/*******************************************************************************
* Copyright (c) 2018 - 2020 Xilinx, Inc.  All rights reserved.
* SPDX-License-Identifier: MIT
*******************************************************************************/


#ifndef __XFPD_SLV_XMPU_H__
#define __XFPD_SLV_XMPU_H__


#ifdef __cplusplus
extern "C" {
#endif

/**
 * XfpdSlvXmpu Base Address
 */
#define XFPD_SLV_XMPU_BASEADDR      0xFD390000UL

/**
 * Register: XfpdSlvXmpuCtrl
 */
#define XFPD_SLV_XMPU_CTRL    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000000UL )
#define XFPD_SLV_XMPU_CTRL_RSTVAL   0x00000013UL

#define XFPD_SLV_XMPU_CTRL_DISDEFSREGION_SHIFT   4UL
#define XFPD_SLV_XMPU_CTRL_DISDEFSREGION_WIDTH   1UL
#define XFPD_SLV_XMPU_CTRL_DISDEFSREGION_MASK    0x00000010UL
#define XFPD_SLV_XMPU_CTRL_DISDEFSREGION_DEFVAL  0x1UL

#define XFPD_SLV_XMPU_CTRL_ALIGNCFG_SHIFT   3UL
#define XFPD_SLV_XMPU_CTRL_ALIGNCFG_WIDTH   1UL
#define XFPD_SLV_XMPU_CTRL_ALIGNCFG_MASK    0x00000008UL
#define XFPD_SLV_XMPU_CTRL_ALIGNCFG_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_CTRL_HIDEALLOWED_SHIFT   2UL
#define XFPD_SLV_XMPU_CTRL_HIDEALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_CTRL_HIDEALLOWED_MASK    0x00000004UL
#define XFPD_SLV_XMPU_CTRL_HIDEALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_CTRL_DEFWRALLOWED_SHIFT   1UL
#define XFPD_SLV_XMPU_CTRL_DEFWRALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_CTRL_DEFWRALLOWED_MASK    0x00000002UL
#define XFPD_SLV_XMPU_CTRL_DEFWRALLOWED_DEFVAL  0x1UL

#define XFPD_SLV_XMPU_CTRL_DEFRDALLOWED_SHIFT   0UL
#define XFPD_SLV_XMPU_CTRL_DEFRDALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_CTRL_DEFRDALLOWED_MASK    0x00000001UL
#define XFPD_SLV_XMPU_CTRL_DEFRDALLOWED_DEFVAL  0x1UL

/**
 * Register: XfpdSlvXmpuErrSts1Lo
 */
#define XFPD_SLV_XMPU_ERR_STS1_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000004UL )
#define XFPD_SLV_XMPU_ERR_STS1_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_ERR_STS1_LO_AXI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_ERR_STS1_LO_AXI_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_ERR_STS1_LO_AXI_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_ERR_STS1_LO_AXI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuErrSts1Hi
 */
#define XFPD_SLV_XMPU_ERR_STS1_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000008UL )
#define XFPD_SLV_XMPU_ERR_STS1_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_ERR_STS1_HI_AXI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_ERR_STS1_HI_AXI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_ERR_STS1_HI_AXI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_ERR_STS1_HI_AXI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuErrSts2
 */
#define XFPD_SLV_XMPU_ERR_STS2    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x0000000CUL )
#define XFPD_SLV_XMPU_ERR_STS2_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_ERR_STS2_AXI_ID_SHIFT   0UL
#define XFPD_SLV_XMPU_ERR_STS2_AXI_ID_WIDTH   10UL
#define XFPD_SLV_XMPU_ERR_STS2_AXI_ID_MASK    0x000003ffUL
#define XFPD_SLV_XMPU_ERR_STS2_AXI_ID_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuIsr
 */
#define XFPD_SLV_XMPU_ISR    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000010UL )
#define XFPD_SLV_XMPU_ISR_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_ISR_SECURITYVIO_SHIFT   3UL
#define XFPD_SLV_XMPU_ISR_SECURITYVIO_WIDTH   1UL
#define XFPD_SLV_XMPU_ISR_SECURITYVIO_MASK    0x00000008UL
#define XFPD_SLV_XMPU_ISR_SECURITYVIO_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_ISR_WRPERMVIO_SHIFT   2UL
#define XFPD_SLV_XMPU_ISR_WRPERMVIO_WIDTH   1UL
#define XFPD_SLV_XMPU_ISR_WRPERMVIO_MASK    0x00000004UL
#define XFPD_SLV_XMPU_ISR_WRPERMVIO_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_ISR_RDPERMVIO_SHIFT   1UL
#define XFPD_SLV_XMPU_ISR_RDPERMVIO_WIDTH   1UL
#define XFPD_SLV_XMPU_ISR_RDPERMVIO_MASK    0x00000002UL
#define XFPD_SLV_XMPU_ISR_RDPERMVIO_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_ISR_INV_APB_SHIFT   0UL
#define XFPD_SLV_XMPU_ISR_INV_APB_WIDTH   1UL
#define XFPD_SLV_XMPU_ISR_INV_APB_MASK    0x00000001UL
#define XFPD_SLV_XMPU_ISR_INV_APB_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuImr
 */
#define XFPD_SLV_XMPU_IMR    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000014UL )
#define XFPD_SLV_XMPU_IMR_RSTVAL   0x0000000fUL

#define XFPD_SLV_XMPU_IMR_SECURITYVIO_SHIFT   3UL
#define XFPD_SLV_XMPU_IMR_SECURITYVIO_WIDTH   1UL
#define XFPD_SLV_XMPU_IMR_SECURITYVIO_MASK    0x00000008UL
#define XFPD_SLV_XMPU_IMR_SECURITYVIO_DEFVAL  0x1UL

#define XFPD_SLV_XMPU_IMR_WRPERMVIO_SHIFT   2UL
#define XFPD_SLV_XMPU_IMR_WRPERMVIO_WIDTH   1UL
#define XFPD_SLV_XMPU_IMR_WRPERMVIO_MASK    0x00000004UL
#define XFPD_SLV_XMPU_IMR_WRPERMVIO_DEFVAL  0x1UL

#define XFPD_SLV_XMPU_IMR_RDPERMVIO_SHIFT   1UL
#define XFPD_SLV_XMPU_IMR_RDPERMVIO_WIDTH   1UL
#define XFPD_SLV_XMPU_IMR_RDPERMVIO_MASK    0x00000002UL
#define XFPD_SLV_XMPU_IMR_RDPERMVIO_DEFVAL  0x1UL

#define XFPD_SLV_XMPU_IMR_INV_APB_SHIFT   0UL
#define XFPD_SLV_XMPU_IMR_INV_APB_WIDTH   1UL
#define XFPD_SLV_XMPU_IMR_INV_APB_MASK    0x00000001UL
#define XFPD_SLV_XMPU_IMR_INV_APB_DEFVAL  0x1UL

/**
 * Register: XfpdSlvXmpuIen
 */
#define XFPD_SLV_XMPU_IEN    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000018UL )
#define XFPD_SLV_XMPU_IEN_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_IEN_SECURITYVIO_SHIFT   3UL
#define XFPD_SLV_XMPU_IEN_SECURITYVIO_WIDTH   1UL
#define XFPD_SLV_XMPU_IEN_SECURITYVIO_MASK    0x00000008UL
#define XFPD_SLV_XMPU_IEN_SECURITYVIO_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_IEN_WRPERMVIO_SHIFT   2UL
#define XFPD_SLV_XMPU_IEN_WRPERMVIO_WIDTH   1UL
#define XFPD_SLV_XMPU_IEN_WRPERMVIO_MASK    0x00000004UL
#define XFPD_SLV_XMPU_IEN_WRPERMVIO_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_IEN_RDPERMVIO_SHIFT   1UL
#define XFPD_SLV_XMPU_IEN_RDPERMVIO_WIDTH   1UL
#define XFPD_SLV_XMPU_IEN_RDPERMVIO_MASK    0x00000002UL
#define XFPD_SLV_XMPU_IEN_RDPERMVIO_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_IEN_INV_APB_SHIFT   0UL
#define XFPD_SLV_XMPU_IEN_INV_APB_WIDTH   1UL
#define XFPD_SLV_XMPU_IEN_INV_APB_MASK    0x00000001UL
#define XFPD_SLV_XMPU_IEN_INV_APB_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuIds
 */
#define XFPD_SLV_XMPU_IDS    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x0000001CUL )
#define XFPD_SLV_XMPU_IDS_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_IDS_SECURITYVIO_SHIFT   3UL
#define XFPD_SLV_XMPU_IDS_SECURITYVIO_WIDTH   1UL
#define XFPD_SLV_XMPU_IDS_SECURITYVIO_MASK    0x00000008UL
#define XFPD_SLV_XMPU_IDS_SECURITYVIO_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_IDS_WRPERMVIO_SHIFT   2UL
#define XFPD_SLV_XMPU_IDS_WRPERMVIO_WIDTH   1UL
#define XFPD_SLV_XMPU_IDS_WRPERMVIO_MASK    0x00000004UL
#define XFPD_SLV_XMPU_IDS_WRPERMVIO_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_IDS_RDPERMVIO_SHIFT   1UL
#define XFPD_SLV_XMPU_IDS_RDPERMVIO_WIDTH   1UL
#define XFPD_SLV_XMPU_IDS_RDPERMVIO_MASK    0x00000002UL
#define XFPD_SLV_XMPU_IDS_RDPERMVIO_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_IDS_INV_APB_SHIFT   0UL
#define XFPD_SLV_XMPU_IDS_INV_APB_WIDTH   1UL
#define XFPD_SLV_XMPU_IDS_INV_APB_MASK    0x00000001UL
#define XFPD_SLV_XMPU_IDS_INV_APB_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuLock
 */
#define XFPD_SLV_XMPU_LOCK    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000020UL )
#define XFPD_SLV_XMPU_LOCK_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_LOCK_REGWRDIS_SHIFT   0UL
#define XFPD_SLV_XMPU_LOCK_REGWRDIS_WIDTH   1UL
#define XFPD_SLV_XMPU_LOCK_REGWRDIS_MASK    0x00000001UL
#define XFPD_SLV_XMPU_LOCK_REGWRDIS_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR00StartLo
 */
#define XFPD_SLV_XMPU_R00_START_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000100UL )
#define XFPD_SLV_XMPU_R00_START_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R00_START_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R00_START_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R00_START_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R00_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR00StartHi
 */
#define XFPD_SLV_XMPU_R00_START_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000104UL )
#define XFPD_SLV_XMPU_R00_START_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R00_START_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R00_START_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R00_START_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R00_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR00EndLo
 */
#define XFPD_SLV_XMPU_R00_END_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000108UL )
#define XFPD_SLV_XMPU_R00_END_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R00_END_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R00_END_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R00_END_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R00_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR00EndHi
 */
#define XFPD_SLV_XMPU_R00_END_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x0000010CUL )
#define XFPD_SLV_XMPU_R00_END_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R00_END_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R00_END_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R00_END_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R00_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR00Master
 */
#define XFPD_SLV_XMPU_R00_MASTER    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000110UL )
#define XFPD_SLV_XMPU_R00_MASTER_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R00_MASTER_MSK_SHIFT   16UL
#define XFPD_SLV_XMPU_R00_MASTER_MSK_WIDTH   10UL
#define XFPD_SLV_XMPU_R00_MASTER_MSK_MASK    0x03ff0000UL
#define XFPD_SLV_XMPU_R00_MASTER_MSK_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R00_MASTER_ID_SHIFT   0UL
#define XFPD_SLV_XMPU_R00_MASTER_ID_WIDTH   10UL
#define XFPD_SLV_XMPU_R00_MASTER_ID_MASK    0x000003ffUL
#define XFPD_SLV_XMPU_R00_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR00Cfg
 */
#define XFPD_SLV_XMPU_R00_CFG    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000114UL )
#define XFPD_SLV_XMPU_R00_CFG_RSTVAL   0x00000008UL

#define XFPD_SLV_XMPU_R00_CFG_NSCHECKTYPE_SHIFT   4UL
#define XFPD_SLV_XMPU_R00_CFG_NSCHECKTYPE_WIDTH   1UL
#define XFPD_SLV_XMPU_R00_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XFPD_SLV_XMPU_R00_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R00_CFG_REGIONNS_SHIFT   3UL
#define XFPD_SLV_XMPU_R00_CFG_REGIONNS_WIDTH   1UL
#define XFPD_SLV_XMPU_R00_CFG_REGIONNS_MASK    0x00000008UL
#define XFPD_SLV_XMPU_R00_CFG_REGIONNS_DEFVAL  0x1UL

#define XFPD_SLV_XMPU_R00_CFG_WRALLOWED_SHIFT   2UL
#define XFPD_SLV_XMPU_R00_CFG_WRALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R00_CFG_WRALLOWED_MASK    0x00000004UL
#define XFPD_SLV_XMPU_R00_CFG_WRALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R00_CFG_RDALLOWED_SHIFT   1UL
#define XFPD_SLV_XMPU_R00_CFG_RDALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R00_CFG_RDALLOWED_MASK    0x00000002UL
#define XFPD_SLV_XMPU_R00_CFG_RDALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R00_CFG_EN_SHIFT   0UL
#define XFPD_SLV_XMPU_R00_CFG_EN_WIDTH   1UL
#define XFPD_SLV_XMPU_R00_CFG_EN_MASK    0x00000001UL
#define XFPD_SLV_XMPU_R00_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR01StartLo
 */
#define XFPD_SLV_XMPU_R01_START_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000118UL )
#define XFPD_SLV_XMPU_R01_START_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R01_START_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R01_START_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R01_START_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R01_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR01StartHi
 */
#define XFPD_SLV_XMPU_R01_START_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x0000011CUL )
#define XFPD_SLV_XMPU_R01_START_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R01_START_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R01_START_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R01_START_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R01_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR01EndLo
 */
#define XFPD_SLV_XMPU_R01_END_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000120UL )
#define XFPD_SLV_XMPU_R01_END_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R01_END_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R01_END_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R01_END_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R01_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR01EndHi
 */
#define XFPD_SLV_XMPU_R01_END_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000124UL )
#define XFPD_SLV_XMPU_R01_END_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R01_END_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R01_END_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R01_END_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R01_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR01Master
 */
#define XFPD_SLV_XMPU_R01_MASTER    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000128UL )
#define XFPD_SLV_XMPU_R01_MASTER_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R01_MASTER_MSK_SHIFT   16UL
#define XFPD_SLV_XMPU_R01_MASTER_MSK_WIDTH   10UL
#define XFPD_SLV_XMPU_R01_MASTER_MSK_MASK    0x03ff0000UL
#define XFPD_SLV_XMPU_R01_MASTER_MSK_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R01_MASTER_ID_SHIFT   0UL
#define XFPD_SLV_XMPU_R01_MASTER_ID_WIDTH   10UL
#define XFPD_SLV_XMPU_R01_MASTER_ID_MASK    0x000003ffUL
#define XFPD_SLV_XMPU_R01_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR01Cfg
 */
#define XFPD_SLV_XMPU_R01_CFG    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x0000012CUL )
#define XFPD_SLV_XMPU_R01_CFG_RSTVAL   0x00000008UL

#define XFPD_SLV_XMPU_R01_CFG_NSCHECKTYPE_SHIFT   4UL
#define XFPD_SLV_XMPU_R01_CFG_NSCHECKTYPE_WIDTH   1UL
#define XFPD_SLV_XMPU_R01_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XFPD_SLV_XMPU_R01_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R01_CFG_REGIONNS_SHIFT   3UL
#define XFPD_SLV_XMPU_R01_CFG_REGIONNS_WIDTH   1UL
#define XFPD_SLV_XMPU_R01_CFG_REGIONNS_MASK    0x00000008UL
#define XFPD_SLV_XMPU_R01_CFG_REGIONNS_DEFVAL  0x1UL

#define XFPD_SLV_XMPU_R01_CFG_WRALLOWED_SHIFT   2UL
#define XFPD_SLV_XMPU_R01_CFG_WRALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R01_CFG_WRALLOWED_MASK    0x00000004UL
#define XFPD_SLV_XMPU_R01_CFG_WRALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R01_CFG_RDALLOWED_SHIFT   1UL
#define XFPD_SLV_XMPU_R01_CFG_RDALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R01_CFG_RDALLOWED_MASK    0x00000002UL
#define XFPD_SLV_XMPU_R01_CFG_RDALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R01_CFG_EN_SHIFT   0UL
#define XFPD_SLV_XMPU_R01_CFG_EN_WIDTH   1UL
#define XFPD_SLV_XMPU_R01_CFG_EN_MASK    0x00000001UL
#define XFPD_SLV_XMPU_R01_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR02StartLo
 */
#define XFPD_SLV_XMPU_R02_START_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000130UL )
#define XFPD_SLV_XMPU_R02_START_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R02_START_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R02_START_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R02_START_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R02_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR02StartHi
 */
#define XFPD_SLV_XMPU_R02_START_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000134UL )
#define XFPD_SLV_XMPU_R02_START_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R02_START_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R02_START_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R02_START_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R02_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR02EndLo
 */
#define XFPD_SLV_XMPU_R02_END_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000138UL )
#define XFPD_SLV_XMPU_R02_END_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R02_END_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R02_END_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R02_END_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R02_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR02EndHi
 */
#define XFPD_SLV_XMPU_R02_END_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x0000013CUL )
#define XFPD_SLV_XMPU_R02_END_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R02_END_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R02_END_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R02_END_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R02_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR02Master
 */
#define XFPD_SLV_XMPU_R02_MASTER    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000140UL )
#define XFPD_SLV_XMPU_R02_MASTER_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R02_MASTER_MSK_SHIFT   16UL
#define XFPD_SLV_XMPU_R02_MASTER_MSK_WIDTH   10UL
#define XFPD_SLV_XMPU_R02_MASTER_MSK_MASK    0x03ff0000UL
#define XFPD_SLV_XMPU_R02_MASTER_MSK_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R02_MASTER_ID_SHIFT   0UL
#define XFPD_SLV_XMPU_R02_MASTER_ID_WIDTH   10UL
#define XFPD_SLV_XMPU_R02_MASTER_ID_MASK    0x000003ffUL
#define XFPD_SLV_XMPU_R02_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR02Cfg
 */
#define XFPD_SLV_XMPU_R02_CFG    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000144UL )
#define XFPD_SLV_XMPU_R02_CFG_RSTVAL   0x00000008UL

#define XFPD_SLV_XMPU_R02_CFG_NSCHECKTYPE_SHIFT   4UL
#define XFPD_SLV_XMPU_R02_CFG_NSCHECKTYPE_WIDTH   1UL
#define XFPD_SLV_XMPU_R02_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XFPD_SLV_XMPU_R02_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R02_CFG_REGIONNS_SHIFT   3UL
#define XFPD_SLV_XMPU_R02_CFG_REGIONNS_WIDTH   1UL
#define XFPD_SLV_XMPU_R02_CFG_REGIONNS_MASK    0x00000008UL
#define XFPD_SLV_XMPU_R02_CFG_REGIONNS_DEFVAL  0x1UL

#define XFPD_SLV_XMPU_R02_CFG_WRALLOWED_SHIFT   2UL
#define XFPD_SLV_XMPU_R02_CFG_WRALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R02_CFG_WRALLOWED_MASK    0x00000004UL
#define XFPD_SLV_XMPU_R02_CFG_WRALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R02_CFG_RDALLOWED_SHIFT   1UL
#define XFPD_SLV_XMPU_R02_CFG_RDALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R02_CFG_RDALLOWED_MASK    0x00000002UL
#define XFPD_SLV_XMPU_R02_CFG_RDALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R02_CFG_EN_SHIFT   0UL
#define XFPD_SLV_XMPU_R02_CFG_EN_WIDTH   1UL
#define XFPD_SLV_XMPU_R02_CFG_EN_MASK    0x00000001UL
#define XFPD_SLV_XMPU_R02_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR03StartLo
 */
#define XFPD_SLV_XMPU_R03_START_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000148UL )
#define XFPD_SLV_XMPU_R03_START_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R03_START_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R03_START_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R03_START_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R03_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR03StartHi
 */
#define XFPD_SLV_XMPU_R03_START_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x0000014CUL )
#define XFPD_SLV_XMPU_R03_START_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R03_START_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R03_START_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R03_START_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R03_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR03EndLo
 */
#define XFPD_SLV_XMPU_R03_END_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000150UL )
#define XFPD_SLV_XMPU_R03_END_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R03_END_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R03_END_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R03_END_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R03_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR03EndHi
 */
#define XFPD_SLV_XMPU_R03_END_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000154UL )
#define XFPD_SLV_XMPU_R03_END_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R03_END_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R03_END_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R03_END_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R03_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR03Master
 */
#define XFPD_SLV_XMPU_R03_MASTER    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000158UL )
#define XFPD_SLV_XMPU_R03_MASTER_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R03_MASTER_MSK_SHIFT   16UL
#define XFPD_SLV_XMPU_R03_MASTER_MSK_WIDTH   10UL
#define XFPD_SLV_XMPU_R03_MASTER_MSK_MASK    0x03ff0000UL
#define XFPD_SLV_XMPU_R03_MASTER_MSK_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R03_MASTER_ID_SHIFT   0UL
#define XFPD_SLV_XMPU_R03_MASTER_ID_WIDTH   10UL
#define XFPD_SLV_XMPU_R03_MASTER_ID_MASK    0x000003ffUL
#define XFPD_SLV_XMPU_R03_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR03Cfg
 */
#define XFPD_SLV_XMPU_R03_CFG    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x0000015CUL )
#define XFPD_SLV_XMPU_R03_CFG_RSTVAL   0x00000008UL

#define XFPD_SLV_XMPU_R03_CFG_NSCHECKTYPE_SHIFT   4UL
#define XFPD_SLV_XMPU_R03_CFG_NSCHECKTYPE_WIDTH   1UL
#define XFPD_SLV_XMPU_R03_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XFPD_SLV_XMPU_R03_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R03_CFG_REGIONNS_SHIFT   3UL
#define XFPD_SLV_XMPU_R03_CFG_REGIONNS_WIDTH   1UL
#define XFPD_SLV_XMPU_R03_CFG_REGIONNS_MASK    0x00000008UL
#define XFPD_SLV_XMPU_R03_CFG_REGIONNS_DEFVAL  0x1UL

#define XFPD_SLV_XMPU_R03_CFG_WRALLOWED_SHIFT   2UL
#define XFPD_SLV_XMPU_R03_CFG_WRALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R03_CFG_WRALLOWED_MASK    0x00000004UL
#define XFPD_SLV_XMPU_R03_CFG_WRALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R03_CFG_RDALLOWED_SHIFT   1UL
#define XFPD_SLV_XMPU_R03_CFG_RDALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R03_CFG_RDALLOWED_MASK    0x00000002UL
#define XFPD_SLV_XMPU_R03_CFG_RDALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R03_CFG_EN_SHIFT   0UL
#define XFPD_SLV_XMPU_R03_CFG_EN_WIDTH   1UL
#define XFPD_SLV_XMPU_R03_CFG_EN_MASK    0x00000001UL
#define XFPD_SLV_XMPU_R03_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR04StartLo
 */
#define XFPD_SLV_XMPU_R04_START_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000160UL )
#define XFPD_SLV_XMPU_R04_START_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R04_START_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R04_START_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R04_START_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R04_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR04StartHi
 */
#define XFPD_SLV_XMPU_R04_START_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000164UL )
#define XFPD_SLV_XMPU_R04_START_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R04_START_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R04_START_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R04_START_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R04_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR04EndLo
 */
#define XFPD_SLV_XMPU_R04_END_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000168UL )
#define XFPD_SLV_XMPU_R04_END_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R04_END_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R04_END_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R04_END_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R04_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR04EndHi
 */
#define XFPD_SLV_XMPU_R04_END_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x0000016CUL )
#define XFPD_SLV_XMPU_R04_END_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R04_END_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R04_END_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R04_END_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R04_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR04Master
 */
#define XFPD_SLV_XMPU_R04_MASTER    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000170UL )
#define XFPD_SLV_XMPU_R04_MASTER_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R04_MASTER_MSK_SHIFT   16UL
#define XFPD_SLV_XMPU_R04_MASTER_MSK_WIDTH   10UL
#define XFPD_SLV_XMPU_R04_MASTER_MSK_MASK    0x03ff0000UL
#define XFPD_SLV_XMPU_R04_MASTER_MSK_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R04_MASTER_ID_SHIFT   0UL
#define XFPD_SLV_XMPU_R04_MASTER_ID_WIDTH   10UL
#define XFPD_SLV_XMPU_R04_MASTER_ID_MASK    0x000003ffUL
#define XFPD_SLV_XMPU_R04_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR04Cfg
 */
#define XFPD_SLV_XMPU_R04_CFG    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000174UL )
#define XFPD_SLV_XMPU_R04_CFG_RSTVAL   0x00000008UL

#define XFPD_SLV_XMPU_R04_CFG_NSCHECKTYPE_SHIFT   4UL
#define XFPD_SLV_XMPU_R04_CFG_NSCHECKTYPE_WIDTH   1UL
#define XFPD_SLV_XMPU_R04_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XFPD_SLV_XMPU_R04_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R04_CFG_REGIONNS_SHIFT   3UL
#define XFPD_SLV_XMPU_R04_CFG_REGIONNS_WIDTH   1UL
#define XFPD_SLV_XMPU_R04_CFG_REGIONNS_MASK    0x00000008UL
#define XFPD_SLV_XMPU_R04_CFG_REGIONNS_DEFVAL  0x1UL

#define XFPD_SLV_XMPU_R04_CFG_WRALLOWED_SHIFT   2UL
#define XFPD_SLV_XMPU_R04_CFG_WRALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R04_CFG_WRALLOWED_MASK    0x00000004UL
#define XFPD_SLV_XMPU_R04_CFG_WRALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R04_CFG_RDALLOWED_SHIFT   1UL
#define XFPD_SLV_XMPU_R04_CFG_RDALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R04_CFG_RDALLOWED_MASK    0x00000002UL
#define XFPD_SLV_XMPU_R04_CFG_RDALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R04_CFG_EN_SHIFT   0UL
#define XFPD_SLV_XMPU_R04_CFG_EN_WIDTH   1UL
#define XFPD_SLV_XMPU_R04_CFG_EN_MASK    0x00000001UL
#define XFPD_SLV_XMPU_R04_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR05StartLo
 */
#define XFPD_SLV_XMPU_R05_START_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000178UL )
#define XFPD_SLV_XMPU_R05_START_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R05_START_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R05_START_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R05_START_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R05_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR05StartHi
 */
#define XFPD_SLV_XMPU_R05_START_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x0000017CUL )
#define XFPD_SLV_XMPU_R05_START_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R05_START_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R05_START_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R05_START_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R05_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR05EndLo
 */
#define XFPD_SLV_XMPU_R05_END_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000180UL )
#define XFPD_SLV_XMPU_R05_END_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R05_END_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R05_END_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R05_END_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R05_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR05EndHi
 */
#define XFPD_SLV_XMPU_R05_END_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000184UL )
#define XFPD_SLV_XMPU_R05_END_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R05_END_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R05_END_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R05_END_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R05_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR05Master
 */
#define XFPD_SLV_XMPU_R05_MASTER    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000188UL )
#define XFPD_SLV_XMPU_R05_MASTER_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R05_MASTER_MSK_SHIFT   16UL
#define XFPD_SLV_XMPU_R05_MASTER_MSK_WIDTH   10UL
#define XFPD_SLV_XMPU_R05_MASTER_MSK_MASK    0x03ff0000UL
#define XFPD_SLV_XMPU_R05_MASTER_MSK_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R05_MASTER_ID_SHIFT   0UL
#define XFPD_SLV_XMPU_R05_MASTER_ID_WIDTH   10UL
#define XFPD_SLV_XMPU_R05_MASTER_ID_MASK    0x000003ffUL
#define XFPD_SLV_XMPU_R05_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR05Cfg
 */
#define XFPD_SLV_XMPU_R05_CFG    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x0000018CUL )
#define XFPD_SLV_XMPU_R05_CFG_RSTVAL   0x00000008UL

#define XFPD_SLV_XMPU_R05_CFG_NSCHECKTYPE_SHIFT   4UL
#define XFPD_SLV_XMPU_R05_CFG_NSCHECKTYPE_WIDTH   1UL
#define XFPD_SLV_XMPU_R05_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XFPD_SLV_XMPU_R05_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R05_CFG_REGIONNS_SHIFT   3UL
#define XFPD_SLV_XMPU_R05_CFG_REGIONNS_WIDTH   1UL
#define XFPD_SLV_XMPU_R05_CFG_REGIONNS_MASK    0x00000008UL
#define XFPD_SLV_XMPU_R05_CFG_REGIONNS_DEFVAL  0x1UL

#define XFPD_SLV_XMPU_R05_CFG_WRALLOWED_SHIFT   2UL
#define XFPD_SLV_XMPU_R05_CFG_WRALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R05_CFG_WRALLOWED_MASK    0x00000004UL
#define XFPD_SLV_XMPU_R05_CFG_WRALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R05_CFG_RDALLOWED_SHIFT   1UL
#define XFPD_SLV_XMPU_R05_CFG_RDALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R05_CFG_RDALLOWED_MASK    0x00000002UL
#define XFPD_SLV_XMPU_R05_CFG_RDALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R05_CFG_EN_SHIFT   0UL
#define XFPD_SLV_XMPU_R05_CFG_EN_WIDTH   1UL
#define XFPD_SLV_XMPU_R05_CFG_EN_MASK    0x00000001UL
#define XFPD_SLV_XMPU_R05_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR06StartLo
 */
#define XFPD_SLV_XMPU_R06_START_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000190UL )
#define XFPD_SLV_XMPU_R06_START_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R06_START_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R06_START_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R06_START_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R06_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR06StartHi
 */
#define XFPD_SLV_XMPU_R06_START_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000194UL )
#define XFPD_SLV_XMPU_R06_START_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R06_START_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R06_START_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R06_START_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R06_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR06EndLo
 */
#define XFPD_SLV_XMPU_R06_END_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000198UL )
#define XFPD_SLV_XMPU_R06_END_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R06_END_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R06_END_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R06_END_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R06_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR06EndHi
 */
#define XFPD_SLV_XMPU_R06_END_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x0000019CUL )
#define XFPD_SLV_XMPU_R06_END_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R06_END_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R06_END_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R06_END_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R06_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR06Master
 */
#define XFPD_SLV_XMPU_R06_MASTER    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001A0UL )
#define XFPD_SLV_XMPU_R06_MASTER_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R06_MASTER_MSK_SHIFT   16UL
#define XFPD_SLV_XMPU_R06_MASTER_MSK_WIDTH   10UL
#define XFPD_SLV_XMPU_R06_MASTER_MSK_MASK    0x03ff0000UL
#define XFPD_SLV_XMPU_R06_MASTER_MSK_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R06_MASTER_ID_SHIFT   0UL
#define XFPD_SLV_XMPU_R06_MASTER_ID_WIDTH   10UL
#define XFPD_SLV_XMPU_R06_MASTER_ID_MASK    0x000003ffUL
#define XFPD_SLV_XMPU_R06_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR06Cfg
 */
#define XFPD_SLV_XMPU_R06_CFG    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001A4UL )
#define XFPD_SLV_XMPU_R06_CFG_RSTVAL   0x00000008UL

#define XFPD_SLV_XMPU_R06_CFG_NSCHECKTYPE_SHIFT   4UL
#define XFPD_SLV_XMPU_R06_CFG_NSCHECKTYPE_WIDTH   1UL
#define XFPD_SLV_XMPU_R06_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XFPD_SLV_XMPU_R06_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R06_CFG_REGIONNS_SHIFT   3UL
#define XFPD_SLV_XMPU_R06_CFG_REGIONNS_WIDTH   1UL
#define XFPD_SLV_XMPU_R06_CFG_REGIONNS_MASK    0x00000008UL
#define XFPD_SLV_XMPU_R06_CFG_REGIONNS_DEFVAL  0x1UL

#define XFPD_SLV_XMPU_R06_CFG_WRALLOWED_SHIFT   2UL
#define XFPD_SLV_XMPU_R06_CFG_WRALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R06_CFG_WRALLOWED_MASK    0x00000004UL
#define XFPD_SLV_XMPU_R06_CFG_WRALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R06_CFG_RDALLOWED_SHIFT   1UL
#define XFPD_SLV_XMPU_R06_CFG_RDALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R06_CFG_RDALLOWED_MASK    0x00000002UL
#define XFPD_SLV_XMPU_R06_CFG_RDALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R06_CFG_EN_SHIFT   0UL
#define XFPD_SLV_XMPU_R06_CFG_EN_WIDTH   1UL
#define XFPD_SLV_XMPU_R06_CFG_EN_MASK    0x00000001UL
#define XFPD_SLV_XMPU_R06_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR07StartLo
 */
#define XFPD_SLV_XMPU_R07_START_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001A8UL )
#define XFPD_SLV_XMPU_R07_START_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R07_START_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R07_START_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R07_START_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R07_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR07StartHi
 */
#define XFPD_SLV_XMPU_R07_START_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001ACUL )
#define XFPD_SLV_XMPU_R07_START_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R07_START_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R07_START_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R07_START_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R07_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR07EndLo
 */
#define XFPD_SLV_XMPU_R07_END_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001B0UL )
#define XFPD_SLV_XMPU_R07_END_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R07_END_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R07_END_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R07_END_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R07_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR07EndHi
 */
#define XFPD_SLV_XMPU_R07_END_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001B4UL )
#define XFPD_SLV_XMPU_R07_END_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R07_END_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R07_END_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R07_END_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R07_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR07Master
 */
#define XFPD_SLV_XMPU_R07_MASTER    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001B8UL )
#define XFPD_SLV_XMPU_R07_MASTER_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R07_MASTER_MSK_SHIFT   16UL
#define XFPD_SLV_XMPU_R07_MASTER_MSK_WIDTH   10UL
#define XFPD_SLV_XMPU_R07_MASTER_MSK_MASK    0x03ff0000UL
#define XFPD_SLV_XMPU_R07_MASTER_MSK_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R07_MASTER_ID_SHIFT   0UL
#define XFPD_SLV_XMPU_R07_MASTER_ID_WIDTH   10UL
#define XFPD_SLV_XMPU_R07_MASTER_ID_MASK    0x000003ffUL
#define XFPD_SLV_XMPU_R07_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR07Cfg
 */
#define XFPD_SLV_XMPU_R07_CFG    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001BCUL )
#define XFPD_SLV_XMPU_R07_CFG_RSTVAL   0x00000008UL

#define XFPD_SLV_XMPU_R07_CFG_NSCHECKTYPE_SHIFT   4UL
#define XFPD_SLV_XMPU_R07_CFG_NSCHECKTYPE_WIDTH   1UL
#define XFPD_SLV_XMPU_R07_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XFPD_SLV_XMPU_R07_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R07_CFG_REGIONNS_SHIFT   3UL
#define XFPD_SLV_XMPU_R07_CFG_REGIONNS_WIDTH   1UL
#define XFPD_SLV_XMPU_R07_CFG_REGIONNS_MASK    0x00000008UL
#define XFPD_SLV_XMPU_R07_CFG_REGIONNS_DEFVAL  0x1UL

#define XFPD_SLV_XMPU_R07_CFG_WRALLOWED_SHIFT   2UL
#define XFPD_SLV_XMPU_R07_CFG_WRALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R07_CFG_WRALLOWED_MASK    0x00000004UL
#define XFPD_SLV_XMPU_R07_CFG_WRALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R07_CFG_RDALLOWED_SHIFT   1UL
#define XFPD_SLV_XMPU_R07_CFG_RDALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R07_CFG_RDALLOWED_MASK    0x00000002UL
#define XFPD_SLV_XMPU_R07_CFG_RDALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R07_CFG_EN_SHIFT   0UL
#define XFPD_SLV_XMPU_R07_CFG_EN_WIDTH   1UL
#define XFPD_SLV_XMPU_R07_CFG_EN_MASK    0x00000001UL
#define XFPD_SLV_XMPU_R07_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR08StartLo
 */
#define XFPD_SLV_XMPU_R08_START_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001C0UL )
#define XFPD_SLV_XMPU_R08_START_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R08_START_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R08_START_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R08_START_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R08_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR08StartHi
 */
#define XFPD_SLV_XMPU_R08_START_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001C4UL )
#define XFPD_SLV_XMPU_R08_START_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R08_START_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R08_START_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R08_START_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R08_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR08EndLo
 */
#define XFPD_SLV_XMPU_R08_END_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001C8UL )
#define XFPD_SLV_XMPU_R08_END_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R08_END_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R08_END_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R08_END_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R08_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR08EndHi
 */
#define XFPD_SLV_XMPU_R08_END_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001CCUL )
#define XFPD_SLV_XMPU_R08_END_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R08_END_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R08_END_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R08_END_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R08_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR08Master
 */
#define XFPD_SLV_XMPU_R08_MASTER    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001D0UL )
#define XFPD_SLV_XMPU_R08_MASTER_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R08_MASTER_MSK_SHIFT   16UL
#define XFPD_SLV_XMPU_R08_MASTER_MSK_WIDTH   10UL
#define XFPD_SLV_XMPU_R08_MASTER_MSK_MASK    0x03ff0000UL
#define XFPD_SLV_XMPU_R08_MASTER_MSK_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R08_MASTER_ID_SHIFT   0UL
#define XFPD_SLV_XMPU_R08_MASTER_ID_WIDTH   10UL
#define XFPD_SLV_XMPU_R08_MASTER_ID_MASK    0x000003ffUL
#define XFPD_SLV_XMPU_R08_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR08Cfg
 */
#define XFPD_SLV_XMPU_R08_CFG    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001D4UL )
#define XFPD_SLV_XMPU_R08_CFG_RSTVAL   0x00000008UL

#define XFPD_SLV_XMPU_R08_CFG_NSCHECKTYPE_SHIFT   4UL
#define XFPD_SLV_XMPU_R08_CFG_NSCHECKTYPE_WIDTH   1UL
#define XFPD_SLV_XMPU_R08_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XFPD_SLV_XMPU_R08_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R08_CFG_REGIONNS_SHIFT   3UL
#define XFPD_SLV_XMPU_R08_CFG_REGIONNS_WIDTH   1UL
#define XFPD_SLV_XMPU_R08_CFG_REGIONNS_MASK    0x00000008UL
#define XFPD_SLV_XMPU_R08_CFG_REGIONNS_DEFVAL  0x1UL

#define XFPD_SLV_XMPU_R08_CFG_WRALLOWED_SHIFT   2UL
#define XFPD_SLV_XMPU_R08_CFG_WRALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R08_CFG_WRALLOWED_MASK    0x00000004UL
#define XFPD_SLV_XMPU_R08_CFG_WRALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R08_CFG_RDALLOWED_SHIFT   1UL
#define XFPD_SLV_XMPU_R08_CFG_RDALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R08_CFG_RDALLOWED_MASK    0x00000002UL
#define XFPD_SLV_XMPU_R08_CFG_RDALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R08_CFG_EN_SHIFT   0UL
#define XFPD_SLV_XMPU_R08_CFG_EN_WIDTH   1UL
#define XFPD_SLV_XMPU_R08_CFG_EN_MASK    0x00000001UL
#define XFPD_SLV_XMPU_R08_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR09StartLo
 */
#define XFPD_SLV_XMPU_R09_START_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001D8UL )
#define XFPD_SLV_XMPU_R09_START_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R09_START_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R09_START_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R09_START_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R09_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR09StartHi
 */
#define XFPD_SLV_XMPU_R09_START_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001DCUL )
#define XFPD_SLV_XMPU_R09_START_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R09_START_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R09_START_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R09_START_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R09_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR09EndLo
 */
#define XFPD_SLV_XMPU_R09_END_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001E0UL )
#define XFPD_SLV_XMPU_R09_END_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R09_END_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R09_END_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R09_END_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R09_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR09EndHi
 */
#define XFPD_SLV_XMPU_R09_END_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001E4UL )
#define XFPD_SLV_XMPU_R09_END_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R09_END_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R09_END_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R09_END_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R09_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR09Master
 */
#define XFPD_SLV_XMPU_R09_MASTER    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001E8UL )
#define XFPD_SLV_XMPU_R09_MASTER_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R09_MASTER_MSK_SHIFT   16UL
#define XFPD_SLV_XMPU_R09_MASTER_MSK_WIDTH   10UL
#define XFPD_SLV_XMPU_R09_MASTER_MSK_MASK    0x03ff0000UL
#define XFPD_SLV_XMPU_R09_MASTER_MSK_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R09_MASTER_ID_SHIFT   0UL
#define XFPD_SLV_XMPU_R09_MASTER_ID_WIDTH   10UL
#define XFPD_SLV_XMPU_R09_MASTER_ID_MASK    0x000003ffUL
#define XFPD_SLV_XMPU_R09_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR09Cfg
 */
#define XFPD_SLV_XMPU_R09_CFG    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001ECUL )
#define XFPD_SLV_XMPU_R09_CFG_RSTVAL   0x00000008UL

#define XFPD_SLV_XMPU_R09_CFG_NSCHECKTYPE_SHIFT   4UL
#define XFPD_SLV_XMPU_R09_CFG_NSCHECKTYPE_WIDTH   1UL
#define XFPD_SLV_XMPU_R09_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XFPD_SLV_XMPU_R09_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R09_CFG_REGIONNS_SHIFT   3UL
#define XFPD_SLV_XMPU_R09_CFG_REGIONNS_WIDTH   1UL
#define XFPD_SLV_XMPU_R09_CFG_REGIONNS_MASK    0x00000008UL
#define XFPD_SLV_XMPU_R09_CFG_REGIONNS_DEFVAL  0x1UL

#define XFPD_SLV_XMPU_R09_CFG_WRALLOWED_SHIFT   2UL
#define XFPD_SLV_XMPU_R09_CFG_WRALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R09_CFG_WRALLOWED_MASK    0x00000004UL
#define XFPD_SLV_XMPU_R09_CFG_WRALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R09_CFG_RDALLOWED_SHIFT   1UL
#define XFPD_SLV_XMPU_R09_CFG_RDALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R09_CFG_RDALLOWED_MASK    0x00000002UL
#define XFPD_SLV_XMPU_R09_CFG_RDALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R09_CFG_EN_SHIFT   0UL
#define XFPD_SLV_XMPU_R09_CFG_EN_WIDTH   1UL
#define XFPD_SLV_XMPU_R09_CFG_EN_MASK    0x00000001UL
#define XFPD_SLV_XMPU_R09_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR10StartLo
 */
#define XFPD_SLV_XMPU_R10_START_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001F0UL )
#define XFPD_SLV_XMPU_R10_START_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R10_START_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R10_START_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R10_START_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R10_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR10StartHi
 */
#define XFPD_SLV_XMPU_R10_START_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001F4UL )
#define XFPD_SLV_XMPU_R10_START_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R10_START_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R10_START_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R10_START_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R10_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR10EndLo
 */
#define XFPD_SLV_XMPU_R10_END_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001F8UL )
#define XFPD_SLV_XMPU_R10_END_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R10_END_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R10_END_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R10_END_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R10_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR10EndHi
 */
#define XFPD_SLV_XMPU_R10_END_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x000001FCUL )
#define XFPD_SLV_XMPU_R10_END_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R10_END_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R10_END_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R10_END_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R10_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR10Master
 */
#define XFPD_SLV_XMPU_R10_MASTER    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000200UL )
#define XFPD_SLV_XMPU_R10_MASTER_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R10_MASTER_MSK_SHIFT   16UL
#define XFPD_SLV_XMPU_R10_MASTER_MSK_WIDTH   10UL
#define XFPD_SLV_XMPU_R10_MASTER_MSK_MASK    0x03ff0000UL
#define XFPD_SLV_XMPU_R10_MASTER_MSK_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R10_MASTER_ID_SHIFT   0UL
#define XFPD_SLV_XMPU_R10_MASTER_ID_WIDTH   10UL
#define XFPD_SLV_XMPU_R10_MASTER_ID_MASK    0x000003ffUL
#define XFPD_SLV_XMPU_R10_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR10Cfg
 */
#define XFPD_SLV_XMPU_R10_CFG    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000204UL )
#define XFPD_SLV_XMPU_R10_CFG_RSTVAL   0x00000008UL

#define XFPD_SLV_XMPU_R10_CFG_NSCHECKTYPE_SHIFT   4UL
#define XFPD_SLV_XMPU_R10_CFG_NSCHECKTYPE_WIDTH   1UL
#define XFPD_SLV_XMPU_R10_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XFPD_SLV_XMPU_R10_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R10_CFG_REGIONNS_SHIFT   3UL
#define XFPD_SLV_XMPU_R10_CFG_REGIONNS_WIDTH   1UL
#define XFPD_SLV_XMPU_R10_CFG_REGIONNS_MASK    0x00000008UL
#define XFPD_SLV_XMPU_R10_CFG_REGIONNS_DEFVAL  0x1UL

#define XFPD_SLV_XMPU_R10_CFG_WRALLOWED_SHIFT   2UL
#define XFPD_SLV_XMPU_R10_CFG_WRALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R10_CFG_WRALLOWED_MASK    0x00000004UL
#define XFPD_SLV_XMPU_R10_CFG_WRALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R10_CFG_RDALLOWED_SHIFT   1UL
#define XFPD_SLV_XMPU_R10_CFG_RDALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R10_CFG_RDALLOWED_MASK    0x00000002UL
#define XFPD_SLV_XMPU_R10_CFG_RDALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R10_CFG_EN_SHIFT   0UL
#define XFPD_SLV_XMPU_R10_CFG_EN_WIDTH   1UL
#define XFPD_SLV_XMPU_R10_CFG_EN_MASK    0x00000001UL
#define XFPD_SLV_XMPU_R10_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR11StartLo
 */
#define XFPD_SLV_XMPU_R11_START_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000208UL )
#define XFPD_SLV_XMPU_R11_START_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R11_START_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R11_START_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R11_START_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R11_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR11StartHi
 */
#define XFPD_SLV_XMPU_R11_START_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x0000020CUL )
#define XFPD_SLV_XMPU_R11_START_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R11_START_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R11_START_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R11_START_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R11_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR11EndLo
 */
#define XFPD_SLV_XMPU_R11_END_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000210UL )
#define XFPD_SLV_XMPU_R11_END_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R11_END_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R11_END_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R11_END_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R11_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR11EndHi
 */
#define XFPD_SLV_XMPU_R11_END_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000214UL )
#define XFPD_SLV_XMPU_R11_END_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R11_END_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R11_END_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R11_END_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R11_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR11Master
 */
#define XFPD_SLV_XMPU_R11_MASTER    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000218UL )
#define XFPD_SLV_XMPU_R11_MASTER_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R11_MASTER_MSK_SHIFT   16UL
#define XFPD_SLV_XMPU_R11_MASTER_MSK_WIDTH   10UL
#define XFPD_SLV_XMPU_R11_MASTER_MSK_MASK    0x03ff0000UL
#define XFPD_SLV_XMPU_R11_MASTER_MSK_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R11_MASTER_ID_SHIFT   0UL
#define XFPD_SLV_XMPU_R11_MASTER_ID_WIDTH   10UL
#define XFPD_SLV_XMPU_R11_MASTER_ID_MASK    0x000003ffUL
#define XFPD_SLV_XMPU_R11_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR11Cfg
 */
#define XFPD_SLV_XMPU_R11_CFG    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x0000021CUL )
#define XFPD_SLV_XMPU_R11_CFG_RSTVAL   0x00000008UL

#define XFPD_SLV_XMPU_R11_CFG_NSCHECKTYPE_SHIFT   4UL
#define XFPD_SLV_XMPU_R11_CFG_NSCHECKTYPE_WIDTH   1UL
#define XFPD_SLV_XMPU_R11_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XFPD_SLV_XMPU_R11_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R11_CFG_REGIONNS_SHIFT   3UL
#define XFPD_SLV_XMPU_R11_CFG_REGIONNS_WIDTH   1UL
#define XFPD_SLV_XMPU_R11_CFG_REGIONNS_MASK    0x00000008UL
#define XFPD_SLV_XMPU_R11_CFG_REGIONNS_DEFVAL  0x1UL

#define XFPD_SLV_XMPU_R11_CFG_WRALLOWED_SHIFT   2UL
#define XFPD_SLV_XMPU_R11_CFG_WRALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R11_CFG_WRALLOWED_MASK    0x00000004UL
#define XFPD_SLV_XMPU_R11_CFG_WRALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R11_CFG_RDALLOWED_SHIFT   1UL
#define XFPD_SLV_XMPU_R11_CFG_RDALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R11_CFG_RDALLOWED_MASK    0x00000002UL
#define XFPD_SLV_XMPU_R11_CFG_RDALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R11_CFG_EN_SHIFT   0UL
#define XFPD_SLV_XMPU_R11_CFG_EN_WIDTH   1UL
#define XFPD_SLV_XMPU_R11_CFG_EN_MASK    0x00000001UL
#define XFPD_SLV_XMPU_R11_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR12StartLo
 */
#define XFPD_SLV_XMPU_R12_START_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000220UL )
#define XFPD_SLV_XMPU_R12_START_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R12_START_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R12_START_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R12_START_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R12_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR12StartHi
 */
#define XFPD_SLV_XMPU_R12_START_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000224UL )
#define XFPD_SLV_XMPU_R12_START_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R12_START_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R12_START_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R12_START_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R12_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR12EndLo
 */
#define XFPD_SLV_XMPU_R12_END_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000228UL )
#define XFPD_SLV_XMPU_R12_END_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R12_END_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R12_END_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R12_END_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R12_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR12EndHi
 */
#define XFPD_SLV_XMPU_R12_END_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x0000022CUL )
#define XFPD_SLV_XMPU_R12_END_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R12_END_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R12_END_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R12_END_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R12_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR12Master
 */
#define XFPD_SLV_XMPU_R12_MASTER    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000238UL )
#define XFPD_SLV_XMPU_R12_MASTER_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R12_MASTER_MSK_SHIFT   16UL
#define XFPD_SLV_XMPU_R12_MASTER_MSK_WIDTH   10UL
#define XFPD_SLV_XMPU_R12_MASTER_MSK_MASK    0x03ff0000UL
#define XFPD_SLV_XMPU_R12_MASTER_MSK_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R12_MASTER_ID_SHIFT   0UL
#define XFPD_SLV_XMPU_R12_MASTER_ID_WIDTH   10UL
#define XFPD_SLV_XMPU_R12_MASTER_ID_MASK    0x000003ffUL
#define XFPD_SLV_XMPU_R12_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR12Cfg
 */
#define XFPD_SLV_XMPU_R12_CFG    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x0000023CUL )
#define XFPD_SLV_XMPU_R12_CFG_RSTVAL   0x00000008UL

#define XFPD_SLV_XMPU_R12_CFG_NSCHECKTYPE_SHIFT   4UL
#define XFPD_SLV_XMPU_R12_CFG_NSCHECKTYPE_WIDTH   1UL
#define XFPD_SLV_XMPU_R12_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XFPD_SLV_XMPU_R12_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R12_CFG_REGIONNS_SHIFT   3UL
#define XFPD_SLV_XMPU_R12_CFG_REGIONNS_WIDTH   1UL
#define XFPD_SLV_XMPU_R12_CFG_REGIONNS_MASK    0x00000008UL
#define XFPD_SLV_XMPU_R12_CFG_REGIONNS_DEFVAL  0x1UL

#define XFPD_SLV_XMPU_R12_CFG_WRALLOWED_SHIFT   2UL
#define XFPD_SLV_XMPU_R12_CFG_WRALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R12_CFG_WRALLOWED_MASK    0x00000004UL
#define XFPD_SLV_XMPU_R12_CFG_WRALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R12_CFG_RDALLOWED_SHIFT   1UL
#define XFPD_SLV_XMPU_R12_CFG_RDALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R12_CFG_RDALLOWED_MASK    0x00000002UL
#define XFPD_SLV_XMPU_R12_CFG_RDALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R12_CFG_EN_SHIFT   0UL
#define XFPD_SLV_XMPU_R12_CFG_EN_WIDTH   1UL
#define XFPD_SLV_XMPU_R12_CFG_EN_MASK    0x00000001UL
#define XFPD_SLV_XMPU_R12_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR13StartLo
 */
#define XFPD_SLV_XMPU_R13_START_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000240UL )
#define XFPD_SLV_XMPU_R13_START_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R13_START_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R13_START_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R13_START_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R13_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR13StartHi
 */
#define XFPD_SLV_XMPU_R13_START_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000244UL )
#define XFPD_SLV_XMPU_R13_START_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R13_START_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R13_START_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R13_START_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R13_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR13EndLo
 */
#define XFPD_SLV_XMPU_R13_END_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000248UL )
#define XFPD_SLV_XMPU_R13_END_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R13_END_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R13_END_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R13_END_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R13_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR13EndHi
 */
#define XFPD_SLV_XMPU_R13_END_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x0000024CUL )
#define XFPD_SLV_XMPU_R13_END_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R13_END_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R13_END_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R13_END_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R13_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR13Master
 */
#define XFPD_SLV_XMPU_R13_MASTER    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000250UL )
#define XFPD_SLV_XMPU_R13_MASTER_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R13_MASTER_MSK_SHIFT   16UL
#define XFPD_SLV_XMPU_R13_MASTER_MSK_WIDTH   10UL
#define XFPD_SLV_XMPU_R13_MASTER_MSK_MASK    0x03ff0000UL
#define XFPD_SLV_XMPU_R13_MASTER_MSK_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R13_MASTER_ID_SHIFT   0UL
#define XFPD_SLV_XMPU_R13_MASTER_ID_WIDTH   10UL
#define XFPD_SLV_XMPU_R13_MASTER_ID_MASK    0x000003ffUL
#define XFPD_SLV_XMPU_R13_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR13Cfg
 */
#define XFPD_SLV_XMPU_R13_CFG    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000254UL )
#define XFPD_SLV_XMPU_R13_CFG_RSTVAL   0x00000008UL

#define XFPD_SLV_XMPU_R13_CFG_NSCHECKTYPE_SHIFT   4UL
#define XFPD_SLV_XMPU_R13_CFG_NSCHECKTYPE_WIDTH   1UL
#define XFPD_SLV_XMPU_R13_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XFPD_SLV_XMPU_R13_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R13_CFG_REGIONNS_SHIFT   3UL
#define XFPD_SLV_XMPU_R13_CFG_REGIONNS_WIDTH   1UL
#define XFPD_SLV_XMPU_R13_CFG_REGIONNS_MASK    0x00000008UL
#define XFPD_SLV_XMPU_R13_CFG_REGIONNS_DEFVAL  0x1UL

#define XFPD_SLV_XMPU_R13_CFG_WRALLOWED_SHIFT   2UL
#define XFPD_SLV_XMPU_R13_CFG_WRALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R13_CFG_WRALLOWED_MASK    0x00000004UL
#define XFPD_SLV_XMPU_R13_CFG_WRALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R13_CFG_RDALLOWED_SHIFT   1UL
#define XFPD_SLV_XMPU_R13_CFG_RDALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R13_CFG_RDALLOWED_MASK    0x00000002UL
#define XFPD_SLV_XMPU_R13_CFG_RDALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R13_CFG_EN_SHIFT   0UL
#define XFPD_SLV_XMPU_R13_CFG_EN_WIDTH   1UL
#define XFPD_SLV_XMPU_R13_CFG_EN_MASK    0x00000001UL
#define XFPD_SLV_XMPU_R13_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR14StartLo
 */
#define XFPD_SLV_XMPU_R14_START_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000258UL )
#define XFPD_SLV_XMPU_R14_START_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R14_START_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R14_START_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R14_START_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R14_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR14StartHi
 */
#define XFPD_SLV_XMPU_R14_START_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x0000025CUL )
#define XFPD_SLV_XMPU_R14_START_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R14_START_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R14_START_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R14_START_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R14_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR14EndLo
 */
#define XFPD_SLV_XMPU_R14_END_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000260UL )
#define XFPD_SLV_XMPU_R14_END_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R14_END_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R14_END_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R14_END_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R14_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR14EndHi
 */
#define XFPD_SLV_XMPU_R14_END_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000264UL )
#define XFPD_SLV_XMPU_R14_END_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R14_END_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R14_END_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R14_END_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R14_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR14Master
 */
#define XFPD_SLV_XMPU_R14_MASTER    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000268UL )
#define XFPD_SLV_XMPU_R14_MASTER_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R14_MASTER_MSK_SHIFT   16UL
#define XFPD_SLV_XMPU_R14_MASTER_MSK_WIDTH   10UL
#define XFPD_SLV_XMPU_R14_MASTER_MSK_MASK    0x03ff0000UL
#define XFPD_SLV_XMPU_R14_MASTER_MSK_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R14_MASTER_ID_SHIFT   0UL
#define XFPD_SLV_XMPU_R14_MASTER_ID_WIDTH   10UL
#define XFPD_SLV_XMPU_R14_MASTER_ID_MASK    0x000003ffUL
#define XFPD_SLV_XMPU_R14_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR14Cfg
 */
#define XFPD_SLV_XMPU_R14_CFG    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x0000026CUL )
#define XFPD_SLV_XMPU_R14_CFG_RSTVAL   0x00000008UL

#define XFPD_SLV_XMPU_R14_CFG_NSCHECKTYPE_SHIFT   4UL
#define XFPD_SLV_XMPU_R14_CFG_NSCHECKTYPE_WIDTH   1UL
#define XFPD_SLV_XMPU_R14_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XFPD_SLV_XMPU_R14_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R14_CFG_REGIONNS_SHIFT   3UL
#define XFPD_SLV_XMPU_R14_CFG_REGIONNS_WIDTH   1UL
#define XFPD_SLV_XMPU_R14_CFG_REGIONNS_MASK    0x00000008UL
#define XFPD_SLV_XMPU_R14_CFG_REGIONNS_DEFVAL  0x1UL

#define XFPD_SLV_XMPU_R14_CFG_WRALLOWED_SHIFT   2UL
#define XFPD_SLV_XMPU_R14_CFG_WRALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R14_CFG_WRALLOWED_MASK    0x00000004UL
#define XFPD_SLV_XMPU_R14_CFG_WRALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R14_CFG_RDALLOWED_SHIFT   1UL
#define XFPD_SLV_XMPU_R14_CFG_RDALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R14_CFG_RDALLOWED_MASK    0x00000002UL
#define XFPD_SLV_XMPU_R14_CFG_RDALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R14_CFG_EN_SHIFT   0UL
#define XFPD_SLV_XMPU_R14_CFG_EN_WIDTH   1UL
#define XFPD_SLV_XMPU_R14_CFG_EN_MASK    0x00000001UL
#define XFPD_SLV_XMPU_R14_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR15StartLo
 */
#define XFPD_SLV_XMPU_R15_START_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000270UL )
#define XFPD_SLV_XMPU_R15_START_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R15_START_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R15_START_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R15_START_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R15_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR15StartHi
 */
#define XFPD_SLV_XMPU_R15_START_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000274UL )
#define XFPD_SLV_XMPU_R15_START_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R15_START_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R15_START_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R15_START_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R15_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR15EndLo
 */
#define XFPD_SLV_XMPU_R15_END_LO    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000278UL )
#define XFPD_SLV_XMPU_R15_END_LO_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R15_END_LO_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R15_END_LO_ADDR_WIDTH   32UL
#define XFPD_SLV_XMPU_R15_END_LO_ADDR_MASK    0xffffffffUL
#define XFPD_SLV_XMPU_R15_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR15EndHi
 */
#define XFPD_SLV_XMPU_R15_END_HI    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x0000027CUL )
#define XFPD_SLV_XMPU_R15_END_HI_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R15_END_HI_ADDR_SHIFT   0UL
#define XFPD_SLV_XMPU_R15_END_HI_ADDR_WIDTH   12UL
#define XFPD_SLV_XMPU_R15_END_HI_ADDR_MASK    0x00000fffUL
#define XFPD_SLV_XMPU_R15_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR15Master
 */
#define XFPD_SLV_XMPU_R15_MASTER    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000280UL )
#define XFPD_SLV_XMPU_R15_MASTER_RSTVAL   0x00000000UL

#define XFPD_SLV_XMPU_R15_MASTER_MSK_SHIFT   16UL
#define XFPD_SLV_XMPU_R15_MASTER_MSK_WIDTH   10UL
#define XFPD_SLV_XMPU_R15_MASTER_MSK_MASK    0x03ff0000UL
#define XFPD_SLV_XMPU_R15_MASTER_MSK_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R15_MASTER_ID_SHIFT   0UL
#define XFPD_SLV_XMPU_R15_MASTER_ID_WIDTH   10UL
#define XFPD_SLV_XMPU_R15_MASTER_ID_MASK    0x000003ffUL
#define XFPD_SLV_XMPU_R15_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XfpdSlvXmpuR15Cfg
 */
#define XFPD_SLV_XMPU_R15_CFG    ( ( XFPD_SLV_XMPU_BASEADDR ) + 0x00000284UL )
#define XFPD_SLV_XMPU_R15_CFG_RSTVAL   0x00000008UL

#define XFPD_SLV_XMPU_R15_CFG_NSCHECKTYPE_SHIFT   4UL
#define XFPD_SLV_XMPU_R15_CFG_NSCHECKTYPE_WIDTH   1UL
#define XFPD_SLV_XMPU_R15_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XFPD_SLV_XMPU_R15_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R15_CFG_REGIONNS_SHIFT   3UL
#define XFPD_SLV_XMPU_R15_CFG_REGIONNS_WIDTH   1UL
#define XFPD_SLV_XMPU_R15_CFG_REGIONNS_MASK    0x00000008UL
#define XFPD_SLV_XMPU_R15_CFG_REGIONNS_DEFVAL  0x1UL

#define XFPD_SLV_XMPU_R15_CFG_WRALLOWED_SHIFT   2UL
#define XFPD_SLV_XMPU_R15_CFG_WRALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R15_CFG_WRALLOWED_MASK    0x00000004UL
#define XFPD_SLV_XMPU_R15_CFG_WRALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R15_CFG_RDALLOWED_SHIFT   1UL
#define XFPD_SLV_XMPU_R15_CFG_RDALLOWED_WIDTH   1UL
#define XFPD_SLV_XMPU_R15_CFG_RDALLOWED_MASK    0x00000002UL
#define XFPD_SLV_XMPU_R15_CFG_RDALLOWED_DEFVAL  0x0UL

#define XFPD_SLV_XMPU_R15_CFG_EN_SHIFT   0UL
#define XFPD_SLV_XMPU_R15_CFG_EN_WIDTH   1UL
#define XFPD_SLV_XMPU_R15_CFG_EN_MASK    0x00000001UL
#define XFPD_SLV_XMPU_R15_CFG_EN_DEFVAL  0x0UL


#ifdef __cplusplus
}
#endif

#endif /* __XFPD_SLV_XMPU_H__ */
