<!-- This Source Code Form is subject to the terms of the Mozilla Public
   - License, v. 2.0. If a copy of the MPL was not distributed with this
   - file, You can obtain one at http://mozilla.org/MPL/2.0/. -->


This document describes the structure of the HTML generated by the renderapi.py
tool, both for use in the API docs shown by "cfx docs" and as exported by
"cfx sdocs". The particular HTML id and class attributes embedded in the files,
as well as their organization, represent the interface between the tool and any
front-end code wanting to style the docs in some particular way.

renderapi generates two sorts of files:

- a file called "<module-name>.div": this is the contents of the parsed
Markdown file rendered inside a well-defined DIV tag

- a file called "<module-name>.html": this is the DIV from above inserted into
a simple HTML template that references a sample CSS file which styles the
contents of the DIV. This CSS file is the same as the one used by the SDK
itself.

DIV tags
--------
The following class and id attributes are used in the DIV:

renderapi uses a number of class attributes and a single id attribute in the DIV:

id attribute    <module_name>"_module_api_docs"
class attribute "api_reference"
class attribute "module_api_docs"
class attribute "api_header"
class attribute "api_name"
class attribute "api_component_group"
class attribute "api_component"
class attribute "datatype"
class attribute "returns"
class attribute "parameter_set"
class attribute "module_description"

DIV structure
-------------
The top level DIV is marked with the id attribute and the "module_api_docs" class
attribute:

      <div id='tabs_module_api_docs' class='module_api_docs'>
        //module doc contents
      </div>


Inside this:

- the first item is an <h1> heading containing the name of the module:

- all "markdown" hunks (that is, all descriptive text not occurring
inside <api></api> tags) are rendered inside a DIV marked with the
"module-description" class attribute

- all <api></api> content is rendered, enclosed in a single tag marked
with the "api_reference" class attribute:

    <div id='tabs_module_api_docs' class='module_api_docs'>
      <div class='module_description'>
        //descriptions
      </div>
        <div class='api_reference'>
        //api reference
      </div>
    </div>

If there is no <api></api> content, then the "api-reference" section is absent.

### API Reference structure ###

The first item in API reference is an <h2> heading title marked with the
"api_header" attribute. This might have the text content "API Reference"
(but you should not rely on that):

      <div class='api_reference'>

        <h2 class='api_header'>API Reference</h2>

        //api contents

      </div>

After the title come one or more component groups.

#### Component Group ####

A component group is marked with the "api_component_group" attribute. The
component group is a collection of some sort of component: for example, a group
of classes, a group of functions, or a group of events.

Each component group starts off with a header marked with the
"api_header" attribute and is followed by one or more sections marked with the
"api_component" attribute.
At the top level (that is, when they are directly under the "API Reference"
heading), the "api_header" items are <h3> headings, otherwise they are divs.

    <div class='api_reference'>

      <h2 class='api_header'>API Reference</h2>

      <div class='api_component_group'>

        <h3 class='api_header'>Classes</h3>

        <div class='api_component'>
          // the first class
        </div>

        <div class='api_component'>
          // another class
        </div>

      </div>

      <div class='api_component_group'>
        //some different components

        <h3 class='api_header'>Functions</h3>

        <div class='api_component'>
          the first function
        </div>

        <div class='api_component'>
          another function
        </div>

      </div>

    </div>

#### Component ####

API components represent actual objects in the API like classes, functions,
properties and events.

Each component starts with a section marked with the
"api_name" tag, which includes the name of the component in the API: for
example "postMessage(message)".

Components at the top level (i.e., directly under h3 headings) are <h4>
headings, otherwise they are divs.

After the name, the component's contents are listed. Different sorts of
components may have different sorts of contents: for example, a function might
have parameters. If the component is composite then it may contain its own
component group. For example, a class may contain methods and properties,
which might be grouped together.

    <div class='api_component'>

      <h4 class='api_name'>Panel</h4>

      <div class='api_component_group'>

        <div class='api_header'>
          Methods
        </div>

        <div class='api_component'>
          show()
        </div>

      </div>

    </div>

Other attributes
-----------------------------

### Datatype ###
All primitive data types, like "string" and "number", are marked with the
"datatype" class attribute:

    <div class="api_component">

    <div class="api_name">
      label : <span class="datatype">string</span>
    </div>

    <p>A required string description of the widget used for accessibility,
    title bars, and error reporting.</p>

    </div>

### Returns ###

Functions mark return values with the "returns" class attribute.

    <div class="api_component">

      <div class="api_name">
        get()
      </div>

      Make a `GET` request.

      <div class="returns">
        Returns: <span class="datatype">Request</span>
      </div>

    </div>

### Parameter_set ###

Functions that take parameters mark them with the parameter_set class
attribute.
