/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.image;

import java.nio.ByteBuffer;
import org.web3d.image.NIOBufferImageType;

public class NIOBufferImage {
    private static final String INVALID_WIDTH_PARAMETER = "image width must be a positive integer";
    private static final String INVALID_HEIGHT_PARAMETER = "image height must be a positive integer";
    private static final String TYPE_IS_NULL = "image type must be non-null";
    private static final String BUFFER_IS_NULL = "image buffer must be non-null";
    private static final String BUFFER_INSUFFICIENT = "image buffer must be sufficiently sized to contain image";
    private int width;
    private int height;
    private NIOBufferImageType type;
    private ByteBuffer[] buffer;
    private boolean isGrayScale;

    public NIOBufferImage(int n, int n2, NIOBufferImageType nIOBufferImageType) {
        this(n, n2, nIOBufferImageType, nIOBufferImageType == NIOBufferImageType.INTENSITY | nIOBufferImageType == NIOBufferImageType.INTENSITY_ALPHA, ByteBuffer.allocateDirect(n * n2 * nIOBufferImageType.size));
    }

    public NIOBufferImage(int n, int n2, NIOBufferImageType nIOBufferImageType, ByteBuffer byteBuffer) {
        this(n, n2, nIOBufferImageType, nIOBufferImageType == NIOBufferImageType.INTENSITY | nIOBufferImageType == NIOBufferImageType.INTENSITY_ALPHA, byteBuffer);
    }

    public NIOBufferImage(int n, int n2, NIOBufferImageType nIOBufferImageType, boolean bl, ByteBuffer byteBuffer) {
        if (n < 1) {
            throw new IllegalArgumentException(INVALID_WIDTH_PARAMETER);
        }
        if (n2 < 1) {
            throw new IllegalArgumentException(INVALID_HEIGHT_PARAMETER);
        }
        if (nIOBufferImageType == null) {
            throw new NullPointerException(TYPE_IS_NULL);
        }
        if (byteBuffer == null) {
            throw new NullPointerException(BUFFER_IS_NULL);
        }
        if (byteBuffer.limit() != n * n2 * nIOBufferImageType.size) {
            throw new IllegalArgumentException(BUFFER_INSUFFICIENT);
        }
        this.width = n;
        this.height = n2;
        this.type = nIOBufferImageType;
        this.isGrayScale = bl;
        this.buffer = new ByteBuffer[]{byteBuffer};
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public NIOBufferImageType getType() {
        return this.type;
    }

    public boolean isGrayScale() {
        return this.isGrayScale;
    }

    public int getLevels() {
        return this.buffer.length;
    }

    public ByteBuffer getBuffer() {
        this.buffer[0].rewind();
        return this.buffer[0];
    }

    public ByteBuffer[] getBuffer(ByteBuffer[] byteBufferArray) {
        int n = this.buffer.length;
        if (byteBufferArray == null || byteBufferArray.length < n) {
            byteBufferArray = new ByteBuffer[n];
        }
        for (int i = 0; i < n; ++i) {
            this.buffer[i].rewind();
            byteBufferArray[i] = this.buffer[i];
        }
        return byteBufferArray;
    }

    public void setBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            throw new NullPointerException(BUFFER_IS_NULL);
        }
        if (byteBuffer.limit() != this.width * this.height * this.type.size) {
            throw new IllegalArgumentException(BUFFER_INSUFFICIENT);
        }
        this.buffer = new ByteBuffer[]{byteBuffer};
    }

    public void setBuffer(ByteBuffer[] byteBufferArray) {
        if (byteBufferArray == null) {
            throw new NullPointerException(BUFFER_IS_NULL);
        }
        if (byteBufferArray[0].limit() != this.width * this.height * this.type.size) {
            throw new IllegalArgumentException(BUFFER_INSUFFICIENT);
        }
        int n = byteBufferArray.length;
        this.buffer = new ByteBuffer[n];
        for (int i = 0; i < n; ++i) {
            this.buffer[i] = byteBufferArray[i];
        }
    }

    public String toString() {
        return "NIOBufferImage: type = " + this.type.name + ", width = " + this.width + ", height = " + this.height;
    }
}

