-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

--  Manage the cross-references.

--# inherit CommandLineData,
--#         ContextManager,
--#         ContextManager.Ops,
--#         Dictionary,
--#         ExaminerConstants,
--#         E_Strings,
--#         FileSystem,
--#         LexTokenLists,
--#         LexTokenManager,
--#         SLI.IO,
--#         SPARK_IO,
--#         SystemErrors;

private package SLI.Xref
--# own State;
--# initializes State;
is

   --  Increment by 1 the number of separates found in the
   --  compilation unit (Comp_Unit).
   procedure Increment_Nb_Separates (Comp_Unit : in ContextManager.UnitDescriptors);
   --# global in out State;
   --# derives State from *,
   --#                    Comp_Unit;

   --  Add a cross-reference for the symbol (Sym). This symbol is
   --  declared in the compilation unit (Decl_Comp_Unit). The
   --  symbol is used in the compilation unit (Usage_Comp_Unit) at
   --  position (Pos). The type of reference is Ref_Type.
   procedure Add_Usage
     (Decl_Comp_Unit  : in ContextManager.UnitDescriptors;
      Sym             : in Dictionary.Symbol;
      Usage_Comp_Unit : in ContextManager.UnitDescriptors;
      Pos             : in LexTokenManager.Token_Position;
      Ref_Type        : in Character);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                CommandLineData.Content,
   --#                                Decl_Comp_Unit,
   --#                                Dictionary.Dict,
   --#                                LexTokenManager.State,
   --#                                State,
   --#                                Sym,
   --#                                Usage_Comp_Unit &
   --#         State             from *,
   --#                                Decl_Comp_Unit,
   --#                                Dictionary.Dict,
   --#                                Pos,
   --#                                Ref_Type,
   --#                                Sym,
   --#                                Usage_Comp_Unit;

   --  Cleanup all the cross-references tables.
   procedure Cleanup_Decl_Comp_Unit;
   --# global in out State;
   --# derives State from *;

   --  Write all the cross-references for the compilation unit
   --  (Comp_Unit) and the closure in the SLI file.
   procedure Dump (Comp_Unit : in ContextManager.UnitDescriptors);
   --# global in     CommandLineData.Content;
   --#        in     ContextManager.Ops.File_Heap;
   --#        in     ContextManager.Ops.Unit_Heap;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out State;
   --#           out IO.Stream_Buffer;
   --# derives IO.Stream_Buffer  from Comp_Unit,
   --#                                ContextManager.Ops.File_Heap,
   --#                                ContextManager.Ops.Unit_Heap,
   --#                                Dictionary.Dict,
   --#                                LexTokenManager.State,
   --#                                State &
   --#         SPARK_IO.File_Sys from *,
   --#                                CommandLineData.Content,
   --#                                Comp_Unit,
   --#                                ContextManager.Ops.Unit_Heap,
   --#                                Dictionary.Dict,
   --#                                LexTokenManager.State,
   --#                                State &
   --#         State             from *,
   --#                                Comp_Unit,
   --#                                ContextManager.Ops.Unit_Heap,
   --#                                Dictionary.Dict,
   --#                                LexTokenManager.State;

end SLI.Xref;
