/*
 * (C) Copyright 2002-2003, Schlund+Partner AG
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/**
 * @file XSLTrans.hpp
 * @version @$Id: XSLTrans.hpp,v 1.11 2003/01/30 12:38:31 spabsurd Exp $
 * @author Schlund + Partner AG
 * @brief *ps*
 *
 * (C) Copyright by Schlund+Partner AG
 *
 * Synopsis: @#include <sp-gxmlcpp/XSLTrans.hpp>
 *
 */

#ifndef SP_GXML_XSLTRANS_HPP
#define SP_GXML_XSLTRANS_HPP

// STDC++
#include <string>

// C++ Libraries
#include <sp-gxmlcpp/XMLDump.hpp>
#include <sp-gxmlcpp/XMLTree.hpp>

// C libraries
#include <libxml/xpath.h>
#include <libxml/tree.h>
#include <libxslt/xsltInternals.h>

namespace SP {
namespace GXML {

class XSLTrans
{
public:
	enum Exceptions
	{
		PARSE_ERR=1,  // Stylesheet not parsed (not well formed XML)
		STYLE_ERR,    // Not a valid stylesheet
		TRANS_ERR     // Transforming error
	};

	XSLTrans(const char * xmlBuffer, int size=-1, const std::string & baseURI="");
	XSLTrans(const std::string & xmlString, const std::string & baseURI="");
	XSLTrans(std::ifstream & f, const std::string & baseURI="");

	~XSLTrans();

	xsltStylesheetPtr getStylesheetPtr();

	// Trans into XMLTree
	std::auto_ptr<XMLTree> transToXMLTree(const xmlDocPtr doc) const;

	std::auto_ptr<XMLDump> trans(const xmlDocPtr doc) const;
	std::auto_ptr<XMLDump> trans(const XMLTree * xmlTree) const;
	std::auto_ptr<XMLDump> trans(const std::string & xmlString) const;

private:
	xmlDocPtr doc_;
	xsltStylesheetPtr style_;

	void genTrans(const char * xmlBuffer, int size=-1, const std::string & baseURI="");

	static char * defaultEncoding_;
};

}}
#endif
