#ifndef SimTK_SIMBODY_SIMBODY_H_
#define SimTK_SIMBODY_SIMBODY_H_

/* -------------------------------------------------------------------------- *
 *                                 Simbody(tm)                                *
 * -------------------------------------------------------------------------- *
 * This is part of the SimTK biosimulation toolkit originating from           *
 * Simbios, the NIH National Center for Physics-Based Simulation of           *
 * Biological Structures at Stanford, funded under the NIH Roadmap for        *
 * Medical Research, grant U54 GM072970. See https://simtk.org/home/simbody.  *
 *                                                                            *
 * Please cite:                                                               *
 *   Michael A. Sherman, Ajay Seth, Scott L. Delp, Simbody: multibody         *
 *   dynamics for biomedical research, Procedia IUTAM 2:241-261 (2011)        *
 *   http://dx.doi.org/10.1016/j.piutam.2011.04.023.                          *
 *                                                                            *
 * Portions copyright (c) 2005-12 Stanford University and the Authors.        *
 * Authors: Michael Sherman, Peter Eastman                                    *
 * Contributors: Jack Middleton, Christopher Bruns, Paul Mitiguy, Matthew     *
 *   Millard, Charles Schwieters, Abhinandan Jain, Isaac Newton               *
 *                                                                            *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may    *
 * not use this file except in compliance with the License. You may obtain a  *
 * copy of the License at http://www.apache.org/licenses/LICENSE-2.0.         *
 *                                                                            *
 * Unless required by applicable law or agreed to in writing, software        *
 * distributed under the License is distributed on an "AS IS" BASIS,          *
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.   *
 * See the License for the specific language governing permissions and        *
 * limitations under the License.                                             *
 * -------------------------------------------------------------------------- */

/** @file
This is the header file that user code should include to pick up all Simbody 
capabilities.\ Note that all symbols defined here will be in the SimTK 
namespace, or (where a namespace can't be used) prefixed by "SimTK_". **/

#include "SimTKcommon.h"
#include "SimTKmath.h"
#include "SimTKsimbody.h"

#endif // SimTK_SIMBODY_SIMBODY_H_
