///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __OVITO_BOOLEAN_GROUP_BOX_CONTROLLER_UI_H
#define __OVITO_BOOLEAN_GROUP_BOX_CONTROLLER_UI_H

#include <core/Core.h>
#include "ParameterUI.h"

namespace Core {

/******************************************************************************
* Allows the user to edit a boolean parameter.
* The check box is displayed in the title bar of a QGroupBox.
******************************************************************************/
class CORE_DLLEXPORT BooleanGroupBoxControllerUI : public ReferenceParameterUI
{
public:

	/// Constructor.
	BooleanGroupBoxControllerUI(PropertiesEditor* parentEditor, const PropertyFieldDescriptor& refField);
	/// Destructor, that releases all GUI controls.
	virtual ~BooleanGroupBoxControllerUI();
    
	/// This returns the group box managed by this parameter UI.
	QGroupBox* groupBox() const { return _groupBox; }

	/// This method is called when parameter object has been assigned to the reference field of the editable object 
	/// this parameter UI is bound to. It is also called when the editable object itself has
	/// been replaced in the editor. This implementation of the method automatically
	/// disables the UI widgets when the reference field of the edited object does not contain a
	/// controller.
	virtual void resetUI();
	
	/// This method updates the displayed value of the parameter UI.
	virtual void updateUI();	

	/// Sets the enabled state of the UI.
	virtual void setEnabled(bool enabled);

	/// Sets the tooltip text for the check box.
	void setToolTip(const QString& text) const { if(groupBox()) groupBox()->setToolTip(text); }

	/// Sets the What's This helper text for the check box.
	void setWhatsThis(const QString& text) const { if(groupBox()) groupBox()->setWhatsThis(text); }
	
public:
	
	Q_PROPERTY(QGroupBox groupBox READ groupBox)			
	
public Q_SLOTS:
	
	/// Takes the value entered by the user and stores it in the parameter object
	/// this parameter UI is bound to. This method must be implemented by derived classes.
	void updateParameterValue();

protected:

	/// The QGroupBox control of the UI component.
	QPointer<QGroupBox> _groupBox;

private:

	Q_OBJECT
	DECLARE_ABSTRACT_PLUGIN_CLASS(BooleanGroupBoxControllerUI)
};

};

#endif // __OVITO_BOOLEAN_GROUP_BOX_CONTROLLER_UI_H
