
MACRO(OVITO_ADD_PLUGIN_DEPENDENCY target_name plugin_name)

	STRING(TOUPPER "${plugin_name}" uppercase_plugin_name)
	IF(NOT OVITO_BUILD_PLUGIN_${uppercase_plugin_name})
		STRING(TOUPPER "${plugin_name}" uppercase_plugin_name)
		MESSAGE(FATAL_ERROR "To build the ${target_name} plugin, the ${plugin_name} plugin has to be enabled too. Please set the OVITO_BUILD_PLUGIN_${uppercase_plugin_name} option to ON.")
	ENDIF()

	TARGET_LINK_LIBRARIES(${target_name} ${plugin_name})

	IF(${plugin_name} STREQUAL "Scripting")
		TARGET_LINK_LIBRARIES(${target_name} ${Boost_PYTHON_LIBRARY} ${PYTHON_UTIL_LIBRARY} ${PYTHON_LIBRARIES})
	ENDIF()

ENDMACRO(OVITO_ADD_PLUGIN_DEPENDENCY)

# Create a new target for a plugin.
MACRO(OVITO_PLUGIN target_name)

	SET(plugin_sources)
	SET(lib_dependencies)
	SET(resource_output)
	SET(resource_input)
	SET(plugin_dependencies)
	SET(optional_plugin_dependencies)
	SET(pch_header)
	FOREACH(currentArg ${ARGN})
		IF("${currentArg}" STREQUAL "SOURCES" OR 
			"${currentArg}" STREQUAL "LIB_DEPENDENCIES" OR 
			"${currentArg}" STREQUAL "PLUGIN_DEPENDENCIES" OR 
			"${currentArg}" STREQUAL "OPTIONAL_PLUGIN_DEPENDENCIES" OR
			"${currentArg}" STREQUAL "PCH" OR  
			"${currentArg}" STREQUAL "RESOURCE")
			SET(DOING_WHAT "${currentArg}")
		ELSEIF("${currentArg}" STREQUAL "THIRDPARTY")
			SET(DOING_WHAT "${currentArg}")
			SET(IS_THIRD_PARTY_PLUGIN TRUE)
		ELSE()
		    IF(${DOING_WHAT} STREQUAL "SOURCES")
				LIST(APPEND plugin_sources "${currentArg}")
		    ELSEIF(${DOING_WHAT} STREQUAL "LIB_DEPENDENCIES")
				LIST(APPEND lib_dependencies "${currentArg}")
		    ELSEIF(${DOING_WHAT} STREQUAL "PLUGIN_DEPENDENCIES")
				LIST(APPEND plugin_dependencies "${currentArg}")
		    ELSEIF(${DOING_WHAT} STREQUAL "OPTIONAL_PLUGIN_DEPENDENCIES")
				LIST(APPEND optional_plugin_dependencies "${currentArg}")
		    ELSEIF(${DOING_WHAT} STREQUAL "PCH")
				SET(pch_header "${currentArg}")
		    ELSEIF(${DOING_WHAT} STREQUAL "RESOURCE")
				SET(resource_output "${currentArg}")
				SET(DOING_WHAT "RESOURCE_INPUT")
		    ELSEIF(${DOING_WHAT} STREQUAL "RESOURCE_INPUT")
				LIST(APPEND resource_input "${currentArg}")
		    ENDIF()
		ENDIF()
	ENDFOREACH(currentArg)

	# Enable precompiled headers when using the GCC compiler.
	IF(pch_header AND OVITO_USE_PRECOMPILED_HEADERS AND CMAKE_COMPILER_IS_GNUCXX)
		INCLUDE_DIRECTORIES(${CMAKE_CURRENT_BINARY_DIR})
	ENDIF()

	# This is needed to export the symbols in this shared library.
	STRING(TOUPPER "${target_name}" uppercase_target_name)
	SET(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -DMAKING_MODULE_${uppercase_target_name}")

	# Create the library target for the plugin.
	ADD_LIBRARY(${target_name} ${plugin_sources})

	# Link mandatory OVITO libraries.
	TARGET_LINK_LIBRARIES(${target_name} Base Core)

	# Link required OVITO libraries.
	TARGET_LINK_LIBRARIES(${target_name} ${lib_dependencies})

	# Link the Qt libraries. 
	TARGET_LINK_LIBRARIES(${target_name} ${QT_LIBRARIES})

	# Link the OpenGL library.
	TARGET_LINK_LIBRARIES(${target_name} ${OPENGL_glu_LIBRARY})

	# Link Boost libraries.
	TARGET_LINK_LIBRARIES(${target_name} ${Boost_LIBRARIES})

	# On Mac OS, we must explicitely link the Boost zlib library.
	IF(APPLE)
		FIND_LIBRARY(BOOST_ZLIB_LIBRARY NAMES "boost_zlib" PATHS ${Boost_LIBRARY_DIRS})	
		TARGET_LINK_LIBRARIES(${target_name} ${BOOST_ZLIB_LIBRARY})
	ENDIF(APPLE)

	# Link plugin dependencies.
	FOREACH(plugin_name ${plugin_dependencies})
		OVITO_ADD_PLUGIN_DEPENDENCY(${target_name} ${plugin_name})
	ENDFOREACH(plugin_name)

	# Link optional plugin dependencies.
	FOREACH(plugin_name ${optional_plugin_dependencies})
		STRING(TOUPPER "${plugin_name}" uppercase_plugin_name)
		IF(OVITO_BUILD_PLUGIN_${uppercase_plugin_name})
			OVITO_ADD_PLUGIN_DEPENDENCY(${target_name} ${plugin_name})
		ENDIF()
	ENDFOREACH(plugin_name)

	# Generate precompiled header
	IF(pch_header AND OVITO_USE_PRECOMPILED_HEADERS AND CMAKE_COMPILER_IS_GNUCXX)
		ADD_PRECOMPILED_HEADER(${target_name} ${pch_header})
	ENDIF()

	# Assign an absolute install path to this dynamic link library.
	IF(APPLE)
		SET_TARGET_PROPERTIES(${target_name} PROPERTIES INSTALL_NAME_DIR "${CMAKE_INSTALL_PREFIX}/${OVITO_RELATIVE_PLUGINS_DIRECTORY}")
	ENDIF(APPLE)
	
	# Copy Plugin manifest to destination directory.
	CONFIGURE_FILE("${CMAKE_CURRENT_SOURCE_DIR}/resources/${target_name}.manifest.xml"
               "${OVITO_PLUGINS_DIRECTORY}/${target_name}.manifest.xml")

	IF(NOT IS_THIRD_PARTY_PLUGIN)

		# This plugin will be part of the installation package.
		IF(NOT OVITO_MONOLITHIC_BUILD)
			INSTALL(TARGETS ${target_name} DESTINATION "${OVITO_RELATIVE_PLUGINS_DIRECTORY}")
		ENDIF(NOT OVITO_MONOLITHIC_BUILD)
		INSTALL(FILES "${OVITO_PLUGINS_DIRECTORY}/${target_name}.manifest.xml" DESTINATION "${OVITO_RELATIVE_PLUGINS_DIRECTORY}")
	
		# Build optional resource file for this plugin which is not linked into the shared library.
		IF(resource_output)
			QT4_COMPILE_RESOURCES(${target_name} "${OVITO_PLUGINS_DIRECTORY}/${resource_output}" ${resource_input})
			# The resource file will be part of the installation package.
			INSTALL(FILES "${OVITO_PLUGINS_DIRECTORY}/${resource_output}" DESTINATION "${OVITO_RELATIVE_PLUGINS_DIRECTORY}")
		ENDIF()
		
	ELSE(NOT IS_THIRD_PARTY_PLUGIN)

		# Install plugin to OVITO's plugin directory.
		IF(OVITO_MONOLITHIC_BUILD)
			MESSAGE(FATAL_ERROR "Cannot install plugin when Ovito has been built as a static executable.")
		ENDIF(OVITO_MONOLITHIC_BUILD)
		INSTALL(TARGETS ${target_name} DESTINATION "${OVITO_PLUGINS_DIRECTORY}")
	
		# Build optional resource file for this plugin which is not linked into the shared library.
		IF(resource_output)
			QT4_COMPILE_RESOURCES(${target_name} "${OVITO_PLUGINS_DIRECTORY}/${resource_output}" ${resource_input})
		ENDIF()
	
	ENDIF(NOT IS_THIRD_PARTY_PLUGIN)

ENDMACRO(OVITO_PLUGIN)

