<!--

@license Apache-2.0

Copyright (c) 2018 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# Constants

> Array constants.

<section class="usage">

## Usage

```javascript
var constants = require( '@stdlib/constants/array' );
```

#### constants

Array constants.

```javascript
var ns = constants;
// returns {...}
```

<!-- <toc pattern="*"> -->

<div class="namespace-toc">

-   <span class="signature">[`MAX_ARRAY_LENGTH`][@stdlib/constants/array/max-array-length]</span><span class="delimiter">: </span><span class="description">maximum length for a generic array.</span>
-   <span class="signature">[`MAX_TYPED_ARRAY_LENGTH`][@stdlib/constants/array/max-typed-array-length]</span><span class="delimiter">: </span><span class="description">maximum length for a typed array.</span>

</div>

<!-- </toc> -->

</section>

<!-- /.usage -->

<section class="examples">

## Examples

<!-- TODO: better examples -->

<!-- eslint no-undef: "error" -->

```javascript
var objectKeys = require( '@stdlib/utils/keys' );
var constants = require( '@stdlib/constants/array' );

console.log( objectKeys( constants ) );
```

</section>

<!-- /.examples -->

<section class="links">

<!-- <toc-links> -->

[@stdlib/constants/array/max-array-length]: https://github.com/stdlib-js/constants/tree/main/array/max-array-length

[@stdlib/constants/array/max-typed-array-length]: https://github.com/stdlib-js/constants/tree/main/array/max-typed-array-length

<!-- </toc-links> -->

</section>

<!-- /.links -->
