.\" Automatically generated from an mdoc input file.  Do not edit.
.\" zip_file_get_external_attributes.mdoc -- get external attributes for file in zip
.\" Copyright (C) 2013-2017 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP files.
.\" The authors can be contacted at <info@libzip.org>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH "ZIP_FILE_GET_EXTERNAL_ATTRIBUTES" "3" "December 18, 2017" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_file_get_external_attributes\fR
\- get external attributes for file in zip
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIint\fR
.br
.PD 0
.HP 4n
\fBzip_file_get_external_attributes\fR(\fIzip_t\ *archive\fR, \fIzip_uint64_t\ index\fR, \fIzip_flags_t\ flags\fR, \fIzip_uint8_t\ *opsys\fR, \fIzip_uint32_t\ *attributes\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_file_get_external_attributes\fR()
function returns the operating system and external attributes for the
file at position
\fIindex\fR
in the zip archive.
The external attributes usually contain the operating system-specific
file permissions.
If
\fIflags\fR
is set to
\fRZIP_FL_UNCHANGED\fR,
the original unchanged values are returned.
If
\fIopsys\fR
or
\fIattributes\fR
are
\fRNULL\fR,
they are not filled in.
.PP
The following operating systems are defined by the zip specification:
.RS 6n
.PD 0
.PP
\fRZIP_OPSYS_ACORN_RISC\fR
.PP
\fRZIP_OPSYS_ALTERNATE_MVS\fR
.PP
\fRZIP_OPSYS_AMIGA\fR
.PP
\fRZIP_OPSYS_ATARI_ST\fR
.PP
\fRZIP_OPSYS_BEOS\fR
.PP
\fRZIP_OPSYS_CPM\fR
.PP
\fRZIP_OPSYS_DOS\fR
.PP
\fRZIP_OPSYS_MACINTOSH\fR
.PP
\fRZIP_OPSYS_MVS\fR
.PP
\fRZIP_OPSYS_OPENVMS\fR
.PP
\fRZIP_OPSYS_OS_2\fR
.PP
\fRZIP_OPSYS_OS_400\fR
.PP
\fRZIP_OPSYS_OS_X\fR
.PP
\fRZIP_OPSYS_TANDEM\fR
.PP
\fRZIP_OPSYS_UNIX\fR
.PP
\fRZIP_OPSYS_VFAT\fR
.PP
\fRZIP_OPSYS_VM_CMS\fR
.PP
\fRZIP_OPSYS_VSE\fR
.PP
\fRZIP_OPSYS_WINDOWS_NTFS\fR
(uncommon, use
\fRZIP_OPSYS_DOS\fR
instead)
.PP
\fRZIP_OPSYS_Z_SYSTEM\fR
.RE
.PD
.PP
The defines above follow the PKWARE Inc. Appnote; please note that
the InfoZIP Appnote has a slightly different mapping.
.SH "RETURN VALUES"
Upon successful completion, 0 is returned.
In case of an error,
\fR\-1\fR
is returned and the error code in
\fIarchive\fR
is set to indicate the error.
.SH "EXAMPLES"
The following code can be used to expand
\fIattributes\fR
if the operating system is
\fRZIP_OPSYS_DOS\fR.
.nf
.sp
.RS 0n
#include <sys/stat.h>

#define FA_RDONLY       0x01            // FILE_ATTRIBUTE_READONLY
#define FA_DIREC        0x10            // FILE_ATTRIBUTE_DIRECTORY

static mode_t
_zip_dos_attr2mode(zip_uint32_t attr)
{
   mode_t m = S_IRUSR | S_IRGRP | S_IROTH;
   if (0 == (attr & FA_RDONLY))
      m |= S_IWUSR | S_IWGRP | S_IWOTH;

   if (attr & FA_DIREC)
      m = (S_IFDIR | (m & ~S_IFMT)) | S_IXUSR | S_IXGRP | S_IXOTH;

   return m;
}
.RE
.fi
.SH "ERRORS"
\fBzip_file_get_external_attributes\fR()
fails if:
.TP 19n
[\fRZIP_ER_INVAL\fR]
\fIindex\fR
is not a valid file index in
\fIarchive\fR.
.SH "SEE ALSO"
libzip(3),
zip_file_set_external_attributes(3)
.SH "HISTORY"
\fBzip_file_get_external_attributes\fR()
was added in libzip 0.11.2.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fIwiz@gatalith.at\fR>
