/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBufferImpl;
import java.nio.HeapFloatBuffer;

public abstract class FloatBuffer
extends Buffer
implements Comparable {
    ByteBufferImpl parent;
    float[] array;
    boolean disposed = false;

    FloatBuffer() {
    }

    public static FloatBuffer wrap(float[] fArray, int n, int n2) {
        if (n < 0 || n > fArray.length || n2 < 0 || n2 > fArray.length - n) {
            throw new IndexOutOfBoundsException();
        }
        HeapFloatBuffer heapFloatBuffer = new HeapFloatBuffer(fArray.length, fArray, 0);
        heapFloatBuffer.position(n);
        heapFloatBuffer.limit(n + n2);
        return heapFloatBuffer;
    }

    public static FloatBuffer wrap(float[] fArray) {
        return FloatBuffer.wrap(fArray, 0, fArray.length);
    }

    public abstract FloatBuffer slice();

    public abstract float get();

    public abstract FloatBuffer put(float var1);

    public abstract float get(int var1);

    public abstract FloatBuffer put(int var1, float var2);

    public FloatBuffer get(float[] fArray, int n, int n2) {
        FloatBuffer.checkBounds(n, n2, fArray.length);
        if (n2 > this.remaining()) {
            throw new BufferUnderflowException();
        }
        this.copyToArray(fArray, n, n2);
        this.position += n2;
        return this;
    }

    abstract void copyToArray(float[] var1, int var2, int var3);

    public FloatBuffer get(float[] fArray) {
        return this.get(fArray, 0, fArray.length);
    }

    public FloatBuffer put(FloatBuffer floatBuffer) {
        if (floatBuffer == this) {
            throw new IllegalArgumentException();
        }
        int n = floatBuffer.limit - floatBuffer.position;
        if (n > this.limit - this.position) {
            throw new BufferOverflowException();
        }
        floatBuffer.copyToFloatBuffer(n, this);
        floatBuffer.position += n;
        this.position += n;
        return this;
    }

    abstract void copyToFloatBuffer(int var1, FloatBuffer var2);

    abstract void copyFromHeapFloatBuffer(FloatBuffer var1, int var2);

    abstract void copyFromByteBufferAsFloatBuffer(FloatBuffer var1, int var2);

    abstract void copyFromDirectFloatBuffer(FloatBuffer var1, int var2);

    static void vanillaCopy(FloatBuffer floatBuffer, FloatBuffer floatBuffer2, int n) {
        for (int i = 0; i < n; ++i) {
            floatBuffer2.put(floatBuffer2.position + i, floatBuffer.get(floatBuffer.position + i));
        }
    }

    public FloatBuffer put(float[] fArray, int n, int n2) {
        FloatBuffer.checkBounds(n, n2, fArray.length);
        if (n2 > this.remaining()) {
            throw new BufferOverflowException();
        }
        this.copyFromArray(fArray, n, n2);
        this.position += n2;
        return this;
    }

    abstract void copyFromArray(float[] var1, int var2, int var3);

    public final FloatBuffer put(float[] fArray) {
        return this.put(fArray, 0, fArray.length);
    }

    public final boolean hasArray() {
        return this.array != null;
    }

    public final float[] array() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.array;
    }

    public final int arrayOffset() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.arrayOffset;
    }

    public abstract boolean isDirect();

    public String toString() {
        return "java.nio.FloatBuffer[pos=" + this.position() + "lim=" + this.limit() + "cap=" + this.capacity() + "]";
    }

    public int hashCode() {
        int n = 1;
        int n2 = this.position();
        for (int i = this.limit() - 1; i >= n2; --i) {
            n = 31 * n + (int)this.get(i);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FloatBuffer)) {
            return false;
        }
        FloatBuffer floatBuffer = (FloatBuffer)object;
        if (this.remaining() != floatBuffer.remaining()) {
            return false;
        }
        int n = this.position();
        int n2 = this.limit() - 1;
        int n3 = floatBuffer.limit() - 1;
        while (n2 >= n) {
            float f;
            float f2 = this.get(n2);
            if (f2 != (f = floatBuffer.get(n3)) && (f2 == f2 || f == f)) {
                return false;
            }
            --n2;
            --n3;
        }
        return true;
    }

    public int compareTo(Object object) {
        FloatBuffer floatBuffer = (FloatBuffer)object;
        int n = this.position() + Math.min(this.remaining(), floatBuffer.remaining());
        int n2 = this.position();
        int n3 = floatBuffer.position();
        while (n2 < n) {
            float f;
            float f2 = this.get(n2);
            if (f2 != (f = floatBuffer.get(n3)) && (f2 == f2 || f == f)) {
                if (f2 < f) {
                    return -1;
                }
                return 1;
            }
            ++n2;
            ++n3;
        }
        return this.remaining() - floatBuffer.remaining();
    }
}

