/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.instrumentor;

import alt.jiapi.Rule;
import alt.jiapi.Runtime;
import alt.jiapi.instrumentor.Instrumentation;
import alt.jiapi.instrumentor.Strategy;
import org.apache.log4j.Category;

public abstract class AbstractStrategy
implements Strategy {
    private Instrumentation instrumentation;
    private static Category log = Runtime.getLogCategory(AbstractStrategy.class);
    protected String[] resolutions;
    private boolean reverseMatch;
    private Rule[] rules;

    protected AbstractStrategy() {
    }

    protected AbstractStrategy(String resolution) {
        this(new String[]{resolution}, false);
    }

    protected AbstractStrategy(String[] resolutions) {
        this(resolutions, false);
    }

    protected AbstractStrategy(String[] resolutions, boolean reverseMatch) {
        this.reverseMatch = reverseMatch;
        this.setResolutions(resolutions);
    }

    public void setResolutions(String[] resolutions) {
        this.resolutions = resolutions;
        this.reverseMatch = false;
        this.createRules(resolutions);
    }

    public String[] getResolutions() {
        return this.resolutions;
    }

    protected boolean match(String name) {
        if (name == null || this.rules == null) {
            return false;
        }
        boolean b = false;
        for (int i = 0; i < this.rules.length; ++i) {
            if (!this.rules[i].match(name)) continue;
            b = true;
            break;
        }
        return b ^= this.reverseMatch;
    }

    void setInstrumentation(Instrumentation i) {
        this.instrumentation = i;
    }

    protected Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    private void createRules(String[] resolutions) {
        if (resolutions == null) {
            return;
        }
        this.rules = new Rule[resolutions.length];
        for (int i = 0; i < resolutions.length; ++i) {
            try {
                this.rules[i] = new Rule(resolutions[i]);
                continue;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
            }
        }
    }
}

