; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -simplifycfg -simplifycfg-require-and-preserve-domtree=1 -opaque-pointers -S < %s | FileCheck %s

declare void @unknown_fun()

define void @different_type(ptr %ptr, i1 %cmp) {
; CHECK-LABEL: @different_type(
; CHECK-NEXT:    store i32 0, ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    br i1 [[CMP:%.*]], label [[IF_THEN:%.*]], label [[RET_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    store i64 1, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[RET_END]]
; CHECK:       ret.end:
; CHECK-NEXT:    ret void
;
  store i32 0, ptr %ptr
  br i1 %cmp, label %if.then, label %ret.end

if.then:
  store i64 1, ptr %ptr
  br label %ret.end

ret.end:
  ret void
}

define void @readonly_call(ptr %ptr, i1 %cmp) {
; CHECK-LABEL: @readonly_call(
; CHECK-NEXT:  ret.end:
; CHECK-NEXT:    store i32 0, ptr [[PTR:%.*]], align 4
; CHECK-NEXT:    call void @unknown_fun() #[[ATTR0:[0-9]+]]
; CHECK-NEXT:    [[SPEC_STORE_SELECT:%.*]] = select i1 [[CMP:%.*]], i32 1, i32 0
; CHECK-NEXT:    store i32 [[SPEC_STORE_SELECT]], ptr [[PTR]], align 4
; CHECK-NEXT:    ret void
;
  store i32 0, ptr %ptr
  call void @unknown_fun() readonly
  br i1 %cmp, label %if.then, label %ret.end

if.then:
  store i32 1, ptr %ptr
  br label %ret.end

ret.end:
  ret void
}

define void @atomic_and_simple(ptr %ptr, i1 %cmp) {
; CHECK-LABEL: @atomic_and_simple(
; CHECK-NEXT:    store atomic i32 0, ptr [[PTR:%.*]] seq_cst, align 4
; CHECK-NEXT:    br i1 [[CMP:%.*]], label [[IF_THEN:%.*]], label [[RET_END:%.*]]
; CHECK:       if.then:
; CHECK-NEXT:    store i32 1, ptr [[PTR]], align 4
; CHECK-NEXT:    br label [[RET_END]]
; CHECK:       ret.end:
; CHECK-NEXT:    ret void
;
  store atomic i32 0, ptr %ptr seq_cst, align 4
  br i1 %cmp, label %if.then, label %ret.end

if.then:
  store i32 1, ptr %ptr
  br label %ret.end

ret.end:
  ret void
}
