; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -partially-inline-libcalls -mtriple=x86_64-unknown-linux-gnu < %s | FileCheck %s
; RUN: opt -S -passes=partially-inline-libcalls -mtriple=x86_64-unknown-linux-gnu < %s | FileCheck %s

define float @f(float %val) {
; CHECK-LABEL: @f(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[RES:%.*]] = tail call float @sqrtf(float [[VAL:%.*]]) #[[READNONE:.*]]
; CHECK-NEXT:    [[TMP0:%.*]] = fcmp oge float [[VAL]], 0.000000e+00
; CHECK-NEXT:    br i1 [[TMP0]], label [[ENTRY_SPLIT:%.*]], label [[CALL_SQRT:%.*]]
; CHECK:       call.sqrt:
; CHECK-NEXT:    [[TMP1:%.*]] = tail call float @sqrtf(float [[VAL]])
; CHECK-NEXT:    br label [[ENTRY_SPLIT]]
; CHECK:       entry.split:
; CHECK-NEXT:    [[TMP2:%.*]] = phi float [ [[RES]], [[ENTRY:%.*]] ], [ [[TMP1]], [[CALL_SQRT]] ]
; CHECK-NEXT:    ret float [[TMP2]]
;
entry:
  %res = tail call float @sqrtf(float %val)
  ret float %res
}

define float @f_writeonly(float %val) {
; CHECK-LABEL: @f_writeonly(
; CHECK-NEXt:    [[RES:%.*]] = tail call float @sqrtf(float [[VAL:%.*]]) #[[READNONE]]
  %res = tail call float @sqrtf(float %val) writeonly
  ret float %res
}

define float @f_readonly(float %val) {
  %res = tail call float @sqrtf(float %val) readonly
  ret float %res
}

declare float @sqrtf(float)
