/*****************************************************************************
 * Copyright (C) 2006-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "enterxauthinteractivepasscodedialog.h"

#include <QtGui/QDialog>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>

#include <klocale.h>
#include <kmessagebox.h>

EnterXauthInteractivePasscodeDialog::EnterXauthInteractivePasscodeDialog(QWidget *parent, bool allowEmptyPassword) : KDialog(parent)
{
    QWidget *page = new QWidget(this);
	main = new Ui_EnterXauthInteractivePasscodeDialogBase;
    main->setupUi(page);
	setMainWidget(page);
    Password = "";
	this->allowEmptyPassword = allowEmptyPassword;

}

EnterXauthInteractivePasscodeDialog::~ EnterXauthInteractivePasscodeDialog()
{
}


void EnterXauthInteractivePasscodeDialog::accept()
{
    bool ok = true;
	if (main->PasswordEdit->text().isEmpty() && allowEmptyPassword == false ) {
        KMessageBox::sorry(0, i18n("Passcode must be filled in."));
        ok = false;
    }

    if (ok) {
        Password = main->PasswordEdit->text();
        QDialog::accept();
    }
}

#include "enterxauthinteractivepasscodedialog.moc"
