/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#include "update_manager.h"

UpdateManager::UpdateManager()
{
}

void UpdateManager::updateManager()
{
    http = new QHttp(this);
    http->setHost("kontrolpack.com");
    http->get("/version.xml");
    connect(http, SIGNAL(done(bool)), this, SLOT(readVersion()));
}

void UpdateManager::autoUpdateManager()
{
    http = new QHttp(this);
    http->setHost("kontrolpack.com");
    http->get("/version.xml");
    connect(http, SIGNAL(done(bool)), this, SLOT(autoReadVersion()));
}

void UpdateManager::autoReadVersion()
{
    QByteArray versionByteArray = http->readAll();
    QStringList params = this->getVersion(QString(versionByteArray));
    QString version = params.at(0);
    QString description = params.at(1);
    if (!version.isEmpty())
        if (QString::compare(version, QString(VERSION), Qt::CaseInsensitive) != 0) {
            UpdateDialog *updateDialog = new UpdateDialog(version, description);
            updateDialog->exec();
        }
}

void UpdateManager::readVersion()
{
    QByteArray versionByteArray = http->readAll();
    QStringList params = this->getVersion(QString(versionByteArray));
    QString version = params.at(0);
    QString description = params.at(1);
    if (!version.isEmpty()) {
        if (QString::compare(version, QString(VERSION), Qt::CaseInsensitive) != 0) {
            UpdateDialog *updateDialog = new UpdateDialog(version, description);
            updateDialog->exec();
        } else {
            UpdateManagerDialog *updateDialog = new UpdateManagerDialog(version);
            updateDialog->exec();
        }
    }
}

QStringList UpdateManager::getVersion(QString xml)
{
    QStringList params = QStringList();
    QString version = "";
    QString description = "";
    QDomDocument doc;
    doc.setContent(xml);
    QDomElement root = doc.documentElement();
    QDomElement child = root.firstChild().toElement();
    while(!child.isNull())
    {
        if (child.tagName() == VERSION_LABEL)
        {
          version = child.text();
        }
        child = child.nextSibling().toElement();
    }
    params.append(version);
    params.append(description);
    return params;
}
