{-# LANGUAGE ForeignFunctionInterface #-}

#include <bindings.dsl.h>
#include <nettle/sha2.h>

module Bindings.Nettle.Hash.SHA2 where
#strict_import

#num SHA256_DIGEST_SIZE
#num SHA256_DATA_SIZE

#starttype struct sha256_ctx
#stoptype

#ccall sha256_init , Ptr <struct sha256_ctx> -> IO ()
#ccall sha256_update , Ptr <struct sha256_ctx> -> CUInt -> Ptr CUChar -> IO ()
#ccall sha256_digest , Ptr <struct sha256_ctx> -> CUInt -> Ptr CUChar -> IO ()


#num SHA224_DIGEST_SIZE
#num SHA224_DATA_SIZE

#starttype struct sha224_ctx
#stoptype

#ccall sha224_init , Ptr <struct sha224_ctx> -> IO ()
#ccall sha224_digest , Ptr <struct sha224_ctx> -> CUInt -> Ptr CUChar -> IO ()


#num SHA512_DIGEST_SIZE
#num SHA512_DATA_SIZE

#starttype struct sha512_ctx
#stoptype

#ccall sha512_init , Ptr <struct sha512_ctx> -> IO ()
#ccall sha512_update , Ptr <struct sha512_ctx> -> CUInt -> Ptr CUChar -> IO ()
#ccall sha512_digest , Ptr <struct sha512_ctx> -> CUInt -> Ptr CUChar -> IO ()


#num SHA384_DIGEST_SIZE
#num SHA384_DATA_SIZE

#starttype struct sha384_ctx
#stoptype

#ccall sha384_init , Ptr <struct sha384_ctx> -> IO ()
#ccall sha384_digest , Ptr <struct sha384_ctx> -> CUInt -> Ptr CUChar -> IO ()

