/*
 * Copyright 2011 The Emscripten Authors.  All rights reserved.
 * Emscripten is available under two separate licenses, the MIT license and the
 * University of Illinois/NCSA Open Source License.  Both these licenses can be
 * found in the LICENSE file.
 */

#include <stdio.h>
#include <math.h>

int main() {
  int x;
  printf("ab%gc%nd\n", 1.23f, &x);
  printf("n=%d\n", x);
  printf("\n");
  printf("Characters: %c %c\n", 'a', 65);
  printf("Decimals: %d %ld %lld %d\n", 1977, 650000L, 12LL, 4);
  printf("Preceding with blanks: %10d %10d\n", 1977, -1977);
  printf("Preceding with zeros: %010d %010d\n", 1977, -1977);
  printf("Force sign: %+d %+d %+6d %+6d\n", 1977, -1977, 1977, -1977);
  printf("Force sign or space: % d % d % 6d % 6d\n", 1977, -1977, 1977, -1977);
  printf("Sign overrides space: % +d % +d % +6d % +6d\n", 1977, -1977, 1977, -1977);
  printf("Some different radixes: %d %x %o %#x %#o\n", 100, 100, 100, 100, 100);
  printf("floats: %4.2f %+.0e %E %08.2f\n", 3.1416, 3.1416, 3.1416, 3.1416);
  printf("negative floats: %4.2f %+.0e %E %08.2f\n", -3.1416, -3.1416, -3.1416, -3.1416);
  printf("Force sign or space: % .2f % .2f % 6.2f % 6.2f\n", 3.1416, -3.1416, 3.1416, -3.1416);
  printf("Width trick: %*d\n", 5, 10);
  printf("%s %%\n", "A string");
  printf("Null string: %7s\n", NULL);
  printf("Null pointer: %p\n", NULL);
  printf("%lf\n", INFINITY);
  printf("%lF\n", INFINITY);
  printf("%lf\n", -INFINITY);
  printf("%lF\n", -INFINITY);
  printf("%lf\n", NAN);
  printf("%lF\n", NAN);
  printf("%10f\n", NAN);
  printf("%-10f\n", NAN);
  printf("%010.2f\n", NAN);
  printf("%-010.2f\n", NAN);
  printf("%10.f\n", INFINITY);
  printf("%-10.f\n", -INFINITY);
  printf("--rest--\n");
  printf("in%%3.5valid\n", 0);
  printf("%.f\n", 0.0f);
  printf("%.0f\n", 0.0f);
  printf("%.1f\n", 0.0f);
  printf("%.2f\n", 0.0f);
  printf("%.5f\n", 0.0f);
  printf("%.f\n", 1.0f);
  printf("%.0f\n", 1.0f);
  printf("%.1f\n", 1.0f);
  printf("%.2f\n", 1.0f);
  printf("%.5f\n", 1.0f);
  printf("%g\n", 1.f);
  printf("%g\n", 12.f);
  printf("%g\n", 123.f);
  printf("%g\n", 1234.f);
  printf("%g\n", 12345.f);
  printf("%g\n", 123456.f);
  printf("%g\n", 1234567.f);
  printf("%g\n", 12345678.f);
  printf("%g\n", 123456789.f);
  printf("%g\n", 1234567891.f);
  printf("%g\n", 12345678912.f);
  printf("%g\n", 123456789123.f);
  printf("%g\n", 1234567891234.f);
  printf("%g\n", 12345678912345.f);
  printf("%g\n", 123456789123456.f);
  printf("%g\n", 1234567891234567.f);
  printf("%g\n", 12345678912345678.f);
  printf("%g\n", 123456789123456789.f);
  printf("%g\n", 123456789123456789123456789.f);
  printf("%g\n", 1.123456789f);
  printf("%g\n", 12.123456789f);
  printf("%g\n", 123.123456789f);
  printf("%g\n", 1234.123456789f);
  printf("%g\n", 12345.123456789f);
  printf("%g\n", 123456.123456789f);
  printf("%g\n", 1234567.123456789f);
  printf("%g\n", 12345678.123456789f);
  printf("%g\n", 123456789123456789.123456789f);
  printf("%10.5g\n", 1.f);
  printf("%10.5g\n", 12.f);
  printf("%10.5g\n", 123.f);
  printf("%10.5g\n", 1234.f);
  printf("%10.5g\n", 12345.f);
  printf("%10.5g\n", 123456.f);
  printf("%10.5g\n", 1234567.f);
  printf("%10.5g\n", 12345678.f);
  printf("%10.5g\n", 123456789.f);
  printf("%10.5g\n", 1234567891.f);
  printf("%10.5g\n", 12345678912.f);
  printf("%10.5g\n", 123456789123.f);
  printf("%10.5g\n", 1234567891234.f);
  printf("%10.5g\n", 12345678912345.f);
  printf("%10.5g\n", 123456789123456.f);
  printf("%10.5g\n", 1234567891234567.f);
  printf("%10.5g\n", 12345678912345678.f);
  printf("%10.5g\n", 123456789123456789.f);
  printf("%10.5g\n", 123456789123456789123456789.f);
  printf("%10.5g\n", 1.123456789f);
  printf("%10.5g\n", 12.123456789f);
  printf("%10.5g\n", 123.123456789f);
  printf("%10.5g\n", 1234.123456789f);
  printf("%10.5g\n", 12345.123456789f);
  printf("%10.5g\n", 123456.123456789f);
  printf("%10.5g\n", 1234567.123456789f);
  printf("%10.5g\n", 12345678.123456789f);
  printf("%10.5g\n", 123456789123456789.123456789f);
  printf("%#.g\n", 1.f);
  printf("%#.g\n", 12.f);
  printf("%#.g\n", 123.f);
  printf("%#.g\n", 1234.f);
  printf("%#.g\n", 12345.f);
  printf("%#.g\n", 123456.f);
  printf("%#.g\n", 1234567.f);
  printf("%#.g\n", 12345678.f);
  printf("%#.g\n", 123456789.f);
  printf("%#.g\n", 1234567891.f);
  printf("%#.g\n", 12345678912.f);
  printf("%#.g\n", 123456789123.f);
  printf("%#.g\n", 1234567891234.f);
  printf("%#.g\n", 12345678912345.f);
  printf("%#.g\n", 123456789123456.f);
  printf("%#.g\n", 1234567891234567.f);
  printf("%#.g\n", 12345678912345678.f);
  printf("%#.g\n", 123456789123456789.f);
  printf("%#.g\n", 123456789123456789123456789.f);
  printf("%#.g\n", 1.123456789f);
  printf("%#.g\n", 12.123456789f);
  printf("%#.g\n", 123.123456789f);
  printf("%#.g\n", 1234.123456789f);
  printf("%#.g\n", 12345.123456789f);
  printf("%#.g\n", 123456.123456789f);
  printf("%#.g\n", 1234567.123456789f);
  printf("%#.g\n", 12345678.123456789f);
  printf("%#.g\n", 123456789123456789.123456789f);
  printf("%g\n", 1.e-10f);
  printf("%g\n", 12.e-10f);
  printf("%g\n", 123.e-10f);
  printf("%g\n", 1234.e-10f);
  printf("%g\n", 12345.e-10f);
  printf("%g\n", 123456.e-10f);
  printf("%g\n", 1234567.e-10f);
  printf("%g\n", 12345678.e-10f);
  printf("%g\n", 123456789.e-10f);
  printf("%10.5g\n", 1.e-10f);
  printf("%10.5g\n", 12.e-10f);
  printf("%10.5g\n", 123.e-10f);
  printf("%10.5g\n", 1234.e-10f);
  printf("%10.5g\n", 12345.e-10f);
  printf("%10.5g\n", 123456.e-10f);
  printf("%10.5g\n", 1234567.e-10f);
  printf("%10.5g\n", 12345678.e-10f);
  printf("%10.5g\n", 123456789.e-10f);
  printf("%#.g\n", 1.123456789e-10f);
  printf("%#.g\n", 12.123456789e-10f);
  printf("%#.g\n", 123.123456789e-10f);
  printf("%#.g\n", 1234.123456789e-10f);
  printf("%#.g\n", 12345.123456789e-10f);
  printf("%#.g\n", 123456.123456789e-10f);
  printf("%#.g\n", 1234567.123456789e-10f);
  printf("%#.g\n", 12345678.123456789e-10f);
  printf("%g\n", 0.f);
  printf("%g\n", 0.123f);
  printf("%g\n", 0.1234567f);
  printf("%10.5g\n", 0.f);
  printf("%10.5g\n", 0.123f);
  printf("%10.5g\n", 0.1234567f);
  printf("%#.g\n", 0.f);
  printf("%#.g\n", 0.123f);
  printf("%#.g\n", 0.1234567f);
  printf("\n");
  printf("%-15s: %+d\n", "%+d", 8127534);
  printf("%-15s: %+.d\n", "%+.d", 8127534);
  printf("%-15s: %+.0d\n", "%+.0d", 8127534);
  printf("%-15s: %+.1d\n", "%+.1d", 8127534);
  printf("%-15s: %+.2d\n", "%+.2d", 8127534);
  printf("%-15s: %+.5d\n", "%+.5d", 8127534);
  printf("%-15s: %+.10d\n", "%+.10d", 8127534);
  printf("%-15s: %+.30d\n", "%+.30d", 8127534);
  printf("%-15s: %+0d\n", "%+0d", 8127534);
  printf("%-15s: %+1d\n", "%+1d", 8127534);
  printf("%-15s: %+1.d\n", "%+1.d", 8127534);
  printf("%-15s: %+1.0d\n", "%+1.0d", 8127534);
  printf("%-15s: %+1.1d\n", "%+1.1d", 8127534);
  printf("%-15s: %+1.2d\n", "%+1.2d", 8127534);
  printf("%-15s: %+1.5d\n", "%+1.5d", 8127534);
  printf("%-15s: %+1.10d\n", "%+1.10d", 8127534);
  printf("%-15s: %+1.30d\n", "%+1.30d", 8127534);
  printf("%-15s: %+2d\n", "%+2d", 8127534);
  printf("%-15s: %+2.d\n", "%+2.d", 8127534);
  printf("%-15s: %+2.0d\n", "%+2.0d", 8127534);
  printf("%-15s: %+2.1d\n", "%+2.1d", 8127534);
  printf("%-15s: %+2.2d\n", "%+2.2d", 8127534);
  printf("%-15s: %+2.5d\n", "%+2.5d", 8127534);
  printf("%-15s: %+2.10d\n", "%+2.10d", 8127534);
  printf("%-15s: %+2.30d\n", "%+2.30d", 8127534);
  printf("%-15s: %+5d\n", "%+5d", 8127534);
  printf("%-15s: %+5.d\n", "%+5.d", 8127534);
  printf("%-15s: %+5.0d\n", "%+5.0d", 8127534);
  printf("%-15s: %+5.1d\n", "%+5.1d", 8127534);
  printf("%-15s: %+5.2d\n", "%+5.2d", 8127534);
  printf("%-15s: %+5.5d\n", "%+5.5d", 8127534);
  printf("%-15s: %+5.10d\n", "%+5.10d", 8127534);
  printf("%-15s: %+5.30d\n", "%+5.30d", 8127534);
  printf("%-15s: %+10d\n", "%+10d", 8127534);
  printf("%-15s: %+10.d\n", "%+10.d", 8127534);
  printf("%-15s: %+10.0d\n", "%+10.0d", 8127534);
  printf("%-15s: %+10.1d\n", "%+10.1d", 8127534);
  printf("%-15s: %+10.2d\n", "%+10.2d", 8127534);
  printf("%-15s: %+10.5d\n", "%+10.5d", 8127534);
  printf("%-15s: %+10.10d\n", "%+10.10d", 8127534);
  printf("%-15s: %+10.30d\n", "%+10.30d", 8127534);
  printf("%-15s: %+30d\n", "%+30d", 8127534);
  printf("%-15s: %+30.d\n", "%+30.d", 8127534);
  printf("%-15s: %+30.0d\n", "%+30.0d", 8127534);
  printf("%-15s: %+30.1d\n", "%+30.1d", 8127534);
  printf("%-15s: %+30.2d\n", "%+30.2d", 8127534);
  printf("%-15s: %+30.5d\n", "%+30.5d", 8127534);
  printf("%-15s: %+30.10d\n", "%+30.10d", 8127534);
  printf("%-15s: %+30.30d\n", "%+30.30d", 8127534);
  printf("%-15s: %-d\n", "%-d", 8127534);
  printf("%-15s: %-.d\n", "%-.d", 8127534);
  printf("%-15s: %-.0d\n", "%-.0d", 8127534);
  printf("%-15s: %-.1d\n", "%-.1d", 8127534);
  printf("%-15s: %-.2d\n", "%-.2d", 8127534);
  printf("%-15s: %-.5d\n", "%-.5d", 8127534);
  printf("%-15s: %-.10d\n", "%-.10d", 8127534);
  printf("%-15s: %-.30d\n", "%-.30d", 8127534);
  printf("%-15s: %-1d\n", "%-1d", 8127534);
  printf("%-15s: %-1.d\n", "%-1.d", 8127534);
  printf("%-15s: %-1.0d\n", "%-1.0d", 8127534);
  printf("%-15s: %-1.1d\n", "%-1.1d", 8127534);
  printf("%-15s: %-1.2d\n", "%-1.2d", 8127534);
  printf("%-15s: %-1.5d\n", "%-1.5d", 8127534);
  printf("%-15s: %-1.10d\n", "%-1.10d", 8127534);
  printf("%-15s: %-1.30d\n", "%-1.30d", 8127534);
  printf("%-15s: %-2d\n", "%-2d", 8127534);
  printf("%-15s: %-2.d\n", "%-2.d", 8127534);
  printf("%-15s: %-2.0d\n", "%-2.0d", 8127534);
  printf("%-15s: %-2.1d\n", "%-2.1d", 8127534);
  printf("%-15s: %-2.2d\n", "%-2.2d", 8127534);
  printf("%-15s: %-2.5d\n", "%-2.5d", 8127534);
  printf("%-15s: %-2.10d\n", "%-2.10d", 8127534);
  printf("%-15s: %-2.30d\n", "%-2.30d", 8127534);
  printf("%-15s: %-5d\n", "%-5d", 8127534);
  printf("%-15s: %-5.d\n", "%-5.d", 8127534);
  printf("%-15s: %-5.0d\n", "%-5.0d", 8127534);
  printf("%-15s: %-5.1d\n", "%-5.1d", 8127534);
  printf("%-15s: %-5.2d\n", "%-5.2d", 8127534);
  printf("%-15s: %-5.5d\n", "%-5.5d", 8127534);
  printf("%-15s: %-5.10d\n", "%-5.10d", 8127534);
  printf("%-15s: %-5.30d\n", "%-5.30d", 8127534);
  printf("%-15s: %-10d\n", "%-10d", 8127534);
  printf("%-15s: %-10.d\n", "%-10.d", 8127534);
  printf("%-15s: %-10.0d\n", "%-10.0d", 8127534);
  printf("%-15s: %-10.1d\n", "%-10.1d", 8127534);
  printf("%-15s: %-10.2d\n", "%-10.2d", 8127534);
  printf("%-15s: %-10.5d\n", "%-10.5d", 8127534);
  printf("%-15s: %-10.10d\n", "%-10.10d", 8127534);
  printf("%-15s: %-10.30d\n", "%-10.30d", 8127534);
  printf("%-15s: %-30d\n", "%-30d", 8127534);
  printf("%-15s: %-30.d\n", "%-30.d", 8127534);
  printf("%-15s: %-30.0d\n", "%-30.0d", 8127534);
  printf("%-15s: %-30.1d\n", "%-30.1d", 8127534);
  printf("%-15s: %-30.2d\n", "%-30.2d", 8127534);
  printf("%-15s: %-30.5d\n", "%-30.5d", 8127534);
  printf("%-15s: %-30.10d\n", "%-30.10d", 8127534);
  printf("%-15s: %-30.30d\n", "%-30.30d", 8127534);
  printf("%-15s: %0d\n", "%0d", 8127534);
  printf("%-15s: %01d\n", "%01d", 8127534);
  printf("%-15s: %02d\n", "%02d", 8127534);
  printf("%-15s: %05d\n", "%05d", 8127534);
  printf("%-15s: %010d\n", "%010d", 8127534);
  printf("%-15s: %030d\n", "%030d", 8127534);
  printf("%-15s: %-+d\n", "%-+d", 8127534);
  printf("%-15s: %-+.d\n", "%-+.d", 8127534);
  printf("%-15s: %-+.0d\n", "%-+.0d", 8127534);
  printf("%-15s: %-+.1d\n", "%-+.1d", 8127534);
  printf("%-15s: %-+.2d\n", "%-+.2d", 8127534);
  printf("%-15s: %-+.5d\n", "%-+.5d", 8127534);
  printf("%-15s: %-+.10d\n", "%-+.10d", 8127534);
  printf("%-15s: %-+.30d\n", "%-+.30d", 8127534);
  printf("%-15s: %-+1d\n", "%-+1d", 8127534);
  printf("%-15s: %-+1.d\n", "%-+1.d", 8127534);
  printf("%-15s: %-+1.0d\n", "%-+1.0d", 8127534);
  printf("%-15s: %-+1.1d\n", "%-+1.1d", 8127534);
  printf("%-15s: %-+1.2d\n", "%-+1.2d", 8127534);
  printf("%-15s: %-+1.5d\n", "%-+1.5d", 8127534);
  printf("%-15s: %-+1.10d\n", "%-+1.10d", 8127534);
  printf("%-15s: %-+1.30d\n", "%-+1.30d", 8127534);
  printf("%-15s: %-+2d\n", "%-+2d", 8127534);
  printf("%-15s: %-+2.d\n", "%-+2.d", 8127534);
  printf("%-15s: %-+2.0d\n", "%-+2.0d", 8127534);
  printf("%-15s: %-+2.1d\n", "%-+2.1d", 8127534);
  printf("%-15s: %-+2.2d\n", "%-+2.2d", 8127534);
  printf("%-15s: %-+2.5d\n", "%-+2.5d", 8127534);
  printf("%-15s: %-+2.10d\n", "%-+2.10d", 8127534);
  printf("%-15s: %-+2.30d\n", "%-+2.30d", 8127534);
  printf("%-15s: %-+5d\n", "%-+5d", 8127534);
  printf("%-15s: %-+5.d\n", "%-+5.d", 8127534);
  printf("%-15s: %-+5.0d\n", "%-+5.0d", 8127534);
  printf("%-15s: %-+5.1d\n", "%-+5.1d", 8127534);
  printf("%-15s: %-+5.2d\n", "%-+5.2d", 8127534);
  printf("%-15s: %-+5.5d\n", "%-+5.5d", 8127534);
  printf("%-15s: %-+5.10d\n", "%-+5.10d", 8127534);
  printf("%-15s: %-+5.30d\n", "%-+5.30d", 8127534);
  printf("%-15s: %-+10d\n", "%-+10d", 8127534);
  printf("%-15s: %-+10.d\n", "%-+10.d", 8127534);
  printf("%-15s: %-+10.0d\n", "%-+10.0d", 8127534);
  printf("%-15s: %-+10.1d\n", "%-+10.1d", 8127534);
  printf("%-15s: %-+10.2d\n", "%-+10.2d", 8127534);
  printf("%-15s: %-+10.5d\n", "%-+10.5d", 8127534);
  printf("%-15s: %-+10.10d\n", "%-+10.10d", 8127534);
  printf("%-15s: %-+10.30d\n", "%-+10.30d", 8127534);
  printf("%-15s: %-+30d\n", "%-+30d", 8127534);
  printf("%-15s: %-+30.d\n", "%-+30.d", 8127534);
  printf("%-15s: %-+30.0d\n", "%-+30.0d", 8127534);
  printf("%-15s: %-+30.1d\n", "%-+30.1d", 8127534);
  printf("%-15s: %-+30.2d\n", "%-+30.2d", 8127534);
  printf("%-15s: %-+30.5d\n", "%-+30.5d", 8127534);
  printf("%-15s: %-+30.10d\n", "%-+30.10d", 8127534);
  printf("%-15s: %-+30.30d\n", "%-+30.30d", 8127534);
  printf("%-15s: %+0d\n", "%+0d", 8127534);
  printf("%-15s: %+01d\n", "%+01d", 8127534);
  printf("%-15s: %+02d\n", "%+02d", 8127534);
  printf("%-15s: %+05d\n", "%+05d", 8127534);
  printf("%-15s: %+010d\n", "%+010d", 8127534);
  printf("%-15s: %+030d\n", "%+030d", 8127534);
  printf("%-15s: %+-d\n", "%+-d", 8127534);
  printf("%-15s: %+-.d\n", "%+-.d", 8127534);
  printf("%-15s: %+-.0d\n", "%+-.0d", 8127534);
  printf("%-15s: %+-.1d\n", "%+-.1d", 8127534);
  printf("%-15s: %+-.2d\n", "%+-.2d", 8127534);
  printf("%-15s: %+-.5d\n", "%+-.5d", 8127534);
  printf("%-15s: %+-.10d\n", "%+-.10d", 8127534);
  printf("%-15s: %+-.30d\n", "%+-.30d", 8127534);
  printf("%-15s: %+-1d\n", "%+-1d", 8127534);
  printf("%-15s: %+-1.d\n", "%+-1.d", 8127534);
  printf("%-15s: %+-1.0d\n", "%+-1.0d", 8127534);
  printf("%-15s: %+-1.1d\n", "%+-1.1d", 8127534);
  printf("%-15s: %+-1.2d\n", "%+-1.2d", 8127534);
  printf("%-15s: %+-1.5d\n", "%+-1.5d", 8127534);
  printf("%-15s: %+-1.10d\n", "%+-1.10d", 8127534);
  printf("%-15s: %+-1.30d\n", "%+-1.30d", 8127534);
  printf("%-15s: %+-2d\n", "%+-2d", 8127534);
  printf("%-15s: %+-2.d\n", "%+-2.d", 8127534);
  printf("%-15s: %+-2.0d\n", "%+-2.0d", 8127534);
  printf("%-15s: %+-2.1d\n", "%+-2.1d", 8127534);
  printf("%-15s: %+-2.2d\n", "%+-2.2d", 8127534);
  printf("%-15s: %+-2.5d\n", "%+-2.5d", 8127534);
  printf("%-15s: %+-2.10d\n", "%+-2.10d", 8127534);
  printf("%-15s: %+-2.30d\n", "%+-2.30d", 8127534);
  printf("%-15s: %+-5d\n", "%+-5d", 8127534);
  printf("%-15s: %+-5.d\n", "%+-5.d", 8127534);
  printf("%-15s: %+-5.0d\n", "%+-5.0d", 8127534);
  printf("%-15s: %+-5.1d\n", "%+-5.1d", 8127534);
  printf("%-15s: %+-5.2d\n", "%+-5.2d", 8127534);
  printf("%-15s: %+-5.5d\n", "%+-5.5d", 8127534);
  printf("%-15s: %+-5.10d\n", "%+-5.10d", 8127534);
  printf("%-15s: %+-5.30d\n", "%+-5.30d", 8127534);
  printf("%-15s: %+-10d\n", "%+-10d", 8127534);
  printf("%-15s: %+-10.d\n", "%+-10.d", 8127534);
  printf("%-15s: %+-10.0d\n", "%+-10.0d", 8127534);
  printf("%-15s: %+-10.1d\n", "%+-10.1d", 8127534);
  printf("%-15s: %+-10.2d\n", "%+-10.2d", 8127534);
  printf("%-15s: %+-10.5d\n", "%+-10.5d", 8127534);
  printf("%-15s: %+-10.10d\n", "%+-10.10d", 8127534);
  printf("%-15s: %+-10.30d\n", "%+-10.30d", 8127534);
  printf("%-15s: %+-30d\n", "%+-30d", 8127534);
  printf("%-15s: %+-30.d\n", "%+-30.d", 8127534);
  printf("%-15s: %+-30.0d\n", "%+-30.0d", 8127534);
  printf("%-15s: %+-30.1d\n", "%+-30.1d", 8127534);
  printf("%-15s: %+-30.2d\n", "%+-30.2d", 8127534);
  printf("%-15s: %+-30.5d\n", "%+-30.5d", 8127534);
  printf("%-15s: %+-30.10d\n", "%+-30.10d", 8127534);
  printf("%-15s: %+-30.30d\n", "%+-30.30d", 8127534);
  printf("%-15s: %+0d\n", "%+0d", 8127534);
  printf("%-15s: %+01d\n", "%+01d", 8127534);
  printf("%-15s: %+02d\n", "%+02d", 8127534);
  printf("%-15s: %+05d\n", "%+05d", 8127534);
  printf("%-15s: %+010d\n", "%+010d", 8127534);
  printf("%-15s: %+030d\n", "%+030d", 8127534);
  printf("%-15s: %+i\n", "%+i", 8127534);
  printf("%-15s: %+.i\n", "%+.i", 8127534);
  printf("%-15s: %+.0i\n", "%+.0i", 8127534);
  printf("%-15s: %+.1i\n", "%+.1i", 8127534);
  printf("%-15s: %+.2i\n", "%+.2i", 8127534);
  printf("%-15s: %+.5i\n", "%+.5i", 8127534);
  printf("%-15s: %+.10i\n", "%+.10i", 8127534);
  printf("%-15s: %+.30i\n", "%+.30i", 8127534);
  printf("%-15s: %+0i\n", "%+0i", 8127534);
  printf("%-15s: %+1i\n", "%+1i", 8127534);
  printf("%-15s: %+1.i\n", "%+1.i", 8127534);
  printf("%-15s: %+1.0i\n", "%+1.0i", 8127534);
  printf("%-15s: %+1.1i\n", "%+1.1i", 8127534);
  printf("%-15s: %+1.2i\n", "%+1.2i", 8127534);
  printf("%-15s: %+1.5i\n", "%+1.5i", 8127534);
  printf("%-15s: %+1.10i\n", "%+1.10i", 8127534);
  printf("%-15s: %+1.30i\n", "%+1.30i", 8127534);
  printf("%-15s: %+2i\n", "%+2i", 8127534);
  printf("%-15s: %+2.i\n", "%+2.i", 8127534);
  printf("%-15s: %+2.0i\n", "%+2.0i", 8127534);
  printf("%-15s: %+2.1i\n", "%+2.1i", 8127534);
  printf("%-15s: %+2.2i\n", "%+2.2i", 8127534);
  printf("%-15s: %+2.5i\n", "%+2.5i", 8127534);
  printf("%-15s: %+2.10i\n", "%+2.10i", 8127534);
  printf("%-15s: %+2.30i\n", "%+2.30i", 8127534);
  printf("%-15s: %+5i\n", "%+5i", 8127534);
  printf("%-15s: %+5.i\n", "%+5.i", 8127534);
  printf("%-15s: %+5.0i\n", "%+5.0i", 8127534);
  printf("%-15s: %+5.1i\n", "%+5.1i", 8127534);
  printf("%-15s: %+5.2i\n", "%+5.2i", 8127534);
  printf("%-15s: %+5.5i\n", "%+5.5i", 8127534);
  printf("%-15s: %+5.10i\n", "%+5.10i", 8127534);
  printf("%-15s: %+5.30i\n", "%+5.30i", 8127534);
  printf("%-15s: %+10i\n", "%+10i", 8127534);
  printf("%-15s: %+10.i\n", "%+10.i", 8127534);
  printf("%-15s: %+10.0i\n", "%+10.0i", 8127534);
  printf("%-15s: %+10.1i\n", "%+10.1i", 8127534);
  printf("%-15s: %+10.2i\n", "%+10.2i", 8127534);
  printf("%-15s: %+10.5i\n", "%+10.5i", 8127534);
  printf("%-15s: %+10.10i\n", "%+10.10i", 8127534);
  printf("%-15s: %+10.30i\n", "%+10.30i", 8127534);
  printf("%-15s: %+30i\n", "%+30i", 8127534);
  printf("%-15s: %+30.i\n", "%+30.i", 8127534);
  printf("%-15s: %+30.0i\n", "%+30.0i", 8127534);
  printf("%-15s: %+30.1i\n", "%+30.1i", 8127534);
  printf("%-15s: %+30.2i\n", "%+30.2i", 8127534);
  printf("%-15s: %+30.5i\n", "%+30.5i", 8127534);
  printf("%-15s: %+30.10i\n", "%+30.10i", 8127534);
  printf("%-15s: %+30.30i\n", "%+30.30i", 8127534);
  printf("%-15s: %-i\n", "%-i", 8127534);
  printf("%-15s: %-.i\n", "%-.i", 8127534);
  printf("%-15s: %-.0i\n", "%-.0i", 8127534);
  printf("%-15s: %-.1i\n", "%-.1i", 8127534);
  printf("%-15s: %-.2i\n", "%-.2i", 8127534);
  printf("%-15s: %-.5i\n", "%-.5i", 8127534);
  printf("%-15s: %-.10i\n", "%-.10i", 8127534);
  printf("%-15s: %-.30i\n", "%-.30i", 8127534);
  printf("%-15s: %-1i\n", "%-1i", 8127534);
  printf("%-15s: %-1.i\n", "%-1.i", 8127534);
  printf("%-15s: %-1.0i\n", "%-1.0i", 8127534);
  printf("%-15s: %-1.1i\n", "%-1.1i", 8127534);
  printf("%-15s: %-1.2i\n", "%-1.2i", 8127534);
  printf("%-15s: %-1.5i\n", "%-1.5i", 8127534);
  printf("%-15s: %-1.10i\n", "%-1.10i", 8127534);
  printf("%-15s: %-1.30i\n", "%-1.30i", 8127534);
  printf("%-15s: %-2i\n", "%-2i", 8127534);
  printf("%-15s: %-2.i\n", "%-2.i", 8127534);
  printf("%-15s: %-2.0i\n", "%-2.0i", 8127534);
  printf("%-15s: %-2.1i\n", "%-2.1i", 8127534);
  printf("%-15s: %-2.2i\n", "%-2.2i", 8127534);
  printf("%-15s: %-2.5i\n", "%-2.5i", 8127534);
  printf("%-15s: %-2.10i\n", "%-2.10i", 8127534);
  printf("%-15s: %-2.30i\n", "%-2.30i", 8127534);
  printf("%-15s: %-5i\n", "%-5i", 8127534);
  printf("%-15s: %-5.i\n", "%-5.i", 8127534);
  printf("%-15s: %-5.0i\n", "%-5.0i", 8127534);
  printf("%-15s: %-5.1i\n", "%-5.1i", 8127534);
  printf("%-15s: %-5.2i\n", "%-5.2i", 8127534);
  printf("%-15s: %-5.5i\n", "%-5.5i", 8127534);
  printf("%-15s: %-5.10i\n", "%-5.10i", 8127534);
  printf("%-15s: %-5.30i\n", "%-5.30i", 8127534);
  printf("%-15s: %-10i\n", "%-10i", 8127534);
  printf("%-15s: %-10.i\n", "%-10.i", 8127534);
  printf("%-15s: %-10.0i\n", "%-10.0i", 8127534);
  printf("%-15s: %-10.1i\n", "%-10.1i", 8127534);
  printf("%-15s: %-10.2i\n", "%-10.2i", 8127534);
  printf("%-15s: %-10.5i\n", "%-10.5i", 8127534);
  printf("%-15s: %-10.10i\n", "%-10.10i", 8127534);
  printf("%-15s: %-10.30i\n", "%-10.30i", 8127534);
  printf("%-15s: %-30i\n", "%-30i", 8127534);
  printf("%-15s: %-30.i\n", "%-30.i", 8127534);
  printf("%-15s: %-30.0i\n", "%-30.0i", 8127534);
  printf("%-15s: %-30.1i\n", "%-30.1i", 8127534);
  printf("%-15s: %-30.2i\n", "%-30.2i", 8127534);
  printf("%-15s: %-30.5i\n", "%-30.5i", 8127534);
  printf("%-15s: %-30.10i\n", "%-30.10i", 8127534);
  printf("%-15s: %-30.30i\n", "%-30.30i", 8127534);
  printf("%-15s: %0i\n", "%0i", 8127534);
  printf("%-15s: %01i\n", "%01i", 8127534);
  printf("%-15s: %02i\n", "%02i", 8127534);
  printf("%-15s: %05i\n", "%05i", 8127534);
  printf("%-15s: %010i\n", "%010i", 8127534);
  printf("%-15s: %030i\n", "%030i", 8127534);
  printf("%-15s: %-+i\n", "%-+i", 8127534);
  printf("%-15s: %-+.i\n", "%-+.i", 8127534);
  printf("%-15s: %-+.0i\n", "%-+.0i", 8127534);
  printf("%-15s: %-+.1i\n", "%-+.1i", 8127534);
  printf("%-15s: %-+.2i\n", "%-+.2i", 8127534);
  printf("%-15s: %-+.5i\n", "%-+.5i", 8127534);
  printf("%-15s: %-+.10i\n", "%-+.10i", 8127534);
  printf("%-15s: %-+.30i\n", "%-+.30i", 8127534);
  printf("%-15s: %-+1i\n", "%-+1i", 8127534);
  printf("%-15s: %-+1.i\n", "%-+1.i", 8127534);
  printf("%-15s: %-+1.0i\n", "%-+1.0i", 8127534);
  printf("%-15s: %-+1.1i\n", "%-+1.1i", 8127534);
  printf("%-15s: %-+1.2i\n", "%-+1.2i", 8127534);
  printf("%-15s: %-+1.5i\n", "%-+1.5i", 8127534);
  printf("%-15s: %-+1.10i\n", "%-+1.10i", 8127534);
  printf("%-15s: %-+1.30i\n", "%-+1.30i", 8127534);
  printf("%-15s: %-+2i\n", "%-+2i", 8127534);
  printf("%-15s: %-+2.i\n", "%-+2.i", 8127534);
  printf("%-15s: %-+2.0i\n", "%-+2.0i", 8127534);
  printf("%-15s: %-+2.1i\n", "%-+2.1i", 8127534);
  printf("%-15s: %-+2.2i\n", "%-+2.2i", 8127534);
  printf("%-15s: %-+2.5i\n", "%-+2.5i", 8127534);
  printf("%-15s: %-+2.10i\n", "%-+2.10i", 8127534);
  printf("%-15s: %-+2.30i\n", "%-+2.30i", 8127534);
  printf("%-15s: %-+5i\n", "%-+5i", 8127534);
  printf("%-15s: %-+5.i\n", "%-+5.i", 8127534);
  printf("%-15s: %-+5.0i\n", "%-+5.0i", 8127534);
  printf("%-15s: %-+5.1i\n", "%-+5.1i", 8127534);
  printf("%-15s: %-+5.2i\n", "%-+5.2i", 8127534);
  printf("%-15s: %-+5.5i\n", "%-+5.5i", 8127534);
  printf("%-15s: %-+5.10i\n", "%-+5.10i", 8127534);
  printf("%-15s: %-+5.30i\n", "%-+5.30i", 8127534);
  printf("%-15s: %-+10i\n", "%-+10i", 8127534);
  printf("%-15s: %-+10.i\n", "%-+10.i", 8127534);
  printf("%-15s: %-+10.0i\n", "%-+10.0i", 8127534);
  printf("%-15s: %-+10.1i\n", "%-+10.1i", 8127534);
  printf("%-15s: %-+10.2i\n", "%-+10.2i", 8127534);
  printf("%-15s: %-+10.5i\n", "%-+10.5i", 8127534);
  printf("%-15s: %-+10.10i\n", "%-+10.10i", 8127534);
  printf("%-15s: %-+10.30i\n", "%-+10.30i", 8127534);
  printf("%-15s: %-+30i\n", "%-+30i", 8127534);
  printf("%-15s: %-+30.i\n", "%-+30.i", 8127534);
  printf("%-15s: %-+30.0i\n", "%-+30.0i", 8127534);
  printf("%-15s: %-+30.1i\n", "%-+30.1i", 8127534);
  printf("%-15s: %-+30.2i\n", "%-+30.2i", 8127534);
  printf("%-15s: %-+30.5i\n", "%-+30.5i", 8127534);
  printf("%-15s: %-+30.10i\n", "%-+30.10i", 8127534);
  printf("%-15s: %-+30.30i\n", "%-+30.30i", 8127534);
  printf("%-15s: %+0i\n", "%+0i", 8127534);
  printf("%-15s: %+01i\n", "%+01i", 8127534);
  printf("%-15s: %+02i\n", "%+02i", 8127534);
  printf("%-15s: %+05i\n", "%+05i", 8127534);
  printf("%-15s: %+010i\n", "%+010i", 8127534);
  printf("%-15s: %+030i\n", "%+030i", 8127534);
  printf("%-15s: %+-i\n", "%+-i", 8127534);
  printf("%-15s: %+-.i\n", "%+-.i", 8127534);
  printf("%-15s: %+-.0i\n", "%+-.0i", 8127534);
  printf("%-15s: %+-.1i\n", "%+-.1i", 8127534);
  printf("%-15s: %+-.2i\n", "%+-.2i", 8127534);
  printf("%-15s: %+-.5i\n", "%+-.5i", 8127534);
  printf("%-15s: %+-.10i\n", "%+-.10i", 8127534);
  printf("%-15s: %+-.30i\n", "%+-.30i", 8127534);
  printf("%-15s: %+-1i\n", "%+-1i", 8127534);
  printf("%-15s: %+-1.i\n", "%+-1.i", 8127534);
  printf("%-15s: %+-1.0i\n", "%+-1.0i", 8127534);
  printf("%-15s: %+-1.1i\n", "%+-1.1i", 8127534);
  printf("%-15s: %+-1.2i\n", "%+-1.2i", 8127534);
  printf("%-15s: %+-1.5i\n", "%+-1.5i", 8127534);
  printf("%-15s: %+-1.10i\n", "%+-1.10i", 8127534);
  printf("%-15s: %+-1.30i\n", "%+-1.30i", 8127534);
  printf("%-15s: %+-2i\n", "%+-2i", 8127534);
  printf("%-15s: %+-2.i\n", "%+-2.i", 8127534);
  printf("%-15s: %+-2.0i\n", "%+-2.0i", 8127534);
  printf("%-15s: %+-2.1i\n", "%+-2.1i", 8127534);
  printf("%-15s: %+-2.2i\n", "%+-2.2i", 8127534);
  printf("%-15s: %+-2.5i\n", "%+-2.5i", 8127534);
  printf("%-15s: %+-2.10i\n", "%+-2.10i", 8127534);
  printf("%-15s: %+-2.30i\n", "%+-2.30i", 8127534);
  printf("%-15s: %+-5i\n", "%+-5i", 8127534);
  printf("%-15s: %+-5.i\n", "%+-5.i", 8127534);
  printf("%-15s: %+-5.0i\n", "%+-5.0i", 8127534);
  printf("%-15s: %+-5.1i\n", "%+-5.1i", 8127534);
  printf("%-15s: %+-5.2i\n", "%+-5.2i", 8127534);
  printf("%-15s: %+-5.5i\n", "%+-5.5i", 8127534);
  printf("%-15s: %+-5.10i\n", "%+-5.10i", 8127534);
  printf("%-15s: %+-5.30i\n", "%+-5.30i", 8127534);
  printf("%-15s: %+-10i\n", "%+-10i", 8127534);
  printf("%-15s: %+-10.i\n", "%+-10.i", 8127534);
  printf("%-15s: %+-10.0i\n", "%+-10.0i", 8127534);
  printf("%-15s: %+-10.1i\n", "%+-10.1i", 8127534);
  printf("%-15s: %+-10.2i\n", "%+-10.2i", 8127534);
  printf("%-15s: %+-10.5i\n", "%+-10.5i", 8127534);
  printf("%-15s: %+-10.10i\n", "%+-10.10i", 8127534);
  printf("%-15s: %+-10.30i\n", "%+-10.30i", 8127534);
  printf("%-15s: %+-30i\n", "%+-30i", 8127534);
  printf("%-15s: %+-30.i\n", "%+-30.i", 8127534);
  printf("%-15s: %+-30.0i\n", "%+-30.0i", 8127534);
  printf("%-15s: %+-30.1i\n", "%+-30.1i", 8127534);
  printf("%-15s: %+-30.2i\n", "%+-30.2i", 8127534);
  printf("%-15s: %+-30.5i\n", "%+-30.5i", 8127534);
  printf("%-15s: %+-30.10i\n", "%+-30.10i", 8127534);
  printf("%-15s: %+-30.30i\n", "%+-30.30i", 8127534);
  printf("%-15s: %+0i\n", "%+0i", 8127534);
  printf("%-15s: %+01i\n", "%+01i", 8127534);
  printf("%-15s: %+02i\n", "%+02i", 8127534);
  printf("%-15s: %+05i\n", "%+05i", 8127534);
  printf("%-15s: %+010i\n", "%+010i", 8127534);
  printf("%-15s: %+030i\n", "%+030i", 8127534);
  printf("%-15s: %-u\n", "%-u", 8127534);
  printf("%-15s: %-.u\n", "%-.u", 8127534);
  printf("%-15s: %-.0u\n", "%-.0u", 8127534);
  printf("%-15s: %-.1u\n", "%-.1u", 8127534);
  printf("%-15s: %-.2u\n", "%-.2u", 8127534);
  printf("%-15s: %-.5u\n", "%-.5u", 8127534);
  printf("%-15s: %-.10u\n", "%-.10u", 8127534);
  printf("%-15s: %-.30u\n", "%-.30u", 8127534);
  printf("%-15s: %-1u\n", "%-1u", 8127534);
  printf("%-15s: %-1.u\n", "%-1.u", 8127534);
  printf("%-15s: %-1.0u\n", "%-1.0u", 8127534);
  printf("%-15s: %-1.1u\n", "%-1.1u", 8127534);
  printf("%-15s: %-1.2u\n", "%-1.2u", 8127534);
  printf("%-15s: %-1.5u\n", "%-1.5u", 8127534);
  printf("%-15s: %-1.10u\n", "%-1.10u", 8127534);
  printf("%-15s: %-1.30u\n", "%-1.30u", 8127534);
  printf("%-15s: %-2u\n", "%-2u", 8127534);
  printf("%-15s: %-2.u\n", "%-2.u", 8127534);
  printf("%-15s: %-2.0u\n", "%-2.0u", 8127534);
  printf("%-15s: %-2.1u\n", "%-2.1u", 8127534);
  printf("%-15s: %-2.2u\n", "%-2.2u", 8127534);
  printf("%-15s: %-2.5u\n", "%-2.5u", 8127534);
  printf("%-15s: %-2.10u\n", "%-2.10u", 8127534);
  printf("%-15s: %-2.30u\n", "%-2.30u", 8127534);
  printf("%-15s: %-5u\n", "%-5u", 8127534);
  printf("%-15s: %-5.u\n", "%-5.u", 8127534);
  printf("%-15s: %-5.0u\n", "%-5.0u", 8127534);
  printf("%-15s: %-5.1u\n", "%-5.1u", 8127534);
  printf("%-15s: %-5.2u\n", "%-5.2u", 8127534);
  printf("%-15s: %-5.5u\n", "%-5.5u", 8127534);
  printf("%-15s: %-5.10u\n", "%-5.10u", 8127534);
  printf("%-15s: %-5.30u\n", "%-5.30u", 8127534);
  printf("%-15s: %-10u\n", "%-10u", 8127534);
  printf("%-15s: %-10.u\n", "%-10.u", 8127534);
  printf("%-15s: %-10.0u\n", "%-10.0u", 8127534);
  printf("%-15s: %-10.1u\n", "%-10.1u", 8127534);
  printf("%-15s: %-10.2u\n", "%-10.2u", 8127534);
  printf("%-15s: %-10.5u\n", "%-10.5u", 8127534);
  printf("%-15s: %-10.10u\n", "%-10.10u", 8127534);
  printf("%-15s: %-10.30u\n", "%-10.30u", 8127534);
  printf("%-15s: %-30u\n", "%-30u", 8127534);
  printf("%-15s: %-30.u\n", "%-30.u", 8127534);
  printf("%-15s: %-30.0u\n", "%-30.0u", 8127534);
  printf("%-15s: %-30.1u\n", "%-30.1u", 8127534);
  printf("%-15s: %-30.2u\n", "%-30.2u", 8127534);
  printf("%-15s: %-30.5u\n", "%-30.5u", 8127534);
  printf("%-15s: %-30.10u\n", "%-30.10u", 8127534);
  printf("%-15s: %-30.30u\n", "%-30.30u", 8127534);
  printf("%-15s: %0u\n", "%0u", 8127534);
  printf("%-15s: %01u\n", "%01u", 8127534);
  printf("%-15s: %02u\n", "%02u", 8127534);
  printf("%-15s: %05u\n", "%05u", 8127534);
  printf("%-15s: %010u\n", "%010u", 8127534);
  printf("%-15s: %030u\n", "%030u", 8127534);
  printf("%-15s: %+ld\n", "%+ld", 8127534l);
  printf("%-15s: %+.ld\n", "%+.ld", 8127534l);
  printf("%-15s: %+.0ld\n", "%+.0ld", 8127534l);
  printf("%-15s: %+.1ld\n", "%+.1ld", 8127534l);
  printf("%-15s: %+.2ld\n", "%+.2ld", 8127534l);
  printf("%-15s: %+.5ld\n", "%+.5ld", 8127534l);
  printf("%-15s: %+.10ld\n", "%+.10ld", 8127534l);
  printf("%-15s: %+.30ld\n", "%+.30ld", 8127534l);
  printf("%-15s: %+0ld\n", "%+0ld", 8127534l);
  printf("%-15s: %+1ld\n", "%+1ld", 8127534l);
  printf("%-15s: %+1.ld\n", "%+1.ld", 8127534l);
  printf("%-15s: %+1.0ld\n", "%+1.0ld", 8127534l);
  printf("%-15s: %+1.1ld\n", "%+1.1ld", 8127534l);
  printf("%-15s: %+1.2ld\n", "%+1.2ld", 8127534l);
  printf("%-15s: %+1.5ld\n", "%+1.5ld", 8127534l);
  printf("%-15s: %+1.10ld\n", "%+1.10ld", 8127534l);
  printf("%-15s: %+1.30ld\n", "%+1.30ld", 8127534l);
  printf("%-15s: %+2ld\n", "%+2ld", 8127534l);
  printf("%-15s: %+2.ld\n", "%+2.ld", 8127534l);
  printf("%-15s: %+2.0ld\n", "%+2.0ld", 8127534l);
  printf("%-15s: %+2.1ld\n", "%+2.1ld", 8127534l);
  printf("%-15s: %+2.2ld\n", "%+2.2ld", 8127534l);
  printf("%-15s: %+2.5ld\n", "%+2.5ld", 8127534l);
  printf("%-15s: %+2.10ld\n", "%+2.10ld", 8127534l);
  printf("%-15s: %+2.30ld\n", "%+2.30ld", 8127534l);
  printf("%-15s: %+5ld\n", "%+5ld", 8127534l);
  printf("%-15s: %+5.ld\n", "%+5.ld", 8127534l);
  printf("%-15s: %+5.0ld\n", "%+5.0ld", 8127534l);
  printf("%-15s: %+5.1ld\n", "%+5.1ld", 8127534l);
  printf("%-15s: %+5.2ld\n", "%+5.2ld", 8127534l);
  printf("%-15s: %+5.5ld\n", "%+5.5ld", 8127534l);
  printf("%-15s: %+5.10ld\n", "%+5.10ld", 8127534l);
  printf("%-15s: %+5.30ld\n", "%+5.30ld", 8127534l);
  printf("%-15s: %+10ld\n", "%+10ld", 8127534l);
  printf("%-15s: %+10.ld\n", "%+10.ld", 8127534l);
  printf("%-15s: %+10.0ld\n", "%+10.0ld", 8127534l);
  printf("%-15s: %+10.1ld\n", "%+10.1ld", 8127534l);
  printf("%-15s: %+10.2ld\n", "%+10.2ld", 8127534l);
  printf("%-15s: %+10.5ld\n", "%+10.5ld", 8127534l);
  printf("%-15s: %+10.10ld\n", "%+10.10ld", 8127534l);
  printf("%-15s: %+10.30ld\n", "%+10.30ld", 8127534l);
  printf("%-15s: %+30ld\n", "%+30ld", 8127534l);
  printf("%-15s: %+30.ld\n", "%+30.ld", 8127534l);
  printf("%-15s: %+30.0ld\n", "%+30.0ld", 8127534l);
  printf("%-15s: %+30.1ld\n", "%+30.1ld", 8127534l);
  printf("%-15s: %+30.2ld\n", "%+30.2ld", 8127534l);
  printf("%-15s: %+30.5ld\n", "%+30.5ld", 8127534l);
  printf("%-15s: %+30.10ld\n", "%+30.10ld", 8127534l);
  printf("%-15s: %+30.30ld\n", "%+30.30ld", 8127534l);
  printf("%-15s: %-ld\n", "%-ld", 8127534l);
  printf("%-15s: %-.ld\n", "%-.ld", 8127534l);
  printf("%-15s: %-.0ld\n", "%-.0ld", 8127534l);
  printf("%-15s: %-.1ld\n", "%-.1ld", 8127534l);
  printf("%-15s: %-.2ld\n", "%-.2ld", 8127534l);
  printf("%-15s: %-.5ld\n", "%-.5ld", 8127534l);
  printf("%-15s: %-.10ld\n", "%-.10ld", 8127534l);
  printf("%-15s: %-.30ld\n", "%-.30ld", 8127534l);
  printf("%-15s: %-1ld\n", "%-1ld", 8127534l);
  printf("%-15s: %-1.ld\n", "%-1.ld", 8127534l);
  printf("%-15s: %-1.0ld\n", "%-1.0ld", 8127534l);
  printf("%-15s: %-1.1ld\n", "%-1.1ld", 8127534l);
  printf("%-15s: %-1.2ld\n", "%-1.2ld", 8127534l);
  printf("%-15s: %-1.5ld\n", "%-1.5ld", 8127534l);
  printf("%-15s: %-1.10ld\n", "%-1.10ld", 8127534l);
  printf("%-15s: %-1.30ld\n", "%-1.30ld", 8127534l);
  printf("%-15s: %-2ld\n", "%-2ld", 8127534l);
  printf("%-15s: %-2.ld\n", "%-2.ld", 8127534l);
  printf("%-15s: %-2.0ld\n", "%-2.0ld", 8127534l);
  printf("%-15s: %-2.1ld\n", "%-2.1ld", 8127534l);
  printf("%-15s: %-2.2ld\n", "%-2.2ld", 8127534l);
  printf("%-15s: %-2.5ld\n", "%-2.5ld", 8127534l);
  printf("%-15s: %-2.10ld\n", "%-2.10ld", 8127534l);
  printf("%-15s: %-2.30ld\n", "%-2.30ld", 8127534l);
  printf("%-15s: %-5ld\n", "%-5ld", 8127534l);
  printf("%-15s: %-5.ld\n", "%-5.ld", 8127534l);
  printf("%-15s: %-5.0ld\n", "%-5.0ld", 8127534l);
  printf("%-15s: %-5.1ld\n", "%-5.1ld", 8127534l);
  printf("%-15s: %-5.2ld\n", "%-5.2ld", 8127534l);
  printf("%-15s: %-5.5ld\n", "%-5.5ld", 8127534l);
  printf("%-15s: %-5.10ld\n", "%-5.10ld", 8127534l);
  printf("%-15s: %-5.30ld\n", "%-5.30ld", 8127534l);
  printf("%-15s: %-10ld\n", "%-10ld", 8127534l);
  printf("%-15s: %-10.ld\n", "%-10.ld", 8127534l);
  printf("%-15s: %-10.0ld\n", "%-10.0ld", 8127534l);
  printf("%-15s: %-10.1ld\n", "%-10.1ld", 8127534l);
  printf("%-15s: %-10.2ld\n", "%-10.2ld", 8127534l);
  printf("%-15s: %-10.5ld\n", "%-10.5ld", 8127534l);
  printf("%-15s: %-10.10ld\n", "%-10.10ld", 8127534l);
  printf("%-15s: %-10.30ld\n", "%-10.30ld", 8127534l);
  printf("%-15s: %-30ld\n", "%-30ld", 8127534l);
  printf("%-15s: %-30.ld\n", "%-30.ld", 8127534l);
  printf("%-15s: %-30.0ld\n", "%-30.0ld", 8127534l);
  printf("%-15s: %-30.1ld\n", "%-30.1ld", 8127534l);
  printf("%-15s: %-30.2ld\n", "%-30.2ld", 8127534l);
  printf("%-15s: %-30.5ld\n", "%-30.5ld", 8127534l);
  printf("%-15s: %-30.10ld\n", "%-30.10ld", 8127534l);
  printf("%-15s: %-30.30ld\n", "%-30.30ld", 8127534l);
  printf("%-15s: %0ld\n", "%0ld", 8127534l);
  printf("%-15s: %01ld\n", "%01ld", 8127534l);
  printf("%-15s: %02ld\n", "%02ld", 8127534l);
  printf("%-15s: %05ld\n", "%05ld", 8127534l);
  printf("%-15s: %010ld\n", "%010ld", 8127534l);
  printf("%-15s: %030ld\n", "%030ld", 8127534l);
  printf("%-15s: %-+ld\n", "%-+ld", 8127534l);
  printf("%-15s: %-+.ld\n", "%-+.ld", 8127534l);
  printf("%-15s: %-+.0ld\n", "%-+.0ld", 8127534l);
  printf("%-15s: %-+.1ld\n", "%-+.1ld", 8127534l);
  printf("%-15s: %-+.2ld\n", "%-+.2ld", 8127534l);
  printf("%-15s: %-+.5ld\n", "%-+.5ld", 8127534l);
  printf("%-15s: %-+.10ld\n", "%-+.10ld", 8127534l);
  printf("%-15s: %-+.30ld\n", "%-+.30ld", 8127534l);
  printf("%-15s: %-+1ld\n", "%-+1ld", 8127534l);
  printf("%-15s: %-+1.ld\n", "%-+1.ld", 8127534l);
  printf("%-15s: %-+1.0ld\n", "%-+1.0ld", 8127534l);
  printf("%-15s: %-+1.1ld\n", "%-+1.1ld", 8127534l);
  printf("%-15s: %-+1.2ld\n", "%-+1.2ld", 8127534l);
  printf("%-15s: %-+1.5ld\n", "%-+1.5ld", 8127534l);
  printf("%-15s: %-+1.10ld\n", "%-+1.10ld", 8127534l);
  printf("%-15s: %-+1.30ld\n", "%-+1.30ld", 8127534l);
  printf("%-15s: %-+2ld\n", "%-+2ld", 8127534l);
  printf("%-15s: %-+2.ld\n", "%-+2.ld", 8127534l);
  printf("%-15s: %-+2.0ld\n", "%-+2.0ld", 8127534l);
  printf("%-15s: %-+2.1ld\n", "%-+2.1ld", 8127534l);
  printf("%-15s: %-+2.2ld\n", "%-+2.2ld", 8127534l);
  printf("%-15s: %-+2.5ld\n", "%-+2.5ld", 8127534l);
  printf("%-15s: %-+2.10ld\n", "%-+2.10ld", 8127534l);
  printf("%-15s: %-+2.30ld\n", "%-+2.30ld", 8127534l);
  printf("%-15s: %-+5ld\n", "%-+5ld", 8127534l);
  printf("%-15s: %-+5.ld\n", "%-+5.ld", 8127534l);
  printf("%-15s: %-+5.0ld\n", "%-+5.0ld", 8127534l);
  printf("%-15s: %-+5.1ld\n", "%-+5.1ld", 8127534l);
  printf("%-15s: %-+5.2ld\n", "%-+5.2ld", 8127534l);
  printf("%-15s: %-+5.5ld\n", "%-+5.5ld", 8127534l);
  printf("%-15s: %-+5.10ld\n", "%-+5.10ld", 8127534l);
  printf("%-15s: %-+5.30ld\n", "%-+5.30ld", 8127534l);
  printf("%-15s: %-+10ld\n", "%-+10ld", 8127534l);
  printf("%-15s: %-+10.ld\n", "%-+10.ld", 8127534l);
  printf("%-15s: %-+10.0ld\n", "%-+10.0ld", 8127534l);
  printf("%-15s: %-+10.1ld\n", "%-+10.1ld", 8127534l);
  printf("%-15s: %-+10.2ld\n", "%-+10.2ld", 8127534l);
  printf("%-15s: %-+10.5ld\n", "%-+10.5ld", 8127534l);
  printf("%-15s: %-+10.10ld\n", "%-+10.10ld", 8127534l);
  printf("%-15s: %-+10.30ld\n", "%-+10.30ld", 8127534l);
  printf("%-15s: %-+30ld\n", "%-+30ld", 8127534l);
  printf("%-15s: %-+30.ld\n", "%-+30.ld", 8127534l);
  printf("%-15s: %-+30.0ld\n", "%-+30.0ld", 8127534l);
  printf("%-15s: %-+30.1ld\n", "%-+30.1ld", 8127534l);
  printf("%-15s: %-+30.2ld\n", "%-+30.2ld", 8127534l);
  printf("%-15s: %-+30.5ld\n", "%-+30.5ld", 8127534l);
  printf("%-15s: %-+30.10ld\n", "%-+30.10ld", 8127534l);
  printf("%-15s: %-+30.30ld\n", "%-+30.30ld", 8127534l);
  printf("%-15s: %+0ld\n", "%+0ld", 8127534l);
  printf("%-15s: %+01ld\n", "%+01ld", 8127534l);
  printf("%-15s: %+02ld\n", "%+02ld", 8127534l);
  printf("%-15s: %+05ld\n", "%+05ld", 8127534l);
  printf("%-15s: %+010ld\n", "%+010ld", 8127534l);
  printf("%-15s: %+030ld\n", "%+030ld", 8127534l);
  printf("%-15s: %+-ld\n", "%+-ld", 8127534l);
  printf("%-15s: %+-.ld\n", "%+-.ld", 8127534l);
  printf("%-15s: %+-.0ld\n", "%+-.0ld", 8127534l);
  printf("%-15s: %+-.1ld\n", "%+-.1ld", 8127534l);
  printf("%-15s: %+-.2ld\n", "%+-.2ld", 8127534l);
  printf("%-15s: %+-.5ld\n", "%+-.5ld", 8127534l);
  printf("%-15s: %+-.10ld\n", "%+-.10ld", 8127534l);
  printf("%-15s: %+-.30ld\n", "%+-.30ld", 8127534l);
  printf("%-15s: %+-1ld\n", "%+-1ld", 8127534l);
  printf("%-15s: %+-1.ld\n", "%+-1.ld", 8127534l);
  printf("%-15s: %+-1.0ld\n", "%+-1.0ld", 8127534l);
  printf("%-15s: %+-1.1ld\n", "%+-1.1ld", 8127534l);
  printf("%-15s: %+-1.2ld\n", "%+-1.2ld", 8127534l);
  printf("%-15s: %+-1.5ld\n", "%+-1.5ld", 8127534l);
  printf("%-15s: %+-1.10ld\n", "%+-1.10ld", 8127534l);
  printf("%-15s: %+-1.30ld\n", "%+-1.30ld", 8127534l);
  printf("%-15s: %+-2ld\n", "%+-2ld", 8127534l);
  printf("%-15s: %+-2.ld\n", "%+-2.ld", 8127534l);
  printf("%-15s: %+-2.0ld\n", "%+-2.0ld", 8127534l);
  printf("%-15s: %+-2.1ld\n", "%+-2.1ld", 8127534l);
  printf("%-15s: %+-2.2ld\n", "%+-2.2ld", 8127534l);
  printf("%-15s: %+-2.5ld\n", "%+-2.5ld", 8127534l);
  printf("%-15s: %+-2.10ld\n", "%+-2.10ld", 8127534l);
  printf("%-15s: %+-2.30ld\n", "%+-2.30ld", 8127534l);
  printf("%-15s: %+-5ld\n", "%+-5ld", 8127534l);
  printf("%-15s: %+-5.ld\n", "%+-5.ld", 8127534l);
  printf("%-15s: %+-5.0ld\n", "%+-5.0ld", 8127534l);
  printf("%-15s: %+-5.1ld\n", "%+-5.1ld", 8127534l);
  printf("%-15s: %+-5.2ld\n", "%+-5.2ld", 8127534l);
  printf("%-15s: %+-5.5ld\n", "%+-5.5ld", 8127534l);
  printf("%-15s: %+-5.10ld\n", "%+-5.10ld", 8127534l);
  printf("%-15s: %+-5.30ld\n", "%+-5.30ld", 8127534l);
  printf("%-15s: %+-10ld\n", "%+-10ld", 8127534l);
  printf("%-15s: %+-10.ld\n", "%+-10.ld", 8127534l);
  printf("%-15s: %+-10.0ld\n", "%+-10.0ld", 8127534l);
  printf("%-15s: %+-10.1ld\n", "%+-10.1ld", 8127534l);
  printf("%-15s: %+-10.2ld\n", "%+-10.2ld", 8127534l);
  printf("%-15s: %+-10.5ld\n", "%+-10.5ld", 8127534l);
  printf("%-15s: %+-10.10ld\n", "%+-10.10ld", 8127534l);
  printf("%-15s: %+-10.30ld\n", "%+-10.30ld", 8127534l);
  printf("%-15s: %+-30ld\n", "%+-30ld", 8127534l);
  printf("%-15s: %+-30.ld\n", "%+-30.ld", 8127534l);
  printf("%-15s: %+-30.0ld\n", "%+-30.0ld", 8127534l);
  printf("%-15s: %+-30.1ld\n", "%+-30.1ld", 8127534l);
  printf("%-15s: %+-30.2ld\n", "%+-30.2ld", 8127534l);
  printf("%-15s: %+-30.5ld\n", "%+-30.5ld", 8127534l);
  printf("%-15s: %+-30.10ld\n", "%+-30.10ld", 8127534l);
  printf("%-15s: %+-30.30ld\n", "%+-30.30ld", 8127534l);
  printf("%-15s: %+0ld\n", "%+0ld", 8127534l);
  printf("%-15s: %+01ld\n", "%+01ld", 8127534l);
  printf("%-15s: %+02ld\n", "%+02ld", 8127534l);
  printf("%-15s: %+05ld\n", "%+05ld", 8127534l);
  printf("%-15s: %+010ld\n", "%+010ld", 8127534l);
  printf("%-15s: %+030ld\n", "%+030ld", 8127534l);
  printf("%-15s: %+lld\n", "%+lld", 8127534ll);
  printf("%-15s: %+.lld\n", "%+.lld", 8127534ll);
  printf("%-15s: %+.0lld\n", "%+.0lld", 8127534ll);
  printf("%-15s: %+.1lld\n", "%+.1lld", 8127534ll);
  printf("%-15s: %+.2lld\n", "%+.2lld", 8127534ll);
  printf("%-15s: %+.5lld\n", "%+.5lld", 8127534ll);
  printf("%-15s: %+.10lld\n", "%+.10lld", 8127534ll);
  printf("%-15s: %+.30lld\n", "%+.30lld", 8127534ll);
  printf("%-15s: %+0lld\n", "%+0lld", 8127534ll);
  printf("%-15s: %+1lld\n", "%+1lld", 8127534ll);
  printf("%-15s: %+1.lld\n", "%+1.lld", 8127534ll);
  printf("%-15s: %+1.0lld\n", "%+1.0lld", 8127534ll);
  printf("%-15s: %+1.1lld\n", "%+1.1lld", 8127534ll);
  printf("%-15s: %+1.2lld\n", "%+1.2lld", 8127534ll);
  printf("%-15s: %+1.5lld\n", "%+1.5lld", 8127534ll);
  printf("%-15s: %+1.10lld\n", "%+1.10lld", 8127534ll);
  printf("%-15s: %+1.30lld\n", "%+1.30lld", 8127534ll);
  printf("%-15s: %+2lld\n", "%+2lld", 8127534ll);
  printf("%-15s: %+2.lld\n", "%+2.lld", 8127534ll);
  printf("%-15s: %+2.0lld\n", "%+2.0lld", 8127534ll);
  printf("%-15s: %+2.1lld\n", "%+2.1lld", 8127534ll);
  printf("%-15s: %+2.2lld\n", "%+2.2lld", 8127534ll);
  printf("%-15s: %+2.5lld\n", "%+2.5lld", 8127534ll);
  printf("%-15s: %+2.10lld\n", "%+2.10lld", 8127534ll);
  printf("%-15s: %+2.30lld\n", "%+2.30lld", 8127534ll);
  printf("%-15s: %+5lld\n", "%+5lld", 8127534ll);
  printf("%-15s: %+5.lld\n", "%+5.lld", 8127534ll);
  printf("%-15s: %+5.0lld\n", "%+5.0lld", 8127534ll);
  printf("%-15s: %+5.1lld\n", "%+5.1lld", 8127534ll);
  printf("%-15s: %+5.2lld\n", "%+5.2lld", 8127534ll);
  printf("%-15s: %+5.5lld\n", "%+5.5lld", 8127534ll);
  printf("%-15s: %+5.10lld\n", "%+5.10lld", 8127534ll);
  printf("%-15s: %+5.30lld\n", "%+5.30lld", 8127534ll);
  printf("%-15s: %+10lld\n", "%+10lld", 8127534ll);
  printf("%-15s: %+10.lld\n", "%+10.lld", 8127534ll);
  printf("%-15s: %+10.0lld\n", "%+10.0lld", 8127534ll);
  printf("%-15s: %+10.1lld\n", "%+10.1lld", 8127534ll);
  printf("%-15s: %+10.2lld\n", "%+10.2lld", 8127534ll);
  printf("%-15s: %+10.5lld\n", "%+10.5lld", 8127534ll);
  printf("%-15s: %+10.10lld\n", "%+10.10lld", 8127534ll);
  printf("%-15s: %+10.30lld\n", "%+10.30lld", 8127534ll);
  printf("%-15s: %+30lld\n", "%+30lld", 8127534ll);
  printf("%-15s: %+30.lld\n", "%+30.lld", 8127534ll);
  printf("%-15s: %+30.0lld\n", "%+30.0lld", 8127534ll);
  printf("%-15s: %+30.1lld\n", "%+30.1lld", 8127534ll);
  printf("%-15s: %+30.2lld\n", "%+30.2lld", 8127534ll);
  printf("%-15s: %+30.5lld\n", "%+30.5lld", 8127534ll);
  printf("%-15s: %+30.10lld\n", "%+30.10lld", 8127534ll);
  printf("%-15s: %+30.30lld\n", "%+30.30lld", 8127534ll);
  printf("%-15s: %-lld\n", "%-lld", 8127534ll);
  printf("%-15s: %-.lld\n", "%-.lld", 8127534ll);
  printf("%-15s: %-.0lld\n", "%-.0lld", 8127534ll);
  printf("%-15s: %-.1lld\n", "%-.1lld", 8127534ll);
  printf("%-15s: %-.2lld\n", "%-.2lld", 8127534ll);
  printf("%-15s: %-.5lld\n", "%-.5lld", 8127534ll);
  printf("%-15s: %-.10lld\n", "%-.10lld", 8127534ll);
  printf("%-15s: %-.30lld\n", "%-.30lld", 8127534ll);
  printf("%-15s: %-1lld\n", "%-1lld", 8127534ll);
  printf("%-15s: %-1.lld\n", "%-1.lld", 8127534ll);
  printf("%-15s: %-1.0lld\n", "%-1.0lld", 8127534ll);
  printf("%-15s: %-1.1lld\n", "%-1.1lld", 8127534ll);
  printf("%-15s: %-1.2lld\n", "%-1.2lld", 8127534ll);
  printf("%-15s: %-1.5lld\n", "%-1.5lld", 8127534ll);
  printf("%-15s: %-1.10lld\n", "%-1.10lld", 8127534ll);
  printf("%-15s: %-1.30lld\n", "%-1.30lld", 8127534ll);
  printf("%-15s: %-2lld\n", "%-2lld", 8127534ll);
  printf("%-15s: %-2.lld\n", "%-2.lld", 8127534ll);
  printf("%-15s: %-2.0lld\n", "%-2.0lld", 8127534ll);
  printf("%-15s: %-2.1lld\n", "%-2.1lld", 8127534ll);
  printf("%-15s: %-2.2lld\n", "%-2.2lld", 8127534ll);
  printf("%-15s: %-2.5lld\n", "%-2.5lld", 8127534ll);
  printf("%-15s: %-2.10lld\n", "%-2.10lld", 8127534ll);
  printf("%-15s: %-2.30lld\n", "%-2.30lld", 8127534ll);
  printf("%-15s: %-5lld\n", "%-5lld", 8127534ll);
  printf("%-15s: %-5.lld\n", "%-5.lld", 8127534ll);
  printf("%-15s: %-5.0lld\n", "%-5.0lld", 8127534ll);
  printf("%-15s: %-5.1lld\n", "%-5.1lld", 8127534ll);
  printf("%-15s: %-5.2lld\n", "%-5.2lld", 8127534ll);
  printf("%-15s: %-5.5lld\n", "%-5.5lld", 8127534ll);
  printf("%-15s: %-5.10lld\n", "%-5.10lld", 8127534ll);
  printf("%-15s: %-5.30lld\n", "%-5.30lld", 8127534ll);
  printf("%-15s: %-10lld\n", "%-10lld", 8127534ll);
  printf("%-15s: %-10.lld\n", "%-10.lld", 8127534ll);
  printf("%-15s: %-10.0lld\n", "%-10.0lld", 8127534ll);
  printf("%-15s: %-10.1lld\n", "%-10.1lld", 8127534ll);
  printf("%-15s: %-10.2lld\n", "%-10.2lld", 8127534ll);
  printf("%-15s: %-10.5lld\n", "%-10.5lld", 8127534ll);
  printf("%-15s: %-10.10lld\n", "%-10.10lld", 8127534ll);
  printf("%-15s: %-10.30lld\n", "%-10.30lld", 8127534ll);
  printf("%-15s: %-30lld\n", "%-30lld", 8127534ll);
  printf("%-15s: %-30.lld\n", "%-30.lld", 8127534ll);
  printf("%-15s: %-30.0lld\n", "%-30.0lld", 8127534ll);
  printf("%-15s: %-30.1lld\n", "%-30.1lld", 8127534ll);
  printf("%-15s: %-30.2lld\n", "%-30.2lld", 8127534ll);
  printf("%-15s: %-30.5lld\n", "%-30.5lld", 8127534ll);
  printf("%-15s: %-30.10lld\n", "%-30.10lld", 8127534ll);
  printf("%-15s: %-30.30lld\n", "%-30.30lld", 8127534ll);
  printf("%-15s: %0lld\n", "%0lld", 8127534ll);
  printf("%-15s: %01lld\n", "%01lld", 8127534ll);
  printf("%-15s: %02lld\n", "%02lld", 8127534ll);
  printf("%-15s: %05lld\n", "%05lld", 8127534ll);
  printf("%-15s: %010lld\n", "%010lld", 8127534ll);
  printf("%-15s: %030lld\n", "%030lld", 8127534ll);
  printf("%-15s: %-+lld\n", "%-+lld", 8127534ll);
  printf("%-15s: %-+.lld\n", "%-+.lld", 8127534ll);
  printf("%-15s: %-+.0lld\n", "%-+.0lld", 8127534ll);
  printf("%-15s: %-+.1lld\n", "%-+.1lld", 8127534ll);
  printf("%-15s: %-+.2lld\n", "%-+.2lld", 8127534ll);
  printf("%-15s: %-+.5lld\n", "%-+.5lld", 8127534ll);
  printf("%-15s: %-+.10lld\n", "%-+.10lld", 8127534ll);
  printf("%-15s: %-+.30lld\n", "%-+.30lld", 8127534ll);
  printf("%-15s: %-+1lld\n", "%-+1lld", 8127534ll);
  printf("%-15s: %-+1.lld\n", "%-+1.lld", 8127534ll);
  printf("%-15s: %-+1.0lld\n", "%-+1.0lld", 8127534ll);
  printf("%-15s: %-+1.1lld\n", "%-+1.1lld", 8127534ll);
  printf("%-15s: %-+1.2lld\n", "%-+1.2lld", 8127534ll);
  printf("%-15s: %-+1.5lld\n", "%-+1.5lld", 8127534ll);
  printf("%-15s: %-+1.10lld\n", "%-+1.10lld", 8127534ll);
  printf("%-15s: %-+1.30lld\n", "%-+1.30lld", 8127534ll);
  printf("%-15s: %-+2lld\n", "%-+2lld", 8127534ll);
  printf("%-15s: %-+2.lld\n", "%-+2.lld", 8127534ll);
  printf("%-15s: %-+2.0lld\n", "%-+2.0lld", 8127534ll);
  printf("%-15s: %-+2.1lld\n", "%-+2.1lld", 8127534ll);
  printf("%-15s: %-+2.2lld\n", "%-+2.2lld", 8127534ll);
  printf("%-15s: %-+2.5lld\n", "%-+2.5lld", 8127534ll);
  printf("%-15s: %-+2.10lld\n", "%-+2.10lld", 8127534ll);
  printf("%-15s: %-+2.30lld\n", "%-+2.30lld", 8127534ll);
  printf("%-15s: %-+5lld\n", "%-+5lld", 8127534ll);
  printf("%-15s: %-+5.lld\n", "%-+5.lld", 8127534ll);
  printf("%-15s: %-+5.0lld\n", "%-+5.0lld", 8127534ll);
  printf("%-15s: %-+5.1lld\n", "%-+5.1lld", 8127534ll);
  printf("%-15s: %-+5.2lld\n", "%-+5.2lld", 8127534ll);
  printf("%-15s: %-+5.5lld\n", "%-+5.5lld", 8127534ll);
  printf("%-15s: %-+5.10lld\n", "%-+5.10lld", 8127534ll);
  printf("%-15s: %-+5.30lld\n", "%-+5.30lld", 8127534ll);
  printf("%-15s: %-+10lld\n", "%-+10lld", 8127534ll);
  printf("%-15s: %-+10.lld\n", "%-+10.lld", 8127534ll);
  printf("%-15s: %-+10.0lld\n", "%-+10.0lld", 8127534ll);
  printf("%-15s: %-+10.1lld\n", "%-+10.1lld", 8127534ll);
  printf("%-15s: %-+10.2lld\n", "%-+10.2lld", 8127534ll);
  printf("%-15s: %-+10.5lld\n", "%-+10.5lld", 8127534ll);
  printf("%-15s: %-+10.10lld\n", "%-+10.10lld", 8127534ll);
  printf("%-15s: %-+10.30lld\n", "%-+10.30lld", 8127534ll);
  printf("%-15s: %-+30lld\n", "%-+30lld", 8127534ll);
  printf("%-15s: %-+30.lld\n", "%-+30.lld", 8127534ll);
  printf("%-15s: %-+30.0lld\n", "%-+30.0lld", 8127534ll);
  printf("%-15s: %-+30.1lld\n", "%-+30.1lld", 8127534ll);
  printf("%-15s: %-+30.2lld\n", "%-+30.2lld", 8127534ll);
  printf("%-15s: %-+30.5lld\n", "%-+30.5lld", 8127534ll);
  printf("%-15s: %-+30.10lld\n", "%-+30.10lld", 8127534ll);
  printf("%-15s: %-+30.30lld\n", "%-+30.30lld", 8127534ll);
  printf("%-15s: %+0lld\n", "%+0lld", 8127534ll);
  printf("%-15s: %+01lld\n", "%+01lld", 8127534ll);
  printf("%-15s: %+02lld\n", "%+02lld", 8127534ll);
  printf("%-15s: %+05lld\n", "%+05lld", 8127534ll);
  printf("%-15s: %+010lld\n", "%+010lld", 8127534ll);
  printf("%-15s: %+030lld\n", "%+030lld", 8127534ll);
  printf("%-15s: %+-lld\n", "%+-lld", 8127534ll);
  printf("%-15s: %+-.lld\n", "%+-.lld", 8127534ll);
  printf("%-15s: %+-.0lld\n", "%+-.0lld", 8127534ll);
  printf("%-15s: %+-.1lld\n", "%+-.1lld", 8127534ll);
  printf("%-15s: %+-.2lld\n", "%+-.2lld", 8127534ll);
  printf("%-15s: %+-.5lld\n", "%+-.5lld", 8127534ll);
  printf("%-15s: %+-.10lld\n", "%+-.10lld", 8127534ll);
  printf("%-15s: %+-.30lld\n", "%+-.30lld", 8127534ll);
  printf("%-15s: %+-1lld\n", "%+-1lld", 8127534ll);
  printf("%-15s: %+-1.lld\n", "%+-1.lld", 8127534ll);
  printf("%-15s: %+-1.0lld\n", "%+-1.0lld", 8127534ll);
  printf("%-15s: %+-1.1lld\n", "%+-1.1lld", 8127534ll);
  printf("%-15s: %+-1.2lld\n", "%+-1.2lld", 8127534ll);
  printf("%-15s: %+-1.5lld\n", "%+-1.5lld", 8127534ll);
  printf("%-15s: %+-1.10lld\n", "%+-1.10lld", 8127534ll);
  printf("%-15s: %+-1.30lld\n", "%+-1.30lld", 8127534ll);
  printf("%-15s: %+-2lld\n", "%+-2lld", 8127534ll);
  printf("%-15s: %+-2.lld\n", "%+-2.lld", 8127534ll);
  printf("%-15s: %+-2.0lld\n", "%+-2.0lld", 8127534ll);
  printf("%-15s: %+-2.1lld\n", "%+-2.1lld", 8127534ll);
  printf("%-15s: %+-2.2lld\n", "%+-2.2lld", 8127534ll);
  printf("%-15s: %+-2.5lld\n", "%+-2.5lld", 8127534ll);
  printf("%-15s: %+-2.10lld\n", "%+-2.10lld", 8127534ll);
  printf("%-15s: %+-2.30lld\n", "%+-2.30lld", 8127534ll);
  printf("%-15s: %+-5lld\n", "%+-5lld", 8127534ll);
  printf("%-15s: %+-5.lld\n", "%+-5.lld", 8127534ll);
  printf("%-15s: %+-5.0lld\n", "%+-5.0lld", 8127534ll);
  printf("%-15s: %+-5.1lld\n", "%+-5.1lld", 8127534ll);
  printf("%-15s: %+-5.2lld\n", "%+-5.2lld", 8127534ll);
  printf("%-15s: %+-5.5lld\n", "%+-5.5lld", 8127534ll);
  printf("%-15s: %+-5.10lld\n", "%+-5.10lld", 8127534ll);
  printf("%-15s: %+-5.30lld\n", "%+-5.30lld", 8127534ll);
  printf("%-15s: %+-10lld\n", "%+-10lld", 8127534ll);
  printf("%-15s: %+-10.lld\n", "%+-10.lld", 8127534ll);
  printf("%-15s: %+-10.0lld\n", "%+-10.0lld", 8127534ll);
  printf("%-15s: %+-10.1lld\n", "%+-10.1lld", 8127534ll);
  printf("%-15s: %+-10.2lld\n", "%+-10.2lld", 8127534ll);
  printf("%-15s: %+-10.5lld\n", "%+-10.5lld", 8127534ll);
  printf("%-15s: %+-10.10lld\n", "%+-10.10lld", 8127534ll);
  printf("%-15s: %+-10.30lld\n", "%+-10.30lld", 8127534ll);
  printf("%-15s: %+-30lld\n", "%+-30lld", 8127534ll);
  printf("%-15s: %+-30.lld\n", "%+-30.lld", 8127534ll);
  printf("%-15s: %+-30.0lld\n", "%+-30.0lld", 8127534ll);
  printf("%-15s: %+-30.1lld\n", "%+-30.1lld", 8127534ll);
  printf("%-15s: %+-30.2lld\n", "%+-30.2lld", 8127534ll);
  printf("%-15s: %+-30.5lld\n", "%+-30.5lld", 8127534ll);
  printf("%-15s: %+-30.10lld\n", "%+-30.10lld", 8127534ll);
  printf("%-15s: %+-30.30lld\n", "%+-30.30lld", 8127534ll);
  printf("%-15s: %+0lld\n", "%+0lld", 8127534ll);
  printf("%-15s: %+01lld\n", "%+01lld", 8127534ll);
  printf("%-15s: %+02lld\n", "%+02lld", 8127534ll);
  printf("%-15s: %+05lld\n", "%+05lld", 8127534ll);
  printf("%-15s: %+010lld\n", "%+010lld", 8127534ll);
  printf("%-15s: %+030lld\n", "%+030lld", 8127534ll);
  printf("%-15s: %+f\n", "%+f", 8127.534f);
  printf("%-15s: %+.f\n", "%+.f", 8127.534f);
  printf("%-15s: %+.0f\n", "%+.0f", 8127.534f);
  printf("%-15s: %+.1f\n", "%+.1f", 8127.534f);
  printf("%-15s: %+.2f\n", "%+.2f", 8127.534f);
  printf("%-15s: %+.5f\n", "%+.5f", 8127.534f);
  printf("%-15s: %+.10f\n", "%+.10f", 8127.534f);
  printf("%-15s: %+.30f\n", "%+.30f", 8127.534f);
  printf("%-15s: %+0f\n", "%+0f", 8127.534f);
  printf("%-15s: %+0.f\n", "%+0.f", 8127.534f);
  printf("%-15s: %+0.0f\n", "%+0.0f", 8127.534f);
  printf("%-15s: %+0.1f\n", "%+0.1f", 8127.534f);
  printf("%-15s: %+0.2f\n", "%+0.2f", 8127.534f);
  printf("%-15s: %+0.5f\n", "%+0.5f", 8127.534f);
  printf("%-15s: %+0.10f\n", "%+0.10f", 8127.534f);
  printf("%-15s: %+0.30f\n", "%+0.30f", 8127.534f);
  printf("%-15s: %+1f\n", "%+1f", 8127.534f);
  printf("%-15s: %+1.f\n", "%+1.f", 8127.534f);
  printf("%-15s: %+1.0f\n", "%+1.0f", 8127.534f);
  printf("%-15s: %+1.1f\n", "%+1.1f", 8127.534f);
  printf("%-15s: %+1.2f\n", "%+1.2f", 8127.534f);
  printf("%-15s: %+1.5f\n", "%+1.5f", 8127.534f);
  printf("%-15s: %+1.10f\n", "%+1.10f", 8127.534f);
  printf("%-15s: %+1.30f\n", "%+1.30f", 8127.534f);
  printf("%-15s: %+2f\n", "%+2f", 8127.534f);
  printf("%-15s: %+2.f\n", "%+2.f", 8127.534f);
  printf("%-15s: %+2.0f\n", "%+2.0f", 8127.534f);
  printf("%-15s: %+2.1f\n", "%+2.1f", 8127.534f);
  printf("%-15s: %+2.2f\n", "%+2.2f", 8127.534f);
  printf("%-15s: %+2.5f\n", "%+2.5f", 8127.534f);
  printf("%-15s: %+2.10f\n", "%+2.10f", 8127.534f);
  printf("%-15s: %+2.30f\n", "%+2.30f", 8127.534f);
  printf("%-15s: %+5f\n", "%+5f", 8127.534f);
  printf("%-15s: %+5.f\n", "%+5.f", 8127.534f);
  printf("%-15s: %+5.0f\n", "%+5.0f", 8127.534f);
  printf("%-15s: %+5.1f\n", "%+5.1f", 8127.534f);
  printf("%-15s: %+5.2f\n", "%+5.2f", 8127.534f);
  printf("%-15s: %+5.5f\n", "%+5.5f", 8127.534f);
  printf("%-15s: %+5.10f\n", "%+5.10f", 8127.534f);
  printf("%-15s: %+5.30f\n", "%+5.30f", 8127.534f);
  printf("%-15s: %+10f\n", "%+10f", 8127.534f);
  printf("%-15s: %+10.f\n", "%+10.f", 8127.534f);
  printf("%-15s: %+10.0f\n", "%+10.0f", 8127.534f);
  printf("%-15s: %+10.1f\n", "%+10.1f", 8127.534f);
  printf("%-15s: %+10.2f\n", "%+10.2f", 8127.534f);
  printf("%-15s: %+10.5f\n", "%+10.5f", 8127.534f);
  printf("%-15s: %+10.10f\n", "%+10.10f", 8127.534f);
  printf("%-15s: %+10.30f\n", "%+10.30f", 8127.534f);
  printf("%-15s: %+30f\n", "%+30f", 8127.534f);
  printf("%-15s: %+30.f\n", "%+30.f", 8127.534f);
  printf("%-15s: %+30.0f\n", "%+30.0f", 8127.534f);
  printf("%-15s: %+30.1f\n", "%+30.1f", 8127.534f);
  printf("%-15s: %+30.2f\n", "%+30.2f", 8127.534f);
  printf("%-15s: %+30.5f\n", "%+30.5f", 8127.534f);
  printf("%-15s: %+30.10f\n", "%+30.10f", 8127.534f);
  printf("%-15s: %+30.30f\n", "%+30.30f", 8127.534f);
  printf("%-15s: %-f\n", "%-f", 8127.534f);
  printf("%-15s: %-.f\n", "%-.f", 8127.534f);
  printf("%-15s: %-.0f\n", "%-.0f", 8127.534f);
  printf("%-15s: %-.1f\n", "%-.1f", 8127.534f);
  printf("%-15s: %-.2f\n", "%-.2f", 8127.534f);
  printf("%-15s: %-.5f\n", "%-.5f", 8127.534f);
  printf("%-15s: %-.10f\n", "%-.10f", 8127.534f);
  printf("%-15s: %-.30f\n", "%-.30f", 8127.534f);
  printf("%-15s: %-1f\n", "%-1f", 8127.534f);
  printf("%-15s: %-1.f\n", "%-1.f", 8127.534f);
  printf("%-15s: %-1.0f\n", "%-1.0f", 8127.534f);
  printf("%-15s: %-1.1f\n", "%-1.1f", 8127.534f);
  printf("%-15s: %-1.2f\n", "%-1.2f", 8127.534f);
  printf("%-15s: %-1.5f\n", "%-1.5f", 8127.534f);
  printf("%-15s: %-1.10f\n", "%-1.10f", 8127.534f);
  printf("%-15s: %-1.30f\n", "%-1.30f", 8127.534f);
  printf("%-15s: %-2f\n", "%-2f", 8127.534f);
  printf("%-15s: %-2.f\n", "%-2.f", 8127.534f);
  printf("%-15s: %-2.0f\n", "%-2.0f", 8127.534f);
  printf("%-15s: %-2.1f\n", "%-2.1f", 8127.534f);
  printf("%-15s: %-2.2f\n", "%-2.2f", 8127.534f);
  printf("%-15s: %-2.5f\n", "%-2.5f", 8127.534f);
  printf("%-15s: %-2.10f\n", "%-2.10f", 8127.534f);
  printf("%-15s: %-2.30f\n", "%-2.30f", 8127.534f);
  printf("%-15s: %-5f\n", "%-5f", 8127.534f);
  printf("%-15s: %-5.f\n", "%-5.f", 8127.534f);
  printf("%-15s: %-5.0f\n", "%-5.0f", 8127.534f);
  printf("%-15s: %-5.1f\n", "%-5.1f", 8127.534f);
  printf("%-15s: %-5.2f\n", "%-5.2f", 8127.534f);
  printf("%-15s: %-5.5f\n", "%-5.5f", 8127.534f);
  printf("%-15s: %-5.10f\n", "%-5.10f", 8127.534f);
  printf("%-15s: %-5.30f\n", "%-5.30f", 8127.534f);
  printf("%-15s: %-10f\n", "%-10f", 8127.534f);
  printf("%-15s: %-10.f\n", "%-10.f", 8127.534f);
  printf("%-15s: %-10.0f\n", "%-10.0f", 8127.534f);
  printf("%-15s: %-10.1f\n", "%-10.1f", 8127.534f);
  printf("%-15s: %-10.2f\n", "%-10.2f", 8127.534f);
  printf("%-15s: %-10.5f\n", "%-10.5f", 8127.534f);
  printf("%-15s: %-10.10f\n", "%-10.10f", 8127.534f);
  printf("%-15s: %-10.30f\n", "%-10.30f", 8127.534f);
  printf("%-15s: %-30f\n", "%-30f", 8127.534f);
  printf("%-15s: %-30.f\n", "%-30.f", 8127.534f);
  printf("%-15s: %-30.0f\n", "%-30.0f", 8127.534f);
  printf("%-15s: %-30.1f\n", "%-30.1f", 8127.534f);
  printf("%-15s: %-30.2f\n", "%-30.2f", 8127.534f);
  printf("%-15s: %-30.5f\n", "%-30.5f", 8127.534f);
  printf("%-15s: %-30.10f\n", "%-30.10f", 8127.534f);
  printf("%-15s: %-30.30f\n", "%-30.30f", 8127.534f);
  printf("%-15s: %#f\n", "%#f", 8127.534f);
  printf("%-15s: %#.f\n", "%#.f", 8127.534f);
  printf("%-15s: %#.0f\n", "%#.0f", 8127.534f);
  printf("%-15s: %#.1f\n", "%#.1f", 8127.534f);
  printf("%-15s: %#.2f\n", "%#.2f", 8127.534f);
  printf("%-15s: %#.5f\n", "%#.5f", 8127.534f);
  printf("%-15s: %#.10f\n", "%#.10f", 8127.534f);
  printf("%-15s: %#.30f\n", "%#.30f", 8127.534f);
  printf("%-15s: %#0f\n", "%#0f", 8127.534f);
  printf("%-15s: %#0.f\n", "%#0.f", 8127.534f);
  printf("%-15s: %#0.0f\n", "%#0.0f", 8127.534f);
  printf("%-15s: %#0.1f\n", "%#0.1f", 8127.534f);
  printf("%-15s: %#0.2f\n", "%#0.2f", 8127.534f);
  printf("%-15s: %#0.5f\n", "%#0.5f", 8127.534f);
  printf("%-15s: %#0.10f\n", "%#0.10f", 8127.534f);
  printf("%-15s: %#0.30f\n", "%#0.30f", 8127.534f);
  printf("%-15s: %#1f\n", "%#1f", 8127.534f);
  printf("%-15s: %#1.f\n", "%#1.f", 8127.534f);
  printf("%-15s: %#1.0f\n", "%#1.0f", 8127.534f);
  printf("%-15s: %#1.1f\n", "%#1.1f", 8127.534f);
  printf("%-15s: %#1.2f\n", "%#1.2f", 8127.534f);
  printf("%-15s: %#1.5f\n", "%#1.5f", 8127.534f);
  printf("%-15s: %#1.10f\n", "%#1.10f", 8127.534f);
  printf("%-15s: %#1.30f\n", "%#1.30f", 8127.534f);
  printf("%-15s: %#2f\n", "%#2f", 8127.534f);
  printf("%-15s: %#2.f\n", "%#2.f", 8127.534f);
  printf("%-15s: %#2.0f\n", "%#2.0f", 8127.534f);
  printf("%-15s: %#2.1f\n", "%#2.1f", 8127.534f);
  printf("%-15s: %#2.2f\n", "%#2.2f", 8127.534f);
  printf("%-15s: %#2.5f\n", "%#2.5f", 8127.534f);
  printf("%-15s: %#2.10f\n", "%#2.10f", 8127.534f);
  printf("%-15s: %#2.30f\n", "%#2.30f", 8127.534f);
  printf("%-15s: %#5f\n", "%#5f", 8127.534f);
  printf("%-15s: %#5.f\n", "%#5.f", 8127.534f);
  printf("%-15s: %#5.0f\n", "%#5.0f", 8127.534f);
  printf("%-15s: %#5.1f\n", "%#5.1f", 8127.534f);
  printf("%-15s: %#5.2f\n", "%#5.2f", 8127.534f);
  printf("%-15s: %#5.5f\n", "%#5.5f", 8127.534f);
  printf("%-15s: %#5.10f\n", "%#5.10f", 8127.534f);
  printf("%-15s: %#5.30f\n", "%#5.30f", 8127.534f);
  printf("%-15s: %#10f\n", "%#10f", 8127.534f);
  printf("%-15s: %#10.f\n", "%#10.f", 8127.534f);
  printf("%-15s: %#10.0f\n", "%#10.0f", 8127.534f);
  printf("%-15s: %#10.1f\n", "%#10.1f", 8127.534f);
  printf("%-15s: %#10.2f\n", "%#10.2f", 8127.534f);
  printf("%-15s: %#10.5f\n", "%#10.5f", 8127.534f);
  printf("%-15s: %#10.10f\n", "%#10.10f", 8127.534f);
  printf("%-15s: %#10.30f\n", "%#10.30f", 8127.534f);
  printf("%-15s: %#30f\n", "%#30f", 8127.534f);
  printf("%-15s: %#30.f\n", "%#30.f", 8127.534f);
  printf("%-15s: %#30.0f\n", "%#30.0f", 8127.534f);
  printf("%-15s: %#30.1f\n", "%#30.1f", 8127.534f);
  printf("%-15s: %#30.2f\n", "%#30.2f", 8127.534f);
  printf("%-15s: %#30.5f\n", "%#30.5f", 8127.534f);
  printf("%-15s: %#30.10f\n", "%#30.10f", 8127.534f);
  printf("%-15s: %#30.30f\n", "%#30.30f", 8127.534f);
  printf("%-15s: %0f\n", "%0f", 8127.534f);
  printf("%-15s: %0.f\n", "%0.f", 8127.534f);
  printf("%-15s: %0.0f\n", "%0.0f", 8127.534f);
  printf("%-15s: %0.1f\n", "%0.1f", 8127.534f);
  printf("%-15s: %0.2f\n", "%0.2f", 8127.534f);
  printf("%-15s: %0.5f\n", "%0.5f", 8127.534f);
  printf("%-15s: %0.10f\n", "%0.10f", 8127.534f);
  printf("%-15s: %0.30f\n", "%0.30f", 8127.534f);
  printf("%-15s: %01f\n", "%01f", 8127.534f);
  printf("%-15s: %01.f\n", "%01.f", 8127.534f);
  printf("%-15s: %01.0f\n", "%01.0f", 8127.534f);
  printf("%-15s: %01.1f\n", "%01.1f", 8127.534f);
  printf("%-15s: %01.2f\n", "%01.2f", 8127.534f);
  printf("%-15s: %01.5f\n", "%01.5f", 8127.534f);
  printf("%-15s: %01.10f\n", "%01.10f", 8127.534f);
  printf("%-15s: %01.30f\n", "%01.30f", 8127.534f);
  printf("%-15s: %02f\n", "%02f", 8127.534f);
  printf("%-15s: %02.f\n", "%02.f", 8127.534f);
  printf("%-15s: %02.0f\n", "%02.0f", 8127.534f);
  printf("%-15s: %02.1f\n", "%02.1f", 8127.534f);
  printf("%-15s: %02.2f\n", "%02.2f", 8127.534f);
  printf("%-15s: %02.5f\n", "%02.5f", 8127.534f);
  printf("%-15s: %02.10f\n", "%02.10f", 8127.534f);
  printf("%-15s: %02.30f\n", "%02.30f", 8127.534f);
  printf("%-15s: %05f\n", "%05f", 8127.534f);
  printf("%-15s: %05.f\n", "%05.f", 8127.534f);
  printf("%-15s: %05.0f\n", "%05.0f", 8127.534f);
  printf("%-15s: %05.1f\n", "%05.1f", 8127.534f);
  printf("%-15s: %05.2f\n", "%05.2f", 8127.534f);
  printf("%-15s: %05.5f\n", "%05.5f", 8127.534f);
  printf("%-15s: %05.10f\n", "%05.10f", 8127.534f);
  printf("%-15s: %05.30f\n", "%05.30f", 8127.534f);
  printf("%-15s: %010f\n", "%010f", 8127.534f);
  printf("%-15s: %010.f\n", "%010.f", 8127.534f);
  printf("%-15s: %010.0f\n", "%010.0f", 8127.534f);
  printf("%-15s: %010.1f\n", "%010.1f", 8127.534f);
  printf("%-15s: %010.2f\n", "%010.2f", 8127.534f);
  printf("%-15s: %010.5f\n", "%010.5f", 8127.534f);
  printf("%-15s: %010.10f\n", "%010.10f", 8127.534f);
  printf("%-15s: %010.30f\n", "%010.30f", 8127.534f);
  printf("%-15s: %030f\n", "%030f", 8127.534f);
  printf("%-15s: %030.f\n", "%030.f", 8127.534f);
  printf("%-15s: %030.0f\n", "%030.0f", 8127.534f);
  printf("%-15s: %030.1f\n", "%030.1f", 8127.534f);
  printf("%-15s: %030.2f\n", "%030.2f", 8127.534f);
  printf("%-15s: %030.5f\n", "%030.5f", 8127.534f);
  printf("%-15s: %030.10f\n", "%030.10f", 8127.534f);
  printf("%-15s: %030.30f\n", "%030.30f", 8127.534f);
  printf("%-15s: %-+f\n", "%-+f", 8127.534f);
  printf("%-15s: %-+.f\n", "%-+.f", 8127.534f);
  printf("%-15s: %-+.0f\n", "%-+.0f", 8127.534f);
  printf("%-15s: %-+.1f\n", "%-+.1f", 8127.534f);
  printf("%-15s: %-+.2f\n", "%-+.2f", 8127.534f);
  printf("%-15s: %-+.5f\n", "%-+.5f", 8127.534f);
  printf("%-15s: %-+.10f\n", "%-+.10f", 8127.534f);
  printf("%-15s: %-+.30f\n", "%-+.30f", 8127.534f);
  printf("%-15s: %-+1f\n", "%-+1f", 8127.534f);
  printf("%-15s: %-+1.f\n", "%-+1.f", 8127.534f);
  printf("%-15s: %-+1.0f\n", "%-+1.0f", 8127.534f);
  printf("%-15s: %-+1.1f\n", "%-+1.1f", 8127.534f);
  printf("%-15s: %-+1.2f\n", "%-+1.2f", 8127.534f);
  printf("%-15s: %-+1.5f\n", "%-+1.5f", 8127.534f);
  printf("%-15s: %-+1.10f\n", "%-+1.10f", 8127.534f);
  printf("%-15s: %-+1.30f\n", "%-+1.30f", 8127.534f);
  printf("%-15s: %-+2f\n", "%-+2f", 8127.534f);
  printf("%-15s: %-+2.f\n", "%-+2.f", 8127.534f);
  printf("%-15s: %-+2.0f\n", "%-+2.0f", 8127.534f);
  printf("%-15s: %-+2.1f\n", "%-+2.1f", 8127.534f);
  printf("%-15s: %-+2.2f\n", "%-+2.2f", 8127.534f);
  printf("%-15s: %-+2.5f\n", "%-+2.5f", 8127.534f);
  printf("%-15s: %-+2.10f\n", "%-+2.10f", 8127.534f);
  printf("%-15s: %-+2.30f\n", "%-+2.30f", 8127.534f);
  printf("%-15s: %-+5f\n", "%-+5f", 8127.534f);
  printf("%-15s: %-+5.f\n", "%-+5.f", 8127.534f);
  printf("%-15s: %-+5.0f\n", "%-+5.0f", 8127.534f);
  printf("%-15s: %-+5.1f\n", "%-+5.1f", 8127.534f);
  printf("%-15s: %-+5.2f\n", "%-+5.2f", 8127.534f);
  printf("%-15s: %-+5.5f\n", "%-+5.5f", 8127.534f);
  printf("%-15s: %-+5.10f\n", "%-+5.10f", 8127.534f);
  printf("%-15s: %-+5.30f\n", "%-+5.30f", 8127.534f);
  printf("%-15s: %-+10f\n", "%-+10f", 8127.534f);
  printf("%-15s: %-+10.f\n", "%-+10.f", 8127.534f);
  printf("%-15s: %-+10.0f\n", "%-+10.0f", 8127.534f);
  printf("%-15s: %-+10.1f\n", "%-+10.1f", 8127.534f);
  printf("%-15s: %-+10.2f\n", "%-+10.2f", 8127.534f);
  printf("%-15s: %-+10.5f\n", "%-+10.5f", 8127.534f);
  printf("%-15s: %-+10.10f\n", "%-+10.10f", 8127.534f);
  printf("%-15s: %-+10.30f\n", "%-+10.30f", 8127.534f);
  printf("%-15s: %-+30f\n", "%-+30f", 8127.534f);
  printf("%-15s: %-+30.f\n", "%-+30.f", 8127.534f);
  printf("%-15s: %-+30.0f\n", "%-+30.0f", 8127.534f);
  printf("%-15s: %-+30.1f\n", "%-+30.1f", 8127.534f);
  printf("%-15s: %-+30.2f\n", "%-+30.2f", 8127.534f);
  printf("%-15s: %-+30.5f\n", "%-+30.5f", 8127.534f);
  printf("%-15s: %-+30.10f\n", "%-+30.10f", 8127.534f);
  printf("%-15s: %-+30.30f\n", "%-+30.30f", 8127.534f);
  printf("%-15s: %#+f\n", "%#+f", 8127.534f);
  printf("%-15s: %#+.f\n", "%#+.f", 8127.534f);
  printf("%-15s: %#+.0f\n", "%#+.0f", 8127.534f);
  printf("%-15s: %#+.1f\n", "%#+.1f", 8127.534f);
  printf("%-15s: %#+.2f\n", "%#+.2f", 8127.534f);
  printf("%-15s: %#+.5f\n", "%#+.5f", 8127.534f);
  printf("%-15s: %#+.10f\n", "%#+.10f", 8127.534f);
  printf("%-15s: %#+.30f\n", "%#+.30f", 8127.534f);
  printf("%-15s: %#+0f\n", "%#+0f", 8127.534f);
  printf("%-15s: %#+0.f\n", "%#+0.f", 8127.534f);
  printf("%-15s: %#+0.0f\n", "%#+0.0f", 8127.534f);
  printf("%-15s: %#+0.1f\n", "%#+0.1f", 8127.534f);
  printf("%-15s: %#+0.2f\n", "%#+0.2f", 8127.534f);
  printf("%-15s: %#+0.5f\n", "%#+0.5f", 8127.534f);
  printf("%-15s: %#+0.10f\n", "%#+0.10f", 8127.534f);
  printf("%-15s: %#+0.30f\n", "%#+0.30f", 8127.534f);
  printf("%-15s: %#+1f\n", "%#+1f", 8127.534f);
  printf("%-15s: %#+1.f\n", "%#+1.f", 8127.534f);
  printf("%-15s: %#+1.0f\n", "%#+1.0f", 8127.534f);
  printf("%-15s: %#+1.1f\n", "%#+1.1f", 8127.534f);
  printf("%-15s: %#+1.2f\n", "%#+1.2f", 8127.534f);
  printf("%-15s: %#+1.5f\n", "%#+1.5f", 8127.534f);
  printf("%-15s: %#+1.10f\n", "%#+1.10f", 8127.534f);
  printf("%-15s: %#+1.30f\n", "%#+1.30f", 8127.534f);
  printf("%-15s: %#+2f\n", "%#+2f", 8127.534f);
  printf("%-15s: %#+2.f\n", "%#+2.f", 8127.534f);
  printf("%-15s: %#+2.0f\n", "%#+2.0f", 8127.534f);
  printf("%-15s: %#+2.1f\n", "%#+2.1f", 8127.534f);
  printf("%-15s: %#+2.2f\n", "%#+2.2f", 8127.534f);
  printf("%-15s: %#+2.5f\n", "%#+2.5f", 8127.534f);
  printf("%-15s: %#+2.10f\n", "%#+2.10f", 8127.534f);
  printf("%-15s: %#+2.30f\n", "%#+2.30f", 8127.534f);
  printf("%-15s: %#+5f\n", "%#+5f", 8127.534f);
  printf("%-15s: %#+5.f\n", "%#+5.f", 8127.534f);
  printf("%-15s: %#+5.0f\n", "%#+5.0f", 8127.534f);
  printf("%-15s: %#+5.1f\n", "%#+5.1f", 8127.534f);
  printf("%-15s: %#+5.2f\n", "%#+5.2f", 8127.534f);
  printf("%-15s: %#+5.5f\n", "%#+5.5f", 8127.534f);
  printf("%-15s: %#+5.10f\n", "%#+5.10f", 8127.534f);
  printf("%-15s: %#+5.30f\n", "%#+5.30f", 8127.534f);
  printf("%-15s: %#+10f\n", "%#+10f", 8127.534f);
  printf("%-15s: %#+10.f\n", "%#+10.f", 8127.534f);
  printf("%-15s: %#+10.0f\n", "%#+10.0f", 8127.534f);
  printf("%-15s: %#+10.1f\n", "%#+10.1f", 8127.534f);
  printf("%-15s: %#+10.2f\n", "%#+10.2f", 8127.534f);
  printf("%-15s: %#+10.5f\n", "%#+10.5f", 8127.534f);
  printf("%-15s: %#+10.10f\n", "%#+10.10f", 8127.534f);
  printf("%-15s: %#+10.30f\n", "%#+10.30f", 8127.534f);
  printf("%-15s: %#+30f\n", "%#+30f", 8127.534f);
  printf("%-15s: %#+30.f\n", "%#+30.f", 8127.534f);
  printf("%-15s: %#+30.0f\n", "%#+30.0f", 8127.534f);
  printf("%-15s: %#+30.1f\n", "%#+30.1f", 8127.534f);
  printf("%-15s: %#+30.2f\n", "%#+30.2f", 8127.534f);
  printf("%-15s: %#+30.5f\n", "%#+30.5f", 8127.534f);
  printf("%-15s: %#+30.10f\n", "%#+30.10f", 8127.534f);
  printf("%-15s: %#+30.30f\n", "%#+30.30f", 8127.534f);
  printf("%-15s: %+0f\n", "%+0f", 8127.534f);
  printf("%-15s: %+0.f\n", "%+0.f", 8127.534f);
  printf("%-15s: %+0.0f\n", "%+0.0f", 8127.534f);
  printf("%-15s: %+0.1f\n", "%+0.1f", 8127.534f);
  printf("%-15s: %+0.2f\n", "%+0.2f", 8127.534f);
  printf("%-15s: %+0.5f\n", "%+0.5f", 8127.534f);
  printf("%-15s: %+0.10f\n", "%+0.10f", 8127.534f);
  printf("%-15s: %+0.30f\n", "%+0.30f", 8127.534f);
  printf("%-15s: %+01f\n", "%+01f", 8127.534f);
  printf("%-15s: %+01.f\n", "%+01.f", 8127.534f);
  printf("%-15s: %+01.0f\n", "%+01.0f", 8127.534f);
  printf("%-15s: %+01.1f\n", "%+01.1f", 8127.534f);
  printf("%-15s: %+01.2f\n", "%+01.2f", 8127.534f);
  printf("%-15s: %+01.5f\n", "%+01.5f", 8127.534f);
  printf("%-15s: %+01.10f\n", "%+01.10f", 8127.534f);
  printf("%-15s: %+01.30f\n", "%+01.30f", 8127.534f);
  printf("%-15s: %+02f\n", "%+02f", 8127.534f);
  printf("%-15s: %+02.f\n", "%+02.f", 8127.534f);
  printf("%-15s: %+02.0f\n", "%+02.0f", 8127.534f);
  printf("%-15s: %+02.1f\n", "%+02.1f", 8127.534f);
  printf("%-15s: %+02.2f\n", "%+02.2f", 8127.534f);
  printf("%-15s: %+02.5f\n", "%+02.5f", 8127.534f);
  printf("%-15s: %+02.10f\n", "%+02.10f", 8127.534f);
  printf("%-15s: %+02.30f\n", "%+02.30f", 8127.534f);
  printf("%-15s: %+05f\n", "%+05f", 8127.534f);
  printf("%-15s: %+05.f\n", "%+05.f", 8127.534f);
  printf("%-15s: %+05.0f\n", "%+05.0f", 8127.534f);
  printf("%-15s: %+05.1f\n", "%+05.1f", 8127.534f);
  printf("%-15s: %+05.2f\n", "%+05.2f", 8127.534f);
  printf("%-15s: %+05.5f\n", "%+05.5f", 8127.534f);
  printf("%-15s: %+05.10f\n", "%+05.10f", 8127.534f);
  printf("%-15s: %+05.30f\n", "%+05.30f", 8127.534f);
  printf("%-15s: %+010f\n", "%+010f", 8127.534f);
  printf("%-15s: %+010.f\n", "%+010.f", 8127.534f);
  printf("%-15s: %+010.0f\n", "%+010.0f", 8127.534f);
  printf("%-15s: %+010.1f\n", "%+010.1f", 8127.534f);
  printf("%-15s: %+010.2f\n", "%+010.2f", 8127.534f);
  printf("%-15s: %+010.5f\n", "%+010.5f", 8127.534f);
  printf("%-15s: %+010.10f\n", "%+010.10f", 8127.534f);
  printf("%-15s: %+010.30f\n", "%+010.30f", 8127.534f);
  printf("%-15s: %+030f\n", "%+030f", 8127.534f);
  printf("%-15s: %+030.f\n", "%+030.f", 8127.534f);
  printf("%-15s: %+030.0f\n", "%+030.0f", 8127.534f);
  printf("%-15s: %+030.1f\n", "%+030.1f", 8127.534f);
  printf("%-15s: %+030.2f\n", "%+030.2f", 8127.534f);
  printf("%-15s: %+030.5f\n", "%+030.5f", 8127.534f);
  printf("%-15s: %+030.10f\n", "%+030.10f", 8127.534f);
  printf("%-15s: %+030.30f\n", "%+030.30f", 8127.534f);
  printf("%-15s: %+-f\n", "%+-f", 8127.534f);
  printf("%-15s: %+-.f\n", "%+-.f", 8127.534f);
  printf("%-15s: %+-.0f\n", "%+-.0f", 8127.534f);
  printf("%-15s: %+-.1f\n", "%+-.1f", 8127.534f);
  printf("%-15s: %+-.2f\n", "%+-.2f", 8127.534f);
  printf("%-15s: %+-.5f\n", "%+-.5f", 8127.534f);
  printf("%-15s: %+-.10f\n", "%+-.10f", 8127.534f);
  printf("%-15s: %+-.30f\n", "%+-.30f", 8127.534f);
  printf("%-15s: %+-1f\n", "%+-1f", 8127.534f);
  printf("%-15s: %+-1.f\n", "%+-1.f", 8127.534f);
  printf("%-15s: %+-1.0f\n", "%+-1.0f", 8127.534f);
  printf("%-15s: %+-1.1f\n", "%+-1.1f", 8127.534f);
  printf("%-15s: %+-1.2f\n", "%+-1.2f", 8127.534f);
  printf("%-15s: %+-1.5f\n", "%+-1.5f", 8127.534f);
  printf("%-15s: %+-1.10f\n", "%+-1.10f", 8127.534f);
  printf("%-15s: %+-1.30f\n", "%+-1.30f", 8127.534f);
  printf("%-15s: %+-2f\n", "%+-2f", 8127.534f);
  printf("%-15s: %+-2.f\n", "%+-2.f", 8127.534f);
  printf("%-15s: %+-2.0f\n", "%+-2.0f", 8127.534f);
  printf("%-15s: %+-2.1f\n", "%+-2.1f", 8127.534f);
  printf("%-15s: %+-2.2f\n", "%+-2.2f", 8127.534f);
  printf("%-15s: %+-2.5f\n", "%+-2.5f", 8127.534f);
  printf("%-15s: %+-2.10f\n", "%+-2.10f", 8127.534f);
  printf("%-15s: %+-2.30f\n", "%+-2.30f", 8127.534f);
  printf("%-15s: %+-5f\n", "%+-5f", 8127.534f);
  printf("%-15s: %+-5.f\n", "%+-5.f", 8127.534f);
  printf("%-15s: %+-5.0f\n", "%+-5.0f", 8127.534f);
  printf("%-15s: %+-5.1f\n", "%+-5.1f", 8127.534f);
  printf("%-15s: %+-5.2f\n", "%+-5.2f", 8127.534f);
  printf("%-15s: %+-5.5f\n", "%+-5.5f", 8127.534f);
  printf("%-15s: %+-5.10f\n", "%+-5.10f", 8127.534f);
  printf("%-15s: %+-5.30f\n", "%+-5.30f", 8127.534f);
  printf("%-15s: %+-10f\n", "%+-10f", 8127.534f);
  printf("%-15s: %+-10.f\n", "%+-10.f", 8127.534f);
  printf("%-15s: %+-10.0f\n", "%+-10.0f", 8127.534f);
  printf("%-15s: %+-10.1f\n", "%+-10.1f", 8127.534f);
  printf("%-15s: %+-10.2f\n", "%+-10.2f", 8127.534f);
  printf("%-15s: %+-10.5f\n", "%+-10.5f", 8127.534f);
  printf("%-15s: %+-10.10f\n", "%+-10.10f", 8127.534f);
  printf("%-15s: %+-10.30f\n", "%+-10.30f", 8127.534f);
  printf("%-15s: %+-30f\n", "%+-30f", 8127.534f);
  printf("%-15s: %+-30.f\n", "%+-30.f", 8127.534f);
  printf("%-15s: %+-30.0f\n", "%+-30.0f", 8127.534f);
  printf("%-15s: %+-30.1f\n", "%+-30.1f", 8127.534f);
  printf("%-15s: %+-30.2f\n", "%+-30.2f", 8127.534f);
  printf("%-15s: %+-30.5f\n", "%+-30.5f", 8127.534f);
  printf("%-15s: %+-30.10f\n", "%+-30.10f", 8127.534f);
  printf("%-15s: %+-30.30f\n", "%+-30.30f", 8127.534f);
  printf("%-15s: %#-f\n", "%#-f", 8127.534f);
  printf("%-15s: %#-.f\n", "%#-.f", 8127.534f);
  printf("%-15s: %#-.0f\n", "%#-.0f", 8127.534f);
  printf("%-15s: %#-.1f\n", "%#-.1f", 8127.534f);
  printf("%-15s: %#-.2f\n", "%#-.2f", 8127.534f);
  printf("%-15s: %#-.5f\n", "%#-.5f", 8127.534f);
  printf("%-15s: %#-.10f\n", "%#-.10f", 8127.534f);
  printf("%-15s: %#-.30f\n", "%#-.30f", 8127.534f);
  printf("%-15s: %#-1f\n", "%#-1f", 8127.534f);
  printf("%-15s: %#-1.f\n", "%#-1.f", 8127.534f);
  printf("%-15s: %#-1.0f\n", "%#-1.0f", 8127.534f);
  printf("%-15s: %#-1.1f\n", "%#-1.1f", 8127.534f);
  printf("%-15s: %#-1.2f\n", "%#-1.2f", 8127.534f);
  printf("%-15s: %#-1.5f\n", "%#-1.5f", 8127.534f);
  printf("%-15s: %#-1.10f\n", "%#-1.10f", 8127.534f);
  printf("%-15s: %#-1.30f\n", "%#-1.30f", 8127.534f);
  printf("%-15s: %#-2f\n", "%#-2f", 8127.534f);
  printf("%-15s: %#-2.f\n", "%#-2.f", 8127.534f);
  printf("%-15s: %#-2.0f\n", "%#-2.0f", 8127.534f);
  printf("%-15s: %#-2.1f\n", "%#-2.1f", 8127.534f);
  printf("%-15s: %#-2.2f\n", "%#-2.2f", 8127.534f);
  printf("%-15s: %#-2.5f\n", "%#-2.5f", 8127.534f);
  printf("%-15s: %#-2.10f\n", "%#-2.10f", 8127.534f);
  printf("%-15s: %#-2.30f\n", "%#-2.30f", 8127.534f);
  printf("%-15s: %#-5f\n", "%#-5f", 8127.534f);
  printf("%-15s: %#-5.f\n", "%#-5.f", 8127.534f);
  printf("%-15s: %#-5.0f\n", "%#-5.0f", 8127.534f);
  printf("%-15s: %#-5.1f\n", "%#-5.1f", 8127.534f);
  printf("%-15s: %#-5.2f\n", "%#-5.2f", 8127.534f);
  printf("%-15s: %#-5.5f\n", "%#-5.5f", 8127.534f);
  printf("%-15s: %#-5.10f\n", "%#-5.10f", 8127.534f);
  printf("%-15s: %#-5.30f\n", "%#-5.30f", 8127.534f);
  printf("%-15s: %#-10f\n", "%#-10f", 8127.534f);
  printf("%-15s: %#-10.f\n", "%#-10.f", 8127.534f);
  printf("%-15s: %#-10.0f\n", "%#-10.0f", 8127.534f);
  printf("%-15s: %#-10.1f\n", "%#-10.1f", 8127.534f);
  printf("%-15s: %#-10.2f\n", "%#-10.2f", 8127.534f);
  printf("%-15s: %#-10.5f\n", "%#-10.5f", 8127.534f);
  printf("%-15s: %#-10.10f\n", "%#-10.10f", 8127.534f);
  printf("%-15s: %#-10.30f\n", "%#-10.30f", 8127.534f);
  printf("%-15s: %#-30f\n", "%#-30f", 8127.534f);
  printf("%-15s: %#-30.f\n", "%#-30.f", 8127.534f);
  printf("%-15s: %#-30.0f\n", "%#-30.0f", 8127.534f);
  printf("%-15s: %#-30.1f\n", "%#-30.1f", 8127.534f);
  printf("%-15s: %#-30.2f\n", "%#-30.2f", 8127.534f);
  printf("%-15s: %#-30.5f\n", "%#-30.5f", 8127.534f);
  printf("%-15s: %#-30.10f\n", "%#-30.10f", 8127.534f);
  printf("%-15s: %#-30.30f\n", "%#-30.30f", 8127.534f);
  printf("%-15s: %+#f\n", "%+#f", 8127.534f);
  printf("%-15s: %+#.f\n", "%+#.f", 8127.534f);
  printf("%-15s: %+#.0f\n", "%+#.0f", 8127.534f);
  printf("%-15s: %+#.1f\n", "%+#.1f", 8127.534f);
  printf("%-15s: %+#.2f\n", "%+#.2f", 8127.534f);
  printf("%-15s: %+#.5f\n", "%+#.5f", 8127.534f);
  printf("%-15s: %+#.10f\n", "%+#.10f", 8127.534f);
  printf("%-15s: %+#.30f\n", "%+#.30f", 8127.534f);
  printf("%-15s: %+#0f\n", "%+#0f", 8127.534f);
  printf("%-15s: %+#0.f\n", "%+#0.f", 8127.534f);
  printf("%-15s: %+#0.0f\n", "%+#0.0f", 8127.534f);
  printf("%-15s: %+#0.1f\n", "%+#0.1f", 8127.534f);
  printf("%-15s: %+#0.2f\n", "%+#0.2f", 8127.534f);
  printf("%-15s: %+#0.5f\n", "%+#0.5f", 8127.534f);
  printf("%-15s: %+#0.10f\n", "%+#0.10f", 8127.534f);
  printf("%-15s: %+#0.30f\n", "%+#0.30f", 8127.534f);
  printf("%-15s: %+#1f\n", "%+#1f", 8127.534f);
  printf("%-15s: %+#1.f\n", "%+#1.f", 8127.534f);
  printf("%-15s: %+#1.0f\n", "%+#1.0f", 8127.534f);
  printf("%-15s: %+#1.1f\n", "%+#1.1f", 8127.534f);
  printf("%-15s: %+#1.2f\n", "%+#1.2f", 8127.534f);
  printf("%-15s: %+#1.5f\n", "%+#1.5f", 8127.534f);
  printf("%-15s: %+#1.10f\n", "%+#1.10f", 8127.534f);
  printf("%-15s: %+#1.30f\n", "%+#1.30f", 8127.534f);
  printf("%-15s: %+#2f\n", "%+#2f", 8127.534f);
  printf("%-15s: %+#2.f\n", "%+#2.f", 8127.534f);
  printf("%-15s: %+#2.0f\n", "%+#2.0f", 8127.534f);
  printf("%-15s: %+#2.1f\n", "%+#2.1f", 8127.534f);
  printf("%-15s: %+#2.2f\n", "%+#2.2f", 8127.534f);
  printf("%-15s: %+#2.5f\n", "%+#2.5f", 8127.534f);
  printf("%-15s: %+#2.10f\n", "%+#2.10f", 8127.534f);
  printf("%-15s: %+#2.30f\n", "%+#2.30f", 8127.534f);
  printf("%-15s: %+#5f\n", "%+#5f", 8127.534f);
  printf("%-15s: %+#5.f\n", "%+#5.f", 8127.534f);
  printf("%-15s: %+#5.0f\n", "%+#5.0f", 8127.534f);
  printf("%-15s: %+#5.1f\n", "%+#5.1f", 8127.534f);
  printf("%-15s: %+#5.2f\n", "%+#5.2f", 8127.534f);
  printf("%-15s: %+#5.5f\n", "%+#5.5f", 8127.534f);
  printf("%-15s: %+#5.10f\n", "%+#5.10f", 8127.534f);
  printf("%-15s: %+#5.30f\n", "%+#5.30f", 8127.534f);
  printf("%-15s: %+#10f\n", "%+#10f", 8127.534f);
  printf("%-15s: %+#10.f\n", "%+#10.f", 8127.534f);
  printf("%-15s: %+#10.0f\n", "%+#10.0f", 8127.534f);
  printf("%-15s: %+#10.1f\n", "%+#10.1f", 8127.534f);
  printf("%-15s: %+#10.2f\n", "%+#10.2f", 8127.534f);
  printf("%-15s: %+#10.5f\n", "%+#10.5f", 8127.534f);
  printf("%-15s: %+#10.10f\n", "%+#10.10f", 8127.534f);
  printf("%-15s: %+#10.30f\n", "%+#10.30f", 8127.534f);
  printf("%-15s: %+#30f\n", "%+#30f", 8127.534f);
  printf("%-15s: %+#30.f\n", "%+#30.f", 8127.534f);
  printf("%-15s: %+#30.0f\n", "%+#30.0f", 8127.534f);
  printf("%-15s: %+#30.1f\n", "%+#30.1f", 8127.534f);
  printf("%-15s: %+#30.2f\n", "%+#30.2f", 8127.534f);
  printf("%-15s: %+#30.5f\n", "%+#30.5f", 8127.534f);
  printf("%-15s: %+#30.10f\n", "%+#30.10f", 8127.534f);
  printf("%-15s: %+#30.30f\n", "%+#30.30f", 8127.534f);
  printf("%-15s: %-#f\n", "%-#f", 8127.534f);
  printf("%-15s: %-#.f\n", "%-#.f", 8127.534f);
  printf("%-15s: %-#.0f\n", "%-#.0f", 8127.534f);
  printf("%-15s: %-#.1f\n", "%-#.1f", 8127.534f);
  printf("%-15s: %-#.2f\n", "%-#.2f", 8127.534f);
  printf("%-15s: %-#.5f\n", "%-#.5f", 8127.534f);
  printf("%-15s: %-#.10f\n", "%-#.10f", 8127.534f);
  printf("%-15s: %-#.30f\n", "%-#.30f", 8127.534f);
  printf("%-15s: %-#1f\n", "%-#1f", 8127.534f);
  printf("%-15s: %-#1.f\n", "%-#1.f", 8127.534f);
  printf("%-15s: %-#1.0f\n", "%-#1.0f", 8127.534f);
  printf("%-15s: %-#1.1f\n", "%-#1.1f", 8127.534f);
  printf("%-15s: %-#1.2f\n", "%-#1.2f", 8127.534f);
  printf("%-15s: %-#1.5f\n", "%-#1.5f", 8127.534f);
  printf("%-15s: %-#1.10f\n", "%-#1.10f", 8127.534f);
  printf("%-15s: %-#1.30f\n", "%-#1.30f", 8127.534f);
  printf("%-15s: %-#2f\n", "%-#2f", 8127.534f);
  printf("%-15s: %-#2.f\n", "%-#2.f", 8127.534f);
  printf("%-15s: %-#2.0f\n", "%-#2.0f", 8127.534f);
  printf("%-15s: %-#2.1f\n", "%-#2.1f", 8127.534f);
  printf("%-15s: %-#2.2f\n", "%-#2.2f", 8127.534f);
  printf("%-15s: %-#2.5f\n", "%-#2.5f", 8127.534f);
  printf("%-15s: %-#2.10f\n", "%-#2.10f", 8127.534f);
  printf("%-15s: %-#2.30f\n", "%-#2.30f", 8127.534f);
  printf("%-15s: %-#5f\n", "%-#5f", 8127.534f);
  printf("%-15s: %-#5.f\n", "%-#5.f", 8127.534f);
  printf("%-15s: %-#5.0f\n", "%-#5.0f", 8127.534f);
  printf("%-15s: %-#5.1f\n", "%-#5.1f", 8127.534f);
  printf("%-15s: %-#5.2f\n", "%-#5.2f", 8127.534f);
  printf("%-15s: %-#5.5f\n", "%-#5.5f", 8127.534f);
  printf("%-15s: %-#5.10f\n", "%-#5.10f", 8127.534f);
  printf("%-15s: %-#5.30f\n", "%-#5.30f", 8127.534f);
  printf("%-15s: %-#10f\n", "%-#10f", 8127.534f);
  printf("%-15s: %-#10.f\n", "%-#10.f", 8127.534f);
  printf("%-15s: %-#10.0f\n", "%-#10.0f", 8127.534f);
  printf("%-15s: %-#10.1f\n", "%-#10.1f", 8127.534f);
  printf("%-15s: %-#10.2f\n", "%-#10.2f", 8127.534f);
  printf("%-15s: %-#10.5f\n", "%-#10.5f", 8127.534f);
  printf("%-15s: %-#10.10f\n", "%-#10.10f", 8127.534f);
  printf("%-15s: %-#10.30f\n", "%-#10.30f", 8127.534f);
  printf("%-15s: %-#30f\n", "%-#30f", 8127.534f);
  printf("%-15s: %-#30.f\n", "%-#30.f", 8127.534f);
  printf("%-15s: %-#30.0f\n", "%-#30.0f", 8127.534f);
  printf("%-15s: %-#30.1f\n", "%-#30.1f", 8127.534f);
  printf("%-15s: %-#30.2f\n", "%-#30.2f", 8127.534f);
  printf("%-15s: %-#30.5f\n", "%-#30.5f", 8127.534f);
  printf("%-15s: %-#30.10f\n", "%-#30.10f", 8127.534f);
  printf("%-15s: %-#30.30f\n", "%-#30.30f", 8127.534f);
  printf("%-15s: %0#f\n", "%0#f", 8127.534f);
  printf("%-15s: %0#.f\n", "%0#.f", 8127.534f);
  printf("%-15s: %0#.0f\n", "%0#.0f", 8127.534f);
  printf("%-15s: %0#.1f\n", "%0#.1f", 8127.534f);
  printf("%-15s: %0#.2f\n", "%0#.2f", 8127.534f);
  printf("%-15s: %0#.5f\n", "%0#.5f", 8127.534f);
  printf("%-15s: %0#.10f\n", "%0#.10f", 8127.534f);
  printf("%-15s: %0#.30f\n", "%0#.30f", 8127.534f);
  printf("%-15s: %0#1f\n", "%0#1f", 8127.534f);
  printf("%-15s: %0#1.f\n", "%0#1.f", 8127.534f);
  printf("%-15s: %0#1.0f\n", "%0#1.0f", 8127.534f);
  printf("%-15s: %0#1.1f\n", "%0#1.1f", 8127.534f);
  printf("%-15s: %0#1.2f\n", "%0#1.2f", 8127.534f);
  printf("%-15s: %0#1.5f\n", "%0#1.5f", 8127.534f);
  printf("%-15s: %0#1.10f\n", "%0#1.10f", 8127.534f);
  printf("%-15s: %0#1.30f\n", "%0#1.30f", 8127.534f);
  printf("%-15s: %0#2f\n", "%0#2f", 8127.534f);
  printf("%-15s: %0#2.f\n", "%0#2.f", 8127.534f);
  printf("%-15s: %0#2.0f\n", "%0#2.0f", 8127.534f);
  printf("%-15s: %0#2.1f\n", "%0#2.1f", 8127.534f);
  printf("%-15s: %0#2.2f\n", "%0#2.2f", 8127.534f);
  printf("%-15s: %0#2.5f\n", "%0#2.5f", 8127.534f);
  printf("%-15s: %0#2.10f\n", "%0#2.10f", 8127.534f);
  printf("%-15s: %0#2.30f\n", "%0#2.30f", 8127.534f);
  printf("%-15s: %0#5f\n", "%0#5f", 8127.534f);
  printf("%-15s: %0#5.f\n", "%0#5.f", 8127.534f);
  printf("%-15s: %0#5.0f\n", "%0#5.0f", 8127.534f);
  printf("%-15s: %0#5.1f\n", "%0#5.1f", 8127.534f);
  printf("%-15s: %0#5.2f\n", "%0#5.2f", 8127.534f);
  printf("%-15s: %0#5.5f\n", "%0#5.5f", 8127.534f);
  printf("%-15s: %0#5.10f\n", "%0#5.10f", 8127.534f);
  printf("%-15s: %0#5.30f\n", "%0#5.30f", 8127.534f);
  printf("%-15s: %0#10f\n", "%0#10f", 8127.534f);
  printf("%-15s: %0#10.f\n", "%0#10.f", 8127.534f);
  printf("%-15s: %0#10.0f\n", "%0#10.0f", 8127.534f);
  printf("%-15s: %0#10.1f\n", "%0#10.1f", 8127.534f);
  printf("%-15s: %0#10.2f\n", "%0#10.2f", 8127.534f);
  printf("%-15s: %0#10.5f\n", "%0#10.5f", 8127.534f);
  printf("%-15s: %0#10.10f\n", "%0#10.10f", 8127.534f);
  printf("%-15s: %0#10.30f\n", "%0#10.30f", 8127.534f);
  printf("%-15s: %0#30f\n", "%0#30f", 8127.534f);
  printf("%-15s: %0#30.f\n", "%0#30.f", 8127.534f);
  printf("%-15s: %0#30.0f\n", "%0#30.0f", 8127.534f);
  printf("%-15s: %0#30.1f\n", "%0#30.1f", 8127.534f);
  printf("%-15s: %0#30.2f\n", "%0#30.2f", 8127.534f);
  printf("%-15s: %0#30.5f\n", "%0#30.5f", 8127.534f);
  printf("%-15s: %0#30.10f\n", "%0#30.10f", 8127.534f);
  printf("%-15s: %0#30.30f\n", "%0#30.30f", 8127.534f);
  printf("%-15s: %+0f\n", "%+0f", 8127.534f);
  printf("%-15s: %+0.f\n", "%+0.f", 8127.534f);
  printf("%-15s: %+0.0f\n", "%+0.0f", 8127.534f);
  printf("%-15s: %+0.1f\n", "%+0.1f", 8127.534f);
  printf("%-15s: %+0.2f\n", "%+0.2f", 8127.534f);
  printf("%-15s: %+0.5f\n", "%+0.5f", 8127.534f);
  printf("%-15s: %+0.10f\n", "%+0.10f", 8127.534f);
  printf("%-15s: %+0.30f\n", "%+0.30f", 8127.534f);
  printf("%-15s: %+01f\n", "%+01f", 8127.534f);
  printf("%-15s: %+01.f\n", "%+01.f", 8127.534f);
  printf("%-15s: %+01.0f\n", "%+01.0f", 8127.534f);
  printf("%-15s: %+01.1f\n", "%+01.1f", 8127.534f);
  printf("%-15s: %+01.2f\n", "%+01.2f", 8127.534f);
  printf("%-15s: %+01.5f\n", "%+01.5f", 8127.534f);
  printf("%-15s: %+01.10f\n", "%+01.10f", 8127.534f);
  printf("%-15s: %+01.30f\n", "%+01.30f", 8127.534f);
  printf("%-15s: %+02f\n", "%+02f", 8127.534f);
  printf("%-15s: %+02.f\n", "%+02.f", 8127.534f);
  printf("%-15s: %+02.0f\n", "%+02.0f", 8127.534f);
  printf("%-15s: %+02.1f\n", "%+02.1f", 8127.534f);
  printf("%-15s: %+02.2f\n", "%+02.2f", 8127.534f);
  printf("%-15s: %+02.5f\n", "%+02.5f", 8127.534f);
  printf("%-15s: %+02.10f\n", "%+02.10f", 8127.534f);
  printf("%-15s: %+02.30f\n", "%+02.30f", 8127.534f);
  printf("%-15s: %+05f\n", "%+05f", 8127.534f);
  printf("%-15s: %+05.f\n", "%+05.f", 8127.534f);
  printf("%-15s: %+05.0f\n", "%+05.0f", 8127.534f);
  printf("%-15s: %+05.1f\n", "%+05.1f", 8127.534f);
  printf("%-15s: %+05.2f\n", "%+05.2f", 8127.534f);
  printf("%-15s: %+05.5f\n", "%+05.5f", 8127.534f);
  printf("%-15s: %+05.10f\n", "%+05.10f", 8127.534f);
  printf("%-15s: %+05.30f\n", "%+05.30f", 8127.534f);
  printf("%-15s: %+010f\n", "%+010f", 8127.534f);
  printf("%-15s: %+010.f\n", "%+010.f", 8127.534f);
  printf("%-15s: %+010.0f\n", "%+010.0f", 8127.534f);
  printf("%-15s: %+010.1f\n", "%+010.1f", 8127.534f);
  printf("%-15s: %+010.2f\n", "%+010.2f", 8127.534f);
  printf("%-15s: %+010.5f\n", "%+010.5f", 8127.534f);
  printf("%-15s: %+010.10f\n", "%+010.10f", 8127.534f);
  printf("%-15s: %+010.30f\n", "%+010.30f", 8127.534f);
  printf("%-15s: %+030f\n", "%+030f", 8127.534f);
  printf("%-15s: %+030.f\n", "%+030.f", 8127.534f);
  printf("%-15s: %+030.0f\n", "%+030.0f", 8127.534f);
  printf("%-15s: %+030.1f\n", "%+030.1f", 8127.534f);
  printf("%-15s: %+030.2f\n", "%+030.2f", 8127.534f);
  printf("%-15s: %+030.5f\n", "%+030.5f", 8127.534f);
  printf("%-15s: %+030.10f\n", "%+030.10f", 8127.534f);
  printf("%-15s: %+030.30f\n", "%+030.30f", 8127.534f);
  printf("%-15s: %#0f\n", "%#0f", 8127.534f);
  printf("%-15s: %#0.f\n", "%#0.f", 8127.534f);
  printf("%-15s: %#0.0f\n", "%#0.0f", 8127.534f);
  printf("%-15s: %#0.1f\n", "%#0.1f", 8127.534f);
  printf("%-15s: %#0.2f\n", "%#0.2f", 8127.534f);
  printf("%-15s: %#0.5f\n", "%#0.5f", 8127.534f);
  printf("%-15s: %#0.10f\n", "%#0.10f", 8127.534f);
  printf("%-15s: %#0.30f\n", "%#0.30f", 8127.534f);
  printf("%-15s: %#01f\n", "%#01f", 8127.534f);
  printf("%-15s: %#01.f\n", "%#01.f", 8127.534f);
  printf("%-15s: %#01.0f\n", "%#01.0f", 8127.534f);
  printf("%-15s: %#01.1f\n", "%#01.1f", 8127.534f);
  printf("%-15s: %#01.2f\n", "%#01.2f", 8127.534f);
  printf("%-15s: %#01.5f\n", "%#01.5f", 8127.534f);
  printf("%-15s: %#01.10f\n", "%#01.10f", 8127.534f);
  printf("%-15s: %#01.30f\n", "%#01.30f", 8127.534f);
  printf("%-15s: %#02f\n", "%#02f", 8127.534f);
  printf("%-15s: %#02.f\n", "%#02.f", 8127.534f);
  printf("%-15s: %#02.0f\n", "%#02.0f", 8127.534f);
  printf("%-15s: %#02.1f\n", "%#02.1f", 8127.534f);
  printf("%-15s: %#02.2f\n", "%#02.2f", 8127.534f);
  printf("%-15s: %#02.5f\n", "%#02.5f", 8127.534f);
  printf("%-15s: %#02.10f\n", "%#02.10f", 8127.534f);
  printf("%-15s: %#02.30f\n", "%#02.30f", 8127.534f);
  printf("%-15s: %#05f\n", "%#05f", 8127.534f);
  printf("%-15s: %#05.f\n", "%#05.f", 8127.534f);
  printf("%-15s: %#05.0f\n", "%#05.0f", 8127.534f);
  printf("%-15s: %#05.1f\n", "%#05.1f", 8127.534f);
  printf("%-15s: %#05.2f\n", "%#05.2f", 8127.534f);
  printf("%-15s: %#05.5f\n", "%#05.5f", 8127.534f);
  printf("%-15s: %#05.10f\n", "%#05.10f", 8127.534f);
  printf("%-15s: %#05.30f\n", "%#05.30f", 8127.534f);
  printf("%-15s: %#010f\n", "%#010f", 8127.534f);
  printf("%-15s: %#010.f\n", "%#010.f", 8127.534f);
  printf("%-15s: %#010.0f\n", "%#010.0f", 8127.534f);
  printf("%-15s: %#010.1f\n", "%#010.1f", 8127.534f);
  printf("%-15s: %#010.2f\n", "%#010.2f", 8127.534f);
  printf("%-15s: %#010.5f\n", "%#010.5f", 8127.534f);
  printf("%-15s: %#010.10f\n", "%#010.10f", 8127.534f);
  printf("%-15s: %#010.30f\n", "%#010.30f", 8127.534f);
  printf("%-15s: %#030f\n", "%#030f", 8127.534f);
  printf("%-15s: %#030.f\n", "%#030.f", 8127.534f);
  printf("%-15s: %#030.0f\n", "%#030.0f", 8127.534f);
  printf("%-15s: %#030.1f\n", "%#030.1f", 8127.534f);
  printf("%-15s: %#030.2f\n", "%#030.2f", 8127.534f);
  printf("%-15s: %#030.5f\n", "%#030.5f", 8127.534f);
  printf("%-15s: %#030.10f\n", "%#030.10f", 8127.534f);
  printf("%-15s: %#030.30f\n", "%#030.30f", 8127.534f);
  printf("%-15s: %-+#f\n", "%-+#f", 8127.534f);
  printf("%-15s: %-+#.f\n", "%-+#.f", 8127.534f);
  printf("%-15s: %-+#.0f\n", "%-+#.0f", 8127.534f);
  printf("%-15s: %-+#.1f\n", "%-+#.1f", 8127.534f);
  printf("%-15s: %-+#.2f\n", "%-+#.2f", 8127.534f);
  printf("%-15s: %-+#.5f\n", "%-+#.5f", 8127.534f);
  printf("%-15s: %-+#.10f\n", "%-+#.10f", 8127.534f);
  printf("%-15s: %-+#.30f\n", "%-+#.30f", 8127.534f);
  printf("%-15s: %-+#1f\n", "%-+#1f", 8127.534f);
  printf("%-15s: %-+#1.f\n", "%-+#1.f", 8127.534f);
  printf("%-15s: %-+#1.0f\n", "%-+#1.0f", 8127.534f);
  printf("%-15s: %-+#1.1f\n", "%-+#1.1f", 8127.534f);
  printf("%-15s: %-+#1.2f\n", "%-+#1.2f", 8127.534f);
  printf("%-15s: %-+#1.5f\n", "%-+#1.5f", 8127.534f);
  printf("%-15s: %-+#1.10f\n", "%-+#1.10f", 8127.534f);
  printf("%-15s: %-+#1.30f\n", "%-+#1.30f", 8127.534f);
  printf("%-15s: %-+#2f\n", "%-+#2f", 8127.534f);
  printf("%-15s: %-+#2.f\n", "%-+#2.f", 8127.534f);
  printf("%-15s: %-+#2.0f\n", "%-+#2.0f", 8127.534f);
  printf("%-15s: %-+#2.1f\n", "%-+#2.1f", 8127.534f);
  printf("%-15s: %-+#2.2f\n", "%-+#2.2f", 8127.534f);
  printf("%-15s: %-+#2.5f\n", "%-+#2.5f", 8127.534f);
  printf("%-15s: %-+#2.10f\n", "%-+#2.10f", 8127.534f);
  printf("%-15s: %-+#2.30f\n", "%-+#2.30f", 8127.534f);
  printf("%-15s: %-+#5f\n", "%-+#5f", 8127.534f);
  printf("%-15s: %-+#5.f\n", "%-+#5.f", 8127.534f);
  printf("%-15s: %-+#5.0f\n", "%-+#5.0f", 8127.534f);
  printf("%-15s: %-+#5.1f\n", "%-+#5.1f", 8127.534f);
  printf("%-15s: %-+#5.2f\n", "%-+#5.2f", 8127.534f);
  printf("%-15s: %-+#5.5f\n", "%-+#5.5f", 8127.534f);
  printf("%-15s: %-+#5.10f\n", "%-+#5.10f", 8127.534f);
  printf("%-15s: %-+#5.30f\n", "%-+#5.30f", 8127.534f);
  printf("%-15s: %-+#10f\n", "%-+#10f", 8127.534f);
  printf("%-15s: %-+#10.f\n", "%-+#10.f", 8127.534f);
  printf("%-15s: %-+#10.0f\n", "%-+#10.0f", 8127.534f);
  printf("%-15s: %-+#10.1f\n", "%-+#10.1f", 8127.534f);
  printf("%-15s: %-+#10.2f\n", "%-+#10.2f", 8127.534f);
  printf("%-15s: %-+#10.5f\n", "%-+#10.5f", 8127.534f);
  printf("%-15s: %-+#10.10f\n", "%-+#10.10f", 8127.534f);
  printf("%-15s: %-+#10.30f\n", "%-+#10.30f", 8127.534f);
  printf("%-15s: %-+#30f\n", "%-+#30f", 8127.534f);
  printf("%-15s: %-+#30.f\n", "%-+#30.f", 8127.534f);
  printf("%-15s: %-+#30.0f\n", "%-+#30.0f", 8127.534f);
  printf("%-15s: %-+#30.1f\n", "%-+#30.1f", 8127.534f);
  printf("%-15s: %-+#30.2f\n", "%-+#30.2f", 8127.534f);
  printf("%-15s: %-+#30.5f\n", "%-+#30.5f", 8127.534f);
  printf("%-15s: %-+#30.10f\n", "%-+#30.10f", 8127.534f);
  printf("%-15s: %-+#30.30f\n", "%-+#30.30f", 8127.534f);
  printf("%-15s: %0+#f\n", "%0+#f", 8127.534f);
  printf("%-15s: %0+#.f\n", "%0+#.f", 8127.534f);
  printf("%-15s: %0+#.0f\n", "%0+#.0f", 8127.534f);
  printf("%-15s: %0+#.1f\n", "%0+#.1f", 8127.534f);
  printf("%-15s: %0+#.2f\n", "%0+#.2f", 8127.534f);
  printf("%-15s: %0+#.5f\n", "%0+#.5f", 8127.534f);
  printf("%-15s: %0+#.10f\n", "%0+#.10f", 8127.534f);
  printf("%-15s: %0+#.30f\n", "%0+#.30f", 8127.534f);
  printf("%-15s: %0+#1f\n", "%0+#1f", 8127.534f);
  printf("%-15s: %0+#1.f\n", "%0+#1.f", 8127.534f);
  printf("%-15s: %0+#1.0f\n", "%0+#1.0f", 8127.534f);
  printf("%-15s: %0+#1.1f\n", "%0+#1.1f", 8127.534f);
  printf("%-15s: %0+#1.2f\n", "%0+#1.2f", 8127.534f);
  printf("%-15s: %0+#1.5f\n", "%0+#1.5f", 8127.534f);
  printf("%-15s: %0+#1.10f\n", "%0+#1.10f", 8127.534f);
  printf("%-15s: %0+#1.30f\n", "%0+#1.30f", 8127.534f);
  printf("%-15s: %0+#2f\n", "%0+#2f", 8127.534f);
  printf("%-15s: %0+#2.f\n", "%0+#2.f", 8127.534f);
  printf("%-15s: %0+#2.0f\n", "%0+#2.0f", 8127.534f);
  printf("%-15s: %0+#2.1f\n", "%0+#2.1f", 8127.534f);
  printf("%-15s: %0+#2.2f\n", "%0+#2.2f", 8127.534f);
  printf("%-15s: %0+#2.5f\n", "%0+#2.5f", 8127.534f);
  printf("%-15s: %0+#2.10f\n", "%0+#2.10f", 8127.534f);
  printf("%-15s: %0+#2.30f\n", "%0+#2.30f", 8127.534f);
  printf("%-15s: %0+#5f\n", "%0+#5f", 8127.534f);
  printf("%-15s: %0+#5.f\n", "%0+#5.f", 8127.534f);
  printf("%-15s: %0+#5.0f\n", "%0+#5.0f", 8127.534f);
  printf("%-15s: %0+#5.1f\n", "%0+#5.1f", 8127.534f);
  printf("%-15s: %0+#5.2f\n", "%0+#5.2f", 8127.534f);
  printf("%-15s: %0+#5.5f\n", "%0+#5.5f", 8127.534f);
  printf("%-15s: %0+#5.10f\n", "%0+#5.10f", 8127.534f);
  printf("%-15s: %0+#5.30f\n", "%0+#5.30f", 8127.534f);
  printf("%-15s: %0+#10f\n", "%0+#10f", 8127.534f);
  printf("%-15s: %0+#10.f\n", "%0+#10.f", 8127.534f);
  printf("%-15s: %0+#10.0f\n", "%0+#10.0f", 8127.534f);
  printf("%-15s: %0+#10.1f\n", "%0+#10.1f", 8127.534f);
  printf("%-15s: %0+#10.2f\n", "%0+#10.2f", 8127.534f);
  printf("%-15s: %0+#10.5f\n", "%0+#10.5f", 8127.534f);
  printf("%-15s: %0+#10.10f\n", "%0+#10.10f", 8127.534f);
  printf("%-15s: %0+#10.30f\n", "%0+#10.30f", 8127.534f);
  printf("%-15s: %0+#30f\n", "%0+#30f", 8127.534f);
  printf("%-15s: %0+#30.f\n", "%0+#30.f", 8127.534f);
  printf("%-15s: %0+#30.0f\n", "%0+#30.0f", 8127.534f);
  printf("%-15s: %0+#30.1f\n", "%0+#30.1f", 8127.534f);
  printf("%-15s: %0+#30.2f\n", "%0+#30.2f", 8127.534f);
  printf("%-15s: %0+#30.5f\n", "%0+#30.5f", 8127.534f);
  printf("%-15s: %0+#30.10f\n", "%0+#30.10f", 8127.534f);
  printf("%-15s: %0+#30.30f\n", "%0+#30.30f", 8127.534f);
  printf("%-15s: %#-+f\n", "%#-+f", 8127.534f);
  printf("%-15s: %#-+.f\n", "%#-+.f", 8127.534f);
  printf("%-15s: %#-+.0f\n", "%#-+.0f", 8127.534f);
  printf("%-15s: %#-+.1f\n", "%#-+.1f", 8127.534f);
  printf("%-15s: %#-+.2f\n", "%#-+.2f", 8127.534f);
  printf("%-15s: %#-+.5f\n", "%#-+.5f", 8127.534f);
  printf("%-15s: %#-+.10f\n", "%#-+.10f", 8127.534f);
  printf("%-15s: %#-+.30f\n", "%#-+.30f", 8127.534f);
  printf("%-15s: %#-+1f\n", "%#-+1f", 8127.534f);
  printf("%-15s: %#-+1.f\n", "%#-+1.f", 8127.534f);
  printf("%-15s: %#-+1.0f\n", "%#-+1.0f", 8127.534f);
  printf("%-15s: %#-+1.1f\n", "%#-+1.1f", 8127.534f);
  printf("%-15s: %#-+1.2f\n", "%#-+1.2f", 8127.534f);
  printf("%-15s: %#-+1.5f\n", "%#-+1.5f", 8127.534f);
  printf("%-15s: %#-+1.10f\n", "%#-+1.10f", 8127.534f);
  printf("%-15s: %#-+1.30f\n", "%#-+1.30f", 8127.534f);
  printf("%-15s: %#-+2f\n", "%#-+2f", 8127.534f);
  printf("%-15s: %#-+2.f\n", "%#-+2.f", 8127.534f);
  printf("%-15s: %#-+2.0f\n", "%#-+2.0f", 8127.534f);
  printf("%-15s: %#-+2.1f\n", "%#-+2.1f", 8127.534f);
  printf("%-15s: %#-+2.2f\n", "%#-+2.2f", 8127.534f);
  printf("%-15s: %#-+2.5f\n", "%#-+2.5f", 8127.534f);
  printf("%-15s: %#-+2.10f\n", "%#-+2.10f", 8127.534f);
  printf("%-15s: %#-+2.30f\n", "%#-+2.30f", 8127.534f);
  printf("%-15s: %#-+5f\n", "%#-+5f", 8127.534f);
  printf("%-15s: %#-+5.f\n", "%#-+5.f", 8127.534f);
  printf("%-15s: %#-+5.0f\n", "%#-+5.0f", 8127.534f);
  printf("%-15s: %#-+5.1f\n", "%#-+5.1f", 8127.534f);
  printf("%-15s: %#-+5.2f\n", "%#-+5.2f", 8127.534f);
  printf("%-15s: %#-+5.5f\n", "%#-+5.5f", 8127.534f);
  printf("%-15s: %#-+5.10f\n", "%#-+5.10f", 8127.534f);
  printf("%-15s: %#-+5.30f\n", "%#-+5.30f", 8127.534f);
  printf("%-15s: %#-+10f\n", "%#-+10f", 8127.534f);
  printf("%-15s: %#-+10.f\n", "%#-+10.f", 8127.534f);
  printf("%-15s: %#-+10.0f\n", "%#-+10.0f", 8127.534f);
  printf("%-15s: %#-+10.1f\n", "%#-+10.1f", 8127.534f);
  printf("%-15s: %#-+10.2f\n", "%#-+10.2f", 8127.534f);
  printf("%-15s: %#-+10.5f\n", "%#-+10.5f", 8127.534f);
  printf("%-15s: %#-+10.10f\n", "%#-+10.10f", 8127.534f);
  printf("%-15s: %#-+10.30f\n", "%#-+10.30f", 8127.534f);
  printf("%-15s: %#-+30f\n", "%#-+30f", 8127.534f);
  printf("%-15s: %#-+30.f\n", "%#-+30.f", 8127.534f);
  printf("%-15s: %#-+30.0f\n", "%#-+30.0f", 8127.534f);
  printf("%-15s: %#-+30.1f\n", "%#-+30.1f", 8127.534f);
  printf("%-15s: %#-+30.2f\n", "%#-+30.2f", 8127.534f);
  printf("%-15s: %#-+30.5f\n", "%#-+30.5f", 8127.534f);
  printf("%-15s: %#-+30.10f\n", "%#-+30.10f", 8127.534f);
  printf("%-15s: %#-+30.30f\n", "%#-+30.30f", 8127.534f);
  printf("%-15s: %+#-f\n", "%+#-f", 8127.534f);
  printf("%-15s: %+#-.f\n", "%+#-.f", 8127.534f);
  printf("%-15s: %+#-.0f\n", "%+#-.0f", 8127.534f);
  printf("%-15s: %+#-.1f\n", "%+#-.1f", 8127.534f);
  printf("%-15s: %+#-.2f\n", "%+#-.2f", 8127.534f);
  printf("%-15s: %+#-.5f\n", "%+#-.5f", 8127.534f);
  printf("%-15s: %+#-.10f\n", "%+#-.10f", 8127.534f);
  printf("%-15s: %+#-.30f\n", "%+#-.30f", 8127.534f);
  printf("%-15s: %+#-1f\n", "%+#-1f", 8127.534f);
  printf("%-15s: %+#-1.f\n", "%+#-1.f", 8127.534f);
  printf("%-15s: %+#-1.0f\n", "%+#-1.0f", 8127.534f);
  printf("%-15s: %+#-1.1f\n", "%+#-1.1f", 8127.534f);
  printf("%-15s: %+#-1.2f\n", "%+#-1.2f", 8127.534f);
  printf("%-15s: %+#-1.5f\n", "%+#-1.5f", 8127.534f);
  printf("%-15s: %+#-1.10f\n", "%+#-1.10f", 8127.534f);
  printf("%-15s: %+#-1.30f\n", "%+#-1.30f", 8127.534f);
  printf("%-15s: %+#-2f\n", "%+#-2f", 8127.534f);
  printf("%-15s: %+#-2.f\n", "%+#-2.f", 8127.534f);
  printf("%-15s: %+#-2.0f\n", "%+#-2.0f", 8127.534f);
  printf("%-15s: %+#-2.1f\n", "%+#-2.1f", 8127.534f);
  printf("%-15s: %+#-2.2f\n", "%+#-2.2f", 8127.534f);
  printf("%-15s: %+#-2.5f\n", "%+#-2.5f", 8127.534f);
  printf("%-15s: %+#-2.10f\n", "%+#-2.10f", 8127.534f);
  printf("%-15s: %+#-2.30f\n", "%+#-2.30f", 8127.534f);
  printf("%-15s: %+#-5f\n", "%+#-5f", 8127.534f);
  printf("%-15s: %+#-5.f\n", "%+#-5.f", 8127.534f);
  printf("%-15s: %+#-5.0f\n", "%+#-5.0f", 8127.534f);
  printf("%-15s: %+#-5.1f\n", "%+#-5.1f", 8127.534f);
  printf("%-15s: %+#-5.2f\n", "%+#-5.2f", 8127.534f);
  printf("%-15s: %+#-5.5f\n", "%+#-5.5f", 8127.534f);
  printf("%-15s: %+#-5.10f\n", "%+#-5.10f", 8127.534f);
  printf("%-15s: %+#-5.30f\n", "%+#-5.30f", 8127.534f);
  printf("%-15s: %+#-10f\n", "%+#-10f", 8127.534f);
  printf("%-15s: %+#-10.f\n", "%+#-10.f", 8127.534f);
  printf("%-15s: %+#-10.0f\n", "%+#-10.0f", 8127.534f);
  printf("%-15s: %+#-10.1f\n", "%+#-10.1f", 8127.534f);
  printf("%-15s: %+#-10.2f\n", "%+#-10.2f", 8127.534f);
  printf("%-15s: %+#-10.5f\n", "%+#-10.5f", 8127.534f);
  printf("%-15s: %+#-10.10f\n", "%+#-10.10f", 8127.534f);
  printf("%-15s: %+#-10.30f\n", "%+#-10.30f", 8127.534f);
  printf("%-15s: %+#-30f\n", "%+#-30f", 8127.534f);
  printf("%-15s: %+#-30.f\n", "%+#-30.f", 8127.534f);
  printf("%-15s: %+#-30.0f\n", "%+#-30.0f", 8127.534f);
  printf("%-15s: %+#-30.1f\n", "%+#-30.1f", 8127.534f);
  printf("%-15s: %+#-30.2f\n", "%+#-30.2f", 8127.534f);
  printf("%-15s: %+#-30.5f\n", "%+#-30.5f", 8127.534f);
  printf("%-15s: %+#-30.10f\n", "%+#-30.10f", 8127.534f);
  printf("%-15s: %+#-30.30f\n", "%+#-30.30f", 8127.534f);
  printf("%-15s: %+lf\n", "%+lf", 8127.534);
  printf("%-15s: %+.lf\n", "%+.lf", 8127.534);
  printf("%-15s: %+.0lf\n", "%+.0lf", 8127.534);
  printf("%-15s: %+.1lf\n", "%+.1lf", 8127.534);
  printf("%-15s: %+.2lf\n", "%+.2lf", 8127.534);
  printf("%-15s: %+.5lf\n", "%+.5lf", 8127.534);
  printf("%-15s: %+.10lf\n", "%+.10lf", 8127.534);
  printf("%-15s: %+.30lf\n", "%+.30lf", 8127.534);
  printf("%-15s: %+0lf\n", "%+0lf", 8127.534);
  printf("%-15s: %+0.lf\n", "%+0.lf", 8127.534);
  printf("%-15s: %+0.0lf\n", "%+0.0lf", 8127.534);
  printf("%-15s: %+0.1lf\n", "%+0.1lf", 8127.534);
  printf("%-15s: %+0.2lf\n", "%+0.2lf", 8127.534);
  printf("%-15s: %+0.5lf\n", "%+0.5lf", 8127.534);
  printf("%-15s: %+0.10lf\n", "%+0.10lf", 8127.534);
  printf("%-15s: %+0.30lf\n", "%+0.30lf", 8127.534);
  printf("%-15s: %+1lf\n", "%+1lf", 8127.534);
  printf("%-15s: %+1.lf\n", "%+1.lf", 8127.534);
  printf("%-15s: %+1.0lf\n", "%+1.0lf", 8127.534);
  printf("%-15s: %+1.1lf\n", "%+1.1lf", 8127.534);
  printf("%-15s: %+1.2lf\n", "%+1.2lf", 8127.534);
  printf("%-15s: %+1.5lf\n", "%+1.5lf", 8127.534);
  printf("%-15s: %+1.10lf\n", "%+1.10lf", 8127.534);
  printf("%-15s: %+1.30lf\n", "%+1.30lf", 8127.534);
  printf("%-15s: %+2lf\n", "%+2lf", 8127.534);
  printf("%-15s: %+2.lf\n", "%+2.lf", 8127.534);
  printf("%-15s: %+2.0lf\n", "%+2.0lf", 8127.534);
  printf("%-15s: %+2.1lf\n", "%+2.1lf", 8127.534);
  printf("%-15s: %+2.2lf\n", "%+2.2lf", 8127.534);
  printf("%-15s: %+2.5lf\n", "%+2.5lf", 8127.534);
  printf("%-15s: %+2.10lf\n", "%+2.10lf", 8127.534);
  printf("%-15s: %+2.30lf\n", "%+2.30lf", 8127.534);
  printf("%-15s: %+5lf\n", "%+5lf", 8127.534);
  printf("%-15s: %+5.lf\n", "%+5.lf", 8127.534);
  printf("%-15s: %+5.0lf\n", "%+5.0lf", 8127.534);
  printf("%-15s: %+5.1lf\n", "%+5.1lf", 8127.534);
  printf("%-15s: %+5.2lf\n", "%+5.2lf", 8127.534);
  printf("%-15s: %+5.5lf\n", "%+5.5lf", 8127.534);
  printf("%-15s: %+5.10lf\n", "%+5.10lf", 8127.534);
  printf("%-15s: %+5.30lf\n", "%+5.30lf", 8127.534);
  printf("%-15s: %+10lf\n", "%+10lf", 8127.534);
  printf("%-15s: %+10.lf\n", "%+10.lf", 8127.534);
  printf("%-15s: %+10.0lf\n", "%+10.0lf", 8127.534);
  printf("%-15s: %+10.1lf\n", "%+10.1lf", 8127.534);
  printf("%-15s: %+10.2lf\n", "%+10.2lf", 8127.534);
  printf("%-15s: %+10.5lf\n", "%+10.5lf", 8127.534);
  printf("%-15s: %+10.10lf\n", "%+10.10lf", 8127.534);
  printf("%-15s: %+10.30lf\n", "%+10.30lf", 8127.534);
  printf("%-15s: %+30lf\n", "%+30lf", 8127.534);
  printf("%-15s: %+30.lf\n", "%+30.lf", 8127.534);
  printf("%-15s: %+30.0lf\n", "%+30.0lf", 8127.534);
  printf("%-15s: %+30.1lf\n", "%+30.1lf", 8127.534);
  printf("%-15s: %+30.2lf\n", "%+30.2lf", 8127.534);
  printf("%-15s: %+30.5lf\n", "%+30.5lf", 8127.534);
  printf("%-15s: %+30.10lf\n", "%+30.10lf", 8127.534);
  printf("%-15s: %+30.30lf\n", "%+30.30lf", 8127.534);
  printf("%-15s: %-lf\n", "%-lf", 8127.534);
  printf("%-15s: %-.lf\n", "%-.lf", 8127.534);
  printf("%-15s: %-.0lf\n", "%-.0lf", 8127.534);
  printf("%-15s: %-.1lf\n", "%-.1lf", 8127.534);
  printf("%-15s: %-.2lf\n", "%-.2lf", 8127.534);
  printf("%-15s: %-.5lf\n", "%-.5lf", 8127.534);
  printf("%-15s: %-.10lf\n", "%-.10lf", 8127.534);
  printf("%-15s: %-.30lf\n", "%-.30lf", 8127.534);
  printf("%-15s: %-1lf\n", "%-1lf", 8127.534);
  printf("%-15s: %-1.lf\n", "%-1.lf", 8127.534);
  printf("%-15s: %-1.0lf\n", "%-1.0lf", 8127.534);
  printf("%-15s: %-1.1lf\n", "%-1.1lf", 8127.534);
  printf("%-15s: %-1.2lf\n", "%-1.2lf", 8127.534);
  printf("%-15s: %-1.5lf\n", "%-1.5lf", 8127.534);
  printf("%-15s: %-1.10lf\n", "%-1.10lf", 8127.534);
  printf("%-15s: %-1.30lf\n", "%-1.30lf", 8127.534);
  printf("%-15s: %-2lf\n", "%-2lf", 8127.534);
  printf("%-15s: %-2.lf\n", "%-2.lf", 8127.534);
  printf("%-15s: %-2.0lf\n", "%-2.0lf", 8127.534);
  printf("%-15s: %-2.1lf\n", "%-2.1lf", 8127.534);
  printf("%-15s: %-2.2lf\n", "%-2.2lf", 8127.534);
  printf("%-15s: %-2.5lf\n", "%-2.5lf", 8127.534);
  printf("%-15s: %-2.10lf\n", "%-2.10lf", 8127.534);
  printf("%-15s: %-2.30lf\n", "%-2.30lf", 8127.534);
  printf("%-15s: %-5lf\n", "%-5lf", 8127.534);
  printf("%-15s: %-5.lf\n", "%-5.lf", 8127.534);
  printf("%-15s: %-5.0lf\n", "%-5.0lf", 8127.534);
  printf("%-15s: %-5.1lf\n", "%-5.1lf", 8127.534);
  printf("%-15s: %-5.2lf\n", "%-5.2lf", 8127.534);
  printf("%-15s: %-5.5lf\n", "%-5.5lf", 8127.534);
  printf("%-15s: %-5.10lf\n", "%-5.10lf", 8127.534);
  printf("%-15s: %-5.30lf\n", "%-5.30lf", 8127.534);
  printf("%-15s: %-10lf\n", "%-10lf", 8127.534);
  printf("%-15s: %-10.lf\n", "%-10.lf", 8127.534);
  printf("%-15s: %-10.0lf\n", "%-10.0lf", 8127.534);
  printf("%-15s: %-10.1lf\n", "%-10.1lf", 8127.534);
  printf("%-15s: %-10.2lf\n", "%-10.2lf", 8127.534);
  printf("%-15s: %-10.5lf\n", "%-10.5lf", 8127.534);
  printf("%-15s: %-10.10lf\n", "%-10.10lf", 8127.534);
  printf("%-15s: %-10.30lf\n", "%-10.30lf", 8127.534);
  printf("%-15s: %-30lf\n", "%-30lf", 8127.534);
  printf("%-15s: %-30.lf\n", "%-30.lf", 8127.534);
  printf("%-15s: %-30.0lf\n", "%-30.0lf", 8127.534);
  printf("%-15s: %-30.1lf\n", "%-30.1lf", 8127.534);
  printf("%-15s: %-30.2lf\n", "%-30.2lf", 8127.534);
  printf("%-15s: %-30.5lf\n", "%-30.5lf", 8127.534);
  printf("%-15s: %-30.10lf\n", "%-30.10lf", 8127.534);
  printf("%-15s: %-30.30lf\n", "%-30.30lf", 8127.534);
  printf("%-15s: %#lf\n", "%#lf", 8127.534);
  printf("%-15s: %#.lf\n", "%#.lf", 8127.534);
  printf("%-15s: %#.0lf\n", "%#.0lf", 8127.534);
  printf("%-15s: %#.1lf\n", "%#.1lf", 8127.534);
  printf("%-15s: %#.2lf\n", "%#.2lf", 8127.534);
  printf("%-15s: %#.5lf\n", "%#.5lf", 8127.534);
  printf("%-15s: %#.10lf\n", "%#.10lf", 8127.534);
  printf("%-15s: %#.30lf\n", "%#.30lf", 8127.534);
  printf("%-15s: %#0lf\n", "%#0lf", 8127.534);
  printf("%-15s: %#0.lf\n", "%#0.lf", 8127.534);
  printf("%-15s: %#0.0lf\n", "%#0.0lf", 8127.534);
  printf("%-15s: %#0.1lf\n", "%#0.1lf", 8127.534);
  printf("%-15s: %#0.2lf\n", "%#0.2lf", 8127.534);
  printf("%-15s: %#0.5lf\n", "%#0.5lf", 8127.534);
  printf("%-15s: %#0.10lf\n", "%#0.10lf", 8127.534);
  printf("%-15s: %#0.30lf\n", "%#0.30lf", 8127.534);
  printf("%-15s: %#1lf\n", "%#1lf", 8127.534);
  printf("%-15s: %#1.lf\n", "%#1.lf", 8127.534);
  printf("%-15s: %#1.0lf\n", "%#1.0lf", 8127.534);
  printf("%-15s: %#1.1lf\n", "%#1.1lf", 8127.534);
  printf("%-15s: %#1.2lf\n", "%#1.2lf", 8127.534);
  printf("%-15s: %#1.5lf\n", "%#1.5lf", 8127.534);
  printf("%-15s: %#1.10lf\n", "%#1.10lf", 8127.534);
  printf("%-15s: %#1.30lf\n", "%#1.30lf", 8127.534);
  printf("%-15s: %#2lf\n", "%#2lf", 8127.534);
  printf("%-15s: %#2.lf\n", "%#2.lf", 8127.534);
  printf("%-15s: %#2.0lf\n", "%#2.0lf", 8127.534);
  printf("%-15s: %#2.1lf\n", "%#2.1lf", 8127.534);
  printf("%-15s: %#2.2lf\n", "%#2.2lf", 8127.534);
  printf("%-15s: %#2.5lf\n", "%#2.5lf", 8127.534);
  printf("%-15s: %#2.10lf\n", "%#2.10lf", 8127.534);
  printf("%-15s: %#2.30lf\n", "%#2.30lf", 8127.534);
  printf("%-15s: %#5lf\n", "%#5lf", 8127.534);
  printf("%-15s: %#5.lf\n", "%#5.lf", 8127.534);
  printf("%-15s: %#5.0lf\n", "%#5.0lf", 8127.534);
  printf("%-15s: %#5.1lf\n", "%#5.1lf", 8127.534);
  printf("%-15s: %#5.2lf\n", "%#5.2lf", 8127.534);
  printf("%-15s: %#5.5lf\n", "%#5.5lf", 8127.534);
  printf("%-15s: %#5.10lf\n", "%#5.10lf", 8127.534);
  printf("%-15s: %#5.30lf\n", "%#5.30lf", 8127.534);
  printf("%-15s: %#10lf\n", "%#10lf", 8127.534);
  printf("%-15s: %#10.lf\n", "%#10.lf", 8127.534);
  printf("%-15s: %#10.0lf\n", "%#10.0lf", 8127.534);
  printf("%-15s: %#10.1lf\n", "%#10.1lf", 8127.534);
  printf("%-15s: %#10.2lf\n", "%#10.2lf", 8127.534);
  printf("%-15s: %#10.5lf\n", "%#10.5lf", 8127.534);
  printf("%-15s: %#10.10lf\n", "%#10.10lf", 8127.534);
  printf("%-15s: %#10.30lf\n", "%#10.30lf", 8127.534);
  printf("%-15s: %#30lf\n", "%#30lf", 8127.534);
  printf("%-15s: %#30.lf\n", "%#30.lf", 8127.534);
  printf("%-15s: %#30.0lf\n", "%#30.0lf", 8127.534);
  printf("%-15s: %#30.1lf\n", "%#30.1lf", 8127.534);
  printf("%-15s: %#30.2lf\n", "%#30.2lf", 8127.534);
  printf("%-15s: %#30.5lf\n", "%#30.5lf", 8127.534);
  printf("%-15s: %#30.10lf\n", "%#30.10lf", 8127.534);
  printf("%-15s: %#30.30lf\n", "%#30.30lf", 8127.534);
  printf("%-15s: %0lf\n", "%0lf", 8127.534);
  printf("%-15s: %0.lf\n", "%0.lf", 8127.534);
  printf("%-15s: %0.0lf\n", "%0.0lf", 8127.534);
  printf("%-15s: %0.1lf\n", "%0.1lf", 8127.534);
  printf("%-15s: %0.2lf\n", "%0.2lf", 8127.534);
  printf("%-15s: %0.5lf\n", "%0.5lf", 8127.534);
  printf("%-15s: %0.10lf\n", "%0.10lf", 8127.534);
  printf("%-15s: %0.30lf\n", "%0.30lf", 8127.534);
  printf("%-15s: %01lf\n", "%01lf", 8127.534);
  printf("%-15s: %01.lf\n", "%01.lf", 8127.534);
  printf("%-15s: %01.0lf\n", "%01.0lf", 8127.534);
  printf("%-15s: %01.1lf\n", "%01.1lf", 8127.534);
  printf("%-15s: %01.2lf\n", "%01.2lf", 8127.534);
  printf("%-15s: %01.5lf\n", "%01.5lf", 8127.534);
  printf("%-15s: %01.10lf\n", "%01.10lf", 8127.534);
  printf("%-15s: %01.30lf\n", "%01.30lf", 8127.534);
  printf("%-15s: %02lf\n", "%02lf", 8127.534);
  printf("%-15s: %02.lf\n", "%02.lf", 8127.534);
  printf("%-15s: %02.0lf\n", "%02.0lf", 8127.534);
  printf("%-15s: %02.1lf\n", "%02.1lf", 8127.534);
  printf("%-15s: %02.2lf\n", "%02.2lf", 8127.534);
  printf("%-15s: %02.5lf\n", "%02.5lf", 8127.534);
  printf("%-15s: %02.10lf\n", "%02.10lf", 8127.534);
  printf("%-15s: %02.30lf\n", "%02.30lf", 8127.534);
  printf("%-15s: %05lf\n", "%05lf", 8127.534);
  printf("%-15s: %05.lf\n", "%05.lf", 8127.534);
  printf("%-15s: %05.0lf\n", "%05.0lf", 8127.534);
  printf("%-15s: %05.1lf\n", "%05.1lf", 8127.534);
  printf("%-15s: %05.2lf\n", "%05.2lf", 8127.534);
  printf("%-15s: %05.5lf\n", "%05.5lf", 8127.534);
  printf("%-15s: %05.10lf\n", "%05.10lf", 8127.534);
  printf("%-15s: %05.30lf\n", "%05.30lf", 8127.534);
  printf("%-15s: %010lf\n", "%010lf", 8127.534);
  printf("%-15s: %010.lf\n", "%010.lf", 8127.534);
  printf("%-15s: %010.0lf\n", "%010.0lf", 8127.534);
  printf("%-15s: %010.1lf\n", "%010.1lf", 8127.534);
  printf("%-15s: %010.2lf\n", "%010.2lf", 8127.534);
  printf("%-15s: %010.5lf\n", "%010.5lf", 8127.534);
  printf("%-15s: %010.10lf\n", "%010.10lf", 8127.534);
  printf("%-15s: %010.30lf\n", "%010.30lf", 8127.534);
  printf("%-15s: %030lf\n", "%030lf", 8127.534);
  printf("%-15s: %030.lf\n", "%030.lf", 8127.534);
  printf("%-15s: %030.0lf\n", "%030.0lf", 8127.534);
  printf("%-15s: %030.1lf\n", "%030.1lf", 8127.534);
  printf("%-15s: %030.2lf\n", "%030.2lf", 8127.534);
  printf("%-15s: %030.5lf\n", "%030.5lf", 8127.534);
  printf("%-15s: %030.10lf\n", "%030.10lf", 8127.534);
  printf("%-15s: %030.30lf\n", "%030.30lf", 8127.534);
  printf("%-15s: %-+lf\n", "%-+lf", 8127.534);
  printf("%-15s: %-+.lf\n", "%-+.lf", 8127.534);
  printf("%-15s: %-+.0lf\n", "%-+.0lf", 8127.534);
  printf("%-15s: %-+.1lf\n", "%-+.1lf", 8127.534);
  printf("%-15s: %-+.2lf\n", "%-+.2lf", 8127.534);
  printf("%-15s: %-+.5lf\n", "%-+.5lf", 8127.534);
  printf("%-15s: %-+.10lf\n", "%-+.10lf", 8127.534);
  printf("%-15s: %-+.30lf\n", "%-+.30lf", 8127.534);
  printf("%-15s: %-+1lf\n", "%-+1lf", 8127.534);
  printf("%-15s: %-+1.lf\n", "%-+1.lf", 8127.534);
  printf("%-15s: %-+1.0lf\n", "%-+1.0lf", 8127.534);
  printf("%-15s: %-+1.1lf\n", "%-+1.1lf", 8127.534);
  printf("%-15s: %-+1.2lf\n", "%-+1.2lf", 8127.534);
  printf("%-15s: %-+1.5lf\n", "%-+1.5lf", 8127.534);
  printf("%-15s: %-+1.10lf\n", "%-+1.10lf", 8127.534);
  printf("%-15s: %-+1.30lf\n", "%-+1.30lf", 8127.534);
  printf("%-15s: %-+2lf\n", "%-+2lf", 8127.534);
  printf("%-15s: %-+2.lf\n", "%-+2.lf", 8127.534);
  printf("%-15s: %-+2.0lf\n", "%-+2.0lf", 8127.534);
  printf("%-15s: %-+2.1lf\n", "%-+2.1lf", 8127.534);
  printf("%-15s: %-+2.2lf\n", "%-+2.2lf", 8127.534);
  printf("%-15s: %-+2.5lf\n", "%-+2.5lf", 8127.534);
  printf("%-15s: %-+2.10lf\n", "%-+2.10lf", 8127.534);
  printf("%-15s: %-+2.30lf\n", "%-+2.30lf", 8127.534);
  printf("%-15s: %-+5lf\n", "%-+5lf", 8127.534);
  printf("%-15s: %-+5.lf\n", "%-+5.lf", 8127.534);
  printf("%-15s: %-+5.0lf\n", "%-+5.0lf", 8127.534);
  printf("%-15s: %-+5.1lf\n", "%-+5.1lf", 8127.534);
  printf("%-15s: %-+5.2lf\n", "%-+5.2lf", 8127.534);
  printf("%-15s: %-+5.5lf\n", "%-+5.5lf", 8127.534);
  printf("%-15s: %-+5.10lf\n", "%-+5.10lf", 8127.534);
  printf("%-15s: %-+5.30lf\n", "%-+5.30lf", 8127.534);
  printf("%-15s: %-+10lf\n", "%-+10lf", 8127.534);
  printf("%-15s: %-+10.lf\n", "%-+10.lf", 8127.534);
  printf("%-15s: %-+10.0lf\n", "%-+10.0lf", 8127.534);
  printf("%-15s: %-+10.1lf\n", "%-+10.1lf", 8127.534);
  printf("%-15s: %-+10.2lf\n", "%-+10.2lf", 8127.534);
  printf("%-15s: %-+10.5lf\n", "%-+10.5lf", 8127.534);
  printf("%-15s: %-+10.10lf\n", "%-+10.10lf", 8127.534);
  printf("%-15s: %-+10.30lf\n", "%-+10.30lf", 8127.534);
  printf("%-15s: %-+30lf\n", "%-+30lf", 8127.534);
  printf("%-15s: %-+30.lf\n", "%-+30.lf", 8127.534);
  printf("%-15s: %-+30.0lf\n", "%-+30.0lf", 8127.534);
  printf("%-15s: %-+30.1lf\n", "%-+30.1lf", 8127.534);
  printf("%-15s: %-+30.2lf\n", "%-+30.2lf", 8127.534);
  printf("%-15s: %-+30.5lf\n", "%-+30.5lf", 8127.534);
  printf("%-15s: %-+30.10lf\n", "%-+30.10lf", 8127.534);
  printf("%-15s: %-+30.30lf\n", "%-+30.30lf", 8127.534);
  printf("%-15s: %#+lf\n", "%#+lf", 8127.534);
  printf("%-15s: %#+.lf\n", "%#+.lf", 8127.534);
  printf("%-15s: %#+.0lf\n", "%#+.0lf", 8127.534);
  printf("%-15s: %#+.1lf\n", "%#+.1lf", 8127.534);
  printf("%-15s: %#+.2lf\n", "%#+.2lf", 8127.534);
  printf("%-15s: %#+.5lf\n", "%#+.5lf", 8127.534);
  printf("%-15s: %#+.10lf\n", "%#+.10lf", 8127.534);
  printf("%-15s: %#+.30lf\n", "%#+.30lf", 8127.534);
  printf("%-15s: %#+0lf\n", "%#+0lf", 8127.534);
  printf("%-15s: %#+0.lf\n", "%#+0.lf", 8127.534);
  printf("%-15s: %#+0.0lf\n", "%#+0.0lf", 8127.534);
  printf("%-15s: %#+0.1lf\n", "%#+0.1lf", 8127.534);
  printf("%-15s: %#+0.2lf\n", "%#+0.2lf", 8127.534);
  printf("%-15s: %#+0.5lf\n", "%#+0.5lf", 8127.534);
  printf("%-15s: %#+0.10lf\n", "%#+0.10lf", 8127.534);
  printf("%-15s: %#+0.30lf\n", "%#+0.30lf", 8127.534);
  printf("%-15s: %#+1lf\n", "%#+1lf", 8127.534);
  printf("%-15s: %#+1.lf\n", "%#+1.lf", 8127.534);
  printf("%-15s: %#+1.0lf\n", "%#+1.0lf", 8127.534);
  printf("%-15s: %#+1.1lf\n", "%#+1.1lf", 8127.534);
  printf("%-15s: %#+1.2lf\n", "%#+1.2lf", 8127.534);
  printf("%-15s: %#+1.5lf\n", "%#+1.5lf", 8127.534);
  printf("%-15s: %#+1.10lf\n", "%#+1.10lf", 8127.534);
  printf("%-15s: %#+1.30lf\n", "%#+1.30lf", 8127.534);
  printf("%-15s: %#+2lf\n", "%#+2lf", 8127.534);
  printf("%-15s: %#+2.lf\n", "%#+2.lf", 8127.534);
  printf("%-15s: %#+2.0lf\n", "%#+2.0lf", 8127.534);
  printf("%-15s: %#+2.1lf\n", "%#+2.1lf", 8127.534);
  printf("%-15s: %#+2.2lf\n", "%#+2.2lf", 8127.534);
  printf("%-15s: %#+2.5lf\n", "%#+2.5lf", 8127.534);
  printf("%-15s: %#+2.10lf\n", "%#+2.10lf", 8127.534);
  printf("%-15s: %#+2.30lf\n", "%#+2.30lf", 8127.534);
  printf("%-15s: %#+5lf\n", "%#+5lf", 8127.534);
  printf("%-15s: %#+5.lf\n", "%#+5.lf", 8127.534);
  printf("%-15s: %#+5.0lf\n", "%#+5.0lf", 8127.534);
  printf("%-15s: %#+5.1lf\n", "%#+5.1lf", 8127.534);
  printf("%-15s: %#+5.2lf\n", "%#+5.2lf", 8127.534);
  printf("%-15s: %#+5.5lf\n", "%#+5.5lf", 8127.534);
  printf("%-15s: %#+5.10lf\n", "%#+5.10lf", 8127.534);
  printf("%-15s: %#+5.30lf\n", "%#+5.30lf", 8127.534);
  printf("%-15s: %#+10lf\n", "%#+10lf", 8127.534);
  printf("%-15s: %#+10.lf\n", "%#+10.lf", 8127.534);
  printf("%-15s: %#+10.0lf\n", "%#+10.0lf", 8127.534);
  printf("%-15s: %#+10.1lf\n", "%#+10.1lf", 8127.534);
  printf("%-15s: %#+10.2lf\n", "%#+10.2lf", 8127.534);
  printf("%-15s: %#+10.5lf\n", "%#+10.5lf", 8127.534);
  printf("%-15s: %#+10.10lf\n", "%#+10.10lf", 8127.534);
  printf("%-15s: %#+10.30lf\n", "%#+10.30lf", 8127.534);
  printf("%-15s: %#+30lf\n", "%#+30lf", 8127.534);
  printf("%-15s: %#+30.lf\n", "%#+30.lf", 8127.534);
  printf("%-15s: %#+30.0lf\n", "%#+30.0lf", 8127.534);
  printf("%-15s: %#+30.1lf\n", "%#+30.1lf", 8127.534);
  printf("%-15s: %#+30.2lf\n", "%#+30.2lf", 8127.534);
  printf("%-15s: %#+30.5lf\n", "%#+30.5lf", 8127.534);
  printf("%-15s: %#+30.10lf\n", "%#+30.10lf", 8127.534);
  printf("%-15s: %#+30.30lf\n", "%#+30.30lf", 8127.534);
  printf("%-15s: %+0lf\n", "%+0lf", 8127.534);
  printf("%-15s: %+0.lf\n", "%+0.lf", 8127.534);
  printf("%-15s: %+0.0lf\n", "%+0.0lf", 8127.534);
  printf("%-15s: %+0.1lf\n", "%+0.1lf", 8127.534);
  printf("%-15s: %+0.2lf\n", "%+0.2lf", 8127.534);
  printf("%-15s: %+0.5lf\n", "%+0.5lf", 8127.534);
  printf("%-15s: %+0.10lf\n", "%+0.10lf", 8127.534);
  printf("%-15s: %+0.30lf\n", "%+0.30lf", 8127.534);
  printf("%-15s: %+01lf\n", "%+01lf", 8127.534);
  printf("%-15s: %+01.lf\n", "%+01.lf", 8127.534);
  printf("%-15s: %+01.0lf\n", "%+01.0lf", 8127.534);
  printf("%-15s: %+01.1lf\n", "%+01.1lf", 8127.534);
  printf("%-15s: %+01.2lf\n", "%+01.2lf", 8127.534);
  printf("%-15s: %+01.5lf\n", "%+01.5lf", 8127.534);
  printf("%-15s: %+01.10lf\n", "%+01.10lf", 8127.534);
  printf("%-15s: %+01.30lf\n", "%+01.30lf", 8127.534);
  printf("%-15s: %+02lf\n", "%+02lf", 8127.534);
  printf("%-15s: %+02.lf\n", "%+02.lf", 8127.534);
  printf("%-15s: %+02.0lf\n", "%+02.0lf", 8127.534);
  printf("%-15s: %+02.1lf\n", "%+02.1lf", 8127.534);
  printf("%-15s: %+02.2lf\n", "%+02.2lf", 8127.534);
  printf("%-15s: %+02.5lf\n", "%+02.5lf", 8127.534);
  printf("%-15s: %+02.10lf\n", "%+02.10lf", 8127.534);
  printf("%-15s: %+02.30lf\n", "%+02.30lf", 8127.534);
  printf("%-15s: %+05lf\n", "%+05lf", 8127.534);
  printf("%-15s: %+05.lf\n", "%+05.lf", 8127.534);
  printf("%-15s: %+05.0lf\n", "%+05.0lf", 8127.534);
  printf("%-15s: %+05.1lf\n", "%+05.1lf", 8127.534);
  printf("%-15s: %+05.2lf\n", "%+05.2lf", 8127.534);
  printf("%-15s: %+05.5lf\n", "%+05.5lf", 8127.534);
  printf("%-15s: %+05.10lf\n", "%+05.10lf", 8127.534);
  printf("%-15s: %+05.30lf\n", "%+05.30lf", 8127.534);
  printf("%-15s: %+010lf\n", "%+010lf", 8127.534);
  printf("%-15s: %+010.lf\n", "%+010.lf", 8127.534);
  printf("%-15s: %+010.0lf\n", "%+010.0lf", 8127.534);
  printf("%-15s: %+010.1lf\n", "%+010.1lf", 8127.534);
  printf("%-15s: %+010.2lf\n", "%+010.2lf", 8127.534);
  printf("%-15s: %+010.5lf\n", "%+010.5lf", 8127.534);
  printf("%-15s: %+010.10lf\n", "%+010.10lf", 8127.534);
  printf("%-15s: %+010.30lf\n", "%+010.30lf", 8127.534);
  printf("%-15s: %+030lf\n", "%+030lf", 8127.534);
  printf("%-15s: %+030.lf\n", "%+030.lf", 8127.534);
  printf("%-15s: %+030.0lf\n", "%+030.0lf", 8127.534);
  printf("%-15s: %+030.1lf\n", "%+030.1lf", 8127.534);
  printf("%-15s: %+030.2lf\n", "%+030.2lf", 8127.534);
  printf("%-15s: %+030.5lf\n", "%+030.5lf", 8127.534);
  printf("%-15s: %+030.10lf\n", "%+030.10lf", 8127.534);
  printf("%-15s: %+030.30lf\n", "%+030.30lf", 8127.534);
  printf("%-15s: %+-lf\n", "%+-lf", 8127.534);
  printf("%-15s: %+-.lf\n", "%+-.lf", 8127.534);
  printf("%-15s: %+-.0lf\n", "%+-.0lf", 8127.534);
  printf("%-15s: %+-.1lf\n", "%+-.1lf", 8127.534);
  printf("%-15s: %+-.2lf\n", "%+-.2lf", 8127.534);
  printf("%-15s: %+-.5lf\n", "%+-.5lf", 8127.534);
  printf("%-15s: %+-.10lf\n", "%+-.10lf", 8127.534);
  printf("%-15s: %+-.30lf\n", "%+-.30lf", 8127.534);
  printf("%-15s: %+-1lf\n", "%+-1lf", 8127.534);
  printf("%-15s: %+-1.lf\n", "%+-1.lf", 8127.534);
  printf("%-15s: %+-1.0lf\n", "%+-1.0lf", 8127.534);
  printf("%-15s: %+-1.1lf\n", "%+-1.1lf", 8127.534);
  printf("%-15s: %+-1.2lf\n", "%+-1.2lf", 8127.534);
  printf("%-15s: %+-1.5lf\n", "%+-1.5lf", 8127.534);
  printf("%-15s: %+-1.10lf\n", "%+-1.10lf", 8127.534);
  printf("%-15s: %+-1.30lf\n", "%+-1.30lf", 8127.534);
  printf("%-15s: %+-2lf\n", "%+-2lf", 8127.534);
  printf("%-15s: %+-2.lf\n", "%+-2.lf", 8127.534);
  printf("%-15s: %+-2.0lf\n", "%+-2.0lf", 8127.534);
  printf("%-15s: %+-2.1lf\n", "%+-2.1lf", 8127.534);
  printf("%-15s: %+-2.2lf\n", "%+-2.2lf", 8127.534);
  printf("%-15s: %+-2.5lf\n", "%+-2.5lf", 8127.534);
  printf("%-15s: %+-2.10lf\n", "%+-2.10lf", 8127.534);
  printf("%-15s: %+-2.30lf\n", "%+-2.30lf", 8127.534);
  printf("%-15s: %+-5lf\n", "%+-5lf", 8127.534);
  printf("%-15s: %+-5.lf\n", "%+-5.lf", 8127.534);
  printf("%-15s: %+-5.0lf\n", "%+-5.0lf", 8127.534);
  printf("%-15s: %+-5.1lf\n", "%+-5.1lf", 8127.534);
  printf("%-15s: %+-5.2lf\n", "%+-5.2lf", 8127.534);
  printf("%-15s: %+-5.5lf\n", "%+-5.5lf", 8127.534);
  printf("%-15s: %+-5.10lf\n", "%+-5.10lf", 8127.534);
  printf("%-15s: %+-5.30lf\n", "%+-5.30lf", 8127.534);
  printf("%-15s: %+-10lf\n", "%+-10lf", 8127.534);
  printf("%-15s: %+-10.lf\n", "%+-10.lf", 8127.534);
  printf("%-15s: %+-10.0lf\n", "%+-10.0lf", 8127.534);
  printf("%-15s: %+-10.1lf\n", "%+-10.1lf", 8127.534);
  printf("%-15s: %+-10.2lf\n", "%+-10.2lf", 8127.534);
  printf("%-15s: %+-10.5lf\n", "%+-10.5lf", 8127.534);
  printf("%-15s: %+-10.10lf\n", "%+-10.10lf", 8127.534);
  printf("%-15s: %+-10.30lf\n", "%+-10.30lf", 8127.534);
  printf("%-15s: %+-30lf\n", "%+-30lf", 8127.534);
  printf("%-15s: %+-30.lf\n", "%+-30.lf", 8127.534);
  printf("%-15s: %+-30.0lf\n", "%+-30.0lf", 8127.534);
  printf("%-15s: %+-30.1lf\n", "%+-30.1lf", 8127.534);
  printf("%-15s: %+-30.2lf\n", "%+-30.2lf", 8127.534);
  printf("%-15s: %+-30.5lf\n", "%+-30.5lf", 8127.534);
  printf("%-15s: %+-30.10lf\n", "%+-30.10lf", 8127.534);
  printf("%-15s: %+-30.30lf\n", "%+-30.30lf", 8127.534);
  printf("%-15s: %#-lf\n", "%#-lf", 8127.534);
  printf("%-15s: %#-.lf\n", "%#-.lf", 8127.534);
  printf("%-15s: %#-.0lf\n", "%#-.0lf", 8127.534);
  printf("%-15s: %#-.1lf\n", "%#-.1lf", 8127.534);
  printf("%-15s: %#-.2lf\n", "%#-.2lf", 8127.534);
  printf("%-15s: %#-.5lf\n", "%#-.5lf", 8127.534);
  printf("%-15s: %#-.10lf\n", "%#-.10lf", 8127.534);
  printf("%-15s: %#-.30lf\n", "%#-.30lf", 8127.534);
  printf("%-15s: %#-1lf\n", "%#-1lf", 8127.534);
  printf("%-15s: %#-1.lf\n", "%#-1.lf", 8127.534);
  printf("%-15s: %#-1.0lf\n", "%#-1.0lf", 8127.534);
  printf("%-15s: %#-1.1lf\n", "%#-1.1lf", 8127.534);
  printf("%-15s: %#-1.2lf\n", "%#-1.2lf", 8127.534);
  printf("%-15s: %#-1.5lf\n", "%#-1.5lf", 8127.534);
  printf("%-15s: %#-1.10lf\n", "%#-1.10lf", 8127.534);
  printf("%-15s: %#-1.30lf\n", "%#-1.30lf", 8127.534);
  printf("%-15s: %#-2lf\n", "%#-2lf", 8127.534);
  printf("%-15s: %#-2.lf\n", "%#-2.lf", 8127.534);
  printf("%-15s: %#-2.0lf\n", "%#-2.0lf", 8127.534);
  printf("%-15s: %#-2.1lf\n", "%#-2.1lf", 8127.534);
  printf("%-15s: %#-2.2lf\n", "%#-2.2lf", 8127.534);
  printf("%-15s: %#-2.5lf\n", "%#-2.5lf", 8127.534);
  printf("%-15s: %#-2.10lf\n", "%#-2.10lf", 8127.534);
  printf("%-15s: %#-2.30lf\n", "%#-2.30lf", 8127.534);
  printf("%-15s: %#-5lf\n", "%#-5lf", 8127.534);
  printf("%-15s: %#-5.lf\n", "%#-5.lf", 8127.534);
  printf("%-15s: %#-5.0lf\n", "%#-5.0lf", 8127.534);
  printf("%-15s: %#-5.1lf\n", "%#-5.1lf", 8127.534);
  printf("%-15s: %#-5.2lf\n", "%#-5.2lf", 8127.534);
  printf("%-15s: %#-5.5lf\n", "%#-5.5lf", 8127.534);
  printf("%-15s: %#-5.10lf\n", "%#-5.10lf", 8127.534);
  printf("%-15s: %#-5.30lf\n", "%#-5.30lf", 8127.534);
  printf("%-15s: %#-10lf\n", "%#-10lf", 8127.534);
  printf("%-15s: %#-10.lf\n", "%#-10.lf", 8127.534);
  printf("%-15s: %#-10.0lf\n", "%#-10.0lf", 8127.534);
  printf("%-15s: %#-10.1lf\n", "%#-10.1lf", 8127.534);
  printf("%-15s: %#-10.2lf\n", "%#-10.2lf", 8127.534);
  printf("%-15s: %#-10.5lf\n", "%#-10.5lf", 8127.534);
  printf("%-15s: %#-10.10lf\n", "%#-10.10lf", 8127.534);
  printf("%-15s: %#-10.30lf\n", "%#-10.30lf", 8127.534);
  printf("%-15s: %#-30lf\n", "%#-30lf", 8127.534);
  printf("%-15s: %#-30.lf\n", "%#-30.lf", 8127.534);
  printf("%-15s: %#-30.0lf\n", "%#-30.0lf", 8127.534);
  printf("%-15s: %#-30.1lf\n", "%#-30.1lf", 8127.534);
  printf("%-15s: %#-30.2lf\n", "%#-30.2lf", 8127.534);
  printf("%-15s: %#-30.5lf\n", "%#-30.5lf", 8127.534);
  printf("%-15s: %#-30.10lf\n", "%#-30.10lf", 8127.534);
  printf("%-15s: %#-30.30lf\n", "%#-30.30lf", 8127.534);
  printf("%-15s: %+#lf\n", "%+#lf", 8127.534);
  printf("%-15s: %+#.lf\n", "%+#.lf", 8127.534);
  printf("%-15s: %+#.0lf\n", "%+#.0lf", 8127.534);
  printf("%-15s: %+#.1lf\n", "%+#.1lf", 8127.534);
  printf("%-15s: %+#.2lf\n", "%+#.2lf", 8127.534);
  printf("%-15s: %+#.5lf\n", "%+#.5lf", 8127.534);
  printf("%-15s: %+#.10lf\n", "%+#.10lf", 8127.534);
  printf("%-15s: %+#.30lf\n", "%+#.30lf", 8127.534);
  printf("%-15s: %+#0lf\n", "%+#0lf", 8127.534);
  printf("%-15s: %+#0.lf\n", "%+#0.lf", 8127.534);
  printf("%-15s: %+#0.0lf\n", "%+#0.0lf", 8127.534);
  printf("%-15s: %+#0.1lf\n", "%+#0.1lf", 8127.534);
  printf("%-15s: %+#0.2lf\n", "%+#0.2lf", 8127.534);
  printf("%-15s: %+#0.5lf\n", "%+#0.5lf", 8127.534);
  printf("%-15s: %+#0.10lf\n", "%+#0.10lf", 8127.534);
  printf("%-15s: %+#0.30lf\n", "%+#0.30lf", 8127.534);
  printf("%-15s: %+#1lf\n", "%+#1lf", 8127.534);
  printf("%-15s: %+#1.lf\n", "%+#1.lf", 8127.534);
  printf("%-15s: %+#1.0lf\n", "%+#1.0lf", 8127.534);
  printf("%-15s: %+#1.1lf\n", "%+#1.1lf", 8127.534);
  printf("%-15s: %+#1.2lf\n", "%+#1.2lf", 8127.534);
  printf("%-15s: %+#1.5lf\n", "%+#1.5lf", 8127.534);
  printf("%-15s: %+#1.10lf\n", "%+#1.10lf", 8127.534);
  printf("%-15s: %+#1.30lf\n", "%+#1.30lf", 8127.534);
  printf("%-15s: %+#2lf\n", "%+#2lf", 8127.534);
  printf("%-15s: %+#2.lf\n", "%+#2.lf", 8127.534);
  printf("%-15s: %+#2.0lf\n", "%+#2.0lf", 8127.534);
  printf("%-15s: %+#2.1lf\n", "%+#2.1lf", 8127.534);
  printf("%-15s: %+#2.2lf\n", "%+#2.2lf", 8127.534);
  printf("%-15s: %+#2.5lf\n", "%+#2.5lf", 8127.534);
  printf("%-15s: %+#2.10lf\n", "%+#2.10lf", 8127.534);
  printf("%-15s: %+#2.30lf\n", "%+#2.30lf", 8127.534);
  printf("%-15s: %+#5lf\n", "%+#5lf", 8127.534);
  printf("%-15s: %+#5.lf\n", "%+#5.lf", 8127.534);
  printf("%-15s: %+#5.0lf\n", "%+#5.0lf", 8127.534);
  printf("%-15s: %+#5.1lf\n", "%+#5.1lf", 8127.534);
  printf("%-15s: %+#5.2lf\n", "%+#5.2lf", 8127.534);
  printf("%-15s: %+#5.5lf\n", "%+#5.5lf", 8127.534);
  printf("%-15s: %+#5.10lf\n", "%+#5.10lf", 8127.534);
  printf("%-15s: %+#5.30lf\n", "%+#5.30lf", 8127.534);
  printf("%-15s: %+#10lf\n", "%+#10lf", 8127.534);
  printf("%-15s: %+#10.lf\n", "%+#10.lf", 8127.534);
  printf("%-15s: %+#10.0lf\n", "%+#10.0lf", 8127.534);
  printf("%-15s: %+#10.1lf\n", "%+#10.1lf", 8127.534);
  printf("%-15s: %+#10.2lf\n", "%+#10.2lf", 8127.534);
  printf("%-15s: %+#10.5lf\n", "%+#10.5lf", 8127.534);
  printf("%-15s: %+#10.10lf\n", "%+#10.10lf", 8127.534);
  printf("%-15s: %+#10.30lf\n", "%+#10.30lf", 8127.534);
  printf("%-15s: %+#30lf\n", "%+#30lf", 8127.534);
  printf("%-15s: %+#30.lf\n", "%+#30.lf", 8127.534);
  printf("%-15s: %+#30.0lf\n", "%+#30.0lf", 8127.534);
  printf("%-15s: %+#30.1lf\n", "%+#30.1lf", 8127.534);
  printf("%-15s: %+#30.2lf\n", "%+#30.2lf", 8127.534);
  printf("%-15s: %+#30.5lf\n", "%+#30.5lf", 8127.534);
  printf("%-15s: %+#30.10lf\n", "%+#30.10lf", 8127.534);
  printf("%-15s: %+#30.30lf\n", "%+#30.30lf", 8127.534);
  printf("%-15s: %-#lf\n", "%-#lf", 8127.534);
  printf("%-15s: %-#.lf\n", "%-#.lf", 8127.534);
  printf("%-15s: %-#.0lf\n", "%-#.0lf", 8127.534);
  printf("%-15s: %-#.1lf\n", "%-#.1lf", 8127.534);
  printf("%-15s: %-#.2lf\n", "%-#.2lf", 8127.534);
  printf("%-15s: %-#.5lf\n", "%-#.5lf", 8127.534);
  printf("%-15s: %-#.10lf\n", "%-#.10lf", 8127.534);
  printf("%-15s: %-#.30lf\n", "%-#.30lf", 8127.534);
  printf("%-15s: %-#1lf\n", "%-#1lf", 8127.534);
  printf("%-15s: %-#1.lf\n", "%-#1.lf", 8127.534);
  printf("%-15s: %-#1.0lf\n", "%-#1.0lf", 8127.534);
  printf("%-15s: %-#1.1lf\n", "%-#1.1lf", 8127.534);
  printf("%-15s: %-#1.2lf\n", "%-#1.2lf", 8127.534);
  printf("%-15s: %-#1.5lf\n", "%-#1.5lf", 8127.534);
  printf("%-15s: %-#1.10lf\n", "%-#1.10lf", 8127.534);
  printf("%-15s: %-#1.30lf\n", "%-#1.30lf", 8127.534);
  printf("%-15s: %-#2lf\n", "%-#2lf", 8127.534);
  printf("%-15s: %-#2.lf\n", "%-#2.lf", 8127.534);
  printf("%-15s: %-#2.0lf\n", "%-#2.0lf", 8127.534);
  printf("%-15s: %-#2.1lf\n", "%-#2.1lf", 8127.534);
  printf("%-15s: %-#2.2lf\n", "%-#2.2lf", 8127.534);
  printf("%-15s: %-#2.5lf\n", "%-#2.5lf", 8127.534);
  printf("%-15s: %-#2.10lf\n", "%-#2.10lf", 8127.534);
  printf("%-15s: %-#2.30lf\n", "%-#2.30lf", 8127.534);
  printf("%-15s: %-#5lf\n", "%-#5lf", 8127.534);
  printf("%-15s: %-#5.lf\n", "%-#5.lf", 8127.534);
  printf("%-15s: %-#5.0lf\n", "%-#5.0lf", 8127.534);
  printf("%-15s: %-#5.1lf\n", "%-#5.1lf", 8127.534);
  printf("%-15s: %-#5.2lf\n", "%-#5.2lf", 8127.534);
  printf("%-15s: %-#5.5lf\n", "%-#5.5lf", 8127.534);
  printf("%-15s: %-#5.10lf\n", "%-#5.10lf", 8127.534);
  printf("%-15s: %-#5.30lf\n", "%-#5.30lf", 8127.534);
  printf("%-15s: %-#10lf\n", "%-#10lf", 8127.534);
  printf("%-15s: %-#10.lf\n", "%-#10.lf", 8127.534);
  printf("%-15s: %-#10.0lf\n", "%-#10.0lf", 8127.534);
  printf("%-15s: %-#10.1lf\n", "%-#10.1lf", 8127.534);
  printf("%-15s: %-#10.2lf\n", "%-#10.2lf", 8127.534);
  printf("%-15s: %-#10.5lf\n", "%-#10.5lf", 8127.534);
  printf("%-15s: %-#10.10lf\n", "%-#10.10lf", 8127.534);
  printf("%-15s: %-#10.30lf\n", "%-#10.30lf", 8127.534);
  printf("%-15s: %-#30lf\n", "%-#30lf", 8127.534);
  printf("%-15s: %-#30.lf\n", "%-#30.lf", 8127.534);
  printf("%-15s: %-#30.0lf\n", "%-#30.0lf", 8127.534);
  printf("%-15s: %-#30.1lf\n", "%-#30.1lf", 8127.534);
  printf("%-15s: %-#30.2lf\n", "%-#30.2lf", 8127.534);
  printf("%-15s: %-#30.5lf\n", "%-#30.5lf", 8127.534);
  printf("%-15s: %-#30.10lf\n", "%-#30.10lf", 8127.534);
  printf("%-15s: %-#30.30lf\n", "%-#30.30lf", 8127.534);
  printf("%-15s: %0#lf\n", "%0#lf", 8127.534);
  printf("%-15s: %0#.lf\n", "%0#.lf", 8127.534);
  printf("%-15s: %0#.0lf\n", "%0#.0lf", 8127.534);
  printf("%-15s: %0#.1lf\n", "%0#.1lf", 8127.534);
  printf("%-15s: %0#.2lf\n", "%0#.2lf", 8127.534);
  printf("%-15s: %0#.5lf\n", "%0#.5lf", 8127.534);
  printf("%-15s: %0#.10lf\n", "%0#.10lf", 8127.534);
  printf("%-15s: %0#.30lf\n", "%0#.30lf", 8127.534);
  printf("%-15s: %0#1lf\n", "%0#1lf", 8127.534);
  printf("%-15s: %0#1.lf\n", "%0#1.lf", 8127.534);
  printf("%-15s: %0#1.0lf\n", "%0#1.0lf", 8127.534);
  printf("%-15s: %0#1.1lf\n", "%0#1.1lf", 8127.534);
  printf("%-15s: %0#1.2lf\n", "%0#1.2lf", 8127.534);
  printf("%-15s: %0#1.5lf\n", "%0#1.5lf", 8127.534);
  printf("%-15s: %0#1.10lf\n", "%0#1.10lf", 8127.534);
  printf("%-15s: %0#1.30lf\n", "%0#1.30lf", 8127.534);
  printf("%-15s: %0#2lf\n", "%0#2lf", 8127.534);
  printf("%-15s: %0#2.lf\n", "%0#2.lf", 8127.534);
  printf("%-15s: %0#2.0lf\n", "%0#2.0lf", 8127.534);
  printf("%-15s: %0#2.1lf\n", "%0#2.1lf", 8127.534);
  printf("%-15s: %0#2.2lf\n", "%0#2.2lf", 8127.534);
  printf("%-15s: %0#2.5lf\n", "%0#2.5lf", 8127.534);
  printf("%-15s: %0#2.10lf\n", "%0#2.10lf", 8127.534);
  printf("%-15s: %0#2.30lf\n", "%0#2.30lf", 8127.534);
  printf("%-15s: %0#5lf\n", "%0#5lf", 8127.534);
  printf("%-15s: %0#5.lf\n", "%0#5.lf", 8127.534);
  printf("%-15s: %0#5.0lf\n", "%0#5.0lf", 8127.534);
  printf("%-15s: %0#5.1lf\n", "%0#5.1lf", 8127.534);
  printf("%-15s: %0#5.2lf\n", "%0#5.2lf", 8127.534);
  printf("%-15s: %0#5.5lf\n", "%0#5.5lf", 8127.534);
  printf("%-15s: %0#5.10lf\n", "%0#5.10lf", 8127.534);
  printf("%-15s: %0#5.30lf\n", "%0#5.30lf", 8127.534);
  printf("%-15s: %0#10lf\n", "%0#10lf", 8127.534);
  printf("%-15s: %0#10.lf\n", "%0#10.lf", 8127.534);
  printf("%-15s: %0#10.0lf\n", "%0#10.0lf", 8127.534);
  printf("%-15s: %0#10.1lf\n", "%0#10.1lf", 8127.534);
  printf("%-15s: %0#10.2lf\n", "%0#10.2lf", 8127.534);
  printf("%-15s: %0#10.5lf\n", "%0#10.5lf", 8127.534);
  printf("%-15s: %0#10.10lf\n", "%0#10.10lf", 8127.534);
  printf("%-15s: %0#10.30lf\n", "%0#10.30lf", 8127.534);
  printf("%-15s: %0#30lf\n", "%0#30lf", 8127.534);
  printf("%-15s: %0#30.lf\n", "%0#30.lf", 8127.534);
  printf("%-15s: %0#30.0lf\n", "%0#30.0lf", 8127.534);
  printf("%-15s: %0#30.1lf\n", "%0#30.1lf", 8127.534);
  printf("%-15s: %0#30.2lf\n", "%0#30.2lf", 8127.534);
  printf("%-15s: %0#30.5lf\n", "%0#30.5lf", 8127.534);
  printf("%-15s: %0#30.10lf\n", "%0#30.10lf", 8127.534);
  printf("%-15s: %0#30.30lf\n", "%0#30.30lf", 8127.534);
  printf("%-15s: %+0lf\n", "%+0lf", 8127.534);
  printf("%-15s: %+0.lf\n", "%+0.lf", 8127.534);
  printf("%-15s: %+0.0lf\n", "%+0.0lf", 8127.534);
  printf("%-15s: %+0.1lf\n", "%+0.1lf", 8127.534);
  printf("%-15s: %+0.2lf\n", "%+0.2lf", 8127.534);
  printf("%-15s: %+0.5lf\n", "%+0.5lf", 8127.534);
  printf("%-15s: %+0.10lf\n", "%+0.10lf", 8127.534);
  printf("%-15s: %+0.30lf\n", "%+0.30lf", 8127.534);
  printf("%-15s: %+01lf\n", "%+01lf", 8127.534);
  printf("%-15s: %+01.lf\n", "%+01.lf", 8127.534);
  printf("%-15s: %+01.0lf\n", "%+01.0lf", 8127.534);
  printf("%-15s: %+01.1lf\n", "%+01.1lf", 8127.534);
  printf("%-15s: %+01.2lf\n", "%+01.2lf", 8127.534);
  printf("%-15s: %+01.5lf\n", "%+01.5lf", 8127.534);
  printf("%-15s: %+01.10lf\n", "%+01.10lf", 8127.534);
  printf("%-15s: %+01.30lf\n", "%+01.30lf", 8127.534);
  printf("%-15s: %+02lf\n", "%+02lf", 8127.534);
  printf("%-15s: %+02.lf\n", "%+02.lf", 8127.534);
  printf("%-15s: %+02.0lf\n", "%+02.0lf", 8127.534);
  printf("%-15s: %+02.1lf\n", "%+02.1lf", 8127.534);
  printf("%-15s: %+02.2lf\n", "%+02.2lf", 8127.534);
  printf("%-15s: %+02.5lf\n", "%+02.5lf", 8127.534);
  printf("%-15s: %+02.10lf\n", "%+02.10lf", 8127.534);
  printf("%-15s: %+02.30lf\n", "%+02.30lf", 8127.534);
  printf("%-15s: %+05lf\n", "%+05lf", 8127.534);
  printf("%-15s: %+05.lf\n", "%+05.lf", 8127.534);
  printf("%-15s: %+05.0lf\n", "%+05.0lf", 8127.534);
  printf("%-15s: %+05.1lf\n", "%+05.1lf", 8127.534);
  printf("%-15s: %+05.2lf\n", "%+05.2lf", 8127.534);
  printf("%-15s: %+05.5lf\n", "%+05.5lf", 8127.534);
  printf("%-15s: %+05.10lf\n", "%+05.10lf", 8127.534);
  printf("%-15s: %+05.30lf\n", "%+05.30lf", 8127.534);
  printf("%-15s: %+010lf\n", "%+010lf", 8127.534);
  printf("%-15s: %+010.lf\n", "%+010.lf", 8127.534);
  printf("%-15s: %+010.0lf\n", "%+010.0lf", 8127.534);
  printf("%-15s: %+010.1lf\n", "%+010.1lf", 8127.534);
  printf("%-15s: %+010.2lf\n", "%+010.2lf", 8127.534);
  printf("%-15s: %+010.5lf\n", "%+010.5lf", 8127.534);
  printf("%-15s: %+010.10lf\n", "%+010.10lf", 8127.534);
  printf("%-15s: %+010.30lf\n", "%+010.30lf", 8127.534);
  printf("%-15s: %+030lf\n", "%+030lf", 8127.534);
  printf("%-15s: %+030.lf\n", "%+030.lf", 8127.534);
  printf("%-15s: %+030.0lf\n", "%+030.0lf", 8127.534);
  printf("%-15s: %+030.1lf\n", "%+030.1lf", 8127.534);
  printf("%-15s: %+030.2lf\n", "%+030.2lf", 8127.534);
  printf("%-15s: %+030.5lf\n", "%+030.5lf", 8127.534);
  printf("%-15s: %+030.10lf\n", "%+030.10lf", 8127.534);
  printf("%-15s: %+030.30lf\n", "%+030.30lf", 8127.534);
  printf("%-15s: %#0lf\n", "%#0lf", 8127.534);
  printf("%-15s: %#0.lf\n", "%#0.lf", 8127.534);
  printf("%-15s: %#0.0lf\n", "%#0.0lf", 8127.534);
  printf("%-15s: %#0.1lf\n", "%#0.1lf", 8127.534);
  printf("%-15s: %#0.2lf\n", "%#0.2lf", 8127.534);
  printf("%-15s: %#0.5lf\n", "%#0.5lf", 8127.534);
  printf("%-15s: %#0.10lf\n", "%#0.10lf", 8127.534);
  printf("%-15s: %#0.30lf\n", "%#0.30lf", 8127.534);
  printf("%-15s: %#01lf\n", "%#01lf", 8127.534);
  printf("%-15s: %#01.lf\n", "%#01.lf", 8127.534);
  printf("%-15s: %#01.0lf\n", "%#01.0lf", 8127.534);
  printf("%-15s: %#01.1lf\n", "%#01.1lf", 8127.534);
  printf("%-15s: %#01.2lf\n", "%#01.2lf", 8127.534);
  printf("%-15s: %#01.5lf\n", "%#01.5lf", 8127.534);
  printf("%-15s: %#01.10lf\n", "%#01.10lf", 8127.534);
  printf("%-15s: %#01.30lf\n", "%#01.30lf", 8127.534);
  printf("%-15s: %#02lf\n", "%#02lf", 8127.534);
  printf("%-15s: %#02.lf\n", "%#02.lf", 8127.534);
  printf("%-15s: %#02.0lf\n", "%#02.0lf", 8127.534);
  printf("%-15s: %#02.1lf\n", "%#02.1lf", 8127.534);
  printf("%-15s: %#02.2lf\n", "%#02.2lf", 8127.534);
  printf("%-15s: %#02.5lf\n", "%#02.5lf", 8127.534);
  printf("%-15s: %#02.10lf\n", "%#02.10lf", 8127.534);
  printf("%-15s: %#02.30lf\n", "%#02.30lf", 8127.534);
  printf("%-15s: %#05lf\n", "%#05lf", 8127.534);
  printf("%-15s: %#05.lf\n", "%#05.lf", 8127.534);
  printf("%-15s: %#05.0lf\n", "%#05.0lf", 8127.534);
  printf("%-15s: %#05.1lf\n", "%#05.1lf", 8127.534);
  printf("%-15s: %#05.2lf\n", "%#05.2lf", 8127.534);
  printf("%-15s: %#05.5lf\n", "%#05.5lf", 8127.534);
  printf("%-15s: %#05.10lf\n", "%#05.10lf", 8127.534);
  printf("%-15s: %#05.30lf\n", "%#05.30lf", 8127.534);
  printf("%-15s: %#010lf\n", "%#010lf", 8127.534);
  printf("%-15s: %#010.lf\n", "%#010.lf", 8127.534);
  printf("%-15s: %#010.0lf\n", "%#010.0lf", 8127.534);
  printf("%-15s: %#010.1lf\n", "%#010.1lf", 8127.534);
  printf("%-15s: %#010.2lf\n", "%#010.2lf", 8127.534);
  printf("%-15s: %#010.5lf\n", "%#010.5lf", 8127.534);
  printf("%-15s: %#010.10lf\n", "%#010.10lf", 8127.534);
  printf("%-15s: %#010.30lf\n", "%#010.30lf", 8127.534);
  printf("%-15s: %#030lf\n", "%#030lf", 8127.534);
  printf("%-15s: %#030.lf\n", "%#030.lf", 8127.534);
  printf("%-15s: %#030.0lf\n", "%#030.0lf", 8127.534);
  printf("%-15s: %#030.1lf\n", "%#030.1lf", 8127.534);
  printf("%-15s: %#030.2lf\n", "%#030.2lf", 8127.534);
  printf("%-15s: %#030.5lf\n", "%#030.5lf", 8127.534);
  printf("%-15s: %#030.10lf\n", "%#030.10lf", 8127.534);
  printf("%-15s: %#030.30lf\n", "%#030.30lf", 8127.534);
  printf("%-15s: %-+#lf\n", "%-+#lf", 8127.534);
  printf("%-15s: %-+#.lf\n", "%-+#.lf", 8127.534);
  printf("%-15s: %-+#.0lf\n", "%-+#.0lf", 8127.534);
  printf("%-15s: %-+#.1lf\n", "%-+#.1lf", 8127.534);
  printf("%-15s: %-+#.2lf\n", "%-+#.2lf", 8127.534);
  printf("%-15s: %-+#.5lf\n", "%-+#.5lf", 8127.534);
  printf("%-15s: %-+#.10lf\n", "%-+#.10lf", 8127.534);
  printf("%-15s: %-+#.30lf\n", "%-+#.30lf", 8127.534);
  printf("%-15s: %-+#1lf\n", "%-+#1lf", 8127.534);
  printf("%-15s: %-+#1.lf\n", "%-+#1.lf", 8127.534);
  printf("%-15s: %-+#1.0lf\n", "%-+#1.0lf", 8127.534);
  printf("%-15s: %-+#1.1lf\n", "%-+#1.1lf", 8127.534);
  printf("%-15s: %-+#1.2lf\n", "%-+#1.2lf", 8127.534);
  printf("%-15s: %-+#1.5lf\n", "%-+#1.5lf", 8127.534);
  printf("%-15s: %-+#1.10lf\n", "%-+#1.10lf", 8127.534);
  printf("%-15s: %-+#1.30lf\n", "%-+#1.30lf", 8127.534);
  printf("%-15s: %-+#2lf\n", "%-+#2lf", 8127.534);
  printf("%-15s: %-+#2.lf\n", "%-+#2.lf", 8127.534);
  printf("%-15s: %-+#2.0lf\n", "%-+#2.0lf", 8127.534);
  printf("%-15s: %-+#2.1lf\n", "%-+#2.1lf", 8127.534);
  printf("%-15s: %-+#2.2lf\n", "%-+#2.2lf", 8127.534);
  printf("%-15s: %-+#2.5lf\n", "%-+#2.5lf", 8127.534);
  printf("%-15s: %-+#2.10lf\n", "%-+#2.10lf", 8127.534);
  printf("%-15s: %-+#2.30lf\n", "%-+#2.30lf", 8127.534);
  printf("%-15s: %-+#5lf\n", "%-+#5lf", 8127.534);
  printf("%-15s: %-+#5.lf\n", "%-+#5.lf", 8127.534);
  printf("%-15s: %-+#5.0lf\n", "%-+#5.0lf", 8127.534);
  printf("%-15s: %-+#5.1lf\n", "%-+#5.1lf", 8127.534);
  printf("%-15s: %-+#5.2lf\n", "%-+#5.2lf", 8127.534);
  printf("%-15s: %-+#5.5lf\n", "%-+#5.5lf", 8127.534);
  printf("%-15s: %-+#5.10lf\n", "%-+#5.10lf", 8127.534);
  printf("%-15s: %-+#5.30lf\n", "%-+#5.30lf", 8127.534);
  printf("%-15s: %-+#10lf\n", "%-+#10lf", 8127.534);
  printf("%-15s: %-+#10.lf\n", "%-+#10.lf", 8127.534);
  printf("%-15s: %-+#10.0lf\n", "%-+#10.0lf", 8127.534);
  printf("%-15s: %-+#10.1lf\n", "%-+#10.1lf", 8127.534);
  printf("%-15s: %-+#10.2lf\n", "%-+#10.2lf", 8127.534);
  printf("%-15s: %-+#10.5lf\n", "%-+#10.5lf", 8127.534);
  printf("%-15s: %-+#10.10lf\n", "%-+#10.10lf", 8127.534);
  printf("%-15s: %-+#10.30lf\n", "%-+#10.30lf", 8127.534);
  printf("%-15s: %-+#30lf\n", "%-+#30lf", 8127.534);
  printf("%-15s: %-+#30.lf\n", "%-+#30.lf", 8127.534);
  printf("%-15s: %-+#30.0lf\n", "%-+#30.0lf", 8127.534);
  printf("%-15s: %-+#30.1lf\n", "%-+#30.1lf", 8127.534);
  printf("%-15s: %-+#30.2lf\n", "%-+#30.2lf", 8127.534);
  printf("%-15s: %-+#30.5lf\n", "%-+#30.5lf", 8127.534);
  printf("%-15s: %-+#30.10lf\n", "%-+#30.10lf", 8127.534);
  printf("%-15s: %-+#30.30lf\n", "%-+#30.30lf", 8127.534);
  printf("%-15s: %0+#lf\n", "%0+#lf", 8127.534);
  printf("%-15s: %0+#.lf\n", "%0+#.lf", 8127.534);
  printf("%-15s: %0+#.0lf\n", "%0+#.0lf", 8127.534);
  printf("%-15s: %0+#.1lf\n", "%0+#.1lf", 8127.534);
  printf("%-15s: %0+#.2lf\n", "%0+#.2lf", 8127.534);
  printf("%-15s: %0+#.5lf\n", "%0+#.5lf", 8127.534);
  printf("%-15s: %0+#.10lf\n", "%0+#.10lf", 8127.534);
  printf("%-15s: %0+#.30lf\n", "%0+#.30lf", 8127.534);
  printf("%-15s: %0+#1lf\n", "%0+#1lf", 8127.534);
  printf("%-15s: %0+#1.lf\n", "%0+#1.lf", 8127.534);
  printf("%-15s: %0+#1.0lf\n", "%0+#1.0lf", 8127.534);
  printf("%-15s: %0+#1.1lf\n", "%0+#1.1lf", 8127.534);
  printf("%-15s: %0+#1.2lf\n", "%0+#1.2lf", 8127.534);
  printf("%-15s: %0+#1.5lf\n", "%0+#1.5lf", 8127.534);
  printf("%-15s: %0+#1.10lf\n", "%0+#1.10lf", 8127.534);
  printf("%-15s: %0+#1.30lf\n", "%0+#1.30lf", 8127.534);
  printf("%-15s: %0+#2lf\n", "%0+#2lf", 8127.534);
  printf("%-15s: %0+#2.lf\n", "%0+#2.lf", 8127.534);
  printf("%-15s: %0+#2.0lf\n", "%0+#2.0lf", 8127.534);
  printf("%-15s: %0+#2.1lf\n", "%0+#2.1lf", 8127.534);
  printf("%-15s: %0+#2.2lf\n", "%0+#2.2lf", 8127.534);
  printf("%-15s: %0+#2.5lf\n", "%0+#2.5lf", 8127.534);
  printf("%-15s: %0+#2.10lf\n", "%0+#2.10lf", 8127.534);
  printf("%-15s: %0+#2.30lf\n", "%0+#2.30lf", 8127.534);
  printf("%-15s: %0+#5lf\n", "%0+#5lf", 8127.534);
  printf("%-15s: %0+#5.lf\n", "%0+#5.lf", 8127.534);
  printf("%-15s: %0+#5.0lf\n", "%0+#5.0lf", 8127.534);
  printf("%-15s: %0+#5.1lf\n", "%0+#5.1lf", 8127.534);
  printf("%-15s: %0+#5.2lf\n", "%0+#5.2lf", 8127.534);
  printf("%-15s: %0+#5.5lf\n", "%0+#5.5lf", 8127.534);
  printf("%-15s: %0+#5.10lf\n", "%0+#5.10lf", 8127.534);
  printf("%-15s: %0+#5.30lf\n", "%0+#5.30lf", 8127.534);
  printf("%-15s: %0+#10lf\n", "%0+#10lf", 8127.534);
  printf("%-15s: %0+#10.lf\n", "%0+#10.lf", 8127.534);
  printf("%-15s: %0+#10.0lf\n", "%0+#10.0lf", 8127.534);
  printf("%-15s: %0+#10.1lf\n", "%0+#10.1lf", 8127.534);
  printf("%-15s: %0+#10.2lf\n", "%0+#10.2lf", 8127.534);
  printf("%-15s: %0+#10.5lf\n", "%0+#10.5lf", 8127.534);
  printf("%-15s: %0+#10.10lf\n", "%0+#10.10lf", 8127.534);
  printf("%-15s: %0+#10.30lf\n", "%0+#10.30lf", 8127.534);
  printf("%-15s: %0+#30lf\n", "%0+#30lf", 8127.534);
  printf("%-15s: %0+#30.lf\n", "%0+#30.lf", 8127.534);
  printf("%-15s: %0+#30.0lf\n", "%0+#30.0lf", 8127.534);
  printf("%-15s: %0+#30.1lf\n", "%0+#30.1lf", 8127.534);
  printf("%-15s: %0+#30.2lf\n", "%0+#30.2lf", 8127.534);
  printf("%-15s: %0+#30.5lf\n", "%0+#30.5lf", 8127.534);
  printf("%-15s: %0+#30.10lf\n", "%0+#30.10lf", 8127.534);
  printf("%-15s: %0+#30.30lf\n", "%0+#30.30lf", 8127.534);
  printf("%-15s: %#-+lf\n", "%#-+lf", 8127.534);
  printf("%-15s: %#-+.lf\n", "%#-+.lf", 8127.534);
  printf("%-15s: %#-+.0lf\n", "%#-+.0lf", 8127.534);
  printf("%-15s: %#-+.1lf\n", "%#-+.1lf", 8127.534);
  printf("%-15s: %#-+.2lf\n", "%#-+.2lf", 8127.534);
  printf("%-15s: %#-+.5lf\n", "%#-+.5lf", 8127.534);
  printf("%-15s: %#-+.10lf\n", "%#-+.10lf", 8127.534);
  printf("%-15s: %#-+.30lf\n", "%#-+.30lf", 8127.534);
  printf("%-15s: %#-+1lf\n", "%#-+1lf", 8127.534);
  printf("%-15s: %#-+1.lf\n", "%#-+1.lf", 8127.534);
  printf("%-15s: %#-+1.0lf\n", "%#-+1.0lf", 8127.534);
  printf("%-15s: %#-+1.1lf\n", "%#-+1.1lf", 8127.534);
  printf("%-15s: %#-+1.2lf\n", "%#-+1.2lf", 8127.534);
  printf("%-15s: %#-+1.5lf\n", "%#-+1.5lf", 8127.534);
  printf("%-15s: %#-+1.10lf\n", "%#-+1.10lf", 8127.534);
  printf("%-15s: %#-+1.30lf\n", "%#-+1.30lf", 8127.534);
  printf("%-15s: %#-+2lf\n", "%#-+2lf", 8127.534);
  printf("%-15s: %#-+2.lf\n", "%#-+2.lf", 8127.534);
  printf("%-15s: %#-+2.0lf\n", "%#-+2.0lf", 8127.534);
  printf("%-15s: %#-+2.1lf\n", "%#-+2.1lf", 8127.534);
  printf("%-15s: %#-+2.2lf\n", "%#-+2.2lf", 8127.534);
  printf("%-15s: %#-+2.5lf\n", "%#-+2.5lf", 8127.534);
  printf("%-15s: %#-+2.10lf\n", "%#-+2.10lf", 8127.534);
  printf("%-15s: %#-+2.30lf\n", "%#-+2.30lf", 8127.534);
  printf("%-15s: %#-+5lf\n", "%#-+5lf", 8127.534);
  printf("%-15s: %#-+5.lf\n", "%#-+5.lf", 8127.534);
  printf("%-15s: %#-+5.0lf\n", "%#-+5.0lf", 8127.534);
  printf("%-15s: %#-+5.1lf\n", "%#-+5.1lf", 8127.534);
  printf("%-15s: %#-+5.2lf\n", "%#-+5.2lf", 8127.534);
  printf("%-15s: %#-+5.5lf\n", "%#-+5.5lf", 8127.534);
  printf("%-15s: %#-+5.10lf\n", "%#-+5.10lf", 8127.534);
  printf("%-15s: %#-+5.30lf\n", "%#-+5.30lf", 8127.534);
  printf("%-15s: %#-+10lf\n", "%#-+10lf", 8127.534);
  printf("%-15s: %#-+10.lf\n", "%#-+10.lf", 8127.534);
  printf("%-15s: %#-+10.0lf\n", "%#-+10.0lf", 8127.534);
  printf("%-15s: %#-+10.1lf\n", "%#-+10.1lf", 8127.534);
  printf("%-15s: %#-+10.2lf\n", "%#-+10.2lf", 8127.534);
  printf("%-15s: %#-+10.5lf\n", "%#-+10.5lf", 8127.534);
  printf("%-15s: %#-+10.10lf\n", "%#-+10.10lf", 8127.534);
  printf("%-15s: %#-+10.30lf\n", "%#-+10.30lf", 8127.534);
  printf("%-15s: %#-+30lf\n", "%#-+30lf", 8127.534);
  printf("%-15s: %#-+30.lf\n", "%#-+30.lf", 8127.534);
  printf("%-15s: %#-+30.0lf\n", "%#-+30.0lf", 8127.534);
  printf("%-15s: %#-+30.1lf\n", "%#-+30.1lf", 8127.534);
  printf("%-15s: %#-+30.2lf\n", "%#-+30.2lf", 8127.534);
  printf("%-15s: %#-+30.5lf\n", "%#-+30.5lf", 8127.534);
  printf("%-15s: %#-+30.10lf\n", "%#-+30.10lf", 8127.534);
  printf("%-15s: %#-+30.30lf\n", "%#-+30.30lf", 8127.534);
  printf("%-15s: %+#-lf\n", "%+#-lf", 8127.534);
  printf("%-15s: %+#-.lf\n", "%+#-.lf", 8127.534);
  printf("%-15s: %+#-.0lf\n", "%+#-.0lf", 8127.534);
  printf("%-15s: %+#-.1lf\n", "%+#-.1lf", 8127.534);
  printf("%-15s: %+#-.2lf\n", "%+#-.2lf", 8127.534);
  printf("%-15s: %+#-.5lf\n", "%+#-.5lf", 8127.534);
  printf("%-15s: %+#-.10lf\n", "%+#-.10lf", 8127.534);
  printf("%-15s: %+#-.30lf\n", "%+#-.30lf", 8127.534);
  printf("%-15s: %+#-1lf\n", "%+#-1lf", 8127.534);
  printf("%-15s: %+#-1.lf\n", "%+#-1.lf", 8127.534);
  printf("%-15s: %+#-1.0lf\n", "%+#-1.0lf", 8127.534);
  printf("%-15s: %+#-1.1lf\n", "%+#-1.1lf", 8127.534);
  printf("%-15s: %+#-1.2lf\n", "%+#-1.2lf", 8127.534);
  printf("%-15s: %+#-1.5lf\n", "%+#-1.5lf", 8127.534);
  printf("%-15s: %+#-1.10lf\n", "%+#-1.10lf", 8127.534);
  printf("%-15s: %+#-1.30lf\n", "%+#-1.30lf", 8127.534);
  printf("%-15s: %+#-2lf\n", "%+#-2lf", 8127.534);
  printf("%-15s: %+#-2.lf\n", "%+#-2.lf", 8127.534);
  printf("%-15s: %+#-2.0lf\n", "%+#-2.0lf", 8127.534);
  printf("%-15s: %+#-2.1lf\n", "%+#-2.1lf", 8127.534);
  printf("%-15s: %+#-2.2lf\n", "%+#-2.2lf", 8127.534);
  printf("%-15s: %+#-2.5lf\n", "%+#-2.5lf", 8127.534);
  printf("%-15s: %+#-2.10lf\n", "%+#-2.10lf", 8127.534);
  printf("%-15s: %+#-2.30lf\n", "%+#-2.30lf", 8127.534);
  printf("%-15s: %+#-5lf\n", "%+#-5lf", 8127.534);
  printf("%-15s: %+#-5.lf\n", "%+#-5.lf", 8127.534);
  printf("%-15s: %+#-5.0lf\n", "%+#-5.0lf", 8127.534);
  printf("%-15s: %+#-5.1lf\n", "%+#-5.1lf", 8127.534);
  printf("%-15s: %+#-5.2lf\n", "%+#-5.2lf", 8127.534);
  printf("%-15s: %+#-5.5lf\n", "%+#-5.5lf", 8127.534);
  printf("%-15s: %+#-5.10lf\n", "%+#-5.10lf", 8127.534);
  printf("%-15s: %+#-5.30lf\n", "%+#-5.30lf", 8127.534);
  printf("%-15s: %+#-10lf\n", "%+#-10lf", 8127.534);
  printf("%-15s: %+#-10.lf\n", "%+#-10.lf", 8127.534);
  printf("%-15s: %+#-10.0lf\n", "%+#-10.0lf", 8127.534);
  printf("%-15s: %+#-10.1lf\n", "%+#-10.1lf", 8127.534);
  printf("%-15s: %+#-10.2lf\n", "%+#-10.2lf", 8127.534);
  printf("%-15s: %+#-10.5lf\n", "%+#-10.5lf", 8127.534);
  printf("%-15s: %+#-10.10lf\n", "%+#-10.10lf", 8127.534);
  printf("%-15s: %+#-10.30lf\n", "%+#-10.30lf", 8127.534);
  printf("%-15s: %+#-30lf\n", "%+#-30lf", 8127.534);
  printf("%-15s: %+#-30.lf\n", "%+#-30.lf", 8127.534);
  printf("%-15s: %+#-30.0lf\n", "%+#-30.0lf", 8127.534);
  printf("%-15s: %+#-30.1lf\n", "%+#-30.1lf", 8127.534);
  printf("%-15s: %+#-30.2lf\n", "%+#-30.2lf", 8127.534);
  printf("%-15s: %+#-30.5lf\n", "%+#-30.5lf", 8127.534);
  printf("%-15s: %+#-30.10lf\n", "%+#-30.10lf", 8127.534);
  printf("%-15s: %+#-30.30lf\n", "%+#-30.30lf", 8127.534);
  printf("%-15s: %+F\n", "%+F", 8127.534f);
  printf("%-15s: %+.F\n", "%+.F", 8127.534f);
  printf("%-15s: %+.0F\n", "%+.0F", 8127.534f);
  printf("%-15s: %+.1F\n", "%+.1F", 8127.534f);
  printf("%-15s: %+.2F\n", "%+.2F", 8127.534f);
  printf("%-15s: %+.5F\n", "%+.5F", 8127.534f);
  printf("%-15s: %+.10F\n", "%+.10F", 8127.534f);
  printf("%-15s: %+.30F\n", "%+.30F", 8127.534f);
  printf("%-15s: %+0F\n", "%+0F", 8127.534f);
  printf("%-15s: %+0.F\n", "%+0.F", 8127.534f);
  printf("%-15s: %+0.0F\n", "%+0.0F", 8127.534f);
  printf("%-15s: %+0.1F\n", "%+0.1F", 8127.534f);
  printf("%-15s: %+0.2F\n", "%+0.2F", 8127.534f);
  printf("%-15s: %+0.5F\n", "%+0.5F", 8127.534f);
  printf("%-15s: %+0.10F\n", "%+0.10F", 8127.534f);
  printf("%-15s: %+0.30F\n", "%+0.30F", 8127.534f);
  printf("%-15s: %+1F\n", "%+1F", 8127.534f);
  printf("%-15s: %+1.F\n", "%+1.F", 8127.534f);
  printf("%-15s: %+1.0F\n", "%+1.0F", 8127.534f);
  printf("%-15s: %+1.1F\n", "%+1.1F", 8127.534f);
  printf("%-15s: %+1.2F\n", "%+1.2F", 8127.534f);
  printf("%-15s: %+1.5F\n", "%+1.5F", 8127.534f);
  printf("%-15s: %+1.10F\n", "%+1.10F", 8127.534f);
  printf("%-15s: %+1.30F\n", "%+1.30F", 8127.534f);
  printf("%-15s: %+2F\n", "%+2F", 8127.534f);
  printf("%-15s: %+2.F\n", "%+2.F", 8127.534f);
  printf("%-15s: %+2.0F\n", "%+2.0F", 8127.534f);
  printf("%-15s: %+2.1F\n", "%+2.1F", 8127.534f);
  printf("%-15s: %+2.2F\n", "%+2.2F", 8127.534f);
  printf("%-15s: %+2.5F\n", "%+2.5F", 8127.534f);
  printf("%-15s: %+2.10F\n", "%+2.10F", 8127.534f);
  printf("%-15s: %+2.30F\n", "%+2.30F", 8127.534f);
  printf("%-15s: %+5F\n", "%+5F", 8127.534f);
  printf("%-15s: %+5.F\n", "%+5.F", 8127.534f);
  printf("%-15s: %+5.0F\n", "%+5.0F", 8127.534f);
  printf("%-15s: %+5.1F\n", "%+5.1F", 8127.534f);
  printf("%-15s: %+5.2F\n", "%+5.2F", 8127.534f);
  printf("%-15s: %+5.5F\n", "%+5.5F", 8127.534f);
  printf("%-15s: %+5.10F\n", "%+5.10F", 8127.534f);
  printf("%-15s: %+5.30F\n", "%+5.30F", 8127.534f);
  printf("%-15s: %+10F\n", "%+10F", 8127.534f);
  printf("%-15s: %+10.F\n", "%+10.F", 8127.534f);
  printf("%-15s: %+10.0F\n", "%+10.0F", 8127.534f);
  printf("%-15s: %+10.1F\n", "%+10.1F", 8127.534f);
  printf("%-15s: %+10.2F\n", "%+10.2F", 8127.534f);
  printf("%-15s: %+10.5F\n", "%+10.5F", 8127.534f);
  printf("%-15s: %+10.10F\n", "%+10.10F", 8127.534f);
  printf("%-15s: %+10.30F\n", "%+10.30F", 8127.534f);
  printf("%-15s: %+30F\n", "%+30F", 8127.534f);
  printf("%-15s: %+30.F\n", "%+30.F", 8127.534f);
  printf("%-15s: %+30.0F\n", "%+30.0F", 8127.534f);
  printf("%-15s: %+30.1F\n", "%+30.1F", 8127.534f);
  printf("%-15s: %+30.2F\n", "%+30.2F", 8127.534f);
  printf("%-15s: %+30.5F\n", "%+30.5F", 8127.534f);
  printf("%-15s: %+30.10F\n", "%+30.10F", 8127.534f);
  printf("%-15s: %+30.30F\n", "%+30.30F", 8127.534f);
  printf("%-15s: %-F\n", "%-F", 8127.534f);
  printf("%-15s: %-.F\n", "%-.F", 8127.534f);
  printf("%-15s: %-.0F\n", "%-.0F", 8127.534f);
  printf("%-15s: %-.1F\n", "%-.1F", 8127.534f);
  printf("%-15s: %-.2F\n", "%-.2F", 8127.534f);
  printf("%-15s: %-.5F\n", "%-.5F", 8127.534f);
  printf("%-15s: %-.10F\n", "%-.10F", 8127.534f);
  printf("%-15s: %-.30F\n", "%-.30F", 8127.534f);
  printf("%-15s: %-1F\n", "%-1F", 8127.534f);
  printf("%-15s: %-1.F\n", "%-1.F", 8127.534f);
  printf("%-15s: %-1.0F\n", "%-1.0F", 8127.534f);
  printf("%-15s: %-1.1F\n", "%-1.1F", 8127.534f);
  printf("%-15s: %-1.2F\n", "%-1.2F", 8127.534f);
  printf("%-15s: %-1.5F\n", "%-1.5F", 8127.534f);
  printf("%-15s: %-1.10F\n", "%-1.10F", 8127.534f);
  printf("%-15s: %-1.30F\n", "%-1.30F", 8127.534f);
  printf("%-15s: %-2F\n", "%-2F", 8127.534f);
  printf("%-15s: %-2.F\n", "%-2.F", 8127.534f);
  printf("%-15s: %-2.0F\n", "%-2.0F", 8127.534f);
  printf("%-15s: %-2.1F\n", "%-2.1F", 8127.534f);
  printf("%-15s: %-2.2F\n", "%-2.2F", 8127.534f);
  printf("%-15s: %-2.5F\n", "%-2.5F", 8127.534f);
  printf("%-15s: %-2.10F\n", "%-2.10F", 8127.534f);
  printf("%-15s: %-2.30F\n", "%-2.30F", 8127.534f);
  printf("%-15s: %-5F\n", "%-5F", 8127.534f);
  printf("%-15s: %-5.F\n", "%-5.F", 8127.534f);
  printf("%-15s: %-5.0F\n", "%-5.0F", 8127.534f);
  printf("%-15s: %-5.1F\n", "%-5.1F", 8127.534f);
  printf("%-15s: %-5.2F\n", "%-5.2F", 8127.534f);
  printf("%-15s: %-5.5F\n", "%-5.5F", 8127.534f);
  printf("%-15s: %-5.10F\n", "%-5.10F", 8127.534f);
  printf("%-15s: %-5.30F\n", "%-5.30F", 8127.534f);
  printf("%-15s: %-10F\n", "%-10F", 8127.534f);
  printf("%-15s: %-10.F\n", "%-10.F", 8127.534f);
  printf("%-15s: %-10.0F\n", "%-10.0F", 8127.534f);
  printf("%-15s: %-10.1F\n", "%-10.1F", 8127.534f);
  printf("%-15s: %-10.2F\n", "%-10.2F", 8127.534f);
  printf("%-15s: %-10.5F\n", "%-10.5F", 8127.534f);
  printf("%-15s: %-10.10F\n", "%-10.10F", 8127.534f);
  printf("%-15s: %-10.30F\n", "%-10.30F", 8127.534f);
  printf("%-15s: %-30F\n", "%-30F", 8127.534f);
  printf("%-15s: %-30.F\n", "%-30.F", 8127.534f);
  printf("%-15s: %-30.0F\n", "%-30.0F", 8127.534f);
  printf("%-15s: %-30.1F\n", "%-30.1F", 8127.534f);
  printf("%-15s: %-30.2F\n", "%-30.2F", 8127.534f);
  printf("%-15s: %-30.5F\n", "%-30.5F", 8127.534f);
  printf("%-15s: %-30.10F\n", "%-30.10F", 8127.534f);
  printf("%-15s: %-30.30F\n", "%-30.30F", 8127.534f);
  printf("%-15s: %#F\n", "%#F", 8127.534f);
  printf("%-15s: %#.F\n", "%#.F", 8127.534f);
  printf("%-15s: %#.0F\n", "%#.0F", 8127.534f);
  printf("%-15s: %#.1F\n", "%#.1F", 8127.534f);
  printf("%-15s: %#.2F\n", "%#.2F", 8127.534f);
  printf("%-15s: %#.5F\n", "%#.5F", 8127.534f);
  printf("%-15s: %#.10F\n", "%#.10F", 8127.534f);
  printf("%-15s: %#.30F\n", "%#.30F", 8127.534f);
  printf("%-15s: %#0F\n", "%#0F", 8127.534f);
  printf("%-15s: %#0.F\n", "%#0.F", 8127.534f);
  printf("%-15s: %#0.0F\n", "%#0.0F", 8127.534f);
  printf("%-15s: %#0.1F\n", "%#0.1F", 8127.534f);
  printf("%-15s: %#0.2F\n", "%#0.2F", 8127.534f);
  printf("%-15s: %#0.5F\n", "%#0.5F", 8127.534f);
  printf("%-15s: %#0.10F\n", "%#0.10F", 8127.534f);
  printf("%-15s: %#0.30F\n", "%#0.30F", 8127.534f);
  printf("%-15s: %#1F\n", "%#1F", 8127.534f);
  printf("%-15s: %#1.F\n", "%#1.F", 8127.534f);
  printf("%-15s: %#1.0F\n", "%#1.0F", 8127.534f);
  printf("%-15s: %#1.1F\n", "%#1.1F", 8127.534f);
  printf("%-15s: %#1.2F\n", "%#1.2F", 8127.534f);
  printf("%-15s: %#1.5F\n", "%#1.5F", 8127.534f);
  printf("%-15s: %#1.10F\n", "%#1.10F", 8127.534f);
  printf("%-15s: %#1.30F\n", "%#1.30F", 8127.534f);
  printf("%-15s: %#2F\n", "%#2F", 8127.534f);
  printf("%-15s: %#2.F\n", "%#2.F", 8127.534f);
  printf("%-15s: %#2.0F\n", "%#2.0F", 8127.534f);
  printf("%-15s: %#2.1F\n", "%#2.1F", 8127.534f);
  printf("%-15s: %#2.2F\n", "%#2.2F", 8127.534f);
  printf("%-15s: %#2.5F\n", "%#2.5F", 8127.534f);
  printf("%-15s: %#2.10F\n", "%#2.10F", 8127.534f);
  printf("%-15s: %#2.30F\n", "%#2.30F", 8127.534f);
  printf("%-15s: %#5F\n", "%#5F", 8127.534f);
  printf("%-15s: %#5.F\n", "%#5.F", 8127.534f);
  printf("%-15s: %#5.0F\n", "%#5.0F", 8127.534f);
  printf("%-15s: %#5.1F\n", "%#5.1F", 8127.534f);
  printf("%-15s: %#5.2F\n", "%#5.2F", 8127.534f);
  printf("%-15s: %#5.5F\n", "%#5.5F", 8127.534f);
  printf("%-15s: %#5.10F\n", "%#5.10F", 8127.534f);
  printf("%-15s: %#5.30F\n", "%#5.30F", 8127.534f);
  printf("%-15s: %#10F\n", "%#10F", 8127.534f);
  printf("%-15s: %#10.F\n", "%#10.F", 8127.534f);
  printf("%-15s: %#10.0F\n", "%#10.0F", 8127.534f);
  printf("%-15s: %#10.1F\n", "%#10.1F", 8127.534f);
  printf("%-15s: %#10.2F\n", "%#10.2F", 8127.534f);
  printf("%-15s: %#10.5F\n", "%#10.5F", 8127.534f);
  printf("%-15s: %#10.10F\n", "%#10.10F", 8127.534f);
  printf("%-15s: %#10.30F\n", "%#10.30F", 8127.534f);
  printf("%-15s: %#30F\n", "%#30F", 8127.534f);
  printf("%-15s: %#30.F\n", "%#30.F", 8127.534f);
  printf("%-15s: %#30.0F\n", "%#30.0F", 8127.534f);
  printf("%-15s: %#30.1F\n", "%#30.1F", 8127.534f);
  printf("%-15s: %#30.2F\n", "%#30.2F", 8127.534f);
  printf("%-15s: %#30.5F\n", "%#30.5F", 8127.534f);
  printf("%-15s: %#30.10F\n", "%#30.10F", 8127.534f);
  printf("%-15s: %#30.30F\n", "%#30.30F", 8127.534f);
  printf("%-15s: %0F\n", "%0F", 8127.534f);
  printf("%-15s: %0.F\n", "%0.F", 8127.534f);
  printf("%-15s: %0.0F\n", "%0.0F", 8127.534f);
  printf("%-15s: %0.1F\n", "%0.1F", 8127.534f);
  printf("%-15s: %0.2F\n", "%0.2F", 8127.534f);
  printf("%-15s: %0.5F\n", "%0.5F", 8127.534f);
  printf("%-15s: %0.10F\n", "%0.10F", 8127.534f);
  printf("%-15s: %0.30F\n", "%0.30F", 8127.534f);
  printf("%-15s: %01F\n", "%01F", 8127.534f);
  printf("%-15s: %01.F\n", "%01.F", 8127.534f);
  printf("%-15s: %01.0F\n", "%01.0F", 8127.534f);
  printf("%-15s: %01.1F\n", "%01.1F", 8127.534f);
  printf("%-15s: %01.2F\n", "%01.2F", 8127.534f);
  printf("%-15s: %01.5F\n", "%01.5F", 8127.534f);
  printf("%-15s: %01.10F\n", "%01.10F", 8127.534f);
  printf("%-15s: %01.30F\n", "%01.30F", 8127.534f);
  printf("%-15s: %02F\n", "%02F", 8127.534f);
  printf("%-15s: %02.F\n", "%02.F", 8127.534f);
  printf("%-15s: %02.0F\n", "%02.0F", 8127.534f);
  printf("%-15s: %02.1F\n", "%02.1F", 8127.534f);
  printf("%-15s: %02.2F\n", "%02.2F", 8127.534f);
  printf("%-15s: %02.5F\n", "%02.5F", 8127.534f);
  printf("%-15s: %02.10F\n", "%02.10F", 8127.534f);
  printf("%-15s: %02.30F\n", "%02.30F", 8127.534f);
  printf("%-15s: %05F\n", "%05F", 8127.534f);
  printf("%-15s: %05.F\n", "%05.F", 8127.534f);
  printf("%-15s: %05.0F\n", "%05.0F", 8127.534f);
  printf("%-15s: %05.1F\n", "%05.1F", 8127.534f);
  printf("%-15s: %05.2F\n", "%05.2F", 8127.534f);
  printf("%-15s: %05.5F\n", "%05.5F", 8127.534f);
  printf("%-15s: %05.10F\n", "%05.10F", 8127.534f);
  printf("%-15s: %05.30F\n", "%05.30F", 8127.534f);
  printf("%-15s: %010F\n", "%010F", 8127.534f);
  printf("%-15s: %010.F\n", "%010.F", 8127.534f);
  printf("%-15s: %010.0F\n", "%010.0F", 8127.534f);
  printf("%-15s: %010.1F\n", "%010.1F", 8127.534f);
  printf("%-15s: %010.2F\n", "%010.2F", 8127.534f);
  printf("%-15s: %010.5F\n", "%010.5F", 8127.534f);
  printf("%-15s: %010.10F\n", "%010.10F", 8127.534f);
  printf("%-15s: %010.30F\n", "%010.30F", 8127.534f);
  printf("%-15s: %030F\n", "%030F", 8127.534f);
  printf("%-15s: %030.F\n", "%030.F", 8127.534f);
  printf("%-15s: %030.0F\n", "%030.0F", 8127.534f);
  printf("%-15s: %030.1F\n", "%030.1F", 8127.534f);
  printf("%-15s: %030.2F\n", "%030.2F", 8127.534f);
  printf("%-15s: %030.5F\n", "%030.5F", 8127.534f);
  printf("%-15s: %030.10F\n", "%030.10F", 8127.534f);
  printf("%-15s: %030.30F\n", "%030.30F", 8127.534f);
  printf("%-15s: %-+F\n", "%-+F", 8127.534f);
  printf("%-15s: %-+.F\n", "%-+.F", 8127.534f);
  printf("%-15s: %-+.0F\n", "%-+.0F", 8127.534f);
  printf("%-15s: %-+.1F\n", "%-+.1F", 8127.534f);
  printf("%-15s: %-+.2F\n", "%-+.2F", 8127.534f);
  printf("%-15s: %-+.5F\n", "%-+.5F", 8127.534f);
  printf("%-15s: %-+.10F\n", "%-+.10F", 8127.534f);
  printf("%-15s: %-+.30F\n", "%-+.30F", 8127.534f);
  printf("%-15s: %-+1F\n", "%-+1F", 8127.534f);
  printf("%-15s: %-+1.F\n", "%-+1.F", 8127.534f);
  printf("%-15s: %-+1.0F\n", "%-+1.0F", 8127.534f);
  printf("%-15s: %-+1.1F\n", "%-+1.1F", 8127.534f);
  printf("%-15s: %-+1.2F\n", "%-+1.2F", 8127.534f);
  printf("%-15s: %-+1.5F\n", "%-+1.5F", 8127.534f);
  printf("%-15s: %-+1.10F\n", "%-+1.10F", 8127.534f);
  printf("%-15s: %-+1.30F\n", "%-+1.30F", 8127.534f);
  printf("%-15s: %-+2F\n", "%-+2F", 8127.534f);
  printf("%-15s: %-+2.F\n", "%-+2.F", 8127.534f);
  printf("%-15s: %-+2.0F\n", "%-+2.0F", 8127.534f);
  printf("%-15s: %-+2.1F\n", "%-+2.1F", 8127.534f);
  printf("%-15s: %-+2.2F\n", "%-+2.2F", 8127.534f);
  printf("%-15s: %-+2.5F\n", "%-+2.5F", 8127.534f);
  printf("%-15s: %-+2.10F\n", "%-+2.10F", 8127.534f);
  printf("%-15s: %-+2.30F\n", "%-+2.30F", 8127.534f);
  printf("%-15s: %-+5F\n", "%-+5F", 8127.534f);
  printf("%-15s: %-+5.F\n", "%-+5.F", 8127.534f);
  printf("%-15s: %-+5.0F\n", "%-+5.0F", 8127.534f);
  printf("%-15s: %-+5.1F\n", "%-+5.1F", 8127.534f);
  printf("%-15s: %-+5.2F\n", "%-+5.2F", 8127.534f);
  printf("%-15s: %-+5.5F\n", "%-+5.5F", 8127.534f);
  printf("%-15s: %-+5.10F\n", "%-+5.10F", 8127.534f);
  printf("%-15s: %-+5.30F\n", "%-+5.30F", 8127.534f);
  printf("%-15s: %-+10F\n", "%-+10F", 8127.534f);
  printf("%-15s: %-+10.F\n", "%-+10.F", 8127.534f);
  printf("%-15s: %-+10.0F\n", "%-+10.0F", 8127.534f);
  printf("%-15s: %-+10.1F\n", "%-+10.1F", 8127.534f);
  printf("%-15s: %-+10.2F\n", "%-+10.2F", 8127.534f);
  printf("%-15s: %-+10.5F\n", "%-+10.5F", 8127.534f);
  printf("%-15s: %-+10.10F\n", "%-+10.10F", 8127.534f);
  printf("%-15s: %-+10.30F\n", "%-+10.30F", 8127.534f);
  printf("%-15s: %-+30F\n", "%-+30F", 8127.534f);
  printf("%-15s: %-+30.F\n", "%-+30.F", 8127.534f);
  printf("%-15s: %-+30.0F\n", "%-+30.0F", 8127.534f);
  printf("%-15s: %-+30.1F\n", "%-+30.1F", 8127.534f);
  printf("%-15s: %-+30.2F\n", "%-+30.2F", 8127.534f);
  printf("%-15s: %-+30.5F\n", "%-+30.5F", 8127.534f);
  printf("%-15s: %-+30.10F\n", "%-+30.10F", 8127.534f);
  printf("%-15s: %-+30.30F\n", "%-+30.30F", 8127.534f);
  printf("%-15s: %#+F\n", "%#+F", 8127.534f);
  printf("%-15s: %#+.F\n", "%#+.F", 8127.534f);
  printf("%-15s: %#+.0F\n", "%#+.0F", 8127.534f);
  printf("%-15s: %#+.1F\n", "%#+.1F", 8127.534f);
  printf("%-15s: %#+.2F\n", "%#+.2F", 8127.534f);
  printf("%-15s: %#+.5F\n", "%#+.5F", 8127.534f);
  printf("%-15s: %#+.10F\n", "%#+.10F", 8127.534f);
  printf("%-15s: %#+.30F\n", "%#+.30F", 8127.534f);
  printf("%-15s: %#+0F\n", "%#+0F", 8127.534f);
  printf("%-15s: %#+0.F\n", "%#+0.F", 8127.534f);
  printf("%-15s: %#+0.0F\n", "%#+0.0F", 8127.534f);
  printf("%-15s: %#+0.1F\n", "%#+0.1F", 8127.534f);
  printf("%-15s: %#+0.2F\n", "%#+0.2F", 8127.534f);
  printf("%-15s: %#+0.5F\n", "%#+0.5F", 8127.534f);
  printf("%-15s: %#+0.10F\n", "%#+0.10F", 8127.534f);
  printf("%-15s: %#+0.30F\n", "%#+0.30F", 8127.534f);
  printf("%-15s: %#+1F\n", "%#+1F", 8127.534f);
  printf("%-15s: %#+1.F\n", "%#+1.F", 8127.534f);
  printf("%-15s: %#+1.0F\n", "%#+1.0F", 8127.534f);
  printf("%-15s: %#+1.1F\n", "%#+1.1F", 8127.534f);
  printf("%-15s: %#+1.2F\n", "%#+1.2F", 8127.534f);
  printf("%-15s: %#+1.5F\n", "%#+1.5F", 8127.534f);
  printf("%-15s: %#+1.10F\n", "%#+1.10F", 8127.534f);
  printf("%-15s: %#+1.30F\n", "%#+1.30F", 8127.534f);
  printf("%-15s: %#+2F\n", "%#+2F", 8127.534f);
  printf("%-15s: %#+2.F\n", "%#+2.F", 8127.534f);
  printf("%-15s: %#+2.0F\n", "%#+2.0F", 8127.534f);
  printf("%-15s: %#+2.1F\n", "%#+2.1F", 8127.534f);
  printf("%-15s: %#+2.2F\n", "%#+2.2F", 8127.534f);
  printf("%-15s: %#+2.5F\n", "%#+2.5F", 8127.534f);
  printf("%-15s: %#+2.10F\n", "%#+2.10F", 8127.534f);
  printf("%-15s: %#+2.30F\n", "%#+2.30F", 8127.534f);
  printf("%-15s: %#+5F\n", "%#+5F", 8127.534f);
  printf("%-15s: %#+5.F\n", "%#+5.F", 8127.534f);
  printf("%-15s: %#+5.0F\n", "%#+5.0F", 8127.534f);
  printf("%-15s: %#+5.1F\n", "%#+5.1F", 8127.534f);
  printf("%-15s: %#+5.2F\n", "%#+5.2F", 8127.534f);
  printf("%-15s: %#+5.5F\n", "%#+5.5F", 8127.534f);
  printf("%-15s: %#+5.10F\n", "%#+5.10F", 8127.534f);
  printf("%-15s: %#+5.30F\n", "%#+5.30F", 8127.534f);
  printf("%-15s: %#+10F\n", "%#+10F", 8127.534f);
  printf("%-15s: %#+10.F\n", "%#+10.F", 8127.534f);
  printf("%-15s: %#+10.0F\n", "%#+10.0F", 8127.534f);
  printf("%-15s: %#+10.1F\n", "%#+10.1F", 8127.534f);
  printf("%-15s: %#+10.2F\n", "%#+10.2F", 8127.534f);
  printf("%-15s: %#+10.5F\n", "%#+10.5F", 8127.534f);
  printf("%-15s: %#+10.10F\n", "%#+10.10F", 8127.534f);
  printf("%-15s: %#+10.30F\n", "%#+10.30F", 8127.534f);
  printf("%-15s: %#+30F\n", "%#+30F", 8127.534f);
  printf("%-15s: %#+30.F\n", "%#+30.F", 8127.534f);
  printf("%-15s: %#+30.0F\n", "%#+30.0F", 8127.534f);
  printf("%-15s: %#+30.1F\n", "%#+30.1F", 8127.534f);
  printf("%-15s: %#+30.2F\n", "%#+30.2F", 8127.534f);
  printf("%-15s: %#+30.5F\n", "%#+30.5F", 8127.534f);
  printf("%-15s: %#+30.10F\n", "%#+30.10F", 8127.534f);
  printf("%-15s: %#+30.30F\n", "%#+30.30F", 8127.534f);
  printf("%-15s: %+0F\n", "%+0F", 8127.534f);
  printf("%-15s: %+0.F\n", "%+0.F", 8127.534f);
  printf("%-15s: %+0.0F\n", "%+0.0F", 8127.534f);
  printf("%-15s: %+0.1F\n", "%+0.1F", 8127.534f);
  printf("%-15s: %+0.2F\n", "%+0.2F", 8127.534f);
  printf("%-15s: %+0.5F\n", "%+0.5F", 8127.534f);
  printf("%-15s: %+0.10F\n", "%+0.10F", 8127.534f);
  printf("%-15s: %+0.30F\n", "%+0.30F", 8127.534f);
  printf("%-15s: %+01F\n", "%+01F", 8127.534f);
  printf("%-15s: %+01.F\n", "%+01.F", 8127.534f);
  printf("%-15s: %+01.0F\n", "%+01.0F", 8127.534f);
  printf("%-15s: %+01.1F\n", "%+01.1F", 8127.534f);
  printf("%-15s: %+01.2F\n", "%+01.2F", 8127.534f);
  printf("%-15s: %+01.5F\n", "%+01.5F", 8127.534f);
  printf("%-15s: %+01.10F\n", "%+01.10F", 8127.534f);
  printf("%-15s: %+01.30F\n", "%+01.30F", 8127.534f);
  printf("%-15s: %+02F\n", "%+02F", 8127.534f);
  printf("%-15s: %+02.F\n", "%+02.F", 8127.534f);
  printf("%-15s: %+02.0F\n", "%+02.0F", 8127.534f);
  printf("%-15s: %+02.1F\n", "%+02.1F", 8127.534f);
  printf("%-15s: %+02.2F\n", "%+02.2F", 8127.534f);
  printf("%-15s: %+02.5F\n", "%+02.5F", 8127.534f);
  printf("%-15s: %+02.10F\n", "%+02.10F", 8127.534f);
  printf("%-15s: %+02.30F\n", "%+02.30F", 8127.534f);
  printf("%-15s: %+05F\n", "%+05F", 8127.534f);
  printf("%-15s: %+05.F\n", "%+05.F", 8127.534f);
  printf("%-15s: %+05.0F\n", "%+05.0F", 8127.534f);
  printf("%-15s: %+05.1F\n", "%+05.1F", 8127.534f);
  printf("%-15s: %+05.2F\n", "%+05.2F", 8127.534f);
  printf("%-15s: %+05.5F\n", "%+05.5F", 8127.534f);
  printf("%-15s: %+05.10F\n", "%+05.10F", 8127.534f);
  printf("%-15s: %+05.30F\n", "%+05.30F", 8127.534f);
  printf("%-15s: %+010F\n", "%+010F", 8127.534f);
  printf("%-15s: %+010.F\n", "%+010.F", 8127.534f);
  printf("%-15s: %+010.0F\n", "%+010.0F", 8127.534f);
  printf("%-15s: %+010.1F\n", "%+010.1F", 8127.534f);
  printf("%-15s: %+010.2F\n", "%+010.2F", 8127.534f);
  printf("%-15s: %+010.5F\n", "%+010.5F", 8127.534f);
  printf("%-15s: %+010.10F\n", "%+010.10F", 8127.534f);
  printf("%-15s: %+010.30F\n", "%+010.30F", 8127.534f);
  printf("%-15s: %+030F\n", "%+030F", 8127.534f);
  printf("%-15s: %+030.F\n", "%+030.F", 8127.534f);
  printf("%-15s: %+030.0F\n", "%+030.0F", 8127.534f);
  printf("%-15s: %+030.1F\n", "%+030.1F", 8127.534f);
  printf("%-15s: %+030.2F\n", "%+030.2F", 8127.534f);
  printf("%-15s: %+030.5F\n", "%+030.5F", 8127.534f);
  printf("%-15s: %+030.10F\n", "%+030.10F", 8127.534f);
  printf("%-15s: %+030.30F\n", "%+030.30F", 8127.534f);
  printf("%-15s: %+-F\n", "%+-F", 8127.534f);
  printf("%-15s: %+-.F\n", "%+-.F", 8127.534f);
  printf("%-15s: %+-.0F\n", "%+-.0F", 8127.534f);
  printf("%-15s: %+-.1F\n", "%+-.1F", 8127.534f);
  printf("%-15s: %+-.2F\n", "%+-.2F", 8127.534f);
  printf("%-15s: %+-.5F\n", "%+-.5F", 8127.534f);
  printf("%-15s: %+-.10F\n", "%+-.10F", 8127.534f);
  printf("%-15s: %+-.30F\n", "%+-.30F", 8127.534f);
  printf("%-15s: %+-1F\n", "%+-1F", 8127.534f);
  printf("%-15s: %+-1.F\n", "%+-1.F", 8127.534f);
  printf("%-15s: %+-1.0F\n", "%+-1.0F", 8127.534f);
  printf("%-15s: %+-1.1F\n", "%+-1.1F", 8127.534f);
  printf("%-15s: %+-1.2F\n", "%+-1.2F", 8127.534f);
  printf("%-15s: %+-1.5F\n", "%+-1.5F", 8127.534f);
  printf("%-15s: %+-1.10F\n", "%+-1.10F", 8127.534f);
  printf("%-15s: %+-1.30F\n", "%+-1.30F", 8127.534f);
  printf("%-15s: %+-2F\n", "%+-2F", 8127.534f);
  printf("%-15s: %+-2.F\n", "%+-2.F", 8127.534f);
  printf("%-15s: %+-2.0F\n", "%+-2.0F", 8127.534f);
  printf("%-15s: %+-2.1F\n", "%+-2.1F", 8127.534f);
  printf("%-15s: %+-2.2F\n", "%+-2.2F", 8127.534f);
  printf("%-15s: %+-2.5F\n", "%+-2.5F", 8127.534f);
  printf("%-15s: %+-2.10F\n", "%+-2.10F", 8127.534f);
  printf("%-15s: %+-2.30F\n", "%+-2.30F", 8127.534f);
  printf("%-15s: %+-5F\n", "%+-5F", 8127.534f);
  printf("%-15s: %+-5.F\n", "%+-5.F", 8127.534f);
  printf("%-15s: %+-5.0F\n", "%+-5.0F", 8127.534f);
  printf("%-15s: %+-5.1F\n", "%+-5.1F", 8127.534f);
  printf("%-15s: %+-5.2F\n", "%+-5.2F", 8127.534f);
  printf("%-15s: %+-5.5F\n", "%+-5.5F", 8127.534f);
  printf("%-15s: %+-5.10F\n", "%+-5.10F", 8127.534f);
  printf("%-15s: %+-5.30F\n", "%+-5.30F", 8127.534f);
  printf("%-15s: %+-10F\n", "%+-10F", 8127.534f);
  printf("%-15s: %+-10.F\n", "%+-10.F", 8127.534f);
  printf("%-15s: %+-10.0F\n", "%+-10.0F", 8127.534f);
  printf("%-15s: %+-10.1F\n", "%+-10.1F", 8127.534f);
  printf("%-15s: %+-10.2F\n", "%+-10.2F", 8127.534f);
  printf("%-15s: %+-10.5F\n", "%+-10.5F", 8127.534f);
  printf("%-15s: %+-10.10F\n", "%+-10.10F", 8127.534f);
  printf("%-15s: %+-10.30F\n", "%+-10.30F", 8127.534f);
  printf("%-15s: %+-30F\n", "%+-30F", 8127.534f);
  printf("%-15s: %+-30.F\n", "%+-30.F", 8127.534f);
  printf("%-15s: %+-30.0F\n", "%+-30.0F", 8127.534f);
  printf("%-15s: %+-30.1F\n", "%+-30.1F", 8127.534f);
  printf("%-15s: %+-30.2F\n", "%+-30.2F", 8127.534f);
  printf("%-15s: %+-30.5F\n", "%+-30.5F", 8127.534f);
  printf("%-15s: %+-30.10F\n", "%+-30.10F", 8127.534f);
  printf("%-15s: %+-30.30F\n", "%+-30.30F", 8127.534f);
  printf("%-15s: %#-F\n", "%#-F", 8127.534f);
  printf("%-15s: %#-.F\n", "%#-.F", 8127.534f);
  printf("%-15s: %#-.0F\n", "%#-.0F", 8127.534f);
  printf("%-15s: %#-.1F\n", "%#-.1F", 8127.534f);
  printf("%-15s: %#-.2F\n", "%#-.2F", 8127.534f);
  printf("%-15s: %#-.5F\n", "%#-.5F", 8127.534f);
  printf("%-15s: %#-.10F\n", "%#-.10F", 8127.534f);
  printf("%-15s: %#-.30F\n", "%#-.30F", 8127.534f);
  printf("%-15s: %#-1F\n", "%#-1F", 8127.534f);
  printf("%-15s: %#-1.F\n", "%#-1.F", 8127.534f);
  printf("%-15s: %#-1.0F\n", "%#-1.0F", 8127.534f);
  printf("%-15s: %#-1.1F\n", "%#-1.1F", 8127.534f);
  printf("%-15s: %#-1.2F\n", "%#-1.2F", 8127.534f);
  printf("%-15s: %#-1.5F\n", "%#-1.5F", 8127.534f);
  printf("%-15s: %#-1.10F\n", "%#-1.10F", 8127.534f);
  printf("%-15s: %#-1.30F\n", "%#-1.30F", 8127.534f);
  printf("%-15s: %#-2F\n", "%#-2F", 8127.534f);
  printf("%-15s: %#-2.F\n", "%#-2.F", 8127.534f);
  printf("%-15s: %#-2.0F\n", "%#-2.0F", 8127.534f);
  printf("%-15s: %#-2.1F\n", "%#-2.1F", 8127.534f);
  printf("%-15s: %#-2.2F\n", "%#-2.2F", 8127.534f);
  printf("%-15s: %#-2.5F\n", "%#-2.5F", 8127.534f);
  printf("%-15s: %#-2.10F\n", "%#-2.10F", 8127.534f);
  printf("%-15s: %#-2.30F\n", "%#-2.30F", 8127.534f);
  printf("%-15s: %#-5F\n", "%#-5F", 8127.534f);
  printf("%-15s: %#-5.F\n", "%#-5.F", 8127.534f);
  printf("%-15s: %#-5.0F\n", "%#-5.0F", 8127.534f);
  printf("%-15s: %#-5.1F\n", "%#-5.1F", 8127.534f);
  printf("%-15s: %#-5.2F\n", "%#-5.2F", 8127.534f);
  printf("%-15s: %#-5.5F\n", "%#-5.5F", 8127.534f);
  printf("%-15s: %#-5.10F\n", "%#-5.10F", 8127.534f);
  printf("%-15s: %#-5.30F\n", "%#-5.30F", 8127.534f);
  printf("%-15s: %#-10F\n", "%#-10F", 8127.534f);
  printf("%-15s: %#-10.F\n", "%#-10.F", 8127.534f);
  printf("%-15s: %#-10.0F\n", "%#-10.0F", 8127.534f);
  printf("%-15s: %#-10.1F\n", "%#-10.1F", 8127.534f);
  printf("%-15s: %#-10.2F\n", "%#-10.2F", 8127.534f);
  printf("%-15s: %#-10.5F\n", "%#-10.5F", 8127.534f);
  printf("%-15s: %#-10.10F\n", "%#-10.10F", 8127.534f);
  printf("%-15s: %#-10.30F\n", "%#-10.30F", 8127.534f);
  printf("%-15s: %#-30F\n", "%#-30F", 8127.534f);
  printf("%-15s: %#-30.F\n", "%#-30.F", 8127.534f);
  printf("%-15s: %#-30.0F\n", "%#-30.0F", 8127.534f);
  printf("%-15s: %#-30.1F\n", "%#-30.1F", 8127.534f);
  printf("%-15s: %#-30.2F\n", "%#-30.2F", 8127.534f);
  printf("%-15s: %#-30.5F\n", "%#-30.5F", 8127.534f);
  printf("%-15s: %#-30.10F\n", "%#-30.10F", 8127.534f);
  printf("%-15s: %#-30.30F\n", "%#-30.30F", 8127.534f);
  printf("%-15s: %+#F\n", "%+#F", 8127.534f);
  printf("%-15s: %+#.F\n", "%+#.F", 8127.534f);
  printf("%-15s: %+#.0F\n", "%+#.0F", 8127.534f);
  printf("%-15s: %+#.1F\n", "%+#.1F", 8127.534f);
  printf("%-15s: %+#.2F\n", "%+#.2F", 8127.534f);
  printf("%-15s: %+#.5F\n", "%+#.5F", 8127.534f);
  printf("%-15s: %+#.10F\n", "%+#.10F", 8127.534f);
  printf("%-15s: %+#.30F\n", "%+#.30F", 8127.534f);
  printf("%-15s: %+#0F\n", "%+#0F", 8127.534f);
  printf("%-15s: %+#0.F\n", "%+#0.F", 8127.534f);
  printf("%-15s: %+#0.0F\n", "%+#0.0F", 8127.534f);
  printf("%-15s: %+#0.1F\n", "%+#0.1F", 8127.534f);
  printf("%-15s: %+#0.2F\n", "%+#0.2F", 8127.534f);
  printf("%-15s: %+#0.5F\n", "%+#0.5F", 8127.534f);
  printf("%-15s: %+#0.10F\n", "%+#0.10F", 8127.534f);
  printf("%-15s: %+#0.30F\n", "%+#0.30F", 8127.534f);
  printf("%-15s: %+#1F\n", "%+#1F", 8127.534f);
  printf("%-15s: %+#1.F\n", "%+#1.F", 8127.534f);
  printf("%-15s: %+#1.0F\n", "%+#1.0F", 8127.534f);
  printf("%-15s: %+#1.1F\n", "%+#1.1F", 8127.534f);
  printf("%-15s: %+#1.2F\n", "%+#1.2F", 8127.534f);
  printf("%-15s: %+#1.5F\n", "%+#1.5F", 8127.534f);
  printf("%-15s: %+#1.10F\n", "%+#1.10F", 8127.534f);
  printf("%-15s: %+#1.30F\n", "%+#1.30F", 8127.534f);
  printf("%-15s: %+#2F\n", "%+#2F", 8127.534f);
  printf("%-15s: %+#2.F\n", "%+#2.F", 8127.534f);
  printf("%-15s: %+#2.0F\n", "%+#2.0F", 8127.534f);
  printf("%-15s: %+#2.1F\n", "%+#2.1F", 8127.534f);
  printf("%-15s: %+#2.2F\n", "%+#2.2F", 8127.534f);
  printf("%-15s: %+#2.5F\n", "%+#2.5F", 8127.534f);
  printf("%-15s: %+#2.10F\n", "%+#2.10F", 8127.534f);
  printf("%-15s: %+#2.30F\n", "%+#2.30F", 8127.534f);
  printf("%-15s: %+#5F\n", "%+#5F", 8127.534f);
  printf("%-15s: %+#5.F\n", "%+#5.F", 8127.534f);
  printf("%-15s: %+#5.0F\n", "%+#5.0F", 8127.534f);
  printf("%-15s: %+#5.1F\n", "%+#5.1F", 8127.534f);
  printf("%-15s: %+#5.2F\n", "%+#5.2F", 8127.534f);
  printf("%-15s: %+#5.5F\n", "%+#5.5F", 8127.534f);
  printf("%-15s: %+#5.10F\n", "%+#5.10F", 8127.534f);
  printf("%-15s: %+#5.30F\n", "%+#5.30F", 8127.534f);
  printf("%-15s: %+#10F\n", "%+#10F", 8127.534f);
  printf("%-15s: %+#10.F\n", "%+#10.F", 8127.534f);
  printf("%-15s: %+#10.0F\n", "%+#10.0F", 8127.534f);
  printf("%-15s: %+#10.1F\n", "%+#10.1F", 8127.534f);
  printf("%-15s: %+#10.2F\n", "%+#10.2F", 8127.534f);
  printf("%-15s: %+#10.5F\n", "%+#10.5F", 8127.534f);
  printf("%-15s: %+#10.10F\n", "%+#10.10F", 8127.534f);
  printf("%-15s: %+#10.30F\n", "%+#10.30F", 8127.534f);
  printf("%-15s: %+#30F\n", "%+#30F", 8127.534f);
  printf("%-15s: %+#30.F\n", "%+#30.F", 8127.534f);
  printf("%-15s: %+#30.0F\n", "%+#30.0F", 8127.534f);
  printf("%-15s: %+#30.1F\n", "%+#30.1F", 8127.534f);
  printf("%-15s: %+#30.2F\n", "%+#30.2F", 8127.534f);
  printf("%-15s: %+#30.5F\n", "%+#30.5F", 8127.534f);
  printf("%-15s: %+#30.10F\n", "%+#30.10F", 8127.534f);
  printf("%-15s: %+#30.30F\n", "%+#30.30F", 8127.534f);
  printf("%-15s: %-#F\n", "%-#F", 8127.534f);
  printf("%-15s: %-#.F\n", "%-#.F", 8127.534f);
  printf("%-15s: %-#.0F\n", "%-#.0F", 8127.534f);
  printf("%-15s: %-#.1F\n", "%-#.1F", 8127.534f);
  printf("%-15s: %-#.2F\n", "%-#.2F", 8127.534f);
  printf("%-15s: %-#.5F\n", "%-#.5F", 8127.534f);
  printf("%-15s: %-#.10F\n", "%-#.10F", 8127.534f);
  printf("%-15s: %-#.30F\n", "%-#.30F", 8127.534f);
  printf("%-15s: %-#1F\n", "%-#1F", 8127.534f);
  printf("%-15s: %-#1.F\n", "%-#1.F", 8127.534f);
  printf("%-15s: %-#1.0F\n", "%-#1.0F", 8127.534f);
  printf("%-15s: %-#1.1F\n", "%-#1.1F", 8127.534f);
  printf("%-15s: %-#1.2F\n", "%-#1.2F", 8127.534f);
  printf("%-15s: %-#1.5F\n", "%-#1.5F", 8127.534f);
  printf("%-15s: %-#1.10F\n", "%-#1.10F", 8127.534f);
  printf("%-15s: %-#1.30F\n", "%-#1.30F", 8127.534f);
  printf("%-15s: %-#2F\n", "%-#2F", 8127.534f);
  printf("%-15s: %-#2.F\n", "%-#2.F", 8127.534f);
  printf("%-15s: %-#2.0F\n", "%-#2.0F", 8127.534f);
  printf("%-15s: %-#2.1F\n", "%-#2.1F", 8127.534f);
  printf("%-15s: %-#2.2F\n", "%-#2.2F", 8127.534f);
  printf("%-15s: %-#2.5F\n", "%-#2.5F", 8127.534f);
  printf("%-15s: %-#2.10F\n", "%-#2.10F", 8127.534f);
  printf("%-15s: %-#2.30F\n", "%-#2.30F", 8127.534f);
  printf("%-15s: %-#5F\n", "%-#5F", 8127.534f);
  printf("%-15s: %-#5.F\n", "%-#5.F", 8127.534f);
  printf("%-15s: %-#5.0F\n", "%-#5.0F", 8127.534f);
  printf("%-15s: %-#5.1F\n", "%-#5.1F", 8127.534f);
  printf("%-15s: %-#5.2F\n", "%-#5.2F", 8127.534f);
  printf("%-15s: %-#5.5F\n", "%-#5.5F", 8127.534f);
  printf("%-15s: %-#5.10F\n", "%-#5.10F", 8127.534f);
  printf("%-15s: %-#5.30F\n", "%-#5.30F", 8127.534f);
  printf("%-15s: %-#10F\n", "%-#10F", 8127.534f);
  printf("%-15s: %-#10.F\n", "%-#10.F", 8127.534f);
  printf("%-15s: %-#10.0F\n", "%-#10.0F", 8127.534f);
  printf("%-15s: %-#10.1F\n", "%-#10.1F", 8127.534f);
  printf("%-15s: %-#10.2F\n", "%-#10.2F", 8127.534f);
  printf("%-15s: %-#10.5F\n", "%-#10.5F", 8127.534f);
  printf("%-15s: %-#10.10F\n", "%-#10.10F", 8127.534f);
  printf("%-15s: %-#10.30F\n", "%-#10.30F", 8127.534f);
  printf("%-15s: %-#30F\n", "%-#30F", 8127.534f);
  printf("%-15s: %-#30.F\n", "%-#30.F", 8127.534f);
  printf("%-15s: %-#30.0F\n", "%-#30.0F", 8127.534f);
  printf("%-15s: %-#30.1F\n", "%-#30.1F", 8127.534f);
  printf("%-15s: %-#30.2F\n", "%-#30.2F", 8127.534f);
  printf("%-15s: %-#30.5F\n", "%-#30.5F", 8127.534f);
  printf("%-15s: %-#30.10F\n", "%-#30.10F", 8127.534f);
  printf("%-15s: %-#30.30F\n", "%-#30.30F", 8127.534f);
  printf("%-15s: %0#F\n", "%0#F", 8127.534f);
  printf("%-15s: %0#.F\n", "%0#.F", 8127.534f);
  printf("%-15s: %0#.0F\n", "%0#.0F", 8127.534f);
  printf("%-15s: %0#.1F\n", "%0#.1F", 8127.534f);
  printf("%-15s: %0#.2F\n", "%0#.2F", 8127.534f);
  printf("%-15s: %0#.5F\n", "%0#.5F", 8127.534f);
  printf("%-15s: %0#.10F\n", "%0#.10F", 8127.534f);
  printf("%-15s: %0#.30F\n", "%0#.30F", 8127.534f);
  printf("%-15s: %0#1F\n", "%0#1F", 8127.534f);
  printf("%-15s: %0#1.F\n", "%0#1.F", 8127.534f);
  printf("%-15s: %0#1.0F\n", "%0#1.0F", 8127.534f);
  printf("%-15s: %0#1.1F\n", "%0#1.1F", 8127.534f);
  printf("%-15s: %0#1.2F\n", "%0#1.2F", 8127.534f);
  printf("%-15s: %0#1.5F\n", "%0#1.5F", 8127.534f);
  printf("%-15s: %0#1.10F\n", "%0#1.10F", 8127.534f);
  printf("%-15s: %0#1.30F\n", "%0#1.30F", 8127.534f);
  printf("%-15s: %0#2F\n", "%0#2F", 8127.534f);
  printf("%-15s: %0#2.F\n", "%0#2.F", 8127.534f);
  printf("%-15s: %0#2.0F\n", "%0#2.0F", 8127.534f);
  printf("%-15s: %0#2.1F\n", "%0#2.1F", 8127.534f);
  printf("%-15s: %0#2.2F\n", "%0#2.2F", 8127.534f);
  printf("%-15s: %0#2.5F\n", "%0#2.5F", 8127.534f);
  printf("%-15s: %0#2.10F\n", "%0#2.10F", 8127.534f);
  printf("%-15s: %0#2.30F\n", "%0#2.30F", 8127.534f);
  printf("%-15s: %0#5F\n", "%0#5F", 8127.534f);
  printf("%-15s: %0#5.F\n", "%0#5.F", 8127.534f);
  printf("%-15s: %0#5.0F\n", "%0#5.0F", 8127.534f);
  printf("%-15s: %0#5.1F\n", "%0#5.1F", 8127.534f);
  printf("%-15s: %0#5.2F\n", "%0#5.2F", 8127.534f);
  printf("%-15s: %0#5.5F\n", "%0#5.5F", 8127.534f);
  printf("%-15s: %0#5.10F\n", "%0#5.10F", 8127.534f);
  printf("%-15s: %0#5.30F\n", "%0#5.30F", 8127.534f);
  printf("%-15s: %0#10F\n", "%0#10F", 8127.534f);
  printf("%-15s: %0#10.F\n", "%0#10.F", 8127.534f);
  printf("%-15s: %0#10.0F\n", "%0#10.0F", 8127.534f);
  printf("%-15s: %0#10.1F\n", "%0#10.1F", 8127.534f);
  printf("%-15s: %0#10.2F\n", "%0#10.2F", 8127.534f);
  printf("%-15s: %0#10.5F\n", "%0#10.5F", 8127.534f);
  printf("%-15s: %0#10.10F\n", "%0#10.10F", 8127.534f);
  printf("%-15s: %0#10.30F\n", "%0#10.30F", 8127.534f);
  printf("%-15s: %0#30F\n", "%0#30F", 8127.534f);
  printf("%-15s: %0#30.F\n", "%0#30.F", 8127.534f);
  printf("%-15s: %0#30.0F\n", "%0#30.0F", 8127.534f);
  printf("%-15s: %0#30.1F\n", "%0#30.1F", 8127.534f);
  printf("%-15s: %0#30.2F\n", "%0#30.2F", 8127.534f);
  printf("%-15s: %0#30.5F\n", "%0#30.5F", 8127.534f);
  printf("%-15s: %0#30.10F\n", "%0#30.10F", 8127.534f);
  printf("%-15s: %0#30.30F\n", "%0#30.30F", 8127.534f);
  printf("%-15s: %+0F\n", "%+0F", 8127.534f);
  printf("%-15s: %+0.F\n", "%+0.F", 8127.534f);
  printf("%-15s: %+0.0F\n", "%+0.0F", 8127.534f);
  printf("%-15s: %+0.1F\n", "%+0.1F", 8127.534f);
  printf("%-15s: %+0.2F\n", "%+0.2F", 8127.534f);
  printf("%-15s: %+0.5F\n", "%+0.5F", 8127.534f);
  printf("%-15s: %+0.10F\n", "%+0.10F", 8127.534f);
  printf("%-15s: %+0.30F\n", "%+0.30F", 8127.534f);
  printf("%-15s: %+01F\n", "%+01F", 8127.534f);
  printf("%-15s: %+01.F\n", "%+01.F", 8127.534f);
  printf("%-15s: %+01.0F\n", "%+01.0F", 8127.534f);
  printf("%-15s: %+01.1F\n", "%+01.1F", 8127.534f);
  printf("%-15s: %+01.2F\n", "%+01.2F", 8127.534f);
  printf("%-15s: %+01.5F\n", "%+01.5F", 8127.534f);
  printf("%-15s: %+01.10F\n", "%+01.10F", 8127.534f);
  printf("%-15s: %+01.30F\n", "%+01.30F", 8127.534f);
  printf("%-15s: %+02F\n", "%+02F", 8127.534f);
  printf("%-15s: %+02.F\n", "%+02.F", 8127.534f);
  printf("%-15s: %+02.0F\n", "%+02.0F", 8127.534f);
  printf("%-15s: %+02.1F\n", "%+02.1F", 8127.534f);
  printf("%-15s: %+02.2F\n", "%+02.2F", 8127.534f);
  printf("%-15s: %+02.5F\n", "%+02.5F", 8127.534f);
  printf("%-15s: %+02.10F\n", "%+02.10F", 8127.534f);
  printf("%-15s: %+02.30F\n", "%+02.30F", 8127.534f);
  printf("%-15s: %+05F\n", "%+05F", 8127.534f);
  printf("%-15s: %+05.F\n", "%+05.F", 8127.534f);
  printf("%-15s: %+05.0F\n", "%+05.0F", 8127.534f);
  printf("%-15s: %+05.1F\n", "%+05.1F", 8127.534f);
  printf("%-15s: %+05.2F\n", "%+05.2F", 8127.534f);
  printf("%-15s: %+05.5F\n", "%+05.5F", 8127.534f);
  printf("%-15s: %+05.10F\n", "%+05.10F", 8127.534f);
  printf("%-15s: %+05.30F\n", "%+05.30F", 8127.534f);
  printf("%-15s: %+010F\n", "%+010F", 8127.534f);
  printf("%-15s: %+010.F\n", "%+010.F", 8127.534f);
  printf("%-15s: %+010.0F\n", "%+010.0F", 8127.534f);
  printf("%-15s: %+010.1F\n", "%+010.1F", 8127.534f);
  printf("%-15s: %+010.2F\n", "%+010.2F", 8127.534f);
  printf("%-15s: %+010.5F\n", "%+010.5F", 8127.534f);
  printf("%-15s: %+010.10F\n", "%+010.10F", 8127.534f);
  printf("%-15s: %+010.30F\n", "%+010.30F", 8127.534f);
  printf("%-15s: %+030F\n", "%+030F", 8127.534f);
  printf("%-15s: %+030.F\n", "%+030.F", 8127.534f);
  printf("%-15s: %+030.0F\n", "%+030.0F", 8127.534f);
  printf("%-15s: %+030.1F\n", "%+030.1F", 8127.534f);
  printf("%-15s: %+030.2F\n", "%+030.2F", 8127.534f);
  printf("%-15s: %+030.5F\n", "%+030.5F", 8127.534f);
  printf("%-15s: %+030.10F\n", "%+030.10F", 8127.534f);
  printf("%-15s: %+030.30F\n", "%+030.30F", 8127.534f);
  printf("%-15s: %#0F\n", "%#0F", 8127.534f);
  printf("%-15s: %#0.F\n", "%#0.F", 8127.534f);
  printf("%-15s: %#0.0F\n", "%#0.0F", 8127.534f);
  printf("%-15s: %#0.1F\n", "%#0.1F", 8127.534f);
  printf("%-15s: %#0.2F\n", "%#0.2F", 8127.534f);
  printf("%-15s: %#0.5F\n", "%#0.5F", 8127.534f);
  printf("%-15s: %#0.10F\n", "%#0.10F", 8127.534f);
  printf("%-15s: %#0.30F\n", "%#0.30F", 8127.534f);
  printf("%-15s: %#01F\n", "%#01F", 8127.534f);
  printf("%-15s: %#01.F\n", "%#01.F", 8127.534f);
  printf("%-15s: %#01.0F\n", "%#01.0F", 8127.534f);
  printf("%-15s: %#01.1F\n", "%#01.1F", 8127.534f);
  printf("%-15s: %#01.2F\n", "%#01.2F", 8127.534f);
  printf("%-15s: %#01.5F\n", "%#01.5F", 8127.534f);
  printf("%-15s: %#01.10F\n", "%#01.10F", 8127.534f);
  printf("%-15s: %#01.30F\n", "%#01.30F", 8127.534f);
  printf("%-15s: %#02F\n", "%#02F", 8127.534f);
  printf("%-15s: %#02.F\n", "%#02.F", 8127.534f);
  printf("%-15s: %#02.0F\n", "%#02.0F", 8127.534f);
  printf("%-15s: %#02.1F\n", "%#02.1F", 8127.534f);
  printf("%-15s: %#02.2F\n", "%#02.2F", 8127.534f);
  printf("%-15s: %#02.5F\n", "%#02.5F", 8127.534f);
  printf("%-15s: %#02.10F\n", "%#02.10F", 8127.534f);
  printf("%-15s: %#02.30F\n", "%#02.30F", 8127.534f);
  printf("%-15s: %#05F\n", "%#05F", 8127.534f);
  printf("%-15s: %#05.F\n", "%#05.F", 8127.534f);
  printf("%-15s: %#05.0F\n", "%#05.0F", 8127.534f);
  printf("%-15s: %#05.1F\n", "%#05.1F", 8127.534f);
  printf("%-15s: %#05.2F\n", "%#05.2F", 8127.534f);
  printf("%-15s: %#05.5F\n", "%#05.5F", 8127.534f);
  printf("%-15s: %#05.10F\n", "%#05.10F", 8127.534f);
  printf("%-15s: %#05.30F\n", "%#05.30F", 8127.534f);
  printf("%-15s: %#010F\n", "%#010F", 8127.534f);
  printf("%-15s: %#010.F\n", "%#010.F", 8127.534f);
  printf("%-15s: %#010.0F\n", "%#010.0F", 8127.534f);
  printf("%-15s: %#010.1F\n", "%#010.1F", 8127.534f);
  printf("%-15s: %#010.2F\n", "%#010.2F", 8127.534f);
  printf("%-15s: %#010.5F\n", "%#010.5F", 8127.534f);
  printf("%-15s: %#010.10F\n", "%#010.10F", 8127.534f);
  printf("%-15s: %#010.30F\n", "%#010.30F", 8127.534f);
  printf("%-15s: %#030F\n", "%#030F", 8127.534f);
  printf("%-15s: %#030.F\n", "%#030.F", 8127.534f);
  printf("%-15s: %#030.0F\n", "%#030.0F", 8127.534f);
  printf("%-15s: %#030.1F\n", "%#030.1F", 8127.534f);
  printf("%-15s: %#030.2F\n", "%#030.2F", 8127.534f);
  printf("%-15s: %#030.5F\n", "%#030.5F", 8127.534f);
  printf("%-15s: %#030.10F\n", "%#030.10F", 8127.534f);
  printf("%-15s: %#030.30F\n", "%#030.30F", 8127.534f);
  printf("%-15s: %-+#F\n", "%-+#F", 8127.534f);
  printf("%-15s: %-+#.F\n", "%-+#.F", 8127.534f);
  printf("%-15s: %-+#.0F\n", "%-+#.0F", 8127.534f);
  printf("%-15s: %-+#.1F\n", "%-+#.1F", 8127.534f);
  printf("%-15s: %-+#.2F\n", "%-+#.2F", 8127.534f);
  printf("%-15s: %-+#.5F\n", "%-+#.5F", 8127.534f);
  printf("%-15s: %-+#.10F\n", "%-+#.10F", 8127.534f);
  printf("%-15s: %-+#.30F\n", "%-+#.30F", 8127.534f);
  printf("%-15s: %-+#1F\n", "%-+#1F", 8127.534f);
  printf("%-15s: %-+#1.F\n", "%-+#1.F", 8127.534f);
  printf("%-15s: %-+#1.0F\n", "%-+#1.0F", 8127.534f);
  printf("%-15s: %-+#1.1F\n", "%-+#1.1F", 8127.534f);
  printf("%-15s: %-+#1.2F\n", "%-+#1.2F", 8127.534f);
  printf("%-15s: %-+#1.5F\n", "%-+#1.5F", 8127.534f);
  printf("%-15s: %-+#1.10F\n", "%-+#1.10F", 8127.534f);
  printf("%-15s: %-+#1.30F\n", "%-+#1.30F", 8127.534f);
  printf("%-15s: %-+#2F\n", "%-+#2F", 8127.534f);
  printf("%-15s: %-+#2.F\n", "%-+#2.F", 8127.534f);
  printf("%-15s: %-+#2.0F\n", "%-+#2.0F", 8127.534f);
  printf("%-15s: %-+#2.1F\n", "%-+#2.1F", 8127.534f);
  printf("%-15s: %-+#2.2F\n", "%-+#2.2F", 8127.534f);
  printf("%-15s: %-+#2.5F\n", "%-+#2.5F", 8127.534f);
  printf("%-15s: %-+#2.10F\n", "%-+#2.10F", 8127.534f);
  printf("%-15s: %-+#2.30F\n", "%-+#2.30F", 8127.534f);
  printf("%-15s: %-+#5F\n", "%-+#5F", 8127.534f);
  printf("%-15s: %-+#5.F\n", "%-+#5.F", 8127.534f);
  printf("%-15s: %-+#5.0F\n", "%-+#5.0F", 8127.534f);
  printf("%-15s: %-+#5.1F\n", "%-+#5.1F", 8127.534f);
  printf("%-15s: %-+#5.2F\n", "%-+#5.2F", 8127.534f);
  printf("%-15s: %-+#5.5F\n", "%-+#5.5F", 8127.534f);
  printf("%-15s: %-+#5.10F\n", "%-+#5.10F", 8127.534f);
  printf("%-15s: %-+#5.30F\n", "%-+#5.30F", 8127.534f);
  printf("%-15s: %-+#10F\n", "%-+#10F", 8127.534f);
  printf("%-15s: %-+#10.F\n", "%-+#10.F", 8127.534f);
  printf("%-15s: %-+#10.0F\n", "%-+#10.0F", 8127.534f);
  printf("%-15s: %-+#10.1F\n", "%-+#10.1F", 8127.534f);
  printf("%-15s: %-+#10.2F\n", "%-+#10.2F", 8127.534f);
  printf("%-15s: %-+#10.5F\n", "%-+#10.5F", 8127.534f);
  printf("%-15s: %-+#10.10F\n", "%-+#10.10F", 8127.534f);
  printf("%-15s: %-+#10.30F\n", "%-+#10.30F", 8127.534f);
  printf("%-15s: %-+#30F\n", "%-+#30F", 8127.534f);
  printf("%-15s: %-+#30.F\n", "%-+#30.F", 8127.534f);
  printf("%-15s: %-+#30.0F\n", "%-+#30.0F", 8127.534f);
  printf("%-15s: %-+#30.1F\n", "%-+#30.1F", 8127.534f);
  printf("%-15s: %-+#30.2F\n", "%-+#30.2F", 8127.534f);
  printf("%-15s: %-+#30.5F\n", "%-+#30.5F", 8127.534f);
  printf("%-15s: %-+#30.10F\n", "%-+#30.10F", 8127.534f);
  printf("%-15s: %-+#30.30F\n", "%-+#30.30F", 8127.534f);
  printf("%-15s: %0+#F\n", "%0+#F", 8127.534f);
  printf("%-15s: %0+#.F\n", "%0+#.F", 8127.534f);
  printf("%-15s: %0+#.0F\n", "%0+#.0F", 8127.534f);
  printf("%-15s: %0+#.1F\n", "%0+#.1F", 8127.534f);
  printf("%-15s: %0+#.2F\n", "%0+#.2F", 8127.534f);
  printf("%-15s: %0+#.5F\n", "%0+#.5F", 8127.534f);
  printf("%-15s: %0+#.10F\n", "%0+#.10F", 8127.534f);
  printf("%-15s: %0+#.30F\n", "%0+#.30F", 8127.534f);
  printf("%-15s: %0+#1F\n", "%0+#1F", 8127.534f);
  printf("%-15s: %0+#1.F\n", "%0+#1.F", 8127.534f);
  printf("%-15s: %0+#1.0F\n", "%0+#1.0F", 8127.534f);
  printf("%-15s: %0+#1.1F\n", "%0+#1.1F", 8127.534f);
  printf("%-15s: %0+#1.2F\n", "%0+#1.2F", 8127.534f);
  printf("%-15s: %0+#1.5F\n", "%0+#1.5F", 8127.534f);
  printf("%-15s: %0+#1.10F\n", "%0+#1.10F", 8127.534f);
  printf("%-15s: %0+#1.30F\n", "%0+#1.30F", 8127.534f);
  printf("%-15s: %0+#2F\n", "%0+#2F", 8127.534f);
  printf("%-15s: %0+#2.F\n", "%0+#2.F", 8127.534f);
  printf("%-15s: %0+#2.0F\n", "%0+#2.0F", 8127.534f);
  printf("%-15s: %0+#2.1F\n", "%0+#2.1F", 8127.534f);
  printf("%-15s: %0+#2.2F\n", "%0+#2.2F", 8127.534f);
  printf("%-15s: %0+#2.5F\n", "%0+#2.5F", 8127.534f);
  printf("%-15s: %0+#2.10F\n", "%0+#2.10F", 8127.534f);
  printf("%-15s: %0+#2.30F\n", "%0+#2.30F", 8127.534f);
  printf("%-15s: %0+#5F\n", "%0+#5F", 8127.534f);
  printf("%-15s: %0+#5.F\n", "%0+#5.F", 8127.534f);
  printf("%-15s: %0+#5.0F\n", "%0+#5.0F", 8127.534f);
  printf("%-15s: %0+#5.1F\n", "%0+#5.1F", 8127.534f);
  printf("%-15s: %0+#5.2F\n", "%0+#5.2F", 8127.534f);
  printf("%-15s: %0+#5.5F\n", "%0+#5.5F", 8127.534f);
  printf("%-15s: %0+#5.10F\n", "%0+#5.10F", 8127.534f);
  printf("%-15s: %0+#5.30F\n", "%0+#5.30F", 8127.534f);
  printf("%-15s: %0+#10F\n", "%0+#10F", 8127.534f);
  printf("%-15s: %0+#10.F\n", "%0+#10.F", 8127.534f);
  printf("%-15s: %0+#10.0F\n", "%0+#10.0F", 8127.534f);
  printf("%-15s: %0+#10.1F\n", "%0+#10.1F", 8127.534f);
  printf("%-15s: %0+#10.2F\n", "%0+#10.2F", 8127.534f);
  printf("%-15s: %0+#10.5F\n", "%0+#10.5F", 8127.534f);
  printf("%-15s: %0+#10.10F\n", "%0+#10.10F", 8127.534f);
  printf("%-15s: %0+#10.30F\n", "%0+#10.30F", 8127.534f);
  printf("%-15s: %0+#30F\n", "%0+#30F", 8127.534f);
  printf("%-15s: %0+#30.F\n", "%0+#30.F", 8127.534f);
  printf("%-15s: %0+#30.0F\n", "%0+#30.0F", 8127.534f);
  printf("%-15s: %0+#30.1F\n", "%0+#30.1F", 8127.534f);
  printf("%-15s: %0+#30.2F\n", "%0+#30.2F", 8127.534f);
  printf("%-15s: %0+#30.5F\n", "%0+#30.5F", 8127.534f);
  printf("%-15s: %0+#30.10F\n", "%0+#30.10F", 8127.534f);
  printf("%-15s: %0+#30.30F\n", "%0+#30.30F", 8127.534f);
  printf("%-15s: %#-+F\n", "%#-+F", 8127.534f);
  printf("%-15s: %#-+.F\n", "%#-+.F", 8127.534f);
  printf("%-15s: %#-+.0F\n", "%#-+.0F", 8127.534f);
  printf("%-15s: %#-+.1F\n", "%#-+.1F", 8127.534f);
  printf("%-15s: %#-+.2F\n", "%#-+.2F", 8127.534f);
  printf("%-15s: %#-+.5F\n", "%#-+.5F", 8127.534f);
  printf("%-15s: %#-+.10F\n", "%#-+.10F", 8127.534f);
  printf("%-15s: %#-+.30F\n", "%#-+.30F", 8127.534f);
  printf("%-15s: %#-+1F\n", "%#-+1F", 8127.534f);
  printf("%-15s: %#-+1.F\n", "%#-+1.F", 8127.534f);
  printf("%-15s: %#-+1.0F\n", "%#-+1.0F", 8127.534f);
  printf("%-15s: %#-+1.1F\n", "%#-+1.1F", 8127.534f);
  printf("%-15s: %#-+1.2F\n", "%#-+1.2F", 8127.534f);
  printf("%-15s: %#-+1.5F\n", "%#-+1.5F", 8127.534f);
  printf("%-15s: %#-+1.10F\n", "%#-+1.10F", 8127.534f);
  printf("%-15s: %#-+1.30F\n", "%#-+1.30F", 8127.534f);
  printf("%-15s: %#-+2F\n", "%#-+2F", 8127.534f);
  printf("%-15s: %#-+2.F\n", "%#-+2.F", 8127.534f);
  printf("%-15s: %#-+2.0F\n", "%#-+2.0F", 8127.534f);
  printf("%-15s: %#-+2.1F\n", "%#-+2.1F", 8127.534f);
  printf("%-15s: %#-+2.2F\n", "%#-+2.2F", 8127.534f);
  printf("%-15s: %#-+2.5F\n", "%#-+2.5F", 8127.534f);
  printf("%-15s: %#-+2.10F\n", "%#-+2.10F", 8127.534f);
  printf("%-15s: %#-+2.30F\n", "%#-+2.30F", 8127.534f);
  printf("%-15s: %#-+5F\n", "%#-+5F", 8127.534f);
  printf("%-15s: %#-+5.F\n", "%#-+5.F", 8127.534f);
  printf("%-15s: %#-+5.0F\n", "%#-+5.0F", 8127.534f);
  printf("%-15s: %#-+5.1F\n", "%#-+5.1F", 8127.534f);
  printf("%-15s: %#-+5.2F\n", "%#-+5.2F", 8127.534f);
  printf("%-15s: %#-+5.5F\n", "%#-+5.5F", 8127.534f);
  printf("%-15s: %#-+5.10F\n", "%#-+5.10F", 8127.534f);
  printf("%-15s: %#-+5.30F\n", "%#-+5.30F", 8127.534f);
  printf("%-15s: %#-+10F\n", "%#-+10F", 8127.534f);
  printf("%-15s: %#-+10.F\n", "%#-+10.F", 8127.534f);
  printf("%-15s: %#-+10.0F\n", "%#-+10.0F", 8127.534f);
  printf("%-15s: %#-+10.1F\n", "%#-+10.1F", 8127.534f);
  printf("%-15s: %#-+10.2F\n", "%#-+10.2F", 8127.534f);
  printf("%-15s: %#-+10.5F\n", "%#-+10.5F", 8127.534f);
  printf("%-15s: %#-+10.10F\n", "%#-+10.10F", 8127.534f);
  printf("%-15s: %#-+10.30F\n", "%#-+10.30F", 8127.534f);
  printf("%-15s: %#-+30F\n", "%#-+30F", 8127.534f);
  printf("%-15s: %#-+30.F\n", "%#-+30.F", 8127.534f);
  printf("%-15s: %#-+30.0F\n", "%#-+30.0F", 8127.534f);
  printf("%-15s: %#-+30.1F\n", "%#-+30.1F", 8127.534f);
  printf("%-15s: %#-+30.2F\n", "%#-+30.2F", 8127.534f);
  printf("%-15s: %#-+30.5F\n", "%#-+30.5F", 8127.534f);
  printf("%-15s: %#-+30.10F\n", "%#-+30.10F", 8127.534f);
  printf("%-15s: %#-+30.30F\n", "%#-+30.30F", 8127.534f);
  printf("%-15s: %+#-F\n", "%+#-F", 8127.534f);
  printf("%-15s: %+#-.F\n", "%+#-.F", 8127.534f);
  printf("%-15s: %+#-.0F\n", "%+#-.0F", 8127.534f);
  printf("%-15s: %+#-.1F\n", "%+#-.1F", 8127.534f);
  printf("%-15s: %+#-.2F\n", "%+#-.2F", 8127.534f);
  printf("%-15s: %+#-.5F\n", "%+#-.5F", 8127.534f);
  printf("%-15s: %+#-.10F\n", "%+#-.10F", 8127.534f);
  printf("%-15s: %+#-.30F\n", "%+#-.30F", 8127.534f);
  printf("%-15s: %+#-1F\n", "%+#-1F", 8127.534f);
  printf("%-15s: %+#-1.F\n", "%+#-1.F", 8127.534f);
  printf("%-15s: %+#-1.0F\n", "%+#-1.0F", 8127.534f);
  printf("%-15s: %+#-1.1F\n", "%+#-1.1F", 8127.534f);
  printf("%-15s: %+#-1.2F\n", "%+#-1.2F", 8127.534f);
  printf("%-15s: %+#-1.5F\n", "%+#-1.5F", 8127.534f);
  printf("%-15s: %+#-1.10F\n", "%+#-1.10F", 8127.534f);
  printf("%-15s: %+#-1.30F\n", "%+#-1.30F", 8127.534f);
  printf("%-15s: %+#-2F\n", "%+#-2F", 8127.534f);
  printf("%-15s: %+#-2.F\n", "%+#-2.F", 8127.534f);
  printf("%-15s: %+#-2.0F\n", "%+#-2.0F", 8127.534f);
  printf("%-15s: %+#-2.1F\n", "%+#-2.1F", 8127.534f);
  printf("%-15s: %+#-2.2F\n", "%+#-2.2F", 8127.534f);
  printf("%-15s: %+#-2.5F\n", "%+#-2.5F", 8127.534f);
  printf("%-15s: %+#-2.10F\n", "%+#-2.10F", 8127.534f);
  printf("%-15s: %+#-2.30F\n", "%+#-2.30F", 8127.534f);
  printf("%-15s: %+#-5F\n", "%+#-5F", 8127.534f);
  printf("%-15s: %+#-5.F\n", "%+#-5.F", 8127.534f);
  printf("%-15s: %+#-5.0F\n", "%+#-5.0F", 8127.534f);
  printf("%-15s: %+#-5.1F\n", "%+#-5.1F", 8127.534f);
  printf("%-15s: %+#-5.2F\n", "%+#-5.2F", 8127.534f);
  printf("%-15s: %+#-5.5F\n", "%+#-5.5F", 8127.534f);
  printf("%-15s: %+#-5.10F\n", "%+#-5.10F", 8127.534f);
  printf("%-15s: %+#-5.30F\n", "%+#-5.30F", 8127.534f);
  printf("%-15s: %+#-10F\n", "%+#-10F", 8127.534f);
  printf("%-15s: %+#-10.F\n", "%+#-10.F", 8127.534f);
  printf("%-15s: %+#-10.0F\n", "%+#-10.0F", 8127.534f);
  printf("%-15s: %+#-10.1F\n", "%+#-10.1F", 8127.534f);
  printf("%-15s: %+#-10.2F\n", "%+#-10.2F", 8127.534f);
  printf("%-15s: %+#-10.5F\n", "%+#-10.5F", 8127.534f);
  printf("%-15s: %+#-10.10F\n", "%+#-10.10F", 8127.534f);
  printf("%-15s: %+#-10.30F\n", "%+#-10.30F", 8127.534f);
  printf("%-15s: %+#-30F\n", "%+#-30F", 8127.534f);
  printf("%-15s: %+#-30.F\n", "%+#-30.F", 8127.534f);
  printf("%-15s: %+#-30.0F\n", "%+#-30.0F", 8127.534f);
  printf("%-15s: %+#-30.1F\n", "%+#-30.1F", 8127.534f);
  printf("%-15s: %+#-30.2F\n", "%+#-30.2F", 8127.534f);
  printf("%-15s: %+#-30.5F\n", "%+#-30.5F", 8127.534f);
  printf("%-15s: %+#-30.10F\n", "%+#-30.10F", 8127.534f);
  printf("%-15s: %+#-30.30F\n", "%+#-30.30F", 8127.534f);
  printf("%-15s: %+e\n", "%+e", 8127.534f);
  printf("%-15s: %+.e\n", "%+.e", 8127.534f);
  printf("%-15s: %+.0e\n", "%+.0e", 8127.534f);
  printf("%-15s: %+.1e\n", "%+.1e", 8127.534f);
  printf("%-15s: %+.2e\n", "%+.2e", 8127.534f);
  printf("%-15s: %+.5e\n", "%+.5e", 8127.534f);
  printf("%-15s: %+.10e\n", "%+.10e", 8127.534f);
  printf("%-15s: %+.30e\n", "%+.30e", 8127.534f);
  printf("%-15s: %+0e\n", "%+0e", 8127.534f);
  printf("%-15s: %+0.e\n", "%+0.e", 8127.534f);
  printf("%-15s: %+0.0e\n", "%+0.0e", 8127.534f);
  printf("%-15s: %+0.1e\n", "%+0.1e", 8127.534f);
  printf("%-15s: %+0.2e\n", "%+0.2e", 8127.534f);
  printf("%-15s: %+0.5e\n", "%+0.5e", 8127.534f);
  printf("%-15s: %+0.10e\n", "%+0.10e", 8127.534f);
  printf("%-15s: %+0.30e\n", "%+0.30e", 8127.534f);
  printf("%-15s: %+1e\n", "%+1e", 8127.534f);
  printf("%-15s: %+1.e\n", "%+1.e", 8127.534f);
  printf("%-15s: %+1.0e\n", "%+1.0e", 8127.534f);
  printf("%-15s: %+1.1e\n", "%+1.1e", 8127.534f);
  printf("%-15s: %+1.2e\n", "%+1.2e", 8127.534f);
  printf("%-15s: %+1.5e\n", "%+1.5e", 8127.534f);
  printf("%-15s: %+1.10e\n", "%+1.10e", 8127.534f);
  printf("%-15s: %+1.30e\n", "%+1.30e", 8127.534f);
  printf("%-15s: %+2e\n", "%+2e", 8127.534f);
  printf("%-15s: %+2.e\n", "%+2.e", 8127.534f);
  printf("%-15s: %+2.0e\n", "%+2.0e", 8127.534f);
  printf("%-15s: %+2.1e\n", "%+2.1e", 8127.534f);
  printf("%-15s: %+2.2e\n", "%+2.2e", 8127.534f);
  printf("%-15s: %+2.5e\n", "%+2.5e", 8127.534f);
  printf("%-15s: %+2.10e\n", "%+2.10e", 8127.534f);
  printf("%-15s: %+2.30e\n", "%+2.30e", 8127.534f);
  printf("%-15s: %+5e\n", "%+5e", 8127.534f);
  printf("%-15s: %+5.e\n", "%+5.e", 8127.534f);
  printf("%-15s: %+5.0e\n", "%+5.0e", 8127.534f);
  printf("%-15s: %+5.1e\n", "%+5.1e", 8127.534f);
  printf("%-15s: %+5.2e\n", "%+5.2e", 8127.534f);
  printf("%-15s: %+5.5e\n", "%+5.5e", 8127.534f);
  printf("%-15s: %+5.10e\n", "%+5.10e", 8127.534f);
  printf("%-15s: %+5.30e\n", "%+5.30e", 8127.534f);
  printf("%-15s: %+10e\n", "%+10e", 8127.534f);
  printf("%-15s: %+10.e\n", "%+10.e", 8127.534f);
  printf("%-15s: %+10.0e\n", "%+10.0e", 8127.534f);
  printf("%-15s: %+10.1e\n", "%+10.1e", 8127.534f);
  printf("%-15s: %+10.2e\n", "%+10.2e", 8127.534f);
  printf("%-15s: %+10.5e\n", "%+10.5e", 8127.534f);
  printf("%-15s: %+10.10e\n", "%+10.10e", 8127.534f);
  printf("%-15s: %+10.30e\n", "%+10.30e", 8127.534f);
  printf("%-15s: %+30e\n", "%+30e", 8127.534f);
  printf("%-15s: %+30.e\n", "%+30.e", 8127.534f);
  printf("%-15s: %+30.0e\n", "%+30.0e", 8127.534f);
  printf("%-15s: %+30.1e\n", "%+30.1e", 8127.534f);
  printf("%-15s: %+30.2e\n", "%+30.2e", 8127.534f);
  printf("%-15s: %+30.5e\n", "%+30.5e", 8127.534f);
  printf("%-15s: %+30.10e\n", "%+30.10e", 8127.534f);
  printf("%-15s: %+30.30e\n", "%+30.30e", 8127.534f);
  printf("%-15s: %-e\n", "%-e", 8127.534f);
  printf("%-15s: %-.e\n", "%-.e", 8127.534f);
  printf("%-15s: %-.0e\n", "%-.0e", 8127.534f);
  printf("%-15s: %-.1e\n", "%-.1e", 8127.534f);
  printf("%-15s: %-.2e\n", "%-.2e", 8127.534f);
  printf("%-15s: %-.5e\n", "%-.5e", 8127.534f);
  printf("%-15s: %-.10e\n", "%-.10e", 8127.534f);
  printf("%-15s: %-.30e\n", "%-.30e", 8127.534f);
  printf("%-15s: %-1e\n", "%-1e", 8127.534f);
  printf("%-15s: %-1.e\n", "%-1.e", 8127.534f);
  printf("%-15s: %-1.0e\n", "%-1.0e", 8127.534f);
  printf("%-15s: %-1.1e\n", "%-1.1e", 8127.534f);
  printf("%-15s: %-1.2e\n", "%-1.2e", 8127.534f);
  printf("%-15s: %-1.5e\n", "%-1.5e", 8127.534f);
  printf("%-15s: %-1.10e\n", "%-1.10e", 8127.534f);
  printf("%-15s: %-1.30e\n", "%-1.30e", 8127.534f);
  printf("%-15s: %-2e\n", "%-2e", 8127.534f);
  printf("%-15s: %-2.e\n", "%-2.e", 8127.534f);
  printf("%-15s: %-2.0e\n", "%-2.0e", 8127.534f);
  printf("%-15s: %-2.1e\n", "%-2.1e", 8127.534f);
  printf("%-15s: %-2.2e\n", "%-2.2e", 8127.534f);
  printf("%-15s: %-2.5e\n", "%-2.5e", 8127.534f);
  printf("%-15s: %-2.10e\n", "%-2.10e", 8127.534f);
  printf("%-15s: %-2.30e\n", "%-2.30e", 8127.534f);
  printf("%-15s: %-5e\n", "%-5e", 8127.534f);
  printf("%-15s: %-5.e\n", "%-5.e", 8127.534f);
  printf("%-15s: %-5.0e\n", "%-5.0e", 8127.534f);
  printf("%-15s: %-5.1e\n", "%-5.1e", 8127.534f);
  printf("%-15s: %-5.2e\n", "%-5.2e", 8127.534f);
  printf("%-15s: %-5.5e\n", "%-5.5e", 8127.534f);
  printf("%-15s: %-5.10e\n", "%-5.10e", 8127.534f);
  printf("%-15s: %-5.30e\n", "%-5.30e", 8127.534f);
  printf("%-15s: %-10e\n", "%-10e", 8127.534f);
  printf("%-15s: %-10.e\n", "%-10.e", 8127.534f);
  printf("%-15s: %-10.0e\n", "%-10.0e", 8127.534f);
  printf("%-15s: %-10.1e\n", "%-10.1e", 8127.534f);
  printf("%-15s: %-10.2e\n", "%-10.2e", 8127.534f);
  printf("%-15s: %-10.5e\n", "%-10.5e", 8127.534f);
  printf("%-15s: %-10.10e\n", "%-10.10e", 8127.534f);
  printf("%-15s: %-10.30e\n", "%-10.30e", 8127.534f);
  printf("%-15s: %-30e\n", "%-30e", 8127.534f);
  printf("%-15s: %-30.e\n", "%-30.e", 8127.534f);
  printf("%-15s: %-30.0e\n", "%-30.0e", 8127.534f);
  printf("%-15s: %-30.1e\n", "%-30.1e", 8127.534f);
  printf("%-15s: %-30.2e\n", "%-30.2e", 8127.534f);
  printf("%-15s: %-30.5e\n", "%-30.5e", 8127.534f);
  printf("%-15s: %-30.10e\n", "%-30.10e", 8127.534f);
  printf("%-15s: %-30.30e\n", "%-30.30e", 8127.534f);
  printf("%-15s: %#e\n", "%#e", 8127.534f);
  printf("%-15s: %#.e\n", "%#.e", 8127.534f);
  printf("%-15s: %#.0e\n", "%#.0e", 8127.534f);
  printf("%-15s: %#.1e\n", "%#.1e", 8127.534f);
  printf("%-15s: %#.2e\n", "%#.2e", 8127.534f);
  printf("%-15s: %#.5e\n", "%#.5e", 8127.534f);
  printf("%-15s: %#.10e\n", "%#.10e", 8127.534f);
  printf("%-15s: %#.30e\n", "%#.30e", 8127.534f);
  printf("%-15s: %#0e\n", "%#0e", 8127.534f);
  printf("%-15s: %#0.e\n", "%#0.e", 8127.534f);
  printf("%-15s: %#0.0e\n", "%#0.0e", 8127.534f);
  printf("%-15s: %#0.1e\n", "%#0.1e", 8127.534f);
  printf("%-15s: %#0.2e\n", "%#0.2e", 8127.534f);
  printf("%-15s: %#0.5e\n", "%#0.5e", 8127.534f);
  printf("%-15s: %#0.10e\n", "%#0.10e", 8127.534f);
  printf("%-15s: %#0.30e\n", "%#0.30e", 8127.534f);
  printf("%-15s: %#1e\n", "%#1e", 8127.534f);
  printf("%-15s: %#1.e\n", "%#1.e", 8127.534f);
  printf("%-15s: %#1.0e\n", "%#1.0e", 8127.534f);
  printf("%-15s: %#1.1e\n", "%#1.1e", 8127.534f);
  printf("%-15s: %#1.2e\n", "%#1.2e", 8127.534f);
  printf("%-15s: %#1.5e\n", "%#1.5e", 8127.534f);
  printf("%-15s: %#1.10e\n", "%#1.10e", 8127.534f);
  printf("%-15s: %#1.30e\n", "%#1.30e", 8127.534f);
  printf("%-15s: %#2e\n", "%#2e", 8127.534f);
  printf("%-15s: %#2.e\n", "%#2.e", 8127.534f);
  printf("%-15s: %#2.0e\n", "%#2.0e", 8127.534f);
  printf("%-15s: %#2.1e\n", "%#2.1e", 8127.534f);
  printf("%-15s: %#2.2e\n", "%#2.2e", 8127.534f);
  printf("%-15s: %#2.5e\n", "%#2.5e", 8127.534f);
  printf("%-15s: %#2.10e\n", "%#2.10e", 8127.534f);
  printf("%-15s: %#2.30e\n", "%#2.30e", 8127.534f);
  printf("%-15s: %#5e\n", "%#5e", 8127.534f);
  printf("%-15s: %#5.e\n", "%#5.e", 8127.534f);
  printf("%-15s: %#5.0e\n", "%#5.0e", 8127.534f);
  printf("%-15s: %#5.1e\n", "%#5.1e", 8127.534f);
  printf("%-15s: %#5.2e\n", "%#5.2e", 8127.534f);
  printf("%-15s: %#5.5e\n", "%#5.5e", 8127.534f);
  printf("%-15s: %#5.10e\n", "%#5.10e", 8127.534f);
  printf("%-15s: %#5.30e\n", "%#5.30e", 8127.534f);
  printf("%-15s: %#10e\n", "%#10e", 8127.534f);
  printf("%-15s: %#10.e\n", "%#10.e", 8127.534f);
  printf("%-15s: %#10.0e\n", "%#10.0e", 8127.534f);
  printf("%-15s: %#10.1e\n", "%#10.1e", 8127.534f);
  printf("%-15s: %#10.2e\n", "%#10.2e", 8127.534f);
  printf("%-15s: %#10.5e\n", "%#10.5e", 8127.534f);
  printf("%-15s: %#10.10e\n", "%#10.10e", 8127.534f);
  printf("%-15s: %#10.30e\n", "%#10.30e", 8127.534f);
  printf("%-15s: %#30e\n", "%#30e", 8127.534f);
  printf("%-15s: %#30.e\n", "%#30.e", 8127.534f);
  printf("%-15s: %#30.0e\n", "%#30.0e", 8127.534f);
  printf("%-15s: %#30.1e\n", "%#30.1e", 8127.534f);
  printf("%-15s: %#30.2e\n", "%#30.2e", 8127.534f);
  printf("%-15s: %#30.5e\n", "%#30.5e", 8127.534f);
  printf("%-15s: %#30.10e\n", "%#30.10e", 8127.534f);
  printf("%-15s: %#30.30e\n", "%#30.30e", 8127.534f);
  printf("%-15s: %0e\n", "%0e", 8127.534f);
  printf("%-15s: %0.e\n", "%0.e", 8127.534f);
  printf("%-15s: %0.0e\n", "%0.0e", 8127.534f);
  printf("%-15s: %0.1e\n", "%0.1e", 8127.534f);
  printf("%-15s: %0.2e\n", "%0.2e", 8127.534f);
  printf("%-15s: %0.5e\n", "%0.5e", 8127.534f);
  printf("%-15s: %0.10e\n", "%0.10e", 8127.534f);
  printf("%-15s: %0.30e\n", "%0.30e", 8127.534f);
  printf("%-15s: %01e\n", "%01e", 8127.534f);
  printf("%-15s: %01.e\n", "%01.e", 8127.534f);
  printf("%-15s: %01.0e\n", "%01.0e", 8127.534f);
  printf("%-15s: %01.1e\n", "%01.1e", 8127.534f);
  printf("%-15s: %01.2e\n", "%01.2e", 8127.534f);
  printf("%-15s: %01.5e\n", "%01.5e", 8127.534f);
  printf("%-15s: %01.10e\n", "%01.10e", 8127.534f);
  printf("%-15s: %01.30e\n", "%01.30e", 8127.534f);
  printf("%-15s: %02e\n", "%02e", 8127.534f);
  printf("%-15s: %02.e\n", "%02.e", 8127.534f);
  printf("%-15s: %02.0e\n", "%02.0e", 8127.534f);
  printf("%-15s: %02.1e\n", "%02.1e", 8127.534f);
  printf("%-15s: %02.2e\n", "%02.2e", 8127.534f);
  printf("%-15s: %02.5e\n", "%02.5e", 8127.534f);
  printf("%-15s: %02.10e\n", "%02.10e", 8127.534f);
  printf("%-15s: %02.30e\n", "%02.30e", 8127.534f);
  printf("%-15s: %05e\n", "%05e", 8127.534f);
  printf("%-15s: %05.e\n", "%05.e", 8127.534f);
  printf("%-15s: %05.0e\n", "%05.0e", 8127.534f);
  printf("%-15s: %05.1e\n", "%05.1e", 8127.534f);
  printf("%-15s: %05.2e\n", "%05.2e", 8127.534f);
  printf("%-15s: %05.5e\n", "%05.5e", 8127.534f);
  printf("%-15s: %05.10e\n", "%05.10e", 8127.534f);
  printf("%-15s: %05.30e\n", "%05.30e", 8127.534f);
  printf("%-15s: %010e\n", "%010e", 8127.534f);
  printf("%-15s: %010.e\n", "%010.e", 8127.534f);
  printf("%-15s: %010.0e\n", "%010.0e", 8127.534f);
  printf("%-15s: %010.1e\n", "%010.1e", 8127.534f);
  printf("%-15s: %010.2e\n", "%010.2e", 8127.534f);
  printf("%-15s: %010.5e\n", "%010.5e", 8127.534f);
  printf("%-15s: %010.10e\n", "%010.10e", 8127.534f);
  printf("%-15s: %010.30e\n", "%010.30e", 8127.534f);
  printf("%-15s: %030e\n", "%030e", 8127.534f);
  printf("%-15s: %030.e\n", "%030.e", 8127.534f);
  printf("%-15s: %030.0e\n", "%030.0e", 8127.534f);
  printf("%-15s: %030.1e\n", "%030.1e", 8127.534f);
  printf("%-15s: %030.2e\n", "%030.2e", 8127.534f);
  printf("%-15s: %030.5e\n", "%030.5e", 8127.534f);
  printf("%-15s: %030.10e\n", "%030.10e", 8127.534f);
  printf("%-15s: %030.30e\n", "%030.30e", 8127.534f);
  printf("%-15s: %-+e\n", "%-+e", 8127.534f);
  printf("%-15s: %-+.e\n", "%-+.e", 8127.534f);
  printf("%-15s: %-+.0e\n", "%-+.0e", 8127.534f);
  printf("%-15s: %-+.1e\n", "%-+.1e", 8127.534f);
  printf("%-15s: %-+.2e\n", "%-+.2e", 8127.534f);
  printf("%-15s: %-+.5e\n", "%-+.5e", 8127.534f);
  printf("%-15s: %-+.10e\n", "%-+.10e", 8127.534f);
  printf("%-15s: %-+.30e\n", "%-+.30e", 8127.534f);
  printf("%-15s: %-+1e\n", "%-+1e", 8127.534f);
  printf("%-15s: %-+1.e\n", "%-+1.e", 8127.534f);
  printf("%-15s: %-+1.0e\n", "%-+1.0e", 8127.534f);
  printf("%-15s: %-+1.1e\n", "%-+1.1e", 8127.534f);
  printf("%-15s: %-+1.2e\n", "%-+1.2e", 8127.534f);
  printf("%-15s: %-+1.5e\n", "%-+1.5e", 8127.534f);
  printf("%-15s: %-+1.10e\n", "%-+1.10e", 8127.534f);
  printf("%-15s: %-+1.30e\n", "%-+1.30e", 8127.534f);
  printf("%-15s: %-+2e\n", "%-+2e", 8127.534f);
  printf("%-15s: %-+2.e\n", "%-+2.e", 8127.534f);
  printf("%-15s: %-+2.0e\n", "%-+2.0e", 8127.534f);
  printf("%-15s: %-+2.1e\n", "%-+2.1e", 8127.534f);
  printf("%-15s: %-+2.2e\n", "%-+2.2e", 8127.534f);
  printf("%-15s: %-+2.5e\n", "%-+2.5e", 8127.534f);
  printf("%-15s: %-+2.10e\n", "%-+2.10e", 8127.534f);
  printf("%-15s: %-+2.30e\n", "%-+2.30e", 8127.534f);
  printf("%-15s: %-+5e\n", "%-+5e", 8127.534f);
  printf("%-15s: %-+5.e\n", "%-+5.e", 8127.534f);
  printf("%-15s: %-+5.0e\n", "%-+5.0e", 8127.534f);
  printf("%-15s: %-+5.1e\n", "%-+5.1e", 8127.534f);
  printf("%-15s: %-+5.2e\n", "%-+5.2e", 8127.534f);
  printf("%-15s: %-+5.5e\n", "%-+5.5e", 8127.534f);
  printf("%-15s: %-+5.10e\n", "%-+5.10e", 8127.534f);
  printf("%-15s: %-+5.30e\n", "%-+5.30e", 8127.534f);
  printf("%-15s: %-+10e\n", "%-+10e", 8127.534f);
  printf("%-15s: %-+10.e\n", "%-+10.e", 8127.534f);
  printf("%-15s: %-+10.0e\n", "%-+10.0e", 8127.534f);
  printf("%-15s: %-+10.1e\n", "%-+10.1e", 8127.534f);
  printf("%-15s: %-+10.2e\n", "%-+10.2e", 8127.534f);
  printf("%-15s: %-+10.5e\n", "%-+10.5e", 8127.534f);
  printf("%-15s: %-+10.10e\n", "%-+10.10e", 8127.534f);
  printf("%-15s: %-+10.30e\n", "%-+10.30e", 8127.534f);
  printf("%-15s: %-+30e\n", "%-+30e", 8127.534f);
  printf("%-15s: %-+30.e\n", "%-+30.e", 8127.534f);
  printf("%-15s: %-+30.0e\n", "%-+30.0e", 8127.534f);
  printf("%-15s: %-+30.1e\n", "%-+30.1e", 8127.534f);
  printf("%-15s: %-+30.2e\n", "%-+30.2e", 8127.534f);
  printf("%-15s: %-+30.5e\n", "%-+30.5e", 8127.534f);
  printf("%-15s: %-+30.10e\n", "%-+30.10e", 8127.534f);
  printf("%-15s: %-+30.30e\n", "%-+30.30e", 8127.534f);
  printf("%-15s: %#+e\n", "%#+e", 8127.534f);
  printf("%-15s: %#+.e\n", "%#+.e", 8127.534f);
  printf("%-15s: %#+.0e\n", "%#+.0e", 8127.534f);
  printf("%-15s: %#+.1e\n", "%#+.1e", 8127.534f);
  printf("%-15s: %#+.2e\n", "%#+.2e", 8127.534f);
  printf("%-15s: %#+.5e\n", "%#+.5e", 8127.534f);
  printf("%-15s: %#+.10e\n", "%#+.10e", 8127.534f);
  printf("%-15s: %#+.30e\n", "%#+.30e", 8127.534f);
  printf("%-15s: %#+0e\n", "%#+0e", 8127.534f);
  printf("%-15s: %#+0.e\n", "%#+0.e", 8127.534f);
  printf("%-15s: %#+0.0e\n", "%#+0.0e", 8127.534f);
  printf("%-15s: %#+0.1e\n", "%#+0.1e", 8127.534f);
  printf("%-15s: %#+0.2e\n", "%#+0.2e", 8127.534f);
  printf("%-15s: %#+0.5e\n", "%#+0.5e", 8127.534f);
  printf("%-15s: %#+0.10e\n", "%#+0.10e", 8127.534f);
  printf("%-15s: %#+0.30e\n", "%#+0.30e", 8127.534f);
  printf("%-15s: %#+1e\n", "%#+1e", 8127.534f);
  printf("%-15s: %#+1.e\n", "%#+1.e", 8127.534f);
  printf("%-15s: %#+1.0e\n", "%#+1.0e", 8127.534f);
  printf("%-15s: %#+1.1e\n", "%#+1.1e", 8127.534f);
  printf("%-15s: %#+1.2e\n", "%#+1.2e", 8127.534f);
  printf("%-15s: %#+1.5e\n", "%#+1.5e", 8127.534f);
  printf("%-15s: %#+1.10e\n", "%#+1.10e", 8127.534f);
  printf("%-15s: %#+1.30e\n", "%#+1.30e", 8127.534f);
  printf("%-15s: %#+2e\n", "%#+2e", 8127.534f);
  printf("%-15s: %#+2.e\n", "%#+2.e", 8127.534f);
  printf("%-15s: %#+2.0e\n", "%#+2.0e", 8127.534f);
  printf("%-15s: %#+2.1e\n", "%#+2.1e", 8127.534f);
  printf("%-15s: %#+2.2e\n", "%#+2.2e", 8127.534f);
  printf("%-15s: %#+2.5e\n", "%#+2.5e", 8127.534f);
  printf("%-15s: %#+2.10e\n", "%#+2.10e", 8127.534f);
  printf("%-15s: %#+2.30e\n", "%#+2.30e", 8127.534f);
  printf("%-15s: %#+5e\n", "%#+5e", 8127.534f);
  printf("%-15s: %#+5.e\n", "%#+5.e", 8127.534f);
  printf("%-15s: %#+5.0e\n", "%#+5.0e", 8127.534f);
  printf("%-15s: %#+5.1e\n", "%#+5.1e", 8127.534f);
  printf("%-15s: %#+5.2e\n", "%#+5.2e", 8127.534f);
  printf("%-15s: %#+5.5e\n", "%#+5.5e", 8127.534f);
  printf("%-15s: %#+5.10e\n", "%#+5.10e", 8127.534f);
  printf("%-15s: %#+5.30e\n", "%#+5.30e", 8127.534f);
  printf("%-15s: %#+10e\n", "%#+10e", 8127.534f);
  printf("%-15s: %#+10.e\n", "%#+10.e", 8127.534f);
  printf("%-15s: %#+10.0e\n", "%#+10.0e", 8127.534f);
  printf("%-15s: %#+10.1e\n", "%#+10.1e", 8127.534f);
  printf("%-15s: %#+10.2e\n", "%#+10.2e", 8127.534f);
  printf("%-15s: %#+10.5e\n", "%#+10.5e", 8127.534f);
  printf("%-15s: %#+10.10e\n", "%#+10.10e", 8127.534f);
  printf("%-15s: %#+10.30e\n", "%#+10.30e", 8127.534f);
  printf("%-15s: %#+30e\n", "%#+30e", 8127.534f);
  printf("%-15s: %#+30.e\n", "%#+30.e", 8127.534f);
  printf("%-15s: %#+30.0e\n", "%#+30.0e", 8127.534f);
  printf("%-15s: %#+30.1e\n", "%#+30.1e", 8127.534f);
  printf("%-15s: %#+30.2e\n", "%#+30.2e", 8127.534f);
  printf("%-15s: %#+30.5e\n", "%#+30.5e", 8127.534f);
  printf("%-15s: %#+30.10e\n", "%#+30.10e", 8127.534f);
  printf("%-15s: %#+30.30e\n", "%#+30.30e", 8127.534f);
  printf("%-15s: %+0e\n", "%+0e", 8127.534f);
  printf("%-15s: %+0.e\n", "%+0.e", 8127.534f);
  printf("%-15s: %+0.0e\n", "%+0.0e", 8127.534f);
  printf("%-15s: %+0.1e\n", "%+0.1e", 8127.534f);
  printf("%-15s: %+0.2e\n", "%+0.2e", 8127.534f);
  printf("%-15s: %+0.5e\n", "%+0.5e", 8127.534f);
  printf("%-15s: %+0.10e\n", "%+0.10e", 8127.534f);
  printf("%-15s: %+0.30e\n", "%+0.30e", 8127.534f);
  printf("%-15s: %+01e\n", "%+01e", 8127.534f);
  printf("%-15s: %+01.e\n", "%+01.e", 8127.534f);
  printf("%-15s: %+01.0e\n", "%+01.0e", 8127.534f);
  printf("%-15s: %+01.1e\n", "%+01.1e", 8127.534f);
  printf("%-15s: %+01.2e\n", "%+01.2e", 8127.534f);
  printf("%-15s: %+01.5e\n", "%+01.5e", 8127.534f);
  printf("%-15s: %+01.10e\n", "%+01.10e", 8127.534f);
  printf("%-15s: %+01.30e\n", "%+01.30e", 8127.534f);
  printf("%-15s: %+02e\n", "%+02e", 8127.534f);
  printf("%-15s: %+02.e\n", "%+02.e", 8127.534f);
  printf("%-15s: %+02.0e\n", "%+02.0e", 8127.534f);
  printf("%-15s: %+02.1e\n", "%+02.1e", 8127.534f);
  printf("%-15s: %+02.2e\n", "%+02.2e", 8127.534f);
  printf("%-15s: %+02.5e\n", "%+02.5e", 8127.534f);
  printf("%-15s: %+02.10e\n", "%+02.10e", 8127.534f);
  printf("%-15s: %+02.30e\n", "%+02.30e", 8127.534f);
  printf("%-15s: %+05e\n", "%+05e", 8127.534f);
  printf("%-15s: %+05.e\n", "%+05.e", 8127.534f);
  printf("%-15s: %+05.0e\n", "%+05.0e", 8127.534f);
  printf("%-15s: %+05.1e\n", "%+05.1e", 8127.534f);
  printf("%-15s: %+05.2e\n", "%+05.2e", 8127.534f);
  printf("%-15s: %+05.5e\n", "%+05.5e", 8127.534f);
  printf("%-15s: %+05.10e\n", "%+05.10e", 8127.534f);
  printf("%-15s: %+05.30e\n", "%+05.30e", 8127.534f);
  printf("%-15s: %+010e\n", "%+010e", 8127.534f);
  printf("%-15s: %+010.e\n", "%+010.e", 8127.534f);
  printf("%-15s: %+010.0e\n", "%+010.0e", 8127.534f);
  printf("%-15s: %+010.1e\n", "%+010.1e", 8127.534f);
  printf("%-15s: %+010.2e\n", "%+010.2e", 8127.534f);
  printf("%-15s: %+010.5e\n", "%+010.5e", 8127.534f);
  printf("%-15s: %+010.10e\n", "%+010.10e", 8127.534f);
  printf("%-15s: %+010.30e\n", "%+010.30e", 8127.534f);
  printf("%-15s: %+030e\n", "%+030e", 8127.534f);
  printf("%-15s: %+030.e\n", "%+030.e", 8127.534f);
  printf("%-15s: %+030.0e\n", "%+030.0e", 8127.534f);
  printf("%-15s: %+030.1e\n", "%+030.1e", 8127.534f);
  printf("%-15s: %+030.2e\n", "%+030.2e", 8127.534f);
  printf("%-15s: %+030.5e\n", "%+030.5e", 8127.534f);
  printf("%-15s: %+030.10e\n", "%+030.10e", 8127.534f);
  printf("%-15s: %+030.30e\n", "%+030.30e", 8127.534f);
  printf("%-15s: %+-e\n", "%+-e", 8127.534f);
  printf("%-15s: %+-.e\n", "%+-.e", 8127.534f);
  printf("%-15s: %+-.0e\n", "%+-.0e", 8127.534f);
  printf("%-15s: %+-.1e\n", "%+-.1e", 8127.534f);
  printf("%-15s: %+-.2e\n", "%+-.2e", 8127.534f);
  printf("%-15s: %+-.5e\n", "%+-.5e", 8127.534f);
  printf("%-15s: %+-.10e\n", "%+-.10e", 8127.534f);
  printf("%-15s: %+-.30e\n", "%+-.30e", 8127.534f);
  printf("%-15s: %+-1e\n", "%+-1e", 8127.534f);
  printf("%-15s: %+-1.e\n", "%+-1.e", 8127.534f);
  printf("%-15s: %+-1.0e\n", "%+-1.0e", 8127.534f);
  printf("%-15s: %+-1.1e\n", "%+-1.1e", 8127.534f);
  printf("%-15s: %+-1.2e\n", "%+-1.2e", 8127.534f);
  printf("%-15s: %+-1.5e\n", "%+-1.5e", 8127.534f);
  printf("%-15s: %+-1.10e\n", "%+-1.10e", 8127.534f);
  printf("%-15s: %+-1.30e\n", "%+-1.30e", 8127.534f);
  printf("%-15s: %+-2e\n", "%+-2e", 8127.534f);
  printf("%-15s: %+-2.e\n", "%+-2.e", 8127.534f);
  printf("%-15s: %+-2.0e\n", "%+-2.0e", 8127.534f);
  printf("%-15s: %+-2.1e\n", "%+-2.1e", 8127.534f);
  printf("%-15s: %+-2.2e\n", "%+-2.2e", 8127.534f);
  printf("%-15s: %+-2.5e\n", "%+-2.5e", 8127.534f);
  printf("%-15s: %+-2.10e\n", "%+-2.10e", 8127.534f);
  printf("%-15s: %+-2.30e\n", "%+-2.30e", 8127.534f);
  printf("%-15s: %+-5e\n", "%+-5e", 8127.534f);
  printf("%-15s: %+-5.e\n", "%+-5.e", 8127.534f);
  printf("%-15s: %+-5.0e\n", "%+-5.0e", 8127.534f);
  printf("%-15s: %+-5.1e\n", "%+-5.1e", 8127.534f);
  printf("%-15s: %+-5.2e\n", "%+-5.2e", 8127.534f);
  printf("%-15s: %+-5.5e\n", "%+-5.5e", 8127.534f);
  printf("%-15s: %+-5.10e\n", "%+-5.10e", 8127.534f);
  printf("%-15s: %+-5.30e\n", "%+-5.30e", 8127.534f);
  printf("%-15s: %+-10e\n", "%+-10e", 8127.534f);
  printf("%-15s: %+-10.e\n", "%+-10.e", 8127.534f);
  printf("%-15s: %+-10.0e\n", "%+-10.0e", 8127.534f);
  printf("%-15s: %+-10.1e\n", "%+-10.1e", 8127.534f);
  printf("%-15s: %+-10.2e\n", "%+-10.2e", 8127.534f);
  printf("%-15s: %+-10.5e\n", "%+-10.5e", 8127.534f);
  printf("%-15s: %+-10.10e\n", "%+-10.10e", 8127.534f);
  printf("%-15s: %+-10.30e\n", "%+-10.30e", 8127.534f);
  printf("%-15s: %+-30e\n", "%+-30e", 8127.534f);
  printf("%-15s: %+-30.e\n", "%+-30.e", 8127.534f);
  printf("%-15s: %+-30.0e\n", "%+-30.0e", 8127.534f);
  printf("%-15s: %+-30.1e\n", "%+-30.1e", 8127.534f);
  printf("%-15s: %+-30.2e\n", "%+-30.2e", 8127.534f);
  printf("%-15s: %+-30.5e\n", "%+-30.5e", 8127.534f);
  printf("%-15s: %+-30.10e\n", "%+-30.10e", 8127.534f);
  printf("%-15s: %+-30.30e\n", "%+-30.30e", 8127.534f);
  printf("%-15s: %#-e\n", "%#-e", 8127.534f);
  printf("%-15s: %#-.e\n", "%#-.e", 8127.534f);
  printf("%-15s: %#-.0e\n", "%#-.0e", 8127.534f);
  printf("%-15s: %#-.1e\n", "%#-.1e", 8127.534f);
  printf("%-15s: %#-.2e\n", "%#-.2e", 8127.534f);
  printf("%-15s: %#-.5e\n", "%#-.5e", 8127.534f);
  printf("%-15s: %#-.10e\n", "%#-.10e", 8127.534f);
  printf("%-15s: %#-.30e\n", "%#-.30e", 8127.534f);
  printf("%-15s: %#-1e\n", "%#-1e", 8127.534f);
  printf("%-15s: %#-1.e\n", "%#-1.e", 8127.534f);
  printf("%-15s: %#-1.0e\n", "%#-1.0e", 8127.534f);
  printf("%-15s: %#-1.1e\n", "%#-1.1e", 8127.534f);
  printf("%-15s: %#-1.2e\n", "%#-1.2e", 8127.534f);
  printf("%-15s: %#-1.5e\n", "%#-1.5e", 8127.534f);
  printf("%-15s: %#-1.10e\n", "%#-1.10e", 8127.534f);
  printf("%-15s: %#-1.30e\n", "%#-1.30e", 8127.534f);
  printf("%-15s: %#-2e\n", "%#-2e", 8127.534f);
  printf("%-15s: %#-2.e\n", "%#-2.e", 8127.534f);
  printf("%-15s: %#-2.0e\n", "%#-2.0e", 8127.534f);
  printf("%-15s: %#-2.1e\n", "%#-2.1e", 8127.534f);
  printf("%-15s: %#-2.2e\n", "%#-2.2e", 8127.534f);
  printf("%-15s: %#-2.5e\n", "%#-2.5e", 8127.534f);
  printf("%-15s: %#-2.10e\n", "%#-2.10e", 8127.534f);
  printf("%-15s: %#-2.30e\n", "%#-2.30e", 8127.534f);
  printf("%-15s: %#-5e\n", "%#-5e", 8127.534f);
  printf("%-15s: %#-5.e\n", "%#-5.e", 8127.534f);
  printf("%-15s: %#-5.0e\n", "%#-5.0e", 8127.534f);
  printf("%-15s: %#-5.1e\n", "%#-5.1e", 8127.534f);
  printf("%-15s: %#-5.2e\n", "%#-5.2e", 8127.534f);
  printf("%-15s: %#-5.5e\n", "%#-5.5e", 8127.534f);
  printf("%-15s: %#-5.10e\n", "%#-5.10e", 8127.534f);
  printf("%-15s: %#-5.30e\n", "%#-5.30e", 8127.534f);
  printf("%-15s: %#-10e\n", "%#-10e", 8127.534f);
  printf("%-15s: %#-10.e\n", "%#-10.e", 8127.534f);
  printf("%-15s: %#-10.0e\n", "%#-10.0e", 8127.534f);
  printf("%-15s: %#-10.1e\n", "%#-10.1e", 8127.534f);
  printf("%-15s: %#-10.2e\n", "%#-10.2e", 8127.534f);
  printf("%-15s: %#-10.5e\n", "%#-10.5e", 8127.534f);
  printf("%-15s: %#-10.10e\n", "%#-10.10e", 8127.534f);
  printf("%-15s: %#-10.30e\n", "%#-10.30e", 8127.534f);
  printf("%-15s: %#-30e\n", "%#-30e", 8127.534f);
  printf("%-15s: %#-30.e\n", "%#-30.e", 8127.534f);
  printf("%-15s: %#-30.0e\n", "%#-30.0e", 8127.534f);
  printf("%-15s: %#-30.1e\n", "%#-30.1e", 8127.534f);
  printf("%-15s: %#-30.2e\n", "%#-30.2e", 8127.534f);
  printf("%-15s: %#-30.5e\n", "%#-30.5e", 8127.534f);
  printf("%-15s: %#-30.10e\n", "%#-30.10e", 8127.534f);
  printf("%-15s: %#-30.30e\n", "%#-30.30e", 8127.534f);
  printf("%-15s: %+#e\n", "%+#e", 8127.534f);
  printf("%-15s: %+#.e\n", "%+#.e", 8127.534f);
  printf("%-15s: %+#.0e\n", "%+#.0e", 8127.534f);
  printf("%-15s: %+#.1e\n", "%+#.1e", 8127.534f);
  printf("%-15s: %+#.2e\n", "%+#.2e", 8127.534f);
  printf("%-15s: %+#.5e\n", "%+#.5e", 8127.534f);
  printf("%-15s: %+#.10e\n", "%+#.10e", 8127.534f);
  printf("%-15s: %+#.30e\n", "%+#.30e", 8127.534f);
  printf("%-15s: %+#0e\n", "%+#0e", 8127.534f);
  printf("%-15s: %+#0.e\n", "%+#0.e", 8127.534f);
  printf("%-15s: %+#0.0e\n", "%+#0.0e", 8127.534f);
  printf("%-15s: %+#0.1e\n", "%+#0.1e", 8127.534f);
  printf("%-15s: %+#0.2e\n", "%+#0.2e", 8127.534f);
  printf("%-15s: %+#0.5e\n", "%+#0.5e", 8127.534f);
  printf("%-15s: %+#0.10e\n", "%+#0.10e", 8127.534f);
  printf("%-15s: %+#0.30e\n", "%+#0.30e", 8127.534f);
  printf("%-15s: %+#1e\n", "%+#1e", 8127.534f);
  printf("%-15s: %+#1.e\n", "%+#1.e", 8127.534f);
  printf("%-15s: %+#1.0e\n", "%+#1.0e", 8127.534f);
  printf("%-15s: %+#1.1e\n", "%+#1.1e", 8127.534f);
  printf("%-15s: %+#1.2e\n", "%+#1.2e", 8127.534f);
  printf("%-15s: %+#1.5e\n", "%+#1.5e", 8127.534f);
  printf("%-15s: %+#1.10e\n", "%+#1.10e", 8127.534f);
  printf("%-15s: %+#1.30e\n", "%+#1.30e", 8127.534f);
  printf("%-15s: %+#2e\n", "%+#2e", 8127.534f);
  printf("%-15s: %+#2.e\n", "%+#2.e", 8127.534f);
  printf("%-15s: %+#2.0e\n", "%+#2.0e", 8127.534f);
  printf("%-15s: %+#2.1e\n", "%+#2.1e", 8127.534f);
  printf("%-15s: %+#2.2e\n", "%+#2.2e", 8127.534f);
  printf("%-15s: %+#2.5e\n", "%+#2.5e", 8127.534f);
  printf("%-15s: %+#2.10e\n", "%+#2.10e", 8127.534f);
  printf("%-15s: %+#2.30e\n", "%+#2.30e", 8127.534f);
  printf("%-15s: %+#5e\n", "%+#5e", 8127.534f);
  printf("%-15s: %+#5.e\n", "%+#5.e", 8127.534f);
  printf("%-15s: %+#5.0e\n", "%+#5.0e", 8127.534f);
  printf("%-15s: %+#5.1e\n", "%+#5.1e", 8127.534f);
  printf("%-15s: %+#5.2e\n", "%+#5.2e", 8127.534f);
  printf("%-15s: %+#5.5e\n", "%+#5.5e", 8127.534f);
  printf("%-15s: %+#5.10e\n", "%+#5.10e", 8127.534f);
  printf("%-15s: %+#5.30e\n", "%+#5.30e", 8127.534f);
  printf("%-15s: %+#10e\n", "%+#10e", 8127.534f);
  printf("%-15s: %+#10.e\n", "%+#10.e", 8127.534f);
  printf("%-15s: %+#10.0e\n", "%+#10.0e", 8127.534f);
  printf("%-15s: %+#10.1e\n", "%+#10.1e", 8127.534f);
  printf("%-15s: %+#10.2e\n", "%+#10.2e", 8127.534f);
  printf("%-15s: %+#10.5e\n", "%+#10.5e", 8127.534f);
  printf("%-15s: %+#10.10e\n", "%+#10.10e", 8127.534f);
  printf("%-15s: %+#10.30e\n", "%+#10.30e", 8127.534f);
  printf("%-15s: %+#30e\n", "%+#30e", 8127.534f);
  printf("%-15s: %+#30.e\n", "%+#30.e", 8127.534f);
  printf("%-15s: %+#30.0e\n", "%+#30.0e", 8127.534f);
  printf("%-15s: %+#30.1e\n", "%+#30.1e", 8127.534f);
  printf("%-15s: %+#30.2e\n", "%+#30.2e", 8127.534f);
  printf("%-15s: %+#30.5e\n", "%+#30.5e", 8127.534f);
  printf("%-15s: %+#30.10e\n", "%+#30.10e", 8127.534f);
  printf("%-15s: %+#30.30e\n", "%+#30.30e", 8127.534f);
  printf("%-15s: %-#e\n", "%-#e", 8127.534f);
  printf("%-15s: %-#.e\n", "%-#.e", 8127.534f);
  printf("%-15s: %-#.0e\n", "%-#.0e", 8127.534f);
  printf("%-15s: %-#.1e\n", "%-#.1e", 8127.534f);
  printf("%-15s: %-#.2e\n", "%-#.2e", 8127.534f);
  printf("%-15s: %-#.5e\n", "%-#.5e", 8127.534f);
  printf("%-15s: %-#.10e\n", "%-#.10e", 8127.534f);
  printf("%-15s: %-#.30e\n", "%-#.30e", 8127.534f);
  printf("%-15s: %-#1e\n", "%-#1e", 8127.534f);
  printf("%-15s: %-#1.e\n", "%-#1.e", 8127.534f);
  printf("%-15s: %-#1.0e\n", "%-#1.0e", 8127.534f);
  printf("%-15s: %-#1.1e\n", "%-#1.1e", 8127.534f);
  printf("%-15s: %-#1.2e\n", "%-#1.2e", 8127.534f);
  printf("%-15s: %-#1.5e\n", "%-#1.5e", 8127.534f);
  printf("%-15s: %-#1.10e\n", "%-#1.10e", 8127.534f);
  printf("%-15s: %-#1.30e\n", "%-#1.30e", 8127.534f);
  printf("%-15s: %-#2e\n", "%-#2e", 8127.534f);
  printf("%-15s: %-#2.e\n", "%-#2.e", 8127.534f);
  printf("%-15s: %-#2.0e\n", "%-#2.0e", 8127.534f);
  printf("%-15s: %-#2.1e\n", "%-#2.1e", 8127.534f);
  printf("%-15s: %-#2.2e\n", "%-#2.2e", 8127.534f);
  printf("%-15s: %-#2.5e\n", "%-#2.5e", 8127.534f);
  printf("%-15s: %-#2.10e\n", "%-#2.10e", 8127.534f);
  printf("%-15s: %-#2.30e\n", "%-#2.30e", 8127.534f);
  printf("%-15s: %-#5e\n", "%-#5e", 8127.534f);
  printf("%-15s: %-#5.e\n", "%-#5.e", 8127.534f);
  printf("%-15s: %-#5.0e\n", "%-#5.0e", 8127.534f);
  printf("%-15s: %-#5.1e\n", "%-#5.1e", 8127.534f);
  printf("%-15s: %-#5.2e\n", "%-#5.2e", 8127.534f);
  printf("%-15s: %-#5.5e\n", "%-#5.5e", 8127.534f);
  printf("%-15s: %-#5.10e\n", "%-#5.10e", 8127.534f);
  printf("%-15s: %-#5.30e\n", "%-#5.30e", 8127.534f);
  printf("%-15s: %-#10e\n", "%-#10e", 8127.534f);
  printf("%-15s: %-#10.e\n", "%-#10.e", 8127.534f);
  printf("%-15s: %-#10.0e\n", "%-#10.0e", 8127.534f);
  printf("%-15s: %-#10.1e\n", "%-#10.1e", 8127.534f);
  printf("%-15s: %-#10.2e\n", "%-#10.2e", 8127.534f);
  printf("%-15s: %-#10.5e\n", "%-#10.5e", 8127.534f);
  printf("%-15s: %-#10.10e\n", "%-#10.10e", 8127.534f);
  printf("%-15s: %-#10.30e\n", "%-#10.30e", 8127.534f);
  printf("%-15s: %-#30e\n", "%-#30e", 8127.534f);
  printf("%-15s: %-#30.e\n", "%-#30.e", 8127.534f);
  printf("%-15s: %-#30.0e\n", "%-#30.0e", 8127.534f);
  printf("%-15s: %-#30.1e\n", "%-#30.1e", 8127.534f);
  printf("%-15s: %-#30.2e\n", "%-#30.2e", 8127.534f);
  printf("%-15s: %-#30.5e\n", "%-#30.5e", 8127.534f);
  printf("%-15s: %-#30.10e\n", "%-#30.10e", 8127.534f);
  printf("%-15s: %-#30.30e\n", "%-#30.30e", 8127.534f);
  printf("%-15s: %0#e\n", "%0#e", 8127.534f);
  printf("%-15s: %0#.e\n", "%0#.e", 8127.534f);
  printf("%-15s: %0#.0e\n", "%0#.0e", 8127.534f);
  printf("%-15s: %0#.1e\n", "%0#.1e", 8127.534f);
  printf("%-15s: %0#.2e\n", "%0#.2e", 8127.534f);
  printf("%-15s: %0#.5e\n", "%0#.5e", 8127.534f);
  printf("%-15s: %0#.10e\n", "%0#.10e", 8127.534f);
  printf("%-15s: %0#.30e\n", "%0#.30e", 8127.534f);
  printf("%-15s: %0#1e\n", "%0#1e", 8127.534f);
  printf("%-15s: %0#1.e\n", "%0#1.e", 8127.534f);
  printf("%-15s: %0#1.0e\n", "%0#1.0e", 8127.534f);
  printf("%-15s: %0#1.1e\n", "%0#1.1e", 8127.534f);
  printf("%-15s: %0#1.2e\n", "%0#1.2e", 8127.534f);
  printf("%-15s: %0#1.5e\n", "%0#1.5e", 8127.534f);
  printf("%-15s: %0#1.10e\n", "%0#1.10e", 8127.534f);
  printf("%-15s: %0#1.30e\n", "%0#1.30e", 8127.534f);
  printf("%-15s: %0#2e\n", "%0#2e", 8127.534f);
  printf("%-15s: %0#2.e\n", "%0#2.e", 8127.534f);
  printf("%-15s: %0#2.0e\n", "%0#2.0e", 8127.534f);
  printf("%-15s: %0#2.1e\n", "%0#2.1e", 8127.534f);
  printf("%-15s: %0#2.2e\n", "%0#2.2e", 8127.534f);
  printf("%-15s: %0#2.5e\n", "%0#2.5e", 8127.534f);
  printf("%-15s: %0#2.10e\n", "%0#2.10e", 8127.534f);
  printf("%-15s: %0#2.30e\n", "%0#2.30e", 8127.534f);
  printf("%-15s: %0#5e\n", "%0#5e", 8127.534f);
  printf("%-15s: %0#5.e\n", "%0#5.e", 8127.534f);
  printf("%-15s: %0#5.0e\n", "%0#5.0e", 8127.534f);
  printf("%-15s: %0#5.1e\n", "%0#5.1e", 8127.534f);
  printf("%-15s: %0#5.2e\n", "%0#5.2e", 8127.534f);
  printf("%-15s: %0#5.5e\n", "%0#5.5e", 8127.534f);
  printf("%-15s: %0#5.10e\n", "%0#5.10e", 8127.534f);
  printf("%-15s: %0#5.30e\n", "%0#5.30e", 8127.534f);
  printf("%-15s: %0#10e\n", "%0#10e", 8127.534f);
  printf("%-15s: %0#10.e\n", "%0#10.e", 8127.534f);
  printf("%-15s: %0#10.0e\n", "%0#10.0e", 8127.534f);
  printf("%-15s: %0#10.1e\n", "%0#10.1e", 8127.534f);
  printf("%-15s: %0#10.2e\n", "%0#10.2e", 8127.534f);
  printf("%-15s: %0#10.5e\n", "%0#10.5e", 8127.534f);
  printf("%-15s: %0#10.10e\n", "%0#10.10e", 8127.534f);
  printf("%-15s: %0#10.30e\n", "%0#10.30e", 8127.534f);
  printf("%-15s: %0#30e\n", "%0#30e", 8127.534f);
  printf("%-15s: %0#30.e\n", "%0#30.e", 8127.534f);
  printf("%-15s: %0#30.0e\n", "%0#30.0e", 8127.534f);
  printf("%-15s: %0#30.1e\n", "%0#30.1e", 8127.534f);
  printf("%-15s: %0#30.2e\n", "%0#30.2e", 8127.534f);
  printf("%-15s: %0#30.5e\n", "%0#30.5e", 8127.534f);
  printf("%-15s: %0#30.10e\n", "%0#30.10e", 8127.534f);
  printf("%-15s: %0#30.30e\n", "%0#30.30e", 8127.534f);
  printf("%-15s: %+0e\n", "%+0e", 8127.534f);
  printf("%-15s: %+0.e\n", "%+0.e", 8127.534f);
  printf("%-15s: %+0.0e\n", "%+0.0e", 8127.534f);
  printf("%-15s: %+0.1e\n", "%+0.1e", 8127.534f);
  printf("%-15s: %+0.2e\n", "%+0.2e", 8127.534f);
  printf("%-15s: %+0.5e\n", "%+0.5e", 8127.534f);
  printf("%-15s: %+0.10e\n", "%+0.10e", 8127.534f);
  printf("%-15s: %+0.30e\n", "%+0.30e", 8127.534f);
  printf("%-15s: %+01e\n", "%+01e", 8127.534f);
  printf("%-15s: %+01.e\n", "%+01.e", 8127.534f);
  printf("%-15s: %+01.0e\n", "%+01.0e", 8127.534f);
  printf("%-15s: %+01.1e\n", "%+01.1e", 8127.534f);
  printf("%-15s: %+01.2e\n", "%+01.2e", 8127.534f);
  printf("%-15s: %+01.5e\n", "%+01.5e", 8127.534f);
  printf("%-15s: %+01.10e\n", "%+01.10e", 8127.534f);
  printf("%-15s: %+01.30e\n", "%+01.30e", 8127.534f);
  printf("%-15s: %+02e\n", "%+02e", 8127.534f);
  printf("%-15s: %+02.e\n", "%+02.e", 8127.534f);
  printf("%-15s: %+02.0e\n", "%+02.0e", 8127.534f);
  printf("%-15s: %+02.1e\n", "%+02.1e", 8127.534f);
  printf("%-15s: %+02.2e\n", "%+02.2e", 8127.534f);
  printf("%-15s: %+02.5e\n", "%+02.5e", 8127.534f);
  printf("%-15s: %+02.10e\n", "%+02.10e", 8127.534f);
  printf("%-15s: %+02.30e\n", "%+02.30e", 8127.534f);
  printf("%-15s: %+05e\n", "%+05e", 8127.534f);
  printf("%-15s: %+05.e\n", "%+05.e", 8127.534f);
  printf("%-15s: %+05.0e\n", "%+05.0e", 8127.534f);
  printf("%-15s: %+05.1e\n", "%+05.1e", 8127.534f);
  printf("%-15s: %+05.2e\n", "%+05.2e", 8127.534f);
  printf("%-15s: %+05.5e\n", "%+05.5e", 8127.534f);
  printf("%-15s: %+05.10e\n", "%+05.10e", 8127.534f);
  printf("%-15s: %+05.30e\n", "%+05.30e", 8127.534f);
  printf("%-15s: %+010e\n", "%+010e", 8127.534f);
  printf("%-15s: %+010.e\n", "%+010.e", 8127.534f);
  printf("%-15s: %+010.0e\n", "%+010.0e", 8127.534f);
  printf("%-15s: %+010.1e\n", "%+010.1e", 8127.534f);
  printf("%-15s: %+010.2e\n", "%+010.2e", 8127.534f);
  printf("%-15s: %+010.5e\n", "%+010.5e", 8127.534f);
  printf("%-15s: %+010.10e\n", "%+010.10e", 8127.534f);
  printf("%-15s: %+010.30e\n", "%+010.30e", 8127.534f);
  printf("%-15s: %+030e\n", "%+030e", 8127.534f);
  printf("%-15s: %+030.e\n", "%+030.e", 8127.534f);
  printf("%-15s: %+030.0e\n", "%+030.0e", 8127.534f);
  printf("%-15s: %+030.1e\n", "%+030.1e", 8127.534f);
  printf("%-15s: %+030.2e\n", "%+030.2e", 8127.534f);
  printf("%-15s: %+030.5e\n", "%+030.5e", 8127.534f);
  printf("%-15s: %+030.10e\n", "%+030.10e", 8127.534f);
  printf("%-15s: %+030.30e\n", "%+030.30e", 8127.534f);
  printf("%-15s: %#0e\n", "%#0e", 8127.534f);
  printf("%-15s: %#0.e\n", "%#0.e", 8127.534f);
  printf("%-15s: %#0.0e\n", "%#0.0e", 8127.534f);
  printf("%-15s: %#0.1e\n", "%#0.1e", 8127.534f);
  printf("%-15s: %#0.2e\n", "%#0.2e", 8127.534f);
  printf("%-15s: %#0.5e\n", "%#0.5e", 8127.534f);
  printf("%-15s: %#0.10e\n", "%#0.10e", 8127.534f);
  printf("%-15s: %#0.30e\n", "%#0.30e", 8127.534f);
  printf("%-15s: %#01e\n", "%#01e", 8127.534f);
  printf("%-15s: %#01.e\n", "%#01.e", 8127.534f);
  printf("%-15s: %#01.0e\n", "%#01.0e", 8127.534f);
  printf("%-15s: %#01.1e\n", "%#01.1e", 8127.534f);
  printf("%-15s: %#01.2e\n", "%#01.2e", 8127.534f);
  printf("%-15s: %#01.5e\n", "%#01.5e", 8127.534f);
  printf("%-15s: %#01.10e\n", "%#01.10e", 8127.534f);
  printf("%-15s: %#01.30e\n", "%#01.30e", 8127.534f);
  printf("%-15s: %#02e\n", "%#02e", 8127.534f);
  printf("%-15s: %#02.e\n", "%#02.e", 8127.534f);
  printf("%-15s: %#02.0e\n", "%#02.0e", 8127.534f);
  printf("%-15s: %#02.1e\n", "%#02.1e", 8127.534f);
  printf("%-15s: %#02.2e\n", "%#02.2e", 8127.534f);
  printf("%-15s: %#02.5e\n", "%#02.5e", 8127.534f);
  printf("%-15s: %#02.10e\n", "%#02.10e", 8127.534f);
  printf("%-15s: %#02.30e\n", "%#02.30e", 8127.534f);
  printf("%-15s: %#05e\n", "%#05e", 8127.534f);
  printf("%-15s: %#05.e\n", "%#05.e", 8127.534f);
  printf("%-15s: %#05.0e\n", "%#05.0e", 8127.534f);
  printf("%-15s: %#05.1e\n", "%#05.1e", 8127.534f);
  printf("%-15s: %#05.2e\n", "%#05.2e", 8127.534f);
  printf("%-15s: %#05.5e\n", "%#05.5e", 8127.534f);
  printf("%-15s: %#05.10e\n", "%#05.10e", 8127.534f);
  printf("%-15s: %#05.30e\n", "%#05.30e", 8127.534f);
  printf("%-15s: %#010e\n", "%#010e", 8127.534f);
  printf("%-15s: %#010.e\n", "%#010.e", 8127.534f);
  printf("%-15s: %#010.0e\n", "%#010.0e", 8127.534f);
  printf("%-15s: %#010.1e\n", "%#010.1e", 8127.534f);
  printf("%-15s: %#010.2e\n", "%#010.2e", 8127.534f);
  printf("%-15s: %#010.5e\n", "%#010.5e", 8127.534f);
  printf("%-15s: %#010.10e\n", "%#010.10e", 8127.534f);
  printf("%-15s: %#010.30e\n", "%#010.30e", 8127.534f);
  printf("%-15s: %#030e\n", "%#030e", 8127.534f);
  printf("%-15s: %#030.e\n", "%#030.e", 8127.534f);
  printf("%-15s: %#030.0e\n", "%#030.0e", 8127.534f);
  printf("%-15s: %#030.1e\n", "%#030.1e", 8127.534f);
  printf("%-15s: %#030.2e\n", "%#030.2e", 8127.534f);
  printf("%-15s: %#030.5e\n", "%#030.5e", 8127.534f);
  printf("%-15s: %#030.10e\n", "%#030.10e", 8127.534f);
  printf("%-15s: %#030.30e\n", "%#030.30e", 8127.534f);
  printf("%-15s: %-+#e\n", "%-+#e", 8127.534f);
  printf("%-15s: %-+#.e\n", "%-+#.e", 8127.534f);
  printf("%-15s: %-+#.0e\n", "%-+#.0e", 8127.534f);
  printf("%-15s: %-+#.1e\n", "%-+#.1e", 8127.534f);
  printf("%-15s: %-+#.2e\n", "%-+#.2e", 8127.534f);
  printf("%-15s: %-+#.5e\n", "%-+#.5e", 8127.534f);
  printf("%-15s: %-+#.10e\n", "%-+#.10e", 8127.534f);
  printf("%-15s: %-+#.30e\n", "%-+#.30e", 8127.534f);
  printf("%-15s: %-+#1e\n", "%-+#1e", 8127.534f);
  printf("%-15s: %-+#1.e\n", "%-+#1.e", 8127.534f);
  printf("%-15s: %-+#1.0e\n", "%-+#1.0e", 8127.534f);
  printf("%-15s: %-+#1.1e\n", "%-+#1.1e", 8127.534f);
  printf("%-15s: %-+#1.2e\n", "%-+#1.2e", 8127.534f);
  printf("%-15s: %-+#1.5e\n", "%-+#1.5e", 8127.534f);
  printf("%-15s: %-+#1.10e\n", "%-+#1.10e", 8127.534f);
  printf("%-15s: %-+#1.30e\n", "%-+#1.30e", 8127.534f);
  printf("%-15s: %-+#2e\n", "%-+#2e", 8127.534f);
  printf("%-15s: %-+#2.e\n", "%-+#2.e", 8127.534f);
  printf("%-15s: %-+#2.0e\n", "%-+#2.0e", 8127.534f);
  printf("%-15s: %-+#2.1e\n", "%-+#2.1e", 8127.534f);
  printf("%-15s: %-+#2.2e\n", "%-+#2.2e", 8127.534f);
  printf("%-15s: %-+#2.5e\n", "%-+#2.5e", 8127.534f);
  printf("%-15s: %-+#2.10e\n", "%-+#2.10e", 8127.534f);
  printf("%-15s: %-+#2.30e\n", "%-+#2.30e", 8127.534f);
  printf("%-15s: %-+#5e\n", "%-+#5e", 8127.534f);
  printf("%-15s: %-+#5.e\n", "%-+#5.e", 8127.534f);
  printf("%-15s: %-+#5.0e\n", "%-+#5.0e", 8127.534f);
  printf("%-15s: %-+#5.1e\n", "%-+#5.1e", 8127.534f);
  printf("%-15s: %-+#5.2e\n", "%-+#5.2e", 8127.534f);
  printf("%-15s: %-+#5.5e\n", "%-+#5.5e", 8127.534f);
  printf("%-15s: %-+#5.10e\n", "%-+#5.10e", 8127.534f);
  printf("%-15s: %-+#5.30e\n", "%-+#5.30e", 8127.534f);
  printf("%-15s: %-+#10e\n", "%-+#10e", 8127.534f);
  printf("%-15s: %-+#10.e\n", "%-+#10.e", 8127.534f);
  printf("%-15s: %-+#10.0e\n", "%-+#10.0e", 8127.534f);
  printf("%-15s: %-+#10.1e\n", "%-+#10.1e", 8127.534f);
  printf("%-15s: %-+#10.2e\n", "%-+#10.2e", 8127.534f);
  printf("%-15s: %-+#10.5e\n", "%-+#10.5e", 8127.534f);
  printf("%-15s: %-+#10.10e\n", "%-+#10.10e", 8127.534f);
  printf("%-15s: %-+#10.30e\n", "%-+#10.30e", 8127.534f);
  printf("%-15s: %-+#30e\n", "%-+#30e", 8127.534f);
  printf("%-15s: %-+#30.e\n", "%-+#30.e", 8127.534f);
  printf("%-15s: %-+#30.0e\n", "%-+#30.0e", 8127.534f);
  printf("%-15s: %-+#30.1e\n", "%-+#30.1e", 8127.534f);
  printf("%-15s: %-+#30.2e\n", "%-+#30.2e", 8127.534f);
  printf("%-15s: %-+#30.5e\n", "%-+#30.5e", 8127.534f);
  printf("%-15s: %-+#30.10e\n", "%-+#30.10e", 8127.534f);
  printf("%-15s: %-+#30.30e\n", "%-+#30.30e", 8127.534f);
  printf("%-15s: %0+#e\n", "%0+#e", 8127.534f);
  printf("%-15s: %0+#.e\n", "%0+#.e", 8127.534f);
  printf("%-15s: %0+#.0e\n", "%0+#.0e", 8127.534f);
  printf("%-15s: %0+#.1e\n", "%0+#.1e", 8127.534f);
  printf("%-15s: %0+#.2e\n", "%0+#.2e", 8127.534f);
  printf("%-15s: %0+#.5e\n", "%0+#.5e", 8127.534f);
  printf("%-15s: %0+#.10e\n", "%0+#.10e", 8127.534f);
  printf("%-15s: %0+#.30e\n", "%0+#.30e", 8127.534f);
  printf("%-15s: %0+#1e\n", "%0+#1e", 8127.534f);
  printf("%-15s: %0+#1.e\n", "%0+#1.e", 8127.534f);
  printf("%-15s: %0+#1.0e\n", "%0+#1.0e", 8127.534f);
  printf("%-15s: %0+#1.1e\n", "%0+#1.1e", 8127.534f);
  printf("%-15s: %0+#1.2e\n", "%0+#1.2e", 8127.534f);
  printf("%-15s: %0+#1.5e\n", "%0+#1.5e", 8127.534f);
  printf("%-15s: %0+#1.10e\n", "%0+#1.10e", 8127.534f);
  printf("%-15s: %0+#1.30e\n", "%0+#1.30e", 8127.534f);
  printf("%-15s: %0+#2e\n", "%0+#2e", 8127.534f);
  printf("%-15s: %0+#2.e\n", "%0+#2.e", 8127.534f);
  printf("%-15s: %0+#2.0e\n", "%0+#2.0e", 8127.534f);
  printf("%-15s: %0+#2.1e\n", "%0+#2.1e", 8127.534f);
  printf("%-15s: %0+#2.2e\n", "%0+#2.2e", 8127.534f);
  printf("%-15s: %0+#2.5e\n", "%0+#2.5e", 8127.534f);
  printf("%-15s: %0+#2.10e\n", "%0+#2.10e", 8127.534f);
  printf("%-15s: %0+#2.30e\n", "%0+#2.30e", 8127.534f);
  printf("%-15s: %0+#5e\n", "%0+#5e", 8127.534f);
  printf("%-15s: %0+#5.e\n", "%0+#5.e", 8127.534f);
  printf("%-15s: %0+#5.0e\n", "%0+#5.0e", 8127.534f);
  printf("%-15s: %0+#5.1e\n", "%0+#5.1e", 8127.534f);
  printf("%-15s: %0+#5.2e\n", "%0+#5.2e", 8127.534f);
  printf("%-15s: %0+#5.5e\n", "%0+#5.5e", 8127.534f);
  printf("%-15s: %0+#5.10e\n", "%0+#5.10e", 8127.534f);
  printf("%-15s: %0+#5.30e\n", "%0+#5.30e", 8127.534f);
  printf("%-15s: %0+#10e\n", "%0+#10e", 8127.534f);
  printf("%-15s: %0+#10.e\n", "%0+#10.e", 8127.534f);
  printf("%-15s: %0+#10.0e\n", "%0+#10.0e", 8127.534f);
  printf("%-15s: %0+#10.1e\n", "%0+#10.1e", 8127.534f);
  printf("%-15s: %0+#10.2e\n", "%0+#10.2e", 8127.534f);
  printf("%-15s: %0+#10.5e\n", "%0+#10.5e", 8127.534f);
  printf("%-15s: %0+#10.10e\n", "%0+#10.10e", 8127.534f);
  printf("%-15s: %0+#10.30e\n", "%0+#10.30e", 8127.534f);
  printf("%-15s: %0+#30e\n", "%0+#30e", 8127.534f);
  printf("%-15s: %0+#30.e\n", "%0+#30.e", 8127.534f);
  printf("%-15s: %0+#30.0e\n", "%0+#30.0e", 8127.534f);
  printf("%-15s: %0+#30.1e\n", "%0+#30.1e", 8127.534f);
  printf("%-15s: %0+#30.2e\n", "%0+#30.2e", 8127.534f);
  printf("%-15s: %0+#30.5e\n", "%0+#30.5e", 8127.534f);
  printf("%-15s: %0+#30.10e\n", "%0+#30.10e", 8127.534f);
  printf("%-15s: %0+#30.30e\n", "%0+#30.30e", 8127.534f);
  printf("%-15s: %#-+e\n", "%#-+e", 8127.534f);
  printf("%-15s: %#-+.e\n", "%#-+.e", 8127.534f);
  printf("%-15s: %#-+.0e\n", "%#-+.0e", 8127.534f);
  printf("%-15s: %#-+.1e\n", "%#-+.1e", 8127.534f);
  printf("%-15s: %#-+.2e\n", "%#-+.2e", 8127.534f);
  printf("%-15s: %#-+.5e\n", "%#-+.5e", 8127.534f);
  printf("%-15s: %#-+.10e\n", "%#-+.10e", 8127.534f);
  printf("%-15s: %#-+.30e\n", "%#-+.30e", 8127.534f);
  printf("%-15s: %#-+1e\n", "%#-+1e", 8127.534f);
  printf("%-15s: %#-+1.e\n", "%#-+1.e", 8127.534f);
  printf("%-15s: %#-+1.0e\n", "%#-+1.0e", 8127.534f);
  printf("%-15s: %#-+1.1e\n", "%#-+1.1e", 8127.534f);
  printf("%-15s: %#-+1.2e\n", "%#-+1.2e", 8127.534f);
  printf("%-15s: %#-+1.5e\n", "%#-+1.5e", 8127.534f);
  printf("%-15s: %#-+1.10e\n", "%#-+1.10e", 8127.534f);
  printf("%-15s: %#-+1.30e\n", "%#-+1.30e", 8127.534f);
  printf("%-15s: %#-+2e\n", "%#-+2e", 8127.534f);
  printf("%-15s: %#-+2.e\n", "%#-+2.e", 8127.534f);
  printf("%-15s: %#-+2.0e\n", "%#-+2.0e", 8127.534f);
  printf("%-15s: %#-+2.1e\n", "%#-+2.1e", 8127.534f);
  printf("%-15s: %#-+2.2e\n", "%#-+2.2e", 8127.534f);
  printf("%-15s: %#-+2.5e\n", "%#-+2.5e", 8127.534f);
  printf("%-15s: %#-+2.10e\n", "%#-+2.10e", 8127.534f);
  printf("%-15s: %#-+2.30e\n", "%#-+2.30e", 8127.534f);
  printf("%-15s: %#-+5e\n", "%#-+5e", 8127.534f);
  printf("%-15s: %#-+5.e\n", "%#-+5.e", 8127.534f);
  printf("%-15s: %#-+5.0e\n", "%#-+5.0e", 8127.534f);
  printf("%-15s: %#-+5.1e\n", "%#-+5.1e", 8127.534f);
  printf("%-15s: %#-+5.2e\n", "%#-+5.2e", 8127.534f);
  printf("%-15s: %#-+5.5e\n", "%#-+5.5e", 8127.534f);
  printf("%-15s: %#-+5.10e\n", "%#-+5.10e", 8127.534f);
  printf("%-15s: %#-+5.30e\n", "%#-+5.30e", 8127.534f);
  printf("%-15s: %#-+10e\n", "%#-+10e", 8127.534f);
  printf("%-15s: %#-+10.e\n", "%#-+10.e", 8127.534f);
  printf("%-15s: %#-+10.0e\n", "%#-+10.0e", 8127.534f);
  printf("%-15s: %#-+10.1e\n", "%#-+10.1e", 8127.534f);
  printf("%-15s: %#-+10.2e\n", "%#-+10.2e", 8127.534f);
  printf("%-15s: %#-+10.5e\n", "%#-+10.5e", 8127.534f);
  printf("%-15s: %#-+10.10e\n", "%#-+10.10e", 8127.534f);
  printf("%-15s: %#-+10.30e\n", "%#-+10.30e", 8127.534f);
  printf("%-15s: %#-+30e\n", "%#-+30e", 8127.534f);
  printf("%-15s: %#-+30.e\n", "%#-+30.e", 8127.534f);
  printf("%-15s: %#-+30.0e\n", "%#-+30.0e", 8127.534f);
  printf("%-15s: %#-+30.1e\n", "%#-+30.1e", 8127.534f);
  printf("%-15s: %#-+30.2e\n", "%#-+30.2e", 8127.534f);
  printf("%-15s: %#-+30.5e\n", "%#-+30.5e", 8127.534f);
  printf("%-15s: %#-+30.10e\n", "%#-+30.10e", 8127.534f);
  printf("%-15s: %#-+30.30e\n", "%#-+30.30e", 8127.534f);
  printf("%-15s: %+#-e\n", "%+#-e", 8127.534f);
  printf("%-15s: %+#-.e\n", "%+#-.e", 8127.534f);
  printf("%-15s: %+#-.0e\n", "%+#-.0e", 8127.534f);
  printf("%-15s: %+#-.1e\n", "%+#-.1e", 8127.534f);
  printf("%-15s: %+#-.2e\n", "%+#-.2e", 8127.534f);
  printf("%-15s: %+#-.5e\n", "%+#-.5e", 8127.534f);
  printf("%-15s: %+#-.10e\n", "%+#-.10e", 8127.534f);
  printf("%-15s: %+#-.30e\n", "%+#-.30e", 8127.534f);
  printf("%-15s: %+#-1e\n", "%+#-1e", 8127.534f);
  printf("%-15s: %+#-1.e\n", "%+#-1.e", 8127.534f);
  printf("%-15s: %+#-1.0e\n", "%+#-1.0e", 8127.534f);
  printf("%-15s: %+#-1.1e\n", "%+#-1.1e", 8127.534f);
  printf("%-15s: %+#-1.2e\n", "%+#-1.2e", 8127.534f);
  printf("%-15s: %+#-1.5e\n", "%+#-1.5e", 8127.534f);
  printf("%-15s: %+#-1.10e\n", "%+#-1.10e", 8127.534f);
  printf("%-15s: %+#-1.30e\n", "%+#-1.30e", 8127.534f);
  printf("%-15s: %+#-2e\n", "%+#-2e", 8127.534f);
  printf("%-15s: %+#-2.e\n", "%+#-2.e", 8127.534f);
  printf("%-15s: %+#-2.0e\n", "%+#-2.0e", 8127.534f);
  printf("%-15s: %+#-2.1e\n", "%+#-2.1e", 8127.534f);
  printf("%-15s: %+#-2.2e\n", "%+#-2.2e", 8127.534f);
  printf("%-15s: %+#-2.5e\n", "%+#-2.5e", 8127.534f);
  printf("%-15s: %+#-2.10e\n", "%+#-2.10e", 8127.534f);
  printf("%-15s: %+#-2.30e\n", "%+#-2.30e", 8127.534f);
  printf("%-15s: %+#-5e\n", "%+#-5e", 8127.534f);
  printf("%-15s: %+#-5.e\n", "%+#-5.e", 8127.534f);
  printf("%-15s: %+#-5.0e\n", "%+#-5.0e", 8127.534f);
  printf("%-15s: %+#-5.1e\n", "%+#-5.1e", 8127.534f);
  printf("%-15s: %+#-5.2e\n", "%+#-5.2e", 8127.534f);
  printf("%-15s: %+#-5.5e\n", "%+#-5.5e", 8127.534f);
  printf("%-15s: %+#-5.10e\n", "%+#-5.10e", 8127.534f);
  printf("%-15s: %+#-5.30e\n", "%+#-5.30e", 8127.534f);
  printf("%-15s: %+#-10e\n", "%+#-10e", 8127.534f);
  printf("%-15s: %+#-10.e\n", "%+#-10.e", 8127.534f);
  printf("%-15s: %+#-10.0e\n", "%+#-10.0e", 8127.534f);
  printf("%-15s: %+#-10.1e\n", "%+#-10.1e", 8127.534f);
  printf("%-15s: %+#-10.2e\n", "%+#-10.2e", 8127.534f);
  printf("%-15s: %+#-10.5e\n", "%+#-10.5e", 8127.534f);
  printf("%-15s: %+#-10.10e\n", "%+#-10.10e", 8127.534f);
  printf("%-15s: %+#-10.30e\n", "%+#-10.30e", 8127.534f);
  printf("%-15s: %+#-30e\n", "%+#-30e", 8127.534f);
  printf("%-15s: %+#-30.e\n", "%+#-30.e", 8127.534f);
  printf("%-15s: %+#-30.0e\n", "%+#-30.0e", 8127.534f);
  printf("%-15s: %+#-30.1e\n", "%+#-30.1e", 8127.534f);
  printf("%-15s: %+#-30.2e\n", "%+#-30.2e", 8127.534f);
  printf("%-15s: %+#-30.5e\n", "%+#-30.5e", 8127.534f);
  printf("%-15s: %+#-30.10e\n", "%+#-30.10e", 8127.534f);
  printf("%-15s: %+#-30.30e\n", "%+#-30.30e", 8127.534f);
  printf("%-15s: %+E\n", "%+E", 8127.534f);
  printf("%-15s: %+.E\n", "%+.E", 8127.534f);
  printf("%-15s: %+.0E\n", "%+.0E", 8127.534f);
  printf("%-15s: %+.1E\n", "%+.1E", 8127.534f);
  printf("%-15s: %+.2E\n", "%+.2E", 8127.534f);
  printf("%-15s: %+.5E\n", "%+.5E", 8127.534f);
  printf("%-15s: %+.10E\n", "%+.10E", 8127.534f);
  printf("%-15s: %+.30E\n", "%+.30E", 8127.534f);
  printf("%-15s: %+0E\n", "%+0E", 8127.534f);
  printf("%-15s: %+0.E\n", "%+0.E", 8127.534f);
  printf("%-15s: %+0.0E\n", "%+0.0E", 8127.534f);
  printf("%-15s: %+0.1E\n", "%+0.1E", 8127.534f);
  printf("%-15s: %+0.2E\n", "%+0.2E", 8127.534f);
  printf("%-15s: %+0.5E\n", "%+0.5E", 8127.534f);
  printf("%-15s: %+0.10E\n", "%+0.10E", 8127.534f);
  printf("%-15s: %+0.30E\n", "%+0.30E", 8127.534f);
  printf("%-15s: %+1E\n", "%+1E", 8127.534f);
  printf("%-15s: %+1.E\n", "%+1.E", 8127.534f);
  printf("%-15s: %+1.0E\n", "%+1.0E", 8127.534f);
  printf("%-15s: %+1.1E\n", "%+1.1E", 8127.534f);
  printf("%-15s: %+1.2E\n", "%+1.2E", 8127.534f);
  printf("%-15s: %+1.5E\n", "%+1.5E", 8127.534f);
  printf("%-15s: %+1.10E\n", "%+1.10E", 8127.534f);
  printf("%-15s: %+1.30E\n", "%+1.30E", 8127.534f);
  printf("%-15s: %+2E\n", "%+2E", 8127.534f);
  printf("%-15s: %+2.E\n", "%+2.E", 8127.534f);
  printf("%-15s: %+2.0E\n", "%+2.0E", 8127.534f);
  printf("%-15s: %+2.1E\n", "%+2.1E", 8127.534f);
  printf("%-15s: %+2.2E\n", "%+2.2E", 8127.534f);
  printf("%-15s: %+2.5E\n", "%+2.5E", 8127.534f);
  printf("%-15s: %+2.10E\n", "%+2.10E", 8127.534f);
  printf("%-15s: %+2.30E\n", "%+2.30E", 8127.534f);
  printf("%-15s: %+5E\n", "%+5E", 8127.534f);
  printf("%-15s: %+5.E\n", "%+5.E", 8127.534f);
  printf("%-15s: %+5.0E\n", "%+5.0E", 8127.534f);
  printf("%-15s: %+5.1E\n", "%+5.1E", 8127.534f);
  printf("%-15s: %+5.2E\n", "%+5.2E", 8127.534f);
  printf("%-15s: %+5.5E\n", "%+5.5E", 8127.534f);
  printf("%-15s: %+5.10E\n", "%+5.10E", 8127.534f);
  printf("%-15s: %+5.30E\n", "%+5.30E", 8127.534f);
  printf("%-15s: %+10E\n", "%+10E", 8127.534f);
  printf("%-15s: %+10.E\n", "%+10.E", 8127.534f);
  printf("%-15s: %+10.0E\n", "%+10.0E", 8127.534f);
  printf("%-15s: %+10.1E\n", "%+10.1E", 8127.534f);
  printf("%-15s: %+10.2E\n", "%+10.2E", 8127.534f);
  printf("%-15s: %+10.5E\n", "%+10.5E", 8127.534f);
  printf("%-15s: %+10.10E\n", "%+10.10E", 8127.534f);
  printf("%-15s: %+10.30E\n", "%+10.30E", 8127.534f);
  printf("%-15s: %+30E\n", "%+30E", 8127.534f);
  printf("%-15s: %+30.E\n", "%+30.E", 8127.534f);
  printf("%-15s: %+30.0E\n", "%+30.0E", 8127.534f);
  printf("%-15s: %+30.1E\n", "%+30.1E", 8127.534f);
  printf("%-15s: %+30.2E\n", "%+30.2E", 8127.534f);
  printf("%-15s: %+30.5E\n", "%+30.5E", 8127.534f);
  printf("%-15s: %+30.10E\n", "%+30.10E", 8127.534f);
  printf("%-15s: %+30.30E\n", "%+30.30E", 8127.534f);
  printf("%-15s: %-E\n", "%-E", 8127.534f);
  printf("%-15s: %-.E\n", "%-.E", 8127.534f);
  printf("%-15s: %-.0E\n", "%-.0E", 8127.534f);
  printf("%-15s: %-.1E\n", "%-.1E", 8127.534f);
  printf("%-15s: %-.2E\n", "%-.2E", 8127.534f);
  printf("%-15s: %-.5E\n", "%-.5E", 8127.534f);
  printf("%-15s: %-.10E\n", "%-.10E", 8127.534f);
  printf("%-15s: %-.30E\n", "%-.30E", 8127.534f);
  printf("%-15s: %-1E\n", "%-1E", 8127.534f);
  printf("%-15s: %-1.E\n", "%-1.E", 8127.534f);
  printf("%-15s: %-1.0E\n", "%-1.0E", 8127.534f);
  printf("%-15s: %-1.1E\n", "%-1.1E", 8127.534f);
  printf("%-15s: %-1.2E\n", "%-1.2E", 8127.534f);
  printf("%-15s: %-1.5E\n", "%-1.5E", 8127.534f);
  printf("%-15s: %-1.10E\n", "%-1.10E", 8127.534f);
  printf("%-15s: %-1.30E\n", "%-1.30E", 8127.534f);
  printf("%-15s: %-2E\n", "%-2E", 8127.534f);
  printf("%-15s: %-2.E\n", "%-2.E", 8127.534f);
  printf("%-15s: %-2.0E\n", "%-2.0E", 8127.534f);
  printf("%-15s: %-2.1E\n", "%-2.1E", 8127.534f);
  printf("%-15s: %-2.2E\n", "%-2.2E", 8127.534f);
  printf("%-15s: %-2.5E\n", "%-2.5E", 8127.534f);
  printf("%-15s: %-2.10E\n", "%-2.10E", 8127.534f);
  printf("%-15s: %-2.30E\n", "%-2.30E", 8127.534f);
  printf("%-15s: %-5E\n", "%-5E", 8127.534f);
  printf("%-15s: %-5.E\n", "%-5.E", 8127.534f);
  printf("%-15s: %-5.0E\n", "%-5.0E", 8127.534f);
  printf("%-15s: %-5.1E\n", "%-5.1E", 8127.534f);
  printf("%-15s: %-5.2E\n", "%-5.2E", 8127.534f);
  printf("%-15s: %-5.5E\n", "%-5.5E", 8127.534f);
  printf("%-15s: %-5.10E\n", "%-5.10E", 8127.534f);
  printf("%-15s: %-5.30E\n", "%-5.30E", 8127.534f);
  printf("%-15s: %-10E\n", "%-10E", 8127.534f);
  printf("%-15s: %-10.E\n", "%-10.E", 8127.534f);
  printf("%-15s: %-10.0E\n", "%-10.0E", 8127.534f);
  printf("%-15s: %-10.1E\n", "%-10.1E", 8127.534f);
  printf("%-15s: %-10.2E\n", "%-10.2E", 8127.534f);
  printf("%-15s: %-10.5E\n", "%-10.5E", 8127.534f);
  printf("%-15s: %-10.10E\n", "%-10.10E", 8127.534f);
  printf("%-15s: %-10.30E\n", "%-10.30E", 8127.534f);
  printf("%-15s: %-30E\n", "%-30E", 8127.534f);
  printf("%-15s: %-30.E\n", "%-30.E", 8127.534f);
  printf("%-15s: %-30.0E\n", "%-30.0E", 8127.534f);
  printf("%-15s: %-30.1E\n", "%-30.1E", 8127.534f);
  printf("%-15s: %-30.2E\n", "%-30.2E", 8127.534f);
  printf("%-15s: %-30.5E\n", "%-30.5E", 8127.534f);
  printf("%-15s: %-30.10E\n", "%-30.10E", 8127.534f);
  printf("%-15s: %-30.30E\n", "%-30.30E", 8127.534f);
  printf("%-15s: %#E\n", "%#E", 8127.534f);
  printf("%-15s: %#.E\n", "%#.E", 8127.534f);
  printf("%-15s: %#.0E\n", "%#.0E", 8127.534f);
  printf("%-15s: %#.1E\n", "%#.1E", 8127.534f);
  printf("%-15s: %#.2E\n", "%#.2E", 8127.534f);
  printf("%-15s: %#.5E\n", "%#.5E", 8127.534f);
  printf("%-15s: %#.10E\n", "%#.10E", 8127.534f);
  printf("%-15s: %#.30E\n", "%#.30E", 8127.534f);
  printf("%-15s: %#0E\n", "%#0E", 8127.534f);
  printf("%-15s: %#0.E\n", "%#0.E", 8127.534f);
  printf("%-15s: %#0.0E\n", "%#0.0E", 8127.534f);
  printf("%-15s: %#0.1E\n", "%#0.1E", 8127.534f);
  printf("%-15s: %#0.2E\n", "%#0.2E", 8127.534f);
  printf("%-15s: %#0.5E\n", "%#0.5E", 8127.534f);
  printf("%-15s: %#0.10E\n", "%#0.10E", 8127.534f);
  printf("%-15s: %#0.30E\n", "%#0.30E", 8127.534f);
  printf("%-15s: %#1E\n", "%#1E", 8127.534f);
  printf("%-15s: %#1.E\n", "%#1.E", 8127.534f);
  printf("%-15s: %#1.0E\n", "%#1.0E", 8127.534f);
  printf("%-15s: %#1.1E\n", "%#1.1E", 8127.534f);
  printf("%-15s: %#1.2E\n", "%#1.2E", 8127.534f);
  printf("%-15s: %#1.5E\n", "%#1.5E", 8127.534f);
  printf("%-15s: %#1.10E\n", "%#1.10E", 8127.534f);
  printf("%-15s: %#1.30E\n", "%#1.30E", 8127.534f);
  printf("%-15s: %#2E\n", "%#2E", 8127.534f);
  printf("%-15s: %#2.E\n", "%#2.E", 8127.534f);
  printf("%-15s: %#2.0E\n", "%#2.0E", 8127.534f);
  printf("%-15s: %#2.1E\n", "%#2.1E", 8127.534f);
  printf("%-15s: %#2.2E\n", "%#2.2E", 8127.534f);
  printf("%-15s: %#2.5E\n", "%#2.5E", 8127.534f);
  printf("%-15s: %#2.10E\n", "%#2.10E", 8127.534f);
  printf("%-15s: %#2.30E\n", "%#2.30E", 8127.534f);
  printf("%-15s: %#5E\n", "%#5E", 8127.534f);
  printf("%-15s: %#5.E\n", "%#5.E", 8127.534f);
  printf("%-15s: %#5.0E\n", "%#5.0E", 8127.534f);
  printf("%-15s: %#5.1E\n", "%#5.1E", 8127.534f);
  printf("%-15s: %#5.2E\n", "%#5.2E", 8127.534f);
  printf("%-15s: %#5.5E\n", "%#5.5E", 8127.534f);
  printf("%-15s: %#5.10E\n", "%#5.10E", 8127.534f);
  printf("%-15s: %#5.30E\n", "%#5.30E", 8127.534f);
  printf("%-15s: %#10E\n", "%#10E", 8127.534f);
  printf("%-15s: %#10.E\n", "%#10.E", 8127.534f);
  printf("%-15s: %#10.0E\n", "%#10.0E", 8127.534f);
  printf("%-15s: %#10.1E\n", "%#10.1E", 8127.534f);
  printf("%-15s: %#10.2E\n", "%#10.2E", 8127.534f);
  printf("%-15s: %#10.5E\n", "%#10.5E", 8127.534f);
  printf("%-15s: %#10.10E\n", "%#10.10E", 8127.534f);
  printf("%-15s: %#10.30E\n", "%#10.30E", 8127.534f);
  printf("%-15s: %#30E\n", "%#30E", 8127.534f);
  printf("%-15s: %#30.E\n", "%#30.E", 8127.534f);
  printf("%-15s: %#30.0E\n", "%#30.0E", 8127.534f);
  printf("%-15s: %#30.1E\n", "%#30.1E", 8127.534f);
  printf("%-15s: %#30.2E\n", "%#30.2E", 8127.534f);
  printf("%-15s: %#30.5E\n", "%#30.5E", 8127.534f);
  printf("%-15s: %#30.10E\n", "%#30.10E", 8127.534f);
  printf("%-15s: %#30.30E\n", "%#30.30E", 8127.534f);
  printf("%-15s: %0E\n", "%0E", 8127.534f);
  printf("%-15s: %0.E\n", "%0.E", 8127.534f);
  printf("%-15s: %0.0E\n", "%0.0E", 8127.534f);
  printf("%-15s: %0.1E\n", "%0.1E", 8127.534f);
  printf("%-15s: %0.2E\n", "%0.2E", 8127.534f);
  printf("%-15s: %0.5E\n", "%0.5E", 8127.534f);
  printf("%-15s: %0.10E\n", "%0.10E", 8127.534f);
  printf("%-15s: %0.30E\n", "%0.30E", 8127.534f);
  printf("%-15s: %01E\n", "%01E", 8127.534f);
  printf("%-15s: %01.E\n", "%01.E", 8127.534f);
  printf("%-15s: %01.0E\n", "%01.0E", 8127.534f);
  printf("%-15s: %01.1E\n", "%01.1E", 8127.534f);
  printf("%-15s: %01.2E\n", "%01.2E", 8127.534f);
  printf("%-15s: %01.5E\n", "%01.5E", 8127.534f);
  printf("%-15s: %01.10E\n", "%01.10E", 8127.534f);
  printf("%-15s: %01.30E\n", "%01.30E", 8127.534f);
  printf("%-15s: %02E\n", "%02E", 8127.534f);
  printf("%-15s: %02.E\n", "%02.E", 8127.534f);
  printf("%-15s: %02.0E\n", "%02.0E", 8127.534f);
  printf("%-15s: %02.1E\n", "%02.1E", 8127.534f);
  printf("%-15s: %02.2E\n", "%02.2E", 8127.534f);
  printf("%-15s: %02.5E\n", "%02.5E", 8127.534f);
  printf("%-15s: %02.10E\n", "%02.10E", 8127.534f);
  printf("%-15s: %02.30E\n", "%02.30E", 8127.534f);
  printf("%-15s: %05E\n", "%05E", 8127.534f);
  printf("%-15s: %05.E\n", "%05.E", 8127.534f);
  printf("%-15s: %05.0E\n", "%05.0E", 8127.534f);
  printf("%-15s: %05.1E\n", "%05.1E", 8127.534f);
  printf("%-15s: %05.2E\n", "%05.2E", 8127.534f);
  printf("%-15s: %05.5E\n", "%05.5E", 8127.534f);
  printf("%-15s: %05.10E\n", "%05.10E", 8127.534f);
  printf("%-15s: %05.30E\n", "%05.30E", 8127.534f);
  printf("%-15s: %010E\n", "%010E", 8127.534f);
  printf("%-15s: %010.E\n", "%010.E", 8127.534f);
  printf("%-15s: %010.0E\n", "%010.0E", 8127.534f);
  printf("%-15s: %010.1E\n", "%010.1E", 8127.534f);
  printf("%-15s: %010.2E\n", "%010.2E", 8127.534f);
  printf("%-15s: %010.5E\n", "%010.5E", 8127.534f);
  printf("%-15s: %010.10E\n", "%010.10E", 8127.534f);
  printf("%-15s: %010.30E\n", "%010.30E", 8127.534f);
  printf("%-15s: %030E\n", "%030E", 8127.534f);
  printf("%-15s: %030.E\n", "%030.E", 8127.534f);
  printf("%-15s: %030.0E\n", "%030.0E", 8127.534f);
  printf("%-15s: %030.1E\n", "%030.1E", 8127.534f);
  printf("%-15s: %030.2E\n", "%030.2E", 8127.534f);
  printf("%-15s: %030.5E\n", "%030.5E", 8127.534f);
  printf("%-15s: %030.10E\n", "%030.10E", 8127.534f);
  printf("%-15s: %030.30E\n", "%030.30E", 8127.534f);
  printf("%-15s: %-+E\n", "%-+E", 8127.534f);
  printf("%-15s: %-+.E\n", "%-+.E", 8127.534f);
  printf("%-15s: %-+.0E\n", "%-+.0E", 8127.534f);
  printf("%-15s: %-+.1E\n", "%-+.1E", 8127.534f);
  printf("%-15s: %-+.2E\n", "%-+.2E", 8127.534f);
  printf("%-15s: %-+.5E\n", "%-+.5E", 8127.534f);
  printf("%-15s: %-+.10E\n", "%-+.10E", 8127.534f);
  printf("%-15s: %-+.30E\n", "%-+.30E", 8127.534f);
  printf("%-15s: %-+1E\n", "%-+1E", 8127.534f);
  printf("%-15s: %-+1.E\n", "%-+1.E", 8127.534f);
  printf("%-15s: %-+1.0E\n", "%-+1.0E", 8127.534f);
  printf("%-15s: %-+1.1E\n", "%-+1.1E", 8127.534f);
  printf("%-15s: %-+1.2E\n", "%-+1.2E", 8127.534f);
  printf("%-15s: %-+1.5E\n", "%-+1.5E", 8127.534f);
  printf("%-15s: %-+1.10E\n", "%-+1.10E", 8127.534f);
  printf("%-15s: %-+1.30E\n", "%-+1.30E", 8127.534f);
  printf("%-15s: %-+2E\n", "%-+2E", 8127.534f);
  printf("%-15s: %-+2.E\n", "%-+2.E", 8127.534f);
  printf("%-15s: %-+2.0E\n", "%-+2.0E", 8127.534f);
  printf("%-15s: %-+2.1E\n", "%-+2.1E", 8127.534f);
  printf("%-15s: %-+2.2E\n", "%-+2.2E", 8127.534f);
  printf("%-15s: %-+2.5E\n", "%-+2.5E", 8127.534f);
  printf("%-15s: %-+2.10E\n", "%-+2.10E", 8127.534f);
  printf("%-15s: %-+2.30E\n", "%-+2.30E", 8127.534f);
  printf("%-15s: %-+5E\n", "%-+5E", 8127.534f);
  printf("%-15s: %-+5.E\n", "%-+5.E", 8127.534f);
  printf("%-15s: %-+5.0E\n", "%-+5.0E", 8127.534f);
  printf("%-15s: %-+5.1E\n", "%-+5.1E", 8127.534f);
  printf("%-15s: %-+5.2E\n", "%-+5.2E", 8127.534f);
  printf("%-15s: %-+5.5E\n", "%-+5.5E", 8127.534f);
  printf("%-15s: %-+5.10E\n", "%-+5.10E", 8127.534f);
  printf("%-15s: %-+5.30E\n", "%-+5.30E", 8127.534f);
  printf("%-15s: %-+10E\n", "%-+10E", 8127.534f);
  printf("%-15s: %-+10.E\n", "%-+10.E", 8127.534f);
  printf("%-15s: %-+10.0E\n", "%-+10.0E", 8127.534f);
  printf("%-15s: %-+10.1E\n", "%-+10.1E", 8127.534f);
  printf("%-15s: %-+10.2E\n", "%-+10.2E", 8127.534f);
  printf("%-15s: %-+10.5E\n", "%-+10.5E", 8127.534f);
  printf("%-15s: %-+10.10E\n", "%-+10.10E", 8127.534f);
  printf("%-15s: %-+10.30E\n", "%-+10.30E", 8127.534f);
  printf("%-15s: %-+30E\n", "%-+30E", 8127.534f);
  printf("%-15s: %-+30.E\n", "%-+30.E", 8127.534f);
  printf("%-15s: %-+30.0E\n", "%-+30.0E", 8127.534f);
  printf("%-15s: %-+30.1E\n", "%-+30.1E", 8127.534f);
  printf("%-15s: %-+30.2E\n", "%-+30.2E", 8127.534f);
  printf("%-15s: %-+30.5E\n", "%-+30.5E", 8127.534f);
  printf("%-15s: %-+30.10E\n", "%-+30.10E", 8127.534f);
  printf("%-15s: %-+30.30E\n", "%-+30.30E", 8127.534f);
  printf("%-15s: %#+E\n", "%#+E", 8127.534f);
  printf("%-15s: %#+.E\n", "%#+.E", 8127.534f);
  printf("%-15s: %#+.0E\n", "%#+.0E", 8127.534f);
  printf("%-15s: %#+.1E\n", "%#+.1E", 8127.534f);
  printf("%-15s: %#+.2E\n", "%#+.2E", 8127.534f);
  printf("%-15s: %#+.5E\n", "%#+.5E", 8127.534f);
  printf("%-15s: %#+.10E\n", "%#+.10E", 8127.534f);
  printf("%-15s: %#+.30E\n", "%#+.30E", 8127.534f);
  printf("%-15s: %#+0E\n", "%#+0E", 8127.534f);
  printf("%-15s: %#+0.E\n", "%#+0.E", 8127.534f);
  printf("%-15s: %#+0.0E\n", "%#+0.0E", 8127.534f);
  printf("%-15s: %#+0.1E\n", "%#+0.1E", 8127.534f);
  printf("%-15s: %#+0.2E\n", "%#+0.2E", 8127.534f);
  printf("%-15s: %#+0.5E\n", "%#+0.5E", 8127.534f);
  printf("%-15s: %#+0.10E\n", "%#+0.10E", 8127.534f);
  printf("%-15s: %#+0.30E\n", "%#+0.30E", 8127.534f);
  printf("%-15s: %#+1E\n", "%#+1E", 8127.534f);
  printf("%-15s: %#+1.E\n", "%#+1.E", 8127.534f);
  printf("%-15s: %#+1.0E\n", "%#+1.0E", 8127.534f);
  printf("%-15s: %#+1.1E\n", "%#+1.1E", 8127.534f);
  printf("%-15s: %#+1.2E\n", "%#+1.2E", 8127.534f);
  printf("%-15s: %#+1.5E\n", "%#+1.5E", 8127.534f);
  printf("%-15s: %#+1.10E\n", "%#+1.10E", 8127.534f);
  printf("%-15s: %#+1.30E\n", "%#+1.30E", 8127.534f);
  printf("%-15s: %#+2E\n", "%#+2E", 8127.534f);
  printf("%-15s: %#+2.E\n", "%#+2.E", 8127.534f);
  printf("%-15s: %#+2.0E\n", "%#+2.0E", 8127.534f);
  printf("%-15s: %#+2.1E\n", "%#+2.1E", 8127.534f);
  printf("%-15s: %#+2.2E\n", "%#+2.2E", 8127.534f);
  printf("%-15s: %#+2.5E\n", "%#+2.5E", 8127.534f);
  printf("%-15s: %#+2.10E\n", "%#+2.10E", 8127.534f);
  printf("%-15s: %#+2.30E\n", "%#+2.30E", 8127.534f);
  printf("%-15s: %#+5E\n", "%#+5E", 8127.534f);
  printf("%-15s: %#+5.E\n", "%#+5.E", 8127.534f);
  printf("%-15s: %#+5.0E\n", "%#+5.0E", 8127.534f);
  printf("%-15s: %#+5.1E\n", "%#+5.1E", 8127.534f);
  printf("%-15s: %#+5.2E\n", "%#+5.2E", 8127.534f);
  printf("%-15s: %#+5.5E\n", "%#+5.5E", 8127.534f);
  printf("%-15s: %#+5.10E\n", "%#+5.10E", 8127.534f);
  printf("%-15s: %#+5.30E\n", "%#+5.30E", 8127.534f);
  printf("%-15s: %#+10E\n", "%#+10E", 8127.534f);
  printf("%-15s: %#+10.E\n", "%#+10.E", 8127.534f);
  printf("%-15s: %#+10.0E\n", "%#+10.0E", 8127.534f);
  printf("%-15s: %#+10.1E\n", "%#+10.1E", 8127.534f);
  printf("%-15s: %#+10.2E\n", "%#+10.2E", 8127.534f);
  printf("%-15s: %#+10.5E\n", "%#+10.5E", 8127.534f);
  printf("%-15s: %#+10.10E\n", "%#+10.10E", 8127.534f);
  printf("%-15s: %#+10.30E\n", "%#+10.30E", 8127.534f);
  printf("%-15s: %#+30E\n", "%#+30E", 8127.534f);
  printf("%-15s: %#+30.E\n", "%#+30.E", 8127.534f);
  printf("%-15s: %#+30.0E\n", "%#+30.0E", 8127.534f);
  printf("%-15s: %#+30.1E\n", "%#+30.1E", 8127.534f);
  printf("%-15s: %#+30.2E\n", "%#+30.2E", 8127.534f);
  printf("%-15s: %#+30.5E\n", "%#+30.5E", 8127.534f);
  printf("%-15s: %#+30.10E\n", "%#+30.10E", 8127.534f);
  printf("%-15s: %#+30.30E\n", "%#+30.30E", 8127.534f);
  printf("%-15s: %+0E\n", "%+0E", 8127.534f);
  printf("%-15s: %+0.E\n", "%+0.E", 8127.534f);
  printf("%-15s: %+0.0E\n", "%+0.0E", 8127.534f);
  printf("%-15s: %+0.1E\n", "%+0.1E", 8127.534f);
  printf("%-15s: %+0.2E\n", "%+0.2E", 8127.534f);
  printf("%-15s: %+0.5E\n", "%+0.5E", 8127.534f);
  printf("%-15s: %+0.10E\n", "%+0.10E", 8127.534f);
  printf("%-15s: %+0.30E\n", "%+0.30E", 8127.534f);
  printf("%-15s: %+01E\n", "%+01E", 8127.534f);
  printf("%-15s: %+01.E\n", "%+01.E", 8127.534f);
  printf("%-15s: %+01.0E\n", "%+01.0E", 8127.534f);
  printf("%-15s: %+01.1E\n", "%+01.1E", 8127.534f);
  printf("%-15s: %+01.2E\n", "%+01.2E", 8127.534f);
  printf("%-15s: %+01.5E\n", "%+01.5E", 8127.534f);
  printf("%-15s: %+01.10E\n", "%+01.10E", 8127.534f);
  printf("%-15s: %+01.30E\n", "%+01.30E", 8127.534f);
  printf("%-15s: %+02E\n", "%+02E", 8127.534f);
  printf("%-15s: %+02.E\n", "%+02.E", 8127.534f);
  printf("%-15s: %+02.0E\n", "%+02.0E", 8127.534f);
  printf("%-15s: %+02.1E\n", "%+02.1E", 8127.534f);
  printf("%-15s: %+02.2E\n", "%+02.2E", 8127.534f);
  printf("%-15s: %+02.5E\n", "%+02.5E", 8127.534f);
  printf("%-15s: %+02.10E\n", "%+02.10E", 8127.534f);
  printf("%-15s: %+02.30E\n", "%+02.30E", 8127.534f);
  printf("%-15s: %+05E\n", "%+05E", 8127.534f);
  printf("%-15s: %+05.E\n", "%+05.E", 8127.534f);
  printf("%-15s: %+05.0E\n", "%+05.0E", 8127.534f);
  printf("%-15s: %+05.1E\n", "%+05.1E", 8127.534f);
  printf("%-15s: %+05.2E\n", "%+05.2E", 8127.534f);
  printf("%-15s: %+05.5E\n", "%+05.5E", 8127.534f);
  printf("%-15s: %+05.10E\n", "%+05.10E", 8127.534f);
  printf("%-15s: %+05.30E\n", "%+05.30E", 8127.534f);
  printf("%-15s: %+010E\n", "%+010E", 8127.534f);
  printf("%-15s: %+010.E\n", "%+010.E", 8127.534f);
  printf("%-15s: %+010.0E\n", "%+010.0E", 8127.534f);
  printf("%-15s: %+010.1E\n", "%+010.1E", 8127.534f);
  printf("%-15s: %+010.2E\n", "%+010.2E", 8127.534f);
  printf("%-15s: %+010.5E\n", "%+010.5E", 8127.534f);
  printf("%-15s: %+010.10E\n", "%+010.10E", 8127.534f);
  printf("%-15s: %+010.30E\n", "%+010.30E", 8127.534f);
  printf("%-15s: %+030E\n", "%+030E", 8127.534f);
  printf("%-15s: %+030.E\n", "%+030.E", 8127.534f);
  printf("%-15s: %+030.0E\n", "%+030.0E", 8127.534f);
  printf("%-15s: %+030.1E\n", "%+030.1E", 8127.534f);
  printf("%-15s: %+030.2E\n", "%+030.2E", 8127.534f);
  printf("%-15s: %+030.5E\n", "%+030.5E", 8127.534f);
  printf("%-15s: %+030.10E\n", "%+030.10E", 8127.534f);
  printf("%-15s: %+030.30E\n", "%+030.30E", 8127.534f);
  printf("%-15s: %+-E\n", "%+-E", 8127.534f);
  printf("%-15s: %+-.E\n", "%+-.E", 8127.534f);
  printf("%-15s: %+-.0E\n", "%+-.0E", 8127.534f);
  printf("%-15s: %+-.1E\n", "%+-.1E", 8127.534f);
  printf("%-15s: %+-.2E\n", "%+-.2E", 8127.534f);
  printf("%-15s: %+-.5E\n", "%+-.5E", 8127.534f);
  printf("%-15s: %+-.10E\n", "%+-.10E", 8127.534f);
  printf("%-15s: %+-.30E\n", "%+-.30E", 8127.534f);
  printf("%-15s: %+-1E\n", "%+-1E", 8127.534f);
  printf("%-15s: %+-1.E\n", "%+-1.E", 8127.534f);
  printf("%-15s: %+-1.0E\n", "%+-1.0E", 8127.534f);
  printf("%-15s: %+-1.1E\n", "%+-1.1E", 8127.534f);
  printf("%-15s: %+-1.2E\n", "%+-1.2E", 8127.534f);
  printf("%-15s: %+-1.5E\n", "%+-1.5E", 8127.534f);
  printf("%-15s: %+-1.10E\n", "%+-1.10E", 8127.534f);
  printf("%-15s: %+-1.30E\n", "%+-1.30E", 8127.534f);
  printf("%-15s: %+-2E\n", "%+-2E", 8127.534f);
  printf("%-15s: %+-2.E\n", "%+-2.E", 8127.534f);
  printf("%-15s: %+-2.0E\n", "%+-2.0E", 8127.534f);
  printf("%-15s: %+-2.1E\n", "%+-2.1E", 8127.534f);
  printf("%-15s: %+-2.2E\n", "%+-2.2E", 8127.534f);
  printf("%-15s: %+-2.5E\n", "%+-2.5E", 8127.534f);
  printf("%-15s: %+-2.10E\n", "%+-2.10E", 8127.534f);
  printf("%-15s: %+-2.30E\n", "%+-2.30E", 8127.534f);
  printf("%-15s: %+-5E\n", "%+-5E", 8127.534f);
  printf("%-15s: %+-5.E\n", "%+-5.E", 8127.534f);
  printf("%-15s: %+-5.0E\n", "%+-5.0E", 8127.534f);
  printf("%-15s: %+-5.1E\n", "%+-5.1E", 8127.534f);
  printf("%-15s: %+-5.2E\n", "%+-5.2E", 8127.534f);
  printf("%-15s: %+-5.5E\n", "%+-5.5E", 8127.534f);
  printf("%-15s: %+-5.10E\n", "%+-5.10E", 8127.534f);
  printf("%-15s: %+-5.30E\n", "%+-5.30E", 8127.534f);
  printf("%-15s: %+-10E\n", "%+-10E", 8127.534f);
  printf("%-15s: %+-10.E\n", "%+-10.E", 8127.534f);
  printf("%-15s: %+-10.0E\n", "%+-10.0E", 8127.534f);
  printf("%-15s: %+-10.1E\n", "%+-10.1E", 8127.534f);
  printf("%-15s: %+-10.2E\n", "%+-10.2E", 8127.534f);
  printf("%-15s: %+-10.5E\n", "%+-10.5E", 8127.534f);
  printf("%-15s: %+-10.10E\n", "%+-10.10E", 8127.534f);
  printf("%-15s: %+-10.30E\n", "%+-10.30E", 8127.534f);
  printf("%-15s: %+-30E\n", "%+-30E", 8127.534f);
  printf("%-15s: %+-30.E\n", "%+-30.E", 8127.534f);
  printf("%-15s: %+-30.0E\n", "%+-30.0E", 8127.534f);
  printf("%-15s: %+-30.1E\n", "%+-30.1E", 8127.534f);
  printf("%-15s: %+-30.2E\n", "%+-30.2E", 8127.534f);
  printf("%-15s: %+-30.5E\n", "%+-30.5E", 8127.534f);
  printf("%-15s: %+-30.10E\n", "%+-30.10E", 8127.534f);
  printf("%-15s: %+-30.30E\n", "%+-30.30E", 8127.534f);
  printf("%-15s: %#-E\n", "%#-E", 8127.534f);
  printf("%-15s: %#-.E\n", "%#-.E", 8127.534f);
  printf("%-15s: %#-.0E\n", "%#-.0E", 8127.534f);
  printf("%-15s: %#-.1E\n", "%#-.1E", 8127.534f);
  printf("%-15s: %#-.2E\n", "%#-.2E", 8127.534f);
  printf("%-15s: %#-.5E\n", "%#-.5E", 8127.534f);
  printf("%-15s: %#-.10E\n", "%#-.10E", 8127.534f);
  printf("%-15s: %#-.30E\n", "%#-.30E", 8127.534f);
  printf("%-15s: %#-1E\n", "%#-1E", 8127.534f);
  printf("%-15s: %#-1.E\n", "%#-1.E", 8127.534f);
  printf("%-15s: %#-1.0E\n", "%#-1.0E", 8127.534f);
  printf("%-15s: %#-1.1E\n", "%#-1.1E", 8127.534f);
  printf("%-15s: %#-1.2E\n", "%#-1.2E", 8127.534f);
  printf("%-15s: %#-1.5E\n", "%#-1.5E", 8127.534f);
  printf("%-15s: %#-1.10E\n", "%#-1.10E", 8127.534f);
  printf("%-15s: %#-1.30E\n", "%#-1.30E", 8127.534f);
  printf("%-15s: %#-2E\n", "%#-2E", 8127.534f);
  printf("%-15s: %#-2.E\n", "%#-2.E", 8127.534f);
  printf("%-15s: %#-2.0E\n", "%#-2.0E", 8127.534f);
  printf("%-15s: %#-2.1E\n", "%#-2.1E", 8127.534f);
  printf("%-15s: %#-2.2E\n", "%#-2.2E", 8127.534f);
  printf("%-15s: %#-2.5E\n", "%#-2.5E", 8127.534f);
  printf("%-15s: %#-2.10E\n", "%#-2.10E", 8127.534f);
  printf("%-15s: %#-2.30E\n", "%#-2.30E", 8127.534f);
  printf("%-15s: %#-5E\n", "%#-5E", 8127.534f);
  printf("%-15s: %#-5.E\n", "%#-5.E", 8127.534f);
  printf("%-15s: %#-5.0E\n", "%#-5.0E", 8127.534f);
  printf("%-15s: %#-5.1E\n", "%#-5.1E", 8127.534f);
  printf("%-15s: %#-5.2E\n", "%#-5.2E", 8127.534f);
  printf("%-15s: %#-5.5E\n", "%#-5.5E", 8127.534f);
  printf("%-15s: %#-5.10E\n", "%#-5.10E", 8127.534f);
  printf("%-15s: %#-5.30E\n", "%#-5.30E", 8127.534f);
  printf("%-15s: %#-10E\n", "%#-10E", 8127.534f);
  printf("%-15s: %#-10.E\n", "%#-10.E", 8127.534f);
  printf("%-15s: %#-10.0E\n", "%#-10.0E", 8127.534f);
  printf("%-15s: %#-10.1E\n", "%#-10.1E", 8127.534f);
  printf("%-15s: %#-10.2E\n", "%#-10.2E", 8127.534f);
  printf("%-15s: %#-10.5E\n", "%#-10.5E", 8127.534f);
  printf("%-15s: %#-10.10E\n", "%#-10.10E", 8127.534f);
  printf("%-15s: %#-10.30E\n", "%#-10.30E", 8127.534f);
  printf("%-15s: %#-30E\n", "%#-30E", 8127.534f);
  printf("%-15s: %#-30.E\n", "%#-30.E", 8127.534f);
  printf("%-15s: %#-30.0E\n", "%#-30.0E", 8127.534f);
  printf("%-15s: %#-30.1E\n", "%#-30.1E", 8127.534f);
  printf("%-15s: %#-30.2E\n", "%#-30.2E", 8127.534f);
  printf("%-15s: %#-30.5E\n", "%#-30.5E", 8127.534f);
  printf("%-15s: %#-30.10E\n", "%#-30.10E", 8127.534f);
  printf("%-15s: %#-30.30E\n", "%#-30.30E", 8127.534f);
  printf("%-15s: %+#E\n", "%+#E", 8127.534f);
  printf("%-15s: %+#.E\n", "%+#.E", 8127.534f);
  printf("%-15s: %+#.0E\n", "%+#.0E", 8127.534f);
  printf("%-15s: %+#.1E\n", "%+#.1E", 8127.534f);
  printf("%-15s: %+#.2E\n", "%+#.2E", 8127.534f);
  printf("%-15s: %+#.5E\n", "%+#.5E", 8127.534f);
  printf("%-15s: %+#.10E\n", "%+#.10E", 8127.534f);
  printf("%-15s: %+#.30E\n", "%+#.30E", 8127.534f);
  printf("%-15s: %+#0E\n", "%+#0E", 8127.534f);
  printf("%-15s: %+#0.E\n", "%+#0.E", 8127.534f);
  printf("%-15s: %+#0.0E\n", "%+#0.0E", 8127.534f);
  printf("%-15s: %+#0.1E\n", "%+#0.1E", 8127.534f);
  printf("%-15s: %+#0.2E\n", "%+#0.2E", 8127.534f);
  printf("%-15s: %+#0.5E\n", "%+#0.5E", 8127.534f);
  printf("%-15s: %+#0.10E\n", "%+#0.10E", 8127.534f);
  printf("%-15s: %+#0.30E\n", "%+#0.30E", 8127.534f);
  printf("%-15s: %+#1E\n", "%+#1E", 8127.534f);
  printf("%-15s: %+#1.E\n", "%+#1.E", 8127.534f);
  printf("%-15s: %+#1.0E\n", "%+#1.0E", 8127.534f);
  printf("%-15s: %+#1.1E\n", "%+#1.1E", 8127.534f);
  printf("%-15s: %+#1.2E\n", "%+#1.2E", 8127.534f);
  printf("%-15s: %+#1.5E\n", "%+#1.5E", 8127.534f);
  printf("%-15s: %+#1.10E\n", "%+#1.10E", 8127.534f);
  printf("%-15s: %+#1.30E\n", "%+#1.30E", 8127.534f);
  printf("%-15s: %+#2E\n", "%+#2E", 8127.534f);
  printf("%-15s: %+#2.E\n", "%+#2.E", 8127.534f);
  printf("%-15s: %+#2.0E\n", "%+#2.0E", 8127.534f);
  printf("%-15s: %+#2.1E\n", "%+#2.1E", 8127.534f);
  printf("%-15s: %+#2.2E\n", "%+#2.2E", 8127.534f);
  printf("%-15s: %+#2.5E\n", "%+#2.5E", 8127.534f);
  printf("%-15s: %+#2.10E\n", "%+#2.10E", 8127.534f);
  printf("%-15s: %+#2.30E\n", "%+#2.30E", 8127.534f);
  printf("%-15s: %+#5E\n", "%+#5E", 8127.534f);
  printf("%-15s: %+#5.E\n", "%+#5.E", 8127.534f);
  printf("%-15s: %+#5.0E\n", "%+#5.0E", 8127.534f);
  printf("%-15s: %+#5.1E\n", "%+#5.1E", 8127.534f);
  printf("%-15s: %+#5.2E\n", "%+#5.2E", 8127.534f);
  printf("%-15s: %+#5.5E\n", "%+#5.5E", 8127.534f);
  printf("%-15s: %+#5.10E\n", "%+#5.10E", 8127.534f);
  printf("%-15s: %+#5.30E\n", "%+#5.30E", 8127.534f);
  printf("%-15s: %+#10E\n", "%+#10E", 8127.534f);
  printf("%-15s: %+#10.E\n", "%+#10.E", 8127.534f);
  printf("%-15s: %+#10.0E\n", "%+#10.0E", 8127.534f);
  printf("%-15s: %+#10.1E\n", "%+#10.1E", 8127.534f);
  printf("%-15s: %+#10.2E\n", "%+#10.2E", 8127.534f);
  printf("%-15s: %+#10.5E\n", "%+#10.5E", 8127.534f);
  printf("%-15s: %+#10.10E\n", "%+#10.10E", 8127.534f);
  printf("%-15s: %+#10.30E\n", "%+#10.30E", 8127.534f);
  printf("%-15s: %+#30E\n", "%+#30E", 8127.534f);
  printf("%-15s: %+#30.E\n", "%+#30.E", 8127.534f);
  printf("%-15s: %+#30.0E\n", "%+#30.0E", 8127.534f);
  printf("%-15s: %+#30.1E\n", "%+#30.1E", 8127.534f);
  printf("%-15s: %+#30.2E\n", "%+#30.2E", 8127.534f);
  printf("%-15s: %+#30.5E\n", "%+#30.5E", 8127.534f);
  printf("%-15s: %+#30.10E\n", "%+#30.10E", 8127.534f);
  printf("%-15s: %+#30.30E\n", "%+#30.30E", 8127.534f);
  printf("%-15s: %-#E\n", "%-#E", 8127.534f);
  printf("%-15s: %-#.E\n", "%-#.E", 8127.534f);
  printf("%-15s: %-#.0E\n", "%-#.0E", 8127.534f);
  printf("%-15s: %-#.1E\n", "%-#.1E", 8127.534f);
  printf("%-15s: %-#.2E\n", "%-#.2E", 8127.534f);
  printf("%-15s: %-#.5E\n", "%-#.5E", 8127.534f);
  printf("%-15s: %-#.10E\n", "%-#.10E", 8127.534f);
  printf("%-15s: %-#.30E\n", "%-#.30E", 8127.534f);
  printf("%-15s: %-#1E\n", "%-#1E", 8127.534f);
  printf("%-15s: %-#1.E\n", "%-#1.E", 8127.534f);
  printf("%-15s: %-#1.0E\n", "%-#1.0E", 8127.534f);
  printf("%-15s: %-#1.1E\n", "%-#1.1E", 8127.534f);
  printf("%-15s: %-#1.2E\n", "%-#1.2E", 8127.534f);
  printf("%-15s: %-#1.5E\n", "%-#1.5E", 8127.534f);
  printf("%-15s: %-#1.10E\n", "%-#1.10E", 8127.534f);
  printf("%-15s: %-#1.30E\n", "%-#1.30E", 8127.534f);
  printf("%-15s: %-#2E\n", "%-#2E", 8127.534f);
  printf("%-15s: %-#2.E\n", "%-#2.E", 8127.534f);
  printf("%-15s: %-#2.0E\n", "%-#2.0E", 8127.534f);
  printf("%-15s: %-#2.1E\n", "%-#2.1E", 8127.534f);
  printf("%-15s: %-#2.2E\n", "%-#2.2E", 8127.534f);
  printf("%-15s: %-#2.5E\n", "%-#2.5E", 8127.534f);
  printf("%-15s: %-#2.10E\n", "%-#2.10E", 8127.534f);
  printf("%-15s: %-#2.30E\n", "%-#2.30E", 8127.534f);
  printf("%-15s: %-#5E\n", "%-#5E", 8127.534f);
  printf("%-15s: %-#5.E\n", "%-#5.E", 8127.534f);
  printf("%-15s: %-#5.0E\n", "%-#5.0E", 8127.534f);
  printf("%-15s: %-#5.1E\n", "%-#5.1E", 8127.534f);
  printf("%-15s: %-#5.2E\n", "%-#5.2E", 8127.534f);
  printf("%-15s: %-#5.5E\n", "%-#5.5E", 8127.534f);
  printf("%-15s: %-#5.10E\n", "%-#5.10E", 8127.534f);
  printf("%-15s: %-#5.30E\n", "%-#5.30E", 8127.534f);
  printf("%-15s: %-#10E\n", "%-#10E", 8127.534f);
  printf("%-15s: %-#10.E\n", "%-#10.E", 8127.534f);
  printf("%-15s: %-#10.0E\n", "%-#10.0E", 8127.534f);
  printf("%-15s: %-#10.1E\n", "%-#10.1E", 8127.534f);
  printf("%-15s: %-#10.2E\n", "%-#10.2E", 8127.534f);
  printf("%-15s: %-#10.5E\n", "%-#10.5E", 8127.534f);
  printf("%-15s: %-#10.10E\n", "%-#10.10E", 8127.534f);
  printf("%-15s: %-#10.30E\n", "%-#10.30E", 8127.534f);
  printf("%-15s: %-#30E\n", "%-#30E", 8127.534f);
  printf("%-15s: %-#30.E\n", "%-#30.E", 8127.534f);
  printf("%-15s: %-#30.0E\n", "%-#30.0E", 8127.534f);
  printf("%-15s: %-#30.1E\n", "%-#30.1E", 8127.534f);
  printf("%-15s: %-#30.2E\n", "%-#30.2E", 8127.534f);
  printf("%-15s: %-#30.5E\n", "%-#30.5E", 8127.534f);
  printf("%-15s: %-#30.10E\n", "%-#30.10E", 8127.534f);
  printf("%-15s: %-#30.30E\n", "%-#30.30E", 8127.534f);
  printf("%-15s: %0#E\n", "%0#E", 8127.534f);
  printf("%-15s: %0#.E\n", "%0#.E", 8127.534f);
  printf("%-15s: %0#.0E\n", "%0#.0E", 8127.534f);
  printf("%-15s: %0#.1E\n", "%0#.1E", 8127.534f);
  printf("%-15s: %0#.2E\n", "%0#.2E", 8127.534f);
  printf("%-15s: %0#.5E\n", "%0#.5E", 8127.534f);
  printf("%-15s: %0#.10E\n", "%0#.10E", 8127.534f);
  printf("%-15s: %0#.30E\n", "%0#.30E", 8127.534f);
  printf("%-15s: %0#1E\n", "%0#1E", 8127.534f);
  printf("%-15s: %0#1.E\n", "%0#1.E", 8127.534f);
  printf("%-15s: %0#1.0E\n", "%0#1.0E", 8127.534f);
  printf("%-15s: %0#1.1E\n", "%0#1.1E", 8127.534f);
  printf("%-15s: %0#1.2E\n", "%0#1.2E", 8127.534f);
  printf("%-15s: %0#1.5E\n", "%0#1.5E", 8127.534f);
  printf("%-15s: %0#1.10E\n", "%0#1.10E", 8127.534f);
  printf("%-15s: %0#1.30E\n", "%0#1.30E", 8127.534f);
  printf("%-15s: %0#2E\n", "%0#2E", 8127.534f);
  printf("%-15s: %0#2.E\n", "%0#2.E", 8127.534f);
  printf("%-15s: %0#2.0E\n", "%0#2.0E", 8127.534f);
  printf("%-15s: %0#2.1E\n", "%0#2.1E", 8127.534f);
  printf("%-15s: %0#2.2E\n", "%0#2.2E", 8127.534f);
  printf("%-15s: %0#2.5E\n", "%0#2.5E", 8127.534f);
  printf("%-15s: %0#2.10E\n", "%0#2.10E", 8127.534f);
  printf("%-15s: %0#2.30E\n", "%0#2.30E", 8127.534f);
  printf("%-15s: %0#5E\n", "%0#5E", 8127.534f);
  printf("%-15s: %0#5.E\n", "%0#5.E", 8127.534f);
  printf("%-15s: %0#5.0E\n", "%0#5.0E", 8127.534f);
  printf("%-15s: %0#5.1E\n", "%0#5.1E", 8127.534f);
  printf("%-15s: %0#5.2E\n", "%0#5.2E", 8127.534f);
  printf("%-15s: %0#5.5E\n", "%0#5.5E", 8127.534f);
  printf("%-15s: %0#5.10E\n", "%0#5.10E", 8127.534f);
  printf("%-15s: %0#5.30E\n", "%0#5.30E", 8127.534f);
  printf("%-15s: %0#10E\n", "%0#10E", 8127.534f);
  printf("%-15s: %0#10.E\n", "%0#10.E", 8127.534f);
  printf("%-15s: %0#10.0E\n", "%0#10.0E", 8127.534f);
  printf("%-15s: %0#10.1E\n", "%0#10.1E", 8127.534f);
  printf("%-15s: %0#10.2E\n", "%0#10.2E", 8127.534f);
  printf("%-15s: %0#10.5E\n", "%0#10.5E", 8127.534f);
  printf("%-15s: %0#10.10E\n", "%0#10.10E", 8127.534f);
  printf("%-15s: %0#10.30E\n", "%0#10.30E", 8127.534f);
  printf("%-15s: %0#30E\n", "%0#30E", 8127.534f);
  printf("%-15s: %0#30.E\n", "%0#30.E", 8127.534f);
  printf("%-15s: %0#30.0E\n", "%0#30.0E", 8127.534f);
  printf("%-15s: %0#30.1E\n", "%0#30.1E", 8127.534f);
  printf("%-15s: %0#30.2E\n", "%0#30.2E", 8127.534f);
  printf("%-15s: %0#30.5E\n", "%0#30.5E", 8127.534f);
  printf("%-15s: %0#30.10E\n", "%0#30.10E", 8127.534f);
  printf("%-15s: %0#30.30E\n", "%0#30.30E", 8127.534f);
  printf("%-15s: %+0E\n", "%+0E", 8127.534f);
  printf("%-15s: %+0.E\n", "%+0.E", 8127.534f);
  printf("%-15s: %+0.0E\n", "%+0.0E", 8127.534f);
  printf("%-15s: %+0.1E\n", "%+0.1E", 8127.534f);
  printf("%-15s: %+0.2E\n", "%+0.2E", 8127.534f);
  printf("%-15s: %+0.5E\n", "%+0.5E", 8127.534f);
  printf("%-15s: %+0.10E\n", "%+0.10E", 8127.534f);
  printf("%-15s: %+0.30E\n", "%+0.30E", 8127.534f);
  printf("%-15s: %+01E\n", "%+01E", 8127.534f);
  printf("%-15s: %+01.E\n", "%+01.E", 8127.534f);
  printf("%-15s: %+01.0E\n", "%+01.0E", 8127.534f);
  printf("%-15s: %+01.1E\n", "%+01.1E", 8127.534f);
  printf("%-15s: %+01.2E\n", "%+01.2E", 8127.534f);
  printf("%-15s: %+01.5E\n", "%+01.5E", 8127.534f);
  printf("%-15s: %+01.10E\n", "%+01.10E", 8127.534f);
  printf("%-15s: %+01.30E\n", "%+01.30E", 8127.534f);
  printf("%-15s: %+02E\n", "%+02E", 8127.534f);
  printf("%-15s: %+02.E\n", "%+02.E", 8127.534f);
  printf("%-15s: %+02.0E\n", "%+02.0E", 8127.534f);
  printf("%-15s: %+02.1E\n", "%+02.1E", 8127.534f);
  printf("%-15s: %+02.2E\n", "%+02.2E", 8127.534f);
  printf("%-15s: %+02.5E\n", "%+02.5E", 8127.534f);
  printf("%-15s: %+02.10E\n", "%+02.10E", 8127.534f);
  printf("%-15s: %+02.30E\n", "%+02.30E", 8127.534f);
  printf("%-15s: %+05E\n", "%+05E", 8127.534f);
  printf("%-15s: %+05.E\n", "%+05.E", 8127.534f);
  printf("%-15s: %+05.0E\n", "%+05.0E", 8127.534f);
  printf("%-15s: %+05.1E\n", "%+05.1E", 8127.534f);
  printf("%-15s: %+05.2E\n", "%+05.2E", 8127.534f);
  printf("%-15s: %+05.5E\n", "%+05.5E", 8127.534f);
  printf("%-15s: %+05.10E\n", "%+05.10E", 8127.534f);
  printf("%-15s: %+05.30E\n", "%+05.30E", 8127.534f);
  printf("%-15s: %+010E\n", "%+010E", 8127.534f);
  printf("%-15s: %+010.E\n", "%+010.E", 8127.534f);
  printf("%-15s: %+010.0E\n", "%+010.0E", 8127.534f);
  printf("%-15s: %+010.1E\n", "%+010.1E", 8127.534f);
  printf("%-15s: %+010.2E\n", "%+010.2E", 8127.534f);
  printf("%-15s: %+010.5E\n", "%+010.5E", 8127.534f);
  printf("%-15s: %+010.10E\n", "%+010.10E", 8127.534f);
  printf("%-15s: %+010.30E\n", "%+010.30E", 8127.534f);
  printf("%-15s: %+030E\n", "%+030E", 8127.534f);
  printf("%-15s: %+030.E\n", "%+030.E", 8127.534f);
  printf("%-15s: %+030.0E\n", "%+030.0E", 8127.534f);
  printf("%-15s: %+030.1E\n", "%+030.1E", 8127.534f);
  printf("%-15s: %+030.2E\n", "%+030.2E", 8127.534f);
  printf("%-15s: %+030.5E\n", "%+030.5E", 8127.534f);
  printf("%-15s: %+030.10E\n", "%+030.10E", 8127.534f);
  printf("%-15s: %+030.30E\n", "%+030.30E", 8127.534f);
  printf("%-15s: %#0E\n", "%#0E", 8127.534f);
  printf("%-15s: %#0.E\n", "%#0.E", 8127.534f);
  printf("%-15s: %#0.0E\n", "%#0.0E", 8127.534f);
  printf("%-15s: %#0.1E\n", "%#0.1E", 8127.534f);
  printf("%-15s: %#0.2E\n", "%#0.2E", 8127.534f);
  printf("%-15s: %#0.5E\n", "%#0.5E", 8127.534f);
  printf("%-15s: %#0.10E\n", "%#0.10E", 8127.534f);
  printf("%-15s: %#0.30E\n", "%#0.30E", 8127.534f);
  printf("%-15s: %#01E\n", "%#01E", 8127.534f);
  printf("%-15s: %#01.E\n", "%#01.E", 8127.534f);
  printf("%-15s: %#01.0E\n", "%#01.0E", 8127.534f);
  printf("%-15s: %#01.1E\n", "%#01.1E", 8127.534f);
  printf("%-15s: %#01.2E\n", "%#01.2E", 8127.534f);
  printf("%-15s: %#01.5E\n", "%#01.5E", 8127.534f);
  printf("%-15s: %#01.10E\n", "%#01.10E", 8127.534f);
  printf("%-15s: %#01.30E\n", "%#01.30E", 8127.534f);
  printf("%-15s: %#02E\n", "%#02E", 8127.534f);
  printf("%-15s: %#02.E\n", "%#02.E", 8127.534f);
  printf("%-15s: %#02.0E\n", "%#02.0E", 8127.534f);
  printf("%-15s: %#02.1E\n", "%#02.1E", 8127.534f);
  printf("%-15s: %#02.2E\n", "%#02.2E", 8127.534f);
  printf("%-15s: %#02.5E\n", "%#02.5E", 8127.534f);
  printf("%-15s: %#02.10E\n", "%#02.10E", 8127.534f);
  printf("%-15s: %#02.30E\n", "%#02.30E", 8127.534f);
  printf("%-15s: %#05E\n", "%#05E", 8127.534f);
  printf("%-15s: %#05.E\n", "%#05.E", 8127.534f);
  printf("%-15s: %#05.0E\n", "%#05.0E", 8127.534f);
  printf("%-15s: %#05.1E\n", "%#05.1E", 8127.534f);
  printf("%-15s: %#05.2E\n", "%#05.2E", 8127.534f);
  printf("%-15s: %#05.5E\n", "%#05.5E", 8127.534f);
  printf("%-15s: %#05.10E\n", "%#05.10E", 8127.534f);
  printf("%-15s: %#05.30E\n", "%#05.30E", 8127.534f);
  printf("%-15s: %#010E\n", "%#010E", 8127.534f);
  printf("%-15s: %#010.E\n", "%#010.E", 8127.534f);
  printf("%-15s: %#010.0E\n", "%#010.0E", 8127.534f);
  printf("%-15s: %#010.1E\n", "%#010.1E", 8127.534f);
  printf("%-15s: %#010.2E\n", "%#010.2E", 8127.534f);
  printf("%-15s: %#010.5E\n", "%#010.5E", 8127.534f);
  printf("%-15s: %#010.10E\n", "%#010.10E", 8127.534f);
  printf("%-15s: %#010.30E\n", "%#010.30E", 8127.534f);
  printf("%-15s: %#030E\n", "%#030E", 8127.534f);
  printf("%-15s: %#030.E\n", "%#030.E", 8127.534f);
  printf("%-15s: %#030.0E\n", "%#030.0E", 8127.534f);
  printf("%-15s: %#030.1E\n", "%#030.1E", 8127.534f);
  printf("%-15s: %#030.2E\n", "%#030.2E", 8127.534f);
  printf("%-15s: %#030.5E\n", "%#030.5E", 8127.534f);
  printf("%-15s: %#030.10E\n", "%#030.10E", 8127.534f);
  printf("%-15s: %#030.30E\n", "%#030.30E", 8127.534f);
  printf("%-15s: %-+#E\n", "%-+#E", 8127.534f);
  printf("%-15s: %-+#.E\n", "%-+#.E", 8127.534f);
  printf("%-15s: %-+#.0E\n", "%-+#.0E", 8127.534f);
  printf("%-15s: %-+#.1E\n", "%-+#.1E", 8127.534f);
  printf("%-15s: %-+#.2E\n", "%-+#.2E", 8127.534f);
  printf("%-15s: %-+#.5E\n", "%-+#.5E", 8127.534f);
  printf("%-15s: %-+#.10E\n", "%-+#.10E", 8127.534f);
  printf("%-15s: %-+#.30E\n", "%-+#.30E", 8127.534f);
  printf("%-15s: %-+#1E\n", "%-+#1E", 8127.534f);
  printf("%-15s: %-+#1.E\n", "%-+#1.E", 8127.534f);
  printf("%-15s: %-+#1.0E\n", "%-+#1.0E", 8127.534f);
  printf("%-15s: %-+#1.1E\n", "%-+#1.1E", 8127.534f);
  printf("%-15s: %-+#1.2E\n", "%-+#1.2E", 8127.534f);
  printf("%-15s: %-+#1.5E\n", "%-+#1.5E", 8127.534f);
  printf("%-15s: %-+#1.10E\n", "%-+#1.10E", 8127.534f);
  printf("%-15s: %-+#1.30E\n", "%-+#1.30E", 8127.534f);
  printf("%-15s: %-+#2E\n", "%-+#2E", 8127.534f);
  printf("%-15s: %-+#2.E\n", "%-+#2.E", 8127.534f);
  printf("%-15s: %-+#2.0E\n", "%-+#2.0E", 8127.534f);
  printf("%-15s: %-+#2.1E\n", "%-+#2.1E", 8127.534f);
  printf("%-15s: %-+#2.2E\n", "%-+#2.2E", 8127.534f);
  printf("%-15s: %-+#2.5E\n", "%-+#2.5E", 8127.534f);
  printf("%-15s: %-+#2.10E\n", "%-+#2.10E", 8127.534f);
  printf("%-15s: %-+#2.30E\n", "%-+#2.30E", 8127.534f);
  printf("%-15s: %-+#5E\n", "%-+#5E", 8127.534f);
  printf("%-15s: %-+#5.E\n", "%-+#5.E", 8127.534f);
  printf("%-15s: %-+#5.0E\n", "%-+#5.0E", 8127.534f);
  printf("%-15s: %-+#5.1E\n", "%-+#5.1E", 8127.534f);
  printf("%-15s: %-+#5.2E\n", "%-+#5.2E", 8127.534f);
  printf("%-15s: %-+#5.5E\n", "%-+#5.5E", 8127.534f);
  printf("%-15s: %-+#5.10E\n", "%-+#5.10E", 8127.534f);
  printf("%-15s: %-+#5.30E\n", "%-+#5.30E", 8127.534f);
  printf("%-15s: %-+#10E\n", "%-+#10E", 8127.534f);
  printf("%-15s: %-+#10.E\n", "%-+#10.E", 8127.534f);
  printf("%-15s: %-+#10.0E\n", "%-+#10.0E", 8127.534f);
  printf("%-15s: %-+#10.1E\n", "%-+#10.1E", 8127.534f);
  printf("%-15s: %-+#10.2E\n", "%-+#10.2E", 8127.534f);
  printf("%-15s: %-+#10.5E\n", "%-+#10.5E", 8127.534f);
  printf("%-15s: %-+#10.10E\n", "%-+#10.10E", 8127.534f);
  printf("%-15s: %-+#10.30E\n", "%-+#10.30E", 8127.534f);
  printf("%-15s: %-+#30E\n", "%-+#30E", 8127.534f);
  printf("%-15s: %-+#30.E\n", "%-+#30.E", 8127.534f);
  printf("%-15s: %-+#30.0E\n", "%-+#30.0E", 8127.534f);
  printf("%-15s: %-+#30.1E\n", "%-+#30.1E", 8127.534f);
  printf("%-15s: %-+#30.2E\n", "%-+#30.2E", 8127.534f);
  printf("%-15s: %-+#30.5E\n", "%-+#30.5E", 8127.534f);
  printf("%-15s: %-+#30.10E\n", "%-+#30.10E", 8127.534f);
  printf("%-15s: %-+#30.30E\n", "%-+#30.30E", 8127.534f);
  printf("%-15s: %0+#E\n", "%0+#E", 8127.534f);
  printf("%-15s: %0+#.E\n", "%0+#.E", 8127.534f);
  printf("%-15s: %0+#.0E\n", "%0+#.0E", 8127.534f);
  printf("%-15s: %0+#.1E\n", "%0+#.1E", 8127.534f);
  printf("%-15s: %0+#.2E\n", "%0+#.2E", 8127.534f);
  printf("%-15s: %0+#.5E\n", "%0+#.5E", 8127.534f);
  printf("%-15s: %0+#.10E\n", "%0+#.10E", 8127.534f);
  printf("%-15s: %0+#.30E\n", "%0+#.30E", 8127.534f);
  printf("%-15s: %0+#1E\n", "%0+#1E", 8127.534f);
  printf("%-15s: %0+#1.E\n", "%0+#1.E", 8127.534f);
  printf("%-15s: %0+#1.0E\n", "%0+#1.0E", 8127.534f);
  printf("%-15s: %0+#1.1E\n", "%0+#1.1E", 8127.534f);
  printf("%-15s: %0+#1.2E\n", "%0+#1.2E", 8127.534f);
  printf("%-15s: %0+#1.5E\n", "%0+#1.5E", 8127.534f);
  printf("%-15s: %0+#1.10E\n", "%0+#1.10E", 8127.534f);
  printf("%-15s: %0+#1.30E\n", "%0+#1.30E", 8127.534f);
  printf("%-15s: %0+#2E\n", "%0+#2E", 8127.534f);
  printf("%-15s: %0+#2.E\n", "%0+#2.E", 8127.534f);
  printf("%-15s: %0+#2.0E\n", "%0+#2.0E", 8127.534f);
  printf("%-15s: %0+#2.1E\n", "%0+#2.1E", 8127.534f);
  printf("%-15s: %0+#2.2E\n", "%0+#2.2E", 8127.534f);
  printf("%-15s: %0+#2.5E\n", "%0+#2.5E", 8127.534f);
  printf("%-15s: %0+#2.10E\n", "%0+#2.10E", 8127.534f);
  printf("%-15s: %0+#2.30E\n", "%0+#2.30E", 8127.534f);
  printf("%-15s: %0+#5E\n", "%0+#5E", 8127.534f);
  printf("%-15s: %0+#5.E\n", "%0+#5.E", 8127.534f);
  printf("%-15s: %0+#5.0E\n", "%0+#5.0E", 8127.534f);
  printf("%-15s: %0+#5.1E\n", "%0+#5.1E", 8127.534f);
  printf("%-15s: %0+#5.2E\n", "%0+#5.2E", 8127.534f);
  printf("%-15s: %0+#5.5E\n", "%0+#5.5E", 8127.534f);
  printf("%-15s: %0+#5.10E\n", "%0+#5.10E", 8127.534f);
  printf("%-15s: %0+#5.30E\n", "%0+#5.30E", 8127.534f);
  printf("%-15s: %0+#10E\n", "%0+#10E", 8127.534f);
  printf("%-15s: %0+#10.E\n", "%0+#10.E", 8127.534f);
  printf("%-15s: %0+#10.0E\n", "%0+#10.0E", 8127.534f);
  printf("%-15s: %0+#10.1E\n", "%0+#10.1E", 8127.534f);
  printf("%-15s: %0+#10.2E\n", "%0+#10.2E", 8127.534f);
  printf("%-15s: %0+#10.5E\n", "%0+#10.5E", 8127.534f);
  printf("%-15s: %0+#10.10E\n", "%0+#10.10E", 8127.534f);
  printf("%-15s: %0+#10.30E\n", "%0+#10.30E", 8127.534f);
  printf("%-15s: %0+#30E\n", "%0+#30E", 8127.534f);
  printf("%-15s: %0+#30.E\n", "%0+#30.E", 8127.534f);
  printf("%-15s: %0+#30.0E\n", "%0+#30.0E", 8127.534f);
  printf("%-15s: %0+#30.1E\n", "%0+#30.1E", 8127.534f);
  printf("%-15s: %0+#30.2E\n", "%0+#30.2E", 8127.534f);
  printf("%-15s: %0+#30.5E\n", "%0+#30.5E", 8127.534f);
  printf("%-15s: %0+#30.10E\n", "%0+#30.10E", 8127.534f);
  printf("%-15s: %0+#30.30E\n", "%0+#30.30E", 8127.534f);
  printf("%-15s: %#-+E\n", "%#-+E", 8127.534f);
  printf("%-15s: %#-+.E\n", "%#-+.E", 8127.534f);
  printf("%-15s: %#-+.0E\n", "%#-+.0E", 8127.534f);
  printf("%-15s: %#-+.1E\n", "%#-+.1E", 8127.534f);
  printf("%-15s: %#-+.2E\n", "%#-+.2E", 8127.534f);
  printf("%-15s: %#-+.5E\n", "%#-+.5E", 8127.534f);
  printf("%-15s: %#-+.10E\n", "%#-+.10E", 8127.534f);
  printf("%-15s: %#-+.30E\n", "%#-+.30E", 8127.534f);
  printf("%-15s: %#-+1E\n", "%#-+1E", 8127.534f);
  printf("%-15s: %#-+1.E\n", "%#-+1.E", 8127.534f);
  printf("%-15s: %#-+1.0E\n", "%#-+1.0E", 8127.534f);
  printf("%-15s: %#-+1.1E\n", "%#-+1.1E", 8127.534f);
  printf("%-15s: %#-+1.2E\n", "%#-+1.2E", 8127.534f);
  printf("%-15s: %#-+1.5E\n", "%#-+1.5E", 8127.534f);
  printf("%-15s: %#-+1.10E\n", "%#-+1.10E", 8127.534f);
  printf("%-15s: %#-+1.30E\n", "%#-+1.30E", 8127.534f);
  printf("%-15s: %#-+2E\n", "%#-+2E", 8127.534f);
  printf("%-15s: %#-+2.E\n", "%#-+2.E", 8127.534f);
  printf("%-15s: %#-+2.0E\n", "%#-+2.0E", 8127.534f);
  printf("%-15s: %#-+2.1E\n", "%#-+2.1E", 8127.534f);
  printf("%-15s: %#-+2.2E\n", "%#-+2.2E", 8127.534f);
  printf("%-15s: %#-+2.5E\n", "%#-+2.5E", 8127.534f);
  printf("%-15s: %#-+2.10E\n", "%#-+2.10E", 8127.534f);
  printf("%-15s: %#-+2.30E\n", "%#-+2.30E", 8127.534f);
  printf("%-15s: %#-+5E\n", "%#-+5E", 8127.534f);
  printf("%-15s: %#-+5.E\n", "%#-+5.E", 8127.534f);
  printf("%-15s: %#-+5.0E\n", "%#-+5.0E", 8127.534f);
  printf("%-15s: %#-+5.1E\n", "%#-+5.1E", 8127.534f);
  printf("%-15s: %#-+5.2E\n", "%#-+5.2E", 8127.534f);
  printf("%-15s: %#-+5.5E\n", "%#-+5.5E", 8127.534f);
  printf("%-15s: %#-+5.10E\n", "%#-+5.10E", 8127.534f);
  printf("%-15s: %#-+5.30E\n", "%#-+5.30E", 8127.534f);
  printf("%-15s: %#-+10E\n", "%#-+10E", 8127.534f);
  printf("%-15s: %#-+10.E\n", "%#-+10.E", 8127.534f);
  printf("%-15s: %#-+10.0E\n", "%#-+10.0E", 8127.534f);
  printf("%-15s: %#-+10.1E\n", "%#-+10.1E", 8127.534f);
  printf("%-15s: %#-+10.2E\n", "%#-+10.2E", 8127.534f);
  printf("%-15s: %#-+10.5E\n", "%#-+10.5E", 8127.534f);
  printf("%-15s: %#-+10.10E\n", "%#-+10.10E", 8127.534f);
  printf("%-15s: %#-+10.30E\n", "%#-+10.30E", 8127.534f);
  printf("%-15s: %#-+30E\n", "%#-+30E", 8127.534f);
  printf("%-15s: %#-+30.E\n", "%#-+30.E", 8127.534f);
  printf("%-15s: %#-+30.0E\n", "%#-+30.0E", 8127.534f);
  printf("%-15s: %#-+30.1E\n", "%#-+30.1E", 8127.534f);
  printf("%-15s: %#-+30.2E\n", "%#-+30.2E", 8127.534f);
  printf("%-15s: %#-+30.5E\n", "%#-+30.5E", 8127.534f);
  printf("%-15s: %#-+30.10E\n", "%#-+30.10E", 8127.534f);
  printf("%-15s: %#-+30.30E\n", "%#-+30.30E", 8127.534f);
  printf("%-15s: %+#-E\n", "%+#-E", 8127.534f);
  printf("%-15s: %+#-.E\n", "%+#-.E", 8127.534f);
  printf("%-15s: %+#-.0E\n", "%+#-.0E", 8127.534f);
  printf("%-15s: %+#-.1E\n", "%+#-.1E", 8127.534f);
  printf("%-15s: %+#-.2E\n", "%+#-.2E", 8127.534f);
  printf("%-15s: %+#-.5E\n", "%+#-.5E", 8127.534f);
  printf("%-15s: %+#-.10E\n", "%+#-.10E", 8127.534f);
  printf("%-15s: %+#-.30E\n", "%+#-.30E", 8127.534f);
  printf("%-15s: %+#-1E\n", "%+#-1E", 8127.534f);
  printf("%-15s: %+#-1.E\n", "%+#-1.E", 8127.534f);
  printf("%-15s: %+#-1.0E\n", "%+#-1.0E", 8127.534f);
  printf("%-15s: %+#-1.1E\n", "%+#-1.1E", 8127.534f);
  printf("%-15s: %+#-1.2E\n", "%+#-1.2E", 8127.534f);
  printf("%-15s: %+#-1.5E\n", "%+#-1.5E", 8127.534f);
  printf("%-15s: %+#-1.10E\n", "%+#-1.10E", 8127.534f);
  printf("%-15s: %+#-1.30E\n", "%+#-1.30E", 8127.534f);
  printf("%-15s: %+#-2E\n", "%+#-2E", 8127.534f);
  printf("%-15s: %+#-2.E\n", "%+#-2.E", 8127.534f);
  printf("%-15s: %+#-2.0E\n", "%+#-2.0E", 8127.534f);
  printf("%-15s: %+#-2.1E\n", "%+#-2.1E", 8127.534f);
  printf("%-15s: %+#-2.2E\n", "%+#-2.2E", 8127.534f);
  printf("%-15s: %+#-2.5E\n", "%+#-2.5E", 8127.534f);
  printf("%-15s: %+#-2.10E\n", "%+#-2.10E", 8127.534f);
  printf("%-15s: %+#-2.30E\n", "%+#-2.30E", 8127.534f);
  printf("%-15s: %+#-5E\n", "%+#-5E", 8127.534f);
  printf("%-15s: %+#-5.E\n", "%+#-5.E", 8127.534f);
  printf("%-15s: %+#-5.0E\n", "%+#-5.0E", 8127.534f);
  printf("%-15s: %+#-5.1E\n", "%+#-5.1E", 8127.534f);
  printf("%-15s: %+#-5.2E\n", "%+#-5.2E", 8127.534f);
  printf("%-15s: %+#-5.5E\n", "%+#-5.5E", 8127.534f);
  printf("%-15s: %+#-5.10E\n", "%+#-5.10E", 8127.534f);
  printf("%-15s: %+#-5.30E\n", "%+#-5.30E", 8127.534f);
  printf("%-15s: %+#-10E\n", "%+#-10E", 8127.534f);
  printf("%-15s: %+#-10.E\n", "%+#-10.E", 8127.534f);
  printf("%-15s: %+#-10.0E\n", "%+#-10.0E", 8127.534f);
  printf("%-15s: %+#-10.1E\n", "%+#-10.1E", 8127.534f);
  printf("%-15s: %+#-10.2E\n", "%+#-10.2E", 8127.534f);
  printf("%-15s: %+#-10.5E\n", "%+#-10.5E", 8127.534f);
  printf("%-15s: %+#-10.10E\n", "%+#-10.10E", 8127.534f);
  printf("%-15s: %+#-10.30E\n", "%+#-10.30E", 8127.534f);
  printf("%-15s: %+#-30E\n", "%+#-30E", 8127.534f);
  printf("%-15s: %+#-30.E\n", "%+#-30.E", 8127.534f);
  printf("%-15s: %+#-30.0E\n", "%+#-30.0E", 8127.534f);
  printf("%-15s: %+#-30.1E\n", "%+#-30.1E", 8127.534f);
  printf("%-15s: %+#-30.2E\n", "%+#-30.2E", 8127.534f);
  printf("%-15s: %+#-30.5E\n", "%+#-30.5E", 8127.534f);
  printf("%-15s: %+#-30.10E\n", "%+#-30.10E", 8127.534f);
  printf("%-15s: %+#-30.30E\n", "%+#-30.30E", 8127.534f);
  printf("%-15s: %+g\n", "%+g", 8127.534f);
  printf("%-15s: %+.g\n", "%+.g", 8127.534f);
  printf("%-15s: %+.0g\n", "%+.0g", 8127.534f);
  printf("%-15s: %+.1g\n", "%+.1g", 8127.534f);
  printf("%-15s: %+.2g\n", "%+.2g", 8127.534f);
  printf("%-15s: %+.5g\n", "%+.5g", 8127.534f);
  printf("%-15s: %+.10g\n", "%+.10g", 8127.534f);
  printf("%-15s: %+.30g\n", "%+.30g", 8127.534f);
  printf("%-15s: %+0g\n", "%+0g", 8127.534f);
  printf("%-15s: %+0.g\n", "%+0.g", 8127.534f);
  printf("%-15s: %+0.0g\n", "%+0.0g", 8127.534f);
  printf("%-15s: %+0.1g\n", "%+0.1g", 8127.534f);
  printf("%-15s: %+0.2g\n", "%+0.2g", 8127.534f);
  printf("%-15s: %+0.5g\n", "%+0.5g", 8127.534f);
  printf("%-15s: %+0.10g\n", "%+0.10g", 8127.534f);
  printf("%-15s: %+0.30g\n", "%+0.30g", 8127.534f);
  printf("%-15s: %+1g\n", "%+1g", 8127.534f);
  printf("%-15s: %+1.g\n", "%+1.g", 8127.534f);
  printf("%-15s: %+1.0g\n", "%+1.0g", 8127.534f);
  printf("%-15s: %+1.1g\n", "%+1.1g", 8127.534f);
  printf("%-15s: %+1.2g\n", "%+1.2g", 8127.534f);
  printf("%-15s: %+1.5g\n", "%+1.5g", 8127.534f);
  printf("%-15s: %+1.10g\n", "%+1.10g", 8127.534f);
  printf("%-15s: %+1.30g\n", "%+1.30g", 8127.534f);
  printf("%-15s: %+2g\n", "%+2g", 8127.534f);
  printf("%-15s: %+2.g\n", "%+2.g", 8127.534f);
  printf("%-15s: %+2.0g\n", "%+2.0g", 8127.534f);
  printf("%-15s: %+2.1g\n", "%+2.1g", 8127.534f);
  printf("%-15s: %+2.2g\n", "%+2.2g", 8127.534f);
  printf("%-15s: %+2.5g\n", "%+2.5g", 8127.534f);
  printf("%-15s: %+2.10g\n", "%+2.10g", 8127.534f);
  printf("%-15s: %+2.30g\n", "%+2.30g", 8127.534f);
  printf("%-15s: %+5g\n", "%+5g", 8127.534f);
  printf("%-15s: %+5.g\n", "%+5.g", 8127.534f);
  printf("%-15s: %+5.0g\n", "%+5.0g", 8127.534f);
  printf("%-15s: %+5.1g\n", "%+5.1g", 8127.534f);
  printf("%-15s: %+5.2g\n", "%+5.2g", 8127.534f);
  printf("%-15s: %+5.5g\n", "%+5.5g", 8127.534f);
  printf("%-15s: %+5.10g\n", "%+5.10g", 8127.534f);
  printf("%-15s: %+5.30g\n", "%+5.30g", 8127.534f);
  printf("%-15s: %+10g\n", "%+10g", 8127.534f);
  printf("%-15s: %+10.g\n", "%+10.g", 8127.534f);
  printf("%-15s: %+10.0g\n", "%+10.0g", 8127.534f);
  printf("%-15s: %+10.1g\n", "%+10.1g", 8127.534f);
  printf("%-15s: %+10.2g\n", "%+10.2g", 8127.534f);
  printf("%-15s: %+10.5g\n", "%+10.5g", 8127.534f);
  printf("%-15s: %+10.10g\n", "%+10.10g", 8127.534f);
  printf("%-15s: %+10.30g\n", "%+10.30g", 8127.534f);
  printf("%-15s: %+30g\n", "%+30g", 8127.534f);
  printf("%-15s: %+30.g\n", "%+30.g", 8127.534f);
  printf("%-15s: %+30.0g\n", "%+30.0g", 8127.534f);
  printf("%-15s: %+30.1g\n", "%+30.1g", 8127.534f);
  printf("%-15s: %+30.2g\n", "%+30.2g", 8127.534f);
  printf("%-15s: %+30.5g\n", "%+30.5g", 8127.534f);
  printf("%-15s: %+30.10g\n", "%+30.10g", 8127.534f);
  printf("%-15s: %+30.30g\n", "%+30.30g", 8127.534f);
  printf("%-15s: %-g\n", "%-g", 8127.534f);
  printf("%-15s: %-.g\n", "%-.g", 8127.534f);
  printf("%-15s: %-.0g\n", "%-.0g", 8127.534f);
  printf("%-15s: %-.1g\n", "%-.1g", 8127.534f);
  printf("%-15s: %-.2g\n", "%-.2g", 8127.534f);
  printf("%-15s: %-.5g\n", "%-.5g", 8127.534f);
  printf("%-15s: %-.10g\n", "%-.10g", 8127.534f);
  printf("%-15s: %-.30g\n", "%-.30g", 8127.534f);
  printf("%-15s: %-1g\n", "%-1g", 8127.534f);
  printf("%-15s: %-1.g\n", "%-1.g", 8127.534f);
  printf("%-15s: %-1.0g\n", "%-1.0g", 8127.534f);
  printf("%-15s: %-1.1g\n", "%-1.1g", 8127.534f);
  printf("%-15s: %-1.2g\n", "%-1.2g", 8127.534f);
  printf("%-15s: %-1.5g\n", "%-1.5g", 8127.534f);
  printf("%-15s: %-1.10g\n", "%-1.10g", 8127.534f);
  printf("%-15s: %-1.30g\n", "%-1.30g", 8127.534f);
  printf("%-15s: %-2g\n", "%-2g", 8127.534f);
  printf("%-15s: %-2.g\n", "%-2.g", 8127.534f);
  printf("%-15s: %-2.0g\n", "%-2.0g", 8127.534f);
  printf("%-15s: %-2.1g\n", "%-2.1g", 8127.534f);
  printf("%-15s: %-2.2g\n", "%-2.2g", 8127.534f);
  printf("%-15s: %-2.5g\n", "%-2.5g", 8127.534f);
  printf("%-15s: %-2.10g\n", "%-2.10g", 8127.534f);
  printf("%-15s: %-2.30g\n", "%-2.30g", 8127.534f);
  printf("%-15s: %-5g\n", "%-5g", 8127.534f);
  printf("%-15s: %-5.g\n", "%-5.g", 8127.534f);
  printf("%-15s: %-5.0g\n", "%-5.0g", 8127.534f);
  printf("%-15s: %-5.1g\n", "%-5.1g", 8127.534f);
  printf("%-15s: %-5.2g\n", "%-5.2g", 8127.534f);
  printf("%-15s: %-5.5g\n", "%-5.5g", 8127.534f);
  printf("%-15s: %-5.10g\n", "%-5.10g", 8127.534f);
  printf("%-15s: %-5.30g\n", "%-5.30g", 8127.534f);
  printf("%-15s: %-10g\n", "%-10g", 8127.534f);
  printf("%-15s: %-10.g\n", "%-10.g", 8127.534f);
  printf("%-15s: %-10.0g\n", "%-10.0g", 8127.534f);
  printf("%-15s: %-10.1g\n", "%-10.1g", 8127.534f);
  printf("%-15s: %-10.2g\n", "%-10.2g", 8127.534f);
  printf("%-15s: %-10.5g\n", "%-10.5g", 8127.534f);
  printf("%-15s: %-10.10g\n", "%-10.10g", 8127.534f);
  printf("%-15s: %-10.30g\n", "%-10.30g", 8127.534f);
  printf("%-15s: %-30g\n", "%-30g", 8127.534f);
  printf("%-15s: %-30.g\n", "%-30.g", 8127.534f);
  printf("%-15s: %-30.0g\n", "%-30.0g", 8127.534f);
  printf("%-15s: %-30.1g\n", "%-30.1g", 8127.534f);
  printf("%-15s: %-30.2g\n", "%-30.2g", 8127.534f);
  printf("%-15s: %-30.5g\n", "%-30.5g", 8127.534f);
  printf("%-15s: %-30.10g\n", "%-30.10g", 8127.534f);
  printf("%-15s: %-30.30g\n", "%-30.30g", 8127.534f);
  printf("%-15s: %#g\n", "%#g", 8127.534f);
  printf("%-15s: %#.g\n", "%#.g", 8127.534f);
  printf("%-15s: %#.0g\n", "%#.0g", 8127.534f);
  printf("%-15s: %#.1g\n", "%#.1g", 8127.534f);
  printf("%-15s: %#.2g\n", "%#.2g", 8127.534f);
  printf("%-15s: %#.5g\n", "%#.5g", 8127.534f);
  printf("%-15s: %#.10g\n", "%#.10g", 8127.534f);
  printf("%-15s: %#.30g\n", "%#.30g", 8127.534f);
  printf("%-15s: %#0g\n", "%#0g", 8127.534f);
  printf("%-15s: %#0.g\n", "%#0.g", 8127.534f);
  printf("%-15s: %#0.0g\n", "%#0.0g", 8127.534f);
  printf("%-15s: %#0.1g\n", "%#0.1g", 8127.534f);
  printf("%-15s: %#0.2g\n", "%#0.2g", 8127.534f);
  printf("%-15s: %#0.5g\n", "%#0.5g", 8127.534f);
  printf("%-15s: %#0.10g\n", "%#0.10g", 8127.534f);
  printf("%-15s: %#0.30g\n", "%#0.30g", 8127.534f);
  printf("%-15s: %#1g\n", "%#1g", 8127.534f);
  printf("%-15s: %#1.g\n", "%#1.g", 8127.534f);
  printf("%-15s: %#1.0g\n", "%#1.0g", 8127.534f);
  printf("%-15s: %#1.1g\n", "%#1.1g", 8127.534f);
  printf("%-15s: %#1.2g\n", "%#1.2g", 8127.534f);
  printf("%-15s: %#1.5g\n", "%#1.5g", 8127.534f);
  printf("%-15s: %#1.10g\n", "%#1.10g", 8127.534f);
  printf("%-15s: %#1.30g\n", "%#1.30g", 8127.534f);
  printf("%-15s: %#2g\n", "%#2g", 8127.534f);
  printf("%-15s: %#2.g\n", "%#2.g", 8127.534f);
  printf("%-15s: %#2.0g\n", "%#2.0g", 8127.534f);
  printf("%-15s: %#2.1g\n", "%#2.1g", 8127.534f);
  printf("%-15s: %#2.2g\n", "%#2.2g", 8127.534f);
  printf("%-15s: %#2.5g\n", "%#2.5g", 8127.534f);
  printf("%-15s: %#2.10g\n", "%#2.10g", 8127.534f);
  printf("%-15s: %#2.30g\n", "%#2.30g", 8127.534f);
  printf("%-15s: %#5g\n", "%#5g", 8127.534f);
  printf("%-15s: %#5.g\n", "%#5.g", 8127.534f);
  printf("%-15s: %#5.0g\n", "%#5.0g", 8127.534f);
  printf("%-15s: %#5.1g\n", "%#5.1g", 8127.534f);
  printf("%-15s: %#5.2g\n", "%#5.2g", 8127.534f);
  printf("%-15s: %#5.5g\n", "%#5.5g", 8127.534f);
  printf("%-15s: %#5.10g\n", "%#5.10g", 8127.534f);
  printf("%-15s: %#5.30g\n", "%#5.30g", 8127.534f);
  printf("%-15s: %#10g\n", "%#10g", 8127.534f);
  printf("%-15s: %#10.g\n", "%#10.g", 8127.534f);
  printf("%-15s: %#10.0g\n", "%#10.0g", 8127.534f);
  printf("%-15s: %#10.1g\n", "%#10.1g", 8127.534f);
  printf("%-15s: %#10.2g\n", "%#10.2g", 8127.534f);
  printf("%-15s: %#10.5g\n", "%#10.5g", 8127.534f);
  printf("%-15s: %#10.10g\n", "%#10.10g", 8127.534f);
  printf("%-15s: %#10.30g\n", "%#10.30g", 8127.534f);
  printf("%-15s: %#30g\n", "%#30g", 8127.534f);
  printf("%-15s: %#30.g\n", "%#30.g", 8127.534f);
  printf("%-15s: %#30.0g\n", "%#30.0g", 8127.534f);
  printf("%-15s: %#30.1g\n", "%#30.1g", 8127.534f);
  printf("%-15s: %#30.2g\n", "%#30.2g", 8127.534f);
  printf("%-15s: %#30.5g\n", "%#30.5g", 8127.534f);
  printf("%-15s: %#30.10g\n", "%#30.10g", 8127.534f);
  printf("%-15s: %#30.30g\n", "%#30.30g", 8127.534f);
  printf("%-15s: %0g\n", "%0g", 8127.534f);
  printf("%-15s: %0.g\n", "%0.g", 8127.534f);
  printf("%-15s: %0.0g\n", "%0.0g", 8127.534f);
  printf("%-15s: %0.1g\n", "%0.1g", 8127.534f);
  printf("%-15s: %0.2g\n", "%0.2g", 8127.534f);
  printf("%-15s: %0.5g\n", "%0.5g", 8127.534f);
  printf("%-15s: %0.10g\n", "%0.10g", 8127.534f);
  printf("%-15s: %0.30g\n", "%0.30g", 8127.534f);
  printf("%-15s: %01g\n", "%01g", 8127.534f);
  printf("%-15s: %01.g\n", "%01.g", 8127.534f);
  printf("%-15s: %01.0g\n", "%01.0g", 8127.534f);
  printf("%-15s: %01.1g\n", "%01.1g", 8127.534f);
  printf("%-15s: %01.2g\n", "%01.2g", 8127.534f);
  printf("%-15s: %01.5g\n", "%01.5g", 8127.534f);
  printf("%-15s: %01.10g\n", "%01.10g", 8127.534f);
  printf("%-15s: %01.30g\n", "%01.30g", 8127.534f);
  printf("%-15s: %02g\n", "%02g", 8127.534f);
  printf("%-15s: %02.g\n", "%02.g", 8127.534f);
  printf("%-15s: %02.0g\n", "%02.0g", 8127.534f);
  printf("%-15s: %02.1g\n", "%02.1g", 8127.534f);
  printf("%-15s: %02.2g\n", "%02.2g", 8127.534f);
  printf("%-15s: %02.5g\n", "%02.5g", 8127.534f);
  printf("%-15s: %02.10g\n", "%02.10g", 8127.534f);
  printf("%-15s: %02.30g\n", "%02.30g", 8127.534f);
  printf("%-15s: %05g\n", "%05g", 8127.534f);
  printf("%-15s: %05.g\n", "%05.g", 8127.534f);
  printf("%-15s: %05.0g\n", "%05.0g", 8127.534f);
  printf("%-15s: %05.1g\n", "%05.1g", 8127.534f);
  printf("%-15s: %05.2g\n", "%05.2g", 8127.534f);
  printf("%-15s: %05.5g\n", "%05.5g", 8127.534f);
  printf("%-15s: %05.10g\n", "%05.10g", 8127.534f);
  printf("%-15s: %05.30g\n", "%05.30g", 8127.534f);
  printf("%-15s: %010g\n", "%010g", 8127.534f);
  printf("%-15s: %010.g\n", "%010.g", 8127.534f);
  printf("%-15s: %010.0g\n", "%010.0g", 8127.534f);
  printf("%-15s: %010.1g\n", "%010.1g", 8127.534f);
  printf("%-15s: %010.2g\n", "%010.2g", 8127.534f);
  printf("%-15s: %010.5g\n", "%010.5g", 8127.534f);
  printf("%-15s: %010.10g\n", "%010.10g", 8127.534f);
  printf("%-15s: %010.30g\n", "%010.30g", 8127.534f);
  printf("%-15s: %030g\n", "%030g", 8127.534f);
  printf("%-15s: %030.g\n", "%030.g", 8127.534f);
  printf("%-15s: %030.0g\n", "%030.0g", 8127.534f);
  printf("%-15s: %030.1g\n", "%030.1g", 8127.534f);
  printf("%-15s: %030.2g\n", "%030.2g", 8127.534f);
  printf("%-15s: %030.5g\n", "%030.5g", 8127.534f);
  printf("%-15s: %030.10g\n", "%030.10g", 8127.534f);
  printf("%-15s: %030.30g\n", "%030.30g", 8127.534f);
  printf("%-15s: %-+g\n", "%-+g", 8127.534f);
  printf("%-15s: %-+.g\n", "%-+.g", 8127.534f);
  printf("%-15s: %-+.0g\n", "%-+.0g", 8127.534f);
  printf("%-15s: %-+.1g\n", "%-+.1g", 8127.534f);
  printf("%-15s: %-+.2g\n", "%-+.2g", 8127.534f);
  printf("%-15s: %-+.5g\n", "%-+.5g", 8127.534f);
  printf("%-15s: %-+.10g\n", "%-+.10g", 8127.534f);
  printf("%-15s: %-+.30g\n", "%-+.30g", 8127.534f);
  printf("%-15s: %-+1g\n", "%-+1g", 8127.534f);
  printf("%-15s: %-+1.g\n", "%-+1.g", 8127.534f);
  printf("%-15s: %-+1.0g\n", "%-+1.0g", 8127.534f);
  printf("%-15s: %-+1.1g\n", "%-+1.1g", 8127.534f);
  printf("%-15s: %-+1.2g\n", "%-+1.2g", 8127.534f);
  printf("%-15s: %-+1.5g\n", "%-+1.5g", 8127.534f);
  printf("%-15s: %-+1.10g\n", "%-+1.10g", 8127.534f);
  printf("%-15s: %-+1.30g\n", "%-+1.30g", 8127.534f);
  printf("%-15s: %-+2g\n", "%-+2g", 8127.534f);
  printf("%-15s: %-+2.g\n", "%-+2.g", 8127.534f);
  printf("%-15s: %-+2.0g\n", "%-+2.0g", 8127.534f);
  printf("%-15s: %-+2.1g\n", "%-+2.1g", 8127.534f);
  printf("%-15s: %-+2.2g\n", "%-+2.2g", 8127.534f);
  printf("%-15s: %-+2.5g\n", "%-+2.5g", 8127.534f);
  printf("%-15s: %-+2.10g\n", "%-+2.10g", 8127.534f);
  printf("%-15s: %-+2.30g\n", "%-+2.30g", 8127.534f);
  printf("%-15s: %-+5g\n", "%-+5g", 8127.534f);
  printf("%-15s: %-+5.g\n", "%-+5.g", 8127.534f);
  printf("%-15s: %-+5.0g\n", "%-+5.0g", 8127.534f);
  printf("%-15s: %-+5.1g\n", "%-+5.1g", 8127.534f);
  printf("%-15s: %-+5.2g\n", "%-+5.2g", 8127.534f);
  printf("%-15s: %-+5.5g\n", "%-+5.5g", 8127.534f);
  printf("%-15s: %-+5.10g\n", "%-+5.10g", 8127.534f);
  printf("%-15s: %-+5.30g\n", "%-+5.30g", 8127.534f);
  printf("%-15s: %-+10g\n", "%-+10g", 8127.534f);
  printf("%-15s: %-+10.g\n", "%-+10.g", 8127.534f);
  printf("%-15s: %-+10.0g\n", "%-+10.0g", 8127.534f);
  printf("%-15s: %-+10.1g\n", "%-+10.1g", 8127.534f);
  printf("%-15s: %-+10.2g\n", "%-+10.2g", 8127.534f);
  printf("%-15s: %-+10.5g\n", "%-+10.5g", 8127.534f);
  printf("%-15s: %-+10.10g\n", "%-+10.10g", 8127.534f);
  printf("%-15s: %-+10.30g\n", "%-+10.30g", 8127.534f);
  printf("%-15s: %-+30g\n", "%-+30g", 8127.534f);
  printf("%-15s: %-+30.g\n", "%-+30.g", 8127.534f);
  printf("%-15s: %-+30.0g\n", "%-+30.0g", 8127.534f);
  printf("%-15s: %-+30.1g\n", "%-+30.1g", 8127.534f);
  printf("%-15s: %-+30.2g\n", "%-+30.2g", 8127.534f);
  printf("%-15s: %-+30.5g\n", "%-+30.5g", 8127.534f);
  printf("%-15s: %-+30.10g\n", "%-+30.10g", 8127.534f);
  printf("%-15s: %-+30.30g\n", "%-+30.30g", 8127.534f);
  printf("%-15s: %#+g\n", "%#+g", 8127.534f);
  printf("%-15s: %#+.g\n", "%#+.g", 8127.534f);
  printf("%-15s: %#+.0g\n", "%#+.0g", 8127.534f);
  printf("%-15s: %#+.1g\n", "%#+.1g", 8127.534f);
  printf("%-15s: %#+.2g\n", "%#+.2g", 8127.534f);
  printf("%-15s: %#+.5g\n", "%#+.5g", 8127.534f);
  printf("%-15s: %#+.10g\n", "%#+.10g", 8127.534f);
  printf("%-15s: %#+.30g\n", "%#+.30g", 8127.534f);
  printf("%-15s: %#+0g\n", "%#+0g", 8127.534f);
  printf("%-15s: %#+0.g\n", "%#+0.g", 8127.534f);
  printf("%-15s: %#+0.0g\n", "%#+0.0g", 8127.534f);
  printf("%-15s: %#+0.1g\n", "%#+0.1g", 8127.534f);
  printf("%-15s: %#+0.2g\n", "%#+0.2g", 8127.534f);
  printf("%-15s: %#+0.5g\n", "%#+0.5g", 8127.534f);
  printf("%-15s: %#+0.10g\n", "%#+0.10g", 8127.534f);
  printf("%-15s: %#+0.30g\n", "%#+0.30g", 8127.534f);
  printf("%-15s: %#+1g\n", "%#+1g", 8127.534f);
  printf("%-15s: %#+1.g\n", "%#+1.g", 8127.534f);
  printf("%-15s: %#+1.0g\n", "%#+1.0g", 8127.534f);
  printf("%-15s: %#+1.1g\n", "%#+1.1g", 8127.534f);
  printf("%-15s: %#+1.2g\n", "%#+1.2g", 8127.534f);
  printf("%-15s: %#+1.5g\n", "%#+1.5g", 8127.534f);
  printf("%-15s: %#+1.10g\n", "%#+1.10g", 8127.534f);
  printf("%-15s: %#+1.30g\n", "%#+1.30g", 8127.534f);
  printf("%-15s: %#+2g\n", "%#+2g", 8127.534f);
  printf("%-15s: %#+2.g\n", "%#+2.g", 8127.534f);
  printf("%-15s: %#+2.0g\n", "%#+2.0g", 8127.534f);
  printf("%-15s: %#+2.1g\n", "%#+2.1g", 8127.534f);
  printf("%-15s: %#+2.2g\n", "%#+2.2g", 8127.534f);
  printf("%-15s: %#+2.5g\n", "%#+2.5g", 8127.534f);
  printf("%-15s: %#+2.10g\n", "%#+2.10g", 8127.534f);
  printf("%-15s: %#+2.30g\n", "%#+2.30g", 8127.534f);
  printf("%-15s: %#+5g\n", "%#+5g", 8127.534f);
  printf("%-15s: %#+5.g\n", "%#+5.g", 8127.534f);
  printf("%-15s: %#+5.0g\n", "%#+5.0g", 8127.534f);
  printf("%-15s: %#+5.1g\n", "%#+5.1g", 8127.534f);
  printf("%-15s: %#+5.2g\n", "%#+5.2g", 8127.534f);
  printf("%-15s: %#+5.5g\n", "%#+5.5g", 8127.534f);
  printf("%-15s: %#+5.10g\n", "%#+5.10g", 8127.534f);
  printf("%-15s: %#+5.30g\n", "%#+5.30g", 8127.534f);
  printf("%-15s: %#+10g\n", "%#+10g", 8127.534f);
  printf("%-15s: %#+10.g\n", "%#+10.g", 8127.534f);
  printf("%-15s: %#+10.0g\n", "%#+10.0g", 8127.534f);
  printf("%-15s: %#+10.1g\n", "%#+10.1g", 8127.534f);
  printf("%-15s: %#+10.2g\n", "%#+10.2g", 8127.534f);
  printf("%-15s: %#+10.5g\n", "%#+10.5g", 8127.534f);
  printf("%-15s: %#+10.10g\n", "%#+10.10g", 8127.534f);
  printf("%-15s: %#+10.30g\n", "%#+10.30g", 8127.534f);
  printf("%-15s: %#+30g\n", "%#+30g", 8127.534f);
  printf("%-15s: %#+30.g\n", "%#+30.g", 8127.534f);
  printf("%-15s: %#+30.0g\n", "%#+30.0g", 8127.534f);
  printf("%-15s: %#+30.1g\n", "%#+30.1g", 8127.534f);
  printf("%-15s: %#+30.2g\n", "%#+30.2g", 8127.534f);
  printf("%-15s: %#+30.5g\n", "%#+30.5g", 8127.534f);
  printf("%-15s: %#+30.10g\n", "%#+30.10g", 8127.534f);
  printf("%-15s: %#+30.30g\n", "%#+30.30g", 8127.534f);
  printf("%-15s: %+0g\n", "%+0g", 8127.534f);
  printf("%-15s: %+0.g\n", "%+0.g", 8127.534f);
  printf("%-15s: %+0.0g\n", "%+0.0g", 8127.534f);
  printf("%-15s: %+0.1g\n", "%+0.1g", 8127.534f);
  printf("%-15s: %+0.2g\n", "%+0.2g", 8127.534f);
  printf("%-15s: %+0.5g\n", "%+0.5g", 8127.534f);
  printf("%-15s: %+0.10g\n", "%+0.10g", 8127.534f);
  printf("%-15s: %+0.30g\n", "%+0.30g", 8127.534f);
  printf("%-15s: %+01g\n", "%+01g", 8127.534f);
  printf("%-15s: %+01.g\n", "%+01.g", 8127.534f);
  printf("%-15s: %+01.0g\n", "%+01.0g", 8127.534f);
  printf("%-15s: %+01.1g\n", "%+01.1g", 8127.534f);
  printf("%-15s: %+01.2g\n", "%+01.2g", 8127.534f);
  printf("%-15s: %+01.5g\n", "%+01.5g", 8127.534f);
  printf("%-15s: %+01.10g\n", "%+01.10g", 8127.534f);
  printf("%-15s: %+01.30g\n", "%+01.30g", 8127.534f);
  printf("%-15s: %+02g\n", "%+02g", 8127.534f);
  printf("%-15s: %+02.g\n", "%+02.g", 8127.534f);
  printf("%-15s: %+02.0g\n", "%+02.0g", 8127.534f);
  printf("%-15s: %+02.1g\n", "%+02.1g", 8127.534f);
  printf("%-15s: %+02.2g\n", "%+02.2g", 8127.534f);
  printf("%-15s: %+02.5g\n", "%+02.5g", 8127.534f);
  printf("%-15s: %+02.10g\n", "%+02.10g", 8127.534f);
  printf("%-15s: %+02.30g\n", "%+02.30g", 8127.534f);
  printf("%-15s: %+05g\n", "%+05g", 8127.534f);
  printf("%-15s: %+05.g\n", "%+05.g", 8127.534f);
  printf("%-15s: %+05.0g\n", "%+05.0g", 8127.534f);
  printf("%-15s: %+05.1g\n", "%+05.1g", 8127.534f);
  printf("%-15s: %+05.2g\n", "%+05.2g", 8127.534f);
  printf("%-15s: %+05.5g\n", "%+05.5g", 8127.534f);
  printf("%-15s: %+05.10g\n", "%+05.10g", 8127.534f);
  printf("%-15s: %+05.30g\n", "%+05.30g", 8127.534f);
  printf("%-15s: %+010g\n", "%+010g", 8127.534f);
  printf("%-15s: %+010.g\n", "%+010.g", 8127.534f);
  printf("%-15s: %+010.0g\n", "%+010.0g", 8127.534f);
  printf("%-15s: %+010.1g\n", "%+010.1g", 8127.534f);
  printf("%-15s: %+010.2g\n", "%+010.2g", 8127.534f);
  printf("%-15s: %+010.5g\n", "%+010.5g", 8127.534f);
  printf("%-15s: %+010.10g\n", "%+010.10g", 8127.534f);
  printf("%-15s: %+010.30g\n", "%+010.30g", 8127.534f);
  printf("%-15s: %+030g\n", "%+030g", 8127.534f);
  printf("%-15s: %+030.g\n", "%+030.g", 8127.534f);
  printf("%-15s: %+030.0g\n", "%+030.0g", 8127.534f);
  printf("%-15s: %+030.1g\n", "%+030.1g", 8127.534f);
  printf("%-15s: %+030.2g\n", "%+030.2g", 8127.534f);
  printf("%-15s: %+030.5g\n", "%+030.5g", 8127.534f);
  printf("%-15s: %+030.10g\n", "%+030.10g", 8127.534f);
  printf("%-15s: %+030.30g\n", "%+030.30g", 8127.534f);
  printf("%-15s: %+-g\n", "%+-g", 8127.534f);
  printf("%-15s: %+-.g\n", "%+-.g", 8127.534f);
  printf("%-15s: %+-.0g\n", "%+-.0g", 8127.534f);
  printf("%-15s: %+-.1g\n", "%+-.1g", 8127.534f);
  printf("%-15s: %+-.2g\n", "%+-.2g", 8127.534f);
  printf("%-15s: %+-.5g\n", "%+-.5g", 8127.534f);
  printf("%-15s: %+-.10g\n", "%+-.10g", 8127.534f);
  printf("%-15s: %+-.30g\n", "%+-.30g", 8127.534f);
  printf("%-15s: %+-1g\n", "%+-1g", 8127.534f);
  printf("%-15s: %+-1.g\n", "%+-1.g", 8127.534f);
  printf("%-15s: %+-1.0g\n", "%+-1.0g", 8127.534f);
  printf("%-15s: %+-1.1g\n", "%+-1.1g", 8127.534f);
  printf("%-15s: %+-1.2g\n", "%+-1.2g", 8127.534f);
  printf("%-15s: %+-1.5g\n", "%+-1.5g", 8127.534f);
  printf("%-15s: %+-1.10g\n", "%+-1.10g", 8127.534f);
  printf("%-15s: %+-1.30g\n", "%+-1.30g", 8127.534f);
  printf("%-15s: %+-2g\n", "%+-2g", 8127.534f);
  printf("%-15s: %+-2.g\n", "%+-2.g", 8127.534f);
  printf("%-15s: %+-2.0g\n", "%+-2.0g", 8127.534f);
  printf("%-15s: %+-2.1g\n", "%+-2.1g", 8127.534f);
  printf("%-15s: %+-2.2g\n", "%+-2.2g", 8127.534f);
  printf("%-15s: %+-2.5g\n", "%+-2.5g", 8127.534f);
  printf("%-15s: %+-2.10g\n", "%+-2.10g", 8127.534f);
  printf("%-15s: %+-2.30g\n", "%+-2.30g", 8127.534f);
  printf("%-15s: %+-5g\n", "%+-5g", 8127.534f);
  printf("%-15s: %+-5.g\n", "%+-5.g", 8127.534f);
  printf("%-15s: %+-5.0g\n", "%+-5.0g", 8127.534f);
  printf("%-15s: %+-5.1g\n", "%+-5.1g", 8127.534f);
  printf("%-15s: %+-5.2g\n", "%+-5.2g", 8127.534f);
  printf("%-15s: %+-5.5g\n", "%+-5.5g", 8127.534f);
  printf("%-15s: %+-5.10g\n", "%+-5.10g", 8127.534f);
  printf("%-15s: %+-5.30g\n", "%+-5.30g", 8127.534f);
  printf("%-15s: %+-10g\n", "%+-10g", 8127.534f);
  printf("%-15s: %+-10.g\n", "%+-10.g", 8127.534f);
  printf("%-15s: %+-10.0g\n", "%+-10.0g", 8127.534f);
  printf("%-15s: %+-10.1g\n", "%+-10.1g", 8127.534f);
  printf("%-15s: %+-10.2g\n", "%+-10.2g", 8127.534f);
  printf("%-15s: %+-10.5g\n", "%+-10.5g", 8127.534f);
  printf("%-15s: %+-10.10g\n", "%+-10.10g", 8127.534f);
  printf("%-15s: %+-10.30g\n", "%+-10.30g", 8127.534f);
  printf("%-15s: %+-30g\n", "%+-30g", 8127.534f);
  printf("%-15s: %+-30.g\n", "%+-30.g", 8127.534f);
  printf("%-15s: %+-30.0g\n", "%+-30.0g", 8127.534f);
  printf("%-15s: %+-30.1g\n", "%+-30.1g", 8127.534f);
  printf("%-15s: %+-30.2g\n", "%+-30.2g", 8127.534f);
  printf("%-15s: %+-30.5g\n", "%+-30.5g", 8127.534f);
  printf("%-15s: %+-30.10g\n", "%+-30.10g", 8127.534f);
  printf("%-15s: %+-30.30g\n", "%+-30.30g", 8127.534f);
  printf("%-15s: %#-g\n", "%#-g", 8127.534f);
  printf("%-15s: %#-.g\n", "%#-.g", 8127.534f);
  printf("%-15s: %#-.0g\n", "%#-.0g", 8127.534f);
  printf("%-15s: %#-.1g\n", "%#-.1g", 8127.534f);
  printf("%-15s: %#-.2g\n", "%#-.2g", 8127.534f);
  printf("%-15s: %#-.5g\n", "%#-.5g", 8127.534f);
  printf("%-15s: %#-.10g\n", "%#-.10g", 8127.534f);
  printf("%-15s: %#-.30g\n", "%#-.30g", 8127.534f);
  printf("%-15s: %#-1g\n", "%#-1g", 8127.534f);
  printf("%-15s: %#-1.g\n", "%#-1.g", 8127.534f);
  printf("%-15s: %#-1.0g\n", "%#-1.0g", 8127.534f);
  printf("%-15s: %#-1.1g\n", "%#-1.1g", 8127.534f);
  printf("%-15s: %#-1.2g\n", "%#-1.2g", 8127.534f);
  printf("%-15s: %#-1.5g\n", "%#-1.5g", 8127.534f);
  printf("%-15s: %#-1.10g\n", "%#-1.10g", 8127.534f);
  printf("%-15s: %#-1.30g\n", "%#-1.30g", 8127.534f);
  printf("%-15s: %#-2g\n", "%#-2g", 8127.534f);
  printf("%-15s: %#-2.g\n", "%#-2.g", 8127.534f);
  printf("%-15s: %#-2.0g\n", "%#-2.0g", 8127.534f);
  printf("%-15s: %#-2.1g\n", "%#-2.1g", 8127.534f);
  printf("%-15s: %#-2.2g\n", "%#-2.2g", 8127.534f);
  printf("%-15s: %#-2.5g\n", "%#-2.5g", 8127.534f);
  printf("%-15s: %#-2.10g\n", "%#-2.10g", 8127.534f);
  printf("%-15s: %#-2.30g\n", "%#-2.30g", 8127.534f);
  printf("%-15s: %#-5g\n", "%#-5g", 8127.534f);
  printf("%-15s: %#-5.g\n", "%#-5.g", 8127.534f);
  printf("%-15s: %#-5.0g\n", "%#-5.0g", 8127.534f);
  printf("%-15s: %#-5.1g\n", "%#-5.1g", 8127.534f);
  printf("%-15s: %#-5.2g\n", "%#-5.2g", 8127.534f);
  printf("%-15s: %#-5.5g\n", "%#-5.5g", 8127.534f);
  printf("%-15s: %#-5.10g\n", "%#-5.10g", 8127.534f);
  printf("%-15s: %#-5.30g\n", "%#-5.30g", 8127.534f);
  printf("%-15s: %#-10g\n", "%#-10g", 8127.534f);
  printf("%-15s: %#-10.g\n", "%#-10.g", 8127.534f);
  printf("%-15s: %#-10.0g\n", "%#-10.0g", 8127.534f);
  printf("%-15s: %#-10.1g\n", "%#-10.1g", 8127.534f);
  printf("%-15s: %#-10.2g\n", "%#-10.2g", 8127.534f);
  printf("%-15s: %#-10.5g\n", "%#-10.5g", 8127.534f);
  printf("%-15s: %#-10.10g\n", "%#-10.10g", 8127.534f);
  printf("%-15s: %#-10.30g\n", "%#-10.30g", 8127.534f);
  printf("%-15s: %#-30g\n", "%#-30g", 8127.534f);
  printf("%-15s: %#-30.g\n", "%#-30.g", 8127.534f);
  printf("%-15s: %#-30.0g\n", "%#-30.0g", 8127.534f);
  printf("%-15s: %#-30.1g\n", "%#-30.1g", 8127.534f);
  printf("%-15s: %#-30.2g\n", "%#-30.2g", 8127.534f);
  printf("%-15s: %#-30.5g\n", "%#-30.5g", 8127.534f);
  printf("%-15s: %#-30.10g\n", "%#-30.10g", 8127.534f);
  printf("%-15s: %#-30.30g\n", "%#-30.30g", 8127.534f);
  printf("%-15s: %+#g\n", "%+#g", 8127.534f);
  printf("%-15s: %+#.g\n", "%+#.g", 8127.534f);
  printf("%-15s: %+#.0g\n", "%+#.0g", 8127.534f);
  printf("%-15s: %+#.1g\n", "%+#.1g", 8127.534f);
  printf("%-15s: %+#.2g\n", "%+#.2g", 8127.534f);
  printf("%-15s: %+#.5g\n", "%+#.5g", 8127.534f);
  printf("%-15s: %+#.10g\n", "%+#.10g", 8127.534f);
  printf("%-15s: %+#.30g\n", "%+#.30g", 8127.534f);
  printf("%-15s: %+#0g\n", "%+#0g", 8127.534f);
  printf("%-15s: %+#0.g\n", "%+#0.g", 8127.534f);
  printf("%-15s: %+#0.0g\n", "%+#0.0g", 8127.534f);
  printf("%-15s: %+#0.1g\n", "%+#0.1g", 8127.534f);
  printf("%-15s: %+#0.2g\n", "%+#0.2g", 8127.534f);
  printf("%-15s: %+#0.5g\n", "%+#0.5g", 8127.534f);
  printf("%-15s: %+#0.10g\n", "%+#0.10g", 8127.534f);
  printf("%-15s: %+#0.30g\n", "%+#0.30g", 8127.534f);
  printf("%-15s: %+#1g\n", "%+#1g", 8127.534f);
  printf("%-15s: %+#1.g\n", "%+#1.g", 8127.534f);
  printf("%-15s: %+#1.0g\n", "%+#1.0g", 8127.534f);
  printf("%-15s: %+#1.1g\n", "%+#1.1g", 8127.534f);
  printf("%-15s: %+#1.2g\n", "%+#1.2g", 8127.534f);
  printf("%-15s: %+#1.5g\n", "%+#1.5g", 8127.534f);
  printf("%-15s: %+#1.10g\n", "%+#1.10g", 8127.534f);
  printf("%-15s: %+#1.30g\n", "%+#1.30g", 8127.534f);
  printf("%-15s: %+#2g\n", "%+#2g", 8127.534f);
  printf("%-15s: %+#2.g\n", "%+#2.g", 8127.534f);
  printf("%-15s: %+#2.0g\n", "%+#2.0g", 8127.534f);
  printf("%-15s: %+#2.1g\n", "%+#2.1g", 8127.534f);
  printf("%-15s: %+#2.2g\n", "%+#2.2g", 8127.534f);
  printf("%-15s: %+#2.5g\n", "%+#2.5g", 8127.534f);
  printf("%-15s: %+#2.10g\n", "%+#2.10g", 8127.534f);
  printf("%-15s: %+#2.30g\n", "%+#2.30g", 8127.534f);
  printf("%-15s: %+#5g\n", "%+#5g", 8127.534f);
  printf("%-15s: %+#5.g\n", "%+#5.g", 8127.534f);
  printf("%-15s: %+#5.0g\n", "%+#5.0g", 8127.534f);
  printf("%-15s: %+#5.1g\n", "%+#5.1g", 8127.534f);
  printf("%-15s: %+#5.2g\n", "%+#5.2g", 8127.534f);
  printf("%-15s: %+#5.5g\n", "%+#5.5g", 8127.534f);
  printf("%-15s: %+#5.10g\n", "%+#5.10g", 8127.534f);
  printf("%-15s: %+#5.30g\n", "%+#5.30g", 8127.534f);
  printf("%-15s: %+#10g\n", "%+#10g", 8127.534f);
  printf("%-15s: %+#10.g\n", "%+#10.g", 8127.534f);
  printf("%-15s: %+#10.0g\n", "%+#10.0g", 8127.534f);
  printf("%-15s: %+#10.1g\n", "%+#10.1g", 8127.534f);
  printf("%-15s: %+#10.2g\n", "%+#10.2g", 8127.534f);
  printf("%-15s: %+#10.5g\n", "%+#10.5g", 8127.534f);
  printf("%-15s: %+#10.10g\n", "%+#10.10g", 8127.534f);
  printf("%-15s: %+#10.30g\n", "%+#10.30g", 8127.534f);
  printf("%-15s: %+#30g\n", "%+#30g", 8127.534f);
  printf("%-15s: %+#30.g\n", "%+#30.g", 8127.534f);
  printf("%-15s: %+#30.0g\n", "%+#30.0g", 8127.534f);
  printf("%-15s: %+#30.1g\n", "%+#30.1g", 8127.534f);
  printf("%-15s: %+#30.2g\n", "%+#30.2g", 8127.534f);
  printf("%-15s: %+#30.5g\n", "%+#30.5g", 8127.534f);
  printf("%-15s: %+#30.10g\n", "%+#30.10g", 8127.534f);
  printf("%-15s: %+#30.30g\n", "%+#30.30g", 8127.534f);
  printf("%-15s: %-#g\n", "%-#g", 8127.534f);
  printf("%-15s: %-#.g\n", "%-#.g", 8127.534f);
  printf("%-15s: %-#.0g\n", "%-#.0g", 8127.534f);
  printf("%-15s: %-#.1g\n", "%-#.1g", 8127.534f);
  printf("%-15s: %-#.2g\n", "%-#.2g", 8127.534f);
  printf("%-15s: %-#.5g\n", "%-#.5g", 8127.534f);
  printf("%-15s: %-#.10g\n", "%-#.10g", 8127.534f);
  printf("%-15s: %-#.30g\n", "%-#.30g", 8127.534f);
  printf("%-15s: %-#1g\n", "%-#1g", 8127.534f);
  printf("%-15s: %-#1.g\n", "%-#1.g", 8127.534f);
  printf("%-15s: %-#1.0g\n", "%-#1.0g", 8127.534f);
  printf("%-15s: %-#1.1g\n", "%-#1.1g", 8127.534f);
  printf("%-15s: %-#1.2g\n", "%-#1.2g", 8127.534f);
  printf("%-15s: %-#1.5g\n", "%-#1.5g", 8127.534f);
  printf("%-15s: %-#1.10g\n", "%-#1.10g", 8127.534f);
  printf("%-15s: %-#1.30g\n", "%-#1.30g", 8127.534f);
  printf("%-15s: %-#2g\n", "%-#2g", 8127.534f);
  printf("%-15s: %-#2.g\n", "%-#2.g", 8127.534f);
  printf("%-15s: %-#2.0g\n", "%-#2.0g", 8127.534f);
  printf("%-15s: %-#2.1g\n", "%-#2.1g", 8127.534f);
  printf("%-15s: %-#2.2g\n", "%-#2.2g", 8127.534f);
  printf("%-15s: %-#2.5g\n", "%-#2.5g", 8127.534f);
  printf("%-15s: %-#2.10g\n", "%-#2.10g", 8127.534f);
  printf("%-15s: %-#2.30g\n", "%-#2.30g", 8127.534f);
  printf("%-15s: %-#5g\n", "%-#5g", 8127.534f);
  printf("%-15s: %-#5.g\n", "%-#5.g", 8127.534f);
  printf("%-15s: %-#5.0g\n", "%-#5.0g", 8127.534f);
  printf("%-15s: %-#5.1g\n", "%-#5.1g", 8127.534f);
  printf("%-15s: %-#5.2g\n", "%-#5.2g", 8127.534f);
  printf("%-15s: %-#5.5g\n", "%-#5.5g", 8127.534f);
  printf("%-15s: %-#5.10g\n", "%-#5.10g", 8127.534f);
  printf("%-15s: %-#5.30g\n", "%-#5.30g", 8127.534f);
  printf("%-15s: %-#10g\n", "%-#10g", 8127.534f);
  printf("%-15s: %-#10.g\n", "%-#10.g", 8127.534f);
  printf("%-15s: %-#10.0g\n", "%-#10.0g", 8127.534f);
  printf("%-15s: %-#10.1g\n", "%-#10.1g", 8127.534f);
  printf("%-15s: %-#10.2g\n", "%-#10.2g", 8127.534f);
  printf("%-15s: %-#10.5g\n", "%-#10.5g", 8127.534f);
  printf("%-15s: %-#10.10g\n", "%-#10.10g", 8127.534f);
  printf("%-15s: %-#10.30g\n", "%-#10.30g", 8127.534f);
  printf("%-15s: %-#30g\n", "%-#30g", 8127.534f);
  printf("%-15s: %-#30.g\n", "%-#30.g", 8127.534f);
  printf("%-15s: %-#30.0g\n", "%-#30.0g", 8127.534f);
  printf("%-15s: %-#30.1g\n", "%-#30.1g", 8127.534f);
  printf("%-15s: %-#30.2g\n", "%-#30.2g", 8127.534f);
  printf("%-15s: %-#30.5g\n", "%-#30.5g", 8127.534f);
  printf("%-15s: %-#30.10g\n", "%-#30.10g", 8127.534f);
  printf("%-15s: %-#30.30g\n", "%-#30.30g", 8127.534f);
  printf("%-15s: %0#g\n", "%0#g", 8127.534f);
  printf("%-15s: %0#.g\n", "%0#.g", 8127.534f);
  printf("%-15s: %0#.0g\n", "%0#.0g", 8127.534f);
  printf("%-15s: %0#.1g\n", "%0#.1g", 8127.534f);
  printf("%-15s: %0#.2g\n", "%0#.2g", 8127.534f);
  printf("%-15s: %0#.5g\n", "%0#.5g", 8127.534f);
  printf("%-15s: %0#.10g\n", "%0#.10g", 8127.534f);
  printf("%-15s: %0#.30g\n", "%0#.30g", 8127.534f);
  printf("%-15s: %0#1g\n", "%0#1g", 8127.534f);
  printf("%-15s: %0#1.g\n", "%0#1.g", 8127.534f);
  printf("%-15s: %0#1.0g\n", "%0#1.0g", 8127.534f);
  printf("%-15s: %0#1.1g\n", "%0#1.1g", 8127.534f);
  printf("%-15s: %0#1.2g\n", "%0#1.2g", 8127.534f);
  printf("%-15s: %0#1.5g\n", "%0#1.5g", 8127.534f);
  printf("%-15s: %0#1.10g\n", "%0#1.10g", 8127.534f);
  printf("%-15s: %0#1.30g\n", "%0#1.30g", 8127.534f);
  printf("%-15s: %0#2g\n", "%0#2g", 8127.534f);
  printf("%-15s: %0#2.g\n", "%0#2.g", 8127.534f);
  printf("%-15s: %0#2.0g\n", "%0#2.0g", 8127.534f);
  printf("%-15s: %0#2.1g\n", "%0#2.1g", 8127.534f);
  printf("%-15s: %0#2.2g\n", "%0#2.2g", 8127.534f);
  printf("%-15s: %0#2.5g\n", "%0#2.5g", 8127.534f);
  printf("%-15s: %0#2.10g\n", "%0#2.10g", 8127.534f);
  printf("%-15s: %0#2.30g\n", "%0#2.30g", 8127.534f);
  printf("%-15s: %0#5g\n", "%0#5g", 8127.534f);
  printf("%-15s: %0#5.g\n", "%0#5.g", 8127.534f);
  printf("%-15s: %0#5.0g\n", "%0#5.0g", 8127.534f);
  printf("%-15s: %0#5.1g\n", "%0#5.1g", 8127.534f);
  printf("%-15s: %0#5.2g\n", "%0#5.2g", 8127.534f);
  printf("%-15s: %0#5.5g\n", "%0#5.5g", 8127.534f);
  printf("%-15s: %0#5.10g\n", "%0#5.10g", 8127.534f);
  printf("%-15s: %0#5.30g\n", "%0#5.30g", 8127.534f);
  printf("%-15s: %0#10g\n", "%0#10g", 8127.534f);
  printf("%-15s: %0#10.g\n", "%0#10.g", 8127.534f);
  printf("%-15s: %0#10.0g\n", "%0#10.0g", 8127.534f);
  printf("%-15s: %0#10.1g\n", "%0#10.1g", 8127.534f);
  printf("%-15s: %0#10.2g\n", "%0#10.2g", 8127.534f);
  printf("%-15s: %0#10.5g\n", "%0#10.5g", 8127.534f);
  printf("%-15s: %0#10.10g\n", "%0#10.10g", 8127.534f);
  printf("%-15s: %0#10.30g\n", "%0#10.30g", 8127.534f);
  printf("%-15s: %0#30g\n", "%0#30g", 8127.534f);
  printf("%-15s: %0#30.g\n", "%0#30.g", 8127.534f);
  printf("%-15s: %0#30.0g\n", "%0#30.0g", 8127.534f);
  printf("%-15s: %0#30.1g\n", "%0#30.1g", 8127.534f);
  printf("%-15s: %0#30.2g\n", "%0#30.2g", 8127.534f);
  printf("%-15s: %0#30.5g\n", "%0#30.5g", 8127.534f);
  printf("%-15s: %0#30.10g\n", "%0#30.10g", 8127.534f);
  printf("%-15s: %0#30.30g\n", "%0#30.30g", 8127.534f);
  printf("%-15s: %+0g\n", "%+0g", 8127.534f);
  printf("%-15s: %+0.g\n", "%+0.g", 8127.534f);
  printf("%-15s: %+0.0g\n", "%+0.0g", 8127.534f);
  printf("%-15s: %+0.1g\n", "%+0.1g", 8127.534f);
  printf("%-15s: %+0.2g\n", "%+0.2g", 8127.534f);
  printf("%-15s: %+0.5g\n", "%+0.5g", 8127.534f);
  printf("%-15s: %+0.10g\n", "%+0.10g", 8127.534f);
  printf("%-15s: %+0.30g\n", "%+0.30g", 8127.534f);
  printf("%-15s: %+01g\n", "%+01g", 8127.534f);
  printf("%-15s: %+01.g\n", "%+01.g", 8127.534f);
  printf("%-15s: %+01.0g\n", "%+01.0g", 8127.534f);
  printf("%-15s: %+01.1g\n", "%+01.1g", 8127.534f);
  printf("%-15s: %+01.2g\n", "%+01.2g", 8127.534f);
  printf("%-15s: %+01.5g\n", "%+01.5g", 8127.534f);
  printf("%-15s: %+01.10g\n", "%+01.10g", 8127.534f);
  printf("%-15s: %+01.30g\n", "%+01.30g", 8127.534f);
  printf("%-15s: %+02g\n", "%+02g", 8127.534f);
  printf("%-15s: %+02.g\n", "%+02.g", 8127.534f);
  printf("%-15s: %+02.0g\n", "%+02.0g", 8127.534f);
  printf("%-15s: %+02.1g\n", "%+02.1g", 8127.534f);
  printf("%-15s: %+02.2g\n", "%+02.2g", 8127.534f);
  printf("%-15s: %+02.5g\n", "%+02.5g", 8127.534f);
  printf("%-15s: %+02.10g\n", "%+02.10g", 8127.534f);
  printf("%-15s: %+02.30g\n", "%+02.30g", 8127.534f);
  printf("%-15s: %+05g\n", "%+05g", 8127.534f);
  printf("%-15s: %+05.g\n", "%+05.g", 8127.534f);
  printf("%-15s: %+05.0g\n", "%+05.0g", 8127.534f);
  printf("%-15s: %+05.1g\n", "%+05.1g", 8127.534f);
  printf("%-15s: %+05.2g\n", "%+05.2g", 8127.534f);
  printf("%-15s: %+05.5g\n", "%+05.5g", 8127.534f);
  printf("%-15s: %+05.10g\n", "%+05.10g", 8127.534f);
  printf("%-15s: %+05.30g\n", "%+05.30g", 8127.534f);
  printf("%-15s: %+010g\n", "%+010g", 8127.534f);
  printf("%-15s: %+010.g\n", "%+010.g", 8127.534f);
  printf("%-15s: %+010.0g\n", "%+010.0g", 8127.534f);
  printf("%-15s: %+010.1g\n", "%+010.1g", 8127.534f);
  printf("%-15s: %+010.2g\n", "%+010.2g", 8127.534f);
  printf("%-15s: %+010.5g\n", "%+010.5g", 8127.534f);
  printf("%-15s: %+010.10g\n", "%+010.10g", 8127.534f);
  printf("%-15s: %+010.30g\n", "%+010.30g", 8127.534f);
  printf("%-15s: %+030g\n", "%+030g", 8127.534f);
  printf("%-15s: %+030.g\n", "%+030.g", 8127.534f);
  printf("%-15s: %+030.0g\n", "%+030.0g", 8127.534f);
  printf("%-15s: %+030.1g\n", "%+030.1g", 8127.534f);
  printf("%-15s: %+030.2g\n", "%+030.2g", 8127.534f);
  printf("%-15s: %+030.5g\n", "%+030.5g", 8127.534f);
  printf("%-15s: %+030.10g\n", "%+030.10g", 8127.534f);
  printf("%-15s: %+030.30g\n", "%+030.30g", 8127.534f);
  printf("%-15s: %#0g\n", "%#0g", 8127.534f);
  printf("%-15s: %#0.g\n", "%#0.g", 8127.534f);
  printf("%-15s: %#0.0g\n", "%#0.0g", 8127.534f);
  printf("%-15s: %#0.1g\n", "%#0.1g", 8127.534f);
  printf("%-15s: %#0.2g\n", "%#0.2g", 8127.534f);
  printf("%-15s: %#0.5g\n", "%#0.5g", 8127.534f);
  printf("%-15s: %#0.10g\n", "%#0.10g", 8127.534f);
  printf("%-15s: %#0.30g\n", "%#0.30g", 8127.534f);
  printf("%-15s: %#01g\n", "%#01g", 8127.534f);
  printf("%-15s: %#01.g\n", "%#01.g", 8127.534f);
  printf("%-15s: %#01.0g\n", "%#01.0g", 8127.534f);
  printf("%-15s: %#01.1g\n", "%#01.1g", 8127.534f);
  printf("%-15s: %#01.2g\n", "%#01.2g", 8127.534f);
  printf("%-15s: %#01.5g\n", "%#01.5g", 8127.534f);
  printf("%-15s: %#01.10g\n", "%#01.10g", 8127.534f);
  printf("%-15s: %#01.30g\n", "%#01.30g", 8127.534f);
  printf("%-15s: %#02g\n", "%#02g", 8127.534f);
  printf("%-15s: %#02.g\n", "%#02.g", 8127.534f);
  printf("%-15s: %#02.0g\n", "%#02.0g", 8127.534f);
  printf("%-15s: %#02.1g\n", "%#02.1g", 8127.534f);
  printf("%-15s: %#02.2g\n", "%#02.2g", 8127.534f);
  printf("%-15s: %#02.5g\n", "%#02.5g", 8127.534f);
  printf("%-15s: %#02.10g\n", "%#02.10g", 8127.534f);
  printf("%-15s: %#02.30g\n", "%#02.30g", 8127.534f);
  printf("%-15s: %#05g\n", "%#05g", 8127.534f);
  printf("%-15s: %#05.g\n", "%#05.g", 8127.534f);
  printf("%-15s: %#05.0g\n", "%#05.0g", 8127.534f);
  printf("%-15s: %#05.1g\n", "%#05.1g", 8127.534f);
  printf("%-15s: %#05.2g\n", "%#05.2g", 8127.534f);
  printf("%-15s: %#05.5g\n", "%#05.5g", 8127.534f);
  printf("%-15s: %#05.10g\n", "%#05.10g", 8127.534f);
  printf("%-15s: %#05.30g\n", "%#05.30g", 8127.534f);
  printf("%-15s: %#010g\n", "%#010g", 8127.534f);
  printf("%-15s: %#010.g\n", "%#010.g", 8127.534f);
  printf("%-15s: %#010.0g\n", "%#010.0g", 8127.534f);
  printf("%-15s: %#010.1g\n", "%#010.1g", 8127.534f);
  printf("%-15s: %#010.2g\n", "%#010.2g", 8127.534f);
  printf("%-15s: %#010.5g\n", "%#010.5g", 8127.534f);
  printf("%-15s: %#010.10g\n", "%#010.10g", 8127.534f);
  printf("%-15s: %#010.30g\n", "%#010.30g", 8127.534f);
  printf("%-15s: %#030g\n", "%#030g", 8127.534f);
  printf("%-15s: %#030.g\n", "%#030.g", 8127.534f);
  printf("%-15s: %#030.0g\n", "%#030.0g", 8127.534f);
  printf("%-15s: %#030.1g\n", "%#030.1g", 8127.534f);
  printf("%-15s: %#030.2g\n", "%#030.2g", 8127.534f);
  printf("%-15s: %#030.5g\n", "%#030.5g", 8127.534f);
  printf("%-15s: %#030.10g\n", "%#030.10g", 8127.534f);
  printf("%-15s: %#030.30g\n", "%#030.30g", 8127.534f);
  printf("%-15s: %-+#g\n", "%-+#g", 8127.534f);
  printf("%-15s: %-+#.g\n", "%-+#.g", 8127.534f);
  printf("%-15s: %-+#.0g\n", "%-+#.0g", 8127.534f);
  printf("%-15s: %-+#.1g\n", "%-+#.1g", 8127.534f);
  printf("%-15s: %-+#.2g\n", "%-+#.2g", 8127.534f);
  printf("%-15s: %-+#.5g\n", "%-+#.5g", 8127.534f);
  printf("%-15s: %-+#.10g\n", "%-+#.10g", 8127.534f);
  printf("%-15s: %-+#.30g\n", "%-+#.30g", 8127.534f);
  printf("%-15s: %-+#1g\n", "%-+#1g", 8127.534f);
  printf("%-15s: %-+#1.g\n", "%-+#1.g", 8127.534f);
  printf("%-15s: %-+#1.0g\n", "%-+#1.0g", 8127.534f);
  printf("%-15s: %-+#1.1g\n", "%-+#1.1g", 8127.534f);
  printf("%-15s: %-+#1.2g\n", "%-+#1.2g", 8127.534f);
  printf("%-15s: %-+#1.5g\n", "%-+#1.5g", 8127.534f);
  printf("%-15s: %-+#1.10g\n", "%-+#1.10g", 8127.534f);
  printf("%-15s: %-+#1.30g\n", "%-+#1.30g", 8127.534f);
  printf("%-15s: %-+#2g\n", "%-+#2g", 8127.534f);
  printf("%-15s: %-+#2.g\n", "%-+#2.g", 8127.534f);
  printf("%-15s: %-+#2.0g\n", "%-+#2.0g", 8127.534f);
  printf("%-15s: %-+#2.1g\n", "%-+#2.1g", 8127.534f);
  printf("%-15s: %-+#2.2g\n", "%-+#2.2g", 8127.534f);
  printf("%-15s: %-+#2.5g\n", "%-+#2.5g", 8127.534f);
  printf("%-15s: %-+#2.10g\n", "%-+#2.10g", 8127.534f);
  printf("%-15s: %-+#2.30g\n", "%-+#2.30g", 8127.534f);
  printf("%-15s: %-+#5g\n", "%-+#5g", 8127.534f);
  printf("%-15s: %-+#5.g\n", "%-+#5.g", 8127.534f);
  printf("%-15s: %-+#5.0g\n", "%-+#5.0g", 8127.534f);
  printf("%-15s: %-+#5.1g\n", "%-+#5.1g", 8127.534f);
  printf("%-15s: %-+#5.2g\n", "%-+#5.2g", 8127.534f);
  printf("%-15s: %-+#5.5g\n", "%-+#5.5g", 8127.534f);
  printf("%-15s: %-+#5.10g\n", "%-+#5.10g", 8127.534f);
  printf("%-15s: %-+#5.30g\n", "%-+#5.30g", 8127.534f);
  printf("%-15s: %-+#10g\n", "%-+#10g", 8127.534f);
  printf("%-15s: %-+#10.g\n", "%-+#10.g", 8127.534f);
  printf("%-15s: %-+#10.0g\n", "%-+#10.0g", 8127.534f);
  printf("%-15s: %-+#10.1g\n", "%-+#10.1g", 8127.534f);
  printf("%-15s: %-+#10.2g\n", "%-+#10.2g", 8127.534f);
  printf("%-15s: %-+#10.5g\n", "%-+#10.5g", 8127.534f);
  printf("%-15s: %-+#10.10g\n", "%-+#10.10g", 8127.534f);
  printf("%-15s: %-+#10.30g\n", "%-+#10.30g", 8127.534f);
  printf("%-15s: %-+#30g\n", "%-+#30g", 8127.534f);
  printf("%-15s: %-+#30.g\n", "%-+#30.g", 8127.534f);
  printf("%-15s: %-+#30.0g\n", "%-+#30.0g", 8127.534f);
  printf("%-15s: %-+#30.1g\n", "%-+#30.1g", 8127.534f);
  printf("%-15s: %-+#30.2g\n", "%-+#30.2g", 8127.534f);
  printf("%-15s: %-+#30.5g\n", "%-+#30.5g", 8127.534f);
  printf("%-15s: %-+#30.10g\n", "%-+#30.10g", 8127.534f);
  printf("%-15s: %-+#30.30g\n", "%-+#30.30g", 8127.534f);
  printf("%-15s: %0+#g\n", "%0+#g", 8127.534f);
  printf("%-15s: %0+#.g\n", "%0+#.g", 8127.534f);
  printf("%-15s: %0+#.0g\n", "%0+#.0g", 8127.534f);
  printf("%-15s: %0+#.1g\n", "%0+#.1g", 8127.534f);
  printf("%-15s: %0+#.2g\n", "%0+#.2g", 8127.534f);
  printf("%-15s: %0+#.5g\n", "%0+#.5g", 8127.534f);
  printf("%-15s: %0+#.10g\n", "%0+#.10g", 8127.534f);
  printf("%-15s: %0+#.30g\n", "%0+#.30g", 8127.534f);
  printf("%-15s: %0+#1g\n", "%0+#1g", 8127.534f);
  printf("%-15s: %0+#1.g\n", "%0+#1.g", 8127.534f);
  printf("%-15s: %0+#1.0g\n", "%0+#1.0g", 8127.534f);
  printf("%-15s: %0+#1.1g\n", "%0+#1.1g", 8127.534f);
  printf("%-15s: %0+#1.2g\n", "%0+#1.2g", 8127.534f);
  printf("%-15s: %0+#1.5g\n", "%0+#1.5g", 8127.534f);
  printf("%-15s: %0+#1.10g\n", "%0+#1.10g", 8127.534f);
  printf("%-15s: %0+#1.30g\n", "%0+#1.30g", 8127.534f);
  printf("%-15s: %0+#2g\n", "%0+#2g", 8127.534f);
  printf("%-15s: %0+#2.g\n", "%0+#2.g", 8127.534f);
  printf("%-15s: %0+#2.0g\n", "%0+#2.0g", 8127.534f);
  printf("%-15s: %0+#2.1g\n", "%0+#2.1g", 8127.534f);
  printf("%-15s: %0+#2.2g\n", "%0+#2.2g", 8127.534f);
  printf("%-15s: %0+#2.5g\n", "%0+#2.5g", 8127.534f);
  printf("%-15s: %0+#2.10g\n", "%0+#2.10g", 8127.534f);
  printf("%-15s: %0+#2.30g\n", "%0+#2.30g", 8127.534f);
  printf("%-15s: %0+#5g\n", "%0+#5g", 8127.534f);
  printf("%-15s: %0+#5.g\n", "%0+#5.g", 8127.534f);
  printf("%-15s: %0+#5.0g\n", "%0+#5.0g", 8127.534f);
  printf("%-15s: %0+#5.1g\n", "%0+#5.1g", 8127.534f);
  printf("%-15s: %0+#5.2g\n", "%0+#5.2g", 8127.534f);
  printf("%-15s: %0+#5.5g\n", "%0+#5.5g", 8127.534f);
  printf("%-15s: %0+#5.10g\n", "%0+#5.10g", 8127.534f);
  printf("%-15s: %0+#5.30g\n", "%0+#5.30g", 8127.534f);
  printf("%-15s: %0+#10g\n", "%0+#10g", 8127.534f);
  printf("%-15s: %0+#10.g\n", "%0+#10.g", 8127.534f);
  printf("%-15s: %0+#10.0g\n", "%0+#10.0g", 8127.534f);
  printf("%-15s: %0+#10.1g\n", "%0+#10.1g", 8127.534f);
  printf("%-15s: %0+#10.2g\n", "%0+#10.2g", 8127.534f);
  printf("%-15s: %0+#10.5g\n", "%0+#10.5g", 8127.534f);
  printf("%-15s: %0+#10.10g\n", "%0+#10.10g", 8127.534f);
  printf("%-15s: %0+#10.30g\n", "%0+#10.30g", 8127.534f);
  printf("%-15s: %0+#30g\n", "%0+#30g", 8127.534f);
  printf("%-15s: %0+#30.g\n", "%0+#30.g", 8127.534f);
  printf("%-15s: %0+#30.0g\n", "%0+#30.0g", 8127.534f);
  printf("%-15s: %0+#30.1g\n", "%0+#30.1g", 8127.534f);
  printf("%-15s: %0+#30.2g\n", "%0+#30.2g", 8127.534f);
  printf("%-15s: %0+#30.5g\n", "%0+#30.5g", 8127.534f);
  printf("%-15s: %0+#30.10g\n", "%0+#30.10g", 8127.534f);
  printf("%-15s: %0+#30.30g\n", "%0+#30.30g", 8127.534f);
  printf("%-15s: %#-+g\n", "%#-+g", 8127.534f);
  printf("%-15s: %#-+.g\n", "%#-+.g", 8127.534f);
  printf("%-15s: %#-+.0g\n", "%#-+.0g", 8127.534f);
  printf("%-15s: %#-+.1g\n", "%#-+.1g", 8127.534f);
  printf("%-15s: %#-+.2g\n", "%#-+.2g", 8127.534f);
  printf("%-15s: %#-+.5g\n", "%#-+.5g", 8127.534f);
  printf("%-15s: %#-+.10g\n", "%#-+.10g", 8127.534f);
  printf("%-15s: %#-+.30g\n", "%#-+.30g", 8127.534f);
  printf("%-15s: %#-+1g\n", "%#-+1g", 8127.534f);
  printf("%-15s: %#-+1.g\n", "%#-+1.g", 8127.534f);
  printf("%-15s: %#-+1.0g\n", "%#-+1.0g", 8127.534f);
  printf("%-15s: %#-+1.1g\n", "%#-+1.1g", 8127.534f);
  printf("%-15s: %#-+1.2g\n", "%#-+1.2g", 8127.534f);
  printf("%-15s: %#-+1.5g\n", "%#-+1.5g", 8127.534f);
  printf("%-15s: %#-+1.10g\n", "%#-+1.10g", 8127.534f);
  printf("%-15s: %#-+1.30g\n", "%#-+1.30g", 8127.534f);
  printf("%-15s: %#-+2g\n", "%#-+2g", 8127.534f);
  printf("%-15s: %#-+2.g\n", "%#-+2.g", 8127.534f);
  printf("%-15s: %#-+2.0g\n", "%#-+2.0g", 8127.534f);
  printf("%-15s: %#-+2.1g\n", "%#-+2.1g", 8127.534f);
  printf("%-15s: %#-+2.2g\n", "%#-+2.2g", 8127.534f);
  printf("%-15s: %#-+2.5g\n", "%#-+2.5g", 8127.534f);
  printf("%-15s: %#-+2.10g\n", "%#-+2.10g", 8127.534f);
  printf("%-15s: %#-+2.30g\n", "%#-+2.30g", 8127.534f);
  printf("%-15s: %#-+5g\n", "%#-+5g", 8127.534f);
  printf("%-15s: %#-+5.g\n", "%#-+5.g", 8127.534f);
  printf("%-15s: %#-+5.0g\n", "%#-+5.0g", 8127.534f);
  printf("%-15s: %#-+5.1g\n", "%#-+5.1g", 8127.534f);
  printf("%-15s: %#-+5.2g\n", "%#-+5.2g", 8127.534f);
  printf("%-15s: %#-+5.5g\n", "%#-+5.5g", 8127.534f);
  printf("%-15s: %#-+5.10g\n", "%#-+5.10g", 8127.534f);
  printf("%-15s: %#-+5.30g\n", "%#-+5.30g", 8127.534f);
  printf("%-15s: %#-+10g\n", "%#-+10g", 8127.534f);
  printf("%-15s: %#-+10.g\n", "%#-+10.g", 8127.534f);
  printf("%-15s: %#-+10.0g\n", "%#-+10.0g", 8127.534f);
  printf("%-15s: %#-+10.1g\n", "%#-+10.1g", 8127.534f);
  printf("%-15s: %#-+10.2g\n", "%#-+10.2g", 8127.534f);
  printf("%-15s: %#-+10.5g\n", "%#-+10.5g", 8127.534f);
  printf("%-15s: %#-+10.10g\n", "%#-+10.10g", 8127.534f);
  printf("%-15s: %#-+10.30g\n", "%#-+10.30g", 8127.534f);
  printf("%-15s: %#-+30g\n", "%#-+30g", 8127.534f);
  printf("%-15s: %#-+30.g\n", "%#-+30.g", 8127.534f);
  printf("%-15s: %#-+30.0g\n", "%#-+30.0g", 8127.534f);
  printf("%-15s: %#-+30.1g\n", "%#-+30.1g", 8127.534f);
  printf("%-15s: %#-+30.2g\n", "%#-+30.2g", 8127.534f);
  printf("%-15s: %#-+30.5g\n", "%#-+30.5g", 8127.534f);
  printf("%-15s: %#-+30.10g\n", "%#-+30.10g", 8127.534f);
  printf("%-15s: %#-+30.30g\n", "%#-+30.30g", 8127.534f);
  printf("%-15s: %+#-g\n", "%+#-g", 8127.534f);
  printf("%-15s: %+#-.g\n", "%+#-.g", 8127.534f);
  printf("%-15s: %+#-.0g\n", "%+#-.0g", 8127.534f);
  printf("%-15s: %+#-.1g\n", "%+#-.1g", 8127.534f);
  printf("%-15s: %+#-.2g\n", "%+#-.2g", 8127.534f);
  printf("%-15s: %+#-.5g\n", "%+#-.5g", 8127.534f);
  printf("%-15s: %+#-.10g\n", "%+#-.10g", 8127.534f);
  printf("%-15s: %+#-.30g\n", "%+#-.30g", 8127.534f);
  printf("%-15s: %+#-1g\n", "%+#-1g", 8127.534f);
  printf("%-15s: %+#-1.g\n", "%+#-1.g", 8127.534f);
  printf("%-15s: %+#-1.0g\n", "%+#-1.0g", 8127.534f);
  printf("%-15s: %+#-1.1g\n", "%+#-1.1g", 8127.534f);
  printf("%-15s: %+#-1.2g\n", "%+#-1.2g", 8127.534f);
  printf("%-15s: %+#-1.5g\n", "%+#-1.5g", 8127.534f);
  printf("%-15s: %+#-1.10g\n", "%+#-1.10g", 8127.534f);
  printf("%-15s: %+#-1.30g\n", "%+#-1.30g", 8127.534f);
  printf("%-15s: %+#-2g\n", "%+#-2g", 8127.534f);
  printf("%-15s: %+#-2.g\n", "%+#-2.g", 8127.534f);
  printf("%-15s: %+#-2.0g\n", "%+#-2.0g", 8127.534f);
  printf("%-15s: %+#-2.1g\n", "%+#-2.1g", 8127.534f);
  printf("%-15s: %+#-2.2g\n", "%+#-2.2g", 8127.534f);
  printf("%-15s: %+#-2.5g\n", "%+#-2.5g", 8127.534f);
  printf("%-15s: %+#-2.10g\n", "%+#-2.10g", 8127.534f);
  printf("%-15s: %+#-2.30g\n", "%+#-2.30g", 8127.534f);
  printf("%-15s: %+#-5g\n", "%+#-5g", 8127.534f);
  printf("%-15s: %+#-5.g\n", "%+#-5.g", 8127.534f);
  printf("%-15s: %+#-5.0g\n", "%+#-5.0g", 8127.534f);
  printf("%-15s: %+#-5.1g\n", "%+#-5.1g", 8127.534f);
  printf("%-15s: %+#-5.2g\n", "%+#-5.2g", 8127.534f);
  printf("%-15s: %+#-5.5g\n", "%+#-5.5g", 8127.534f);
  printf("%-15s: %+#-5.10g\n", "%+#-5.10g", 8127.534f);
  printf("%-15s: %+#-5.30g\n", "%+#-5.30g", 8127.534f);
  printf("%-15s: %+#-10g\n", "%+#-10g", 8127.534f);
  printf("%-15s: %+#-10.g\n", "%+#-10.g", 8127.534f);
  printf("%-15s: %+#-10.0g\n", "%+#-10.0g", 8127.534f);
  printf("%-15s: %+#-10.1g\n", "%+#-10.1g", 8127.534f);
  printf("%-15s: %+#-10.2g\n", "%+#-10.2g", 8127.534f);
  printf("%-15s: %+#-10.5g\n", "%+#-10.5g", 8127.534f);
  printf("%-15s: %+#-10.10g\n", "%+#-10.10g", 8127.534f);
  printf("%-15s: %+#-10.30g\n", "%+#-10.30g", 8127.534f);
  printf("%-15s: %+#-30g\n", "%+#-30g", 8127.534f);
  printf("%-15s: %+#-30.g\n", "%+#-30.g", 8127.534f);
  printf("%-15s: %+#-30.0g\n", "%+#-30.0g", 8127.534f);
  printf("%-15s: %+#-30.1g\n", "%+#-30.1g", 8127.534f);
  printf("%-15s: %+#-30.2g\n", "%+#-30.2g", 8127.534f);
  printf("%-15s: %+#-30.5g\n", "%+#-30.5g", 8127.534f);
  printf("%-15s: %+#-30.10g\n", "%+#-30.10g", 8127.534f);
  printf("%-15s: %+#-30.30g\n", "%+#-30.30g", 8127.534f);
  printf("%-15s: %+G\n", "%+G", 8127.534f);
  printf("%-15s: %+.G\n", "%+.G", 8127.534f);
  printf("%-15s: %+.0G\n", "%+.0G", 8127.534f);
  printf("%-15s: %+.1G\n", "%+.1G", 8127.534f);
  printf("%-15s: %+.2G\n", "%+.2G", 8127.534f);
  printf("%-15s: %+.5G\n", "%+.5G", 8127.534f);
  printf("%-15s: %+.10G\n", "%+.10G", 8127.534f);
  printf("%-15s: %+.30G\n", "%+.30G", 8127.534f);
  printf("%-15s: %+0G\n", "%+0G", 8127.534f);
  printf("%-15s: %+0.G\n", "%+0.G", 8127.534f);
  printf("%-15s: %+0.0G\n", "%+0.0G", 8127.534f);
  printf("%-15s: %+0.1G\n", "%+0.1G", 8127.534f);
  printf("%-15s: %+0.2G\n", "%+0.2G", 8127.534f);
  printf("%-15s: %+0.5G\n", "%+0.5G", 8127.534f);
  printf("%-15s: %+0.10G\n", "%+0.10G", 8127.534f);
  printf("%-15s: %+0.30G\n", "%+0.30G", 8127.534f);
  printf("%-15s: %+1G\n", "%+1G", 8127.534f);
  printf("%-15s: %+1.G\n", "%+1.G", 8127.534f);
  printf("%-15s: %+1.0G\n", "%+1.0G", 8127.534f);
  printf("%-15s: %+1.1G\n", "%+1.1G", 8127.534f);
  printf("%-15s: %+1.2G\n", "%+1.2G", 8127.534f);
  printf("%-15s: %+1.5G\n", "%+1.5G", 8127.534f);
  printf("%-15s: %+1.10G\n", "%+1.10G", 8127.534f);
  printf("%-15s: %+1.30G\n", "%+1.30G", 8127.534f);
  printf("%-15s: %+2G\n", "%+2G", 8127.534f);
  printf("%-15s: %+2.G\n", "%+2.G", 8127.534f);
  printf("%-15s: %+2.0G\n", "%+2.0G", 8127.534f);
  printf("%-15s: %+2.1G\n", "%+2.1G", 8127.534f);
  printf("%-15s: %+2.2G\n", "%+2.2G", 8127.534f);
  printf("%-15s: %+2.5G\n", "%+2.5G", 8127.534f);
  printf("%-15s: %+2.10G\n", "%+2.10G", 8127.534f);
  printf("%-15s: %+2.30G\n", "%+2.30G", 8127.534f);
  printf("%-15s: %+5G\n", "%+5G", 8127.534f);
  printf("%-15s: %+5.G\n", "%+5.G", 8127.534f);
  printf("%-15s: %+5.0G\n", "%+5.0G", 8127.534f);
  printf("%-15s: %+5.1G\n", "%+5.1G", 8127.534f);
  printf("%-15s: %+5.2G\n", "%+5.2G", 8127.534f);
  printf("%-15s: %+5.5G\n", "%+5.5G", 8127.534f);
  printf("%-15s: %+5.10G\n", "%+5.10G", 8127.534f);
  printf("%-15s: %+5.30G\n", "%+5.30G", 8127.534f);
  printf("%-15s: %+10G\n", "%+10G", 8127.534f);
  printf("%-15s: %+10.G\n", "%+10.G", 8127.534f);
  printf("%-15s: %+10.0G\n", "%+10.0G", 8127.534f);
  printf("%-15s: %+10.1G\n", "%+10.1G", 8127.534f);
  printf("%-15s: %+10.2G\n", "%+10.2G", 8127.534f);
  printf("%-15s: %+10.5G\n", "%+10.5G", 8127.534f);
  printf("%-15s: %+10.10G\n", "%+10.10G", 8127.534f);
  printf("%-15s: %+10.30G\n", "%+10.30G", 8127.534f);
  printf("%-15s: %+30G\n", "%+30G", 8127.534f);
  printf("%-15s: %+30.G\n", "%+30.G", 8127.534f);
  printf("%-15s: %+30.0G\n", "%+30.0G", 8127.534f);
  printf("%-15s: %+30.1G\n", "%+30.1G", 8127.534f);
  printf("%-15s: %+30.2G\n", "%+30.2G", 8127.534f);
  printf("%-15s: %+30.5G\n", "%+30.5G", 8127.534f);
  printf("%-15s: %+30.10G\n", "%+30.10G", 8127.534f);
  printf("%-15s: %+30.30G\n", "%+30.30G", 8127.534f);
  printf("%-15s: %-G\n", "%-G", 8127.534f);
  printf("%-15s: %-.G\n", "%-.G", 8127.534f);
  printf("%-15s: %-.0G\n", "%-.0G", 8127.534f);
  printf("%-15s: %-.1G\n", "%-.1G", 8127.534f);
  printf("%-15s: %-.2G\n", "%-.2G", 8127.534f);
  printf("%-15s: %-.5G\n", "%-.5G", 8127.534f);
  printf("%-15s: %-.10G\n", "%-.10G", 8127.534f);
  printf("%-15s: %-.30G\n", "%-.30G", 8127.534f);
  printf("%-15s: %-1G\n", "%-1G", 8127.534f);
  printf("%-15s: %-1.G\n", "%-1.G", 8127.534f);
  printf("%-15s: %-1.0G\n", "%-1.0G", 8127.534f);
  printf("%-15s: %-1.1G\n", "%-1.1G", 8127.534f);
  printf("%-15s: %-1.2G\n", "%-1.2G", 8127.534f);
  printf("%-15s: %-1.5G\n", "%-1.5G", 8127.534f);
  printf("%-15s: %-1.10G\n", "%-1.10G", 8127.534f);
  printf("%-15s: %-1.30G\n", "%-1.30G", 8127.534f);
  printf("%-15s: %-2G\n", "%-2G", 8127.534f);
  printf("%-15s: %-2.G\n", "%-2.G", 8127.534f);
  printf("%-15s: %-2.0G\n", "%-2.0G", 8127.534f);
  printf("%-15s: %-2.1G\n", "%-2.1G", 8127.534f);
  printf("%-15s: %-2.2G\n", "%-2.2G", 8127.534f);
  printf("%-15s: %-2.5G\n", "%-2.5G", 8127.534f);
  printf("%-15s: %-2.10G\n", "%-2.10G", 8127.534f);
  printf("%-15s: %-2.30G\n", "%-2.30G", 8127.534f);
  printf("%-15s: %-5G\n", "%-5G", 8127.534f);
  printf("%-15s: %-5.G\n", "%-5.G", 8127.534f);
  printf("%-15s: %-5.0G\n", "%-5.0G", 8127.534f);
  printf("%-15s: %-5.1G\n", "%-5.1G", 8127.534f);
  printf("%-15s: %-5.2G\n", "%-5.2G", 8127.534f);
  printf("%-15s: %-5.5G\n", "%-5.5G", 8127.534f);
  printf("%-15s: %-5.10G\n", "%-5.10G", 8127.534f);
  printf("%-15s: %-5.30G\n", "%-5.30G", 8127.534f);
  printf("%-15s: %-10G\n", "%-10G", 8127.534f);
  printf("%-15s: %-10.G\n", "%-10.G", 8127.534f);
  printf("%-15s: %-10.0G\n", "%-10.0G", 8127.534f);
  printf("%-15s: %-10.1G\n", "%-10.1G", 8127.534f);
  printf("%-15s: %-10.2G\n", "%-10.2G", 8127.534f);
  printf("%-15s: %-10.5G\n", "%-10.5G", 8127.534f);
  printf("%-15s: %-10.10G\n", "%-10.10G", 8127.534f);
  printf("%-15s: %-10.30G\n", "%-10.30G", 8127.534f);
  printf("%-15s: %-30G\n", "%-30G", 8127.534f);
  printf("%-15s: %-30.G\n", "%-30.G", 8127.534f);
  printf("%-15s: %-30.0G\n", "%-30.0G", 8127.534f);
  printf("%-15s: %-30.1G\n", "%-30.1G", 8127.534f);
  printf("%-15s: %-30.2G\n", "%-30.2G", 8127.534f);
  printf("%-15s: %-30.5G\n", "%-30.5G", 8127.534f);
  printf("%-15s: %-30.10G\n", "%-30.10G", 8127.534f);
  printf("%-15s: %-30.30G\n", "%-30.30G", 8127.534f);
  printf("%-15s: %#G\n", "%#G", 8127.534f);
  printf("%-15s: %#.G\n", "%#.G", 8127.534f);
  printf("%-15s: %#.0G\n", "%#.0G", 8127.534f);
  printf("%-15s: %#.1G\n", "%#.1G", 8127.534f);
  printf("%-15s: %#.2G\n", "%#.2G", 8127.534f);
  printf("%-15s: %#.5G\n", "%#.5G", 8127.534f);
  printf("%-15s: %#.10G\n", "%#.10G", 8127.534f);
  printf("%-15s: %#.30G\n", "%#.30G", 8127.534f);
  printf("%-15s: %#0G\n", "%#0G", 8127.534f);
  printf("%-15s: %#0.G\n", "%#0.G", 8127.534f);
  printf("%-15s: %#0.0G\n", "%#0.0G", 8127.534f);
  printf("%-15s: %#0.1G\n", "%#0.1G", 8127.534f);
  printf("%-15s: %#0.2G\n", "%#0.2G", 8127.534f);
  printf("%-15s: %#0.5G\n", "%#0.5G", 8127.534f);
  printf("%-15s: %#0.10G\n", "%#0.10G", 8127.534f);
  printf("%-15s: %#0.30G\n", "%#0.30G", 8127.534f);
  printf("%-15s: %#1G\n", "%#1G", 8127.534f);
  printf("%-15s: %#1.G\n", "%#1.G", 8127.534f);
  printf("%-15s: %#1.0G\n", "%#1.0G", 8127.534f);
  printf("%-15s: %#1.1G\n", "%#1.1G", 8127.534f);
  printf("%-15s: %#1.2G\n", "%#1.2G", 8127.534f);
  printf("%-15s: %#1.5G\n", "%#1.5G", 8127.534f);
  printf("%-15s: %#1.10G\n", "%#1.10G", 8127.534f);
  printf("%-15s: %#1.30G\n", "%#1.30G", 8127.534f);
  printf("%-15s: %#2G\n", "%#2G", 8127.534f);
  printf("%-15s: %#2.G\n", "%#2.G", 8127.534f);
  printf("%-15s: %#2.0G\n", "%#2.0G", 8127.534f);
  printf("%-15s: %#2.1G\n", "%#2.1G", 8127.534f);
  printf("%-15s: %#2.2G\n", "%#2.2G", 8127.534f);
  printf("%-15s: %#2.5G\n", "%#2.5G", 8127.534f);
  printf("%-15s: %#2.10G\n", "%#2.10G", 8127.534f);
  printf("%-15s: %#2.30G\n", "%#2.30G", 8127.534f);
  printf("%-15s: %#5G\n", "%#5G", 8127.534f);
  printf("%-15s: %#5.G\n", "%#5.G", 8127.534f);
  printf("%-15s: %#5.0G\n", "%#5.0G", 8127.534f);
  printf("%-15s: %#5.1G\n", "%#5.1G", 8127.534f);
  printf("%-15s: %#5.2G\n", "%#5.2G", 8127.534f);
  printf("%-15s: %#5.5G\n", "%#5.5G", 8127.534f);
  printf("%-15s: %#5.10G\n", "%#5.10G", 8127.534f);
  printf("%-15s: %#5.30G\n", "%#5.30G", 8127.534f);
  printf("%-15s: %#10G\n", "%#10G", 8127.534f);
  printf("%-15s: %#10.G\n", "%#10.G", 8127.534f);
  printf("%-15s: %#10.0G\n", "%#10.0G", 8127.534f);
  printf("%-15s: %#10.1G\n", "%#10.1G", 8127.534f);
  printf("%-15s: %#10.2G\n", "%#10.2G", 8127.534f);
  printf("%-15s: %#10.5G\n", "%#10.5G", 8127.534f);
  printf("%-15s: %#10.10G\n", "%#10.10G", 8127.534f);
  printf("%-15s: %#10.30G\n", "%#10.30G", 8127.534f);
  printf("%-15s: %#30G\n", "%#30G", 8127.534f);
  printf("%-15s: %#30.G\n", "%#30.G", 8127.534f);
  printf("%-15s: %#30.0G\n", "%#30.0G", 8127.534f);
  printf("%-15s: %#30.1G\n", "%#30.1G", 8127.534f);
  printf("%-15s: %#30.2G\n", "%#30.2G", 8127.534f);
  printf("%-15s: %#30.5G\n", "%#30.5G", 8127.534f);
  printf("%-15s: %#30.10G\n", "%#30.10G", 8127.534f);
  printf("%-15s: %#30.30G\n", "%#30.30G", 8127.534f);
  printf("%-15s: %0G\n", "%0G", 8127.534f);
  printf("%-15s: %0.G\n", "%0.G", 8127.534f);
  printf("%-15s: %0.0G\n", "%0.0G", 8127.534f);
  printf("%-15s: %0.1G\n", "%0.1G", 8127.534f);
  printf("%-15s: %0.2G\n", "%0.2G", 8127.534f);
  printf("%-15s: %0.5G\n", "%0.5G", 8127.534f);
  printf("%-15s: %0.10G\n", "%0.10G", 8127.534f);
  printf("%-15s: %0.30G\n", "%0.30G", 8127.534f);
  printf("%-15s: %01G\n", "%01G", 8127.534f);
  printf("%-15s: %01.G\n", "%01.G", 8127.534f);
  printf("%-15s: %01.0G\n", "%01.0G", 8127.534f);
  printf("%-15s: %01.1G\n", "%01.1G", 8127.534f);
  printf("%-15s: %01.2G\n", "%01.2G", 8127.534f);
  printf("%-15s: %01.5G\n", "%01.5G", 8127.534f);
  printf("%-15s: %01.10G\n", "%01.10G", 8127.534f);
  printf("%-15s: %01.30G\n", "%01.30G", 8127.534f);
  printf("%-15s: %02G\n", "%02G", 8127.534f);
  printf("%-15s: %02.G\n", "%02.G", 8127.534f);
  printf("%-15s: %02.0G\n", "%02.0G", 8127.534f);
  printf("%-15s: %02.1G\n", "%02.1G", 8127.534f);
  printf("%-15s: %02.2G\n", "%02.2G", 8127.534f);
  printf("%-15s: %02.5G\n", "%02.5G", 8127.534f);
  printf("%-15s: %02.10G\n", "%02.10G", 8127.534f);
  printf("%-15s: %02.30G\n", "%02.30G", 8127.534f);
  printf("%-15s: %05G\n", "%05G", 8127.534f);
  printf("%-15s: %05.G\n", "%05.G", 8127.534f);
  printf("%-15s: %05.0G\n", "%05.0G", 8127.534f);
  printf("%-15s: %05.1G\n", "%05.1G", 8127.534f);
  printf("%-15s: %05.2G\n", "%05.2G", 8127.534f);
  printf("%-15s: %05.5G\n", "%05.5G", 8127.534f);
  printf("%-15s: %05.10G\n", "%05.10G", 8127.534f);
  printf("%-15s: %05.30G\n", "%05.30G", 8127.534f);
  printf("%-15s: %010G\n", "%010G", 8127.534f);
  printf("%-15s: %010.G\n", "%010.G", 8127.534f);
  printf("%-15s: %010.0G\n", "%010.0G", 8127.534f);
  printf("%-15s: %010.1G\n", "%010.1G", 8127.534f);
  printf("%-15s: %010.2G\n", "%010.2G", 8127.534f);
  printf("%-15s: %010.5G\n", "%010.5G", 8127.534f);
  printf("%-15s: %010.10G\n", "%010.10G", 8127.534f);
  printf("%-15s: %010.30G\n", "%010.30G", 8127.534f);
  printf("%-15s: %030G\n", "%030G", 8127.534f);
  printf("%-15s: %030.G\n", "%030.G", 8127.534f);
  printf("%-15s: %030.0G\n", "%030.0G", 8127.534f);
  printf("%-15s: %030.1G\n", "%030.1G", 8127.534f);
  printf("%-15s: %030.2G\n", "%030.2G", 8127.534f);
  printf("%-15s: %030.5G\n", "%030.5G", 8127.534f);
  printf("%-15s: %030.10G\n", "%030.10G", 8127.534f);
  printf("%-15s: %030.30G\n", "%030.30G", 8127.534f);
  printf("%-15s: %-+G\n", "%-+G", 8127.534f);
  printf("%-15s: %-+.G\n", "%-+.G", 8127.534f);
  printf("%-15s: %-+.0G\n", "%-+.0G", 8127.534f);
  printf("%-15s: %-+.1G\n", "%-+.1G", 8127.534f);
  printf("%-15s: %-+.2G\n", "%-+.2G", 8127.534f);
  printf("%-15s: %-+.5G\n", "%-+.5G", 8127.534f);
  printf("%-15s: %-+.10G\n", "%-+.10G", 8127.534f);
  printf("%-15s: %-+.30G\n", "%-+.30G", 8127.534f);
  printf("%-15s: %-+1G\n", "%-+1G", 8127.534f);
  printf("%-15s: %-+1.G\n", "%-+1.G", 8127.534f);
  printf("%-15s: %-+1.0G\n", "%-+1.0G", 8127.534f);
  printf("%-15s: %-+1.1G\n", "%-+1.1G", 8127.534f);
  printf("%-15s: %-+1.2G\n", "%-+1.2G", 8127.534f);
  printf("%-15s: %-+1.5G\n", "%-+1.5G", 8127.534f);
  printf("%-15s: %-+1.10G\n", "%-+1.10G", 8127.534f);
  printf("%-15s: %-+1.30G\n", "%-+1.30G", 8127.534f);
  printf("%-15s: %-+2G\n", "%-+2G", 8127.534f);
  printf("%-15s: %-+2.G\n", "%-+2.G", 8127.534f);
  printf("%-15s: %-+2.0G\n", "%-+2.0G", 8127.534f);
  printf("%-15s: %-+2.1G\n", "%-+2.1G", 8127.534f);
  printf("%-15s: %-+2.2G\n", "%-+2.2G", 8127.534f);
  printf("%-15s: %-+2.5G\n", "%-+2.5G", 8127.534f);
  printf("%-15s: %-+2.10G\n", "%-+2.10G", 8127.534f);
  printf("%-15s: %-+2.30G\n", "%-+2.30G", 8127.534f);
  printf("%-15s: %-+5G\n", "%-+5G", 8127.534f);
  printf("%-15s: %-+5.G\n", "%-+5.G", 8127.534f);
  printf("%-15s: %-+5.0G\n", "%-+5.0G", 8127.534f);
  printf("%-15s: %-+5.1G\n", "%-+5.1G", 8127.534f);
  printf("%-15s: %-+5.2G\n", "%-+5.2G", 8127.534f);
  printf("%-15s: %-+5.5G\n", "%-+5.5G", 8127.534f);
  printf("%-15s: %-+5.10G\n", "%-+5.10G", 8127.534f);
  printf("%-15s: %-+5.30G\n", "%-+5.30G", 8127.534f);
  printf("%-15s: %-+10G\n", "%-+10G", 8127.534f);
  printf("%-15s: %-+10.G\n", "%-+10.G", 8127.534f);
  printf("%-15s: %-+10.0G\n", "%-+10.0G", 8127.534f);
  printf("%-15s: %-+10.1G\n", "%-+10.1G", 8127.534f);
  printf("%-15s: %-+10.2G\n", "%-+10.2G", 8127.534f);
  printf("%-15s: %-+10.5G\n", "%-+10.5G", 8127.534f);
  printf("%-15s: %-+10.10G\n", "%-+10.10G", 8127.534f);
  printf("%-15s: %-+10.30G\n", "%-+10.30G", 8127.534f);
  printf("%-15s: %-+30G\n", "%-+30G", 8127.534f);
  printf("%-15s: %-+30.G\n", "%-+30.G", 8127.534f);
  printf("%-15s: %-+30.0G\n", "%-+30.0G", 8127.534f);
  printf("%-15s: %-+30.1G\n", "%-+30.1G", 8127.534f);
  printf("%-15s: %-+30.2G\n", "%-+30.2G", 8127.534f);
  printf("%-15s: %-+30.5G\n", "%-+30.5G", 8127.534f);
  printf("%-15s: %-+30.10G\n", "%-+30.10G", 8127.534f);
  printf("%-15s: %-+30.30G\n", "%-+30.30G", 8127.534f);
  printf("%-15s: %#+G\n", "%#+G", 8127.534f);
  printf("%-15s: %#+.G\n", "%#+.G", 8127.534f);
  printf("%-15s: %#+.0G\n", "%#+.0G", 8127.534f);
  printf("%-15s: %#+.1G\n", "%#+.1G", 8127.534f);
  printf("%-15s: %#+.2G\n", "%#+.2G", 8127.534f);
  printf("%-15s: %#+.5G\n", "%#+.5G", 8127.534f);
  printf("%-15s: %#+.10G\n", "%#+.10G", 8127.534f);
  printf("%-15s: %#+.30G\n", "%#+.30G", 8127.534f);
  printf("%-15s: %#+0G\n", "%#+0G", 8127.534f);
  printf("%-15s: %#+0.G\n", "%#+0.G", 8127.534f);
  printf("%-15s: %#+0.0G\n", "%#+0.0G", 8127.534f);
  printf("%-15s: %#+0.1G\n", "%#+0.1G", 8127.534f);
  printf("%-15s: %#+0.2G\n", "%#+0.2G", 8127.534f);
  printf("%-15s: %#+0.5G\n", "%#+0.5G", 8127.534f);
  printf("%-15s: %#+0.10G\n", "%#+0.10G", 8127.534f);
  printf("%-15s: %#+0.30G\n", "%#+0.30G", 8127.534f);
  printf("%-15s: %#+1G\n", "%#+1G", 8127.534f);
  printf("%-15s: %#+1.G\n", "%#+1.G", 8127.534f);
  printf("%-15s: %#+1.0G\n", "%#+1.0G", 8127.534f);
  printf("%-15s: %#+1.1G\n", "%#+1.1G", 8127.534f);
  printf("%-15s: %#+1.2G\n", "%#+1.2G", 8127.534f);
  printf("%-15s: %#+1.5G\n", "%#+1.5G", 8127.534f);
  printf("%-15s: %#+1.10G\n", "%#+1.10G", 8127.534f);
  printf("%-15s: %#+1.30G\n", "%#+1.30G", 8127.534f);
  printf("%-15s: %#+2G\n", "%#+2G", 8127.534f);
  printf("%-15s: %#+2.G\n", "%#+2.G", 8127.534f);
  printf("%-15s: %#+2.0G\n", "%#+2.0G", 8127.534f);
  printf("%-15s: %#+2.1G\n", "%#+2.1G", 8127.534f);
  printf("%-15s: %#+2.2G\n", "%#+2.2G", 8127.534f);
  printf("%-15s: %#+2.5G\n", "%#+2.5G", 8127.534f);
  printf("%-15s: %#+2.10G\n", "%#+2.10G", 8127.534f);
  printf("%-15s: %#+2.30G\n", "%#+2.30G", 8127.534f);
  printf("%-15s: %#+5G\n", "%#+5G", 8127.534f);
  printf("%-15s: %#+5.G\n", "%#+5.G", 8127.534f);
  printf("%-15s: %#+5.0G\n", "%#+5.0G", 8127.534f);
  printf("%-15s: %#+5.1G\n", "%#+5.1G", 8127.534f);
  printf("%-15s: %#+5.2G\n", "%#+5.2G", 8127.534f);
  printf("%-15s: %#+5.5G\n", "%#+5.5G", 8127.534f);
  printf("%-15s: %#+5.10G\n", "%#+5.10G", 8127.534f);
  printf("%-15s: %#+5.30G\n", "%#+5.30G", 8127.534f);
  printf("%-15s: %#+10G\n", "%#+10G", 8127.534f);
  printf("%-15s: %#+10.G\n", "%#+10.G", 8127.534f);
  printf("%-15s: %#+10.0G\n", "%#+10.0G", 8127.534f);
  printf("%-15s: %#+10.1G\n", "%#+10.1G", 8127.534f);
  printf("%-15s: %#+10.2G\n", "%#+10.2G", 8127.534f);
  printf("%-15s: %#+10.5G\n", "%#+10.5G", 8127.534f);
  printf("%-15s: %#+10.10G\n", "%#+10.10G", 8127.534f);
  printf("%-15s: %#+10.30G\n", "%#+10.30G", 8127.534f);
  printf("%-15s: %#+30G\n", "%#+30G", 8127.534f);
  printf("%-15s: %#+30.G\n", "%#+30.G", 8127.534f);
  printf("%-15s: %#+30.0G\n", "%#+30.0G", 8127.534f);
  printf("%-15s: %#+30.1G\n", "%#+30.1G", 8127.534f);
  printf("%-15s: %#+30.2G\n", "%#+30.2G", 8127.534f);
  printf("%-15s: %#+30.5G\n", "%#+30.5G", 8127.534f);
  printf("%-15s: %#+30.10G\n", "%#+30.10G", 8127.534f);
  printf("%-15s: %#+30.30G\n", "%#+30.30G", 8127.534f);
  printf("%-15s: %+0G\n", "%+0G", 8127.534f);
  printf("%-15s: %+0.G\n", "%+0.G", 8127.534f);
  printf("%-15s: %+0.0G\n", "%+0.0G", 8127.534f);
  printf("%-15s: %+0.1G\n", "%+0.1G", 8127.534f);
  printf("%-15s: %+0.2G\n", "%+0.2G", 8127.534f);
  printf("%-15s: %+0.5G\n", "%+0.5G", 8127.534f);
  printf("%-15s: %+0.10G\n", "%+0.10G", 8127.534f);
  printf("%-15s: %+0.30G\n", "%+0.30G", 8127.534f);
  printf("%-15s: %+01G\n", "%+01G", 8127.534f);
  printf("%-15s: %+01.G\n", "%+01.G", 8127.534f);
  printf("%-15s: %+01.0G\n", "%+01.0G", 8127.534f);
  printf("%-15s: %+01.1G\n", "%+01.1G", 8127.534f);
  printf("%-15s: %+01.2G\n", "%+01.2G", 8127.534f);
  printf("%-15s: %+01.5G\n", "%+01.5G", 8127.534f);
  printf("%-15s: %+01.10G\n", "%+01.10G", 8127.534f);
  printf("%-15s: %+01.30G\n", "%+01.30G", 8127.534f);
  printf("%-15s: %+02G\n", "%+02G", 8127.534f);
  printf("%-15s: %+02.G\n", "%+02.G", 8127.534f);
  printf("%-15s: %+02.0G\n", "%+02.0G", 8127.534f);
  printf("%-15s: %+02.1G\n", "%+02.1G", 8127.534f);
  printf("%-15s: %+02.2G\n", "%+02.2G", 8127.534f);
  printf("%-15s: %+02.5G\n", "%+02.5G", 8127.534f);
  printf("%-15s: %+02.10G\n", "%+02.10G", 8127.534f);
  printf("%-15s: %+02.30G\n", "%+02.30G", 8127.534f);
  printf("%-15s: %+05G\n", "%+05G", 8127.534f);
  printf("%-15s: %+05.G\n", "%+05.G", 8127.534f);
  printf("%-15s: %+05.0G\n", "%+05.0G", 8127.534f);
  printf("%-15s: %+05.1G\n", "%+05.1G", 8127.534f);
  printf("%-15s: %+05.2G\n", "%+05.2G", 8127.534f);
  printf("%-15s: %+05.5G\n", "%+05.5G", 8127.534f);
  printf("%-15s: %+05.10G\n", "%+05.10G", 8127.534f);
  printf("%-15s: %+05.30G\n", "%+05.30G", 8127.534f);
  printf("%-15s: %+010G\n", "%+010G", 8127.534f);
  printf("%-15s: %+010.G\n", "%+010.G", 8127.534f);
  printf("%-15s: %+010.0G\n", "%+010.0G", 8127.534f);
  printf("%-15s: %+010.1G\n", "%+010.1G", 8127.534f);
  printf("%-15s: %+010.2G\n", "%+010.2G", 8127.534f);
  printf("%-15s: %+010.5G\n", "%+010.5G", 8127.534f);
  printf("%-15s: %+010.10G\n", "%+010.10G", 8127.534f);
  printf("%-15s: %+010.30G\n", "%+010.30G", 8127.534f);
  printf("%-15s: %+030G\n", "%+030G", 8127.534f);
  printf("%-15s: %+030.G\n", "%+030.G", 8127.534f);
  printf("%-15s: %+030.0G\n", "%+030.0G", 8127.534f);
  printf("%-15s: %+030.1G\n", "%+030.1G", 8127.534f);
  printf("%-15s: %+030.2G\n", "%+030.2G", 8127.534f);
  printf("%-15s: %+030.5G\n", "%+030.5G", 8127.534f);
  printf("%-15s: %+030.10G\n", "%+030.10G", 8127.534f);
  printf("%-15s: %+030.30G\n", "%+030.30G", 8127.534f);
  printf("%-15s: %+-G\n", "%+-G", 8127.534f);
  printf("%-15s: %+-.G\n", "%+-.G", 8127.534f);
  printf("%-15s: %+-.0G\n", "%+-.0G", 8127.534f);
  printf("%-15s: %+-.1G\n", "%+-.1G", 8127.534f);
  printf("%-15s: %+-.2G\n", "%+-.2G", 8127.534f);
  printf("%-15s: %+-.5G\n", "%+-.5G", 8127.534f);
  printf("%-15s: %+-.10G\n", "%+-.10G", 8127.534f);
  printf("%-15s: %+-.30G\n", "%+-.30G", 8127.534f);
  printf("%-15s: %+-1G\n", "%+-1G", 8127.534f);
  printf("%-15s: %+-1.G\n", "%+-1.G", 8127.534f);
  printf("%-15s: %+-1.0G\n", "%+-1.0G", 8127.534f);
  printf("%-15s: %+-1.1G\n", "%+-1.1G", 8127.534f);
  printf("%-15s: %+-1.2G\n", "%+-1.2G", 8127.534f);
  printf("%-15s: %+-1.5G\n", "%+-1.5G", 8127.534f);
  printf("%-15s: %+-1.10G\n", "%+-1.10G", 8127.534f);
  printf("%-15s: %+-1.30G\n", "%+-1.30G", 8127.534f);
  printf("%-15s: %+-2G\n", "%+-2G", 8127.534f);
  printf("%-15s: %+-2.G\n", "%+-2.G", 8127.534f);
  printf("%-15s: %+-2.0G\n", "%+-2.0G", 8127.534f);
  printf("%-15s: %+-2.1G\n", "%+-2.1G", 8127.534f);
  printf("%-15s: %+-2.2G\n", "%+-2.2G", 8127.534f);
  printf("%-15s: %+-2.5G\n", "%+-2.5G", 8127.534f);
  printf("%-15s: %+-2.10G\n", "%+-2.10G", 8127.534f);
  printf("%-15s: %+-2.30G\n", "%+-2.30G", 8127.534f);
  printf("%-15s: %+-5G\n", "%+-5G", 8127.534f);
  printf("%-15s: %+-5.G\n", "%+-5.G", 8127.534f);
  printf("%-15s: %+-5.0G\n", "%+-5.0G", 8127.534f);
  printf("%-15s: %+-5.1G\n", "%+-5.1G", 8127.534f);
  printf("%-15s: %+-5.2G\n", "%+-5.2G", 8127.534f);
  printf("%-15s: %+-5.5G\n", "%+-5.5G", 8127.534f);
  printf("%-15s: %+-5.10G\n", "%+-5.10G", 8127.534f);
  printf("%-15s: %+-5.30G\n", "%+-5.30G", 8127.534f);
  printf("%-15s: %+-10G\n", "%+-10G", 8127.534f);
  printf("%-15s: %+-10.G\n", "%+-10.G", 8127.534f);
  printf("%-15s: %+-10.0G\n", "%+-10.0G", 8127.534f);
  printf("%-15s: %+-10.1G\n", "%+-10.1G", 8127.534f);
  printf("%-15s: %+-10.2G\n", "%+-10.2G", 8127.534f);
  printf("%-15s: %+-10.5G\n", "%+-10.5G", 8127.534f);
  printf("%-15s: %+-10.10G\n", "%+-10.10G", 8127.534f);
  printf("%-15s: %+-10.30G\n", "%+-10.30G", 8127.534f);
  printf("%-15s: %+-30G\n", "%+-30G", 8127.534f);
  printf("%-15s: %+-30.G\n", "%+-30.G", 8127.534f);
  printf("%-15s: %+-30.0G\n", "%+-30.0G", 8127.534f);
  printf("%-15s: %+-30.1G\n", "%+-30.1G", 8127.534f);
  printf("%-15s: %+-30.2G\n", "%+-30.2G", 8127.534f);
  printf("%-15s: %+-30.5G\n", "%+-30.5G", 8127.534f);
  printf("%-15s: %+-30.10G\n", "%+-30.10G", 8127.534f);
  printf("%-15s: %+-30.30G\n", "%+-30.30G", 8127.534f);
  printf("%-15s: %#-G\n", "%#-G", 8127.534f);
  printf("%-15s: %#-.G\n", "%#-.G", 8127.534f);
  printf("%-15s: %#-.0G\n", "%#-.0G", 8127.534f);
  printf("%-15s: %#-.1G\n", "%#-.1G", 8127.534f);
  printf("%-15s: %#-.2G\n", "%#-.2G", 8127.534f);
  printf("%-15s: %#-.5G\n", "%#-.5G", 8127.534f);
  printf("%-15s: %#-.10G\n", "%#-.10G", 8127.534f);
  printf("%-15s: %#-.30G\n", "%#-.30G", 8127.534f);
  printf("%-15s: %#-1G\n", "%#-1G", 8127.534f);
  printf("%-15s: %#-1.G\n", "%#-1.G", 8127.534f);
  printf("%-15s: %#-1.0G\n", "%#-1.0G", 8127.534f);
  printf("%-15s: %#-1.1G\n", "%#-1.1G", 8127.534f);
  printf("%-15s: %#-1.2G\n", "%#-1.2G", 8127.534f);
  printf("%-15s: %#-1.5G\n", "%#-1.5G", 8127.534f);
  printf("%-15s: %#-1.10G\n", "%#-1.10G", 8127.534f);
  printf("%-15s: %#-1.30G\n", "%#-1.30G", 8127.534f);
  printf("%-15s: %#-2G\n", "%#-2G", 8127.534f);
  printf("%-15s: %#-2.G\n", "%#-2.G", 8127.534f);
  printf("%-15s: %#-2.0G\n", "%#-2.0G", 8127.534f);
  printf("%-15s: %#-2.1G\n", "%#-2.1G", 8127.534f);
  printf("%-15s: %#-2.2G\n", "%#-2.2G", 8127.534f);
  printf("%-15s: %#-2.5G\n", "%#-2.5G", 8127.534f);
  printf("%-15s: %#-2.10G\n", "%#-2.10G", 8127.534f);
  printf("%-15s: %#-2.30G\n", "%#-2.30G", 8127.534f);
  printf("%-15s: %#-5G\n", "%#-5G", 8127.534f);
  printf("%-15s: %#-5.G\n", "%#-5.G", 8127.534f);
  printf("%-15s: %#-5.0G\n", "%#-5.0G", 8127.534f);
  printf("%-15s: %#-5.1G\n", "%#-5.1G", 8127.534f);
  printf("%-15s: %#-5.2G\n", "%#-5.2G", 8127.534f);
  printf("%-15s: %#-5.5G\n", "%#-5.5G", 8127.534f);
  printf("%-15s: %#-5.10G\n", "%#-5.10G", 8127.534f);
  printf("%-15s: %#-5.30G\n", "%#-5.30G", 8127.534f);
  printf("%-15s: %#-10G\n", "%#-10G", 8127.534f);
  printf("%-15s: %#-10.G\n", "%#-10.G", 8127.534f);
  printf("%-15s: %#-10.0G\n", "%#-10.0G", 8127.534f);
  printf("%-15s: %#-10.1G\n", "%#-10.1G", 8127.534f);
  printf("%-15s: %#-10.2G\n", "%#-10.2G", 8127.534f);
  printf("%-15s: %#-10.5G\n", "%#-10.5G", 8127.534f);
  printf("%-15s: %#-10.10G\n", "%#-10.10G", 8127.534f);
  printf("%-15s: %#-10.30G\n", "%#-10.30G", 8127.534f);
  printf("%-15s: %#-30G\n", "%#-30G", 8127.534f);
  printf("%-15s: %#-30.G\n", "%#-30.G", 8127.534f);
  printf("%-15s: %#-30.0G\n", "%#-30.0G", 8127.534f);
  printf("%-15s: %#-30.1G\n", "%#-30.1G", 8127.534f);
  printf("%-15s: %#-30.2G\n", "%#-30.2G", 8127.534f);
  printf("%-15s: %#-30.5G\n", "%#-30.5G", 8127.534f);
  printf("%-15s: %#-30.10G\n", "%#-30.10G", 8127.534f);
  printf("%-15s: %#-30.30G\n", "%#-30.30G", 8127.534f);
  printf("%-15s: %+#G\n", "%+#G", 8127.534f);
  printf("%-15s: %+#.G\n", "%+#.G", 8127.534f);
  printf("%-15s: %+#.0G\n", "%+#.0G", 8127.534f);
  printf("%-15s: %+#.1G\n", "%+#.1G", 8127.534f);
  printf("%-15s: %+#.2G\n", "%+#.2G", 8127.534f);
  printf("%-15s: %+#.5G\n", "%+#.5G", 8127.534f);
  printf("%-15s: %+#.10G\n", "%+#.10G", 8127.534f);
  printf("%-15s: %+#.30G\n", "%+#.30G", 8127.534f);
  printf("%-15s: %+#0G\n", "%+#0G", 8127.534f);
  printf("%-15s: %+#0.G\n", "%+#0.G", 8127.534f);
  printf("%-15s: %+#0.0G\n", "%+#0.0G", 8127.534f);
  printf("%-15s: %+#0.1G\n", "%+#0.1G", 8127.534f);
  printf("%-15s: %+#0.2G\n", "%+#0.2G", 8127.534f);
  printf("%-15s: %+#0.5G\n", "%+#0.5G", 8127.534f);
  printf("%-15s: %+#0.10G\n", "%+#0.10G", 8127.534f);
  printf("%-15s: %+#0.30G\n", "%+#0.30G", 8127.534f);
  printf("%-15s: %+#1G\n", "%+#1G", 8127.534f);
  printf("%-15s: %+#1.G\n", "%+#1.G", 8127.534f);
  printf("%-15s: %+#1.0G\n", "%+#1.0G", 8127.534f);
  printf("%-15s: %+#1.1G\n", "%+#1.1G", 8127.534f);
  printf("%-15s: %+#1.2G\n", "%+#1.2G", 8127.534f);
  printf("%-15s: %+#1.5G\n", "%+#1.5G", 8127.534f);
  printf("%-15s: %+#1.10G\n", "%+#1.10G", 8127.534f);
  printf("%-15s: %+#1.30G\n", "%+#1.30G", 8127.534f);
  printf("%-15s: %+#2G\n", "%+#2G", 8127.534f);
  printf("%-15s: %+#2.G\n", "%+#2.G", 8127.534f);
  printf("%-15s: %+#2.0G\n", "%+#2.0G", 8127.534f);
  printf("%-15s: %+#2.1G\n", "%+#2.1G", 8127.534f);
  printf("%-15s: %+#2.2G\n", "%+#2.2G", 8127.534f);
  printf("%-15s: %+#2.5G\n", "%+#2.5G", 8127.534f);
  printf("%-15s: %+#2.10G\n", "%+#2.10G", 8127.534f);
  printf("%-15s: %+#2.30G\n", "%+#2.30G", 8127.534f);
  printf("%-15s: %+#5G\n", "%+#5G", 8127.534f);
  printf("%-15s: %+#5.G\n", "%+#5.G", 8127.534f);
  printf("%-15s: %+#5.0G\n", "%+#5.0G", 8127.534f);
  printf("%-15s: %+#5.1G\n", "%+#5.1G", 8127.534f);
  printf("%-15s: %+#5.2G\n", "%+#5.2G", 8127.534f);
  printf("%-15s: %+#5.5G\n", "%+#5.5G", 8127.534f);
  printf("%-15s: %+#5.10G\n", "%+#5.10G", 8127.534f);
  printf("%-15s: %+#5.30G\n", "%+#5.30G", 8127.534f);
  printf("%-15s: %+#10G\n", "%+#10G", 8127.534f);
  printf("%-15s: %+#10.G\n", "%+#10.G", 8127.534f);
  printf("%-15s: %+#10.0G\n", "%+#10.0G", 8127.534f);
  printf("%-15s: %+#10.1G\n", "%+#10.1G", 8127.534f);
  printf("%-15s: %+#10.2G\n", "%+#10.2G", 8127.534f);
  printf("%-15s: %+#10.5G\n", "%+#10.5G", 8127.534f);
  printf("%-15s: %+#10.10G\n", "%+#10.10G", 8127.534f);
  printf("%-15s: %+#10.30G\n", "%+#10.30G", 8127.534f);
  printf("%-15s: %+#30G\n", "%+#30G", 8127.534f);
  printf("%-15s: %+#30.G\n", "%+#30.G", 8127.534f);
  printf("%-15s: %+#30.0G\n", "%+#30.0G", 8127.534f);
  printf("%-15s: %+#30.1G\n", "%+#30.1G", 8127.534f);
  printf("%-15s: %+#30.2G\n", "%+#30.2G", 8127.534f);
  printf("%-15s: %+#30.5G\n", "%+#30.5G", 8127.534f);
  printf("%-15s: %+#30.10G\n", "%+#30.10G", 8127.534f);
  printf("%-15s: %+#30.30G\n", "%+#30.30G", 8127.534f);
  printf("%-15s: %-#G\n", "%-#G", 8127.534f);
  printf("%-15s: %-#.G\n", "%-#.G", 8127.534f);
  printf("%-15s: %-#.0G\n", "%-#.0G", 8127.534f);
  printf("%-15s: %-#.1G\n", "%-#.1G", 8127.534f);
  printf("%-15s: %-#.2G\n", "%-#.2G", 8127.534f);
  printf("%-15s: %-#.5G\n", "%-#.5G", 8127.534f);
  printf("%-15s: %-#.10G\n", "%-#.10G", 8127.534f);
  printf("%-15s: %-#.30G\n", "%-#.30G", 8127.534f);
  printf("%-15s: %-#1G\n", "%-#1G", 8127.534f);
  printf("%-15s: %-#1.G\n", "%-#1.G", 8127.534f);
  printf("%-15s: %-#1.0G\n", "%-#1.0G", 8127.534f);
  printf("%-15s: %-#1.1G\n", "%-#1.1G", 8127.534f);
  printf("%-15s: %-#1.2G\n", "%-#1.2G", 8127.534f);
  printf("%-15s: %-#1.5G\n", "%-#1.5G", 8127.534f);
  printf("%-15s: %-#1.10G\n", "%-#1.10G", 8127.534f);
  printf("%-15s: %-#1.30G\n", "%-#1.30G", 8127.534f);
  printf("%-15s: %-#2G\n", "%-#2G", 8127.534f);
  printf("%-15s: %-#2.G\n", "%-#2.G", 8127.534f);
  printf("%-15s: %-#2.0G\n", "%-#2.0G", 8127.534f);
  printf("%-15s: %-#2.1G\n", "%-#2.1G", 8127.534f);
  printf("%-15s: %-#2.2G\n", "%-#2.2G", 8127.534f);
  printf("%-15s: %-#2.5G\n", "%-#2.5G", 8127.534f);
  printf("%-15s: %-#2.10G\n", "%-#2.10G", 8127.534f);
  printf("%-15s: %-#2.30G\n", "%-#2.30G", 8127.534f);
  printf("%-15s: %-#5G\n", "%-#5G", 8127.534f);
  printf("%-15s: %-#5.G\n", "%-#5.G", 8127.534f);
  printf("%-15s: %-#5.0G\n", "%-#5.0G", 8127.534f);
  printf("%-15s: %-#5.1G\n", "%-#5.1G", 8127.534f);
  printf("%-15s: %-#5.2G\n", "%-#5.2G", 8127.534f);
  printf("%-15s: %-#5.5G\n", "%-#5.5G", 8127.534f);
  printf("%-15s: %-#5.10G\n", "%-#5.10G", 8127.534f);
  printf("%-15s: %-#5.30G\n", "%-#5.30G", 8127.534f);
  printf("%-15s: %-#10G\n", "%-#10G", 8127.534f);
  printf("%-15s: %-#10.G\n", "%-#10.G", 8127.534f);
  printf("%-15s: %-#10.0G\n", "%-#10.0G", 8127.534f);
  printf("%-15s: %-#10.1G\n", "%-#10.1G", 8127.534f);
  printf("%-15s: %-#10.2G\n", "%-#10.2G", 8127.534f);
  printf("%-15s: %-#10.5G\n", "%-#10.5G", 8127.534f);
  printf("%-15s: %-#10.10G\n", "%-#10.10G", 8127.534f);
  printf("%-15s: %-#10.30G\n", "%-#10.30G", 8127.534f);
  printf("%-15s: %-#30G\n", "%-#30G", 8127.534f);
  printf("%-15s: %-#30.G\n", "%-#30.G", 8127.534f);
  printf("%-15s: %-#30.0G\n", "%-#30.0G", 8127.534f);
  printf("%-15s: %-#30.1G\n", "%-#30.1G", 8127.534f);
  printf("%-15s: %-#30.2G\n", "%-#30.2G", 8127.534f);
  printf("%-15s: %-#30.5G\n", "%-#30.5G", 8127.534f);
  printf("%-15s: %-#30.10G\n", "%-#30.10G", 8127.534f);
  printf("%-15s: %-#30.30G\n", "%-#30.30G", 8127.534f);
  printf("%-15s: %0#G\n", "%0#G", 8127.534f);
  printf("%-15s: %0#.G\n", "%0#.G", 8127.534f);
  printf("%-15s: %0#.0G\n", "%0#.0G", 8127.534f);
  printf("%-15s: %0#.1G\n", "%0#.1G", 8127.534f);
  printf("%-15s: %0#.2G\n", "%0#.2G", 8127.534f);
  printf("%-15s: %0#.5G\n", "%0#.5G", 8127.534f);
  printf("%-15s: %0#.10G\n", "%0#.10G", 8127.534f);
  printf("%-15s: %0#.30G\n", "%0#.30G", 8127.534f);
  printf("%-15s: %0#1G\n", "%0#1G", 8127.534f);
  printf("%-15s: %0#1.G\n", "%0#1.G", 8127.534f);
  printf("%-15s: %0#1.0G\n", "%0#1.0G", 8127.534f);
  printf("%-15s: %0#1.1G\n", "%0#1.1G", 8127.534f);
  printf("%-15s: %0#1.2G\n", "%0#1.2G", 8127.534f);
  printf("%-15s: %0#1.5G\n", "%0#1.5G", 8127.534f);
  printf("%-15s: %0#1.10G\n", "%0#1.10G", 8127.534f);
  printf("%-15s: %0#1.30G\n", "%0#1.30G", 8127.534f);
  printf("%-15s: %0#2G\n", "%0#2G", 8127.534f);
  printf("%-15s: %0#2.G\n", "%0#2.G", 8127.534f);
  printf("%-15s: %0#2.0G\n", "%0#2.0G", 8127.534f);
  printf("%-15s: %0#2.1G\n", "%0#2.1G", 8127.534f);
  printf("%-15s: %0#2.2G\n", "%0#2.2G", 8127.534f);
  printf("%-15s: %0#2.5G\n", "%0#2.5G", 8127.534f);
  printf("%-15s: %0#2.10G\n", "%0#2.10G", 8127.534f);
  printf("%-15s: %0#2.30G\n", "%0#2.30G", 8127.534f);
  printf("%-15s: %0#5G\n", "%0#5G", 8127.534f);
  printf("%-15s: %0#5.G\n", "%0#5.G", 8127.534f);
  printf("%-15s: %0#5.0G\n", "%0#5.0G", 8127.534f);
  printf("%-15s: %0#5.1G\n", "%0#5.1G", 8127.534f);
  printf("%-15s: %0#5.2G\n", "%0#5.2G", 8127.534f);
  printf("%-15s: %0#5.5G\n", "%0#5.5G", 8127.534f);
  printf("%-15s: %0#5.10G\n", "%0#5.10G", 8127.534f);
  printf("%-15s: %0#5.30G\n", "%0#5.30G", 8127.534f);
  printf("%-15s: %0#10G\n", "%0#10G", 8127.534f);
  printf("%-15s: %0#10.G\n", "%0#10.G", 8127.534f);
  printf("%-15s: %0#10.0G\n", "%0#10.0G", 8127.534f);
  printf("%-15s: %0#10.1G\n", "%0#10.1G", 8127.534f);
  printf("%-15s: %0#10.2G\n", "%0#10.2G", 8127.534f);
  printf("%-15s: %0#10.5G\n", "%0#10.5G", 8127.534f);
  printf("%-15s: %0#10.10G\n", "%0#10.10G", 8127.534f);
  printf("%-15s: %0#10.30G\n", "%0#10.30G", 8127.534f);
  printf("%-15s: %0#30G\n", "%0#30G", 8127.534f);
  printf("%-15s: %0#30.G\n", "%0#30.G", 8127.534f);
  printf("%-15s: %0#30.0G\n", "%0#30.0G", 8127.534f);
  printf("%-15s: %0#30.1G\n", "%0#30.1G", 8127.534f);
  printf("%-15s: %0#30.2G\n", "%0#30.2G", 8127.534f);
  printf("%-15s: %0#30.5G\n", "%0#30.5G", 8127.534f);
  printf("%-15s: %0#30.10G\n", "%0#30.10G", 8127.534f);
  printf("%-15s: %0#30.30G\n", "%0#30.30G", 8127.534f);
  printf("%-15s: %+0G\n", "%+0G", 8127.534f);
  printf("%-15s: %+0.G\n", "%+0.G", 8127.534f);
  printf("%-15s: %+0.0G\n", "%+0.0G", 8127.534f);
  printf("%-15s: %+0.1G\n", "%+0.1G", 8127.534f);
  printf("%-15s: %+0.2G\n", "%+0.2G", 8127.534f);
  printf("%-15s: %+0.5G\n", "%+0.5G", 8127.534f);
  printf("%-15s: %+0.10G\n", "%+0.10G", 8127.534f);
  printf("%-15s: %+0.30G\n", "%+0.30G", 8127.534f);
  printf("%-15s: %+01G\n", "%+01G", 8127.534f);
  printf("%-15s: %+01.G\n", "%+01.G", 8127.534f);
  printf("%-15s: %+01.0G\n", "%+01.0G", 8127.534f);
  printf("%-15s: %+01.1G\n", "%+01.1G", 8127.534f);
  printf("%-15s: %+01.2G\n", "%+01.2G", 8127.534f);
  printf("%-15s: %+01.5G\n", "%+01.5G", 8127.534f);
  printf("%-15s: %+01.10G\n", "%+01.10G", 8127.534f);
  printf("%-15s: %+01.30G\n", "%+01.30G", 8127.534f);
  printf("%-15s: %+02G\n", "%+02G", 8127.534f);
  printf("%-15s: %+02.G\n", "%+02.G", 8127.534f);
  printf("%-15s: %+02.0G\n", "%+02.0G", 8127.534f);
  printf("%-15s: %+02.1G\n", "%+02.1G", 8127.534f);
  printf("%-15s: %+02.2G\n", "%+02.2G", 8127.534f);
  printf("%-15s: %+02.5G\n", "%+02.5G", 8127.534f);
  printf("%-15s: %+02.10G\n", "%+02.10G", 8127.534f);
  printf("%-15s: %+02.30G\n", "%+02.30G", 8127.534f);
  printf("%-15s: %+05G\n", "%+05G", 8127.534f);
  printf("%-15s: %+05.G\n", "%+05.G", 8127.534f);
  printf("%-15s: %+05.0G\n", "%+05.0G", 8127.534f);
  printf("%-15s: %+05.1G\n", "%+05.1G", 8127.534f);
  printf("%-15s: %+05.2G\n", "%+05.2G", 8127.534f);
  printf("%-15s: %+05.5G\n", "%+05.5G", 8127.534f);
  printf("%-15s: %+05.10G\n", "%+05.10G", 8127.534f);
  printf("%-15s: %+05.30G\n", "%+05.30G", 8127.534f);
  printf("%-15s: %+010G\n", "%+010G", 8127.534f);
  printf("%-15s: %+010.G\n", "%+010.G", 8127.534f);
  printf("%-15s: %+010.0G\n", "%+010.0G", 8127.534f);
  printf("%-15s: %+010.1G\n", "%+010.1G", 8127.534f);
  printf("%-15s: %+010.2G\n", "%+010.2G", 8127.534f);
  printf("%-15s: %+010.5G\n", "%+010.5G", 8127.534f);
  printf("%-15s: %+010.10G\n", "%+010.10G", 8127.534f);
  printf("%-15s: %+010.30G\n", "%+010.30G", 8127.534f);
  printf("%-15s: %+030G\n", "%+030G", 8127.534f);
  printf("%-15s: %+030.G\n", "%+030.G", 8127.534f);
  printf("%-15s: %+030.0G\n", "%+030.0G", 8127.534f);
  printf("%-15s: %+030.1G\n", "%+030.1G", 8127.534f);
  printf("%-15s: %+030.2G\n", "%+030.2G", 8127.534f);
  printf("%-15s: %+030.5G\n", "%+030.5G", 8127.534f);
  printf("%-15s: %+030.10G\n", "%+030.10G", 8127.534f);
  printf("%-15s: %+030.30G\n", "%+030.30G", 8127.534f);
  printf("%-15s: %#0G\n", "%#0G", 8127.534f);
  printf("%-15s: %#0.G\n", "%#0.G", 8127.534f);
  printf("%-15s: %#0.0G\n", "%#0.0G", 8127.534f);
  printf("%-15s: %#0.1G\n", "%#0.1G", 8127.534f);
  printf("%-15s: %#0.2G\n", "%#0.2G", 8127.534f);
  printf("%-15s: %#0.5G\n", "%#0.5G", 8127.534f);
  printf("%-15s: %#0.10G\n", "%#0.10G", 8127.534f);
  printf("%-15s: %#0.30G\n", "%#0.30G", 8127.534f);
  printf("%-15s: %#01G\n", "%#01G", 8127.534f);
  printf("%-15s: %#01.G\n", "%#01.G", 8127.534f);
  printf("%-15s: %#01.0G\n", "%#01.0G", 8127.534f);
  printf("%-15s: %#01.1G\n", "%#01.1G", 8127.534f);
  printf("%-15s: %#01.2G\n", "%#01.2G", 8127.534f);
  printf("%-15s: %#01.5G\n", "%#01.5G", 8127.534f);
  printf("%-15s: %#01.10G\n", "%#01.10G", 8127.534f);
  printf("%-15s: %#01.30G\n", "%#01.30G", 8127.534f);
  printf("%-15s: %#02G\n", "%#02G", 8127.534f);
  printf("%-15s: %#02.G\n", "%#02.G", 8127.534f);
  printf("%-15s: %#02.0G\n", "%#02.0G", 8127.534f);
  printf("%-15s: %#02.1G\n", "%#02.1G", 8127.534f);
  printf("%-15s: %#02.2G\n", "%#02.2G", 8127.534f);
  printf("%-15s: %#02.5G\n", "%#02.5G", 8127.534f);
  printf("%-15s: %#02.10G\n", "%#02.10G", 8127.534f);
  printf("%-15s: %#02.30G\n", "%#02.30G", 8127.534f);
  printf("%-15s: %#05G\n", "%#05G", 8127.534f);
  printf("%-15s: %#05.G\n", "%#05.G", 8127.534f);
  printf("%-15s: %#05.0G\n", "%#05.0G", 8127.534f);
  printf("%-15s: %#05.1G\n", "%#05.1G", 8127.534f);
  printf("%-15s: %#05.2G\n", "%#05.2G", 8127.534f);
  printf("%-15s: %#05.5G\n", "%#05.5G", 8127.534f);
  printf("%-15s: %#05.10G\n", "%#05.10G", 8127.534f);
  printf("%-15s: %#05.30G\n", "%#05.30G", 8127.534f);
  printf("%-15s: %#010G\n", "%#010G", 8127.534f);
  printf("%-15s: %#010.G\n", "%#010.G", 8127.534f);
  printf("%-15s: %#010.0G\n", "%#010.0G", 8127.534f);
  printf("%-15s: %#010.1G\n", "%#010.1G", 8127.534f);
  printf("%-15s: %#010.2G\n", "%#010.2G", 8127.534f);
  printf("%-15s: %#010.5G\n", "%#010.5G", 8127.534f);
  printf("%-15s: %#010.10G\n", "%#010.10G", 8127.534f);
  printf("%-15s: %#010.30G\n", "%#010.30G", 8127.534f);
  printf("%-15s: %#030G\n", "%#030G", 8127.534f);
  printf("%-15s: %#030.G\n", "%#030.G", 8127.534f);
  printf("%-15s: %#030.0G\n", "%#030.0G", 8127.534f);
  printf("%-15s: %#030.1G\n", "%#030.1G", 8127.534f);
  printf("%-15s: %#030.2G\n", "%#030.2G", 8127.534f);
  printf("%-15s: %#030.5G\n", "%#030.5G", 8127.534f);
  printf("%-15s: %#030.10G\n", "%#030.10G", 8127.534f);
  printf("%-15s: %#030.30G\n", "%#030.30G", 8127.534f);
  printf("%-15s: %-+#G\n", "%-+#G", 8127.534f);
  printf("%-15s: %-+#.G\n", "%-+#.G", 8127.534f);
  printf("%-15s: %-+#.0G\n", "%-+#.0G", 8127.534f);
  printf("%-15s: %-+#.1G\n", "%-+#.1G", 8127.534f);
  printf("%-15s: %-+#.2G\n", "%-+#.2G", 8127.534f);
  printf("%-15s: %-+#.5G\n", "%-+#.5G", 8127.534f);
  printf("%-15s: %-+#.10G\n", "%-+#.10G", 8127.534f);
  printf("%-15s: %-+#.30G\n", "%-+#.30G", 8127.534f);
  printf("%-15s: %-+#1G\n", "%-+#1G", 8127.534f);
  printf("%-15s: %-+#1.G\n", "%-+#1.G", 8127.534f);
  printf("%-15s: %-+#1.0G\n", "%-+#1.0G", 8127.534f);
  printf("%-15s: %-+#1.1G\n", "%-+#1.1G", 8127.534f);
  printf("%-15s: %-+#1.2G\n", "%-+#1.2G", 8127.534f);
  printf("%-15s: %-+#1.5G\n", "%-+#1.5G", 8127.534f);
  printf("%-15s: %-+#1.10G\n", "%-+#1.10G", 8127.534f);
  printf("%-15s: %-+#1.30G\n", "%-+#1.30G", 8127.534f);
  printf("%-15s: %-+#2G\n", "%-+#2G", 8127.534f);
  printf("%-15s: %-+#2.G\n", "%-+#2.G", 8127.534f);
  printf("%-15s: %-+#2.0G\n", "%-+#2.0G", 8127.534f);
  printf("%-15s: %-+#2.1G\n", "%-+#2.1G", 8127.534f);
  printf("%-15s: %-+#2.2G\n", "%-+#2.2G", 8127.534f);
  printf("%-15s: %-+#2.5G\n", "%-+#2.5G", 8127.534f);
  printf("%-15s: %-+#2.10G\n", "%-+#2.10G", 8127.534f);
  printf("%-15s: %-+#2.30G\n", "%-+#2.30G", 8127.534f);
  printf("%-15s: %-+#5G\n", "%-+#5G", 8127.534f);
  printf("%-15s: %-+#5.G\n", "%-+#5.G", 8127.534f);
  printf("%-15s: %-+#5.0G\n", "%-+#5.0G", 8127.534f);
  printf("%-15s: %-+#5.1G\n", "%-+#5.1G", 8127.534f);
  printf("%-15s: %-+#5.2G\n", "%-+#5.2G", 8127.534f);
  printf("%-15s: %-+#5.5G\n", "%-+#5.5G", 8127.534f);
  printf("%-15s: %-+#5.10G\n", "%-+#5.10G", 8127.534f);
  printf("%-15s: %-+#5.30G\n", "%-+#5.30G", 8127.534f);
  printf("%-15s: %-+#10G\n", "%-+#10G", 8127.534f);
  printf("%-15s: %-+#10.G\n", "%-+#10.G", 8127.534f);
  printf("%-15s: %-+#10.0G\n", "%-+#10.0G", 8127.534f);
  printf("%-15s: %-+#10.1G\n", "%-+#10.1G", 8127.534f);
  printf("%-15s: %-+#10.2G\n", "%-+#10.2G", 8127.534f);
  printf("%-15s: %-+#10.5G\n", "%-+#10.5G", 8127.534f);
  printf("%-15s: %-+#10.10G\n", "%-+#10.10G", 8127.534f);
  printf("%-15s: %-+#10.30G\n", "%-+#10.30G", 8127.534f);
  printf("%-15s: %-+#30G\n", "%-+#30G", 8127.534f);
  printf("%-15s: %-+#30.G\n", "%-+#30.G", 8127.534f);
  printf("%-15s: %-+#30.0G\n", "%-+#30.0G", 8127.534f);
  printf("%-15s: %-+#30.1G\n", "%-+#30.1G", 8127.534f);
  printf("%-15s: %-+#30.2G\n", "%-+#30.2G", 8127.534f);
  printf("%-15s: %-+#30.5G\n", "%-+#30.5G", 8127.534f);
  printf("%-15s: %-+#30.10G\n", "%-+#30.10G", 8127.534f);
  printf("%-15s: %-+#30.30G\n", "%-+#30.30G", 8127.534f);
  printf("%-15s: %0+#G\n", "%0+#G", 8127.534f);
  printf("%-15s: %0+#.G\n", "%0+#.G", 8127.534f);
  printf("%-15s: %0+#.0G\n", "%0+#.0G", 8127.534f);
  printf("%-15s: %0+#.1G\n", "%0+#.1G", 8127.534f);
  printf("%-15s: %0+#.2G\n", "%0+#.2G", 8127.534f);
  printf("%-15s: %0+#.5G\n", "%0+#.5G", 8127.534f);
  printf("%-15s: %0+#.10G\n", "%0+#.10G", 8127.534f);
  printf("%-15s: %0+#.30G\n", "%0+#.30G", 8127.534f);
  printf("%-15s: %0+#1G\n", "%0+#1G", 8127.534f);
  printf("%-15s: %0+#1.G\n", "%0+#1.G", 8127.534f);
  printf("%-15s: %0+#1.0G\n", "%0+#1.0G", 8127.534f);
  printf("%-15s: %0+#1.1G\n", "%0+#1.1G", 8127.534f);
  printf("%-15s: %0+#1.2G\n", "%0+#1.2G", 8127.534f);
  printf("%-15s: %0+#1.5G\n", "%0+#1.5G", 8127.534f);
  printf("%-15s: %0+#1.10G\n", "%0+#1.10G", 8127.534f);
  printf("%-15s: %0+#1.30G\n", "%0+#1.30G", 8127.534f);
  printf("%-15s: %0+#2G\n", "%0+#2G", 8127.534f);
  printf("%-15s: %0+#2.G\n", "%0+#2.G", 8127.534f);
  printf("%-15s: %0+#2.0G\n", "%0+#2.0G", 8127.534f);
  printf("%-15s: %0+#2.1G\n", "%0+#2.1G", 8127.534f);
  printf("%-15s: %0+#2.2G\n", "%0+#2.2G", 8127.534f);
  printf("%-15s: %0+#2.5G\n", "%0+#2.5G", 8127.534f);
  printf("%-15s: %0+#2.10G\n", "%0+#2.10G", 8127.534f);
  printf("%-15s: %0+#2.30G\n", "%0+#2.30G", 8127.534f);
  printf("%-15s: %0+#5G\n", "%0+#5G", 8127.534f);
  printf("%-15s: %0+#5.G\n", "%0+#5.G", 8127.534f);
  printf("%-15s: %0+#5.0G\n", "%0+#5.0G", 8127.534f);
  printf("%-15s: %0+#5.1G\n", "%0+#5.1G", 8127.534f);
  printf("%-15s: %0+#5.2G\n", "%0+#5.2G", 8127.534f);
  printf("%-15s: %0+#5.5G\n", "%0+#5.5G", 8127.534f);
  printf("%-15s: %0+#5.10G\n", "%0+#5.10G", 8127.534f);
  printf("%-15s: %0+#5.30G\n", "%0+#5.30G", 8127.534f);
  printf("%-15s: %0+#10G\n", "%0+#10G", 8127.534f);
  printf("%-15s: %0+#10.G\n", "%0+#10.G", 8127.534f);
  printf("%-15s: %0+#10.0G\n", "%0+#10.0G", 8127.534f);
  printf("%-15s: %0+#10.1G\n", "%0+#10.1G", 8127.534f);
  printf("%-15s: %0+#10.2G\n", "%0+#10.2G", 8127.534f);
  printf("%-15s: %0+#10.5G\n", "%0+#10.5G", 8127.534f);
  printf("%-15s: %0+#10.10G\n", "%0+#10.10G", 8127.534f);
  printf("%-15s: %0+#10.30G\n", "%0+#10.30G", 8127.534f);
  printf("%-15s: %0+#30G\n", "%0+#30G", 8127.534f);
  printf("%-15s: %0+#30.G\n", "%0+#30.G", 8127.534f);
  printf("%-15s: %0+#30.0G\n", "%0+#30.0G", 8127.534f);
  printf("%-15s: %0+#30.1G\n", "%0+#30.1G", 8127.534f);
  printf("%-15s: %0+#30.2G\n", "%0+#30.2G", 8127.534f);
  printf("%-15s: %0+#30.5G\n", "%0+#30.5G", 8127.534f);
  printf("%-15s: %0+#30.10G\n", "%0+#30.10G", 8127.534f);
  printf("%-15s: %0+#30.30G\n", "%0+#30.30G", 8127.534f);
  printf("%-15s: %#-+G\n", "%#-+G", 8127.534f);
  printf("%-15s: %#-+.G\n", "%#-+.G", 8127.534f);
  printf("%-15s: %#-+.0G\n", "%#-+.0G", 8127.534f);
  printf("%-15s: %#-+.1G\n", "%#-+.1G", 8127.534f);
  printf("%-15s: %#-+.2G\n", "%#-+.2G", 8127.534f);
  printf("%-15s: %#-+.5G\n", "%#-+.5G", 8127.534f);
  printf("%-15s: %#-+.10G\n", "%#-+.10G", 8127.534f);
  printf("%-15s: %#-+.30G\n", "%#-+.30G", 8127.534f);
  printf("%-15s: %#-+1G\n", "%#-+1G", 8127.534f);
  printf("%-15s: %#-+1.G\n", "%#-+1.G", 8127.534f);
  printf("%-15s: %#-+1.0G\n", "%#-+1.0G", 8127.534f);
  printf("%-15s: %#-+1.1G\n", "%#-+1.1G", 8127.534f);
  printf("%-15s: %#-+1.2G\n", "%#-+1.2G", 8127.534f);
  printf("%-15s: %#-+1.5G\n", "%#-+1.5G", 8127.534f);
  printf("%-15s: %#-+1.10G\n", "%#-+1.10G", 8127.534f);
  printf("%-15s: %#-+1.30G\n", "%#-+1.30G", 8127.534f);
  printf("%-15s: %#-+2G\n", "%#-+2G", 8127.534f);
  printf("%-15s: %#-+2.G\n", "%#-+2.G", 8127.534f);
  printf("%-15s: %#-+2.0G\n", "%#-+2.0G", 8127.534f);
  printf("%-15s: %#-+2.1G\n", "%#-+2.1G", 8127.534f);
  printf("%-15s: %#-+2.2G\n", "%#-+2.2G", 8127.534f);
  printf("%-15s: %#-+2.5G\n", "%#-+2.5G", 8127.534f);
  printf("%-15s: %#-+2.10G\n", "%#-+2.10G", 8127.534f);
  printf("%-15s: %#-+2.30G\n", "%#-+2.30G", 8127.534f);
  printf("%-15s: %#-+5G\n", "%#-+5G", 8127.534f);
  printf("%-15s: %#-+5.G\n", "%#-+5.G", 8127.534f);
  printf("%-15s: %#-+5.0G\n", "%#-+5.0G", 8127.534f);
  printf("%-15s: %#-+5.1G\n", "%#-+5.1G", 8127.534f);
  printf("%-15s: %#-+5.2G\n", "%#-+5.2G", 8127.534f);
  printf("%-15s: %#-+5.5G\n", "%#-+5.5G", 8127.534f);
  printf("%-15s: %#-+5.10G\n", "%#-+5.10G", 8127.534f);
  printf("%-15s: %#-+5.30G\n", "%#-+5.30G", 8127.534f);
  printf("%-15s: %#-+10G\n", "%#-+10G", 8127.534f);
  printf("%-15s: %#-+10.G\n", "%#-+10.G", 8127.534f);
  printf("%-15s: %#-+10.0G\n", "%#-+10.0G", 8127.534f);
  printf("%-15s: %#-+10.1G\n", "%#-+10.1G", 8127.534f);
  printf("%-15s: %#-+10.2G\n", "%#-+10.2G", 8127.534f);
  printf("%-15s: %#-+10.5G\n", "%#-+10.5G", 8127.534f);
  printf("%-15s: %#-+10.10G\n", "%#-+10.10G", 8127.534f);
  printf("%-15s: %#-+10.30G\n", "%#-+10.30G", 8127.534f);
  printf("%-15s: %#-+30G\n", "%#-+30G", 8127.534f);
  printf("%-15s: %#-+30.G\n", "%#-+30.G", 8127.534f);
  printf("%-15s: %#-+30.0G\n", "%#-+30.0G", 8127.534f);
  printf("%-15s: %#-+30.1G\n", "%#-+30.1G", 8127.534f);
  printf("%-15s: %#-+30.2G\n", "%#-+30.2G", 8127.534f);
  printf("%-15s: %#-+30.5G\n", "%#-+30.5G", 8127.534f);
  printf("%-15s: %#-+30.10G\n", "%#-+30.10G", 8127.534f);
  printf("%-15s: %#-+30.30G\n", "%#-+30.30G", 8127.534f);
  printf("%-15s: %+#-G\n", "%+#-G", 8127.534f);
  printf("%-15s: %+#-.G\n", "%+#-.G", 8127.534f);
  printf("%-15s: %+#-.0G\n", "%+#-.0G", 8127.534f);
  printf("%-15s: %+#-.1G\n", "%+#-.1G", 8127.534f);
  printf("%-15s: %+#-.2G\n", "%+#-.2G", 8127.534f);
  printf("%-15s: %+#-.5G\n", "%+#-.5G", 8127.534f);
  printf("%-15s: %+#-.10G\n", "%+#-.10G", 8127.534f);
  printf("%-15s: %+#-.30G\n", "%+#-.30G", 8127.534f);
  printf("%-15s: %+#-1G\n", "%+#-1G", 8127.534f);
  printf("%-15s: %+#-1.G\n", "%+#-1.G", 8127.534f);
  printf("%-15s: %+#-1.0G\n", "%+#-1.0G", 8127.534f);
  printf("%-15s: %+#-1.1G\n", "%+#-1.1G", 8127.534f);
  printf("%-15s: %+#-1.2G\n", "%+#-1.2G", 8127.534f);
  printf("%-15s: %+#-1.5G\n", "%+#-1.5G", 8127.534f);
  printf("%-15s: %+#-1.10G\n", "%+#-1.10G", 8127.534f);
  printf("%-15s: %+#-1.30G\n", "%+#-1.30G", 8127.534f);
  printf("%-15s: %+#-2G\n", "%+#-2G", 8127.534f);
  printf("%-15s: %+#-2.G\n", "%+#-2.G", 8127.534f);
  printf("%-15s: %+#-2.0G\n", "%+#-2.0G", 8127.534f);
  printf("%-15s: %+#-2.1G\n", "%+#-2.1G", 8127.534f);
  printf("%-15s: %+#-2.2G\n", "%+#-2.2G", 8127.534f);
  printf("%-15s: %+#-2.5G\n", "%+#-2.5G", 8127.534f);
  printf("%-15s: %+#-2.10G\n", "%+#-2.10G", 8127.534f);
  printf("%-15s: %+#-2.30G\n", "%+#-2.30G", 8127.534f);
  printf("%-15s: %+#-5G\n", "%+#-5G", 8127.534f);
  printf("%-15s: %+#-5.G\n", "%+#-5.G", 8127.534f);
  printf("%-15s: %+#-5.0G\n", "%+#-5.0G", 8127.534f);
  printf("%-15s: %+#-5.1G\n", "%+#-5.1G", 8127.534f);
  printf("%-15s: %+#-5.2G\n", "%+#-5.2G", 8127.534f);
  printf("%-15s: %+#-5.5G\n", "%+#-5.5G", 8127.534f);
  printf("%-15s: %+#-5.10G\n", "%+#-5.10G", 8127.534f);
  printf("%-15s: %+#-5.30G\n", "%+#-5.30G", 8127.534f);
  printf("%-15s: %+#-10G\n", "%+#-10G", 8127.534f);
  printf("%-15s: %+#-10.G\n", "%+#-10.G", 8127.534f);
  printf("%-15s: %+#-10.0G\n", "%+#-10.0G", 8127.534f);
  printf("%-15s: %+#-10.1G\n", "%+#-10.1G", 8127.534f);
  printf("%-15s: %+#-10.2G\n", "%+#-10.2G", 8127.534f);
  printf("%-15s: %+#-10.5G\n", "%+#-10.5G", 8127.534f);
  printf("%-15s: %+#-10.10G\n", "%+#-10.10G", 8127.534f);
  printf("%-15s: %+#-10.30G\n", "%+#-10.30G", 8127.534f);
  printf("%-15s: %+#-30G\n", "%+#-30G", 8127.534f);
  printf("%-15s: %+#-30.G\n", "%+#-30.G", 8127.534f);
  printf("%-15s: %+#-30.0G\n", "%+#-30.0G", 8127.534f);
  printf("%-15s: %+#-30.1G\n", "%+#-30.1G", 8127.534f);
  printf("%-15s: %+#-30.2G\n", "%+#-30.2G", 8127.534f);
  printf("%-15s: %+#-30.5G\n", "%+#-30.5G", 8127.534f);
  printf("%-15s: %+#-30.10G\n", "%+#-30.10G", 8127.534f);
  printf("%-15s: %+#-30.30G\n", "%+#-30.30G", 8127.534f);
  printf("%-15s: %-x\n", "%-x", 8127534);
  printf("%-15s: %-.x\n", "%-.x", 8127534);
  printf("%-15s: %-.0x\n", "%-.0x", 8127534);
  printf("%-15s: %-.1x\n", "%-.1x", 8127534);
  printf("%-15s: %-.2x\n", "%-.2x", 8127534);
  printf("%-15s: %-.5x\n", "%-.5x", 8127534);
  printf("%-15s: %-.10x\n", "%-.10x", 8127534);
  printf("%-15s: %-.30x\n", "%-.30x", 8127534);
  printf("%-15s: %-1x\n", "%-1x", 8127534);
  printf("%-15s: %-1.x\n", "%-1.x", 8127534);
  printf("%-15s: %-1.0x\n", "%-1.0x", 8127534);
  printf("%-15s: %-1.1x\n", "%-1.1x", 8127534);
  printf("%-15s: %-1.2x\n", "%-1.2x", 8127534);
  printf("%-15s: %-1.5x\n", "%-1.5x", 8127534);
  printf("%-15s: %-1.10x\n", "%-1.10x", 8127534);
  printf("%-15s: %-1.30x\n", "%-1.30x", 8127534);
  printf("%-15s: %-2x\n", "%-2x", 8127534);
  printf("%-15s: %-2.x\n", "%-2.x", 8127534);
  printf("%-15s: %-2.0x\n", "%-2.0x", 8127534);
  printf("%-15s: %-2.1x\n", "%-2.1x", 8127534);
  printf("%-15s: %-2.2x\n", "%-2.2x", 8127534);
  printf("%-15s: %-2.5x\n", "%-2.5x", 8127534);
  printf("%-15s: %-2.10x\n", "%-2.10x", 8127534);
  printf("%-15s: %-2.30x\n", "%-2.30x", 8127534);
  printf("%-15s: %-5x\n", "%-5x", 8127534);
  printf("%-15s: %-5.x\n", "%-5.x", 8127534);
  printf("%-15s: %-5.0x\n", "%-5.0x", 8127534);
  printf("%-15s: %-5.1x\n", "%-5.1x", 8127534);
  printf("%-15s: %-5.2x\n", "%-5.2x", 8127534);
  printf("%-15s: %-5.5x\n", "%-5.5x", 8127534);
  printf("%-15s: %-5.10x\n", "%-5.10x", 8127534);
  printf("%-15s: %-5.30x\n", "%-5.30x", 8127534);
  printf("%-15s: %-10x\n", "%-10x", 8127534);
  printf("%-15s: %-10.x\n", "%-10.x", 8127534);
  printf("%-15s: %-10.0x\n", "%-10.0x", 8127534);
  printf("%-15s: %-10.1x\n", "%-10.1x", 8127534);
  printf("%-15s: %-10.2x\n", "%-10.2x", 8127534);
  printf("%-15s: %-10.5x\n", "%-10.5x", 8127534);
  printf("%-15s: %-10.10x\n", "%-10.10x", 8127534);
  printf("%-15s: %-10.30x\n", "%-10.30x", 8127534);
  printf("%-15s: %-30x\n", "%-30x", 8127534);
  printf("%-15s: %-30.x\n", "%-30.x", 8127534);
  printf("%-15s: %-30.0x\n", "%-30.0x", 8127534);
  printf("%-15s: %-30.1x\n", "%-30.1x", 8127534);
  printf("%-15s: %-30.2x\n", "%-30.2x", 8127534);
  printf("%-15s: %-30.5x\n", "%-30.5x", 8127534);
  printf("%-15s: %-30.10x\n", "%-30.10x", 8127534);
  printf("%-15s: %-30.30x\n", "%-30.30x", 8127534);
  printf("%-15s: %#x\n", "%#x", 8127534);
  printf("%-15s: %#.x\n", "%#.x", 8127534);
  printf("%-15s: %#.0x\n", "%#.0x", 8127534);
  printf("%-15s: %#.1x\n", "%#.1x", 8127534);
  printf("%-15s: %#.2x\n", "%#.2x", 8127534);
  printf("%-15s: %#.5x\n", "%#.5x", 8127534);
  printf("%-15s: %#.10x\n", "%#.10x", 8127534);
  printf("%-15s: %#.30x\n", "%#.30x", 8127534);
  printf("%-15s: %#0x\n", "%#0x", 8127534);
  printf("%-15s: %#1x\n", "%#1x", 8127534);
  printf("%-15s: %#1.x\n", "%#1.x", 8127534);
  printf("%-15s: %#1.0x\n", "%#1.0x", 8127534);
  printf("%-15s: %#1.1x\n", "%#1.1x", 8127534);
  printf("%-15s: %#1.2x\n", "%#1.2x", 8127534);
  printf("%-15s: %#1.5x\n", "%#1.5x", 8127534);
  printf("%-15s: %#1.10x\n", "%#1.10x", 8127534);
  printf("%-15s: %#1.30x\n", "%#1.30x", 8127534);
  printf("%-15s: %#2x\n", "%#2x", 8127534);
  printf("%-15s: %#2.x\n", "%#2.x", 8127534);
  printf("%-15s: %#2.0x\n", "%#2.0x", 8127534);
  printf("%-15s: %#2.1x\n", "%#2.1x", 8127534);
  printf("%-15s: %#2.2x\n", "%#2.2x", 8127534);
  printf("%-15s: %#2.5x\n", "%#2.5x", 8127534);
  printf("%-15s: %#2.10x\n", "%#2.10x", 8127534);
  printf("%-15s: %#2.30x\n", "%#2.30x", 8127534);
  printf("%-15s: %#5x\n", "%#5x", 8127534);
  printf("%-15s: %#5.x\n", "%#5.x", 8127534);
  printf("%-15s: %#5.0x\n", "%#5.0x", 8127534);
  printf("%-15s: %#5.1x\n", "%#5.1x", 8127534);
  printf("%-15s: %#5.2x\n", "%#5.2x", 8127534);
  printf("%-15s: %#5.5x\n", "%#5.5x", 8127534);
  printf("%-15s: %#5.10x\n", "%#5.10x", 8127534);
  printf("%-15s: %#5.30x\n", "%#5.30x", 8127534);
  printf("%-15s: %#10x\n", "%#10x", 8127534);
  printf("%-15s: %#10.x\n", "%#10.x", 8127534);
  printf("%-15s: %#10.0x\n", "%#10.0x", 8127534);
  printf("%-15s: %#10.1x\n", "%#10.1x", 8127534);
  printf("%-15s: %#10.2x\n", "%#10.2x", 8127534);
  printf("%-15s: %#10.5x\n", "%#10.5x", 8127534);
  printf("%-15s: %#10.10x\n", "%#10.10x", 8127534);
  printf("%-15s: %#10.30x\n", "%#10.30x", 8127534);
  printf("%-15s: %#30x\n", "%#30x", 8127534);
  printf("%-15s: %#30.x\n", "%#30.x", 8127534);
  printf("%-15s: %#30.0x\n", "%#30.0x", 8127534);
  printf("%-15s: %#30.1x\n", "%#30.1x", 8127534);
  printf("%-15s: %#30.2x\n", "%#30.2x", 8127534);
  printf("%-15s: %#30.5x\n", "%#30.5x", 8127534);
  printf("%-15s: %#30.10x\n", "%#30.10x", 8127534);
  printf("%-15s: %#30.30x\n", "%#30.30x", 8127534);
  printf("%-15s: %0x\n", "%0x", 8127534);
  printf("%-15s: %01x\n", "%01x", 8127534);
  printf("%-15s: %02x\n", "%02x", 8127534);
  printf("%-15s: %05x\n", "%05x", 8127534);
  printf("%-15s: %010x\n", "%010x", 8127534);
  printf("%-15s: %030x\n", "%030x", 8127534);
  printf("%-15s: %#-x\n", "%#-x", 8127534);
  printf("%-15s: %#-.x\n", "%#-.x", 8127534);
  printf("%-15s: %#-.0x\n", "%#-.0x", 8127534);
  printf("%-15s: %#-.1x\n", "%#-.1x", 8127534);
  printf("%-15s: %#-.2x\n", "%#-.2x", 8127534);
  printf("%-15s: %#-.5x\n", "%#-.5x", 8127534);
  printf("%-15s: %#-.10x\n", "%#-.10x", 8127534);
  printf("%-15s: %#-.30x\n", "%#-.30x", 8127534);
  printf("%-15s: %#-1x\n", "%#-1x", 8127534);
  printf("%-15s: %#-1.x\n", "%#-1.x", 8127534);
  printf("%-15s: %#-1.0x\n", "%#-1.0x", 8127534);
  printf("%-15s: %#-1.1x\n", "%#-1.1x", 8127534);
  printf("%-15s: %#-1.2x\n", "%#-1.2x", 8127534);
  printf("%-15s: %#-1.5x\n", "%#-1.5x", 8127534);
  printf("%-15s: %#-1.10x\n", "%#-1.10x", 8127534);
  printf("%-15s: %#-1.30x\n", "%#-1.30x", 8127534);
  printf("%-15s: %#-2x\n", "%#-2x", 8127534);
  printf("%-15s: %#-2.x\n", "%#-2.x", 8127534);
  printf("%-15s: %#-2.0x\n", "%#-2.0x", 8127534);
  printf("%-15s: %#-2.1x\n", "%#-2.1x", 8127534);
  printf("%-15s: %#-2.2x\n", "%#-2.2x", 8127534);
  printf("%-15s: %#-2.5x\n", "%#-2.5x", 8127534);
  printf("%-15s: %#-2.10x\n", "%#-2.10x", 8127534);
  printf("%-15s: %#-2.30x\n", "%#-2.30x", 8127534);
  printf("%-15s: %#-5x\n", "%#-5x", 8127534);
  printf("%-15s: %#-5.x\n", "%#-5.x", 8127534);
  printf("%-15s: %#-5.0x\n", "%#-5.0x", 8127534);
  printf("%-15s: %#-5.1x\n", "%#-5.1x", 8127534);
  printf("%-15s: %#-5.2x\n", "%#-5.2x", 8127534);
  printf("%-15s: %#-5.5x\n", "%#-5.5x", 8127534);
  printf("%-15s: %#-5.10x\n", "%#-5.10x", 8127534);
  printf("%-15s: %#-5.30x\n", "%#-5.30x", 8127534);
  printf("%-15s: %#-10x\n", "%#-10x", 8127534);
  printf("%-15s: %#-10.x\n", "%#-10.x", 8127534);
  printf("%-15s: %#-10.0x\n", "%#-10.0x", 8127534);
  printf("%-15s: %#-10.1x\n", "%#-10.1x", 8127534);
  printf("%-15s: %#-10.2x\n", "%#-10.2x", 8127534);
  printf("%-15s: %#-10.5x\n", "%#-10.5x", 8127534);
  printf("%-15s: %#-10.10x\n", "%#-10.10x", 8127534);
  printf("%-15s: %#-10.30x\n", "%#-10.30x", 8127534);
  printf("%-15s: %#-30x\n", "%#-30x", 8127534);
  printf("%-15s: %#-30.x\n", "%#-30.x", 8127534);
  printf("%-15s: %#-30.0x\n", "%#-30.0x", 8127534);
  printf("%-15s: %#-30.1x\n", "%#-30.1x", 8127534);
  printf("%-15s: %#-30.2x\n", "%#-30.2x", 8127534);
  printf("%-15s: %#-30.5x\n", "%#-30.5x", 8127534);
  printf("%-15s: %#-30.10x\n", "%#-30.10x", 8127534);
  printf("%-15s: %#-30.30x\n", "%#-30.30x", 8127534);
  printf("%-15s: %-#x\n", "%-#x", 8127534);
  printf("%-15s: %-#.x\n", "%-#.x", 8127534);
  printf("%-15s: %-#.0x\n", "%-#.0x", 8127534);
  printf("%-15s: %-#.1x\n", "%-#.1x", 8127534);
  printf("%-15s: %-#.2x\n", "%-#.2x", 8127534);
  printf("%-15s: %-#.5x\n", "%-#.5x", 8127534);
  printf("%-15s: %-#.10x\n", "%-#.10x", 8127534);
  printf("%-15s: %-#.30x\n", "%-#.30x", 8127534);
  printf("%-15s: %-#1x\n", "%-#1x", 8127534);
  printf("%-15s: %-#1.x\n", "%-#1.x", 8127534);
  printf("%-15s: %-#1.0x\n", "%-#1.0x", 8127534);
  printf("%-15s: %-#1.1x\n", "%-#1.1x", 8127534);
  printf("%-15s: %-#1.2x\n", "%-#1.2x", 8127534);
  printf("%-15s: %-#1.5x\n", "%-#1.5x", 8127534);
  printf("%-15s: %-#1.10x\n", "%-#1.10x", 8127534);
  printf("%-15s: %-#1.30x\n", "%-#1.30x", 8127534);
  printf("%-15s: %-#2x\n", "%-#2x", 8127534);
  printf("%-15s: %-#2.x\n", "%-#2.x", 8127534);
  printf("%-15s: %-#2.0x\n", "%-#2.0x", 8127534);
  printf("%-15s: %-#2.1x\n", "%-#2.1x", 8127534);
  printf("%-15s: %-#2.2x\n", "%-#2.2x", 8127534);
  printf("%-15s: %-#2.5x\n", "%-#2.5x", 8127534);
  printf("%-15s: %-#2.10x\n", "%-#2.10x", 8127534);
  printf("%-15s: %-#2.30x\n", "%-#2.30x", 8127534);
  printf("%-15s: %-#5x\n", "%-#5x", 8127534);
  printf("%-15s: %-#5.x\n", "%-#5.x", 8127534);
  printf("%-15s: %-#5.0x\n", "%-#5.0x", 8127534);
  printf("%-15s: %-#5.1x\n", "%-#5.1x", 8127534);
  printf("%-15s: %-#5.2x\n", "%-#5.2x", 8127534);
  printf("%-15s: %-#5.5x\n", "%-#5.5x", 8127534);
  printf("%-15s: %-#5.10x\n", "%-#5.10x", 8127534);
  printf("%-15s: %-#5.30x\n", "%-#5.30x", 8127534);
  printf("%-15s: %-#10x\n", "%-#10x", 8127534);
  printf("%-15s: %-#10.x\n", "%-#10.x", 8127534);
  printf("%-15s: %-#10.0x\n", "%-#10.0x", 8127534);
  printf("%-15s: %-#10.1x\n", "%-#10.1x", 8127534);
  printf("%-15s: %-#10.2x\n", "%-#10.2x", 8127534);
  printf("%-15s: %-#10.5x\n", "%-#10.5x", 8127534);
  printf("%-15s: %-#10.10x\n", "%-#10.10x", 8127534);
  printf("%-15s: %-#10.30x\n", "%-#10.30x", 8127534);
  printf("%-15s: %-#30x\n", "%-#30x", 8127534);
  printf("%-15s: %-#30.x\n", "%-#30.x", 8127534);
  printf("%-15s: %-#30.0x\n", "%-#30.0x", 8127534);
  printf("%-15s: %-#30.1x\n", "%-#30.1x", 8127534);
  printf("%-15s: %-#30.2x\n", "%-#30.2x", 8127534);
  printf("%-15s: %-#30.5x\n", "%-#30.5x", 8127534);
  printf("%-15s: %-#30.10x\n", "%-#30.10x", 8127534);
  printf("%-15s: %-#30.30x\n", "%-#30.30x", 8127534);
  printf("%-15s: %0#x\n", "%0#x", 8127534);
  printf("%-15s: %0#1x\n", "%0#1x", 8127534);
  printf("%-15s: %0#2x\n", "%0#2x", 8127534);
  printf("%-15s: %0#5x\n", "%0#5x", 8127534);
  printf("%-15s: %0#10x\n", "%0#10x", 8127534);
  printf("%-15s: %0#30x\n", "%0#30x", 8127534);
  printf("%-15s: %#0x\n", "%#0x", 8127534);
  printf("%-15s: %#01x\n", "%#01x", 8127534);
  printf("%-15s: %#02x\n", "%#02x", 8127534);
  printf("%-15s: %#05x\n", "%#05x", 8127534);
  printf("%-15s: %#010x\n", "%#010x", 8127534);
  printf("%-15s: %#030x\n", "%#030x", 8127534);
  printf("%-15s: %-X\n", "%-X", 8127534);
  printf("%-15s: %-.X\n", "%-.X", 8127534);
  printf("%-15s: %-.0X\n", "%-.0X", 8127534);
  printf("%-15s: %-.1X\n", "%-.1X", 8127534);
  printf("%-15s: %-.2X\n", "%-.2X", 8127534);
  printf("%-15s: %-.5X\n", "%-.5X", 8127534);
  printf("%-15s: %-.10X\n", "%-.10X", 8127534);
  printf("%-15s: %-.30X\n", "%-.30X", 8127534);
  printf("%-15s: %-1X\n", "%-1X", 8127534);
  printf("%-15s: %-1.X\n", "%-1.X", 8127534);
  printf("%-15s: %-1.0X\n", "%-1.0X", 8127534);
  printf("%-15s: %-1.1X\n", "%-1.1X", 8127534);
  printf("%-15s: %-1.2X\n", "%-1.2X", 8127534);
  printf("%-15s: %-1.5X\n", "%-1.5X", 8127534);
  printf("%-15s: %-1.10X\n", "%-1.10X", 8127534);
  printf("%-15s: %-1.30X\n", "%-1.30X", 8127534);
  printf("%-15s: %-2X\n", "%-2X", 8127534);
  printf("%-15s: %-2.X\n", "%-2.X", 8127534);
  printf("%-15s: %-2.0X\n", "%-2.0X", 8127534);
  printf("%-15s: %-2.1X\n", "%-2.1X", 8127534);
  printf("%-15s: %-2.2X\n", "%-2.2X", 8127534);
  printf("%-15s: %-2.5X\n", "%-2.5X", 8127534);
  printf("%-15s: %-2.10X\n", "%-2.10X", 8127534);
  printf("%-15s: %-2.30X\n", "%-2.30X", 8127534);
  printf("%-15s: %-5X\n", "%-5X", 8127534);
  printf("%-15s: %-5.X\n", "%-5.X", 8127534);
  printf("%-15s: %-5.0X\n", "%-5.0X", 8127534);
  printf("%-15s: %-5.1X\n", "%-5.1X", 8127534);
  printf("%-15s: %-5.2X\n", "%-5.2X", 8127534);
  printf("%-15s: %-5.5X\n", "%-5.5X", 8127534);
  printf("%-15s: %-5.10X\n", "%-5.10X", 8127534);
  printf("%-15s: %-5.30X\n", "%-5.30X", 8127534);
  printf("%-15s: %-10X\n", "%-10X", 8127534);
  printf("%-15s: %-10.X\n", "%-10.X", 8127534);
  printf("%-15s: %-10.0X\n", "%-10.0X", 8127534);
  printf("%-15s: %-10.1X\n", "%-10.1X", 8127534);
  printf("%-15s: %-10.2X\n", "%-10.2X", 8127534);
  printf("%-15s: %-10.5X\n", "%-10.5X", 8127534);
  printf("%-15s: %-10.10X\n", "%-10.10X", 8127534);
  printf("%-15s: %-10.30X\n", "%-10.30X", 8127534);
  printf("%-15s: %-30X\n", "%-30X", 8127534);
  printf("%-15s: %-30.X\n", "%-30.X", 8127534);
  printf("%-15s: %-30.0X\n", "%-30.0X", 8127534);
  printf("%-15s: %-30.1X\n", "%-30.1X", 8127534);
  printf("%-15s: %-30.2X\n", "%-30.2X", 8127534);
  printf("%-15s: %-30.5X\n", "%-30.5X", 8127534);
  printf("%-15s: %-30.10X\n", "%-30.10X", 8127534);
  printf("%-15s: %-30.30X\n", "%-30.30X", 8127534);
  printf("%-15s: %#X\n", "%#X", 8127534);
  printf("%-15s: %#.X\n", "%#.X", 8127534);
  printf("%-15s: %#.0X\n", "%#.0X", 8127534);
  printf("%-15s: %#.1X\n", "%#.1X", 8127534);
  printf("%-15s: %#.2X\n", "%#.2X", 8127534);
  printf("%-15s: %#.5X\n", "%#.5X", 8127534);
  printf("%-15s: %#.10X\n", "%#.10X", 8127534);
  printf("%-15s: %#.30X\n", "%#.30X", 8127534);
  printf("%-15s: %#0X\n", "%#0X", 8127534);
  printf("%-15s: %#1X\n", "%#1X", 8127534);
  printf("%-15s: %#1.X\n", "%#1.X", 8127534);
  printf("%-15s: %#1.0X\n", "%#1.0X", 8127534);
  printf("%-15s: %#1.1X\n", "%#1.1X", 8127534);
  printf("%-15s: %#1.2X\n", "%#1.2X", 8127534);
  printf("%-15s: %#1.5X\n", "%#1.5X", 8127534);
  printf("%-15s: %#1.10X\n", "%#1.10X", 8127534);
  printf("%-15s: %#1.30X\n", "%#1.30X", 8127534);
  printf("%-15s: %#2X\n", "%#2X", 8127534);
  printf("%-15s: %#2.X\n", "%#2.X", 8127534);
  printf("%-15s: %#2.0X\n", "%#2.0X", 8127534);
  printf("%-15s: %#2.1X\n", "%#2.1X", 8127534);
  printf("%-15s: %#2.2X\n", "%#2.2X", 8127534);
  printf("%-15s: %#2.5X\n", "%#2.5X", 8127534);
  printf("%-15s: %#2.10X\n", "%#2.10X", 8127534);
  printf("%-15s: %#2.30X\n", "%#2.30X", 8127534);
  printf("%-15s: %#5X\n", "%#5X", 8127534);
  printf("%-15s: %#5.X\n", "%#5.X", 8127534);
  printf("%-15s: %#5.0X\n", "%#5.0X", 8127534);
  printf("%-15s: %#5.1X\n", "%#5.1X", 8127534);
  printf("%-15s: %#5.2X\n", "%#5.2X", 8127534);
  printf("%-15s: %#5.5X\n", "%#5.5X", 8127534);
  printf("%-15s: %#5.10X\n", "%#5.10X", 8127534);
  printf("%-15s: %#5.30X\n", "%#5.30X", 8127534);
  printf("%-15s: %#10X\n", "%#10X", 8127534);
  printf("%-15s: %#10.X\n", "%#10.X", 8127534);
  printf("%-15s: %#10.0X\n", "%#10.0X", 8127534);
  printf("%-15s: %#10.1X\n", "%#10.1X", 8127534);
  printf("%-15s: %#10.2X\n", "%#10.2X", 8127534);
  printf("%-15s: %#10.5X\n", "%#10.5X", 8127534);
  printf("%-15s: %#10.10X\n", "%#10.10X", 8127534);
  printf("%-15s: %#10.30X\n", "%#10.30X", 8127534);
  printf("%-15s: %#30X\n", "%#30X", 8127534);
  printf("%-15s: %#30.X\n", "%#30.X", 8127534);
  printf("%-15s: %#30.0X\n", "%#30.0X", 8127534);
  printf("%-15s: %#30.1X\n", "%#30.1X", 8127534);
  printf("%-15s: %#30.2X\n", "%#30.2X", 8127534);
  printf("%-15s: %#30.5X\n", "%#30.5X", 8127534);
  printf("%-15s: %#30.10X\n", "%#30.10X", 8127534);
  printf("%-15s: %#30.30X\n", "%#30.30X", 8127534);
  printf("%-15s: %0X\n", "%0X", 8127534);
  printf("%-15s: %01X\n", "%01X", 8127534);
  printf("%-15s: %02X\n", "%02X", 8127534);
  printf("%-15s: %05X\n", "%05X", 8127534);
  printf("%-15s: %010X\n", "%010X", 8127534);
  printf("%-15s: %030X\n", "%030X", 8127534);
  printf("%-15s: %#-X\n", "%#-X", 8127534);
  printf("%-15s: %#-.X\n", "%#-.X", 8127534);
  printf("%-15s: %#-.0X\n", "%#-.0X", 8127534);
  printf("%-15s: %#-.1X\n", "%#-.1X", 8127534);
  printf("%-15s: %#-.2X\n", "%#-.2X", 8127534);
  printf("%-15s: %#-.5X\n", "%#-.5X", 8127534);
  printf("%-15s: %#-.10X\n", "%#-.10X", 8127534);
  printf("%-15s: %#-.30X\n", "%#-.30X", 8127534);
  printf("%-15s: %#-1X\n", "%#-1X", 8127534);
  printf("%-15s: %#-1.X\n", "%#-1.X", 8127534);
  printf("%-15s: %#-1.0X\n", "%#-1.0X", 8127534);
  printf("%-15s: %#-1.1X\n", "%#-1.1X", 8127534);
  printf("%-15s: %#-1.2X\n", "%#-1.2X", 8127534);
  printf("%-15s: %#-1.5X\n", "%#-1.5X", 8127534);
  printf("%-15s: %#-1.10X\n", "%#-1.10X", 8127534);
  printf("%-15s: %#-1.30X\n", "%#-1.30X", 8127534);
  printf("%-15s: %#-2X\n", "%#-2X", 8127534);
  printf("%-15s: %#-2.X\n", "%#-2.X", 8127534);
  printf("%-15s: %#-2.0X\n", "%#-2.0X", 8127534);
  printf("%-15s: %#-2.1X\n", "%#-2.1X", 8127534);
  printf("%-15s: %#-2.2X\n", "%#-2.2X", 8127534);
  printf("%-15s: %#-2.5X\n", "%#-2.5X", 8127534);
  printf("%-15s: %#-2.10X\n", "%#-2.10X", 8127534);
  printf("%-15s: %#-2.30X\n", "%#-2.30X", 8127534);
  printf("%-15s: %#-5X\n", "%#-5X", 8127534);
  printf("%-15s: %#-5.X\n", "%#-5.X", 8127534);
  printf("%-15s: %#-5.0X\n", "%#-5.0X", 8127534);
  printf("%-15s: %#-5.1X\n", "%#-5.1X", 8127534);
  printf("%-15s: %#-5.2X\n", "%#-5.2X", 8127534);
  printf("%-15s: %#-5.5X\n", "%#-5.5X", 8127534);
  printf("%-15s: %#-5.10X\n", "%#-5.10X", 8127534);
  printf("%-15s: %#-5.30X\n", "%#-5.30X", 8127534);
  printf("%-15s: %#-10X\n", "%#-10X", 8127534);
  printf("%-15s: %#-10.X\n", "%#-10.X", 8127534);
  printf("%-15s: %#-10.0X\n", "%#-10.0X", 8127534);
  printf("%-15s: %#-10.1X\n", "%#-10.1X", 8127534);
  printf("%-15s: %#-10.2X\n", "%#-10.2X", 8127534);
  printf("%-15s: %#-10.5X\n", "%#-10.5X", 8127534);
  printf("%-15s: %#-10.10X\n", "%#-10.10X", 8127534);
  printf("%-15s: %#-10.30X\n", "%#-10.30X", 8127534);
  printf("%-15s: %#-30X\n", "%#-30X", 8127534);
  printf("%-15s: %#-30.X\n", "%#-30.X", 8127534);
  printf("%-15s: %#-30.0X\n", "%#-30.0X", 8127534);
  printf("%-15s: %#-30.1X\n", "%#-30.1X", 8127534);
  printf("%-15s: %#-30.2X\n", "%#-30.2X", 8127534);
  printf("%-15s: %#-30.5X\n", "%#-30.5X", 8127534);
  printf("%-15s: %#-30.10X\n", "%#-30.10X", 8127534);
  printf("%-15s: %#-30.30X\n", "%#-30.30X", 8127534);
  printf("%-15s: %-#X\n", "%-#X", 8127534);
  printf("%-15s: %-#.X\n", "%-#.X", 8127534);
  printf("%-15s: %-#.0X\n", "%-#.0X", 8127534);
  printf("%-15s: %-#.1X\n", "%-#.1X", 8127534);
  printf("%-15s: %-#.2X\n", "%-#.2X", 8127534);
  printf("%-15s: %-#.5X\n", "%-#.5X", 8127534);
  printf("%-15s: %-#.10X\n", "%-#.10X", 8127534);
  printf("%-15s: %-#.30X\n", "%-#.30X", 8127534);
  printf("%-15s: %-#1X\n", "%-#1X", 8127534);
  printf("%-15s: %-#1.X\n", "%-#1.X", 8127534);
  printf("%-15s: %-#1.0X\n", "%-#1.0X", 8127534);
  printf("%-15s: %-#1.1X\n", "%-#1.1X", 8127534);
  printf("%-15s: %-#1.2X\n", "%-#1.2X", 8127534);
  printf("%-15s: %-#1.5X\n", "%-#1.5X", 8127534);
  printf("%-15s: %-#1.10X\n", "%-#1.10X", 8127534);
  printf("%-15s: %-#1.30X\n", "%-#1.30X", 8127534);
  printf("%-15s: %-#2X\n", "%-#2X", 8127534);
  printf("%-15s: %-#2.X\n", "%-#2.X", 8127534);
  printf("%-15s: %-#2.0X\n", "%-#2.0X", 8127534);
  printf("%-15s: %-#2.1X\n", "%-#2.1X", 8127534);
  printf("%-15s: %-#2.2X\n", "%-#2.2X", 8127534);
  printf("%-15s: %-#2.5X\n", "%-#2.5X", 8127534);
  printf("%-15s: %-#2.10X\n", "%-#2.10X", 8127534);
  printf("%-15s: %-#2.30X\n", "%-#2.30X", 8127534);
  printf("%-15s: %-#5X\n", "%-#5X", 8127534);
  printf("%-15s: %-#5.X\n", "%-#5.X", 8127534);
  printf("%-15s: %-#5.0X\n", "%-#5.0X", 8127534);
  printf("%-15s: %-#5.1X\n", "%-#5.1X", 8127534);
  printf("%-15s: %-#5.2X\n", "%-#5.2X", 8127534);
  printf("%-15s: %-#5.5X\n", "%-#5.5X", 8127534);
  printf("%-15s: %-#5.10X\n", "%-#5.10X", 8127534);
  printf("%-15s: %-#5.30X\n", "%-#5.30X", 8127534);
  printf("%-15s: %-#10X\n", "%-#10X", 8127534);
  printf("%-15s: %-#10.X\n", "%-#10.X", 8127534);
  printf("%-15s: %-#10.0X\n", "%-#10.0X", 8127534);
  printf("%-15s: %-#10.1X\n", "%-#10.1X", 8127534);
  printf("%-15s: %-#10.2X\n", "%-#10.2X", 8127534);
  printf("%-15s: %-#10.5X\n", "%-#10.5X", 8127534);
  printf("%-15s: %-#10.10X\n", "%-#10.10X", 8127534);
  printf("%-15s: %-#10.30X\n", "%-#10.30X", 8127534);
  printf("%-15s: %-#30X\n", "%-#30X", 8127534);
  printf("%-15s: %-#30.X\n", "%-#30.X", 8127534);
  printf("%-15s: %-#30.0X\n", "%-#30.0X", 8127534);
  printf("%-15s: %-#30.1X\n", "%-#30.1X", 8127534);
  printf("%-15s: %-#30.2X\n", "%-#30.2X", 8127534);
  printf("%-15s: %-#30.5X\n", "%-#30.5X", 8127534);
  printf("%-15s: %-#30.10X\n", "%-#30.10X", 8127534);
  printf("%-15s: %-#30.30X\n", "%-#30.30X", 8127534);
  printf("%-15s: %0#X\n", "%0#X", 8127534);
  printf("%-15s: %0#1X\n", "%0#1X", 8127534);
  printf("%-15s: %0#2X\n", "%0#2X", 8127534);
  printf("%-15s: %0#5X\n", "%0#5X", 8127534);
  printf("%-15s: %0#10X\n", "%0#10X", 8127534);
  printf("%-15s: %0#30X\n", "%0#30X", 8127534);
  printf("%-15s: %#0X\n", "%#0X", 8127534);
  printf("%-15s: %#01X\n", "%#01X", 8127534);
  printf("%-15s: %#02X\n", "%#02X", 8127534);
  printf("%-15s: %#05X\n", "%#05X", 8127534);
  printf("%-15s: %#010X\n", "%#010X", 8127534);
  printf("%-15s: %#030X\n", "%#030X", 8127534);
  printf("%-15s: %-o\n", "%-o", 8127534);
  printf("%-15s: %-.o\n", "%-.o", 8127534);
  printf("%-15s: %-.0o\n", "%-.0o", 8127534);
  printf("%-15s: %-.1o\n", "%-.1o", 8127534);
  printf("%-15s: %-.2o\n", "%-.2o", 8127534);
  printf("%-15s: %-.5o\n", "%-.5o", 8127534);
  printf("%-15s: %-.10o\n", "%-.10o", 8127534);
  printf("%-15s: %-.30o\n", "%-.30o", 8127534);
  printf("%-15s: %-1o\n", "%-1o", 8127534);
  printf("%-15s: %-1.o\n", "%-1.o", 8127534);
  printf("%-15s: %-1.0o\n", "%-1.0o", 8127534);
  printf("%-15s: %-1.1o\n", "%-1.1o", 8127534);
  printf("%-15s: %-1.2o\n", "%-1.2o", 8127534);
  printf("%-15s: %-1.5o\n", "%-1.5o", 8127534);
  printf("%-15s: %-1.10o\n", "%-1.10o", 8127534);
  printf("%-15s: %-1.30o\n", "%-1.30o", 8127534);
  printf("%-15s: %-2o\n", "%-2o", 8127534);
  printf("%-15s: %-2.o\n", "%-2.o", 8127534);
  printf("%-15s: %-2.0o\n", "%-2.0o", 8127534);
  printf("%-15s: %-2.1o\n", "%-2.1o", 8127534);
  printf("%-15s: %-2.2o\n", "%-2.2o", 8127534);
  printf("%-15s: %-2.5o\n", "%-2.5o", 8127534);
  printf("%-15s: %-2.10o\n", "%-2.10o", 8127534);
  printf("%-15s: %-2.30o\n", "%-2.30o", 8127534);
  printf("%-15s: %-5o\n", "%-5o", 8127534);
  printf("%-15s: %-5.o\n", "%-5.o", 8127534);
  printf("%-15s: %-5.0o\n", "%-5.0o", 8127534);
  printf("%-15s: %-5.1o\n", "%-5.1o", 8127534);
  printf("%-15s: %-5.2o\n", "%-5.2o", 8127534);
  printf("%-15s: %-5.5o\n", "%-5.5o", 8127534);
  printf("%-15s: %-5.10o\n", "%-5.10o", 8127534);
  printf("%-15s: %-5.30o\n", "%-5.30o", 8127534);
  printf("%-15s: %-10o\n", "%-10o", 8127534);
  printf("%-15s: %-10.o\n", "%-10.o", 8127534);
  printf("%-15s: %-10.0o\n", "%-10.0o", 8127534);
  printf("%-15s: %-10.1o\n", "%-10.1o", 8127534);
  printf("%-15s: %-10.2o\n", "%-10.2o", 8127534);
  printf("%-15s: %-10.5o\n", "%-10.5o", 8127534);
  printf("%-15s: %-10.10o\n", "%-10.10o", 8127534);
  printf("%-15s: %-10.30o\n", "%-10.30o", 8127534);
  printf("%-15s: %-30o\n", "%-30o", 8127534);
  printf("%-15s: %-30.o\n", "%-30.o", 8127534);
  printf("%-15s: %-30.0o\n", "%-30.0o", 8127534);
  printf("%-15s: %-30.1o\n", "%-30.1o", 8127534);
  printf("%-15s: %-30.2o\n", "%-30.2o", 8127534);
  printf("%-15s: %-30.5o\n", "%-30.5o", 8127534);
  printf("%-15s: %-30.10o\n", "%-30.10o", 8127534);
  printf("%-15s: %-30.30o\n", "%-30.30o", 8127534);
  printf("%-15s: %#o\n", "%#o", 8127534);
  printf("%-15s: %#.o\n", "%#.o", 8127534);
  printf("%-15s: %#.0o\n", "%#.0o", 8127534);
  printf("%-15s: %#.1o\n", "%#.1o", 8127534);
  printf("%-15s: %#.2o\n", "%#.2o", 8127534);
  printf("%-15s: %#.5o\n", "%#.5o", 8127534);
  printf("%-15s: %#.10o\n", "%#.10o", 8127534);
  printf("%-15s: %#.30o\n", "%#.30o", 8127534);
  printf("%-15s: %#0o\n", "%#0o", 8127534);
  printf("%-15s: %#1o\n", "%#1o", 8127534);
  printf("%-15s: %#1.o\n", "%#1.o", 8127534);
  printf("%-15s: %#1.0o\n", "%#1.0o", 8127534);
  printf("%-15s: %#1.1o\n", "%#1.1o", 8127534);
  printf("%-15s: %#1.2o\n", "%#1.2o", 8127534);
  printf("%-15s: %#1.5o\n", "%#1.5o", 8127534);
  printf("%-15s: %#1.10o\n", "%#1.10o", 8127534);
  printf("%-15s: %#1.30o\n", "%#1.30o", 8127534);
  printf("%-15s: %#2o\n", "%#2o", 8127534);
  printf("%-15s: %#2.o\n", "%#2.o", 8127534);
  printf("%-15s: %#2.0o\n", "%#2.0o", 8127534);
  printf("%-15s: %#2.1o\n", "%#2.1o", 8127534);
  printf("%-15s: %#2.2o\n", "%#2.2o", 8127534);
  printf("%-15s: %#2.5o\n", "%#2.5o", 8127534);
  printf("%-15s: %#2.10o\n", "%#2.10o", 8127534);
  printf("%-15s: %#2.30o\n", "%#2.30o", 8127534);
  printf("%-15s: %#5o\n", "%#5o", 8127534);
  printf("%-15s: %#5.o\n", "%#5.o", 8127534);
  printf("%-15s: %#5.0o\n", "%#5.0o", 8127534);
  printf("%-15s: %#5.1o\n", "%#5.1o", 8127534);
  printf("%-15s: %#5.2o\n", "%#5.2o", 8127534);
  printf("%-15s: %#5.5o\n", "%#5.5o", 8127534);
  printf("%-15s: %#5.10o\n", "%#5.10o", 8127534);
  printf("%-15s: %#5.30o\n", "%#5.30o", 8127534);
  printf("%-15s: %#10o\n", "%#10o", 8127534);
  printf("%-15s: %#10.o\n", "%#10.o", 8127534);
  printf("%-15s: %#10.0o\n", "%#10.0o", 8127534);
  printf("%-15s: %#10.1o\n", "%#10.1o", 8127534);
  printf("%-15s: %#10.2o\n", "%#10.2o", 8127534);
  printf("%-15s: %#10.5o\n", "%#10.5o", 8127534);
  printf("%-15s: %#10.10o\n", "%#10.10o", 8127534);
  printf("%-15s: %#10.30o\n", "%#10.30o", 8127534);
  printf("%-15s: %#30o\n", "%#30o", 8127534);
  printf("%-15s: %#30.o\n", "%#30.o", 8127534);
  printf("%-15s: %#30.0o\n", "%#30.0o", 8127534);
  printf("%-15s: %#30.1o\n", "%#30.1o", 8127534);
  printf("%-15s: %#30.2o\n", "%#30.2o", 8127534);
  printf("%-15s: %#30.5o\n", "%#30.5o", 8127534);
  printf("%-15s: %#30.10o\n", "%#30.10o", 8127534);
  printf("%-15s: %#30.30o\n", "%#30.30o", 8127534);
  printf("%-15s: %0o\n", "%0o", 8127534);
  printf("%-15s: %01o\n", "%01o", 8127534);
  printf("%-15s: %02o\n", "%02o", 8127534);
  printf("%-15s: %05o\n", "%05o", 8127534);
  printf("%-15s: %010o\n", "%010o", 8127534);
  printf("%-15s: %030o\n", "%030o", 8127534);
  printf("%-15s: %#-o\n", "%#-o", 8127534);
  printf("%-15s: %#-.o\n", "%#-.o", 8127534);
  printf("%-15s: %#-.0o\n", "%#-.0o", 8127534);
  printf("%-15s: %#-.1o\n", "%#-.1o", 8127534);
  printf("%-15s: %#-.2o\n", "%#-.2o", 8127534);
  printf("%-15s: %#-.5o\n", "%#-.5o", 8127534);
  printf("%-15s: %#-.10o\n", "%#-.10o", 8127534);
  printf("%-15s: %#-.30o\n", "%#-.30o", 8127534);
  printf("%-15s: %#-1o\n", "%#-1o", 8127534);
  printf("%-15s: %#-1.o\n", "%#-1.o", 8127534);
  printf("%-15s: %#-1.0o\n", "%#-1.0o", 8127534);
  printf("%-15s: %#-1.1o\n", "%#-1.1o", 8127534);
  printf("%-15s: %#-1.2o\n", "%#-1.2o", 8127534);
  printf("%-15s: %#-1.5o\n", "%#-1.5o", 8127534);
  printf("%-15s: %#-1.10o\n", "%#-1.10o", 8127534);
  printf("%-15s: %#-1.30o\n", "%#-1.30o", 8127534);
  printf("%-15s: %#-2o\n", "%#-2o", 8127534);
  printf("%-15s: %#-2.o\n", "%#-2.o", 8127534);
  printf("%-15s: %#-2.0o\n", "%#-2.0o", 8127534);
  printf("%-15s: %#-2.1o\n", "%#-2.1o", 8127534);
  printf("%-15s: %#-2.2o\n", "%#-2.2o", 8127534);
  printf("%-15s: %#-2.5o\n", "%#-2.5o", 8127534);
  printf("%-15s: %#-2.10o\n", "%#-2.10o", 8127534);
  printf("%-15s: %#-2.30o\n", "%#-2.30o", 8127534);
  printf("%-15s: %#-5o\n", "%#-5o", 8127534);
  printf("%-15s: %#-5.o\n", "%#-5.o", 8127534);
  printf("%-15s: %#-5.0o\n", "%#-5.0o", 8127534);
  printf("%-15s: %#-5.1o\n", "%#-5.1o", 8127534);
  printf("%-15s: %#-5.2o\n", "%#-5.2o", 8127534);
  printf("%-15s: %#-5.5o\n", "%#-5.5o", 8127534);
  printf("%-15s: %#-5.10o\n", "%#-5.10o", 8127534);
  printf("%-15s: %#-5.30o\n", "%#-5.30o", 8127534);
  printf("%-15s: %#-10o\n", "%#-10o", 8127534);
  printf("%-15s: %#-10.o\n", "%#-10.o", 8127534);
  printf("%-15s: %#-10.0o\n", "%#-10.0o", 8127534);
  printf("%-15s: %#-10.1o\n", "%#-10.1o", 8127534);
  printf("%-15s: %#-10.2o\n", "%#-10.2o", 8127534);
  printf("%-15s: %#-10.5o\n", "%#-10.5o", 8127534);
  printf("%-15s: %#-10.10o\n", "%#-10.10o", 8127534);
  printf("%-15s: %#-10.30o\n", "%#-10.30o", 8127534);
  printf("%-15s: %#-30o\n", "%#-30o", 8127534);
  printf("%-15s: %#-30.o\n", "%#-30.o", 8127534);
  printf("%-15s: %#-30.0o\n", "%#-30.0o", 8127534);
  printf("%-15s: %#-30.1o\n", "%#-30.1o", 8127534);
  printf("%-15s: %#-30.2o\n", "%#-30.2o", 8127534);
  printf("%-15s: %#-30.5o\n", "%#-30.5o", 8127534);
  printf("%-15s: %#-30.10o\n", "%#-30.10o", 8127534);
  printf("%-15s: %#-30.30o\n", "%#-30.30o", 8127534);
  printf("%-15s: %-#o\n", "%-#o", 8127534);
  printf("%-15s: %-#.o\n", "%-#.o", 8127534);
  printf("%-15s: %-#.0o\n", "%-#.0o", 8127534);
  printf("%-15s: %-#.1o\n", "%-#.1o", 8127534);
  printf("%-15s: %-#.2o\n", "%-#.2o", 8127534);
  printf("%-15s: %-#.5o\n", "%-#.5o", 8127534);
  printf("%-15s: %-#.10o\n", "%-#.10o", 8127534);
  printf("%-15s: %-#.30o\n", "%-#.30o", 8127534);
  printf("%-15s: %-#1o\n", "%-#1o", 8127534);
  printf("%-15s: %-#1.o\n", "%-#1.o", 8127534);
  printf("%-15s: %-#1.0o\n", "%-#1.0o", 8127534);
  printf("%-15s: %-#1.1o\n", "%-#1.1o", 8127534);
  printf("%-15s: %-#1.2o\n", "%-#1.2o", 8127534);
  printf("%-15s: %-#1.5o\n", "%-#1.5o", 8127534);
  printf("%-15s: %-#1.10o\n", "%-#1.10o", 8127534);
  printf("%-15s: %-#1.30o\n", "%-#1.30o", 8127534);
  printf("%-15s: %-#2o\n", "%-#2o", 8127534);
  printf("%-15s: %-#2.o\n", "%-#2.o", 8127534);
  printf("%-15s: %-#2.0o\n", "%-#2.0o", 8127534);
  printf("%-15s: %-#2.1o\n", "%-#2.1o", 8127534);
  printf("%-15s: %-#2.2o\n", "%-#2.2o", 8127534);
  printf("%-15s: %-#2.5o\n", "%-#2.5o", 8127534);
  printf("%-15s: %-#2.10o\n", "%-#2.10o", 8127534);
  printf("%-15s: %-#2.30o\n", "%-#2.30o", 8127534);
  printf("%-15s: %-#5o\n", "%-#5o", 8127534);
  printf("%-15s: %-#5.o\n", "%-#5.o", 8127534);
  printf("%-15s: %-#5.0o\n", "%-#5.0o", 8127534);
  printf("%-15s: %-#5.1o\n", "%-#5.1o", 8127534);
  printf("%-15s: %-#5.2o\n", "%-#5.2o", 8127534);
  printf("%-15s: %-#5.5o\n", "%-#5.5o", 8127534);
  printf("%-15s: %-#5.10o\n", "%-#5.10o", 8127534);
  printf("%-15s: %-#5.30o\n", "%-#5.30o", 8127534);
  printf("%-15s: %-#10o\n", "%-#10o", 8127534);
  printf("%-15s: %-#10.o\n", "%-#10.o", 8127534);
  printf("%-15s: %-#10.0o\n", "%-#10.0o", 8127534);
  printf("%-15s: %-#10.1o\n", "%-#10.1o", 8127534);
  printf("%-15s: %-#10.2o\n", "%-#10.2o", 8127534);
  printf("%-15s: %-#10.5o\n", "%-#10.5o", 8127534);
  printf("%-15s: %-#10.10o\n", "%-#10.10o", 8127534);
  printf("%-15s: %-#10.30o\n", "%-#10.30o", 8127534);
  printf("%-15s: %-#30o\n", "%-#30o", 8127534);
  printf("%-15s: %-#30.o\n", "%-#30.o", 8127534);
  printf("%-15s: %-#30.0o\n", "%-#30.0o", 8127534);
  printf("%-15s: %-#30.1o\n", "%-#30.1o", 8127534);
  printf("%-15s: %-#30.2o\n", "%-#30.2o", 8127534);
  printf("%-15s: %-#30.5o\n", "%-#30.5o", 8127534);
  printf("%-15s: %-#30.10o\n", "%-#30.10o", 8127534);
  printf("%-15s: %-#30.30o\n", "%-#30.30o", 8127534);
  printf("%-15s: %0#o\n", "%0#o", 8127534);
  printf("%-15s: %0#1o\n", "%0#1o", 8127534);
  printf("%-15s: %0#2o\n", "%0#2o", 8127534);
  printf("%-15s: %0#5o\n", "%0#5o", 8127534);
  printf("%-15s: %#0o\n", "%#0o", 8127534);
  printf("%-15s: %#01o\n", "%#01o", 8127534);
  printf("%-15s: %#02o\n", "%#02o", 8127534);
  printf("%-15s: %#05o\n", "%#05o", 8127534);
  printf("%-15s: %010o\n", "%010o", 8127534);
  printf("%-15s: %030o\n", "%030o", 8127534);
  printf("-break--\n");
  printf("%-15s: %-s\n", "%-s", "test");
  printf("%-15s: %-.s\n", "%-.s", "test");
  printf("%-15s: %-.0s\n", "%-.0s", "test");
  printf("%-15s: %-.1s\n", "%-.1s", "test");
  printf("%-15s: %-.2s\n", "%-.2s", "test");
  printf("%-15s: %-.5s\n", "%-.5s", "test");
  printf("%-15s: %-.10s\n", "%-.10s", "test");
  printf("%-15s: %-.30s\n", "%-.30s", "test");
  printf("%-15s: %-1s\n", "%-1s", "test");
  printf("%-15s: %-1.s\n", "%-1.s", "test");
  printf("%-15s: %-1.0s\n", "%-1.0s", "test");
  printf("%-15s: %-1.1s\n", "%-1.1s", "test");
  printf("%-15s: %-1.2s\n", "%-1.2s", "test");
  printf("%-15s: %-1.5s\n", "%-1.5s", "test");
  printf("%-15s: %-1.10s\n", "%-1.10s", "test");
  printf("%-15s: %-1.30s\n", "%-1.30s", "test");
  printf("%-15s: %-2s\n", "%-2s", "test");
  printf("%-15s: %-2.s\n", "%-2.s", "test");
  printf("%-15s: %-2.0s\n", "%-2.0s", "test");
  printf("%-15s: %-2.1s\n", "%-2.1s", "test");
  printf("%-15s: %-2.2s\n", "%-2.2s", "test");
  printf("%-15s: %-2.5s\n", "%-2.5s", "test");
  printf("%-15s: %-2.10s\n", "%-2.10s", "test");
  printf("%-15s: %-2.30s\n", "%-2.30s", "test");
  printf("%-15s: %-5s\n", "%-5s", "test");
  printf("%-15s: %-5.s\n", "%-5.s", "test");
  printf("%-15s: %-5.0s\n", "%-5.0s", "test");
  printf("%-15s: %-5.1s\n", "%-5.1s", "test");
  printf("%-15s: %-5.2s\n", "%-5.2s", "test");
  printf("%-15s: %-5.5s\n", "%-5.5s", "test");
  printf("%-15s: %-5.10s\n", "%-5.10s", "test");
  printf("%-15s: %-5.30s\n", "%-5.30s", "test");
  printf("%-15s: %-10s\n", "%-10s", "test");
  printf("%-15s: %-10.s\n", "%-10.s", "test");
  printf("%-15s: %-10.0s\n", "%-10.0s", "test");
  printf("%-15s: %-10.1s\n", "%-10.1s", "test");
  printf("%-15s: %-10.2s\n", "%-10.2s", "test");
  printf("%-15s: %-10.5s\n", "%-10.5s", "test");
  printf("%-15s: %-10.10s\n", "%-10.10s", "test");
  printf("%-15s: %-10.30s\n", "%-10.30s", "test");
  printf("%-15s: %-30s\n", "%-30s", "test");
  printf("%-15s: %-30.s\n", "%-30.s", "test");
  printf("%-15s: %-30.0s\n", "%-30.0s", "test");
  printf("%-15s: %-30.1s\n", "%-30.1s", "test");
  printf("%-15s: %-30.2s\n", "%-30.2s", "test");
  printf("%-15s: %-30.5s\n", "%-30.5s", "test");
  printf("%-15s: %-30.10s\n", "%-30.10s", "test");
  printf("%-15s: %-30.30s\n", "%-30.30s", "test");
  printf("%-15s: %-c\n", "%-c", 'x');
  printf("%-15s: %-1c\n", "%-1c", 'x');
  printf("%-15s: %-2c\n", "%-2c", 'x');
  printf("%-15s: %-5c\n", "%-5c", 'x');
  printf("%-15s: %-10c\n", "%-10c", 'x');
  printf("%-15s: %-30c\n", "%-30c", 'x');
  printf("%-15s: %-p\n", "%-p", (void*)324376);
  printf("%-15s: %-1p\n", "%-1p", (void*)324376);
  printf("%-15s: %-2p\n", "%-2p", (void*)324376);
  printf("%-15s: %-5p\n", "%-5p", (void*)324376);
  printf("%-15s: %-10p\n", "%-10p", (void*)324376);
  printf("%-15s: %-30p\n", "%-30p", (void*)324376);
  printf("\n");
  printf("%hhx\n", 0x789ABCDE);
  printf("%hx\n", 0x789ABCDE);
  printf("%x\n", 0x789ABCDE);
  printf("%lx\n", 0x789ABCDE);
  printf("\n");
  printf("%hhx\n", 0x789ABCDEl);
  printf("%hx\n", 0x789ABCDEl);
  printf("%x\n", 0x789ABCDEl);
  printf("%lx\n", 0x789ABCDEl);
  printf("\n");
  printf("%hhx\n", 0x0123456789ABCDEll);
  printf("%hx\n", 0x0123456789ABCDEll);
  printf("%x\n", 0x0123456789ABCDEll);
  printf("%lx\n", 0x0123456789ABCDEll);
  printf("%llx\n", 0x0123456789ABCDEll);
  printf("%llx\n", 0x0123456789ABCDEll);
  printf("\n");
  printf("%zx\n", 0x0123456789ABCDEll);
  printf("%jx\n", 0x0123456789ABCDEll);
  printf("%tx\n", 0x0123456789ABCDEll);
  printf("\n");
  printf("%hhd\n", 0x789ABCDE);
  printf("%hd\n", 0x789ABCDE);
  printf("%d\n", 0x789ABCDE);
  printf("%ld\n", 0x789ABCDE);
  printf("\n");
  printf("%hhd\n", 0x789ABCDEl);
  printf("%hd\n", 0x789ABCDEl);
  printf("%d\n", 0x789ABCDEl);
  printf("%ld\n", 0x789ABCDEl);
  printf("\n");
  printf("%hhd\n", 0x0123456789ABCDEll);
  printf("%hd\n", 0x0123456789ABCDEll);
  printf("%d\n", 0x0123456789ABCDEll);
  printf("%ld\n", 0x0123456789ABCDEll);
  printf("%lld\n", 0x0123456789ABCDEll);
  printf("%lld\n", 0x0123456789ABCDEll);
  printf("\n");
  printf("%zd\n", 0x0123456789ABCDEll);
  printf("%jd\n", 0x0123456789ABCDEll);
  printf("%td\n", 0x0123456789ABCDEll);
  printf("\n");
  printf("%hhu\n", 0x789ABCDE);
  printf("%hu\n", 0x789ABCDE);
  printf("%u\n", 0x789ABCDE);
  printf("%lu\n", 0x789ABCDE);
  printf("\n");
  printf("%hhu\n", 0x789ABCDEl);
  printf("%hu\n", 0x789ABCDEl);
  printf("%u\n", 0x789ABCDEl);
  printf("%lu\n", 0x789ABCDEl);
  printf("\n");
  printf("%hhu\n", 0x0123456789ABCDEll);
  printf("%hu\n", 0x0123456789ABCDEll);
  printf("%u\n", 0x0123456789ABCDEll);
  printf("%lu\n", 0x0123456789ABCDEll);
  printf("%llu\n", 0x0123456789ABCDEll);
  printf("%llu\n", 0x0123456789ABCDEll);
  printf("\n");
  printf("%zu\n", 0x0123456789ABCDEll);
  printf("%ju\n", 0x0123456789ABCDEll);
  printf("%tu\n", 0x0123456789ABCDEll);
  printf("\n");
  printf("%hhx\n", -0x789ABCDE);
  printf("%hx\n", -0x789ABCDE);
  printf("%x\n", -0x789ABCDE);
  printf("%lx\n", -0x789ABCDE);
  printf("\n");
  printf("%hhx\n", -0x789ABCDEl);
  printf("%hx\n", -0x789ABCDEl);
  printf("%x\n", -0x789ABCDEl);
  printf("%lx\n", -0x789ABCDEl);
  printf("\n");
  printf("%hhx\n", -0x0123456789ABCDEll);
  printf("%hx\n", -0x0123456789ABCDEll);
  printf("%x\n", -0x0123456789ABCDEll);
  printf("%lx\n", -0x0123456789ABCDEll);
  printf("%llx\n", -0x0123456789ABCDEll);
  printf("%llx\n", -0x0123456789ABCDEll);
  printf("\n");
  printf("%zx\n", -0x0123456789ABCDEll);
  printf("%jx\n", -0x0123456789ABCDEll);
  printf("%tx\n", -0x0123456789ABCDEll);
  printf("\n");
  printf("%hhd\n", -0x789ABCDE);
  printf("%hd\n", -0x789ABCDE);
  printf("%d\n", -0x789ABCDE);
  printf("%ld\n", -0x789ABCDE);
  printf("\n");
  printf("%hhd\n", -0x789ABCDEl);
  printf("%hd\n", -0x789ABCDEl);
  printf("%d\n", -0x789ABCDEl);
  printf("%ld\n", -0x789ABCDEl);
  printf("\n");
  printf("%hhd\n", -0x0123456789ABCDEll);
  printf("%hd\n", -0x0123456789ABCDEll);
  printf("%d\n", -0x0123456789ABCDEll);
  printf("%ld\n", -0x0123456789ABCDEll);
  printf("%lld\n", -0x0123456789ABCDEll);
  printf("%lld\n", -0x0123456789ABCDEll);
  printf("\n");
  printf("%zd\n", -0x0123456789ABCDEll);
  printf("%jd\n", -0x0123456789ABCDEll);
  printf("%td\n", -0x0123456789ABCDEll);
  printf("\n");
  printf("%hhu\n", -0x789ABCDE);
  printf("%hu\n", -0x789ABCDE);
  printf("%u\n", -0x789ABCDE);
  printf("%lu\n", -0x789ABCDE);
  printf("\n");
  printf("%hhu\n", -0x789ABCDEl);
  printf("%hu\n", -0x789ABCDEl);
  printf("%u\n", -0x789ABCDEl);
  printf("%lu\n", -0x789ABCDEl);
  printf("\n");
  printf("%hhu\n", -0x0123456789ABCDEll);
  printf("%hu\n", -0x0123456789ABCDEll);
  printf("%u\n", -0x0123456789ABCDEll);
  printf("%lu\n", -0x0123456789ABCDEll);
  printf("%llu\n", -0x0123456789ABCDEll);
  printf("%llu\n", -0x0123456789ABCDEll);
  printf("\n");
  printf("z %zu\n", -0x0123456789ABCDEll);
  printf("j %ju\n", -0x0123456789ABCDEll);
  printf("t %tu\n", -0x0123456789ABCDEll);
  printf("\n");
  printf("%f\n", 1234567.890123456789);
  printf("%lf\n", 1234567.890123456789);
  printf("\n");
  printf("%f\n", -1234567.890123456789);
  printf("%lf\n", -1234567.890123456789);
  printf("\n");
  printf("%f\n", 1234567.890123456789f);
  printf("%lf\n", 1234567.890123456789f);
  printf("\n");
  printf("%f\n", -1234567.890123456789f);
  printf("%lf\n", -1234567.890123456789f);
  printf("\n");
  printf("%hhu\n", 0);
  printf("%hu\n", 0);
  printf("%u\n", 0);
  printf("%llu\n", 0ll);
  printf("%hhx\n", 0);
  printf("%hx\n", 0);
  printf("%x\n", 0);
  printf("%llx\n", 0ll);
  printf("\n");
  printf("%hhu\n", 1);
  printf("%hu\n", 1);
  printf("%u\n", 1);
  printf("%llu\n", 1ll);
  printf("%hhx\n", 1);
  printf("%hx\n", 1);
  printf("%x\n", 1);
  printf("%llx\n", 1ll);
  printf("\n");
  printf("%hhu\n", -1);
  printf("%hu\n", -1);
  printf("%u\n", -1);
  printf("%llu\n", -1ll);
  printf("%hhx\n", -1);
  printf("%hx\n", -1);
  printf("%x\n", -1);
  printf("%llx\n", -1ll);
  printf("\n");
  printf("%hhu\n", 0x7E);
  printf("%hu\n", 0x7FFE);
  printf("%u\n", 0x7FFFFFFE);
  printf("%llu\n", 0x7FFFFFFFFFFEll);
  printf("%hhx\n", 0x7E);
  printf("%hx\n", 0x7FFE);
  printf("%x\n", 0x7FFFFFFE);
  printf("%llx\n", 0x7FFFFFFFFFFEll);
  printf("\n");
  printf("%hhu\n", 0x7F);
  printf("%hu\n", 0x7FFF);
  printf("%u\n", 0x7FFFFFFF);
  printf("%llu\n", 0x7FFFFFFFFFFFll);
  printf("%hhx\n", 0x7F);
  printf("%hx\n", 0x7FFF);
  printf("%x\n", 0x7FFFFFFF);
  printf("%llx\n", 0x7FFFFFFFFFFFll);
  printf("\n");
  printf("%hhu\n", 0x80);
  printf("%hu\n", 0x8000);
  printf("%u\n", 0x8000000);
  printf("%llu\n", 0x8000000000ll);
  printf("%hhx\n", 0x80);
  printf("%hx\n", 0x8000);
  printf("%x\n", 0x8000000);
  printf("%llx\n", 0x8000000000ll);
  printf("\n");
  printf("%hhu\n", 0xFF);
  printf("%hu\n", 0xFFFF);
  printf("%u\n", 0xFFFFFFFF);
  printf("%llu\n", 0xFFFFFFFFFFFFll);
  printf("%hhx\n", 0xFF);
  printf("%hx\n", 0xFFFF);
  printf("%x\n", 0xFFFFFFFF);
  printf("\n");
  printf("%hhu\n", -0x7E);
  printf("%hu\n", -0x7FFE);
  printf("%u\n", -0x7FFFFFFE);
  printf("%llu\n", -0x7FFFFFFFFFFEll);
  printf("%hhx\n", -0x7E);
  printf("%hx\n", -0x7FFE);
  printf("%x\n", -0x7FFFFFFE);
  printf("%llx\n", -0x7FFFFFFFFFFEll);
  printf("\n");
  printf("%hhu\n", -0x7F);
  printf("%hu\n", -0x7FFF);
  printf("%u\n", -0x7FFFFFFF);
  printf("%llu\n", -0x7FFFFFFFFFFFll);
  printf("%hhx\n", -0x7F);
  printf("%hx\n", -0x7FFF);
  printf("%x\n", -0x7FFFFFFF);
  printf("%llx\n", -0x7FFFFFFFFFFFll);
  printf("\n");
  printf("%hhu\n", -0x80);
  printf("%hu\n", -0x8000);
  printf("%u\n", -0x8000000);
  printf("%llu\n", -0x8000000000ll);
  printf("%hhx\n", -0x80);
  printf("%hx\n", -0x8000);
  printf("%x\n", -0x8000000);
  printf("%llx\n", -0x8000000000ll);
  printf("\n");
  printf("%hhu\n", -0xFF);
  printf("%hu\n", -0xFFFF);
  printf("%u\n", -0xFFFFFFFF);
  printf("%llu\n", -0xFFFFFFFFFFFFll);
  printf("%hhx\n", -0xFF);
  printf("%hx\n", -0xFFFF);
  printf("%x\n", -0xFFFFFFFF);
  printf("\n");
  printf("%*.*E\n", 10, -1, 12345.6789123);
  printf("%*.*E\n", 10, -313, 12345.6789123);
  printf("no_new_line");
  return 0;
}
