/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignViewport;
import jalview.appletgui.AnnotationPanel;
import jalview.appletgui.FeatureRenderer;
import jalview.appletgui.PaintRefresher;
import jalview.appletgui.SequenceRenderer;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SearchResults;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.util.Comparison;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.util.Vector;

public class SeqCanvas
extends Panel {
    FeatureRenderer fr;
    SequenceRenderer sr;
    Image img;
    Graphics gg;
    int imgWidth;
    int imgHeight;
    AlignViewport av;
    SearchResults searchResults = null;
    boolean fastPaint = false;
    int cursorX = 0;
    int cursorY = 0;
    int lastsr = 0;
    int LABEL_WEST;
    int LABEL_EAST;
    AnnotationPanel annotations;

    public SeqCanvas(AlignViewport av) {
        this.av = av;
        this.fr = new FeatureRenderer(av);
        this.sr = new SequenceRenderer(av);
        PaintRefresher.Register(this, av.getSequenceSetId());
    }

    public AlignViewport getViewport() {
        return this.av;
    }

    public FeatureRenderer getFeatureRenderer() {
        return this.fr;
    }

    public SequenceRenderer getSequenceRenderer() {
        return this.sr;
    }

    void drawNorthScale(Graphics g, int startx, int endx, int ypos) {
        int scalestartx = startx - startx % 10 + 10;
        g.setColor(Color.black);
        for (int i = scalestartx; i < endx; i += 10) {
            int value = i;
            if (this.av.hasHiddenColumns) {
                value = this.av.getColumnSelection().adjustForHiddenColumns(value);
            }
            g.drawString(String.valueOf(value), (i - startx - 1) * this.av.charWidth, ypos - this.av.charHeight / 2);
            g.drawLine((i - startx - 1) * this.av.charWidth + this.av.charWidth / 2, ypos + 2 - this.av.charHeight / 2, (i - startx - 1) * this.av.charWidth + this.av.charWidth / 2, ypos - 2);
        }
    }

    void drawWestScale(Graphics g, int startx, int endx, int ypos) {
        FontMetrics fm = this.getFontMetrics(this.av.getFont());
        ypos += this.av.charHeight;
        if (this.av.hasHiddenColumns) {
            startx = this.av.getColumnSelection().adjustForHiddenColumns(startx);
            endx = this.av.getColumnSelection().adjustForHiddenColumns(endx);
        }
        int maxwidth = this.av.alignment.getWidth();
        if (this.av.hasHiddenColumns) {
            maxwidth = this.av.getColumnSelection().findColumnPosition(maxwidth) - 1;
        }
        for (int i = 0; i < this.av.alignment.getHeight(); ++i) {
            SequenceI seq = this.av.alignment.getSequenceAt(i);
            int value = -1;
            for (int index = startx; index < endx; ++index) {
                if (Comparison.isGap(seq.getCharAt(index))) {
                    continue;
                }
                value = this.av.alignment.getSequenceAt(i).findPosition(index);
                break;
            }
            if (value == -1) continue;
            int x = this.LABEL_WEST - fm.stringWidth(String.valueOf(value)) - this.av.charWidth / 2;
            g.drawString(value + "", x, ypos + i * this.av.charHeight - this.av.charHeight / 5);
        }
    }

    void drawEastScale(Graphics g, int startx, int endx, int ypos) {
        ypos += this.av.charHeight;
        if (this.av.hasHiddenColumns) {
            endx = this.av.getColumnSelection().adjustForHiddenColumns(endx);
        }
        for (int i = 0; i < this.av.alignment.getHeight(); ++i) {
            SequenceI seq = this.av.alignment.getSequenceAt(i);
            int value = -1;
            for (int index = endx; index > startx; --index) {
                if (Comparison.isGap(seq.getCharAt(index))) {
                    continue;
                }
                value = seq.findPosition(index);
                break;
            }
            if (value == -1) continue;
            g.drawString(String.valueOf(value), 0, ypos + i * this.av.charHeight - this.av.charHeight / 5);
        }
    }

    void fastPaint(int horizontal, int vertical) {
        if (this.fastPaint || this.gg == null) {
            return;
        }
        if (this.lastsr + horizontal != this.av.startRes) {
            horizontal = this.av.startRes - this.lastsr;
        }
        this.lastsr = this.av.startRes;
        this.fastPaint = true;
        this.gg.copyArea(horizontal * this.av.charWidth, vertical * this.av.charHeight, this.imgWidth - horizontal * this.av.charWidth, this.imgHeight - vertical * this.av.charHeight, -horizontal * this.av.charWidth, -vertical * this.av.charHeight);
        int sr = this.av.startRes;
        int er = this.av.endRes;
        int ss = this.av.startSeq;
        int es = this.av.endSeq;
        int transX = 0;
        int transY = 0;
        if (horizontal > 0) {
            transX = (er - sr - horizontal) * this.av.charWidth;
            sr = er - horizontal;
        } else if (horizontal < 0) {
            er = sr - horizontal;
        } else if (vertical > 0) {
            ss = es - vertical;
            if (ss < this.av.startSeq) {
                ss = this.av.startSeq;
            } else {
                transY = this.imgHeight - vertical * this.av.charHeight;
            }
        } else if (vertical < 0 && (es = ss - vertical) > this.av.endSeq) {
            es = this.av.endSeq;
        }
        this.gg.translate(transX, transY);
        this.drawPanel(this.gg, sr, er, ss, es, 0);
        this.gg.translate(-transX, -transY);
        this.repaint();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.img != null && (this.fastPaint || this.getSize().width != g.getClipBounds().width || this.getSize().height != g.getClipBounds().height)) {
            g.drawImage(this.img, 0, 0, this);
            this.fastPaint = false;
            return;
        }
        if (this.fastPaint) {
            g.drawImage(this.img, 0, 0, this);
            this.fastPaint = false;
            return;
        }
        this.imgWidth = this.getSize().width;
        this.imgHeight = this.getSize().height;
        this.imgWidth -= this.imgWidth % this.av.charWidth;
        this.imgHeight -= this.imgHeight % this.av.charHeight;
        if (this.imgWidth < 1 || this.imgHeight < 1) {
            return;
        }
        if (this.img == null || this.imgWidth != this.img.getWidth(this) || this.imgHeight != this.img.getHeight(this)) {
            this.img = this.createImage(this.imgWidth, this.imgHeight);
            this.gg = this.img.getGraphics();
            this.gg.setFont(this.av.getFont());
        }
        this.gg.setColor(Color.white);
        this.gg.fillRect(0, 0, this.imgWidth, this.imgHeight);
        if (this.av.getWrapAlignment()) {
            this.drawWrappedPanel(this.gg, this.imgWidth, this.imgHeight, this.av.startRes);
        } else {
            this.drawPanel(this.gg, this.av.startRes, this.av.endRes, this.av.startSeq, this.av.endSeq, 0);
        }
        g.drawImage(this.img, 0, 0, this);
    }

    public int getWrappedCanvasWidth(int cwidth) {
        cwidth -= cwidth % this.av.charWidth;
        FontMetrics fm = this.getFontMetrics(this.av.getFont());
        this.LABEL_EAST = 0;
        this.LABEL_WEST = 0;
        if (this.av.scaleRightWrapped) {
            this.LABEL_EAST = fm.stringWidth(this.getMask());
        }
        if (this.av.scaleLeftWrapped) {
            this.LABEL_WEST = fm.stringWidth(this.getMask());
        }
        return (cwidth - this.LABEL_EAST - this.LABEL_WEST) / this.av.charWidth;
    }

    String getMask() {
        int i;
        String mask = "0";
        int maxWidth = 0;
        for (i = 0; i < this.av.alignment.getHeight(); ++i) {
            int tmp = this.av.alignment.getSequenceAt(i).getEnd();
            if (tmp <= maxWidth) continue;
            maxWidth = tmp;
        }
        for (i = maxWidth; i > 0; i /= 10) {
            mask = mask + "0";
        }
        return mask;
    }

    public void drawWrappedPanel(Graphics g, int canvasWidth, int canvasHeight, int startRes) {
        AlignmentI al = this.av.getAlignment();
        FontMetrics fm = this.getFontMetrics(this.av.getFont());
        if (this.av.scaleRightWrapped) {
            this.LABEL_EAST = fm.stringWidth(this.getMask());
        }
        if (this.av.scaleLeftWrapped) {
            this.LABEL_WEST = fm.stringWidth(this.getMask());
        }
        int hgap = this.av.charHeight;
        if (this.av.scaleAboveWrapped) {
            hgap += this.av.charHeight;
        }
        int cWidth = (canvasWidth - this.LABEL_EAST - this.LABEL_WEST) / this.av.charWidth;
        int cHeight = this.av.getAlignment().getHeight() * this.av.charHeight;
        this.av.setWrappedWidth(cWidth);
        this.av.endRes = this.av.startRes + cWidth;
        int ypos = hgap;
        int maxwidth = this.av.alignment.getWidth() - 1;
        if (this.av.hasHiddenColumns) {
            maxwidth = this.av.getColumnSelection().findColumnPosition(maxwidth) - 1;
        }
        while (ypos <= canvasHeight && startRes < maxwidth) {
            int endx = startRes + cWidth - 1;
            if (endx > maxwidth) {
                endx = maxwidth;
            }
            g.setColor(Color.black);
            if (this.av.scaleLeftWrapped) {
                this.drawWestScale(g, startRes, endx, ypos);
            }
            if (this.av.scaleRightWrapped) {
                g.translate(canvasWidth - this.LABEL_EAST, 0);
                this.drawEastScale(g, startRes, endx, ypos);
                g.translate(-(canvasWidth - this.LABEL_EAST), 0);
            }
            g.translate(this.LABEL_WEST, 0);
            if (this.av.scaleAboveWrapped) {
                this.drawNorthScale(g, startRes, endx, ypos);
            }
            if (this.av.hasHiddenColumns && this.av.showHiddenMarkers) {
                g.setColor(Color.blue);
                for (int i = 0; i < this.av.getColumnSelection().getHiddenColumns().size(); ++i) {
                    int res = this.av.getColumnSelection().findHiddenRegionPosition(i) - startRes;
                    if (res < 0 || res > endx - startRes) continue;
                    this.gg.fillPolygon(new int[]{res * this.av.charWidth - this.av.charHeight / 4, res * this.av.charWidth + this.av.charHeight / 4, res * this.av.charWidth}, new int[]{ypos - this.av.charHeight / 2, ypos - this.av.charHeight / 2, ypos - this.av.charHeight / 2 + 8}, 3);
                }
            }
            if (g.getClip() == null) {
                g.setClip(0, 0, cWidth * this.av.charWidth, canvasHeight);
            }
            this.drawPanel(g, startRes, endx, 0, al.getHeight(), ypos);
            g.setClip(null);
            if (this.av.showAnnotation) {
                g.translate(0, cHeight + ypos + 4);
                if (this.annotations == null) {
                    this.annotations = new AnnotationPanel(this.av);
                }
                this.annotations.drawComponent(g, startRes, endx + 1);
                g.translate(0, -cHeight - ypos - 4);
            }
            g.translate(-this.LABEL_WEST, 0);
            ypos += cHeight + this.getAnnotationHeight() + hgap;
            startRes += cWidth;
        }
    }

    int getAnnotationHeight() {
        if (!this.av.showAnnotation) {
            return 0;
        }
        if (this.annotations == null) {
            this.annotations = new AnnotationPanel(this.av);
        }
        return this.annotations.adjustPanelHeight();
    }

    void drawPanel(Graphics g1, int startRes, int endRes, int startSeq, int endSeq, int offset) {
        if (!this.av.hasHiddenColumns) {
            this.draw(g1, startRes, endRes, startSeq, endSeq, offset);
        } else {
            Vector regions = this.av.getColumnSelection().getHiddenColumns();
            int screenY = 0;
            int blockStart = startRes;
            int blockEnd = endRes;
            for (int i = 0; i < regions.size(); ++i) {
                int[] region = (int[])regions.elementAt(i);
                int hideStart = region[0];
                int hideEnd = region[1];
                if (hideStart <= blockStart) {
                    blockStart += hideEnd - hideStart + 1;
                    continue;
                }
                blockEnd = hideStart - 1;
                g1.translate(screenY * this.av.charWidth, 0);
                this.draw(g1, blockStart, blockEnd, startSeq, endSeq, offset);
                if (this.av.getShowHiddenMarkers()) {
                    g1.setColor(Color.blue);
                    g1.drawLine((blockEnd - blockStart + 1) * this.av.charWidth - 1, 0 + offset, (blockEnd - blockStart + 1) * this.av.charWidth - 1, (endSeq - startSeq) * this.av.charHeight + offset);
                }
                g1.translate(-screenY * this.av.charWidth, 0);
                screenY += blockEnd - blockStart + 1;
                blockStart = hideEnd + 1;
            }
            if (screenY <= endRes - startRes) {
                blockEnd = blockStart + (endRes - startRes) - screenY;
                g1.translate(screenY * this.av.charWidth, 0);
                this.draw(g1, blockStart, blockEnd, startSeq, endSeq, offset);
                g1.translate(-screenY * this.av.charWidth, 0);
            }
        }
    }

    void draw(Graphics g, int startRes, int endRes, int startSeq, int endSeq, int offset) {
        g.setFont(this.av.getFont());
        this.sr.prepare(g, this.av.renderGaps);
        for (int i = startSeq; i < endSeq; ++i) {
            int[] visibleResults;
            SequenceI nextSeq = this.av.alignment.getSequenceAt(i);
            if (nextSeq == null) continue;
            this.sr.drawSequence(nextSeq, this.av.alignment.findAllGroups(nextSeq), startRes, endRes, offset + (i - startSeq) * this.av.charHeight);
            if (this.av.showSequenceFeatures) {
                this.fr.drawSequence(g, nextSeq, startRes, endRes, offset + (i - startSeq) * this.av.charHeight);
            }
            if (this.searchResults != null && (visibleResults = this.searchResults.getResults(nextSeq, startRes, endRes)) != null) {
                for (int r = 0; r < visibleResults.length; r += 2) {
                    this.sr.drawHighlightedText(nextSeq, visibleResults[r], visibleResults[r + 1], (visibleResults[r] - startRes) * this.av.charWidth, offset + (i - startSeq) * this.av.charHeight);
                }
            }
            if (!this.av.cursorMode || this.cursorY != i || this.cursorX < startRes || this.cursorX > endRes) continue;
            this.sr.drawCursor(nextSeq, this.cursorX, (this.cursorX - startRes) * this.av.charWidth, offset + (i - startSeq) * this.av.charHeight);
        }
        if (this.av.getSelectionGroup() != null || this.av.alignment.getGroups().size() > 0) {
            this.drawGroupsBoundaries(g, startRes, endRes, startSeq, endSeq, offset);
        }
    }

    void drawGroupsBoundaries(Graphics g, int startRes, int endRes, int startSeq, int endSeq, int offset) {
        SequenceGroup group = this.av.getSelectionGroup();
        int sx = -1;
        int sy = -1;
        int ex = -1;
        int groupIndex = -1;
        if (group == null && this.av.alignment.getGroups().size() > 0) {
            group = (SequenceGroup)this.av.alignment.getGroups().elementAt(0);
            groupIndex = 0;
        }
        if (group != null) {
            do {
                int oldY = -1;
                int i = 0;
                boolean inGroup = false;
                int top = -1;
                int bottom = -1;
                int alHeight = this.av.alignment.getHeight() - 1;
                for (i = startSeq; i < endSeq; ++i) {
                    sx = (group.getStartRes() - startRes) * this.av.charWidth;
                    sy = offset + (i - startSeq) * this.av.charHeight;
                    ex = (group.getEndRes() + 1 - group.getStartRes()) * this.av.charWidth - 1;
                    if (sx + ex < 0 || sx > this.imgWidth) continue;
                    if (sx <= (endRes - startRes) * this.av.charWidth && group.getSequences(null).contains(this.av.alignment.getSequenceAt(i))) {
                        if (!(bottom != -1 || i < alHeight && group.getSequences(null).contains(this.av.alignment.getSequenceAt(i + 1)))) {
                            bottom = sy + this.av.charHeight;
                        }
                        if (inGroup) continue;
                        if (top == -1 && i == 0 || !group.getSequences(null).contains(this.av.alignment.getSequenceAt(i - 1))) {
                            top = sy;
                        }
                        oldY = sy;
                        inGroup = true;
                        if (group == this.av.getSelectionGroup()) {
                            g.setColor(Color.red);
                            continue;
                        }
                        g.setColor(group.getOutlineColour());
                        continue;
                    }
                    if (!inGroup) continue;
                    if (sx >= 0 && sx < this.imgWidth) {
                        g.drawLine(sx, oldY, sx, sy);
                    }
                    if (sx + ex < this.imgWidth) {
                        g.drawLine(sx + ex, oldY, sx + ex, sy);
                    }
                    if (sx < 0) {
                        ex += sx;
                        sx = 0;
                    }
                    if (sx + ex > this.imgWidth) {
                        ex = this.imgWidth;
                    } else if (sx + ex >= (endRes - startRes + 1) * this.av.charWidth) {
                        ex = (endRes - startRes + 1) * this.av.charWidth;
                    }
                    if (top != -1) {
                        g.drawLine(sx, top, sx + ex, top);
                        top = -1;
                    }
                    if (bottom != -1) {
                        g.drawLine(sx, bottom, sx + ex, bottom);
                        bottom = -1;
                    }
                    inGroup = false;
                }
                if (inGroup) {
                    sy = offset + (i - startSeq) * this.av.charHeight;
                    if (sx >= 0 && sx < this.imgWidth) {
                        g.drawLine(sx, oldY, sx, sy);
                    }
                    if (sx + ex < this.imgWidth) {
                        g.drawLine(sx + ex, oldY, sx + ex, sy);
                    }
                    if (sx < 0) {
                        ex += sx;
                        sx = 0;
                    }
                    if (sx + ex > this.imgWidth) {
                        ex = this.imgWidth;
                    } else if (sx + ex >= (endRes - startRes + 1) * this.av.charWidth) {
                        ex = (endRes - startRes + 1) * this.av.charWidth;
                    }
                    if (top != -1) {
                        g.drawLine(sx, top, sx + ex, top);
                        top = -1;
                    }
                    if (bottom != -1) {
                        g.drawLine(sx, bottom - 1, sx + ex, bottom - 1);
                        bottom = -1;
                    }
                    inGroup = false;
                }
                if (++groupIndex >= this.av.alignment.getGroups().size()) break;
                group = (SequenceGroup)this.av.alignment.getGroups().elementAt(groupIndex);
            } while (groupIndex < this.av.alignment.getGroups().size());
        }
    }

    public void highlightSearchResults(SearchResults results) {
        this.searchResults = results;
        this.repaint();
    }
}

