" Vim syntax file
" Language: DDTP files - client version
" Maintainer: Lorenzo Cappelletti <lorenzo.cappelletti@email.it>
" Last Change: Tue,  5 Aug 2003 21:47:34 +0200
"

" For copyright statement and stuff, see included file ddtpCom.vim



" Common definitions
runtime syntax/ddtpCom.vim


" Atomic description
syntax region ddtpCliAtom	fold keepend transparent
	\ start=/^# package:/
	\ end=/^$/
	\ contains=ddtpCliHeader,ddtpCliOr,@ddtpCliXx

" Pseudo-header
syntax region ddtpCliHeader	fold keepend transparent contained
	\ start=/^/
	\ end=/^\(# -\)\?Description: /me=s-1
	\ contains=ddtpCliHeaderKey

syntax match  ddtpCliHeaderKey	contained
	\ /^# \(package\|translator\|ddts id\|bug number\|reviewer\)[^:]*/hs=s+2
	\ nextgroup=ddtpComHeaderArg

" Original description
syntax region ddtpCliOr		fold keepend transparent contained
	\ start=/^\(# -\)\?Description: /
	\ end=/^\([>+]>[a-z+-][+-]\)\?Description-\l\l\|^$/me=s-1
	\ contains=ddtpCliOrSynp,ddtpCliOrDesc

syntax region  ddtpCliOrSynp	keepend transparent contained
	\ start=/^\(# -\)\?Description: /
	\ end=/^[ #]/me=e-1
	\ contains=ddtpComSynpKey,ddtpComTodo,
		  \ddtpCliDiffRemoved,@ddtpComErrSynp		" Synopsis

syntax region ddtpCliOrDesc 	fold keepend transparent contained
	\ start=/^ \|#\( -Description\)\@!/
	\ end=/^$/
	\ contains=ddtpCliOrPara,ddtpComDot			" Description

syntax region ddtpCliOrPara	fold transparent contained
	\ start=/^[ #][^\.]/
	\ skip=/^#/
	\ end=/ \.$/me=e-2
	\ contains=@ddtpCliComm,ddtpCliDiffRemoved,
		  \@ddtpComErrPara				" Paragraphs

" Generic translation
syntax region ddtpCliXx		fold keepend transparent contained
	\ start=/^\([>+]>[a-z+-][+-]\)\?Description-\l\l/
	\ end=/^$/me=s-1
	\ contains=ddtpCliXxSynp,ddtpCliXxDesc,@ddtpCliDiff

syntax region  ddtpCliXxSynp	transparent contained
	\ start=/^\([>+]>[a-z+-][+-]\)\?Description-\l\l.*/
	\ end=/^\([>+]>[a-z+-][+-]Description-\l\l.*$\)\@!/
	\ contains=ddtpComSynpKey,ddtpComTodo,@ddtpCliDiff,
		  \@ddtpComErrSynp				" Synopsis

syntax region ddtpCliXxDesc 	fold keepend transparent contained
	\ start=/^\(\([>+]>[a-z+-][+-]\)\?Description-\l\l.*$\)\@!/
	\ end=/^$/
	\ contains=ddtpCliXxPara,ddtpComDot			" Description

syntax region ddtpCliXxPara	fold contained
	\ start=/\(^ \.\)\@!/
	\ skip=/^[#>+]/
	\ end=/ \.$/me=e-2
	\ contains=@ddtpCliComm,ddtpComTodo,@ddtpCliDiff,
		  \@ddtpComErrPara				" Paragraph


" Comments
syntax match  ddtpCliCommServ	/^>[^>].*$/ 	 		contained	" Server
syntax match  ddtpCliCommPerm	/^>>[^a-z+-][^+-].*$/		contained	" Permanent

syntax cluster ddtpCliComm contains=ddtpCliCommServ,ddtpCliCommPerm


" Diff
syntax match  ddtpCliDiffRemoved	/^# -.*/		contained
syntax match  ddtpCliDiffRemoved	/^>>--.*/		contained
syntax match  ddtpCliDiffAddedA		/^>>a+.*/		contained
syntax match  ddtpCliDiffAddedB		/^>>b+.*/		contained
syntax match  ddtpCliDiffAddedC		/^>>c+.*/		contained
syntax match  ddtpCliDiffAddedX		/^>>[d-z+]+.*/		contained
syntax match  ddtpCliDiffSelected	/^+>[a-z+-][+-].*/	contained contains=ddtpCliDiffSelectedHeader
syntax match  ddtpCliDiffSelectedHeader	/^+>[a-z+-][+-]/	contained

syntax cluster ddtpCliDiff contains=ddtpCliDiff.*


" Localized versions
runtime syntax/ddtpCli??.vim
runtime syntax/ddtpCli????.vim
syntax cluster ddtpCliXx contains=ddtpCli..


" Highlighting
highlight ddtpCliDiffAddedA	ctermfg=Magenta
				\ guifg=Magenta
highlight ddtpCliDiffAddedB	ctermfg=Yellow
				\ guifg=Yellow
highlight ddtpCliDiffAddedC	ctermfg=LightBlue
				\ guifg=LightBlue

highlight def link ddtpCliHeaderKey		ddtpComHeaderKey
highlight def link ddtpCliCommServ		ddtpComCommServ
highlight def link ddtpCliCommPerm		ddtpComCommPerm
highlight def link ddtpCliDiffAddedX		diffAdded
highlight def link ddtpCliDiffRemoved		diffRemoved
highlight def link ddtpCliDiffSelectedHeader	Type


" Folding
if !exists("ddts_nofolding")
  set foldmethod=syntax
  1,$foldopen!
endif

let b:current_syntax = "ddtc"

