import QtQuick 2.0
import QtMultimedia 5.0

Rectangle {
    property string recordOffImagePath: "assets/record_off.png"
    property string recordOnImagePath: "assets/record_on.png"
    property string shootImagePath: "assets/shoot.png"
    function isSuffix(str, suffix) {
        return String(str).substr(String(str).length - suffix.length) == suffix
    }

    id: ui
    color: "#252423"
    state: "off"

    Camera {
        objectName: "camera"
        id: camera
        cameraState: Camera.UnloadedState
        onError: {
            console.log(errorString);
            shootButton.source = recordOffImagePath
        }
        videoRecorder.audioBitRate: 128000
        videoRecorder.mediaContainer: "mp4"
    }
    Image {
        id: microphoneImage
        source: "assets/microphone.png"
        smooth: true
        visible: false
        width: parent.width
        height: parent.height
    }
    VideoOutput {
        id: output
        focus : visible
        source: camera
        width: parent.width
        height: parent.height
    }

    Item {
        anchors.bottom: parent.bottom
        width: parent.width
        height: shootButton.height
        BorderImage {
            id: leftBackground
            anchors.left: parent.left
            anchors.top: parent.top
            anchors.bottom: parent.bottom
            anchors.right: middle.left
            anchors.topMargin: units.dp(2)
            anchors.bottomMargin: units.dp(2)
            source: "assets/toolbar-left.png"
            Image {
                anchors.verticalCenter: parent.verticalCenter
                anchors.left: parent.left
                anchors.leftMargin: parent.iconSpacing
                source: "assets/back.png"
                width: units.gu(6)
                height: units.gu(5)
                MouseArea {
                    anchors.fill: parent
                    onClicked: {
                        if (ui.state === "camera") {
                            ui.parent.exec("com.cordova.Camera", "cancel");
                        } else if (ui.state === "audio") {
                            ui.parent.exec("com.cordova.Capture", "cancel");
                        } else if (ui.state === "videoRecording") {
                            ui.parent.exec("com.cordova.Camera", "cancel");
                        }
                    }
                }
            }
        }
        BorderImage {
            id: middle
            anchors.top: parent.top
            anchors.bottom: parent.bottom
            anchors.horizontalCenter: parent.horizontalCenter
            height: shootButton.height + units.gu(1)
            width: shootButton.width
            source: "assets/toolbar-middle.png"
            Image {
                id: shootButton
                width: units.gu(8)
                height: width
                anchors.horizontalCenter: parent.horizontalCenter
                source: shootImagePath
                MouseArea {
                    anchors.fill: parent
                    onClicked: {
                        if (ui.state === "camera") {
                            camera.imageCapture.capture();
                        } else if (ui.state === "audio") {
                            ui.parent.exec("com.cordova.Capture", "record");
                            if (isSuffix(shootButton.source, recordOffImagePath)) {
                                shootButton.source = recordOnImagePath
                            } else {
                                shootButton.source = recordOffImagePath
                            }
                        } else if (ui.state === "videoRecording") {
                            if (!camera.videoRecorder.recorderState) {
                                shootButton.source = recordOnImagePath
                                camera.videoRecorder.record();
                            } else {
                                camera.videoRecorder.stop();
                                shootButton.source = recordOffImagePath
                            }
                        }
                    }
                }
            }
        }
        BorderImage {
            id: rightBackground
            anchors.right: parent.right
            anchors.top: parent.top
            anchors.bottom: parent.bottom
            anchors.left: middle.right
            anchors.topMargin: units.dp(2)
            anchors.bottomMargin: units.dp(2)
            source: "assets/toolbar-right.png"
        }
    }
    states: [
        State {
            name: "off"
            StateChangeScript {
                script:{
		    ui.visible = false;
                    camera.stop();
                    camera.start();
                    camera.stop();
                    camera.unlock();
                }
            }
        },
        State {
            name: "camera"
            StateChangeScript {
                script: {
                    camera.start();
		    microphoneImage.visible = false
                    output.visible = true
                    shootButton.source = shootImagePath
                    ui.visible = true
                }
            }
        },
        State {
            name: "videoRecording"
            StateChangeScript {
                script: {
                    shootButton.source = recordOffImagePath
                    camera.start();
		    microphoneImage.visible = false
                    output.visible = true
                    ui.visible = true
                }
            }
        },
        State {
            name: "audio"
            StateChangeScript {
                script:{
                    shootButton.source = recordOffImagePath
                    camera.stop();
		    microphoneImage.visible = true
                    camera.unlock();
                    output.visible = false
                    ui.visible = true
                }
            }
        }
    ]
}
