{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetFilled: Boolean;
    procedure SetFilled(const Value: Boolean);
    function GetHatchColor: TCastleColorRGB;
    procedure SetHatchColor(const Value: TCastleColorRGB);
    function GetHatched: Boolean;
    procedure SetHatched(const Value: Boolean);
    function GetHatchStyle: Integer;
    procedure SetHatchStyle(const Value: Integer);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdFilled: TSFBool;
    { Internal wrapper for property @link(Filled). This wrapper API may change, we advise to access simpler @link(Filled) instead. }
    public property FdFilled: TSFBool read FFdFilled;
    {  }
    property Filled: Boolean read GetFilled write SetFilled;

    strict private FFdHatchColor: TSFColor;
    { Internal wrapper for property @link(HatchColor). This wrapper API may change, we advise to access simpler @link(HatchColor) instead. }
    public property FdHatchColor: TSFColor read FFdHatchColor;
    {  }
    property HatchColor: TCastleColorRGB read GetHatchColor write SetHatchColor;

    strict private FFdHatched: TSFBool;
    { Internal wrapper for property @link(Hatched). This wrapper API may change, we advise to access simpler @link(Hatched) instead. }
    public property FdHatched: TSFBool read FFdHatched;
    {  }
    property Hatched: Boolean read GetHatched write SetHatched;

    strict private FFdHatchStyle: TSFInt32;
    { Internal wrapper for property @link(HatchStyle). This wrapper API may change, we advise to access simpler @link(HatchStyle) instead. }
    public property FdHatchStyle: TSFInt32 read FFdHatchStyle;
    {  }
    property HatchStyle: Integer read GetHatchStyle write SetHatchStyle;

{$endif read_interface}

{$ifdef read_implementation}

{ TFillPropertiesNode ----------------------------------------------- }

function TFillPropertiesNode.GetFilled: Boolean;
begin
  Result := FdFilled.Value;
end;

procedure TFillPropertiesNode.SetFilled(const Value: Boolean);
begin
  FdFilled.Send(Value);
end;

function TFillPropertiesNode.GetHatchColor: TCastleColorRGB;
begin
  Result := FdHatchColor.Value;
end;

procedure TFillPropertiesNode.SetHatchColor(const Value: TCastleColorRGB);
begin
  FdHatchColor.Send(Value);
end;

function TFillPropertiesNode.GetHatched: Boolean;
begin
  Result := FdHatched.Value;
end;

procedure TFillPropertiesNode.SetHatched(const Value: Boolean);
begin
  FdHatched.Send(Value);
end;

function TFillPropertiesNode.GetHatchStyle: Integer;
begin
  Result := FdHatchStyle.Value;
end;

procedure TFillPropertiesNode.SetHatchStyle(const Value: Integer);
begin
  FdHatchStyle.Send(Value);
end;

class function TFillPropertiesNode.ClassX3DType: String;
begin
  Result := 'FillProperties';
end;

procedure TFillPropertiesNode.CreateNode;
begin
  inherited;

  FFdFilled := TSFBool.Create(Self, True, 'filled', true);
   FdFilled.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdFilled);

  FFdHatchColor := TSFColor.Create(Self, True, 'hatchColor', Vector3(1, 1, 1));
   FdHatchColor.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdHatchColor);

  FFdHatched := TSFBool.Create(Self, True, 'hatched', true);
   FdHatched.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdHatched);

  FFdHatchStyle := TSFInt32.Create(Self, True, 'hatchStyle', 1);
   FdHatchStyle.ChangeAlways := chVisibleNonGeometry;
   FdHatchStyle.MustBeNonnegative := true;
  AddField(FFdHatchStyle);

  DefaultContainerField := 'fillProperties';
end;

{$endif read_implementation}
