{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetEnabled: boolean;
    procedure SetEnabled(const Value: boolean);
    function GetNeedsDepth: boolean;
    procedure SetNeedsDepth(const Value: boolean);
  public
    property Enabled: boolean read GetEnabled write SetEnabled;
    property NeedsDepth: boolean read GetNeedsDepth write SetNeedsDepth;
    procedure SetShaders(const Value: array of TAbstractShaderNode);

{$endif read_interface}

{$ifdef read_implementation}

{ TScreenEffectNode ----------------------------------------------- }

function TScreenEffectNode.GetEnabled: boolean;
begin
  Result := FdEnabled.Value;
end;

procedure TScreenEffectNode.SetEnabled(const Value: boolean);
begin
  FdEnabled.Send(Value);
end;

function TScreenEffectNode.GetNeedsDepth: boolean;
begin
  Result := FdNeedsDepth.Value;
end;

procedure TScreenEffectNode.SetNeedsDepth(const Value: boolean);
begin
  FdNeedsDepth.Send(Value);
end;

procedure TScreenEffectNode.SetShaders(const Value: array of TAbstractShaderNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractShaderNode));
  FdShaders.Send(A);
end;

{$endif read_implementation}
