#include "Base/Axis/Frame.h"
#include "Base/Axis/MakeScale.h"
#include "Device/Data/DataUtil.h"
#include "Device/Data/Datafield.h"
#include "Tests/GTestWrapper/google_test.h"
#include <algorithm>

class DatafieldTest : public ::testing::Test {
protected:
    DatafieldTest()
        : db_data{{newEquiDivision("angle", 20, 0.0, 0.1), newEquiDivision("length", 10, 0.0, 0.5)}}
    {
        for (size_t i = 0; i < 200; ++i)
            db_data[i] = (double)i;
    }
    Datafield db_data;
};


TEST_F(DatafieldTest, SizeAfterAddingAxes)
{
    EXPECT_EQ(200u, db_data.size());
}

TEST_F(DatafieldTest, DataInitialization)
{
    std::vector<unsigned> coordinates;
    coordinates.push_back(11);
    coordinates.push_back(4);
    EXPECT_DOUBLE_EQ(114., db_data[db_data.frame().toGlobalIndex(coordinates)]);
}

TEST_F(DatafieldTest, SetCleared)
{
    db_data.setAllTo(1.0);
    EXPECT_EQ(db_data[0], 1.0);
}
