# -*- coding: utf-8 -*-

# Bluemindo: A really simple but powerful audio player in Python/PyGTK.
# Copyright (C) 2007-2009  Erwan Briand

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation version 3 of the License.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from gobject import markup_escape_text
from gtk.glade import XML as glade_XML
from os import getcwd
from os.path import join
import tagpy

from common.sqlite import SQLite

class EditSong(object):
    def __init__(self):
        self.song_to_edit = None

    def edit_song_datas(self, song):
        """Edit datas of a song."""
        self.song_to_edit = song

        self.widgets = glade_XML(join(getcwd(), 'modules', 'explorer',
                       'editsongwindow.glade'), 'window1', domain='bluemindo')
        self.window = self.widgets.get_widget('window1')

        lbl_title = self.widgets.get_widget('label1')
        replace = (markup_escape_text(song[0]), markup_escape_text(song[1]))
        lbl_title.set_markup('<b>Edit %s - %s</b>' % replace)
        self.window.set_title('Edit %s - %s' % replace)

        entry_title = self.widgets.get_widget('entry1')
        entry_artist = self.widgets.get_widget('entry2')
        entry_album = self.widgets.get_widget('entry3')
        entry_comment = self.widgets.get_widget('entry6')
        entry_genre = self.widgets.get_widget('entry5')

        entry_title.set_text(song[0])
        entry_artist.set_text(song[1])
        entry_album.set_text(song[2])
        entry_comment.set_text(song[3])
        entry_genre.set_text(song[4])

        spin_track = self.widgets.get_widget('spinbutton1')
        spin_year = self.widgets.get_widget('spinbutton2')

        spin_track.set_value(float(song[6]))
        spin_year.set_value(float(song[5]))

        button_cancel = self.widgets.get_widget('button-cancel')
        button_validate = self.widgets.get_widget('button-validate')

        button_cancel.connect('clicked', self.cancel)
        button_validate.connect('clicked', self.validate)

    def cancel(self, widget):
        """Cancel and close"""
        self.window.destroy()
        self.song_to_edit = None
        
    def validate(self, widget):
        """Write the new datas on the file."""
        filename = self.song_to_edit[8]

        entry_title = self.widgets.get_widget('entry1')
        entry_artist = self.widgets.get_widget('entry2')
        entry_album = self.widgets.get_widget('entry3')
        entry_comment = self.widgets.get_widget('entry6')
        entry_genre = self.widgets.get_widget('entry5')
        spin_track = self.widgets.get_widget('spinbutton1')
        spin_year = self.widgets.get_widget('spinbutton2')

        title = str(entry_title.get_text())
        artist = str(entry_artist.get_text())
        album = str(entry_album.get_text())
        comment = str(entry_comment.get_text())
        genre = str(entry_genre.get_text())
        track = int(spin_track.get_value())
        year = int(spin_year.get_value())

        # tagpy initialization
        filetag = tagpy.FileRef(filename)

        tags = filetag.tag()

        tags.title = title
        tags.artist = artist
        tags.album = album
        tags.comment = comment
        tags.genre = genre
        tags.track = track
        tags.year = year

        filetag.save()

        # SQL modifications
        sqlite = SQLite()
        sqlite.execute('update songs set title ="%(title)s", '
                       'artist ="%(artist)s", album ="%(album)s", '
                       'comment ="%(comment)s", genre ="%(genre)s", '
                       'track ="%(track)s", year="%(year)s" where '
                       'filename ="(%(filename)s"' %
                       {'title': title,
                        'artist': artist,
                        'album': album,
                        'comment': comment,
                        'genre': genre,
                        'track': str(track),
                        'year': str(year),
                        'filename': filename
                       })
        sqlite.close()

        # Close everything
        self.cancel(None)