// ---------------------------------------------------------------------------
// - cloc.hxx                                                                -
// - standard platform library - c localization platform function definition -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2012 amaury darsch                                   -
// ---------------------------------------------------------------------------

// check for unknown platform
#if (AFNIX_PLATFORM_PLATID == AFNIX_PLATFORM_UNKNOWN)
#error "unknown platform type"
#endif

// check for unknown processor
#if (AFNIX_PLATFORM_PROCID == AFNIX_PROCTYPE_UNKNOWN)
#error "unknown processor type"
#endif

#include <locale.h>

namespace afnix {

  // ISO-8859-01 transcoding table
  static const t_quad ISO_8859_01_MAP[256] = {
    0x00000000, // NULL
    0x00000001, // START OF HEADING
    0x00000002, // START OF TEXT
    0x00000003, // END OF TEXT
    0x00000004, // END OF TRANSMISSION
    0x00000005, // ENQUIRY
    0x00000006, // ACKNOWLEDGE
    0x00000007, // BELL
    0x00000008, // BACKSPACE
    0x00000009, // HORIZONTAL TABULATION
    0x0000000A, // LINE FEED
    0x0000000B, // VERTICAL TABULATION
    0x0000000C, // FORM FEED
    0x0000000D, // CARRIAGE RETURN
    0x0000000E, // SHIFT OUT
    0x0000000F, // SHIFT IN
    0x00000010, // DATA LINK ESCAPE
    0x00000011, // DEVICE CONTROL ONE
    0x00000012, // DEVICE CONTROL TWO
    0x00000013, // DEVICE CONTROL THREE
    0x00000014, // DEVICE CONTROL FOUR
    0x00000015, // NEGATIVE ACKNOWLEDGE
    0x00000016, // SYNCHRONOUS IDLE
    0x00000017, // END OF TRANSMISSION BLOCK
    0x00000018, // CANCEL
    0x00000019, // END OF MEDIUM
    0x0000001A, // SUBSTITUTE
    0x0000001B, // ESCAPE
    0x0000001C, // FILE SEPARATOR
    0x0000001D, // GROUP SEPARATOR
    0x0000001E, // RECORD SEPARATOR
    0x0000001F, // UNIT SEPARATOR
    0x00000020, // SPACE
    0x00000021, // EXCLAMATION MARK
    0x00000022, // QUOTATION MARK
    0x00000023, // NUMBER SIGN
    0x00000024, // DOLLAR SIGN
    0x00000025, // PERCENT SIGN
    0x00000026, // AMPERSAND
    0x00000027, // APOSTROPHE
    0x00000028, // LEFT PARENTHESIS
    0x00000029, // RIGHT PARENTHESIS
    0x0000002A, // ASTERISK
    0x0000002B, // PLUS SIGN
    0x0000002C, // COMMA
    0x0000002D, // HYPHEN-MINUS
    0x0000002E, // FULL STOP
    0x0000002F, // SOLIDUS
    0x00000030, // DIGIT ZERO
    0x00000031, // DIGIT ONE
    0x00000032, // DIGIT TWO
    0x00000033, // DIGIT THREE
    0x00000034, // DIGIT FOUR
    0x00000035, // DIGIT FIVE
    0x00000036, // DIGIT SIX
    0x00000037, // DIGIT SEVEN
    0x00000038, // DIGIT EIGHT
    0x00000039, // DIGIT NINE
    0x0000003A, // COLON
    0x0000003B, // SEMICOLON
    0x0000003C, // LESS-THAN SIGN
    0x0000003D, // EQUALS SIGN
    0x0000003E, // GREATER-THAN SIGN
    0x0000003F, // QUESTION MARK
    0x00000040, // COMMERCIAL AT
    0x00000041, // LATIN CAPITAL LETTER A
    0x00000042, // LATIN CAPITAL LETTER B
    0x00000043, // LATIN CAPITAL LETTER C
    0x00000044, // LATIN CAPITAL LETTER D
    0x00000045, // LATIN CAPITAL LETTER E
    0x00000046, // LATIN CAPITAL LETTER F
    0x00000047, // LATIN CAPITAL LETTER G
    0x00000048, // LATIN CAPITAL LETTER H
    0x00000049, // LATIN CAPITAL LETTER I
    0x0000004A, // LATIN CAPITAL LETTER J
    0x0000004B, // LATIN CAPITAL LETTER K
    0x0000004C, // LATIN CAPITAL LETTER L
    0x0000004D, // LATIN CAPITAL LETTER M
    0x0000004E, // LATIN CAPITAL LETTER N
    0x0000004F, // LATIN CAPITAL LETTER O
    0x00000050, // LATIN CAPITAL LETTER P
    0x00000051, // LATIN CAPITAL LETTER Q
    0x00000052, // LATIN CAPITAL LETTER R
    0x00000053, // LATIN CAPITAL LETTER S
    0x00000054, // LATIN CAPITAL LETTER T
    0x00000055, // LATIN CAPITAL LETTER U
    0x00000056, // LATIN CAPITAL LETTER V
    0x00000057, // LATIN CAPITAL LETTER W
    0x00000058, // LATIN CAPITAL LETTER X
    0x00000059, // LATIN CAPITAL LETTER Y
    0x0000005A, // LATIN CAPITAL LETTER Z
    0x0000005B, // LEFT SQUARE BRACKET
    0x0000005C, // REVERSE SOLIDUS
    0x0000005D, // RIGHT SQUARE BRACKET
    0x0000005E, // CIRCUMFLEX ACCENT
    0x0000005F, // LOW LINE
    0x00000060, // GRAVE ACCENT
    0x00000061, // LATIN SMALL LETTER A
    0x00000062, // LATIN SMALL LETTER B
    0x00000063, // LATIN SMALL LETTER C
    0x00000064, // LATIN SMALL LETTER D
    0x00000065, // LATIN SMALL LETTER E
    0x00000066, // LATIN SMALL LETTER F
    0x00000067, // LATIN SMALL LETTER G
    0x00000068, // LATIN SMALL LETTER H
    0x00000069, // LATIN SMALL LETTER I
    0x0000006A, // LATIN SMALL LETTER J
    0x0000006B, // LATIN SMALL LETTER K
    0x0000006C, // LATIN SMALL LETTER L
    0x0000006D, // LATIN SMALL LETTER M
    0x0000006E, // LATIN SMALL LETTER N
    0x0000006F, // LATIN SMALL LETTER O
    0x00000070, // LATIN SMALL LETTER P
    0x00000071, // LATIN SMALL LETTER Q
    0x00000072, // LATIN SMALL LETTER R
    0x00000073, // LATIN SMALL LETTER S
    0x00000074, // LATIN SMALL LETTER T
    0x00000075, // LATIN SMALL LETTER U
    0x00000076, // LATIN SMALL LETTER V
    0x00000077, // LATIN SMALL LETTER W
    0x00000078, // LATIN SMALL LETTER X
    0x00000079, // LATIN SMALL LETTER Y
    0x0000007A, // LATIN SMALL LETTER Z
    0x0000007B, // LEFT CURLY BRACKET
    0x0000007C, // VERTICAL LINE
    0x0000007D, // RIGHT CURLY BRACKET
    0x0000007E, // TILDE
    0x0000007F, // DELETE
    0x00000080, // <control>
    0x00000081, // <control>
    0x00000082, // <control>
    0x00000083, // <control>
    0x00000084, // <control>
    0x00000085, // <control>
    0x00000086, // <control>
    0x00000087, // <control>
    0x00000088, // <control>
    0x00000089, // <control>
    0x0000008A, // <control>
    0x0000008B, // <control>
    0x0000008C, // <control>
    0x0000008D, // <control>
    0x0000008E, // <control>
    0x0000008F, // <control>
    0x00000090, // <control>
    0x00000091, // <control>
    0x00000092, // <control>
    0x00000093, // <control>
    0x00000094, // <control>
    0x00000095, // <control>
    0x00000096, // <control>
    0x00000097, // <control>
    0x00000098, // <control>
    0x00000099, // <control>
    0x0000009A, // <control>
    0x0000009B, // <control>
    0x0000009C, // <control>
    0x0000009D, // <control>
    0x0000009E, // <control>
    0x0000009F, // <control>
    0x000000A0, // NO-BREAK SPACE
    0x000000A1, // INVERTED EXCLAMATION MARK
    0x000000A2, // CENT SIGN
    0x000000A3, // POUND SIGN
    0x000000A4, // CURRENCY SIGN
    0x000000A5, // YEN SIGN
    0x000000A6, // BROKEN BAR
    0x000000A7, // SECTION SIGN
    0x000000A8, // DIAERESIS
    0x000000A9, // COPYRIGHT SIGN
    0x000000AA, // FEMININE ORDINAL INDICATOR
    0x000000AB, // LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x000000AC, // NOT SIGN
    0x000000AD, // SOFT HYPHEN
    0x000000AE, // REGISTERED SIGN
    0x000000AF, // MACRON
    0x000000B0, // DEGREE SIGN
    0x000000B1, // PLUS-MINUS SIGN
    0x000000B2, // SUPERSCRIPT TWO
    0x000000B3, // SUPERSCRIPT THREE
    0x000000B4, // ACUTE ACCENT
    0x000000B5, // MICRO SIGN
    0x000000B6, // PILCROW SIGN
    0x000000B7, // MIDDLE DOT
    0x000000B8, // CEDILLA
    0x000000B9, // SUPERSCRIPT ONE
    0x000000BA, // MASCULINE ORDINAL INDICATOR
    0x000000BB, // RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x000000BC, // VULGAR FRACTION ONE QUARTER
    0x000000BD, // VULGAR FRACTION ONE HALF
    0x000000BE, // VULGAR FRACTION THREE QUARTERS
    0x000000BF, // INVERTED QUESTION MARK
    0x000000C0, // LATIN CAPITAL LETTER A WITH GRAVE
    0x000000C1, // LATIN CAPITAL LETTER A WITH ACUTE
    0x000000C2, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
    0x000000C3, // LATIN CAPITAL LETTER A WITH TILDE
    0x000000C4, // LATIN CAPITAL LETTER A WITH DIAERESIS
    0x000000C5, // LATIN CAPITAL LETTER A WITH RING ABOVE
    0x000000C6, // LATIN CAPITAL LETTER AE
    0x000000C7, // LATIN CAPITAL LETTER C WITH CEDILLA
    0x000000C8, // LATIN CAPITAL LETTER E WITH GRAVE
    0x000000C9, // LATIN CAPITAL LETTER E WITH ACUTE
    0x000000CA, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX
    0x000000CB, // LATIN CAPITAL LETTER E WITH DIAERESIS
    0x000000CC, // LATIN CAPITAL LETTER I WITH GRAVE
    0x000000CD, // LATIN CAPITAL LETTER I WITH ACUTE
    0x000000CE, // LATIN CAPITAL LETTER I WITH CIRCUMFLEX
    0x000000CF, // LATIN CAPITAL LETTER I WITH DIAERESIS
    0x000000D0, // LATIN CAPITAL LETTER ETH (Icelandic)
    0x000000D1, // LATIN CAPITAL LETTER N WITH TILDE
    0x000000D2, // LATIN CAPITAL LETTER O WITH GRAVE
    0x000000D3, // LATIN CAPITAL LETTER O WITH ACUTE
    0x000000D4, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
    0x000000D5, // LATIN CAPITAL LETTER O WITH TILDE
    0x000000D6, // LATIN CAPITAL LETTER O WITH DIAERESIS
    0x000000D7, // MULTIPLICATION SIGN
    0x000000D8, // LATIN CAPITAL LETTER O WITH STROKE
    0x000000D9, // LATIN CAPITAL LETTER U WITH GRAVE
    0x000000DA, // LATIN CAPITAL LETTER U WITH ACUTE
    0x000000DB, // LATIN CAPITAL LETTER U WITH CIRCUMFLEX
    0x000000DC, // LATIN CAPITAL LETTER U WITH DIAERESIS
    0x000000DD, // LATIN CAPITAL LETTER Y WITH ACUTE
    0x000000DE, // LATIN CAPITAL LETTER THORN (Icelandic)
    0x000000DF, // LATIN SMALL LETTER SHARP S (German)
    0x000000E0, // LATIN SMALL LETTER A WITH GRAVE
    0x000000E1, // LATIN SMALL LETTER A WITH ACUTE
    0x000000E2, // LATIN SMALL LETTER A WITH CIRCUMFLEX
    0x000000E3, // LATIN SMALL LETTER A WITH TILDE
    0x000000E4, // LATIN SMALL LETTER A WITH DIAERESIS
    0x000000E5, // LATIN SMALL LETTER A WITH RING ABOVE
    0x000000E6, // LATIN SMALL LETTER AE
    0x000000E7, // LATIN SMALL LETTER C WITH CEDILLA
    0x000000E8, // LATIN SMALL LETTER E WITH GRAVE
    0x000000E9, // LATIN SMALL LETTER E WITH ACUTE
    0x000000EA, // LATIN SMALL LETTER E WITH CIRCUMFLEX
    0x000000EB, // LATIN SMALL LETTER E WITH DIAERESIS
    0x000000EC, // LATIN SMALL LETTER I WITH GRAVE
    0x000000ED, // LATIN SMALL LETTER I WITH ACUTE
    0x000000EE, // LATIN SMALL LETTER I WITH CIRCUMFLEX
    0x000000EF, // LATIN SMALL LETTER I WITH DIAERESIS
    0x000000F0, // LATIN SMALL LETTER ETH (Icelandic)
    0x000000F1, // LATIN SMALL LETTER N WITH TILDE
    0x000000F2, // LATIN SMALL LETTER O WITH GRAVE
    0x000000F3, // LATIN SMALL LETTER O WITH ACUTE
    0x000000F4, // LATIN SMALL LETTER O WITH CIRCUMFLEX
    0x000000F5, // LATIN SMALL LETTER O WITH TILDE
    0x000000F6, // LATIN SMALL LETTER O WITH DIAERESIS
    0x000000F7, // DIVISION SIGN
    0x000000F8, // LATIN SMALL LETTER O WITH STROKE
    0x000000F9, // LATIN SMALL LETTER U WITH GRAVE
    0x000000FA, // LATIN SMALL LETTER U WITH ACUTE
    0x000000FB, // LATIN SMALL LETTER U WITH CIRCUMFLEX
    0x000000FC, // LATIN SMALL LETTER U WITH DIAERESIS
    0x000000FD, // LATIN SMALL LETTER Y WITH ACUTE
    0x000000FE, // LATIN SMALL LETTER THORN (Icelandic)
    0x000000FF  // LATIN SMALL LETTER Y WITH DIAERESIS
  };

  // ISO-8859-02 transcoding table
  static const t_quad ISO_8859_02_MAP[256] = {
    0x00000000, // NULL
    0x00000001, // START OF HEADING
    0x00000002, // START OF TEXT
    0x00000003, // END OF TEXT
    0x00000004, // END OF TRANSMISSION
    0x00000005, // ENQUIRY
    0x00000006, // ACKNOWLEDGE
    0x00000007, // BELL
    0x00000008, // BACKSPACE
    0x00000009, // HORIZONTAL TABULATION
    0x0000000A, // LINE FEED
    0x0000000B, // VERTICAL TABULATION
    0x0000000C, // FORM FEED
    0x0000000D, // CARRIAGE RETURN
    0x0000000E, // SHIFT OUT
    0x0000000F, // SHIFT IN
    0x00000010, // DATA LINK ESCAPE
    0x00000011, // DEVICE CONTROL ONE
    0x00000012, // DEVICE CONTROL TWO
    0x00000013, // DEVICE CONTROL THREE
    0x00000014, // DEVICE CONTROL FOUR
    0x00000015, // NEGATIVE ACKNOWLEDGE
    0x00000016, // SYNCHRONOUS IDLE
    0x00000017, // END OF TRANSMISSION BLOCK
    0x00000018, // CANCEL
    0x00000019, // END OF MEDIUM
    0x0000001A, // SUBSTITUTE
    0x0000001B, // ESCAPE
    0x0000001C, // FILE SEPARATOR
    0x0000001D, // GROUP SEPARATOR
    0x0000001E, // RECORD SEPARATOR
    0x0000001F, // UNIT SEPARATOR
    0x00000020, // SPACE
    0x00000021, // EXCLAMATION MARK
    0x00000022, // QUOTATION MARK
    0x00000023, // NUMBER SIGN
    0x00000024, // DOLLAR SIGN
    0x00000025, // PERCENT SIGN
    0x00000026, // AMPERSAND
    0x00000027, // APOSTROPHE
    0x00000028, // LEFT PARENTHESIS
    0x00000029, // RIGHT PARENTHESIS
    0x0000002A, // ASTERISK
    0x0000002B, // PLUS SIGN
    0x0000002C, // COMMA
    0x0000002D, // HYPHEN-MINUS
    0x0000002E, // FULL STOP
    0x0000002F, // SOLIDUS
    0x00000030, // DIGIT ZERO
    0x00000031, // DIGIT ONE
    0x00000032, // DIGIT TWO
    0x00000033, // DIGIT THREE
    0x00000034, // DIGIT FOUR
    0x00000035, // DIGIT FIVE
    0x00000036, // DIGIT SIX
    0x00000037, // DIGIT SEVEN
    0x00000038, // DIGIT EIGHT
    0x00000039, // DIGIT NINE
    0x0000003A, // COLON
    0x0000003B, // SEMICOLON
    0x0000003C, // LESS-THAN SIGN
    0x0000003D, // EQUALS SIGN
    0x0000003E, // GREATER-THAN SIGN
    0x0000003F, // QUESTION MARK
    0x00000040, // COMMERCIAL AT
    0x00000041, // LATIN CAPITAL LETTER A
    0x00000042, // LATIN CAPITAL LETTER B
    0x00000043, // LATIN CAPITAL LETTER C
    0x00000044, // LATIN CAPITAL LETTER D
    0x00000045, // LATIN CAPITAL LETTER E
    0x00000046, // LATIN CAPITAL LETTER F
    0x00000047, // LATIN CAPITAL LETTER G
    0x00000048, // LATIN CAPITAL LETTER H
    0x00000049, // LATIN CAPITAL LETTER I
    0x0000004A, // LATIN CAPITAL LETTER J
    0x0000004B, // LATIN CAPITAL LETTER K
    0x0000004C, // LATIN CAPITAL LETTER L
    0x0000004D, // LATIN CAPITAL LETTER M
    0x0000004E, // LATIN CAPITAL LETTER N
    0x0000004F, // LATIN CAPITAL LETTER O
    0x00000050, // LATIN CAPITAL LETTER P
    0x00000051, // LATIN CAPITAL LETTER Q
    0x00000052, // LATIN CAPITAL LETTER R
    0x00000053, // LATIN CAPITAL LETTER S
    0x00000054, // LATIN CAPITAL LETTER T
    0x00000055, // LATIN CAPITAL LETTER U
    0x00000056, // LATIN CAPITAL LETTER V
    0x00000057, // LATIN CAPITAL LETTER W
    0x00000058, // LATIN CAPITAL LETTER X
    0x00000059, // LATIN CAPITAL LETTER Y
    0x0000005A, // LATIN CAPITAL LETTER Z
    0x0000005B, // LEFT SQUARE BRACKET
    0x0000005C, // REVERSE SOLIDUS
    0x0000005D, // RIGHT SQUARE BRACKET
    0x0000005E, // CIRCUMFLEX ACCENT
    0x0000005F, // LOW LINE
    0x00000060, // GRAVE ACCENT
    0x00000061, // LATIN SMALL LETTER A
    0x00000062, // LATIN SMALL LETTER B
    0x00000063, // LATIN SMALL LETTER C
    0x00000064, // LATIN SMALL LETTER D
    0x00000065, // LATIN SMALL LETTER E
    0x00000066, // LATIN SMALL LETTER F
    0x00000067, // LATIN SMALL LETTER G
    0x00000068, // LATIN SMALL LETTER H
    0x00000069, // LATIN SMALL LETTER I
    0x0000006A, // LATIN SMALL LETTER J
    0x0000006B, // LATIN SMALL LETTER K
    0x0000006C, // LATIN SMALL LETTER L
    0x0000006D, // LATIN SMALL LETTER M
    0x0000006E, // LATIN SMALL LETTER N
    0x0000006F, // LATIN SMALL LETTER O
    0x00000070, // LATIN SMALL LETTER P
    0x00000071, // LATIN SMALL LETTER Q
    0x00000072, // LATIN SMALL LETTER R
    0x00000073, // LATIN SMALL LETTER S
    0x00000074, // LATIN SMALL LETTER T
    0x00000075, // LATIN SMALL LETTER U
    0x00000076, // LATIN SMALL LETTER V
    0x00000077, // LATIN SMALL LETTER W
    0x00000078, // LATIN SMALL LETTER X
    0x00000079, // LATIN SMALL LETTER Y
    0x0000007A, // LATIN SMALL LETTER Z
    0x0000007B, // LEFT CURLY BRACKET
    0x0000007C, // VERTICAL LINE
    0x0000007D, // RIGHT CURLY BRACKET
    0x0000007E, // TILDE
    0x0000007F, // DELETE
    0x00000080, // <control>
    0x00000081, // <control>
    0x00000082, // <control>
    0x00000083, // <control>
    0x00000084, // <control>
    0x00000085, // <control>
    0x00000086, // <control>
    0x00000087, // <control>
    0x00000088, // <control>
    0x00000089, // <control>
    0x0000008A, // <control>
    0x0000008B, // <control>
    0x0000008C, // <control>
    0x0000008D, // <control>
    0x0000008E, // <control>
    0x0000008F, // <control>
    0x00000090, // <control>
    0x00000091, // <control>
    0x00000092, // <control>
    0x00000093, // <control>
    0x00000094, // <control>
    0x00000095, // <control>
    0x00000096, // <control>
    0x00000097, // <control>
    0x00000098, // <control>
    0x00000099, // <control>
    0x0000009A, // <control>
    0x0000009B, // <control>
    0x0000009C, // <control>
    0x0000009D, // <control>
    0x0000009E, // <control>
    0x0000009F, // <control>
    0x000000A0, // NO-BREAK SPACE
    0x00000104, // LATIN CAPITAL LETTER A WITH OGONEK
    0x000002D8, // BREVE
    0x00000141, // LATIN CAPITAL LETTER L WITH STROKE
    0x000000A4, // CURRENCY SIGN
    0x0000013D, // LATIN CAPITAL LETTER L WITH CARON
    0x0000015A, // LATIN CAPITAL LETTER S WITH ACUTE
    0x000000A7, // SECTION SIGN
    0x000000A8, // DIAERESIS
    0x00000160, // LATIN CAPITAL LETTER S WITH CARON
    0x0000015E, // LATIN CAPITAL LETTER S WITH CEDILLA
    0x00000164, // LATIN CAPITAL LETTER T WITH CARON
    0x00000179, // LATIN CAPITAL LETTER Z WITH ACUTE
    0x000000AD, // SOFT HYPHEN
    0x0000017D, // LATIN CAPITAL LETTER Z WITH CARON
    0x0000017B, // LATIN CAPITAL LETTER Z WITH DOT ABOVE
    0x000000B0, // DEGREE SIGN
    0x00000105, // LATIN SMALL LETTER A WITH OGONEK
    0x000002DB, // OGONEK
    0x00000142, // LATIN SMALL LETTER L WITH STROKE
    0x000000B4, // ACUTE ACCENT
    0x0000013E, // LATIN SMALL LETTER L WITH CARON
    0x0000015B, // LATIN SMALL LETTER S WITH ACUTE
    0x000002C7, // CARON
    0x000000B8, // CEDILLA
    0x00000161, // LATIN SMALL LETTER S WITH CARON
    0x0000015F, // LATIN SMALL LETTER S WITH CEDILLA
    0x00000165, // LATIN SMALL LETTER T WITH CARON
    0x0000017A, // LATIN SMALL LETTER Z WITH ACUTE
    0x000002DD, // DOUBLE ACUTE ACCENT
    0x0000017E, // LATIN SMALL LETTER Z WITH CARON
    0x0000017C, // LATIN SMALL LETTER Z WITH DOT ABOVE
    0x00000154, // LATIN CAPITAL LETTER R WITH ACUTE
    0x000000C1, // LATIN CAPITAL LETTER A WITH ACUTE
    0x000000C2, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
    0x00000102, // LATIN CAPITAL LETTER A WITH BREVE
    0x000000C4, // LATIN CAPITAL LETTER A WITH DIAERESIS
    0x00000139, // LATIN CAPITAL LETTER L WITH ACUTE
    0x00000106, // LATIN CAPITAL LETTER C WITH ACUTE
    0x000000C7, // LATIN CAPITAL LETTER C WITH CEDILLA
    0x0000010C, // LATIN CAPITAL LETTER C WITH CARON
    0x000000C9, // LATIN CAPITAL LETTER E WITH ACUTE
    0x00000118, // LATIN CAPITAL LETTER E WITH OGONEK
    0x000000CB, // LATIN CAPITAL LETTER E WITH DIAERESIS
    0x0000011A, // LATIN CAPITAL LETTER E WITH CARON
    0x000000CD, // LATIN CAPITAL LETTER I WITH ACUTE
    0x000000CE, // LATIN CAPITAL LETTER I WITH CIRCUMFLEX
    0x0000010E, // LATIN CAPITAL LETTER D WITH CARON
    0x00000110, // LATIN CAPITAL LETTER D WITH STROKE
    0x00000143, // LATIN CAPITAL LETTER N WITH ACUTE
    0x00000147, // LATIN CAPITAL LETTER N WITH CARON
    0x000000D3, // LATIN CAPITAL LETTER O WITH ACUTE
    0x000000D4, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
    0x00000150, // LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
    0x000000D6, // LATIN CAPITAL LETTER O WITH DIAERESIS
    0x000000D7, // MULTIPLICATION SIGN
    0x00000158, // LATIN CAPITAL LETTER R WITH CARON
    0x0000016E, // LATIN CAPITAL LETTER U WITH RING ABOVE
    0x000000DA, // LATIN CAPITAL LETTER U WITH ACUTE
    0x00000170, // LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
    0x000000DC, // LATIN CAPITAL LETTER U WITH DIAERESIS
    0x000000DD, // LATIN CAPITAL LETTER Y WITH ACUTE
    0x00000162, // LATIN CAPITAL LETTER T WITH CEDILLA
    0x000000DF, // LATIN SMALL LETTER SHARP S
    0x00000155, // LATIN SMALL LETTER R WITH ACUTE
    0x000000E1, // LATIN SMALL LETTER A WITH ACUTE
    0x000000E2, // LATIN SMALL LETTER A WITH CIRCUMFLEX
    0x00000103, // LATIN SMALL LETTER A WITH BREVE
    0x000000E4, // LATIN SMALL LETTER A WITH DIAERESIS
    0x0000013A, // LATIN SMALL LETTER L WITH ACUTE
    0x00000107, // LATIN SMALL LETTER C WITH ACUTE
    0x000000E7, // LATIN SMALL LETTER C WITH CEDILLA
    0x0000010D, // LATIN SMALL LETTER C WITH CARON
    0x000000E9, // LATIN SMALL LETTER E WITH ACUTE
    0x00000119, // LATIN SMALL LETTER E WITH OGONEK
    0x000000EB, // LATIN SMALL LETTER E WITH DIAERESIS
    0x0000011B, // LATIN SMALL LETTER E WITH CARON
    0x000000ED, // LATIN SMALL LETTER I WITH ACUTE
    0x000000EE, // LATIN SMALL LETTER I WITH CIRCUMFLEX
    0x0000010F, // LATIN SMALL LETTER D WITH CARON
    0x00000111, // LATIN SMALL LETTER D WITH STROKE
    0x00000144, // LATIN SMALL LETTER N WITH ACUTE
    0x00000148, // LATIN SMALL LETTER N WITH CARON
    0x000000F3, // LATIN SMALL LETTER O WITH ACUTE
    0x000000F4, // LATIN SMALL LETTER O WITH CIRCUMFLEX
    0x00000151, // LATIN SMALL LETTER O WITH DOUBLE ACUTE
    0x000000F6, // LATIN SMALL LETTER O WITH DIAERESIS
    0x000000F7, // DIVISION SIGN
    0x00000159, // LATIN SMALL LETTER R WITH CARON
    0x0000016F, // LATIN SMALL LETTER U WITH RING ABOVE
    0x000000FA, // LATIN SMALL LETTER U WITH ACUTE
    0x00000171, // LATIN SMALL LETTER U WITH DOUBLE ACUTE
    0x000000FC, // LATIN SMALL LETTER U WITH DIAERESIS
    0x000000FD, // LATIN SMALL LETTER Y WITH ACUTE
    0x00000163, // LATIN SMALL LETTER T WITH CEDILLA
    0x000002D9, // DOT ABOVE
  };

  // ISO-8859-03 transcoding table
  static const t_quad ISO_8859_03_MAP[256] = {
    0x00000000, // NULL
    0x00000001, // START OF HEADING
    0x00000002, // START OF TEXT
    0x00000003, // END OF TEXT
    0x00000004, // END OF TRANSMISSION
    0x00000005, // ENQUIRY
    0x00000006, // ACKNOWLEDGE
    0x00000007, // BELL
    0x00000008, // BACKSPACE
    0x00000009, // HORIZONTAL TABULATION
    0x0000000A, // LINE FEED
    0x0000000B, // VERTICAL TABULATION
    0x0000000C, // FORM FEED
    0x0000000D, // CARRIAGE RETURN
    0x0000000E, // SHIFT OUT
    0x0000000F, // SHIFT IN
    0x00000010, // DATA LINK ESCAPE
    0x00000011, // DEVICE CONTROL ONE
    0x00000012, // DEVICE CONTROL TWO
    0x00000013, // DEVICE CONTROL THREE
    0x00000014, // DEVICE CONTROL FOUR
    0x00000015, // NEGATIVE ACKNOWLEDGE
    0x00000016, // SYNCHRONOUS IDLE
    0x00000017, // END OF TRANSMISSION BLOCK
    0x00000018, // CANCEL
    0x00000019, // END OF MEDIUM
    0x0000001A, // SUBSTITUTE
    0x0000001B, // ESCAPE
    0x0000001C, // FILE SEPARATOR
    0x0000001D, // GROUP SEPARATOR
    0x0000001E, // RECORD SEPARATOR
    0x0000001F, // UNIT SEPARATOR
    0x00000020, // SPACE
    0x00000021, // EXCLAMATION MARK
    0x00000022, // QUOTATION MARK
    0x00000023, // NUMBER SIGN
    0x00000024, // DOLLAR SIGN
    0x00000025, // PERCENT SIGN
    0x00000026, // AMPERSAND
    0x00000027, // APOSTROPHE
    0x00000028, // LEFT PARENTHESIS
    0x00000029, // RIGHT PARENTHESIS
    0x0000002A, // ASTERISK
    0x0000002B, // PLUS SIGN
    0x0000002C, // COMMA
    0x0000002D, // HYPHEN-MINUS
    0x0000002E, // FULL STOP
    0x0000002F, // SOLIDUS
    0x00000030, // DIGIT ZERO
    0x00000031, // DIGIT ONE
    0x00000032, // DIGIT TWO
    0x00000033, // DIGIT THREE
    0x00000034, // DIGIT FOUR
    0x00000035, // DIGIT FIVE
    0x00000036, // DIGIT SIX
    0x00000037, // DIGIT SEVEN
    0x00000038, // DIGIT EIGHT
    0x00000039, // DIGIT NINE
    0x0000003A, // COLON
    0x0000003B, // SEMICOLON
    0x0000003C, // LESS-THAN SIGN
    0x0000003D, // EQUALS SIGN
    0x0000003E, // GREATER-THAN SIGN
    0x0000003F, // QUESTION MARK
    0x00000040, // COMMERCIAL AT
    0x00000041, // LATIN CAPITAL LETTER A
    0x00000042, // LATIN CAPITAL LETTER B
    0x00000043, // LATIN CAPITAL LETTER C
    0x00000044, // LATIN CAPITAL LETTER D
    0x00000045, // LATIN CAPITAL LETTER E
    0x00000046, // LATIN CAPITAL LETTER F
    0x00000047, // LATIN CAPITAL LETTER G
    0x00000048, // LATIN CAPITAL LETTER H
    0x00000049, // LATIN CAPITAL LETTER I
    0x0000004A, // LATIN CAPITAL LETTER J
    0x0000004B, // LATIN CAPITAL LETTER K
    0x0000004C, // LATIN CAPITAL LETTER L
    0x0000004D, // LATIN CAPITAL LETTER M
    0x0000004E, // LATIN CAPITAL LETTER N
    0x0000004F, // LATIN CAPITAL LETTER O
    0x00000050, // LATIN CAPITAL LETTER P
    0x00000051, // LATIN CAPITAL LETTER Q
    0x00000052, // LATIN CAPITAL LETTER R
    0x00000053, // LATIN CAPITAL LETTER S
    0x00000054, // LATIN CAPITAL LETTER T
    0x00000055, // LATIN CAPITAL LETTER U
    0x00000056, // LATIN CAPITAL LETTER V
    0x00000057, // LATIN CAPITAL LETTER W
    0x00000058, // LATIN CAPITAL LETTER X
    0x00000059, // LATIN CAPITAL LETTER Y
    0x0000005A, // LATIN CAPITAL LETTER Z
    0x0000005B, // LEFT SQUARE BRACKET
    0x0000005C, // REVERSE SOLIDUS
    0x0000005D, // RIGHT SQUARE BRACKET
    0x0000005E, // CIRCUMFLEX ACCENT
    0x0000005F, // LOW LINE
    0x00000060, // GRAVE ACCENT
    0x00000061, // LATIN SMALL LETTER A
    0x00000062, // LATIN SMALL LETTER B
    0x00000063, // LATIN SMALL LETTER C
    0x00000064, // LATIN SMALL LETTER D
    0x00000065, // LATIN SMALL LETTER E
    0x00000066, // LATIN SMALL LETTER F
    0x00000067, // LATIN SMALL LETTER G
    0x00000068, // LATIN SMALL LETTER H
    0x00000069, // LATIN SMALL LETTER I
    0x0000006A, // LATIN SMALL LETTER J
    0x0000006B, // LATIN SMALL LETTER K
    0x0000006C, // LATIN SMALL LETTER L
    0x0000006D, // LATIN SMALL LETTER M
    0x0000006E, // LATIN SMALL LETTER N
    0x0000006F, // LATIN SMALL LETTER O
    0x00000070, // LATIN SMALL LETTER P
    0x00000071, // LATIN SMALL LETTER Q
    0x00000072, // LATIN SMALL LETTER R
    0x00000073, // LATIN SMALL LETTER S
    0x00000074, // LATIN SMALL LETTER T
    0x00000075, // LATIN SMALL LETTER U
    0x00000076, // LATIN SMALL LETTER V
    0x00000077, // LATIN SMALL LETTER W
    0x00000078, // LATIN SMALL LETTER X
    0x00000079, // LATIN SMALL LETTER Y
    0x0000007A, // LATIN SMALL LETTER Z
    0x0000007B, // LEFT CURLY BRACKET
    0x0000007C, // VERTICAL LINE
    0x0000007D, // RIGHT CURLY BRACKET
    0x0000007E, // TILDE
    0x0000007F, // DELETE
    0x00000080, // <control>
    0x00000081, // <control>
    0x00000082, // <control>
    0x00000083, // <control>
    0x00000084, // <control>
    0x00000085, // <control>
    0x00000086, // <control>
    0x00000087, // <control>
    0x00000088, // <control>
    0x00000089, // <control>
    0x0000008A, // <control>
    0x0000008B, // <control>
    0x0000008C, // <control>
    0x0000008D, // <control>
    0x0000008E, // <control>
    0x0000008F, // <control>
    0x00000090, // <control>
    0x00000091, // <control>
    0x00000092, // <control>
    0x00000093, // <control>
    0x00000094, // <control>
    0x00000095, // <control>
    0x00000096, // <control>
    0x00000097, // <control>
    0x00000098, // <control>
    0x00000099, // <control>
    0x0000009A, // <control>
    0x0000009B, // <control>
    0x0000009C, // <control>
    0x0000009D, // <control>
    0x0000009E, // <control>
    0x0000009F, // <control>
    0x000000A0, // NO-BREAK SPACE
    0x00000126, // LATIN CAPITAL LETTER H WITH STROKE
    0x000002D8, // BREVE
    0x000000A3, // POUND SIGN
    0x000000A4, // CURRENCY SIGN
    0xFFFFFFFF, // <not implemented>
    0x00000124, // LATIN CAPITAL LETTER H WITH CIRCUMFLEX
    0x000000A7, // SECTION SIGN
    0x000000A8, // DIAERESIS
    0x00000130, // LATIN CAPITAL LETTER I WITH DOT ABOVE
    0x0000015E, // LATIN CAPITAL LETTER S WITH CEDILLA
    0x0000011E, // LATIN CAPITAL LETTER G WITH BREVE
    0x00000134, // LATIN CAPITAL LETTER J WITH CIRCUMFLEX
    0x000000AD, // SOFT HYPHEN
    0xFFFFFFFF, // <not implemented>
    0x0000017B, // LATIN CAPITAL LETTER Z WITH DOT ABOVE
    0x000000B0, // DEGREE SIGN
    0x00000127, // LATIN SMALL LETTER H WITH STROKE
    0x000000B2, // SUPERSCRIPT TWO
    0x000000B3, // SUPERSCRIPT THREE
    0x000000B4, // ACUTE ACCENT
    0x000000B5, // MICRO SIGN
    0x00000125, // LATIN SMALL LETTER H WITH CIRCUMFLEX
    0x000000B7, // MIDDLE DOT
    0x000000B8, // CEDILLA
    0x00000131, // LATIN SMALL LETTER DOTLESS I
    0x0000015F, // LATIN SMALL LETTER S WITH CEDILLA
    0x0000011F, // LATIN SMALL LETTER G WITH BREVE
    0x00000135, // LATIN SMALL LETTER J WITH CIRCUMFLEX
    0x000000BD, // VULGAR FRACTION ONE HALF
    0xFFFFFFFF, // <not implemented>
    0x0000017C, // LATIN SMALL LETTER Z WITH DOT ABOVE
    0x000000C0, // LATIN CAPITAL LETTER A WITH GRAVE
    0x000000C1, // LATIN CAPITAL LETTER A WITH ACUTE
    0x000000C2, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
    0xFFFFFFFF, // <not implemented>
    0x000000C4, // LATIN CAPITAL LETTER A WITH DIAERESIS
    0x0000010A, // LATIN CAPITAL LETTER C WITH DOT ABOVE
    0x00000108, // LATIN CAPITAL LETTER C WITH CIRCUMFLEX
    0x000000C7, // LATIN CAPITAL LETTER C WITH CEDILLA
    0x000000C8, // LATIN CAPITAL LETTER E WITH GRAVE
    0x000000C9, // LATIN CAPITAL LETTER E WITH ACUTE
    0x000000CA, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX
    0x000000CB, // LATIN CAPITAL LETTER E WITH DIAERESIS
    0x000000CC, // LATIN CAPITAL LETTER I WITH GRAVE
    0x000000CD, // LATIN CAPITAL LETTER I WITH ACUTE
    0x000000CE, // LATIN CAPITAL LETTER I WITH CIRCUMFLEX
    0x000000CF, // LATIN CAPITAL LETTER I WITH DIAERESIS
    0xFFFFFFFF, // <not implemented>
    0x000000D1, // LATIN CAPITAL LETTER N WITH TILDE
    0x000000D2, // LATIN CAPITAL LETTER O WITH GRAVE
    0x000000D3, // LATIN CAPITAL LETTER O WITH ACUTE
    0x000000D4, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
    0x00000120, // LATIN CAPITAL LETTER G WITH DOT ABOVE
    0x000000D6, // LATIN CAPITAL LETTER O WITH DIAERESIS
    0x000000D7, // MULTIPLICATION SIGN
    0x0000011C, // LATIN CAPITAL LETTER G WITH CIRCUMFLEX
    0x000000D9, // LATIN CAPITAL LETTER U WITH GRAVE
    0x000000DA, // LATIN CAPITAL LETTER U WITH ACUTE
    0x000000DB, // LATIN CAPITAL LETTER U WITH CIRCUMFLEX
    0x000000DC, // LATIN CAPITAL LETTER U WITH DIAERESIS
    0x0000016C, // LATIN CAPITAL LETTER U WITH BREVE
    0x0000015C, // LATIN CAPITAL LETTER S WITH CIRCUMFLEX
    0x000000DF, // LATIN SMALL LETTER SHARP S
    0x000000E0, // LATIN SMALL LETTER A WITH GRAVE
    0x000000E1, // LATIN SMALL LETTER A WITH ACUTE
    0x000000E2, // LATIN SMALL LETTER A WITH CIRCUMFLEX
    0xFFFFFFFF, // <not implemented>
    0x000000E4, // LATIN SMALL LETTER A WITH DIAERESIS
    0x0000010B, // LATIN SMALL LETTER C WITH DOT ABOVE
    0x00000109, // LATIN SMALL LETTER C WITH CIRCUMFLEX
    0x000000E7, // LATIN SMALL LETTER C WITH CEDILLA
    0x000000E8, // LATIN SMALL LETTER E WITH GRAVE
    0x000000E9, // LATIN SMALL LETTER E WITH ACUTE
    0x000000EA, // LATIN SMALL LETTER E WITH CIRCUMFLEX
    0x000000EB, // LATIN SMALL LETTER E WITH DIAERESIS
    0x000000EC, // LATIN SMALL LETTER I WITH GRAVE
    0x000000ED, // LATIN SMALL LETTER I WITH ACUTE
    0x000000EE, // LATIN SMALL LETTER I WITH CIRCUMFLEX
    0x000000EF, // LATIN SMALL LETTER I WITH DIAERESIS
    0xFFFFFFFF, // <not implemented>
    0x000000F1, // LATIN SMALL LETTER N WITH TILDE
    0x000000F2, // LATIN SMALL LETTER O WITH GRAVE
    0x000000F3, // LATIN SMALL LETTER O WITH ACUTE
    0x000000F4, // LATIN SMALL LETTER O WITH CIRCUMFLEX
    0x00000121, // LATIN SMALL LETTER G WITH DOT ABOVE
    0x000000F6, // LATIN SMALL LETTER O WITH DIAERESIS
    0x000000F7, // DIVISION SIGN
    0x0000011D, // LATIN SMALL LETTER G WITH CIRCUMFLEX
    0x000000F9, // LATIN SMALL LETTER U WITH GRAVE
    0x000000FA, // LATIN SMALL LETTER U WITH ACUTE
    0x000000FB, // LATIN SMALL LETTER U WITH CIRCUMFLEX
    0x000000FC, // LATIN SMALL LETTER U WITH DIAERESIS
    0x0000016D, // LATIN SMALL LETTER U WITH BREVE
    0x0000015D, // LATIN SMALL LETTER S WITH CIRCUMFLEX
    0x000002D9  // DOT ABOVE
  };

  // ISO-8859-04  transcoding table
  static const t_quad ISO_8859_04_MAP[256] = {
    0x00000000, // NULL
    0x00000001, // START OF HEADING
    0x00000002, // START OF TEXT
    0x00000003, // END OF TEXT
    0x00000004, // END OF TRANSMISSION
    0x00000005, // ENQUIRY
    0x00000006, // ACKNOWLEDGE
    0x00000007, // BELL
    0x00000008, // BACKSPACE
    0x00000009, // HORIZONTAL TABULATION
    0x0000000A, // LINE FEED
    0x0000000B, // VERTICAL TABULATION
    0x0000000C, // FORM FEED
    0x0000000D, // CARRIAGE RETURN
    0x0000000E, // SHIFT OUT
    0x0000000F, // SHIFT IN
    0x00000010, // DATA LINK ESCAPE
    0x00000011, // DEVICE CONTROL ONE
    0x00000012, // DEVICE CONTROL TWO
    0x00000013, // DEVICE CONTROL THREE
    0x00000014, // DEVICE CONTROL FOUR
    0x00000015, // NEGATIVE ACKNOWLEDGE
    0x00000016, // SYNCHRONOUS IDLE
    0x00000017, // END OF TRANSMISSION BLOCK
    0x00000018, // CANCEL
    0x00000019, // END OF MEDIUM
    0x0000001A, // SUBSTITUTE
    0x0000001B, // ESCAPE
    0x0000001C, // FILE SEPARATOR
    0x0000001D, // GROUP SEPARATOR
    0x0000001E, // RECORD SEPARATOR
    0x0000001F, // UNIT SEPARATOR
    0x00000020, // SPACE
    0x00000021, // EXCLAMATION MARK
    0x00000022, // QUOTATION MARK
    0x00000023, // NUMBER SIGN
    0x00000024, // DOLLAR SIGN
    0x00000025, // PERCENT SIGN
    0x00000026, // AMPERSAND
    0x00000027, // APOSTROPHE
    0x00000028, // LEFT PARENTHESIS
    0x00000029, // RIGHT PARENTHESIS
    0x0000002A, // ASTERISK
    0x0000002B, // PLUS SIGN
    0x0000002C, // COMMA
    0x0000002D, // HYPHEN-MINUS
    0x0000002E, // FULL STOP
    0x0000002F, // SOLIDUS
    0x00000030, // DIGIT ZERO
    0x00000031, // DIGIT ONE
    0x00000032, // DIGIT TWO
    0x00000033, // DIGIT THREE
    0x00000034, // DIGIT FOUR
    0x00000035, // DIGIT FIVE
    0x00000036, // DIGIT SIX
    0x00000037, // DIGIT SEVEN
    0x00000038, // DIGIT EIGHT
    0x00000039, // DIGIT NINE
    0x0000003A, // COLON
    0x0000003B, // SEMICOLON
    0x0000003C, // LESS-THAN SIGN
    0x0000003D, // EQUALS SIGN
    0x0000003E, // GREATER-THAN SIGN
    0x0000003F, // QUESTION MARK
    0x00000040, // COMMERCIAL AT
    0x00000041, // LATIN CAPITAL LETTER A
    0x00000042, // LATIN CAPITAL LETTER B
    0x00000043, // LATIN CAPITAL LETTER C
    0x00000044, // LATIN CAPITAL LETTER D
    0x00000045, // LATIN CAPITAL LETTER E
    0x00000046, // LATIN CAPITAL LETTER F
    0x00000047, // LATIN CAPITAL LETTER G
    0x00000048, // LATIN CAPITAL LETTER H
    0x00000049, // LATIN CAPITAL LETTER I
    0x0000004A, // LATIN CAPITAL LETTER J
    0x0000004B, // LATIN CAPITAL LETTER K
    0x0000004C, // LATIN CAPITAL LETTER L
    0x0000004D, // LATIN CAPITAL LETTER M
    0x0000004E, // LATIN CAPITAL LETTER N
    0x0000004F, // LATIN CAPITAL LETTER O
    0x00000050, // LATIN CAPITAL LETTER P
    0x00000051, // LATIN CAPITAL LETTER Q
    0x00000052, // LATIN CAPITAL LETTER R
    0x00000053, // LATIN CAPITAL LETTER S
    0x00000054, // LATIN CAPITAL LETTER T
    0x00000055, // LATIN CAPITAL LETTER U
    0x00000056, // LATIN CAPITAL LETTER V
    0x00000057, // LATIN CAPITAL LETTER W
    0x00000058, // LATIN CAPITAL LETTER X
    0x00000059, // LATIN CAPITAL LETTER Y
    0x0000005A, // LATIN CAPITAL LETTER Z
    0x0000005B, // LEFT SQUARE BRACKET
    0x0000005C, // REVERSE SOLIDUS
    0x0000005D, // RIGHT SQUARE BRACKET
    0x0000005E, // CIRCUMFLEX ACCENT
    0x0000005F, // LOW LINE
    0x00000060, // GRAVE ACCENT
    0x00000061, // LATIN SMALL LETTER A
    0x00000062, // LATIN SMALL LETTER B
    0x00000063, // LATIN SMALL LETTER C
    0x00000064, // LATIN SMALL LETTER D
    0x00000065, // LATIN SMALL LETTER E
    0x00000066, // LATIN SMALL LETTER F
    0x00000067, // LATIN SMALL LETTER G
    0x00000068, // LATIN SMALL LETTER H
    0x00000069, // LATIN SMALL LETTER I
    0x0000006A, // LATIN SMALL LETTER J
    0x0000006B, // LATIN SMALL LETTER K
    0x0000006C, // LATIN SMALL LETTER L
    0x0000006D, // LATIN SMALL LETTER M
    0x0000006E, // LATIN SMALL LETTER N
    0x0000006F, // LATIN SMALL LETTER O
    0x00000070, // LATIN SMALL LETTER P
    0x00000071, // LATIN SMALL LETTER Q
    0x00000072, // LATIN SMALL LETTER R
    0x00000073, // LATIN SMALL LETTER S
    0x00000074, // LATIN SMALL LETTER T
    0x00000075, // LATIN SMALL LETTER U
    0x00000076, // LATIN SMALL LETTER V
    0x00000077, // LATIN SMALL LETTER W
    0x00000078, // LATIN SMALL LETTER X
    0x00000079, // LATIN SMALL LETTER Y
    0x0000007A, // LATIN SMALL LETTER Z
    0x0000007B, // LEFT CURLY BRACKET
    0x0000007C, // VERTICAL LINE
    0x0000007D, // RIGHT CURLY BRACKET
    0x0000007E, // TILDE
    0x0000007F, // DELETE
    0x00000080, // <control>
    0x00000081, // <control>
    0x00000082, // <control>
    0x00000083, // <control>
    0x00000084, // <control>
    0x00000085, // <control>
    0x00000086, // <control>
    0x00000087, // <control>
    0x00000088, // <control>
    0x00000089, // <control>
    0x0000008A, // <control>
    0x0000008B, // <control>
    0x0000008C, // <control>
    0x0000008D, // <control>
    0x0000008E, // <control>
    0x0000008F, // <control>
    0x00000090, // <control>
    0x00000091, // <control>
    0x00000092, // <control>
    0x00000093, // <control>
    0x00000094, // <control>
    0x00000095, // <control>
    0x00000096, // <control>
    0x00000097, // <control>
    0x00000098, // <control>
    0x00000099, // <control>
    0x0000009A, // <control>
    0x0000009B, // <control>
    0x0000009C, // <control>
    0x0000009D, // <control>
    0x0000009E, // <control>
    0x0000009F, // <control>
    0x000000A0, // NO-BREAK SPACE
    0x00000104, // LATIN CAPITAL LETTER A WITH OGONEK
    0x00000138, // LATIN SMALL LETTER KRA
    0x00000156, // LATIN CAPITAL LETTER R WITH CEDILLA
    0x000000A4, // CURRENCY SIGN
    0x00000128, // LATIN CAPITAL LETTER I WITH TILDE
    0x0000013B, // LATIN CAPITAL LETTER L WITH CEDILLA
    0x000000A7, // SECTION SIGN
    0x000000A8, // DIAERESIS
    0x00000160, // LATIN CAPITAL LETTER S WITH CARON
    0x00000112, // LATIN CAPITAL LETTER E WITH MACRON
    0x00000122, // LATIN CAPITAL LETTER G WITH CEDILLA
    0x00000166, // LATIN CAPITAL LETTER T WITH STROKE
    0x000000AD, // SOFT HYPHEN
    0x0000017D, // LATIN CAPITAL LETTER Z WITH CARON
    0x000000AF, // MACRON
    0x000000B0, // DEGREE SIGN
    0x00000105, // LATIN SMALL LETTER A WITH OGONEK
    0x000002DB, // OGONEK
    0x00000157, // LATIN SMALL LETTER R WITH CEDILLA
    0x000000B4, // ACUTE ACCENT
    0x00000129, // LATIN SMALL LETTER I WITH TILDE
    0x0000013C, // LATIN SMALL LETTER L WITH CEDILLA
    0x000002C7, // CARON
    0x000000B8, // CEDILLA
    0x00000161, // LATIN SMALL LETTER S WITH CARON
    0x00000113, // LATIN SMALL LETTER E WITH MACRON
    0x00000123, // LATIN SMALL LETTER G WITH CEDILLA
    0x00000167, // LATIN SMALL LETTER T WITH STROKE
    0x0000014A, // LATIN CAPITAL LETTER ENG
    0x0000017E, // LATIN SMALL LETTER Z WITH CARON
    0x0000014B, // LATIN SMALL LETTER ENG
    0x00000100, // LATIN CAPITAL LETTER A WITH MACRON
    0x000000C1, // LATIN CAPITAL LETTER A WITH ACUTE
    0x000000C2, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
    0x000000C3, // LATIN CAPITAL LETTER A WITH TILDE
    0x000000C4, // LATIN CAPITAL LETTER A WITH DIAERESIS
    0x000000C5, // LATIN CAPITAL LETTER A WITH RING ABOVE
    0x000000C6, // LATIN CAPITAL LETTER AE
    0x0000012E, // LATIN CAPITAL LETTER I WITH OGONEK
    0x0000010C, // LATIN CAPITAL LETTER C WITH CARON
    0x000000C9, // LATIN CAPITAL LETTER E WITH ACUTE
    0x00000118, // LATIN CAPITAL LETTER E WITH OGONEK
    0x000000CB, // LATIN CAPITAL LETTER E WITH DIAERESIS
    0x00000116, // LATIN CAPITAL LETTER E WITH DOT ABOVE
    0x000000CD, // LATIN CAPITAL LETTER I WITH ACUTE
    0x000000CE, // LATIN CAPITAL LETTER I WITH CIRCUMFLEX
    0x0000012A, // LATIN CAPITAL LETTER I WITH MACRON
    0x00000110, // LATIN CAPITAL LETTER D WITH STROKE
    0x00000145, // LATIN CAPITAL LETTER N WITH CEDILLA
    0x0000014C, // LATIN CAPITAL LETTER O WITH MACRON
    0x00000136, // LATIN CAPITAL LETTER K WITH CEDILLA
    0x000000D4, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
    0x000000D5, // LATIN CAPITAL LETTER O WITH TILDE
    0x000000D6, // LATIN CAPITAL LETTER O WITH DIAERESIS
    0x000000D7, // MULTIPLICATION SIGN
    0x000000D8, // LATIN CAPITAL LETTER O WITH STROKE
    0x00000172, // LATIN CAPITAL LETTER U WITH OGONEK
    0x000000DA, // LATIN CAPITAL LETTER U WITH ACUTE
    0x000000DB, // LATIN CAPITAL LETTER U WITH CIRCUMFLEX
    0x000000DC, // LATIN CAPITAL LETTER U WITH DIAERESIS
    0x00000168, // LATIN CAPITAL LETTER U WITH TILDE
    0x0000016A, // LATIN CAPITAL LETTER U WITH MACRON
    0x000000DF, // LATIN SMALL LETTER SHARP S
    0x00000101, // LATIN SMALL LETTER A WITH MACRON
    0x000000E1, // LATIN SMALL LETTER A WITH ACUTE
    0x000000E2, // LATIN SMALL LETTER A WITH CIRCUMFLEX
    0x000000E3, // LATIN SMALL LETTER A WITH TILDE
    0x000000E4, // LATIN SMALL LETTER A WITH DIAERESIS
    0x000000E5, // LATIN SMALL LETTER A WITH RING ABOVE
    0x000000E6, // LATIN SMALL LETTER AE
    0x0000012F, // LATIN SMALL LETTER I WITH OGONEK
    0x0000010D, // LATIN SMALL LETTER C WITH CARON
    0x000000E9, // LATIN SMALL LETTER E WITH ACUTE
    0x00000119, // LATIN SMALL LETTER E WITH OGONEK
    0x000000EB, // LATIN SMALL LETTER E WITH DIAERESIS
    0x00000117, // LATIN SMALL LETTER E WITH DOT ABOVE
    0x000000ED, // LATIN SMALL LETTER I WITH ACUTE
    0x000000EE, // LATIN SMALL LETTER I WITH CIRCUMFLEX
    0x0000012B, // LATIN SMALL LETTER I WITH MACRON
    0x00000111, // LATIN SMALL LETTER D WITH STROKE
    0x00000146, // LATIN SMALL LETTER N WITH CEDILLA
    0x0000014D, // LATIN SMALL LETTER O WITH MACRON
    0x00000137, // LATIN SMALL LETTER K WITH CEDILLA
    0x000000F4, // LATIN SMALL LETTER O WITH CIRCUMFLEX
    0x000000F5, // LATIN SMALL LETTER O WITH TILDE
    0x000000F6, // LATIN SMALL LETTER O WITH DIAERESIS
    0x000000F7, // DIVISION SIGN
    0x000000F8, // LATIN SMALL LETTER O WITH STROKE
    0x00000173, // LATIN SMALL LETTER U WITH OGONEK
    0x000000FA, // LATIN SMALL LETTER U WITH ACUTE
    0x000000FB, // LATIN SMALL LETTER U WITH CIRCUMFLEX
    0x000000FC, // LATIN SMALL LETTER U WITH DIAERESIS
    0x00000169, // LATIN SMALL LETTER U WITH TILDE
    0x0000016B, // LATIN SMALL LETTER U WITH MACRON
    0x000002D9  // DOT ABOVE
  };

  // ISO-8859-05 transcoding table
  static const t_quad ISO_8859_05_MAP[256] = {
    0x00000000, // NULL
    0x00000001, // START OF HEADING
    0x00000002, // START OF TEXT
    0x00000003, // END OF TEXT
    0x00000004, // END OF TRANSMISSION
    0x00000005, // ENQUIRY
    0x00000006, // ACKNOWLEDGE
    0x00000007, // BELL
    0x00000008, // BACKSPACE
    0x00000009, // HORIZONTAL TABULATION
    0x0000000A, // LINE FEED
    0x0000000B, // VERTICAL TABULATION
    0x0000000C, // FORM FEED
    0x0000000D, // CARRIAGE RETURN
    0x0000000E, // SHIFT OUT
    0x0000000F, // SHIFT IN
    0x00000010, // DATA LINK ESCAPE
    0x00000011, // DEVICE CONTROL ONE
    0x00000012, // DEVICE CONTROL TWO
    0x00000013, // DEVICE CONTROL THREE
    0x00000014, // DEVICE CONTROL FOUR
    0x00000015, // NEGATIVE ACKNOWLEDGE
    0x00000016, // SYNCHRONOUS IDLE
    0x00000017, // END OF TRANSMISSION BLOCK
    0x00000018, // CANCEL
    0x00000019, // END OF MEDIUM
    0x0000001A, // SUBSTITUTE
    0x0000001B, // ESCAPE
    0x0000001C, // FILE SEPARATOR
    0x0000001D, // GROUP SEPARATOR
    0x0000001E, // RECORD SEPARATOR
    0x0000001F, // UNIT SEPARATOR
    0x00000020, // SPACE
    0x00000021, // EXCLAMATION MARK
    0x00000022, // QUOTATION MARK
    0x00000023, // NUMBER SIGN
    0x00000024, // DOLLAR SIGN
    0x00000025, // PERCENT SIGN
    0x00000026, // AMPERSAND
    0x00000027, // APOSTROPHE
    0x00000028, // LEFT PARENTHESIS
    0x00000029, // RIGHT PARENTHESIS
    0x0000002A, // ASTERISK
    0x0000002B, // PLUS SIGN
    0x0000002C, // COMMA
    0x0000002D, // HYPHEN-MINUS
    0x0000002E, // FULL STOP
    0x0000002F, // SOLIDUS
    0x00000030, // DIGIT ZERO
    0x00000031, // DIGIT ONE
    0x00000032, // DIGIT TWO
    0x00000033, // DIGIT THREE
    0x00000034, // DIGIT FOUR
    0x00000035, // DIGIT FIVE
    0x00000036, // DIGIT SIX
    0x00000037, // DIGIT SEVEN
    0x00000038, // DIGIT EIGHT
    0x00000039, // DIGIT NINE
    0x0000003A, // COLON
    0x0000003B, // SEMICOLON
    0x0000003C, // LESS-THAN SIGN
    0x0000003D, // EQUALS SIGN
    0x0000003E, // GREATER-THAN SIGN
    0x0000003F, // QUESTION MARK
    0x00000040, // COMMERCIAL AT
    0x00000041, // LATIN CAPITAL LETTER A
    0x00000042, // LATIN CAPITAL LETTER B
    0x00000043, // LATIN CAPITAL LETTER C
    0x00000044, // LATIN CAPITAL LETTER D
    0x00000045, // LATIN CAPITAL LETTER E
    0x00000046, // LATIN CAPITAL LETTER F
    0x00000047, // LATIN CAPITAL LETTER G
    0x00000048, // LATIN CAPITAL LETTER H
    0x00000049, // LATIN CAPITAL LETTER I
    0x0000004A, // LATIN CAPITAL LETTER J
    0x0000004B, // LATIN CAPITAL LETTER K
    0x0000004C, // LATIN CAPITAL LETTER L
    0x0000004D, // LATIN CAPITAL LETTER M
    0x0000004E, // LATIN CAPITAL LETTER N
    0x0000004F, // LATIN CAPITAL LETTER O
    0x00000050, // LATIN CAPITAL LETTER P
    0x00000051, // LATIN CAPITAL LETTER Q
    0x00000052, // LATIN CAPITAL LETTER R
    0x00000053, // LATIN CAPITAL LETTER S
    0x00000054, // LATIN CAPITAL LETTER T
    0x00000055, // LATIN CAPITAL LETTER U
    0x00000056, // LATIN CAPITAL LETTER V
    0x00000057, // LATIN CAPITAL LETTER W
    0x00000058, // LATIN CAPITAL LETTER X
    0x00000059, // LATIN CAPITAL LETTER Y
    0x0000005A, // LATIN CAPITAL LETTER Z
    0x0000005B, // LEFT SQUARE BRACKET
    0x0000005C, // REVERSE SOLIDUS
    0x0000005D, // RIGHT SQUARE BRACKET
    0x0000005E, // CIRCUMFLEX ACCENT
    0x0000005F, // LOW LINE
    0x00000060, // GRAVE ACCENT
    0x00000061, // LATIN SMALL LETTER A
    0x00000062, // LATIN SMALL LETTER B
    0x00000063, // LATIN SMALL LETTER C
    0x00000064, // LATIN SMALL LETTER D
    0x00000065, // LATIN SMALL LETTER E
    0x00000066, // LATIN SMALL LETTER F
    0x00000067, // LATIN SMALL LETTER G
    0x00000068, // LATIN SMALL LETTER H
    0x00000069, // LATIN SMALL LETTER I
    0x0000006A, // LATIN SMALL LETTER J
    0x0000006B, // LATIN SMALL LETTER K
    0x0000006C, // LATIN SMALL LETTER L
    0x0000006D, // LATIN SMALL LETTER M
    0x0000006E, // LATIN SMALL LETTER N
    0x0000006F, // LATIN SMALL LETTER O
    0x00000070, // LATIN SMALL LETTER P
    0x00000071, // LATIN SMALL LETTER Q
    0x00000072, // LATIN SMALL LETTER R
    0x00000073, // LATIN SMALL LETTER S
    0x00000074, // LATIN SMALL LETTER T
    0x00000075, // LATIN SMALL LETTER U
    0x00000076, // LATIN SMALL LETTER V
    0x00000077, // LATIN SMALL LETTER W
    0x00000078, // LATIN SMALL LETTER X
    0x00000079, // LATIN SMALL LETTER Y
    0x0000007A, // LATIN SMALL LETTER Z
    0x0000007B, // LEFT CURLY BRACKET
    0x0000007C, // VERTICAL LINE
    0x0000007D, // RIGHT CURLY BRACKET
    0x0000007E, // TILDE
    0x0000007F, // DELETE
    0x00000080, // <control>
    0x00000081, // <control>
    0x00000082, // <control>
    0x00000083, // <control>
    0x00000084, // <control>
    0x00000085, // <control>
    0x00000086, // <control>
    0x00000087, // <control>
    0x00000088, // <control>
    0x00000089, // <control>
    0x0000008A, // <control>
    0x0000008B, // <control>
    0x0000008C, // <control>
    0x0000008D, // <control>
    0x0000008E, // <control>
    0x0000008F, // <control>
    0x00000090, // <control>
    0x00000091, // <control>
    0x00000092, // <control>
    0x00000093, // <control>
    0x00000094, // <control>
    0x00000095, // <control>
    0x00000096, // <control>
    0x00000097, // <control>
    0x00000098, // <control>
    0x00000099, // <control>
    0x0000009A, // <control>
    0x0000009B, // <control>
    0x0000009C, // <control>
    0x0000009D, // <control>
    0x0000009E, // <control>
    0x0000009F, // <control>
    0x000000A0, // NO-BREAK SPACE
    0x00000401, // CYRILLIC CAPITAL LETTER IO
    0x00000402, // CYRILLIC CAPITAL LETTER DJE
    0x00000403, // CYRILLIC CAPITAL LETTER GJE
    0x00000404, // CYRILLIC CAPITAL LETTER UKRAINIAN IE
    0x00000405, // CYRILLIC CAPITAL LETTER DZE
    0x00000406, // CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
    0x00000407, // CYRILLIC CAPITAL LETTER YI
    0x00000408, // CYRILLIC CAPITAL LETTER JE
    0x00000409, // CYRILLIC CAPITAL LETTER LJE
    0x0000040A, // CYRILLIC CAPITAL LETTER NJE
    0x0000040B, // CYRILLIC CAPITAL LETTER TSHE
    0x0000040C, // CYRILLIC CAPITAL LETTER KJE
    0x000000AD, // SOFT HYPHEN
    0x0000040E, // CYRILLIC CAPITAL LETTER SHORT U
    0x0000040F, // CYRILLIC CAPITAL LETTER DZHE
    0x00000410, // CYRILLIC CAPITAL LETTER A
    0x00000411, // CYRILLIC CAPITAL LETTER BE
    0x00000412, // CYRILLIC CAPITAL LETTER VE
    0x00000413, // CYRILLIC CAPITAL LETTER GHE
    0x00000414, // CYRILLIC CAPITAL LETTER DE
    0x00000415, // CYRILLIC CAPITAL LETTER IE
    0x00000416, // CYRILLIC CAPITAL LETTER ZHE
    0x00000417, // CYRILLIC CAPITAL LETTER ZE
    0x00000418, // CYRILLIC CAPITAL LETTER I
    0x00000419, // CYRILLIC CAPITAL LETTER SHORT I
    0x0000041A, // CYRILLIC CAPITAL LETTER KA
    0x0000041B, // CYRILLIC CAPITAL LETTER EL
    0x0000041C, // CYRILLIC CAPITAL LETTER EM
    0x0000041D, // CYRILLIC CAPITAL LETTER EN
    0x0000041E, // CYRILLIC CAPITAL LETTER O
    0x0000041F, // CYRILLIC CAPITAL LETTER PE
    0x00000420, // CYRILLIC CAPITAL LETTER ER
    0x00000421, // CYRILLIC CAPITAL LETTER ES
    0x00000422, // CYRILLIC CAPITAL LETTER TE
    0x00000423, // CYRILLIC CAPITAL LETTER U
    0x00000424, // CYRILLIC CAPITAL LETTER EF
    0x00000425, // CYRILLIC CAPITAL LETTER HA
    0x00000426, // CYRILLIC CAPITAL LETTER TSE
    0x00000427, // CYRILLIC CAPITAL LETTER CHE
    0x00000428, // CYRILLIC CAPITAL LETTER SHA
    0x00000429, // CYRILLIC CAPITAL LETTER SHCHA
    0x0000042A, // CYRILLIC CAPITAL LETTER HARD SIGN
    0x0000042B, // CYRILLIC CAPITAL LETTER YERU
    0x0000042C, // CYRILLIC CAPITAL LETTER SOFT SIGN
    0x0000042D, // CYRILLIC CAPITAL LETTER E
    0x0000042E, // CYRILLIC CAPITAL LETTER YU
    0x0000042F, // CYRILLIC CAPITAL LETTER YA
    0x00000430, // CYRILLIC SMALL LETTER A
    0x00000431, // CYRILLIC SMALL LETTER BE
    0x00000432, // CYRILLIC SMALL LETTER VE
    0x00000433, // CYRILLIC SMALL LETTER GHE
    0x00000434, // CYRILLIC SMALL LETTER DE
    0x00000435, // CYRILLIC SMALL LETTER IE
    0x00000436, // CYRILLIC SMALL LETTER ZHE
    0x00000437, // CYRILLIC SMALL LETTER ZE
    0x00000438, // CYRILLIC SMALL LETTER I
    0x00000439, // CYRILLIC SMALL LETTER SHORT I
    0x0000043A, // CYRILLIC SMALL LETTER KA
    0x0000043B, // CYRILLIC SMALL LETTER EL
    0x0000043C, // CYRILLIC SMALL LETTER EM
    0x0000043D, // CYRILLIC SMALL LETTER EN
    0x0000043E, // CYRILLIC SMALL LETTER O
    0x0000043F, // CYRILLIC SMALL LETTER PE
    0x00000440, // CYRILLIC SMALL LETTER ER
    0x00000441, // CYRILLIC SMALL LETTER ES
    0x00000442, // CYRILLIC SMALL LETTER TE
    0x00000443, // CYRILLIC SMALL LETTER U
    0x00000444, // CYRILLIC SMALL LETTER EF
    0x00000445, // CYRILLIC SMALL LETTER HA
    0x00000446, // CYRILLIC SMALL LETTER TSE
    0x00000447, // CYRILLIC SMALL LETTER CHE
    0x00000448, // CYRILLIC SMALL LETTER SHA
    0x00000449, // CYRILLIC SMALL LETTER SHCHA
    0x0000044A, // CYRILLIC SMALL LETTER HARD SIGN
    0x0000044B, // CYRILLIC SMALL LETTER YERU
    0x0000044C, // CYRILLIC SMALL LETTER SOFT SIGN
    0x0000044D, // CYRILLIC SMALL LETTER E
    0x0000044E, // CYRILLIC SMALL LETTER YU
    0x0000044F, // CYRILLIC SMALL LETTER YA
    0x00002116, // NUMERO SIGN
    0x00000451, // CYRILLIC SMALL LETTER IO
    0x00000452, // CYRILLIC SMALL LETTER DJE
    0x00000453, // CYRILLIC SMALL LETTER GJE
    0x00000454, // CYRILLIC SMALL LETTER UKRAINIAN IE
    0x00000455, // CYRILLIC SMALL LETTER DZE
    0x00000456, // CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
    0x00000457, // CYRILLIC SMALL LETTER YI
    0x00000458, // CYRILLIC SMALL LETTER JE
    0x00000459, // CYRILLIC SMALL LETTER LJE
    0x0000045A, // CYRILLIC SMALL LETTER NJE
    0x0000045B, // CYRILLIC SMALL LETTER TSHE
    0x0000045C, // CYRILLIC SMALL LETTER KJE
    0x000000A7, // SECTION SIGN
    0x0000045E, // CYRILLIC SMALL LETTER SHORT U
    0x0000045F  // CYRILLIC SMALL LETTER DZHE
  };

  // ISO-8859-06 transcoding table
  static const t_quad ISO_8859_06_MAP[256] = {
    0x00000000, // NULL
    0x00000001, // START OF HEADING
    0x00000002, // START OF TEXT
    0x00000003, // END OF TEXT
    0x00000004, // END OF TRANSMISSION
    0x00000005, // ENQUIRY
    0x00000006, // ACKNOWLEDGE
    0x00000007, // BELL
    0x00000008, // BACKSPACE
    0x00000009, // HORIZONTAL TABULATION
    0x0000000A, // LINE FEED
    0x0000000B, // VERTICAL TABULATION
    0x0000000C, // FORM FEED
    0x0000000D, // CARRIAGE RETURN
    0x0000000E, // SHIFT OUT
    0x0000000F, // SHIFT IN
    0x00000010, // DATA LINK ESCAPE
    0x00000011, // DEVICE CONTROL ONE
    0x00000012, // DEVICE CONTROL TWO
    0x00000013, // DEVICE CONTROL THREE
    0x00000014, // DEVICE CONTROL FOUR
    0x00000015, // NEGATIVE ACKNOWLEDGE
    0x00000016, // SYNCHRONOUS IDLE
    0x00000017, // END OF TRANSMISSION BLOCK
    0x00000018, // CANCEL
    0x00000019, // END OF MEDIUM
    0x0000001A, // SUBSTITUTE
    0x0000001B, // ESCAPE
    0x0000001C, // FILE SEPARATOR
    0x0000001D, // GROUP SEPARATOR
    0x0000001E, // RECORD SEPARATOR
    0x0000001F, // UNIT SEPARATOR
    0x00000020, // SPACE
    0x00000021, // EXCLAMATION MARK
    0x00000022, // QUOTATION MARK
    0x00000023, // NUMBER SIGN
    0x00000024, // DOLLAR SIGN
    0x00000025, // PERCENT SIGN
    0x00000026, // AMPERSAND
    0x00000027, // APOSTROPHE
    0x00000028, // LEFT PARENTHESIS
    0x00000029, // RIGHT PARENTHESIS
    0x0000002A, // ASTERISK
    0x0000002B, // PLUS SIGN
    0x0000002C, // COMMA
    0x0000002D, // HYPHEN-MINUS
    0x0000002E, // FULL STOP
    0x0000002F, // SOLIDUS
    0x00000030, // DIGIT ZERO
    0x00000031, // DIGIT ONE
    0x00000032, // DIGIT TWO
    0x00000033, // DIGIT THREE
    0x00000034, // DIGIT FOUR
    0x00000035, // DIGIT FIVE
    0x00000036, // DIGIT SIX
    0x00000037, // DIGIT SEVEN
    0x00000038, // DIGIT EIGHT
    0x00000039, // DIGIT NINE
    0x0000003A, // COLON
    0x0000003B, // SEMICOLON
    0x0000003C, // LESS-THAN SIGN
    0x0000003D, // EQUALS SIGN
    0x0000003E, // GREATER-THAN SIGN
    0x0000003F, // QUESTION MARK
    0x00000040, // COMMERCIAL AT
    0x00000041, // LATIN CAPITAL LETTER A
    0x00000042, // LATIN CAPITAL LETTER B
    0x00000043, // LATIN CAPITAL LETTER C
    0x00000044, // LATIN CAPITAL LETTER D
    0x00000045, // LATIN CAPITAL LETTER E
    0x00000046, // LATIN CAPITAL LETTER F
    0x00000047, // LATIN CAPITAL LETTER G
    0x00000048, // LATIN CAPITAL LETTER H
    0x00000049, // LATIN CAPITAL LETTER I
    0x0000004A, // LATIN CAPITAL LETTER J
    0x0000004B, // LATIN CAPITAL LETTER K
    0x0000004C, // LATIN CAPITAL LETTER L
    0x0000004D, // LATIN CAPITAL LETTER M
    0x0000004E, // LATIN CAPITAL LETTER N
    0x0000004F, // LATIN CAPITAL LETTER O
    0x00000050, // LATIN CAPITAL LETTER P
    0x00000051, // LATIN CAPITAL LETTER Q
    0x00000052, // LATIN CAPITAL LETTER R
    0x00000053, // LATIN CAPITAL LETTER S
    0x00000054, // LATIN CAPITAL LETTER T
    0x00000055, // LATIN CAPITAL LETTER U
    0x00000056, // LATIN CAPITAL LETTER V
    0x00000057, // LATIN CAPITAL LETTER W
    0x00000058, // LATIN CAPITAL LETTER X
    0x00000059, // LATIN CAPITAL LETTER Y
    0x0000005A, // LATIN CAPITAL LETTER Z
    0x0000005B, // LEFT SQUARE BRACKET
    0x0000005C, // REVERSE SOLIDUS
    0x0000005D, // RIGHT SQUARE BRACKET
    0x0000005E, // CIRCUMFLEX ACCENT
    0x0000005F, // LOW LINE
    0x00000060, // GRAVE ACCENT
    0x00000061, // LATIN SMALL LETTER A
    0x00000062, // LATIN SMALL LETTER B
    0x00000063, // LATIN SMALL LETTER C
    0x00000064, // LATIN SMALL LETTER D
    0x00000065, // LATIN SMALL LETTER E
    0x00000066, // LATIN SMALL LETTER F
    0x00000067, // LATIN SMALL LETTER G
    0x00000068, // LATIN SMALL LETTER H
    0x00000069, // LATIN SMALL LETTER I
    0x0000006A, // LATIN SMALL LETTER J
    0x0000006B, // LATIN SMALL LETTER K
    0x0000006C, // LATIN SMALL LETTER L
    0x0000006D, // LATIN SMALL LETTER M
    0x0000006E, // LATIN SMALL LETTER N
    0x0000006F, // LATIN SMALL LETTER O
    0x00000070, // LATIN SMALL LETTER P
    0x00000071, // LATIN SMALL LETTER Q
    0x00000072, // LATIN SMALL LETTER R
    0x00000073, // LATIN SMALL LETTER S
    0x00000074, // LATIN SMALL LETTER T
    0x00000075, // LATIN SMALL LETTER U
    0x00000076, // LATIN SMALL LETTER V
    0x00000077, // LATIN SMALL LETTER W
    0x00000078, // LATIN SMALL LETTER X
    0x00000079, // LATIN SMALL LETTER Y
    0x0000007A, // LATIN SMALL LETTER Z
    0x0000007B, // LEFT CURLY BRACKET
    0x0000007C, // VERTICAL LINE
    0x0000007D, // RIGHT CURLY BRACKET
    0x0000007E, // TILDE
    0x0000007F, // DELETE
    0x00000080, // <control>
    0x00000081, // <control>
    0x00000082, // <control>
    0x00000083, // <control>
    0x00000084, // <control>
    0x00000085, // <control>
    0x00000086, // <control>
    0x00000087, // <control>
    0x00000088, // <control>
    0x00000089, // <control>
    0x0000008A, // <control>
    0x0000008B, // <control>
    0x0000008C, // <control>
    0x0000008D, // <control>
    0x0000008E, // <control>
    0x0000008F, // <control>
    0x00000090, // <control>
    0x00000091, // <control>
    0x00000092, // <control>
    0x00000093, // <control>
    0x00000094, // <control>
    0x00000095, // <control>
    0x00000096, // <control>
    0x00000097, // <control>
    0x00000098, // <control>
    0x00000099, // <control>
    0x0000009A, // <control>
    0x0000009B, // <control>
    0x0000009C, // <control>
    0x0000009D, // <control>
    0x0000009E, // <control>
    0x0000009F, // <control>
    0x000000A0, // NO-BREAK SPACE
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0x000000A4, // CURRENCY SIGN
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0x0000060C, // ARABIC COMMA
    0x000000AD, // SOFT HYPHEN
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0x0000061B, // ARABIC SEMICOLON
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0x0000061F, // ARABIC QUESTION MARK
    0xFFFFFFFF, // <not defined>
    0x00000621, // ARABIC LETTER HAMZA
    0x00000622, // ARABIC LETTER ALEF WITH MADDA ABOVE
    0x00000623, // ARABIC LETTER ALEF WITH HAMZA ABOVE
    0x00000624, // ARABIC LETTER WAW WITH HAMZA ABOVE
    0x00000625, // ARABIC LETTER ALEF WITH HAMZA BELOW
    0x00000626, // ARABIC LETTER YEH WITH HAMZA ABOVE
    0x00000627, // ARABIC LETTER ALEF
    0x00000628, // ARABIC LETTER BEH
    0x00000629, // ARABIC LETTER TEH MARBUTA
    0x0000062A, // ARABIC LETTER TEH
    0x0000062B, // ARABIC LETTER THEH
    0x0000062C, // ARABIC LETTER JEEM
    0x0000062D, // ARABIC LETTER HAH
    0x0000062E, // ARABIC LETTER KHAH
    0x0000062F, // ARABIC LETTER DAL
    0x00000630, // ARABIC LETTER THAL
    0x00000631, // ARABIC LETTER REH
    0x00000632, // ARABIC LETTER ZAIN
    0x00000633, // ARABIC LETTER SEEN
    0x00000634, // ARABIC LETTER SHEEN
    0x00000635, // ARABIC LETTER SAD
    0x00000636, // ARABIC LETTER DAD
    0x00000637, // ARABIC LETTER TAH
    0x00000638, // ARABIC LETTER ZAH
    0x00000639, // ARABIC LETTER AIN
    0x0000063A, // ARABIC LETTER GHAIN
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0x00000640, // ARABIC TATWEEL
    0x00000641, // ARABIC LETTER FEH
    0x00000642, // ARABIC LETTER QAF
    0x00000643, // ARABIC LETTER KAF
    0x00000644, // ARABIC LETTER LAM
    0x00000645, // ARABIC LETTER MEEM
    0x00000646, // ARABIC LETTER NOON
    0x00000647, // ARABIC LETTER HEH
    0x00000648, // ARABIC LETTER WAW
    0x00000649, // ARABIC LETTER ALEF MAKSURA
    0x0000064A, // ARABIC LETTER YEH
    0x0000064B, // ARABIC FATHATAN
    0x0000064C, // ARABIC DAMMATAN
    0x0000064D, // ARABIC KASRATAN
    0x0000064E, // ARABIC FATHA
    0x0000064F, // ARABIC DAMMA
    0x00000650, // ARABIC KASRA
    0x00000651, // ARABIC SHADDA
    0x00000652, // ARABIC SUKUN
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF, // <not defined>
    0xFFFFFFFF  // <not defined>
  };

  // ISO-8859-07 transcoding table
  static const t_quad ISO_8859_07_MAP[256] = {
    0x00000000, // NULL
    0x00000001, // START OF HEADING
    0x00000002, // START OF TEXT
    0x00000003, // END OF TEXT
    0x00000004, // END OF TRANSMISSION
    0x00000005, // ENQUIRY
    0x00000006, // ACKNOWLEDGE
    0x00000007, // BELL
    0x00000008, // BACKSPACE
    0x00000009, // HORIZONTAL TABULATION
    0x0000000A, // LINE FEED
    0x0000000B, // VERTICAL TABULATION
    0x0000000C, // FORM FEED
    0x0000000D, // CARRIAGE RETURN
    0x0000000E, // SHIFT OUT
    0x0000000F, // SHIFT IN
    0x00000010, // DATA LINK ESCAPE
    0x00000011, // DEVICE CONTROL ONE
    0x00000012, // DEVICE CONTROL TWO
    0x00000013, // DEVICE CONTROL THREE
    0x00000014, // DEVICE CONTROL FOUR
    0x00000015, // NEGATIVE ACKNOWLEDGE
    0x00000016, // SYNCHRONOUS IDLE
    0x00000017, // END OF TRANSMISSION BLOCK
    0x00000018, // CANCEL
    0x00000019, // END OF MEDIUM
    0x0000001A, // SUBSTITUTE
    0x0000001B, // ESCAPE
    0x0000001C, // FILE SEPARATOR
    0x0000001D, // GROUP SEPARATOR
    0x0000001E, // RECORD SEPARATOR
    0x0000001F, // UNIT SEPARATOR
    0x00000020, // SPACE
    0x00000021, // EXCLAMATION MARK
    0x00000022, // QUOTATION MARK
    0x00000023, // NUMBER SIGN
    0x00000024, // DOLLAR SIGN
    0x00000025, // PERCENT SIGN
    0x00000026, // AMPERSAND
    0x00000027, // APOSTROPHE
    0x00000028, // LEFT PARENTHESIS
    0x00000029, // RIGHT PARENTHESIS
    0x0000002A, // ASTERISK
    0x0000002B, // PLUS SIGN
    0x0000002C, // COMMA
    0x0000002D, // HYPHEN-MINUS
    0x0000002E, // FULL STOP
    0x0000002F, // SOLIDUS
    0x00000030, // DIGIT ZERO
    0x00000031, // DIGIT ONE
    0x00000032, // DIGIT TWO
    0x00000033, // DIGIT THREE
    0x00000034, // DIGIT FOUR
    0x00000035, // DIGIT FIVE
    0x00000036, // DIGIT SIX
    0x00000037, // DIGIT SEVEN
    0x00000038, // DIGIT EIGHT
    0x00000039, // DIGIT NINE
    0x0000003A, // COLON
    0x0000003B, // SEMICOLON
    0x0000003C, // LESS-THAN SIGN
    0x0000003D, // EQUALS SIGN
    0x0000003E, // GREATER-THAN SIGN
    0x0000003F, // QUESTION MARK
    0x00000040, // COMMERCIAL AT
    0x00000041, // LATIN CAPITAL LETTER A
    0x00000042, // LATIN CAPITAL LETTER B
    0x00000043, // LATIN CAPITAL LETTER C
    0x00000044, // LATIN CAPITAL LETTER D
    0x00000045, // LATIN CAPITAL LETTER E
    0x00000046, // LATIN CAPITAL LETTER F
    0x00000047, // LATIN CAPITAL LETTER G
    0x00000048, // LATIN CAPITAL LETTER H
    0x00000049, // LATIN CAPITAL LETTER I
    0x0000004A, // LATIN CAPITAL LETTER J
    0x0000004B, // LATIN CAPITAL LETTER K
    0x0000004C, // LATIN CAPITAL LETTER L
    0x0000004D, // LATIN CAPITAL LETTER M
    0x0000004E, // LATIN CAPITAL LETTER N
    0x0000004F, // LATIN CAPITAL LETTER O
    0x00000050, // LATIN CAPITAL LETTER P
    0x00000051, // LATIN CAPITAL LETTER Q
    0x00000052, // LATIN CAPITAL LETTER R
    0x00000053, // LATIN CAPITAL LETTER S
    0x00000054, // LATIN CAPITAL LETTER T
    0x00000055, // LATIN CAPITAL LETTER U
    0x00000056, // LATIN CAPITAL LETTER V
    0x00000057, // LATIN CAPITAL LETTER W
    0x00000058, // LATIN CAPITAL LETTER X
    0x00000059, // LATIN CAPITAL LETTER Y
    0x0000005A, // LATIN CAPITAL LETTER Z
    0x0000005B, // LEFT SQUARE BRACKET
    0x0000005C, // REVERSE SOLIDUS
    0x0000005D, // RIGHT SQUARE BRACKET
    0x0000005E, // CIRCUMFLEX ACCENT
    0x0000005F, // LOW LINE
    0x00000060, // GRAVE ACCENT
    0x00000061, // LATIN SMALL LETTER A
    0x00000062, // LATIN SMALL LETTER B
    0x00000063, // LATIN SMALL LETTER C
    0x00000064, // LATIN SMALL LETTER D
    0x00000065, // LATIN SMALL LETTER E
    0x00000066, // LATIN SMALL LETTER F
    0x00000067, // LATIN SMALL LETTER G
    0x00000068, // LATIN SMALL LETTER H
    0x00000069, // LATIN SMALL LETTER I
    0x0000006A, // LATIN SMALL LETTER J
    0x0000006B, // LATIN SMALL LETTER K
    0x0000006C, // LATIN SMALL LETTER L
    0x0000006D, // LATIN SMALL LETTER M
    0x0000006E, // LATIN SMALL LETTER N
    0x0000006F, // LATIN SMALL LETTER O
    0x00000070, // LATIN SMALL LETTER P
    0x00000071, // LATIN SMALL LETTER Q
    0x00000072, // LATIN SMALL LETTER R
    0x00000073, // LATIN SMALL LETTER S
    0x00000074, // LATIN SMALL LETTER T
    0x00000075, // LATIN SMALL LETTER U
    0x00000076, // LATIN SMALL LETTER V
    0x00000077, // LATIN SMALL LETTER W
    0x00000078, // LATIN SMALL LETTER X
    0x00000079, // LATIN SMALL LETTER Y
    0x0000007A, // LATIN SMALL LETTER Z
    0x0000007B, // LEFT CURLY BRACKET
    0x0000007C, // VERTICAL LINE
    0x0000007D, // RIGHT CURLY BRACKET
    0x0000007E, // TILDE
    0x0000007F, // DELETE
    0x00000080, // <control>
    0x00000081, // <control>
    0x00000082, // <control>
    0x00000083, // <control>
    0x00000084, // <control>
    0x00000085, // <control>
    0x00000086, // <control>
    0x00000087, // <control>
    0x00000088, // <control>
    0x00000089, // <control>
    0x0000008A, // <control>
    0x0000008B, // <control>
    0x0000008C, // <control>
    0x0000008D, // <control>
    0x0000008E, // <control>
    0x0000008F, // <control>
    0x00000090, // <control>
    0x00000091, // <control>
    0x00000092, // <control>
    0x00000093, // <control>
    0x00000094, // <control>
    0x00000095, // <control>
    0x00000096, // <control>
    0x00000097, // <control>
    0x00000098, // <control>
    0x00000099, // <control>
    0x0000009A, // <control>
    0x0000009B, // <control>
    0x0000009C, // <control>
    0x0000009D, // <control>
    0x0000009E, // <control>
    0x0000009F, // <control>
    0x000000A0, // NO-BREAK SPACE
    0x00002018, // LEFT SINGLE QUOTATION MARK
    0x00002019, // RIGHT SINGLE QUOTATION MARK
    0x000000A3, // POUND SIGN
    0x000020AC, // EURO SIGN
    0x000020AF, // DRACHMA SIGN
    0x000000A6, // BROKEN BAR
    0x000000A7, // SECTION SIGN
    0x000000A8, // DIAERESIS
    0x000000A9, // COPYRIGHT SIGN
    0x0000037A, // GREEK YPOGEGRAMMENI
    0x000000AB, // LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x000000AC, // NOT SIGN
    0x000000AD, // SOFT HYPHEN
    0xFFFFFFFF, // <not implemented>
    0x00002015, // HORIZONTAL BAR
    0x000000B0, // DEGREE SIGN
    0x000000B1, // PLUS-MINUS SIGN
    0x000000B2, // SUPERSCRIPT TWO
    0x000000B3, // SUPERSCRIPT THREE
    0x00000384, // GREEK TONOS
    0x00000385, // GREEK DIALYTIKA TONOS
    0x00000386, // GREEK CAPITAL LETTER ALPHA WITH TONOS
    0x000000B7, // MIDDLE DOT
    0x00000388, // GREEK CAPITAL LETTER EPSILON WITH TONOS
    0x00000389, // GREEK CAPITAL LETTER ETA WITH TONOS
    0x0000038A, // GREEK CAPITAL LETTER IOTA WITH TONOS
    0x000000BB, // RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x0000038C, // GREEK CAPITAL LETTER OMICRON WITH TONOS
    0x000000BD, // VULGAR FRACTION ONE HALF
    0x0000038E, // GREEK CAPITAL LETTER UPSILON WITH TONOS
    0x0000038F, // GREEK CAPITAL LETTER OMEGA WITH TONOS
    0x00000390, // GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
    0x00000391, // GREEK CAPITAL LETTER ALPHA
    0x00000392, // GREEK CAPITAL LETTER BETA
    0x00000393, // GREEK CAPITAL LETTER GAMMA
    0x00000394, // GREEK CAPITAL LETTER DELTA
    0x00000395, // GREEK CAPITAL LETTER EPSILON
    0x00000396, // GREEK CAPITAL LETTER ZETA
    0x00000397, // GREEK CAPITAL LETTER ETA
    0x00000398, // GREEK CAPITAL LETTER THETA
    0x00000399, // GREEK CAPITAL LETTER IOTA
    0x0000039A, // GREEK CAPITAL LETTER KAPPA
    0x0000039B, // GREEK CAPITAL LETTER LAMDA
    0x0000039C, // GREEK CAPITAL LETTER MU
    0x0000039D, // GREEK CAPITAL LETTER NU
    0x0000039E, // GREEK CAPITAL LETTER XI
    0x0000039F, // GREEK CAPITAL LETTER OMICRON
    0x000003A0, // GREEK CAPITAL LETTER PI
    0x000003A1, // GREEK CAPITAL LETTER RHO
    0xFFFFFFFF, // <not implemented>
    0x000003A3, // GREEK CAPITAL LETTER SIGMA
    0x000003A4, // GREEK CAPITAL LETTER TAU
    0x000003A5, // GREEK CAPITAL LETTER UPSILON
    0x000003A6, // GREEK CAPITAL LETTER PHI
    0x000003A7, // GREEK CAPITAL LETTER CHI
    0x000003A8, // GREEK CAPITAL LETTER PSI
    0x000003A9, // GREEK CAPITAL LETTER OMEGA
    0x000003AA, // GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
    0x000003AB, // GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
    0x000003AC, // GREEK SMALL LETTER ALPHA WITH TONOS
    0x000003AD, // GREEK SMALL LETTER EPSILON WITH TONOS
    0x000003AE, // GREEK SMALL LETTER ETA WITH TONOS
    0x000003AF, // GREEK SMALL LETTER IOTA WITH TONOS
    0x000003B0, // GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
    0x000003B1, // GREEK SMALL LETTER ALPHA
    0x000003B2, // GREEK SMALL LETTER BETA
    0x000003B3, // GREEK SMALL LETTER GAMMA
    0x000003B4, // GREEK SMALL LETTER DELTA
    0x000003B5, // GREEK SMALL LETTER EPSILON
    0x000003B6, // GREEK SMALL LETTER ZETA
    0x000003B7, // GREEK SMALL LETTER ETA
    0x000003B8, // GREEK SMALL LETTER THETA
    0x000003B9, // GREEK SMALL LETTER IOTA
    0x000003BA, // GREEK SMALL LETTER KAPPA
    0x000003BB, // GREEK SMALL LETTER LAMDA
    0x000003BC, // GREEK SMALL LETTER MU
    0x000003BD, // GREEK SMALL LETTER NU
    0x000003BE, // GREEK SMALL LETTER XI
    0x000003BF, // GREEK SMALL LETTER OMICRON
    0x000003C0, // GREEK SMALL LETTER PI
    0x000003C1, // GREEK SMALL LETTER RHO
    0x000003C2, // GREEK SMALL LETTER FINAL SIGMA
    0x000003C3, // GREEK SMALL LETTER SIGMA
    0x000003C4, // GREEK SMALL LETTER TAU
    0x000003C5, // GREEK SMALL LETTER UPSILON
    0x000003C6, // GREEK SMALL LETTER PHI
    0x000003C7, // GREEK SMALL LETTER CHI
    0x000003C8, // GREEK SMALL LETTER PSI
    0x000003C9, // GREEK SMALL LETTER OMEGA
    0x000003CA, // GREEK SMALL LETTER IOTA WITH DIALYTIKA
    0x000003CB, // GREEK SMALL LETTER UPSILON WITH DIALYTIKA
    0x000003CC, // GREEK SMALL LETTER OMICRON WITH TONOS
    0x000003CD, // GREEK SMALL LETTER UPSILON WITH TONOS
    0x000003CE, // GREEK SMALL LETTER OMEGA WITH TONOS
    0xFFFFFFFF  // <not implemented>
  };

  // ISO-8859-08 transcoding table
  static const t_quad ISO_8859_08_MAP[256] = {
    0x00000000, // NULL
    0x00000001, // START OF HEADING
    0x00000002, // START OF TEXT
    0x00000003, // END OF TEXT
    0x00000004, // END OF TRANSMISSION
    0x00000005, // ENQUIRY
    0x00000006, // ACKNOWLEDGE
    0x00000007, // BELL
    0x00000008, // BACKSPACE
    0x00000009, // HORIZONTAL TABULATION
    0x0000000A, // LINE FEED
    0x0000000B, // VERTICAL TABULATION
    0x0000000C, // FORM FEED
    0x0000000D, // CARRIAGE RETURN
    0x0000000E, // SHIFT OUT
    0x0000000F, // SHIFT IN
    0x00000010, // DATA LINK ESCAPE
    0x00000011, // DEVICE CONTROL ONE
    0x00000012, // DEVICE CONTROL TWO
    0x00000013, // DEVICE CONTROL THREE
    0x00000014, // DEVICE CONTROL FOUR
    0x00000015, // NEGATIVE ACKNOWLEDGE
    0x00000016, // SYNCHRONOUS IDLE
    0x00000017, // END OF TRANSMISSION BLOCK
    0x00000018, // CANCEL
    0x00000019, // END OF MEDIUM
    0x0000001A, // SUBSTITUTE
    0x0000001B, // ESCAPE
    0x0000001C, // FILE SEPARATOR
    0x0000001D, // GROUP SEPARATOR
    0x0000001E, // RECORD SEPARATOR
    0x0000001F, // UNIT SEPARATOR
    0x00000020, // SPACE
    0x00000021, // EXCLAMATION MARK
    0x00000022, // QUOTATION MARK
    0x00000023, // NUMBER SIGN
    0x00000024, // DOLLAR SIGN
    0x00000025, // PERCENT SIGN
    0x00000026, // AMPERSAND
    0x00000027, // APOSTROPHE
    0x00000028, // LEFT PARENTHESIS
    0x00000029, // RIGHT PARENTHESIS
    0x0000002A, // ASTERISK
    0x0000002B, // PLUS SIGN
    0x0000002C, // COMMA
    0x0000002D, // HYPHEN-MINUS
    0x0000002E, // FULL STOP
    0x0000002F, // SOLIDUS
    0x00000030, // DIGIT ZERO
    0x00000031, // DIGIT ONE
    0x00000032, // DIGIT TWO
    0x00000033, // DIGIT THREE
    0x00000034, // DIGIT FOUR
    0x00000035, // DIGIT FIVE
    0x00000036, // DIGIT SIX
    0x00000037, // DIGIT SEVEN
    0x00000038, // DIGIT EIGHT
    0x00000039, // DIGIT NINE
    0x0000003A, // COLON
    0x0000003B, // SEMICOLON
    0x0000003C, // LESS-THAN SIGN
    0x0000003D, // EQUALS SIGN
    0x0000003E, // GREATER-THAN SIGN
    0x0000003F, // QUESTION MARK
    0x00000040, // COMMERCIAL AT
    0x00000041, // LATIN CAPITAL LETTER A
    0x00000042, // LATIN CAPITAL LETTER B
    0x00000043, // LATIN CAPITAL LETTER C
    0x00000044, // LATIN CAPITAL LETTER D
    0x00000045, // LATIN CAPITAL LETTER E
    0x00000046, // LATIN CAPITAL LETTER F
    0x00000047, // LATIN CAPITAL LETTER G
    0x00000048, // LATIN CAPITAL LETTER H
    0x00000049, // LATIN CAPITAL LETTER I
    0x0000004A, // LATIN CAPITAL LETTER J
    0x0000004B, // LATIN CAPITAL LETTER K
    0x0000004C, // LATIN CAPITAL LETTER L
    0x0000004D, // LATIN CAPITAL LETTER M
    0x0000004E, // LATIN CAPITAL LETTER N
    0x0000004F, // LATIN CAPITAL LETTER O
    0x00000050, // LATIN CAPITAL LETTER P
    0x00000051, // LATIN CAPITAL LETTER Q
    0x00000052, // LATIN CAPITAL LETTER R
    0x00000053, // LATIN CAPITAL LETTER S
    0x00000054, // LATIN CAPITAL LETTER T
    0x00000055, // LATIN CAPITAL LETTER U
    0x00000056, // LATIN CAPITAL LETTER V
    0x00000057, // LATIN CAPITAL LETTER W
    0x00000058, // LATIN CAPITAL LETTER X
    0x00000059, // LATIN CAPITAL LETTER Y
    0x0000005A, // LATIN CAPITAL LETTER Z
    0x0000005B, // LEFT SQUARE BRACKET
    0x0000005C, // REVERSE SOLIDUS
    0x0000005D, // RIGHT SQUARE BRACKET
    0x0000005E, // CIRCUMFLEX ACCENT
    0x0000005F, // LOW LINE
    0x00000060, // GRAVE ACCENT
    0x00000061, // LATIN SMALL LETTER A
    0x00000062, // LATIN SMALL LETTER B
    0x00000063, // LATIN SMALL LETTER C
    0x00000064, // LATIN SMALL LETTER D
    0x00000065, // LATIN SMALL LETTER E
    0x00000066, // LATIN SMALL LETTER F
    0x00000067, // LATIN SMALL LETTER G
    0x00000068, // LATIN SMALL LETTER H
    0x00000069, // LATIN SMALL LETTER I
    0x0000006A, // LATIN SMALL LETTER J
    0x0000006B, // LATIN SMALL LETTER K
    0x0000006C, // LATIN SMALL LETTER L
    0x0000006D, // LATIN SMALL LETTER M
    0x0000006E, // LATIN SMALL LETTER N
    0x0000006F, // LATIN SMALL LETTER O
    0x00000070, // LATIN SMALL LETTER P
    0x00000071, // LATIN SMALL LETTER Q
    0x00000072, // LATIN SMALL LETTER R
    0x00000073, // LATIN SMALL LETTER S
    0x00000074, // LATIN SMALL LETTER T
    0x00000075, // LATIN SMALL LETTER U
    0x00000076, // LATIN SMALL LETTER V
    0x00000077, // LATIN SMALL LETTER W
    0x00000078, // LATIN SMALL LETTER X
    0x00000079, // LATIN SMALL LETTER Y
    0x0000007A, // LATIN SMALL LETTER Z
    0x0000007B, // LEFT CURLY BRACKET
    0x0000007C, // VERTICAL LINE
    0x0000007D, // RIGHT CURLY BRACKET
    0x0000007E, // TILDE
    0x0000007F, // DELETE
    0x00000080, // <control>
    0x00000081, // <control>
    0x00000082, // <control>
    0x00000083, // <control>
    0x00000084, // <control>
    0x00000085, // <control>
    0x00000086, // <control>
    0x00000087, // <control>
    0x00000088, // <control>
    0x00000089, // <control>
    0x0000008A, // <control>
    0x0000008B, // <control>
    0x0000008C, // <control>
    0x0000008D, // <control>
    0x0000008E, // <control>
    0x0000008F, // <control>
    0x00000090, // <control>
    0x00000091, // <control>
    0x00000092, // <control>
    0x00000093, // <control>
    0x00000094, // <control>
    0x00000095, // <control>
    0x00000096, // <control>
    0x00000097, // <control>
    0x00000098, // <control>
    0x00000099, // <control>
    0x0000009A, // <control>
    0x0000009B, // <control>
    0x0000009C, // <control>
    0x0000009D, // <control>
    0x0000009E, // <control>
    0x0000009F, // <control>
    0x000000A0, // NO-BREAK SPACE
    0xFFFFFFFF, // <not implemented>
    0x000000A2, // CENT SIGN
    0x000000A3, // POUND SIGN
    0x000000A4, // CURRENCY SIGN
    0x000000A5, // YEN SIGN
    0x000000A6, // BROKEN BAR
    0x000000A7, // SECTION SIGN
    0x000000A8, // DIAERESIS
    0x000000A9, // COPYRIGHT SIGN
    0x000000D7, // MULTIPLICATION SIGN
    0x000000AB, // LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x000000AC, // NOT SIGN
    0x000000AD, // SOFT HYPHEN
    0x000000AE, // REGISTERED SIGN
    0x000000AF, // MACRON
    0x000000B0, // DEGREE SIGN
    0x000000B1, // PLUS-MINUS SIGN
    0x000000B2, // SUPERSCRIPT TWO
    0x000000B3, // SUPERSCRIPT THREE
    0x000000B4, // ACUTE ACCENT
    0x000000B5, // MICRO SIGN
    0x000000B6, // PILCROW SIGN
    0x000000B7, // MIDDLE DOT
    0x000000B8, // CEDILLA
    0x000000B9, // SUPERSCRIPT ONE
    0x000000F7, // DIVISION SIGN
    0x000000BB, // RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x000000BC, // VULGAR FRACTION ONE QUARTER
    0x000000BD, // VULGAR FRACTION ONE HALF
    0x000000BE, // VULGAR FRACTION THREE QUARTERS
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0x00002017, // DOUBLE LOW LINE
    0x000005D0, // HEBREW LETTER ALEF
    0x000005D1, // HEBREW LETTER BET
    0x000005D2, // HEBREW LETTER GIMEL
    0x000005D3, // HEBREW LETTER DALET
    0x000005D4, // HEBREW LETTER HE
    0x000005D5, // HEBREW LETTER VAV
    0x000005D6, // HEBREW LETTER ZAYIN
    0x000005D7, // HEBREW LETTER HET
    0x000005D8, // HEBREW LETTER TET
    0x000005D9, // HEBREW LETTER YOD
    0x000005DA, // HEBREW LETTER FINAL KAF
    0x000005DB, // HEBREW LETTER KAF
    0x000005DC, // HEBREW LETTER LAMED
    0x000005DD, // HEBREW LETTER FINAL MEM
    0x000005DE, // HEBREW LETTER MEM
    0x000005DF, // HEBREW LETTER FINAL NUN
    0x000005E0, // HEBREW LETTER NUN
    0x000005E1, // HEBREW LETTER SAMEKH
    0x000005E2, // HEBREW LETTER AYIN
    0x000005E3, // HEBREW LETTER FINAL PE
    0x000005E4, // HEBREW LETTER PE
    0x000005E5, // HEBREW LETTER FINAL TSADI
    0x000005E6, // HEBREW LETTER TSADI
    0x000005E7, // HEBREW LETTER QOF
    0x000005E8, // HEBREW LETTER RESH
    0x000005E9, // HEBREW LETTER SHIN
    0x000005EA, // HEBREW LETTER TAV
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0x0000200E, // LEFT-TO-RIGHT MARK
    0x0000200F, // RIGHT-TO-LEFT MARK
    0xFFFFFFFF  // <not implemented>
  };

  // ISO-8859-09 transcoding table
  static const t_quad ISO_8859_09_MAP[256] = {
    0x00000000, // NULL
    0x00000001, // START OF HEADING
    0x00000002, // START OF TEXT
    0x00000003, // END OF TEXT
    0x00000004, // END OF TRANSMISSION
    0x00000005, // ENQUIRY
    0x00000006, // ACKNOWLEDGE
    0x00000007, // BELL
    0x00000008, // BACKSPACE
    0x00000009, // HORIZONTAL TABULATION
    0x0000000A, // LINE FEED
    0x0000000B, // VERTICAL TABULATION
    0x0000000C, // FORM FEED
    0x0000000D, // CARRIAGE RETURN
    0x0000000E, // SHIFT OUT
    0x0000000F, // SHIFT IN
    0x00000010, // DATA LINK ESCAPE
    0x00000011, // DEVICE CONTROL ONE
    0x00000012, // DEVICE CONTROL TWO
    0x00000013, // DEVICE CONTROL THREE
    0x00000014, // DEVICE CONTROL FOUR
    0x00000015, // NEGATIVE ACKNOWLEDGE
    0x00000016, // SYNCHRONOUS IDLE
    0x00000017, // END OF TRANSMISSION BLOCK
    0x00000018, // CANCEL
    0x00000019, // END OF MEDIUM
    0x0000001A, // SUBSTITUTE
    0x0000001B, // ESCAPE
    0x0000001C, // FILE SEPARATOR
    0x0000001D, // GROUP SEPARATOR
    0x0000001E, // RECORD SEPARATOR
    0x0000001F, // UNIT SEPARATOR
    0x00000020, // SPACE
    0x00000021, // EXCLAMATION MARK
    0x00000022, // QUOTATION MARK
    0x00000023, // NUMBER SIGN
    0x00000024, // DOLLAR SIGN
    0x00000025, // PERCENT SIGN
    0x00000026, // AMPERSAND
    0x00000027, // APOSTROPHE
    0x00000028, // LEFT PARENTHESIS
    0x00000029, // RIGHT PARENTHESIS
    0x0000002A, // ASTERISK
    0x0000002B, // PLUS SIGN
    0x0000002C, // COMMA
    0x0000002D, // HYPHEN-MINUS
    0x0000002E, // FULL STOP
    0x0000002F, // SOLIDUS
    0x00000030, // DIGIT ZERO
    0x00000031, // DIGIT ONE
    0x00000032, // DIGIT TWO
    0x00000033, // DIGIT THREE
    0x00000034, // DIGIT FOUR
    0x00000035, // DIGIT FIVE
    0x00000036, // DIGIT SIX
    0x00000037, // DIGIT SEVEN
    0x00000038, // DIGIT EIGHT
    0x00000039, // DIGIT NINE
    0x0000003A, // COLON
    0x0000003B, // SEMICOLON
    0x0000003C, // LESS-THAN SIGN
    0x0000003D, // EQUALS SIGN
    0x0000003E, // GREATER-THAN SIGN
    0x0000003F, // QUESTION MARK
    0x00000040, // COMMERCIAL AT
    0x00000041, // LATIN CAPITAL LETTER A
    0x00000042, // LATIN CAPITAL LETTER B
    0x00000043, // LATIN CAPITAL LETTER C
    0x00000044, // LATIN CAPITAL LETTER D
    0x00000045, // LATIN CAPITAL LETTER E
    0x00000046, // LATIN CAPITAL LETTER F
    0x00000047, // LATIN CAPITAL LETTER G
    0x00000048, // LATIN CAPITAL LETTER H
    0x00000049, // LATIN CAPITAL LETTER I
    0x0000004A, // LATIN CAPITAL LETTER J
    0x0000004B, // LATIN CAPITAL LETTER K
    0x0000004C, // LATIN CAPITAL LETTER L
    0x0000004D, // LATIN CAPITAL LETTER M
    0x0000004E, // LATIN CAPITAL LETTER N
    0x0000004F, // LATIN CAPITAL LETTER O
    0x00000050, // LATIN CAPITAL LETTER P
    0x00000051, // LATIN CAPITAL LETTER Q
    0x00000052, // LATIN CAPITAL LETTER R
    0x00000053, // LATIN CAPITAL LETTER S
    0x00000054, // LATIN CAPITAL LETTER T
    0x00000055, // LATIN CAPITAL LETTER U
    0x00000056, // LATIN CAPITAL LETTER V
    0x00000057, // LATIN CAPITAL LETTER W
    0x00000058, // LATIN CAPITAL LETTER X
    0x00000059, // LATIN CAPITAL LETTER Y
    0x0000005A, // LATIN CAPITAL LETTER Z
    0x0000005B, // LEFT SQUARE BRACKET
    0x0000005C, // REVERSE SOLIDUS
    0x0000005D, // RIGHT SQUARE BRACKET
    0x0000005E, // CIRCUMFLEX ACCENT
    0x0000005F, // LOW LINE
    0x00000060, // GRAVE ACCENT
    0x00000061, // LATIN SMALL LETTER A
    0x00000062, // LATIN SMALL LETTER B
    0x00000063, // LATIN SMALL LETTER C
    0x00000064, // LATIN SMALL LETTER D
    0x00000065, // LATIN SMALL LETTER E
    0x00000066, // LATIN SMALL LETTER F
    0x00000067, // LATIN SMALL LETTER G
    0x00000068, // LATIN SMALL LETTER H
    0x00000069, // LATIN SMALL LETTER I
    0x0000006A, // LATIN SMALL LETTER J
    0x0000006B, // LATIN SMALL LETTER K
    0x0000006C, // LATIN SMALL LETTER L
    0x0000006D, // LATIN SMALL LETTER M
    0x0000006E, // LATIN SMALL LETTER N
    0x0000006F, // LATIN SMALL LETTER O
    0x00000070, // LATIN SMALL LETTER P
    0x00000071, // LATIN SMALL LETTER Q
    0x00000072, // LATIN SMALL LETTER R
    0x00000073, // LATIN SMALL LETTER S
    0x00000074, // LATIN SMALL LETTER T
    0x00000075, // LATIN SMALL LETTER U
    0x00000076, // LATIN SMALL LETTER V
    0x00000077, // LATIN SMALL LETTER W
    0x00000078, // LATIN SMALL LETTER X
    0x00000079, // LATIN SMALL LETTER Y
    0x0000007A, // LATIN SMALL LETTER Z
    0x0000007B, // LEFT CURLY BRACKET
    0x0000007C, // VERTICAL LINE
    0x0000007D, // RIGHT CURLY BRACKET
    0x0000007E, // TILDE
    0x0000007F, // DELETE
    0x00000080, // <control>
    0x00000081, // <control>
    0x00000082, // <control>
    0x00000083, // <control>
    0x00000084, // <control>
    0x00000085, // <control>
    0x00000086, // <control>
    0x00000087, // <control>
    0x00000088, // <control>
    0x00000089, // <control>
    0x0000008A, // <control>
    0x0000008B, // <control>
    0x0000008C, // <control>
    0x0000008D, // <control>
    0x0000008E, // <control>
    0x0000008F, // <control>
    0x00000090, // <control>
    0x00000091, // <control>
    0x00000092, // <control>
    0x00000093, // <control>
    0x00000094, // <control>
    0x00000095, // <control>
    0x00000096, // <control>
    0x00000097, // <control>
    0x00000098, // <control>
    0x00000099, // <control>
    0x0000009A, // <control>
    0x0000009B, // <control>
    0x0000009C, // <control>
    0x0000009D, // <control>
    0x0000009E, // <control>
    0x0000009F, // <control>
    0x000000A0, // NO-BREAK SPACE
    0x000000A1, // INVERTED EXCLAMATION MARK
    0x000000A2, // CENT SIGN
    0x000000A3, // POUND SIGN
    0x000000A4, // CURRENCY SIGN
    0x000000A5, // YEN SIGN
    0x000000A6, // BROKEN BAR
    0x000000A7, // SECTION SIGN
    0x000000A8, // DIAERESIS
    0x000000A9, // COPYRIGHT SIGN
    0x000000AA, // FEMININE ORDINAL INDICATOR
    0x000000AB, // LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x000000AC, // NOT SIGN
    0x000000AD, // SOFT HYPHEN
    0x000000AE, // REGISTERED SIGN
    0x000000AF, // MACRON
    0x000000B0, // DEGREE SIGN
    0x000000B1, // PLUS-MINUS SIGN
    0x000000B2, // SUPERSCRIPT TWO
    0x000000B3, // SUPERSCRIPT THREE
    0x000000B4, // ACUTE ACCENT
    0x000000B5, // MICRO SIGN
    0x000000B6, // PILCROW SIGN
    0x000000B7, // MIDDLE DOT
    0x000000B8, // CEDILLA
    0x000000B9, // SUPERSCRIPT ONE
    0x000000BA, // MASCULINE ORDINAL INDICATOR
    0x000000BB, // RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x000000BC, // VULGAR FRACTION ONE QUARTER
    0x000000BD, // VULGAR FRACTION ONE HALF
    0x000000BE, // VULGAR FRACTION THREE QUARTERS
    0x000000BF, // INVERTED QUESTION MARK
    0x000000C0, // LATIN CAPITAL LETTER A WITH GRAVE
    0x000000C1, // LATIN CAPITAL LETTER A WITH ACUTE
    0x000000C2, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
    0x000000C3, // LATIN CAPITAL LETTER A WITH TILDE
    0x000000C4, // LATIN CAPITAL LETTER A WITH DIAERESIS
    0x000000C5, // LATIN CAPITAL LETTER A WITH RING ABOVE
    0x000000C6, // LATIN CAPITAL LETTER AE
    0x000000C7, // LATIN CAPITAL LETTER C WITH CEDILLA
    0x000000C8, // LATIN CAPITAL LETTER E WITH GRAVE
    0x000000C9, // LATIN CAPITAL LETTER E WITH ACUTE
    0x000000CA, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX
    0x000000CB, // LATIN CAPITAL LETTER E WITH DIAERESIS
    0x000000CC, // LATIN CAPITAL LETTER I WITH GRAVE
    0x000000CD, // LATIN CAPITAL LETTER I WITH ACUTE
    0x000000CE, // LATIN CAPITAL LETTER I WITH CIRCUMFLEX
    0x000000CF, // LATIN CAPITAL LETTER I WITH DIAERESIS
    0x0000011E, // LATIN CAPITAL LETTER G WITH BREVE
    0x000000D1, // LATIN CAPITAL LETTER N WITH TILDE
    0x000000D2, // LATIN CAPITAL LETTER O WITH GRAVE
    0x000000D3, // LATIN CAPITAL LETTER O WITH ACUTE
    0x000000D4, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
    0x000000D5, // LATIN CAPITAL LETTER O WITH TILDE
    0x000000D6, // LATIN CAPITAL LETTER O WITH DIAERESIS
    0x000000D7, // MULTIPLICATION SIGN
    0x000000D8, // LATIN CAPITAL LETTER O WITH STROKE
    0x000000D9, // LATIN CAPITAL LETTER U WITH GRAVE
    0x000000DA, // LATIN CAPITAL LETTER U WITH ACUTE
    0x000000DB, // LATIN CAPITAL LETTER U WITH CIRCUMFLEX
    0x000000DC, // LATIN CAPITAL LETTER U WITH DIAERESIS
    0x00000130, // LATIN CAPITAL LETTER I WITH DOT ABOVE
    0x0000015E, // LATIN CAPITAL LETTER S WITH CEDILLA
    0x000000DF, // LATIN SMALL LETTER SHARP S
    0x000000E0, // LATIN SMALL LETTER A WITH GRAVE
    0x000000E1, // LATIN SMALL LETTER A WITH ACUTE
    0x000000E2, // LATIN SMALL LETTER A WITH CIRCUMFLEX
    0x000000E3, // LATIN SMALL LETTER A WITH TILDE
    0x000000E4, // LATIN SMALL LETTER A WITH DIAERESIS
    0x000000E5, // LATIN SMALL LETTER A WITH RING ABOVE
    0x000000E6, // LATIN SMALL LETTER AE
    0x000000E7, // LATIN SMALL LETTER C WITH CEDILLA
    0x000000E8, // LATIN SMALL LETTER E WITH GRAVE
    0x000000E9, // LATIN SMALL LETTER E WITH ACUTE
    0x000000EA, // LATIN SMALL LETTER E WITH CIRCUMFLEX
    0x000000EB, // LATIN SMALL LETTER E WITH DIAERESIS
    0x000000EC, // LATIN SMALL LETTER I WITH GRAVE
    0x000000ED, // LATIN SMALL LETTER I WITH ACUTE
    0x000000EE, // LATIN SMALL LETTER I WITH CIRCUMFLEX
    0x000000EF, // LATIN SMALL LETTER I WITH DIAERESIS
    0x0000011F, // LATIN SMALL LETTER G WITH BREVE
    0x000000F1, // LATIN SMALL LETTER N WITH TILDE
    0x000000F2, // LATIN SMALL LETTER O WITH GRAVE
    0x000000F3, // LATIN SMALL LETTER O WITH ACUTE
    0x000000F4, // LATIN SMALL LETTER O WITH CIRCUMFLEX
    0x000000F5, // LATIN SMALL LETTER O WITH TILDE
    0x000000F6, // LATIN SMALL LETTER O WITH DIAERESIS
    0x000000F7, // DIVISION SIGN
    0x000000F8, // LATIN SMALL LETTER O WITH STROKE
    0x000000F9, // LATIN SMALL LETTER U WITH GRAVE
    0x000000FA, // LATIN SMALL LETTER U WITH ACUTE
    0x000000FB, // LATIN SMALL LETTER U WITH CIRCUMFLEX
    0x000000FC, // LATIN SMALL LETTER U WITH DIAERESIS
    0x00000131, // LATIN SMALL LETTER DOTLESS I
    0x0000015F, // LATIN SMALL LETTER S WITH CEDILLA
    0x000000FF  // LATIN SMALL LETTER Y WITH DIAERESIS
  };

  // ISO-8859-10 transcoding table
  static const t_quad ISO_8859_10_MAP[256] = {
    0x00000000, // NULL
    0x00000001, // START OF HEADING
    0x00000002, // START OF TEXT
    0x00000003, // END OF TEXT
    0x00000004, // END OF TRANSMISSION
    0x00000005, // ENQUIRY
    0x00000006, // ACKNOWLEDGE
    0x00000007, // BELL
    0x00000008, // BACKSPACE
    0x00000009, // HORIZONTAL TABULATION
    0x0000000A, // LINE FEED
    0x0000000B, // VERTICAL TABULATION
    0x0000000C, // FORM FEED
    0x0000000D, // CARRIAGE RETURN
    0x0000000E, // SHIFT OUT
    0x0000000F, // SHIFT IN
    0x00000010, // DATA LINK ESCAPE
    0x00000011, // DEVICE CONTROL ONE
    0x00000012, // DEVICE CONTROL TWO
    0x00000013, // DEVICE CONTROL THREE
    0x00000014, // DEVICE CONTROL FOUR
    0x00000015, // NEGATIVE ACKNOWLEDGE
    0x00000016, // SYNCHRONOUS IDLE
    0x00000017, // END OF TRANSMISSION BLOCK
    0x00000018, // CANCEL
    0x00000019, // END OF MEDIUM
    0x0000001A, // SUBSTITUTE
    0x0000001B, // ESCAPE
    0x0000001C, // FILE SEPARATOR
    0x0000001D, // GROUP SEPARATOR
    0x0000001E, // RECORD SEPARATOR
    0x0000001F, // UNIT SEPARATOR
    0x00000020, // SPACE
    0x00000021, // EXCLAMATION MARK
    0x00000022, // QUOTATION MARK
    0x00000023, // NUMBER SIGN
    0x00000024, // DOLLAR SIGN
    0x00000025, // PERCENT SIGN
    0x00000026, // AMPERSAND
    0x00000027, // APOSTROPHE
    0x00000028, // LEFT PARENTHESIS
    0x00000029, // RIGHT PARENTHESIS
    0x0000002A, // ASTERISK
    0x0000002B, // PLUS SIGN
    0x0000002C, // COMMA
    0x0000002D, // HYPHEN-MINUS
    0x0000002E, // FULL STOP
    0x0000002F, // SOLIDUS
    0x00000030, // DIGIT ZERO
    0x00000031, // DIGIT ONE
    0x00000032, // DIGIT TWO
    0x00000033, // DIGIT THREE
    0x00000034, // DIGIT FOUR
    0x00000035, // DIGIT FIVE
    0x00000036, // DIGIT SIX
    0x00000037, // DIGIT SEVEN
    0x00000038, // DIGIT EIGHT
    0x00000039, // DIGIT NINE
    0x0000003A, // COLON
    0x0000003B, // SEMICOLON
    0x0000003C, // LESS-THAN SIGN
    0x0000003D, // EQUALS SIGN
    0x0000003E, // GREATER-THAN SIGN
    0x0000003F, // QUESTION MARK
    0x00000040, // COMMERCIAL AT
    0x00000041, // LATIN CAPITAL LETTER A
    0x00000042, // LATIN CAPITAL LETTER B
    0x00000043, // LATIN CAPITAL LETTER C
    0x00000044, // LATIN CAPITAL LETTER D
    0x00000045, // LATIN CAPITAL LETTER E
    0x00000046, // LATIN CAPITAL LETTER F
    0x00000047, // LATIN CAPITAL LETTER G
    0x00000048, // LATIN CAPITAL LETTER H
    0x00000049, // LATIN CAPITAL LETTER I
    0x0000004A, // LATIN CAPITAL LETTER J
    0x0000004B, // LATIN CAPITAL LETTER K
    0x0000004C, // LATIN CAPITAL LETTER L
    0x0000004D, // LATIN CAPITAL LETTER M
    0x0000004E, // LATIN CAPITAL LETTER N
    0x0000004F, // LATIN CAPITAL LETTER O
    0x00000050, // LATIN CAPITAL LETTER P
    0x00000051, // LATIN CAPITAL LETTER Q
    0x00000052, // LATIN CAPITAL LETTER R
    0x00000053, // LATIN CAPITAL LETTER S
    0x00000054, // LATIN CAPITAL LETTER T
    0x00000055, // LATIN CAPITAL LETTER U
    0x00000056, // LATIN CAPITAL LETTER V
    0x00000057, // LATIN CAPITAL LETTER W
    0x00000058, // LATIN CAPITAL LETTER X
    0x00000059, // LATIN CAPITAL LETTER Y
    0x0000005A, // LATIN CAPITAL LETTER Z
    0x0000005B, // LEFT SQUARE BRACKET
    0x0000005C, // REVERSE SOLIDUS
    0x0000005D, // RIGHT SQUARE BRACKET
    0x0000005E, // CIRCUMFLEX ACCENT
    0x0000005F, // LOW LINE
    0x00000060, // GRAVE ACCENT
    0x00000061, // LATIN SMALL LETTER A
    0x00000062, // LATIN SMALL LETTER B
    0x00000063, // LATIN SMALL LETTER C
    0x00000064, // LATIN SMALL LETTER D
    0x00000065, // LATIN SMALL LETTER E
    0x00000066, // LATIN SMALL LETTER F
    0x00000067, // LATIN SMALL LETTER G
    0x00000068, // LATIN SMALL LETTER H
    0x00000069, // LATIN SMALL LETTER I
    0x0000006A, // LATIN SMALL LETTER J
    0x0000006B, // LATIN SMALL LETTER K
    0x0000006C, // LATIN SMALL LETTER L
    0x0000006D, // LATIN SMALL LETTER M
    0x0000006E, // LATIN SMALL LETTER N
    0x0000006F, // LATIN SMALL LETTER O
    0x00000070, // LATIN SMALL LETTER P
    0x00000071, // LATIN SMALL LETTER Q
    0x00000072, // LATIN SMALL LETTER R
    0x00000073, // LATIN SMALL LETTER S
    0x00000074, // LATIN SMALL LETTER T
    0x00000075, // LATIN SMALL LETTER U
    0x00000076, // LATIN SMALL LETTER V
    0x00000077, // LATIN SMALL LETTER W
    0x00000078, // LATIN SMALL LETTER X
    0x00000079, // LATIN SMALL LETTER Y
    0x0000007A, // LATIN SMALL LETTER Z
    0x0000007B, // LEFT CURLY BRACKET
    0x0000007C, // VERTICAL LINE
    0x0000007D, // RIGHT CURLY BRACKET
    0x0000007E, // TILDE
    0x0000007F, // DELETE
    0x00000080, // <control>
    0x00000081, // <control>
    0x00000082, // <control>
    0x00000083, // <control>
    0x00000084, // <control>
    0x00000085, // <control>
    0x00000086, // <control>
    0x00000087, // <control>
    0x00000088, // <control>
    0x00000089, // <control>
    0x0000008A, // <control>
    0x0000008B, // <control>
    0x0000008C, // <control>
    0x0000008D, // <control>
    0x0000008E, // <control>
    0x0000008F, // <control>
    0x00000090, // <control>
    0x00000091, // <control>
    0x00000092, // <control>
    0x00000093, // <control>
    0x00000094, // <control>
    0x00000095, // <control>
    0x00000096, // <control>
    0x00000097, // <control>
    0x00000098, // <control>
    0x00000099, // <control>
    0x0000009A, // <control>
    0x0000009B, // <control>
    0x0000009C, // <control>
    0x0000009D, // <control>
    0x0000009E, // <control>
    0x0000009F, // <control>
    0x000000A0, // NO-BREAK SPACE
    0x00000104, // LATIN CAPITAL LETTER A WITH OGONEK
    0x00000112, // LATIN CAPITAL LETTER E WITH MACRON
    0x00000122, // LATIN CAPITAL LETTER G WITH CEDILLA
    0x0000012A, // LATIN CAPITAL LETTER I WITH MACRON
    0x00000128, // LATIN CAPITAL LETTER I WITH TILDE
    0x00000136, // LATIN CAPITAL LETTER K WITH CEDILLA
    0x000000A7, // SECTION SIGN
    0x0000013B, // LATIN CAPITAL LETTER L WITH CEDILLA
    0x00000110, // LATIN CAPITAL LETTER D WITH STROKE
    0x00000160, // LATIN CAPITAL LETTER S WITH CARON
    0x00000166, // LATIN CAPITAL LETTER T WITH STROKE
    0x0000017D, // LATIN CAPITAL LETTER Z WITH CARON
    0x000000AD, // SOFT HYPHEN
    0x0000016A, // LATIN CAPITAL LETTER U WITH MACRON
    0x0000014A, // LATIN CAPITAL LETTER ENG
    0x000000B0, // DEGREE SIGN
    0x00000105, // LATIN SMALL LETTER A WITH OGONEK
    0x00000113, // LATIN SMALL LETTER E WITH MACRON
    0x00000123, // LATIN SMALL LETTER G WITH CEDILLA
    0x0000012B, // LATIN SMALL LETTER I WITH MACRON
    0x00000129, // LATIN SMALL LETTER I WITH TILDE
    0x00000137, // LATIN SMALL LETTER K WITH CEDILLA
    0x000000B7, // MIDDLE DOT
    0x0000013C, // LATIN SMALL LETTER L WITH CEDILLA
    0x00000111, // LATIN SMALL LETTER D WITH STROKE
    0x00000161, // LATIN SMALL LETTER S WITH CARON
    0x00000167, // LATIN SMALL LETTER T WITH STROKE
    0x0000017E, // LATIN SMALL LETTER Z WITH CARON
    0x00002015, // HORIZONTAL BAR
    0x0000016B, // LATIN SMALL LETTER U WITH MACRON
    0x0000014B, // LATIN SMALL LETTER ENG
    0x00000100, // LATIN CAPITAL LETTER A WITH MACRON
    0x000000C1, // LATIN CAPITAL LETTER A WITH ACUTE
    0x000000C2, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
    0x000000C3, // LATIN CAPITAL LETTER A WITH TILDE
    0x000000C4, // LATIN CAPITAL LETTER A WITH DIAERESIS
    0x000000C5, // LATIN CAPITAL LETTER A WITH RING ABOVE
    0x000000C6, // LATIN CAPITAL LETTER AE
    0x0000012E, // LATIN CAPITAL LETTER I WITH OGONEK
    0x0000010C, // LATIN CAPITAL LETTER C WITH CARON
    0x000000C9, // LATIN CAPITAL LETTER E WITH ACUTE
    0x00000118, // LATIN CAPITAL LETTER E WITH OGONEK
    0x000000CB, // LATIN CAPITAL LETTER E WITH DIAERESIS
    0x00000116, // LATIN CAPITAL LETTER E WITH DOT ABOVE
    0x000000CD, // LATIN CAPITAL LETTER I WITH ACUTE
    0x000000CE, // LATIN CAPITAL LETTER I WITH CIRCUMFLEX
    0x000000CF, // LATIN CAPITAL LETTER I WITH DIAERESIS
    0x000000D0, // LATIN CAPITAL LETTER ETH (Icelandic)
    0x00000145, // LATIN CAPITAL LETTER N WITH CEDILLA
    0x0000014C, // LATIN CAPITAL LETTER O WITH MACRON
    0x000000D3, // LATIN CAPITAL LETTER O WITH ACUTE
    0x000000D4, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
    0x000000D5, // LATIN CAPITAL LETTER O WITH TILDE
    0x000000D6, // LATIN CAPITAL LETTER O WITH DIAERESIS
    0x00000168, // LATIN CAPITAL LETTER U WITH TILDE
    0x000000D8, // LATIN CAPITAL LETTER O WITH STROKE
    0x00000172, // LATIN CAPITAL LETTER U WITH OGONEK
    0x000000DA, // LATIN CAPITAL LETTER U WITH ACUTE
    0x000000DB, // LATIN CAPITAL LETTER U WITH CIRCUMFLEX
    0x000000DC, // LATIN CAPITAL LETTER U WITH DIAERESIS
    0x000000DD, // LATIN CAPITAL LETTER Y WITH ACUTE
    0x000000DE, // LATIN CAPITAL LETTER THORN (Icelandic)
    0x000000DF, // LATIN SMALL LETTER SHARP S (German)
    0x00000101, // LATIN SMALL LETTER A WITH MACRON
    0x000000E1, // LATIN SMALL LETTER A WITH ACUTE
    0x000000E2, // LATIN SMALL LETTER A WITH CIRCUMFLEX
    0x000000E3, // LATIN SMALL LETTER A WITH TILDE
    0x000000E4, // LATIN SMALL LETTER A WITH DIAERESIS
    0x000000E5, // LATIN SMALL LETTER A WITH RING ABOVE
    0x000000E6, // LATIN SMALL LETTER AE
    0x0000012F, // LATIN SMALL LETTER I WITH OGONEK
    0x0000010D, // LATIN SMALL LETTER C WITH CARON
    0x000000E9, // LATIN SMALL LETTER E WITH ACUTE
    0x00000119, // LATIN SMALL LETTER E WITH OGONEK
    0x000000EB, // LATIN SMALL LETTER E WITH DIAERESIS
    0x00000117, // LATIN SMALL LETTER E WITH DOT ABOVE
    0x000000ED, // LATIN SMALL LETTER I WITH ACUTE
    0x000000EE, // LATIN SMALL LETTER I WITH CIRCUMFLEX
    0x000000EF, // LATIN SMALL LETTER I WITH DIAERESIS
    0x000000F0, // LATIN SMALL LETTER ETH (Icelandic)
    0x00000146, // LATIN SMALL LETTER N WITH CEDILLA
    0x0000014D, // LATIN SMALL LETTER O WITH MACRON
    0x000000F3, // LATIN SMALL LETTER O WITH ACUTE
    0x000000F4, // LATIN SMALL LETTER O WITH CIRCUMFLEX
    0x000000F5, // LATIN SMALL LETTER O WITH TILDE
    0x000000F6, // LATIN SMALL LETTER O WITH DIAERESIS
    0x00000169, // LATIN SMALL LETTER U WITH TILDE
    0x000000F8, // LATIN SMALL LETTER O WITH STROKE
    0x00000173, // LATIN SMALL LETTER U WITH OGONEK
    0x000000FA, // LATIN SMALL LETTER U WITH ACUTE
    0x000000FB, // LATIN SMALL LETTER U WITH CIRCUMFLEX
    0x000000FC, // LATIN SMALL LETTER U WITH DIAERESIS
    0x000000FD, // LATIN SMALL LETTER Y WITH ACUTE
    0x000000FE, // LATIN SMALL LETTER THORN (Icelandic)
    0x00000138  // LATIN SMALL LETTER KRA
  };

  // ISO-8859-11 transcoding table
  static const t_quad ISO_8859_11_MAP[256] = {
    0x00000000, // NULL
    0x00000001, // START OF HEADING
    0x00000002, // START OF TEXT
    0x00000003, // END OF TEXT
    0x00000004, // END OF TRANSMISSION
    0x00000005, // ENQUIRY
    0x00000006, // ACKNOWLEDGE
    0x00000007, // BELL
    0x00000008, // BACKSPACE
    0x00000009, // HORIZONTAL TABULATION
    0x0000000A, // LINE FEED
    0x0000000B, // VERTICAL TABULATION
    0x0000000C, // FORM FEED
    0x0000000D, // CARRIAGE RETURN
    0x0000000E, // SHIFT OUT
    0x0000000F, // SHIFT IN
    0x00000010, // DATA LINK ESCAPE
    0x00000011, // DEVICE CONTROL ONE
    0x00000012, // DEVICE CONTROL TWO
    0x00000013, // DEVICE CONTROL THREE
    0x00000014, // DEVICE CONTROL FOUR
    0x00000015, // NEGATIVE ACKNOWLEDGE
    0x00000016, // SYNCHRONOUS IDLE
    0x00000017, // END OF TRANSMISSION BLOCK
    0x00000018, // CANCEL
    0x00000019, // END OF MEDIUM
    0x0000001A, // SUBSTITUTE
    0x0000001B, // ESCAPE
    0x0000001C, // FILE SEPARATOR
    0x0000001D, // GROUP SEPARATOR
    0x0000001E, // RECORD SEPARATOR
    0x0000001F, // UNIT SEPARATOR
    0x00000020, // SPACE
    0x00000021, // EXCLAMATION MARK
    0x00000022, // QUOTATION MARK
    0x00000023, // NUMBER SIGN
    0x00000024, // DOLLAR SIGN
    0x00000025, // PERCENT SIGN
    0x00000026, // AMPERSAND
    0x00000027, // APOSTROPHE
    0x00000028, // LEFT PARENTHESIS
    0x00000029, // RIGHT PARENTHESIS
    0x0000002A, // ASTERISK
    0x0000002B, // PLUS SIGN
    0x0000002C, // COMMA
    0x0000002D, // HYPHEN-MINUS
    0x0000002E, // FULL STOP
    0x0000002F, // SOLIDUS
    0x00000030, // DIGIT ZERO
    0x00000031, // DIGIT ONE
    0x00000032, // DIGIT TWO
    0x00000033, // DIGIT THREE
    0x00000034, // DIGIT FOUR
    0x00000035, // DIGIT FIVE
    0x00000036, // DIGIT SIX
    0x00000037, // DIGIT SEVEN
    0x00000038, // DIGIT EIGHT
    0x00000039, // DIGIT NINE
    0x0000003A, // COLON
    0x0000003B, // SEMICOLON
    0x0000003C, // LESS-THAN SIGN
    0x0000003D, // EQUALS SIGN
    0x0000003E, // GREATER-THAN SIGN
    0x0000003F, // QUESTION MARK
    0x00000040, // COMMERCIAL AT
    0x00000041, // LATIN CAPITAL LETTER A
    0x00000042, // LATIN CAPITAL LETTER B
    0x00000043, // LATIN CAPITAL LETTER C
    0x00000044, // LATIN CAPITAL LETTER D
    0x00000045, // LATIN CAPITAL LETTER E
    0x00000046, // LATIN CAPITAL LETTER F
    0x00000047, // LATIN CAPITAL LETTER G
    0x00000048, // LATIN CAPITAL LETTER H
    0x00000049, // LATIN CAPITAL LETTER I
    0x0000004A, // LATIN CAPITAL LETTER J
    0x0000004B, // LATIN CAPITAL LETTER K
    0x0000004C, // LATIN CAPITAL LETTER L
    0x0000004D, // LATIN CAPITAL LETTER M
    0x0000004E, // LATIN CAPITAL LETTER N
    0x0000004F, // LATIN CAPITAL LETTER O
    0x00000050, // LATIN CAPITAL LETTER P
    0x00000051, // LATIN CAPITAL LETTER Q
    0x00000052, // LATIN CAPITAL LETTER R
    0x00000053, // LATIN CAPITAL LETTER S
    0x00000054, // LATIN CAPITAL LETTER T
    0x00000055, // LATIN CAPITAL LETTER U
    0x00000056, // LATIN CAPITAL LETTER V
    0x00000057, // LATIN CAPITAL LETTER W
    0x00000058, // LATIN CAPITAL LETTER X
    0x00000059, // LATIN CAPITAL LETTER Y
    0x0000005A, // LATIN CAPITAL LETTER Z
    0x0000005B, // LEFT SQUARE BRACKET
    0x0000005C, // REVERSE SOLIDUS
    0x0000005D, // RIGHT SQUARE BRACKET
    0x0000005E, // CIRCUMFLEX ACCENT
    0x0000005F, // LOW LINE
    0x00000060, // GRAVE ACCENT
    0x00000061, // LATIN SMALL LETTER A
    0x00000062, // LATIN SMALL LETTER B
    0x00000063, // LATIN SMALL LETTER C
    0x00000064, // LATIN SMALL LETTER D
    0x00000065, // LATIN SMALL LETTER E
    0x00000066, // LATIN SMALL LETTER F
    0x00000067, // LATIN SMALL LETTER G
    0x00000068, // LATIN SMALL LETTER H
    0x00000069, // LATIN SMALL LETTER I
    0x0000006A, // LATIN SMALL LETTER J
    0x0000006B, // LATIN SMALL LETTER K
    0x0000006C, // LATIN SMALL LETTER L
    0x0000006D, // LATIN SMALL LETTER M
    0x0000006E, // LATIN SMALL LETTER N
    0x0000006F, // LATIN SMALL LETTER O
    0x00000070, // LATIN SMALL LETTER P
    0x00000071, // LATIN SMALL LETTER Q
    0x00000072, // LATIN SMALL LETTER R
    0x00000073, // LATIN SMALL LETTER S
    0x00000074, // LATIN SMALL LETTER T
    0x00000075, // LATIN SMALL LETTER U
    0x00000076, // LATIN SMALL LETTER V
    0x00000077, // LATIN SMALL LETTER W
    0x00000078, // LATIN SMALL LETTER X
    0x00000079, // LATIN SMALL LETTER Y
    0x0000007A, // LATIN SMALL LETTER Z
    0x0000007B, // LEFT CURLY BRACKET
    0x0000007C, // VERTICAL LINE
    0x0000007D, // RIGHT CURLY BRACKET
    0x0000007E, // TILDE
    0x0000007F, // DELETE
    0x00000080, // <control>
    0x00000081, // <control>
    0x00000082, // <control>
    0x00000083, // <control>
    0x00000084, // <control>
    0x00000085, // <control>
    0x00000086, // <control>
    0x00000087, // <control>
    0x00000088, // <control>
    0x00000089, // <control>
    0x0000008A, // <control>
    0x0000008B, // <control>
    0x0000008C, // <control>
    0x0000008D, // <control>
    0x0000008E, // <control>
    0x0000008F, // <control>
    0x00000090, // <control>
    0x00000091, // <control>
    0x00000092, // <control>
    0x00000093, // <control>
    0x00000094, // <control>
    0x00000095, // <control>
    0x00000096, // <control>
    0x00000097, // <control>
    0x00000098, // <control>
    0x00000099, // <control>
    0x0000009A, // <control>
    0x0000009B, // <control>
    0x0000009C, // <control>
    0x0000009D, // <control>
    0x0000009E, // <control>
    0x0000009F, // <control>
    0x000000A0, // NO-BREAK SPACE
    0x00000E01, // THAI CHARACTER KO KAI
    0x00000E02, // THAI CHARACTER KHO KHAI
    0x00000E03, // THAI CHARACTER KHO KHUAT
    0x00000E04, // THAI CHARACTER KHO KHWAI
    0x00000E05, // THAI CHARACTER KHO KHON
    0x00000E06, // THAI CHARACTER KHO RAKHANG
    0x00000E07, // THAI CHARACTER NGO NGU
    0x00000E08, // THAI CHARACTER CHO CHAN
    0x00000E09, // THAI CHARACTER CHO CHING
    0x00000E0A, // THAI CHARACTER CHO CHANG
    0x00000E0B, // THAI CHARACTER SO SO
    0x00000E0C, // THAI CHARACTER CHO CHOE
    0x00000E0D, // THAI CHARACTER YO YING
    0x00000E0E, // THAI CHARACTER DO CHADA
    0x00000E0F, // THAI CHARACTER TO PATAK
    0x00000E10, // THAI CHARACTER THO THAN
    0x00000E11, // THAI CHARACTER THO NANGMONTHO
    0x00000E12, // THAI CHARACTER THO PHUTHAO
    0x00000E13, // THAI CHARACTER NO NEN
    0x00000E14, // THAI CHARACTER DO DEK
    0x00000E15, // THAI CHARACTER TO TAO
    0x00000E16, // THAI CHARACTER THO THUNG
    0x00000E17, // THAI CHARACTER THO THAHAN
    0x00000E18, // THAI CHARACTER THO THONG
    0x00000E19, // THAI CHARACTER NO NU
    0x00000E1A, // THAI CHARACTER BO BAIMAI
    0x00000E1B, // THAI CHARACTER PO PLA
    0x00000E1C, // THAI CHARACTER PHO PHUNG
    0x00000E1D, // THAI CHARACTER FO FA
    0x00000E1E, // THAI CHARACTER PHO PHAN
    0x00000E1F, // THAI CHARACTER FO FAN
    0x00000E20, // THAI CHARACTER PHO SAMPHAO
    0x00000E21, // THAI CHARACTER MO MA
    0x00000E22, // THAI CHARACTER YO YAK
    0x00000E23, // THAI CHARACTER RO RUA
    0x00000E24, // THAI CHARACTER RU
    0x00000E25, // THAI CHARACTER LO LING
    0x00000E26, // THAI CHARACTER LU
    0x00000E27, // THAI CHARACTER WO WAEN
    0x00000E28, // THAI CHARACTER SO SALA
    0x00000E29, // THAI CHARACTER SO RUSI
    0x00000E2A, // THAI CHARACTER SO SUA
    0x00000E2B, // THAI CHARACTER HO HIP
    0x00000E2C, // THAI CHARACTER LO CHULA
    0x00000E2D, // THAI CHARACTER O ANG
    0x00000E2E, // THAI CHARACTER HO NOKHUK
    0x00000E2F, // THAI CHARACTER PAIYANNOI
    0x00000E30, // THAI CHARACTER SARA A
    0x00000E31, // THAI CHARACTER MAI HAN-AKAT
    0x00000E32, // THAI CHARACTER SARA AA
    0x00000E33, // THAI CHARACTER SARA AM
    0x00000E34, // THAI CHARACTER SARA I
    0x00000E35, // THAI CHARACTER SARA II
    0x00000E36, // THAI CHARACTER SARA UE
    0x00000E37, // THAI CHARACTER SARA UEE
    0x00000E38, // THAI CHARACTER SARA U
    0x00000E39, // THAI CHARACTER SARA UU
    0x00000E3A, // THAI CHARACTER PHINTHU
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0x00000E3F, // THAI CURRENCY SYMBOL BAHT
    0x00000E40, // THAI CHARACTER SARA E
    0x00000E41, // THAI CHARACTER SARA AE
    0x00000E42, // THAI CHARACTER SARA O
    0x00000E43, // THAI CHARACTER SARA AI MAIMUAN
    0x00000E44, // THAI CHARACTER SARA AI MAIMALAI
    0x00000E45, // THAI CHARACTER LAKKHANGYAO
    0x00000E46, // THAI CHARACTER MAIYAMOK
    0x00000E47, // THAI CHARACTER MAITAIKHU
    0x00000E48, // THAI CHARACTER MAI EK
    0x00000E49, // THAI CHARACTER MAI THO
    0x00000E4A, // THAI CHARACTER MAI TRI
    0x00000E4B, // THAI CHARACTER MAI CHATTAWA
    0x00000E4C, // THAI CHARACTER THANTHAKHAT
    0x00000E4D, // THAI CHARACTER NIKHAHIT
    0x00000E4E, // THAI CHARACTER YAMAKKAN
    0x00000E4F, // THAI CHARACTER FONGMAN
    0x00000E50, // THAI DIGIT ZERO
    0x00000E51, // THAI DIGIT ONE
    0x00000E52, // THAI DIGIT TWO
    0x00000E53, // THAI DIGIT THREE
    0x00000E54, // THAI DIGIT FOUR
    0x00000E55, // THAI DIGIT FIVE
    0x00000E56, // THAI DIGIT SIX
    0x00000E57, // THAI DIGIT SEVEN
    0x00000E58, // THAI DIGIT EIGHT
    0x00000E59, // THAI DIGIT NINE
    0x00000E5A, // THAI CHARACTER ANGKHANKHU
    0x00000E5B, // THAI CHARACTER KHOMUT
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF, // <not implemented>
    0xFFFFFFFF  // <not implemented>
  };

  // ISO-8859-13 transcoding table
  static const t_quad ISO_8859_13_MAP[256] = {
    0x00000000, // NULL
    0x00000001, // START OF HEADING
    0x00000002, // START OF TEXT
    0x00000003, // END OF TEXT
    0x00000004, // END OF TRANSMISSION
    0x00000005, // ENQUIRY
    0x00000006, // ACKNOWLEDGE
    0x00000007, // BELL
    0x00000008, // BACKSPACE
    0x00000009, // HORIZONTAL TABULATION
    0x0000000A, // LINE FEED
    0x0000000B, // VERTICAL TABULATION
    0x0000000C, // FORM FEED
    0x0000000D, // CARRIAGE RETURN
    0x0000000E, // SHIFT OUT
    0x0000000F, // SHIFT IN
    0x00000010, // DATA LINK ESCAPE
    0x00000011, // DEVICE CONTROL ONE
    0x00000012, // DEVICE CONTROL TWO
    0x00000013, // DEVICE CONTROL THREE
    0x00000014, // DEVICE CONTROL FOUR
    0x00000015, // NEGATIVE ACKNOWLEDGE
    0x00000016, // SYNCHRONOUS IDLE
    0x00000017, // END OF TRANSMISSION BLOCK
    0x00000018, // CANCEL
    0x00000019, // END OF MEDIUM
    0x0000001A, // SUBSTITUTE
    0x0000001B, // ESCAPE
    0x0000001C, // FILE SEPARATOR
    0x0000001D, // GROUP SEPARATOR
    0x0000001E, // RECORD SEPARATOR
    0x0000001F, // UNIT SEPARATOR
    0x00000020, // SPACE
    0x00000021, // EXCLAMATION MARK
    0x00000022, // QUOTATION MARK
    0x00000023, // NUMBER SIGN
    0x00000024, // DOLLAR SIGN
    0x00000025, // PERCENT SIGN
    0x00000026, // AMPERSAND
    0x00000027, // APOSTROPHE
    0x00000028, // LEFT PARENTHESIS
    0x00000029, // RIGHT PARENTHESIS
    0x0000002A, // ASTERISK
    0x0000002B, // PLUS SIGN
    0x0000002C, // COMMA
    0x0000002D, // HYPHEN-MINUS
    0x0000002E, // FULL STOP
    0x0000002F, // SOLIDUS
    0x00000030, // DIGIT ZERO
    0x00000031, // DIGIT ONE
    0x00000032, // DIGIT TWO
    0x00000033, // DIGIT THREE
    0x00000034, // DIGIT FOUR
    0x00000035, // DIGIT FIVE
    0x00000036, // DIGIT SIX
    0x00000037, // DIGIT SEVEN
    0x00000038, // DIGIT EIGHT
    0x00000039, // DIGIT NINE
    0x0000003A, // COLON
    0x0000003B, // SEMICOLON
    0x0000003C, // LESS-THAN SIGN
    0x0000003D, // EQUALS SIGN
    0x0000003E, // GREATER-THAN SIGN
    0x0000003F, // QUESTION MARK
    0x00000040, // COMMERCIAL AT
    0x00000041, // LATIN CAPITAL LETTER A
    0x00000042, // LATIN CAPITAL LETTER B
    0x00000043, // LATIN CAPITAL LETTER C
    0x00000044, // LATIN CAPITAL LETTER D
    0x00000045, // LATIN CAPITAL LETTER E
    0x00000046, // LATIN CAPITAL LETTER F
    0x00000047, // LATIN CAPITAL LETTER G
    0x00000048, // LATIN CAPITAL LETTER H
    0x00000049, // LATIN CAPITAL LETTER I
    0x0000004A, // LATIN CAPITAL LETTER J
    0x0000004B, // LATIN CAPITAL LETTER K
    0x0000004C, // LATIN CAPITAL LETTER L
    0x0000004D, // LATIN CAPITAL LETTER M
    0x0000004E, // LATIN CAPITAL LETTER N
    0x0000004F, // LATIN CAPITAL LETTER O
    0x00000050, // LATIN CAPITAL LETTER P
    0x00000051, // LATIN CAPITAL LETTER Q
    0x00000052, // LATIN CAPITAL LETTER R
    0x00000053, // LATIN CAPITAL LETTER S
    0x00000054, // LATIN CAPITAL LETTER T
    0x00000055, // LATIN CAPITAL LETTER U
    0x00000056, // LATIN CAPITAL LETTER V
    0x00000057, // LATIN CAPITAL LETTER W
    0x00000058, // LATIN CAPITAL LETTER X
    0x00000059, // LATIN CAPITAL LETTER Y
    0x0000005A, // LATIN CAPITAL LETTER Z
    0x0000005B, // LEFT SQUARE BRACKET
    0x0000005C, // REVERSE SOLIDUS
    0x0000005D, // RIGHT SQUARE BRACKET
    0x0000005E, // CIRCUMFLEX ACCENT
    0x0000005F, // LOW LINE
    0x00000060, // GRAVE ACCENT
    0x00000061, // LATIN SMALL LETTER A
    0x00000062, // LATIN SMALL LETTER B
    0x00000063, // LATIN SMALL LETTER C
    0x00000064, // LATIN SMALL LETTER D
    0x00000065, // LATIN SMALL LETTER E
    0x00000066, // LATIN SMALL LETTER F
    0x00000067, // LATIN SMALL LETTER G
    0x00000068, // LATIN SMALL LETTER H
    0x00000069, // LATIN SMALL LETTER I
    0x0000006A, // LATIN SMALL LETTER J
    0x0000006B, // LATIN SMALL LETTER K
    0x0000006C, // LATIN SMALL LETTER L
    0x0000006D, // LATIN SMALL LETTER M
    0x0000006E, // LATIN SMALL LETTER N
    0x0000006F, // LATIN SMALL LETTER O
    0x00000070, // LATIN SMALL LETTER P
    0x00000071, // LATIN SMALL LETTER Q
    0x00000072, // LATIN SMALL LETTER R
    0x00000073, // LATIN SMALL LETTER S
    0x00000074, // LATIN SMALL LETTER T
    0x00000075, // LATIN SMALL LETTER U
    0x00000076, // LATIN SMALL LETTER V
    0x00000077, // LATIN SMALL LETTER W
    0x00000078, // LATIN SMALL LETTER X
    0x00000079, // LATIN SMALL LETTER Y
    0x0000007A, // LATIN SMALL LETTER Z
    0x0000007B, // LEFT CURLY BRACKET
    0x0000007C, // VERTICAL LINE
    0x0000007D, // RIGHT CURLY BRACKET
    0x0000007E, // TILDE
    0x0000007F, // DELETE
    0x00000080, // <control>
    0x00000081, // <control>
    0x00000082, // <control>
    0x00000083, // <control>
    0x00000084, // <control>
    0x00000085, // <control>
    0x00000086, // <control>
    0x00000087, // <control>
    0x00000088, // <control>
    0x00000089, // <control>
    0x0000008A, // <control>
    0x0000008B, // <control>
    0x0000008C, // <control>
    0x0000008D, // <control>
    0x0000008E, // <control>
    0x0000008F, // <control>
    0x00000090, // <control>
    0x00000091, // <control>
    0x00000092, // <control>
    0x00000093, // <control>
    0x00000094, // <control>
    0x00000095, // <control>
    0x00000096, // <control>
    0x00000097, // <control>
    0x00000098, // <control>
    0x00000099, // <control>
    0x0000009A, // <control>
    0x0000009B, // <control>
    0x0000009C, // <control>
    0x0000009D, // <control>
    0x0000009E, // <control>
    0x0000009F, // <control>
    0x000000A0, // NO-BREAK SPACE
    0x0000201D, // RIGHT DOUBLE QUOTATION MARK
    0x000000A2, // CENT SIGN
    0x000000A3, // POUND SIGN
    0x000000A4, // CURRENCY SIGN
    0x0000201E, // DOUBLE LOW-9 QUOTATION MARK
    0x000000A6, // BROKEN BAR
    0x000000A7, // SECTION SIGN
    0x000000D8, // LATIN CAPITAL LETTER O WITH STROKE
    0x000000A9, // COPYRIGHT SIGN
    0x00000156, // LATIN CAPITAL LETTER R WITH CEDILLA
    0x000000AB, // LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x000000AC, // NOT SIGN
    0x000000AD, // SOFT HYPHEN
    0x000000AE, // REGISTERED SIGN
    0x000000C6, // LATIN CAPITAL LETTER AE
    0x000000B0, // DEGREE SIGN
    0x000000B1, // PLUS-MINUS SIGN
    0x000000B2, // SUPERSCRIPT TWO
    0x000000B3, // SUPERSCRIPT THREE
    0x0000201C, // LEFT DOUBLE QUOTATION MARK
    0x000000B5, // MICRO SIGN
    0x000000B6, // PILCROW SIGN
    0x000000B7, // MIDDLE DOT
    0x000000F8, // LATIN SMALL LETTER O WITH STROKE
    0x000000B9, // SUPERSCRIPT ONE
    0x00000157, // LATIN SMALL LETTER R WITH CEDILLA
    0x000000BB, // RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x000000BC, // VULGAR FRACTION ONE QUARTER
    0x000000BD, // VULGAR FRACTION ONE HALF
    0x000000BE, // VULGAR FRACTION THREE QUARTERS
    0x000000E6, // LATIN SMALL LETTER AE
    0x00000104, // LATIN CAPITAL LETTER A WITH OGONEK
    0x0000012E, // LATIN CAPITAL LETTER I WITH OGONEK
    0x00000100, // LATIN CAPITAL LETTER A WITH MACRON
    0x00000106, // LATIN CAPITAL LETTER C WITH ACUTE
    0x000000C4, // LATIN CAPITAL LETTER A WITH DIAERESIS
    0x000000C5, // LATIN CAPITAL LETTER A WITH RING ABOVE
    0x00000118, // LATIN CAPITAL LETTER E WITH OGONEK
    0x00000112, // LATIN CAPITAL LETTER E WITH MACRON
    0x0000010C, // LATIN CAPITAL LETTER C WITH CARON
    0x000000C9, // LATIN CAPITAL LETTER E WITH ACUTE
    0x00000179, // LATIN CAPITAL LETTER Z WITH ACUTE
    0x00000116, // LATIN CAPITAL LETTER E WITH DOT ABOVE
    0x00000122, // LATIN CAPITAL LETTER G WITH CEDILLA
    0x00000136, // LATIN CAPITAL LETTER K WITH CEDILLA
    0x0000012A, // LATIN CAPITAL LETTER I WITH MACRON
    0x0000013B, // LATIN CAPITAL LETTER L WITH CEDILLA
    0x00000160, // LATIN CAPITAL LETTER S WITH CARON
    0x00000143, // LATIN CAPITAL LETTER N WITH ACUTE
    0x00000145, // LATIN CAPITAL LETTER N WITH CEDILLA
    0x000000D3, // LATIN CAPITAL LETTER O WITH ACUTE
    0x0000014C, // LATIN CAPITAL LETTER O WITH MACRON
    0x000000D5, // LATIN CAPITAL LETTER O WITH TILDE
    0x000000D6, // LATIN CAPITAL LETTER O WITH DIAERESIS
    0x000000D7, // MULTIPLICATION SIGN
    0x00000172, // LATIN CAPITAL LETTER U WITH OGONEK
    0x00000141, // LATIN CAPITAL LETTER L WITH STROKE
    0x0000015A, // LATIN CAPITAL LETTER S WITH ACUTE
    0x0000016A, // LATIN CAPITAL LETTER U WITH MACRON
    0x000000DC, // LATIN CAPITAL LETTER U WITH DIAERESIS
    0x0000017B, // LATIN CAPITAL LETTER Z WITH DOT ABOVE
    0x0000017D, // LATIN CAPITAL LETTER Z WITH CARON
    0x000000DF, // LATIN SMALL LETTER SHARP S (German)
    0x00000105, // LATIN SMALL LETTER A WITH OGONEK
    0x0000012F, // LATIN SMALL LETTER I WITH OGONEK
    0x00000101, // LATIN SMALL LETTER A WITH MACRON
    0x00000107, // LATIN SMALL LETTER C WITH ACUTE
    0x000000E4, // LATIN SMALL LETTER A WITH DIAERESIS
    0x000000E5, // LATIN SMALL LETTER A WITH RING ABOVE
    0x00000119, // LATIN SMALL LETTER E WITH OGONEK
    0x00000113, // LATIN SMALL LETTER E WITH MACRON
    0x0000010D, // LATIN SMALL LETTER C WITH CARON
    0x000000E9, // LATIN SMALL LETTER E WITH ACUTE
    0x0000017A, // LATIN SMALL LETTER Z WITH ACUTE
    0x00000117, // LATIN SMALL LETTER E WITH DOT ABOVE
    0x00000123, // LATIN SMALL LETTER G WITH CEDILLA
    0x00000137, // LATIN SMALL LETTER K WITH CEDILLA
    0x0000012B, // LATIN SMALL LETTER I WITH MACRON
    0x0000013C, // LATIN SMALL LETTER L WITH CEDILLA
    0x00000161, // LATIN SMALL LETTER S WITH CARON
    0x00000144, // LATIN SMALL LETTER N WITH ACUTE
    0x00000146, // LATIN SMALL LETTER N WITH CEDILLA
    0x000000F3, // LATIN SMALL LETTER O WITH ACUTE
    0x0000014D, // LATIN SMALL LETTER O WITH MACRON
    0x000000F5, // LATIN SMALL LETTER O WITH TILDE
    0x000000F6, // LATIN SMALL LETTER O WITH DIAERESIS
    0x000000F7, // DIVISION SIGN
    0x00000173, // LATIN SMALL LETTER U WITH OGONEK
    0x00000142, // LATIN SMALL LETTER L WITH STROKE
    0x0000015B, // LATIN SMALL LETTER S WITH ACUTE
    0x0000016B, // LATIN SMALL LETTER U WITH MACRON
    0x000000FC, // LATIN SMALL LETTER U WITH DIAERESIS
    0x0000017C, // LATIN SMALL LETTER Z WITH DOT ABOVE
    0x0000017E, // LATIN SMALL LETTER Z WITH CARON
    0x00002019  // RIGHT SINGLE QUOTATION MARK
  };

  // ISO-8859-14 transcoding table
  static const t_quad ISO_8859_14_MAP[256] = {
    0x00000000, // NULL
    0x00000001, // START OF HEADING
    0x00000002, // START OF TEXT
    0x00000003, // END OF TEXT
    0x00000004, // END OF TRANSMISSION
    0x00000005, // ENQUIRY
    0x00000006, // ACKNOWLEDGE
    0x00000007, // BELL
    0x00000008, // BACKSPACE
    0x00000009, // HORIZONTAL TABULATION
    0x0000000A, // LINE FEED
    0x0000000B, // VERTICAL TABULATION
    0x0000000C, // FORM FEED
    0x0000000D, // CARRIAGE RETURN
    0x0000000E, // SHIFT OUT
    0x0000000F, // SHIFT IN
    0x00000010, // DATA LINK ESCAPE
    0x00000011, // DEVICE CONTROL ONE
    0x00000012, // DEVICE CONTROL TWO
    0x00000013, // DEVICE CONTROL THREE
    0x00000014, // DEVICE CONTROL FOUR
    0x00000015, // NEGATIVE ACKNOWLEDGE
    0x00000016, // SYNCHRONOUS IDLE
    0x00000017, // END OF TRANSMISSION BLOCK
    0x00000018, // CANCEL
    0x00000019, // END OF MEDIUM
    0x0000001A, // SUBSTITUTE
    0x0000001B, // ESCAPE
    0x0000001C, // FILE SEPARATOR
    0x0000001D, // GROUP SEPARATOR
    0x0000001E, // RECORD SEPARATOR
    0x0000001F, // UNIT SEPARATOR
    0x00000020, // SPACE
    0x00000021, // EXCLAMATION MARK
    0x00000022, // QUOTATION MARK
    0x00000023, // NUMBER SIGN
    0x00000024, // DOLLAR SIGN
    0x00000025, // PERCENT SIGN
    0x00000026, // AMPERSAND
    0x00000027, // APOSTROPHE
    0x00000028, // LEFT PARENTHESIS
    0x00000029, // RIGHT PARENTHESIS
    0x0000002A, // ASTERISK
    0x0000002B, // PLUS SIGN
    0x0000002C, // COMMA
    0x0000002D, // HYPHEN-MINUS
    0x0000002E, // FULL STOP
    0x0000002F, // SOLIDUS
    0x00000030, // DIGIT ZERO
    0x00000031, // DIGIT ONE
    0x00000032, // DIGIT TWO
    0x00000033, // DIGIT THREE
    0x00000034, // DIGIT FOUR
    0x00000035, // DIGIT FIVE
    0x00000036, // DIGIT SIX
    0x00000037, // DIGIT SEVEN
    0x00000038, // DIGIT EIGHT
    0x00000039, // DIGIT NINE
    0x0000003A, // COLON
    0x0000003B, // SEMICOLON
    0x0000003C, // LESS-THAN SIGN
    0x0000003D, // EQUALS SIGN
    0x0000003E, // GREATER-THAN SIGN
    0x0000003F, // QUESTION MARK
    0x00000040, // COMMERCIAL AT
    0x00000041, // LATIN CAPITAL LETTER A
    0x00000042, // LATIN CAPITAL LETTER B
    0x00000043, // LATIN CAPITAL LETTER C
    0x00000044, // LATIN CAPITAL LETTER D
    0x00000045, // LATIN CAPITAL LETTER E
    0x00000046, // LATIN CAPITAL LETTER F
    0x00000047, // LATIN CAPITAL LETTER G
    0x00000048, // LATIN CAPITAL LETTER H
    0x00000049, // LATIN CAPITAL LETTER I
    0x0000004A, // LATIN CAPITAL LETTER J
    0x0000004B, // LATIN CAPITAL LETTER K
    0x0000004C, // LATIN CAPITAL LETTER L
    0x0000004D, // LATIN CAPITAL LETTER M
    0x0000004E, // LATIN CAPITAL LETTER N
    0x0000004F, // LATIN CAPITAL LETTER O
    0x00000050, // LATIN CAPITAL LETTER P
    0x00000051, // LATIN CAPITAL LETTER Q
    0x00000052, // LATIN CAPITAL LETTER R
    0x00000053, // LATIN CAPITAL LETTER S
    0x00000054, // LATIN CAPITAL LETTER T
    0x00000055, // LATIN CAPITAL LETTER U
    0x00000056, // LATIN CAPITAL LETTER V
    0x00000057, // LATIN CAPITAL LETTER W
    0x00000058, // LATIN CAPITAL LETTER X
    0x00000059, // LATIN CAPITAL LETTER Y
    0x0000005A, // LATIN CAPITAL LETTER Z
    0x0000005B, // LEFT SQUARE BRACKET
    0x0000005C, // REVERSE SOLIDUS
    0x0000005D, // RIGHT SQUARE BRACKET
    0x0000005E, // CIRCUMFLEX ACCENT
    0x0000005F, // LOW LINE
    0x00000060, // GRAVE ACCENT
    0x00000061, // LATIN SMALL LETTER A
    0x00000062, // LATIN SMALL LETTER B
    0x00000063, // LATIN SMALL LETTER C
    0x00000064, // LATIN SMALL LETTER D
    0x00000065, // LATIN SMALL LETTER E
    0x00000066, // LATIN SMALL LETTER F
    0x00000067, // LATIN SMALL LETTER G
    0x00000068, // LATIN SMALL LETTER H
    0x00000069, // LATIN SMALL LETTER I
    0x0000006A, // LATIN SMALL LETTER J
    0x0000006B, // LATIN SMALL LETTER K
    0x0000006C, // LATIN SMALL LETTER L
    0x0000006D, // LATIN SMALL LETTER M
    0x0000006E, // LATIN SMALL LETTER N
    0x0000006F, // LATIN SMALL LETTER O
    0x00000070, // LATIN SMALL LETTER P
    0x00000071, // LATIN SMALL LETTER Q
    0x00000072, // LATIN SMALL LETTER R
    0x00000073, // LATIN SMALL LETTER S
    0x00000074, // LATIN SMALL LETTER T
    0x00000075, // LATIN SMALL LETTER U
    0x00000076, // LATIN SMALL LETTER V
    0x00000077, // LATIN SMALL LETTER W
    0x00000078, // LATIN SMALL LETTER X
    0x00000079, // LATIN SMALL LETTER Y
    0x0000007A, // LATIN SMALL LETTER Z
    0x0000007B, // LEFT CURLY BRACKET
    0x0000007C, // VERTICAL LINE
    0x0000007D, // RIGHT CURLY BRACKET
    0x0000007E, // TILDE
    0x0000007F, // DELETE
    0x00000080, // <control>
    0x00000081, // <control>
    0x00000082, // <control>
    0x00000083, // <control>
    0x00000084, // <control>
    0x00000085, // <control>
    0x00000086, // <control>
    0x00000087, // <control>
    0x00000088, // <control>
    0x00000089, // <control>
    0x0000008A, // <control>
    0x0000008B, // <control>
    0x0000008C, // <control>
    0x0000008D, // <control>
    0x0000008E, // <control>
    0x0000008F, // <control>
    0x00000090, // <control>
    0x00000091, // <control>
    0x00000092, // <control>
    0x00000093, // <control>
    0x00000094, // <control>
    0x00000095, // <control>
    0x00000096, // <control>
    0x00000097, // <control>
    0x00000098, // <control>
    0x00000099, // <control>
    0x0000009A, // <control>
    0x0000009B, // <control>
    0x0000009C, // <control>
    0x0000009D, // <control>
    0x0000009E, // <control>
    0x0000009F, // <control>
    0x000000A0, // NO-BREAK SPACE
    0x00001E02, // LATIN CAPITAL LETTER B WITH DOT ABOVE
    0x00001E03, // LATIN SMALL LETTER B WITH DOT ABOVE
    0x000000A3, // POUND SIGN
    0x0000010A, // LATIN CAPITAL LETTER C WITH DOT ABOVE
    0x0000010B, // LATIN SMALL LETTER C WITH DOT ABOVE
    0x00001E0A, // LATIN CAPITAL LETTER D WITH DOT ABOVE
    0x000000A7, // SECTION SIGN
    0x00001E80, // LATIN CAPITAL LETTER W WITH GRAVE
    0x000000A9, // COPYRIGHT SIGN
    0x00001E82, // LATIN CAPITAL LETTER W WITH ACUTE
    0x00001E0B, // LATIN SMALL LETTER D WITH DOT ABOVE
    0x00001EF2, // LATIN CAPITAL LETTER Y WITH GRAVE
    0x000000AD, // SOFT HYPHEN
    0x000000AE, // REGISTERED SIGN
    0x00000178, // LATIN CAPITAL LETTER Y WITH DIAERESIS
    0x00001E1E, // LATIN CAPITAL LETTER F WITH DOT ABOVE
    0x00001E1F, // LATIN SMALL LETTER F WITH DOT ABOVE
    0x00000120, // LATIN CAPITAL LETTER G WITH DOT ABOVE
    0x00000121, // LATIN SMALL LETTER G WITH DOT ABOVE
    0x00001E40, // LATIN CAPITAL LETTER M WITH DOT ABOVE
    0x00001E41, // LATIN SMALL LETTER M WITH DOT ABOVE
    0x000000B6, // PILCROW SIGN
    0x00001E56, // LATIN CAPITAL LETTER P WITH DOT ABOVE
    0x00001E81, // LATIN SMALL LETTER W WITH GRAVE
    0x00001E57, // LATIN SMALL LETTER P WITH DOT ABOVE
    0x00001E83, // LATIN SMALL LETTER W WITH ACUTE
    0x00001E60, // LATIN CAPITAL LETTER S WITH DOT ABOVE
    0x00001EF3, // LATIN SMALL LETTER Y WITH GRAVE
    0x00001E84, // LATIN CAPITAL LETTER W WITH DIAERESIS
    0x00001E85, // LATIN SMALL LETTER W WITH DIAERESIS
    0x00001E61, // LATIN SMALL LETTER S WITH DOT ABOVE
    0x000000C0, // LATIN CAPITAL LETTER A WITH GRAVE
    0x000000C1, // LATIN CAPITAL LETTER A WITH ACUTE
    0x000000C2, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
    0x000000C3, // LATIN CAPITAL LETTER A WITH TILDE
    0x000000C4, // LATIN CAPITAL LETTER A WITH DIAERESIS
    0x000000C5, // LATIN CAPITAL LETTER A WITH RING ABOVE
    0x000000C6, // LATIN CAPITAL LETTER AE
    0x000000C7, // LATIN CAPITAL LETTER C WITH CEDILLA
    0x000000C8, // LATIN CAPITAL LETTER E WITH GRAVE
    0x000000C9, // LATIN CAPITAL LETTER E WITH ACUTE
    0x000000CA, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX
    0x000000CB, // LATIN CAPITAL LETTER E WITH DIAERESIS
    0x000000CC, // LATIN CAPITAL LETTER I WITH GRAVE
    0x000000CD, // LATIN CAPITAL LETTER I WITH ACUTE
    0x000000CE, // LATIN CAPITAL LETTER I WITH CIRCUMFLEX
    0x000000CF, // LATIN CAPITAL LETTER I WITH DIAERESIS
    0x00000174, // LATIN CAPITAL LETTER W WITH CIRCUMFLEX
    0x000000D1, // LATIN CAPITAL LETTER N WITH TILDE
    0x000000D2, // LATIN CAPITAL LETTER O WITH GRAVE
    0x000000D3, // LATIN CAPITAL LETTER O WITH ACUTE
    0x000000D4, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
    0x000000D5, // LATIN CAPITAL LETTER O WITH TILDE
    0x000000D6, // LATIN CAPITAL LETTER O WITH DIAERESIS
    0x00001E6A, // LATIN CAPITAL LETTER T WITH DOT ABOVE
    0x000000D8, // LATIN CAPITAL LETTER O WITH STROKE
    0x000000D9, // LATIN CAPITAL LETTER U WITH GRAVE
    0x000000DA, // LATIN CAPITAL LETTER U WITH ACUTE
    0x000000DB, // LATIN CAPITAL LETTER U WITH CIRCUMFLEX
    0x000000DC, // LATIN CAPITAL LETTER U WITH DIAERESIS
    0x000000DD, // LATIN CAPITAL LETTER Y WITH ACUTE
    0x00000176, // LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
    0x000000DF, // LATIN SMALL LETTER SHARP S
    0x000000E0, // LATIN SMALL LETTER A WITH GRAVE
    0x000000E1, // LATIN SMALL LETTER A WITH ACUTE
    0x000000E2, // LATIN SMALL LETTER A WITH CIRCUMFLEX
    0x000000E3, // LATIN SMALL LETTER A WITH TILDE
    0x000000E4, // LATIN SMALL LETTER A WITH DIAERESIS
    0x000000E5, // LATIN SMALL LETTER A WITH RING ABOVE
    0x000000E6, // LATIN SMALL LETTER AE
    0x000000E7, // LATIN SMALL LETTER C WITH CEDILLA
    0x000000E8, // LATIN SMALL LETTER E WITH GRAVE
    0x000000E9, // LATIN SMALL LETTER E WITH ACUTE
    0x000000EA, // LATIN SMALL LETTER E WITH CIRCUMFLEX
    0x000000EB, // LATIN SMALL LETTER E WITH DIAERESIS
    0x000000EC, // LATIN SMALL LETTER I WITH GRAVE
    0x000000ED, // LATIN SMALL LETTER I WITH ACUTE
    0x000000EE, // LATIN SMALL LETTER I WITH CIRCUMFLEX
    0x000000EF, // LATIN SMALL LETTER I WITH DIAERESIS
    0x00000175, // LATIN SMALL LETTER W WITH CIRCUMFLEX
    0x000000F1, // LATIN SMALL LETTER N WITH TILDE
    0x000000F2, // LATIN SMALL LETTER O WITH GRAVE
    0x000000F3, // LATIN SMALL LETTER O WITH ACUTE
    0x000000F4, // LATIN SMALL LETTER O WITH CIRCUMFLEX
    0x000000F5, // LATIN SMALL LETTER O WITH TILDE
    0x000000F6, // LATIN SMALL LETTER O WITH DIAERESIS
    0x00001E6B, // LATIN SMALL LETTER T WITH DOT ABOVE
    0x000000F8, // LATIN SMALL LETTER O WITH STROKE
    0x000000F9, // LATIN SMALL LETTER U WITH GRAVE
    0x000000FA, // LATIN SMALL LETTER U WITH ACUTE
    0x000000FB, // LATIN SMALL LETTER U WITH CIRCUMFLEX
    0x000000FC, // LATIN SMALL LETTER U WITH DIAERESIS
    0x000000FD, // LATIN SMALL LETTER Y WITH ACUTE
    0x00000177, // LATIN SMALL LETTER Y WITH CIRCUMFLEX
    0x000000FF  // LATIN SMALL LETTER Y WITH DIAERESIS
  };

  // ISO-8859-15 transcoding table
  static const t_quad ISO_8859_15_MAP[256] = {
    0x00000000, // NULL
    0x00000001, // START OF HEADING
    0x00000002, // START OF TEXT
    0x00000003, // END OF TEXT
    0x00000004, // END OF TRANSMISSION
    0x00000005, // ENQUIRY
    0x00000006, // ACKNOWLEDGE
    0x00000007, // BELL
    0x00000008, // BACKSPACE
    0x00000009, // HORIZONTAL TABULATION
    0x0000000A, // LINE FEED
    0x0000000B, // VERTICAL TABULATION
    0x0000000C, // FORM FEED
    0x0000000D, // CARRIAGE RETURN
    0x0000000E, // SHIFT OUT
    0x0000000F, // SHIFT IN
    0x00000010, // DATA LINK ESCAPE
    0x00000011, // DEVICE CONTROL ONE
    0x00000012, // DEVICE CONTROL TWO
    0x00000013, // DEVICE CONTROL THREE
    0x00000014, // DEVICE CONTROL FOUR
    0x00000015, // NEGATIVE ACKNOWLEDGE
    0x00000016, // SYNCHRONOUS IDLE
    0x00000017, // END OF TRANSMISSION BLOCK
    0x00000018, // CANCEL
    0x00000019, // END OF MEDIUM
    0x0000001A, // SUBSTITUTE
    0x0000001B, // ESCAPE
    0x0000001C, // FILE SEPARATOR
    0x0000001D, // GROUP SEPARATOR
    0x0000001E, // RECORD SEPARATOR
    0x0000001F, // UNIT SEPARATOR
    0x00000020, // SPACE
    0x00000021, // EXCLAMATION MARK
    0x00000022, // QUOTATION MARK
    0x00000023, // NUMBER SIGN
    0x00000024, // DOLLAR SIGN
    0x00000025, // PERCENT SIGN
    0x00000026, // AMPERSAND
    0x00000027, // APOSTROPHE
    0x00000028, // LEFT PARENTHESIS
    0x00000029, // RIGHT PARENTHESIS
    0x0000002A, // ASTERISK
    0x0000002B, // PLUS SIGN
    0x0000002C, // COMMA
    0x0000002D, // HYPHEN-MINUS
    0x0000002E, // FULL STOP
    0x0000002F, // SOLIDUS
    0x00000030, // DIGIT ZERO
    0x00000031, // DIGIT ONE
    0x00000032, // DIGIT TWO
    0x00000033, // DIGIT THREE
    0x00000034, // DIGIT FOUR
    0x00000035, // DIGIT FIVE
    0x00000036, // DIGIT SIX
    0x00000037, // DIGIT SEVEN
    0x00000038, // DIGIT EIGHT
    0x00000039, // DIGIT NINE
    0x0000003A, // COLON
    0x0000003B, // SEMICOLON
    0x0000003C, // LESS-THAN SIGN
    0x0000003D, // EQUALS SIGN
    0x0000003E, // GREATER-THAN SIGN
    0x0000003F, // QUESTION MARK
    0x00000040, // COMMERCIAL AT
    0x00000041, // LATIN CAPITAL LETTER A
    0x00000042, // LATIN CAPITAL LETTER B
    0x00000043, // LATIN CAPITAL LETTER C
    0x00000044, // LATIN CAPITAL LETTER D
    0x00000045, // LATIN CAPITAL LETTER E
    0x00000046, // LATIN CAPITAL LETTER F
    0x00000047, // LATIN CAPITAL LETTER G
    0x00000048, // LATIN CAPITAL LETTER H
    0x00000049, // LATIN CAPITAL LETTER I
    0x0000004A, // LATIN CAPITAL LETTER J
    0x0000004B, // LATIN CAPITAL LETTER K
    0x0000004C, // LATIN CAPITAL LETTER L
    0x0000004D, // LATIN CAPITAL LETTER M
    0x0000004E, // LATIN CAPITAL LETTER N
    0x0000004F, // LATIN CAPITAL LETTER O
    0x00000050, // LATIN CAPITAL LETTER P
    0x00000051, // LATIN CAPITAL LETTER Q
    0x00000052, // LATIN CAPITAL LETTER R
    0x00000053, // LATIN CAPITAL LETTER S
    0x00000054, // LATIN CAPITAL LETTER T
    0x00000055, // LATIN CAPITAL LETTER U
    0x00000056, // LATIN CAPITAL LETTER V
    0x00000057, // LATIN CAPITAL LETTER W
    0x00000058, // LATIN CAPITAL LETTER X
    0x00000059, // LATIN CAPITAL LETTER Y
    0x0000005A, // LATIN CAPITAL LETTER Z
    0x0000005B, // LEFT SQUARE BRACKET
    0x0000005C, // REVERSE SOLIDUS
    0x0000005D, // RIGHT SQUARE BRACKET
    0x0000005E, // CIRCUMFLEX ACCENT
    0x0000005F, // LOW LINE
    0x00000060, // GRAVE ACCENT
    0x00000061, // LATIN SMALL LETTER A
    0x00000062, // LATIN SMALL LETTER B
    0x00000063, // LATIN SMALL LETTER C
    0x00000064, // LATIN SMALL LETTER D
    0x00000065, // LATIN SMALL LETTER E
    0x00000066, // LATIN SMALL LETTER F
    0x00000067, // LATIN SMALL LETTER G
    0x00000068, // LATIN SMALL LETTER H
    0x00000069, // LATIN SMALL LETTER I
    0x0000006A, // LATIN SMALL LETTER J
    0x0000006B, // LATIN SMALL LETTER K
    0x0000006C, // LATIN SMALL LETTER L
    0x0000006D, // LATIN SMALL LETTER M
    0x0000006E, // LATIN SMALL LETTER N
    0x0000006F, // LATIN SMALL LETTER O
    0x00000070, // LATIN SMALL LETTER P
    0x00000071, // LATIN SMALL LETTER Q
    0x00000072, // LATIN SMALL LETTER R
    0x00000073, // LATIN SMALL LETTER S
    0x00000074, // LATIN SMALL LETTER T
    0x00000075, // LATIN SMALL LETTER U
    0x00000076, // LATIN SMALL LETTER V
    0x00000077, // LATIN SMALL LETTER W
    0x00000078, // LATIN SMALL LETTER X
    0x00000079, // LATIN SMALL LETTER Y
    0x0000007A, // LATIN SMALL LETTER Z
    0x0000007B, // LEFT CURLY BRACKET
    0x0000007C, // VERTICAL LINE
    0x0000007D, // RIGHT CURLY BRACKET
    0x0000007E, // TILDE
    0x0000007F, // DELETE
    0x00000080, // <control>
    0x00000081, // <control>
    0x00000082, // <control>
    0x00000083, // <control>
    0x00000084, // <control>
    0x00000085, // <control>
    0x00000086, // <control>
    0x00000087, // <control>
    0x00000088, // <control>
    0x00000089, // <control>
    0x0000008A, // <control>
    0x0000008B, // <control>
    0x0000008C, // <control>
    0x0000008D, // <control>
    0x0000008E, // <control>
    0x0000008F, // <control>
    0x00000090, // <control>
    0x00000091, // <control>
    0x00000092, // <control>
    0x00000093, // <control>
    0x00000094, // <control>
    0x00000095, // <control>
    0x00000096, // <control>
    0x00000097, // <control>
    0x00000098, // <control>
    0x00000099, // <control>
    0x0000009A, // <control>
    0x0000009B, // <control>
    0x0000009C, // <control>
    0x0000009D, // <control>
    0x0000009E, // <control>
    0x0000009F, // <control>
    0x000000A0, // NO-BREAK SPACE
    0x000000A1, // INVERTED EXCLAMATION MARK
    0x000000A2, // CENT SIGN
    0x000000A3, // POUND SIGN
    0x000020AC, // EURO SIGN
    0x000000A5, // YEN SIGN
    0x00000160, // LATIN CAPITAL LETTER S WITH CARON
    0x000000A7, // SECTION SIGN
    0x00000161, // LATIN SMALL LETTER S WITH CARON
    0x000000A9, // COPYRIGHT SIGN
    0x000000AA, // FEMININE ORDINAL INDICATOR
    0x000000AB, // LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x000000AC, // NOT SIGN
    0x000000AD, // SOFT HYPHEN
    0x000000AE, // REGISTERED SIGN
    0x000000AF, // MACRON
    0x000000B0, // DEGREE SIGN
    0x000000B1, // PLUS-MINUS SIGN
    0x000000B2, // SUPERSCRIPT TWO
    0x000000B3, // SUPERSCRIPT THREE
    0x0000017D, // LATIN CAPITAL LETTER Z WITH CARON
    0x000000B5, // MICRO SIGN
    0x000000B6, // PILCROW SIGN
    0x000000B7, // MIDDLE DOT
    0x0000017E, // LATIN SMALL LETTER Z WITH CARON
    0x000000B9, // SUPERSCRIPT ONE
    0x000000BA, // MASCULINE ORDINAL INDICATOR
    0x000000BB, // RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x00000152, // LATIN CAPITAL LIGATURE OE
    0x00000153, // LATIN SMALL LIGATURE OE
    0x00000178, // LATIN CAPITAL LETTER Y WITH DIAERESIS
    0x000000BF, // INVERTED QUESTION MARK
    0x000000C0, // LATIN CAPITAL LETTER A WITH GRAVE
    0x000000C1, // LATIN CAPITAL LETTER A WITH ACUTE
    0x000000C2, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
    0x000000C3, // LATIN CAPITAL LETTER A WITH TILDE
    0x000000C4, // LATIN CAPITAL LETTER A WITH DIAERESIS
    0x000000C5, // LATIN CAPITAL LETTER A WITH RING ABOVE
    0x000000C6, // LATIN CAPITAL LETTER AE
    0x000000C7, // LATIN CAPITAL LETTER C WITH CEDILLA
    0x000000C8, // LATIN CAPITAL LETTER E WITH GRAVE
    0x000000C9, // LATIN CAPITAL LETTER E WITH ACUTE
    0x000000CA, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX
    0x000000CB, // LATIN CAPITAL LETTER E WITH DIAERESIS
    0x000000CC, // LATIN CAPITAL LETTER I WITH GRAVE
    0x000000CD, // LATIN CAPITAL LETTER I WITH ACUTE
    0x000000CE, // LATIN CAPITAL LETTER I WITH CIRCUMFLEX
    0x000000CF, // LATIN CAPITAL LETTER I WITH DIAERESIS
    0x000000D0, // LATIN CAPITAL LETTER ETH
    0x000000D1, // LATIN CAPITAL LETTER N WITH TILDE
    0x000000D2, // LATIN CAPITAL LETTER O WITH GRAVE
    0x000000D3, // LATIN CAPITAL LETTER O WITH ACUTE
    0x000000D4, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
    0x000000D5, // LATIN CAPITAL LETTER O WITH TILDE
    0x000000D6, // LATIN CAPITAL LETTER O WITH DIAERESIS
    0x000000D7, // MULTIPLICATION SIGN
    0x000000D8, // LATIN CAPITAL LETTER O WITH STROKE
    0x000000D9, // LATIN CAPITAL LETTER U WITH GRAVE
    0x000000DA, // LATIN CAPITAL LETTER U WITH ACUTE
    0x000000DB, // LATIN CAPITAL LETTER U WITH CIRCUMFLEX
    0x000000DC, // LATIN CAPITAL LETTER U WITH DIAERESIS
    0x000000DD, // LATIN CAPITAL LETTER Y WITH ACUTE
    0x000000DE, // LATIN CAPITAL LETTER THORN
    0x000000DF, // LATIN SMALL LETTER SHARP S
    0x000000E0, // LATIN SMALL LETTER A WITH GRAVE
    0x000000E1, // LATIN SMALL LETTER A WITH ACUTE
    0x000000E2, // LATIN SMALL LETTER A WITH CIRCUMFLEX
    0x000000E3, // LATIN SMALL LETTER A WITH TILDE
    0x000000E4, // LATIN SMALL LETTER A WITH DIAERESIS
    0x000000E5, // LATIN SMALL LETTER A WITH RING ABOVE
    0x000000E6, // LATIN SMALL LETTER AE
    0x000000E7, // LATIN SMALL LETTER C WITH CEDILLA
    0x000000E8, // LATIN SMALL LETTER E WITH GRAVE
    0x000000E9, // LATIN SMALL LETTER E WITH ACUTE
    0x000000EA, // LATIN SMALL LETTER E WITH CIRCUMFLEX
    0x000000EB, // LATIN SMALL LETTER E WITH DIAERESIS
    0x000000EC, // LATIN SMALL LETTER I WITH GRAVE
    0x000000ED, // LATIN SMALL LETTER I WITH ACUTE
    0x000000EE, // LATIN SMALL LETTER I WITH CIRCUMFLEX
    0x000000EF, // LATIN SMALL LETTER I WITH DIAERESIS
    0x000000F0, // LATIN SMALL LETTER ETH
    0x000000F1, // LATIN SMALL LETTER N WITH TILDE
    0x000000F2, // LATIN SMALL LETTER O WITH GRAVE
    0x000000F3, // LATIN SMALL LETTER O WITH ACUTE
    0x000000F4, // LATIN SMALL LETTER O WITH CIRCUMFLEX
    0x000000F5, // LATIN SMALL LETTER O WITH TILDE
    0x000000F6, // LATIN SMALL LETTER O WITH DIAERESIS
    0x000000F7, // DIVISION SIGN
    0x000000F8, // LATIN SMALL LETTER O WITH STROKE
    0x000000F9, // LATIN SMALL LETTER U WITH GRAVE
    0x000000FA, // LATIN SMALL LETTER U WITH ACUTE
    0x000000FB, // LATIN SMALL LETTER U WITH CIRCUMFLEX
    0x000000FC, // LATIN SMALL LETTER U WITH DIAERESIS
    0x000000FD, // LATIN SMALL LETTER Y WITH ACUTE
    0x000000FE, // LATIN SMALL LETTER THORN
    0x000000FF  // LATIN SMALL LETTER Y WITH DIAERESIS
  };

  // ISO-8859-16 transcoding table
  static const t_quad ISO_8859_16_MAP[256] = {
    0x00000000, // NULL
    0x00000001, // START OF HEADING
    0x00000002, // START OF TEXT
    0x00000003, // END OF TEXT
    0x00000004, // END OF TRANSMISSION
    0x00000005, // ENQUIRY
    0x00000006, // ACKNOWLEDGE
    0x00000007, // BELL
    0x00000008, // BACKSPACE
    0x00000009, // HORIZONTAL TABULATION
    0x0000000A, // LINE FEED
    0x0000000B, // VERTICAL TABULATION
    0x0000000C, // FORM FEED
    0x0000000D, // CARRIAGE RETURN
    0x0000000E, // SHIFT OUT
    0x0000000F, // SHIFT IN
    0x00000010, // DATA LINK ESCAPE
    0x00000011, // DEVICE CONTROL ONE
    0x00000012, // DEVICE CONTROL TWO
    0x00000013, // DEVICE CONTROL THREE
    0x00000014, // DEVICE CONTROL FOUR
    0x00000015, // NEGATIVE ACKNOWLEDGE
    0x00000016, // SYNCHRONOUS IDLE
    0x00000017, // END OF TRANSMISSION BLOCK
    0x00000018, // CANCEL
    0x00000019, // END OF MEDIUM
    0x0000001A, // SUBSTITUTE
    0x0000001B, // ESCAPE
    0x0000001C, // FILE SEPARATOR
    0x0000001D, // GROUP SEPARATOR
    0x0000001E, // RECORD SEPARATOR
    0x0000001F, // UNIT SEPARATOR
    0x00000020, // SPACE
    0x00000021, // EXCLAMATION MARK
    0x00000022, // QUOTATION MARK
    0x00000023, // NUMBER SIGN
    0x00000024, // DOLLAR SIGN
    0x00000025, // PERCENT SIGN
    0x00000026, // AMPERSAND
    0x00000027, // APOSTROPHE
    0x00000028, // LEFT PARENTHESIS
    0x00000029, // RIGHT PARENTHESIS
    0x0000002A, // ASTERISK
    0x0000002B, // PLUS SIGN
    0x0000002C, // COMMA
    0x0000002D, // HYPHEN-MINUS
    0x0000002E, // FULL STOP
    0x0000002F, // SOLIDUS
    0x00000030, // DIGIT ZERO
    0x00000031, // DIGIT ONE
    0x00000032, // DIGIT TWO
    0x00000033, // DIGIT THREE
    0x00000034, // DIGIT FOUR
    0x00000035, // DIGIT FIVE
    0x00000036, // DIGIT SIX
    0x00000037, // DIGIT SEVEN
    0x00000038, // DIGIT EIGHT
    0x00000039, // DIGIT NINE
    0x0000003A, // COLON
    0x0000003B, // SEMICOLON
    0x0000003C, // LESS-THAN SIGN
    0x0000003D, // EQUALS SIGN
    0x0000003E, // GREATER-THAN SIGN
    0x0000003F, // QUESTION MARK
    0x00000040, // COMMERCIAL AT
    0x00000041, // LATIN CAPITAL LETTER A
    0x00000042, // LATIN CAPITAL LETTER B
    0x00000043, // LATIN CAPITAL LETTER C
    0x00000044, // LATIN CAPITAL LETTER D
    0x00000045, // LATIN CAPITAL LETTER E
    0x00000046, // LATIN CAPITAL LETTER F
    0x00000047, // LATIN CAPITAL LETTER G
    0x00000048, // LATIN CAPITAL LETTER H
    0x00000049, // LATIN CAPITAL LETTER I
    0x0000004A, // LATIN CAPITAL LETTER J
    0x0000004B, // LATIN CAPITAL LETTER K
    0x0000004C, // LATIN CAPITAL LETTER L
    0x0000004D, // LATIN CAPITAL LETTER M
    0x0000004E, // LATIN CAPITAL LETTER N
    0x0000004F, // LATIN CAPITAL LETTER O
    0x00000050, // LATIN CAPITAL LETTER P
    0x00000051, // LATIN CAPITAL LETTER Q
    0x00000052, // LATIN CAPITAL LETTER R
    0x00000053, // LATIN CAPITAL LETTER S
    0x00000054, // LATIN CAPITAL LETTER T
    0x00000055, // LATIN CAPITAL LETTER U
    0x00000056, // LATIN CAPITAL LETTER V
    0x00000057, // LATIN CAPITAL LETTER W
    0x00000058, // LATIN CAPITAL LETTER X
    0x00000059, // LATIN CAPITAL LETTER Y
    0x0000005A, // LATIN CAPITAL LETTER Z
    0x0000005B, // LEFT SQUARE BRACKET
    0x0000005C, // REVERSE SOLIDUS
    0x0000005D, // RIGHT SQUARE BRACKET
    0x0000005E, // CIRCUMFLEX ACCENT
    0x0000005F, // LOW LINE
    0x00000060, // GRAVE ACCENT
    0x00000061, // LATIN SMALL LETTER A
    0x00000062, // LATIN SMALL LETTER B
    0x00000063, // LATIN SMALL LETTER C
    0x00000064, // LATIN SMALL LETTER D
    0x00000065, // LATIN SMALL LETTER E
    0x00000066, // LATIN SMALL LETTER F
    0x00000067, // LATIN SMALL LETTER G
    0x00000068, // LATIN SMALL LETTER H
    0x00000069, // LATIN SMALL LETTER I
    0x0000006A, // LATIN SMALL LETTER J
    0x0000006B, // LATIN SMALL LETTER K
    0x0000006C, // LATIN SMALL LETTER L
    0x0000006D, // LATIN SMALL LETTER M
    0x0000006E, // LATIN SMALL LETTER N
    0x0000006F, // LATIN SMALL LETTER O
    0x00000070, // LATIN SMALL LETTER P
    0x00000071, // LATIN SMALL LETTER Q
    0x00000072, // LATIN SMALL LETTER R
    0x00000073, // LATIN SMALL LETTER S
    0x00000074, // LATIN SMALL LETTER T
    0x00000075, // LATIN SMALL LETTER U
    0x00000076, // LATIN SMALL LETTER V
    0x00000077, // LATIN SMALL LETTER W
    0x00000078, // LATIN SMALL LETTER X
    0x00000079, // LATIN SMALL LETTER Y
    0x0000007A, // LATIN SMALL LETTER Z
    0x0000007B, // LEFT CURLY BRACKET
    0x0000007C, // VERTICAL LINE
    0x0000007D, // RIGHT CURLY BRACKET
    0x0000007E, // TILDE
    0x0000007F, // DELETE
    0x00000080, // <control>
    0x00000081, // <control>
    0x00000082, // <control>
    0x00000083, // <control>
    0x00000084, // <control>
    0x00000085, // <control>
    0x00000086, // <control>
    0x00000087, // <control>
    0x00000088, // <control>
    0x00000089, // <control>
    0x0000008A, // <control>
    0x0000008B, // <control>
    0x0000008C, // <control>
    0x0000008D, // <control>
    0x0000008E, // <control>
    0x0000008F, // <control>
    0x00000090, // <control>
    0x00000091, // <control>
    0x00000092, // <control>
    0x00000093, // <control>
    0x00000094, // <control>
    0x00000095, // <control>
    0x00000096, // <control>
    0x00000097, // <control>
    0x00000098, // <control>
    0x00000099, // <control>
    0x0000009A, // <control>
    0x0000009B, // <control>
    0x0000009C, // <control>
    0x0000009D, // <control>
    0x0000009E, // <control>
    0x0000009F, // <control>
    0x000000A0, // NO-BREAK SPACE
    0x00000104, // LATIN CAPITAL LETTER A WITH OGONEK
    0x00000105, // LATIN SMALL LETTER A WITH OGONEK
    0x00000141, // LATIN CAPITAL LETTER L WITH STROKE
    0x000020AC, // EURO SIGN
    0x0000201E, // DOUBLE LOW-9 QUOTATION MARK
    0x00000160, // LATIN CAPITAL LETTER S WITH CARON
    0x000000A7, // SECTION SIGN
    0x00000161, // LATIN SMALL LETTER S WITH CARON
    0x000000A9, // COPYRIGHT SIGN
    0x00000218, // LATIN CAPITAL LETTER S WITH COMMA BELOW
    0x000000AB, // LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x00000179, // LATIN CAPITAL LETTER Z WITH ACUTE
    0x000000AD, // SOFT HYPHEN
    0x0000017A, // LATIN SMALL LETTER Z WITH ACUTE
    0x0000017B, // LATIN CAPITAL LETTER Z WITH DOT ABOVE
    0x000000B0, // DEGREE SIGN
    0x000000B1, // PLUS-MINUS SIGN
    0x0000010C, // LATIN CAPITAL LETTER C WITH CARON
    0x00000142, // LATIN SMALL LETTER L WITH STROKE
    0x0000017D, // LATIN CAPITAL LETTER Z WITH CARON
    0x0000201D, // RIGHT DOUBLE QUOTATION MARK
    0x000000B6, // PILCROW SIGN
    0x000000B7, // MIDDLE DOT
    0x0000017E, // LATIN SMALL LETTER Z WITH CARON
    0x0000010D, // LATIN SMALL LETTER C WITH CARON
    0x00000219, // LATIN SMALL LETTER S WITH COMMA BELOW
    0x000000BB, // RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
    0x00000152, // LATIN CAPITAL LIGATURE OE
    0x00000153, // LATIN SMALL LIGATURE OE
    0x00000178, // LATIN CAPITAL LETTER Y WITH DIAERESIS
    0x0000017C, // LATIN SMALL LETTER Z WITH DOT ABOVE
    0x000000C0, // LATIN CAPITAL LETTER A WITH GRAVE
    0x000000C1, // LATIN CAPITAL LETTER A WITH ACUTE
    0x000000C2, // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
    0x00000102, // LATIN CAPITAL LETTER A WITH BREVE
    0x000000C4, // LATIN CAPITAL LETTER A WITH DIAERESIS
    0x00000106, // LATIN CAPITAL LETTER C WITH ACUTE
    0x000000C6, // LATIN CAPITAL LETTER AE
    0x000000C7, // LATIN CAPITAL LETTER C WITH CEDILLA
    0x000000C8, // LATIN CAPITAL LETTER E WITH GRAVE
    0x000000C9, // LATIN CAPITAL LETTER E WITH ACUTE
    0x000000CA, // LATIN CAPITAL LETTER E WITH CIRCUMFLEX
    0x000000CB, // LATIN CAPITAL LETTER E WITH DIAERESIS
    0x000000CC, // LATIN CAPITAL LETTER I WITH GRAVE
    0x000000CD, // LATIN CAPITAL LETTER I WITH ACUTE
    0x000000CE, // LATIN CAPITAL LETTER I WITH CIRCUMFLEX
    0x000000CF, // LATIN CAPITAL LETTER I WITH DIAERESIS
    0x00000110, // LATIN CAPITAL LETTER D WITH STROKE
    0x00000143, // LATIN CAPITAL LETTER N WITH ACUTE
    0x000000D2, // LATIN CAPITAL LETTER O WITH GRAVE
    0x000000D3, // LATIN CAPITAL LETTER O WITH ACUTE
    0x000000D4, // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
    0x00000150, // LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
    0x000000D6, // LATIN CAPITAL LETTER O WITH DIAERESIS
    0x0000015A, // LATIN CAPITAL LETTER S WITH ACUTE
    0x00000170, // LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
    0x000000D9, // LATIN CAPITAL LETTER U WITH GRAVE
    0x000000DA, // LATIN CAPITAL LETTER U WITH ACUTE
    0x000000DB, // LATIN CAPITAL LETTER U WITH CIRCUMFLEX
    0x000000DC, // LATIN CAPITAL LETTER U WITH DIAERESIS
    0x00000118, // LATIN CAPITAL LETTER E WITH OGONEK
    0x0000021A, // LATIN CAPITAL LETTER T WITH COMMA BELOW
    0x000000DF, // LATIN SMALL LETTER SHARP S
    0x000000E0, // LATIN SMALL LETTER A WITH GRAVE
    0x000000E1, // LATIN SMALL LETTER A WITH ACUTE
    0x000000E2, // LATIN SMALL LETTER A WITH CIRCUMFLEX
    0x00000103, // LATIN SMALL LETTER A WITH BREVE
    0x000000E4, // LATIN SMALL LETTER A WITH DIAERESIS
    0x00000107, // LATIN SMALL LETTER C WITH ACUTE
    0x000000E6, // LATIN SMALL LETTER AE
    0x000000E7, // LATIN SMALL LETTER C WITH CEDILLA
    0x000000E8, // LATIN SMALL LETTER E WITH GRAVE
    0x000000E9, // LATIN SMALL LETTER E WITH ACUTE
    0x000000EA, // LATIN SMALL LETTER E WITH CIRCUMFLEX
    0x000000EB, // LATIN SMALL LETTER E WITH DIAERESIS
    0x000000EC, // LATIN SMALL LETTER I WITH GRAVE
    0x000000ED, // LATIN SMALL LETTER I WITH ACUTE
    0x000000EE, // LATIN SMALL LETTER I WITH CIRCUMFLEX
    0x000000EF, // LATIN SMALL LETTER I WITH DIAERESIS
    0x00000111, // LATIN SMALL LETTER D WITH STROKE
    0x00000144, // LATIN SMALL LETTER N WITH ACUTE
    0x000000F2, // LATIN SMALL LETTER O WITH GRAVE
    0x000000F3, // LATIN SMALL LETTER O WITH ACUTE
    0x000000F4, // LATIN SMALL LETTER O WITH CIRCUMFLEX
    0x00000151, // LATIN SMALL LETTER O WITH DOUBLE ACUTE
    0x000000F6, // LATIN SMALL LETTER O WITH DIAERESIS
    0x0000015B, // LATIN SMALL LETTER S WITH ACUTE
    0x00000171, // LATIN SMALL LETTER U WITH DOUBLE ACUTE
    0x000000F9, // LATIN SMALL LETTER U WITH GRAVE
    0x000000FA, // LATIN SMALL LETTER U WITH ACUTE
    0x000000FB, // LATIN SMALL LETTER U WITH CIRCUMFLEX
    0x000000FC, // LATIN SMALL LETTER U WITH DIAERESIS
    0x00000119, // LATIN SMALL LETTER E WITH OGONEK
    0x0000021B, // LATIN SMALL LETTER T WITH COMMA BELOW
    0x000000FF  // LATIN SMALL LETTER Y WITH DIAERESIS
  };
}
