         SUBROUTINE  ERD__K12_INT2D_TO_E000
     +
     +                    ( SHELLA,SHELLP,
     +                      NGQP,NEXQ,NGQEXQ,
     +                      NXYZET,NXYZP,
     +                      INT2DX,INT2DY,INT2DZ,
     +                      DIFFY,DIFFZ,
     +                      TEMP1,TEMP2,
     +                      SCALE,RTS,UVAL,STGEXP,
     +
     +                                BATCH )
     +
C------------------------------------------------------------------------
C  OPERATION   : ERD__DERV_INT2D_TO_E000
C  MODULE      : ELECTRON REPULSION INTEGRALS DIRECT
C  MODULE-ID   : ERD
C  SUBROUTINES : none
C  DESCRIPTION : This routine assembles the set of batches of cartesian
C                derivative eris [E0|00] , E = A to P, adding up the
C                contributions from all the derivative 2D P00 integrals.
C
C                Simplified version of the general E0CD routine to
C                reduce loop overheads for those cases where there are
C                two s-shells in the CD-part. For comments and details
C                see the general E0CD routine.
C
C
C                  Input:
C
C                    SHELLx      =  shell types for individual csh
C                                   x=A and csh sum P=A+B
C                    NGQP        =  # of gaussian quadrature points
C                                   (roots)
C                    NEXQ        =  current # of exponent quadruplets
C                    NGQEXQ      =  product of # of gaussian quadrature
C                                   points times exponent quadruplets
C                    NXYZET      =  sum of # of cartesian monomials
C                                   for all shells in the range
C                                   E = A,...,P=A+B
C                    NXYZP       =  # of cartesian monomials for the
C                                   P shell
C                    INT2Dx      =  all current 2D P00 derivative
C                                   integrals for each cartesian
C                                   component (x = X,Y,Z)
C                    DIFFx       =  is true, if differentiation was
C                                   performed along the x=Y,Z direction
C                    TEMP1(2)    =  scratch arrays holding intermediate
C                                   2D P00 derivative integral products
C                    SCALE       =  the NGQEXQ scaling factors
C
C
C                  Output:
C
C                    BATCH       =  batch of primitive cartesian [E0|C0]
C                                   or [E0|0C]derivative integrals
C                                   corresponding to all current
C                                   exponent quadruplets
C
C
C  AUTHOR      : Norbert Flocke
C------------------------------------------------------------------------
C
C                      >>>  COPYRIGHT NOTICE  <<<
C                             Program ERD
C
C    This routine is part of the integral program package ERD and as
C    such is copyrighted by N. Flocke, 2004; all rights reserved.
C    The full copyright notice is printed in the main routine of the
C    ERD package and all terms and conditions given therein are
C    incorporated here.
C
C------------------------------------------------------------------------
C
C
C             ...include files and declare variables.
C
C
         IMPLICIT    NONE

         LOGICAL     DIFFY,DIFFZ

         INTEGER     I,M,N,R
         INTEGER     NGQP,NEXQ,NGQEXQ
         INTEGER     NXYZE,NXYZET,NXYZP
         INTEGER     SE
         INTEGER     SEEND
         INTEGER     SHELLA,SHELLP
         INTEGER     XE,YE,ZE
         INTEGER     XEMAX
         INTEGER     XEP,XYEP
         INTEGER     XYE
         INTEGER     YEEND

         DOUBLE PRECISION  SUM
         DOUBLE PRECISION  ZERO,STGEXP

         DOUBLE PRECISION  SCALE (1:NGQEXQ),RTS(1:NGQEXQ)
         DOUBLE PRECISION  TEMP1 (1:NGQEXQ),UVAL(1:NEXQ)
         DOUBLE PRECISION  TEMP2 (1:NGQEXQ)

         DOUBLE PRECISION  BATCH (1:NEXQ,1:NXYZET)

         DOUBLE PRECISION  INT2DX (1:NGQEXQ,0:SHELLP)
         DOUBLE PRECISION  INT2DY (1:NGQEXQ,0:SHELLP)
         DOUBLE PRECISION  INT2DZ (1:NGQEXQ,0:SHELLP)

         PARAMETER  (ZERO  =  0.D0)
C
C
C------------------------------------------------------------------------
C
C
C             ...jump according to number of roots.
C
C
         GOTO  (1,2,3,4,5,6,7,8,9,10)  MIN (NGQP,10)
C
C
C                       ********************
C                       *  # of roots = 1  *
C                       ********************
C
C
    1    XEP = NXYZET + 3
         DO 100 XE = 0,SHELLP
            XEP = XEP + XE - 2
            XEMAX = XE * SHELLP
            YEEND = SHELLP - XE

            DO M = 1,NEXQ
               TEMP1 (M) = SCALE (M) * INT2DX (M,XE)
            END DO

            XYEP = XEP - XEMAX
            DO 110 YE = 0,YEEND
               XYE = XE + YE
               XYEP = XYEP - 1
               SEEND = MAX0 (SHELLA,XYE)

               IF (.NOT.DIFFY .AND. YE.EQ.0) THEN
                   DO M = 1,NEXQ
                      TEMP2 (M) = TEMP1 (M)
                   END DO
               ELSE
                   DO M = 1,NEXQ
                      TEMP2 (M) = TEMP1 (M) * INT2DY (M,YE)
                   END DO
               END IF

               I = XYEP
               NXYZE = NXYZP
               DO 120 SE = SHELLP,SEEND,-1
                  ZE = SE - XYE

                  IF (.NOT.DIFFZ .AND. ZE.EQ.0) THEN
                      DO M = 1,NEXQ
                         BATCH (M,I) = TEMP2 (M)*
     &                       (2.d0*UVAL(M)/STGEXP)*(1.d0-RTS(M))
                      END DO
                  ELSE
                      DO M = 1,NEXQ
                         BATCH (M,I) = TEMP2 (M) * INT2DZ (M,ZE)*
     &                       (2.d0*UVAL(M)/STGEXP)*(1.d0-RTS(M))
                      END DO
                  END IF

                  I = I - NXYZE + XE
                  NXYZE = NXYZE - SE - 1
  120          CONTINUE
  110       CONTINUE
  100    CONTINUE

         RETURN
C
C
C                       ********************
C                       *  # of roots = 2  *
C                       ********************
C
C
    2    XEP = NXYZET + 3
         DO 200 XE = 0,SHELLP
            XEP = XEP + XE - 2
            XEMAX = XE * SHELLP
            YEEND = SHELLP - XE

            DO M = 1,NGQEXQ
               TEMP1 (M) = SCALE (M) * INT2DX (M,XE)
            END DO

            XYEP = XEP - XEMAX
            DO 210 YE = 0,YEEND
               XYE = XE + YE
               XYEP = XYEP - 1
               SEEND = MAX0 (SHELLA,XYE)

               IF (.NOT.DIFFY .AND. YE.EQ.0) THEN
                   DO N = 1,NGQEXQ
                      TEMP2 (N) = TEMP1 (N)
                   END DO
               ELSE
                   DO N = 1,NGQEXQ
                      TEMP2 (N) = TEMP1 (N) * INT2DY (N,YE)
                   END DO
               END IF

               I = XYEP
               NXYZE = NXYZP
               DO 220 SE = SHELLP,SEEND,-1
                  ZE = SE - XYE

                  IF (.NOT.DIFFZ .AND. ZE.EQ.0) THEN
                      R = 1
                      DO M = 1,NEXQ
                         BATCH (M,I) = (  TEMP2 (R)*(1.d0-RTS(R))
     +                                 + TEMP2 (R+1)*(1.d0-RTS(R+1))
     +                                 )*(2.d0*UVAL(M)/STGEXP)
                         R = R + 2
                      END DO
                  ELSE
                      R = 1
                      DO M = 1,NEXQ
                         BATCH (M,I) = (  TEMP2 (R)
     +                                 * INT2DZ (R,ZE)*(1.d0-RTS(R))
     +                                 + TEMP2 (R+1)
     +                                 * INT2DZ (R+1,ZE)*(1.d0-RTS(R+1))
     +                                 )*(2.d0*UVAL(M)/STGEXP) 
                         R = R + 2
                      END DO
                  END IF

                  I = I - NXYZE + XE
                  NXYZE = NXYZE - SE - 1
  220          CONTINUE
  210       CONTINUE
  200    CONTINUE

         RETURN
C
C
C                       ********************
C                       *  # of roots = 3  *
C                       ********************
C
C
    3    XEP = NXYZET + 3
         DO 300 XE = 0,SHELLP
            XEP = XEP + XE - 2
            XEMAX = XE * SHELLP
            YEEND = SHELLP - XE

            DO M = 1,NGQEXQ
               TEMP1 (M) = SCALE (M) * INT2DX (M,XE)
            END DO

            XYEP = XEP - XEMAX
            DO 310 YE = 0,YEEND
               XYE = XE + YE
               XYEP = XYEP - 1
               SEEND = MAX0 (SHELLA,XYE)

               IF (.NOT.DIFFY .AND. YE.EQ.0) THEN
                   DO N = 1,NGQEXQ
                      TEMP2 (N) = TEMP1 (N)
                   END DO
               ELSE
                   DO N = 1,NGQEXQ
                      TEMP2 (N) = TEMP1 (N) * INT2DY (N,YE)
                   END DO
               END IF

               I = XYEP
               NXYZE = NXYZP
               DO 320 SE = SHELLP,SEEND,-1
                  ZE = SE - XYE

                  IF (.NOT.DIFFZ .AND. ZE.EQ.0) THEN
                      R = 1
                      DO M = 1,NEXQ
                         BATCH (M,I) = (  TEMP2 (R)*(1.d0-RTS(R))
     +                                 + TEMP2 (R+1)*(1.d0-RTS(R+1))
     +                                 + TEMP2 (R+2)*(1.d0-RTS(R+2))
     +                                 )*(2.d0*UVAL(M)/STGEXP)
                         R = R + 3
                      END DO
                  ELSE
                      R = 1
                      DO M = 1,NEXQ
                         BATCH (M,I) = (  TEMP2 (R)
     +                                 * INT2DZ (R,ZE)*(1.d0-RTS(R))
     +                                 + TEMP2 (R+1)
     +                                 * INT2DZ (R+1,ZE)*(1.d0-RTS(R+1))
     +                                 + TEMP2 (R+2)
     +                                 * INT2DZ (R+2,ZE)*(1.d0-RTS(R+2))
     +                                 )*(2.d0*UVAL(M)/STGEXP)
                         R = R + 3
                      END DO
                  END IF

                  I = I - NXYZE + XE
                  NXYZE = NXYZE - SE - 1
  320          CONTINUE
  310       CONTINUE
  300    CONTINUE

         RETURN
C
C
C                       ********************
C                       *  # of roots = 4  *
C                       ********************
C
C
    4    XEP = NXYZET + 3
         DO 400 XE = 0,SHELLP
            XEP = XEP + XE - 2
            XEMAX = XE * SHELLP
            YEEND = SHELLP - XE

            DO M = 1,NGQEXQ
               TEMP1 (M) = SCALE (M) * INT2DX (M,XE)
            END DO

            XYEP = XEP - XEMAX
            DO 410 YE = 0,YEEND
               XYE = XE + YE
               XYEP = XYEP - 1
               SEEND = MAX0 (SHELLA,XYE)

               IF (.NOT.DIFFY .AND. YE.EQ.0) THEN
                   DO N = 1,NGQEXQ
                      TEMP2 (N) = TEMP1 (N)
                   END DO
               ELSE
                   DO N = 1,NGQEXQ
                      TEMP2 (N) = TEMP1 (N) * INT2DY (N,YE)
                   END DO
               END IF

               I = XYEP
               NXYZE = NXYZP
               DO 420 SE = SHELLP,SEEND,-1
                  ZE = SE - XYE

                  IF (.NOT.DIFFZ .AND. ZE.EQ.0) THEN
                      R = 1
                      DO M = 1,NEXQ
                         BATCH (M,I) = ( TEMP2 (R)*(1.d0-RTS(R))
     +                                 + TEMP2 (R+1)*(1.d0-RTS(R+1))
     +                                 + TEMP2 (R+2)*(1.d0-RTS(R+2))
     +                                 + TEMP2 (R+3)*(1.d0-RTS(R+3))
     +                                 )*(2.d0*UVAL(M)/STGEXP)
                         R = R + 4
                      END DO
                  ELSE
                      R = 1
                      DO M = 1,NEXQ
                         BATCH (M,I) = ( TEMP2 (R)
     +                                 * INT2DZ (R,ZE)*(1.d0-RTS(R))
     +                                 + TEMP2 (R+1)
     +                                 * INT2DZ (R+1,ZE)*(1.d0-RTS(R+1))
     +                                 + TEMP2 (R+2)
     +                                 * INT2DZ (R+2,ZE)*(1.d0-RTS(R+2))
     +                                 + TEMP2 (R+3)
     +                                 * INT2DZ (R+3,ZE)*(1.d0-RTS(R+3))
     +                                 )*(2.d0*UVAL(M)/STGEXP)
                         R = R + 4
                      END DO
                  END IF

                  I = I - NXYZE + XE
                  NXYZE = NXYZE - SE - 1
  420          CONTINUE
  410       CONTINUE
  400    CONTINUE

         RETURN
C
C
C                       ********************
C                       *  # of roots = 5  *
C                       ********************
C
C
    5    XEP = NXYZET + 3
         DO 500 XE = 0,SHELLP
            XEP = XEP + XE - 2
            XEMAX = XE * SHELLP
            YEEND = SHELLP - XE

            DO M = 1,NGQEXQ
               TEMP1 (M) = SCALE (M) * INT2DX (M,XE)
            END DO

            XYEP = XEP - XEMAX
            DO 510 YE = 0,YEEND
               XYE = XE + YE
               XYEP = XYEP - 1
               SEEND = MAX0 (SHELLA,XYE)

               IF (.NOT.DIFFY .AND. YE.EQ.0) THEN
                   DO N = 1,NGQEXQ
                      TEMP2 (N) = TEMP1 (N)
                   END DO
               ELSE
                   DO N = 1,NGQEXQ
                      TEMP2 (N) = TEMP1 (N) * INT2DY (N,YE)
                   END DO
               END IF

               I = XYEP
               NXYZE = NXYZP
               DO 520 SE = SHELLP,SEEND,-1
                  ZE = SE - XYE

                  IF (.NOT.DIFFZ .AND. ZE.EQ.0) THEN
                      R = 1
                      DO M = 1,NEXQ
                         BATCH (M,I) = ( TEMP2 (R)*(1.d0-RTS(R))
     +                                 + TEMP2 (R+1)*(1.d0-RTS(R+1))
     +                                 + TEMP2 (R+2)*(1.d0-RTS(R+2))
     +                                 + TEMP2 (R+3)*(1.d0-RTS(R+3))
     +                                 + TEMP2 (R+4)*(1.d0-RTS(R+4))
     +                                 )*(2.d0*UVAL(M)/STGEXP)
                         R = R + 5
                      END DO
                  ELSE
                      R = 1
                      DO M = 1,NEXQ
                         BATCH (M,I) = ( TEMP2 (R)
     +                                 * INT2DZ (R,ZE)*(1.d0-RTS(R))
     +                                 + TEMP2 (R+1)
     +                                 * INT2DZ (R+1,ZE)*(1.d0-RTS(R+1))
     +                                 + TEMP2 (R+2)
     +                                 * INT2DZ (R+2,ZE)*(1.d0-RTS(R+2))
     +                                 + TEMP2 (R+3)
     +                                 * INT2DZ (R+3,ZE)*(1.d0-RTS(R+3))
     +                                 + TEMP2 (R+4)
     +                                 * INT2DZ (R+4,ZE)*(1.d0-RTS(R+4))
     +                                 )*(2.d0*UVAL(M)/STGEXP)
                         R = R + 5
                      END DO
                  END IF

                  I = I - NXYZE + XE
                  NXYZE = NXYZE - SE - 1
  520          CONTINUE
  510       CONTINUE
  500    CONTINUE

         RETURN
C
C
C                       ********************
C                       *  # of roots = 6  *
C                       ********************
C
C
    6    XEP = NXYZET + 3
         DO 600 XE = 0,SHELLP
            XEP = XEP + XE - 2
            XEMAX = XE * SHELLP
            YEEND = SHELLP - XE

            DO M = 1,NGQEXQ
               TEMP1 (M) = SCALE (M) * INT2DX (M,XE)
            END DO

            XYEP = XEP - XEMAX
            DO 610 YE = 0,YEEND
               XYE = XE + YE
               XYEP = XYEP - 1
               SEEND = MAX0 (SHELLA,XYE)

               IF (.NOT.DIFFY .AND. YE.EQ.0) THEN
                   DO N = 1,NGQEXQ
                      TEMP2 (N) = TEMP1 (N)
                   END DO
               ELSE
                   DO N = 1,NGQEXQ
                      TEMP2 (N) = TEMP1 (N) * INT2DY (N,YE)
                   END DO
               END IF

               I = XYEP
               NXYZE = NXYZP
               DO 620 SE = SHELLP,SEEND,-1
                  ZE = SE - XYE

                  IF (.NOT.DIFFZ .AND. ZE.EQ.0) THEN
                      R = 1
                      DO M = 1,NEXQ
                         BATCH (M,I) = ( TEMP2 (R)*(1.d0-RTS(R))
     +                                 + TEMP2 (R+1)*(1.d0-RTS(R+1))
     +                                 + TEMP2 (R+2)*(1.d0-RTS(R+2))
     +                                 + TEMP2 (R+3)*(1.d0-RTS(R+3))
     +                                 + TEMP2 (R+4)*(1.d0-RTS(R+4))
     +                                 + TEMP2 (R+5)*(1.d0-RTS(R+5))
     +                                 )*(2.d0*UVAL(M)/STGEXP)
                         R = R + 6
                      END DO
                  ELSE
                      R = 1
                      DO M = 1,NEXQ
                         BATCH (M,I) = ( TEMP2 (R)
     +                                 * INT2DZ (R,ZE)*(1.d0-RTS(R))
     +                                 + TEMP2 (R+1)
     +                                 * INT2DZ (R+1,ZE)*(1.d0-RTS(R+1))
     +                                 + TEMP2 (R+2)
     +                                 * INT2DZ (R+2,ZE)*(1.d0-RTS(R+2))
     +                                 + TEMP2 (R+3)
     +                                 * INT2DZ (R+3,ZE)*(1.d0-RTS(R+3))
     +                                 + TEMP2 (R+4)
     +                                 * INT2DZ (R+4,ZE)*(1.d0-RTS(R+4))
     +                                 + TEMP2 (R+5)
     +                                 * INT2DZ (R+5,ZE)*(1.d0-RTS(R+5))
     +                                 )*(2.d0*UVAL(M)/STGEXP)
                         R = R + 6
                      END DO
                  END IF

                  I = I - NXYZE + XE
                  NXYZE = NXYZE - SE - 1
  620          CONTINUE
  610       CONTINUE
  600    CONTINUE

         RETURN
C
C
C                       ********************
C                       *  # of roots = 7  *
C                       ********************
C
C
    7    XEP = NXYZET + 3
         DO 700 XE = 0,SHELLP
            XEP = XEP + XE - 2
            XEMAX = XE * SHELLP
            YEEND = SHELLP - XE

            DO M = 1,NGQEXQ
               TEMP1 (M) = SCALE (M) * INT2DX (M,XE)
            END DO

            XYEP = XEP - XEMAX
            DO 710 YE = 0,YEEND
               XYE = XE + YE
               XYEP = XYEP - 1
               SEEND = MAX0 (SHELLA,XYE)

               IF (.NOT.DIFFY .AND. YE.EQ.0) THEN
                   DO N = 1,NGQEXQ
                      TEMP2 (N) = TEMP1 (N)
                   END DO
               ELSE
                   DO N = 1,NGQEXQ
                      TEMP2 (N) = TEMP1 (N) * INT2DY (N,YE)
                   END DO
               END IF

               I = XYEP
               NXYZE = NXYZP
               DO 720 SE = SHELLP,SEEND,-1
                  ZE = SE - XYE

                  IF (.NOT.DIFFZ .AND. ZE.EQ.0) THEN
                      R = 1
                      DO M = 1,NEXQ
                         BATCH (M,I) = ( TEMP2 (R)*(1.d0-RTS(R))
     +                                 + TEMP2 (R+1)*(1.d0-RTS(R+1))
     +                                 + TEMP2 (R+2)*(1.d0-RTS(R+2))
     +                                 + TEMP2 (R+3)*(1.d0-RTS(R+3))
     +                                 + TEMP2 (R+4)*(1.d0-RTS(R+4))
     +                                 + TEMP2 (R+5)*(1.d0-RTS(R+5))
     +                                 + TEMP2 (R+6)*(1.d0-RTS(R+6))
     +                                 )*(2.d0*UVAL(M)/STGEXP)
                         R = R + 7
                      END DO
                  ELSE
                      R = 1
                      DO M = 1,NEXQ
                         BATCH (M,I) = ( TEMP2 (R)
     +                                 * INT2DZ (R,ZE)*(1.d0-RTS(R))
     +                                 + TEMP2 (R+1)
     +                                 * INT2DZ (R+1,ZE)*(1.d0-RTS(R+1))
     +                                 + TEMP2 (R+2)
     +                                 * INT2DZ (R+2,ZE)*(1.d0-RTS(R+2))
     +                                 + TEMP2 (R+3)
     +                                 * INT2DZ (R+3,ZE)*(1.d0-RTS(R+3))
     +                                 + TEMP2 (R+4)
     +                                 * INT2DZ (R+4,ZE)*(1.d0-RTS(R+4))
     +                                 + TEMP2 (R+5)
     +                                 * INT2DZ (R+5,ZE)*(1.d0-RTS(R+5))
     +                                 + TEMP2 (R+6)
     +                                 * INT2DZ (R+6,ZE)*(1.d0-RTS(R+6))
     +                                 )*(2.d0*UVAL(M)/STGEXP)
                         R = R + 7
                      END DO
                  END IF

                  I = I - NXYZE + XE
                  NXYZE = NXYZE - SE - 1
  720          CONTINUE
  710       CONTINUE
  700    CONTINUE

         RETURN
C
C
C                       ********************
C                       *  # of roots = 8  *
C                       ********************
C
C
    8    XEP = NXYZET + 3
         DO 800 XE = 0,SHELLP
            XEP = XEP + XE - 2
            XEMAX = XE * SHELLP
            YEEND = SHELLP - XE

            DO M = 1,NGQEXQ
               TEMP1 (M) = SCALE (M) * INT2DX (M,XE)
            END DO

            XYEP = XEP - XEMAX
            DO 810 YE = 0,YEEND
               XYE = XE + YE
               XYEP = XYEP - 1
               SEEND = MAX0 (SHELLA,XYE)

               IF (.NOT.DIFFY .AND. YE.EQ.0) THEN
                   DO N = 1,NGQEXQ
                      TEMP2 (N) = TEMP1 (N)
                   END DO
               ELSE
                   DO N = 1,NGQEXQ
                      TEMP2 (N) = TEMP1 (N) * INT2DY (N,YE)
                   END DO
               END IF

               I = XYEP
               NXYZE = NXYZP
               DO 820 SE = SHELLP,SEEND,-1
                  ZE = SE - XYE

                  IF (.NOT.DIFFZ .AND. ZE.EQ.0) THEN
                      R = 1
                      DO M = 1,NEXQ
                         BATCH (M,I) = ( TEMP2 (R)*(1.d0-RTS(R))
     +                                 + TEMP2 (R+1)*(1.d0-RTS(R+1))
     +                                 + TEMP2 (R+2)*(1.d0-RTS(R+2))
     +                                 + TEMP2 (R+3)*(1.d0-RTS(R+3))
     +                                 + TEMP2 (R+4)*(1.d0-RTS(R+4))
     +                                 + TEMP2 (R+5)*(1.d0-RTS(R+5))
     +                                 + TEMP2 (R+6)*(1.d0-RTS(R+6))
     +                                 + TEMP2 (R+7)*(1.d0-RTS(R+7))
     +                                 )*(2.d0*UVAL(M)/STGEXP)
                         R = R + 8
                      END DO
                  ELSE
                      R = 1
                      DO M = 1,NEXQ
                         BATCH (M,I) = ( TEMP2 (R)
     +                                 * INT2DZ (R,ZE)*(1.d0-RTS(R))
     +                                 + TEMP2 (R+1)
     +                                 * INT2DZ (R+1,ZE)*(1.d0-RTS(R+1))
     +                                 + TEMP2 (R+2)
     +                                 * INT2DZ (R+2,ZE)*(1.d0-RTS(R+2))
     +                                 + TEMP2 (R+3)
     +                                 * INT2DZ (R+3,ZE)*(1.d0-RTS(R+3))
     +                                 + TEMP2 (R+4)
     +                                 * INT2DZ (R+4,ZE)*(1.d0-RTS(R+4))
     +                                 + TEMP2 (R+5)
     +                                 * INT2DZ (R+5,ZE)*(1.d0-RTS(R+5))
     +                                 + TEMP2 (R+6)
     +                                 * INT2DZ (R+6,ZE)*(1.d0-RTS(R+6))
     +                                 + TEMP2 (R+7)
     +                                 * INT2DZ (R+7,ZE)*(1.d0-RTS(R+7))
     +                                 )*(2.d0*UVAL(M)/STGEXP)
                         R = R + 8
                      END DO
                  END IF

                  I = I - NXYZE + XE
                  NXYZE = NXYZE - SE - 1
  820          CONTINUE
  810       CONTINUE
  800    CONTINUE

         RETURN
C
C
C                       ********************
C                       *  # of roots = 9  *
C                       ********************
C
C
    9    XEP = NXYZET + 3
         DO 900 XE = 0,SHELLP
            XEP = XEP + XE - 2
            XEMAX = XE * SHELLP
            YEEND = SHELLP - XE

            DO M = 1,NGQEXQ
               TEMP1 (M) = SCALE (M) * INT2DX (M,XE)
            END DO

            XYEP = XEP - XEMAX
            DO 910 YE = 0,YEEND
               XYE = XE + YE
               XYEP = XYEP - 1
               SEEND = MAX0 (SHELLA,XYE)

               IF (.NOT.DIFFY .AND. YE.EQ.0) THEN
                   DO N = 1,NGQEXQ
                      TEMP2 (N) = TEMP1 (N)
                   END DO
               ELSE
                   DO N = 1,NGQEXQ
                      TEMP2 (N) = TEMP1 (N) * INT2DY (N,YE)
                   END DO
               END IF

               I = XYEP
               NXYZE = NXYZP
               DO 920 SE = SHELLP,SEEND,-1
                  ZE = SE - XYE

                  IF (.NOT.DIFFZ .AND. ZE.EQ.0) THEN
                      R = 1
                      DO M = 1,NEXQ
                         BATCH (M,I) = ( TEMP2 (R)*(1.d0-RTS(R))
     +                                 + TEMP2 (R+1)*(1.d0-RTS(R+1))
     +                                 + TEMP2 (R+2)*(1.d0-RTS(R+2))
     +                                 + TEMP2 (R+3)*(1.d0-RTS(R+3))
     +                                 + TEMP2 (R+4)*(1.d0-RTS(R+4))
     +                                 + TEMP2 (R+5)*(1.d0-RTS(R+5))
     +                                 + TEMP2 (R+6)*(1.d0-RTS(R+6))
     +                                 + TEMP2 (R+7)*(1.d0-RTS(R+7))
     +                                 + TEMP2 (R+8)*(1.d0-RTS(R+8))
     +                                 )*(2.d0*UVAL(M)/STGEXP)
                         R = R + 9
                      END DO
                  ELSE
                      R = 1
                      DO M = 1,NEXQ
                         BATCH (M,I) = ( TEMP2 (R)
     +                                 * INT2DZ (R,ZE)*(1.d0-RTS(R))
     +                                 + TEMP2 (R+1)
     +                                 * INT2DZ (R+1,ZE)*(1.d0-RTS(R+1))
     +                                 + TEMP2 (R+2)
     +                                 * INT2DZ (R+2,ZE)*(1.d0-RTS(R+2))
     +                                 + TEMP2 (R+3)
     +                                 * INT2DZ (R+3,ZE)*(1.d0-RTS(R+3))
     +                                 + TEMP2 (R+4)
     +                                 * INT2DZ (R+4,ZE)*(1.d0-RTS(R+4))
     +                                 + TEMP2 (R+5)
     +                                 * INT2DZ (R+5,ZE)*(1.d0-RTS(R+5))
     +                                 + TEMP2 (R+6)
     +                                 * INT2DZ (R+6,ZE)*(1.d0-RTS(R+6))
     +                                 + TEMP2 (R+7)
     +                                 * INT2DZ (R+7,ZE)*(1.d0-RTS(R+7))
     +                                 + TEMP2 (R+8)
     +                                 * INT2DZ (R+8,ZE)*(1.d0-RTS(R+8))
     +                                 )*(2.d0*UVAL(M)/STGEXP)
                         R = R + 9
                      END DO
                  END IF

                  I = I - NXYZE + XE
                  NXYZE = NXYZE - SE - 1
  920          CONTINUE
  910       CONTINUE
  900    CONTINUE

         RETURN
C
C
C                       ********************
C                       *  # of roots > 9  *
C                       ********************
C
C             ...outer loops over x-contributions. No skipping of the
C                x-contributions of 0-type can be done here, since
C                the 2DX integrals carry the Rys weight!
C
C
   10    XEP = NXYZET + 3
         DO 1000 XE = 0,SHELLP
            XEP = XEP + XE - 2
            XEMAX = XE * SHELLP
            YEEND = SHELLP - XE

            DO M = 1,NGQEXQ
               TEMP1 (M) = SCALE (M) * INT2DX (M,XE)
            END DO
C
C
C             ...middle loops over y-contributions. Skip multiplication
C                of y-contributions, if no y-coordinate derivative
C                was formed and we have a 0-type, as then the 2DY
C                integrals are equal to 1.
C
C
            XYEP = XEP - XEMAX
            DO 1010 YE = 0,YEEND
               XYE = XE + YE
               XYEP = XYEP - 1
               SEEND = MAX0 (SHELLA,XYE)

               IF (.NOT.DIFFY .AND. YE.EQ.0) THEN
                   DO N = 1,NGQEXQ
                      TEMP2 (N) = TEMP1 (N)
                   END DO
               ELSE
                   DO N = 1,NGQEXQ
                      TEMP2 (N) = TEMP1 (N) * INT2DY (N,YE)
                   END DO
               END IF
C
C
C             ...inner loop over E shells. Skip multiplication of
C                z-contributions, if we have a 0-type and no
C                derivations were performed on the z-coordinate,
C                as then the 2DZ integrals are equal to 1.
C                All info concerning all three x-,y- and z-
C                contributions have been collected for all exponent
C                quadruplets at once. Sum up the 2D X,Y,Z integral
C                products to the appropriate place of the batch.
C
C
               I = XYEP
               NXYZE = NXYZP
               DO 1020 SE = SHELLP,SEEND,-1
                  ZE = SE - XYE

                  IF (.NOT.DIFFZ .AND. ZE.EQ.0) THEN
                      R = 0
                      DO M = 1,NEXQ
                         SUM = ZERO
                         DO N = 1,NGQP
                            SUM = SUM + TEMP2 (R+N)*(1.d0-RTS(R+N))
                         END DO
                         R = R + NGQP
                         BATCH (M,I) = SUM*(2.d0*UVAL(M)/STGEXP)
                      END DO
                  ELSE
                      R = 0
                      DO M = 1,NEXQ
                         SUM = ZERO
                         DO N = 1,NGQP
                            SUM = SUM + TEMP2 (R+N) * 
     &                           INT2DZ (R+N,ZE)*(1.d0-RTS(R+N))
                         END DO
                         R = R + NGQP
                         BATCH (M,I) = SUM*(2.d0*UVAL(M)/STGEXP)
                      END DO
                  END IF
C
C
C             ...next z-contribution.
C
C
                  I = I - NXYZE + XE
                  NXYZE = NXYZE - SE - 1
 1020          CONTINUE
C
C
C             ...next y- and x-contributions.
C
C
 1010       CONTINUE
 1000    CONTINUE
C
C
C             ...ready!
C
C
         RETURN
         END
