#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2019 BetaRays
# SPDX-FileCopyrightText: © 2020 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2021 HS-157
# SPDX-FileCopyrightText: © 2021 Hoël Bézier
set -o errexit

###
# Factorio
###

script_version=20231031.1

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='factorio'
GAME_NAME='Factorio'

GAME_ID_DEMO="${GAME_ID}-demo"
GAME_NAME_DEMO="$GAME_NAME (demo)"

# Archives

## Factorio (full game)

ARCHIVE_BASE_14_NAME='factorio_alpha_x64_1.1.91.tar.xz'
ARCHIVE_BASE_14_MD5='3d906d237f44c5a3d7cd019f5733c53c'
ARCHIVE_BASE_14_SIZE='1894576'
ARCHIVE_BASE_14_VERSION='1.1.91-1'
ARCHIVE_BASE_14_URL='https://www.factorio.com/'

ARCHIVE_BASE_13_NAME='factorio_alpha_x64_1.1.87.tar.xz'
ARCHIVE_BASE_13_MD5='d7972ea941172301e18ebb64694a10b6'
ARCHIVE_BASE_13_SIZE='1750584'
ARCHIVE_BASE_13_VERSION='1.1.87-1'

ARCHIVE_BASE_12_NAME='factorio_alpha_x64_1.1.80.tar.xz'
ARCHIVE_BASE_12_MD5='fc2e68ed66beedb82ad4a25023ac32aa'
ARCHIVE_BASE_12_SIZE='1800000'
ARCHIVE_BASE_12_VERSION='1.1.80-1'

ARCHIVE_BASE_11_NAME='factorio_alpha_x64_1.1.77.tar.xz'
ARCHIVE_BASE_11_MD5='ea6a481b694d73a956e45ea3ebe17a43'
ARCHIVE_BASE_11_SIZE='1800000'
ARCHIVE_BASE_11_VERSION='1.1.77-1'

ARCHIVE_BASE_10_NAME='factorio_alpha_x64_1.1.76.tar.xz'
ARCHIVE_BASE_10_MD5='c2a2302f2c1819a453a023789b3b8558'
ARCHIVE_BASE_10_SIZE='1800000'
ARCHIVE_BASE_10_VERSION='1.1.76-1'

ARCHIVE_BASE_9_NAME='factorio_alpha_x64_1.1.61.tar.xz'
ARCHIVE_BASE_9_MD5='d829704d00f92bef8d72ba3f36910529'
ARCHIVE_BASE_9_SIZE='1800000'
ARCHIVE_BASE_9_VERSION='1.1.61-1'

ARCHIVE_BASE_8_NAME='factorio_alpha_x64_1.1.59.tar.xz'
ARCHIVE_BASE_8_MD5='568328112d5b6e57c9e7a13237c85500'
ARCHIVE_BASE_8_SIZE='1800000'
ARCHIVE_BASE_8_VERSION='1.1.59-1'

ARCHIVE_BASE_7_NAME='factorio_alpha_x64_1.1.57.tar.xz'
ARCHIVE_BASE_7_MD5='c1e5392a9c7d2ead37de90c1ce4732ff'
ARCHIVE_BASE_7_SIZE='1800000'
ARCHIVE_BASE_7_VERSION='1.1.57-1'

ARCHIVE_BASE_6_NAME='factorio_alpha_x64_1.1.53.tar.xz'
ARCHIVE_BASE_6_MD5='3197e3b0de006f3c14027604ba39a244'
ARCHIVE_BASE_6_SIZE='1800000'
ARCHIVE_BASE_6_VERSION='1.1.53-1'

ARCHIVE_BASE_5_NAME='factorio_alpha_x64_1.1.41.tar.xz'
ARCHIVE_BASE_5_MD5='9dbe3f0b17a2f217f62b1d6b756897dc'
ARCHIVE_BASE_5_SIZE='1800000'
ARCHIVE_BASE_5_VERSION='1.1.41-1'

ARCHIVE_BASE_4_NAME='factorio_alpha_x64_1.1.39.tar.xz'
ARCHIVE_BASE_4_MD5='92dae2519513f87cc9b25c26930a21a9'
ARCHIVE_BASE_4_SIZE='1800000'
ARCHIVE_BASE_4_VERSION='1.1.39-1'

ARCHIVE_BASE_3_NAME='factorio_alpha_x64_1.1.30.tar.xz'
ARCHIVE_BASE_3_MD5='b039e25fef976f2ebe77bf5d9bca3c90'
ARCHIVE_BASE_3_SIZE='1800000'
ARCHIVE_BASE_3_VERSION='1.1.30-1'

ARCHIVE_BASE_2_NAME='factorio_alpha_x64_1.1.27.tar.xz'
ARCHIVE_BASE_2_MD5='71c370e0363c40e95f0a9af56b8f4a9b'
ARCHIVE_BASE_2_SIZE='1800000'
ARCHIVE_BASE_2_VERSION='1.1.27-1'

ARCHIVE_BASE_1_NAME='factorio_alpha_x64_1.1.19.tar.xz'
ARCHIVE_BASE_1_MD5='ffe7310259e6176d20fc4add10d8a3d3'
ARCHIVE_BASE_1_SIZE='1800000'
ARCHIVE_BASE_1_VERSION='1.1.19-1'

ARCHIVE_BASE_0_NAME='factorio_alpha_x64_1.0.0.tar.xz'
ARCHIVE_BASE_0_MD5='001910cafbfa8f4ac61b2897f91fe77e'
ARCHIVE_BASE_0_SIZE='1700000'
ARCHIVE_BASE_0_VERSION='1.0.0-1'

## Factorio (demo)

ARCHIVE_BASE_DEMO_12_NAME='factorio_demo_x64_1.1.91.tar.xz'
ARCHIVE_BASE_DEMO_12_MD5='b4c599f44952033e5830f3fee78cb41f'
ARCHIVE_BASE_DEMO_12_SIZE='1687672'
ARCHIVE_BASE_DEMO_12_VERSION='1.1.91-1'
ARCHIVE_BASE_DEMO_12_URL='https://www.factorio.com/download'

ARCHIVE_BASE_DEMO_11_NAME='factorio_demo_x64_1.1.87.tar.xz'
ARCHIVE_BASE_DEMO_11_MD5='7968cbd443ad7d562c6bbbb5a5f99d0d'
ARCHIVE_BASE_DEMO_11_SIZE='1687456'
ARCHIVE_BASE_DEMO_11_VERSION='1.1.87-1'

ARCHIVE_BASE_DEMO_10_NAME='factorio_demo_x64_1.1.76.tar.xz'
ARCHIVE_BASE_DEMO_10_MD5='bf5eb5cf72137a87ea1055cf9b39967a'
ARCHIVE_BASE_DEMO_10_SIZE='1700000'
ARCHIVE_BASE_DEMO_10_VERSION='1.1.76-1'

ARCHIVE_BASE_DEMO_9_NAME='factorio_demo_x64_1.1.59.tar.xz'
ARCHIVE_BASE_DEMO_9_MD5='c40c223284a8a373800bf777d364f5b2'
ARCHIVE_BASE_DEMO_9_SIZE='1700000'
ARCHIVE_BASE_DEMO_9_VERSION='1.1.59-1'

ARCHIVE_BASE_DEMO_8_NAME='factorio_demo_x64_1.1.53.tar.xz'
ARCHIVE_BASE_DEMO_8_MD5='79bafca740b1ea6fb13ab94b79845601'
ARCHIVE_BASE_DEMO_8_SIZE='1700000'
ARCHIVE_BASE_DEMO_8_VERSION='1.1.53-1'

ARCHIVE_BASE_DEMO_7_NAME='factorio_demo_x64_1.1.41.tar.xz'
ARCHIVE_BASE_DEMO_7_MD5='df020fa5c98690d8aedf8cb23b80bce3'
ARCHIVE_BASE_DEMO_7_VERSION='1.1.41-1'
ARCHIVE_BASE_DEMO_7_SIZE='1700000'

ARCHIVE_BASE_DEMO_6_NAME='factorio_demo_x64_1.1.39.tar.xz'
ARCHIVE_BASE_DEMO_6_MD5='cabef150f9b7af9b1480d2590b7799ec'
ARCHIVE_BASE_DEMO_6_VERSION='1.1.39-1'
ARCHIVE_BASE_DEMO_6_SIZE='1700000'

ARCHIVE_BASE_DEMO_5_NAME='factorio_demo_x64_1.1.33.tar.xz'
ARCHIVE_BASE_DEMO_5_MD5='82cc1137048cf98121cd6943e51ae597'
ARCHIVE_BASE_DEMO_5_VERSION='1.1.33-1'
ARCHIVE_BASE_DEMO_5_SIZE='1700000'

ARCHIVE_BASE_DEMO_4_NAME='factorio_demo_x64_1.1.32.tar.xz'
ARCHIVE_BASE_DEMO_4_MD5='275b63133ac56e59ccb73e98f5bebed2'
ARCHIVE_BASE_DEMO_4_VERSION='1.1.32-1'
ARCHIVE_BASE_DEMO_4_SIZE='1700000'

ARCHIVE_BASE_DEMO_3_NAME='factorio_demo_x64_1.1.30.tar.xz'
ARCHIVE_BASE_DEMO_3_MD5='36186abcbe560591bd8e4c207291409f'
ARCHIVE_BASE_DEMO_3_VERSION='1.1.30-1'
ARCHIVE_BASE_DEMO_3_SIZE='1700000'

ARCHIVE_BASE_DEMO_2_NAME='factorio_demo_x64_1.1.27.tar.xz'
ARCHIVE_BASE_DEMO_2_MD5='cdb61b4b98a704e9c6a1090938dfabee'
ARCHIVE_BASE_DEMO_2_VERSION='1.1.27-1'
ARCHIVE_BASE_DEMO_2_SIZE='1700000'

ARCHIVE_BASE_DEMO_1_NAME='factorio_demo_x64_1.0.0.tar.xz'
ARCHIVE_BASE_DEMO_1_MD5='3995194f9c4b4368ecf27ffa9234008e'
ARCHIVE_BASE_DEMO_1_VERSION='1.0.0-1'
ARCHIVE_BASE_DEMO_1_SIZE='1400000'

ARCHIVE_BASE_DEMO_0_NAME='factorio_demo_x64_0.16.51.tar.xz'
ARCHIVE_BASE_DEMO_0_MD5='130267c91df0be6c2034b64fb05d389b'
ARCHIVE_BASE_DEMO_0_VERSION='0.16.51-1'
ARCHIVE_BASE_DEMO_0_SIZE='680000'


CONTENT_PATH_DEFAULT='factorio'
CONTENT_GAME_BIN_FILES='
bin/x64/factorio'
CONTENT_GAME_DATA_FILES='
data
config-path.cfg'
CONTENT_DOC_DATA_FILES='
doc-html'

USER_PERSISTENT_FILES='
*.cfg
*.dat
player-data.json'
USER_PERSISTENT_DIRECTORIES='
config
mods
saves'

APP_MAIN_EXE='bin/x64/factorio'
APP_MAIN_ICON='data/core/graphics/factorio-icon.png'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_DEMO="${GAME_ID_DEMO}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ID_DEMO="$GAME_ID_DEMO"
PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPS_DEMO="$PKG_DATA_ID_DEMO"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libX11.so.6
libXext.so.6
libGL.so.1
libXinerama.so.1
libXrandr.so.2
libXcursor.so.1
libasound.so.2
libpulse.so.0
libpulse-simple.so.0'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
