/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.Iterator;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.IInlineStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.ILayoutManager;
import org.eclipse.birt.report.engine.layout.area.IArea;
import org.eclipse.birt.report.engine.layout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.CellArea;
import org.eclipse.birt.report.engine.layout.area.impl.RowArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFAbstractLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFInlineStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFTableLM;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class PDFRowLM
extends PDFInlineStackingLM
implements IInlineStackingLayoutManager {
    protected PDFTableLM tbl = this.getTableLayoutManager();
    protected boolean hasNext = false;

    public PDFRowLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
        this.calculateSpecifiedHeight();
    }

    @Override
    protected void createRoot() {
        this.root = AreaFactory.createRowArea((IRowContent)this.content);
    }

    @Override
    protected void initialize() {
        if (this.root == null) {
            this.createRoot();
        }
        this.maxAvaWidth = this.parent.getCurrentMaxContentWidth();
        this.root.setWidth(this.getCurrentMaxContentWidth());
        this.root.setAllocatedHeight(this.parent.getCurrentMaxContentHeight());
        this.maxAvaHeight = this.root.getContentHeight();
        this.hasNext = false;
    }

    @Override
    protected boolean traverseChildren() throws BirtException {
        block4: {
            block3: {
                if (this.children.size() != 0) break block3;
                while (this.executor.hasNextChild()) {
                    IReportItemExecutor childExecutor = this.executor.getNextChild();
                    IContent childContent = childExecutor.execute();
                    PDFAbstractLM childLM = this.getFactory().createLayoutManager(this, childContent, childExecutor);
                    this.addChild(childLM);
                    if (!childLM.layout() || this.hasNext) continue;
                    this.hasNext = true;
                }
                break block4;
            }
            if (this.isRowFinished()) break block4;
            int i = 0;
            while (i < this.children.size()) {
                ILayoutManager childLM = (ILayoutManager)this.children.get(i);
                if (childLM.layout() && !this.hasNext) {
                    this.hasNext = true;
                }
                ++i;
            }
        }
        return this.hasNext;
    }

    @Override
    protected void closeLayout() {
        if (this.root != null) {
            this.tbl.updateRow((RowArea)this.root, this.specifiedHeight, !this.hasNext);
        }
    }

    @Override
    protected boolean submitRoot() {
        RowArea row = (RowArea)this.root;
        boolean ret = super.submitRoot();
        if (ret) {
            this.tbl.addRow(row, !this.hasNext, false);
        }
        return ret;
    }

    @Override
    public boolean addArea(IArea area, boolean keepWithPrevious, boolean keepWithNext) {
        this.submit((AbstractArea)area);
        return true;
    }

    protected boolean isRowFinished() {
        int i = 0;
        while (i < this.children.size()) {
            PDFAbstractLM lm = (PDFAbstractLM)this.children.get(i);
            if (lm != null && !lm.isFinished()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected boolean hasNextChild() {
        if (this.children.size() > 0) {
            return !this.isRowFinished();
        }
        return true;
    }

    @Override
    protected boolean isRootEmpty() {
        if (this.root != null) {
            Iterator iter = this.root.getChildren();
            while (iter.hasNext()) {
                CellArea cell = (CellArea)iter.next();
                if (cell.getChildrenCount() <= 0) continue;
                return false;
            }
            if (this.isRowFinished() && this.root.getChildrenCount() > 0) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void submit(AbstractArea area) {
        ReportDesignHandle design;
        CellArea cArea = (CellArea)area;
        this.root.addChild(area);
        int columnID = cArea.getColumnID();
        int colSpan = cArea.getColSpan();
        if (colSpan > 1 && (design = this.context.report.getDesign().getReportDesign()).isDirectionRTL()) {
            columnID += colSpan - 1;
        }
        cArea.setPosition(this.tbl.getXPos(columnID), 0);
    }

    @Override
    protected boolean clearCache() {
        return false;
    }
}

