/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.common.util;

import com.nvidia.common.internal.Activator;
import com.nvidia.common.util.CoreUtil;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.runtime.IStatus;

public final class AsyncValidator {
    private static final int VALIDATION_DELAY_MS = 100;
    private final ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
    private final WritableValue value = new WritableValue();
    private final AtomicReference<DelayedRunnable> scheduled = new AtomicReference<Object>(null);
    private final AtomicBoolean settingValue = new AtomicBoolean(false);

    public synchronized IStatus submit(Callable<IStatus> callable) {
        if (!this.settingValue.get()) {
            this.scheduled.set(new DelayedRunnable(callable));
            this.service.schedule(this.scheduled.get(), 100L, TimeUnit.MILLISECONDS);
        }
        return (IStatus)this.value.getValue();
    }

    private final class DelayedRunnable
    implements Runnable {
        private final Callable<IStatus> callable;

        private DelayedRunnable(Callable<IStatus> callable) {
            this.callable = callable;
        }

        @Override
        public void run() {
            try {
                if (this.isCurrentRunnable()) {
                    this.updateValue(this.callable.call());
                }
            }
            catch (Exception e) {
                Activator.log(e);
                this.updateValue(CoreUtil.errorStatus(e, "Internal validator error", new Object[0]));
            }
        }

        private void updateValue(final IStatus status) {
            if (this.isCurrentRunnable()) {
                AsyncValidator.this.value.getRealm().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (DelayedRunnable.this.isCurrentRunnable()) {
                            try {
                                AsyncValidator.this.settingValue.set(true);
                                AsyncValidator.this.value.setValue((Object)status);
                            }
                            finally {
                                AsyncValidator.this.settingValue.set(false);
                            }
                        }
                    }
                });
            }
        }

        private boolean isCurrentRunnable() {
            return AsyncValidator.this.scheduled.get() == this;
        }
    }
}

