/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui.actions;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.GeneratedMakefileBuilder;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;

public class CleanFilesAction
extends ActionDelegate
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow workbenchWindow = null;
    private IAction action = null;

    public CleanFilesAction() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public CleanFilesAction(IWorkbenchWindow window) {
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
    }

    public void dispose() {
    }

    public void init(IAction action) {
        this.action = action;
        this.update();
    }

    public void init(IWorkbenchWindow window) {
        this.workbenchWindow = window;
    }

    private IFile convertToIFile(Object object) {
        IResource resource;
        IAdaptable adaptable;
        IFile file;
        if (object instanceof IFile) {
            return (IFile)object;
        }
        if (object instanceof IAdaptable && (file = (IFile)(adaptable = (IAdaptable)object).getAdapter(IFile.class)) != null) {
            return file;
        }
        if (object instanceof ITranslationUnit && (resource = ((ITranslationUnit)object).getResource()) instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    private List<IFile> getSelectedBuildableFiles() {
        LinkedList<IFile> files = new LinkedList<IFile>();
        ISelectionService selectionService = this.workbenchWindow.getSelectionService();
        ISelection selection = selectionService.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Iterator elements = structuredSelection.iterator();
            while (elements.hasNext()) {
                IManagedBuildInfo buildInfo;
                IFile file = this.convertToIFile(elements.next());
                if (file == null || !(buildInfo = ManagedBuildManager.getBuildInfo((IResource)file.getProject())).buildsFileType(file.getFileExtension())) continue;
                files.add(file);
            }
        }
        return files;
    }

    public void run(IAction action) {
        List<IFile> selectedFiles = this.getSelectedBuildableFiles();
        CleanFilesJob job = new CleanFilesJob(selectedFiles);
        job.schedule();
    }

    private boolean shouldBeEnabled() {
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        if (preferences.getBoolean("description.autobuilding")) {
            return false;
        }
        ISelectionService selectionService = this.workbenchWindow.getSelectionService();
        ISelection selection = selectionService.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.size() <= 0) {
                return false;
            }
            Iterator elements = structuredSelection.iterator();
            while (elements.hasNext()) {
                IFile file = this.convertToIFile(elements.next());
                if (file != null) {
                    if (!ManagedBuildManager.manages((IResource)file.getProject())) {
                        return false;
                    }
                    IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)file.getProject());
                    if (buildInfo != null && buildInfo.isValid() && buildInfo.buildsFileType(file.getFileExtension())) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private void update() {
        if (this.action != null) {
            this.action.setEnabled(this.shouldBeEnabled());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.update();
    }

    private static final class CleanFilesJob
    extends Job {
        private final List<IFile> files;

        private CleanFilesJob(List<IFile> filesToBuild) {
            super(ManagedMakeMessages.getResourceString((String)"CleanFilesAction.cleaningFiles"));
            this.files = filesToBuild;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Class<?> clazz = ((Object)((Object)this)).getClass();
            synchronized (clazz) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Job[] buildJobs = Job.getJobManager().find(ResourcesPlugin.FAMILY_MANUAL_BUILD);
                int i = 0;
                while (i < buildJobs.length) {
                    Job curr = buildJobs[i];
                    if (curr != this && curr instanceof CleanFilesJob) {
                        curr.cancel();
                    }
                    ++i;
                }
            }
            GeneratedMakefileBuilder builder = new GeneratedMakefileBuilder();
            return builder.cleanFiles(this.files, monitor);
        }

        public boolean belongsTo(Object family) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
        }
    }
}

