/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.build.cubins;

import com.nvidia.cuda.ide.build.core.Activator;
import com.nvidia.cuda.ide.util.BasicUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.IAddressFactory;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ISymbolReader;
import org.eclipse.cdt.utils.BinaryFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class CudaBinary
extends BinaryFile
implements IBinaryParser.IBinaryShared,
ISymbolReader {
    private CUData cuData;
    private long timestamp = Long.MIN_VALUE;

    public static CUData readCUData(IPath path) {
        String string;
        block6: {
            string = CudaBinary.runCuobjdump(path, new String[0]);
            if (string != null) break block6;
            return null;
        }
        try {
            Pattern architectures = Pattern.compile("Fatbin (.*?) code:\n.*?\narch = (.*?)\n.*?\nidentifier = (.*?)\n", 40);
            Matcher matcher = architectures.matcher(string);
            TreeSet<String> sources = new TreeSet<String>();
            TreeSet<String> archs = new TreeSet<String>();
            boolean hasDebug = false;
            while (matcher.find()) {
                File file;
                String kind = "elf".equals(matcher.group(1)) ? "sass" : "ptx";
                archs.add(String.format("%s (%s)", matcher.group(2), kind));
                hasDebug |= matcher.group(0).indexOf("has debug info") > 0;
                String src = matcher.group(3);
                if (src == null || src.length() <= 0) continue;
                Path source = new Path(src);
                if (!source.isAbsolute()) {
                    source = path.removeLastSegments(1).append((IPath)source);
                }
                if (!(file = source.toFile()).exists()) continue;
                sources.add(file.getAbsolutePath());
            }
            if (archs.isEmpty()) {
                CudaBinary.parseNonFatbin(archs, path);
            }
            return new CUData(hasDebug, CudaBinary.toString(archs), sources.toArray(new String[sources.size()]));
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
            return null;
        }
    }

    private static String runCuobjdump(IPath path, String ... args) throws CoreException {
        CommandLauncher launcher = new CommandLauncher();
        launcher.execute((IPath)new Path("cuobjdump"), BasicUtil.join(args, path.toOSString()), null, null, (IProgressMonitor)new NullProgressMonitor());
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        if (launcher.waitAndRead((OutputStream)stdout, (OutputStream)stderr, (IProgressMonitor)new NullProgressMonitor()) == 0) {
            return stdout.toString();
        }
        return null;
    }

    private static void parseNonFatbin(Collection<String> archs, IPath path) throws CoreException {
        String string = CudaBinary.runCuobjdump(path, "--dump-sass");
        Pattern compile = Pattern.compile(".*code for (.*?)\n.*", 40);
        Matcher m = compile.matcher(string);
        if (m.matches()) {
            archs.add(String.valueOf(m.group(1)) + "(sass)");
        }
    }

    private static String toString(Collection<String> archs) {
        if (archs.isEmpty()) {
            return "";
        }
        Iterator<String> i = archs.iterator();
        StringBuilder builder = new StringBuilder(i.next());
        while (i.hasNext()) {
            builder.append(", ").append(i.next());
        }
        return builder.toString();
    }

    public CudaBinary(IBinaryParser parser, IPath path) {
        super(parser, path, 4);
    }

    private synchronized CUData fetchCUData() {
        long fileTimestamp = this.getFileTimestamp();
        if (this.timestamp < fileTimestamp) {
            this.cuData = CudaBinary.readCUData(this.getPath());
            this.timestamp = fileTimestamp;
        }
        if (this.cuData == null) {
            this.cuData = new CUData(false, "<unknown>", new String[0]);
        }
        return this.cuData;
    }

    public Object getAdapter(Class adapter) {
        if (ISymbolReader.class.equals((Object)adapter)) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public IAddressFactory getAddressFactory() {
        return null;
    }

    public long getBSS() {
        return 0L;
    }

    public String getCPU() {
        return this.fetchCUData().getArchitectures();
    }

    public long getData() {
        return 0L;
    }

    private long getFileTimestamp() {
        File file = this.getPath().toFile();
        if (file.isFile()) {
            return file.lastModified();
        }
        return Long.MIN_VALUE;
    }

    public String getName() {
        return this.getPath().lastSegment();
    }

    public String[] getNeededSharedLibs() {
        return new String[0];
    }

    public String getSoName() {
        return this.getName();
    }

    public String[] getSourceFiles() {
        return this.fetchCUData().getSources();
    }

    public String[] getSourceFiles(IProgressMonitor monitor) {
        return this.getSourceFiles();
    }

    public IBinaryParser.ISymbol getSymbol(IAddress addr) {
        return null;
    }

    public IBinaryParser.ISymbol[] getSymbols() {
        return new IBinaryParser.ISymbol[0];
    }

    public long getText() {
        return 0L;
    }

    public boolean hasDebug() {
        return this.fetchCUData().hasDebug();
    }

    public boolean isLittleEndian() {
        return true;
    }

    public static final class CUData {
        private final String architectures;
        private final boolean hasDebug;
        private final String[] sources;

        public CUData(boolean hasDebug, String architectures, String[] sources) {
            this.hasDebug = hasDebug;
            this.architectures = architectures;
            this.sources = sources;
        }

        public String getArchitectures() {
            return this.architectures;
        }

        public String[] getSources() {
            return this.sources;
        }

        public boolean hasDebug() {
            return this.hasDebug;
        }
    }
}

