/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.ui.viewmodel.vms;

import com.ibm.icu.text.MessageFormat;
import com.nvidia.cuda.ide.debug.core.Activator;
import com.nvidia.cuda.ide.debug.core.CudaDebugImages;
import com.nvidia.cuda.ide.debug.model.Block;
import com.nvidia.cuda.ide.debug.model.CudaCoord;
import com.nvidia.cuda.ide.debug.model.CudaDim;
import com.nvidia.cuda.ide.debug.model.Device;
import com.nvidia.cuda.ide.debug.model.DeviceThread;
import com.nvidia.cuda.ide.debug.model.ICoordSorter;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.ICudaRuntimeObject;
import com.nvidia.cuda.ide.debug.model.ICudaVisitor;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.Lane;
import com.nvidia.cuda.ide.debug.model.RangeContext;
import com.nvidia.cuda.ide.debug.model.StreamingMultiprocessor;
import com.nvidia.cuda.ide.debug.model.Warp;
import com.nvidia.cuda.ide.debug.ui.IDebugLabelProvider;
import com.nvidia.cuda.ide.debug.ui.viewmodel.ICudaUIConstants;
import com.nvidia.cuda.ide.debug.ui.viewmodel.ICudaVMProvider;
import com.nvidia.cuda.ide.debug.ui.viewmodel.LayoutChangeEvent;
import com.nvidia.cuda.ide.debug.ui.viewmodel.LinkedSelectionChangedEvent;
import com.nvidia.cuda.ide.debug.ui.viewmodel.events.ElementQuerySet;
import com.nvidia.cuda.ide.debug.ui.viewmodel.events.ViewModeChangedEvent;
import com.nvidia.cuda.ide.debug.ui.viewmodel.filters.ActiveElementsOnly;
import com.nvidia.cuda.ide.debug.ui.viewmodel.filters.ICudaElementFilter;
import com.nvidia.cuda.ide.debug.ui.viewmodel.filters.IFilters;
import com.nvidia.cuda.ide.debug.util.DebugUtil;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.launch.FullStackRefreshEvent;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.concurrent.ViewerDataRequestMonitor;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMContext;
import org.eclipse.cdt.dsf.ui.viewmodel.ModelProxyInstalledEvent;
import org.eclipse.cdt.dsf.ui.viewmodel.VMDelta;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IElementPropertiesProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.IPropertiesUpdate;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementCompareRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementMementoRequest;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;
import org.eclipse.ui.IMemento;

public abstract class AbstractCudaDMVMNode<T extends ICudaRuntimeObject>
extends AbstractDMVMNode
implements IElementLabelProvider,
IElementPropertiesProvider,
IElementMementoProvider {
    protected final Class<T> clazz;
    private IElementLabelProvider labelProvider;

    public AbstractCudaDMVMNode(AbstractDMVMProvider provider, DsfSession session, Class<T> clazz) {
        super(provider, session, clazz);
        this.clazz = clazz;
    }

    protected final void baseUpdate(IChildrenCountUpdate[] updates) {
        super.update(updates);
    }

    protected final void baseUpdate(IHasChildrenUpdate[] updates) {
        super.update(updates);
    }

    public void buildDelta(Object event, VMDelta parent, int nodeOffset, RequestMonitor requestMonitor) {
        if (event instanceof FullStackRefreshEvent) {
            parent.setFlags(parent.getFlags() | 0x400);
            requestMonitor.done();
        } else if (event instanceof LinkedSelectionChangedEvent) {
            this.selectOrExpand(((LinkedSelectionChangedEvent)event).getDMContext(), parent, nodeOffset, false, requestMonitor);
        } else if (event instanceof ModelProxyInstalledEvent) {
            this.buildProxyInstalledDelta(parent, nodeOffset, requestMonitor);
        } else if (event instanceof LayoutChangeEvent) {
            parent.setFlags(parent.getFlags() | 0x400);
            this.selectOrExpand(DebugUtil.getObject(event, ICudaRuntimeObject.class, null), parent, nodeOffset, true, requestMonitor);
        } else {
            requestMonitor.done();
        }
    }

    protected void buildProxyInstalledDelta(VMDelta parent, int nodeOffset, RequestMonitor requestMonitor) {
        VMDelta grandparent = parent.getParentDelta();
        if (grandparent != null && grandparent.getChildCount() == 1 && ((grandparent.getFlags() & 0x100000) == 0x100000 || grandparent.getParentDelta() == null)) {
            parent.setFlags(parent.getFlags() | 0x100000);
        }
        requestMonitor.done();
    }

    protected abstract boolean compareElement(T var1, IMemento var2);

    public final void compareElements(IElementCompareRequest[] requests) {
        IElementCompareRequest[] iElementCompareRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IElementCompareRequest request = iElementCompareRequestArray[n2];
            T object = this.getUpdateObject(request);
            if (object != null) {
                request.setEqual(this.compareElement(object, request.getMemento()));
            } else {
                request.cancel();
            }
            request.done();
            ++n2;
        }
    }

    protected abstract IElementLabelProvider createLabelProvider();

    protected abstract void encodeElement(T var1, IMemento var2);

    public final void encodeElements(IElementMementoRequest[] requests) {
        IElementMementoRequest[] iElementMementoRequestArray = requests;
        int n = requests.length;
        int n2 = 0;
        while (n2 < n) {
            IElementMementoRequest request = iElementMementoRequestArray[n2];
            T object = this.getUpdateObject(request);
            if (object != null) {
                this.encodeElement(object, request.getMemento());
            } else {
                request.cancel();
            }
            request.done();
            ++n2;
        }
    }

    protected boolean fetchChildren(ICudaRuntimeObject parent, int offset, int length, DataRequestMonitor<IDMContext[]> drm) {
        this.getFilter().updateChildren(this.isInLogicalMode(), parent, offset, length, ICoordSorter.CUDA, drm);
        return true;
    }

    private void fillInactiveLabel(String label, ILabelUpdate update, int columnNo) {
        switch (columnNo) {
            case 0: {
                update.setImageDescriptor(this.getInactiveImageDescriptor().getDescriptor(), columnNo);
                break;
            }
            case 2: {
                update.setImageDescriptor(CudaDebugImages.OCCUPANCY_00.getDescriptor(), columnNo);
            }
        }
        update.setLabel(label, columnNo);
        update.setForeground(DebugUtil.getRGBColor(33), columnNo);
    }

    protected void buildSelectionDelta(T element, VMDelta delta, int nodeOffset, boolean select, boolean collapseTheRest, RequestMonitor rm) {
        DebugUtil.select(element, delta, select, collapseTheRest, this.getVMProvider(), rm);
    }

    public void getContextsForEvent(VMDelta parentDelta, Object event, DataRequestMonitor<IVMContext[]> rm) {
        rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.ui", 10003, "", null));
        rm.done();
    }

    public int getDeltaFlags(Object event) {
        if (event instanceof FullStackRefreshEvent || event instanceof IRunControl.IExitedDMEvent) {
            return 1024;
        }
        if (event instanceof ViewModeChangedEvent) {
            return 1024;
        }
        if (event instanceof ElementQuerySet) {
            return 0x300000;
        }
        if (event instanceof LinkedSelectionChangedEvent) {
            return 0x300000;
        }
        if (event instanceof ModelProxyInstalledEvent) {
            return 0x1300000;
        }
        if (event instanceof LayoutChangeEvent) {
            return 36701184;
        }
        return 0;
    }

    protected final ICudaElementFilter getFilter() {
        if (this.getDMVMProvider() instanceof ICudaVMProvider) {
            return ((ICudaVMProvider)this.getDMVMProvider()).getFilter();
        }
        IFilters filters = Activator.getDefault().getFilters();
        return filters.get(ActiveElementsOnly.ID);
    }

    protected final IDebugLabelProvider getFormatter() {
        return Activator.getDefault().getFormatter();
    }

    protected String getInactiveElementRangeLabel(RangeContext rangeContext, boolean singleColumn) {
        String end;
        String start;
        CudaDim dim = ((Kernel)DMContexts.getAncestorOfType((IDMContext)rangeContext, Kernel.class)).getBlockDim();
        ICoordSorter sorter = rangeContext.getSorter();
        if (sorter != null) {
            CudaCoord startCoord = sorter.getCoord(dim, rangeContext.getStart());
            CudaCoord endCoord = sorter.getCoord(dim, rangeContext.getEnd());
            start = String.valueOf(startCoord.toString());
            end = String.valueOf(endCoord.toString());
        } else {
            start = String.valueOf(rangeContext.getStart());
            end = String.valueOf(rangeContext.getEnd());
        }
        return MessageFormat.format((String)"{0,choice,0#{1}|1<{1} - {2}}", (Object[])new Object[]{rangeContext.getEnd() - rangeContext.getStart(), start, end});
    }

    protected abstract String getInactiveElementRangeStateLabel(RangeContext var1);

    protected abstract CudaDebugImages getInactiveImageDescriptor();

    protected ICudaRuntimeObject getParentElement(IChildrenUpdate update) {
        return this.getUpdateObject(update, ICudaRuntimeObject.class);
    }

    protected final T getUpdateObject(Object element) {
        return (T)((ICudaRuntimeObject)this.getUpdateObject(element, this.clazz));
    }

    protected final <K extends IDMContext> K getUpdateObject(Object element, Class<K> clazz) {
        return DebugUtil.getObject(element, clazz, this.getServicesTracker());
    }

    protected final boolean isInLogicalMode() {
        return !"hardware.view.mode".equals(this.getDMVMProvider().getPresentationContext().getProperty("view.mode"));
    }

    protected abstract boolean isLogicalNode();

    protected void selectOrExpand(IDMContext object, VMDelta parent, int nodeOffset, boolean collapseTheRest, RequestMonitor requestMonitor) {
        ICudaRuntimeObject ancestor;
        if (object != null && (ancestor = (ICudaRuntimeObject)DMContexts.getAncestorOfType((IDMContext)object, this.clazz)) != null) {
            this.buildSelectionDelta(ancestor, parent, nodeOffset, object.equals(ancestor), collapseTheRest, requestMonitor);
            return;
        }
        requestMonitor.done();
    }

    protected final boolean shouldIgnore(ICudaRuntimeObject object) {
        if (object != null && !(object instanceof RangeContext) && object.getSessionId() != null) {
            IgnoreForMode visitor = new IgnoreForMode(this.isInLogicalMode());
            object.accept(visitor);
            return visitor.ignore;
        }
        return true;
    }

    public void update(final IChildrenCountUpdate[] updates) {
        if (this.isLogicalNode() == this.isInLogicalMode()) {
            this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    IChildrenCountUpdate[] iChildrenCountUpdateArray = updates;
                    int n = updates.length;
                    int n2 = 0;
                    while (n2 < n) {
                        final IChildrenCountUpdate update = iChildrenCountUpdateArray[n2];
                        ICudaRuntimeObject object = AbstractCudaDMVMNode.this.getUpdateObject(update, ICudaRuntimeObject.class);
                        if (AbstractCudaDMVMNode.this.shouldIgnore(object)) {
                            AbstractCudaDMVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        } else {
                            AbstractCudaDMVMNode.this.getFilter().updateChildrenCount(AbstractCudaDMVMNode.this.isInLogicalMode(), object, ICoordSorter.CUDA, (DataRequestMonitor<Integer>)new ViewerDataRequestMonitor<Integer>(ImmediateExecutor.getInstance(), (IViewerUpdate)update){

                                protected void handleFailure() {
                                    AbstractCudaDMVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                                }

                                protected void handleSuccess() {
                                    update.setChildCount(((Integer)this.getData()).intValue());
                                    update.done();
                                }
                            });
                        }
                        ++n2;
                    }
                }
            });
        } else {
            IChildrenCountUpdate[] iChildrenCountUpdateArray = updates;
            int n = updates.length;
            int n2 = 0;
            while (n2 < n) {
                IChildrenCountUpdate update = iChildrenCountUpdateArray[n2];
                this.handleFailedUpdate((IViewerUpdate)update);
                ++n2;
            }
        }
    }

    public void update(IChildrenUpdate[] updates) {
        if (this.isLogicalNode() == this.isInLogicalMode() && this.getSession().isActive()) {
            super.update(updates);
        } else {
            IChildrenUpdate[] iChildrenUpdateArray = updates;
            int n = updates.length;
            int n2 = 0;
            while (n2 < n) {
                IChildrenUpdate update = iChildrenUpdateArray[n2];
                this.handleFailedUpdate((IViewerUpdate)update);
                ++n2;
            }
        }
    }

    public void update(IHasChildrenUpdate[] updates) {
        if (this.isLogicalNode() == this.isInLogicalMode()) {
            IHasChildrenUpdate[] iHasChildrenUpdateArray = updates;
            int n = updates.length;
            int n2 = 0;
            while (n2 < n) {
                final IHasChildrenUpdate update = iHasChildrenUpdateArray[n2];
                ICudaRuntimeObject object = this.getUpdateObject(update, ICudaRuntimeObject.class);
                if (this.shouldIgnore(object)) {
                    this.handleFailedUpdate((IViewerUpdate)update);
                } else {
                    this.getFilter().updateHasChildren(this.isInLogicalMode(), object, (DataRequestMonitor<Boolean>)new ViewerDataRequestMonitor<Boolean>(ImmediateExecutor.getInstance(), (IViewerUpdate)update){

                        protected void handleFailure() {
                            AbstractCudaDMVMNode.this.handleFailedUpdate((IViewerUpdate)update);
                        }

                        protected void handleSuccess() {
                            update.setHasChilren(!Boolean.FALSE.equals(this.getData()));
                            update.done();
                        }
                    });
                }
                ++n2;
            }
        } else {
            IHasChildrenUpdate[] iHasChildrenUpdateArray = updates;
            int n = updates.length;
            int n3 = 0;
            while (n3 < n) {
                IHasChildrenUpdate update = iHasChildrenUpdateArray[n3];
                this.handleFailedUpdate((IViewerUpdate)update);
                ++n3;
            }
        }
    }

    public final void update(ILabelUpdate[] updates) {
        ArrayList<ILabelUpdate> elementUpdates = new ArrayList<ILabelUpdate>();
        ArrayList<ILabelUpdate> inactiveRangeUpdates = new ArrayList<ILabelUpdate>();
        ILabelUpdate[] iLabelUpdateArray = updates;
        int n = updates.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelUpdate update = iLabelUpdateArray[n2];
            IDMContext object = this.getUpdateObject(update, IDMContext.class);
            if (object instanceof RangeContext) {
                inactiveRangeUpdates.add(update);
            } else {
                elementUpdates.add(update);
            }
            ++n2;
        }
        if (elementUpdates.size() > 0) {
            if (this.labelProvider == null) {
                this.labelProvider = this.createLabelProvider();
            }
            this.labelProvider.update(elementUpdates.toArray(new ILabelUpdate[elementUpdates.size()]));
        }
        this.updateRangesLabels(inactiveRangeUpdates);
    }

    public final void update(final IPropertiesUpdate[] updates) {
        this.getSession().getExecutor().execute((Runnable)new DsfRunnable(){

            public void run() {
                IPropertiesUpdate[] iPropertiesUpdateArray = updates;
                int n = updates.length;
                int n2 = 0;
                while (n2 < n) {
                    IPropertiesUpdate update = iPropertiesUpdateArray[n2];
                    ICudaRuntimeObject object = (ICudaRuntimeObject)AbstractCudaDMVMNode.this.getUpdateObject(update, AbstractCudaDMVMNode.this.clazz);
                    if (!AbstractCudaDMVMNode.this.shouldIgnore(object)) {
                        AbstractCudaDMVMNode.this.updatePropertiesInSessionThread(object, update);
                    } else {
                        update.done();
                    }
                    ++n2;
                }
            }
        });
    }

    protected final void updateElementsInSessionThread(IChildrenUpdate update) {
        ICudaRuntimeObject object = this.getParentElement(update);
        if (this.shouldIgnore(object)) {
            this.handleFailedUpdate((IViewerUpdate)update);
        } else if (!this.fetchChildren(object, update.getOffset(), update.getLength(), (DataRequestMonitor<IDMContext[]>)new FilterRequestMonitor(this.getExecutor(), update))) {
            update.done();
        }
    }

    protected abstract void updatePropertiesInSessionThread(T var1, IPropertiesUpdate var2);

    private void updateRangesLabels(ArrayList<ILabelUpdate> inactiveRangeUpdates) {
        for (ILabelUpdate update : inactiveRangeUpdates) {
            RangeContext rangeContext = this.getUpdateObject(update, RangeContext.class);
            String[] columnIds = update.getColumnIds();
            int i = 0;
            if (columnIds != null) {
                String[] stringArray = columnIds;
                int n = columnIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    String label = "org.eclipse.cdt.dsf.ui.COLUMN_ID__NAME".equals(string) || "ID_COLUMN_NO_COLUMNS".equals(string) ? this.getInactiveElementRangeLabel(rangeContext, false) : (ICudaUIConstants.COLUMN_ID__DETAILS.equals(string) ? this.getInactiveElementRangeStateLabel(rangeContext) : "");
                    this.fillInactiveLabel(label, update, i);
                    ++i;
                    ++n2;
                }
            } else {
                this.fillInactiveLabel(this.getInactiveElementRangeLabel(rangeContext, true), update, 0);
            }
            update.done();
        }
    }

    protected final class FilterRequestMonitor
    extends ViewerDataRequestMonitor<IDMContext[]> {
        private final IChildrenUpdate update;

        protected FilterRequestMonitor(Executor executor, IChildrenUpdate update) {
            super(executor, (IViewerUpdate)update);
            this.update = update;
        }

        protected final void handleErrorOrWarning() {
            AbstractCudaDMVMNode.this.handleFailedUpdate((IViewerUpdate)this.update);
        }

        protected final void handleSuccess() {
            if (this.getData() == null) {
                Activator.log("No elements returned by filter", new Object[0]);
            }
            if (this.update.getOffset() >= 0) {
                AbstractCudaDMVMNode.this.fillUpdateWithVMCs(this.update, (IDMContext[])this.getData(), this.update.getOffset());
            } else {
                AbstractCudaDMVMNode.this.fillUpdateWithVMCs(this.update, (IDMContext[])this.getData());
            }
            this.update.done();
        }
    }

    public static final class IgnoreForMode
    implements ICudaVisitor {
        public boolean ignore;
        private final boolean needsLogical;

        public IgnoreForMode(boolean needsLogical) {
            this.needsLogical = needsLogical;
        }

        @Override
        public void visitApplication(ICudaApplication application) {
            this.ignore = false;
        }

        @Override
        public void visitBlock(Block block) {
            this.ignore = !this.needsLogical;
        }

        @Override
        public void visitDevice(Device device) {
            this.ignore = this.needsLogical;
        }

        @Override
        public void visitKernel(Kernel kernel) {
            this.ignore = !this.needsLogical;
        }

        @Override
        public void visitLane(Lane lane) {
            this.ignore = this.needsLogical;
        }

        @Override
        public void visitSM(StreamingMultiprocessor sm) {
            this.ignore = this.needsLogical;
        }

        @Override
        public void visitThread(DeviceThread deviceThread) {
            this.ignore = !this.needsLogical;
        }

        @Override
        public void visitWarp(Warp warp) {
            this.ignore = this.needsLogical;
        }
    }
}

