/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuda.ide.debug.model.state;

import com.nvidia.cuda.ide.debug.mi.LaunchTraceInfo;
import com.nvidia.cuda.ide.debug.mi.vo.KernelInfo;
import com.nvidia.cuda.ide.debug.model.CudaRuntimeInformation;
import com.nvidia.cuda.ide.debug.model.CudaThreadState;
import com.nvidia.cuda.ide.debug.model.ICudaApplication;
import com.nvidia.cuda.ide.debug.model.Kernel;
import com.nvidia.cuda.ide.debug.model.state.ICudaQueries;
import com.nvidia.cuda.ide.debug.util.MultiDataRequestMonitor;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.CountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateExecutor;
import org.eclipse.cdt.dsf.concurrent.ImmediateInDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.core.runtime.IStatus;

public final class KernelsStateManager {
    private final ICudaApplication application;
    private ConcurrentMap<Long, Kernel> kernels = new ConcurrentHashMap<Long, Kernel>();
    private final Queue<RequestMonitor> postponed = new ConcurrentLinkedQueue<RequestMonitor>();
    private final ICudaQueries queries;
    private final AtomicBoolean reconciling = new AtomicBoolean(false);
    private final AtomicReference<IStatus> status = new AtomicReference<Object>(null);
    private final AtomicBoolean valid = new AtomicBoolean(false);

    public KernelsStateManager(ICudaApplication application, ICudaQueries queries) {
        this.application = application;
        this.queries = queries;
    }

    public Kernel addKernel(Kernel kernel) {
        Kernel existing = this.kernels.putIfAbsent(kernel.getId(), kernel);
        return existing == null ? kernel : existing;
    }

    private boolean completeMonitor(RequestMonitor rm) {
        IStatus s = this.status.get();
        if (this.valid.get()) {
            if (s != null && !s.isOK()) {
                if (s.getSeverity() == 8) {
                    rm.cancel();
                } else {
                    rm.setStatus(s);
                }
            }
            rm.done();
            return true;
        }
        return false;
    }

    private Kernel createKernel(Kernel childKernel, LaunchTraceInfo info, Kernel parent) {
        Kernel kernel = new Kernel((IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)childKernel, IRunControl.IContainerDMContext.class), (ICudaApplication)DMContexts.getAncestorOfType((IDMContext)childKernel, ICudaApplication.class), info.getId(), info.getDeviceId(), info.getStatus());
        kernel.setAttributes(info.getName(), info.getGridDim(), info.getBlockDim());
        if (parent != null) {
            kernel.setCallSite(parent);
        }
        return kernel;
    }

    private int fetchParentKernels(Kernel kernel, long parentId, Map<Long, Kernel> newKernels, Map<Long, MultiDataRequestMonitor<Kernel>> queue, DataRequestMonitor<Kernel> drm) {
        Kernel parentKernel = newKernels.get(parentId);
        if (parentKernel == null) {
            MultiDataRequestMonitor<Kernel> monitor = queue.get(parentId);
            if (monitor == null) {
                monitor = new MultiDataRequestMonitor();
                queue.put(parentId, monitor);
                this.fetchParentKernels(kernel, newKernels, queue, monitor);
            }
            monitor.enqueue(drm);
            return 1;
        }
        kernel.setCallSite(parentKernel);
        return 0;
    }

    private void fetchParentKernels(final Kernel sourceKernel, final Map<Long, Kernel> newKernels, final Map<Long, MultiDataRequestMonitor<Kernel>> queue, DataRequestMonitor<Kernel> dataRequestMonitor) {
        this.queries.queryCdpTrace(sourceKernel, sourceKernel.getId(), new DataRequestMonitor<LaunchTraceInfo[]>(ImmediateExecutor.getInstance(), dataRequestMonitor){

            @ConfinedToDsfExecutor(value="fExecutor")
            protected void handleSuccess() {
                KernelsStateManager.this.processTrace(sourceKernel, (LaunchTraceInfo[])this.getData(), newKernels, queue);
            }
        });
    }

    private boolean flushPostponed() {
        if (this.valid.get()) {
            RequestMonitor rm;
            while ((rm = this.postponed.poll()) != null) {
                if (this.completeMonitor(rm)) continue;
                this.postponed.add(rm);
                return this.flushPostponed();
            }
            return true;
        }
        return false;
    }

    public Kernel get(long id) {
        return (Kernel)this.kernels.get(id);
    }

    public void getKernels(IRunControl.IContainerDMContext dmc, DataRequestMonitor<? super Kernel[]> rm) {
        this.reconcileCudaState(dmc, new RequestMonitor((Executor)this.queries.getExecutor(), (RequestMonitor)rm, (DataRequestMonitor)rm){
            private final /* synthetic */ DataRequestMonitor val$rm;
            {
                this.val$rm = dataRequestMonitor;
                super($anonymous0, $anonymous1);
            }

            protected void handleSuccess() {
                TreeSet<Kernel> set = new TreeSet<Kernel>(new Comparator<Kernel>(){

                    @Override
                    public int compare(Kernel o1, Kernel o2) {
                        return Long.signum(o1.getId() - o2.getId());
                    }
                });
                set.addAll(KernelsStateManager.this.kernels.values());
                this.val$rm.setData((Object)set.toArray(new Kernel[set.size()]));
                this.val$rm.done();
            }
        });
    }

    protected void getKernelsDelta(IRunControl.IContainerDMContext dmc, KernelInfo[] kernelInfos, final RequestMonitor rm) {
        final TreeMap<Long, Kernel> newKernels = new TreeMap<Long, Kernel>();
        KernelInfo[] kernelInfoArray = kernelInfos;
        int n = kernelInfos.length;
        int n2 = 0;
        while (n2 < n) {
            KernelInfo info = kernelInfoArray[n2];
            long kernelId = info.getId();
            Kernel k = (Kernel)this.kernels.get(kernelId);
            if (k == null) {
                k = this.addKernel(new Kernel(dmc, this.application, kernelId, info.getDeviceId(), info.getStatus()));
            }
            k.setAttributes(info.getName(), info.getGridDim(), info.getBlockDim());
            newKernels.put(kernelId, k);
            ++n2;
        }
        int unfetched = 0;
        final CountingRequestMonitor crm = new CountingRequestMonitor(ImmediateExecutor.getInstance(), rm){

            @ConfinedToDsfExecutor(value="fExecutor")
            protected void handleCompleted() {
                KernelsStateManager.this.kernels = new ConcurrentHashMap(newKernels);
                rm.done();
            }
        };
        HashMap<Long, MultiDataRequestMonitor<Kernel>> queue = new HashMap<Long, MultiDataRequestMonitor<Kernel>>();
        KernelInfo[] kernelInfoArray2 = kernelInfos;
        int n3 = kernelInfos.length;
        int n4 = 0;
        while (n4 < n3) {
            KernelInfo kernelInfo = kernelInfoArray2[n4];
            final Kernel kernel = (Kernel)newKernels.get(kernelInfo.getId());
            long parentId = kernelInfo.getParentId();
            DataRequestMonitor<Kernel> drm = new DataRequestMonitor<Kernel>(ImmediateExecutor.getInstance(), (RequestMonitor)crm){

                @ConfinedToDsfExecutor(value="fExecutor")
                protected void handleSuccess() {
                    KernelsStateManager.this.setParentKernel(kernel, (Kernel)this.getData(), newKernels);
                    crm.done();
                }
            };
            if (!kernelInfo.isCPULaunch()) {
                unfetched += this.fetchParentKernels(kernel, parentId, newKernels, queue, drm);
            }
            ++n4;
        }
        crm.setDoneCount(unfetched);
    }

    public void getState(Kernel kernel, DataRequestMonitor<CudaRuntimeInformation> rm) {
        this.reconcileCudaState((IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)kernel, IRunControl.IContainerDMContext.class), new RequestMonitor((Executor)new ImmediateInDsfExecutor(this.queries.getExecutor()), (RequestMonitor)rm, (DataRequestMonitor)rm, kernel){
            private final /* synthetic */ DataRequestMonitor val$rm;
            private final /* synthetic */ Kernel val$kernel;
            {
                this.val$rm = dataRequestMonitor;
                this.val$kernel = kernel;
                super($anonymous0, $anonymous1);
            }

            protected void handleSuccess() {
                this.val$rm.setData((Object)new CudaRuntimeInformation(this.val$kernel.getDeviceId(), -1, -1, -1, KernelsStateManager.this.isRunningKernel(this.val$kernel) ? CudaThreadState.RUNNING : CudaThreadState.INACTIVE));
                this.val$rm.done();
            }
        });
    }

    public void invalidate() {
        this.valid.set(false);
        this.status.set(null);
    }

    public boolean isEmpty() {
        return this.kernels.isEmpty();
    }

    private boolean isRunningKernel(Kernel kernel) {
        return this.kernels.containsKey(kernel.getId());
    }

    private boolean postponeOrRun(RequestMonitor rm) {
        if (!this.completeMonitor(rm)) {
            this.postponed.add(rm);
            return this.flushPostponed();
        }
        return true;
    }

    protected synchronized void processTrace(Kernel sourceKernel, LaunchTraceInfo[] data, Map<Long, Kernel> newKernels, Map<Long, MultiDataRequestMonitor<Kernel>> queue) {
        Kernel k = null;
        int i = data.length - 1;
        while (i > 0) {
            LaunchTraceInfo info = data[i];
            long parentId = info.getId();
            Kernel kernel = newKernels.get(parentId);
            if (kernel == null) {
                k = this.createKernel(sourceKernel, info, k);
                newKernels.put(parentId, k);
                if (queue.containsKey(parentId)) {
                    queue.get(parentId).done(k);
                }
            } else {
                k = kernel;
            }
            --i;
        }
    }

    private void reconcileCudaState(IRunControl.IContainerDMContext ctx, RequestMonitor rm) {
        if (!this.postponeOrRun(rm) && this.reconciling.compareAndSet(false, true)) {
            this.queries.queryKernels((IDMContext)ctx, new KernelsReconciler((Executor)this.queries.getExecutor(), ctx));
        }
    }

    private synchronized void setParentKernel(Kernel kernel, Kernel parentKernel, Map<Long, Kernel> newKernels) {
        kernel.setCallSite(parentKernel);
        newKernels.put(parentKernel.getId(), parentKernel);
    }

    private final class KernelsReconciler
    extends DataRequestMonitor<KernelInfo[]> {
        private final IRunControl.IContainerDMContext dmc;

        private KernelsReconciler(Executor executor, IRunControl.IContainerDMContext dmc) {
            super(executor, null);
            this.dmc = dmc;
        }

        protected void handleFailure() {
            KernelsStateManager.this.status.set(this.getStatus());
            KernelsStateManager.this.reconciling.set(false);
            KernelsStateManager.this.valid.set(true);
            KernelsStateManager.this.flushPostponed();
        }

        protected void handleSuccess() {
            KernelsStateManager.this.getKernelsDelta(this.dmc, (KernelInfo[])this.getData(), new RequestMonitor((Executor)KernelsStateManager.this.queries.getExecutor(), null){

                @ConfinedToDsfExecutor(value="fExecutor")
                protected void handleCompleted() {
                    if (!this.isSuccess()) {
                        KernelsStateManager.this.status.set(this.getStatus());
                    }
                    KernelsStateManager.this.reconciling.set(false);
                    KernelsStateManager.this.valid.set(true);
                    KernelsStateManager.this.flushPostponed();
                }
            });
        }
    }
}

