/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.ui.sourcelookup;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.ui.sourcelookup.IInstructionPointerPresentation;
import org.eclipse.cdt.dsf.debug.ui.sourcelookup.Messages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

@ThreadSafe
public class InstructionPointerManager {
    private static final String ID_CURRENT_IP = "org.eclipse.debug.ui.currentIP";
    private static final String ID_SECONDARY_IP = "org.eclipse.debug.ui.secondaryIP";
    private static final String ID_ERROR_IP = "org.eclipse.cdt.debug.core.errorIP";
    private final List<AnnotationWrapper> fAnnotationWrappers;
    private final IInstructionPointerPresentation fPresentation;

    public InstructionPointerManager() {
        this(null);
    }

    public InstructionPointerManager(IInstructionPointerPresentation presentation) {
        this.fPresentation = presentation;
        this.fAnnotationWrappers = new LinkedList<AnnotationWrapper>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotation(ITextEditor textEditor, IStack.IFrameDMContext frame, Position position, boolean isTopFrame, boolean errorIP) {
        IEditorInput editorInput;
        IDocumentProvider docProvider = textEditor.getDocumentProvider();
        IAnnotationModel annModel = docProvider.getAnnotationModel((Object)(editorInput = textEditor.getEditorInput()));
        if (annModel == null) {
            return;
        }
        if (isTopFrame && !errorIP) {
            this.removeAnnotations((IRunControl.IExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)frame.getParents()[0], IRunControl.IExecutionDMContext.class));
        }
        Annotation annotation = this.createAnnotation(textEditor, frame, errorIP);
        annModel.removeAnnotation(annotation);
        annModel.addAnnotation(annotation, position);
        List<AnnotationWrapper> list = this.fAnnotationWrappers;
        synchronized (list) {
            this.fAnnotationWrappers.add(new AnnotationWrapper(textEditor, annotation, frame));
        }
    }

    private Annotation createAnnotation(ITextEditor editorPart, IStack.IFrameDMContext frame, boolean errorIP) {
        String id = null;
        String text = null;
        Image image = null;
        if (this.fPresentation != null) {
            Annotation annotation = this.fPresentation.getInstructionPointerAnnotation((IEditorPart)editorPart, frame);
            if (annotation != null) {
                return annotation;
            }
            id = this.fPresentation.getInstructionPointerAnnotationType((IEditorPart)editorPart, frame);
            if (id == null) {
                image = this.fPresentation.getInstructionPointerImage((IEditorPart)editorPart, frame);
            }
            text = this.fPresentation.getInstructionPointerText((IEditorPart)editorPart, frame);
        }
        if (id == null) {
            if (frame.getLevel() == 0) {
                if (errorIP) {
                    id = ID_ERROR_IP;
                    if (text == null) {
                        text = Messages.IPAnnotation_error;
                    }
                    if (image == null) {
                        image = CDebugUIPlugin.getDefault().getImage("icons/obj16/inst_ptr_err.gif");
                    }
                } else {
                    id = ID_CURRENT_IP;
                    if (text == null) {
                        text = Messages.IPAnnotation_primary;
                    }
                    if (image == null) {
                        image = DebugUITools.getImage((String)"IMG_OBJS_INSTRUCTION_POINTER_TOP");
                    }
                }
            } else {
                id = ID_SECONDARY_IP;
                if (text == null) {
                    text = Messages.IPAnnotation_secondary;
                }
                if (image == null) {
                    image = DebugUITools.getImage((String)"IMG_OBJS_INSTRUCTION_POINTER");
                }
            }
            return new IPAnnotation(frame, id, text, image, errorIP);
        }
        return new Annotation(id, false, text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnnotations(IRunControl.IExecutionDMContext execDmc) {
        List<AnnotationWrapper> list = this.fAnnotationWrappers;
        synchronized (list) {
            Iterator<AnnotationWrapper> wrapperItr = this.fAnnotationWrappers.iterator();
            while (wrapperItr.hasNext()) {
                AnnotationWrapper wrapper = wrapperItr.next();
                if (!DMContexts.isAncestorOf((IDMContext)wrapper.getFrameDMC(), (IDMContext)execDmc)) continue;
                this.removeAnnotation(wrapper.getTextEditor(), wrapper.getAnnotation());
                wrapperItr.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTopFrameAnnotations(IRunControl.IExecutionDMContext execDmc) {
        List<AnnotationWrapper> list = this.fAnnotationWrappers;
        synchronized (list) {
            Iterator<AnnotationWrapper> wrapperItr = this.fAnnotationWrappers.iterator();
            while (wrapperItr.hasNext()) {
                AnnotationWrapper wrapper = wrapperItr.next();
                IStack.IFrameDMContext frameDmc = wrapper.getFrameDMC();
                if (!DMContexts.isAncestorOf((IDMContext)frameDmc, (IDMContext)execDmc) || frameDmc.getLevel() != 0) continue;
                this.removeAnnotation(wrapper.getTextEditor(), wrapper.getAnnotation());
                wrapperItr.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAnnotations() {
        List<AnnotationWrapper> list = this.fAnnotationWrappers;
        synchronized (list) {
            for (AnnotationWrapper wrapper : this.fAnnotationWrappers) {
                this.removeAnnotation(wrapper.getTextEditor(), wrapper.getAnnotation());
            }
            this.fAnnotationWrappers.clear();
        }
    }

    private void removeAnnotation(ITextEditor textEditor, Annotation annotation) {
        IAnnotationModel annotationModel;
        IDocumentProvider docProvider = textEditor.getDocumentProvider();
        if (docProvider != null && (annotationModel = docProvider.getAnnotationModel((Object)textEditor.getEditorInput())) != null) {
            annotationModel.removeAnnotation(annotation);
        }
    }

    static class AnnotationWrapper {
        private ITextEditor fTextEditor;
        private IStack.IFrameDMContext fFrameDmc;
        private Annotation fAnnotation;

        AnnotationWrapper(ITextEditor textEditor, Annotation annotation, IStack.IFrameDMContext frameDmc) {
            this.fTextEditor = textEditor;
            this.fAnnotation = annotation;
            this.fFrameDmc = frameDmc;
        }

        public boolean equals(Object other) {
            if (other instanceof AnnotationWrapper) {
                AnnotationWrapper otherContext = (AnnotationWrapper)other;
                return this.getAnnotation().equals(otherContext.getAnnotation());
            }
            return false;
        }

        public int hashCode() {
            return this.getAnnotation().hashCode();
        }

        ITextEditor getTextEditor() {
            return this.fTextEditor;
        }

        Annotation getAnnotation() {
            return this.fAnnotation;
        }

        IStack.IFrameDMContext getFrameDMC() {
            return this.fFrameDmc;
        }
    }

    static class IPAnnotation
    extends Annotation
    implements IAnnotationPresentation {
        private Image fImage;
        private IStack.IFrameDMContext fFrame;
        private boolean exceptionIP;

        IPAnnotation(IStack.IFrameDMContext frame, String annotationType, String text, Image image, boolean exception) {
            super(annotationType, false, text);
            this.fFrame = frame;
            this.fImage = image;
            this.exceptionIP = exception;
        }

        protected Image getImage() {
            return this.fImage;
        }

        public boolean equals(Object o) {
            if (o instanceof IPAnnotation) {
                IPAnnotation other = (IPAnnotation)((Object)o);
                return this.fFrame.equals(other.fFrame) && other.exceptionIP == this.exceptionIP;
            }
            return false;
        }

        public int hashCode() {
            return this.fFrame.hashCode();
        }

        public void paint(GC gc, Canvas canvas, Rectangle bounds) {
            Rectangle imageBounds = this.fImage.getBounds();
            gc.drawImage(this.fImage, bounds.x + (bounds.width - imageBounds.width) / 2, bounds.y + (bounds.height - imageBounds.height) / 2);
        }

        public int getLayer() {
            return 5;
        }
    }
}

