/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.internal.ui.commands.actions.DebugCommandService;
import org.eclipse.debug.internal.ui.commands.actions.ICommandParticipant;
import org.eclipse.debug.internal.ui.commands.actions.IEnabledTarget;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class DebugCommandHandler
extends AbstractHandler {
    private IWindowListener fWindowListener = new IWindowListener(){

        public void windowOpened(IWorkbenchWindow w) {
        }

        public void windowDeactivated(IWorkbenchWindow w) {
        }

        public void windowClosed(IWorkbenchWindow w) {
            EnabledTarget enabledTarget = (EnabledTarget)DebugCommandHandler.this.fEnabledTargetsMap.get(w);
            if (enabledTarget != null) {
                enabledTarget.dispose();
            }
        }

        public void windowActivated(IWorkbenchWindow w) {
            DebugCommandHandler.this.fCurrentEnabledTarget = (EnabledTarget)DebugCommandHandler.this.fEnabledTargetsMap.get(w);
            DebugCommandHandler.this.fireHandlerChanged(new HandlerEvent((IHandler)DebugCommandHandler.this, true, false));
        }
    };
    private Map<IWorkbenchWindow, EnabledTarget> fEnabledTargetsMap = new WeakHashMap<IWorkbenchWindow, EnabledTarget>();
    private EnabledTarget fCurrentEnabledTarget = null;

    public DebugCommandHandler() {
        PlatformUI.getWorkbench().addWindowListener(this.fWindowListener);
    }

    public void setEnabled(Object evaluationContext) {
        this.fCurrentEnabledTarget = null;
        if (!(evaluationContext instanceof IEvaluationContext)) {
            return;
        }
        IEvaluationContext context = (IEvaluationContext)evaluationContext;
        Object _window = context.getVariable("activeWorkbenchWindow");
        if (_window instanceof IWorkbenchWindow) {
            IWorkbenchWindow window = (IWorkbenchWindow)_window;
            this.fCurrentEnabledTarget = this.getEnabledTarget(window);
        }
    }

    public boolean isEnabled() {
        if (this.fCurrentEnabledTarget == null) {
            return false;
        }
        return this.fCurrentEnabledTarget.fEnabled;
    }

    private EnabledTarget getEnabledTarget(IWorkbenchWindow window) {
        EnabledTarget target = this.fEnabledTargetsMap.get(window);
        if (target == null) {
            target = new EnabledTarget(window);
            this.fEnabledTargetsMap.put(window, target);
        }
        return target;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        if (window == null) {
            throw new ExecutionException("No active workbench window.");
        }
        this.fCurrentEnabledTarget = this.getEnabledTarget(window);
        ISelection selection = this.getContextService(window).getActiveContext();
        if (selection instanceof IStructuredSelection && this.isEnabled()) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            boolean enabledAfterExecute = this.execute(window, ss.toArray());
            this.fCurrentEnabledTarget.setEnabled(enabledAfterExecute);
        }
        return null;
    }

    private IDebugContextService getContextService(IWorkbenchWindow window) {
        return DebugUITools.getDebugContextManager().getContextService(window);
    }

    private boolean execute(IWorkbenchWindow window, final Object[] targets) {
        DebugCommandService service = DebugCommandService.getService(window);
        return service.executeCommand(this.getCommandType(), targets, new ICommandParticipant(){

            @Override
            public void requestDone(IRequest request) {
                DebugCommandHandler.this.postExecute(request, targets);
            }
        });
    }

    protected void postExecute(IRequest request, Object[] targets) {
    }

    protected abstract Class<?> getCommandType();

    protected boolean getInitialEnablement() {
        return false;
    }

    public void dispose() {
        PlatformUI.getWorkbench().removeWindowListener(this.fWindowListener);
        for (EnabledTarget target : this.fEnabledTargetsMap.values()) {
            if (target.isDisposed()) continue;
            target.dispose();
        }
        this.fEnabledTargetsMap.clear();
        this.fCurrentEnabledTarget = null;
    }

    private class EnabledTarget
    implements IEnabledTarget,
    IDebugContextListener {
        boolean fEnabled;
        IWorkbenchWindow fWindow;

        EnabledTarget(IWorkbenchWindow window) {
            this.fEnabled = DebugCommandHandler.this.getInitialEnablement();
            this.fWindow = window;
            DebugCommandService.getService(this.fWindow).updateCommand(DebugCommandHandler.this.getCommandType(), this);
            DebugCommandHandler.this.getContextService(this.fWindow).addDebugContextListener(this);
        }

        @Override
        public void setEnabled(boolean enabled) {
            boolean oldEnabled = this.fEnabled;
            this.fEnabled = enabled;
            if (this.fEnabled != oldEnabled && DebugCommandHandler.this.fCurrentEnabledTarget == this) {
                DebugCommandHandler.this.fireHandlerChanged(new HandlerEvent((IHandler)DebugCommandHandler.this, true, false));
            }
        }

        @Override
        public void debugContextChanged(DebugContextEvent event) {
            DebugCommandService.getService(this.fWindow).postUpdateCommand(DebugCommandHandler.this.getCommandType(), this);
        }

        void dispose() {
            if (this.isDisposed()) {
                return;
            }
            DebugCommandHandler.this.getContextService(this.fWindow).removeDebugContextListener(this);
            this.fWindow = null;
        }

        boolean isDisposed() {
            return this.fWindow == null;
        }
    }
}

