/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.viper.analysis;

import com.nvidia.viper.activity.CuptiActivitySourceLocator;
import com.nvidia.viper.activity.ICuptiActivitySourceLevelResult;
import com.nvidia.viper.analysis.AnalysisDescriptor;
import com.nvidia.viper.analysis.AnalysisResult;
import com.nvidia.viper.analysis.AnalysisResultSourceLevelKind;
import com.nvidia.viper.model.ITimelineInterval;
import com.nvidia.viper.model.Session;
import com.nvidia.viper.model.Timeline;
import com.nvidia.viper.model.TimelineIntervalKernel;
import com.nvidia.viper.model.TimelineIntervalPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class AnalysisResultSourceLevel
extends AnalysisResult {
    private final Session session;
    private final ITimelineInterval interval;
    protected Set<ICuptiActivitySourceLevelResult> results;

    public AnalysisResultSourceLevel(Session session, ITimelineInterval interval, AnalysisDescriptor desc) {
        super(desc);
        this.session = session;
        this.interval = interval;
        this.results = new HashSet<ICuptiActivitySourceLevelResult>();
    }

    @Override
    public void discard() {
        if (this.results != null) {
            for (ICuptiActivitySourceLevelResult slr : this.results) {
                this.session.getSourceLocator().removeAnalysisMarker(slr);
            }
        }
        this.results.clear();
        this.results = null;
    }

    public ITimelineInterval getInterval() {
        return this.interval;
    }

    public final TimelineIntervalKernel getKernel() {
        return (TimelineIntervalKernel)this.interval;
    }

    public int getSourceLevelResultCount() {
        return this.results.size();
    }

    public Set<ICuptiActivitySourceLevelResult> getSourceLevelResults() {
        return Collections.unmodifiableSet(this.results);
    }

    public boolean addResult(ICuptiActivitySourceLevelResult slr) {
        CuptiActivitySourceLocator loc = this.session.getSourceLocator().getLocation(slr.getSourceLocatorId());
        this.results.add(slr);
        return loc != null || slr.isNullResult();
    }

    protected void addMarkers(ICuptiActivitySourceLevelResult slr) {
        this.session.getSourceLocator().requestAnalysisMarker(slr, this.getResultDescription(slr));
    }

    @Override
    public boolean isValid() {
        Timeline timeline = this.interval.getPrimaryTimeline();
        return timeline == null || timeline.isVisible() && !timeline.isFiltered();
    }

    @Override
    public List<TimelineIntervalPair> getAssociatedIntervals() {
        ArrayList<TimelineIntervalPair> pairs = new ArrayList<TimelineIntervalPair>(1);
        TimelineIntervalPair pair = new TimelineIntervalPair(this.interval.getPrimaryTimeline(), this.interval);
        pairs.add(pair);
        return pairs;
    }

    public String getResultDescription(ICuptiActivitySourceLevelResult result) {
        return result.getKind().name();
    }

    public abstract AnalysisResultSourceLevelKind getAnalysisResultSourceLevelKind();

    public Set<ICuptiActivitySourceLevelResult> getMarkerSourceLevelResults() {
        return Collections.emptySet();
    }

    public boolean hasOnlyNullResults() {
        for (ICuptiActivitySourceLevelResult result : this.results) {
            if (result.isNullResult()) continue;
            return false;
        }
        return true;
    }
}

