/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.repository.RepositoriesViewContentProvider;
import org.eclipse.egit.ui.internal.repository.tree.FileNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.WorkingDirNode;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.ILinkHelper;

public class LinkHelper
implements ILinkHelper {
    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        try {
            FileNode node = (FileNode)aSelection.getFirstElement();
            File file = (File)node.getObject();
            IEditorReference[] iEditorReferenceArray = aPage.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference ref = iEditorReferenceArray[n2];
                IEditorPart part = ref.getEditor(false);
                if (part != null) {
                    IFile r;
                    IEditorInput input = part.getEditorInput();
                    if (input instanceof IFileEditorInput && (r = ((IFileEditorInput)input).getFile()).getLocation().toFile().equals(file)) {
                        aPage.activate((IWorkbenchPart)part);
                        return;
                    }
                    if (input instanceof IURIEditorInput && ((IURIEditorInput)input).getURI().equals(file.toURI())) {
                        aPage.activate((IWorkbenchPart)part);
                        return;
                    }
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
    }

    public IStructuredSelection findSelection(IEditorInput anInput) {
        if (!(anInput instanceof IURIEditorInput)) {
            return null;
        }
        URI uri = ((IURIEditorInput)anInput).getURI();
        if (!uri.getScheme().equals("file")) {
            return null;
        }
        File file = new File(uri.getPath());
        if (!file.exists()) {
            return null;
        }
        RepositoryUtil config = Activator.getDefault().getRepositoryUtil();
        List repos = config.getConfiguredRepositories();
        for (String repo : repos) {
            Repository repository;
            try {
                repository = FileRepositoryBuilder.create((File)new File(repo));
            }
            catch (IOException iOException) {
                continue;
            }
            if (repository.isBare() || !file.getPath().startsWith(repository.getWorkTree().getPath())) continue;
            RepositoriesViewContentProvider cp = new RepositoriesViewContentProvider();
            RepositoryNode repoNode = new RepositoryNode(null, repository);
            RepositoryTreeNode result = null;
            Object[] objectArray = cp.getChildren(repoNode);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (child instanceof WorkingDirNode) {
                    result = (WorkingDirNode)child;
                    break;
                }
                ++n2;
            }
            if (result == null) {
                return null;
            }
            Path remainingPath = new Path(file.getPath().substring(repository.getWorkTree().getPath().length()));
            String[] stringArray = remainingPath.segments();
            int n3 = stringArray.length;
            n = 0;
            while (n < n3) {
                String segment = stringArray[n];
                Object[] objectArray2 = cp.getChildren(result);
                int n4 = objectArray2.length;
                int n5 = 0;
                while (n5 < n4) {
                    RepositoryTreeNode fileNode;
                    Object child = objectArray2[n5];
                    try {
                        fileNode = (RepositoryTreeNode)child;
                    }
                    catch (ClassCastException classCastException) {
                        return null;
                    }
                    if (((File)fileNode.getObject()).getName().equals(segment)) {
                        result = fileNode;
                        break;
                    }
                    ++n5;
                }
                ++n;
            }
            return new StructuredSelection((Object)result);
        }
        return null;
    }
}

