/*
 * Decompiled with CFR 0.152.
 */
package amazon.fws.clicommando.processors.output;

import amazon.fws.clicommando.exceptions.ConfigurationErrorException;
import amazon.fws.clicommando.exceptions.InternalErrorException;
import amazon.fws.clicommando.processors.output.Printable;
import amazon.fws.clicommando.processors.output.PrintableTable;
import amazon.fws.clicommando.processors.output.PrintableValue;
import amazon.fws.clicommando.util.StringUtils;

public class PrintableRow
extends Printable {
    private PrintableTable parentTable;

    public PrintableRow(PrintableTable parentTable) {
        this.parentTable = parentTable;
    }

    public PrintableRow() {
        this(null);
    }

    public void addValue(String value) {
        this.addValue(new PrintableValue(value));
    }

    public void setParentTable(PrintableTable parentTable) {
        this.parentTable = parentTable;
    }

    public String print() {
        int i;
        if (this.parentTable == null) {
            throw new ConfigurationErrorException("You can't print() a row without a parent table");
        }
        StringBuilder ret = new StringBuilder();
        String tableName = this.parentTable.getOutDesc().getTableName();
        if (Printable.trimExcessTableNameWS) {
            tableName = tableName.trim();
        }
        if (StringUtils.notEmpty(tableName)) {
            ret.append(tableName + delimiter);
        }
        for (i = 0; i < this.getValues().size(); ++i) {
            Printable value = this.getValues().get(i);
            if (value instanceof PrintableTable) {
                PrintableTable table;
                if (ret.length() > 0 && i > 0 && this.getValues().get(i - 1) instanceof PrintableValue) {
                    ret.delete(ret.length() - delimiter.length(), ret.length());
                    ret.append("\n");
                }
                if ((table = (PrintableTable)value).getRows().size() <= 0) continue;
                ret.append(table.print());
                continue;
            }
            if (value instanceof PrintableValue) {
                if (!this.parentTable.getIsColumnUsedList().get(i).booleanValue()) continue;
                String col = ((PrintableValue)value).getValue();
                if (useWSPadding && i < this.getValues().size() - 1) {
                    int length = this.parentTable.getMaxSizeList().get(i);
                    ret.append(StringUtils.fixedLength(col, length));
                } else {
                    ret.append(col);
                }
                ret.append(delimiter);
                continue;
            }
            throw new InternalErrorException("The row doesn't know how to handle value type " + value.getClass().toString());
        }
        if (ret.length() > 0 && this.getValues().size() > 0 && this.getValues().get(i - 1) instanceof PrintableValue) {
            ret.delete(ret.length() - delimiter.length(), ret.length());
            ret.append("\n");
        }
        return ret.toString();
    }
}

