/* Generated by re2c */
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2015 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Zeev Suraski <zeev@zend.com>                                |
   |          Jani Taskinen <jani@php.net>                                |
   |          Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   +----------------------------------------------------------------------+
*/

/* $Id$ */

#include <errno.h>
#include "zend.h"
#include "zend_API.h"
#include "zend_globals.h"
#include <zend_ini_parser.h>
#include "zend_ini_scanner.h"

#ifdef YYDEBUG
#undef YYDEBUG
#endif

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_ini_scanner_defs.h"

#define YYCTYPE   unsigned char
/* allow the scanner to read one null byte after the end of the string (from ZEND_MMAP_AHEAD)
 * so that if will be able to terminate to match the current token (e.g. non-enclosed string) */
#define YYFILL(n) { if (YYCURSOR > YYLIMIT) return 0; }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do {	YYCURSOR = (unsigned char*)yytext + x; \
							yyleng   = (unsigned int)x; } while(0)

/* #define yymore()     goto yymore_restart */

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 6

#if ZEND_MMAP_AHEAD < (YYMAXFILL + 1)
# error ZEND_MMAP_AHEAD should be greater than YYMAXFILL
#endif


/* How it works (for the core ini directives):
 * ===========================================
 *
 * 1. Scanner scans file for tokens and passes them to parser.
 * 2. Parser parses the tokens and passes the name/value pairs to the callback
 *    function which stores them in the configuration hash table.
 * 3. Later REGISTER_INI_ENTRIES() is called which triggers the actual
 *    registering of ini entries and uses zend_get_configuration_directive()
 *    to fetch the previously stored name/value pair from configuration hash table
 *    and registers the static ini entries which match the name to the value
 *    into EG(ini_directives) hash table.
 * 4. PATH section entries are used per-request from down to top, each overriding
 *    previous if one exists. zend_alter_ini_entry() is called for each entry.
 *    Settings in PATH section are ZEND_INI_SYSTEM accessible and thus mimics the
 *    php_admin_* directives used within Apache httpd.conf when PHP is compiled as
 *    module for Apache.
 * 5. User defined ini files (like .htaccess for apache) are parsed for each request and
 *    stored in separate hash defined by SAPI.
 */

/* TODO: (ordered by importance :-)
 * ===============================================================================
 *
 *  - Separate constant lookup totally from plain strings (using CONSTANT pattern)
 *  - Add #if .. #else .. #endif and ==, !=, <, > , <=, >= operators
 *  - Add #include "some.ini"
 *  - Allow variables to refer to options also when using parse_ini_file()
 *
 */

/* Globals Macros */
#define SCNG	INI_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id ini_scanner_globals_id;
#else
ZEND_API zend_ini_scanner_globals ini_scanner_globals;
#endif

/* Eat leading whitespace */
#define EAT_LEADING_WHITESPACE()                     \
	while (yytext[0]) {                              \
		if (yytext[0] == ' ' || yytext[0] == '\t') { \
			SCNG(yy_text)++;                         \
			yyleng--;                                \
		} else {                                     \
			break;                                   \
		}                                            \
	}

/* Eat trailing whitespace + extra char */
#define EAT_TRAILING_WHITESPACE_EX(ch)              \
	while (yyleng > 0 && (                          \
		(ch != 'X' && yytext[yyleng - 1] ==  ch) || \
		yytext[yyleng - 1] == '\n' ||               \
		yytext[yyleng - 1] == '\r' ||               \
		yytext[yyleng - 1] == '\t' ||               \
		yytext[yyleng - 1] == ' ')                  \
	) {                                             \
		yyleng--;                                   \
	}

/* Eat trailing whitespace */
#define EAT_TRAILING_WHITESPACE()	EAT_TRAILING_WHITESPACE_EX('X')

#define zend_ini_copy_value(retval, str, len)	\
	ZVAL_NEW_STR(retval, zend_string_init(str, len, 1))


#define RETURN_TOKEN(type, str, len) {                       \
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_TYPED) {      \
		zend_ini_copy_typed_value(ini_lval, type, str, len); \
	} else {                                                 \
		zend_ini_copy_value(ini_lval, str, len);             \
	}                                                        \
	return type;                                             \
}

static inline int convert_to_number(zval *retval, const char *str, const int str_len)
{
	zend_uchar type;
	int overflow;
	zend_long lval;
	double dval;

	if ((type = is_numeric_string_ex(str, str_len, &lval, &dval, 0, &overflow)) != 0) {
		if (type == IS_LONG) {
			ZVAL_LONG(retval, lval);
			return SUCCESS;
		} else if (type == IS_DOUBLE && !overflow) {
			ZVAL_DOUBLE(retval, dval);
			return SUCCESS;
		}
	}

	return FAILURE;
}

static void zend_ini_copy_typed_value(zval *retval, const int type, const char *str, int len)
{
	switch (type) {
		case BOOL_FALSE:
		case BOOL_TRUE:
			ZVAL_BOOL(retval, type == BOOL_TRUE);
			break;

		case NULL_NULL:
			ZVAL_NULL(retval);
			break;

		case TC_NUMBER:
			if (convert_to_number(retval, str, len) == SUCCESS) {
				break;
			}
			/* intentional fall-through */
		default:
			zend_ini_copy_value(retval, str, len);
	}
}

static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len)
{
	YYCURSOR = (YYCTYPE*)str;
	SCNG(yy_start) = YYCURSOR;
	YYLIMIT  = YYCURSOR + len;
}

#define ini_filename SCNG(filename)

/* {{{ init_ini_scanner()
*/
static int init_ini_scanner(int scanner_mode, zend_file_handle *fh)
{
	/* Sanity check */
	if (scanner_mode != ZEND_INI_SCANNER_NORMAL && scanner_mode != ZEND_INI_SCANNER_RAW && scanner_mode != ZEND_INI_SCANNER_TYPED) {
		zend_error(E_WARNING, "Invalid scanner mode");
		return FAILURE;
	}

	SCNG(lineno) = 1;
	SCNG(scanner_mode) = scanner_mode;
	SCNG(yy_in) = fh;

	if (fh != NULL) {
		ini_filename = zend_strndup(fh->filename, strlen(fh->filename));
	} else {
		ini_filename = NULL;
	}

	zend_stack_init(&SCNG(state_stack), sizeof(int));
	BEGIN(INITIAL);

	return SUCCESS;
}
/* }}} */

/* {{{ shutdown_ini_scanner()
*/
void shutdown_ini_scanner(void)
{
	zend_stack_destroy(&SCNG(state_stack));
	if (ini_filename) {
		free(ini_filename);
	}
}
/* }}} */

/* {{{ zend_ini_scanner_get_lineno()
*/
int zend_ini_scanner_get_lineno(void)
{
	return SCNG(lineno);
}
/* }}} */

/* {{{ zend_ini_scanner_get_filename()
*/
char *zend_ini_scanner_get_filename(void)
{
	return ini_filename ? ini_filename : "Unknown";
}
/* }}} */

/* {{{ zend_ini_open_file_for_scanning()
*/
int zend_ini_open_file_for_scanning(zend_file_handle *fh, int scanner_mode)
{
	char *buf;
	size_t size;

	if (zend_stream_fixup(fh, &buf, &size) == FAILURE) {
		return FAILURE;
	}

	if (init_ini_scanner(scanner_mode, fh) == FAILURE) {
		zend_file_handle_dtor(fh);
		return FAILURE;
	}

	yy_scan_buffer(buf, (unsigned int)size);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_prepare_string_for_scanning()
*/
int zend_ini_prepare_string_for_scanning(char *str, int scanner_mode)
{
	int len = (int)strlen(str);

	if (init_ini_scanner(scanner_mode, NULL) == FAILURE) {
		return FAILURE;
	}

	yy_scan_buffer(str, len);

	return SUCCESS;
}
/* }}} */

/* {{{ zend_ini_escape_string()
 */
static void zend_ini_escape_string(zval *lval, char *str, int len, char quote_type)
{
	register char *s, *t;
	char *end;

	zend_ini_copy_value(lval, str, len);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(lval);
	end = s + Z_STRLEN_P(lval);

	while (s < end) {
		if (*s == '\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				continue;
			}
			switch (*s) {
				case '"':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					Z_STRLEN_P(lval)--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			SCNG(lineno)++;
		}
		s++;
	}
	*t = 0;
}
/* }}} */

int ini_lex(zval *ini_lval)
{
restart:
	SCNG(yy_text) = YYCURSOR;

/* yymore_restart: */
	/* detect EOF */
	if (YYCURSOR >= YYLIMIT) {
		if (YYSTATE == STATE(ST_VALUE) || YYSTATE == STATE(ST_RAW)) {
			BEGIN(INITIAL);
			return END_OF_LINE;
		}
		return 0;
	}

	/* Eat any UTF-8 BOM we find in the first 3 bytes */
	if (YYCURSOR == SCNG(yy_start) && YYCURSOR + 3 < YYLIMIT) {
		if (memcmp(YYCURSOR, "\xef\xbb\xbf", 3) == 0) {
			YYCURSOR += 3;
			goto restart;
		}
	}

{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static void *yyctable[8] = {
		&&yyc_INITIAL,
		&&yyc_ST_OFFSET,
		&&yyc_ST_SECTION_VALUE,
		&&yyc_ST_VALUE,
		&&yyc_ST_SECTION_RAW,
		&&yyc_ST_DOUBLE_QUOTES,
		&&yyc_ST_VARNAME,
		&&yyc_ST_RAW,
	};
	goto *yyctable[YYGETCONDITION()];
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 160,   0, 144, 144,   0, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			240, 128, 128, 144, 128, 144, 128, 144, 
			128, 128, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 128, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 144, 144, 128, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 128, 128, 128, 128, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
			144, 144, 144, 144, 144, 144, 144, 144, 
		};
		YYDEBUG(1, *YYCURSOR);
		YYFILL(5);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy6,  &&yy9,  &&yy3,  &&yy3,  &&yy11, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy12, &&yy14, &&yy14, &&yy3,  &&yy14, &&yy3,  &&yy14, &&yy3,
				&&yy14, &&yy14, &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy16, &&yy3,  &&yy18, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy21, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy22, &&yy23,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy24, &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy25, &&yy3,  &&yy26, &&yy3,  &&yy3,  &&yy14, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy21, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy22, &&yy23,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy24, &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy25, &&yy3,  &&yy14, &&yy14, &&yy14, &&yy14, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3
			};
			goto *yytarget[yych];
		}
yy3:
		YYDEBUG(3, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy4:
		YYDEBUG(4, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy5,  &&yy5,  &&yy3,  &&yy3,  &&yy5,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy5,  &&yy5,  &&yy3,  &&yy5,  &&yy3,  &&yy5,  &&yy3,
				&&yy5,  &&yy5,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy5,  &&yy3,  &&yy5,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy28, &&yy3,  &&yy3,  &&yy5,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3
			};
			goto *yytarget[yych];
		}
yy5:
		YYDEBUG(5, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get option name */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_LABEL, yytext, yyleng);
}
yy6:
		YYDEBUG(6, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(7, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy6,  &&yy9,  &&yy8,  &&yy8,  &&yy11, &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy6,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy16, &&yy8,  &&yy18, &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,
				&&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8,  &&yy8
			};
			goto *yytarget[yych];
		}
yy8:
		YYDEBUG(8, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* eat whitespace */
	goto restart;
}
yy9:
		YYDEBUG(9, *YYCURSOR);
		++YYCURSOR;
yy10:
		YYDEBUG(10, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy11:
		YYDEBUG(11, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy9;
		goto yy10;
yy12:
		YYDEBUG(12, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(13, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy6,  &&yy9,  &&yy3,  &&yy3,  &&yy11, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy12, &&yy5,  &&yy5,  &&yy3,  &&yy5,  &&yy3,  &&yy5,  &&yy3,
				&&yy5,  &&yy5,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy16, &&yy3,  &&yy18, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy28, &&yy3,  &&yy3,  &&yy5,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy5,  &&yy5,  &&yy5,  &&yy5,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3
			};
			goto *yytarget[yych];
		}
yy14:
		YYDEBUG(14, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(15, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Disallow these chars outside option values */
	return yytext[0];
}
yy16:
		YYDEBUG(16, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(17, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy16;
		}
		if (yych <= '\n') goto yy31;
		goto yy33;
yy18:
		YYDEBUG(18, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(19, *YYCURSOR);
		if (yych == '\t') goto yy18;
		if (yych == ' ') goto yy18;
		YYDEBUG(20, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Start option value */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		yy_push_state(ST_RAW);
	} else {
		yy_push_state(ST_VALUE);
	}
	return '=';
}
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy34;
		if (yych == 'a') goto yy34;
		goto yy4;
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy35,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy37, &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy35,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy37, &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4
			};
			goto *yytarget[yych];
		}
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy38, &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy39, &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy38, &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy39, &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4
			};
			goto *yytarget[yych];
		}
yy24:
		YYDEBUG(24, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy42;
		if (yych == 'r') goto yy42;
		goto yy4;
yy25:
		YYDEBUG(25, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy43;
		if (yych == 'e') goto yy43;
		goto yy4;
yy26:
		YYDEBUG(26, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(27, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Section start */
	/* Enter section data lookup state */
	if (SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW) {
		yy_push_state(ST_SECTION_RAW);
	} else {
		yy_push_state(ST_SECTION_VALUE);
	}
	return TC_SECTION;
}
yy28:
		YYDEBUG(28, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(29, *YYCURSOR);
		if (yych == '\t') goto yy28;
		if (yych == ' ') goto yy28;
		YYDEBUG(30, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Start of option with offset */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace and [ */
	EAT_TRAILING_WHITESPACE_EX('[');

	/* Enter offset lookup state */
	yy_push_state(ST_OFFSET);

	RETURN_TOKEN(TC_OFFSET, yytext, yyleng);
}
yy31:
		YYDEBUG(31, *YYCURSOR);
		++YYCURSOR;
yy32:
		YYDEBUG(32, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy33:
		YYDEBUG(33, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy31;
		goto yy32;
yy34:
		YYDEBUG(34, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy44;
		if (yych == 'l') goto yy44;
		goto yy4;
yy35:
		YYDEBUG(35, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy45, &&yy36, &&yy4,  &&yy4,  &&yy36, &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy47, &&yy36, &&yy36, &&yy4,  &&yy36, &&yy4,  &&yy36, &&yy4,
				&&yy36, &&yy36, &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy36, &&yy4,  &&yy36, &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy49, &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy36, &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy49, &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy36, &&yy36, &&yy36, &&yy36, &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,
				&&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4,  &&yy4
			};
			goto *yytarget[yych];
		}
yy36:
		YYDEBUG(36, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
yy37:
		YYDEBUG(37, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy50;
		if (yych == 'l') goto yy50;
		goto yy4;
yy38:
		YYDEBUG(38, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy47;
		if (yych == 'f') goto yy47;
		goto yy4;
yy39:
		YYDEBUG(39, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(40, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy51, &&yy41, &&yy3,  &&yy3,  &&yy41, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy39, &&yy41, &&yy41, &&yy3,  &&yy41, &&yy3,  &&yy41, &&yy3,
				&&yy41, &&yy41, &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy41, &&yy3,  &&yy41, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy28, &&yy3,  &&yy3,  &&yy41, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy41, &&yy41, &&yy41, &&yy41, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3
			};
			goto *yytarget[yych];
		}
yy41:
		YYDEBUG(41, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
yy42:
		YYDEBUG(42, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy53;
		if (yych == 'u') goto yy53;
		goto yy4;
yy43:
		YYDEBUG(43, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy39;
		if (yych == 's') goto yy39;
		goto yy4;
yy44:
		YYDEBUG(44, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy49;
		if (yych == 's') goto yy49;
		goto yy4;
yy45:
		YYDEBUG(45, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(46, *YYCURSOR);
		if (yych == '\t') goto yy45;
		if (yych == ' ') goto yy45;
		goto yy36;
yy47:
		YYDEBUG(47, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(48, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy45, &&yy36, &&yy3,  &&yy3,  &&yy36, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy47, &&yy36, &&yy36, &&yy3,  &&yy36, &&yy3,  &&yy36, &&yy3,
				&&yy36, &&yy36, &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy36, &&yy3,  &&yy36, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy28, &&yy3,  &&yy3,  &&yy36, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy36, &&yy36, &&yy36, &&yy36, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3
			};
			goto *yytarget[yych];
		}
yy49:
		YYDEBUG(49, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy47;
		if (yych == 'e') goto yy47;
		goto yy4;
yy50:
		YYDEBUG(50, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy54;
		if (yych == 'l') goto yy54;
		goto yy4;
yy51:
		YYDEBUG(51, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(52, *YYCURSOR);
		if (yych == '\t') goto yy51;
		if (yych == ' ') goto yy51;
		goto yy41;
yy53:
		YYDEBUG(53, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy39;
		if (yych == 'e') goto yy39;
		goto yy4;
yy54:
		YYDEBUG(54, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(55, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy57, &&yy56, &&yy3,  &&yy3,  &&yy56, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy54, &&yy56, &&yy56, &&yy3,  &&yy56, &&yy3,  &&yy56, &&yy3,
				&&yy56, &&yy56, &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy56, &&yy3,  &&yy56, &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy28, &&yy3,  &&yy3,  &&yy56, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy56, &&yy56, &&yy56, &&yy56, &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3
			};
			goto *yytarget[yych];
		}
yy56:
		YYDEBUG(56, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(NULL_NULL, "", 0);
}
yy57:
		YYDEBUG(57, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(58, *YYCURSOR);
		if (yych == '\t') goto yy57;
		if (yych == ' ') goto yy57;
		goto yy56;
	}
/* *********************************** */
yyc_ST_OFFSET:
	{
		static const unsigned char yybm[] = {
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 140, 128, 132, 132, 128, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			140, 132, 128, 132, 192, 132, 132,   0, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			180, 180, 180, 180, 180, 180, 180, 180, 
			180, 180, 132, 128, 132, 132, 132, 132, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 192, 128, 132, 164, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
		};
		YYDEBUG(59, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy64, &&yy66, &&yy61, &&yy61, &&yy66, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy64, &&yy61, &&yy68, &&yy61, &&yy70, &&yy61, &&yy61, &&yy71,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy72, &&yy72, &&yy61,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy61, &&yy66, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76,
				&&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76,
				&&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76,
				&&yy76, &&yy76, &&yy76, &&yy61, &&yy79, &&yy80, &&yy61, &&yy76,
				&&yy61, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76,
				&&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76,
				&&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76,
				&&yy76, &&yy76, &&yy76, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61
			};
			goto *yytarget[yych];
		}
yy61:
		YYDEBUG(61, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy62:
		YYDEBUG(62, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy61;
		}
		if (yych <= '"') goto yy63;
		if (yych <= '$') goto yy82;
		if (yych <= ';') goto yy63;
		if (yych <= '\\') goto yy79;
yy63:
		YYDEBUG(63, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
yy64:
		YYDEBUG(64, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(65, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy64, &&yy63, &&yy61, &&yy61, &&yy63, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy64, &&yy61, &&yy68, &&yy61, &&yy82, &&yy61, &&yy61, &&yy63,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy63, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy79, &&yy80, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61
			};
			goto *yytarget[yych];
		}
yy66:
		YYDEBUG(66, *YYCURSOR);
		++YYCURSOR;
yy67:
		YYDEBUG(67, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy68:
		YYDEBUG(68, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(69, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
yy70:
		YYDEBUG(70, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy67;
			if (yych <= '[') goto yy61;
			goto yy84;
		} else {
			if (yych == '{') goto yy86;
			goto yy61;
		}
yy71:
		YYDEBUG(71, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy88;
		}
		goto yy67;
yy72:
		YYDEBUG(72, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy62;
		if (yych <= '9') goto yy90;
		goto yy62;
yy73:
		YYDEBUG(73, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(74, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy75, &&yy61, &&yy61, &&yy75, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy75, &&yy61, &&yy82, &&yy61, &&yy61, &&yy75,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy90, &&yy61,
				&&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73, &&yy73,
				&&yy73, &&yy73, &&yy61, &&yy75, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy79, &&yy75, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61
			};
			goto *yytarget[yych];
		}
yy75:
		YYDEBUG(75, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
yy76:
		YYDEBUG(76, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(77, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy78, &&yy61, &&yy61, &&yy78, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy78, &&yy61, &&yy82, &&yy61, &&yy61, &&yy78,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76,
				&&yy76, &&yy76, &&yy61, &&yy78, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76,
				&&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76,
				&&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76,
				&&yy76, &&yy76, &&yy76, &&yy61, &&yy79, &&yy78, &&yy61, &&yy76,
				&&yy61, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76,
				&&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76,
				&&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76, &&yy76,
				&&yy76, &&yy76, &&yy76, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61
			};
			goto *yytarget[yych];
		}
yy78:
		YYDEBUG(78, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
yy79:
		YYDEBUG(79, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy61;
yy80:
		YYDEBUG(80, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(81, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of section or an option offset */
	BEGIN(INITIAL);
	return ']';
}
yy82:
		YYDEBUG(82, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy83;
			if (yych <= '[') goto yy61;
			goto yy84;
		} else {
			if (yych != '{') goto yy61;
		}
yy83:
		YYDEBUG(83, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy63;
			} else {
				goto yy75;
			}
		} else {
			goto yy78;
		}
yy84:
		YYDEBUG(84, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(85, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy84;
		}
		goto yy61;
yy86:
		YYDEBUG(86, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(87, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
yy88:
		YYDEBUG(88, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(89, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy88;
		}
		goto yy92;
yy90:
		YYDEBUG(90, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(91, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy75, &&yy61, &&yy61, &&yy75, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy75, &&yy61, &&yy82, &&yy61, &&yy61, &&yy75,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy90, &&yy90, &&yy90, &&yy90, &&yy90, &&yy90, &&yy90, &&yy90,
				&&yy90, &&yy90, &&yy61, &&yy75, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy79, &&yy75, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61,
				&&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61, &&yy61
			};
			goto *yytarget[yych];
		}
yy92:
		YYDEBUG(92, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(93, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
	}
/* *********************************** */
yyc_ST_SECTION_VALUE:
	{
		static const unsigned char yybm[] = {
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 140, 128, 132, 132, 128, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			140, 132, 128, 132, 192, 132, 132,   0, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			180, 180, 180, 180, 180, 180, 180, 180, 
			180, 180, 132, 128, 132, 132, 132, 132, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 192, 128, 132, 164, 
			132, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 164, 164, 164, 164, 164, 
			164, 164, 164, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
			132, 132, 132, 132, 132, 132, 132, 132, 
		};
		YYDEBUG(94, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy99,  &&yy101, &&yy96,  &&yy96,  &&yy101, &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy99,  &&yy96,  &&yy103, &&yy96,  &&yy105, &&yy96,  &&yy96,  &&yy106,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy107, &&yy107, &&yy96,
				&&yy108, &&yy108, &&yy108, &&yy108, &&yy108, &&yy108, &&yy108, &&yy108,
				&&yy108, &&yy108, &&yy96,  &&yy101, &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy96,  &&yy114, &&yy115, &&yy96,  &&yy111,
				&&yy96,  &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96
			};
			goto *yytarget[yych];
		}
yy96:
		YYDEBUG(96, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy97:
		YYDEBUG(97, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy96;
		}
		if (yych <= '"') goto yy98;
		if (yych <= '$') goto yy118;
		if (yych <= ';') goto yy98;
		if (yych <= '\\') goto yy114;
yy98:
		YYDEBUG(98, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get rest as section/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
yy99:
		YYDEBUG(99, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(100, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy99,  &&yy98,  &&yy96,  &&yy96,  &&yy98,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy99,  &&yy96,  &&yy103, &&yy96,  &&yy118, &&yy96,  &&yy96,  &&yy98,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy98,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy114, &&yy98,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96
			};
			goto *yytarget[yych];
		}
yy101:
		YYDEBUG(101, *YYCURSOR);
		++YYCURSOR;
yy102:
		YYDEBUG(102, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy103:
		YYDEBUG(103, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(104, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
yy105:
		YYDEBUG(105, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy102;
			if (yych <= '[') goto yy96;
			goto yy120;
		} else {
			if (yych == '{') goto yy122;
			goto yy96;
		}
yy106:
		YYDEBUG(106, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy124;
		}
		goto yy102;
yy107:
		YYDEBUG(107, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy97;
		if (yych <= '9') goto yy126;
		goto yy97;
yy108:
		YYDEBUG(108, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(109, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy110, &&yy96,  &&yy96,  &&yy110, &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy110, &&yy96,  &&yy118, &&yy96,  &&yy96,  &&yy110,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy126, &&yy96,
				&&yy108, &&yy108, &&yy108, &&yy108, &&yy108, &&yy108, &&yy108, &&yy108,
				&&yy108, &&yy108, &&yy96,  &&yy110, &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy114, &&yy110, &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96
			};
			goto *yytarget[yych];
		}
yy110:
		YYDEBUG(110, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
yy111:
		YYDEBUG(111, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(112, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy113, &&yy96,  &&yy96,  &&yy113, &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy113, &&yy96,  &&yy118, &&yy96,  &&yy96,  &&yy113,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy96,  &&yy113, &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy96,  &&yy114, &&yy113, &&yy96,  &&yy111,
				&&yy96,  &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111, &&yy111,
				&&yy111, &&yy111, &&yy111, &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96
			};
			goto *yytarget[yych];
		}
yy113:
		YYDEBUG(113, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
yy114:
		YYDEBUG(114, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		goto yy96;
yy115:
		YYDEBUG(115, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(116, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy117;
			if (yych <= '\t') goto yy115;
			if (yych <= '\n') goto yy128;
		} else {
			if (yych <= '\r') goto yy129;
			if (yych == ' ') goto yy115;
		}
yy117:
		YYDEBUG(117, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
yy118:
		YYDEBUG(118, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy119;
			if (yych <= '[') goto yy96;
			goto yy120;
		} else {
			if (yych != '{') goto yy96;
		}
yy119:
		YYDEBUG(119, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 1) {
			if (yyaccept == 0) {
				goto yy98;
			} else {
				goto yy110;
			}
		} else {
			goto yy113;
		}
yy120:
		YYDEBUG(120, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(121, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy120;
		}
		goto yy96;
yy122:
		YYDEBUG(122, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(123, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
yy124:
		YYDEBUG(124, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(125, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy124;
		}
		goto yy130;
yy126:
		YYDEBUG(126, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(127, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy110, &&yy96,  &&yy96,  &&yy110, &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy110, &&yy96,  &&yy118, &&yy96,  &&yy96,  &&yy110,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy126, &&yy126, &&yy126, &&yy126, &&yy126, &&yy126, &&yy126, &&yy126,
				&&yy126, &&yy126, &&yy96,  &&yy110, &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy114, &&yy110, &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,
				&&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96,  &&yy96
			};
			goto *yytarget[yych];
		}
yy128:
		YYDEBUG(128, *YYCURSOR);
		++YYCURSOR;
		goto yy117;
yy129:
		YYDEBUG(129, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy128;
		goto yy117;
yy130:
		YYDEBUG(130, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(131, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
	}
/* *********************************** */
yyc_ST_VALUE:
	{
		static const unsigned char yybm[] = {
			 80,  82,  82,  82,  82,  82,  82,  82, 
			 82,  84,  64,  82,  82,  64,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 84,  80,  80,  82, 208,  82,  80,  16, 
			 80,  80,  82,  82,  82,  82,  82,  82, 
			122, 122, 122, 122, 122, 122, 122, 122, 
			122, 122,  82,  80,  82,  80,  82,  82, 
			 82, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114,  82,  82,  82,  80, 114, 
			 82, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114, 114, 114, 114, 114, 114, 
			114, 114, 114,  82,  80,  82,  80,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
			 82,  82,  82,  82,  82,  82,  82,  82, 
		};
		YYDEBUG(132, *YYCURSOR);
		YYFILL(6);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy134, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy139, &&yy142, &&yy136, &&yy136, &&yy144, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy139, &&yy145, &&yy148, &&yy136, &&yy150, &&yy136, &&yy145, &&yy151,
				&&yy145, &&yy145, &&yy136, &&yy136, &&yy136, &&yy152, &&yy152, &&yy136,
				&&yy153, &&yy153, &&yy153, &&yy153, &&yy153, &&yy153, &&yy153, &&yy153,
				&&yy153, &&yy153, &&yy136, &&yy156, &&yy136, &&yy158, &&yy136, &&yy136,
				&&yy136, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy163, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy164, &&yy165,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy166, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy167, &&yy160, &&yy136, &&yy136, &&yy136, &&yy145, &&yy160,
				&&yy136, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy163, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy164, &&yy165,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy166, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy167, &&yy160, &&yy136, &&yy145, &&yy136, &&yy145, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136
			};
			goto *yytarget[yych];
		}
yy134:
		YYDEBUG(134, *YYCURSOR);
		++YYCURSOR;
yy135:
		YYDEBUG(135, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
yy136:
		YYDEBUG(136, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy137:
		YYDEBUG(137, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy138, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy138, &&yy138, &&yy136, &&yy136, &&yy138, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy138, &&yy138, &&yy138, &&yy136, &&yy168, &&yy136, &&yy138, &&yy138,
				&&yy138, &&yy138, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy138, &&yy136, &&yy138, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy138, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy138, &&yy136, &&yy138, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136
			};
			goto *yytarget[yych];
		}
yy138:
		YYDEBUG(138, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get everything else as option/offset value */
	RETURN_TOKEN(TC_STRING, yytext, yyleng);
}
yy139:
		YYDEBUG(139, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(140, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy139, &&yy142, &&yy141, &&yy141, &&yy144, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy139, &&yy141, &&yy148, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy156, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141,
				&&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141, &&yy141
			};
			goto *yytarget[yych];
		}
yy141:
		YYDEBUG(141, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(TC_WHITESPACE, yytext, yyleng);
}
yy142:
		YYDEBUG(142, *YYCURSOR);
		++YYCURSOR;
yy143:
		YYDEBUG(143, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy144:
		YYDEBUG(144, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy142;
		goto yy143;
yy145:
		YYDEBUG(145, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(146, *YYCURSOR);
		if (yych == '\t') goto yy145;
		if (yych == ' ') goto yy145;
		YYDEBUG(147, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Boolean operators */
	return yytext[0];
}
yy148:
		YYDEBUG(148, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(149, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string start */
	yy_push_state(ST_DOUBLE_QUOTES);
	return '"';
}
yy150:
		YYDEBUG(150, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy135;
			if (yych <= '[') goto yy136;
			goto yy170;
		} else {
			if (yych == '{') goto yy171;
			goto yy136;
		}
yy151:
		YYDEBUG(151, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy173;
		}
		goto yy135;
yy152:
		YYDEBUG(152, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') goto yy137;
		if (yych <= '9') goto yy175;
		goto yy137;
yy153:
		YYDEBUG(153, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(154, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy155, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy155, &&yy155, &&yy136, &&yy136, &&yy155, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy155, &&yy155, &&yy155, &&yy136, &&yy168, &&yy136, &&yy155, &&yy155,
				&&yy155, &&yy155, &&yy136, &&yy136, &&yy136, &&yy136, &&yy175, &&yy136,
				&&yy153, &&yy153, &&yy153, &&yy153, &&yy153, &&yy153, &&yy153, &&yy153,
				&&yy153, &&yy153, &&yy136, &&yy155, &&yy136, &&yy155, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy155, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy155, &&yy136, &&yy155, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136
			};
			goto *yytarget[yych];
		}
yy155:
		YYDEBUG(155, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get number option value as string */
	RETURN_TOKEN(TC_NUMBER, yytext, yyleng);
}
yy156:
		YYDEBUG(156, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(157, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy156;
		}
		if (yych <= '\n') goto yy177;
		goto yy179;
yy158:
		YYDEBUG(158, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(159, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Make = used in option value to trigger error */
	yyless(0);
	BEGIN(INITIAL);
	return END_OF_LINE;
}
yy160:
		YYDEBUG(160, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(161, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy162, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy162, &&yy162, &&yy136, &&yy136, &&yy162, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy162, &&yy162, &&yy162, &&yy136, &&yy168, &&yy136, &&yy162, &&yy162,
				&&yy162, &&yy162, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy136, &&yy162, &&yy136, &&yy162, &&yy136, &&yy136,
				&&yy136, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy136, &&yy136, &&yy136, &&yy162, &&yy160,
				&&yy136, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy136, &&yy162, &&yy136, &&yy162, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136
			};
			goto *yytarget[yych];
		}
yy162:
		YYDEBUG(162, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Get constant option value */
	RETURN_TOKEN(TC_CONSTANT, yytext, yyleng);
}
yy163:
		YYDEBUG(163, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy162, &&yy162, &&yy137, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy162, &&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy162, &&yy162,
				&&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy180, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy137, &&yy137, &&yy162, &&yy160,
				&&yy137, &&yy180, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137
			};
			goto *yytarget[yych];
		}
yy164:
		YYDEBUG(164, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy162, &&yy162, &&yy137, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy162, &&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy162, &&yy162,
				&&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy181,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy183, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy137, &&yy137, &&yy162, &&yy160,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy181,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy183, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137
			};
			goto *yytarget[yych];
		}
yy165:
		YYDEBUG(165, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy162, &&yy162, &&yy137, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy162, &&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy162, &&yy162,
				&&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy184, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy185, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy137, &&yy137, &&yy162, &&yy160,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy184, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy185, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137
			};
			goto *yytarget[yych];
		}
yy166:
		YYDEBUG(166, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy162, &&yy162, &&yy137, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy162, &&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy162, &&yy162,
				&&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy187, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy137, &&yy137, &&yy162, &&yy160,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy187, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137
			};
			goto *yytarget[yych];
		}
yy167:
		YYDEBUG(167, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy162, &&yy162, &&yy137, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy162, &&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy162, &&yy162,
				&&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy188, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy137, &&yy137, &&yy162, &&yy160,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy188, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137
			};
			goto *yytarget[yych];
		}
yy168:
		YYDEBUG(168, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= 0x00) goto yy169;
			if (yych <= '[') goto yy136;
			goto yy170;
		} else {
			if (yych != '{') goto yy136;
		}
yy169:
		YYDEBUG(169, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 2) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy138;
				} else {
					goto yy155;
				}
			} else {
				goto yy162;
			}
		} else {
			if (yyaccept <= 4) {
				if (yyaccept == 3) {
					goto yy182;
				} else {
					goto yy186;
				}
			} else {
				goto yy203;
			}
		}
yy170:
		YYDEBUG(170, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy189;
		}
		goto yy136;
yy171:
		YYDEBUG(171, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(172, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
yy173:
		YYDEBUG(173, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(174, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy173;
		}
		goto yy191;
yy175:
		YYDEBUG(175, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(176, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy155, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy155, &&yy155, &&yy136, &&yy136, &&yy155, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy155, &&yy155, &&yy155, &&yy136, &&yy168, &&yy136, &&yy155, &&yy155,
				&&yy155, &&yy155, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175, &&yy175,
				&&yy175, &&yy175, &&yy136, &&yy155, &&yy136, &&yy155, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy155, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy155, &&yy136, &&yy155, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136,
				&&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136, &&yy136
			};
			goto *yytarget[yych];
		}
yy177:
		YYDEBUG(177, *YYCURSOR);
		++YYCURSOR;
yy178:
		YYDEBUG(178, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy179:
		YYDEBUG(179, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy177;
		goto yy178;
yy180:
		YYDEBUG(180, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy162, &&yy162, &&yy137, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy162, &&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy162, &&yy162,
				&&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy193, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy137, &&yy137, &&yy162, &&yy160,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy193, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137
			};
			goto *yytarget[yych];
		}
yy181:
		YYDEBUG(181, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy182, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy194, &&yy182, &&yy137, &&yy137, &&yy182, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy194, &&yy182, &&yy182, &&yy137, &&yy137, &&yy137, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy137, &&yy182, &&yy137, &&yy182, &&yy137, &&yy137,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy196, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy137, &&yy137, &&yy182, &&yy160,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy196, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy182, &&yy137, &&yy182, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137
			};
			goto *yytarget[yych];
		}
yy182:
		YYDEBUG(182, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* FALSE value (when used outside option value/offset this causes parse error!)*/
	RETURN_TOKEN(BOOL_FALSE, "", 0);
}
yy183:
		YYDEBUG(183, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy162, &&yy162, &&yy137, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy162, &&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy162, &&yy162,
				&&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy197, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy137, &&yy137, &&yy162, &&yy160,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy197, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137
			};
			goto *yytarget[yych];
		}
yy184:
		YYDEBUG(184, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy162, &&yy162, &&yy137, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy162, &&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy162, &&yy162,
				&&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy198, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy137, &&yy137, &&yy162, &&yy160,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy198, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137
			};
			goto *yytarget[yych];
		}
yy185:
		YYDEBUG(185, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy186, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy199, &&yy186, &&yy137, &&yy137, &&yy186, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy199, &&yy186, &&yy186, &&yy137, &&yy137, &&yy137, &&yy186, &&yy186,
				&&yy186, &&yy186, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy137, &&yy186, &&yy137, &&yy186, &&yy137, &&yy137,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy137, &&yy137, &&yy186, &&yy160,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy186, &&yy137, &&yy186, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137
			};
			goto *yytarget[yych];
		}
yy186:
		YYDEBUG(186, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* TRUE value (when used outside option value/offset this causes parse error!) */
	RETURN_TOKEN(BOOL_TRUE, "1", 1);
}
yy187:
		YYDEBUG(187, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy162, &&yy162, &&yy137, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy162, &&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy162, &&yy162,
				&&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy201, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy137, &&yy137, &&yy162, &&yy160,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy201, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137
			};
			goto *yytarget[yych];
		}
yy188:
		YYDEBUG(188, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy162, &&yy162, &&yy137, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy162, &&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy162, &&yy162,
				&&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy185, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy137, &&yy137, &&yy162, &&yy160,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy185, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137
			};
			goto *yytarget[yych];
		}
yy189:
		YYDEBUG(189, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(190, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy189;
		}
		if (yych <= 0x00) goto yy138;
		if (yych == '\\') goto yy170;
		goto yy136;
yy191:
		YYDEBUG(191, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(192, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw string */
	/* Eat leading and trailing single quotes */
	if (yytext[0] == '\'' && yytext[yyleng - 1] == '\'') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
yy193:
		YYDEBUG(193, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy162, &&yy162, &&yy137, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy162, &&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy162, &&yy162,
				&&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy196, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy137, &&yy137, &&yy162, &&yy160,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy196, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137
			};
			goto *yytarget[yych];
		}
yy194:
		YYDEBUG(194, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(195, *YYCURSOR);
		if (yych == '\t') goto yy194;
		if (yych == ' ') goto yy194;
		goto yy182;
yy196:
		YYDEBUG(196, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy162, &&yy162, &&yy137, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy162, &&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy162, &&yy162,
				&&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy198, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy137, &&yy137, &&yy162, &&yy160,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy198, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137
			};
			goto *yytarget[yych];
		}
yy197:
		YYDEBUG(197, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy162, &&yy162, &&yy137, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy162, &&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy162, &&yy162,
				&&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy202, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy137, &&yy137, &&yy162, &&yy160,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy202, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137
			};
			goto *yytarget[yych];
		}
yy198:
		YYDEBUG(198, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy182, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy194, &&yy182, &&yy137, &&yy137, &&yy182, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy194, &&yy182, &&yy182, &&yy137, &&yy137, &&yy137, &&yy182, &&yy182,
				&&yy182, &&yy182, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy137, &&yy182, &&yy137, &&yy182, &&yy137, &&yy137,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy137, &&yy137, &&yy182, &&yy160,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy182, &&yy137, &&yy182, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137
			};
			goto *yytarget[yych];
		}
yy199:
		YYDEBUG(199, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(200, *YYCURSOR);
		if (yych == '\t') goto yy199;
		if (yych == ' ') goto yy199;
		goto yy186;
yy201:
		YYDEBUG(201, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy162, &&yy162, &&yy137, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy162, &&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy162, &&yy162,
				&&yy162, &&yy162, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137, &&yy137,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy185, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy137, &&yy137, &&yy162, &&yy160,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy185, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy162, &&yy137, &&yy162, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137
			};
			goto *yytarget[yych];
		}
yy202:
		YYDEBUG(202, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy203, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy204, &&yy203, &&yy137, &&yy137, &&yy203, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy204, &&yy203, &&yy203, &&yy137, &&yy137, &&yy137, &&yy203, &&yy203,
				&&yy203, &&yy203, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy137, &&yy203, &&yy137, &&yy203, &&yy137, &&yy137,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy137, &&yy137, &&yy203, &&yy160,
				&&yy137, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160, &&yy160,
				&&yy160, &&yy160, &&yy160, &&yy137, &&yy203, &&yy137, &&yy203, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137,
				&&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137, &&yy137
			};
			goto *yytarget[yych];
		}
yy203:
		YYDEBUG(203, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(NULL_NULL, "", 0);
}
yy204:
		YYDEBUG(204, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(205, *YYCURSOR);
		if (yych == '\t') goto yy204;
		if (yych == ' ') goto yy204;
		goto yy203;
	}
/* *********************************** */
yyc_ST_SECTION_RAW:
	{
		static const unsigned char yybm[] = {
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64, 192,   0,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			192,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(206, *YYCURSOR);
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy208;
		}
		if (yych <= '\r') goto yy211;
		goto yy213;
yy208:
		YYDEBUG(208, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(209, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy208;
		}
		YYDEBUG(210, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
yy211:
		YYDEBUG(211, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(212, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy213:
		YYDEBUG(213, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(214, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy213;
		}
		if (yych <= 0x08) goto yy215;
		if (yych <= '\n') goto yy216;
		if (yych == '\r') goto yy217;
yy215:
		YYDEBUG(215, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of section */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return ']';
}
yy216:
		YYDEBUG(216, *YYCURSOR);
		++YYCURSOR;
		goto yy215;
yy217:
		YYDEBUG(217, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy216;
		goto yy215;
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		YYDEBUG(218, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '"') goto yy222;
		if (yych == '$') goto yy225;
		YYDEBUG(220, *YYCURSOR);
		++YYCURSOR;
yy221:
		YYDEBUG(221, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Escape double quoted string contents */
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				if (YYCURSOR < YYLIMIT && YYCURSOR[-2] == '\\' && *YYCURSOR != '\r' && *YYCURSOR != '\n') {
					continue;
				}
				break;
			case '$':
				if (*YYCURSOR == '{') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '"') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	zend_ini_escape_string(ini_lval, yytext, yyleng, '"');
	return TC_QUOTED_STRING;
}
yy222:
		YYDEBUG(222, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(223, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy222;
		}
		YYDEBUG(224, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Double quoted '"' string ends */
	yy_pop_state();
	return '"';
}
yy225:
		YYDEBUG(225, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '{') goto yy221;
		YYDEBUG(226, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(227, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable start */
	yy_push_state(ST_VARNAME);
	return TC_DOLLAR_CURLY;
}
	}
/* *********************************** */
yyc_ST_VARNAME:
	{
		YYDEBUG(228, *YYCURSOR);
		YYFILL(1);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy233, &&yy233, &&yy230, &&yy230, &&yy233, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy233, &&yy233, &&yy230, &&yy233, &&yy230, &&yy233, &&yy230,
				&&yy233, &&yy233, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy233, &&yy230, &&yy233, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy233, &&yy230, &&yy230, &&yy233, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy233, &&yy233, &&yy235, &&yy233, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230
			};
			goto *yytarget[yych];
		}
yy230:
		YYDEBUG(230, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(231, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy232, &&yy232, &&yy230, &&yy230, &&yy232, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy232, &&yy232, &&yy230, &&yy232, &&yy230, &&yy232, &&yy230,
				&&yy232, &&yy232, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy232, &&yy230, &&yy232, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy232, &&yy230, &&yy230, &&yy232, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy232, &&yy232, &&yy232, &&yy232, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230,
				&&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230, &&yy230
			};
			goto *yytarget[yych];
		}
yy232:
		YYDEBUG(232, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable name */
	/* Eat leading whitespace */
	EAT_LEADING_WHITESPACE();

	/* Eat trailing whitespace */
	EAT_TRAILING_WHITESPACE();

	RETURN_TOKEN(TC_VARNAME, yytext, yyleng);
}
yy233:
		YYDEBUG(233, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(234, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return 0;
}
yy235:
		YYDEBUG(235, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(236, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Variable end */
	yy_pop_state();
	return '}';
}
	}
/* *********************************** */
yyc_ST_RAW:
	{
		static const unsigned char yybm[] = {
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64, 192,   0,  64,  64,   0,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			192,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(237, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy239, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy243, &&yy244, &&yy241, &&yy241, &&yy246, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy243, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy247, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241,
				&&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241, &&yy241
			};
			goto *yytarget[yych];
		}
yy239:
		YYDEBUG(239, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(240, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value (if EOF is reached before EOL */
	BEGIN(INITIAL);
	return END_OF_LINE;
}
yy241:
		YYDEBUG(241, *YYCURSOR);
		++YYCURSOR;
yy242:
		YYDEBUG(242, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Raw value, only used when SCNG(scanner_mode) == ZEND_INI_SCANNER_RAW. */
	unsigned char *sc = NULL;
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR) {
			case '\n':
			case '\r':
				goto end_raw_value_chars;
				break;
			case ';':
				if (sc == NULL) {
					sc = YYCURSOR;
				}
				/* no break */
			default:
				YYCURSOR++;
				break;
		}
	}
end_raw_value_chars:
	yyleng = YYCURSOR - SCNG(yy_text);

	/* Eat trailing semicolons */
	while (yytext[yyleng - 1] == ';') {
		yyleng--;
	}

	/* Eat leading and trailing double quotes */
	if (yytext[0] == '"' && yytext[yyleng - 1] == '"') {
		SCNG(yy_text)++;
		yyleng = yyleng - 2;
	} else if (sc) {
		YYCURSOR = sc;
		yyleng = YYCURSOR - SCNG(yy_text);
	}
	RETURN_TOKEN(TC_RAW, yytext, yyleng);
}
yy243:
		YYDEBUG(243, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy250, &&yy250, &&yy242, &&yy242, &&yy250, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy250, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy250, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242,
				&&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242, &&yy242
			};
			goto *yytarget[yych];
		}
yy244:
		YYDEBUG(244, *YYCURSOR);
		++YYCURSOR;
yy245:
		YYDEBUG(245, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* End of option value */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy246:
		YYDEBUG(246, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy244;
		goto yy245;
yy247:
		YYDEBUG(247, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(248, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy247;
		}
		if (yych <= '\n') goto yy252;
		goto yy254;
yy249:
		YYDEBUG(249, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy250:
		YYDEBUG(250, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy249;
		}
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy251;
			if (yych <= '\n') goto yy244;
		} else {
			if (yych <= '\r') goto yy246;
			if (yych == ';') goto yy247;
		}
yy251:
		YYDEBUG(251, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* eat whitespace */
	goto restart;
}
yy252:
		YYDEBUG(252, *YYCURSOR);
		++YYCURSOR;
yy253:
		YYDEBUG(253, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Comment */
	BEGIN(INITIAL);
	SCNG(lineno)++;
	return END_OF_LINE;
}
yy254:
		YYDEBUG(254, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy252;
		goto yy253;
	}
}

}
re2c: warning: line 384: column 13: escape has no effect: '\.' [-Wuseless-escape]
re2c: warning: line 384: column 32: escape has no effect: '\.' [-Wuseless-escape]
re2c: warning: line 391: column 27: escape has no effect: '\[' [-Wuseless-escape]
re2c: warning: line 392: column 11: escape has no effect: '\[' [-Wuseless-escape]
re2c: warning: line 648: unreachable rule in condition 'INITIAL' (shadowed by rules at lines 406, 481, 491, 555, 627, 632, 637) [-Wunreachable-rules]
re2c: warning: line 623: unreachable rule in condition 'ST_OFFSET' (shadowed by rule at line 573) [-Wunreachable-rules]
re2c: warning: line 623: unreachable rule in condition 'ST_SECTION_VALUE' (shadowed by rule at line 573) [-Wunreachable-rules]
re2c: warning: line 648: unreachable rule in condition 'ST_VALUE' (shadowed by rules at lines 541, 547, 551, 559, 563, 569, 577, 623, 643) [-Wunreachable-rules]
re2c: warning: line 648: unreachable rule in condition 'ST_DOUBLE_QUOTES' (shadowed by rules at lines 582, 587) [-Wunreachable-rules]
re2c: warning: line 648: unreachable rule in condition 'ST_RAW' (shadowed by rules at lines 500, 541, 643) [-Wunreachable-rules]
re2c: warning: line 652: looks like you use hardcoded numbers instead of autogenerated condition names: better add '/*!types:re2c*/' directive or '-t, --type-header' option and don't rely on fixed condition order. [-Wcondition-order]
