/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the libgltf project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#include "types.h"

namespace libgltf
{

glTFFile::glTFFile()
    : type(GLTF_NONE)
    , filename()
    , buffer(0)
    , size(0)
    , imageheight(0)
    , imagewidth(0)
{
}

glTFFile::glTFFile(const glTFFile& copy)
    : type(copy.type)
    , filename(copy.filename)
    , buffer(copy.buffer)
    , size(copy.size)
    , imageheight(copy.imageheight)
    , imagewidth(copy.imagewidth)
{
}

glTFFile& glTFFile::operator=(const glTFFile& copy)
{
    if(this != &copy)
    {
        type = copy.type;
        filename = copy.filename;
        buffer = copy.buffer;
        size = copy.size;
        imageheight = copy.imageheight;
        imagewidth = copy.imagewidth;
    }
    return *this;
}

} // namespace libgltf

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
