/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#include <librevenge/librevenge.h>

#include "FB2MetadataCollector.h"

namespace libebook
{

FB2MetadataCollector::FB2MetadataCollector(librevenge::RVNGPropertyList &metadata)
  : m_metadata(metadata)
{
}

void FB2MetadataCollector::defineMetadataEntry(const char *name, const char *value)
{
  m_metadata.insert(name, librevenge::RVNGString(value));
}

void FB2MetadataCollector::openMetadataEntry(const char *name)
{
  (void) name;
}

void FB2MetadataCollector::closeMetadataEntry()
{
}

void FB2MetadataCollector::defineID(const char *)
{
}

void FB2MetadataCollector::openPageSpan()
{
}

void FB2MetadataCollector::closePageSpan()
{
}

void FB2MetadataCollector::openBlock()
{
}

void FB2MetadataCollector::closeBlock()
{
}

void FB2MetadataCollector::openParagraph(const FB2BlockFormat &)
{
}

void FB2MetadataCollector::closeParagraph()
{
}

void FB2MetadataCollector::openSpan(const FB2Style &)
{
}

void FB2MetadataCollector::closeSpan()
{
}

void FB2MetadataCollector::insertText(const char *text)
{
  (void) text;
}

void FB2MetadataCollector::openTable(const FB2BlockFormat &)
{
}

void FB2MetadataCollector::closeTable()
{
}

void FB2MetadataCollector::openTableRow(const FB2BlockFormat &)
{
}

void FB2MetadataCollector::closeTableRow()
{
}

void FB2MetadataCollector::openTableCell(int, int)
{
}

void FB2MetadataCollector::closeTableCell()
{
}

void FB2MetadataCollector::insertCoveredTableCell()
{
}

void FB2MetadataCollector::insertFootnote(const char *)
{
}

void FB2MetadataCollector::insertBitmap(const char *)
{
}

void FB2MetadataCollector::insertBitmapData(const char *, const char *)
{
}

}

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
