// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --function-signature --include-generated-funcs --replace-value-regex "__omp_offloading_[0-9a-z]+_[0-9a-z]+" "reduction_size[.].+[.]" "pl_cond[.].+[.|,]" --prefix-filecheck-ir-name _
// RUN: %clang_cc1 -verify -Wno-vla -fopenmp -fnoopenmp-use-tls -x c++ -std=c++11 -triple x86_64-unknown-unknown -emit-llvm %s -fexceptions -fcxx-exceptions -o - | FileCheck %s --check-prefix=CHECK1
// RUN: %clang_cc1 -verify -Wno-vla -fopenmp -fopenmp-version=45 -fnoopenmp-use-tls -x c++ -std=c++11 -triple x86_64-unknown-unknown -emit-llvm %s -fexceptions -fcxx-exceptions -o - | FileCheck %s --check-prefix=CHECK2

// RUN: %clang_cc1 -fopenmp -fnoopenmp-use-tls -x c++ -std=c++11 -triple x86_64-unknown-unknown -fexceptions -fcxx-exceptions -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp -fnoopenmp-use-tls -x c++ -triple x86_64-unknown-unknown -fexceptions -fcxx-exceptions -std=c++11 -include-pch %t -verify -Wno-vla %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK1

// RUN: %clang_cc1 -fopenmp -fopenmp-version=45 -fnoopenmp-use-tls -x c++ -std=c++11 -triple x86_64-unknown-unknown -fexceptions -fcxx-exceptions -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp -fopenmp-version=45 -fnoopenmp-use-tls -x c++ -triple x86_64-unknown-unknown -fexceptions -fcxx-exceptions -std=c++11 -include-pch %t -verify -Wno-vla %s -emit-llvm -o - | FileCheck %s --check-prefix=CHECK4

// RUN: %clang_cc1 -verify -Wno-vla -triple x86_64-apple-darwin10 -std=c++11 -fopenmp -fnoopenmp-use-tls -fexceptions -fcxx-exceptions -debug-info-kind=line-tables-only -x c++ -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK5
// RUN: %clang_cc1 -verify -Wno-vla -fopenmp -fnoopenmp-use-tls -x c++ -std=c++11 -DARRAY -triple x86_64-apple-darwin10 -emit-llvm %s -o - | FileCheck %s --check-prefix=CHECK6

// RUN: %clang_cc1 -verify -Wno-vla -fopenmp-simd -fnoopenmp-use-tls -x c++ -std=c++11 -triple x86_64-unknown-unknown -emit-llvm %s -fexceptions -fcxx-exceptions -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -fopenmp-simd -fnoopenmp-use-tls -x c++ -std=c++11 -triple x86_64-unknown-unknown -fexceptions -fcxx-exceptions -emit-pch -o %t %s
// RUN: %clang_cc1 -fopenmp-simd -fnoopenmp-use-tls -x c++ -triple x86_64-unknown-unknown -fexceptions -fcxx-exceptions -std=c++11 -include-pch %t -verify %s -emit-llvm -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -verify -Wno-vla -triple x86_64-apple-darwin10 -std=c++11 -fopenmp-simd -fnoopenmp-use-tls -fexceptions -fcxx-exceptions -debug-info-kind=line-tables-only -x c++ -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// RUN: %clang_cc1 -verify -Wno-vla -fopenmp-simd -fnoopenmp-use-tls -x c++ -std=c++11 -DARRAY -triple x86_64-apple-darwin10 -emit-llvm %s -o - | FileCheck %s --implicit-check-not="{{__kmpc|__tgt}}"
// expected-no-diagnostics
#ifndef ARRAY
#ifndef HEADER
#define HEADER

class TestClass {
public:
  int a;
  TestClass() : a(0) {}
  TestClass(const TestClass &C) : a(C.a) {}
  TestClass &operator=(const TestClass &) { return *this;}
  ~TestClass(){};
};



TestClass tc;
TestClass tc2[2];
#pragma omp threadprivate(tc, tc2)

void foo() { extern void mayThrow(); mayThrow(); }

struct SS {
  int a;
  int b : 4;
  int &c;
  SS(int &d) : a(0), b(0), c(d) {
#pragma omp parallel firstprivate(a, b, c)
#pragma omp single copyprivate(a, this->b, (this)->c)
    [&]() {
      ++this->a, --b, (this)->c /= 1;
#pragma omp parallel firstprivate(a, b, c)
#pragma omp single copyprivate(a, this->b, (this)->c)
      ++(this)->a, --b, this->c /= 1;
    }();
  }
};

template<typename T>
struct SST {
  T a;
  SST() : a(T()) {
#pragma omp parallel firstprivate(a)
#pragma omp single copyprivate(this->a)
    [&]() {
      [&]() {
        ++this->a;
#pragma omp parallel firstprivate(a)
#pragma omp single copyprivate((this)->a)
        ++(this)->a;
      }();
    }();
  }
};

int main() {
  char a;
  char a2[2];
  TestClass &c = tc;
  SST<double> sst;
  SS ss(c.a);

#pragma omp single nowait
  a = 2;
#pragma omp single
  a = 2;
#pragma omp single copyprivate(a, c, tc, a2, tc2)
  foo();
  return a;
}


void parallel_single() {
#pragma omp parallel
#pragma omp single
  foo();
}
#endif
#else
struct St {
  int a, b;
  St() : a(0), b(0) {}
  St &operator=(const St &) { return *this; };
  ~St() {}
};

void array_func(int n, int a[n], St s[2]) {
#pragma omp single copyprivate(a, s)
  ;
}
#endif
// CHECK1-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_.
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    call void @_ZN9TestClassC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TMP1]])
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    ret ptr [[TMP2]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN9TestClassC1Ev
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    call void @_ZN9TestClassC2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_.
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    call void @_ZN9TestClassD1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TMP1]]) #[[ATTR3:[0-9]+]]
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN9TestClassD1Ev
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2:[0-9]+]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    call void @_ZN9TestClassD2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR3]]
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.__omp_threadprivate_init_.
// CHECK1-SAME: () #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1:[0-9]+]])
// CHECK1-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB1]], ptr @tc, ptr @.__kmpc_global_ctor_., ptr null, ptr @.__kmpc_global_dtor_.)
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_..1
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] personality ptr @__gxx_personality_v0 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %class.TestClass], ptr [[TMP1]], i32 0, i32 0
// CHECK1-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[CLASS_TESTCLASS:%.*]], ptr [[ARRAY_BEGIN]], i64 2
// CHECK1-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK1:       arrayctor.loop:
// CHECK1-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi ptr [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[INVOKE_CONT:%.*]] ]
// CHECK1-NEXT:    invoke void @_ZN9TestClassC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK1-NEXT:    to label [[INVOKE_CONT]] unwind label [[LPAD:%.*]]
// CHECK1:       invoke.cont:
// CHECK1-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[CLASS_TESTCLASS]], ptr [[ARRAYCTOR_CUR]], i64 1
// CHECK1-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq ptr [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK1-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK1:       arrayctor.cont:
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    ret ptr [[TMP2]]
// CHECK1:       lpad:
// CHECK1-NEXT:    [[TMP3:%.*]] = landingpad { ptr, i32 }
// CHECK1-NEXT:    cleanup
// CHECK1-NEXT:    [[TMP4:%.*]] = extractvalue { ptr, i32 } [[TMP3]], 0
// CHECK1-NEXT:    store ptr [[TMP4]], ptr [[EXN_SLOT]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = extractvalue { ptr, i32 } [[TMP3]], 1
// CHECK1-NEXT:    store i32 [[TMP5]], ptr [[EHSELECTOR_SLOT]], align 4
// CHECK1-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr [[ARRAY_BEGIN]], [[ARRAYCTOR_CUR]]
// CHECK1-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY:%.*]]
// CHECK1:       arraydestroy.body:
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[ARRAYCTOR_CUR]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[CLASS_TESTCLASS]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK1-NEXT:    call void @_ZN9TestClassD1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// CHECK1-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK1-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1]], label [[ARRAYDESTROY_BODY]]
// CHECK1:       arraydestroy.done1:
// CHECK1-NEXT:    br label [[EH_RESUME:%.*]]
// CHECK1:       eh.resume:
// CHECK1-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8
// CHECK1-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4
// CHECK1-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0
// CHECK1-NEXT:    [[LPAD_VAL2:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1
// CHECK1-NEXT:    resume { ptr, i32 } [[LPAD_VAL2]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_..2
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[CLASS_TESTCLASS:%.*]], ptr [[TMP1]], i64 2
// CHECK1-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK1:       arraydestroy.body:
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP2]], [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[CLASS_TESTCLASS]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK1-NEXT:    call void @_ZN9TestClassD1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// CHECK1-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[TMP1]]
// CHECK1-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK1:       arraydestroy.done1:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.__omp_threadprivate_init_..3
// CHECK1-SAME: () #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK1-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB1]], ptr @tc2, ptr @.__kmpc_global_ctor_..1, ptr null, ptr @.__kmpc_global_dtor_..2)
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@__cxx_global_var_init
// CHECK1-SAME: () #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void @_ZN9TestClassC1Ev(ptr noundef nonnull align 4 dereferenceable(4) @tc)
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @_ZN9TestClassD1Ev, ptr @tc, ptr @__dso_handle) #[[ATTR3]]
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@__cxx_global_var_init.4
// CHECK1-SAME: () #[[ATTR0]] personality ptr @__gxx_personality_v0 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK1:       arrayctor.loop:
// CHECK1-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi ptr [ @tc2, [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[INVOKE_CONT:%.*]] ]
// CHECK1-NEXT:    invoke void @_ZN9TestClassC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK1-NEXT:    to label [[INVOKE_CONT]] unwind label [[LPAD:%.*]]
// CHECK1:       invoke.cont:
// CHECK1-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[CLASS_TESTCLASS:%.*]], ptr [[ARRAYCTOR_CUR]], i64 1
// CHECK1-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq ptr [[ARRAYCTOR_NEXT]], getelementptr inbounds ([[CLASS_TESTCLASS]], ptr @tc2, i64 2)
// CHECK1-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK1:       arrayctor.cont:
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @__cxx_global_array_dtor, ptr null, ptr @__dso_handle) #[[ATTR3]]
// CHECK1-NEXT:    ret void
// CHECK1:       lpad:
// CHECK1-NEXT:    [[TMP1:%.*]] = landingpad { ptr, i32 }
// CHECK1-NEXT:    cleanup
// CHECK1-NEXT:    [[TMP2:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 0
// CHECK1-NEXT:    store ptr [[TMP2]], ptr [[EXN_SLOT]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 1
// CHECK1-NEXT:    store i32 [[TMP3]], ptr [[EHSELECTOR_SLOT]], align 4
// CHECK1-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr @tc2, [[ARRAYCTOR_CUR]]
// CHECK1-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY:%.*]]
// CHECK1:       arraydestroy.body:
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[ARRAYCTOR_CUR]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[CLASS_TESTCLASS]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK1-NEXT:    call void @_ZN9TestClassD1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// CHECK1-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @tc2
// CHECK1-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1]], label [[ARRAYDESTROY_BODY]]
// CHECK1:       arraydestroy.done1:
// CHECK1-NEXT:    br label [[EH_RESUME:%.*]]
// CHECK1:       eh.resume:
// CHECK1-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8
// CHECK1-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4
// CHECK1-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0
// CHECK1-NEXT:    [[LPAD_VAL2:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1
// CHECK1-NEXT:    resume { ptr, i32 } [[LPAD_VAL2]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@__cxx_global_array_dtor
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK1:       arraydestroy.body:
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ getelementptr inbounds ([[CLASS_TESTCLASS:%.*]], ptr @tc2, i64 2), [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK1-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[CLASS_TESTCLASS]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK1-NEXT:    call void @_ZN9TestClassD1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// CHECK1-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @tc2
// CHECK1-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK1:       arraydestroy.done1:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN9TestClassC2Ev
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[A:%.*]] = getelementptr inbounds [[CLASS_TESTCLASS:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    store i32 0, ptr [[A]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN9TestClassD2Ev
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z3foov
// CHECK1-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void @_Z8mayThrowv()
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@main
// CHECK1-SAME: () #[[ATTR6:[0-9]+]] personality ptr @__gxx_personality_v0 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[A:%.*]] = alloca i8, align 1
// CHECK1-NEXT:    [[A2:%.*]] = alloca [2 x i8], align 1
// CHECK1-NEXT:    [[C:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[SST:%.*]] = alloca [[STRUCT_SST:%.*]], align 8
// CHECK1-NEXT:    [[SS:%.*]] = alloca [[STRUCT_SS:%.*]], align 8
// CHECK1-NEXT:    [[DOTOMP_COPYPRIVATE_DID_IT:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COPYPRIVATE_CPR_LIST:%.*]] = alloca [5 x ptr], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK1-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK1-NEXT:    store ptr @tc, ptr [[C]], align 8
// CHECK1-NEXT:    call void @_ZN3SSTIdEC1Ev(ptr noundef nonnull align 8 dereferenceable(8) [[SST]])
// CHECK1-NEXT:    call void @_ZN2SSC1ERi(ptr noundef nonnull align 8 dereferenceable(16) [[SS]], ptr noundef nonnull align 4 dereferenceable(4) @tc)
// CHECK1-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK1-NEXT:    [[TMP2:%.*]] = icmp ne i32 [[TMP1]], 0
// CHECK1-NEXT:    br i1 [[TMP2]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    store i8 2, ptr [[A]], align 1
// CHECK1-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK1-NEXT:    [[TMP4:%.*]] = icmp ne i32 [[TMP3]], 0
// CHECK1-NEXT:    br i1 [[TMP4]], label [[OMP_IF_THEN1:%.*]], label [[OMP_IF_END2:%.*]]
// CHECK1:       omp_if.then1:
// CHECK1-NEXT:    store i8 2, ptr [[A]], align 1
// CHECK1-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK1-NEXT:    br label [[OMP_IF_END2]]
// CHECK1:       omp_if.end2:
// CHECK1-NEXT:    call void @__kmpc_barrier(ptr @[[GLOB2:[0-9]+]], i32 [[TMP0]])
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK1-NEXT:    [[TMP6:%.*]] = icmp ne i32 [[TMP5]], 0
// CHECK1-NEXT:    br i1 [[TMP6]], label [[OMP_IF_THEN3:%.*]], label [[OMP_IF_END4:%.*]]
// CHECK1:       omp_if.then3:
// CHECK1-NEXT:    invoke void @_Z3foov()
// CHECK1-NEXT:    to label [[INVOKE_CONT:%.*]] unwind label [[TERMINATE_LPAD:%.*]]
// CHECK1:       invoke.cont:
// CHECK1-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK1-NEXT:    br label [[OMP_IF_END4]]
// CHECK1:       omp_if.end4:
// CHECK1-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 0
// CHECK1-NEXT:    store ptr [[A]], ptr [[TMP7]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 1
// CHECK1-NEXT:    store ptr @tc, ptr [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 2
// CHECK1-NEXT:    [[TMP10:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @tc, i64 4, ptr @tc.cache.)
// CHECK1-NEXT:    store ptr [[TMP10]], ptr [[TMP9]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 3
// CHECK1-NEXT:    store ptr [[A2]], ptr [[TMP11]], align 8
// CHECK1-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 4
// CHECK1-NEXT:    [[TMP13:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @tc2, i64 8, ptr @tc2.cache.)
// CHECK1-NEXT:    store ptr [[TMP13]], ptr [[TMP12]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK1-NEXT:    call void @__kmpc_copyprivate(ptr @[[GLOB1]], i32 [[TMP0]], i64 40, ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], ptr @.omp.copyprivate.copy_func, i32 [[TMP14]])
// CHECK1-NEXT:    [[TMP15:%.*]] = load i8, ptr [[A]], align 1
// CHECK1-NEXT:    [[CONV:%.*]] = sext i8 [[TMP15]] to i32
// CHECK1-NEXT:    ret i32 [[CONV]]
// CHECK1:       terminate.lpad:
// CHECK1-NEXT:    [[TMP16:%.*]] = landingpad { ptr, i32 }
// CHECK1-NEXT:    catch ptr null
// CHECK1-NEXT:    [[TMP17:%.*]] = extractvalue { ptr, i32 } [[TMP16]], 0
// CHECK1-NEXT:    call void @__clang_call_terminate(ptr [[TMP17]]) #[[ATTR13:[0-9]+]]
// CHECK1-NEXT:    unreachable
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN3SSTIdEC1Ev
// CHECK1-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    call void @_ZN3SSTIdEC2Ev(ptr noundef nonnull align 8 dereferenceable(8) [[THIS1]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN2SSC1ERi
// CHECK1-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[D:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[D_ADDR]], align 8
// CHECK1-NEXT:    call void @_ZN2SSC2ERi(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP0]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@__clang_call_terminate
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR8:[0-9]+]] comdat {
// CHECK1-NEXT:    [[TMP2:%.*]] = call ptr @__cxa_begin_catch(ptr [[TMP0]]) #[[ATTR3]]
// CHECK1-NEXT:    call void @_ZSt9terminatev() #[[ATTR13]]
// CHECK1-NEXT:    unreachable
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp.copyprivate.copy_func
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR9:[0-9]+]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load i8, ptr [[TMP7]], align 1
// CHECK1-NEXT:    store i8 [[TMP8]], ptr [[TMP5]], align 1
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP2]], i64 0, i64 1
// CHECK1-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[TMP9]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP3]], i64 0, i64 1
// CHECK1-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP11]], align 8
// CHECK1-NEXT:    [[CALL:%.*]] = call noundef nonnull align 4 dereferenceable(4) ptr @_ZN9TestClassaSERKS_(ptr noundef nonnull align 4 dereferenceable(4) [[TMP10]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP12]])
// CHECK1-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP2]], i64 0, i64 2
// CHECK1-NEXT:    [[TMP14:%.*]] = load ptr, ptr [[TMP13]], align 8
// CHECK1-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP3]], i64 0, i64 2
// CHECK1-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[TMP15]], align 8
// CHECK1-NEXT:    [[CALL2:%.*]] = call noundef nonnull align 4 dereferenceable(4) ptr @_ZN9TestClassaSERKS_(ptr noundef nonnull align 4 dereferenceable(4) [[TMP14]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP16]])
// CHECK1-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP2]], i64 0, i64 3
// CHECK1-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[TMP17]], align 8
// CHECK1-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP3]], i64 0, i64 3
// CHECK1-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[TMP19]], align 8
// CHECK1-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 1 [[TMP18]], ptr align 1 [[TMP20]], i64 2, i1 false)
// CHECK1-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP2]], i64 0, i64 4
// CHECK1-NEXT:    [[TMP22:%.*]] = load ptr, ptr [[TMP21]], align 8
// CHECK1-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP3]], i64 0, i64 4
// CHECK1-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[TMP23]], align 8
// CHECK1-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [[CLASS_TESTCLASS:%.*]], ptr [[TMP22]], i64 2
// CHECK1-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq ptr [[TMP22]], [[TMP25]]
// CHECK1-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE4:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK1:       omp.arraycpy.body:
// CHECK1-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi ptr [ [[TMP24]], [[ENTRY:%.*]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK1-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi ptr [ [[TMP22]], [[ENTRY]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK1-NEXT:    [[CALL3:%.*]] = call noundef nonnull align 4 dereferenceable(4) ptr @_ZN9TestClassaSERKS_(ptr noundef nonnull align 4 dereferenceable(4) [[OMP_ARRAYCPY_DESTELEMENTPAST]], ptr noundef nonnull align 4 dereferenceable(4) [[OMP_ARRAYCPY_SRCELEMENTPAST]])
// CHECK1-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[CLASS_TESTCLASS]], ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK1-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[CLASS_TESTCLASS]], ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK1-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP25]]
// CHECK1-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE4]], label [[OMP_ARRAYCPY_BODY]]
// CHECK1:       omp.arraycpy.done4:
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN9TestClassaSERKS_
// CHECK1-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP0:%.*]]) #[[ATTR10:[0-9]+]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    ret ptr [[THIS1]]
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN3SSTIdEC2Ev
// CHECK1-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A2:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SST:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    store double 0.000000e+00, ptr [[A]], align 8
// CHECK1-NEXT:    [[A3:%.*]] = getelementptr inbounds [[STRUCT_SST]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    store ptr [[A3]], ptr [[A2]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[A2]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load double, ptr [[TMP0]], align 8
// CHECK1-NEXT:    store double [[TMP1]], ptr [[A_CASTED]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load i64, ptr [[A_CASTED]], align 8
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 2, ptr @_ZN3SSTIdEC2Ev.omp_outlined, ptr [[THIS1]], i64 [[TMP2]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN3SSTIdEC2Ev.omp_outlined
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], i64 noundef [[A:%.*]]) #[[ATTR12:[0-9]+]] personality ptr @__gxx_personality_v0 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTOMP_COPYPRIVATE_DID_IT:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON:%.*]], align 8
// CHECK1-NEXT:    [[DOTOMP_COPYPRIVATE_CPR_LIST:%.*]] = alloca [1 x ptr], align 8
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[A]], ptr [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[A_ADDR]], ptr [[TMP]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[_TMP1]], align 8
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK1-NEXT:    [[TMP5:%.*]] = icmp ne i32 [[TMP4]], 0
// CHECK1-NEXT:    br i1 [[TMP5]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[REF_TMP]], i32 0, i32 0
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[TMP6]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[REF_TMP]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK1-NEXT:    store ptr [[TMP8]], ptr [[TMP7]], align 8
// CHECK1-NEXT:    invoke void @_ZZN3SSTIdEC1EvENKUlvE_clEv(ptr noundef nonnull align 8 dereferenceable(16) [[REF_TMP]])
// CHECK1-NEXT:    to label [[INVOKE_CONT:%.*]] unwind label [[TERMINATE_LPAD:%.*]]
// CHECK1:       invoke.cont:
// CHECK1-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK1-NEXT:    store ptr [[TMP10]], ptr [[TMP9]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK1-NEXT:    call void @__kmpc_copyprivate(ptr @[[GLOB1]], i32 [[TMP3]], i64 8, ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], ptr @.omp.copyprivate.copy_func.5, i32 [[TMP11]])
// CHECK1-NEXT:    ret void
// CHECK1:       terminate.lpad:
// CHECK1-NEXT:    [[TMP12:%.*]] = landingpad { ptr, i32 }
// CHECK1-NEXT:    catch ptr null
// CHECK1-NEXT:    [[TMP13:%.*]] = extractvalue { ptr, i32 } [[TMP12]], 0
// CHECK1-NEXT:    call void @__clang_call_terminate(ptr [[TMP13]]) #[[ATTR13]]
// CHECK1-NEXT:    unreachable
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZZN3SSTIdEC1EvENKUlvE_clEv
// CHECK1-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) #[[ATTR4]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_0:%.*]], align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP0]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[REF_TMP]], i32 0, i32 0
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[TMP2]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[REF_TMP]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[THIS1]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK1-NEXT:    store ptr [[TMP5]], ptr [[TMP3]], align 8
// CHECK1-NEXT:    call void @_ZZZN3SSTIdEC1EvENKUlvE_clEvENKUlvE_clEv(ptr noundef nonnull align 8 dereferenceable(16) [[REF_TMP]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp.copyprivate.copy_func.5
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR9]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load double, ptr [[TMP7]], align 8
// CHECK1-NEXT:    store double [[TMP8]], ptr [[TMP5]], align 8
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZZZN3SSTIdEC1EvENKUlvE_clEvENKUlvE_clEv
// CHECK1-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) #[[ATTR10]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP0]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[THIS1]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP2]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load double, ptr [[TMP3]], align 8
// CHECK1-NEXT:    [[INC:%.*]] = fadd double [[TMP4]], 1.000000e+00
// CHECK1-NEXT:    store double [[INC]], ptr [[TMP3]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[THIS1]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[TMP5]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load double, ptr [[TMP6]], align 8
// CHECK1-NEXT:    store double [[TMP7]], ptr [[A_CASTED]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load i64, ptr [[A_CASTED]], align 8
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 2, ptr @_ZZZN3SSTIdEC1EvENKUlvE_clEvENKUlvE_clEv.omp_outlined, ptr [[TMP1]], i64 [[TMP8]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZZZN3SSTIdEC1EvENKUlvE_clEvENKUlvE_clEv.omp_outlined
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], i64 noundef [[A:%.*]]) #[[ATTR12]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTOMP_COPYPRIVATE_DID_IT:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COPYPRIVATE_CPR_LIST:%.*]] = alloca [1 x ptr], align 8
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[A]], ptr [[A_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[A_ADDR]], ptr [[TMP]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[_TMP1]], align 8
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK1-NEXT:    [[TMP5:%.*]] = icmp ne i32 [[TMP4]], 0
// CHECK1-NEXT:    br i1 [[TMP5]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load double, ptr [[TMP6]], align 8
// CHECK1-NEXT:    [[INC:%.*]] = fadd double [[TMP7]], 1.000000e+00
// CHECK1-NEXT:    store double [[INC]], ptr [[TMP6]], align 8
// CHECK1-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK1-NEXT:    store ptr [[TMP9]], ptr [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK1-NEXT:    call void @__kmpc_copyprivate(ptr @[[GLOB1]], i32 [[TMP3]], i64 8, ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], ptr @.omp.copyprivate.copy_func.6, i32 [[TMP10]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp.copyprivate.copy_func.6
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR9]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load double, ptr [[TMP7]], align 8
// CHECK1-NEXT:    store double [[TMP8]], ptr [[TMP5]], align 8
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN2SSC2ERi
// CHECK1-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[D:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A2:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[B4:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[C7:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[B_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[C_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    store i32 0, ptr [[A]], align 8
// CHECK1-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 1
// CHECK1-NEXT:    [[BF_LOAD:%.*]] = load i8, ptr [[B]], align 4
// CHECK1-NEXT:    [[BF_CLEAR:%.*]] = and i8 [[BF_LOAD]], -16
// CHECK1-NEXT:    [[BF_SET:%.*]] = or i8 [[BF_CLEAR]], 0
// CHECK1-NEXT:    store i8 [[BF_SET]], ptr [[B]], align 4
// CHECK1-NEXT:    [[C:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[D_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[C]], align 8
// CHECK1-NEXT:    [[A3:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    store ptr [[A3]], ptr [[A2]], align 8
// CHECK1-NEXT:    [[B5:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 1
// CHECK1-NEXT:    [[BF_LOAD6:%.*]] = load i8, ptr [[B5]], align 4
// CHECK1-NEXT:    [[BF_SHL:%.*]] = shl i8 [[BF_LOAD6]], 4
// CHECK1-NEXT:    [[BF_ASHR:%.*]] = ashr i8 [[BF_SHL]], 4
// CHECK1-NEXT:    [[BF_CAST:%.*]] = sext i8 [[BF_ASHR]] to i32
// CHECK1-NEXT:    store i32 [[BF_CAST]], ptr [[B4]], align 4
// CHECK1-NEXT:    [[C8:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[C8]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[C7]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[A2]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4
// CHECK1-NEXT:    store i32 [[TMP3]], ptr [[A_CASTED]], align 4
// CHECK1-NEXT:    [[TMP4:%.*]] = load i64, ptr [[A_CASTED]], align 8
// CHECK1-NEXT:    [[TMP5:%.*]] = load i32, ptr [[B4]], align 4
// CHECK1-NEXT:    store i32 [[TMP5]], ptr [[B_CASTED]], align 4
// CHECK1-NEXT:    [[TMP6:%.*]] = load i64, ptr [[B_CASTED]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[C7]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP7]], align 4
// CHECK1-NEXT:    store i32 [[TMP8]], ptr [[C_CASTED]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i64, ptr [[C_CASTED]], align 8
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 4, ptr @_ZN2SSC2ERi.omp_outlined, ptr [[THIS1]], i64 [[TMP4]], i64 [[TMP6]], i64 [[TMP9]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZN2SSC2ERi.omp_outlined
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], i64 noundef [[A:%.*]], i64 noundef [[B:%.*]], i64 noundef [[C:%.*]]) #[[ATTR12]] personality ptr @__gxx_personality_v0 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[_TMP2:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[_TMP3:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTOMP_COPYPRIVATE_DID_IT:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_1:%.*]], align 8
// CHECK1-NEXT:    [[DOTOMP_COPYPRIVATE_CPR_LIST:%.*]] = alloca [3 x ptr], align 8
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[A]], ptr [[A_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[B]], ptr [[B_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[C]], ptr [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[A_ADDR]], ptr [[TMP]], align 8
// CHECK1-NEXT:    store ptr [[C_ADDR]], ptr [[_TMP1]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[_TMP2]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK1-NEXT:    store ptr [[TMP2]], ptr [[_TMP3]], align 8
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP3]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK1-NEXT:    [[TMP6:%.*]] = icmp ne i32 [[TMP5]], 0
// CHECK1-NEXT:    br i1 [[TMP6]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[REF_TMP]], i32 0, i32 0
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[TMP7]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[REF_TMP]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[_TMP2]], align 8
// CHECK1-NEXT:    store ptr [[TMP9]], ptr [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[REF_TMP]], i32 0, i32 2
// CHECK1-NEXT:    store ptr [[B_ADDR]], ptr [[TMP10]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[REF_TMP]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[_TMP3]], align 8
// CHECK1-NEXT:    store ptr [[TMP12]], ptr [[TMP11]], align 8
// CHECK1-NEXT:    invoke void @_ZZN2SSC1ERiENKUlvE_clEv(ptr noundef nonnull align 8 dereferenceable(32) [[REF_TMP]])
// CHECK1-NEXT:    to label [[INVOKE_CONT:%.*]] unwind label [[TERMINATE_LPAD:%.*]]
// CHECK1:       invoke.cont:
// CHECK1-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP14:%.*]] = load ptr, ptr [[_TMP2]], align 8
// CHECK1-NEXT:    store ptr [[TMP14]], ptr [[TMP13]], align 8
// CHECK1-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 1
// CHECK1-NEXT:    store ptr [[B_ADDR]], ptr [[TMP15]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 2
// CHECK1-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[_TMP3]], align 8
// CHECK1-NEXT:    store ptr [[TMP17]], ptr [[TMP16]], align 8
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK1-NEXT:    call void @__kmpc_copyprivate(ptr @[[GLOB1]], i32 [[TMP4]], i64 24, ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], ptr @.omp.copyprivate.copy_func.7, i32 [[TMP18]])
// CHECK1-NEXT:    ret void
// CHECK1:       terminate.lpad:
// CHECK1-NEXT:    [[TMP19:%.*]] = landingpad { ptr, i32 }
// CHECK1-NEXT:    catch ptr null
// CHECK1-NEXT:    [[TMP20:%.*]] = extractvalue { ptr, i32 } [[TMP19]], 0
// CHECK1-NEXT:    call void @__clang_call_terminate(ptr [[TMP20]]) #[[ATTR13]]
// CHECK1-NEXT:    unreachable
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZZN2SSC1ERiENKUlvE_clEv
// CHECK1-SAME: (ptr noundef nonnull align 8 dereferenceable(32) [[THIS:%.*]]) #[[ATTR10]] align 2 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[B_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[C_CASTED:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON_1:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP0]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[THIS1]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP2]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP3]], align 4
// CHECK1-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP4]], 1
// CHECK1-NEXT:    store i32 [[INC]], ptr [[TMP3]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[THIS1]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[TMP5]], align 8
// CHECK1-NEXT:    [[TMP7:%.*]] = load i32, ptr [[TMP6]], align 4
// CHECK1-NEXT:    [[DEC:%.*]] = add nsw i32 [[TMP7]], -1
// CHECK1-NEXT:    store i32 [[DEC]], ptr [[TMP6]], align 4
// CHECK1-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[THIS1]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[TMP8]], align 8
// CHECK1-NEXT:    [[TMP10:%.*]] = load i32, ptr [[TMP9]], align 4
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP10]], 1
// CHECK1-NEXT:    store i32 [[DIV]], ptr [[TMP9]], align 4
// CHECK1-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[THIS1]], i32 0, i32 1
// CHECK1-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP11]], align 8
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, ptr [[TMP12]], align 4
// CHECK1-NEXT:    store i32 [[TMP13]], ptr [[A_CASTED]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = load i64, ptr [[A_CASTED]], align 8
// CHECK1-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[THIS1]], i32 0, i32 2
// CHECK1-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[TMP15]], align 8
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, ptr [[TMP16]], align 4
// CHECK1-NEXT:    store i32 [[TMP17]], ptr [[B_CASTED]], align 4
// CHECK1-NEXT:    [[TMP18:%.*]] = load i64, ptr [[B_CASTED]], align 8
// CHECK1-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[THIS1]], i32 0, i32 3
// CHECK1-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[TMP19]], align 8
// CHECK1-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP20]], align 4
// CHECK1-NEXT:    store i32 [[TMP21]], ptr [[C_CASTED]], align 4
// CHECK1-NEXT:    [[TMP22:%.*]] = load i64, ptr [[C_CASTED]], align 8
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 4, ptr @_ZZN2SSC1ERiENKUlvE_clEv.omp_outlined, ptr [[TMP1]], i64 [[TMP14]], i64 [[TMP18]], i64 [[TMP22]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp.copyprivate.copy_func.7
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR9]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP7]], align 4
// CHECK1-NEXT:    store i32 [[TMP8]], ptr [[TMP5]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 1
// CHECK1-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[TMP9]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 1
// CHECK1-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP11]], align 8
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, ptr [[TMP12]], align 4
// CHECK1-NEXT:    store i32 [[TMP13]], ptr [[TMP10]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 2
// CHECK1-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[TMP14]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 2
// CHECK1-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[TMP16]], align 8
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, ptr [[TMP17]], align 4
// CHECK1-NEXT:    store i32 [[TMP18]], ptr [[TMP15]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_ZZN2SSC1ERiENKUlvE_clEv.omp_outlined
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], i64 noundef [[A:%.*]], i64 noundef [[B:%.*]], i64 noundef [[C:%.*]]) #[[ATTR12]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[C_ADDR:%.*]] = alloca i64, align 8
// CHECK1-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[_TMP2:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[_TMP3:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTOMP_COPYPRIVATE_DID_IT:%.*]] = alloca i32, align 4
// CHECK1-NEXT:    [[DOTOMP_COPYPRIVATE_CPR_LIST:%.*]] = alloca [3 x ptr], align 8
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[A]], ptr [[A_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[B]], ptr [[B_ADDR]], align 8
// CHECK1-NEXT:    store i64 [[C]], ptr [[C_ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK1-NEXT:    store ptr [[A_ADDR]], ptr [[TMP]], align 8
// CHECK1-NEXT:    store ptr [[C_ADDR]], ptr [[_TMP1]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[_TMP2]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK1-NEXT:    store ptr [[TMP2]], ptr [[_TMP3]], align 8
// CHECK1-NEXT:    store i32 0, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP3]], align 4
// CHECK1-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK1-NEXT:    [[TMP6:%.*]] = icmp ne i32 [[TMP5]], 0
// CHECK1-NEXT:    br i1 [[TMP6]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[_TMP2]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP7]], align 4
// CHECK1-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK1-NEXT:    store i32 [[INC]], ptr [[TMP7]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = load i32, ptr [[B_ADDR]], align 4
// CHECK1-NEXT:    [[DEC:%.*]] = add nsw i32 [[TMP9]], -1
// CHECK1-NEXT:    store i32 [[DEC]], ptr [[B_ADDR]], align 4
// CHECK1-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[_TMP3]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP10]], align 4
// CHECK1-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP11]], 1
// CHECK1-NEXT:    store i32 [[DIV]], ptr [[TMP10]], align 4
// CHECK1-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK1-NEXT:    store i32 1, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[_TMP2]], align 8
// CHECK1-NEXT:    store ptr [[TMP13]], ptr [[TMP12]], align 8
// CHECK1-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 1
// CHECK1-NEXT:    store ptr [[B_ADDR]], ptr [[TMP14]], align 8
// CHECK1-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 2
// CHECK1-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[_TMP3]], align 8
// CHECK1-NEXT:    store ptr [[TMP16]], ptr [[TMP15]], align 8
// CHECK1-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK1-NEXT:    call void @__kmpc_copyprivate(ptr @[[GLOB1]], i32 [[TMP4]], i64 24, ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], ptr @.omp.copyprivate.copy_func.8, i32 [[TMP17]])
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@.omp.copyprivate.copy_func.8
// CHECK1-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR9]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK1-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK1-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK1-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK1-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK1-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP7]], align 4
// CHECK1-NEXT:    store i32 [[TMP8]], ptr [[TMP5]], align 4
// CHECK1-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 1
// CHECK1-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[TMP9]], align 8
// CHECK1-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 1
// CHECK1-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP11]], align 8
// CHECK1-NEXT:    [[TMP13:%.*]] = load i32, ptr [[TMP12]], align 4
// CHECK1-NEXT:    store i32 [[TMP13]], ptr [[TMP10]], align 4
// CHECK1-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 2
// CHECK1-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[TMP14]], align 8
// CHECK1-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 2
// CHECK1-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[TMP16]], align 8
// CHECK1-NEXT:    [[TMP18:%.*]] = load i32, ptr [[TMP17]], align 4
// CHECK1-NEXT:    store i32 [[TMP18]], ptr [[TMP15]], align 4
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z15parallel_singlev
// CHECK1-SAME: () #[[ATTR10]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 0, ptr @_Z15parallel_singlev.omp_outlined)
// CHECK1-NEXT:    ret void
//
//
// CHECK1-LABEL: define {{[^@]+}}@_Z15parallel_singlev.omp_outlined
// CHECK1-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]]) #[[ATTR12]] personality ptr @__gxx_personality_v0 {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK1-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK1-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK1-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK1-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP2]], 0
// CHECK1-NEXT:    br i1 [[TMP3]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK1:       omp_if.then:
// CHECK1-NEXT:    invoke void @_Z3foov()
// CHECK1-NEXT:    to label [[INVOKE_CONT:%.*]] unwind label [[TERMINATE_LPAD:%.*]]
// CHECK1:       invoke.cont:
// CHECK1-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK1-NEXT:    br label [[OMP_IF_END]]
// CHECK1:       omp_if.end:
// CHECK1-NEXT:    call void @__kmpc_barrier(ptr @[[GLOB2]], i32 [[TMP1]])
// CHECK1-NEXT:    ret void
// CHECK1:       terminate.lpad:
// CHECK1-NEXT:    [[TMP4:%.*]] = landingpad { ptr, i32 }
// CHECK1-NEXT:    catch ptr null
// CHECK1-NEXT:    [[TMP5:%.*]] = extractvalue { ptr, i32 } [[TMP4]], 0
// CHECK1-NEXT:    call void @__clang_call_terminate(ptr [[TMP5]]) #[[ATTR13]]
// CHECK1-NEXT:    unreachable
//
//
// CHECK1-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_single_codegen.cpp
// CHECK1-SAME: () #[[ATTR0]] {
// CHECK1-NEXT:  entry:
// CHECK1-NEXT:    call void @__cxx_global_var_init()
// CHECK1-NEXT:    call void @__cxx_global_var_init.4()
// CHECK1-NEXT:    call void @.__omp_threadprivate_init_.()
// CHECK1-NEXT:    call void @.__omp_threadprivate_init_..3()
// CHECK1-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@__cxx_global_var_init
// CHECK2-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    call void @_ZN9TestClassC1Ev(ptr noundef nonnull align 4 dereferenceable(4) @tc)
// CHECK2-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @_ZN9TestClassD1Ev, ptr @tc, ptr @__dso_handle) #[[ATTR3:[0-9]+]]
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN9TestClassC1Ev
// CHECK2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    call void @_ZN9TestClassC2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN9TestClassD1Ev
// CHECK2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2:[0-9]+]] comdat align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    call void @_ZN9TestClassD2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR3]]
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@__cxx_global_var_init.1
// CHECK2-SAME: () #[[ATTR0]] personality ptr @__gxx_personality_v0 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK2:       arrayctor.loop:
// CHECK2-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi ptr [ @tc2, [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[INVOKE_CONT:%.*]] ]
// CHECK2-NEXT:    invoke void @_ZN9TestClassC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK2-NEXT:    to label [[INVOKE_CONT]] unwind label [[LPAD:%.*]]
// CHECK2:       invoke.cont:
// CHECK2-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[CLASS_TESTCLASS:%.*]], ptr [[ARRAYCTOR_CUR]], i64 1
// CHECK2-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq ptr [[ARRAYCTOR_NEXT]], getelementptr inbounds ([[CLASS_TESTCLASS]], ptr @tc2, i64 2)
// CHECK2-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK2:       arrayctor.cont:
// CHECK2-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @__cxx_global_array_dtor, ptr null, ptr @__dso_handle) #[[ATTR3]]
// CHECK2-NEXT:    ret void
// CHECK2:       lpad:
// CHECK2-NEXT:    [[TMP1:%.*]] = landingpad { ptr, i32 }
// CHECK2-NEXT:    cleanup
// CHECK2-NEXT:    [[TMP2:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 0
// CHECK2-NEXT:    store ptr [[TMP2]], ptr [[EXN_SLOT]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 1
// CHECK2-NEXT:    store i32 [[TMP3]], ptr [[EHSELECTOR_SLOT]], align 4
// CHECK2-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr @tc2, [[ARRAYCTOR_CUR]]
// CHECK2-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY:%.*]]
// CHECK2:       arraydestroy.body:
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[ARRAYCTOR_CUR]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[CLASS_TESTCLASS]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK2-NEXT:    call void @_ZN9TestClassD1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// CHECK2-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @tc2
// CHECK2-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1]], label [[ARRAYDESTROY_BODY]]
// CHECK2:       arraydestroy.done1:
// CHECK2-NEXT:    br label [[EH_RESUME:%.*]]
// CHECK2:       eh.resume:
// CHECK2-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8
// CHECK2-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4
// CHECK2-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0
// CHECK2-NEXT:    [[LPAD_VAL2:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1
// CHECK2-NEXT:    resume { ptr, i32 } [[LPAD_VAL2]]
//
//
// CHECK2-LABEL: define {{[^@]+}}@__cxx_global_array_dtor
// CHECK2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK2:       arraydestroy.body:
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ getelementptr inbounds ([[CLASS_TESTCLASS:%.*]], ptr @tc2, i64 2), [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[CLASS_TESTCLASS]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK2-NEXT:    call void @_ZN9TestClassD1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// CHECK2-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @tc2
// CHECK2-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK2:       arraydestroy.done1:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_.
// CHECK2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    call void @_ZN9TestClassC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TMP1]])
// CHECK2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    ret ptr [[TMP2]]
//
//
// CHECK2-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_.
// CHECK2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    call void @_ZN9TestClassD1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TMP1]]) #[[ATTR3]]
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.__omp_threadprivate_init_.
// CHECK2-SAME: () #[[ATTR0]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1:[0-9]+]])
// CHECK2-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB1]], ptr @tc, ptr @.__kmpc_global_ctor_., ptr null, ptr @.__kmpc_global_dtor_.)
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_..2
// CHECK2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] personality ptr @__gxx_personality_v0 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %class.TestClass], ptr [[TMP1]], i32 0, i32 0
// CHECK2-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[CLASS_TESTCLASS:%.*]], ptr [[ARRAY_BEGIN]], i64 2
// CHECK2-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK2:       arrayctor.loop:
// CHECK2-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi ptr [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[INVOKE_CONT:%.*]] ]
// CHECK2-NEXT:    invoke void @_ZN9TestClassC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK2-NEXT:    to label [[INVOKE_CONT]] unwind label [[LPAD:%.*]]
// CHECK2:       invoke.cont:
// CHECK2-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[CLASS_TESTCLASS]], ptr [[ARRAYCTOR_CUR]], i64 1
// CHECK2-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq ptr [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK2-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK2:       arrayctor.cont:
// CHECK2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    ret ptr [[TMP2]]
// CHECK2:       lpad:
// CHECK2-NEXT:    [[TMP3:%.*]] = landingpad { ptr, i32 }
// CHECK2-NEXT:    cleanup
// CHECK2-NEXT:    [[TMP4:%.*]] = extractvalue { ptr, i32 } [[TMP3]], 0
// CHECK2-NEXT:    store ptr [[TMP4]], ptr [[EXN_SLOT]], align 8
// CHECK2-NEXT:    [[TMP5:%.*]] = extractvalue { ptr, i32 } [[TMP3]], 1
// CHECK2-NEXT:    store i32 [[TMP5]], ptr [[EHSELECTOR_SLOT]], align 4
// CHECK2-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr [[ARRAY_BEGIN]], [[ARRAYCTOR_CUR]]
// CHECK2-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY:%.*]]
// CHECK2:       arraydestroy.body:
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[ARRAYCTOR_CUR]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[CLASS_TESTCLASS]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK2-NEXT:    call void @_ZN9TestClassD1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// CHECK2-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK2-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1]], label [[ARRAYDESTROY_BODY]]
// CHECK2:       arraydestroy.done1:
// CHECK2-NEXT:    br label [[EH_RESUME:%.*]]
// CHECK2:       eh.resume:
// CHECK2-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8
// CHECK2-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4
// CHECK2-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0
// CHECK2-NEXT:    [[LPAD_VAL2:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1
// CHECK2-NEXT:    resume { ptr, i32 } [[LPAD_VAL2]]
//
//
// CHECK2-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_..3
// CHECK2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[CLASS_TESTCLASS:%.*]], ptr [[TMP1]], i64 2
// CHECK2-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK2:       arraydestroy.body:
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP2]], [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK2-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[CLASS_TESTCLASS]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK2-NEXT:    call void @_ZN9TestClassD1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// CHECK2-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[TMP1]]
// CHECK2-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK2:       arraydestroy.done1:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.__omp_threadprivate_init_..4
// CHECK2-SAME: () #[[ATTR0]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK2-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB1]], ptr @tc2, ptr @.__kmpc_global_ctor_..2, ptr null, ptr @.__kmpc_global_dtor_..3)
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_Z3foov
// CHECK2-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    call void @_Z8mayThrowv()
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@main
// CHECK2-SAME: () #[[ATTR6:[0-9]+]] personality ptr @__gxx_personality_v0 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[A:%.*]] = alloca i8, align 1
// CHECK2-NEXT:    [[A2:%.*]] = alloca [2 x i8], align 1
// CHECK2-NEXT:    [[C:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[SST:%.*]] = alloca [[STRUCT_SST:%.*]], align 8
// CHECK2-NEXT:    [[SS:%.*]] = alloca [[STRUCT_SS:%.*]], align 8
// CHECK2-NEXT:    [[DOTOMP_COPYPRIVATE_DID_IT:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_COPYPRIVATE_CPR_LIST:%.*]] = alloca [5 x ptr], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK2-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK2-NEXT:    store ptr @tc, ptr [[C]], align 8
// CHECK2-NEXT:    call void @_ZN3SSTIdEC1Ev(ptr noundef nonnull align 8 dereferenceable(8) [[SST]])
// CHECK2-NEXT:    call void @_ZN2SSC1ERi(ptr noundef nonnull align 8 dereferenceable(16) [[SS]], ptr noundef nonnull align 4 dereferenceable(4) @tc)
// CHECK2-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK2-NEXT:    [[TMP2:%.*]] = icmp ne i32 [[TMP1]], 0
// CHECK2-NEXT:    br i1 [[TMP2]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK2:       omp_if.then:
// CHECK2-NEXT:    store i8 2, ptr [[A]], align 1
// CHECK2-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK2-NEXT:    br label [[OMP_IF_END]]
// CHECK2:       omp_if.end:
// CHECK2-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK2-NEXT:    [[TMP4:%.*]] = icmp ne i32 [[TMP3]], 0
// CHECK2-NEXT:    br i1 [[TMP4]], label [[OMP_IF_THEN1:%.*]], label [[OMP_IF_END2:%.*]]
// CHECK2:       omp_if.then1:
// CHECK2-NEXT:    store i8 2, ptr [[A]], align 1
// CHECK2-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK2-NEXT:    br label [[OMP_IF_END2]]
// CHECK2:       omp_if.end2:
// CHECK2-NEXT:    call void @__kmpc_barrier(ptr @[[GLOB2:[0-9]+]], i32 [[TMP0]])
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK2-NEXT:    [[TMP6:%.*]] = icmp ne i32 [[TMP5]], 0
// CHECK2-NEXT:    br i1 [[TMP6]], label [[OMP_IF_THEN3:%.*]], label [[OMP_IF_END4:%.*]]
// CHECK2:       omp_if.then3:
// CHECK2-NEXT:    invoke void @_Z3foov()
// CHECK2-NEXT:    to label [[INVOKE_CONT:%.*]] unwind label [[TERMINATE_LPAD:%.*]]
// CHECK2:       invoke.cont:
// CHECK2-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK2-NEXT:    store i32 1, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK2-NEXT:    br label [[OMP_IF_END4]]
// CHECK2:       omp_if.end4:
// CHECK2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 0
// CHECK2-NEXT:    store ptr [[A]], ptr [[TMP7]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 1
// CHECK2-NEXT:    store ptr @tc, ptr [[TMP8]], align 8
// CHECK2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 2
// CHECK2-NEXT:    [[TMP10:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @tc, i64 4, ptr @tc.cache.)
// CHECK2-NEXT:    store ptr [[TMP10]], ptr [[TMP9]], align 8
// CHECK2-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 3
// CHECK2-NEXT:    store ptr [[A2]], ptr [[TMP11]], align 8
// CHECK2-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 4
// CHECK2-NEXT:    [[TMP13:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @tc2, i64 8, ptr @tc2.cache.)
// CHECK2-NEXT:    store ptr [[TMP13]], ptr [[TMP12]], align 8
// CHECK2-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK2-NEXT:    call void @__kmpc_copyprivate(ptr @[[GLOB1]], i32 [[TMP0]], i64 40, ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], ptr @.omp.copyprivate.copy_func, i32 [[TMP14]])
// CHECK2-NEXT:    [[TMP15:%.*]] = load i8, ptr [[A]], align 1
// CHECK2-NEXT:    [[CONV:%.*]] = sext i8 [[TMP15]] to i32
// CHECK2-NEXT:    ret i32 [[CONV]]
// CHECK2:       terminate.lpad:
// CHECK2-NEXT:    [[TMP16:%.*]] = landingpad { ptr, i32 }
// CHECK2-NEXT:    catch ptr null
// CHECK2-NEXT:    [[TMP17:%.*]] = extractvalue { ptr, i32 } [[TMP16]], 0
// CHECK2-NEXT:    call void @__clang_call_terminate(ptr [[TMP17]]) #[[ATTR13:[0-9]+]]
// CHECK2-NEXT:    unreachable
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN3SSTIdEC1Ev
// CHECK2-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    call void @_ZN3SSTIdEC2Ev(ptr noundef nonnull align 8 dereferenceable(8) [[THIS1]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN2SSC1ERi
// CHECK2-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[D:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[D_ADDR]], align 8
// CHECK2-NEXT:    call void @_ZN2SSC2ERi(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP0]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@__clang_call_terminate
// CHECK2-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR8:[0-9]+]] comdat {
// CHECK2-NEXT:    [[TMP2:%.*]] = call ptr @__cxa_begin_catch(ptr [[TMP0]]) #[[ATTR3]]
// CHECK2-NEXT:    call void @_ZSt9terminatev() #[[ATTR13]]
// CHECK2-NEXT:    unreachable
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp.copyprivate.copy_func
// CHECK2-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR9:[0-9]+]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK2-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK2-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = load i8, ptr [[TMP7]], align 1
// CHECK2-NEXT:    store i8 [[TMP8]], ptr [[TMP5]], align 1
// CHECK2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP2]], i64 0, i64 1
// CHECK2-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[TMP9]], align 8
// CHECK2-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP3]], i64 0, i64 1
// CHECK2-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP11]], align 8
// CHECK2-NEXT:    [[CALL:%.*]] = call noundef nonnull align 4 dereferenceable(4) ptr @_ZN9TestClassaSERKS_(ptr noundef nonnull align 4 dereferenceable(4) [[TMP10]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP12]])
// CHECK2-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP2]], i64 0, i64 2
// CHECK2-NEXT:    [[TMP14:%.*]] = load ptr, ptr [[TMP13]], align 8
// CHECK2-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP3]], i64 0, i64 2
// CHECK2-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[TMP15]], align 8
// CHECK2-NEXT:    [[CALL2:%.*]] = call noundef nonnull align 4 dereferenceable(4) ptr @_ZN9TestClassaSERKS_(ptr noundef nonnull align 4 dereferenceable(4) [[TMP14]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP16]])
// CHECK2-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP2]], i64 0, i64 3
// CHECK2-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[TMP17]], align 8
// CHECK2-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP3]], i64 0, i64 3
// CHECK2-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[TMP19]], align 8
// CHECK2-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 1 [[TMP18]], ptr align 1 [[TMP20]], i64 2, i1 false)
// CHECK2-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP2]], i64 0, i64 4
// CHECK2-NEXT:    [[TMP22:%.*]] = load ptr, ptr [[TMP21]], align 8
// CHECK2-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP3]], i64 0, i64 4
// CHECK2-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[TMP23]], align 8
// CHECK2-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [[CLASS_TESTCLASS:%.*]], ptr [[TMP22]], i64 2
// CHECK2-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq ptr [[TMP22]], [[TMP25]]
// CHECK2-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE4:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK2:       omp.arraycpy.body:
// CHECK2-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi ptr [ [[TMP24]], [[ENTRY:%.*]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK2-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi ptr [ [[TMP22]], [[ENTRY]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK2-NEXT:    [[CALL3:%.*]] = call noundef nonnull align 4 dereferenceable(4) ptr @_ZN9TestClassaSERKS_(ptr noundef nonnull align 4 dereferenceable(4) [[OMP_ARRAYCPY_DESTELEMENTPAST]], ptr noundef nonnull align 4 dereferenceable(4) [[OMP_ARRAYCPY_SRCELEMENTPAST]])
// CHECK2-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[CLASS_TESTCLASS]], ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK2-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[CLASS_TESTCLASS]], ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK2-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP25]]
// CHECK2-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE4]], label [[OMP_ARRAYCPY_BODY]]
// CHECK2:       omp.arraycpy.done4:
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN9TestClassaSERKS_
// CHECK2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP0:%.*]]) #[[ATTR10:[0-9]+]] comdat align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    ret ptr [[THIS1]]
//
//
// CHECK2-LABEL: define {{[^@]+}}@_Z15parallel_singlev
// CHECK2-SAME: () #[[ATTR10]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 0, ptr @_Z15parallel_singlev.omp_outlined)
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_Z15parallel_singlev.omp_outlined
// CHECK2-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]]) #[[ATTR12:[0-9]+]] personality ptr @__gxx_personality_v0 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK2-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK2-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP2]], 0
// CHECK2-NEXT:    br i1 [[TMP3]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK2:       omp_if.then:
// CHECK2-NEXT:    invoke void @_Z3foov()
// CHECK2-NEXT:    to label [[INVOKE_CONT:%.*]] unwind label [[TERMINATE_LPAD:%.*]]
// CHECK2:       invoke.cont:
// CHECK2-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK2-NEXT:    br label [[OMP_IF_END]]
// CHECK2:       omp_if.end:
// CHECK2-NEXT:    call void @__kmpc_barrier(ptr @[[GLOB2]], i32 [[TMP1]])
// CHECK2-NEXT:    ret void
// CHECK2:       terminate.lpad:
// CHECK2-NEXT:    [[TMP4:%.*]] = landingpad { ptr, i32 }
// CHECK2-NEXT:    catch ptr null
// CHECK2-NEXT:    [[TMP5:%.*]] = extractvalue { ptr, i32 } [[TMP4]], 0
// CHECK2-NEXT:    call void @__clang_call_terminate(ptr [[TMP5]]) #[[ATTR13]]
// CHECK2-NEXT:    unreachable
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN9TestClassC2Ev
// CHECK2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[A:%.*]] = getelementptr inbounds [[CLASS_TESTCLASS:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK2-NEXT:    store i32 0, ptr [[A]], align 4
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN9TestClassD2Ev
// CHECK2-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN2SSC2ERi
// CHECK2-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[D:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[A2:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[B4:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[C7:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[B_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[C_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK2-NEXT:    store i32 0, ptr [[A]], align 8
// CHECK2-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 1
// CHECK2-NEXT:    [[BF_LOAD:%.*]] = load i8, ptr [[B]], align 4
// CHECK2-NEXT:    [[BF_CLEAR:%.*]] = and i8 [[BF_LOAD]], -16
// CHECK2-NEXT:    [[BF_SET:%.*]] = or i8 [[BF_CLEAR]], 0
// CHECK2-NEXT:    store i8 [[BF_SET]], ptr [[B]], align 4
// CHECK2-NEXT:    [[C:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[D_ADDR]], align 8
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[C]], align 8
// CHECK2-NEXT:    [[A3:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 0
// CHECK2-NEXT:    store ptr [[A3]], ptr [[A2]], align 8
// CHECK2-NEXT:    [[B5:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 1
// CHECK2-NEXT:    [[BF_LOAD6:%.*]] = load i8, ptr [[B5]], align 4
// CHECK2-NEXT:    [[BF_SHL:%.*]] = shl i8 [[BF_LOAD6]], 4
// CHECK2-NEXT:    [[BF_ASHR:%.*]] = ashr i8 [[BF_SHL]], 4
// CHECK2-NEXT:    [[BF_CAST:%.*]] = sext i8 [[BF_ASHR]] to i32
// CHECK2-NEXT:    store i32 [[BF_CAST]], ptr [[B4]], align 4
// CHECK2-NEXT:    [[C8:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[C8]], align 8
// CHECK2-NEXT:    store ptr [[TMP1]], ptr [[C7]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[A2]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4
// CHECK2-NEXT:    store i32 [[TMP3]], ptr [[A_CASTED]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = load i64, ptr [[A_CASTED]], align 8
// CHECK2-NEXT:    [[TMP5:%.*]] = load i32, ptr [[B4]], align 4
// CHECK2-NEXT:    store i32 [[TMP5]], ptr [[B_CASTED]], align 4
// CHECK2-NEXT:    [[TMP6:%.*]] = load i64, ptr [[B_CASTED]], align 8
// CHECK2-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[C7]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP7]], align 4
// CHECK2-NEXT:    store i32 [[TMP8]], ptr [[C_CASTED]], align 4
// CHECK2-NEXT:    [[TMP9:%.*]] = load i64, ptr [[C_CASTED]], align 8
// CHECK2-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 4, ptr @_ZN2SSC2ERi.omp_outlined, ptr [[THIS1]], i64 [[TMP4]], i64 [[TMP6]], i64 [[TMP9]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN2SSC2ERi.omp_outlined
// CHECK2-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], i64 noundef [[A:%.*]], i64 noundef [[B:%.*]], i64 noundef [[C:%.*]]) #[[ATTR12]] personality ptr @__gxx_personality_v0 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[C_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[_TMP2:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[_TMP3:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTOMP_COPYPRIVATE_DID_IT:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON:%.*]], align 8
// CHECK2-NEXT:    [[DOTOMP_COPYPRIVATE_CPR_LIST:%.*]] = alloca [3 x ptr], align 8
// CHECK2-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[A]], ptr [[A_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[B]], ptr [[B_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[C]], ptr [[C_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store ptr [[A_ADDR]], ptr [[TMP]], align 8
// CHECK2-NEXT:    store ptr [[C_ADDR]], ptr [[_TMP1]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK2-NEXT:    store ptr [[TMP1]], ptr [[_TMP2]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK2-NEXT:    store ptr [[TMP2]], ptr [[_TMP3]], align 8
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK2-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP3]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK2-NEXT:    [[TMP6:%.*]] = icmp ne i32 [[TMP5]], 0
// CHECK2-NEXT:    br i1 [[TMP6]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK2:       omp_if.then:
// CHECK2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[REF_TMP]], i32 0, i32 0
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[TMP7]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[REF_TMP]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[_TMP2]], align 8
// CHECK2-NEXT:    store ptr [[TMP9]], ptr [[TMP8]], align 8
// CHECK2-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[REF_TMP]], i32 0, i32 2
// CHECK2-NEXT:    store ptr [[B_ADDR]], ptr [[TMP10]], align 8
// CHECK2-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[REF_TMP]], i32 0, i32 3
// CHECK2-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[_TMP3]], align 8
// CHECK2-NEXT:    store ptr [[TMP12]], ptr [[TMP11]], align 8
// CHECK2-NEXT:    invoke void @_ZZN2SSC1ERiENKUlvE_clEv(ptr noundef nonnull align 8 dereferenceable(32) [[REF_TMP]])
// CHECK2-NEXT:    to label [[INVOKE_CONT:%.*]] unwind label [[TERMINATE_LPAD:%.*]]
// CHECK2:       invoke.cont:
// CHECK2-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK2-NEXT:    store i32 1, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK2-NEXT:    br label [[OMP_IF_END]]
// CHECK2:       omp_if.end:
// CHECK2-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 0
// CHECK2-NEXT:    [[TMP14:%.*]] = load ptr, ptr [[_TMP2]], align 8
// CHECK2-NEXT:    store ptr [[TMP14]], ptr [[TMP13]], align 8
// CHECK2-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 1
// CHECK2-NEXT:    store ptr [[B_ADDR]], ptr [[TMP15]], align 8
// CHECK2-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 2
// CHECK2-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[_TMP3]], align 8
// CHECK2-NEXT:    store ptr [[TMP17]], ptr [[TMP16]], align 8
// CHECK2-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK2-NEXT:    call void @__kmpc_copyprivate(ptr @[[GLOB1]], i32 [[TMP4]], i64 24, ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], ptr @.omp.copyprivate.copy_func.5, i32 [[TMP18]])
// CHECK2-NEXT:    ret void
// CHECK2:       terminate.lpad:
// CHECK2-NEXT:    [[TMP19:%.*]] = landingpad { ptr, i32 }
// CHECK2-NEXT:    catch ptr null
// CHECK2-NEXT:    [[TMP20:%.*]] = extractvalue { ptr, i32 } [[TMP19]], 0
// CHECK2-NEXT:    call void @__clang_call_terminate(ptr [[TMP20]]) #[[ATTR13]]
// CHECK2-NEXT:    unreachable
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZZN2SSC1ERiENKUlvE_clEv
// CHECK2-SAME: (ptr noundef nonnull align 8 dereferenceable(32) [[THIS:%.*]]) #[[ATTR10]] align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[B_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[C_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP0]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[THIS1]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP2]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP3]], align 4
// CHECK2-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP4]], 1
// CHECK2-NEXT:    store i32 [[INC]], ptr [[TMP3]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[THIS1]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[TMP5]], align 8
// CHECK2-NEXT:    [[TMP7:%.*]] = load i32, ptr [[TMP6]], align 4
// CHECK2-NEXT:    [[DEC:%.*]] = add nsw i32 [[TMP7]], -1
// CHECK2-NEXT:    store i32 [[DEC]], ptr [[TMP6]], align 4
// CHECK2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[THIS1]], i32 0, i32 3
// CHECK2-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[TMP8]], align 8
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, ptr [[TMP9]], align 4
// CHECK2-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP10]], 1
// CHECK2-NEXT:    store i32 [[DIV]], ptr [[TMP9]], align 4
// CHECK2-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[THIS1]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP11]], align 8
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, ptr [[TMP12]], align 4
// CHECK2-NEXT:    store i32 [[TMP13]], ptr [[A_CASTED]], align 4
// CHECK2-NEXT:    [[TMP14:%.*]] = load i64, ptr [[A_CASTED]], align 8
// CHECK2-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[THIS1]], i32 0, i32 2
// CHECK2-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[TMP15]], align 8
// CHECK2-NEXT:    [[TMP17:%.*]] = load i32, ptr [[TMP16]], align 4
// CHECK2-NEXT:    store i32 [[TMP17]], ptr [[B_CASTED]], align 4
// CHECK2-NEXT:    [[TMP18:%.*]] = load i64, ptr [[B_CASTED]], align 8
// CHECK2-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[THIS1]], i32 0, i32 3
// CHECK2-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[TMP19]], align 8
// CHECK2-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP20]], align 4
// CHECK2-NEXT:    store i32 [[TMP21]], ptr [[C_CASTED]], align 4
// CHECK2-NEXT:    [[TMP22:%.*]] = load i64, ptr [[C_CASTED]], align 8
// CHECK2-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 4, ptr @_ZZN2SSC1ERiENKUlvE_clEv.omp_outlined, ptr [[TMP1]], i64 [[TMP14]], i64 [[TMP18]], i64 [[TMP22]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp.copyprivate.copy_func.5
// CHECK2-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR9]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK2-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK2-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP7]], align 4
// CHECK2-NEXT:    store i32 [[TMP8]], ptr [[TMP5]], align 4
// CHECK2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 1
// CHECK2-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[TMP9]], align 8
// CHECK2-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 1
// CHECK2-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP11]], align 8
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, ptr [[TMP12]], align 4
// CHECK2-NEXT:    store i32 [[TMP13]], ptr [[TMP10]], align 4
// CHECK2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 2
// CHECK2-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[TMP14]], align 8
// CHECK2-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 2
// CHECK2-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[TMP16]], align 8
// CHECK2-NEXT:    [[TMP18:%.*]] = load i32, ptr [[TMP17]], align 4
// CHECK2-NEXT:    store i32 [[TMP18]], ptr [[TMP15]], align 4
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZZN2SSC1ERiENKUlvE_clEv.omp_outlined
// CHECK2-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], i64 noundef [[A:%.*]], i64 noundef [[B:%.*]], i64 noundef [[C:%.*]]) #[[ATTR12]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[C_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[_TMP2:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[_TMP3:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTOMP_COPYPRIVATE_DID_IT:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_COPYPRIVATE_CPR_LIST:%.*]] = alloca [3 x ptr], align 8
// CHECK2-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[A]], ptr [[A_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[B]], ptr [[B_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[C]], ptr [[C_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store ptr [[A_ADDR]], ptr [[TMP]], align 8
// CHECK2-NEXT:    store ptr [[C_ADDR]], ptr [[_TMP1]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK2-NEXT:    store ptr [[TMP1]], ptr [[_TMP2]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK2-NEXT:    store ptr [[TMP2]], ptr [[_TMP3]], align 8
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK2-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP3]], align 4
// CHECK2-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK2-NEXT:    [[TMP6:%.*]] = icmp ne i32 [[TMP5]], 0
// CHECK2-NEXT:    br i1 [[TMP6]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK2:       omp_if.then:
// CHECK2-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[_TMP2]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP7]], align 4
// CHECK2-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK2-NEXT:    store i32 [[INC]], ptr [[TMP7]], align 4
// CHECK2-NEXT:    [[TMP9:%.*]] = load i32, ptr [[B_ADDR]], align 4
// CHECK2-NEXT:    [[DEC:%.*]] = add nsw i32 [[TMP9]], -1
// CHECK2-NEXT:    store i32 [[DEC]], ptr [[B_ADDR]], align 4
// CHECK2-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[_TMP3]], align 8
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP10]], align 4
// CHECK2-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP11]], 1
// CHECK2-NEXT:    store i32 [[DIV]], ptr [[TMP10]], align 4
// CHECK2-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK2-NEXT:    store i32 1, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK2-NEXT:    br label [[OMP_IF_END]]
// CHECK2:       omp_if.end:
// CHECK2-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 0
// CHECK2-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[_TMP2]], align 8
// CHECK2-NEXT:    store ptr [[TMP13]], ptr [[TMP12]], align 8
// CHECK2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 1
// CHECK2-NEXT:    store ptr [[B_ADDR]], ptr [[TMP14]], align 8
// CHECK2-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 2
// CHECK2-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[_TMP3]], align 8
// CHECK2-NEXT:    store ptr [[TMP16]], ptr [[TMP15]], align 8
// CHECK2-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK2-NEXT:    call void @__kmpc_copyprivate(ptr @[[GLOB1]], i32 [[TMP4]], i64 24, ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], ptr @.omp.copyprivate.copy_func.6, i32 [[TMP17]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp.copyprivate.copy_func.6
// CHECK2-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR9]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK2-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK2-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP7]], align 4
// CHECK2-NEXT:    store i32 [[TMP8]], ptr [[TMP5]], align 4
// CHECK2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 1
// CHECK2-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[TMP9]], align 8
// CHECK2-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 1
// CHECK2-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP11]], align 8
// CHECK2-NEXT:    [[TMP13:%.*]] = load i32, ptr [[TMP12]], align 4
// CHECK2-NEXT:    store i32 [[TMP13]], ptr [[TMP10]], align 4
// CHECK2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 2
// CHECK2-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[TMP14]], align 8
// CHECK2-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 2
// CHECK2-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[TMP16]], align 8
// CHECK2-NEXT:    [[TMP18:%.*]] = load i32, ptr [[TMP17]], align 4
// CHECK2-NEXT:    store i32 [[TMP18]], ptr [[TMP15]], align 4
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN3SSTIdEC2Ev
// CHECK2-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[A2:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SST:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK2-NEXT:    store double 0.000000e+00, ptr [[A]], align 8
// CHECK2-NEXT:    [[A3:%.*]] = getelementptr inbounds [[STRUCT_SST]], ptr [[THIS1]], i32 0, i32 0
// CHECK2-NEXT:    store ptr [[A3]], ptr [[A2]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[A2]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load double, ptr [[TMP0]], align 8
// CHECK2-NEXT:    store double [[TMP1]], ptr [[A_CASTED]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load i64, ptr [[A_CASTED]], align 8
// CHECK2-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 2, ptr @_ZN3SSTIdEC2Ev.omp_outlined, ptr [[THIS1]], i64 [[TMP2]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZN3SSTIdEC2Ev.omp_outlined
// CHECK2-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], i64 noundef [[A:%.*]]) #[[ATTR12]] personality ptr @__gxx_personality_v0 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTOMP_COPYPRIVATE_DID_IT:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_0:%.*]], align 8
// CHECK2-NEXT:    [[DOTOMP_COPYPRIVATE_CPR_LIST:%.*]] = alloca [1 x ptr], align 8
// CHECK2-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[A]], ptr [[A_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store ptr [[A_ADDR]], ptr [[TMP]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK2-NEXT:    store ptr [[TMP1]], ptr [[_TMP1]], align 8
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK2-NEXT:    [[TMP5:%.*]] = icmp ne i32 [[TMP4]], 0
// CHECK2-NEXT:    br i1 [[TMP5]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK2:       omp_if.then:
// CHECK2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[REF_TMP]], i32 0, i32 0
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[TMP6]], align 8
// CHECK2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[REF_TMP]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK2-NEXT:    store ptr [[TMP8]], ptr [[TMP7]], align 8
// CHECK2-NEXT:    invoke void @_ZZN3SSTIdEC1EvENKUlvE_clEv(ptr noundef nonnull align 8 dereferenceable(16) [[REF_TMP]])
// CHECK2-NEXT:    to label [[INVOKE_CONT:%.*]] unwind label [[TERMINATE_LPAD:%.*]]
// CHECK2:       invoke.cont:
// CHECK2-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK2-NEXT:    store i32 1, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK2-NEXT:    br label [[OMP_IF_END]]
// CHECK2:       omp_if.end:
// CHECK2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 0
// CHECK2-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK2-NEXT:    store ptr [[TMP10]], ptr [[TMP9]], align 8
// CHECK2-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK2-NEXT:    call void @__kmpc_copyprivate(ptr @[[GLOB1]], i32 [[TMP3]], i64 8, ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], ptr @.omp.copyprivate.copy_func.7, i32 [[TMP11]])
// CHECK2-NEXT:    ret void
// CHECK2:       terminate.lpad:
// CHECK2-NEXT:    [[TMP12:%.*]] = landingpad { ptr, i32 }
// CHECK2-NEXT:    catch ptr null
// CHECK2-NEXT:    [[TMP13:%.*]] = extractvalue { ptr, i32 } [[TMP12]], 0
// CHECK2-NEXT:    call void @__clang_call_terminate(ptr [[TMP13]]) #[[ATTR13]]
// CHECK2-NEXT:    unreachable
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZZN3SSTIdEC1EvENKUlvE_clEv
// CHECK2-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) #[[ATTR4]] align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_1:%.*]], align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP0]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[REF_TMP]], i32 0, i32 0
// CHECK2-NEXT:    store ptr [[TMP1]], ptr [[TMP2]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[REF_TMP]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[THIS1]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK2-NEXT:    store ptr [[TMP5]], ptr [[TMP3]], align 8
// CHECK2-NEXT:    call void @_ZZZN3SSTIdEC1EvENKUlvE_clEvENKUlvE_clEv(ptr noundef nonnull align 8 dereferenceable(16) [[REF_TMP]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp.copyprivate.copy_func.7
// CHECK2-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR9]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK2-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK2-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = load double, ptr [[TMP7]], align 8
// CHECK2-NEXT:    store double [[TMP8]], ptr [[TMP5]], align 8
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZZZN3SSTIdEC1EvENKUlvE_clEvENKUlvE_clEv
// CHECK2-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) #[[ATTR10]] align 2 {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON_1:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP0]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[THIS1]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP2]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = load double, ptr [[TMP3]], align 8
// CHECK2-NEXT:    [[INC:%.*]] = fadd double [[TMP4]], 1.000000e+00
// CHECK2-NEXT:    store double [[INC]], ptr [[TMP3]], align 8
// CHECK2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[THIS1]], i32 0, i32 1
// CHECK2-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[TMP5]], align 8
// CHECK2-NEXT:    [[TMP7:%.*]] = load double, ptr [[TMP6]], align 8
// CHECK2-NEXT:    store double [[TMP7]], ptr [[A_CASTED]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = load i64, ptr [[A_CASTED]], align 8
// CHECK2-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 2, ptr @_ZZZN3SSTIdEC1EvENKUlvE_clEvENKUlvE_clEv.omp_outlined, ptr [[TMP1]], i64 [[TMP8]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_ZZZN3SSTIdEC1EvENKUlvE_clEvENKUlvE_clEv.omp_outlined
// CHECK2-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], i64 noundef [[A:%.*]]) #[[ATTR12]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK2-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTOMP_COPYPRIVATE_DID_IT:%.*]] = alloca i32, align 4
// CHECK2-NEXT:    [[DOTOMP_COPYPRIVATE_CPR_LIST:%.*]] = alloca [1 x ptr], align 8
// CHECK2-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK2-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store i64 [[A]], ptr [[A_ADDR]], align 8
// CHECK2-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK2-NEXT:    store ptr [[A_ADDR]], ptr [[TMP]], align 8
// CHECK2-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK2-NEXT:    store ptr [[TMP1]], ptr [[_TMP1]], align 8
// CHECK2-NEXT:    store i32 0, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4
// CHECK2-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK2-NEXT:    [[TMP5:%.*]] = icmp ne i32 [[TMP4]], 0
// CHECK2-NEXT:    br i1 [[TMP5]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK2:       omp_if.then:
// CHECK2-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK2-NEXT:    [[TMP7:%.*]] = load double, ptr [[TMP6]], align 8
// CHECK2-NEXT:    [[INC:%.*]] = fadd double [[TMP7]], 1.000000e+00
// CHECK2-NEXT:    store double [[INC]], ptr [[TMP6]], align 8
// CHECK2-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK2-NEXT:    store i32 1, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK2-NEXT:    br label [[OMP_IF_END]]
// CHECK2:       omp_if.end:
// CHECK2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 0
// CHECK2-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK2-NEXT:    store ptr [[TMP9]], ptr [[TMP8]], align 8
// CHECK2-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK2-NEXT:    call void @__kmpc_copyprivate(ptr @[[GLOB1]], i32 [[TMP3]], i64 8, ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], ptr @.omp.copyprivate.copy_func.8, i32 [[TMP10]])
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@.omp.copyprivate.copy_func.8
// CHECK2-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR9]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK2-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK2-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK2-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK2-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK2-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK2-NEXT:    [[TMP8:%.*]] = load double, ptr [[TMP7]], align 8
// CHECK2-NEXT:    store double [[TMP8]], ptr [[TMP5]], align 8
// CHECK2-NEXT:    ret void
//
//
// CHECK2-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_single_codegen.cpp
// CHECK2-SAME: () #[[ATTR0]] {
// CHECK2-NEXT:  entry:
// CHECK2-NEXT:    call void @__cxx_global_var_init()
// CHECK2-NEXT:    call void @__cxx_global_var_init.1()
// CHECK2-NEXT:    call void @.__omp_threadprivate_init_.()
// CHECK2-NEXT:    call void @.__omp_threadprivate_init_..4()
// CHECK2-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@__cxx_global_var_init
// CHECK4-SAME: () #[[ATTR0:[0-9]+]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1:[0-9]+]])
// CHECK4-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB1]], ptr @tc, ptr @.__kmpc_global_ctor_., ptr null, ptr @.__kmpc_global_dtor_.)
// CHECK4-NEXT:    call void @_ZN9TestClassC1Ev(ptr noundef nonnull align 4 dereferenceable(4) @tc)
// CHECK4-NEXT:    [[TMP1:%.*]] = call i32 @__cxa_atexit(ptr @_ZN9TestClassD1Ev, ptr @tc, ptr @__dso_handle) #[[ATTR3:[0-9]+]]
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_.
// CHECK4-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    call void @_ZN9TestClassC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TMP1]])
// CHECK4-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    ret ptr [[TMP2]]
//
//
// CHECK4-LABEL: define {{[^@]+}}@_ZN9TestClassC1Ev
// CHECK4-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] comdat align 2 {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    call void @_ZN9TestClassC2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_.
// CHECK4-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    call void @_ZN9TestClassD1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TMP1]]) #[[ATTR3]]
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_ZN9TestClassD1Ev
// CHECK4-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2:[0-9]+]] comdat align 2 {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    call void @_ZN9TestClassD2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR3]]
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@__cxx_global_var_init.1
// CHECK4-SAME: () #[[ATTR0]] personality ptr @__gxx_personality_v0 {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK4-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB1]], ptr @tc2, ptr @.__kmpc_global_ctor_..2, ptr null, ptr @.__kmpc_global_dtor_..3)
// CHECK4-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK4:       arrayctor.loop:
// CHECK4-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi ptr [ @tc2, [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[INVOKE_CONT:%.*]] ]
// CHECK4-NEXT:    invoke void @_ZN9TestClassC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK4-NEXT:    to label [[INVOKE_CONT]] unwind label [[LPAD:%.*]]
// CHECK4:       invoke.cont:
// CHECK4-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[CLASS_TESTCLASS:%.*]], ptr [[ARRAYCTOR_CUR]], i64 1
// CHECK4-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq ptr [[ARRAYCTOR_NEXT]], getelementptr inbounds ([[CLASS_TESTCLASS]], ptr @tc2, i64 2)
// CHECK4-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK4:       arrayctor.cont:
// CHECK4-NEXT:    [[TMP1:%.*]] = call i32 @__cxa_atexit(ptr @__cxx_global_array_dtor, ptr null, ptr @__dso_handle) #[[ATTR3]]
// CHECK4-NEXT:    ret void
// CHECK4:       lpad:
// CHECK4-NEXT:    [[TMP2:%.*]] = landingpad { ptr, i32 }
// CHECK4-NEXT:    cleanup
// CHECK4-NEXT:    [[TMP3:%.*]] = extractvalue { ptr, i32 } [[TMP2]], 0
// CHECK4-NEXT:    store ptr [[TMP3]], ptr [[EXN_SLOT]], align 8
// CHECK4-NEXT:    [[TMP4:%.*]] = extractvalue { ptr, i32 } [[TMP2]], 1
// CHECK4-NEXT:    store i32 [[TMP4]], ptr [[EHSELECTOR_SLOT]], align 4
// CHECK4-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr @tc2, [[ARRAYCTOR_CUR]]
// CHECK4-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY:%.*]]
// CHECK4:       arraydestroy.body:
// CHECK4-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[ARRAYCTOR_CUR]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK4-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[CLASS_TESTCLASS]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK4-NEXT:    call void @_ZN9TestClassD1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// CHECK4-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @tc2
// CHECK4-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1]], label [[ARRAYDESTROY_BODY]]
// CHECK4:       arraydestroy.done1:
// CHECK4-NEXT:    br label [[EH_RESUME:%.*]]
// CHECK4:       eh.resume:
// CHECK4-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8
// CHECK4-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4
// CHECK4-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0
// CHECK4-NEXT:    [[LPAD_VAL2:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1
// CHECK4-NEXT:    resume { ptr, i32 } [[LPAD_VAL2]]
//
//
// CHECK4-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_..2
// CHECK4-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] personality ptr @__gxx_personality_v0 {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %class.TestClass], ptr [[TMP1]], i32 0, i32 0
// CHECK4-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[CLASS_TESTCLASS:%.*]], ptr [[ARRAY_BEGIN]], i64 2
// CHECK4-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]]
// CHECK4:       arrayctor.loop:
// CHECK4-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi ptr [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[INVOKE_CONT:%.*]] ]
// CHECK4-NEXT:    invoke void @_ZN9TestClassC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK4-NEXT:    to label [[INVOKE_CONT]] unwind label [[LPAD:%.*]]
// CHECK4:       invoke.cont:
// CHECK4-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[CLASS_TESTCLASS]], ptr [[ARRAYCTOR_CUR]], i64 1
// CHECK4-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq ptr [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]]
// CHECK4-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]]
// CHECK4:       arrayctor.cont:
// CHECK4-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    ret ptr [[TMP2]]
// CHECK4:       lpad:
// CHECK4-NEXT:    [[TMP3:%.*]] = landingpad { ptr, i32 }
// CHECK4-NEXT:    cleanup
// CHECK4-NEXT:    [[TMP4:%.*]] = extractvalue { ptr, i32 } [[TMP3]], 0
// CHECK4-NEXT:    store ptr [[TMP4]], ptr [[EXN_SLOT]], align 8
// CHECK4-NEXT:    [[TMP5:%.*]] = extractvalue { ptr, i32 } [[TMP3]], 1
// CHECK4-NEXT:    store i32 [[TMP5]], ptr [[EHSELECTOR_SLOT]], align 4
// CHECK4-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr [[ARRAY_BEGIN]], [[ARRAYCTOR_CUR]]
// CHECK4-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY:%.*]]
// CHECK4:       arraydestroy.body:
// CHECK4-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[ARRAYCTOR_CUR]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK4-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[CLASS_TESTCLASS]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK4-NEXT:    call void @_ZN9TestClassD1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// CHECK4-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]]
// CHECK4-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1]], label [[ARRAYDESTROY_BODY]]
// CHECK4:       arraydestroy.done1:
// CHECK4-NEXT:    br label [[EH_RESUME:%.*]]
// CHECK4:       eh.resume:
// CHECK4-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8
// CHECK4-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4
// CHECK4-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0
// CHECK4-NEXT:    [[LPAD_VAL2:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1
// CHECK4-NEXT:    resume { ptr, i32 } [[LPAD_VAL2]]
//
//
// CHECK4-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_..3
// CHECK4-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[CLASS_TESTCLASS:%.*]], ptr [[TMP1]], i64 2
// CHECK4-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK4:       arraydestroy.body:
// CHECK4-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP2]], [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK4-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[CLASS_TESTCLASS]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK4-NEXT:    call void @_ZN9TestClassD1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// CHECK4-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[TMP1]]
// CHECK4-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK4:       arraydestroy.done1:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@__cxx_global_array_dtor
// CHECK4-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]]
// CHECK4:       arraydestroy.body:
// CHECK4-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ getelementptr inbounds ([[CLASS_TESTCLASS:%.*]], ptr @tc2, i64 2), [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ]
// CHECK4-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[CLASS_TESTCLASS]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1
// CHECK4-NEXT:    call void @_ZN9TestClassD1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]]
// CHECK4-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @tc2
// CHECK4-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]]
// CHECK4:       arraydestroy.done1:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_Z3foov
// CHECK4-SAME: () #[[ATTR4:[0-9]+]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    call void @_Z8mayThrowv()
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@main
// CHECK4-SAME: () #[[ATTR6:[0-9]+]] personality ptr @__gxx_personality_v0 {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[A:%.*]] = alloca i8, align 1
// CHECK4-NEXT:    [[A2:%.*]] = alloca [2 x i8], align 1
// CHECK4-NEXT:    [[C:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[SST:%.*]] = alloca [[STRUCT_SST:%.*]], align 8
// CHECK4-NEXT:    [[SS:%.*]] = alloca [[STRUCT_SS:%.*]], align 8
// CHECK4-NEXT:    [[DOTOMP_COPYPRIVATE_DID_IT:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_COPYPRIVATE_CPR_LIST:%.*]] = alloca [5 x ptr], align 8
// CHECK4-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1]])
// CHECK4-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK4-NEXT:    store ptr @tc, ptr [[C]], align 8
// CHECK4-NEXT:    call void @_ZN3SSTIdEC1Ev(ptr noundef nonnull align 8 dereferenceable(8) [[SST]])
// CHECK4-NEXT:    call void @_ZN2SSC1ERi(ptr noundef nonnull align 8 dereferenceable(16) [[SS]], ptr noundef nonnull align 4 dereferenceable(4) @tc)
// CHECK4-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK4-NEXT:    [[TMP2:%.*]] = icmp ne i32 [[TMP1]], 0
// CHECK4-NEXT:    br i1 [[TMP2]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK4:       omp_if.then:
// CHECK4-NEXT:    store i8 2, ptr [[A]], align 1
// CHECK4-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK4-NEXT:    br label [[OMP_IF_END]]
// CHECK4:       omp_if.end:
// CHECK4-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK4-NEXT:    [[TMP4:%.*]] = icmp ne i32 [[TMP3]], 0
// CHECK4-NEXT:    br i1 [[TMP4]], label [[OMP_IF_THEN1:%.*]], label [[OMP_IF_END2:%.*]]
// CHECK4:       omp_if.then1:
// CHECK4-NEXT:    store i8 2, ptr [[A]], align 1
// CHECK4-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK4-NEXT:    br label [[OMP_IF_END2]]
// CHECK4:       omp_if.end2:
// CHECK4-NEXT:    call void @__kmpc_barrier(ptr @[[GLOB2:[0-9]+]], i32 [[TMP0]])
// CHECK4-NEXT:    store i32 0, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK4-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK4-NEXT:    [[TMP6:%.*]] = icmp ne i32 [[TMP5]], 0
// CHECK4-NEXT:    br i1 [[TMP6]], label [[OMP_IF_THEN3:%.*]], label [[OMP_IF_END4:%.*]]
// CHECK4:       omp_if.then3:
// CHECK4-NEXT:    invoke void @_Z3foov()
// CHECK4-NEXT:    to label [[INVOKE_CONT:%.*]] unwind label [[TERMINATE_LPAD:%.*]]
// CHECK4:       invoke.cont:
// CHECK4-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK4-NEXT:    store i32 1, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK4-NEXT:    br label [[OMP_IF_END4]]
// CHECK4:       omp_if.end4:
// CHECK4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 0
// CHECK4-NEXT:    store ptr [[A]], ptr [[TMP7]], align 8
// CHECK4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 1
// CHECK4-NEXT:    store ptr @tc, ptr [[TMP8]], align 8
// CHECK4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 2
// CHECK4-NEXT:    [[TMP10:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @tc, i64 4, ptr @tc.cache.)
// CHECK4-NEXT:    store ptr [[TMP10]], ptr [[TMP9]], align 8
// CHECK4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 3
// CHECK4-NEXT:    store ptr [[A2]], ptr [[TMP11]], align 8
// CHECK4-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 4
// CHECK4-NEXT:    [[TMP13:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB1]], i32 [[TMP0]], ptr @tc2, i64 8, ptr @tc2.cache.)
// CHECK4-NEXT:    store ptr [[TMP13]], ptr [[TMP12]], align 8
// CHECK4-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK4-NEXT:    call void @__kmpc_copyprivate(ptr @[[GLOB1]], i32 [[TMP0]], i64 40, ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], ptr @.omp.copyprivate.copy_func, i32 [[TMP14]])
// CHECK4-NEXT:    [[TMP15:%.*]] = load i8, ptr [[A]], align 1
// CHECK4-NEXT:    [[CONV:%.*]] = sext i8 [[TMP15]] to i32
// CHECK4-NEXT:    ret i32 [[CONV]]
// CHECK4:       terminate.lpad:
// CHECK4-NEXT:    [[TMP16:%.*]] = landingpad { ptr, i32 }
// CHECK4-NEXT:    catch ptr null
// CHECK4-NEXT:    [[TMP17:%.*]] = extractvalue { ptr, i32 } [[TMP16]], 0
// CHECK4-NEXT:    call void @__clang_call_terminate(ptr [[TMP17]]) #[[ATTR13:[0-9]+]]
// CHECK4-NEXT:    unreachable
//
//
// CHECK4-LABEL: define {{[^@]+}}@_ZN3SSTIdEC1Ev
// CHECK4-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    call void @_ZN3SSTIdEC2Ev(ptr noundef nonnull align 8 dereferenceable(8) [[THIS1]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_ZN2SSC1ERi
// CHECK4-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[D:%.*]]) unnamed_addr #[[ATTR1]] comdat align 2 {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 8
// CHECK4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[D_ADDR]], align 8
// CHECK4-NEXT:    call void @_ZN2SSC2ERi(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP0]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@__clang_call_terminate
// CHECK4-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR8:[0-9]+]] comdat {
// CHECK4-NEXT:    [[TMP2:%.*]] = call ptr @__cxa_begin_catch(ptr [[TMP0]]) #[[ATTR3]]
// CHECK4-NEXT:    call void @_ZSt9terminatev() #[[ATTR13]]
// CHECK4-NEXT:    unreachable
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp.copyprivate.copy_func
// CHECK4-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR9:[0-9]+]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK4-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK4-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK4-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK4-NEXT:    [[TMP8:%.*]] = load i8, ptr [[TMP7]], align 1
// CHECK4-NEXT:    store i8 [[TMP8]], ptr [[TMP5]], align 1
// CHECK4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP2]], i64 0, i64 1
// CHECK4-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[TMP9]], align 8
// CHECK4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP3]], i64 0, i64 1
// CHECK4-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP11]], align 8
// CHECK4-NEXT:    [[CALL:%.*]] = call noundef nonnull align 4 dereferenceable(4) ptr @_ZN9TestClassaSERKS_(ptr noundef nonnull align 4 dereferenceable(4) [[TMP10]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP12]])
// CHECK4-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP2]], i64 0, i64 2
// CHECK4-NEXT:    [[TMP14:%.*]] = load ptr, ptr [[TMP13]], align 8
// CHECK4-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP3]], i64 0, i64 2
// CHECK4-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[TMP15]], align 8
// CHECK4-NEXT:    [[CALL2:%.*]] = call noundef nonnull align 4 dereferenceable(4) ptr @_ZN9TestClassaSERKS_(ptr noundef nonnull align 4 dereferenceable(4) [[TMP14]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP16]])
// CHECK4-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP2]], i64 0, i64 3
// CHECK4-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[TMP17]], align 8
// CHECK4-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP3]], i64 0, i64 3
// CHECK4-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[TMP19]], align 8
// CHECK4-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 1 [[TMP18]], ptr align 1 [[TMP20]], i64 2, i1 false)
// CHECK4-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP2]], i64 0, i64 4
// CHECK4-NEXT:    [[TMP22:%.*]] = load ptr, ptr [[TMP21]], align 8
// CHECK4-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP3]], i64 0, i64 4
// CHECK4-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[TMP23]], align 8
// CHECK4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [[CLASS_TESTCLASS:%.*]], ptr [[TMP22]], i64 2
// CHECK4-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq ptr [[TMP22]], [[TMP25]]
// CHECK4-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE4:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]]
// CHECK4:       omp.arraycpy.body:
// CHECK4-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi ptr [ [[TMP24]], [[ENTRY:%.*]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK4-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi ptr [ [[TMP22]], [[ENTRY]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ]
// CHECK4-NEXT:    [[CALL3:%.*]] = call noundef nonnull align 4 dereferenceable(4) ptr @_ZN9TestClassaSERKS_(ptr noundef nonnull align 4 dereferenceable(4) [[OMP_ARRAYCPY_DESTELEMENTPAST]], ptr noundef nonnull align 4 dereferenceable(4) [[OMP_ARRAYCPY_SRCELEMENTPAST]])
// CHECK4-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[CLASS_TESTCLASS]], ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1
// CHECK4-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[CLASS_TESTCLASS]], ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1
// CHECK4-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP25]]
// CHECK4-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE4]], label [[OMP_ARRAYCPY_BODY]]
// CHECK4:       omp.arraycpy.done4:
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_ZN9TestClassaSERKS_
// CHECK4-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP0:%.*]]) #[[ATTR10:[0-9]+]] comdat align 2 {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    ret ptr [[THIS1]]
//
//
// CHECK4-LABEL: define {{[^@]+}}@_Z15parallel_singlev
// CHECK4-SAME: () #[[ATTR10]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 0, ptr @_Z15parallel_singlev.omp_outlined)
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_Z15parallel_singlev.omp_outlined
// CHECK4-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]]) #[[ATTR12:[0-9]+]] personality ptr @__gxx_personality_v0 {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK4-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK4-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP2]], 0
// CHECK4-NEXT:    br i1 [[TMP3]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK4:       omp_if.then:
// CHECK4-NEXT:    invoke void @_Z3foov()
// CHECK4-NEXT:    to label [[INVOKE_CONT:%.*]] unwind label [[TERMINATE_LPAD:%.*]]
// CHECK4:       invoke.cont:
// CHECK4-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP1]])
// CHECK4-NEXT:    br label [[OMP_IF_END]]
// CHECK4:       omp_if.end:
// CHECK4-NEXT:    call void @__kmpc_barrier(ptr @[[GLOB2]], i32 [[TMP1]])
// CHECK4-NEXT:    ret void
// CHECK4:       terminate.lpad:
// CHECK4-NEXT:    [[TMP4:%.*]] = landingpad { ptr, i32 }
// CHECK4-NEXT:    catch ptr null
// CHECK4-NEXT:    [[TMP5:%.*]] = extractvalue { ptr, i32 } [[TMP4]], 0
// CHECK4-NEXT:    call void @__clang_call_terminate(ptr [[TMP5]]) #[[ATTR13]]
// CHECK4-NEXT:    unreachable
//
//
// CHECK4-LABEL: define {{[^@]+}}@_ZN9TestClassC2Ev
// CHECK4-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[A:%.*]] = getelementptr inbounds [[CLASS_TESTCLASS:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK4-NEXT:    store i32 0, ptr [[A]], align 4
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_ZN9TestClassD2Ev
// CHECK4-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_ZN2SSC2ERi
// CHECK4-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[D:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[A2:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[B4:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[C7:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK4-NEXT:    [[B_CASTED:%.*]] = alloca i64, align 8
// CHECK4-NEXT:    [[C_CASTED:%.*]] = alloca i64, align 8
// CHECK4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 8
// CHECK4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK4-NEXT:    store i32 0, ptr [[A]], align 8
// CHECK4-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 1
// CHECK4-NEXT:    [[BF_LOAD:%.*]] = load i8, ptr [[B]], align 4
// CHECK4-NEXT:    [[BF_CLEAR:%.*]] = and i8 [[BF_LOAD]], -16
// CHECK4-NEXT:    [[BF_SET:%.*]] = or i8 [[BF_CLEAR]], 0
// CHECK4-NEXT:    store i8 [[BF_SET]], ptr [[B]], align 4
// CHECK4-NEXT:    [[C:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 2
// CHECK4-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[D_ADDR]], align 8
// CHECK4-NEXT:    store ptr [[TMP0]], ptr [[C]], align 8
// CHECK4-NEXT:    [[A3:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 0
// CHECK4-NEXT:    store ptr [[A3]], ptr [[A2]], align 8
// CHECK4-NEXT:    [[B5:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 1
// CHECK4-NEXT:    [[BF_LOAD6:%.*]] = load i8, ptr [[B5]], align 4
// CHECK4-NEXT:    [[BF_SHL:%.*]] = shl i8 [[BF_LOAD6]], 4
// CHECK4-NEXT:    [[BF_ASHR:%.*]] = ashr i8 [[BF_SHL]], 4
// CHECK4-NEXT:    [[BF_CAST:%.*]] = sext i8 [[BF_ASHR]] to i32
// CHECK4-NEXT:    store i32 [[BF_CAST]], ptr [[B4]], align 4
// CHECK4-NEXT:    [[C8:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 2
// CHECK4-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[C8]], align 8
// CHECK4-NEXT:    store ptr [[TMP1]], ptr [[C7]], align 8
// CHECK4-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[A2]], align 8
// CHECK4-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4
// CHECK4-NEXT:    store i32 [[TMP3]], ptr [[A_CASTED]], align 4
// CHECK4-NEXT:    [[TMP4:%.*]] = load i64, ptr [[A_CASTED]], align 8
// CHECK4-NEXT:    [[TMP5:%.*]] = load i32, ptr [[B4]], align 4
// CHECK4-NEXT:    store i32 [[TMP5]], ptr [[B_CASTED]], align 4
// CHECK4-NEXT:    [[TMP6:%.*]] = load i64, ptr [[B_CASTED]], align 8
// CHECK4-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[C7]], align 8
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP7]], align 4
// CHECK4-NEXT:    store i32 [[TMP8]], ptr [[C_CASTED]], align 4
// CHECK4-NEXT:    [[TMP9:%.*]] = load i64, ptr [[C_CASTED]], align 8
// CHECK4-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 4, ptr @_ZN2SSC2ERi.omp_outlined, ptr [[THIS1]], i64 [[TMP4]], i64 [[TMP6]], i64 [[TMP9]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_ZN2SSC2ERi.omp_outlined
// CHECK4-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], i64 noundef [[A:%.*]], i64 noundef [[B:%.*]], i64 noundef [[C:%.*]]) #[[ATTR12]] personality ptr @__gxx_personality_v0 {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK4-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK4-NEXT:    [[C_ADDR:%.*]] = alloca i64, align 8
// CHECK4-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[_TMP2:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[_TMP3:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTOMP_COPYPRIVATE_DID_IT:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON:%.*]], align 8
// CHECK4-NEXT:    [[DOTOMP_COPYPRIVATE_CPR_LIST:%.*]] = alloca [3 x ptr], align 8
// CHECK4-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    store i64 [[A]], ptr [[A_ADDR]], align 8
// CHECK4-NEXT:    store i64 [[B]], ptr [[B_ADDR]], align 8
// CHECK4-NEXT:    store i64 [[C]], ptr [[C_ADDR]], align 8
// CHECK4-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    store ptr [[A_ADDR]], ptr [[TMP]], align 8
// CHECK4-NEXT:    store ptr [[C_ADDR]], ptr [[_TMP1]], align 8
// CHECK4-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK4-NEXT:    store ptr [[TMP1]], ptr [[_TMP2]], align 8
// CHECK4-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK4-NEXT:    store ptr [[TMP2]], ptr [[_TMP3]], align 8
// CHECK4-NEXT:    store i32 0, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK4-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP3]], align 4
// CHECK4-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK4-NEXT:    [[TMP6:%.*]] = icmp ne i32 [[TMP5]], 0
// CHECK4-NEXT:    br i1 [[TMP6]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK4:       omp_if.then:
// CHECK4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[REF_TMP]], i32 0, i32 0
// CHECK4-NEXT:    store ptr [[TMP0]], ptr [[TMP7]], align 8
// CHECK4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[REF_TMP]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[_TMP2]], align 8
// CHECK4-NEXT:    store ptr [[TMP9]], ptr [[TMP8]], align 8
// CHECK4-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[REF_TMP]], i32 0, i32 2
// CHECK4-NEXT:    store ptr [[B_ADDR]], ptr [[TMP10]], align 8
// CHECK4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[REF_TMP]], i32 0, i32 3
// CHECK4-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[_TMP3]], align 8
// CHECK4-NEXT:    store ptr [[TMP12]], ptr [[TMP11]], align 8
// CHECK4-NEXT:    invoke void @_ZZN2SSC1ERiENKUlvE_clEv(ptr noundef nonnull align 8 dereferenceable(32) [[REF_TMP]])
// CHECK4-NEXT:    to label [[INVOKE_CONT:%.*]] unwind label [[TERMINATE_LPAD:%.*]]
// CHECK4:       invoke.cont:
// CHECK4-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK4-NEXT:    store i32 1, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK4-NEXT:    br label [[OMP_IF_END]]
// CHECK4:       omp_if.end:
// CHECK4-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 0
// CHECK4-NEXT:    [[TMP14:%.*]] = load ptr, ptr [[_TMP2]], align 8
// CHECK4-NEXT:    store ptr [[TMP14]], ptr [[TMP13]], align 8
// CHECK4-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 1
// CHECK4-NEXT:    store ptr [[B_ADDR]], ptr [[TMP15]], align 8
// CHECK4-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 2
// CHECK4-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[_TMP3]], align 8
// CHECK4-NEXT:    store ptr [[TMP17]], ptr [[TMP16]], align 8
// CHECK4-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK4-NEXT:    call void @__kmpc_copyprivate(ptr @[[GLOB1]], i32 [[TMP4]], i64 24, ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], ptr @.omp.copyprivate.copy_func.4, i32 [[TMP18]])
// CHECK4-NEXT:    ret void
// CHECK4:       terminate.lpad:
// CHECK4-NEXT:    [[TMP19:%.*]] = landingpad { ptr, i32 }
// CHECK4-NEXT:    catch ptr null
// CHECK4-NEXT:    [[TMP20:%.*]] = extractvalue { ptr, i32 } [[TMP19]], 0
// CHECK4-NEXT:    call void @__clang_call_terminate(ptr [[TMP20]]) #[[ATTR13]]
// CHECK4-NEXT:    unreachable
//
//
// CHECK4-LABEL: define {{[^@]+}}@_ZZN2SSC1ERiENKUlvE_clEv
// CHECK4-SAME: (ptr noundef nonnull align 8 dereferenceable(32) [[THIS:%.*]]) #[[ATTR10]] align 2 {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK4-NEXT:    [[B_CASTED:%.*]] = alloca i64, align 8
// CHECK4-NEXT:    [[C_CASTED:%.*]] = alloca i64, align 8
// CHECK4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP0]], align 8
// CHECK4-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[THIS1]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP2]], align 8
// CHECK4-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP3]], align 4
// CHECK4-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP4]], 1
// CHECK4-NEXT:    store i32 [[INC]], ptr [[TMP3]], align 4
// CHECK4-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[THIS1]], i32 0, i32 2
// CHECK4-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[TMP5]], align 8
// CHECK4-NEXT:    [[TMP7:%.*]] = load i32, ptr [[TMP6]], align 4
// CHECK4-NEXT:    [[DEC:%.*]] = add nsw i32 [[TMP7]], -1
// CHECK4-NEXT:    store i32 [[DEC]], ptr [[TMP6]], align 4
// CHECK4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[THIS1]], i32 0, i32 3
// CHECK4-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[TMP8]], align 8
// CHECK4-NEXT:    [[TMP10:%.*]] = load i32, ptr [[TMP9]], align 4
// CHECK4-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP10]], 1
// CHECK4-NEXT:    store i32 [[DIV]], ptr [[TMP9]], align 4
// CHECK4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[THIS1]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP11]], align 8
// CHECK4-NEXT:    [[TMP13:%.*]] = load i32, ptr [[TMP12]], align 4
// CHECK4-NEXT:    store i32 [[TMP13]], ptr [[A_CASTED]], align 4
// CHECK4-NEXT:    [[TMP14:%.*]] = load i64, ptr [[A_CASTED]], align 8
// CHECK4-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[THIS1]], i32 0, i32 2
// CHECK4-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[TMP15]], align 8
// CHECK4-NEXT:    [[TMP17:%.*]] = load i32, ptr [[TMP16]], align 4
// CHECK4-NEXT:    store i32 [[TMP17]], ptr [[B_CASTED]], align 4
// CHECK4-NEXT:    [[TMP18:%.*]] = load i64, ptr [[B_CASTED]], align 8
// CHECK4-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[THIS1]], i32 0, i32 3
// CHECK4-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[TMP19]], align 8
// CHECK4-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP20]], align 4
// CHECK4-NEXT:    store i32 [[TMP21]], ptr [[C_CASTED]], align 4
// CHECK4-NEXT:    [[TMP22:%.*]] = load i64, ptr [[C_CASTED]], align 8
// CHECK4-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 4, ptr @_ZZN2SSC1ERiENKUlvE_clEv.omp_outlined, ptr [[TMP1]], i64 [[TMP14]], i64 [[TMP18]], i64 [[TMP22]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp.copyprivate.copy_func.4
// CHECK4-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR9]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK4-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK4-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK4-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP7]], align 4
// CHECK4-NEXT:    store i32 [[TMP8]], ptr [[TMP5]], align 4
// CHECK4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 1
// CHECK4-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[TMP9]], align 8
// CHECK4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 1
// CHECK4-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP11]], align 8
// CHECK4-NEXT:    [[TMP13:%.*]] = load i32, ptr [[TMP12]], align 4
// CHECK4-NEXT:    store i32 [[TMP13]], ptr [[TMP10]], align 4
// CHECK4-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 2
// CHECK4-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[TMP14]], align 8
// CHECK4-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 2
// CHECK4-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[TMP16]], align 8
// CHECK4-NEXT:    [[TMP18:%.*]] = load i32, ptr [[TMP17]], align 4
// CHECK4-NEXT:    store i32 [[TMP18]], ptr [[TMP15]], align 4
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_ZZN2SSC1ERiENKUlvE_clEv.omp_outlined
// CHECK4-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], i64 noundef [[A:%.*]], i64 noundef [[B:%.*]], i64 noundef [[C:%.*]]) #[[ATTR12]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK4-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK4-NEXT:    [[C_ADDR:%.*]] = alloca i64, align 8
// CHECK4-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[_TMP2:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[_TMP3:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTOMP_COPYPRIVATE_DID_IT:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_COPYPRIVATE_CPR_LIST:%.*]] = alloca [3 x ptr], align 8
// CHECK4-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    store i64 [[A]], ptr [[A_ADDR]], align 8
// CHECK4-NEXT:    store i64 [[B]], ptr [[B_ADDR]], align 8
// CHECK4-NEXT:    store i64 [[C]], ptr [[C_ADDR]], align 8
// CHECK4-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    store ptr [[A_ADDR]], ptr [[TMP]], align 8
// CHECK4-NEXT:    store ptr [[C_ADDR]], ptr [[_TMP1]], align 8
// CHECK4-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK4-NEXT:    store ptr [[TMP1]], ptr [[_TMP2]], align 8
// CHECK4-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK4-NEXT:    store ptr [[TMP2]], ptr [[_TMP3]], align 8
// CHECK4-NEXT:    store i32 0, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK4-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP3]], align 4
// CHECK4-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK4-NEXT:    [[TMP6:%.*]] = icmp ne i32 [[TMP5]], 0
// CHECK4-NEXT:    br i1 [[TMP6]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK4:       omp_if.then:
// CHECK4-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[_TMP2]], align 8
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP7]], align 4
// CHECK4-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP8]], 1
// CHECK4-NEXT:    store i32 [[INC]], ptr [[TMP7]], align 4
// CHECK4-NEXT:    [[TMP9:%.*]] = load i32, ptr [[B_ADDR]], align 4
// CHECK4-NEXT:    [[DEC:%.*]] = add nsw i32 [[TMP9]], -1
// CHECK4-NEXT:    store i32 [[DEC]], ptr [[B_ADDR]], align 4
// CHECK4-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[_TMP3]], align 8
// CHECK4-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP10]], align 4
// CHECK4-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP11]], 1
// CHECK4-NEXT:    store i32 [[DIV]], ptr [[TMP10]], align 4
// CHECK4-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP4]])
// CHECK4-NEXT:    store i32 1, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK4-NEXT:    br label [[OMP_IF_END]]
// CHECK4:       omp_if.end:
// CHECK4-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 0
// CHECK4-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[_TMP2]], align 8
// CHECK4-NEXT:    store ptr [[TMP13]], ptr [[TMP12]], align 8
// CHECK4-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 1
// CHECK4-NEXT:    store ptr [[B_ADDR]], ptr [[TMP14]], align 8
// CHECK4-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 2
// CHECK4-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[_TMP3]], align 8
// CHECK4-NEXT:    store ptr [[TMP16]], ptr [[TMP15]], align 8
// CHECK4-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK4-NEXT:    call void @__kmpc_copyprivate(ptr @[[GLOB1]], i32 [[TMP4]], i64 24, ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], ptr @.omp.copyprivate.copy_func.5, i32 [[TMP17]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp.copyprivate.copy_func.5
// CHECK4-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR9]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK4-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK4-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK4-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK4-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP7]], align 4
// CHECK4-NEXT:    store i32 [[TMP8]], ptr [[TMP5]], align 4
// CHECK4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 1
// CHECK4-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[TMP9]], align 8
// CHECK4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 1
// CHECK4-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP11]], align 8
// CHECK4-NEXT:    [[TMP13:%.*]] = load i32, ptr [[TMP12]], align 4
// CHECK4-NEXT:    store i32 [[TMP13]], ptr [[TMP10]], align 4
// CHECK4-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 2
// CHECK4-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[TMP14]], align 8
// CHECK4-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 2
// CHECK4-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[TMP16]], align 8
// CHECK4-NEXT:    [[TMP18:%.*]] = load i32, ptr [[TMP17]], align 4
// CHECK4-NEXT:    store i32 [[TMP18]], ptr [[TMP15]], align 4
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_ZN3SSTIdEC2Ev
// CHECK4-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] comdat align 2 {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[A2:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SST:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK4-NEXT:    store double 0.000000e+00, ptr [[A]], align 8
// CHECK4-NEXT:    [[A3:%.*]] = getelementptr inbounds [[STRUCT_SST]], ptr [[THIS1]], i32 0, i32 0
// CHECK4-NEXT:    store ptr [[A3]], ptr [[A2]], align 8
// CHECK4-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[A2]], align 8
// CHECK4-NEXT:    [[TMP1:%.*]] = load double, ptr [[TMP0]], align 8
// CHECK4-NEXT:    store double [[TMP1]], ptr [[A_CASTED]], align 8
// CHECK4-NEXT:    [[TMP2:%.*]] = load i64, ptr [[A_CASTED]], align 8
// CHECK4-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 2, ptr @_ZN3SSTIdEC2Ev.omp_outlined, ptr [[THIS1]], i64 [[TMP2]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_ZN3SSTIdEC2Ev.omp_outlined
// CHECK4-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], i64 noundef [[A:%.*]]) #[[ATTR12]] personality ptr @__gxx_personality_v0 {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK4-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTOMP_COPYPRIVATE_DID_IT:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_0:%.*]], align 8
// CHECK4-NEXT:    [[DOTOMP_COPYPRIVATE_CPR_LIST:%.*]] = alloca [1 x ptr], align 8
// CHECK4-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    store i64 [[A]], ptr [[A_ADDR]], align 8
// CHECK4-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    store ptr [[A_ADDR]], ptr [[TMP]], align 8
// CHECK4-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK4-NEXT:    store ptr [[TMP1]], ptr [[_TMP1]], align 8
// CHECK4-NEXT:    store i32 0, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4
// CHECK4-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK4-NEXT:    [[TMP5:%.*]] = icmp ne i32 [[TMP4]], 0
// CHECK4-NEXT:    br i1 [[TMP5]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK4:       omp_if.then:
// CHECK4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[REF_TMP]], i32 0, i32 0
// CHECK4-NEXT:    store ptr [[TMP0]], ptr [[TMP6]], align 8
// CHECK4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[REF_TMP]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK4-NEXT:    store ptr [[TMP8]], ptr [[TMP7]], align 8
// CHECK4-NEXT:    invoke void @_ZZN3SSTIdEC1EvENKUlvE_clEv(ptr noundef nonnull align 8 dereferenceable(16) [[REF_TMP]])
// CHECK4-NEXT:    to label [[INVOKE_CONT:%.*]] unwind label [[TERMINATE_LPAD:%.*]]
// CHECK4:       invoke.cont:
// CHECK4-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK4-NEXT:    store i32 1, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK4-NEXT:    br label [[OMP_IF_END]]
// CHECK4:       omp_if.end:
// CHECK4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 0
// CHECK4-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK4-NEXT:    store ptr [[TMP10]], ptr [[TMP9]], align 8
// CHECK4-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK4-NEXT:    call void @__kmpc_copyprivate(ptr @[[GLOB1]], i32 [[TMP3]], i64 8, ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], ptr @.omp.copyprivate.copy_func.6, i32 [[TMP11]])
// CHECK4-NEXT:    ret void
// CHECK4:       terminate.lpad:
// CHECK4-NEXT:    [[TMP12:%.*]] = landingpad { ptr, i32 }
// CHECK4-NEXT:    catch ptr null
// CHECK4-NEXT:    [[TMP13:%.*]] = extractvalue { ptr, i32 } [[TMP12]], 0
// CHECK4-NEXT:    call void @__clang_call_terminate(ptr [[TMP13]]) #[[ATTR13]]
// CHECK4-NEXT:    unreachable
//
//
// CHECK4-LABEL: define {{[^@]+}}@_ZZN3SSTIdEC1EvENKUlvE_clEv
// CHECK4-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) #[[ATTR4]] align 2 {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_1:%.*]], align 8
// CHECK4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP0]], align 8
// CHECK4-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[REF_TMP]], i32 0, i32 0
// CHECK4-NEXT:    store ptr [[TMP1]], ptr [[TMP2]], align 8
// CHECK4-NEXT:    [[TMP3:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[REF_TMP]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[THIS1]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK4-NEXT:    store ptr [[TMP5]], ptr [[TMP3]], align 8
// CHECK4-NEXT:    call void @_ZZZN3SSTIdEC1EvENKUlvE_clEvENKUlvE_clEv(ptr noundef nonnull align 8 dereferenceable(16) [[REF_TMP]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp.copyprivate.copy_func.6
// CHECK4-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR9]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK4-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK4-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK4-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK4-NEXT:    [[TMP8:%.*]] = load double, ptr [[TMP7]], align 8
// CHECK4-NEXT:    store double [[TMP8]], ptr [[TMP5]], align 8
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_ZZZN3SSTIdEC1EvENKUlvE_clEvENKUlvE_clEv
// CHECK4-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) #[[ATTR10]] align 2 {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON_1:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK4-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP0]], align 8
// CHECK4-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[THIS1]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP2]], align 8
// CHECK4-NEXT:    [[TMP4:%.*]] = load double, ptr [[TMP3]], align 8
// CHECK4-NEXT:    [[INC:%.*]] = fadd double [[TMP4]], 1.000000e+00
// CHECK4-NEXT:    store double [[INC]], ptr [[TMP3]], align 8
// CHECK4-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[THIS1]], i32 0, i32 1
// CHECK4-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[TMP5]], align 8
// CHECK4-NEXT:    [[TMP7:%.*]] = load double, ptr [[TMP6]], align 8
// CHECK4-NEXT:    store double [[TMP7]], ptr [[A_CASTED]], align 8
// CHECK4-NEXT:    [[TMP8:%.*]] = load i64, ptr [[A_CASTED]], align 8
// CHECK4-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB1]], i32 2, ptr @_ZZZN3SSTIdEC1EvENKUlvE_clEvENKUlvE_clEv.omp_outlined, ptr [[TMP1]], i64 [[TMP8]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_ZZZN3SSTIdEC1EvENKUlvE_clEvENKUlvE_clEv.omp_outlined
// CHECK4-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], i64 noundef [[A:%.*]]) #[[ATTR12]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK4-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTOMP_COPYPRIVATE_DID_IT:%.*]] = alloca i32, align 4
// CHECK4-NEXT:    [[DOTOMP_COPYPRIVATE_CPR_LIST:%.*]] = alloca [1 x ptr], align 8
// CHECK4-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK4-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    store i64 [[A]], ptr [[A_ADDR]], align 8
// CHECK4-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK4-NEXT:    store ptr [[A_ADDR]], ptr [[TMP]], align 8
// CHECK4-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP]], align 8
// CHECK4-NEXT:    store ptr [[TMP1]], ptr [[_TMP1]], align 8
// CHECK4-NEXT:    store i32 0, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK4-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK4-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4
// CHECK4-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK4-NEXT:    [[TMP5:%.*]] = icmp ne i32 [[TMP4]], 0
// CHECK4-NEXT:    br i1 [[TMP5]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK4:       omp_if.then:
// CHECK4-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK4-NEXT:    [[TMP7:%.*]] = load double, ptr [[TMP6]], align 8
// CHECK4-NEXT:    [[INC:%.*]] = fadd double [[TMP7]], 1.000000e+00
// CHECK4-NEXT:    store double [[INC]], ptr [[TMP6]], align 8
// CHECK4-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP3]])
// CHECK4-NEXT:    store i32 1, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK4-NEXT:    br label [[OMP_IF_END]]
// CHECK4:       omp_if.end:
// CHECK4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 0
// CHECK4-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[_TMP1]], align 8
// CHECK4-NEXT:    store ptr [[TMP9]], ptr [[TMP8]], align 8
// CHECK4-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK4-NEXT:    call void @__kmpc_copyprivate(ptr @[[GLOB1]], i32 [[TMP3]], i64 8, ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], ptr @.omp.copyprivate.copy_func.7, i32 [[TMP10]])
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@.omp.copyprivate.copy_func.7
// CHECK4-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR9]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK4-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK4-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK4-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK4-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK4-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK4-NEXT:    [[TMP8:%.*]] = load double, ptr [[TMP7]], align 8
// CHECK4-NEXT:    store double [[TMP8]], ptr [[TMP5]], align 8
// CHECK4-NEXT:    ret void
//
//
// CHECK4-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_single_codegen.cpp
// CHECK4-SAME: () #[[ATTR0]] {
// CHECK4-NEXT:  entry:
// CHECK4-NEXT:    call void @__cxx_global_var_init()
// CHECK4-NEXT:    call void @__cxx_global_var_init.1()
// CHECK4-NEXT:    ret void
//
//
// CHECK5-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_.
// CHECK5-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0:[0-9]+]] section "__TEXT,__StaticInit,regular,pure_instructions" !dbg [[DBG6:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG10:![0-9]+]]
// CHECK5-NEXT:    call void @_ZN9TestClassC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TMP1]]), !dbg [[DBG11:![0-9]+]]
// CHECK5-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG10]]
// CHECK5-NEXT:    ret ptr [[TMP2]], !dbg [[DBG10]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN9TestClassC1Ev
// CHECK5-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR1:[0-9]+]] align 2 !dbg [[DBG12:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    call void @_ZN9TestClassC2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]), !dbg [[DBG13:![0-9]+]]
// CHECK5-NEXT:    ret void, !dbg [[DBG14:![0-9]+]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_.
// CHECK5-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] section "__TEXT,__StaticInit,regular,pure_instructions" !dbg [[DBG15:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG16:![0-9]+]]
// CHECK5-NEXT:    call void @_ZN9TestClassD1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[TMP1]]) #[[ATTR3:[0-9]+]], !dbg [[DBG16]]
// CHECK5-NEXT:    ret void, !dbg [[DBG17:![0-9]+]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN9TestClassD1Ev
// CHECK5-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2:[0-9]+]] align 2 !dbg [[DBG18:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    call void @_ZN9TestClassD2Ev(ptr noundef nonnull align 4 dereferenceable(4) [[THIS1]]) #[[ATTR3]], !dbg [[DBG19:![0-9]+]]
// CHECK5-NEXT:    ret void, !dbg [[DBG20:![0-9]+]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@.__omp_threadprivate_init_.
// CHECK5-SAME: () #[[ATTR0]] section "__TEXT,__StaticInit,regular,pure_instructions" !dbg [[DBG21:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1:[0-9]+]]), !dbg [[DBG22:![0-9]+]]
// CHECK5-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB1]], ptr @tc, ptr @.__kmpc_global_ctor_., ptr null, ptr @.__kmpc_global_dtor_.), !dbg [[DBG22]]
// CHECK5-NEXT:    ret void, !dbg [[DBG22]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@.__kmpc_global_ctor_..1
// CHECK5-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] section "__TEXT,__StaticInit,regular,pure_instructions" personality ptr @__gxx_personality_v0 !dbg [[DBG23:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG24:![0-9]+]]
// CHECK5-NEXT:    [[ARRAY_BEGIN:%.*]] = getelementptr inbounds [2 x %class.TestClass], ptr [[TMP1]], i32 0, i32 0, !dbg [[DBG25:![0-9]+]]
// CHECK5-NEXT:    [[ARRAYCTOR_END:%.*]] = getelementptr inbounds [[CLASS_TESTCLASS:%.*]], ptr [[ARRAY_BEGIN]], i64 2, !dbg [[DBG25]]
// CHECK5-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]], !dbg [[DBG25]]
// CHECK5:       arrayctor.loop:
// CHECK5-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi ptr [ [[ARRAY_BEGIN]], [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[INVOKE_CONT:%.*]] ], !dbg [[DBG25]]
// CHECK5-NEXT:    invoke void @_ZN9TestClassC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK5-NEXT:    to label [[INVOKE_CONT]] unwind label [[LPAD:%.*]], !dbg [[DBG25]]
// CHECK5:       invoke.cont:
// CHECK5-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[CLASS_TESTCLASS]], ptr [[ARRAYCTOR_CUR]], i64 1, !dbg [[DBG25]]
// CHECK5-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq ptr [[ARRAYCTOR_NEXT]], [[ARRAYCTOR_END]], !dbg [[DBG25]]
// CHECK5-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]], !dbg [[DBG25]]
// CHECK5:       arrayctor.cont:
// CHECK5-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG24]]
// CHECK5-NEXT:    ret ptr [[TMP2]], !dbg [[DBG24]]
// CHECK5:       lpad:
// CHECK5-NEXT:    [[TMP3:%.*]] = landingpad { ptr, i32 }
// CHECK5-NEXT:    cleanup, !dbg [[DBG26:![0-9]+]]
// CHECK5-NEXT:    [[TMP4:%.*]] = extractvalue { ptr, i32 } [[TMP3]], 0, !dbg [[DBG26]]
// CHECK5-NEXT:    store ptr [[TMP4]], ptr [[EXN_SLOT]], align 8, !dbg [[DBG26]]
// CHECK5-NEXT:    [[TMP5:%.*]] = extractvalue { ptr, i32 } [[TMP3]], 1, !dbg [[DBG26]]
// CHECK5-NEXT:    store i32 [[TMP5]], ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG26]]
// CHECK5-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr [[ARRAY_BEGIN]], [[ARRAYCTOR_CUR]], !dbg [[DBG25]]
// CHECK5-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY:%.*]], !dbg [[DBG25]]
// CHECK5:       arraydestroy.body:
// CHECK5-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[ARRAYCTOR_CUR]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ], !dbg [[DBG25]]
// CHECK5-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[CLASS_TESTCLASS]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1, !dbg [[DBG25]]
// CHECK5-NEXT:    call void @_ZN9TestClassD1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]], !dbg [[DBG25]]
// CHECK5-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[ARRAY_BEGIN]], !dbg [[DBG25]]
// CHECK5-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1]], label [[ARRAYDESTROY_BODY]], !dbg [[DBG25]]
// CHECK5:       arraydestroy.done1:
// CHECK5-NEXT:    br label [[EH_RESUME:%.*]], !dbg [[DBG25]]
// CHECK5:       eh.resume:
// CHECK5-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8, !dbg [[DBG25]]
// CHECK5-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG25]]
// CHECK5-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0, !dbg [[DBG25]]
// CHECK5-NEXT:    [[LPAD_VAL2:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1, !dbg [[DBG25]]
// CHECK5-NEXT:    resume { ptr, i32 } [[LPAD_VAL2]], !dbg [[DBG25]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@.__kmpc_global_dtor_..2
// CHECK5-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] section "__TEXT,__StaticInit,regular,pure_instructions" !dbg [[DBG27:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK5-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG28:![0-9]+]]
// CHECK5-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[CLASS_TESTCLASS:%.*]], ptr [[TMP1]], i64 2, !dbg [[DBG28]]
// CHECK5-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]], !dbg [[DBG28]]
// CHECK5:       arraydestroy.body:
// CHECK5-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[TMP2]], [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ], !dbg [[DBG28]]
// CHECK5-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[CLASS_TESTCLASS]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1, !dbg [[DBG28]]
// CHECK5-NEXT:    call void @_ZN9TestClassD1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]], !dbg [[DBG28]]
// CHECK5-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], [[TMP1]], !dbg [[DBG28]]
// CHECK5-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]], !dbg [[DBG28]]
// CHECK5:       arraydestroy.done1:
// CHECK5-NEXT:    ret void, !dbg [[DBG29:![0-9]+]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@.__omp_threadprivate_init_..3
// CHECK5-SAME: () #[[ATTR0]] section "__TEXT,__StaticInit,regular,pure_instructions" !dbg [[DBG30:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB3:[0-9]+]]), !dbg [[DBG31:![0-9]+]]
// CHECK5-NEXT:    call void @__kmpc_threadprivate_register(ptr @[[GLOB3]], ptr @tc2, ptr @.__kmpc_global_ctor_..1, ptr null, ptr @.__kmpc_global_dtor_..2), !dbg [[DBG31]]
// CHECK5-NEXT:    ret void, !dbg [[DBG31]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@__cxx_global_var_init
// CHECK5-SAME: () #[[ATTR0]] section "__TEXT,__StaticInit,regular,pure_instructions" !dbg [[DBG32:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    call void @_ZN9TestClassC1Ev(ptr noundef nonnull align 4 dereferenceable(4) @tc), !dbg [[DBG34:![0-9]+]]
// CHECK5-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @_ZN9TestClassD1Ev, ptr @tc, ptr @__dso_handle) #[[ATTR3]], !dbg [[DBG36:![0-9]+]]
// CHECK5-NEXT:    ret void, !dbg [[DBG34]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@__cxx_global_var_init.4
// CHECK5-SAME: () #[[ATTR0]] section "__TEXT,__StaticInit,regular,pure_instructions" personality ptr @__gxx_personality_v0 !dbg [[DBG37:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[EXN_SLOT:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[EHSELECTOR_SLOT:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    br label [[ARRAYCTOR_LOOP:%.*]], !dbg [[DBG38:![0-9]+]]
// CHECK5:       arrayctor.loop:
// CHECK5-NEXT:    [[ARRAYCTOR_CUR:%.*]] = phi ptr [ @tc2, [[ENTRY:%.*]] ], [ [[ARRAYCTOR_NEXT:%.*]], [[INVOKE_CONT:%.*]] ], !dbg [[DBG38]]
// CHECK5-NEXT:    invoke void @_ZN9TestClassC1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYCTOR_CUR]])
// CHECK5-NEXT:    to label [[INVOKE_CONT]] unwind label [[LPAD:%.*]], !dbg [[DBG38]]
// CHECK5:       invoke.cont:
// CHECK5-NEXT:    [[ARRAYCTOR_NEXT]] = getelementptr inbounds [[CLASS_TESTCLASS:%.*]], ptr [[ARRAYCTOR_CUR]], i64 1, !dbg [[DBG38]]
// CHECK5-NEXT:    [[ARRAYCTOR_DONE:%.*]] = icmp eq ptr [[ARRAYCTOR_NEXT]], getelementptr inbounds ([[CLASS_TESTCLASS]], ptr @tc2, i64 2), !dbg [[DBG38]]
// CHECK5-NEXT:    br i1 [[ARRAYCTOR_DONE]], label [[ARRAYCTOR_CONT:%.*]], label [[ARRAYCTOR_LOOP]], !dbg [[DBG38]]
// CHECK5:       arrayctor.cont:
// CHECK5-NEXT:    [[TMP0:%.*]] = call i32 @__cxa_atexit(ptr @__cxx_global_array_dtor, ptr null, ptr @__dso_handle) #[[ATTR3]], !dbg [[DBG40:![0-9]+]]
// CHECK5-NEXT:    ret void, !dbg [[DBG40]]
// CHECK5:       lpad:
// CHECK5-NEXT:    [[TMP1:%.*]] = landingpad { ptr, i32 }
// CHECK5-NEXT:    cleanup, !dbg [[DBG41:![0-9]+]]
// CHECK5-NEXT:    [[TMP2:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 0, !dbg [[DBG41]]
// CHECK5-NEXT:    store ptr [[TMP2]], ptr [[EXN_SLOT]], align 8, !dbg [[DBG41]]
// CHECK5-NEXT:    [[TMP3:%.*]] = extractvalue { ptr, i32 } [[TMP1]], 1, !dbg [[DBG41]]
// CHECK5-NEXT:    store i32 [[TMP3]], ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG41]]
// CHECK5-NEXT:    [[ARRAYDESTROY_ISEMPTY:%.*]] = icmp eq ptr @tc2, [[ARRAYCTOR_CUR]], !dbg [[DBG38]]
// CHECK5-NEXT:    br i1 [[ARRAYDESTROY_ISEMPTY]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY:%.*]], !dbg [[DBG38]]
// CHECK5:       arraydestroy.body:
// CHECK5-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ [[ARRAYCTOR_CUR]], [[LPAD]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ], !dbg [[DBG38]]
// CHECK5-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[CLASS_TESTCLASS]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1, !dbg [[DBG38]]
// CHECK5-NEXT:    call void @_ZN9TestClassD1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]], !dbg [[DBG38]]
// CHECK5-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @tc2, !dbg [[DBG38]]
// CHECK5-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1]], label [[ARRAYDESTROY_BODY]], !dbg [[DBG38]]
// CHECK5:       arraydestroy.done1:
// CHECK5-NEXT:    br label [[EH_RESUME:%.*]], !dbg [[DBG38]]
// CHECK5:       eh.resume:
// CHECK5-NEXT:    [[EXN:%.*]] = load ptr, ptr [[EXN_SLOT]], align 8, !dbg [[DBG38]]
// CHECK5-NEXT:    [[SEL:%.*]] = load i32, ptr [[EHSELECTOR_SLOT]], align 4, !dbg [[DBG38]]
// CHECK5-NEXT:    [[LPAD_VAL:%.*]] = insertvalue { ptr, i32 } poison, ptr [[EXN]], 0, !dbg [[DBG38]]
// CHECK5-NEXT:    [[LPAD_VAL2:%.*]] = insertvalue { ptr, i32 } [[LPAD_VAL]], i32 [[SEL]], 1, !dbg [[DBG38]]
// CHECK5-NEXT:    resume { ptr, i32 } [[LPAD_VAL2]], !dbg [[DBG38]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@__cxx_global_array_dtor
// CHECK5-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR0]] section "__TEXT,__StaticInit,regular,pure_instructions" !dbg [[DBG42:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK5-NEXT:    br label [[ARRAYDESTROY_BODY:%.*]], !dbg [[DBG43:![0-9]+]]
// CHECK5:       arraydestroy.body:
// CHECK5-NEXT:    [[ARRAYDESTROY_ELEMENTPAST:%.*]] = phi ptr [ getelementptr inbounds ([[CLASS_TESTCLASS:%.*]], ptr @tc2, i64 2), [[ENTRY:%.*]] ], [ [[ARRAYDESTROY_ELEMENT:%.*]], [[ARRAYDESTROY_BODY]] ], !dbg [[DBG43]]
// CHECK5-NEXT:    [[ARRAYDESTROY_ELEMENT]] = getelementptr inbounds [[CLASS_TESTCLASS]], ptr [[ARRAYDESTROY_ELEMENTPAST]], i64 -1, !dbg [[DBG43]]
// CHECK5-NEXT:    call void @_ZN9TestClassD1Ev(ptr noundef nonnull align 4 dereferenceable(4) [[ARRAYDESTROY_ELEMENT]]) #[[ATTR3]], !dbg [[DBG43]]
// CHECK5-NEXT:    [[ARRAYDESTROY_DONE:%.*]] = icmp eq ptr [[ARRAYDESTROY_ELEMENT]], @tc2, !dbg [[DBG43]]
// CHECK5-NEXT:    br i1 [[ARRAYDESTROY_DONE]], label [[ARRAYDESTROY_DONE1:%.*]], label [[ARRAYDESTROY_BODY]], !dbg [[DBG43]]
// CHECK5:       arraydestroy.done1:
// CHECK5-NEXT:    ret void, !dbg [[DBG43]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN9TestClassC2Ev
// CHECK5-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] align 2 !dbg [[DBG44:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[A:%.*]] = getelementptr inbounds [[CLASS_TESTCLASS:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG45:![0-9]+]]
// CHECK5-NEXT:    store i32 0, ptr [[A]], align 4, !dbg [[DBG45]]
// CHECK5-NEXT:    ret void, !dbg [[DBG46:![0-9]+]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN9TestClassD2Ev
// CHECK5-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] align 2 !dbg [[DBG47:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    ret void, !dbg [[DBG48:![0-9]+]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_Z3foov
// CHECK5-SAME: () #[[ATTR4:[0-9]+]] !dbg [[DBG49:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    call void @_Z8mayThrowv(), !dbg [[DBG50:![0-9]+]]
// CHECK5-NEXT:    ret void, !dbg [[DBG51:![0-9]+]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@main
// CHECK5-SAME: () #[[ATTR6:[0-9]+]] personality ptr @__gxx_personality_v0 !dbg [[DBG52:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[RETVAL:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[A:%.*]] = alloca i8, align 1
// CHECK5-NEXT:    [[A2:%.*]] = alloca [2 x i8], align 1
// CHECK5-NEXT:    [[C:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[SST:%.*]] = alloca [[STRUCT_SST:%.*]], align 8
// CHECK5-NEXT:    [[SS:%.*]] = alloca [[STRUCT_SS:%.*]], align 8
// CHECK5-NEXT:    [[DOTOMP_COPYPRIVATE_DID_IT:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_COPYPRIVATE_CPR_LIST:%.*]] = alloca [5 x ptr], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB5:[0-9]+]])
// CHECK5-NEXT:    store i32 0, ptr [[RETVAL]], align 4
// CHECK5-NEXT:    store ptr @tc, ptr [[C]], align 8, !dbg [[DBG53:![0-9]+]]
// CHECK5-NEXT:    call void @_ZN3SSTIdEC1Ev(ptr noundef nonnull align 8 dereferenceable(8) [[SST]]), !dbg [[DBG54:![0-9]+]]
// CHECK5-NEXT:    call void @_ZN2SSC1ERi(ptr noundef nonnull align 8 dereferenceable(16) [[SS]], ptr noundef nonnull align 4 dereferenceable(4) @tc), !dbg [[DBG55:![0-9]+]]
// CHECK5-NEXT:    [[TMP1:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB5]], i32 [[TMP0]]), !dbg [[DBG56:![0-9]+]]
// CHECK5-NEXT:    [[TMP2:%.*]] = icmp ne i32 [[TMP1]], 0, !dbg [[DBG56]]
// CHECK5-NEXT:    br i1 [[TMP2]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]], !dbg [[DBG56]]
// CHECK5:       omp_if.then:
// CHECK5-NEXT:    store i8 2, ptr [[A]], align 1, !dbg [[DBG57:![0-9]+]]
// CHECK5-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB5]], i32 [[TMP0]]), !dbg [[DBG58:![0-9]+]]
// CHECK5-NEXT:    br label [[OMP_IF_END]], !dbg [[DBG58]]
// CHECK5:       omp_if.end:
// CHECK5-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB7:[0-9]+]], i32 [[TMP0]]), !dbg [[DBG59:![0-9]+]]
// CHECK5-NEXT:    [[TMP4:%.*]] = icmp ne i32 [[TMP3]], 0, !dbg [[DBG59]]
// CHECK5-NEXT:    br i1 [[TMP4]], label [[OMP_IF_THEN1:%.*]], label [[OMP_IF_END2:%.*]], !dbg [[DBG59]]
// CHECK5:       omp_if.then1:
// CHECK5-NEXT:    store i8 2, ptr [[A]], align 1, !dbg [[DBG60:![0-9]+]]
// CHECK5-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB7]], i32 [[TMP0]]), !dbg [[DBG61:![0-9]+]]
// CHECK5-NEXT:    br label [[OMP_IF_END2]], !dbg [[DBG61]]
// CHECK5:       omp_if.end2:
// CHECK5-NEXT:    call void @__kmpc_barrier(ptr @[[GLOB8:[0-9]+]], i32 [[TMP0]]), !dbg [[DBG62:![0-9]+]]
// CHECK5-NEXT:    store i32 0, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4, !dbg [[DBG63:![0-9]+]]
// CHECK5-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB10:[0-9]+]], i32 [[TMP0]]), !dbg [[DBG63]]
// CHECK5-NEXT:    [[TMP6:%.*]] = icmp ne i32 [[TMP5]], 0, !dbg [[DBG63]]
// CHECK5-NEXT:    br i1 [[TMP6]], label [[OMP_IF_THEN3:%.*]], label [[OMP_IF_END4:%.*]], !dbg [[DBG63]]
// CHECK5:       omp_if.then3:
// CHECK5-NEXT:    invoke void @_Z3foov()
// CHECK5-NEXT:    to label [[INVOKE_CONT:%.*]] unwind label [[TERMINATE_LPAD:%.*]], !dbg [[DBG64:![0-9]+]]
// CHECK5:       invoke.cont:
// CHECK5-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB10]], i32 [[TMP0]]), !dbg [[DBG64]]
// CHECK5-NEXT:    store i32 1, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4, !dbg [[DBG64]]
// CHECK5-NEXT:    br label [[OMP_IF_END4]], !dbg [[DBG64]]
// CHECK5:       omp_if.end4:
// CHECK5-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 0, !dbg [[DBG64]]
// CHECK5-NEXT:    store ptr [[A]], ptr [[TMP7]], align 8, !dbg [[DBG64]]
// CHECK5-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 1, !dbg [[DBG64]]
// CHECK5-NEXT:    store ptr @tc, ptr [[TMP8]], align 8, !dbg [[DBG64]]
// CHECK5-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 2, !dbg [[DBG64]]
// CHECK5-NEXT:    [[TMP10:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB12:[0-9]+]], i32 [[TMP0]], ptr @tc, i64 4, ptr @tc.cache.), !dbg [[DBG65:![0-9]+]]
// CHECK5-NEXT:    store ptr [[TMP10]], ptr [[TMP9]], align 8, !dbg [[DBG64]]
// CHECK5-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 3, !dbg [[DBG64]]
// CHECK5-NEXT:    store ptr [[A2]], ptr [[TMP11]], align 8, !dbg [[DBG64]]
// CHECK5-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [5 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 4, !dbg [[DBG64]]
// CHECK5-NEXT:    [[TMP13:%.*]] = call ptr @__kmpc_threadprivate_cached(ptr @[[GLOB14:[0-9]+]], i32 [[TMP0]], ptr @tc2, i64 8, ptr @tc2.cache.), !dbg [[DBG66:![0-9]+]]
// CHECK5-NEXT:    store ptr [[TMP13]], ptr [[TMP12]], align 8, !dbg [[DBG64]]
// CHECK5-NEXT:    [[TMP14:%.*]] = load i32, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4, !dbg [[DBG64]]
// CHECK5-NEXT:    call void @__kmpc_copyprivate(ptr @[[GLOB10]], i32 [[TMP0]], i64 40, ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], ptr @.omp.copyprivate.copy_func, i32 [[TMP14]]), !dbg [[DBG64]]
// CHECK5-NEXT:    [[TMP15:%.*]] = load i8, ptr [[A]], align 1, !dbg [[DBG67:![0-9]+]]
// CHECK5-NEXT:    [[CONV:%.*]] = sext i8 [[TMP15]] to i32, !dbg [[DBG67]]
// CHECK5-NEXT:    ret i32 [[CONV]], !dbg [[DBG68:![0-9]+]]
// CHECK5:       terminate.lpad:
// CHECK5-NEXT:    [[TMP16:%.*]] = landingpad { ptr, i32 }
// CHECK5-NEXT:    catch ptr null, !dbg [[DBG64]]
// CHECK5-NEXT:    [[TMP17:%.*]] = extractvalue { ptr, i32 } [[TMP16]], 0, !dbg [[DBG64]]
// CHECK5-NEXT:    call void @__clang_call_terminate(ptr [[TMP17]]) #[[ATTR13:[0-9]+]], !dbg [[DBG64]]
// CHECK5-NEXT:    unreachable, !dbg [[DBG64]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN3SSTIdEC1Ev
// CHECK5-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR1]] align 2 !dbg [[DBG69:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    call void @_ZN3SSTIdEC2Ev(ptr noundef nonnull align 8 dereferenceable(8) [[THIS1]]), !dbg [[DBG70:![0-9]+]]
// CHECK5-NEXT:    ret void, !dbg [[DBG71:![0-9]+]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN2SSC1ERi
// CHECK5-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[D:%.*]]) unnamed_addr #[[ATTR1]] align 2 !dbg [[DBG72:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 8
// CHECK5-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[D_ADDR]], align 8, !dbg [[DBG73:![0-9]+]]
// CHECK5-NEXT:    call void @_ZN2SSC2ERi(ptr noundef nonnull align 8 dereferenceable(16) [[THIS1]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP0]]), !dbg [[DBG73]]
// CHECK5-NEXT:    ret void, !dbg [[DBG74:![0-9]+]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@__clang_call_terminate
// CHECK5-SAME: (ptr noundef [[TMP0:%.*]]) #[[ATTR8:[0-9]+]] {
// CHECK5-NEXT:    [[TMP2:%.*]] = call ptr @__cxa_begin_catch(ptr [[TMP0]]) #[[ATTR3]]
// CHECK5-NEXT:    call void @_ZSt9terminatev() #[[ATTR13]]
// CHECK5-NEXT:    unreachable
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp.copyprivate.copy_func
// CHECK5-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR9:[0-9]+]] !dbg [[DBG75:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK5-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG76:![0-9]+]]
// CHECK5-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8, !dbg [[DBG76]]
// CHECK5-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP2]], i64 0, i64 0, !dbg [[DBG76]]
// CHECK5-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8, !dbg [[DBG76]]
// CHECK5-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP3]], i64 0, i64 0, !dbg [[DBG76]]
// CHECK5-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8, !dbg [[DBG76]]
// CHECK5-NEXT:    [[TMP8:%.*]] = load i8, ptr [[TMP7]], align 1, !dbg [[DBG77:![0-9]+]]
// CHECK5-NEXT:    store i8 [[TMP8]], ptr [[TMP5]], align 1, !dbg [[DBG77]]
// CHECK5-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP2]], i64 0, i64 1, !dbg [[DBG76]]
// CHECK5-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[TMP9]], align 8, !dbg [[DBG76]]
// CHECK5-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP3]], i64 0, i64 1, !dbg [[DBG76]]
// CHECK5-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP11]], align 8, !dbg [[DBG76]]
// CHECK5-NEXT:    [[CALL:%.*]] = call noundef nonnull align 4 dereferenceable(4) ptr @_ZN9TestClassaSERKS_(ptr noundef nonnull align 4 dereferenceable(4) [[TMP10]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP12]]), !dbg [[DBG78:![0-9]+]]
// CHECK5-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP2]], i64 0, i64 2, !dbg [[DBG76]]
// CHECK5-NEXT:    [[TMP14:%.*]] = load ptr, ptr [[TMP13]], align 8, !dbg [[DBG76]]
// CHECK5-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP3]], i64 0, i64 2, !dbg [[DBG76]]
// CHECK5-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[TMP15]], align 8, !dbg [[DBG76]]
// CHECK5-NEXT:    [[CALL2:%.*]] = call noundef nonnull align 4 dereferenceable(4) ptr @_ZN9TestClassaSERKS_(ptr noundef nonnull align 4 dereferenceable(4) [[TMP14]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP16]]), !dbg [[DBG79:![0-9]+]]
// CHECK5-NEXT:    [[TMP17:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP2]], i64 0, i64 3, !dbg [[DBG76]]
// CHECK5-NEXT:    [[TMP18:%.*]] = load ptr, ptr [[TMP17]], align 8, !dbg [[DBG76]]
// CHECK5-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP3]], i64 0, i64 3, !dbg [[DBG76]]
// CHECK5-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[TMP19]], align 8, !dbg [[DBG76]]
// CHECK5-NEXT:    call void @llvm.memcpy.p0.p0.i64(ptr align 1 [[TMP18]], ptr align 1 [[TMP20]], i64 2, i1 false), !dbg [[DBG76]]
// CHECK5-NEXT:    [[TMP21:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP2]], i64 0, i64 4, !dbg [[DBG76]]
// CHECK5-NEXT:    [[TMP22:%.*]] = load ptr, ptr [[TMP21]], align 8, !dbg [[DBG76]]
// CHECK5-NEXT:    [[TMP23:%.*]] = getelementptr inbounds [5 x ptr], ptr [[TMP3]], i64 0, i64 4, !dbg [[DBG76]]
// CHECK5-NEXT:    [[TMP24:%.*]] = load ptr, ptr [[TMP23]], align 8, !dbg [[DBG76]]
// CHECK5-NEXT:    [[TMP25:%.*]] = getelementptr inbounds [[CLASS_TESTCLASS:%.*]], ptr [[TMP22]], i64 2, !dbg [[DBG76]]
// CHECK5-NEXT:    [[OMP_ARRAYCPY_ISEMPTY:%.*]] = icmp eq ptr [[TMP22]], [[TMP25]], !dbg [[DBG76]]
// CHECK5-NEXT:    br i1 [[OMP_ARRAYCPY_ISEMPTY]], label [[OMP_ARRAYCPY_DONE4:%.*]], label [[OMP_ARRAYCPY_BODY:%.*]], !dbg [[DBG76]]
// CHECK5:       omp.arraycpy.body:
// CHECK5-NEXT:    [[OMP_ARRAYCPY_SRCELEMENTPAST:%.*]] = phi ptr [ [[TMP24]], [[ENTRY:%.*]] ], [ [[OMP_ARRAYCPY_SRC_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ], !dbg [[DBG76]]
// CHECK5-NEXT:    [[OMP_ARRAYCPY_DESTELEMENTPAST:%.*]] = phi ptr [ [[TMP22]], [[ENTRY]] ], [ [[OMP_ARRAYCPY_DEST_ELEMENT:%.*]], [[OMP_ARRAYCPY_BODY]] ], !dbg [[DBG76]]
// CHECK5-NEXT:    [[CALL3:%.*]] = call noundef nonnull align 4 dereferenceable(4) ptr @_ZN9TestClassaSERKS_(ptr noundef nonnull align 4 dereferenceable(4) [[OMP_ARRAYCPY_DESTELEMENTPAST]], ptr noundef nonnull align 4 dereferenceable(4) [[OMP_ARRAYCPY_SRCELEMENTPAST]]), !dbg [[DBG80:![0-9]+]]
// CHECK5-NEXT:    [[OMP_ARRAYCPY_DEST_ELEMENT]] = getelementptr [[CLASS_TESTCLASS]], ptr [[OMP_ARRAYCPY_DESTELEMENTPAST]], i32 1, !dbg [[DBG76]]
// CHECK5-NEXT:    [[OMP_ARRAYCPY_SRC_ELEMENT]] = getelementptr [[CLASS_TESTCLASS]], ptr [[OMP_ARRAYCPY_SRCELEMENTPAST]], i32 1, !dbg [[DBG76]]
// CHECK5-NEXT:    [[OMP_ARRAYCPY_DONE:%.*]] = icmp eq ptr [[OMP_ARRAYCPY_DEST_ELEMENT]], [[TMP25]], !dbg [[DBG76]]
// CHECK5-NEXT:    br i1 [[OMP_ARRAYCPY_DONE]], label [[OMP_ARRAYCPY_DONE4]], label [[OMP_ARRAYCPY_BODY]], !dbg [[DBG76]]
// CHECK5:       omp.arraycpy.done4:
// CHECK5-NEXT:    ret void, !dbg [[DBG80]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN9TestClassaSERKS_
// CHECK5-SAME: (ptr noundef nonnull align 4 dereferenceable(4) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[TMP0:%.*]]) #[[ATTR10:[0-9]+]] align 2 !dbg [[DBG81:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK5-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    ret ptr [[THIS1]], !dbg [[DBG82:![0-9]+]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN3SSTIdEC2Ev
// CHECK5-SAME: (ptr noundef nonnull align 8 dereferenceable(8) [[THIS:%.*]]) unnamed_addr #[[ATTR2]] align 2 !dbg [[DBG83:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[A2:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SST:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG84:![0-9]+]]
// CHECK5-NEXT:    store double 0.000000e+00, ptr [[A]], align 8, !dbg [[DBG84]]
// CHECK5-NEXT:    [[A3:%.*]] = getelementptr inbounds [[STRUCT_SST]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG85:![0-9]+]]
// CHECK5-NEXT:    store ptr [[A3]], ptr [[A2]], align 8, !dbg [[DBG85]]
// CHECK5-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[A2]], align 8, !dbg [[DBG86:![0-9]+]]
// CHECK5-NEXT:    [[TMP1:%.*]] = load double, ptr [[TMP0]], align 8, !dbg [[DBG87:![0-9]+]]
// CHECK5-NEXT:    store double [[TMP1]], ptr [[A_CASTED]], align 8, !dbg [[DBG87]]
// CHECK5-NEXT:    [[TMP2:%.*]] = load i64, ptr [[A_CASTED]], align 8, !dbg [[DBG87]]
// CHECK5-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB18:[0-9]+]], i32 2, ptr @_ZN3SSTIdEC2Ev.omp_outlined, ptr [[THIS1]], i64 [[TMP2]]), !dbg [[DBG87]]
// CHECK5-NEXT:    ret void, !dbg [[DBG88:![0-9]+]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN3SSTIdEC2Ev.omp_outlined
// CHECK5-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], i64 noundef [[A:%.*]]) #[[ATTR12:[0-9]+]] personality ptr @__gxx_personality_v0 !dbg [[DBG89:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[DOTOMP_COPYPRIVATE_DID_IT:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON:%.*]], align 8
// CHECK5-NEXT:    [[DOTOMP_COPYPRIVATE_CPR_LIST:%.*]] = alloca [1 x ptr], align 8
// CHECK5-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK5-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[A]], ptr [[A_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8, !dbg [[DBG90:![0-9]+]]
// CHECK5-NEXT:    store ptr [[A_ADDR]], ptr [[TMP]], align 8, !dbg [[DBG90]]
// CHECK5-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP]], align 8, !dbg [[DBG91:![0-9]+]]
// CHECK5-NEXT:    store ptr [[TMP1]], ptr [[_TMP1]], align 8, !dbg [[DBG92:![0-9]+]]
// CHECK5-NEXT:    store i32 0, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4, !dbg [[DBG92]]
// CHECK5-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8, !dbg [[DBG92]]
// CHECK5-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4, !dbg [[DBG92]]
// CHECK5-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB16:[0-9]+]], i32 [[TMP3]]), !dbg [[DBG92]]
// CHECK5-NEXT:    [[TMP5:%.*]] = icmp ne i32 [[TMP4]], 0, !dbg [[DBG92]]
// CHECK5-NEXT:    br i1 [[TMP5]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]], !dbg [[DBG92]]
// CHECK5:       omp_if.then:
// CHECK5-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[REF_TMP]], i32 0, i32 0, !dbg [[DBG93:![0-9]+]]
// CHECK5-NEXT:    store ptr [[TMP0]], ptr [[TMP6]], align 8, !dbg [[DBG93]]
// CHECK5-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[REF_TMP]], i32 0, i32 1, !dbg [[DBG93]]
// CHECK5-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[_TMP1]], align 8, !dbg [[DBG94:![0-9]+]]
// CHECK5-NEXT:    store ptr [[TMP8]], ptr [[TMP7]], align 8, !dbg [[DBG93]]
// CHECK5-NEXT:    invoke void @_ZZN3SSTIdEC1EvENKUlvE_clEv(ptr noundef nonnull align 8 dereferenceable(16) [[REF_TMP]])
// CHECK5-NEXT:    to label [[INVOKE_CONT:%.*]] unwind label [[TERMINATE_LPAD:%.*]], !dbg [[DBG93]]
// CHECK5:       invoke.cont:
// CHECK5-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB16]], i32 [[TMP3]]), !dbg [[DBG93]]
// CHECK5-NEXT:    store i32 1, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4, !dbg [[DBG93]]
// CHECK5-NEXT:    br label [[OMP_IF_END]], !dbg [[DBG93]]
// CHECK5:       omp_if.end:
// CHECK5-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 0, !dbg [[DBG93]]
// CHECK5-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[_TMP1]], align 8, !dbg [[DBG95:![0-9]+]]
// CHECK5-NEXT:    store ptr [[TMP10]], ptr [[TMP9]], align 8, !dbg [[DBG93]]
// CHECK5-NEXT:    [[TMP11:%.*]] = load i32, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4, !dbg [[DBG93]]
// CHECK5-NEXT:    call void @__kmpc_copyprivate(ptr @[[GLOB16]], i32 [[TMP3]], i64 8, ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], ptr @.omp.copyprivate.copy_func.5, i32 [[TMP11]]), !dbg [[DBG93]]
// CHECK5-NEXT:    ret void, !dbg [[DBG96:![0-9]+]]
// CHECK5:       terminate.lpad:
// CHECK5-NEXT:    [[TMP12:%.*]] = landingpad { ptr, i32 }
// CHECK5-NEXT:    catch ptr null, !dbg [[DBG93]]
// CHECK5-NEXT:    [[TMP13:%.*]] = extractvalue { ptr, i32 } [[TMP12]], 0, !dbg [[DBG93]]
// CHECK5-NEXT:    call void @__clang_call_terminate(ptr [[TMP13]]) #[[ATTR13]], !dbg [[DBG93]]
// CHECK5-NEXT:    unreachable, !dbg [[DBG93]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZZN3SSTIdEC1EvENKUlvE_clEv
// CHECK5-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) #[[ATTR4]] align 2 !dbg [[DBG97:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_0:%.*]], align 8
// CHECK5-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP0]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[REF_TMP]], i32 0, i32 0, !dbg [[DBG98:![0-9]+]]
// CHECK5-NEXT:    store ptr [[TMP1]], ptr [[TMP2]], align 8, !dbg [[DBG98]]
// CHECK5-NEXT:    [[TMP3:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[REF_TMP]], i32 0, i32 1, !dbg [[DBG98]]
// CHECK5-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [[CLASS_ANON]], ptr [[THIS1]], i32 0, i32 1, !dbg [[DBG99:![0-9]+]]
// CHECK5-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8, !dbg [[DBG99]]
// CHECK5-NEXT:    store ptr [[TMP5]], ptr [[TMP3]], align 8, !dbg [[DBG98]]
// CHECK5-NEXT:    call void @_ZZZN3SSTIdEC1EvENKUlvE_clEvENKUlvE_clEv(ptr noundef nonnull align 8 dereferenceable(16) [[REF_TMP]]), !dbg [[DBG98]]
// CHECK5-NEXT:    ret void, !dbg [[DBG100:![0-9]+]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp.copyprivate.copy_func.5
// CHECK5-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR9]] !dbg [[DBG101:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK5-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG102:![0-9]+]]
// CHECK5-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8, !dbg [[DBG102]]
// CHECK5-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x ptr], ptr [[TMP2]], i64 0, i64 0, !dbg [[DBG102]]
// CHECK5-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8, !dbg [[DBG102]]
// CHECK5-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x ptr], ptr [[TMP3]], i64 0, i64 0, !dbg [[DBG102]]
// CHECK5-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8, !dbg [[DBG102]]
// CHECK5-NEXT:    [[TMP8:%.*]] = load double, ptr [[TMP7]], align 8, !dbg [[DBG103:![0-9]+]]
// CHECK5-NEXT:    store double [[TMP8]], ptr [[TMP5]], align 8, !dbg [[DBG103]]
// CHECK5-NEXT:    ret void, !dbg [[DBG103]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZZZN3SSTIdEC1EvENKUlvE_clEvENKUlvE_clEv
// CHECK5-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]]) #[[ATTR10]] align 2 !dbg [[DBG106:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON_0:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP0]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[THIS1]], i32 0, i32 1, !dbg [[DBG107:![0-9]+]]
// CHECK5-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP2]], align 8, !dbg [[DBG107]]
// CHECK5-NEXT:    [[TMP4:%.*]] = load double, ptr [[TMP3]], align 8, !dbg [[DBG108:![0-9]+]]
// CHECK5-NEXT:    [[INC:%.*]] = fadd double [[TMP4]], 1.000000e+00, !dbg [[DBG108]]
// CHECK5-NEXT:    store double [[INC]], ptr [[TMP3]], align 8, !dbg [[DBG108]]
// CHECK5-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[CLASS_ANON_0]], ptr [[THIS1]], i32 0, i32 1, !dbg [[DBG109:![0-9]+]]
// CHECK5-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[TMP5]], align 8, !dbg [[DBG109]]
// CHECK5-NEXT:    [[TMP7:%.*]] = load double, ptr [[TMP6]], align 8, !dbg [[DBG110:![0-9]+]]
// CHECK5-NEXT:    store double [[TMP7]], ptr [[A_CASTED]], align 8, !dbg [[DBG110]]
// CHECK5-NEXT:    [[TMP8:%.*]] = load i64, ptr [[A_CASTED]], align 8, !dbg [[DBG110]]
// CHECK5-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB22:[0-9]+]], i32 2, ptr @_ZZZN3SSTIdEC1EvENKUlvE_clEvENKUlvE_clEv.omp_outlined, ptr [[TMP1]], i64 [[TMP8]]), !dbg [[DBG110]]
// CHECK5-NEXT:    ret void, !dbg [[DBG111:![0-9]+]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZZZN3SSTIdEC1EvENKUlvE_clEvENKUlvE_clEv.omp_outlined
// CHECK5-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], i64 noundef [[A:%.*]]) #[[ATTR12]] !dbg [[DBG112:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[DOTOMP_COPYPRIVATE_DID_IT:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_COPYPRIVATE_CPR_LIST:%.*]] = alloca [1 x ptr], align 8
// CHECK5-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK5-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[A]], ptr [[A_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8, !dbg [[DBG113:![0-9]+]]
// CHECK5-NEXT:    store ptr [[A_ADDR]], ptr [[TMP]], align 8, !dbg [[DBG113]]
// CHECK5-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP]], align 8, !dbg [[DBG114:![0-9]+]]
// CHECK5-NEXT:    store ptr [[TMP1]], ptr [[_TMP1]], align 8, !dbg [[DBG115:![0-9]+]]
// CHECK5-NEXT:    store i32 0, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4, !dbg [[DBG115]]
// CHECK5-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8, !dbg [[DBG115]]
// CHECK5-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4, !dbg [[DBG115]]
// CHECK5-NEXT:    [[TMP4:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB20:[0-9]+]], i32 [[TMP3]]), !dbg [[DBG115]]
// CHECK5-NEXT:    [[TMP5:%.*]] = icmp ne i32 [[TMP4]], 0, !dbg [[DBG115]]
// CHECK5-NEXT:    br i1 [[TMP5]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]], !dbg [[DBG115]]
// CHECK5:       omp_if.then:
// CHECK5-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[_TMP1]], align 8, !dbg [[DBG114]]
// CHECK5-NEXT:    [[TMP7:%.*]] = load double, ptr [[TMP6]], align 8, !dbg [[DBG116:![0-9]+]]
// CHECK5-NEXT:    [[INC:%.*]] = fadd double [[TMP7]], 1.000000e+00, !dbg [[DBG116]]
// CHECK5-NEXT:    store double [[INC]], ptr [[TMP6]], align 8, !dbg [[DBG116]]
// CHECK5-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB20]], i32 [[TMP3]]), !dbg [[DBG116]]
// CHECK5-NEXT:    store i32 1, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4, !dbg [[DBG116]]
// CHECK5-NEXT:    br label [[OMP_IF_END]], !dbg [[DBG116]]
// CHECK5:       omp_if.end:
// CHECK5-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [1 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 0, !dbg [[DBG116]]
// CHECK5-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[_TMP1]], align 8, !dbg [[DBG117:![0-9]+]]
// CHECK5-NEXT:    store ptr [[TMP9]], ptr [[TMP8]], align 8, !dbg [[DBG116]]
// CHECK5-NEXT:    [[TMP10:%.*]] = load i32, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4, !dbg [[DBG116]]
// CHECK5-NEXT:    call void @__kmpc_copyprivate(ptr @[[GLOB20]], i32 [[TMP3]], i64 8, ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], ptr @.omp.copyprivate.copy_func.6, i32 [[TMP10]]), !dbg [[DBG116]]
// CHECK5-NEXT:    ret void, !dbg [[DBG118:![0-9]+]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp.copyprivate.copy_func.6
// CHECK5-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR9]] !dbg [[DBG119:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK5-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG120:![0-9]+]]
// CHECK5-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8, !dbg [[DBG120]]
// CHECK5-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [1 x ptr], ptr [[TMP2]], i64 0, i64 0, !dbg [[DBG120]]
// CHECK5-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8, !dbg [[DBG120]]
// CHECK5-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [1 x ptr], ptr [[TMP3]], i64 0, i64 0, !dbg [[DBG120]]
// CHECK5-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8, !dbg [[DBG120]]
// CHECK5-NEXT:    [[TMP8:%.*]] = load double, ptr [[TMP7]], align 8, !dbg [[DBG121:![0-9]+]]
// CHECK5-NEXT:    store double [[TMP8]], ptr [[TMP5]], align 8, !dbg [[DBG121]]
// CHECK5-NEXT:    ret void, !dbg [[DBG121]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN2SSC2ERi
// CHECK5-SAME: (ptr noundef nonnull align 8 dereferenceable(16) [[THIS:%.*]], ptr noundef nonnull align 4 dereferenceable(4) [[D:%.*]]) unnamed_addr #[[ATTR2]] align 2 !dbg [[DBG122:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[D_ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[A2:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[B4:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[C7:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[B_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[C_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    store ptr [[D]], ptr [[D_ADDR]], align 8
// CHECK5-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[A:%.*]] = getelementptr inbounds [[STRUCT_SS:%.*]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG123:![0-9]+]]
// CHECK5-NEXT:    store i32 0, ptr [[A]], align 8, !dbg [[DBG123]]
// CHECK5-NEXT:    [[B:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 1, !dbg [[DBG124:![0-9]+]]
// CHECK5-NEXT:    [[BF_LOAD:%.*]] = load i8, ptr [[B]], align 4, !dbg [[DBG124]]
// CHECK5-NEXT:    [[BF_CLEAR:%.*]] = and i8 [[BF_LOAD]], -16, !dbg [[DBG124]]
// CHECK5-NEXT:    [[BF_SET:%.*]] = or i8 [[BF_CLEAR]], 0, !dbg [[DBG124]]
// CHECK5-NEXT:    store i8 [[BF_SET]], ptr [[B]], align 4, !dbg [[DBG124]]
// CHECK5-NEXT:    [[C:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 2, !dbg [[DBG125:![0-9]+]]
// CHECK5-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[D_ADDR]], align 8, !dbg [[DBG126:![0-9]+]]
// CHECK5-NEXT:    store ptr [[TMP0]], ptr [[C]], align 8, !dbg [[DBG125]]
// CHECK5-NEXT:    [[A3:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 0, !dbg [[DBG127:![0-9]+]]
// CHECK5-NEXT:    store ptr [[A3]], ptr [[A2]], align 8, !dbg [[DBG127]]
// CHECK5-NEXT:    [[B5:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 1, !dbg [[DBG128:![0-9]+]]
// CHECK5-NEXT:    [[BF_LOAD6:%.*]] = load i8, ptr [[B5]], align 4, !dbg [[DBG128]]
// CHECK5-NEXT:    [[BF_SHL:%.*]] = shl i8 [[BF_LOAD6]], 4, !dbg [[DBG128]]
// CHECK5-NEXT:    [[BF_ASHR:%.*]] = ashr i8 [[BF_SHL]], 4, !dbg [[DBG128]]
// CHECK5-NEXT:    [[BF_CAST:%.*]] = sext i8 [[BF_ASHR]] to i32, !dbg [[DBG128]]
// CHECK5-NEXT:    store i32 [[BF_CAST]], ptr [[B4]], align 4, !dbg [[DBG128]]
// CHECK5-NEXT:    [[C8:%.*]] = getelementptr inbounds [[STRUCT_SS]], ptr [[THIS1]], i32 0, i32 2, !dbg [[DBG129:![0-9]+]]
// CHECK5-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[C8]], align 8, !dbg [[DBG129]]
// CHECK5-NEXT:    store ptr [[TMP1]], ptr [[C7]], align 8, !dbg [[DBG129]]
// CHECK5-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[A2]], align 8, !dbg [[DBG130:![0-9]+]]
// CHECK5-NEXT:    [[TMP3:%.*]] = load i32, ptr [[TMP2]], align 4, !dbg [[DBG131:![0-9]+]]
// CHECK5-NEXT:    store i32 [[TMP3]], ptr [[A_CASTED]], align 4, !dbg [[DBG131]]
// CHECK5-NEXT:    [[TMP4:%.*]] = load i64, ptr [[A_CASTED]], align 8, !dbg [[DBG131]]
// CHECK5-NEXT:    [[TMP5:%.*]] = load i32, ptr [[B4]], align 4, !dbg [[DBG131]]
// CHECK5-NEXT:    store i32 [[TMP5]], ptr [[B_CASTED]], align 4, !dbg [[DBG131]]
// CHECK5-NEXT:    [[TMP6:%.*]] = load i64, ptr [[B_CASTED]], align 8, !dbg [[DBG131]]
// CHECK5-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[C7]], align 8, !dbg [[DBG132:![0-9]+]]
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP7]], align 4, !dbg [[DBG131]]
// CHECK5-NEXT:    store i32 [[TMP8]], ptr [[C_CASTED]], align 4, !dbg [[DBG131]]
// CHECK5-NEXT:    [[TMP9:%.*]] = load i64, ptr [[C_CASTED]], align 8, !dbg [[DBG131]]
// CHECK5-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB26:[0-9]+]], i32 4, ptr @_ZN2SSC2ERi.omp_outlined, ptr [[THIS1]], i64 [[TMP4]], i64 [[TMP6]], i64 [[TMP9]]), !dbg [[DBG131]]
// CHECK5-NEXT:    ret void, !dbg [[DBG133:![0-9]+]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZN2SSC2ERi.omp_outlined
// CHECK5-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], i64 noundef [[A:%.*]], i64 noundef [[B:%.*]], i64 noundef [[C:%.*]]) #[[ATTR12]] personality ptr @__gxx_personality_v0 !dbg [[DBG134:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[C_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[_TMP2:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[_TMP3:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[DOTOMP_COPYPRIVATE_DID_IT:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[REF_TMP:%.*]] = alloca [[CLASS_ANON_1:%.*]], align 8
// CHECK5-NEXT:    [[DOTOMP_COPYPRIVATE_CPR_LIST:%.*]] = alloca [3 x ptr], align 8
// CHECK5-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK5-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[A]], ptr [[A_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[B]], ptr [[B_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[C]], ptr [[C_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8, !dbg [[DBG135:![0-9]+]]
// CHECK5-NEXT:    store ptr [[A_ADDR]], ptr [[TMP]], align 8, !dbg [[DBG135]]
// CHECK5-NEXT:    store ptr [[C_ADDR]], ptr [[_TMP1]], align 8, !dbg [[DBG135]]
// CHECK5-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP]], align 8, !dbg [[DBG136:![0-9]+]]
// CHECK5-NEXT:    store ptr [[TMP1]], ptr [[_TMP2]], align 8, !dbg [[DBG137:![0-9]+]]
// CHECK5-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[_TMP1]], align 8, !dbg [[DBG138:![0-9]+]]
// CHECK5-NEXT:    store ptr [[TMP2]], ptr [[_TMP3]], align 8, !dbg [[DBG137]]
// CHECK5-NEXT:    store i32 0, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4, !dbg [[DBG137]]
// CHECK5-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8, !dbg [[DBG137]]
// CHECK5-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP3]], align 4, !dbg [[DBG137]]
// CHECK5-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB24:[0-9]+]], i32 [[TMP4]]), !dbg [[DBG137]]
// CHECK5-NEXT:    [[TMP6:%.*]] = icmp ne i32 [[TMP5]], 0, !dbg [[DBG137]]
// CHECK5-NEXT:    br i1 [[TMP6]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]], !dbg [[DBG137]]
// CHECK5:       omp_if.then:
// CHECK5-NEXT:    [[TMP7:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[REF_TMP]], i32 0, i32 0, !dbg [[DBG139:![0-9]+]]
// CHECK5-NEXT:    store ptr [[TMP0]], ptr [[TMP7]], align 8, !dbg [[DBG139]]
// CHECK5-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[REF_TMP]], i32 0, i32 1, !dbg [[DBG139]]
// CHECK5-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[_TMP2]], align 8, !dbg [[DBG140:![0-9]+]]
// CHECK5-NEXT:    store ptr [[TMP9]], ptr [[TMP8]], align 8, !dbg [[DBG139]]
// CHECK5-NEXT:    [[TMP10:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[REF_TMP]], i32 0, i32 2, !dbg [[DBG139]]
// CHECK5-NEXT:    store ptr [[B_ADDR]], ptr [[TMP10]], align 8, !dbg [[DBG139]]
// CHECK5-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[REF_TMP]], i32 0, i32 3, !dbg [[DBG139]]
// CHECK5-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[_TMP3]], align 8, !dbg [[DBG140]]
// CHECK5-NEXT:    store ptr [[TMP12]], ptr [[TMP11]], align 8, !dbg [[DBG139]]
// CHECK5-NEXT:    invoke void @_ZZN2SSC1ERiENKUlvE_clEv(ptr noundef nonnull align 8 dereferenceable(32) [[REF_TMP]])
// CHECK5-NEXT:    to label [[INVOKE_CONT:%.*]] unwind label [[TERMINATE_LPAD:%.*]], !dbg [[DBG139]]
// CHECK5:       invoke.cont:
// CHECK5-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB24]], i32 [[TMP4]]), !dbg [[DBG139]]
// CHECK5-NEXT:    store i32 1, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4, !dbg [[DBG139]]
// CHECK5-NEXT:    br label [[OMP_IF_END]], !dbg [[DBG139]]
// CHECK5:       omp_if.end:
// CHECK5-NEXT:    [[TMP13:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 0, !dbg [[DBG139]]
// CHECK5-NEXT:    [[TMP14:%.*]] = load ptr, ptr [[_TMP2]], align 8, !dbg [[DBG141:![0-9]+]]
// CHECK5-NEXT:    store ptr [[TMP14]], ptr [[TMP13]], align 8, !dbg [[DBG139]]
// CHECK5-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 1, !dbg [[DBG139]]
// CHECK5-NEXT:    store ptr [[B_ADDR]], ptr [[TMP15]], align 8, !dbg [[DBG139]]
// CHECK5-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 2, !dbg [[DBG139]]
// CHECK5-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[_TMP3]], align 8, !dbg [[DBG142:![0-9]+]]
// CHECK5-NEXT:    store ptr [[TMP17]], ptr [[TMP16]], align 8, !dbg [[DBG139]]
// CHECK5-NEXT:    [[TMP18:%.*]] = load i32, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4, !dbg [[DBG139]]
// CHECK5-NEXT:    call void @__kmpc_copyprivate(ptr @[[GLOB24]], i32 [[TMP4]], i64 24, ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], ptr @.omp.copyprivate.copy_func.7, i32 [[TMP18]]), !dbg [[DBG139]]
// CHECK5-NEXT:    ret void, !dbg [[DBG143:![0-9]+]]
// CHECK5:       terminate.lpad:
// CHECK5-NEXT:    [[TMP19:%.*]] = landingpad { ptr, i32 }
// CHECK5-NEXT:    catch ptr null, !dbg [[DBG139]]
// CHECK5-NEXT:    [[TMP20:%.*]] = extractvalue { ptr, i32 } [[TMP19]], 0, !dbg [[DBG139]]
// CHECK5-NEXT:    call void @__clang_call_terminate(ptr [[TMP20]]) #[[ATTR13]], !dbg [[DBG139]]
// CHECK5-NEXT:    unreachable, !dbg [[DBG139]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZZN2SSC1ERiENKUlvE_clEv
// CHECK5-SAME: (ptr noundef nonnull align 8 dereferenceable(32) [[THIS:%.*]]) #[[ATTR10]] align 2 !dbg [[DBG144:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[A_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[B_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[C_CASTED:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[THIS1:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = getelementptr inbounds [[CLASS_ANON_1:%.*]], ptr [[THIS1]], i32 0, i32 0
// CHECK5-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP0]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[THIS1]], i32 0, i32 1, !dbg [[DBG145:![0-9]+]]
// CHECK5-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[TMP2]], align 8, !dbg [[DBG145]]
// CHECK5-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP3]], align 4, !dbg [[DBG146:![0-9]+]]
// CHECK5-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP4]], 1, !dbg [[DBG146]]
// CHECK5-NEXT:    store i32 [[INC]], ptr [[TMP3]], align 4, !dbg [[DBG146]]
// CHECK5-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[THIS1]], i32 0, i32 2, !dbg [[DBG147:![0-9]+]]
// CHECK5-NEXT:    [[TMP6:%.*]] = load ptr, ptr [[TMP5]], align 8, !dbg [[DBG147]]
// CHECK5-NEXT:    [[TMP7:%.*]] = load i32, ptr [[TMP6]], align 4, !dbg [[DBG148:![0-9]+]]
// CHECK5-NEXT:    [[DEC:%.*]] = add nsw i32 [[TMP7]], -1, !dbg [[DBG148]]
// CHECK5-NEXT:    store i32 [[DEC]], ptr [[TMP6]], align 4, !dbg [[DBG148]]
// CHECK5-NEXT:    [[TMP8:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[THIS1]], i32 0, i32 3, !dbg [[DBG149:![0-9]+]]
// CHECK5-NEXT:    [[TMP9:%.*]] = load ptr, ptr [[TMP8]], align 8, !dbg [[DBG149]]
// CHECK5-NEXT:    [[TMP10:%.*]] = load i32, ptr [[TMP9]], align 4, !dbg [[DBG150:![0-9]+]]
// CHECK5-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP10]], 1, !dbg [[DBG150]]
// CHECK5-NEXT:    store i32 [[DIV]], ptr [[TMP9]], align 4, !dbg [[DBG150]]
// CHECK5-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[THIS1]], i32 0, i32 1, !dbg [[DBG151:![0-9]+]]
// CHECK5-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP11]], align 8, !dbg [[DBG151]]
// CHECK5-NEXT:    [[TMP13:%.*]] = load i32, ptr [[TMP12]], align 4, !dbg [[DBG152:![0-9]+]]
// CHECK5-NEXT:    store i32 [[TMP13]], ptr [[A_CASTED]], align 4, !dbg [[DBG152]]
// CHECK5-NEXT:    [[TMP14:%.*]] = load i64, ptr [[A_CASTED]], align 8, !dbg [[DBG152]]
// CHECK5-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[THIS1]], i32 0, i32 2, !dbg [[DBG153:![0-9]+]]
// CHECK5-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[TMP15]], align 8, !dbg [[DBG153]]
// CHECK5-NEXT:    [[TMP17:%.*]] = load i32, ptr [[TMP16]], align 4, !dbg [[DBG152]]
// CHECK5-NEXT:    store i32 [[TMP17]], ptr [[B_CASTED]], align 4, !dbg [[DBG152]]
// CHECK5-NEXT:    [[TMP18:%.*]] = load i64, ptr [[B_CASTED]], align 8, !dbg [[DBG152]]
// CHECK5-NEXT:    [[TMP19:%.*]] = getelementptr inbounds [[CLASS_ANON_1]], ptr [[THIS1]], i32 0, i32 3, !dbg [[DBG154:![0-9]+]]
// CHECK5-NEXT:    [[TMP20:%.*]] = load ptr, ptr [[TMP19]], align 8, !dbg [[DBG154]]
// CHECK5-NEXT:    [[TMP21:%.*]] = load i32, ptr [[TMP20]], align 4, !dbg [[DBG152]]
// CHECK5-NEXT:    store i32 [[TMP21]], ptr [[C_CASTED]], align 4, !dbg [[DBG152]]
// CHECK5-NEXT:    [[TMP22:%.*]] = load i64, ptr [[C_CASTED]], align 8, !dbg [[DBG152]]
// CHECK5-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB30:[0-9]+]], i32 4, ptr @_ZZN2SSC1ERiENKUlvE_clEv.omp_outlined, ptr [[TMP1]], i64 [[TMP14]], i64 [[TMP18]], i64 [[TMP22]]), !dbg [[DBG152]]
// CHECK5-NEXT:    ret void, !dbg [[DBG155:![0-9]+]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp.copyprivate.copy_func.7
// CHECK5-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR9]] !dbg [[DBG156:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK5-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG157:![0-9]+]]
// CHECK5-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8, !dbg [[DBG157]]
// CHECK5-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 0, !dbg [[DBG157]]
// CHECK5-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8, !dbg [[DBG157]]
// CHECK5-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 0, !dbg [[DBG157]]
// CHECK5-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8, !dbg [[DBG157]]
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP7]], align 4, !dbg [[DBG158:![0-9]+]]
// CHECK5-NEXT:    store i32 [[TMP8]], ptr [[TMP5]], align 4, !dbg [[DBG158]]
// CHECK5-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 1, !dbg [[DBG157]]
// CHECK5-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[TMP9]], align 8, !dbg [[DBG157]]
// CHECK5-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 1, !dbg [[DBG157]]
// CHECK5-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP11]], align 8, !dbg [[DBG157]]
// CHECK5-NEXT:    [[TMP13:%.*]] = load i32, ptr [[TMP12]], align 4, !dbg [[DBG159:![0-9]+]]
// CHECK5-NEXT:    store i32 [[TMP13]], ptr [[TMP10]], align 4, !dbg [[DBG159]]
// CHECK5-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 2, !dbg [[DBG157]]
// CHECK5-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[TMP14]], align 8, !dbg [[DBG157]]
// CHECK5-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 2, !dbg [[DBG157]]
// CHECK5-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[TMP16]], align 8, !dbg [[DBG157]]
// CHECK5-NEXT:    [[TMP18:%.*]] = load i32, ptr [[TMP17]], align 4, !dbg [[DBG160:![0-9]+]]
// CHECK5-NEXT:    store i32 [[TMP18]], ptr [[TMP15]], align 4, !dbg [[DBG160]]
// CHECK5-NEXT:    ret void, !dbg [[DBG160]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_ZZN2SSC1ERiENKUlvE_clEv.omp_outlined
// CHECK5-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]], ptr noundef [[THIS:%.*]], i64 noundef [[A:%.*]], i64 noundef [[B:%.*]], i64 noundef [[C:%.*]]) #[[ATTR12]] !dbg [[DBG161:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[THIS_ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[A_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[B_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[C_ADDR:%.*]] = alloca i64, align 8
// CHECK5-NEXT:    [[TMP:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[_TMP1:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[_TMP2:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[_TMP3:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[DOTOMP_COPYPRIVATE_DID_IT:%.*]] = alloca i32, align 4
// CHECK5-NEXT:    [[DOTOMP_COPYPRIVATE_CPR_LIST:%.*]] = alloca [3 x ptr], align 8
// CHECK5-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK5-NEXT:    store ptr [[THIS]], ptr [[THIS_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[A]], ptr [[A_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[B]], ptr [[B_ADDR]], align 8
// CHECK5-NEXT:    store i64 [[C]], ptr [[C_ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[THIS_ADDR]], align 8, !dbg [[DBG162:![0-9]+]]
// CHECK5-NEXT:    store ptr [[A_ADDR]], ptr [[TMP]], align 8, !dbg [[DBG162]]
// CHECK5-NEXT:    store ptr [[C_ADDR]], ptr [[_TMP1]], align 8, !dbg [[DBG162]]
// CHECK5-NEXT:    [[TMP1:%.*]] = load ptr, ptr [[TMP]], align 8, !dbg [[DBG163:![0-9]+]]
// CHECK5-NEXT:    store ptr [[TMP1]], ptr [[_TMP2]], align 8, !dbg [[DBG164:![0-9]+]]
// CHECK5-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[_TMP1]], align 8, !dbg [[DBG165:![0-9]+]]
// CHECK5-NEXT:    store ptr [[TMP2]], ptr [[_TMP3]], align 8, !dbg [[DBG164]]
// CHECK5-NEXT:    store i32 0, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4, !dbg [[DBG164]]
// CHECK5-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8, !dbg [[DBG164]]
// CHECK5-NEXT:    [[TMP4:%.*]] = load i32, ptr [[TMP3]], align 4, !dbg [[DBG164]]
// CHECK5-NEXT:    [[TMP5:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB28:[0-9]+]], i32 [[TMP4]]), !dbg [[DBG164]]
// CHECK5-NEXT:    [[TMP6:%.*]] = icmp ne i32 [[TMP5]], 0, !dbg [[DBG164]]
// CHECK5-NEXT:    br i1 [[TMP6]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]], !dbg [[DBG164]]
// CHECK5:       omp_if.then:
// CHECK5-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[_TMP2]], align 8, !dbg [[DBG163]]
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP7]], align 4, !dbg [[DBG166:![0-9]+]]
// CHECK5-NEXT:    [[INC:%.*]] = add nsw i32 [[TMP8]], 1, !dbg [[DBG166]]
// CHECK5-NEXT:    store i32 [[INC]], ptr [[TMP7]], align 4, !dbg [[DBG166]]
// CHECK5-NEXT:    [[TMP9:%.*]] = load i32, ptr [[B_ADDR]], align 4, !dbg [[DBG167:![0-9]+]]
// CHECK5-NEXT:    [[DEC:%.*]] = add nsw i32 [[TMP9]], -1, !dbg [[DBG167]]
// CHECK5-NEXT:    store i32 [[DEC]], ptr [[B_ADDR]], align 4, !dbg [[DBG167]]
// CHECK5-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[_TMP3]], align 8, !dbg [[DBG165]]
// CHECK5-NEXT:    [[TMP11:%.*]] = load i32, ptr [[TMP10]], align 4, !dbg [[DBG168:![0-9]+]]
// CHECK5-NEXT:    [[DIV:%.*]] = sdiv i32 [[TMP11]], 1, !dbg [[DBG168]]
// CHECK5-NEXT:    store i32 [[DIV]], ptr [[TMP10]], align 4, !dbg [[DBG168]]
// CHECK5-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB28]], i32 [[TMP4]]), !dbg [[DBG166]]
// CHECK5-NEXT:    store i32 1, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4, !dbg [[DBG166]]
// CHECK5-NEXT:    br label [[OMP_IF_END]], !dbg [[DBG166]]
// CHECK5:       omp_if.end:
// CHECK5-NEXT:    [[TMP12:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 0, !dbg [[DBG166]]
// CHECK5-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[_TMP2]], align 8, !dbg [[DBG169:![0-9]+]]
// CHECK5-NEXT:    store ptr [[TMP13]], ptr [[TMP12]], align 8, !dbg [[DBG166]]
// CHECK5-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 1, !dbg [[DBG166]]
// CHECK5-NEXT:    store ptr [[B_ADDR]], ptr [[TMP14]], align 8, !dbg [[DBG166]]
// CHECK5-NEXT:    [[TMP15:%.*]] = getelementptr inbounds [3 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 2, !dbg [[DBG166]]
// CHECK5-NEXT:    [[TMP16:%.*]] = load ptr, ptr [[_TMP3]], align 8, !dbg [[DBG170:![0-9]+]]
// CHECK5-NEXT:    store ptr [[TMP16]], ptr [[TMP15]], align 8, !dbg [[DBG166]]
// CHECK5-NEXT:    [[TMP17:%.*]] = load i32, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4, !dbg [[DBG166]]
// CHECK5-NEXT:    call void @__kmpc_copyprivate(ptr @[[GLOB28]], i32 [[TMP4]], i64 24, ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], ptr @.omp.copyprivate.copy_func.8, i32 [[TMP17]]), !dbg [[DBG166]]
// CHECK5-NEXT:    ret void, !dbg [[DBG171:![0-9]+]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@.omp.copyprivate.copy_func.8
// CHECK5-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR9]] !dbg [[DBG172:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK5-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK5-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8, !dbg [[DBG173:![0-9]+]]
// CHECK5-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8, !dbg [[DBG173]]
// CHECK5-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 0, !dbg [[DBG173]]
// CHECK5-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8, !dbg [[DBG173]]
// CHECK5-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 0, !dbg [[DBG173]]
// CHECK5-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8, !dbg [[DBG173]]
// CHECK5-NEXT:    [[TMP8:%.*]] = load i32, ptr [[TMP7]], align 4, !dbg [[DBG174:![0-9]+]]
// CHECK5-NEXT:    store i32 [[TMP8]], ptr [[TMP5]], align 4, !dbg [[DBG174]]
// CHECK5-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 1, !dbg [[DBG173]]
// CHECK5-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[TMP9]], align 8, !dbg [[DBG173]]
// CHECK5-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 1, !dbg [[DBG173]]
// CHECK5-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP11]], align 8, !dbg [[DBG173]]
// CHECK5-NEXT:    [[TMP13:%.*]] = load i32, ptr [[TMP12]], align 4, !dbg [[DBG175:![0-9]+]]
// CHECK5-NEXT:    store i32 [[TMP13]], ptr [[TMP10]], align 4, !dbg [[DBG175]]
// CHECK5-NEXT:    [[TMP14:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP2]], i64 0, i64 2, !dbg [[DBG173]]
// CHECK5-NEXT:    [[TMP15:%.*]] = load ptr, ptr [[TMP14]], align 8, !dbg [[DBG173]]
// CHECK5-NEXT:    [[TMP16:%.*]] = getelementptr inbounds [3 x ptr], ptr [[TMP3]], i64 0, i64 2, !dbg [[DBG173]]
// CHECK5-NEXT:    [[TMP17:%.*]] = load ptr, ptr [[TMP16]], align 8, !dbg [[DBG173]]
// CHECK5-NEXT:    [[TMP18:%.*]] = load i32, ptr [[TMP17]], align 4, !dbg [[DBG176:![0-9]+]]
// CHECK5-NEXT:    store i32 [[TMP18]], ptr [[TMP15]], align 4, !dbg [[DBG176]]
// CHECK5-NEXT:    ret void, !dbg [[DBG176]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_Z15parallel_singlev
// CHECK5-SAME: () #[[ATTR10]] !dbg [[DBG177:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    call void (ptr, i32, ptr, ...) @__kmpc_fork_call(ptr @[[GLOB35:[0-9]+]], i32 0, ptr @_Z15parallel_singlev.omp_outlined), !dbg [[DBG178:![0-9]+]]
// CHECK5-NEXT:    ret void, !dbg [[DBG179:![0-9]+]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_Z15parallel_singlev.omp_outlined
// CHECK5-SAME: (ptr noalias noundef [[DOTGLOBAL_TID_:%.*]], ptr noalias noundef [[DOTBOUND_TID_:%.*]]) #[[ATTR12]] personality ptr @__gxx_personality_v0 !dbg [[DBG180:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    [[DOTGLOBAL_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    [[DOTBOUND_TID__ADDR:%.*]] = alloca ptr, align 8
// CHECK5-NEXT:    store ptr [[DOTGLOBAL_TID_]], ptr [[DOTGLOBAL_TID__ADDR]], align 8
// CHECK5-NEXT:    store ptr [[DOTBOUND_TID_]], ptr [[DOTBOUND_TID__ADDR]], align 8
// CHECK5-NEXT:    [[TMP0:%.*]] = load ptr, ptr [[DOTGLOBAL_TID__ADDR]], align 8, !dbg [[DBG181:![0-9]+]]
// CHECK5-NEXT:    [[TMP1:%.*]] = load i32, ptr [[TMP0]], align 4, !dbg [[DBG181]]
// CHECK5-NEXT:    [[TMP2:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB32:[0-9]+]], i32 [[TMP1]]), !dbg [[DBG181]]
// CHECK5-NEXT:    [[TMP3:%.*]] = icmp ne i32 [[TMP2]], 0, !dbg [[DBG181]]
// CHECK5-NEXT:    br i1 [[TMP3]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]], !dbg [[DBG181]]
// CHECK5:       omp_if.then:
// CHECK5-NEXT:    invoke void @_Z3foov()
// CHECK5-NEXT:    to label [[INVOKE_CONT:%.*]] unwind label [[TERMINATE_LPAD:%.*]], !dbg [[DBG182:![0-9]+]]
// CHECK5:       invoke.cont:
// CHECK5-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB32]], i32 [[TMP1]]), !dbg [[DBG182]]
// CHECK5-NEXT:    br label [[OMP_IF_END]], !dbg [[DBG182]]
// CHECK5:       omp_if.end:
// CHECK5-NEXT:    call void @__kmpc_barrier(ptr @[[GLOB33:[0-9]+]], i32 [[TMP1]]), !dbg [[DBG183:![0-9]+]]
// CHECK5-NEXT:    ret void, !dbg [[DBG183]]
// CHECK5:       terminate.lpad:
// CHECK5-NEXT:    [[TMP4:%.*]] = landingpad { ptr, i32 }
// CHECK5-NEXT:    catch ptr null, !dbg [[DBG182]]
// CHECK5-NEXT:    [[TMP5:%.*]] = extractvalue { ptr, i32 } [[TMP4]], 0, !dbg [[DBG182]]
// CHECK5-NEXT:    call void @__clang_call_terminate(ptr [[TMP5]]) #[[ATTR13]], !dbg [[DBG182]]
// CHECK5-NEXT:    unreachable, !dbg [[DBG182]]
//
//
// CHECK5-LABEL: define {{[^@]+}}@_GLOBAL__sub_I_single_codegen.cpp
// CHECK5-SAME: () #[[ATTR0]] section "__TEXT,__StaticInit,regular,pure_instructions" !dbg [[DBG184:![0-9]+]] {
// CHECK5-NEXT:  entry:
// CHECK5-NEXT:    call void @__cxx_global_var_init(), !dbg [[DBG185:![0-9]+]]
// CHECK5-NEXT:    call void @__cxx_global_var_init.4(), !dbg [[DBG185]]
// CHECK5-NEXT:    call void @.__omp_threadprivate_init_.(), !dbg [[DBG185]]
// CHECK5-NEXT:    call void @.__omp_threadprivate_init_..3(), !dbg [[DBG185]]
// CHECK5-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@_Z10array_funciPiP2St
// CHECK6-SAME: (i32 noundef [[N:%.*]], ptr noundef [[A:%.*]], ptr noundef [[S:%.*]]) #[[ATTR0:[0-9]+]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[N_ADDR:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[A_ADDR:%.*]] = alloca ptr, align 8
// CHECK6-NEXT:    [[S_ADDR:%.*]] = alloca ptr, align 8
// CHECK6-NEXT:    [[DOTOMP_COPYPRIVATE_DID_IT:%.*]] = alloca i32, align 4
// CHECK6-NEXT:    [[DOTOMP_COPYPRIVATE_CPR_LIST:%.*]] = alloca [2 x ptr], align 8
// CHECK6-NEXT:    [[TMP0:%.*]] = call i32 @__kmpc_global_thread_num(ptr @[[GLOB1:[0-9]+]])
// CHECK6-NEXT:    store i32 [[N]], ptr [[N_ADDR]], align 4
// CHECK6-NEXT:    store ptr [[A]], ptr [[A_ADDR]], align 8
// CHECK6-NEXT:    store ptr [[S]], ptr [[S_ADDR]], align 8
// CHECK6-NEXT:    [[TMP1:%.*]] = load i32, ptr [[N_ADDR]], align 4
// CHECK6-NEXT:    [[TMP2:%.*]] = zext i32 [[TMP1]] to i64
// CHECK6-NEXT:    store i32 0, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK6-NEXT:    [[TMP3:%.*]] = call i32 @__kmpc_single(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK6-NEXT:    [[TMP4:%.*]] = icmp ne i32 [[TMP3]], 0
// CHECK6-NEXT:    br i1 [[TMP4]], label [[OMP_IF_THEN:%.*]], label [[OMP_IF_END:%.*]]
// CHECK6:       omp_if.then:
// CHECK6-NEXT:    call void @__kmpc_end_single(ptr @[[GLOB1]], i32 [[TMP0]])
// CHECK6-NEXT:    store i32 1, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK6-NEXT:    br label [[OMP_IF_END]]
// CHECK6:       omp_if.end:
// CHECK6-NEXT:    [[TMP5:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 0
// CHECK6-NEXT:    store ptr [[A_ADDR]], ptr [[TMP5]], align 8
// CHECK6-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x ptr], ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], i64 0, i64 1
// CHECK6-NEXT:    store ptr [[S_ADDR]], ptr [[TMP6]], align 8
// CHECK6-NEXT:    [[TMP7:%.*]] = load i32, ptr [[DOTOMP_COPYPRIVATE_DID_IT]], align 4
// CHECK6-NEXT:    call void @__kmpc_copyprivate(ptr @[[GLOB1]], i32 [[TMP0]], i64 16, ptr [[DOTOMP_COPYPRIVATE_CPR_LIST]], ptr @.omp.copyprivate.copy_func, i32 [[TMP7]])
// CHECK6-NEXT:    ret void
//
//
// CHECK6-LABEL: define {{[^@]+}}@.omp.copyprivate.copy_func
// CHECK6-SAME: (ptr noundef [[TMP0:%.*]], ptr noundef [[TMP1:%.*]]) #[[ATTR3:[0-9]+]] {
// CHECK6-NEXT:  entry:
// CHECK6-NEXT:    [[DOTADDR:%.*]] = alloca ptr, align 8
// CHECK6-NEXT:    [[DOTADDR1:%.*]] = alloca ptr, align 8
// CHECK6-NEXT:    store ptr [[TMP0]], ptr [[DOTADDR]], align 8
// CHECK6-NEXT:    store ptr [[TMP1]], ptr [[DOTADDR1]], align 8
// CHECK6-NEXT:    [[TMP2:%.*]] = load ptr, ptr [[DOTADDR]], align 8
// CHECK6-NEXT:    [[TMP3:%.*]] = load ptr, ptr [[DOTADDR1]], align 8
// CHECK6-NEXT:    [[TMP4:%.*]] = getelementptr inbounds [2 x ptr], ptr [[TMP2]], i64 0, i64 0
// CHECK6-NEXT:    [[TMP5:%.*]] = load ptr, ptr [[TMP4]], align 8
// CHECK6-NEXT:    [[TMP6:%.*]] = getelementptr inbounds [2 x ptr], ptr [[TMP3]], i64 0, i64 0
// CHECK6-NEXT:    [[TMP7:%.*]] = load ptr, ptr [[TMP6]], align 8
// CHECK6-NEXT:    [[TMP8:%.*]] = load ptr, ptr [[TMP7]], align 8
// CHECK6-NEXT:    store ptr [[TMP8]], ptr [[TMP5]], align 8
// CHECK6-NEXT:    [[TMP9:%.*]] = getelementptr inbounds [2 x ptr], ptr [[TMP2]], i64 0, i64 1
// CHECK6-NEXT:    [[TMP10:%.*]] = load ptr, ptr [[TMP9]], align 8
// CHECK6-NEXT:    [[TMP11:%.*]] = getelementptr inbounds [2 x ptr], ptr [[TMP3]], i64 0, i64 1
// CHECK6-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP11]], align 8
// CHECK6-NEXT:    [[TMP13:%.*]] = load ptr, ptr [[TMP12]], align 8
// CHECK6-NEXT:    store ptr [[TMP13]], ptr [[TMP10]], align 8
// CHECK6-NEXT:    ret void
//
