# NuGet E2E test scripts

This is a collection of scripts for Visual Studio End-to-End tests that run via the Package Manager Console.

The End-to-End tests depend on an integration provided by the [API.Test](./../../test/TestExtensions/API.Test/API.Test.csproj) project and the Package Manager Console's access to Visual Studio services.

The [CreateEndToEndTestPackage.ps1](./../cibuild/CreateEndToEndTestPackage.ps1) script generates a zip file that contains all the details needed for running End-to-End test.
This zip file can also be generated by the [build.ps1](./../../build.ps1) script.
Note that the scripts assume certain relative paths that are correct within the zip, but may not work if you attempt to use the scripts from the repo location.

***NOTE:*** To ensure that all tests are runnable, you may need to update Visual Studio with [tests vs config](build\tests.dev17.vsconfig).

## Running the tests

These tests run on the Visual Studio instance you need to test. They do not need Xunit or any other runner.

1. Create or download the end-to-end test ZIP file and extract it to a directory. It is recommended you extract the files in the `artifacts` directory at the repo root.
1. Run [SetupFunctionalTests.ps1](./SetupFunctionalTests.ps1). This step is executed once per machine.
1. Start the Visual Studio instance you want to test. This can be a regular Visual Studio instance, with or without a VSIX that you want to test installed, but it can also be an [experimental Visual Studio instance](./../../docs/debugging.md#debugging-and-testing-nuget-in-visual-studio) you want to debug.
1. Open the Package Manager Console and load the module from the unzipped end-to-end test package, [NuGet.Tests.psm1](./../../test/EndToEnd/NuGet.Tests.psm1), by running `Import-Module <NuGet.Tests.psm1 file path>`.
1. Run a test:
    - `Run-Test <TestName>` - The test name is the function name without a prefix `Test-`.
    - `Run-Test <FileName>` - The file name is a filename from the generated zip file.
    - `Run-Test` - Runs all tests the runner can discover based on the relative file location.

## Debugging End-to-End tests

1. Load the [experimental instance of Visual Studio](./../../docs/debugging.md#debugging-and-testing-nuget-in-visual-studio).
1. Find the code in question, and set your breakpoints.
1. Follow the [steps](#running-the-tests) for running the tests. Import the scripts in the experimental instance Package Manager Console.
