.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
cubocteversion - Displays a cuboctahedron eversion.
.SH SYNOPSIS
.B cubocteversion
[\-\-display \fIhost:display.screen\fP]
[\-\-install]
[\-\-visual \fIvisual\fP]
[\-\-window]
[\-\-root]
[\-\-window\-id \fInumber\fP]
[\-\-delay \fIusecs\fP]
[\-\-fps]
[\-\-eversion-method \fImethod\fP]
[\-\-morin-denner]
[\-\-apery]
[\-\-mode \fIdisplay-mode\fP]
[\-\-surface]
[\-\-transparent]
[\-\-edges \fIedge-mode\fP]
[\-\-self-intersections \fIself-intersection-mode\fP]
[\-\-colors \fIcolor-scheme\fP]
[\-\-twosided-colors]
[\-\-face-colors]
[\-\-earth-colors]
[\-\-deformation-speed \fIfloat\fP]
[\-\-projection \fIprojection-mode\fP]
[\-\-perspective]
[\-\-orthographic]
[\-\-transparency \fItransparency-method\fP]
[\-\-correct-transparency]
[\-\-approximate-transparency]
[\-\-standard-transparency]
[\-\-speed-x \fIfloat\fP]
[\-\-speed-y \fIfloat\fP]
[\-\-speed-z \fIfloat\fP]
.SH DESCRIPTION
The \fIcubocteversion\fP program shows a cuboctahedron
eversion, i.e., a smooth deformation (homotopy) that turns a
cuboctahedron inside out.  During the eversion, the deformed
cuboctahedron is allowed to intersect itself transversally.  However,
no fold edges or non-injective neighborhoods of vertices are allowed
to occur.
.PP
The cuboctahedron can be deformed with two eversion methods:
Morin-Denner or Apry.  The Morin-Denner cuboctahedron eversion method
is described in the following two papers: Richard Denner: "Versions
polydriques du retournement de la sphre", L'Ouvert 94:32-45, March
1999; Richard Denner: "Versions polydriques du retournement de la
sphre, retournement du cuboctadre", L'Ouvert 95:15-36, June 1999.
The Apry cuboctahedron eversion method is described in the following
paper: Franois Apry: "Le retournement du cuboctadre",
Prpublication de l'institut de recherche mathmatique avance,
Universit Louis Pasteur et C.N.R.S., Strasbourg, 1994.
.PP
The deformed cuboctahedron can be projected to the screen either
perspectively or orthographically.
.PP
There are three display modes for the cuboctahedron: solid,
transparent, or random.  If random mode is selected, the mode is
changed each time an eversion has been completed.
.PP
The edges of the faces of the cuboctahedron can be visualized in three
modes: without edge tubes, with edge tubes, or random.  If edge tubes
are selected, solid gray tubes are displayed around the edges of the
cuboctahedron.  This makes them more prominent.  If random mode is
selected, the mode is changed each time an eversion has been
completed.
.PP
During the eversion, the cuboctahedron must intersect itself.  It can
be selected how these self-intersections are displayed: without
self-intersection tubes, with self-intersection tubes, or random.  If
self-intersection tubes are selected, solid orange tubes are displayed
around the self-intersections of the cuboctahedron.  This makes them
more prominent.  If random mode is selected, the mode is changed each
time an eversion has been completed.
.PP
The colors with with the cuboctahedron is drawn can be set to
two-sided, face, earth, or random.  In two-sided mode, the
cuboctahedron is drawn with magenta on one side and cyan on the other
side.  In face mode, the cuboctahedron is displayed with different
colors for each face.  The colors of the faces are identical on the
inside and outside of the cuboctahedron.  Colors on the northern
hemi-cuboctahedron are brighter than those on the southern
hemi-cuboctahedron.  In earth mode, the cuboctahedron is drawn with a
texture of earth by day on one side and with a texture of earth by
night on the other side.  Initially, the earth by day is on the
outside and the earth by night on the inside.  After the first
eversion, the earth by night will be on the outside.  All points of
the earth on the inside and outside are at the same positions on the
cuboctahedron.  Since an eversion transforms the cuboctahedron into
its inverse, the earth by night will appear with all continents mirror
reversed.  If random mode is selected, the color scheme is changed
each time an eversion has been completed.
.PP
It is possible to rotate the cuboctahedron while it is deforming.  The
rotation speed for each of the three coordinate axes around which the
cuboctahedron rotates can be chosen arbitrarily.
.SH BRIEF DESCRIPTION OF THE CUBOCTAHEDRON EVERSION BASICS
A sphere eversion turns the standard embedding of the unit sphere
inside-out in a smooth manner.  Creases, pinch points, holes, etc. may
not occur during the eversion.  However, the sphere may intersect
itself during the eversion.  In mathematical terms, the eversion is a
regular homotopy between the sphere and the sphere point reflected at
its center.  A convex bounded polyhedron of Euler characteristic 2 is
homeomorphic to a sphere. Since a polyhedron does not have a
continuous tangent bundle, it cannot be everted by a regular homotopy,
which requires the tangent bundle induced by the homotopy to be
continuous.  Instead, it is required that polyhedron does not develop
fold edges during the eversion and that a neighborhood of each vertex
is injective throughout the eversion.  Fold edges occur whenever two
faces that share an edge become coplanar and all vertices of the two
faces lie on the same side of the edge in the plane in which they are
coplanar.  Furthermore, it is required that all self-intersections
between edges that occur during the eversion are transversal, which
means that they must not occur at the vertices of the edges.
.PP
Any eversion of the sphere (smooth or polyhedral) must contain a
quadruple point.  This is a point in which four different parts of the
deformed sphere intersect transversally.  For a polyhedron, this means
that four different faces must intersect transversally.  Four faces
are defined by four planes, each of which, in turn, is defined by
three vertices.  By the above requirements, none of the twelve
vertices that define the four planes may coincide.  Therefore, the
minimum number of vertices of a polyhedron that allows it to be
everted is twelve. The cuboctahedron has twelve vertices and the
papers cited above show that a cuboctahedron can indeed be everted.
.PP
A cuboctahedron has 14 faces: six squares and eight equilateral
triangles.  To perform the eversion, the cuboctahedron is oriented
such that two opposite squares are horizontal.  One of these squares
corresponds to the north polar region and one to the south polar
region if the cubctahedron is identified with the round sphere.  The
four remaining squares are vertical and lie in the tropical region
around the equator.  Each square is then divided into two isosceles
right triangles.  The four tropical squares are divided along the
equator and the north and south pole squares are divided in orthogonal
directions: the edge introduced in the north pole square is orthogonal
to that introduced in the south pole square.  This results in a
triangulated version of the cuboctahedron with 12 vertices, 30 edges,
and 20 triangular faces.  This is the version of the cuboctahedron
that can be everted.
.SH BRIEF DESCRIPTION OF THE MORIN-DENNER CUBOCTAHEDRON EVERSION METHOD
The approach of Morin and Denner is to evert the cuboctahedron in 44
steps, resulting in 45 different polyhedra that occur as models.  The
eversion is symmetric in time, so the 44 steps can be visualized by
time running from -22 to 22.  Of the 45 models, 44 possess a twofold
rotational symmetry.  The halfway model at time 0 possesses a fourfold
rotational symmetry.  The halfway model is the model at which the
cuboctahedron is turned halfway inside-out.  In each of the 44 steps,
two vertices of the cuboctahedron are moved along two respective
straight lines, each of which is an edge or an extension of an edge of
the cuboctahedron.  After the eversion has been completed, the inside
of the cuboctahedron lies on the outside.  Furthermore, all points of
the everted cuboctahedron lie at the antipodal points of the original
cuboctahedron.
.PP
The following description assumes that the cuboctahedron is visualized
in two-sided color mode.  In the first 16 steps, the magenta
cuboctahedron is deformed into a magenta polyhedron that Morin and
Denner call the bicorne.  During this phase, no self-intersections
occur.  Topologically, the bicorne is still an embedded sphere.  The
next twelve steps, from time -6 to 6, are the most interesting steps
of the eversion: the cuboctahedron intersects itself.  It no longer is
an embedding but an immersion.  In this phase, progressively more of
the cyan inside becomes visible.  These steps are shown at a two times
slower speed compared to the rest of the steps.  At time 6, the
eversion has produced a cyan bicorne.  At this step, the cuboctahetron
has been everted: it is an embedding of the everted sphere.  In the
remaining 16 steps, the cyan bicorne is deformed to the everted
cuboctahedron.
.SH BRIEF DESCRIPTION OF THE APRY CUBOCTAHEDRON EVERSION METHOD
The original approach of Apry is to evert the cuboctahedron in four
steps, resulting in five different polyhedra that occur as models.
The eversion is symmetric in time, so the four steps can be visualized
by time running from -2 to 2.  Of the five models, four possess a
twofold rotational symmetry.  The halfway model at time 0 possesses a
fourfold rotational symmetry.  The halfway model is the model at which
the cuboctahedron is turned halfway inside-out.  In addition to the
start and end models at times -2 and 2, which both are cuboctahedra,
and the halfway model at time 0, the two intermediate models at times
-1 and 1 are embeddings of the cuboctahedron.  Apry calls them
gastrula because they correspond to a cuboctahedron in which the
northern hemi-cuboctahedron has been pushed downwards so that it lies
inside the southern hemi-cuboctahedron.  In each of the four steps,
the cuboctahedron is deformed by linearly interpolating the
corresponding vertices between two successive models.  After the
eversion has been completed, the inside of the cuboctahedron lies on
the outside.  Furthermore, all points of the everted cuboctahedron lie
at the antipodal points of the original cuboctahedron.
.PP
During the development of this program, it was discovered that the
linear interpolation between the cuboctahedron and the gastrula causes
the deformed cuboctahedron to intersect itself for a brief period of
time shortly before the gastrula is reached.  Therefore, an additional
model, devised by Franois Apry and called pre-gastrula by him, was
inserted at times -1.25 and 1.25.  This additional model avoids the
self-intersections before the gastrula is reached.  The rest of
Apry's approach remains unaffected: the vertices are interpolated
linearly between successive models.
.PP
The following description assumes that the cuboctahedron is visualized
in two-sided color mode.  In the first two steps, the magenta
cuboctahedron is deformed into a magenta gastrula.  During this phase,
no self-intersections occur.  Topologically, the gastrula is still an
embedded sphere.  The next two steps, from time -1 to 1, are the most
interesting steps of the eversion: the cuboctahedron intersects
itself.  It no longer is an embedding but an immersion.  In this
phase, progressively more of the cyan inside becomes visible.  At time
1, the eversion has produced a cyan gastrula.  At this step, the
cuboctahetron has been everted: it is an embedding of the everted
sphere.  In the remaining two steps, the cyan gastrula is deformed to
the everted cuboctahedron.
.SH OPTIONS
.I cubocteversion
accepts the following options:
.TP 8
.B \-\-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-\-root
Draw on the root window.
.TP 8
.B \-\-window\-id \fInumber\fP
Draw on the specified window.
.TP 8
.B \-\-install
Install a private colormap for the window.
.TP 8
.B \-\-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual
class, or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-\-delay \fImicroseconds\fP
How much of a delay should be introduced between steps of the
animation.  Default 20000, or 1/50th second.
.TP 8
.B \-\-fps
Display the current frame rate, CPU load, and polygon count.
.PP
The following three options are mutually exclusive.  They determine
which cuboctahedron eversion method is used.
.TP 8
.B \-\-eversion-method random
Use a random cuboctahedron eversion method (default).
.TP 8
.B \-\-eversion-method  morin-denner \fP(Shortcut: \fB\-\-morin-denner\fP)
Use the Morin-Denner cuboctahedron eversion method.
.TP 8
.B \-\-eversion-method apery \fP(Shortcut: \fB\-\-apery\fP)
Use the Apry cuboctahedron eversion method.
.PP
The following three options are mutually exclusive.  They determine
how the deformed cuboctahedron is displayed.
.TP 8
.B \-\-mode random
Display the cuboctahedron in a random display mode (default).
.TP 8
.B \-\-mode surface \fP(Shortcut: \fB\-\-surface\fP)
Display the cuboctahedron as a solid surface.
.TP 8
.B \-\-mode transparent \fP(Shortcut: \fB\-\-transparent\fP)
Display the cuboctahedron as a transparent surface.
.PP
The following three options are mutually exclusive.  They determine
whether the edges of the cuboctahedron are displayed as solid gray
tubes.
.TP 8
.B \-\-edges random
Randomly choose whether to display edge tubes (default).
.TP 8
.B \-\-edges on
Display the cuboctahedron with edge tubes.
.TP 8
.B \-\-edges off
Display the cuboctahedron without edge tubes.
.PP
The following three options are mutually exclusive.  They determine
whether the self-intersections of the deformed cuboctahedron are
displayed as solid orange tubes.
.TP 8
.B \-\-self-intersections random
Randomly choose whether to display self-intersection tubes (default).
.TP 8
.B \-\-self-intersections on
Display the cuboctahedron with self-intersection tubes.
.TP 8
.B \-\-self-intersections off
Display the cuboctahedron without self-intersection tubes.
.PP
The following four options are mutually exclusive.  They determine how
to color the deformed cuboctahedron.
.TP 8
.B \-\-colors random
Display the cuboctahedron with a random color scheme (default).
.TP 8
.B \-\-colors twosided \fP(Shortcut: \fB\-\-twosided-colors\fP)
Display the cuboctahedron with two colors: magenta on one side and
cyan on the other side.
.TP 8
.B \-\-colors face \fP(Shortcut: \fB\-\-face-colors\fP)
Display the cuboctahedron with different colors for each face. The
colors of the faces are identical on the inside and outside of the
cuboctahedron.  Colors on the northern hemi-cuboctahedron are brighter
than those on the southern hemi-cuboctahedron.
.TP 8
.B \-\-colors earth \fP(Shortcut: \fB\-\-earth-colors\fP)
Display the cuboctahedron with a texture of earth by day on one side
and with a texture of earth by night on the other side.  Initially,
the earth by day is on the outside and the earth by night on the
inside.  After the first eversion, the earth by night will be on the
outside.  All points of the earth on the inside and outside are at the
same positions on the cuboctahedron.  Since an eversion transforms the
cuboctahedron into its inverse, the earth by night will appear with
all continents mirror reversed.
.PP
The following option determines the deformation speed.
.TP 8
.B \-\-deformation-speed \fIfloat\fP
The deformation speed is measured in percent of some sensible maximum
speed (default: 20.0).
.PP
The following three options are mutually exclusive.  They determine
how the deformed cuboctahedron is projected from 3d to 2d (i.e., to
the screen).
.TP 8
.B \-\-projection random
Project the cuboctahedron from 3d to 2d using a random projection mode
(default).
.TP 8
.B \-\-projection perspective \fP(Shortcut: \fB\-\-perspective\fP)
Project the cuboctahedron from 3d to 2d using a perspective
projection.
.TP 8
.B \-\-projection orthographic \fP(Shortcut: \fB\-\-orthographic\fP)
Project the cuboctahedron from 3d to 2d using an orthographic
projection.
.PP
The following three options are mutually exclusive.  They determine
which transparency algorithm is used to display the transparent faces
of the cuboctahedron.  If correct transparency is selected, a correct
but slower algorithm is used to render the transparent faces.  If the
frame rate of this algorithm is too slow and results in a jerky
animation, it can be set to one of the other two modes.  If
approximate transparency is selected, an transparency algorithm that
provides an approximation to the correct transparency is used.
Finally, if standard transparency is selected, a transparency
algorithm that only uses standard OpenGL transparency rendering
features is used.  It results in a lower-quality rendering of the
transparent faces in which the appearance depends on the order in
which the faces are drawn.  The approximate and standard transparency
algorithms are equally fast and, depending on the GPU, can be
significantly faster than the correct transparency algorithm.  The
correct and approximate transparency algorithms are automatically
switched off if the OpenGL version supported by the operating system
does not support them (for example, on iOS and iPadOS).
.TP 8
.B \-\-transparency correct \fP(Shortcut: \fB\-\-correct-transparency\fP)
Use a transparency algorithm that results in a correct rendering of
transparent surfaces (default).
.TP 8
.B \-\-transparency approximate \fP(Shortcut: \fB\-\-approximate-transparency\fP)
Use a transparency algorithm that results in an approximately correct
rendering of transparent surfaces.
.TP 8
.B \-\-transparency standard \fP(Shortcut: \fB\-\-standard-transparency\fP)
Use a transparency algorithm that uses only standard OpenGL features
for the rendering of transparent surfaces.
.PP
The following three options determine the rotation speed of the
deformed cuboctahedron around the three possible axes.  The rotation
speed is measured in degrees per frame.  The speeds should be set to
relatively small values, e.g., less than 4 in magnitude.
.TP 8
.B \-\-speed-x \fIfloat\fP
Rotation speed around the x axis (default: 0.0).
.TP 8
.B \-\-speed-y \fIfloat\fP
Rotation speed around the y axis (default: 0.0).
.TP 8
.B \-\-speed-z \fIfloat\fP
Rotation speed around the z axis (default: 0.0).
.SH INTERACTION
If you run this program in standalone mode, you can rotate the
deformed cuboctahedron by dragging the mouse while pressing the left
mouse button.  This rotates the cuboctahedron in 3d.  To examine the
deformed cuboctahedron at your leisure, it is best to set all speeds
to 0.  Otherwise, the deformed cuboctahedron will rotate while the
left mouse button is not pressed.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.TP 8
.B XSCREENSAVER_WINDOW
The window ID to use with \fI\-\-root\fP.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1),
.SH COPYRIGHT
Copyright \(co 2023 by Carsten Steger.  Permission to use, copy,
modify, distribute, and sell this software and its documentation for
any purpose is hereby granted without fee, provided that the above
copyright notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting documentation.
No representations are made about the suitability of this software for
any purpose.  It is provided "as is" without express or implied
warranty.
.SH AUTHOR
Carsten Steger <carsten@mirsanmir.org>, 06-mar-2023.
