/* valagirparser.c generated by valac, the Vala compiler
 * generated from valagirparser.vala, do not modify */

/* valagirparser.vala
 *
 * Copyright (C) 2008-2012  Jürg Billeter
 * Copyright (C) 2011-2014  Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Luca Bruno <lucabru@src.gnome.org>
 */

#include "vala.h"
#include <glib-object.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>
#include <errno.h>

#define VALA_GIR_PARSER_TYPE_NODE (vala_gir_parser_node_get_type ())
#define VALA_GIR_PARSER_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNode))
#define VALA_GIR_PARSER_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNodeClass))
#define VALA_GIR_PARSER_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_NODE))
#define VALA_GIR_PARSER_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_NODE))
#define VALA_GIR_PARSER_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNodeClass))

typedef struct _ValaGirParserNode ValaGirParserNode;
typedef struct _ValaGirParserNodeClass ValaGirParserNodeClass;

#define VALA_GIR_PARSER_TYPE_METADATA (vala_gir_parser_metadata_get_type ())
#define VALA_GIR_PARSER_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadata))
#define VALA_GIR_PARSER_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadataClass))
#define VALA_GIR_PARSER_IS_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_METADATA))
#define VALA_GIR_PARSER_IS_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_METADATA))
#define VALA_GIR_PARSER_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadataClass))

typedef struct _ValaGirParserMetadata ValaGirParserMetadata;
typedef struct _ValaGirParserMetadataClass ValaGirParserMetadataClass;
typedef enum  {
	VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP,
	VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN,
	VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_OUT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_REF,
	VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SEALED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS,
	VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING,
	VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID,
	VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID,
	VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE
} ValaGirParserArgumentType;

#define VALA_GIR_PARSER_TYPE_ARGUMENT_TYPE (vala_gir_parser_argument_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
#define _vala_markup_reader_unref0(var) ((var == NULL) ? NULL : (var = (vala_markup_reader_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_gir_parser_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_gir_parser_metadata_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_metadata_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
typedef struct _ValaGirParserNodePrivate ValaGirParserNodePrivate;

#define VALA_GIR_PARSER_TYPE_PARAMETER_INFO (vala_gir_parser_parameter_info_get_type ())
#define VALA_GIR_PARSER_PARAMETER_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfo))
#define VALA_GIR_PARSER_PARAMETER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfoClass))
#define VALA_GIR_PARSER_IS_PARAMETER_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_PARAMETER_INFO))
#define VALA_GIR_PARSER_IS_PARAMETER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_PARAMETER_INFO))
#define VALA_GIR_PARSER_PARAMETER_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfoClass))

typedef struct _ValaGirParserParameterInfo ValaGirParserParameterInfo;
typedef struct _ValaGirParserParameterInfoClass ValaGirParserParameterInfoClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
typedef struct _ValaGirParserParameterInfoPrivate ValaGirParserParameterInfoPrivate;

#define VALA_GIR_PARSER_TYPE_METADATA_PARSER (vala_gir_parser_metadata_parser_get_type ())
#define VALA_GIR_PARSER_METADATA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParser))
#define VALA_GIR_PARSER_METADATA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParserClass))
#define VALA_GIR_PARSER_IS_METADATA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_METADATA_PARSER))
#define VALA_GIR_PARSER_IS_METADATA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_METADATA_PARSER))
#define VALA_GIR_PARSER_METADATA_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParserClass))

typedef struct _ValaGirParserMetadataParser ValaGirParserMetadataParser;
typedef struct _ValaGirParserMetadataParserClass ValaGirParserMetadataParserClass;
#define _vala_gir_parser_metadata_parser_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_metadata_parser_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))
#define _vala_gir_parser_parameter_info_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_parameter_info_unref (var), NULL)))
typedef struct _ValaGirParserMetadataPrivate ValaGirParserMetadataPrivate;

#define VALA_GIR_PARSER_TYPE_ARGUMENT (vala_gir_parser_argument_get_type ())
#define VALA_GIR_PARSER_ARGUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgument))
#define VALA_GIR_PARSER_ARGUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgumentClass))
#define VALA_GIR_PARSER_IS_ARGUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_ARGUMENT))
#define VALA_GIR_PARSER_IS_ARGUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_ARGUMENT))
#define VALA_GIR_PARSER_ARGUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgumentClass))

typedef struct _ValaGirParserArgument ValaGirParserArgument;
typedef struct _ValaGirParserArgumentClass ValaGirParserArgumentClass;
typedef struct _ValaGirParserArgumentPrivate ValaGirParserArgumentPrivate;
#define _vala_gir_parser_argument_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_argument_unref (var), NULL)))
#define _vala_map_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_iterator_unref (var), NULL)))
typedef struct _ValaGirParserParamSpecArgument ValaGirParserParamSpecArgument;

#define VALA_GIR_PARSER_TYPE_METADATA_SET (vala_gir_parser_metadata_set_get_type ())
#define VALA_GIR_PARSER_METADATA_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_METADATA_SET, ValaGirParserMetadataSet))
#define VALA_GIR_PARSER_METADATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_METADATA_SET, ValaGirParserMetadataSetClass))
#define VALA_GIR_PARSER_IS_METADATA_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_METADATA_SET))
#define VALA_GIR_PARSER_IS_METADATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_METADATA_SET))
#define VALA_GIR_PARSER_METADATA_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_METADATA_SET, ValaGirParserMetadataSetClass))

typedef struct _ValaGirParserMetadataSet ValaGirParserMetadataSet;
typedef struct _ValaGirParserMetadataSetClass ValaGirParserMetadataSetClass;
typedef struct _ValaGirParserMetadataSetPrivate ValaGirParserMetadataSetPrivate;
#define _g_pattern_spec_free0(var) ((var == NULL) ? NULL : (var = (g_pattern_spec_free (var), NULL)))
typedef struct _ValaGirParserParamSpecMetadata ValaGirParserParamSpecMetadata;
typedef struct _ValaGirParserMetadataParserPrivate ValaGirParserMetadataParserPrivate;
#define _vala_scanner_unref0(var) ((var == NULL) ? NULL : (var = (vala_scanner_unref (var), NULL)))
typedef struct _ValaGirParserParamSpecMetadataParser ValaGirParserParamSpecMetadataParser;
typedef struct _ValaGirParserParamSpecNode ValaGirParserParamSpecNode;
typedef struct _ValaGirParserParamSpecParameterInfo ValaGirParserParamSpecParameterInfo;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGirParserPrivate {
	ValaMarkupReader* reader;
	ValaCodeContext* context;
	ValaSourceFile* current_source_file;
	ValaGirParserNode* root;
	ValaArrayList* metadata_roots;
	ValaSourceLocation begin;
	ValaSourceLocation end;
	ValaMarkupTokenType current_token;
	gchar** cheader_filenames;
	gint cheader_filenames_length1;
	gint _cheader_filenames_size_;
	ValaArrayList* metadata_stack;
	ValaGirParserMetadata* metadata;
	ValaArrayList* tree_stack;
	ValaGirParserNode* current;
	ValaGirParserNode* old_current;
	ValaSet* provided_namespaces;
	ValaHashMap* unresolved_symbols_map;
	ValaArrayList* unresolved_gir_symbols;
	ValaHashMap* unresolved_type_arguments;
	ValaArrayList* ifaces_needing_object_prereq;
};

struct _ValaGirParserNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaGirParserNode* parent;
	gchar* element_type;
	gchar* name;
	ValaMap* girdata;
	ValaGirParserMetadata* metadata;
	ValaSourceReference* source_reference;
	ValaArrayList* members;
	ValaHashMap* scope;
	ValaGirComment* comment;
	ValaSymbol* symbol;
	gboolean new_symbol;
	gboolean merged;
	gboolean processed;
	gint return_array_length_idx;
	ValaList* parameters;
	ValaArrayList* array_length_parameters;
	ValaArrayList* closure_parameters;
	ValaArrayList* destroy_parameters;
	ValaUnresolvedSymbol* gtype_struct_for;
	ValaDataType* base_type;
	gint array_length_idx;
	gboolean deprecated;
	guint64 deprecated_version;
	gchar* deprecated_since;
	gchar* deprecated_replacement;
	ValaGirParserNodePrivate * priv;
};

struct _ValaGirParserNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserNode *self);
};

struct _ValaGirParserParameterInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaParameter* param;
	gfloat vala_idx;
	gint array_length_idx;
	gint closure_idx;
	gint destroy_idx;
	gboolean keep;
	gboolean is_async;
	gboolean is_error;
	ValaGirParserParameterInfoPrivate * priv;
};

struct _ValaGirParserParameterInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserParameterInfo *self);
};

struct _ValaGirParserMetadata {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GPatternSpec* pattern_spec;
	gchar* selector;
	ValaSourceReference* source_reference;
	gboolean used;
	ValaMap* args;
	ValaArrayList* children;
	ValaGirParserMetadataPrivate * priv;
};

struct _ValaGirParserMetadataClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserMetadata *self);
};

struct _ValaGirParserArgument {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaExpression* expression;
	ValaSourceReference* source_reference;
	gboolean used;
	ValaGirParserArgumentPrivate * priv;
};

struct _ValaGirParserArgumentClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserArgument *self);
};

struct _ValaGirParserParamSpecArgument {
	GParamSpec parent_instance;
};

struct _ValaGirParserMetadataSet {
	ValaGirParserMetadata parent_instance;
	ValaGirParserMetadataSetPrivate * priv;
};

struct _ValaGirParserMetadataSetClass {
	ValaGirParserMetadataClass parent_class;
};

struct _ValaGirParserParamSpecMetadata {
	GParamSpec parent_instance;
};

struct _ValaGirParserMetadataParser {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaGirParserMetadataParserPrivate * priv;
};

struct _ValaGirParserMetadataParserClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserMetadataParser *self);
};

struct _ValaGirParserMetadataParserPrivate {
	ValaGirParserMetadata* tree;
	ValaScanner* scanner;
	ValaSourceLocation begin;
	ValaSourceLocation end;
	ValaSourceLocation old_end;
	ValaTokenType current;
	ValaGirParserMetadata* parent_metadata;
};

struct _ValaGirParserParamSpecMetadataParser {
	GParamSpec parent_instance;
};

struct _ValaGirParserParamSpecNode {
	GParamSpec parent_instance;
};

struct _ValaGirParserParamSpecParameterInfo {
	GParamSpec parent_instance;
};

static gint ValaGirParser_private_offset;
static gpointer vala_gir_parser_parent_class = NULL;
static GRegex* vala_gir_parser_type_from_string_regex;
static GRegex* vala_gir_parser_type_from_string_regex = NULL;
static ValaArrayList* vala_gir_parser_node_new_namespaces;
static gpointer vala_gir_parser_argument_parent_class = NULL;
static gpointer vala_gir_parser_metadata_set_parent_class = NULL;
static gpointer vala_gir_parser_metadata_parent_class = NULL;
static ValaGirParserMetadata* vala_gir_parser_metadata__empty;
static ValaGirParserMetadata* vala_gir_parser_metadata__empty = NULL;
static gint ValaGirParserMetadataParser_private_offset;
static gpointer vala_gir_parser_metadata_parser_parent_class = NULL;
static gpointer vala_gir_parser_node_parent_class = NULL;
static ValaArrayList* vala_gir_parser_node_new_namespaces = NULL;
static gpointer vala_gir_parser_parameter_info_parent_class = NULL;

static gpointer vala_gir_parser_node_ref (gpointer instance);
static void vala_gir_parser_node_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_node (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_node (GValue* value,
                                     gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_node (GValue* value,
                                      gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_node (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_node_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gpointer vala_gir_parser_metadata_ref (gpointer instance);
static void vala_gir_parser_metadata_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_metadata (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_metadata (GValue* value,
                                         gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_metadata (GValue* value,
                                          gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_metadata (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_metadata_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType vala_gir_parser_argument_type_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGirParserArgumentType* vala_gir_parser_argument_type_from_string (const gchar* name);
static ValaGirParserArgumentType* _vala_gir_parser_argument_type_dup (ValaGirParserArgumentType* self);
#define VALA_GIR_PARSER_GIR_VERSION "1.2"
static guint vala_gir_parser_unresolved_symbol_hash (ValaUnresolvedSymbol* sym);
static guint _vala_gir_parser_unresolved_symbol_hash_ghash_func (gconstpointer key);
static gboolean vala_gir_parser_unresolved_symbol_equal (ValaUnresolvedSymbol* sym1,
                                                  ValaUnresolvedSymbol* sym2);
static gboolean _vala_gir_parser_unresolved_symbol_equal_gequal_func (gconstpointer a,
                                                               gconstpointer b);
static ValaGirParserNode* vala_gir_parser_node_new (const gchar* name);
static ValaGirParserNode* vala_gir_parser_node_construct (GType object_type,
                                                   const gchar* name);
static gpointer vala_gir_parser_parameter_info_ref (gpointer instance);
static void vala_gir_parser_parameter_info_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_parameter_info (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_parameter_info (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_parameter_info (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_parameter_info (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_parameter_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void vala_gir_parser_map_vala_to_gir (ValaGirParser* self);
static void vala_gir_parser_resolve_gir_symbols (ValaGirParser* self);
static void vala_gir_parser_create_new_namespaces (ValaGirParser* self);
static void vala_gir_parser_resolve_type_arguments (ValaGirParser* self);
static void vala_gir_parser_node_process (ValaGirParserNode* self,
                                   ValaGirParser* parser);
static void vala_gir_parser_report_unused_metadata (ValaGirParser* self,
                                             ValaGirParserMetadata* metadata);
static void vala_gir_parser_set_symbol_mapping (ValaGirParser* self,
                                         ValaUnresolvedSymbol* map_from,
                                         ValaSymbol* map_to);
static void vala_gir_parser_real_visit_source_file (ValaCodeVisitor* base,
                                             ValaSourceFile* source_file);
static ValaGirParserMetadata* vala_gir_parser_metadata_get_empty (void);
static void vala_gir_parser_next (ValaGirParser* self);
static void vala_gir_parser_parse_repository (ValaGirParser* self);
static void vala_gir_parser_start_element (ValaGirParser* self,
                                    const gchar* name);
static ValaSourceReference* vala_gir_parser_get_current_src (ValaGirParser* self);
static void vala_gir_parser_end_element (ValaGirParser* self,
                                  const gchar* name);
static void vala_gir_parser_skip_element (ValaGirParser* self);
static ValaSourceReference* vala_gir_parser_get_src (ValaGirParser* self,
                                              ValaSourceLocation* begin,
                                              ValaSourceLocation* end);
static void vala_gir_parser_add_symbol_to_container (ValaSymbol* container,
                                              ValaSymbol* sym);
static gboolean vala_gir_parser_is_container (ValaSymbol* sym);
static ValaUnresolvedSymbol* vala_gir_parser_parse_symbol_from_string (ValaGirParser* self,
                                                                const gchar* symbol_string,
                                                                ValaSourceReference* source_reference);
static void vala_gir_parser_assume_parameter_names (ValaGirParser* self,
                                             ValaSignal* sig,
                                             ValaSymbol* sym,
                                             gboolean skip_first);
static ValaGirParserNode* vala_gir_parser_find_invoker (ValaGirParser* self,
                                                 ValaGirParserNode* node);
static ValaGirParserMetadata* vala_gir_parser_get_current_metadata (ValaGirParser* self);
static ValaGirParserMetadata* vala_gir_parser_metadata_match_child (ValaGirParserMetadata* self,
                                                             const gchar* name,
                                                             const gchar* selector);
static gboolean vala_gir_parser_push_metadata (ValaGirParser* self);
static gboolean vala_gir_parser_metadata_has_argument (ValaGirParserMetadata* self,
                                                ValaGirParserArgumentType key);
static gboolean vala_gir_parser_metadata_get_bool (ValaGirParserMetadata* self,
                                            ValaGirParserArgumentType arg,
                                            gboolean default_value);
static void vala_gir_parser_pop_metadata (ValaGirParser* self);
static gboolean vala_gir_parser_parse_type_arguments_from_string (ValaGirParser* self,
                                                           ValaDataType* parent_type,
                                                           const gchar* type_arguments,
                                                           ValaSourceReference* source_reference);
static ValaDataType* vala_gir_parser_parse_type_from_string (ValaGirParser* self,
                                                      const gchar* type_string,
                                                      gboolean owned_by_default,
                                                      ValaSourceReference* source_reference);
static gchar* vala_gir_parser_element_get_string (ValaGirParser* self,
                                           const gchar* attribute_name,
                                           ValaGirParserArgumentType arg_type);
static gchar* vala_gir_parser_metadata_get_string (ValaGirParserMetadata* self,
                                            ValaGirParserArgumentType arg);
static ValaDataType* vala_gir_parser_element_get_type (ValaGirParser* self,
                                                ValaDataType* orig_type,
                                                gboolean owned_by_default,
                                                gboolean* no_array_length,
                                                gboolean* array_null_terminated,
                                                gboolean* changed);
static ValaSourceReference* vala_gir_parser_metadata_get_source_reference (ValaGirParserMetadata* self,
                                                                    ValaGirParserArgumentType arg);
static gchar* vala_gir_parser_element_get_name (ValaGirParser* self,
                                         const gchar* gir_name);
static gchar* vala_gir_parser_element_get_type_id (ValaGirParser* self);
static void vala_gir_parser_set_array_ccode (ValaGirParser* self,
                                      ValaSymbol* sym,
                                      ValaGirParserParameterInfo* info);
static ValaGirParserNode* vala_gir_parser_node_lookup (ValaGirParserNode* self,
                                                const gchar* name,
                                                gboolean create_namespace,
                                                ValaSourceReference* source_reference);
static gchar* vala_gir_parser_node_get_cname (ValaGirParserNode* self);
static void vala_gir_parser_set_type_id_ccode (ValaGirParser* self,
                                        ValaSymbol* sym);
static void vala_gir_parser_parse_namespace (ValaGirParser* self);
static void vala_gir_parser_parse_include (ValaGirParser* self);
static gchar* vala_gir_parser_parse_package (ValaGirParser* self);
static void vala_gir_parser_parse_c_include (ValaGirParser* self);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static ValaGirParserNode* vala_gir_parser_resolve_node (ValaGirParser* self,
                                                 ValaGirParserNode* parent_scope,
                                                 ValaUnresolvedSymbol* unresolved_sym,
                                                 gboolean create_namespace);
static ValaSymbol* vala_gir_parser_resolve_symbol (ValaGirParser* self,
                                            ValaGirParserNode* parent_scope,
                                            ValaUnresolvedSymbol* unresolved_sym);
static void vala_gir_parser_push_node (ValaGirParser* self,
                                const gchar* name,
                                gboolean merge);
static void vala_gir_parser_node_add_member (ValaGirParserNode* self,
                                      ValaGirParserNode* node);
static gchar* vala_gir_parser_node_get_gir_name (ValaGirParserNode* self);
static ValaUnresolvedSymbol* vala_gir_parser_node_get_unresolved_symbol (ValaGirParserNode* self);
static void vala_gir_parser_pop_node (ValaGirParser* self);
static gpointer vala_gir_parser_metadata_parser_ref (gpointer instance);
static void vala_gir_parser_metadata_parser_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_metadata_parser (const gchar* name,
                                                        const gchar* nick,
                                                        const gchar* blurb,
                                                        GType object_type,
                                                        GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_metadata_parser (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_metadata_parser (GValue* value,
                                                 gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_metadata_parser (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_metadata_parser_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGirParserMetadataParser* vala_gir_parser_metadata_parser_new (void);
static ValaGirParserMetadataParser* vala_gir_parser_metadata_parser_construct (GType object_type);
static ValaGirParserMetadata* vala_gir_parser_metadata_parser_parse_metadata (ValaGirParserMetadataParser* self,
                                                                       ValaSourceFile* metadata_file);
static void _vala_code_node_unref0_ (gpointer var);
static inline void _g_list_free__vala_code_node_unref0_ (GList* self);
static void vala_gir_parser_parse_alias (ValaGirParser* self);
static void vala_gir_parser_parse_error_domain (ValaGirParser* self);
static void vala_gir_parser_parse_enumeration (ValaGirParser* self,
                                        const gchar* element_name,
                                        gboolean error_domain);
static void vala_gir_parser_parse_bitfield (ValaGirParser* self);
static void vala_gir_parser_parse_method (ValaGirParser* self,
                                   const gchar* element_name);
static void vala_gir_parser_parse_callback (ValaGirParser* self);
static void vala_gir_parser_parse_record (ValaGirParser* self);
static void vala_gir_parser_parse_boxed (ValaGirParser* self,
                                  const gchar* element_name);
static void vala_gir_parser_parse_class (ValaGirParser* self);
static void vala_gir_parser_parse_interface (ValaGirParser* self);
static void vala_gir_parser_parse_union (ValaGirParser* self);
static void vala_gir_parser_parse_constant (ValaGirParser* self);
static ValaGirComment* vala_gir_parser_parse_symbol_doc (ValaGirParser* self);
static ValaDataType* vala_gir_parser_parse_type (ValaGirParser* self,
                                          gchar* * ctype,
                                          gint* array_length_idx,
                                          gboolean transfer_elements,
                                          gboolean* no_array_length,
                                          gboolean* array_null_terminated);
static void vala_gir_parser_calculate_common_prefix (ValaGirParser* self,
                                              gchar* * common_prefix,
                                              const gchar* cname);
static ValaComment* vala_gir_parser_parse_doc (ValaGirParser* self);
static void vala_gir_parser_parse_error_member (ValaGirParser* self);
static void vala_gir_parser_parse_enumeration_member (ValaGirParser* self);
static ValaExpression* vala_gir_parser_metadata_get_expression (ValaGirParserMetadata* self,
                                                         ValaGirParserArgumentType arg);
static ValaDataType* vala_gir_parser_parse_return_value (ValaGirParser* self,
                                                  gchar* * ctype,
                                                  gint* array_length_idx,
                                                  gboolean* no_array_length,
                                                  gboolean* array_null_terminated,
                                                  ValaComment* * comment);
static ValaParameter* vala_gir_parser_parse_parameter (ValaGirParser* self,
                                                gint* array_length_idx,
                                                gint* closure_idx,
                                                gint* destroy_idx,
                                                gchar* * scope,
                                                ValaComment* * comment,
                                                const gchar* default_name);
static gint vala_gir_parser_metadata_get_integer (ValaGirParserMetadata* self,
                                           ValaGirParserArgumentType arg);
static ValaDataType* vala_gir_parser_parse_type_from_gir_name (ValaGirParser* self,
                                                        const gchar* type_name,
                                                        gboolean* no_array_length,
                                                        gboolean* array_null_terminated,
                                                        const gchar* ctype);
static void vala_gir_parser_parse_field (ValaGirParser* self);
static void vala_gir_parser_parse_constructor (ValaGirParser* self);
static ValaProperty* vala_gir_parser_parse_property (ValaGirParser* self);
static void vala_gir_parser_parse_signal (ValaGirParser* self);
static void vala_gir_parser_parse_function (ValaGirParser* self,
                                     const gchar* element_name);
G_GNUC_INTERNAL void vala_gir_comment_add_content_for_parameter (ValaGirComment* self,
                                                 const gchar* name,
                                                 ValaComment* comment);
static ValaGirParserParameterInfo* vala_gir_parser_parameter_info_new (ValaParameter* param,
                                                                gint array_length_idx,
                                                                gint closure_idx,
                                                                gint destroy_idx,
                                                                gboolean is_async);
static ValaGirParserParameterInfo* vala_gir_parser_parameter_info_construct (GType object_type,
                                                                      ValaParameter* param,
                                                                      gint array_length_idx,
                                                                      gint closure_idx,
                                                                      gint destroy_idx,
                                                                      gboolean is_async);
static gpointer vala_gir_parser_argument_ref (gpointer instance);
static void vala_gir_parser_argument_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_argument (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_argument (GValue* value,
                                         gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_argument (GValue* value,
                                          gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_argument (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_argument_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void vala_gir_parser_process_interface (ValaGirParser* self,
                                        ValaGirParserNode* iface_node);
static void vala_gir_parser_process_alias (ValaGirParser* self,
                                    ValaGirParserNode* alias);
static gchar* vala_gir_parser_node_get_full_name (ValaGirParserNode* self);
static void vala_gir_parser_process_callable (ValaGirParser* self,
                                       ValaGirParserNode* node);
static void vala_gir_parser_find_parent (ValaGirParser* self,
                                  const gchar* cname,
                                  ValaGirParserNode* current,
                                  ValaGirParserNode* * best,
                                  gint* match);
static gchar* vala_gir_parser_node_get_lower_case_cprefix (ValaGirParserNode* self);
static gboolean vala_gir_parser_same_gir (ValaGirParser* self,
                                   ValaSymbol* gir_component,
                                   ValaSymbol* sym);
static void vala_gir_parser_process_namespace_method (ValaGirParser* self,
                                               ValaGirParserNode* ns,
                                               ValaGirParserNode* node);
static void vala_gir_parser_node_remove_member (ValaGirParserNode* self,
                                         ValaGirParserNode* node);
static void vala_gir_parser_process_virtual_method_field (ValaGirParser* self,
                                                   ValaGirParserNode* node,
                                                   ValaDelegate* d,
                                                   ValaUnresolvedSymbol* gtype_struct_for);
static gchar* vala_gir_parser_node_to_string (ValaGirParserNode* self);
static ValaArrayList* vala_gir_parser_node_lookup_all (ValaGirParserNode* self,
                                                const gchar* name);
static void vala_gir_parser_process_async_method (ValaGirParser* self,
                                           ValaGirParserNode* node);
static gchar* vala_gir_parser_node_get_finish_cname (ValaGirParserNode* self);
static ValaGirParserNode* vala_gir_parser_base_interface_property (ValaGirParser* self,
                                                            ValaGirParserNode* prop_node);
static ValaGirParserArgument* vala_gir_parser_argument_new (ValaExpression* expression,
                                                     ValaSourceReference* source_reference);
static ValaGirParserArgument* vala_gir_parser_argument_construct (GType object_type,
                                                           ValaExpression* expression,
                                                           ValaSourceReference* source_reference);
static void vala_gir_parser_argument_finalize (ValaGirParserArgument * obj);
static GType vala_gir_parser_argument_get_type_once (void);
static GType vala_gir_parser_metadata_set_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGirParserMetadataSet* vala_gir_parser_metadata_set_new (const gchar* selector);
static ValaGirParserMetadataSet* vala_gir_parser_metadata_set_construct (GType object_type,
                                                                  const gchar* selector);
static ValaGirParserMetadata* vala_gir_parser_metadata_new (const gchar* pattern,
                                                     const gchar* selector,
                                                     ValaSourceReference* source_reference);
static ValaGirParserMetadata* vala_gir_parser_metadata_construct (GType object_type,
                                                           const gchar* pattern,
                                                           const gchar* selector,
                                                           ValaSourceReference* source_reference);
static void vala_gir_parser_metadata_set_add_sibling (ValaGirParserMetadataSet* self,
                                               ValaGirParserMetadata* metadata);
static void vala_gir_parser_metadata_add_child (ValaGirParserMetadata* self,
                                         ValaGirParserMetadata* metadata);
static GType vala_gir_parser_metadata_set_get_type_once (void);
static void vala_gir_parser_metadata_add_argument (ValaGirParserMetadata* self,
                                            ValaGirParserArgumentType key,
                                            ValaGirParserArgument* value);
static void vala_gir_parser_metadata_finalize (ValaGirParserMetadata * obj);
static GType vala_gir_parser_metadata_get_type_once (void);
static ValaSourceReference* vala_gir_parser_metadata_parser_get_current_src (ValaGirParserMetadataParser* self);
static ValaSourceReference* vala_gir_parser_metadata_parser_get_src (ValaGirParserMetadataParser* self,
                                                              ValaSourceLocation* begin,
                                                              ValaSourceLocation* end);
static ValaTokenType vala_gir_parser_metadata_parser_next (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_parse_rule (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_has_space (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_has_newline (ValaGirParserMetadataParser* self);
static gchar* vala_gir_parser_metadata_parser_get_string (ValaGirParserMetadataParser* self,
                                                   ValaSourceLocation* begin,
                                                   ValaSourceLocation* end);
static gchar* vala_gir_parser_metadata_parser_parse_identifier (ValaGirParserMetadataParser* self,
                                                         gboolean is_glob);
static gchar* vala_gir_parser_metadata_parser_parse_selector (ValaGirParserMetadataParser* self);
static ValaGirParserMetadata* vala_gir_parser_metadata_parser_parse_pattern (ValaGirParserMetadataParser* self);
static ValaExpression* vala_gir_parser_metadata_parser_parse_expression (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_parse_args (ValaGirParserMetadataParser* self,
                                                     ValaGirParserMetadata* metadata);
static void vala_gir_parser_metadata_parser_finalize (ValaGirParserMetadataParser * obj);
static GType vala_gir_parser_metadata_parser_get_type_once (void);
static gchar* vala_gir_parser_node_get_default_gir_name (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_default_lower_case_cprefix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_lower_case_csuffix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_default_lower_case_csuffix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_cprefix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_default_cname (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_cheader_filename (ValaGirParserNode* self);
static guint64 vala_gir_parser_node_parse_version_string (const gchar* version);
static void vala_gir_parser_node_finalize (ValaGirParserNode * obj);
static GType vala_gir_parser_node_get_type_once (void);
static void vala_gir_parser_parameter_info_finalize (ValaGirParserParameterInfo * obj);
static GType vala_gir_parser_parameter_info_get_type_once (void);
static void vala_gir_parser_finalize (ValaCodeVisitor * obj);
static GType vala_gir_parser_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
vala_gir_parser_get_instance_private (ValaGirParser* self)
{
	return G_STRUCT_MEMBER_P (self, ValaGirParser_private_offset);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static ValaGirParserArgumentType*
_vala_gir_parser_argument_type_dup (ValaGirParserArgumentType* self)
{
	ValaGirParserArgumentType* dup;
	dup = g_new0 (ValaGirParserArgumentType, 1);
	memcpy (dup, self, sizeof (ValaGirParserArgumentType));
	return dup;
}

static gpointer
__vala_gir_parser_argument_type_dup0 (gpointer self)
{
	return self ? _vala_gir_parser_argument_type_dup (self) : NULL;
}

static ValaGirParserArgumentType*
vala_gir_parser_argument_type_from_string (const gchar* name)
{
	GEnumClass* enum_class = NULL;
	GTypeClass* _tmp0_;
	gchar* nick = NULL;
	gchar* _tmp1_;
	GEnumValue* enum_value = NULL;
	GEnumClass* _tmp2_;
	const gchar* _tmp3_;
	GEnumValue* _tmp4_;
	ValaGirParserArgumentType* result = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_type_class_ref (VALA_GIR_PARSER_TYPE_ARGUMENT_TYPE);
	enum_class = (GEnumClass*) _tmp0_;
	_tmp1_ = string_replace (name, "_", "-");
	nick = _tmp1_;
	_tmp2_ = enum_class;
	_tmp3_ = nick;
	enum_value = g_enum_get_value_by_nick (_tmp2_, _tmp3_);
	_tmp4_ = enum_value;
	if (_tmp4_ != NULL) {
		ValaGirParserArgumentType value = 0;
		GEnumValue* _tmp5_;
		ValaGirParserArgumentType* _tmp6_;
		_tmp5_ = enum_value;
		value = (ValaGirParserArgumentType) (*_tmp5_).value;
		_tmp6_ = __vala_gir_parser_argument_type_dup0 (&value);
		result = _tmp6_;
		_g_free0 (nick);
		_g_type_class_unref0 (enum_class);
		return result;
	}
	result = NULL;
	_g_free0 (nick);
	_g_type_class_unref0 (enum_class);
	return result;
}

static GType
vala_gir_parser_argument_type_get_type_once (void)
{
	static const GEnumValue values[] = {{VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP, "VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP", "skip"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN, "VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN", "hidden"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE", "type"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS, "VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS", "type-arguments"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME", "cheader-filename"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_NAME", "name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED, "VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED", "owned"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED, "VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED", "unowned"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT, "VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT", "parent"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE, "VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE", "nullable"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED, "VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED", "deprecated"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT, "VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT", "replacement"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE", "deprecated-since"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE", "since"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY", "array"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX", "array-length-idx"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED", "array-null-terminated"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT, "VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT", "default"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_OUT, "VALA_GIR_PARSER_ARGUMENT_TYPE_OUT", "out"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_REF, "VALA_GIR_PARSER_ARGUMENT_TYPE_REF", "ref"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME", "vfunc-name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL, "VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL", "virtual"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, "VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT", "abstract"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SEALED, "VALA_GIR_PARSER_ARGUMENT_TYPE_SEALED", "sealed"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE", "scope"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT, "VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT", "struct"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS, "VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS", "throws"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT, "VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT", "printf-format"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD", "array-length-field"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL, "VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL", "sentinel"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE, "VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE", "closure"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY, "VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY", "destroy"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX, "VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX", "cprefix"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX, "VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX", "lower-case-cprefix"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX, "VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX", "lower-case-csuffix"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN, "VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN", "errordomain"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE", "destroys-instance"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE", "base-type"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME", "finish-name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE", "finish-instance"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE", "symbol-type"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX, "VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX", "instance-idx"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL, "VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL", "experimental"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING, "VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING", "floating"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID, "VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID", "type-id"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID, "VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID", "return-void"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER, "VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER", "returns-modified-pointer"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME", "delegate-target-cname"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME", "finish-vfunc-name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD, "VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD", "no-accessor-method"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME", "cname"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET, "VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET", "delegate-target"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE", "ctype"}, {0, NULL, NULL}};
	GType vala_gir_parser_argument_type_type_id;
	vala_gir_parser_argument_type_type_id = g_enum_register_static ("ValaGirParserArgumentType", values);
	return vala_gir_parser_argument_type_type_id;
}

static GType
vala_gir_parser_argument_type_get_type (void)
{
	static volatile gsize vala_gir_parser_argument_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_argument_type_type_id__volatile)) {
		GType vala_gir_parser_argument_type_type_id;
		vala_gir_parser_argument_type_type_id = vala_gir_parser_argument_type_get_type_once ();
		g_once_init_leave (&vala_gir_parser_argument_type_type_id__volatile, vala_gir_parser_argument_type_type_id);
	}
	return vala_gir_parser_argument_type_type_id__volatile;
}

static guint
_vala_gir_parser_unresolved_symbol_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = vala_gir_parser_unresolved_symbol_hash ((ValaUnresolvedSymbol*) key);
	return result;
}

static gboolean
_vala_gir_parser_unresolved_symbol_equal_gequal_func (gconstpointer a,
                                                      gconstpointer b)
{
	gboolean result;
	result = vala_gir_parser_unresolved_symbol_equal ((ValaUnresolvedSymbol*) a, (ValaUnresolvedSymbol*) b);
	return result;
}

/**
 * Parses all .gir source files in the specified code
 * context and builds a code tree.
 *
 * @param context a code context
 */
static gpointer
_vala_code_context_ref0 (gpointer self)
{
	return self ? vala_code_context_ref (self) : NULL;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_gir_parser_node_ref0 (gpointer self)
{
	return self ? vala_gir_parser_node_ref (self) : NULL;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

void
vala_gir_parser_parse (ValaGirParser* self,
                       ValaCodeContext* context)
{
	ValaCodeContext* _tmp0_;
	ValaGirParserNode* _tmp1_;
	ValaGirParserNode* _tmp2_;
	ValaNamespace* _tmp3_;
	ValaNamespace* _tmp4_;
	ValaSymbol* _tmp5_;
	GEqualFunc _tmp6_;
	ValaArrayList* _tmp7_;
	ValaGirParserNode* _tmp8_;
	ValaGirParserNode* _tmp9_;
	ValaGirParserNode* _tmp10_;
	ValaNamespace* glib_ns = NULL;
	ValaNamespace* _tmp11_;
	ValaNamespace* _tmp12_;
	ValaScope* _tmp13_;
	ValaScope* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaNamespace* _tmp16_;
	ValaNamespace* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = _vala_code_context_ref0 (context);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = vala_gir_parser_node_new (NULL);
	_vala_gir_parser_node_unref0 (self->priv->root);
	self->priv->root = _tmp1_;
	_tmp2_ = self->priv->root;
	_tmp3_ = vala_code_context_get_root (context);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp4_);
	_vala_code_node_unref0 (_tmp2_->symbol);
	_tmp2_->symbol = _tmp5_;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp6_);
	_vala_iterable_unref0 (self->priv->tree_stack);
	self->priv->tree_stack = _tmp7_;
	_tmp8_ = self->priv->root;
	_tmp9_ = _vala_gir_parser_node_ref0 (_tmp8_);
	_vala_gir_parser_node_unref0 (self->priv->current);
	self->priv->current = _tmp9_;
	vala_gir_parser_map_vala_to_gir (self);
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	vala_gir_parser_resolve_gir_symbols (self);
	vala_gir_parser_create_new_namespaces (self);
	vala_gir_parser_resolve_type_arguments (self);
	_tmp10_ = self->priv->root;
	vala_gir_parser_node_process (_tmp10_, self);
	_tmp11_ = vala_code_context_get_root (context);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_symbol_get_scope ((ValaSymbol*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_scope_lookup (_tmp14_, "GLib");
	_tmp16_ = VALA_IS_NAMESPACE (_tmp15_) ? ((ValaNamespace*) _tmp15_) : NULL;
	if (_tmp16_ == NULL) {
		_vala_code_node_unref0 (_tmp15_);
	}
	glib_ns = _tmp16_;
	_tmp17_ = glib_ns;
	if (_tmp17_ != NULL) {
		ValaClass* object_type = NULL;
		ValaNamespace* _tmp18_;
		ValaScope* _tmp19_;
		ValaScope* _tmp20_;
		ValaSymbol* _tmp21_;
		_tmp18_ = glib_ns;
		_tmp19_ = vala_symbol_get_scope ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_scope_lookup (_tmp20_, "Object");
		object_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_CLASS, ValaClass);
		{
			ValaArrayList* _iface_list = NULL;
			ValaArrayList* _tmp22_;
			ValaArrayList* _tmp23_;
			gint _iface_size = 0;
			ValaArrayList* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gint _iface_index = 0;
			_tmp22_ = self->priv->ifaces_needing_object_prereq;
			_tmp23_ = _vala_iterable_ref0 (_tmp22_);
			_iface_list = _tmp23_;
			_tmp24_ = _iface_list;
			_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
			_tmp26_ = _tmp25_;
			_iface_size = _tmp26_;
			_iface_index = -1;
			while (TRUE) {
				ValaInterface* iface = NULL;
				ValaArrayList* _tmp27_;
				gpointer _tmp28_;
				ValaInterface* _tmp29_;
				ValaClass* _tmp30_;
				ValaObjectType* _tmp31_;
				ValaObjectType* _tmp32_;
				_iface_index = _iface_index + 1;
				if (!(_iface_index < _iface_size)) {
					break;
				}
				_tmp27_ = _iface_list;
				_tmp28_ = vala_list_get ((ValaList*) _tmp27_, _iface_index);
				iface = (ValaInterface*) _tmp28_;
				_tmp29_ = iface;
				_tmp30_ = object_type;
				_tmp31_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp30_);
				_tmp32_ = _tmp31_;
				vala_interface_add_prerequisite (_tmp29_, (ValaDataType*) _tmp32_);
				_vala_code_node_unref0 (_tmp32_);
				_vala_code_node_unref0 (iface);
			}
			_vala_iterable_unref0 (_iface_list);
		}
		_vala_code_node_unref0 (object_type);
	}
	{
		ValaArrayList* _metadata_list = NULL;
		ValaArrayList* _tmp33_;
		ValaArrayList* _tmp34_;
		gint _metadata_size = 0;
		ValaArrayList* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gint _metadata_index = 0;
		_tmp33_ = self->priv->metadata_roots;
		_tmp34_ = _vala_iterable_ref0 (_tmp33_);
		_metadata_list = _tmp34_;
		_tmp35_ = _metadata_list;
		_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		_metadata_size = _tmp37_;
		_metadata_index = -1;
		while (TRUE) {
			ValaGirParserMetadata* metadata = NULL;
			ValaArrayList* _tmp38_;
			gpointer _tmp39_;
			ValaGirParserMetadata* _tmp40_;
			_metadata_index = _metadata_index + 1;
			if (!(_metadata_index < _metadata_size)) {
				break;
			}
			_tmp38_ = _metadata_list;
			_tmp39_ = vala_list_get ((ValaList*) _tmp38_, _metadata_index);
			metadata = (ValaGirParserMetadata*) _tmp39_;
			_tmp40_ = metadata;
			vala_gir_parser_report_unused_metadata (self, _tmp40_);
			_vala_gir_parser_metadata_unref0 (metadata);
		}
		_vala_iterable_unref0 (_metadata_list);
	}
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = NULL;
	_vala_code_node_unref0 (glib_ns);
}

static void
vala_gir_parser_map_vala_to_gir (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	{
		ValaList* _source_file_list = NULL;
		ValaCodeContext* _tmp0_;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _source_file_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _source_file_index = 0;
		_tmp0_ = self->priv->context;
		_tmp1_ = vala_code_context_get_source_files (_tmp0_);
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_source_file_list = _tmp2_;
		_tmp3_ = _source_file_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_source_file_size = _tmp5_;
		_source_file_index = -1;
		while (TRUE) {
			ValaSourceFile* source_file = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			gchar* gir_namespace = NULL;
			ValaSourceFile* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* gir_version = NULL;
			ValaSourceFile* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
			ValaNamespace* ns = NULL;
			const gchar* _tmp16_;
			const gchar* _tmp33_;
			ValaSet* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			ValaUnresolvedSymbol* gir_symbol = NULL;
			const gchar* _tmp39_;
			ValaUnresolvedSymbol* _tmp40_;
			const gchar* _tmp41_;
			ValaNamespace* _tmp42_;
			const gchar* _tmp43_;
			const gchar* _tmp44_;
			_source_file_index = _source_file_index + 1;
			if (!(_source_file_index < _source_file_size)) {
				break;
			}
			_tmp6_ = _source_file_list;
			_tmp7_ = vala_list_get (_tmp6_, _source_file_index);
			source_file = (ValaSourceFile*) _tmp7_;
			_tmp8_ = source_file;
			_tmp9_ = vala_source_file_get_gir_namespace (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strdup (_tmp10_);
			gir_namespace = _tmp11_;
			_tmp12_ = source_file;
			_tmp13_ = vala_source_file_get_gir_version (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strdup (_tmp14_);
			gir_version = _tmp15_;
			ns = NULL;
			_tmp16_ = gir_namespace;
			if (_tmp16_ == NULL) {
				{
					ValaList* _node_list = NULL;
					ValaSourceFile* _tmp17_;
					ValaList* _tmp18_;
					ValaList* _tmp19_;
					gint _node_size = 0;
					ValaList* _tmp20_;
					gint _tmp21_;
					gint _tmp22_;
					gint _node_index = 0;
					_tmp17_ = source_file;
					_tmp18_ = vala_source_file_get_nodes (_tmp17_);
					_tmp19_ = _vala_iterable_ref0 (_tmp18_);
					_node_list = _tmp19_;
					_tmp20_ = _node_list;
					_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
					_tmp22_ = _tmp21_;
					_node_size = _tmp22_;
					_node_index = -1;
					while (TRUE) {
						ValaCodeNode* node = NULL;
						ValaList* _tmp23_;
						gpointer _tmp24_;
						ValaCodeNode* _tmp25_;
						_node_index = _node_index + 1;
						if (!(_node_index < _node_size)) {
							break;
						}
						_tmp23_ = _node_list;
						_tmp24_ = vala_list_get (_tmp23_, _node_index);
						node = (ValaCodeNode*) _tmp24_;
						_tmp25_ = node;
						if (VALA_IS_NAMESPACE (_tmp25_)) {
							ValaCodeNode* _tmp26_;
							ValaNamespace* _tmp27_;
							ValaNamespace* _tmp28_;
							gchar* _tmp29_;
							const gchar* _tmp30_;
							_tmp26_ = node;
							_tmp27_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALA_TYPE_NAMESPACE, ValaNamespace));
							_vala_code_node_unref0 (ns);
							ns = _tmp27_;
							_tmp28_ = ns;
							_tmp29_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp28_, "CCode", "gir_namespace", NULL);
							_g_free0 (gir_namespace);
							gir_namespace = _tmp29_;
							_tmp30_ = gir_namespace;
							if (_tmp30_ != NULL) {
								ValaNamespace* _tmp31_;
								gchar* _tmp32_;
								_tmp31_ = ns;
								_tmp32_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp31_, "CCode", "gir_version", NULL);
								_g_free0 (gir_version);
								gir_version = _tmp32_;
								_vala_code_node_unref0 (node);
								break;
							}
						}
						_vala_code_node_unref0 (node);
					}
					_vala_iterable_unref0 (_node_list);
				}
			}
			_tmp33_ = gir_namespace;
			if (_tmp33_ == NULL) {
				_vala_code_node_unref0 (ns);
				_g_free0 (gir_version);
				_g_free0 (gir_namespace);
				_vala_source_file_unref0 (source_file);
				continue;
			}
			_tmp34_ = self->priv->provided_namespaces;
			_tmp35_ = gir_namespace;
			_tmp36_ = gir_version;
			_tmp37_ = g_strdup_printf ("%s-%s", _tmp35_, _tmp36_);
			_tmp38_ = _tmp37_;
			vala_collection_add ((ValaCollection*) _tmp34_, _tmp38_);
			_g_free0 (_tmp38_);
			_tmp39_ = gir_namespace;
			_tmp40_ = vala_unresolved_symbol_new (NULL, _tmp39_, NULL);
			gir_symbol = _tmp40_;
			_tmp41_ = gir_namespace;
			_tmp42_ = ns;
			_tmp43_ = vala_symbol_get_name ((ValaSymbol*) _tmp42_);
			_tmp44_ = _tmp43_;
			if (g_strcmp0 (_tmp41_, _tmp44_) != 0) {
				ValaUnresolvedSymbol* _tmp45_;
				ValaNamespace* _tmp46_;
				_tmp45_ = gir_symbol;
				_tmp46_ = ns;
				vala_gir_parser_set_symbol_mapping (self, _tmp45_, (ValaSymbol*) _tmp46_);
			}
			{
				ValaList* _node_list = NULL;
				ValaSourceFile* _tmp47_;
				ValaList* _tmp48_;
				ValaList* _tmp49_;
				gint _node_size = 0;
				ValaList* _tmp50_;
				gint _tmp51_;
				gint _tmp52_;
				gint _node_index = 0;
				_tmp47_ = source_file;
				_tmp48_ = vala_source_file_get_nodes (_tmp47_);
				_tmp49_ = _vala_iterable_ref0 (_tmp48_);
				_node_list = _tmp49_;
				_tmp50_ = _node_list;
				_tmp51_ = vala_collection_get_size ((ValaCollection*) _tmp50_);
				_tmp52_ = _tmp51_;
				_node_size = _tmp52_;
				_node_index = -1;
				while (TRUE) {
					ValaCodeNode* node = NULL;
					ValaList* _tmp53_;
					gpointer _tmp54_;
					ValaCodeNode* _tmp55_;
					_node_index = _node_index + 1;
					if (!(_node_index < _node_size)) {
						break;
					}
					_tmp53_ = _node_list;
					_tmp54_ = vala_list_get (_tmp53_, _node_index);
					node = (ValaCodeNode*) _tmp54_;
					_tmp55_ = node;
					if (vala_code_node_has_attribute_argument (_tmp55_, "GIR", "name")) {
						ValaUnresolvedSymbol* map_from = NULL;
						ValaUnresolvedSymbol* _tmp56_;
						ValaCodeNode* _tmp57_;
						gchar* _tmp58_;
						gchar* _tmp59_;
						ValaUnresolvedSymbol* _tmp60_;
						ValaUnresolvedSymbol* _tmp61_;
						ValaUnresolvedSymbol* _tmp62_;
						ValaCodeNode* _tmp63_;
						_tmp56_ = gir_symbol;
						_tmp57_ = node;
						_tmp58_ = vala_code_node_get_attribute_string (_tmp57_, "GIR", "name", NULL);
						_tmp59_ = _tmp58_;
						_tmp60_ = vala_unresolved_symbol_new (_tmp56_, _tmp59_, NULL);
						_tmp61_ = _tmp60_;
						_g_free0 (_tmp59_);
						map_from = _tmp61_;
						_tmp62_ = map_from;
						_tmp63_ = node;
						vala_gir_parser_set_symbol_mapping (self, _tmp62_, G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_SYMBOL, ValaSymbol));
						_vala_code_node_unref0 (map_from);
					}
					_vala_code_node_unref0 (node);
				}
				_vala_iterable_unref0 (_node_list);
			}
			_vala_code_node_unref0 (gir_symbol);
			_vala_code_node_unref0 (ns);
			_g_free0 (gir_version);
			_g_free0 (gir_namespace);
			_vala_source_file_unref0 (source_file);
		}
		_vala_iterable_unref0 (_source_file_list);
	}
}

static void
vala_gir_parser_real_visit_source_file (ValaCodeVisitor* base,
                                        ValaSourceFile* source_file)
{
	ValaGirParser * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (ValaGirParser*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0_ = vala_source_file_get_filename (source_file);
	_tmp1_ = _tmp0_;
	if (g_str_has_suffix (_tmp1_, ".gir")) {
		vala_gir_parser_parse_file (self, source_file);
	}
}

static gpointer
_vala_gir_parser_metadata_ref0 (gpointer self)
{
	return self ? vala_gir_parser_metadata_ref (self) : NULL;
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

void
vala_gir_parser_parse_file (ValaGirParser* self,
                            ValaSourceFile* source_file)
{
	gboolean has_global_context = FALSE;
	ValaCodeContext* _tmp0_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	ValaGirParserMetadata* _tmp6_;
	ValaGirParserMetadata* _tmp7_;
	ValaGirParserMetadata* _tmp8_;
	ValaSourceFile* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	ValaMarkupReader* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_file != NULL);
	_tmp0_ = self->priv->context;
	has_global_context = _tmp0_ != NULL;
	if (!has_global_context) {
		ValaCodeContext* _tmp1_;
		ValaCodeContext* _tmp2_;
		ValaCodeContext* _tmp3_;
		_tmp1_ = vala_source_file_get_context (source_file);
		_tmp2_ = _tmp1_;
		_tmp3_ = _vala_code_context_ref0 (_tmp2_);
		_vala_code_context_unref0 (self->priv->context);
		self->priv->context = _tmp3_;
	}
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_METADATA, (GBoxedCopyFunc) vala_gir_parser_metadata_ref, (GDestroyNotify) vala_gir_parser_metadata_unref, _tmp4_);
	_vala_iterable_unref0 (self->priv->metadata_stack);
	self->priv->metadata_stack = _tmp5_;
	_tmp6_ = vala_gir_parser_metadata_get_empty ();
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_gir_parser_metadata_ref0 (_tmp7_);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	self->priv->metadata = _tmp8_;
	self->priv->cheader_filenames = (_vala_array_free (self->priv->cheader_filenames, self->priv->cheader_filenames_length1, (GDestroyNotify) g_free), NULL);
	self->priv->cheader_filenames = NULL;
	self->priv->cheader_filenames_length1 = 0;
	self->priv->_cheader_filenames_size_ = self->priv->cheader_filenames_length1;
	_tmp9_ = _vala_source_file_ref0 (source_file);
	_vala_source_file_unref0 (self->priv->current_source_file);
	self->priv->current_source_file = _tmp9_;
	_tmp10_ = vala_source_file_get_filename (source_file);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_markup_reader_new (_tmp11_);
	_vala_markup_reader_unref0 (self->priv->reader);
	self->priv->reader = _tmp12_;
	vala_gir_parser_next (self);
	vala_gir_parser_next (self);
	vala_gir_parser_next (self);
	vala_gir_parser_parse_repository (self);
	_vala_markup_reader_unref0 (self->priv->reader);
	self->priv->reader = NULL;
	_vala_source_file_unref0 (self->priv->current_source_file);
	self->priv->current_source_file = NULL;
	if (!has_global_context) {
		_vala_code_context_unref0 (self->priv->context);
		self->priv->context = NULL;
	}
}

static void
vala_gir_parser_next (ValaGirParser* self)
{
	ValaMarkupReader* _tmp0_;
	ValaSourceLocation _tmp1_ = {0};
	ValaSourceLocation _tmp2_ = {0};
	ValaMarkupTokenType _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_read_token (_tmp0_, &_tmp1_, &_tmp2_);
	self->priv->begin = _tmp1_;
	self->priv->end = _tmp2_;
	self->priv->current_token = _tmp3_;
}

static void
vala_gir_parser_start_element (ValaGirParser* self,
                               const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	ValaMarkupTokenType _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = self->priv->current_token;
	if (_tmp1_ != VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		_tmp0_ = TRUE;
	} else {
		ValaMarkupReader* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->priv->reader;
		_tmp3_ = vala_markup_reader_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, name) != 0;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = vala_gir_parser_get_current_src (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf ("expected start element of `%s'", name);
		_tmp8_ = _tmp7_;
		vala_report_error (_tmp6_, _tmp8_);
		_g_free0 (_tmp8_);
		_vala_source_reference_unref0 (_tmp6_);
	}
}

static void
vala_gir_parser_end_element (ValaGirParser* self,
                             const gchar* name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		ValaMarkupTokenType _tmp1_;
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp1_ = self->priv->current_token;
		if (_tmp1_ != VALA_MARKUP_TOKEN_TYPE_END_ELEMENT) {
			_tmp0_ = TRUE;
		} else {
			ValaMarkupReader* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = self->priv->reader;
			_tmp3_ = vala_markup_reader_get_name (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp0_ = g_strcmp0 (_tmp4_, name) != 0;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = vala_gir_parser_get_current_src (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf ("expected end element of `%s'", name);
		_tmp8_ = _tmp7_;
		vala_report_warning (_tmp6_, _tmp8_);
		_g_free0 (_tmp8_);
		_vala_source_reference_unref0 (_tmp6_);
		vala_gir_parser_skip_element (self);
	}
	vala_gir_parser_next (self);
}

static ValaSourceReference*
vala_gir_parser_get_current_src (ValaGirParser* self)
{
	ValaSourceFile* _tmp0_;
	ValaSourceLocation _tmp1_;
	ValaSourceLocation _tmp2_;
	ValaSourceReference* _tmp3_;
	ValaSourceReference* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current_source_file;
	_tmp1_ = self->priv->begin;
	_tmp2_ = self->priv->end;
	_tmp3_ = vala_source_reference_new (_tmp0_, &_tmp1_, &_tmp2_);
	result = _tmp3_;
	return result;
}

static ValaSourceReference*
vala_gir_parser_get_src (ValaGirParser* self,
                         ValaSourceLocation* begin,
                         ValaSourceLocation* end)
{
	ValaSourceLocation e = {0};
	ValaSourceLocation _tmp0_;
	ValaSourceFile* _tmp1_;
	ValaSourceLocation _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceReference* _tmp4_;
	ValaSourceReference* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	_tmp0_ = self->priv->end;
	e = _tmp0_;
	if (end != NULL) {
		e = *end;
	}
	_tmp1_ = self->priv->current_source_file;
	_tmp2_ = *begin;
	_tmp3_ = e;
	_tmp4_ = vala_source_reference_new (_tmp1_, &_tmp2_, &_tmp3_);
	result = _tmp4_;
	return result;
}

static void
vala_gir_parser_add_symbol_to_container (ValaSymbol* container,
                                         ValaSymbol* sym)
{
	g_return_if_fail (container != NULL);
	g_return_if_fail (sym != NULL);
	if (VALA_IS_CLASS (container)) {
		ValaClass* cl = NULL;
		cl = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_CLASS, ValaClass);
		if (VALA_IS_CLASS (sym)) {
			ValaClass* _tmp0_;
			_tmp0_ = cl;
			vala_symbol_add_class ((ValaSymbol*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
		} else {
			if (VALA_IS_CONSTANT (sym)) {
				ValaClass* _tmp1_;
				_tmp1_ = cl;
				vala_symbol_add_constant ((ValaSymbol*) _tmp1_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
			} else {
				if (VALA_IS_ENUM (sym)) {
					ValaClass* _tmp2_;
					_tmp2_ = cl;
					vala_symbol_add_enum ((ValaSymbol*) _tmp2_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
				} else {
					if (VALA_IS_FIELD (sym)) {
						ValaClass* _tmp3_;
						_tmp3_ = cl;
						vala_symbol_add_field ((ValaSymbol*) _tmp3_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
					} else {
						if (VALA_IS_METHOD (sym)) {
							ValaClass* _tmp4_;
							_tmp4_ = cl;
							vala_symbol_add_method ((ValaSymbol*) _tmp4_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
						} else {
							if (VALA_IS_PROPERTY (sym)) {
								ValaClass* _tmp5_;
								_tmp5_ = cl;
								vala_symbol_add_property ((ValaSymbol*) _tmp5_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
							} else {
								if (VALA_IS_SIGNAL (sym)) {
									ValaClass* _tmp6_;
									_tmp6_ = cl;
									vala_symbol_add_signal ((ValaSymbol*) _tmp6_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_SIGNAL, ValaSignal));
								} else {
									if (VALA_IS_STRUCT (sym)) {
										ValaClass* _tmp7_;
										_tmp7_ = cl;
										vala_symbol_add_struct ((ValaSymbol*) _tmp7_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
									}
								}
							}
						}
					}
				}
			}
		}
	} else {
		if (VALA_IS_ENUM (container)) {
			ValaEnum* en = NULL;
			en = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_ENUM, ValaEnum);
			if (VALA_IS_ENUM_VALUE (sym)) {
				ValaEnum* _tmp8_;
				_tmp8_ = en;
				vala_enum_add_value (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM_VALUE, ValaEnumValue));
			} else {
				if (VALA_IS_CONSTANT (sym)) {
					ValaEnum* _tmp9_;
					_tmp9_ = en;
					vala_symbol_add_constant ((ValaSymbol*) _tmp9_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
				} else {
					if (VALA_IS_METHOD (sym)) {
						ValaEnum* _tmp10_;
						_tmp10_ = en;
						vala_symbol_add_method ((ValaSymbol*) _tmp10_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
					}
				}
			}
		} else {
			if (VALA_IS_INTERFACE (container)) {
				ValaInterface* iface = NULL;
				iface = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_INTERFACE, ValaInterface);
				if (VALA_IS_CLASS (sym)) {
					ValaInterface* _tmp11_;
					_tmp11_ = iface;
					vala_symbol_add_class ((ValaSymbol*) _tmp11_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
				} else {
					if (VALA_IS_CONSTANT (sym)) {
						ValaInterface* _tmp12_;
						_tmp12_ = iface;
						vala_symbol_add_constant ((ValaSymbol*) _tmp12_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
					} else {
						if (VALA_IS_ENUM (sym)) {
							ValaInterface* _tmp13_;
							_tmp13_ = iface;
							vala_symbol_add_enum ((ValaSymbol*) _tmp13_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
						} else {
							if (VALA_IS_FIELD (sym)) {
								ValaInterface* _tmp14_;
								_tmp14_ = iface;
								vala_symbol_add_field ((ValaSymbol*) _tmp14_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
							} else {
								if (VALA_IS_METHOD (sym)) {
									ValaInterface* _tmp15_;
									_tmp15_ = iface;
									vala_symbol_add_method ((ValaSymbol*) _tmp15_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								} else {
									if (VALA_IS_PROPERTY (sym)) {
										ValaInterface* _tmp16_;
										_tmp16_ = iface;
										vala_symbol_add_property ((ValaSymbol*) _tmp16_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
									} else {
										if (VALA_IS_SIGNAL (sym)) {
											ValaInterface* _tmp17_;
											_tmp17_ = iface;
											vala_symbol_add_signal ((ValaSymbol*) _tmp17_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_SIGNAL, ValaSignal));
										} else {
											if (VALA_IS_STRUCT (sym)) {
												ValaInterface* _tmp18_;
												_tmp18_ = iface;
												vala_symbol_add_struct ((ValaSymbol*) _tmp18_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
											}
										}
									}
								}
							}
						}
					}
				}
			} else {
				if (VALA_IS_NAMESPACE (container)) {
					ValaNamespace* ns = NULL;
					ns = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_NAMESPACE, ValaNamespace);
					if (VALA_IS_NAMESPACE (sym)) {
						ValaNamespace* _tmp19_;
						_tmp19_ = ns;
						vala_symbol_add_namespace ((ValaSymbol*) _tmp19_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_NAMESPACE, ValaNamespace));
					} else {
						if (VALA_IS_CLASS (sym)) {
							ValaNamespace* _tmp20_;
							_tmp20_ = ns;
							vala_symbol_add_class ((ValaSymbol*) _tmp20_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
						} else {
							if (VALA_IS_CONSTANT (sym)) {
								ValaNamespace* _tmp21_;
								_tmp21_ = ns;
								vala_symbol_add_constant ((ValaSymbol*) _tmp21_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
							} else {
								if (VALA_IS_DELEGATE (sym)) {
									ValaNamespace* _tmp22_;
									_tmp22_ = ns;
									vala_symbol_add_delegate ((ValaSymbol*) _tmp22_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_DELEGATE, ValaDelegate));
								} else {
									if (VALA_IS_ENUM (sym)) {
										ValaNamespace* _tmp23_;
										_tmp23_ = ns;
										vala_symbol_add_enum ((ValaSymbol*) _tmp23_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
									} else {
										if (VALA_IS_ERROR_DOMAIN (sym)) {
											ValaNamespace* _tmp24_;
											_tmp24_ = ns;
											vala_symbol_add_error_domain ((ValaSymbol*) _tmp24_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain));
										} else {
											if (VALA_IS_FIELD (sym)) {
												ValaField* field = NULL;
												ValaField* _tmp25_;
												ValaMemberBinding _tmp26_;
												ValaMemberBinding _tmp27_;
												ValaNamespace* _tmp29_;
												ValaField* _tmp30_;
												field = G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField);
												_tmp25_ = field;
												_tmp26_ = vala_field_get_binding (_tmp25_);
												_tmp27_ = _tmp26_;
												if (_tmp27_ == VALA_MEMBER_BINDING_INSTANCE) {
													ValaField* _tmp28_;
													_tmp28_ = field;
													vala_field_set_binding (_tmp28_, VALA_MEMBER_BINDING_STATIC);
												}
												_tmp29_ = ns;
												_tmp30_ = field;
												vala_symbol_add_field ((ValaSymbol*) _tmp29_, _tmp30_);
											} else {
												if (VALA_IS_INTERFACE (sym)) {
													ValaNamespace* _tmp31_;
													_tmp31_ = ns;
													vala_symbol_add_interface ((ValaSymbol*) _tmp31_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_INTERFACE, ValaInterface));
												} else {
													if (VALA_IS_METHOD (sym)) {
														ValaMethod* method = NULL;
														ValaMethod* _tmp32_;
														ValaMemberBinding _tmp33_;
														ValaMemberBinding _tmp34_;
														ValaNamespace* _tmp36_;
														ValaMethod* _tmp37_;
														method = G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod);
														_tmp32_ = method;
														_tmp33_ = vala_method_get_binding (_tmp32_);
														_tmp34_ = _tmp33_;
														if (_tmp34_ == VALA_MEMBER_BINDING_INSTANCE) {
															ValaMethod* _tmp35_;
															_tmp35_ = method;
															vala_method_set_binding (_tmp35_, VALA_MEMBER_BINDING_STATIC);
														}
														_tmp36_ = ns;
														_tmp37_ = method;
														vala_symbol_add_method ((ValaSymbol*) _tmp36_, _tmp37_);
													} else {
														if (VALA_IS_STRUCT (sym)) {
															ValaNamespace* _tmp38_;
															_tmp38_ = ns;
															vala_symbol_add_struct ((ValaSymbol*) _tmp38_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				} else {
					if (VALA_IS_STRUCT (container)) {
						ValaStruct* st = NULL;
						st = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_STRUCT, ValaStruct);
						if (VALA_IS_CONSTANT (sym)) {
							ValaStruct* _tmp39_;
							_tmp39_ = st;
							vala_symbol_add_constant ((ValaSymbol*) _tmp39_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
						} else {
							if (VALA_IS_FIELD (sym)) {
								ValaStruct* _tmp40_;
								_tmp40_ = st;
								vala_symbol_add_field ((ValaSymbol*) _tmp40_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
							} else {
								if (VALA_IS_METHOD (sym)) {
									ValaStruct* _tmp41_;
									_tmp41_ = st;
									vala_symbol_add_method ((ValaSymbol*) _tmp41_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								} else {
									if (VALA_IS_PROPERTY (sym)) {
										ValaStruct* _tmp42_;
										_tmp42_ = st;
										vala_symbol_add_property ((ValaSymbol*) _tmp42_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
									}
								}
							}
						}
					} else {
						if (VALA_IS_ERROR_DOMAIN (container)) {
							ValaErrorDomain* ed = NULL;
							ed = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain);
							if (VALA_IS_ERROR_CODE (sym)) {
								ValaErrorDomain* _tmp43_;
								_tmp43_ = ed;
								vala_error_domain_add_code (_tmp43_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ERROR_CODE, ValaErrorCode));
							} else {
								if (VALA_IS_METHOD (sym)) {
									ValaErrorDomain* _tmp44_;
									_tmp44_ = ed;
									vala_symbol_add_method ((ValaSymbol*) _tmp44_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								}
							}
						} else {
							ValaSourceReference* _tmp45_;
							ValaSourceReference* _tmp46_;
							const gchar* _tmp47_;
							const gchar* _tmp48_;
							const gchar* _tmp49_;
							const gchar* _tmp50_;
							gchar* _tmp51_;
							gchar* _tmp52_;
							_tmp45_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
							_tmp46_ = _tmp45_;
							_tmp47_ = vala_symbol_get_name (sym);
							_tmp48_ = _tmp47_;
							_tmp49_ = vala_symbol_get_name (container);
							_tmp50_ = _tmp49_;
							_tmp51_ = g_strdup_printf ("impossible to add `%s' to container `%s'", _tmp48_, _tmp50_);
							_tmp52_ = _tmp51_;
							vala_report_error (_tmp46_, _tmp52_);
							_g_free0 (_tmp52_);
						}
					}
				}
			}
		}
	}
}

static gboolean
vala_gir_parser_is_container (ValaSymbol* sym)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (sym != NULL, FALSE);
	if (VALA_IS_OBJECT_TYPE_SYMBOL (sym)) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = VALA_IS_STRUCT (sym);
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = VALA_IS_NAMESPACE (sym);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = VALA_IS_ERROR_DOMAIN (sym);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_ENUM (sym);
	}
	result = _tmp0_;
	return result;
}

static ValaUnresolvedSymbol*
vala_gir_parser_parse_symbol_from_string (ValaGirParser* self,
                                          const gchar* symbol_string,
                                          ValaSourceReference* source_reference)
{
	ValaUnresolvedSymbol* sym = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	ValaUnresolvedSymbol* _tmp5_;
	ValaUnresolvedSymbol* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol_string != NULL, NULL);
	sym = NULL;
	_tmp1_ = _tmp0_ = g_strsplit (symbol_string, ".", 0);
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp1_;
		s_collection_length1 = _vala_array_length (_tmp0_);
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			const gchar* s = NULL;
			s = s_collection[s_it];
			{
				ValaUnresolvedSymbol* _tmp2_;
				const gchar* _tmp3_;
				ValaUnresolvedSymbol* _tmp4_;
				_tmp2_ = sym;
				_tmp3_ = s;
				_tmp4_ = vala_unresolved_symbol_new (_tmp2_, _tmp3_, source_reference);
				_vala_code_node_unref0 (sym);
				sym = _tmp4_;
			}
		}
		s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp5_ = sym;
	if (_tmp5_ == NULL) {
		vala_report_error (source_reference, "a symbol must be specified");
	}
	result = sym;
	return result;
}

static void
vala_gir_parser_set_symbol_mapping (ValaGirParser* self,
                                    ValaUnresolvedSymbol* map_from,
                                    ValaSymbol* map_to)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (map_from != NULL);
	g_return_if_fail (map_to != NULL);
	if (VALA_IS_UNRESOLVED_SYMBOL (map_from)) {
		ValaHashMap* _tmp0_;
		_tmp0_ = self->priv->unresolved_symbols_map;
		vala_map_set ((ValaMap*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (map_from, VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbol), map_to);
	}
}

static void
vala_gir_parser_assume_parameter_names (ValaGirParser* self,
                                        ValaSignal* sig,
                                        ValaSymbol* sym,
                                        gboolean skip_first)
{
	ValaIterator* iter = NULL;
	ValaList* _tmp0_;
	ValaIterator* _tmp1_;
	gboolean first = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	g_return_if_fail (sym != NULL);
	_tmp0_ = vala_callable_get_parameters (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CALLABLE, ValaCallable));
	_tmp1_ = vala_iterable_iterator ((ValaIterable*) _tmp0_);
	iter = _tmp1_;
	first = TRUE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _param_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _param_index = 0;
		_tmp2_ = vala_callable_get_parameters ((ValaCallable*) sig);
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_param_list = _tmp3_;
		_tmp4_ = _param_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_param_size = _tmp6_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gpointer _tmp8_;
			ValaIterator* _tmp9_;
			gboolean _tmp10_ = FALSE;
			ValaParameter* _tmp12_;
			ValaIterator* _tmp13_;
			gpointer _tmp14_;
			ValaParameter* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = vala_list_get (_tmp7_, _param_index);
			param = (ValaParameter*) _tmp8_;
			_tmp9_ = iter;
			if (!vala_iterator_next (_tmp9_)) {
				_vala_code_node_unref0 (param);
				break;
			}
			if (skip_first) {
				_tmp10_ = first;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				ValaIterator* _tmp11_;
				_tmp11_ = iter;
				if (!vala_iterator_next (_tmp11_)) {
					_vala_code_node_unref0 (param);
					break;
				}
				first = FALSE;
			}
			_tmp12_ = param;
			_tmp13_ = iter;
			_tmp14_ = vala_iterator_get (_tmp13_);
			_tmp15_ = (ValaParameter*) _tmp14_;
			_tmp16_ = vala_symbol_get_name ((ValaSymbol*) _tmp15_);
			_tmp17_ = _tmp16_;
			vala_symbol_set_name ((ValaSymbol*) _tmp12_, _tmp17_);
			_vala_code_node_unref0 (_tmp15_);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_vala_iterator_unref0 (iter);
}

static ValaGirParserNode*
vala_gir_parser_find_invoker (ValaGirParser* self,
                              ValaGirParserNode* node)
{
	ValaMethod* m = NULL;
	ValaSymbol* _tmp0_;
	ValaMethod* _tmp1_;
	gchar* prefix = NULL;
	ValaMethod* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	ValaGirParserNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node->symbol;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALA_TYPE_METHOD, ValaMethod));
	m = _tmp1_;
	_tmp2_ = m;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s_", _tmp4_);
	prefix = _tmp5_;
	{
		ValaArrayList* _n_list = NULL;
		ValaGirParserNode* _tmp6_;
		ValaArrayList* _tmp7_;
		ValaArrayList* _tmp8_;
		gint _n_size = 0;
		ValaArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _n_index = 0;
		_tmp6_ = node->parent;
		_tmp7_ = _tmp6_->members;
		_tmp8_ = _vala_iterable_ref0 (_tmp7_);
		_n_list = _tmp8_;
		_tmp9_ = _n_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_n_size = _tmp11_;
		_n_index = -1;
		while (TRUE) {
			ValaGirParserNode* n = NULL;
			ValaArrayList* _tmp12_;
			gpointer _tmp13_;
			ValaGirParserNode* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			ValaMethod* invoker = NULL;
			ValaGirParserNode* _tmp17_;
			ValaSymbol* _tmp18_;
			ValaMethod* _tmp19_;
			gboolean _tmp20_ = FALSE;
			ValaMethod* _tmp21_;
			ValaIterator* iter = NULL;
			ValaMethod* _tmp30_;
			ValaList* _tmp31_;
			ValaIterator* _tmp32_;
			ValaMethod* _tmp51_;
			_n_index = _n_index + 1;
			if (!(_n_index < _n_size)) {
				break;
			}
			_tmp12_ = _n_list;
			_tmp13_ = vala_list_get ((ValaList*) _tmp12_, _n_index);
			n = (ValaGirParserNode*) _tmp13_;
			_tmp14_ = n;
			_tmp15_ = _tmp14_->name;
			_tmp16_ = prefix;
			if (!g_str_has_prefix (_tmp15_, _tmp16_)) {
				_vala_gir_parser_node_unref0 (n);
				continue;
			}
			_tmp17_ = n;
			_tmp18_ = _tmp17_->symbol;
			_tmp19_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp18_) ? ((ValaMethod*) _tmp18_) : NULL);
			invoker = _tmp19_;
			_tmp21_ = invoker;
			if (_tmp21_ == NULL) {
				_tmp20_ = TRUE;
			} else {
				ValaMethod* _tmp22_;
				ValaList* _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				ValaMethod* _tmp26_;
				ValaList* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				_tmp22_ = m;
				_tmp23_ = vala_callable_get_parameters ((ValaCallable*) _tmp22_);
				_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = invoker;
				_tmp27_ = vala_callable_get_parameters ((ValaCallable*) _tmp26_);
				_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
				_tmp29_ = _tmp28_;
				_tmp20_ = _tmp25_ != _tmp29_;
			}
			if (_tmp20_) {
				_vala_code_node_unref0 (invoker);
				_vala_gir_parser_node_unref0 (n);
				continue;
			}
			_tmp30_ = invoker;
			_tmp31_ = vala_callable_get_parameters ((ValaCallable*) _tmp30_);
			_tmp32_ = vala_iterable_iterator ((ValaIterable*) _tmp31_);
			iter = _tmp32_;
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp33_;
				ValaList* _tmp34_;
				ValaList* _tmp35_;
				gint _param_size = 0;
				ValaList* _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				gint _param_index = 0;
				_tmp33_ = m;
				_tmp34_ = vala_callable_get_parameters ((ValaCallable*) _tmp33_);
				_tmp35_ = _vala_iterable_ref0 (_tmp34_);
				_param_list = _tmp35_;
				_tmp36_ = _param_list;
				_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
				_tmp38_ = _tmp37_;
				_param_size = _tmp38_;
				_param_index = -1;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp39_;
					gpointer _tmp40_;
					ValaIterator* _tmp41_;
					ValaParameter* _tmp42_;
					const gchar* _tmp43_;
					const gchar* _tmp44_;
					ValaIterator* _tmp45_;
					gpointer _tmp46_;
					ValaParameter* _tmp47_;
					const gchar* _tmp48_;
					const gchar* _tmp49_;
					gboolean _tmp50_;
					_param_index = _param_index + 1;
					if (!(_param_index < _param_size)) {
						break;
					}
					_tmp39_ = _param_list;
					_tmp40_ = vala_list_get (_tmp39_, _param_index);
					param = (ValaParameter*) _tmp40_;
					_tmp41_ = iter;
					_vala_assert (vala_iterator_next (_tmp41_), "iter.next ()");
					_tmp42_ = param;
					_tmp43_ = vala_symbol_get_name ((ValaSymbol*) _tmp42_);
					_tmp44_ = _tmp43_;
					_tmp45_ = iter;
					_tmp46_ = vala_iterator_get (_tmp45_);
					_tmp47_ = (ValaParameter*) _tmp46_;
					_tmp48_ = vala_symbol_get_name ((ValaSymbol*) _tmp47_);
					_tmp49_ = _tmp48_;
					_tmp50_ = g_strcmp0 (_tmp44_, _tmp49_) != 0;
					_vala_code_node_unref0 (_tmp47_);
					if (_tmp50_) {
						_vala_code_node_unref0 (invoker);
						invoker = NULL;
						_vala_code_node_unref0 (param);
						break;
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp51_ = invoker;
			if (_tmp51_ != NULL) {
				result = n;
				_vala_iterator_unref0 (iter);
				_vala_code_node_unref0 (invoker);
				_vala_iterable_unref0 (_n_list);
				_g_free0 (prefix);
				_vala_code_node_unref0 (m);
				return result;
			}
			_vala_iterator_unref0 (iter);
			_vala_code_node_unref0 (invoker);
			_vala_gir_parser_node_unref0 (n);
		}
		_vala_iterable_unref0 (_n_list);
	}
	result = NULL;
	_g_free0 (prefix);
	_vala_code_node_unref0 (m);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static ValaGirParserMetadata*
vala_gir_parser_get_current_metadata (ValaGirParser* self)
{
	gchar* selector = NULL;
	ValaMarkupReader* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* child_name = NULL;
	ValaMarkupReader* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	const gchar* _tmp13_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	ValaGirParserMetadata* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	ValaGirParserMetadata* _tmp29_;
	ValaGirParserMetadata* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	selector = _tmp3_;
	_tmp4_ = self->priv->reader;
	_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "name");
	child_name = _tmp5_;
	_tmp6_ = child_name;
	if (_tmp6_ == NULL) {
		ValaMarkupReader* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = self->priv->reader;
		_tmp8_ = vala_markup_reader_get_attribute (_tmp7_, "glib:name");
		_g_free0 (child_name);
		child_name = _tmp8_;
	}
	_tmp10_ = selector;
	if (g_strcmp0 (_tmp10_, "union") == 0) {
		const gchar* _tmp11_;
		_tmp11_ = child_name;
		_tmp9_ = _tmp11_ == NULL;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gchar* _tmp12_;
		_tmp12_ = g_strdup ("union");
		_g_free0 (child_name);
		child_name = _tmp12_;
	}
	_tmp13_ = child_name;
	if (_tmp13_ == NULL) {
		ValaGirParserMetadata* _tmp14_;
		ValaGirParserMetadata* _tmp15_;
		ValaGirParserMetadata* _tmp16_;
		_tmp14_ = vala_gir_parser_metadata_get_empty ();
		_tmp15_ = _tmp14_;
		_tmp16_ = _vala_gir_parser_metadata_ref0 (_tmp15_);
		result = _tmp16_;
		_g_free0 (child_name);
		_g_free0 (selector);
		return result;
	}
	_tmp17_ = selector;
	_tmp18_ = string_replace (_tmp17_, "-", "_");
	_g_free0 (selector);
	selector = _tmp18_;
	_tmp19_ = child_name;
	_tmp20_ = string_replace (_tmp19_, "-", "_");
	_g_free0 (child_name);
	child_name = _tmp20_;
	_tmp21_ = selector;
	if (g_str_has_prefix (_tmp21_, "glib:")) {
		const gchar* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gchar* _tmp25_;
		_tmp22_ = selector;
		_tmp23_ = strlen ("glib:");
		_tmp24_ = _tmp23_;
		_tmp25_ = string_substring (_tmp22_, (glong) _tmp24_, (glong) -1);
		_g_free0 (selector);
		selector = _tmp25_;
	}
	_tmp26_ = self->priv->metadata;
	_tmp27_ = child_name;
	_tmp28_ = selector;
	_tmp29_ = vala_gir_parser_metadata_match_child (_tmp26_, _tmp27_, _tmp28_);
	result = _tmp29_;
	_g_free0 (child_name);
	_g_free0 (selector);
	return result;
}

static gboolean
vala_gir_parser_push_metadata (ValaGirParser* self)
{
	ValaGirParserMetadata* new_metadata = NULL;
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaArrayList* _tmp11_;
	ValaGirParserMetadata* _tmp12_;
	ValaGirParserMetadata* _tmp13_;
	ValaGirParserMetadata* _tmp14_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_gir_parser_get_current_metadata (self);
	new_metadata = _tmp0_;
	_tmp1_ = new_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp1_, VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP)) {
		ValaGirParserMetadata* _tmp2_;
		_tmp2_ = new_metadata;
		if (vala_gir_parser_metadata_get_bool (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP, FALSE)) {
			result = FALSE;
			_vala_gir_parser_metadata_unref0 (new_metadata);
			return result;
		}
	} else {
		gboolean _tmp3_ = FALSE;
		ValaMarkupReader* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = self->priv->reader;
		_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "introspectable");
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strcmp0 (_tmp6_, "0") == 0;
		_g_free0 (_tmp6_);
		if (_tmp7_) {
			_tmp3_ = TRUE;
		} else {
			ValaMarkupReader* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp8_ = self->priv->reader;
			_tmp9_ = vala_markup_reader_get_attribute (_tmp8_, "private");
			_tmp10_ = _tmp9_;
			_tmp3_ = g_strcmp0 (_tmp10_, "1") == 0;
			_g_free0 (_tmp10_);
		}
		if (_tmp3_) {
			result = FALSE;
			_vala_gir_parser_metadata_unref0 (new_metadata);
			return result;
		}
	}
	_tmp11_ = self->priv->metadata_stack;
	_tmp12_ = self->priv->metadata;
	vala_collection_add ((ValaCollection*) _tmp11_, _tmp12_);
	_tmp13_ = new_metadata;
	_tmp14_ = _vala_gir_parser_metadata_ref0 (_tmp13_);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	self->priv->metadata = _tmp14_;
	result = TRUE;
	_vala_gir_parser_metadata_unref0 (new_metadata);
	return result;
}

static void
vala_gir_parser_pop_metadata (ValaGirParser* self)
{
	ValaArrayList* _tmp0_;
	ValaArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gpointer _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->metadata_stack;
	_tmp1_ = self->priv->metadata_stack;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_list_remove_at ((ValaList*) _tmp0_, _tmp3_ - 1);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	self->priv->metadata = (ValaGirParserMetadata*) _tmp4_;
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
vala_gir_parser_parse_type_arguments_from_string (ValaGirParser* self,
                                                  ValaDataType* parent_type,
                                                  const gchar* type_arguments,
                                                  ValaSourceReference* source_reference)
{
	gint type_arguments_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	GString* current = NULL;
	GString* _tmp2_;
	gint depth = 0;
	ValaDataType* dt = NULL;
	GString* _tmp19_;
	const gchar* _tmp20_;
	ValaDataType* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (parent_type != NULL, FALSE);
	g_return_val_if_fail (type_arguments != NULL, FALSE);
	_tmp0_ = strlen (type_arguments);
	_tmp1_ = _tmp0_;
	type_arguments_length = (gint) _tmp1_;
	_tmp2_ = g_string_sized_new ((gsize) type_arguments_length);
	current = _tmp2_;
	depth = 0;
	{
		gint c = 0;
		c = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_ = FALSE;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = c;
					c = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(c < type_arguments_length)) {
					break;
				}
				if (string_get (type_arguments, (glong) c) == '<') {
					_tmp5_ = TRUE;
				} else {
					_tmp5_ = string_get (type_arguments, (glong) c) == '[';
				}
				if (_tmp5_) {
					gint _tmp6_;
					GString* _tmp7_;
					_tmp6_ = depth;
					depth = _tmp6_ + 1;
					_tmp7_ = current;
					g_string_append_unichar (_tmp7_, (gunichar) string_get (type_arguments, (glong) c));
				} else {
					gboolean _tmp8_ = FALSE;
					if (string_get (type_arguments, (glong) c) == '>') {
						_tmp8_ = TRUE;
					} else {
						_tmp8_ = string_get (type_arguments, (glong) c) == ']';
					}
					if (_tmp8_) {
						gint _tmp9_;
						GString* _tmp10_;
						_tmp9_ = depth;
						depth = _tmp9_ - 1;
						_tmp10_ = current;
						g_string_append_unichar (_tmp10_, (gunichar) string_get (type_arguments, (glong) c));
					} else {
						if (string_get (type_arguments, (glong) c) == ',') {
							if (depth == 0) {
								ValaDataType* dt = NULL;
								GString* _tmp11_;
								const gchar* _tmp12_;
								ValaDataType* _tmp13_;
								ValaDataType* _tmp14_;
								ValaDataType* _tmp15_;
								GString* _tmp16_;
								_tmp11_ = current;
								_tmp12_ = _tmp11_->str;
								_tmp13_ = vala_gir_parser_parse_type_from_string (self, _tmp12_, TRUE, source_reference);
								dt = _tmp13_;
								_tmp14_ = dt;
								if (_tmp14_ == NULL) {
									result = FALSE;
									_vala_code_node_unref0 (dt);
									_g_string_free0 (current);
									return result;
								}
								_tmp15_ = dt;
								vala_data_type_add_type_argument (parent_type, _tmp15_);
								_tmp16_ = current;
								g_string_truncate (_tmp16_, (gsize) 0);
								_vala_code_node_unref0 (dt);
							} else {
								GString* _tmp17_;
								_tmp17_ = current;
								g_string_append_unichar (_tmp17_, (gunichar) string_get (type_arguments, (glong) c));
							}
						} else {
							GString* _tmp18_;
							_tmp18_ = current;
							g_string_append_unichar (_tmp18_, (gunichar) string_get (type_arguments, (glong) c));
						}
					}
				}
			}
		}
	}
	_tmp19_ = current;
	_tmp20_ = _tmp19_->str;
	_tmp21_ = vala_gir_parser_parse_type_from_string (self, _tmp20_, TRUE, source_reference);
	dt = _tmp21_;
	_tmp22_ = dt;
	if (_tmp22_ == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (dt);
		_g_string_free0 (current);
		return result;
	}
	_tmp23_ = dt;
	vala_data_type_add_type_argument (parent_type, _tmp23_);
	result = TRUE;
	_vala_code_node_unref0 (dt);
	_g_string_free0 (current);
	return result;
}

static ValaDataType*
vala_gir_parser_parse_type_from_string (ValaGirParser* self,
                                        const gchar* type_string,
                                        gboolean owned_by_default,
                                        ValaSourceReference* source_reference)
{
	GRegex* _tmp0_;
	GMatchInfo* match = NULL;
	GRegex* _tmp5_;
	GMatchInfo* _tmp6_ = NULL;
	gboolean _tmp7_;
	ValaDataType* type = NULL;
	gchar* ownership_data = NULL;
	GMatchInfo* _tmp8_;
	gchar* _tmp9_;
	gchar* type_name = NULL;
	GMatchInfo* _tmp10_;
	gchar* _tmp11_;
	gchar* type_arguments_data = NULL;
	GMatchInfo* _tmp12_;
	gchar* _tmp13_;
	gchar* pointers_data = NULL;
	GMatchInfo* _tmp14_;
	gchar* _tmp15_;
	gchar* array_data = NULL;
	GMatchInfo* _tmp16_;
	gchar* _tmp17_;
	gchar* nullable_data = NULL;
	GMatchInfo* _tmp18_;
	gchar* _tmp19_;
	gboolean _tmp20_ = FALSE;
	const gchar* _tmp21_;
	gboolean nullable = FALSE;
	gboolean _tmp25_ = FALSE;
	const gchar* _tmp26_;
	gboolean value_owned = FALSE;
	const gchar* _tmp39_;
	ValaUnresolvedSymbol* sym = NULL;
	const gchar* _tmp41_;
	ValaUnresolvedSymbol* _tmp42_;
	ValaUnresolvedSymbol* _tmp43_;
	ValaUnresolvedSymbol* _tmp44_;
	ValaUnresolvedType* _tmp45_;
	gboolean _tmp46_ = FALSE;
	const gchar* _tmp47_;
	const gchar* _tmp53_;
	gboolean _tmp61_ = FALSE;
	const gchar* _tmp62_;
	ValaDataType* _tmp72_;
	ValaDataType* _tmp73_;
	GError* _inner_error0_ = NULL;
	ValaDataType* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_string != NULL, NULL);
	_tmp0_ = vala_gir_parser_type_from_string_regex;
	if (_tmp0_ == NULL) {
		{
			GRegex* _tmp1_ = NULL;
			GRegex* _tmp2_;
			GRegex* _tmp3_;
			_tmp2_ = g_regex_new ("^(?:(owned|unowned|weak) +)?([0-9a-zA-Z_\\.]+)(?:<(.+)>)?(\\*+)?(\\[,*" \
"\\])?(\\?)?$", (G_REGEX_ANCHORED | G_REGEX_DOLLAR_ENDONLY) | G_REGEX_OPTIMIZE, 0, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch0_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_regex_unref0 (vala_gir_parser_type_from_string_regex);
			vala_gir_parser_type_from_string_regex = _tmp3_;
			_g_regex_unref0 (_tmp1_);
		}
		goto __finally0;
		__catch0_g_regex_error:
		{
			GError* e = NULL;
			const gchar* _tmp4_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e->message;
			g_error ("valagirparser.vala:1743: Unable to compile regex: %s", _tmp4_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = vala_gir_parser_type_from_string_regex;
	_tmp7_ = g_regex_match (_tmp5_, type_string, 0, &_tmp6_);
	_g_match_info_unref0 (match);
	match = _tmp6_;
	if (!_tmp7_) {
		vala_report_error (source_reference, "unable to parse type");
		result = NULL;
		_g_match_info_unref0 (match);
		return result;
	}
	type = NULL;
	_tmp8_ = match;
	_tmp9_ = g_match_info_fetch (_tmp8_, 1);
	ownership_data = _tmp9_;
	_tmp10_ = match;
	_tmp11_ = g_match_info_fetch (_tmp10_, 2);
	type_name = _tmp11_;
	_tmp12_ = match;
	_tmp13_ = g_match_info_fetch (_tmp12_, 3);
	type_arguments_data = _tmp13_;
	_tmp14_ = match;
	_tmp15_ = g_match_info_fetch (_tmp14_, 4);
	pointers_data = _tmp15_;
	_tmp16_ = match;
	_tmp17_ = g_match_info_fetch (_tmp16_, 5);
	array_data = _tmp17_;
	_tmp18_ = match;
	_tmp19_ = g_match_info_fetch (_tmp18_, 6);
	nullable_data = _tmp19_;
	_tmp21_ = nullable_data;
	if (_tmp21_ != NULL) {
		const gchar* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		_tmp22_ = nullable_data;
		_tmp23_ = strlen (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp20_ = _tmp24_ > 0;
	} else {
		_tmp20_ = FALSE;
	}
	nullable = _tmp20_;
	_tmp26_ = ownership_data;
	if (_tmp26_ == NULL) {
		const gchar* _tmp27_;
		_tmp27_ = type_name;
		_tmp25_ = g_strcmp0 (_tmp27_, "void") == 0;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		gboolean _tmp28_ = FALSE;
		const gchar* _tmp29_;
		_tmp29_ = array_data;
		if (_tmp29_ == NULL) {
			_tmp28_ = !nullable;
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			ValaVoidType* _tmp30_;
			const gchar* _tmp31_;
			_tmp30_ = vala_void_type_new (source_reference);
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp30_;
			_tmp31_ = pointers_data;
			if (_tmp31_ != NULL) {
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp32_ = FALSE;
						_tmp32_ = TRUE;
						while (TRUE) {
							const gchar* _tmp34_;
							gint _tmp35_;
							gint _tmp36_;
							ValaDataType* _tmp37_;
							ValaPointerType* _tmp38_;
							if (!_tmp32_) {
								gint _tmp33_;
								_tmp33_ = i;
								i = _tmp33_ + 1;
							}
							_tmp32_ = FALSE;
							_tmp34_ = pointers_data;
							_tmp35_ = strlen (_tmp34_);
							_tmp36_ = _tmp35_;
							if (!(i < _tmp36_)) {
								break;
							}
							_tmp37_ = type;
							_tmp38_ = vala_pointer_type_new (_tmp37_, NULL);
							_vala_code_node_unref0 (type);
							type = (ValaDataType*) _tmp38_;
						}
					}
				}
			}
			result = type;
			_g_free0 (nullable_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_g_match_info_unref0 (match);
			return result;
		} else {
			vala_report_error (source_reference, "invalid void type");
			result = NULL;
			_g_free0 (nullable_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_unref0 (match);
			return result;
		}
	}
	value_owned = owned_by_default;
	_tmp39_ = ownership_data;
	if (g_strcmp0 (_tmp39_, "owned") == 0) {
		if (owned_by_default) {
			vala_report_error (source_reference, "unexpected `owned' keyword");
		} else {
			value_owned = TRUE;
		}
	} else {
		const gchar* _tmp40_;
		_tmp40_ = ownership_data;
		if (g_strcmp0 (_tmp40_, "unowned") == 0) {
			if (owned_by_default) {
				value_owned = FALSE;
			} else {
				vala_report_error (source_reference, "unexpected `unowned' keyword");
				result = NULL;
				_g_free0 (nullable_data);
				_g_free0 (array_data);
				_g_free0 (pointers_data);
				_g_free0 (type_arguments_data);
				_g_free0 (type_name);
				_g_free0 (ownership_data);
				_vala_code_node_unref0 (type);
				_g_match_info_unref0 (match);
				return result;
			}
		}
	}
	_tmp41_ = type_name;
	_tmp42_ = vala_gir_parser_parse_symbol_from_string (self, _tmp41_, source_reference);
	sym = _tmp42_;
	_tmp43_ = sym;
	if (_tmp43_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (sym);
		_g_free0 (nullable_data);
		_g_free0 (array_data);
		_g_free0 (pointers_data);
		_g_free0 (type_arguments_data);
		_g_free0 (type_name);
		_g_free0 (ownership_data);
		_vala_code_node_unref0 (type);
		_g_match_info_unref0 (match);
		return result;
	}
	_tmp44_ = sym;
	_tmp45_ = vala_unresolved_type_new_from_symbol (_tmp44_, source_reference);
	_vala_code_node_unref0 (type);
	type = (ValaDataType*) _tmp45_;
	_tmp47_ = type_arguments_data;
	if (_tmp47_ != NULL) {
		const gchar* _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		_tmp48_ = type_arguments_data;
		_tmp49_ = strlen (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp46_ = _tmp50_ > 0;
	} else {
		_tmp46_ = FALSE;
	}
	if (_tmp46_) {
		ValaDataType* _tmp51_;
		const gchar* _tmp52_;
		_tmp51_ = type;
		_tmp52_ = type_arguments_data;
		if (!vala_gir_parser_parse_type_arguments_from_string (self, _tmp51_, _tmp52_, source_reference)) {
			result = NULL;
			_vala_code_node_unref0 (sym);
			_g_free0 (nullable_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_unref0 (match);
			return result;
		}
	}
	_tmp53_ = pointers_data;
	if (_tmp53_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp54_ = FALSE;
				_tmp54_ = TRUE;
				while (TRUE) {
					const gchar* _tmp56_;
					gint _tmp57_;
					gint _tmp58_;
					ValaDataType* _tmp59_;
					ValaPointerType* _tmp60_;
					if (!_tmp54_) {
						gint _tmp55_;
						_tmp55_ = i;
						i = _tmp55_ + 1;
					}
					_tmp54_ = FALSE;
					_tmp56_ = pointers_data;
					_tmp57_ = strlen (_tmp56_);
					_tmp58_ = _tmp57_;
					if (!(i < _tmp58_)) {
						break;
					}
					_tmp59_ = type;
					_tmp60_ = vala_pointer_type_new (_tmp59_, NULL);
					_vala_code_node_unref0 (type);
					type = (ValaDataType*) _tmp60_;
				}
			}
		}
	}
	_tmp62_ = array_data;
	if (_tmp62_ != NULL) {
		const gchar* _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		_tmp63_ = array_data;
		_tmp64_ = strlen (_tmp63_);
		_tmp65_ = _tmp64_;
		_tmp61_ = _tmp65_ != 0;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaDataType* _tmp66_;
		ValaDataType* _tmp67_;
		const gchar* _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		ValaArrayType* _tmp71_;
		_tmp66_ = type;
		vala_data_type_set_value_owned (_tmp66_, TRUE);
		_tmp67_ = type;
		_tmp68_ = array_data;
		_tmp69_ = strlen (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_array_type_new (_tmp67_, ((gint) _tmp70_) - 1, source_reference);
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp71_;
	}
	_tmp72_ = type;
	vala_data_type_set_nullable (_tmp72_, nullable);
	_tmp73_ = type;
	vala_data_type_set_value_owned (_tmp73_, value_owned);
	result = type;
	_vala_code_node_unref0 (sym);
	_g_free0 (nullable_data);
	_g_free0 (array_data);
	_g_free0 (pointers_data);
	_g_free0 (type_arguments_data);
	_g_free0 (type_name);
	_g_free0 (ownership_data);
	_g_match_info_unref0 (match);
	return result;
}

static gchar*
vala_gir_parser_element_get_string (ValaGirParser* self,
                                    const gchar* attribute_name,
                                    ValaGirParserArgumentType arg_type)
{
	ValaGirParserMetadata* _tmp0_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attribute_name != NULL, NULL);
	_tmp0_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp0_, arg_type)) {
		ValaGirParserMetadata* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->metadata;
		_tmp2_ = vala_gir_parser_metadata_get_string (_tmp1_, arg_type);
		result = _tmp2_;
		return result;
	} else {
		ValaMarkupReader* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->reader;
		_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, attribute_name);
		result = _tmp4_;
		return result;
	}
}

static ValaDataType*
vala_gir_parser_element_get_type (ValaGirParser* self,
                                  ValaDataType* orig_type,
                                  gboolean owned_by_default,
                                  gboolean* no_array_length,
                                  gboolean* array_null_terminated,
                                  gboolean* changed)
{
	gboolean _vala_changed = FALSE;
	ValaDataType* type = NULL;
	ValaDataType* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaDataType* _tmp43_;
	ValaDataType* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (orig_type != NULL, NULL);
	_vala_changed = FALSE;
	_tmp0_ = _vala_code_node_ref0 (orig_type);
	type = _tmp0_;
	_tmp1_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp1_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE)) {
		ValaGirParserMetadata* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		ValaGirParserMetadata* _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaDataType* _tmp8_;
		_tmp2_ = self->priv->metadata;
		_tmp3_ = vala_gir_parser_metadata_get_string (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->metadata;
		_tmp6_ = vala_gir_parser_metadata_get_source_reference (_tmp5_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_gir_parser_parse_type_from_string (self, _tmp4_, owned_by_default, _tmp7_);
		_vala_code_node_unref0 (type);
		type = _tmp8_;
		_vala_source_reference_unref0 (_tmp7_);
		_g_free0 (_tmp4_);
		_vala_changed = TRUE;
	} else {
		ValaDataType* _tmp9_;
		_tmp9_ = type;
		if (!VALA_IS_VOID_TYPE (_tmp9_)) {
			ValaGirParserMetadata* _tmp10_;
			gboolean _tmp19_ = FALSE;
			ValaDataType* _tmp20_;
			ValaDataType* _tmp38_;
			ValaGirParserMetadata* _tmp39_;
			ValaDataType* _tmp40_;
			gboolean _tmp41_;
			gboolean _tmp42_;
			_tmp10_ = self->priv->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp10_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS)) {
				ValaDataType* _tmp11_;
				ValaDataType* _tmp12_;
				ValaGirParserMetadata* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				ValaGirParserMetadata* _tmp16_;
				ValaSourceReference* _tmp17_;
				ValaSourceReference* _tmp18_;
				_tmp11_ = type;
				vala_data_type_remove_all_type_arguments (_tmp11_);
				_tmp12_ = type;
				_tmp13_ = self->priv->metadata;
				_tmp14_ = vala_gir_parser_metadata_get_string (_tmp13_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS);
				_tmp15_ = _tmp14_;
				_tmp16_ = self->priv->metadata;
				_tmp17_ = vala_gir_parser_metadata_get_source_reference (_tmp16_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS);
				_tmp18_ = _tmp17_;
				vala_gir_parser_parse_type_arguments_from_string (self, _tmp12_, _tmp15_, _tmp18_);
				_vala_source_reference_unref0 (_tmp18_);
				_g_free0 (_tmp15_);
			}
			_tmp20_ = type;
			if (!VALA_IS_ARRAY_TYPE (_tmp20_)) {
				ValaGirParserMetadata* _tmp21_;
				_tmp21_ = self->priv->metadata;
				_tmp19_ = vala_gir_parser_metadata_get_bool (_tmp21_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY, FALSE);
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				ValaDataType* _tmp22_;
				ValaDataType* _tmp23_;
				ValaDataType* _tmp24_;
				ValaSourceReference* _tmp25_;
				ValaSourceReference* _tmp26_;
				ValaArrayType* _tmp27_;
				_tmp22_ = type;
				vala_data_type_set_value_owned (_tmp22_, TRUE);
				_tmp23_ = type;
				_tmp24_ = type;
				_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_array_type_new (_tmp23_, 1, _tmp26_);
				_vala_code_node_unref0 (type);
				type = (ValaDataType*) _tmp27_;
				_vala_changed = TRUE;
			}
			if (owned_by_default) {
				ValaDataType* _tmp28_;
				ValaGirParserMetadata* _tmp29_;
				ValaDataType* _tmp30_;
				gboolean _tmp31_;
				gboolean _tmp32_;
				_tmp28_ = type;
				_tmp29_ = self->priv->metadata;
				_tmp30_ = type;
				_tmp31_ = vala_data_type_get_value_owned (_tmp30_);
				_tmp32_ = _tmp31_;
				vala_data_type_set_value_owned (_tmp28_, !vala_gir_parser_metadata_get_bool (_tmp29_, VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED, !_tmp32_));
			} else {
				ValaDataType* _tmp33_;
				ValaGirParserMetadata* _tmp34_;
				ValaDataType* _tmp35_;
				gboolean _tmp36_;
				gboolean _tmp37_;
				_tmp33_ = type;
				_tmp34_ = self->priv->metadata;
				_tmp35_ = type;
				_tmp36_ = vala_data_type_get_value_owned (_tmp35_);
				_tmp37_ = _tmp36_;
				vala_data_type_set_value_owned (_tmp33_, vala_gir_parser_metadata_get_bool (_tmp34_, VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED, _tmp37_));
			}
			_tmp38_ = type;
			_tmp39_ = self->priv->metadata;
			_tmp40_ = type;
			_tmp41_ = vala_data_type_get_nullable (_tmp40_);
			_tmp42_ = _tmp41_;
			vala_data_type_set_nullable (_tmp38_, vala_gir_parser_metadata_get_bool (_tmp39_, VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE, _tmp42_));
		}
	}
	_tmp43_ = type;
	if (VALA_IS_ARRAY_TYPE (_tmp43_)) {
		ValaGirParserMetadata* _tmp44_;
		if (!VALA_IS_ARRAY_TYPE (orig_type)) {
			*no_array_length = TRUE;
		}
		_tmp44_ = self->priv->metadata;
		*array_null_terminated = vala_gir_parser_metadata_get_bool (_tmp44_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED, *array_null_terminated);
	}
	result = type;
	if (changed) {
		*changed = _vala_changed;
	}
	return result;
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
vala_gir_parser_element_get_name (ValaGirParser* self,
                                  const gchar* gir_name)
{
	gchar* name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* pattern = NULL;
	ValaGirParserMetadata* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (gir_name);
	name = _tmp0_;
	_tmp1_ = name;
	if (_tmp1_ == NULL) {
		ValaMarkupReader* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->reader;
		_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "name");
		_g_free0 (name);
		name = _tmp3_;
	}
	_tmp4_ = self->priv->metadata;
	_tmp5_ = vala_gir_parser_metadata_get_string (_tmp4_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
	pattern = _tmp5_;
	_tmp6_ = pattern;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		_tmp7_ = pattern;
		if (string_index_of_char (_tmp7_, (gunichar) '(', 0) < 0) {
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = pattern;
			_tmp9_ = g_strdup (_tmp8_);
			_g_free0 (name);
			name = _tmp9_;
		} else {
			{
				gchar* replacement = NULL;
				gchar* _tmp10_;
				gchar** split = NULL;
				const gchar* _tmp11_;
				gchar** _tmp12_;
				gchar** _tmp13_;
				gint split_length1;
				gint _split_size_;
				gchar** _tmp14_;
				gint _tmp14__length1;
				GRegex* regex = NULL;
				const gchar* _tmp21_;
				GRegex* _tmp22_;
				gchar* _tmp23_ = NULL;
				GRegex* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				_tmp10_ = g_strdup ("\\1");
				replacement = _tmp10_;
				_tmp11_ = pattern;
				_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, "/", 0);
				split = _tmp13_;
				split_length1 = _vala_array_length (_tmp12_);
				_split_size_ = split_length1;
				_tmp14_ = split;
				_tmp14__length1 = split_length1;
				if (_tmp14__length1 > 1) {
					gchar** _tmp15_;
					gint _tmp15__length1;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					gchar** _tmp18_;
					gint _tmp18__length1;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					_tmp15_ = split;
					_tmp15__length1 = split_length1;
					_tmp16_ = _tmp15_[0];
					_tmp17_ = g_strdup (_tmp16_);
					_g_free0 (pattern);
					pattern = _tmp17_;
					_tmp18_ = split;
					_tmp18__length1 = split_length1;
					_tmp19_ = _tmp18_[1];
					_tmp20_ = g_strdup (_tmp19_);
					_g_free0 (replacement);
					replacement = _tmp20_;
				}
				_tmp21_ = pattern;
				_tmp22_ = g_regex_new (_tmp21_, G_REGEX_ANCHORED, G_REGEX_MATCH_ANCHORED, &_inner_error0_);
				regex = _tmp22_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (replacement);
					goto __catch0_g_error;
				}
				_tmp24_ = regex;
				_tmp25_ = name;
				_tmp26_ = replacement;
				_tmp27_ = g_regex_replace (_tmp24_, _tmp25_, (gssize) -1, 0, _tmp26_, 0, &_inner_error0_);
				_tmp23_ = _tmp27_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_regex_unref0 (regex);
					split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (replacement);
					goto __catch0_g_error;
				}
				_tmp28_ = _tmp23_;
				_tmp23_ = NULL;
				_g_free0 (name);
				name = _tmp28_;
				_g_free0 (_tmp23_);
				_g_regex_unref0 (regex);
				split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (replacement);
			}
			goto __finally0;
			__catch0_g_error:
			{
				const gchar* _tmp29_;
				gchar* _tmp30_;
				g_clear_error (&_inner_error0_);
				_tmp29_ = pattern;
				_tmp30_ = g_strdup (_tmp29_);
				_g_free0 (name);
				name = _tmp30_;
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (pattern);
				_g_free0 (name);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	} else {
		gboolean _tmp31_ = FALSE;
		const gchar* _tmp32_;
		_tmp32_ = name;
		if (_tmp32_ != NULL) {
			const gchar* _tmp33_;
			_tmp33_ = name;
			_tmp31_ = g_str_has_suffix (_tmp33_, "Enum");
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			gint _tmp39_;
			gchar* _tmp40_;
			_tmp34_ = name;
			_tmp35_ = name;
			_tmp36_ = strlen (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = strlen ("Enum");
			_tmp39_ = _tmp38_;
			_tmp40_ = string_substring (_tmp34_, (glong) 0, (glong) (_tmp37_ - _tmp39_));
			_g_free0 (name);
			name = _tmp40_;
		}
	}
	result = name;
	_g_free0 (pattern);
	return result;
}

static gchar*
vala_gir_parser_element_get_type_id (ValaGirParser* self)
{
	gchar* type_id = NULL;
	ValaGirParserMetadata* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	ValaMarkupReader* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->metadata;
	_tmp1_ = vala_gir_parser_metadata_get_string (_tmp0_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID);
	type_id = _tmp1_;
	_tmp2_ = type_id;
	if (_tmp2_ != NULL) {
		result = type_id;
		return result;
	}
	_tmp3_ = self->priv->reader;
	_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, "glib:get-type");
	_g_free0 (type_id);
	type_id = _tmp4_;
	_tmp5_ = type_id;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = type_id;
		_tmp7_ = g_strconcat (_tmp6_, " ()", NULL);
		_g_free0 (type_id);
		type_id = _tmp7_;
	}
	result = type_id;
	return result;
}

static void
vala_gir_parser_set_array_ccode (ValaGirParser* self,
                                 ValaSymbol* sym,
                                 ValaGirParserParameterInfo* info)
{
	gchar* type_name = NULL;
	ValaParameter* _tmp3_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	g_return_if_fail (info != NULL);
	vala_code_node_set_attribute_double ((ValaCodeNode*) sym, "CCode", "array_length_pos", (gdouble) info->vala_idx, NULL);
	if (VALA_IS_PARAMETER (sym)) {
		ValaParameter* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp0_ = info->param;
		_tmp1_ = vala_symbol_get_name ((ValaSymbol*) _tmp0_);
		_tmp2_ = _tmp1_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) sym, "CCode", "array_length_cname", _tmp2_, NULL);
	}
	_tmp3_ = info->param;
	_tmp4_ = vala_variable_get_variable_type ((ValaVariable*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_data_type_to_qualified_string (_tmp5_, NULL);
	type_name = _tmp6_;
	_tmp7_ = type_name;
	if (g_strcmp0 (_tmp7_, "int") != 0) {
		ValaGirParserNode* st = NULL;
		ValaGirParserNode* _tmp8_;
		const gchar* _tmp9_;
		ValaGirParserNode* _tmp10_;
		ValaGirParserNode* _tmp11_;
		_tmp8_ = self->priv->root;
		_tmp9_ = type_name;
		_tmp10_ = vala_gir_parser_node_lookup (_tmp8_, _tmp9_, FALSE, NULL);
		st = _tmp10_;
		_tmp11_ = st;
		if (_tmp11_ != NULL) {
			gboolean _tmp12_ = FALSE;
			if (VALA_IS_CALLABLE (sym)) {
				_tmp12_ = TRUE;
			} else {
				_tmp12_ = VALA_IS_PARAMETER (sym);
			}
			if (_tmp12_) {
				ValaGirParserNode* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp13_ = st;
				_tmp14_ = vala_gir_parser_node_get_cname (_tmp13_);
				_tmp15_ = _tmp14_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) sym, "CCode", "array_length_type", _tmp15_, NULL);
				_g_free0 (_tmp15_);
			}
		}
		_vala_gir_parser_node_unref0 (st);
	}
	_g_free0 (type_name);
}

static void
vala_gir_parser_set_type_id_ccode (ValaGirParser* self,
                                   ValaSymbol* sym)
{
	gboolean _tmp0_ = FALSE;
	gchar* type_id = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	if (vala_code_node_has_attribute_argument ((ValaCodeNode*) sym, "CCode", "has_type_id")) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) sym, "CCode", "type_id");
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = vala_gir_parser_element_get_type_id (self);
	type_id = _tmp1_;
	_tmp2_ = type_id;
	if (_tmp2_ == NULL) {
		vala_code_node_set_attribute_bool ((ValaCodeNode*) sym, "CCode", "has_type_id", FALSE, NULL);
	} else {
		const gchar* _tmp3_;
		_tmp3_ = type_id;
		vala_code_node_set_attribute_string ((ValaCodeNode*) sym, "CCode", "type_id", _tmp3_, NULL);
	}
	_g_free0 (type_id);
}

static void
vala_gir_parser_parse_repository (ValaGirParser* self)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "repository");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "version");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, VALA_GIR_PARSER_GIR_VERSION) != 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaMarkupReader* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp4_ = vala_gir_parser_get_current_src (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->reader;
		_tmp7_ = vala_markup_reader_get_attribute (_tmp6_, "version");
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf ("unsupported GIR version %s (supported: %s)", _tmp8_, VALA_GIR_PARSER_GIR_VERSION);
		_tmp10_ = _tmp9_;
		vala_report_error (_tmp5_, _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_vala_source_reference_unref0 (_tmp5_);
		return;
	}
	vala_gir_parser_next (self);
	while (TRUE) {
		ValaMarkupTokenType _tmp11_;
		ValaMarkupReader* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp11_ = self->priv->current_token;
		if (!(_tmp11_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp12_ = self->priv->reader;
		_tmp13_ = vala_markup_reader_get_name (_tmp12_);
		_tmp14_ = _tmp13_;
		if (g_strcmp0 (_tmp14_, "namespace") == 0) {
			vala_gir_parser_parse_namespace (self);
		} else {
			ValaMarkupReader* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp15_ = self->priv->reader;
			_tmp16_ = vala_markup_reader_get_name (_tmp15_);
			_tmp17_ = _tmp16_;
			if (g_strcmp0 (_tmp17_, "include") == 0) {
				vala_gir_parser_parse_include (self);
			} else {
				ValaMarkupReader* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				_tmp18_ = self->priv->reader;
				_tmp19_ = vala_markup_reader_get_name (_tmp18_);
				_tmp20_ = _tmp19_;
				if (g_strcmp0 (_tmp20_, "package") == 0) {
					gchar* pkg = NULL;
					gchar* _tmp21_;
					ValaSourceFile* _tmp22_;
					const gchar* _tmp23_;
					ValaCodeContext* _tmp24_;
					const gchar* _tmp25_;
					_tmp21_ = vala_gir_parser_parse_package (self);
					pkg = _tmp21_;
					_tmp22_ = self->priv->current_source_file;
					_tmp23_ = pkg;
					vala_source_file_set_package_name (_tmp22_, _tmp23_);
					_tmp24_ = self->priv->context;
					_tmp25_ = pkg;
					if (vala_code_context_has_package (_tmp24_, _tmp25_)) {
						ValaSourceFile* _tmp26_;
						gboolean _tmp27_;
						gboolean _tmp28_;
						_tmp26_ = self->priv->current_source_file;
						_tmp27_ = vala_source_file_get_from_commandline (_tmp26_);
						_tmp28_ = _tmp27_;
						if (!_tmp28_) {
							_g_free0 (pkg);
							return;
						}
					} else {
						ValaCodeContext* _tmp29_;
						const gchar* _tmp30_;
						_tmp29_ = self->priv->context;
						_tmp30_ = pkg;
						vala_code_context_add_package (_tmp29_, _tmp30_);
					}
					_g_free0 (pkg);
				} else {
					ValaMarkupReader* _tmp31_;
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					_tmp31_ = self->priv->reader;
					_tmp32_ = vala_markup_reader_get_name (_tmp31_);
					_tmp33_ = _tmp32_;
					if (g_strcmp0 (_tmp33_, "c:include") == 0) {
						vala_gir_parser_parse_c_include (self);
					} else {
						ValaSourceReference* _tmp34_;
						ValaSourceReference* _tmp35_;
						ValaMarkupReader* _tmp36_;
						const gchar* _tmp37_;
						const gchar* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						_tmp34_ = vala_gir_parser_get_current_src (self);
						_tmp35_ = _tmp34_;
						_tmp36_ = self->priv->reader;
						_tmp37_ = vala_markup_reader_get_name (_tmp36_);
						_tmp38_ = _tmp37_;
						_tmp39_ = g_strdup_printf ("unknown child element `%s' in `repository'", _tmp38_);
						_tmp40_ = _tmp39_;
						vala_report_error (_tmp35_, _tmp40_);
						_g_free0 (_tmp40_);
						_vala_source_reference_unref0 (_tmp35_);
						vala_gir_parser_skip_element (self);
					}
				}
			}
		}
	}
	vala_gir_parser_end_element (self, "repository");
}

static void
vala_gir_parser_parse_include (ValaGirParser* self)
{
	gchar* pkg = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* version = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCodeContext* _tmp8_;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "include");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	pkg = _tmp1_;
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "version");
	version = _tmp3_;
	_tmp4_ = version;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = pkg;
		_tmp6_ = version;
		_tmp7_ = g_strdup_printf ("%s-%s", _tmp5_, _tmp6_);
		_g_free0 (pkg);
		pkg = _tmp7_;
	}
	_tmp8_ = self->priv->context;
	_tmp9_ = pkg;
	vala_code_context_add_external_package (_tmp8_, _tmp9_);
	vala_gir_parser_next (self);
	vala_gir_parser_end_element (self, "include");
	_g_free0 (version);
	_g_free0 (pkg);
}

static gchar*
vala_gir_parser_parse_package (ValaGirParser* self)
{
	gchar* pkg = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "package");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	pkg = _tmp1_;
	vala_gir_parser_next (self);
	vala_gir_parser_end_element (self, "package");
	result = pkg;
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
vala_gir_parser_parse_c_include (ValaGirParser* self)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "c:include");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	_vala_array_add1 (&self->priv->cheader_filenames, &self->priv->cheader_filenames_length1, &self->priv->_cheader_filenames_size_, _tmp1_);
	vala_gir_parser_next (self);
	vala_gir_parser_end_element (self, "c:include");
}

static void
vala_gir_parser_skip_element (ValaGirParser* self)
{
	gint level = 0;
	g_return_if_fail (self != NULL);
	vala_gir_parser_next (self);
	level = 1;
	while (TRUE) {
		ValaMarkupTokenType _tmp0_;
		if (!(level > 0)) {
			break;
		}
		_tmp0_ = self->priv->current_token;
		if (_tmp0_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
			gint _tmp1_;
			_tmp1_ = level;
			level = _tmp1_ + 1;
		} else {
			ValaMarkupTokenType _tmp2_;
			_tmp2_ = self->priv->current_token;
			if (_tmp2_ == VALA_MARKUP_TOKEN_TYPE_END_ELEMENT) {
				gint _tmp3_;
				_tmp3_ = level;
				level = _tmp3_ - 1;
			} else {
				ValaMarkupTokenType _tmp4_;
				_tmp4_ = self->priv->current_token;
				if (_tmp4_ == VALA_MARKUP_TOKEN_TYPE_EOF) {
					ValaSourceReference* _tmp5_;
					ValaSourceReference* _tmp6_;
					_tmp5_ = vala_gir_parser_get_current_src (self);
					_tmp6_ = _tmp5_;
					vala_report_error (_tmp6_, "unexpected end of file");
					_vala_source_reference_unref0 (_tmp6_);
					break;
				}
			}
		}
		vala_gir_parser_next (self);
	}
}

static ValaGirParserNode*
vala_gir_parser_resolve_node (ValaGirParser* self,
                              ValaGirParserNode* parent_scope,
                              ValaUnresolvedSymbol* unresolved_sym,
                              gboolean create_namespace)
{
	ValaUnresolvedSymbol* _tmp0_;
	ValaUnresolvedSymbol* _tmp1_;
	ValaGirParserNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent_scope != NULL, NULL);
	g_return_val_if_fail (unresolved_sym != NULL, NULL);
	_tmp0_ = vala_unresolved_symbol_get_inner (unresolved_sym);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		ValaGirParserNode* scope = NULL;
		ValaGirParserNode* _tmp2_;
		_tmp2_ = _vala_gir_parser_node_ref0 (parent_scope);
		scope = _tmp2_;
		while (TRUE) {
			ValaGirParserNode* _tmp3_;
			ValaGirParserNode* node = NULL;
			ValaGirParserNode* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			ValaSourceReference* _tmp7_;
			ValaSourceReference* _tmp8_;
			ValaGirParserNode* _tmp9_;
			ValaGirParserNode* _tmp10_;
			ValaGirParserNode* _tmp11_;
			ValaGirParserNode* _tmp12_;
			ValaGirParserNode* _tmp13_;
			_tmp3_ = scope;
			if (!(_tmp3_ != NULL)) {
				break;
			}
			_tmp4_ = scope;
			_tmp5_ = vala_symbol_get_name ((ValaSymbol*) unresolved_sym);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) unresolved_sym);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_gir_parser_node_lookup (_tmp4_, _tmp6_, create_namespace, _tmp8_);
			node = _tmp9_;
			_tmp10_ = node;
			if (_tmp10_ != NULL) {
				result = node;
				_vala_gir_parser_node_unref0 (scope);
				return result;
			}
			_tmp11_ = scope;
			_tmp12_ = _tmp11_->parent;
			_tmp13_ = _vala_gir_parser_node_ref0 (_tmp12_);
			_vala_gir_parser_node_unref0 (scope);
			scope = _tmp13_;
			_vala_gir_parser_node_unref0 (node);
		}
		_vala_gir_parser_node_unref0 (scope);
	} else {
		ValaGirParserNode* inner = NULL;
		ValaUnresolvedSymbol* _tmp14_;
		ValaUnresolvedSymbol* _tmp15_;
		ValaGirParserNode* _tmp16_;
		ValaGirParserNode* _tmp17_;
		_tmp14_ = vala_unresolved_symbol_get_inner (unresolved_sym);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_gir_parser_resolve_node (self, parent_scope, _tmp15_, create_namespace);
		inner = _tmp16_;
		_tmp17_ = inner;
		if (_tmp17_ != NULL) {
			ValaGirParserNode* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			ValaSourceReference* _tmp21_;
			ValaSourceReference* _tmp22_;
			ValaGirParserNode* _tmp23_;
			_tmp18_ = inner;
			_tmp19_ = vala_symbol_get_name ((ValaSymbol*) unresolved_sym);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) unresolved_sym);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_gir_parser_node_lookup (_tmp18_, _tmp20_, create_namespace, _tmp22_);
			result = _tmp23_;
			_vala_gir_parser_node_unref0 (inner);
			return result;
		}
		_vala_gir_parser_node_unref0 (inner);
	}
	result = NULL;
	return result;
}

static ValaSymbol*
vala_gir_parser_resolve_symbol (ValaGirParser* self,
                                ValaGirParserNode* parent_scope,
                                ValaUnresolvedSymbol* unresolved_sym)
{
	ValaGirParserNode* node = NULL;
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	ValaSymbol* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent_scope != NULL, NULL);
	g_return_val_if_fail (unresolved_sym != NULL, NULL);
	_tmp0_ = vala_gir_parser_resolve_node (self, parent_scope, unresolved_sym, FALSE);
	node = _tmp0_;
	_tmp1_ = node;
	if (_tmp1_ != NULL) {
		ValaGirParserNode* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp2_ = node;
		_tmp3_ = _tmp2_->symbol;
		_tmp4_ = _vala_code_node_ref0 (_tmp3_);
		result = _tmp4_;
		_vala_gir_parser_node_unref0 (node);
		return result;
	}
	result = NULL;
	_vala_gir_parser_node_unref0 (node);
	return result;
}

static void
vala_gir_parser_push_node (ValaGirParser* self,
                           const gchar* name,
                           gboolean merge)
{
	ValaGirParserNode* parent = NULL;
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	ValaGirParserNode* node = NULL;
	ValaGirParserNode* _tmp14_;
	ValaGirParserNode* _tmp15_;
	gboolean _tmp16_ = FALSE;
	ValaGirParserNode* _tmp17_;
	ValaGirParserNode* _tmp27_;
	ValaMarkupReader* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	ValaGirParserNode* _tmp32_;
	ValaMarkupReader* _tmp33_;
	ValaMap* _tmp34_;
	ValaGirParserNode* _tmp35_;
	ValaGirParserMetadata* _tmp36_;
	ValaGirParserMetadata* _tmp37_;
	ValaGirParserNode* _tmp38_;
	ValaSourceReference* _tmp39_;
	gchar* gir_name = NULL;
	ValaGirParserNode* _tmp40_;
	gchar* _tmp41_;
	gboolean _tmp42_ = FALSE;
	ValaGirParserNode* _tmp43_;
	ValaGirParserNode* _tmp44_;
	ValaArrayList* _tmp52_;
	ValaGirParserNode* _tmp53_;
	ValaGirParserNode* _tmp54_;
	ValaGirParserNode* _tmp55_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->current;
	_tmp1_ = _vala_gir_parser_node_ref0 (_tmp0_);
	parent = _tmp1_;
	_tmp2_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT)) {
		ValaUnresolvedSymbol* target = NULL;
		ValaGirParserMetadata* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		ValaGirParserMetadata* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaUnresolvedSymbol* _tmp9_;
		ValaUnresolvedSymbol* _tmp10_;
		ValaGirParserNode* _tmp11_;
		ValaUnresolvedSymbol* _tmp12_;
		ValaGirParserNode* _tmp13_;
		_tmp3_ = self->priv->metadata;
		_tmp4_ = vala_gir_parser_metadata_get_string (_tmp3_, VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->metadata;
		_tmp7_ = vala_gir_parser_metadata_get_source_reference (_tmp6_, VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_gir_parser_parse_symbol_from_string (self, _tmp5_, _tmp8_);
		_tmp10_ = _tmp9_;
		_vala_source_reference_unref0 (_tmp8_);
		_g_free0 (_tmp5_);
		target = _tmp10_;
		_tmp11_ = self->priv->root;
		_tmp12_ = target;
		_tmp13_ = vala_gir_parser_resolve_node (self, _tmp11_, _tmp12_, TRUE);
		_vala_gir_parser_node_unref0 (parent);
		parent = _tmp13_;
		_vala_code_node_unref0 (target);
	}
	_tmp14_ = parent;
	_tmp15_ = vala_gir_parser_node_lookup (_tmp14_, name, FALSE, NULL);
	node = _tmp15_;
	_tmp17_ = node;
	if (_tmp17_ == NULL) {
		_tmp16_ = TRUE;
	} else {
		gboolean _tmp18_ = FALSE;
		ValaGirParserNode* _tmp19_;
		ValaSymbol* _tmp20_;
		_tmp19_ = node;
		_tmp20_ = _tmp19_->symbol;
		if (_tmp20_ != NULL) {
			_tmp18_ = !merge;
		} else {
			_tmp18_ = FALSE;
		}
		_tmp16_ = _tmp18_;
	}
	if (_tmp16_) {
		ValaGirParserNode* _tmp21_;
		ValaGirParserNode* _tmp22_;
		ValaGirParserNode* _tmp23_;
		ValaGirParserNode* _tmp24_;
		_tmp21_ = vala_gir_parser_node_new (name);
		_vala_gir_parser_node_unref0 (node);
		node = _tmp21_;
		_tmp22_ = node;
		_tmp22_->new_symbol = TRUE;
		_tmp23_ = parent;
		_tmp24_ = node;
		vala_gir_parser_node_add_member (_tmp23_, _tmp24_);
	} else {
		ValaArrayList* _tmp25_;
		ValaGirParserNode* _tmp26_;
		_tmp25_ = vala_gir_parser_node_new_namespaces;
		_tmp26_ = node;
		vala_collection_remove ((ValaCollection*) _tmp25_, _tmp26_);
	}
	_tmp27_ = node;
	_tmp28_ = self->priv->reader;
	_tmp29_ = vala_markup_reader_get_name (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strdup (_tmp30_);
	_g_free0 (_tmp27_->element_type);
	_tmp27_->element_type = _tmp31_;
	_tmp32_ = node;
	_tmp33_ = self->priv->reader;
	_tmp34_ = vala_markup_reader_get_attributes (_tmp33_);
	_vala_map_unref0 (_tmp32_->girdata);
	_tmp32_->girdata = _tmp34_;
	_tmp35_ = node;
	_tmp36_ = self->priv->metadata;
	_tmp37_ = _vala_gir_parser_metadata_ref0 (_tmp36_);
	_vala_gir_parser_metadata_unref0 (_tmp35_->metadata);
	_tmp35_->metadata = _tmp37_;
	_tmp38_ = node;
	_tmp39_ = vala_gir_parser_get_current_src (self);
	_vala_source_reference_unref0 (_tmp38_->source_reference);
	_tmp38_->source_reference = _tmp39_;
	_tmp40_ = node;
	_tmp41_ = vala_gir_parser_node_get_gir_name (_tmp40_);
	gir_name = _tmp41_;
	_tmp43_ = parent;
	_tmp44_ = self->priv->current;
	if (_tmp43_ != _tmp44_) {
		_tmp42_ = TRUE;
	} else {
		const gchar* _tmp45_;
		_tmp45_ = gir_name;
		_tmp42_ = g_strcmp0 (_tmp45_, name) != 0;
	}
	if (_tmp42_) {
		const gchar* _tmp46_;
		ValaUnresolvedSymbol* _tmp47_;
		ValaUnresolvedSymbol* _tmp48_;
		ValaGirParserNode* _tmp49_;
		ValaUnresolvedSymbol* _tmp50_;
		ValaUnresolvedSymbol* _tmp51_;
		_tmp46_ = gir_name;
		_tmp47_ = vala_unresolved_symbol_new (NULL, _tmp46_, NULL);
		_tmp48_ = _tmp47_;
		_tmp49_ = node;
		_tmp50_ = vala_gir_parser_node_get_unresolved_symbol (_tmp49_);
		_tmp51_ = _tmp50_;
		vala_gir_parser_set_symbol_mapping (self, _tmp48_, (ValaSymbol*) _tmp51_);
		_vala_code_node_unref0 (_tmp51_);
		_vala_code_node_unref0 (_tmp48_);
	}
	_tmp52_ = self->priv->tree_stack;
	_tmp53_ = self->priv->current;
	vala_collection_add ((ValaCollection*) _tmp52_, _tmp53_);
	_tmp54_ = node;
	_tmp55_ = _vala_gir_parser_node_ref0 (_tmp54_);
	_vala_gir_parser_node_unref0 (self->priv->current);
	self->priv->current = _tmp55_;
	_g_free0 (gir_name);
	_vala_gir_parser_node_unref0 (node);
	_vala_gir_parser_node_unref0 (parent);
}

static void
vala_gir_parser_pop_node (ValaGirParser* self)
{
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	ValaArrayList* _tmp2_;
	ValaArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gpointer _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	_tmp1_ = _vala_gir_parser_node_ref0 (_tmp0_);
	_vala_gir_parser_node_unref0 (self->priv->old_current);
	self->priv->old_current = _tmp1_;
	_tmp2_ = self->priv->tree_stack;
	_tmp3_ = self->priv->tree_stack;
	_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_list_remove_at ((ValaList*) _tmp2_, _tmp5_ - 1);
	_vala_gir_parser_node_unref0 (self->priv->current);
	self->priv->current = (ValaGirParserNode*) _tmp6_;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static void
_vala_code_node_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL));
}

static inline void
_g_list_free__vala_code_node_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _vala_code_node_unref0_);
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gboolean _tmp0_ = FALSE;
	gchar* result = NULL;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static void
vala_gir_parser_parse_namespace (ValaGirParser* self)
{
	gchar* cprefix = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* lower_case_cprefix = NULL;
	ValaMarkupReader* _tmp6_;
	gchar* _tmp7_;
	gchar* vala_namespace = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* gir_namespace = NULL;
	ValaMarkupReader* _tmp10_;
	gchar* _tmp11_;
	gchar* gir_version = NULL;
	ValaMarkupReader* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	ValaSet* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gboolean _tmp23_;
	gchar* metadata_filename = NULL;
	ValaCodeContext* _tmp24_;
	ValaSourceFile* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	gboolean _tmp29_ = FALSE;
	const gchar* _tmp30_;
	ValaGirParserMetadata* ns_metadata = NULL;
	ValaGirParserMetadata* _tmp46_;
	const gchar* _tmp47_;
	ValaGirParserMetadata* _tmp48_;
	ValaGirParserMetadata* _tmp49_;
	const gchar* _tmp52_;
	ValaSourceFile* _tmp55_;
	const gchar* _tmp56_;
	ValaSourceFile* _tmp57_;
	const gchar* _tmp58_;
	ValaNamespace* ns = NULL;
	const gchar* _tmp59_;
	ValaGirParserNode* _tmp60_;
	ValaGirParserNode* _tmp75_;
	ValaGirParserMetadata* _tmp76_;
	ValaGirParserMetadata* _tmp77_;
	ValaGirParserMetadata* _tmp78_;
	ValaGirParserMetadata* _tmp81_;
	ValaNamespace* _tmp87_;
	const gchar* _tmp88_;
	ValaNamespace* _tmp89_;
	const gchar* _tmp90_;
	const gchar* _tmp91_;
	const gchar* _tmp101_;
	gchar** _tmp104_;
	gint _tmp104__length1;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "namespace");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "c:identifier-prefixes");
	cprefix = _tmp1_;
	_tmp2_ = cprefix;
	if (_tmp2_ != NULL) {
		gint idx = 0;
		const gchar* _tmp3_;
		_tmp3_ = cprefix;
		idx = string_index_of (_tmp3_, ",", 0);
		if (idx != -1) {
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = cprefix;
			_tmp5_ = string_substring (_tmp4_, (glong) 0, (glong) idx);
			_g_free0 (cprefix);
			cprefix = _tmp5_;
		}
	}
	_tmp6_ = self->priv->reader;
	_tmp7_ = vala_markup_reader_get_attribute (_tmp6_, "c:symbol-prefixes");
	lower_case_cprefix = _tmp7_;
	_tmp8_ = cprefix;
	_tmp9_ = g_strdup (_tmp8_);
	vala_namespace = _tmp9_;
	_tmp10_ = self->priv->reader;
	_tmp11_ = vala_markup_reader_get_attribute (_tmp10_, "name");
	gir_namespace = _tmp11_;
	_tmp12_ = self->priv->reader;
	_tmp13_ = vala_markup_reader_get_attribute (_tmp12_, "version");
	gir_version = _tmp13_;
	_tmp14_ = lower_case_cprefix;
	if (_tmp14_ != NULL) {
		gint idx = 0;
		const gchar* _tmp15_;
		_tmp15_ = lower_case_cprefix;
		idx = string_index_of (_tmp15_, ",", 0);
		if (idx != -1) {
			const gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp16_ = lower_case_cprefix;
			_tmp17_ = string_substring (_tmp16_, (glong) 0, (glong) idx);
			_g_free0 (lower_case_cprefix);
			lower_case_cprefix = _tmp17_;
		}
	}
	_tmp18_ = self->priv->provided_namespaces;
	_tmp19_ = gir_namespace;
	_tmp20_ = gir_version;
	_tmp21_ = g_strdup_printf ("%s-%s", _tmp19_, _tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_collection_contains ((ValaCollection*) _tmp18_, _tmp22_);
	_g_free0 (_tmp22_);
	if (_tmp23_) {
		vala_gir_parser_skip_element (self);
		_g_free0 (gir_version);
		_g_free0 (gir_namespace);
		_g_free0 (vala_namespace);
		_g_free0 (lower_case_cprefix);
		_g_free0 (cprefix);
		return;
	}
	_tmp24_ = self->priv->context;
	_tmp25_ = self->priv->current_source_file;
	_tmp26_ = vala_source_file_get_filename (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_code_context_get_metadata_path (_tmp24_, _tmp27_);
	metadata_filename = _tmp28_;
	_tmp30_ = metadata_filename;
	if (_tmp30_ != NULL) {
		const gchar* _tmp31_;
		_tmp31_ = metadata_filename;
		_tmp29_ = g_file_test (_tmp31_, G_FILE_TEST_EXISTS);
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		ValaGirParserMetadataParser* metadata_parser = NULL;
		ValaGirParserMetadataParser* _tmp32_;
		ValaSourceFile* metadata_file = NULL;
		ValaCodeContext* _tmp33_;
		ValaSourceFile* _tmp34_;
		ValaSourceFileType _tmp35_;
		ValaSourceFileType _tmp36_;
		const gchar* _tmp37_;
		ValaSourceFile* _tmp38_;
		ValaCodeContext* _tmp39_;
		ValaSourceFile* _tmp40_;
		ValaGirParserMetadataParser* _tmp41_;
		ValaSourceFile* _tmp42_;
		ValaGirParserMetadata* _tmp43_;
		ValaArrayList* _tmp44_;
		ValaGirParserMetadata* _tmp45_;
		_tmp32_ = vala_gir_parser_metadata_parser_new ();
		metadata_parser = _tmp32_;
		_tmp33_ = self->priv->context;
		_tmp34_ = self->priv->current_source_file;
		_tmp35_ = vala_source_file_get_file_type (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = metadata_filename;
		_tmp38_ = vala_source_file_new (_tmp33_, _tmp36_, _tmp37_, NULL, FALSE);
		metadata_file = _tmp38_;
		_tmp39_ = self->priv->context;
		_tmp40_ = metadata_file;
		vala_code_context_add_source_file (_tmp39_, _tmp40_);
		_tmp41_ = metadata_parser;
		_tmp42_ = metadata_file;
		_tmp43_ = vala_gir_parser_metadata_parser_parse_metadata (_tmp41_, _tmp42_);
		_vala_gir_parser_metadata_unref0 (self->priv->metadata);
		self->priv->metadata = _tmp43_;
		_tmp44_ = self->priv->metadata_roots;
		_tmp45_ = self->priv->metadata;
		vala_collection_add ((ValaCollection*) _tmp44_, _tmp45_);
		_vala_source_file_unref0 (metadata_file);
		_vala_gir_parser_metadata_parser_unref0 (metadata_parser);
	}
	_tmp46_ = self->priv->metadata;
	_tmp47_ = gir_namespace;
	_tmp48_ = vala_gir_parser_metadata_match_child (_tmp46_, _tmp47_, NULL);
	ns_metadata = _tmp48_;
	_tmp49_ = ns_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp49_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME)) {
		ValaGirParserMetadata* _tmp50_;
		gchar* _tmp51_;
		_tmp50_ = ns_metadata;
		_tmp51_ = vala_gir_parser_metadata_get_string (_tmp50_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
		_g_free0 (vala_namespace);
		vala_namespace = _tmp51_;
	}
	_tmp52_ = vala_namespace;
	if (_tmp52_ == NULL) {
		const gchar* _tmp53_;
		gchar* _tmp54_;
		_tmp53_ = gir_namespace;
		_tmp54_ = g_strdup (_tmp53_);
		_g_free0 (vala_namespace);
		vala_namespace = _tmp54_;
	}
	_tmp55_ = self->priv->current_source_file;
	_tmp56_ = gir_namespace;
	vala_source_file_set_gir_namespace (_tmp55_, _tmp56_);
	_tmp57_ = self->priv->current_source_file;
	_tmp58_ = gir_version;
	vala_source_file_set_gir_version (_tmp57_, _tmp58_);
	_tmp59_ = vala_namespace;
	vala_gir_parser_push_node (self, _tmp59_, TRUE);
	_tmp60_ = self->priv->current;
	if (_tmp60_->new_symbol) {
		const gchar* _tmp61_;
		ValaGirParserNode* _tmp62_;
		ValaSourceReference* _tmp63_;
		ValaNamespace* _tmp64_;
		ValaGirParserNode* _tmp65_;
		ValaNamespace* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp61_ = vala_namespace;
		_tmp62_ = self->priv->current;
		_tmp63_ = _tmp62_->source_reference;
		_tmp64_ = vala_namespace_new (_tmp61_, _tmp63_);
		_vala_code_node_unref0 (ns);
		ns = _tmp64_;
		_tmp65_ = self->priv->current;
		_tmp66_ = ns;
		_tmp67_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp66_);
		_vala_code_node_unref0 (_tmp65_->symbol);
		_tmp65_->symbol = _tmp67_;
	} else {
		ValaGirParserNode* _tmp68_;
		ValaSymbol* _tmp69_;
		ValaNamespace* _tmp70_;
		ValaNamespace* _tmp71_;
		ValaNamespace* _tmp72_;
		ValaGirParserNode* _tmp73_;
		ValaSourceReference* _tmp74_;
		_tmp68_ = self->priv->current;
		_tmp69_ = _tmp68_->symbol;
		_tmp70_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_NAMESPACE, ValaNamespace));
		_vala_code_node_unref0 (ns);
		ns = _tmp70_;
		_tmp71_ = ns;
		(((ValaCodeNode*) _tmp71_)->attributes == NULL) ? NULL : (((ValaCodeNode*) _tmp71_)->attributes = (_g_list_free__vala_code_node_unref0_ (((ValaCodeNode*) _tmp71_)->attributes), NULL));
		((ValaCodeNode*) _tmp71_)->attributes = NULL;
		_tmp72_ = ns;
		_tmp73_ = self->priv->current;
		_tmp74_ = _tmp73_->source_reference;
		vala_code_node_set_source_reference ((ValaCodeNode*) _tmp72_, _tmp74_);
	}
	_tmp75_ = self->priv->current;
	_tmp76_ = ns_metadata;
	_tmp77_ = _vala_gir_parser_metadata_ref0 (_tmp76_);
	_vala_gir_parser_metadata_unref0 (_tmp75_->metadata);
	_tmp75_->metadata = _tmp77_;
	_tmp78_ = ns_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp78_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX)) {
		ValaGirParserMetadata* _tmp79_;
		gchar* _tmp80_;
		_tmp79_ = ns_metadata;
		_tmp80_ = vala_gir_parser_metadata_get_string (_tmp79_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX);
		_g_free0 (cprefix);
		cprefix = _tmp80_;
	}
	_tmp81_ = ns_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp81_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX)) {
		ValaGirParserMetadata* _tmp82_;
		gchar* _tmp83_;
		_tmp82_ = ns_metadata;
		_tmp83_ = vala_gir_parser_metadata_get_string (_tmp82_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX);
		_g_free0 (lower_case_cprefix);
		lower_case_cprefix = _tmp83_;
	} else {
		const gchar* _tmp84_;
		_tmp84_ = lower_case_cprefix;
		if (_tmp84_ != NULL) {
			const gchar* _tmp85_;
			gchar* _tmp86_;
			_tmp85_ = lower_case_cprefix;
			_tmp86_ = g_strconcat (_tmp85_, "_", NULL);
			_g_free0 (lower_case_cprefix);
			lower_case_cprefix = _tmp86_;
		}
	}
	_tmp87_ = ns;
	_tmp88_ = gir_namespace;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp87_, "CCode", "gir_namespace", _tmp88_, NULL);
	_tmp89_ = ns;
	_tmp90_ = gir_version;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp89_, "CCode", "gir_version", _tmp90_, NULL);
	_tmp91_ = cprefix;
	if (_tmp91_ != NULL) {
		ValaNamespace* _tmp92_;
		const gchar* _tmp93_;
		const gchar* _tmp94_;
		_tmp92_ = ns;
		_tmp93_ = cprefix;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp92_, "CCode", "cprefix", _tmp93_, NULL);
		_tmp94_ = lower_case_cprefix;
		if (_tmp94_ == NULL) {
			ValaNamespace* _tmp95_;
			const gchar* _tmp96_;
			gchar* _tmp97_;
			gchar* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			_tmp95_ = ns;
			_tmp96_ = cprefix;
			_tmp97_ = vala_symbol_camel_case_to_lower_case (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp99_ = g_strconcat (_tmp98_, "_", NULL);
			_tmp100_ = _tmp99_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp95_, "CCode", "lower_case_cprefix", _tmp100_, NULL);
			_g_free0 (_tmp100_);
			_g_free0 (_tmp98_);
		}
	}
	_tmp101_ = lower_case_cprefix;
	if (_tmp101_ != NULL) {
		ValaNamespace* _tmp102_;
		const gchar* _tmp103_;
		_tmp102_ = ns;
		_tmp103_ = lower_case_cprefix;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp102_, "CCode", "lower_case_cprefix", _tmp103_, NULL);
	}
	_tmp104_ = self->priv->cheader_filenames;
	_tmp104__length1 = self->priv->cheader_filenames_length1;
	if (_tmp104_ != NULL) {
		ValaNamespace* _tmp105_;
		gchar** _tmp106_;
		gint _tmp106__length1;
		gchar* _tmp107_;
		gchar* _tmp108_;
		_tmp105_ = ns;
		_tmp106_ = self->priv->cheader_filenames;
		_tmp106__length1 = self->priv->cheader_filenames_length1;
		_tmp107_ = _vala_g_strjoinv (",", _tmp106_, (gint) _tmp106__length1);
		_tmp108_ = _tmp107_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp105_, "CCode", "cheader_filename", _tmp108_, NULL);
		_g_free0 (_tmp108_);
	}
	vala_gir_parser_next (self);
	while (TRUE) {
		ValaMarkupTokenType _tmp109_;
		ValaMarkupReader* _tmp110_;
		const gchar* _tmp111_;
		const gchar* _tmp112_;
		_tmp109_ = self->priv->current_token;
		if (!(_tmp109_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp110_ = self->priv->reader;
		_tmp111_ = vala_markup_reader_get_name (_tmp110_);
		_tmp112_ = _tmp111_;
		if (g_strcmp0 (_tmp112_, "alias") == 0) {
			vala_gir_parser_parse_alias (self);
		} else {
			ValaMarkupReader* _tmp113_;
			const gchar* _tmp114_;
			const gchar* _tmp115_;
			_tmp113_ = self->priv->reader;
			_tmp114_ = vala_markup_reader_get_name (_tmp113_);
			_tmp115_ = _tmp114_;
			if (g_strcmp0 (_tmp115_, "enumeration") == 0) {
				ValaGirParserMetadata* _tmp116_;
				_tmp116_ = self->priv->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp116_, VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN)) {
					ValaGirParserMetadata* _tmp117_;
					_tmp117_ = self->priv->metadata;
					if (vala_gir_parser_metadata_get_bool (_tmp117_, VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN, FALSE)) {
						vala_gir_parser_parse_error_domain (self);
					} else {
						vala_gir_parser_parse_enumeration (self, "enumeration", FALSE);
					}
				} else {
					gboolean _tmp118_ = FALSE;
					ValaMarkupReader* _tmp119_;
					gchar* _tmp120_;
					gchar* _tmp121_;
					gboolean _tmp122_;
					_tmp119_ = self->priv->reader;
					_tmp120_ = vala_markup_reader_get_attribute (_tmp119_, "glib:error-quark");
					_tmp121_ = _tmp120_;
					_tmp122_ = _tmp121_ != NULL;
					_g_free0 (_tmp121_);
					if (_tmp122_) {
						_tmp118_ = TRUE;
					} else {
						ValaMarkupReader* _tmp123_;
						gchar* _tmp124_;
						gchar* _tmp125_;
						_tmp123_ = self->priv->reader;
						_tmp124_ = vala_markup_reader_get_attribute (_tmp123_, "glib:error-domain");
						_tmp125_ = _tmp124_;
						_tmp118_ = _tmp125_ != NULL;
						_g_free0 (_tmp125_);
					}
					if (_tmp118_) {
						vala_gir_parser_parse_error_domain (self);
					} else {
						vala_gir_parser_parse_enumeration (self, "enumeration", FALSE);
					}
				}
			} else {
				ValaMarkupReader* _tmp126_;
				const gchar* _tmp127_;
				const gchar* _tmp128_;
				_tmp126_ = self->priv->reader;
				_tmp127_ = vala_markup_reader_get_name (_tmp126_);
				_tmp128_ = _tmp127_;
				if (g_strcmp0 (_tmp128_, "bitfield") == 0) {
					vala_gir_parser_parse_bitfield (self);
				} else {
					ValaMarkupReader* _tmp129_;
					const gchar* _tmp130_;
					const gchar* _tmp131_;
					_tmp129_ = self->priv->reader;
					_tmp130_ = vala_markup_reader_get_name (_tmp129_);
					_tmp131_ = _tmp130_;
					if (g_strcmp0 (_tmp131_, "function") == 0) {
						vala_gir_parser_parse_method (self, "function");
					} else {
						ValaMarkupReader* _tmp132_;
						const gchar* _tmp133_;
						const gchar* _tmp134_;
						_tmp132_ = self->priv->reader;
						_tmp133_ = vala_markup_reader_get_name (_tmp132_);
						_tmp134_ = _tmp133_;
						if (g_strcmp0 (_tmp134_, "function-macro") == 0) {
							vala_gir_parser_skip_element (self);
						} else {
							ValaMarkupReader* _tmp135_;
							const gchar* _tmp136_;
							const gchar* _tmp137_;
							_tmp135_ = self->priv->reader;
							_tmp136_ = vala_markup_reader_get_name (_tmp135_);
							_tmp137_ = _tmp136_;
							if (g_strcmp0 (_tmp137_, "callback") == 0) {
								vala_gir_parser_parse_callback (self);
							} else {
								ValaMarkupReader* _tmp138_;
								const gchar* _tmp139_;
								const gchar* _tmp140_;
								_tmp138_ = self->priv->reader;
								_tmp139_ = vala_markup_reader_get_name (_tmp138_);
								_tmp140_ = _tmp139_;
								if (g_strcmp0 (_tmp140_, "record") == 0) {
									ValaGirParserMetadata* _tmp141_;
									_tmp141_ = self->priv->metadata;
									if (vala_gir_parser_metadata_has_argument (_tmp141_, VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT)) {
										ValaGirParserMetadata* _tmp142_;
										_tmp142_ = self->priv->metadata;
										if (vala_gir_parser_metadata_get_bool (_tmp142_, VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT, FALSE)) {
											vala_gir_parser_parse_record (self);
										} else {
											vala_gir_parser_parse_boxed (self, "record");
										}
									} else {
										gchar* _tmp143_;
										gchar* _tmp144_;
										gboolean _tmp145_;
										_tmp143_ = vala_gir_parser_element_get_type_id (self);
										_tmp144_ = _tmp143_;
										_tmp145_ = _tmp144_ != NULL;
										_g_free0 (_tmp144_);
										if (_tmp145_) {
											vala_gir_parser_parse_boxed (self, "record");
										} else {
											ValaMarkupReader* _tmp146_;
											gchar* _tmp147_;
											gchar* _tmp148_;
											gboolean _tmp149_;
											_tmp146_ = self->priv->reader;
											_tmp147_ = vala_markup_reader_get_attribute (_tmp146_, "name");
											_tmp148_ = _tmp147_;
											_tmp149_ = !g_str_has_suffix (_tmp148_, "Private");
											_g_free0 (_tmp148_);
											if (_tmp149_) {
												gboolean _tmp150_ = FALSE;
												ValaMarkupReader* _tmp151_;
												gchar* _tmp152_;
												gchar* _tmp153_;
												gboolean _tmp154_;
												_tmp151_ = self->priv->reader;
												_tmp152_ = vala_markup_reader_get_attribute (_tmp151_, "glib:is-gtype-struct-for");
												_tmp153_ = _tmp152_;
												_tmp154_ = _tmp153_ == NULL;
												_g_free0 (_tmp153_);
												if (_tmp154_) {
													ValaMarkupReader* _tmp155_;
													gchar* _tmp156_;
													gchar* _tmp157_;
													_tmp155_ = self->priv->reader;
													_tmp156_ = vala_markup_reader_get_attribute (_tmp155_, "disguised");
													_tmp157_ = _tmp156_;
													_tmp150_ = g_strcmp0 (_tmp157_, "1") == 0;
													_g_free0 (_tmp157_);
												} else {
													_tmp150_ = FALSE;
												}
												if (_tmp150_) {
													vala_gir_parser_parse_boxed (self, "record");
												} else {
													vala_gir_parser_parse_record (self);
												}
											} else {
												vala_gir_parser_skip_element (self);
											}
										}
									}
								} else {
									ValaMarkupReader* _tmp158_;
									const gchar* _tmp159_;
									const gchar* _tmp160_;
									_tmp158_ = self->priv->reader;
									_tmp159_ = vala_markup_reader_get_name (_tmp158_);
									_tmp160_ = _tmp159_;
									if (g_strcmp0 (_tmp160_, "class") == 0) {
										vala_gir_parser_parse_class (self);
									} else {
										ValaMarkupReader* _tmp161_;
										const gchar* _tmp162_;
										const gchar* _tmp163_;
										_tmp161_ = self->priv->reader;
										_tmp162_ = vala_markup_reader_get_name (_tmp161_);
										_tmp163_ = _tmp162_;
										if (g_strcmp0 (_tmp163_, "interface") == 0) {
											vala_gir_parser_parse_interface (self);
										} else {
											ValaMarkupReader* _tmp164_;
											const gchar* _tmp165_;
											const gchar* _tmp166_;
											_tmp164_ = self->priv->reader;
											_tmp165_ = vala_markup_reader_get_name (_tmp164_);
											_tmp166_ = _tmp165_;
											if (g_strcmp0 (_tmp166_, "glib:boxed") == 0) {
												vala_gir_parser_parse_boxed (self, "glib:boxed");
											} else {
												ValaMarkupReader* _tmp167_;
												const gchar* _tmp168_;
												const gchar* _tmp169_;
												_tmp167_ = self->priv->reader;
												_tmp168_ = vala_markup_reader_get_name (_tmp167_);
												_tmp169_ = _tmp168_;
												if (g_strcmp0 (_tmp169_, "union") == 0) {
													gboolean _tmp170_ = FALSE;
													gchar* _tmp171_;
													gchar* _tmp172_;
													gboolean _tmp173_;
													_tmp171_ = vala_gir_parser_element_get_type_id (self);
													_tmp172_ = _tmp171_;
													_tmp173_ = _tmp172_ != NULL;
													_g_free0 (_tmp172_);
													if (_tmp173_) {
														ValaGirParserMetadata* _tmp174_;
														_tmp174_ = self->priv->metadata;
														_tmp170_ = !vala_gir_parser_metadata_get_bool (_tmp174_, VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT, FALSE);
													} else {
														_tmp170_ = FALSE;
													}
													if (_tmp170_) {
														vala_gir_parser_parse_boxed (self, "union");
													} else {
														vala_gir_parser_parse_union (self);
													}
												} else {
													ValaMarkupReader* _tmp175_;
													const gchar* _tmp176_;
													const gchar* _tmp177_;
													_tmp175_ = self->priv->reader;
													_tmp176_ = vala_markup_reader_get_name (_tmp175_);
													_tmp177_ = _tmp176_;
													if (g_strcmp0 (_tmp177_, "constant") == 0) {
														vala_gir_parser_parse_constant (self);
													} else {
														ValaSourceReference* _tmp178_;
														ValaSourceReference* _tmp179_;
														ValaMarkupReader* _tmp180_;
														const gchar* _tmp181_;
														const gchar* _tmp182_;
														gchar* _tmp183_;
														gchar* _tmp184_;
														_tmp178_ = vala_gir_parser_get_current_src (self);
														_tmp179_ = _tmp178_;
														_tmp180_ = self->priv->reader;
														_tmp181_ = vala_markup_reader_get_name (_tmp180_);
														_tmp182_ = _tmp181_;
														_tmp183_ = g_strdup_printf ("unknown child element `%s' in `namespace'", _tmp182_);
														_tmp184_ = _tmp183_;
														vala_report_error (_tmp179_, _tmp184_);
														_g_free0 (_tmp184_);
														_vala_source_reference_unref0 (_tmp179_);
														vala_gir_parser_skip_element (self);
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "namespace");
	_vala_code_node_unref0 (ns);
	_vala_gir_parser_metadata_unref0 (ns_metadata);
	_g_free0 (metadata_filename);
	_g_free0 (gir_version);
	_g_free0 (gir_namespace);
	_g_free0 (vala_namespace);
	_g_free0 (lower_case_cprefix);
	_g_free0 (cprefix);
}

static void
vala_gir_parser_parse_alias (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaGirParserNode* _tmp2_;
	ValaGirComment* _tmp3_;
	gboolean no_array_length = FALSE;
	gboolean array_null_terminated = FALSE;
	ValaGirParserNode* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaGirParserMetadata* _tmp12_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "alias");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	vala_gir_parser_next (self);
	_tmp2_ = self->priv->current;
	_tmp3_ = _tmp2_->comment;
	if (_tmp3_ == NULL) {
		ValaGirParserNode* _tmp4_;
		ValaGirComment* _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = vala_gir_parser_parse_symbol_doc (self);
		_vala_comment_unref0 (_tmp4_->comment);
		_tmp4_->comment = _tmp5_;
	} else {
		ValaGirComment* _tmp6_;
		ValaGirComment* _tmp7_;
		_tmp6_ = vala_gir_parser_parse_symbol_doc (self);
		_tmp7_ = _tmp6_;
		_vala_comment_unref0 (_tmp7_);
	}
	no_array_length = FALSE;
	array_null_terminated = FALSE;
	_tmp8_ = self->priv->current;
	_tmp9_ = vala_gir_parser_parse_type (self, NULL, NULL, TRUE, NULL, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_gir_parser_element_get_type (self, _tmp10_, TRUE, &no_array_length, &array_null_terminated, NULL);
	_vala_code_node_unref0 (_tmp8_->base_type);
	_tmp8_->base_type = _tmp11_;
	_vala_code_node_unref0 (_tmp10_);
	_tmp12_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp12_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE)) {
		ValaGirParserNode* _tmp13_;
		ValaGirParserMetadata* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		ValaGirParserMetadata* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaDataType* _tmp20_;
		_tmp13_ = self->priv->current;
		_tmp14_ = self->priv->metadata;
		_tmp15_ = vala_gir_parser_metadata_get_string (_tmp14_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->metadata;
		_tmp18_ = vala_gir_parser_metadata_get_source_reference (_tmp17_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_gir_parser_parse_type_from_string (self, _tmp16_, TRUE, _tmp19_);
		_vala_code_node_unref0 (_tmp13_->base_type);
		_tmp13_->base_type = _tmp20_;
		_vala_source_reference_unref0 (_tmp19_);
		_g_free0 (_tmp16_);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "alias");
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static void
vala_gir_parser_calculate_common_prefix (ValaGirParser* self,
                                         gchar* * common_prefix,
                                         const gchar* cname)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	if ((*common_prefix) == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (cname);
		_g_free0 (*common_prefix);
		*common_prefix = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			gint _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gchar* _tmp6_;
			_tmp2_ = strlen (*common_prefix);
			_tmp3_ = _tmp2_;
			if (_tmp3_ > 0) {
				_tmp1_ = !g_str_has_suffix (*common_prefix, "_");
			} else {
				_tmp1_ = FALSE;
			}
			if (!_tmp1_) {
				break;
			}
			_tmp4_ = strlen (*common_prefix);
			_tmp5_ = _tmp4_;
			_tmp6_ = string_substring (*common_prefix, (glong) 0, (glong) (_tmp5_ - 1));
			_g_free0 (*common_prefix);
			*common_prefix = _tmp6_;
		}
	} else {
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gchar* _tmp9_;
			if (!(!g_str_has_prefix (cname, *common_prefix))) {
				break;
			}
			_tmp7_ = strlen (*common_prefix);
			_tmp8_ = _tmp7_;
			_tmp9_ = string_substring (*common_prefix, (glong) 0, (glong) (_tmp8_ - 1));
			_g_free0 (*common_prefix);
			*common_prefix = _tmp9_;
		}
	}
	while (TRUE) {
		gboolean _tmp10_ = FALSE;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp21_;
		gint _tmp22_;
		gchar* _tmp23_;
		_tmp11_ = strlen (*common_prefix);
		_tmp12_ = _tmp11_;
		if (_tmp12_ > 0) {
			gboolean _tmp13_ = FALSE;
			if (!g_str_has_suffix (*common_prefix, "_")) {
				_tmp13_ = TRUE;
			} else {
				gboolean _tmp14_ = FALSE;
				gint _tmp15_;
				gint _tmp16_;
				_tmp15_ = strlen (*common_prefix);
				_tmp16_ = _tmp15_;
				if (g_unichar_isdigit (string_get_char (cname, (glong) _tmp16_))) {
					gint _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
					_tmp17_ = strlen (cname);
					_tmp18_ = _tmp17_;
					_tmp19_ = strlen (*common_prefix);
					_tmp20_ = _tmp19_;
					_tmp14_ = (_tmp18_ - _tmp20_) <= 1;
				} else {
					_tmp14_ = FALSE;
				}
				_tmp13_ = _tmp14_;
			}
			_tmp10_ = _tmp13_;
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			break;
		}
		_tmp21_ = strlen (*common_prefix);
		_tmp22_ = _tmp21_;
		_tmp23_ = string_substring (*common_prefix, (glong) 0, (glong) (_tmp22_ - 1));
		_g_free0 (*common_prefix);
		*common_prefix = _tmp23_;
	}
}

static ValaGirComment*
vala_gir_parser_parse_symbol_doc (ValaGirParser* self)
{
	ValaGirComment* comment = NULL;
	ValaGirComment* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	comment = NULL;
	while (TRUE) {
		ValaMarkupTokenType _tmp0_;
		const gchar* reader_name = NULL;
		ValaMarkupReader* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp0_ = self->priv->current_token;
		if (!(_tmp0_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp1_ = self->priv->reader;
		_tmp2_ = vala_markup_reader_get_name (_tmp1_);
		_tmp3_ = _tmp2_;
		reader_name = _tmp3_;
		_tmp4_ = reader_name;
		if (g_strcmp0 (_tmp4_, "doc") == 0) {
			ValaMarkupTokenType _tmp5_;
			vala_gir_parser_start_element (self, "doc");
			vala_gir_parser_next (self);
			_tmp5_ = self->priv->current_token;
			if (_tmp5_ == VALA_MARKUP_TOKEN_TYPE_TEXT) {
				ValaMarkupReader* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				ValaGirParserNode* _tmp9_;
				ValaSourceReference* _tmp10_;
				ValaGirComment* _tmp11_;
				_tmp6_ = self->priv->reader;
				_tmp7_ = vala_markup_reader_get_content (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = self->priv->current;
				_tmp10_ = _tmp9_->source_reference;
				_tmp11_ = vala_gir_comment_new (_tmp8_, _tmp10_);
				_vala_comment_unref0 (comment);
				comment = _tmp11_;
				vala_gir_parser_next (self);
			}
			vala_gir_parser_end_element (self, "doc");
		} else {
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			const gchar* _tmp14_;
			_tmp14_ = reader_name;
			if (g_strcmp0 (_tmp14_, "doc-version") == 0) {
				_tmp13_ = TRUE;
			} else {
				const gchar* _tmp15_;
				_tmp15_ = reader_name;
				_tmp13_ = g_strcmp0 (_tmp15_, "doc-deprecated") == 0;
			}
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				const gchar* _tmp16_;
				_tmp16_ = reader_name;
				_tmp12_ = g_strcmp0 (_tmp16_, "doc-stability") == 0;
			}
			if (_tmp12_) {
				vala_gir_parser_skip_element (self);
			} else {
				const gchar* _tmp17_;
				_tmp17_ = reader_name;
				if (g_strcmp0 (_tmp17_, "source-position") == 0) {
					vala_gir_parser_skip_element (self);
				} else {
					const gchar* _tmp18_;
					_tmp18_ = reader_name;
					if (g_strcmp0 (_tmp18_, "attribute") == 0) {
						vala_gir_parser_skip_element (self);
					} else {
						break;
					}
				}
			}
		}
	}
	result = comment;
	return result;
}

static ValaComment*
vala_gir_parser_parse_doc (ValaGirParser* self)
{
	ValaComment* comment = NULL;
	ValaComment* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	comment = NULL;
	while (TRUE) {
		ValaMarkupTokenType _tmp0_;
		const gchar* reader_name = NULL;
		ValaMarkupReader* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp0_ = self->priv->current_token;
		if (!(_tmp0_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp1_ = self->priv->reader;
		_tmp2_ = vala_markup_reader_get_name (_tmp1_);
		_tmp3_ = _tmp2_;
		reader_name = _tmp3_;
		_tmp4_ = reader_name;
		if (g_strcmp0 (_tmp4_, "doc") == 0) {
			ValaMarkupTokenType _tmp5_;
			vala_gir_parser_start_element (self, "doc");
			vala_gir_parser_next (self);
			_tmp5_ = self->priv->current_token;
			if (_tmp5_ == VALA_MARKUP_TOKEN_TYPE_TEXT) {
				ValaMarkupReader* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				ValaGirParserNode* _tmp9_;
				ValaSourceReference* _tmp10_;
				ValaComment* _tmp11_;
				_tmp6_ = self->priv->reader;
				_tmp7_ = vala_markup_reader_get_content (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = self->priv->current;
				_tmp10_ = _tmp9_->source_reference;
				_tmp11_ = vala_comment_new (_tmp8_, _tmp10_);
				_vala_comment_unref0 (comment);
				comment = _tmp11_;
				vala_gir_parser_next (self);
			}
			vala_gir_parser_end_element (self, "doc");
		} else {
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			const gchar* _tmp14_;
			_tmp14_ = reader_name;
			if (g_strcmp0 (_tmp14_, "doc-version") == 0) {
				_tmp13_ = TRUE;
			} else {
				const gchar* _tmp15_;
				_tmp15_ = reader_name;
				_tmp13_ = g_strcmp0 (_tmp15_, "doc-deprecated") == 0;
			}
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				const gchar* _tmp16_;
				_tmp16_ = reader_name;
				_tmp12_ = g_strcmp0 (_tmp16_, "doc-stability") == 0;
			}
			if (_tmp12_) {
				vala_gir_parser_skip_element (self);
			} else {
				const gchar* _tmp17_;
				_tmp17_ = reader_name;
				if (g_strcmp0 (_tmp17_, "source-position") == 0) {
					vala_gir_parser_skip_element (self);
				} else {
					const gchar* _tmp18_;
					_tmp18_ = reader_name;
					if (g_strcmp0 (_tmp18_, "attribute") == 0) {
						vala_gir_parser_skip_element (self);
					} else {
						break;
					}
				}
			}
		}
	}
	result = comment;
	return result;
}

static void
vala_gir_parser_parse_enumeration (ValaGirParser* self,
                                   const gchar* element_name,
                                   gboolean error_domain)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaSymbol* sym = NULL;
	ValaGirParserNode* _tmp2_;
	ValaSymbol* _tmp23_;
	gchar* common_prefix = NULL;
	gboolean has_member = FALSE;
	ValaSymbol* _tmp24_;
	ValaGirComment* _tmp25_;
	ValaGirComment* _tmp26_;
	const gchar* _tmp56_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_start_element (self, element_name);
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->current;
	if (_tmp2_->new_symbol) {
		ValaGirParserNode* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		if (error_domain) {
			ValaGirParserNode* _tmp3_;
			const gchar* _tmp4_;
			ValaGirParserNode* _tmp5_;
			ValaSourceReference* _tmp6_;
			ValaErrorDomain* _tmp7_;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_->name;
			_tmp5_ = self->priv->current;
			_tmp6_ = _tmp5_->source_reference;
			_tmp7_ = vala_error_domain_new (_tmp4_, _tmp6_, NULL);
			_vala_code_node_unref0 (sym);
			sym = (ValaSymbol*) _tmp7_;
		} else {
			ValaEnum* en = NULL;
			ValaGirParserNode* _tmp8_;
			const gchar* _tmp9_;
			ValaGirParserNode* _tmp10_;
			ValaSourceReference* _tmp11_;
			ValaEnum* _tmp12_;
			ValaEnum* _tmp14_;
			ValaSymbol* _tmp15_;
			_tmp8_ = self->priv->current;
			_tmp9_ = _tmp8_->name;
			_tmp10_ = self->priv->current;
			_tmp11_ = _tmp10_->source_reference;
			_tmp12_ = vala_enum_new (_tmp9_, _tmp11_, NULL);
			en = _tmp12_;
			if (g_strcmp0 (element_name, "bitfield") == 0) {
				ValaEnum* _tmp13_;
				_tmp13_ = en;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp13_, "Flags", TRUE, NULL);
			}
			_tmp14_ = en;
			_tmp15_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp14_);
			_vala_code_node_unref0 (sym);
			sym = _tmp15_;
			_vala_code_node_unref0 (en);
		}
		_tmp16_ = self->priv->current;
		_tmp17_ = sym;
		_tmp18_ = _vala_code_node_ref0 (_tmp17_);
		_vala_code_node_unref0 (_tmp16_->symbol);
		_tmp16_->symbol = _tmp18_;
	} else {
		ValaGirParserNode* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaSymbol* _tmp21_;
		_tmp19_ = self->priv->current;
		_tmp20_ = _tmp19_->symbol;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		_vala_code_node_unref0 (sym);
		sym = _tmp21_;
	}
	if (!error_domain) {
		ValaSymbol* _tmp22_;
		_tmp22_ = sym;
		vala_gir_parser_set_type_id_ccode (self, _tmp22_);
	}
	_tmp23_ = sym;
	vala_symbol_set_access (_tmp23_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	common_prefix = NULL;
	has_member = FALSE;
	vala_gir_parser_next (self);
	_tmp24_ = sym;
	_tmp25_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp26_ = _tmp25_;
	vala_symbol_set_comment (_tmp24_, (ValaComment*) _tmp26_);
	_vala_comment_unref0 (_tmp26_);
	while (TRUE) {
		ValaMarkupTokenType _tmp27_;
		ValaMarkupReader* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		_tmp27_ = self->priv->current_token;
		if (!(_tmp27_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp28_ = self->priv->reader;
		_tmp29_ = vala_markup_reader_get_name (_tmp28_);
		_tmp30_ = _tmp29_;
		if (g_strcmp0 (_tmp30_, "member") == 0) {
			has_member = TRUE;
			if (error_domain) {
				ValaGirParserNode* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				vala_gir_parser_parse_error_member (self);
				_tmp31_ = self->priv->old_current;
				_tmp32_ = vala_gir_parser_node_get_cname (_tmp31_);
				_tmp33_ = _tmp32_;
				vala_gir_parser_calculate_common_prefix (self, &common_prefix, _tmp33_);
				_g_free0 (_tmp33_);
			} else {
				ValaGirParserNode* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				vala_gir_parser_parse_enumeration_member (self);
				_tmp34_ = self->priv->old_current;
				_tmp35_ = vala_gir_parser_node_get_cname (_tmp34_);
				_tmp36_ = _tmp35_;
				vala_gir_parser_calculate_common_prefix (self, &common_prefix, _tmp36_);
				_g_free0 (_tmp36_);
			}
		} else {
			ValaMarkupReader* _tmp37_;
			const gchar* _tmp38_;
			const gchar* _tmp39_;
			_tmp37_ = self->priv->reader;
			_tmp38_ = vala_markup_reader_get_name (_tmp37_);
			_tmp39_ = _tmp38_;
			if (g_strcmp0 (_tmp39_, "function") == 0) {
				vala_gir_parser_skip_element (self);
			} else {
				ValaMarkupReader* _tmp40_;
				const gchar* _tmp41_;
				const gchar* _tmp42_;
				_tmp40_ = self->priv->reader;
				_tmp41_ = vala_markup_reader_get_name (_tmp40_);
				_tmp42_ = _tmp41_;
				if (g_strcmp0 (_tmp42_, "function-macro") == 0) {
					vala_gir_parser_skip_element (self);
				} else {
					ValaSourceReference* _tmp43_;
					ValaSourceReference* _tmp44_;
					ValaMarkupReader* _tmp45_;
					const gchar* _tmp46_;
					const gchar* _tmp47_;
					gchar* _tmp48_;
					gchar* _tmp49_;
					_tmp43_ = vala_gir_parser_get_current_src (self);
					_tmp44_ = _tmp43_;
					_tmp45_ = self->priv->reader;
					_tmp46_ = vala_markup_reader_get_name (_tmp45_);
					_tmp47_ = _tmp46_;
					_tmp48_ = g_strdup_printf ("unknown child element `%s' in `%s'", _tmp47_, element_name);
					_tmp49_ = _tmp48_;
					vala_report_error (_tmp44_, _tmp49_);
					_g_free0 (_tmp49_);
					_vala_source_reference_unref0 (_tmp44_);
					vala_gir_parser_skip_element (self);
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	if (!has_member) {
		ValaSourceReference* _tmp50_;
		ValaSourceReference* _tmp51_;
		ValaGirParserNode* _tmp52_;
		const gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		_tmp50_ = vala_gir_parser_get_current_src (self);
		_tmp51_ = _tmp50_;
		_tmp52_ = self->priv->current;
		_tmp53_ = _tmp52_->name;
		_tmp54_ = g_strdup_printf ("%s `%s' has no members", element_name, _tmp53_);
		_tmp55_ = _tmp54_;
		vala_report_error (_tmp51_, _tmp55_);
		_g_free0 (_tmp55_);
		_vala_source_reference_unref0 (_tmp51_);
	}
	_tmp56_ = common_prefix;
	if (_tmp56_ != NULL) {
		ValaSymbol* _tmp57_;
		const gchar* _tmp58_;
		_tmp57_ = sym;
		_tmp58_ = common_prefix;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp57_, "CCode", "cprefix", _tmp58_, NULL);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, element_name);
	_g_free0 (common_prefix);
	_vala_code_node_unref0 (sym);
}

static void
vala_gir_parser_parse_error_domain (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_enumeration (self, "enumeration", TRUE);
}

static void
vala_gir_parser_parse_bitfield (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_enumeration (self, "bitfield", FALSE);
}

static void
vala_gir_parser_parse_enumeration_member (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaEnumValue* ev = NULL;
	ValaGirParserNode* _tmp6_;
	const gchar* _tmp7_;
	ValaGirParserMetadata* _tmp8_;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaGirParserNode* _tmp11_;
	ValaSourceReference* _tmp12_;
	ValaEnumValue* _tmp13_;
	ValaEnumValue* _tmp14_;
	ValaGirParserNode* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaGirComment* _tmp17_;
	ValaGirComment* _tmp18_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "member");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_ascii_strup (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, "-", "_");
	_tmp5_ = _tmp4_;
	vala_gir_parser_push_node (self, _tmp5_, FALSE);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = self->priv->current;
	_tmp7_ = _tmp6_->name;
	_tmp8_ = self->priv->metadata;
	_tmp9_ = vala_gir_parser_metadata_get_expression (_tmp8_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->current;
	_tmp12_ = _tmp11_->source_reference;
	_tmp13_ = vala_enum_value_new (_tmp7_, _tmp10_, _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_vala_code_node_unref0 (_tmp10_);
	ev = _tmp14_;
	_tmp15_ = self->priv->current;
	_tmp16_ = _vala_code_node_ref0 ((ValaSymbol*) ev);
	_vala_code_node_unref0 (_tmp15_->symbol);
	_tmp15_->symbol = _tmp16_;
	vala_gir_parser_next (self);
	_tmp17_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp18_ = _tmp17_;
	vala_symbol_set_comment ((ValaSymbol*) ev, (ValaComment*) _tmp18_);
	_vala_comment_unref0 (_tmp18_);
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "member");
	_vala_code_node_unref0 (ev);
}

static void
vala_gir_parser_parse_error_member (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaErrorCode* ec = NULL;
	gchar* value = NULL;
	ValaMarkupReader* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	ValaGirParserNode* _tmp18_;
	ValaErrorCode* _tmp19_;
	ValaSymbol* _tmp20_;
	ValaErrorCode* _tmp21_;
	ValaGirComment* _tmp22_;
	ValaGirComment* _tmp23_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "member");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_ascii_strup (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, "-", "_");
	_tmp5_ = _tmp4_;
	vala_gir_parser_push_node (self, _tmp5_, FALSE);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = self->priv->reader;
	_tmp7_ = vala_markup_reader_get_attribute (_tmp6_, "value");
	value = _tmp7_;
	_tmp8_ = value;
	if (_tmp8_ != NULL) {
		ValaGirParserNode* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		ValaIntegerLiteral* _tmp12_;
		ValaIntegerLiteral* _tmp13_;
		ValaErrorCode* _tmp14_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_->name;
		_tmp11_ = value;
		_tmp12_ = vala_integer_literal_new (_tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_error_code_new_with_value (_tmp10_, (ValaExpression*) _tmp13_, NULL);
		_vala_code_node_unref0 (ec);
		ec = _tmp14_;
		_vala_code_node_unref0 (_tmp13_);
	} else {
		ValaGirParserNode* _tmp15_;
		const gchar* _tmp16_;
		ValaErrorCode* _tmp17_;
		_tmp15_ = self->priv->current;
		_tmp16_ = _tmp15_->name;
		_tmp17_ = vala_error_code_new (_tmp16_, NULL, NULL);
		_vala_code_node_unref0 (ec);
		ec = _tmp17_;
	}
	_tmp18_ = self->priv->current;
	_tmp19_ = ec;
	_tmp20_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp19_);
	_vala_code_node_unref0 (_tmp18_->symbol);
	_tmp18_->symbol = _tmp20_;
	vala_gir_parser_next (self);
	_tmp21_ = ec;
	_tmp22_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp23_ = _tmp22_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp21_, (ValaComment*) _tmp23_);
	_vala_comment_unref0 (_tmp23_);
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "member");
	_g_free0 (value);
	_vala_code_node_unref0 (ec);
}

static ValaDataType*
vala_gir_parser_parse_return_value (ValaGirParser* self,
                                    gchar* * ctype,
                                    gint* array_length_idx,
                                    gboolean* no_array_length,
                                    gboolean* array_null_terminated,
                                    ValaComment* * comment)
{
	gchar* _vala_ctype = NULL;
	gint _vala_array_length_idx = 0;
	gboolean _vala_no_array_length = FALSE;
	gboolean _vala_array_null_terminated = FALSE;
	ValaComment* _vala_comment = NULL;
	gchar* transfer = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* nullable = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	gchar* allow_none = NULL;
	ValaMarkupReader* _tmp4_;
	gchar* _tmp5_;
	ValaComment* _tmp6_;
	gboolean transfer_elements = FALSE;
	const gchar* _tmp7_;
	ValaDataType* type = NULL;
	gchar* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	ValaDataType* _tmp12_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	gboolean _tmp17_ = FALSE;
	const gchar* _tmp18_;
	ValaDataType* _tmp21_;
	ValaDataType* _tmp22_;
	ValaDataType* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "return-value");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "transfer-ownership");
	transfer = _tmp1_;
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "nullable");
	nullable = _tmp3_;
	_tmp4_ = self->priv->reader;
	_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "allow-none");
	allow_none = _tmp5_;
	vala_gir_parser_next (self);
	_tmp6_ = vala_gir_parser_parse_doc (self);
	_vala_comment_unref0 (_vala_comment);
	_vala_comment = _tmp6_;
	_tmp7_ = transfer;
	transfer_elements = g_strcmp0 (_tmp7_, "container") != 0;
	_tmp12_ = vala_gir_parser_parse_type (self, &_tmp8_, &_tmp9_, transfer_elements, &_tmp10_, &_tmp11_);
	_g_free0 (_vala_ctype);
	_vala_ctype = _tmp8_;
	_vala_array_length_idx = _tmp9_;
	_vala_no_array_length = _tmp10_;
	_vala_array_null_terminated = _tmp11_;
	type = _tmp12_;
	_tmp14_ = transfer;
	if (g_strcmp0 (_tmp14_, "full") == 0) {
		_tmp13_ = TRUE;
	} else {
		const gchar* _tmp15_;
		_tmp15_ = transfer;
		_tmp13_ = g_strcmp0 (_tmp15_, "container") == 0;
	}
	if (_tmp13_) {
		ValaDataType* _tmp16_;
		_tmp16_ = type;
		vala_data_type_set_value_owned (_tmp16_, TRUE);
	}
	_tmp18_ = nullable;
	if (g_strcmp0 (_tmp18_, "1") == 0) {
		_tmp17_ = TRUE;
	} else {
		const gchar* _tmp19_;
		_tmp19_ = allow_none;
		_tmp17_ = g_strcmp0 (_tmp19_, "1") == 0;
	}
	if (_tmp17_) {
		ValaDataType* _tmp20_;
		_tmp20_ = type;
		vala_data_type_set_nullable (_tmp20_, TRUE);
	}
	_tmp21_ = type;
	_tmp22_ = vala_gir_parser_element_get_type (self, _tmp21_, TRUE, &_vala_no_array_length, &_vala_array_null_terminated, NULL);
	_vala_code_node_unref0 (type);
	type = _tmp22_;
	vala_gir_parser_end_element (self, "return-value");
	result = type;
	_g_free0 (allow_none);
	_g_free0 (nullable);
	_g_free0 (transfer);
	if (ctype) {
		*ctype = _vala_ctype;
	} else {
		_g_free0 (_vala_ctype);
	}
	if (array_length_idx) {
		*array_length_idx = _vala_array_length_idx;
	}
	if (no_array_length) {
		*no_array_length = _vala_no_array_length;
	}
	if (array_null_terminated) {
		*array_null_terminated = _vala_array_null_terminated;
	}
	if (comment) {
		*comment = _vala_comment;
	} else {
		_vala_comment_unref0 (_vala_comment);
	}
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static ValaParameter*
vala_gir_parser_parse_parameter (ValaGirParser* self,
                                 gint* array_length_idx,
                                 gint* closure_idx,
                                 gint* destroy_idx,
                                 gchar* * scope,
                                 ValaComment* * comment,
                                 const gchar* default_name)
{
	gint _vala_array_length_idx = 0;
	gint _vala_closure_idx = 0;
	gint _vala_destroy_idx = 0;
	gchar* _vala_scope = NULL;
	ValaComment* _vala_comment = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_;
	ValaParameter* param = NULL;
	gchar* element_type = NULL;
	ValaMarkupReader* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaMarkupTokenType _tmp6_;
	const gchar* _tmp12_;
	gchar* name = NULL;
	ValaGirParserMetadata* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp18_;
	gchar* direction = NULL;
	ValaGirParserMetadata* _tmp25_;
	gchar* transfer = NULL;
	ValaMarkupReader* _tmp33_;
	gchar* _tmp34_;
	gchar* nullable = NULL;
	ValaMarkupReader* _tmp35_;
	gchar* _tmp36_;
	gchar* allow_none = NULL;
	ValaMarkupReader* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* closure = NULL;
	ValaMarkupReader* _tmp40_;
	gchar* _tmp41_;
	gchar* destroy = NULL;
	ValaMarkupReader* _tmp42_;
	gchar* _tmp43_;
	gboolean _tmp44_ = FALSE;
	const gchar* _tmp45_;
	gboolean _tmp47_ = FALSE;
	const gchar* _tmp48_;
	ValaGirParserMetadata* _tmp50_;
	ValaGirParserMetadata* _tmp52_;
	ValaComment* _tmp54_;
	ValaMarkupReader* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	const gchar* _tmp113_;
	ValaParameter* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->begin;
	begin = _tmp0_;
	_vala_array_length_idx = -1;
	_vala_closure_idx = -1;
	_vala_destroy_idx = -1;
	_tmp1_ = self->priv->reader;
	_tmp2_ = vala_markup_reader_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	element_type = _tmp4_;
	_tmp6_ = self->priv->current_token;
	if (_tmp6_ != VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		_tmp5_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
		_tmp8_ = element_type;
		if (g_strcmp0 (_tmp8_, "parameter") != 0) {
			const gchar* _tmp9_;
			_tmp9_ = element_type;
			_tmp7_ = g_strcmp0 (_tmp9_, "instance-parameter") != 0;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp5_ = _tmp7_;
	}
	if (_tmp5_) {
		ValaSourceReference* _tmp10_;
		ValaSourceReference* _tmp11_;
		_tmp10_ = vala_gir_parser_get_current_src (self);
		_tmp11_ = _tmp10_;
		vala_report_error (_tmp11_, "expected start element of `parameter' or `instance-parameter'");
		_vala_source_reference_unref0 (_tmp11_);
	}
	_tmp12_ = element_type;
	vala_gir_parser_start_element (self, _tmp12_);
	_tmp13_ = self->priv->metadata;
	_tmp14_ = vala_gir_parser_metadata_get_string (_tmp13_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
	name = _tmp14_;
	_tmp15_ = name;
	if (_tmp15_ == NULL) {
		ValaMarkupReader* _tmp16_;
		gchar* _tmp17_;
		_tmp16_ = self->priv->reader;
		_tmp17_ = vala_markup_reader_get_attribute (_tmp16_, "name");
		_g_free0 (name);
		name = _tmp17_;
	}
	_tmp18_ = name;
	if (_tmp18_ == NULL) {
		gchar* _tmp19_;
		_tmp19_ = g_strdup (default_name);
		_g_free0 (name);
		name = _tmp19_;
	} else {
		const gchar* _tmp20_;
		_tmp20_ = name;
		if (string_contains (_tmp20_, "-")) {
			ValaSourceReference* _tmp21_;
			ValaSourceReference* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp21_ = vala_gir_parser_get_current_src (self);
			_tmp22_ = _tmp21_;
			vala_report_warning (_tmp22_, "parameter name contains hyphen");
			_vala_source_reference_unref0 (_tmp22_);
			_tmp23_ = name;
			_tmp24_ = string_replace (_tmp23_, "-", "_");
			_g_free0 (name);
			name = _tmp24_;
		}
	}
	direction = NULL;
	_tmp25_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp25_, VALA_GIR_PARSER_ARGUMENT_TYPE_OUT)) {
		ValaGirParserMetadata* _tmp26_;
		_tmp26_ = self->priv->metadata;
		if (vala_gir_parser_metadata_get_bool (_tmp26_, VALA_GIR_PARSER_ARGUMENT_TYPE_OUT, FALSE)) {
			gchar* _tmp27_;
			_tmp27_ = g_strdup ("out");
			_g_free0 (direction);
			direction = _tmp27_;
		}
	} else {
		ValaGirParserMetadata* _tmp28_;
		_tmp28_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp28_, VALA_GIR_PARSER_ARGUMENT_TYPE_REF)) {
			ValaGirParserMetadata* _tmp29_;
			_tmp29_ = self->priv->metadata;
			if (vala_gir_parser_metadata_get_bool (_tmp29_, VALA_GIR_PARSER_ARGUMENT_TYPE_REF, FALSE)) {
				gchar* _tmp30_;
				_tmp30_ = g_strdup ("inout");
				_g_free0 (direction);
				direction = _tmp30_;
			}
		} else {
			ValaMarkupReader* _tmp31_;
			gchar* _tmp32_;
			_tmp31_ = self->priv->reader;
			_tmp32_ = vala_markup_reader_get_attribute (_tmp31_, "direction");
			_g_free0 (direction);
			direction = _tmp32_;
		}
	}
	_tmp33_ = self->priv->reader;
	_tmp34_ = vala_markup_reader_get_attribute (_tmp33_, "transfer-ownership");
	transfer = _tmp34_;
	_tmp35_ = self->priv->reader;
	_tmp36_ = vala_markup_reader_get_attribute (_tmp35_, "nullable");
	nullable = _tmp36_;
	_tmp37_ = self->priv->reader;
	_tmp38_ = vala_markup_reader_get_attribute (_tmp37_, "allow-none");
	allow_none = _tmp38_;
	_tmp39_ = vala_gir_parser_element_get_string (self, "scope", VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE);
	_g_free0 (_vala_scope);
	_vala_scope = _tmp39_;
	_tmp40_ = self->priv->reader;
	_tmp41_ = vala_markup_reader_get_attribute (_tmp40_, "closure");
	closure = _tmp41_;
	_tmp42_ = self->priv->reader;
	_tmp43_ = vala_markup_reader_get_attribute (_tmp42_, "destroy");
	destroy = _tmp43_;
	_tmp45_ = closure;
	if (_tmp45_ != NULL) {
		_tmp44_ = (&_vala_closure_idx) != NULL;
	} else {
		_tmp44_ = FALSE;
	}
	if (_tmp44_) {
		const gchar* _tmp46_;
		_tmp46_ = closure;
		_vala_closure_idx = atoi (_tmp46_);
	}
	_tmp48_ = destroy;
	if (_tmp48_ != NULL) {
		_tmp47_ = (&_vala_destroy_idx) != NULL;
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		const gchar* _tmp49_;
		_tmp49_ = destroy;
		_vala_destroy_idx = atoi (_tmp49_);
	}
	_tmp50_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp50_, VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE)) {
		ValaGirParserMetadata* _tmp51_;
		_tmp51_ = self->priv->metadata;
		_vala_closure_idx = vala_gir_parser_metadata_get_integer (_tmp51_, VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE);
	}
	_tmp52_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp52_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY)) {
		ValaGirParserMetadata* _tmp53_;
		_tmp53_ = self->priv->metadata;
		_vala_destroy_idx = vala_gir_parser_metadata_get_integer (_tmp53_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY);
	}
	vala_gir_parser_next (self);
	_tmp54_ = vala_gir_parser_parse_doc (self);
	_vala_comment_unref0 (_vala_comment);
	_vala_comment = _tmp54_;
	_tmp55_ = self->priv->reader;
	_tmp56_ = vala_markup_reader_get_name (_tmp55_);
	_tmp57_ = _tmp56_;
	if (g_strcmp0 (_tmp57_, "varargs") == 0) {
		ValaSourceLocation _tmp58_;
		ValaSourceReference* _tmp59_;
		ValaSourceReference* _tmp60_;
		ValaParameter* _tmp61_;
		vala_gir_parser_start_element (self, "varargs");
		vala_gir_parser_next (self);
		_tmp58_ = begin;
		_tmp59_ = vala_gir_parser_get_src (self, &_tmp58_, NULL);
		_tmp60_ = _tmp59_;
		_tmp61_ = vala_parameter_new_with_ellipsis (_tmp60_);
		_vala_code_node_unref0 (param);
		param = _tmp61_;
		_vala_source_reference_unref0 (_tmp60_);
		vala_gir_parser_end_element (self, "varargs");
	} else {
		gchar* ctype = NULL;
		gboolean no_array_length = FALSE;
		gboolean array_null_terminated = FALSE;
		ValaDataType* type = NULL;
		const gchar* _tmp62_;
		gchar* _tmp63_ = NULL;
		gint _tmp64_ = 0;
		gboolean _tmp65_ = FALSE;
		gboolean _tmp66_ = FALSE;
		ValaDataType* _tmp67_;
		gboolean _tmp68_ = FALSE;
		gboolean _tmp69_ = FALSE;
		const gchar* _tmp70_;
		gboolean _tmp74_ = FALSE;
		const gchar* _tmp75_;
		gboolean changed = FALSE;
		gboolean _tmp80_ = FALSE;
		const gchar* _tmp81_;
		ValaDataType* _tmp83_;
		gboolean _tmp84_ = FALSE;
		ValaDataType* _tmp85_;
		const gchar* _tmp86_;
		ValaDataType* _tmp87_;
		ValaSourceLocation _tmp88_;
		ValaSourceReference* _tmp89_;
		ValaSourceReference* _tmp90_;
		ValaParameter* _tmp91_;
		const gchar* _tmp92_;
		const gchar* _tmp95_;
		ValaDataType* _tmp99_;
		ValaParameter* _tmp105_;
		ValaGirParserMetadata* _tmp106_;
		ValaExpression* _tmp107_;
		ValaExpression* _tmp108_;
		ValaParameter* _tmp109_;
		ValaExpression* _tmp110_;
		ValaExpression* _tmp111_;
		_tmp62_ = transfer;
		_tmp67_ = vala_gir_parser_parse_type (self, &_tmp63_, &_tmp64_, g_strcmp0 (_tmp62_, "container") != 0, &_tmp65_, &_tmp66_);
		_g_free0 (ctype);
		ctype = _tmp63_;
		_vala_array_length_idx = _tmp64_;
		no_array_length = _tmp65_;
		array_null_terminated = _tmp66_;
		type = _tmp67_;
		_tmp70_ = transfer;
		if (g_strcmp0 (_tmp70_, "full") == 0) {
			_tmp69_ = TRUE;
		} else {
			const gchar* _tmp71_;
			_tmp71_ = transfer;
			_tmp69_ = g_strcmp0 (_tmp71_, "container") == 0;
		}
		if (_tmp69_) {
			_tmp68_ = TRUE;
		} else {
			const gchar* _tmp72_;
			_tmp72_ = destroy;
			_tmp68_ = _tmp72_ != NULL;
		}
		if (_tmp68_) {
			ValaDataType* _tmp73_;
			_tmp73_ = type;
			vala_data_type_set_value_owned (_tmp73_, TRUE);
		}
		_tmp75_ = nullable;
		if (g_strcmp0 (_tmp75_, "1") == 0) {
			_tmp74_ = TRUE;
		} else {
			gboolean _tmp76_ = FALSE;
			const gchar* _tmp77_;
			_tmp77_ = allow_none;
			if (g_strcmp0 (_tmp77_, "1") == 0) {
				const gchar* _tmp78_;
				_tmp78_ = direction;
				_tmp76_ = g_strcmp0 (_tmp78_, "out") != 0;
			} else {
				_tmp76_ = FALSE;
			}
			_tmp74_ = _tmp76_;
		}
		if (_tmp74_) {
			ValaDataType* _tmp79_;
			_tmp79_ = type;
			vala_data_type_set_nullable (_tmp79_, TRUE);
		}
		_tmp81_ = direction;
		if (g_strcmp0 (_tmp81_, "out") == 0) {
			_tmp80_ = TRUE;
		} else {
			const gchar* _tmp82_;
			_tmp82_ = direction;
			_tmp80_ = g_strcmp0 (_tmp82_, "inout") == 0;
		}
		_tmp83_ = type;
		_tmp85_ = vala_gir_parser_element_get_type (self, _tmp83_, _tmp80_, &no_array_length, &array_null_terminated, &_tmp84_);
		changed = _tmp84_;
		_vala_code_node_unref0 (type);
		type = _tmp85_;
		if (!changed) {
			_g_free0 (ctype);
			ctype = NULL;
		}
		_tmp86_ = name;
		_tmp87_ = type;
		_tmp88_ = begin;
		_tmp89_ = vala_gir_parser_get_src (self, &_tmp88_, NULL);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_parameter_new (_tmp86_, _tmp87_, _tmp90_);
		_vala_code_node_unref0 (param);
		param = _tmp91_;
		_vala_source_reference_unref0 (_tmp90_);
		_tmp92_ = ctype;
		if (_tmp92_ != NULL) {
			ValaParameter* _tmp93_;
			const gchar* _tmp94_;
			_tmp93_ = param;
			_tmp94_ = ctype;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp93_, "CCode", "type", _tmp94_, NULL);
		}
		_tmp95_ = direction;
		if (g_strcmp0 (_tmp95_, "out") == 0) {
			ValaParameter* _tmp96_;
			_tmp96_ = param;
			vala_parameter_set_direction (_tmp96_, VALA_PARAMETER_DIRECTION_OUT);
		} else {
			const gchar* _tmp97_;
			_tmp97_ = direction;
			if (g_strcmp0 (_tmp97_, "inout") == 0) {
				ValaParameter* _tmp98_;
				_tmp98_ = param;
				vala_parameter_set_direction (_tmp98_, VALA_PARAMETER_DIRECTION_REF);
			}
		}
		_tmp99_ = type;
		if (VALA_IS_ARRAY_TYPE (_tmp99_)) {
			ValaGirParserMetadata* _tmp100_;
			_tmp100_ = self->priv->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp100_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX)) {
				ValaGirParserMetadata* _tmp101_;
				_tmp101_ = self->priv->metadata;
				_vala_array_length_idx = vala_gir_parser_metadata_get_integer (_tmp101_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX);
			} else {
				gboolean _tmp102_ = FALSE;
				if (no_array_length) {
					_tmp102_ = TRUE;
				} else {
					_tmp102_ = array_null_terminated;
				}
				if (_tmp102_) {
					ValaParameter* _tmp103_;
					_tmp103_ = param;
					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp103_, "CCode", "array_length", !no_array_length, NULL);
				}
				if (array_null_terminated) {
					ValaParameter* _tmp104_;
					_tmp104_ = param;
					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp104_, "CCode", "array_null_terminated", array_null_terminated, NULL);
				}
			}
		}
		_tmp105_ = param;
		_tmp106_ = self->priv->metadata;
		_tmp107_ = vala_gir_parser_metadata_get_expression (_tmp106_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT);
		_tmp108_ = _tmp107_;
		vala_variable_set_initializer ((ValaVariable*) _tmp105_, _tmp108_);
		_vala_code_node_unref0 (_tmp108_);
		_tmp109_ = param;
		_tmp110_ = vala_variable_get_initializer ((ValaVariable*) _tmp109_);
		_tmp111_ = _tmp110_;
		if (VALA_IS_TUPLE (_tmp111_)) {
			ValaParameter* _tmp112_;
			_tmp112_ = param;
			vala_variable_set_initializer ((ValaVariable*) _tmp112_, NULL);
		}
		_vala_code_node_unref0 (type);
		_g_free0 (ctype);
	}
	_tmp113_ = element_type;
	vala_gir_parser_end_element (self, _tmp113_);
	result = param;
	_g_free0 (destroy);
	_g_free0 (closure);
	_g_free0 (allow_none);
	_g_free0 (nullable);
	_g_free0 (transfer);
	_g_free0 (direction);
	_g_free0 (name);
	_g_free0 (element_type);
	if (array_length_idx) {
		*array_length_idx = _vala_array_length_idx;
	}
	if (closure_idx) {
		*closure_idx = _vala_closure_idx;
	}
	if (destroy_idx) {
		*destroy_idx = _vala_destroy_idx;
	}
	if (scope) {
		*scope = _vala_scope;
	} else {
		_g_free0 (_vala_scope);
	}
	if (comment) {
		*comment = _vala_comment;
	} else {
		_vala_comment_unref0 (_vala_comment);
	}
	return result;
}

static ValaDataType*
vala_gir_parser_parse_type (ValaGirParser* self,
                            gchar* * ctype,
                            gint* array_length_idx,
                            gboolean transfer_elements,
                            gboolean* no_array_length,
                            gboolean* array_null_terminated)
{
	gchar* _vala_ctype = NULL;
	gint _vala_array_length_idx = 0;
	gboolean _vala_no_array_length = FALSE;
	gboolean _vala_array_null_terminated = FALSE;
	gboolean is_array = FALSE;
	gchar* type_name = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gint fixed_length = 0;
	ValaMarkupReader* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaGirParserMetadata* _tmp49_;
	gboolean _tmp54_ = FALSE;
	const gchar* _tmp55_;
	const gchar* _tmp58_;
	ValaDataType* type = NULL;
	const gchar* _tmp61_;
	const gchar* _tmp62_;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	ValaDataType* _tmp65_;
	const gchar* _tmp92_ = NULL;
	ValaDataType* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	is_array = FALSE;
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	type_name = _tmp1_;
	_g_free0 (_vala_ctype);
	_vala_ctype = NULL;
	fixed_length = -1;
	_vala_array_length_idx = -1;
	_vala_no_array_length = TRUE;
	_vala_array_null_terminated = TRUE;
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_name (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp4_, "array") == 0) {
		ValaSourceReference* src = NULL;
		ValaSourceReference* _tmp5_;
		const gchar* _tmp6_;
		is_array = TRUE;
		vala_gir_parser_start_element (self, "array");
		_tmp5_ = vala_gir_parser_get_current_src (self);
		src = _tmp5_;
		_tmp6_ = type_name;
		if (_tmp6_ == NULL) {
			ValaMarkupReader* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gboolean _tmp10_;
			ValaMarkupReader* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gboolean _tmp17_;
			ValaMarkupReader* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gboolean _tmp24_;
			ValaMarkupReader* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gboolean _tmp28_;
			ValaDataType* element_type = NULL;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			ValaArrayType* array_type = NULL;
			ValaDataType* _tmp34_;
			ValaSourceReference* _tmp35_;
			ValaArrayType* _tmp36_;
			_tmp7_ = self->priv->reader;
			_tmp8_ = vala_markup_reader_get_attribute (_tmp7_, "length");
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_ != NULL;
			_g_free0 (_tmp9_);
			if (_tmp10_) {
				ValaMarkupReader* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp11_ = self->priv->reader;
				_tmp12_ = vala_markup_reader_get_attribute (_tmp11_, "length");
				_tmp13_ = _tmp12_;
				_vala_array_length_idx = atoi (_tmp13_);
				_g_free0 (_tmp13_);
				_vala_no_array_length = FALSE;
				_vala_array_null_terminated = FALSE;
			}
			_tmp14_ = self->priv->reader;
			_tmp15_ = vala_markup_reader_get_attribute (_tmp14_, "fixed-size");
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_ != NULL;
			_g_free0 (_tmp16_);
			if (_tmp17_) {
				ValaMarkupReader* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp18_ = self->priv->reader;
				_tmp19_ = vala_markup_reader_get_attribute (_tmp18_, "fixed-size");
				_tmp20_ = _tmp19_;
				fixed_length = atoi (_tmp20_);
				_g_free0 (_tmp20_);
				_vala_array_null_terminated = FALSE;
			}
			_tmp21_ = self->priv->reader;
			_tmp22_ = vala_markup_reader_get_attribute (_tmp21_, "c:type");
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strcmp0 (_tmp23_, "GStrv") == 0;
			_g_free0 (_tmp23_);
			if (_tmp24_) {
				_vala_no_array_length = TRUE;
				_vala_array_null_terminated = TRUE;
			}
			_tmp25_ = self->priv->reader;
			_tmp26_ = vala_markup_reader_get_attribute (_tmp25_, "zero-terminated");
			_tmp27_ = _tmp26_;
			_tmp28_ = _tmp27_ != NULL;
			_g_free0 (_tmp27_);
			if (_tmp28_) {
				ValaMarkupReader* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp29_ = self->priv->reader;
				_tmp30_ = vala_markup_reader_get_attribute (_tmp29_, "zero-terminated");
				_tmp31_ = _tmp30_;
				_vala_array_null_terminated = atoi (_tmp31_) != 0;
				_g_free0 (_tmp31_);
			}
			vala_gir_parser_next (self);
			_tmp32_ = vala_gir_parser_parse_type (self, NULL, NULL, TRUE, NULL, NULL);
			element_type = _tmp32_;
			_tmp33_ = element_type;
			vala_data_type_set_value_owned (_tmp33_, transfer_elements);
			vala_gir_parser_end_element (self, "array");
			_tmp34_ = element_type;
			_tmp35_ = src;
			_tmp36_ = vala_array_type_new (_tmp34_, 1, _tmp35_);
			array_type = _tmp36_;
			if (fixed_length > 0) {
				ValaArrayType* _tmp37_;
				ValaArrayType* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				ValaIntegerLiteral* _tmp41_;
				ValaIntegerLiteral* _tmp42_;
				_tmp37_ = array_type;
				vala_array_type_set_fixed_length (_tmp37_, TRUE);
				_tmp38_ = array_type;
				_tmp39_ = g_strdup_printf ("%i", fixed_length);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_integer_literal_new (_tmp40_, NULL);
				_tmp42_ = _tmp41_;
				vala_array_type_set_length (_tmp38_, (ValaExpression*) _tmp42_);
				_vala_code_node_unref0 (_tmp42_);
				_g_free0 (_tmp40_);
			}
			result = (ValaDataType*) array_type;
			_vala_code_node_unref0 (element_type);
			_vala_source_reference_unref0 (src);
			_g_free0 (type_name);
			if (ctype) {
				*ctype = _vala_ctype;
			} else {
				_g_free0 (_vala_ctype);
			}
			if (array_length_idx) {
				*array_length_idx = _vala_array_length_idx;
			}
			if (no_array_length) {
				*no_array_length = _vala_no_array_length;
			}
			if (array_null_terminated) {
				*array_null_terminated = _vala_array_null_terminated;
			}
			return result;
		}
		_vala_source_reference_unref0 (src);
	} else {
		ValaMarkupReader* _tmp43_;
		const gchar* _tmp44_;
		const gchar* _tmp45_;
		_tmp43_ = self->priv->reader;
		_tmp44_ = vala_markup_reader_get_name (_tmp43_);
		_tmp45_ = _tmp44_;
		if (g_strcmp0 (_tmp45_, "callback") == 0) {
			ValaGirParserNode* _tmp46_;
			ValaSymbol* _tmp47_;
			ValaDelegateType* _tmp48_;
			vala_gir_parser_parse_callback (self);
			_tmp46_ = self->priv->old_current;
			_tmp47_ = _tmp46_->symbol;
			_tmp48_ = vala_delegate_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_DELEGATE, ValaDelegate));
			result = (ValaDataType*) _tmp48_;
			_g_free0 (type_name);
			if (ctype) {
				*ctype = _vala_ctype;
			} else {
				_g_free0 (_vala_ctype);
			}
			if (array_length_idx) {
				*array_length_idx = _vala_array_length_idx;
			}
			if (no_array_length) {
				*no_array_length = _vala_no_array_length;
			}
			if (array_null_terminated) {
				*array_null_terminated = _vala_array_null_terminated;
			}
			return result;
		} else {
			vala_gir_parser_start_element (self, "type");
		}
	}
	_tmp49_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp49_, VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE)) {
		ValaGirParserMetadata* _tmp50_;
		gchar* _tmp51_;
		_tmp50_ = self->priv->metadata;
		_tmp51_ = vala_gir_parser_metadata_get_string (_tmp50_, VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE);
		_g_free0 (_vala_ctype);
		_vala_ctype = _tmp51_;
	} else {
		ValaMarkupReader* _tmp52_;
		gchar* _tmp53_;
		_tmp52_ = self->priv->reader;
		_tmp53_ = vala_markup_reader_get_attribute (_tmp52_, "c:type");
		_g_free0 (_vala_ctype);
		_vala_ctype = _tmp53_;
	}
	vala_gir_parser_next (self);
	_tmp55_ = type_name;
	if (g_strcmp0 (_tmp55_, "GLib.PtrArray") == 0) {
		ValaMarkupTokenType _tmp56_;
		_tmp56_ = self->priv->current_token;
		_tmp54_ = _tmp56_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT;
	} else {
		_tmp54_ = FALSE;
	}
	if (_tmp54_) {
		gchar* _tmp57_;
		_tmp57_ = g_strdup ("GLib.GenericArray");
		_g_free0 (type_name);
		type_name = _tmp57_;
	}
	_tmp58_ = type_name;
	if (_tmp58_ == NULL) {
		const gchar* _tmp59_;
		gchar* _tmp60_;
		_tmp59_ = _vala_ctype;
		_tmp60_ = g_strdup (_tmp59_);
		_g_free0 (type_name);
		type_name = _tmp60_;
	}
	_tmp61_ = type_name;
	_tmp62_ = _vala_ctype;
	_tmp65_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp61_, &_tmp63_, &_tmp64_, _tmp62_);
	_vala_no_array_length = _tmp63_;
	_vala_array_null_terminated = _tmp64_;
	type = _tmp65_;
	while (TRUE) {
		ValaMarkupTokenType _tmp66_;
		const gchar* _tmp67_;
		ValaDataType* element_type = NULL;
		ValaDataType* _tmp68_;
		ValaDataType* _tmp69_;
		ValaDataType* _tmp70_;
		ValaDataType* _tmp71_;
		ValaDataType* _tmp72_;
		_tmp66_ = self->priv->current_token;
		if (!(_tmp66_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp67_ = type_name;
		if (g_strcmp0 (_tmp67_, "GLib.ByteArray") == 0) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp68_ = vala_gir_parser_parse_type (self, NULL, NULL, TRUE, NULL, NULL);
		element_type = _tmp68_;
		_tmp69_ = element_type;
		vala_data_type_set_value_owned (_tmp69_, transfer_elements);
		_tmp70_ = type;
		_tmp71_ = element_type;
		vala_data_type_add_type_argument (_tmp70_, _tmp71_);
		_tmp72_ = element_type;
		if (VALA_IS_UNRESOLVED_TYPE (_tmp72_)) {
			ValaGirParserNode* _tmp73_ = NULL;
			ValaGirParserNode* _tmp74_;
			ValaGirParserNode* parent = NULL;
			ValaGirParserNode* _tmp76_;
			ValaHashMap* _tmp89_;
			ValaDataType* _tmp90_;
			ValaGirParserNode* _tmp91_;
			_tmp74_ = self->priv->current;
			_tmp73_ = _tmp74_;
			if (_tmp73_ == NULL) {
				ValaGirParserNode* _tmp75_;
				_tmp75_ = self->priv->root;
				_tmp73_ = _tmp75_;
			}
			_tmp76_ = _vala_gir_parser_node_ref0 (_tmp73_);
			parent = _tmp76_;
			while (TRUE) {
				gboolean _tmp77_ = FALSE;
				gboolean _tmp78_ = FALSE;
				ValaGirParserNode* _tmp79_;
				ValaGirParserNode* _tmp80_;
				ValaGirParserNode* _tmp86_;
				ValaGirParserNode* _tmp87_;
				ValaGirParserNode* _tmp88_;
				_tmp79_ = parent;
				_tmp80_ = self->priv->root;
				if (_tmp79_ != _tmp80_) {
					ValaGirParserNode* _tmp81_;
					ValaGirParserNode* _tmp82_;
					_tmp81_ = parent;
					_tmp82_ = _tmp81_->parent;
					_tmp78_ = _tmp82_ != NULL;
				} else {
					_tmp78_ = FALSE;
				}
				if (_tmp78_) {
					ValaGirParserNode* _tmp83_;
					ValaGirParserNode* _tmp84_;
					ValaGirParserNode* _tmp85_;
					_tmp83_ = parent;
					_tmp84_ = _tmp83_->parent;
					_tmp85_ = self->priv->root;
					_tmp77_ = _tmp84_ != _tmp85_;
				} else {
					_tmp77_ = FALSE;
				}
				if (!_tmp77_) {
					break;
				}
				_tmp86_ = parent;
				_tmp87_ = _tmp86_->parent;
				_tmp88_ = _vala_gir_parser_node_ref0 (_tmp87_);
				_vala_gir_parser_node_unref0 (parent);
				parent = _tmp88_;
			}
			_tmp89_ = self->priv->unresolved_type_arguments;
			_tmp90_ = element_type;
			_tmp91_ = parent;
			vala_map_set ((ValaMap*) _tmp89_, G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType), _tmp91_);
			_vala_gir_parser_node_unref0 (parent);
		}
		_vala_code_node_unref0 (element_type);
	}
	if (is_array) {
		_tmp92_ = "array";
	} else {
		_tmp92_ = "type";
	}
	vala_gir_parser_end_element (self, _tmp92_);
	result = type;
	_g_free0 (type_name);
	if (ctype) {
		*ctype = _vala_ctype;
	} else {
		_g_free0 (_vala_ctype);
	}
	if (array_length_idx) {
		*array_length_idx = _vala_array_length_idx;
	}
	if (no_array_length) {
		*no_array_length = _vala_no_array_length;
	}
	if (array_null_terminated) {
		*array_null_terminated = _vala_array_null_terminated;
	}
	return result;
}

static ValaDataType*
vala_gir_parser_parse_type_from_gir_name (ValaGirParser* self,
                                          const gchar* type_name,
                                          gboolean* no_array_length,
                                          gboolean* array_null_terminated,
                                          const gchar* ctype)
{
	gboolean _vala_no_array_length = FALSE;
	gboolean _vala_array_null_terminated = FALSE;
	ValaDataType* type = NULL;
	ValaDataType* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	_vala_no_array_length = FALSE;
	_vala_array_null_terminated = FALSE;
	type = NULL;
	if (g_strcmp0 (type_name, "none") == 0) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		ValaVoidType* _tmp2_;
		_tmp0_ = vala_gir_parser_get_current_src (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_void_type_new (_tmp1_);
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp2_;
		_vala_source_reference_unref0 (_tmp1_);
	} else {
		if (g_strcmp0 (type_name, "gpointer") == 0) {
			ValaSourceReference* _tmp3_;
			ValaSourceReference* _tmp4_;
			ValaVoidType* _tmp5_;
			ValaVoidType* _tmp6_;
			ValaSourceReference* _tmp7_;
			ValaSourceReference* _tmp8_;
			ValaPointerType* _tmp9_;
			_tmp3_ = vala_gir_parser_get_current_src (self);
			_tmp4_ = _tmp3_;
			_tmp5_ = vala_void_type_new (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_gir_parser_get_current_src (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_pointer_type_new ((ValaDataType*) _tmp6_, _tmp8_);
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp9_;
			_vala_source_reference_unref0 (_tmp8_);
			_vala_code_node_unref0 (_tmp6_);
			_vala_source_reference_unref0 (_tmp4_);
		} else {
			if (g_strcmp0 (type_name, "GObject.Strv") == 0) {
				ValaUnresolvedType* element_type = NULL;
				ValaUnresolvedSymbol* _tmp10_;
				ValaUnresolvedSymbol* _tmp11_;
				ValaUnresolvedType* _tmp12_;
				ValaUnresolvedType* _tmp13_;
				ValaUnresolvedType* _tmp14_;
				ValaUnresolvedType* _tmp15_;
				ValaSourceReference* _tmp16_;
				ValaSourceReference* _tmp17_;
				ValaArrayType* _tmp18_;
				_tmp10_ = vala_unresolved_symbol_new (NULL, "string", NULL);
				_tmp11_ = _tmp10_;
				_tmp12_ = vala_unresolved_type_new_from_symbol (_tmp11_, NULL);
				_tmp13_ = _tmp12_;
				_vala_code_node_unref0 (_tmp11_);
				element_type = _tmp13_;
				_tmp14_ = element_type;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp14_, TRUE);
				_tmp15_ = element_type;
				_tmp16_ = vala_gir_parser_get_current_src (self);
				_tmp17_ = _tmp16_;
				_tmp18_ = vala_array_type_new ((ValaDataType*) _tmp15_, 1, _tmp17_);
				_vala_code_node_unref0 (type);
				type = (ValaDataType*) _tmp18_;
				_vala_source_reference_unref0 (_tmp17_);
				_vala_no_array_length = TRUE;
				_vala_array_null_terminated = TRUE;
				_vala_code_node_unref0 (element_type);
			} else {
				gboolean known_type = FALSE;
				ValaDataType* _tmp31_;
				known_type = TRUE;
				if (g_strcmp0 (type_name, "utf8") == 0) {
					type_name = "string";
				} else {
					if (g_strcmp0 (type_name, "gboolean") == 0) {
						ValaCodeContext* _tmp19_;
						ValaNamespace* _tmp20_;
						ValaNamespace* _tmp21_;
						ValaScope* _tmp22_;
						ValaScope* _tmp23_;
						ValaSymbol* _tmp24_;
						ValaStruct* _tmp25_;
						ValaBooleanType* _tmp26_;
						_tmp19_ = self->priv->context;
						_tmp20_ = vala_code_context_get_root (_tmp19_);
						_tmp21_ = _tmp20_;
						_tmp22_ = vala_symbol_get_scope ((ValaSymbol*) _tmp21_);
						_tmp23_ = _tmp22_;
						_tmp24_ = vala_scope_lookup (_tmp23_, "bool");
						_tmp25_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, VALA_TYPE_STRUCT, ValaStruct);
						_tmp26_ = vala_boolean_type_new (_tmp25_);
						_vala_code_node_unref0 (type);
						type = (ValaDataType*) _tmp26_;
						_vala_code_node_unref0 (_tmp25_);
					} else {
						if (g_strcmp0 (type_name, "gchar") == 0) {
							type_name = "char";
						} else {
							if (g_strcmp0 (type_name, "gshort") == 0) {
								type_name = "short";
							} else {
								if (g_strcmp0 (type_name, "gushort") == 0) {
									type_name = "ushort";
								} else {
									if (g_strcmp0 (type_name, "gint") == 0) {
										type_name = "int";
									} else {
										if (g_strcmp0 (type_name, "guint") == 0) {
											type_name = "uint";
										} else {
											if (g_strcmp0 (type_name, "glong") == 0) {
												gboolean _tmp27_ = FALSE;
												if (ctype != NULL) {
													_tmp27_ = g_str_has_prefix (ctype, "gssize");
												} else {
													_tmp27_ = FALSE;
												}
												if (_tmp27_) {
													type_name = "ssize_t";
												} else {
													gboolean _tmp28_ = FALSE;
													if (ctype != NULL) {
														_tmp28_ = g_str_has_prefix (ctype, "gintptr");
													} else {
														_tmp28_ = FALSE;
													}
													if (_tmp28_) {
														type_name = "intptr";
													} else {
														type_name = "long";
													}
												}
											} else {
												if (g_strcmp0 (type_name, "gulong") == 0) {
													gboolean _tmp29_ = FALSE;
													if (ctype != NULL) {
														_tmp29_ = g_str_has_prefix (ctype, "gsize");
													} else {
														_tmp29_ = FALSE;
													}
													if (_tmp29_) {
														type_name = "size_t";
													} else {
														gboolean _tmp30_ = FALSE;
														if (ctype != NULL) {
															_tmp30_ = g_str_has_prefix (ctype, "guintptr");
														} else {
															_tmp30_ = FALSE;
														}
														if (_tmp30_) {
															type_name = "uintptr";
														} else {
															type_name = "ulong";
														}
													}
												} else {
													if (g_strcmp0 (type_name, "gint8") == 0) {
														type_name = "int8";
													} else {
														if (g_strcmp0 (type_name, "guint8") == 0) {
															type_name = "uint8";
														} else {
															if (g_strcmp0 (type_name, "gint16") == 0) {
																type_name = "int16";
															} else {
																if (g_strcmp0 (type_name, "guint16") == 0) {
																	type_name = "uint16";
																} else {
																	if (g_strcmp0 (type_name, "gint32") == 0) {
																		type_name = "int32";
																	} else {
																		if (g_strcmp0 (type_name, "guint32") == 0) {
																			type_name = "uint32";
																		} else {
																			if (g_strcmp0 (type_name, "gint64") == 0) {
																				type_name = "int64";
																			} else {
																				if (g_strcmp0 (type_name, "guint64") == 0) {
																					type_name = "uint64";
																				} else {
																					if (g_strcmp0 (type_name, "gfloat") == 0) {
																						type_name = "float";
																					} else {
																						if (g_strcmp0 (type_name, "gdouble") == 0) {
																							type_name = "double";
																						} else {
																							if (g_strcmp0 (type_name, "filename") == 0) {
																								type_name = "string";
																							} else {
																								if (g_strcmp0 (type_name, "GLib.offset") == 0) {
																									type_name = "int64";
																								} else {
																									if (g_strcmp0 (type_name, "gsize") == 0) {
																										type_name = "size_t";
																									} else {
																										if (g_strcmp0 (type_name, "gssize") == 0) {
																											type_name = "ssize_t";
																										} else {
																											if (g_strcmp0 (type_name, "guintptr") == 0) {
																												type_name = "uintptr";
																											} else {
																												if (g_strcmp0 (type_name, "gintptr") == 0) {
																													type_name = "intptr";
																												} else {
																													if (g_strcmp0 (type_name, "GType") == 0) {
																														type_name = "GLib.Type";
																													} else {
																														if (g_strcmp0 (type_name, "GLib.String") == 0) {
																															type_name = "GLib.StringBuilder";
																														} else {
																															if (g_strcmp0 (type_name, "GObject.Class") == 0) {
																																type_name = "GLib.ObjectClass";
																															} else {
																																if (g_strcmp0 (type_name, "gunichar") == 0) {
																																	type_name = "unichar";
																																} else {
																																	if (g_strcmp0 (type_name, "GLib.Data") == 0) {
																																		type_name = "GLib.Datalist";
																																	} else {
																																		if (g_strcmp0 (type_name, "Atk.ImplementorIface") == 0) {
																																			type_name = "Atk.Implementor";
																																		} else {
																																			known_type = FALSE;
																																		}
																																	}
																																}
																															}
																														}
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
				_tmp31_ = type;
				if (_tmp31_ == NULL) {
					ValaUnresolvedSymbol* sym = NULL;
					ValaSourceReference* _tmp32_;
					ValaSourceReference* _tmp33_;
					ValaUnresolvedSymbol* _tmp34_;
					ValaUnresolvedSymbol* _tmp35_;
					ValaUnresolvedSymbol* _tmp36_;
					ValaSourceReference* _tmp37_;
					ValaSourceReference* _tmp38_;
					ValaUnresolvedType* _tmp39_;
					_tmp32_ = vala_gir_parser_get_current_src (self);
					_tmp33_ = _tmp32_;
					_tmp34_ = vala_gir_parser_parse_symbol_from_string (self, type_name, _tmp33_);
					_tmp35_ = _tmp34_;
					_vala_source_reference_unref0 (_tmp33_);
					sym = _tmp35_;
					_tmp36_ = sym;
					_tmp37_ = vala_gir_parser_get_current_src (self);
					_tmp38_ = _tmp37_;
					_tmp39_ = vala_unresolved_type_new_from_symbol (_tmp36_, _tmp38_);
					_vala_code_node_unref0 (type);
					type = (ValaDataType*) _tmp39_;
					_vala_source_reference_unref0 (_tmp38_);
					if (!known_type) {
						ValaArrayList* _tmp40_;
						ValaUnresolvedSymbol* _tmp41_;
						_tmp40_ = self->priv->unresolved_gir_symbols;
						_tmp41_ = sym;
						vala_collection_add ((ValaCollection*) _tmp40_, _tmp41_);
					}
					_vala_code_node_unref0 (sym);
				}
			}
		}
	}
	result = type;
	if (no_array_length) {
		*no_array_length = _vala_no_array_length;
	}
	if (array_null_terminated) {
		*array_null_terminated = _vala_array_null_terminated;
	}
	return result;
}

static void
vala_gir_parser_parse_record (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaStruct* st = NULL;
	gboolean require_copy_free = FALSE;
	ValaGirParserNode* _tmp2_;
	ValaStruct* _tmp14_;
	ValaStruct* _tmp15_;
	ValaStruct* _tmp16_;
	gchar* gtype_struct_for = NULL;
	ValaMarkupReader* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gboolean first_field = FALSE;
	ValaStruct* _tmp28_;
	ValaGirComment* _tmp29_;
	ValaGirComment* _tmp30_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "record");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	require_copy_free = FALSE;
	_tmp2_ = self->priv->current;
	if (_tmp2_->new_symbol) {
		gchar* _tmp3_;
		gchar* _tmp4_;
		ValaGirParserNode* _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaStruct* _tmp7_;
		ValaGirParserNode* _tmp8_;
		ValaStruct* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp3_ = vala_gir_parser_element_get_name (self, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_->source_reference;
		_tmp7_ = vala_struct_new (_tmp4_, _tmp6_, NULL);
		_vala_code_node_unref0 (st);
		st = _tmp7_;
		_g_free0 (_tmp4_);
		_tmp8_ = self->priv->current;
		_tmp9_ = st;
		_tmp10_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp9_);
		_vala_code_node_unref0 (_tmp8_->symbol);
		_tmp8_->symbol = _tmp10_;
	} else {
		ValaGirParserNode* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaStruct* _tmp13_;
		_tmp11_ = self->priv->current;
		_tmp12_ = _tmp11_->symbol;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_STRUCT, ValaStruct));
		_vala_code_node_unref0 (st);
		st = _tmp13_;
	}
	_tmp14_ = st;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp14_);
	_tmp15_ = st;
	require_copy_free = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp15_, "CCode", "type_id");
	_tmp16_ = st;
	vala_symbol_set_access ((ValaSymbol*) _tmp16_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp17_ = self->priv->reader;
	_tmp18_ = vala_markup_reader_get_attribute (_tmp17_, "glib:is-gtype-struct-for");
	gtype_struct_for = _tmp18_;
	_tmp19_ = gtype_struct_for;
	if (_tmp19_ != NULL) {
		ValaGirParserNode* _tmp20_;
		const gchar* _tmp21_;
		ValaGirParserNode* _tmp22_;
		ValaSourceReference* _tmp23_;
		ValaUnresolvedSymbol* _tmp24_;
		ValaArrayList* _tmp25_;
		ValaGirParserNode* _tmp26_;
		ValaUnresolvedSymbol* _tmp27_;
		_tmp20_ = self->priv->current;
		_tmp21_ = gtype_struct_for;
		_tmp22_ = self->priv->current;
		_tmp23_ = _tmp22_->source_reference;
		_tmp24_ = vala_gir_parser_parse_symbol_from_string (self, _tmp21_, _tmp23_);
		_vala_code_node_unref0 (_tmp20_->gtype_struct_for);
		_tmp20_->gtype_struct_for = _tmp24_;
		_tmp25_ = self->priv->unresolved_gir_symbols;
		_tmp26_ = self->priv->current;
		_tmp27_ = _tmp26_->gtype_struct_for;
		vala_collection_add ((ValaCollection*) _tmp25_, _tmp27_);
	}
	first_field = TRUE;
	vala_gir_parser_next (self);
	_tmp28_ = st;
	_tmp29_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp30_ = _tmp29_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp28_, (ValaComment*) _tmp30_);
	_vala_comment_unref0 (_tmp30_);
	while (TRUE) {
		ValaMarkupTokenType _tmp31_;
		ValaMarkupReader* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		_tmp31_ = self->priv->current_token;
		if (!(_tmp31_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			gboolean _tmp32_ = FALSE;
			if (first_field) {
				ValaMarkupReader* _tmp33_;
				const gchar* _tmp34_;
				const gchar* _tmp35_;
				_tmp33_ = self->priv->reader;
				_tmp34_ = vala_markup_reader_get_name (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp32_ = g_strcmp0 (_tmp35_, "field") == 0;
			} else {
				_tmp32_ = FALSE;
			}
			if (_tmp32_) {
				first_field = FALSE;
			}
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp36_ = self->priv->reader;
		_tmp37_ = vala_markup_reader_get_name (_tmp36_);
		_tmp38_ = _tmp37_;
		if (g_strcmp0 (_tmp38_, "field") == 0) {
			gboolean _tmp39_ = FALSE;
			ValaMarkupReader* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gboolean _tmp43_;
			_tmp40_ = self->priv->reader;
			_tmp41_ = vala_markup_reader_get_attribute (_tmp40_, "name");
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strcmp0 (_tmp42_, "priv") != 0;
			_g_free0 (_tmp42_);
			if (_tmp43_) {
				gboolean _tmp44_ = FALSE;
				if (first_field) {
					const gchar* _tmp45_;
					_tmp45_ = gtype_struct_for;
					_tmp44_ = _tmp45_ != NULL;
				} else {
					_tmp44_ = FALSE;
				}
				_tmp39_ = !_tmp44_;
			} else {
				_tmp39_ = FALSE;
			}
			if (_tmp39_) {
				vala_gir_parser_parse_field (self);
			} else {
				vala_gir_parser_skip_element (self);
			}
			first_field = FALSE;
		} else {
			ValaMarkupReader* _tmp46_;
			const gchar* _tmp47_;
			const gchar* _tmp48_;
			_tmp46_ = self->priv->reader;
			_tmp47_ = vala_markup_reader_get_name (_tmp46_);
			_tmp48_ = _tmp47_;
			if (g_strcmp0 (_tmp48_, "constructor") == 0) {
				vala_gir_parser_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp49_;
				const gchar* _tmp50_;
				const gchar* _tmp51_;
				_tmp49_ = self->priv->reader;
				_tmp50_ = vala_markup_reader_get_name (_tmp49_);
				_tmp51_ = _tmp50_;
				if (g_strcmp0 (_tmp51_, "method") == 0) {
					vala_gir_parser_parse_method (self, "method");
				} else {
					ValaMarkupReader* _tmp52_;
					const gchar* _tmp53_;
					const gchar* _tmp54_;
					_tmp52_ = self->priv->reader;
					_tmp53_ = vala_markup_reader_get_name (_tmp52_);
					_tmp54_ = _tmp53_;
					if (g_strcmp0 (_tmp54_, "function") == 0) {
						vala_gir_parser_skip_element (self);
					} else {
						ValaMarkupReader* _tmp55_;
						const gchar* _tmp56_;
						const gchar* _tmp57_;
						_tmp55_ = self->priv->reader;
						_tmp56_ = vala_markup_reader_get_name (_tmp55_);
						_tmp57_ = _tmp56_;
						if (g_strcmp0 (_tmp57_, "function-macro") == 0) {
							vala_gir_parser_skip_element (self);
						} else {
							ValaMarkupReader* _tmp58_;
							const gchar* _tmp59_;
							const gchar* _tmp60_;
							_tmp58_ = self->priv->reader;
							_tmp59_ = vala_markup_reader_get_name (_tmp58_);
							_tmp60_ = _tmp59_;
							if (g_strcmp0 (_tmp60_, "union") == 0) {
								vala_gir_parser_parse_union (self);
							} else {
								ValaSourceReference* _tmp61_;
								ValaSourceReference* _tmp62_;
								ValaMarkupReader* _tmp63_;
								const gchar* _tmp64_;
								const gchar* _tmp65_;
								gchar* _tmp66_;
								gchar* _tmp67_;
								_tmp61_ = vala_gir_parser_get_current_src (self);
								_tmp62_ = _tmp61_;
								_tmp63_ = self->priv->reader;
								_tmp64_ = vala_markup_reader_get_name (_tmp63_);
								_tmp65_ = _tmp64_;
								_tmp66_ = g_strdup_printf ("unknown child element `%s' in `record'", _tmp65_);
								_tmp67_ = _tmp66_;
								vala_report_error (_tmp62_, _tmp67_);
								_g_free0 (_tmp67_);
								_vala_source_reference_unref0 (_tmp62_);
								vala_gir_parser_skip_element (self);
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	if (require_copy_free) {
		ValaStruct* _tmp68_;
		ValaStruct* _tmp69_;
		_tmp68_ = st;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp68_, "CCode", "copy_function", "g_boxed_copy", NULL);
		_tmp69_ = st;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp69_, "CCode", "free_function", "g_boxed_free", NULL);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "record");
	_g_free0 (gtype_struct_for);
	_vala_code_node_unref0 (st);
}

static void
vala_gir_parser_parse_class (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaClass* cl = NULL;
	gchar* parent = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	ValaGirParserNode* _tmp4_;
	ValaClass* _tmp28_;
	ValaClass* _tmp29_;
	ValaClass* _tmp30_;
	ValaGirComment* _tmp31_;
	ValaGirComment* _tmp32_;
	gboolean first_field = FALSE;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "class");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "parent");
	parent = _tmp3_;
	_tmp4_ = self->priv->current;
	if (_tmp4_->new_symbol) {
		ValaGirParserNode* _tmp5_;
		const gchar* _tmp6_;
		ValaGirParserNode* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaClass* _tmp9_;
		ValaClass* _tmp10_;
		ValaGirParserMetadata* _tmp11_;
		ValaMarkupReader* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		ValaClass* _tmp15_;
		ValaGirParserMetadata* _tmp16_;
		const gchar* _tmp17_;
		ValaGirParserNode* _tmp22_;
		ValaClass* _tmp23_;
		ValaSymbol* _tmp24_;
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_->name;
		_tmp7_ = self->priv->current;
		_tmp8_ = _tmp7_->source_reference;
		_tmp9_ = vala_class_new (_tmp6_, _tmp8_, NULL);
		_vala_code_node_unref0 (cl);
		cl = _tmp9_;
		_tmp10_ = cl;
		_tmp11_ = self->priv->metadata;
		_tmp12_ = self->priv->reader;
		_tmp13_ = vala_markup_reader_get_attribute (_tmp12_, "abstract");
		_tmp14_ = _tmp13_;
		vala_class_set_is_abstract (_tmp10_, vala_gir_parser_metadata_get_bool (_tmp11_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, g_strcmp0 (_tmp14_, "1") == 0));
		_g_free0 (_tmp14_);
		_tmp15_ = cl;
		_tmp16_ = self->priv->metadata;
		vala_class_set_is_sealed (_tmp15_, vala_gir_parser_metadata_get_bool (_tmp16_, VALA_GIR_PARSER_ARGUMENT_TYPE_SEALED, FALSE));
		_tmp17_ = parent;
		if (_tmp17_ != NULL) {
			ValaClass* _tmp18_;
			const gchar* _tmp19_;
			ValaDataType* _tmp20_;
			ValaDataType* _tmp21_;
			_tmp18_ = cl;
			_tmp19_ = parent;
			_tmp20_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp19_, NULL, NULL, NULL);
			_tmp21_ = _tmp20_;
			vala_class_add_base_type (_tmp18_, _tmp21_);
			_vala_code_node_unref0 (_tmp21_);
		}
		_tmp22_ = self->priv->current;
		_tmp23_ = cl;
		_tmp24_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp23_);
		_vala_code_node_unref0 (_tmp22_->symbol);
		_tmp22_->symbol = _tmp24_;
	} else {
		ValaGirParserNode* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaClass* _tmp27_;
		_tmp25_ = self->priv->current;
		_tmp26_ = _tmp25_->symbol;
		_tmp27_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALA_TYPE_CLASS, ValaClass));
		_vala_code_node_unref0 (cl);
		cl = _tmp27_;
	}
	_tmp28_ = cl;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp28_);
	_tmp29_ = cl;
	vala_symbol_set_access ((ValaSymbol*) _tmp29_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_gir_parser_next (self);
	_tmp30_ = cl;
	_tmp31_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp32_ = _tmp31_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp30_, (ValaComment*) _tmp32_);
	_vala_comment_unref0 (_tmp32_);
	first_field = TRUE;
	while (TRUE) {
		ValaMarkupTokenType _tmp33_;
		ValaMarkupReader* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		_tmp33_ = self->priv->current_token;
		if (!(_tmp33_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			gboolean _tmp34_ = FALSE;
			if (first_field) {
				ValaMarkupReader* _tmp35_;
				const gchar* _tmp36_;
				const gchar* _tmp37_;
				_tmp35_ = self->priv->reader;
				_tmp36_ = vala_markup_reader_get_name (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp34_ = g_strcmp0 (_tmp37_, "field") == 0;
			} else {
				_tmp34_ = FALSE;
			}
			if (_tmp34_) {
				first_field = FALSE;
			}
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp38_ = self->priv->reader;
		_tmp39_ = vala_markup_reader_get_name (_tmp38_);
		_tmp40_ = _tmp39_;
		if (g_strcmp0 (_tmp40_, "implements") == 0) {
			ValaClass* _tmp41_;
			ValaMarkupReader* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			vala_gir_parser_start_element (self, "implements");
			_tmp41_ = cl;
			_tmp42_ = self->priv->reader;
			_tmp43_ = vala_markup_reader_get_attribute (_tmp42_, "name");
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp44_, NULL, NULL, NULL);
			_tmp46_ = _tmp45_;
			vala_class_add_base_type (_tmp41_, _tmp46_);
			_vala_code_node_unref0 (_tmp46_);
			_g_free0 (_tmp44_);
			vala_gir_parser_next (self);
			vala_gir_parser_end_element (self, "implements");
		} else {
			ValaMarkupReader* _tmp47_;
			const gchar* _tmp48_;
			const gchar* _tmp49_;
			_tmp47_ = self->priv->reader;
			_tmp48_ = vala_markup_reader_get_name (_tmp47_);
			_tmp49_ = _tmp48_;
			if (g_strcmp0 (_tmp49_, "constant") == 0) {
				vala_gir_parser_parse_constant (self);
			} else {
				ValaMarkupReader* _tmp50_;
				const gchar* _tmp51_;
				const gchar* _tmp52_;
				_tmp50_ = self->priv->reader;
				_tmp51_ = vala_markup_reader_get_name (_tmp50_);
				_tmp52_ = _tmp51_;
				if (g_strcmp0 (_tmp52_, "field") == 0) {
					gboolean _tmp53_ = FALSE;
					if (first_field) {
						const gchar* _tmp54_;
						_tmp54_ = parent;
						_tmp53_ = _tmp54_ != NULL;
					} else {
						_tmp53_ = FALSE;
					}
					if (_tmp53_) {
						vala_gir_parser_skip_element (self);
					} else {
						ValaMarkupReader* _tmp55_;
						gchar* _tmp56_;
						gchar* _tmp57_;
						gboolean _tmp58_;
						_tmp55_ = self->priv->reader;
						_tmp56_ = vala_markup_reader_get_attribute (_tmp55_, "name");
						_tmp57_ = _tmp56_;
						_tmp58_ = g_strcmp0 (_tmp57_, "priv") != 0;
						_g_free0 (_tmp57_);
						if (_tmp58_) {
							vala_gir_parser_parse_field (self);
						} else {
							vala_gir_parser_skip_element (self);
						}
					}
					first_field = FALSE;
				} else {
					ValaMarkupReader* _tmp59_;
					const gchar* _tmp60_;
					const gchar* _tmp61_;
					_tmp59_ = self->priv->reader;
					_tmp60_ = vala_markup_reader_get_name (_tmp59_);
					_tmp61_ = _tmp60_;
					if (g_strcmp0 (_tmp61_, "property") == 0) {
						ValaProperty* _tmp62_;
						ValaProperty* _tmp63_;
						_tmp62_ = vala_gir_parser_parse_property (self);
						_tmp63_ = _tmp62_;
						_vala_code_node_unref0 (_tmp63_);
					} else {
						ValaMarkupReader* _tmp64_;
						const gchar* _tmp65_;
						const gchar* _tmp66_;
						_tmp64_ = self->priv->reader;
						_tmp65_ = vala_markup_reader_get_name (_tmp64_);
						_tmp66_ = _tmp65_;
						if (g_strcmp0 (_tmp66_, "constructor") == 0) {
							vala_gir_parser_parse_constructor (self);
						} else {
							ValaMarkupReader* _tmp67_;
							const gchar* _tmp68_;
							const gchar* _tmp69_;
							_tmp67_ = self->priv->reader;
							_tmp68_ = vala_markup_reader_get_name (_tmp67_);
							_tmp69_ = _tmp68_;
							if (g_strcmp0 (_tmp69_, "function") == 0) {
								vala_gir_parser_parse_method (self, "function");
							} else {
								ValaMarkupReader* _tmp70_;
								const gchar* _tmp71_;
								const gchar* _tmp72_;
								_tmp70_ = self->priv->reader;
								_tmp71_ = vala_markup_reader_get_name (_tmp70_);
								_tmp72_ = _tmp71_;
								if (g_strcmp0 (_tmp72_, "function-macro") == 0) {
									vala_gir_parser_skip_element (self);
								} else {
									ValaMarkupReader* _tmp73_;
									const gchar* _tmp74_;
									const gchar* _tmp75_;
									_tmp73_ = self->priv->reader;
									_tmp74_ = vala_markup_reader_get_name (_tmp73_);
									_tmp75_ = _tmp74_;
									if (g_strcmp0 (_tmp75_, "method") == 0) {
										vala_gir_parser_parse_method (self, "method");
									} else {
										ValaMarkupReader* _tmp76_;
										const gchar* _tmp77_;
										const gchar* _tmp78_;
										_tmp76_ = self->priv->reader;
										_tmp77_ = vala_markup_reader_get_name (_tmp76_);
										_tmp78_ = _tmp77_;
										if (g_strcmp0 (_tmp78_, "virtual-method") == 0) {
											vala_gir_parser_parse_method (self, "virtual-method");
										} else {
											ValaMarkupReader* _tmp79_;
											const gchar* _tmp80_;
											const gchar* _tmp81_;
											_tmp79_ = self->priv->reader;
											_tmp80_ = vala_markup_reader_get_name (_tmp79_);
											_tmp81_ = _tmp80_;
											if (g_strcmp0 (_tmp81_, "union") == 0) {
												vala_gir_parser_parse_union (self);
											} else {
												ValaMarkupReader* _tmp82_;
												const gchar* _tmp83_;
												const gchar* _tmp84_;
												_tmp82_ = self->priv->reader;
												_tmp83_ = vala_markup_reader_get_name (_tmp82_);
												_tmp84_ = _tmp83_;
												if (g_strcmp0 (_tmp84_, "glib:signal") == 0) {
													vala_gir_parser_parse_signal (self);
												} else {
													ValaSourceReference* _tmp85_;
													ValaSourceReference* _tmp86_;
													ValaMarkupReader* _tmp87_;
													const gchar* _tmp88_;
													const gchar* _tmp89_;
													gchar* _tmp90_;
													gchar* _tmp91_;
													_tmp85_ = vala_gir_parser_get_current_src (self);
													_tmp86_ = _tmp85_;
													_tmp87_ = self->priv->reader;
													_tmp88_ = vala_markup_reader_get_name (_tmp87_);
													_tmp89_ = _tmp88_;
													_tmp90_ = g_strdup_printf ("unknown child element `%s' in `class'", _tmp89_);
													_tmp91_ = _tmp90_;
													vala_report_error (_tmp86_, _tmp91_);
													_g_free0 (_tmp91_);
													_vala_source_reference_unref0 (_tmp86_);
													vala_gir_parser_skip_element (self);
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "class");
	_g_free0 (parent);
	_vala_code_node_unref0 (cl);
}

static void
vala_gir_parser_parse_interface (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaInterface* iface = NULL;
	ValaGirParserNode* _tmp2_;
	ValaInterface* _tmp14_;
	ValaInterface* _tmp15_;
	ValaInterface* _tmp16_;
	ValaGirComment* _tmp17_;
	ValaGirComment* _tmp18_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "interface");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->current;
	if (_tmp2_->new_symbol) {
		ValaGirParserNode* _tmp3_;
		const gchar* _tmp4_;
		ValaGirParserNode* _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaInterface* _tmp7_;
		ValaGirParserNode* _tmp8_;
		ValaInterface* _tmp9_;
		ValaSymbol* _tmp10_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_->name;
		_tmp5_ = self->priv->current;
		_tmp6_ = _tmp5_->source_reference;
		_tmp7_ = vala_interface_new (_tmp4_, _tmp6_, NULL);
		_vala_code_node_unref0 (iface);
		iface = _tmp7_;
		_tmp8_ = self->priv->current;
		_tmp9_ = iface;
		_tmp10_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp9_);
		_vala_code_node_unref0 (_tmp8_->symbol);
		_tmp8_->symbol = _tmp10_;
	} else {
		ValaGirParserNode* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaInterface* _tmp13_;
		_tmp11_ = self->priv->current;
		_tmp12_ = _tmp11_->symbol;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_INTERFACE, ValaInterface));
		_vala_code_node_unref0 (iface);
		iface = _tmp13_;
	}
	_tmp14_ = iface;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp14_);
	_tmp15_ = iface;
	vala_symbol_set_access ((ValaSymbol*) _tmp15_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_gir_parser_next (self);
	_tmp16_ = iface;
	_tmp17_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp18_ = _tmp17_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp16_, (ValaComment*) _tmp18_);
	_vala_comment_unref0 (_tmp18_);
	while (TRUE) {
		ValaMarkupTokenType _tmp19_;
		ValaMarkupReader* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		_tmp19_ = self->priv->current_token;
		if (!(_tmp19_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp20_ = self->priv->reader;
		_tmp21_ = vala_markup_reader_get_name (_tmp20_);
		_tmp22_ = _tmp21_;
		if (g_strcmp0 (_tmp22_, "prerequisite") == 0) {
			ValaInterface* _tmp23_;
			ValaMarkupReader* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			ValaDataType* _tmp27_;
			ValaDataType* _tmp28_;
			vala_gir_parser_start_element (self, "prerequisite");
			_tmp23_ = iface;
			_tmp24_ = self->priv->reader;
			_tmp25_ = vala_markup_reader_get_attribute (_tmp24_, "name");
			_tmp26_ = _tmp25_;
			_tmp27_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp26_, NULL, NULL, NULL);
			_tmp28_ = _tmp27_;
			vala_interface_add_prerequisite (_tmp23_, _tmp28_);
			_vala_code_node_unref0 (_tmp28_);
			_g_free0 (_tmp26_);
			vala_gir_parser_next (self);
			vala_gir_parser_end_element (self, "prerequisite");
		} else {
			ValaMarkupReader* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			_tmp29_ = self->priv->reader;
			_tmp30_ = vala_markup_reader_get_name (_tmp29_);
			_tmp31_ = _tmp30_;
			if (g_strcmp0 (_tmp31_, "field") == 0) {
				vala_gir_parser_parse_field (self);
			} else {
				ValaMarkupReader* _tmp32_;
				const gchar* _tmp33_;
				const gchar* _tmp34_;
				_tmp32_ = self->priv->reader;
				_tmp33_ = vala_markup_reader_get_name (_tmp32_);
				_tmp34_ = _tmp33_;
				if (g_strcmp0 (_tmp34_, "property") == 0) {
					ValaProperty* _tmp35_;
					ValaProperty* _tmp36_;
					_tmp35_ = vala_gir_parser_parse_property (self);
					_tmp36_ = _tmp35_;
					_vala_code_node_unref0 (_tmp36_);
				} else {
					ValaMarkupReader* _tmp37_;
					const gchar* _tmp38_;
					const gchar* _tmp39_;
					_tmp37_ = self->priv->reader;
					_tmp38_ = vala_markup_reader_get_name (_tmp37_);
					_tmp39_ = _tmp38_;
					if (g_strcmp0 (_tmp39_, "virtual-method") == 0) {
						vala_gir_parser_parse_method (self, "virtual-method");
					} else {
						ValaMarkupReader* _tmp40_;
						const gchar* _tmp41_;
						const gchar* _tmp42_;
						_tmp40_ = self->priv->reader;
						_tmp41_ = vala_markup_reader_get_name (_tmp40_);
						_tmp42_ = _tmp41_;
						if (g_strcmp0 (_tmp42_, "function") == 0) {
							vala_gir_parser_parse_method (self, "function");
						} else {
							ValaMarkupReader* _tmp43_;
							const gchar* _tmp44_;
							const gchar* _tmp45_;
							_tmp43_ = self->priv->reader;
							_tmp44_ = vala_markup_reader_get_name (_tmp43_);
							_tmp45_ = _tmp44_;
							if (g_strcmp0 (_tmp45_, "function-macro") == 0) {
								vala_gir_parser_skip_element (self);
							} else {
								ValaMarkupReader* _tmp46_;
								const gchar* _tmp47_;
								const gchar* _tmp48_;
								_tmp46_ = self->priv->reader;
								_tmp47_ = vala_markup_reader_get_name (_tmp46_);
								_tmp48_ = _tmp47_;
								if (g_strcmp0 (_tmp48_, "method") == 0) {
									vala_gir_parser_parse_method (self, "method");
								} else {
									ValaMarkupReader* _tmp49_;
									const gchar* _tmp50_;
									const gchar* _tmp51_;
									_tmp49_ = self->priv->reader;
									_tmp50_ = vala_markup_reader_get_name (_tmp49_);
									_tmp51_ = _tmp50_;
									if (g_strcmp0 (_tmp51_, "glib:signal") == 0) {
										vala_gir_parser_parse_signal (self);
									} else {
										ValaSourceReference* _tmp52_;
										ValaSourceReference* _tmp53_;
										ValaMarkupReader* _tmp54_;
										const gchar* _tmp55_;
										const gchar* _tmp56_;
										gchar* _tmp57_;
										gchar* _tmp58_;
										_tmp52_ = vala_gir_parser_get_current_src (self);
										_tmp53_ = _tmp52_;
										_tmp54_ = self->priv->reader;
										_tmp55_ = vala_markup_reader_get_name (_tmp54_);
										_tmp56_ = _tmp55_;
										_tmp57_ = g_strdup_printf ("unknown child element `%s' in `interface'", _tmp56_);
										_tmp58_ = _tmp57_;
										vala_report_error (_tmp53_, _tmp58_);
										_g_free0 (_tmp58_);
										_vala_source_reference_unref0 (_tmp53_);
										vala_gir_parser_skip_element (self);
									}
								}
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "interface");
	_vala_code_node_unref0 (iface);
}

static void
vala_gir_parser_parse_field (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* nullable = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	gchar* allow_none = NULL;
	ValaMarkupReader* _tmp4_;
	gchar* _tmp5_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp6_;
	gboolean no_array_length = FALSE;
	gboolean array_null_terminated = FALSE;
	gint array_length_idx = 0;
	ValaDataType* type = NULL;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	gchar* name = NULL;
	ValaGirParserNode* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* cname = NULL;
	ValaGirParserNode* _tmp16_;
	ValaMap* _tmp17_;
	gpointer _tmp18_;
	ValaField* field = NULL;
	const gchar* _tmp19_;
	ValaDataType* _tmp20_;
	ValaGirParserNode* _tmp21_;
	ValaSourceReference* _tmp22_;
	ValaField* _tmp23_;
	ValaField* _tmp24_;
	ValaField* _tmp25_;
	ValaGirComment* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	ValaDataType* _tmp31_;
	gboolean _tmp37_ = FALSE;
	const gchar* _tmp38_;
	ValaGirParserNode* _tmp41_;
	ValaField* _tmp42_;
	ValaSymbol* _tmp43_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "field");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, FALSE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "nullable");
	nullable = _tmp3_;
	_tmp4_ = self->priv->reader;
	_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "allow-none");
	allow_none = _tmp5_;
	vala_gir_parser_next (self);
	_tmp6_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp6_;
	_tmp10_ = vala_gir_parser_parse_type (self, NULL, &_tmp7_, TRUE, &_tmp8_, &_tmp9_);
	array_length_idx = _tmp7_;
	no_array_length = _tmp8_;
	array_null_terminated = _tmp9_;
	type = _tmp10_;
	_tmp11_ = type;
	_tmp12_ = vala_gir_parser_element_get_type (self, _tmp11_, TRUE, &no_array_length, &array_null_terminated, NULL);
	_vala_code_node_unref0 (type);
	type = _tmp12_;
	_tmp13_ = self->priv->current;
	_tmp14_ = _tmp13_->name;
	_tmp15_ = g_strdup (_tmp14_);
	name = _tmp15_;
	_tmp16_ = self->priv->current;
	_tmp17_ = _tmp16_->girdata;
	_tmp18_ = vala_map_get (_tmp17_, "name");
	cname = (gchar*) _tmp18_;
	_tmp19_ = name;
	_tmp20_ = type;
	_tmp21_ = self->priv->current;
	_tmp22_ = _tmp21_->source_reference;
	_tmp23_ = vala_field_new (_tmp19_, _tmp20_, NULL, _tmp22_, NULL);
	field = _tmp23_;
	_tmp24_ = field;
	vala_symbol_set_access ((ValaSymbol*) _tmp24_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp25_ = field;
	_tmp26_ = comment;
	vala_symbol_set_comment ((ValaSymbol*) _tmp25_, (ValaComment*) _tmp26_);
	_tmp27_ = name;
	_tmp28_ = cname;
	if (g_strcmp0 (_tmp27_, _tmp28_) != 0) {
		ValaField* _tmp29_;
		const gchar* _tmp30_;
		_tmp29_ = field;
		_tmp30_ = cname;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp29_, "CCode", "cname", _tmp30_, NULL);
	}
	_tmp31_ = type;
	if (VALA_IS_ARRAY_TYPE (_tmp31_)) {
		gboolean _tmp32_ = FALSE;
		gboolean _tmp34_ = FALSE;
		if (!no_array_length) {
			_tmp32_ = array_length_idx > -1;
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			ValaGirParserNode* _tmp33_;
			_tmp33_ = self->priv->current;
			_tmp33_->array_length_idx = array_length_idx;
		}
		if (no_array_length) {
			_tmp34_ = TRUE;
		} else {
			_tmp34_ = array_null_terminated;
		}
		if (_tmp34_) {
			ValaField* _tmp35_;
			_tmp35_ = field;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp35_, "CCode", "array_length", !no_array_length, NULL);
		}
		if (array_null_terminated) {
			ValaField* _tmp36_;
			_tmp36_ = field;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp36_, "CCode", "array_null_terminated", TRUE, NULL);
		}
	}
	_tmp38_ = nullable;
	if (g_strcmp0 (_tmp38_, "1") == 0) {
		_tmp37_ = TRUE;
	} else {
		const gchar* _tmp39_;
		_tmp39_ = allow_none;
		_tmp37_ = g_strcmp0 (_tmp39_, "1") == 0;
	}
	if (_tmp37_) {
		ValaDataType* _tmp40_;
		_tmp40_ = type;
		vala_data_type_set_nullable (_tmp40_, TRUE);
	}
	_tmp41_ = self->priv->current;
	_tmp42_ = field;
	_tmp43_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp42_);
	_vala_code_node_unref0 (_tmp41_->symbol);
	_tmp41_->symbol = _tmp43_;
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "field");
	_vala_code_node_unref0 (field);
	_g_free0 (cname);
	_g_free0 (name);
	_vala_code_node_unref0 (type);
	_vala_comment_unref0 (comment);
	_g_free0 (allow_none);
	_g_free0 (nullable);
}

static ValaProperty*
vala_gir_parser_parse_property (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean is_abstract = FALSE;
	ValaGirParserMetadata* _tmp4_;
	ValaGirParserNode* _tmp5_;
	ValaGirParserNode* _tmp6_;
	ValaSymbol* _tmp7_;
	gchar* transfer = NULL;
	ValaMarkupReader* _tmp8_;
	gchar* _tmp9_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp10_;
	gboolean no_array_length = FALSE;
	gboolean array_null_terminated = FALSE;
	ValaDataType* type = NULL;
	const gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	ValaDataType* _tmp14_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaProperty* prop = NULL;
	ValaGirParserNode* _tmp17_;
	const gchar* _tmp18_;
	ValaDataType* _tmp19_;
	ValaGirParserNode* _tmp20_;
	ValaSourceReference* _tmp21_;
	ValaProperty* _tmp22_;
	ValaProperty* _tmp23_;
	ValaGirComment* _tmp24_;
	ValaProperty* _tmp25_;
	ValaProperty* _tmp26_;
	gboolean _tmp27_ = FALSE;
	ValaGirParserNode* _tmp30_;
	ValaProperty* _tmp31_;
	ValaSymbol* _tmp32_;
	ValaProperty* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "property");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, "-", "_");
	_tmp3_ = _tmp2_;
	vala_gir_parser_push_node (self, _tmp3_, FALSE);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp4_ = self->priv->metadata;
	_tmp5_ = self->priv->current;
	_tmp6_ = _tmp5_->parent;
	_tmp7_ = _tmp6_->symbol;
	is_abstract = vala_gir_parser_metadata_get_bool (_tmp4_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, VALA_IS_INTERFACE (_tmp7_));
	_tmp8_ = self->priv->reader;
	_tmp9_ = vala_markup_reader_get_attribute (_tmp8_, "transfer-ownership");
	transfer = _tmp9_;
	vala_gir_parser_next (self);
	_tmp10_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp10_;
	_tmp11_ = transfer;
	_tmp14_ = vala_gir_parser_parse_type (self, NULL, NULL, g_strcmp0 (_tmp11_, "container") != 0, &_tmp12_, &_tmp13_);
	no_array_length = _tmp12_;
	array_null_terminated = _tmp13_;
	type = _tmp14_;
	_tmp15_ = type;
	_tmp16_ = vala_gir_parser_element_get_type (self, _tmp15_, TRUE, &no_array_length, &array_null_terminated, NULL);
	_vala_code_node_unref0 (type);
	type = _tmp16_;
	_tmp17_ = self->priv->current;
	_tmp18_ = _tmp17_->name;
	_tmp19_ = type;
	_tmp20_ = self->priv->current;
	_tmp21_ = _tmp20_->source_reference;
	_tmp22_ = vala_property_new (_tmp18_, _tmp19_, NULL, NULL, _tmp21_, NULL);
	prop = _tmp22_;
	_tmp23_ = prop;
	_tmp24_ = comment;
	vala_symbol_set_comment ((ValaSymbol*) _tmp23_, (ValaComment*) _tmp24_);
	_tmp25_ = prop;
	vala_symbol_set_access ((ValaSymbol*) _tmp25_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp26_ = prop;
	vala_property_set_is_abstract (_tmp26_, is_abstract);
	if (no_array_length) {
		_tmp27_ = TRUE;
	} else {
		_tmp27_ = array_null_terminated;
	}
	if (_tmp27_) {
		ValaProperty* _tmp28_;
		_tmp28_ = prop;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp28_, "CCode", "array_length", !no_array_length, NULL);
	}
	if (array_null_terminated) {
		ValaProperty* _tmp29_;
		_tmp29_ = prop;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp29_, "CCode", "array_null_terminated", TRUE, NULL);
	}
	_tmp30_ = self->priv->current;
	_tmp31_ = prop;
	_tmp32_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp31_);
	_vala_code_node_unref0 (_tmp30_->symbol);
	_tmp30_->symbol = _tmp32_;
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "property");
	result = prop;
	_vala_code_node_unref0 (type);
	_vala_comment_unref0 (comment);
	_g_free0 (transfer);
	return result;
}

static void
vala_gir_parser_parse_callback (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_function (self, "callback");
}

static void
vala_gir_parser_parse_constructor (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_function (self, "constructor");
}

static void
vala_gir_parser_parse_function (ValaGirParser* self,
                                const gchar* element_name)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* symbol_type = NULL;
	ValaGirParserMetadata* _tmp7_;
	gchar* ctype = NULL;
	ValaGirParserMetadata* _tmp11_;
	gchar* name = NULL;
	ValaGirParserNode* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* throws_string = NULL;
	ValaMarkupReader* _tmp17_;
	gchar* _tmp18_;
	gchar* invoker = NULL;
	ValaMarkupReader* _tmp19_;
	gchar* _tmp20_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp21_;
	ValaDataType* return_type = NULL;
	gchar* return_ctype = NULL;
	gint return_array_length_idx = 0;
	gboolean return_no_array_length = FALSE;
	gboolean return_array_null_terminated = FALSE;
	gboolean _tmp22_ = FALSE;
	ValaMarkupTokenType _tmp23_;
	ValaSymbol* s = NULL;
	const gchar* _tmp41_;
	ValaSymbol* _tmp98_;
	ValaSymbol* _tmp99_;
	ValaGirComment* _tmp100_;
	ValaArrayType* array_type = NULL;
	ValaDataType* _tmp101_;
	ValaArrayType* _tmp102_;
	gboolean _tmp103_ = FALSE;
	ValaArrayType* _tmp104_;
	ValaSymbol* _tmp116_;
	ValaSymbol* _tmp130_;
	gboolean _tmp167_ = FALSE;
	ValaSymbol* _tmp168_;
	ValaGirParserMetadata* _tmp192_;
	ValaExpression* _tmp193_;
	ValaExpression* _tmp194_;
	gboolean _tmp195_;
	ValaSymbol* _tmp225_;
	gboolean _tmp235_ = FALSE;
	ValaDataType* _tmp236_;
	ValaGirParserNode* _tmp242_;
	const gchar* _tmp243_;
	ValaGirParserNode* _tmp246_;
	ValaSymbol* _tmp247_;
	ValaSymbol* _tmp248_;
	ValaGirParserMetadata* _tmp249_;
	ValaGirParserMetadata* _tmp254_;
	gint instance_idx = 0;
	gboolean _tmp257_ = FALSE;
	ValaArrayList* parameters = NULL;
	GEqualFunc _tmp264_;
	ValaArrayList* _tmp265_;
	ValaGirParserNode* _tmp266_;
	GEqualFunc _tmp267_;
	ValaArrayList* _tmp268_;
	ValaGirParserNode* _tmp269_;
	GEqualFunc _tmp270_;
	ValaArrayList* _tmp271_;
	ValaGirParserNode* _tmp272_;
	GEqualFunc _tmp273_;
	ValaArrayList* _tmp274_;
	gboolean _tmp275_ = FALSE;
	ValaMarkupTokenType _tmp276_;
	ValaGirParserNode* _tmp385_;
	ValaArrayList* _tmp386_;
	ValaList* _tmp387_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_start_element (self, element_name);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "invoker");
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_gir_parser_element_get_name (self, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_replace (_tmp4_, "-", "_");
	_tmp6_ = _tmp5_;
	vala_gir_parser_push_node (self, _tmp6_, FALSE);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp7_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp7_, VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE)) {
		ValaGirParserMetadata* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = self->priv->metadata;
		_tmp9_ = vala_gir_parser_metadata_get_string (_tmp8_, VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE);
		_g_free0 (symbol_type);
		symbol_type = _tmp9_;
	} else {
		gchar* _tmp10_;
		_tmp10_ = g_strdup (element_name);
		_g_free0 (symbol_type);
		symbol_type = _tmp10_;
	}
	ctype = NULL;
	_tmp11_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp11_, VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE)) {
		ValaGirParserMetadata* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = self->priv->metadata;
		_tmp13_ = vala_gir_parser_metadata_get_string (_tmp12_, VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE);
		_g_free0 (ctype);
		ctype = _tmp13_;
	}
	_tmp14_ = self->priv->current;
	_tmp15_ = _tmp14_->name;
	_tmp16_ = g_strdup (_tmp15_);
	name = _tmp16_;
	_tmp17_ = self->priv->reader;
	_tmp18_ = vala_markup_reader_get_attribute (_tmp17_, "throws");
	throws_string = _tmp18_;
	_tmp19_ = self->priv->reader;
	_tmp20_ = vala_markup_reader_get_attribute (_tmp19_, "invoker");
	invoker = _tmp20_;
	vala_gir_parser_next (self);
	_tmp21_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp21_;
	return_ctype = NULL;
	return_array_length_idx = -1;
	return_no_array_length = FALSE;
	return_array_null_terminated = FALSE;
	_tmp23_ = self->priv->current_token;
	if (_tmp23_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		ValaMarkupReader* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		_tmp24_ = self->priv->reader;
		_tmp25_ = vala_markup_reader_get_name (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp22_ = g_strcmp0 (_tmp26_, "return-value") == 0;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		ValaComment* return_comment = NULL;
		gchar* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		ValaComment* _tmp31_ = NULL;
		ValaDataType* _tmp32_;
		ValaComment* _tmp33_;
		_tmp32_ = vala_gir_parser_parse_return_value (self, &_tmp27_, &_tmp28_, &_tmp29_, &_tmp30_, &_tmp31_);
		_g_free0 (return_ctype);
		return_ctype = _tmp27_;
		return_array_length_idx = _tmp28_;
		return_no_array_length = _tmp29_;
		return_array_null_terminated = _tmp30_;
		_vala_comment_unref0 (return_comment);
		return_comment = _tmp31_;
		_vala_code_node_unref0 (return_type);
		return_type = _tmp32_;
		_tmp33_ = return_comment;
		if (_tmp33_ != NULL) {
			ValaGirComment* _tmp34_;
			ValaGirComment* _tmp38_;
			ValaComment* _tmp39_;
			_tmp34_ = comment;
			if (_tmp34_ == NULL) {
				ValaGirParserNode* _tmp35_;
				ValaSourceReference* _tmp36_;
				ValaGirComment* _tmp37_;
				_tmp35_ = self->priv->current;
				_tmp36_ = _tmp35_->source_reference;
				_tmp37_ = vala_gir_comment_new (NULL, _tmp36_);
				_vala_comment_unref0 (comment);
				comment = _tmp37_;
			}
			_tmp38_ = comment;
			_tmp39_ = return_comment;
			vala_gir_comment_set_return_content (_tmp38_, _tmp39_);
		}
		_vala_comment_unref0 (return_comment);
	} else {
		ValaVoidType* _tmp40_;
		_tmp40_ = vala_void_type_new (NULL);
		_vala_code_node_unref0 (return_type);
		return_type = (ValaDataType*) _tmp40_;
	}
	_tmp41_ = symbol_type;
	if (g_strcmp0 (_tmp41_, "callback") == 0) {
		const gchar* _tmp42_;
		ValaDataType* _tmp43_;
		ValaGirParserNode* _tmp44_;
		ValaSourceReference* _tmp45_;
		ValaDelegate* _tmp46_;
		ValaSymbol* _tmp47_;
		_tmp42_ = name;
		_tmp43_ = return_type;
		_tmp44_ = self->priv->current;
		_tmp45_ = _tmp44_->source_reference;
		_tmp46_ = vala_delegate_new (_tmp42_, _tmp43_, _tmp45_, NULL);
		_vala_code_node_unref0 (s);
		s = (ValaSymbol*) _tmp46_;
		_tmp47_ = s;
		vala_delegate_set_has_target (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_DELEGATE, ValaDelegate), FALSE);
	} else {
		const gchar* _tmp48_;
		_tmp48_ = symbol_type;
		if (g_strcmp0 (_tmp48_, "constructor") == 0) {
			const gchar* _tmp49_;
			ValaCreationMethod* m = NULL;
			const gchar* _tmp55_;
			ValaGirParserNode* _tmp56_;
			ValaSourceReference* _tmp57_;
			ValaCreationMethod* _tmp58_;
			ValaCreationMethod* _tmp59_;
			gboolean _tmp60_ = FALSE;
			const gchar* _tmp61_;
			gchar* parent_ctype = NULL;
			ValaGirParserNode* _tmp69_;
			ValaGirParserNode* _tmp70_;
			ValaSymbol* _tmp71_;
			gboolean _tmp75_ = FALSE;
			const gchar* _tmp76_;
			ValaCreationMethod* _tmp85_;
			ValaSymbol* _tmp86_;
			_tmp49_ = name;
			if (g_strcmp0 (_tmp49_, "new") == 0) {
				_g_free0 (name);
				name = NULL;
			} else {
				const gchar* _tmp50_;
				_tmp50_ = name;
				if (g_str_has_prefix (_tmp50_, "new_")) {
					const gchar* _tmp51_;
					gint _tmp52_;
					gint _tmp53_;
					gchar* _tmp54_;
					_tmp51_ = name;
					_tmp52_ = strlen ("new_");
					_tmp53_ = _tmp52_;
					_tmp54_ = string_substring (_tmp51_, (glong) _tmp53_, (glong) -1);
					_g_free0 (name);
					name = _tmp54_;
				}
			}
			_tmp55_ = name;
			_tmp56_ = self->priv->current;
			_tmp57_ = _tmp56_->source_reference;
			_tmp58_ = vala_creation_method_new (NULL, _tmp55_, _tmp57_, NULL);
			m = _tmp58_;
			_tmp59_ = m;
			vala_method_set_has_construct_function ((ValaMethod*) _tmp59_, FALSE);
			_tmp61_ = name;
			if (_tmp61_ != NULL) {
				ValaGirParserNode* _tmp62_;
				const gchar* _tmp63_;
				_tmp62_ = self->priv->current;
				_tmp63_ = _tmp62_->name;
				_tmp60_ = !g_str_has_prefix (_tmp63_, "new_");
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				ValaCreationMethod* _tmp64_;
				ValaGirParserNode* _tmp65_;
				ValaMap* _tmp66_;
				gpointer _tmp67_;
				gchar* _tmp68_;
				_tmp64_ = m;
				_tmp65_ = self->priv->current;
				_tmp66_ = _tmp65_->girdata;
				_tmp67_ = vala_map_get (_tmp66_, "c:identifier");
				_tmp68_ = (gchar*) _tmp67_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp64_, "CCode", "cname", _tmp68_, NULL);
				_g_free0 (_tmp68_);
			}
			parent_ctype = NULL;
			_tmp69_ = self->priv->current;
			_tmp70_ = _tmp69_->parent;
			_tmp71_ = _tmp70_->symbol;
			if (VALA_IS_CLASS (_tmp71_)) {
				ValaGirParserNode* _tmp72_;
				ValaGirParserNode* _tmp73_;
				gchar* _tmp74_;
				_tmp72_ = self->priv->current;
				_tmp73_ = _tmp72_->parent;
				_tmp74_ = vala_gir_parser_node_get_cname (_tmp73_);
				_g_free0 (parent_ctype);
				parent_ctype = _tmp74_;
			}
			_tmp76_ = return_ctype;
			if (_tmp76_ != NULL) {
				gboolean _tmp77_ = FALSE;
				const gchar* _tmp78_;
				_tmp78_ = parent_ctype;
				if (_tmp78_ == NULL) {
					_tmp77_ = TRUE;
				} else {
					const gchar* _tmp79_;
					const gchar* _tmp80_;
					gchar* _tmp81_;
					gchar* _tmp82_;
					_tmp79_ = return_ctype;
					_tmp80_ = parent_ctype;
					_tmp81_ = g_strconcat (_tmp80_, "*", NULL);
					_tmp82_ = _tmp81_;
					_tmp77_ = g_strcmp0 (_tmp79_, _tmp82_) != 0;
					_g_free0 (_tmp82_);
				}
				_tmp75_ = _tmp77_;
			} else {
				_tmp75_ = FALSE;
			}
			if (_tmp75_) {
				ValaCreationMethod* _tmp83_;
				const gchar* _tmp84_;
				_tmp83_ = m;
				_tmp84_ = return_ctype;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp83_, "CCode", "type", _tmp84_, NULL);
			}
			_tmp85_ = m;
			_tmp86_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp85_);
			_vala_code_node_unref0 (s);
			s = _tmp86_;
			_g_free0 (parent_ctype);
			_vala_code_node_unref0 (m);
		} else {
			const gchar* _tmp87_;
			_tmp87_ = symbol_type;
			if (g_strcmp0 (_tmp87_, "glib:signal") == 0) {
				const gchar* _tmp88_;
				ValaDataType* _tmp89_;
				ValaGirParserNode* _tmp90_;
				ValaSourceReference* _tmp91_;
				ValaSignal* _tmp92_;
				_tmp88_ = name;
				_tmp89_ = return_type;
				_tmp90_ = self->priv->current;
				_tmp91_ = _tmp90_->source_reference;
				_tmp92_ = vala_signal_new (_tmp88_, _tmp89_, _tmp91_, NULL);
				_vala_code_node_unref0 (s);
				s = (ValaSymbol*) _tmp92_;
			} else {
				const gchar* _tmp93_;
				ValaDataType* _tmp94_;
				ValaGirParserNode* _tmp95_;
				ValaSourceReference* _tmp96_;
				ValaMethod* _tmp97_;
				_tmp93_ = name;
				_tmp94_ = return_type;
				_tmp95_ = self->priv->current;
				_tmp96_ = _tmp95_->source_reference;
				_tmp97_ = vala_method_new (_tmp93_, _tmp94_, _tmp96_, NULL);
				_vala_code_node_unref0 (s);
				s = (ValaSymbol*) _tmp97_;
			}
		}
	}
	_tmp98_ = s;
	vala_symbol_set_access (_tmp98_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp99_ = s;
	_tmp100_ = comment;
	vala_symbol_set_comment (_tmp99_, (ValaComment*) _tmp100_);
	_tmp101_ = return_type;
	_tmp102_ = _vala_code_node_ref0 (VALA_IS_ARRAY_TYPE (_tmp101_) ? ((ValaArrayType*) _tmp101_) : NULL);
	array_type = _tmp102_;
	_tmp104_ = array_type;
	if (_tmp104_ != NULL) {
		ValaArrayType* _tmp105_;
		gboolean _tmp106_;
		gboolean _tmp107_;
		_tmp105_ = array_type;
		_tmp106_ = vala_array_type_get_fixed_length (_tmp105_);
		_tmp107_ = _tmp106_;
		_tmp103_ = _tmp107_;
	} else {
		_tmp103_ = FALSE;
	}
	if (_tmp103_) {
		ValaSymbol* _tmp108_;
		ValaArrayType* _tmp109_;
		ValaExpression* _tmp110_;
		ValaExpression* _tmp111_;
		const gchar* _tmp112_;
		const gchar* _tmp113_;
		ValaArrayType* _tmp114_;
		ValaArrayType* _tmp115_;
		_tmp108_ = s;
		_tmp109_ = array_type;
		_tmp110_ = vala_array_type_get_length (_tmp109_);
		_tmp111_ = _tmp110_;
		_tmp112_ = vala_integer_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
		_tmp113_ = _tmp112_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp108_, "CCode", "array_length_cexpr", _tmp113_, NULL);
		_tmp114_ = array_type;
		vala_array_type_set_fixed_length (_tmp114_, FALSE);
		_tmp115_ = array_type;
		vala_array_type_set_length (_tmp115_, NULL);
	}
	_tmp116_ = s;
	if (VALA_IS_SIGNAL (_tmp116_)) {
		ValaGirParserNode* _tmp117_;
		ValaMap* _tmp118_;
		gpointer _tmp119_;
		gchar* _tmp120_;
		const gchar* _tmp121_;
		gchar* _tmp122_;
		gchar* _tmp123_;
		gboolean _tmp124_;
		_tmp117_ = self->priv->current;
		_tmp118_ = _tmp117_->girdata;
		_tmp119_ = vala_map_get (_tmp118_, "name");
		_tmp120_ = (gchar*) _tmp119_;
		_tmp121_ = name;
		_tmp122_ = string_replace (_tmp121_, "_", "-");
		_tmp123_ = _tmp122_;
		_tmp124_ = g_strcmp0 (_tmp120_, _tmp123_) != 0;
		_g_free0 (_tmp123_);
		_g_free0 (_tmp120_);
		if (_tmp124_) {
			ValaSymbol* _tmp125_;
			ValaGirParserNode* _tmp126_;
			ValaMap* _tmp127_;
			gpointer _tmp128_;
			gchar* _tmp129_;
			_tmp125_ = s;
			_tmp126_ = self->priv->current;
			_tmp127_ = _tmp126_->girdata;
			_tmp128_ = vala_map_get (_tmp127_, "name");
			_tmp129_ = (gchar*) _tmp128_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp125_, "CCode", "cname", _tmp129_, NULL);
			_g_free0 (_tmp129_);
		}
	}
	_tmp130_ = s;
	if (VALA_IS_METHOD (_tmp130_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp131_;
		ValaMethod* _tmp132_;
		gboolean _tmp133_ = FALSE;
		const gchar* _tmp134_;
		ValaGirParserMetadata* _tmp161_;
		_tmp131_ = s;
		_tmp132_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp131_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp132_;
		_tmp134_ = symbol_type;
		if (g_strcmp0 (_tmp134_, "virtual-method") == 0) {
			_tmp133_ = TRUE;
		} else {
			const gchar* _tmp135_;
			_tmp135_ = symbol_type;
			_tmp133_ = g_strcmp0 (_tmp135_, "callback") == 0;
		}
		if (_tmp133_) {
			ValaGirParserNode* _tmp136_;
			ValaGirParserNode* _tmp137_;
			ValaSymbol* _tmp138_;
			gboolean _tmp141_ = FALSE;
			const gchar* _tmp142_;
			ValaGirParserNode* _tmp148_;
			ValaMap* _tmp149_;
			gpointer _tmp150_;
			gchar* _tmp151_;
			const gchar* _tmp152_;
			gboolean _tmp153_;
			_tmp136_ = self->priv->current;
			_tmp137_ = _tmp136_->parent;
			_tmp138_ = _tmp137_->symbol;
			if (VALA_IS_INTERFACE (_tmp138_)) {
				ValaMethod* _tmp139_;
				_tmp139_ = m;
				vala_method_set_is_abstract (_tmp139_, TRUE);
			} else {
				ValaMethod* _tmp140_;
				_tmp140_ = m;
				vala_method_set_is_virtual (_tmp140_, TRUE);
			}
			_tmp142_ = invoker;
			if (_tmp142_ == NULL) {
				ValaGirParserMetadata* _tmp143_;
				_tmp143_ = self->priv->metadata;
				_tmp141_ = !vala_gir_parser_metadata_has_argument (_tmp143_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME);
			} else {
				_tmp141_ = FALSE;
			}
			if (_tmp141_) {
				ValaSymbol* _tmp144_;
				ValaSymbol* _tmp145_;
				ValaSourceReference* _tmp146_;
				ValaSourceReference* _tmp147_;
				_tmp144_ = s;
				_tmp145_ = s;
				_tmp146_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp145_);
				_tmp147_ = _tmp146_;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp144_, "NoWrapper", TRUE, _tmp147_);
			}
			_tmp148_ = self->priv->current;
			_tmp149_ = _tmp148_->girdata;
			_tmp150_ = vala_map_get (_tmp149_, "name");
			_tmp151_ = (gchar*) _tmp150_;
			_tmp152_ = name;
			_tmp153_ = g_strcmp0 (_tmp151_, _tmp152_) != 0;
			_g_free0 (_tmp151_);
			if (_tmp153_) {
				ValaMethod* _tmp154_;
				ValaGirParserNode* _tmp155_;
				ValaMap* _tmp156_;
				gpointer _tmp157_;
				gchar* _tmp158_;
				_tmp154_ = m;
				_tmp155_ = self->priv->current;
				_tmp156_ = _tmp155_->girdata;
				_tmp157_ = vala_map_get (_tmp156_, "name");
				_tmp158_ = (gchar*) _tmp157_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp154_, "CCode", "vfunc_name", _tmp158_, NULL);
				_g_free0 (_tmp158_);
			}
		} else {
			const gchar* _tmp159_;
			_tmp159_ = symbol_type;
			if (g_strcmp0 (_tmp159_, "function") == 0) {
				ValaMethod* _tmp160_;
				_tmp160_ = m;
				vala_method_set_binding (_tmp160_, VALA_MEMBER_BINDING_STATIC);
			}
		}
		_tmp161_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp161_, VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING)) {
			ValaMethod* _tmp162_;
			ValaGirParserMetadata* _tmp163_;
			ValaMethod* _tmp164_;
			ValaDataType* _tmp165_;
			ValaDataType* _tmp166_;
			_tmp162_ = m;
			_tmp163_ = self->priv->metadata;
			vala_method_set_returns_floating_reference (_tmp162_, vala_gir_parser_metadata_get_bool (_tmp163_, VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING, FALSE));
			_tmp164_ = m;
			_tmp165_ = vala_callable_get_return_type ((ValaCallable*) _tmp164_);
			_tmp166_ = _tmp165_;
			vala_data_type_set_value_owned (_tmp166_, TRUE);
		}
		_vala_code_node_unref0 (m);
	}
	_tmp168_ = s;
	if (VALA_IS_METHOD (_tmp168_)) {
		ValaSymbol* _tmp169_;
		_tmp169_ = s;
		_tmp167_ = !VALA_IS_CREATION_METHOD (_tmp169_);
	} else {
		_tmp167_ = FALSE;
	}
	if (_tmp167_) {
		ValaMethod* method = NULL;
		ValaSymbol* _tmp170_;
		ValaMethod* _tmp171_;
		ValaGirParserMetadata* _tmp172_;
		ValaGirParserMetadata* _tmp180_;
		ValaGirParserMetadata* _tmp186_;
		_tmp170_ = s;
		_tmp171_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp170_, VALA_TYPE_METHOD, ValaMethod));
		method = _tmp171_;
		_tmp172_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp172_, VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL)) {
			ValaMethod* _tmp173_;
			ValaGirParserMetadata* _tmp174_;
			ValaMethod* _tmp175_;
			_tmp173_ = method;
			_tmp174_ = self->priv->metadata;
			vala_method_set_is_virtual (_tmp173_, vala_gir_parser_metadata_get_bool (_tmp174_, VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL, FALSE));
			_tmp175_ = method;
			vala_method_set_is_abstract (_tmp175_, FALSE);
		} else {
			ValaGirParserMetadata* _tmp176_;
			_tmp176_ = self->priv->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp176_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT)) {
				ValaMethod* _tmp177_;
				ValaGirParserMetadata* _tmp178_;
				ValaMethod* _tmp179_;
				_tmp177_ = method;
				_tmp178_ = self->priv->metadata;
				vala_method_set_is_abstract (_tmp177_, vala_gir_parser_metadata_get_bool (_tmp178_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, FALSE));
				_tmp179_ = method;
				vala_method_set_is_virtual (_tmp179_, FALSE);
			}
		}
		_tmp180_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp180_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME)) {
			ValaMethod* _tmp181_;
			ValaGirParserMetadata* _tmp182_;
			gchar* _tmp183_;
			gchar* _tmp184_;
			ValaMethod* _tmp185_;
			_tmp181_ = method;
			_tmp182_ = self->priv->metadata;
			_tmp183_ = vala_gir_parser_metadata_get_string (_tmp182_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME);
			_tmp184_ = _tmp183_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp181_, "CCode", "vfunc_name", _tmp184_, NULL);
			_g_free0 (_tmp184_);
			_tmp185_ = method;
			vala_method_set_is_virtual (_tmp185_, TRUE);
		}
		_tmp186_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp186_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME)) {
			ValaMethod* _tmp187_;
			ValaGirParserMetadata* _tmp188_;
			gchar* _tmp189_;
			gchar* _tmp190_;
			ValaMethod* _tmp191_;
			_tmp187_ = method;
			_tmp188_ = self->priv->metadata;
			_tmp189_ = vala_gir_parser_metadata_get_string (_tmp188_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME);
			_tmp190_ = _tmp189_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp187_, "CCode", "finish_vfunc_name", _tmp190_, NULL);
			_g_free0 (_tmp190_);
			_tmp191_ = method;
			vala_method_set_is_virtual (_tmp191_, TRUE);
		}
		_vala_code_node_unref0 (method);
	}
	_tmp192_ = self->priv->metadata;
	_tmp193_ = vala_gir_parser_metadata_get_expression (_tmp192_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS);
	_tmp194_ = _tmp193_;
	_tmp195_ = !VALA_IS_NULL_LITERAL (_tmp194_);
	_vala_code_node_unref0 (_tmp194_);
	if (_tmp195_) {
		ValaGirParserMetadata* _tmp196_;
		_tmp196_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp196_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS)) {
			gchar** error_types = NULL;
			ValaGirParserMetadata* _tmp197_;
			gchar* _tmp198_;
			gchar* _tmp199_;
			gchar** _tmp200_;
			gchar** _tmp201_;
			gchar** _tmp202_;
			gint _tmp202__length1;
			gint error_types_length1;
			gint _error_types_size_;
			gchar** _tmp203_;
			gint _tmp203__length1;
			gchar* _tmp216_;
			_tmp197_ = self->priv->metadata;
			_tmp198_ = vala_gir_parser_metadata_get_string (_tmp197_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS);
			_tmp199_ = _tmp198_;
			_tmp201_ = _tmp200_ = g_strsplit (_tmp199_, ",", 0);
			_tmp202_ = _tmp201_;
			_tmp202__length1 = _vala_array_length (_tmp200_);
			_g_free0 (_tmp199_);
			error_types = _tmp202_;
			error_types_length1 = _tmp202__length1;
			_error_types_size_ = error_types_length1;
			_tmp203_ = error_types;
			_tmp203__length1 = error_types_length1;
			{
				gchar** error_type_name_collection = NULL;
				gint error_type_name_collection_length1 = 0;
				gint _error_type_name_collection_size_ = 0;
				gint error_type_name_it = 0;
				error_type_name_collection = _tmp203_;
				error_type_name_collection_length1 = _tmp203__length1;
				for (error_type_name_it = 0; error_type_name_it < error_type_name_collection_length1; error_type_name_it = error_type_name_it + 1) {
					gchar* _tmp204_;
					gchar* error_type_name = NULL;
					_tmp204_ = g_strdup (error_type_name_collection[error_type_name_it]);
					error_type_name = _tmp204_;
					{
						ValaDataType* error_type = NULL;
						const gchar* _tmp205_;
						ValaGirParserMetadata* _tmp206_;
						ValaSourceReference* _tmp207_;
						ValaSourceReference* _tmp208_;
						ValaDataType* _tmp209_;
						ValaDataType* _tmp210_;
						ValaSymbol* _tmp211_;
						_tmp205_ = error_type_name;
						_tmp206_ = self->priv->metadata;
						_tmp207_ = vala_gir_parser_metadata_get_source_reference (_tmp206_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS);
						_tmp208_ = _tmp207_;
						_tmp209_ = vala_gir_parser_parse_type_from_string (self, _tmp205_, TRUE, _tmp208_);
						_tmp210_ = _tmp209_;
						_vala_source_reference_unref0 (_tmp208_);
						error_type = _tmp210_;
						_tmp211_ = s;
						if (VALA_IS_METHOD (_tmp211_)) {
							ValaSymbol* _tmp212_;
							ValaDataType* _tmp213_;
							_tmp212_ = s;
							_tmp213_ = error_type;
							vala_method_add_error_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp212_, VALA_TYPE_METHOD, ValaMethod), _tmp213_);
						} else {
							ValaSymbol* _tmp214_;
							ValaDataType* _tmp215_;
							_tmp214_ = s;
							_tmp215_ = error_type;
							vala_delegate_add_error_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp214_, VALA_TYPE_DELEGATE, ValaDelegate), _tmp215_);
						}
						_vala_code_node_unref0 (error_type);
						_g_free0 (error_type_name);
					}
				}
			}
			_tmp216_ = g_strdup ("1");
			_g_free0 (throws_string);
			throws_string = _tmp216_;
			error_types = (_vala_array_free (error_types, error_types_length1, (GDestroyNotify) g_free), NULL);
		} else {
			const gchar* _tmp217_;
			_tmp217_ = throws_string;
			if (g_strcmp0 (_tmp217_, "1") == 0) {
				ValaSymbol* _tmp218_;
				_tmp218_ = s;
				if (VALA_IS_METHOD (_tmp218_)) {
					ValaSymbol* _tmp219_;
					ValaErrorType* _tmp220_;
					ValaErrorType* _tmp221_;
					_tmp219_ = s;
					_tmp220_ = vala_error_type_new (NULL, NULL, NULL);
					_tmp221_ = _tmp220_;
					vala_method_add_error_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp219_, VALA_TYPE_METHOD, ValaMethod), (ValaDataType*) _tmp221_);
					_vala_code_node_unref0 (_tmp221_);
				} else {
					ValaSymbol* _tmp222_;
					ValaErrorType* _tmp223_;
					ValaErrorType* _tmp224_;
					_tmp222_ = s;
					_tmp223_ = vala_error_type_new (NULL, NULL, NULL);
					_tmp224_ = _tmp223_;
					vala_delegate_add_error_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp222_, VALA_TYPE_DELEGATE, ValaDelegate), (ValaDataType*) _tmp224_);
					_vala_code_node_unref0 (_tmp224_);
				}
			}
		}
	}
	_tmp225_ = s;
	if (VALA_IS_METHOD (_tmp225_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp226_;
		ValaMethod* _tmp227_;
		ValaMethod* _tmp228_;
		ValaGirParserMetadata* _tmp229_;
		ValaGirParserMetadata* _tmp230_;
		_tmp226_ = s;
		_tmp227_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp226_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp227_;
		_tmp228_ = m;
		_tmp229_ = self->priv->metadata;
		vala_code_node_set_attribute ((ValaCodeNode*) _tmp228_, "PrintfFormat", vala_gir_parser_metadata_get_bool (_tmp229_, VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT, FALSE), NULL);
		_tmp230_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp230_, VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL)) {
			ValaMethod* _tmp231_;
			ValaGirParserMetadata* _tmp232_;
			gchar* _tmp233_;
			gchar* _tmp234_;
			_tmp231_ = m;
			_tmp232_ = self->priv->metadata;
			_tmp233_ = vala_gir_parser_metadata_get_string (_tmp232_, VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL);
			_tmp234_ = _tmp233_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp231_, "CCode", "sentinel", _tmp234_, NULL);
			_g_free0 (_tmp234_);
		}
		_vala_code_node_unref0 (m);
	}
	_tmp236_ = return_type;
	if (VALA_IS_ARRAY_TYPE (_tmp236_)) {
		ValaGirParserMetadata* _tmp237_;
		_tmp237_ = self->priv->metadata;
		_tmp235_ = vala_gir_parser_metadata_has_argument (_tmp237_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX);
	} else {
		_tmp235_ = FALSE;
	}
	if (_tmp235_) {
		ValaGirParserMetadata* _tmp238_;
		_tmp238_ = self->priv->metadata;
		return_array_length_idx = vala_gir_parser_metadata_get_integer (_tmp238_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX);
	} else {
		gboolean _tmp239_ = FALSE;
		if (return_no_array_length) {
			_tmp239_ = TRUE;
		} else {
			_tmp239_ = return_array_null_terminated;
		}
		if (_tmp239_) {
			ValaSymbol* _tmp240_;
			_tmp240_ = s;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp240_, "CCode", "array_length", !return_no_array_length, NULL);
		}
		if (return_array_null_terminated) {
			ValaSymbol* _tmp241_;
			_tmp241_ = s;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp241_, "CCode", "array_null_terminated", TRUE, NULL);
		}
	}
	_tmp242_ = self->priv->current;
	_tmp242_->return_array_length_idx = return_array_length_idx;
	_tmp243_ = ctype;
	if (_tmp243_ != NULL) {
		ValaSymbol* _tmp244_;
		const gchar* _tmp245_;
		_tmp244_ = s;
		_tmp245_ = ctype;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp244_, "CCode", "type", _tmp245_, NULL);
	}
	_tmp246_ = self->priv->current;
	_tmp247_ = s;
	_tmp248_ = _vala_code_node_ref0 (_tmp247_);
	_vala_code_node_unref0 (_tmp246_->symbol);
	_tmp246_->symbol = _tmp248_;
	_tmp249_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp249_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME)) {
		ValaSymbol* _tmp250_;
		ValaGirParserMetadata* _tmp251_;
		gchar* _tmp252_;
		gchar* _tmp253_;
		_tmp250_ = s;
		_tmp251_ = self->priv->metadata;
		_tmp252_ = vala_gir_parser_metadata_get_string (_tmp251_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME);
		_tmp253_ = _tmp252_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp250_, "CCode", "finish_name", _tmp253_, NULL);
		_g_free0 (_tmp253_);
	}
	_tmp254_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp254_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE)) {
		ValaSymbol* _tmp255_;
		ValaGirParserMetadata* _tmp256_;
		_tmp255_ = s;
		_tmp256_ = self->priv->metadata;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp255_, "CCode", "finish_instance", vala_gir_parser_metadata_get_bool (_tmp256_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE, FALSE), NULL);
	}
	instance_idx = -2;
	if (g_strcmp0 (element_name, "function") == 0) {
		const gchar* _tmp258_;
		_tmp258_ = symbol_type;
		_tmp257_ = g_strcmp0 (_tmp258_, "method") == 0;
	} else {
		_tmp257_ = FALSE;
	}
	if (_tmp257_) {
		ValaGirParserMetadata* _tmp259_;
		_tmp259_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp259_, VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX)) {
			ValaGirParserMetadata* _tmp260_;
			_tmp260_ = self->priv->metadata;
			instance_idx = vala_gir_parser_metadata_get_integer (_tmp260_, VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX);
			if (instance_idx != 0) {
				ValaSymbol* _tmp261_;
				_tmp261_ = s;
				vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp261_, "CCode", "instance_pos", instance_idx + 0.5, NULL);
			}
		} else {
			ValaSourceReference* _tmp262_;
			ValaSourceReference* _tmp263_;
			_tmp262_ = vala_gir_parser_get_current_src (self);
			_tmp263_ = _tmp262_;
			vala_report_error (_tmp263_, "instance_idx required when converting function to method");
			_vala_source_reference_unref0 (_tmp263_);
		}
	}
	_tmp264_ = g_direct_equal;
	_tmp265_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_PARAMETER_INFO, (GBoxedCopyFunc) vala_gir_parser_parameter_info_ref, (GDestroyNotify) vala_gir_parser_parameter_info_unref, _tmp264_);
	parameters = _tmp265_;
	_tmp266_ = self->priv->current;
	_tmp267_ = g_direct_equal;
	_tmp268_ = vala_array_list_new (G_TYPE_INT, NULL, NULL, _tmp267_);
	_vala_iterable_unref0 (_tmp266_->array_length_parameters);
	_tmp266_->array_length_parameters = _tmp268_;
	_tmp269_ = self->priv->current;
	_tmp270_ = g_direct_equal;
	_tmp271_ = vala_array_list_new (G_TYPE_INT, NULL, NULL, _tmp270_);
	_vala_iterable_unref0 (_tmp269_->closure_parameters);
	_tmp269_->closure_parameters = _tmp271_;
	_tmp272_ = self->priv->current;
	_tmp273_ = g_direct_equal;
	_tmp274_ = vala_array_list_new (G_TYPE_INT, NULL, NULL, _tmp273_);
	_vala_iterable_unref0 (_tmp272_->destroy_parameters);
	_tmp272_->destroy_parameters = _tmp274_;
	_tmp276_ = self->priv->current_token;
	if (_tmp276_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		ValaMarkupReader* _tmp277_;
		const gchar* _tmp278_;
		const gchar* _tmp279_;
		_tmp277_ = self->priv->reader;
		_tmp278_ = vala_markup_reader_get_name (_tmp277_);
		_tmp279_ = _tmp278_;
		_tmp275_ = g_strcmp0 (_tmp279_, "parameters") == 0;
	} else {
		_tmp275_ = FALSE;
	}
	if (_tmp275_) {
		gint current_parameter_idx = 0;
		vala_gir_parser_start_element (self, "parameters");
		vala_gir_parser_next (self);
		current_parameter_idx = -1;
		while (TRUE) {
			ValaMarkupTokenType _tmp280_;
			gint _tmp281_;
			gboolean _tmp282_ = FALSE;
			ValaMarkupReader* _tmp283_;
			const gchar* _tmp284_;
			const gchar* _tmp285_;
			gboolean is_instance_parameter = FALSE;
			gboolean _tmp289_ = FALSE;
			gint array_length_idx = 0;
			gint closure_idx = 0;
			gint destroy_idx = 0;
			gchar* scope = NULL;
			gchar* default_param_name = NULL;
			ValaComment* param_comment = NULL;
			ValaArrayList* _tmp290_;
			gint _tmp291_;
			gint _tmp292_;
			gchar* _tmp293_;
			ValaParameter* param = NULL;
			const gchar* _tmp294_;
			gint _tmp295_ = 0;
			gint _tmp296_ = 0;
			gint _tmp297_ = 0;
			gchar* _tmp298_ = NULL;
			ValaComment* _tmp299_ = NULL;
			ValaParameter* _tmp300_;
			ValaComment* _tmp329_;
			ValaGirParserParameterInfo* info = NULL;
			ValaParameter* _tmp346_;
			const gchar* _tmp347_;
			ValaGirParserParameterInfo* _tmp348_;
			ValaUnresolvedType* unresolved_type = NULL;
			ValaParameter* _tmp349_;
			ValaDataType* _tmp350_;
			ValaDataType* _tmp351_;
			gboolean _tmp352_ = FALSE;
			ValaSymbol* _tmp353_;
			gboolean _tmp364_ = FALSE;
			gboolean _tmp365_ = FALSE;
			ValaSymbol* _tmp366_;
			ValaArrayList* _tmp383_;
			ValaGirParserParameterInfo* _tmp384_;
			_tmp280_ = self->priv->current_token;
			if (!(_tmp280_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
				break;
			}
			_tmp281_ = current_parameter_idx;
			current_parameter_idx = _tmp281_ + 1;
			_tmp283_ = self->priv->reader;
			_tmp284_ = vala_markup_reader_get_name (_tmp283_);
			_tmp285_ = _tmp284_;
			if (g_strcmp0 (_tmp285_, "instance-parameter") == 0) {
				gboolean _tmp286_ = FALSE;
				const gchar* _tmp287_;
				_tmp287_ = symbol_type;
				if (g_strcmp0 (_tmp287_, "function") == 0) {
					_tmp286_ = TRUE;
				} else {
					const gchar* _tmp288_;
					_tmp288_ = symbol_type;
					_tmp286_ = g_strcmp0 (_tmp288_, "constructor") == 0;
				}
				_tmp282_ = !_tmp286_;
			} else {
				_tmp282_ = FALSE;
			}
			is_instance_parameter = _tmp282_;
			if (instance_idx > -2) {
				_tmp289_ = instance_idx == current_parameter_idx;
			} else {
				_tmp289_ = FALSE;
			}
			if (_tmp289_) {
				vala_gir_parser_skip_element (self);
				continue;
			}
			if (!vala_gir_parser_push_metadata (self)) {
				vala_gir_parser_skip_element (self);
				continue;
			}
			default_param_name = NULL;
			_tmp290_ = parameters;
			_tmp291_ = vala_collection_get_size ((ValaCollection*) _tmp290_);
			_tmp292_ = _tmp291_;
			_tmp293_ = g_strdup_printf ("arg%d", _tmp292_);
			_g_free0 (default_param_name);
			default_param_name = _tmp293_;
			_tmp294_ = default_param_name;
			_tmp300_ = vala_gir_parser_parse_parameter (self, &_tmp295_, &_tmp296_, &_tmp297_, &_tmp298_, &_tmp299_, _tmp294_);
			array_length_idx = _tmp295_;
			closure_idx = _tmp296_;
			destroy_idx = _tmp297_;
			_g_free0 (scope);
			scope = _tmp298_;
			_vala_comment_unref0 (param_comment);
			param_comment = _tmp299_;
			param = _tmp300_;
			if (is_instance_parameter) {
				ValaMethod* m = NULL;
				ValaSymbol* _tmp301_;
				ValaMethod* _tmp302_;
				_tmp301_ = s;
				m = VALA_IS_METHOD (_tmp301_) ? ((ValaMethod*) _tmp301_) : NULL;
				_tmp302_ = m;
				if (_tmp302_ != NULL) {
					ValaParameter* _tmp303_;
					ValaParameterDirection _tmp304_;
					ValaParameterDirection _tmp305_;
					_tmp303_ = param;
					_tmp304_ = vala_parameter_get_direction (_tmp303_);
					_tmp305_ = _tmp304_;
					if (_tmp305_ == VALA_PARAMETER_DIRECTION_IN) {
						ValaParameter* _tmp306_;
						ValaDataType* _tmp307_;
						ValaDataType* _tmp308_;
						gboolean _tmp309_;
						gboolean _tmp310_;
						_tmp306_ = param;
						_tmp307_ = vala_variable_get_variable_type ((ValaVariable*) _tmp306_);
						_tmp308_ = _tmp307_;
						_tmp309_ = vala_data_type_get_value_owned (_tmp308_);
						_tmp310_ = _tmp309_;
						if (_tmp310_) {
							ValaMethod* _tmp311_;
							_tmp311_ = m;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp311_, "DestroysInstance", TRUE, NULL);
						}
						vala_gir_parser_pop_metadata (self);
						_vala_code_node_unref0 (param);
						_vala_comment_unref0 (param_comment);
						_g_free0 (default_param_name);
						_g_free0 (scope);
						continue;
					} else {
						ValaMethod* _tmp312_;
						_tmp312_ = m;
						vala_method_set_binding (_tmp312_, VALA_MEMBER_BINDING_STATIC);
					}
				}
			}
			if (array_length_idx != -1) {
				gboolean _tmp313_ = FALSE;
				ValaGirParserNode* _tmp315_;
				ValaArrayList* _tmp316_;
				if (instance_idx > -2) {
					_tmp313_ = instance_idx < array_length_idx;
				} else {
					_tmp313_ = FALSE;
				}
				if (_tmp313_) {
					gint _tmp314_;
					_tmp314_ = array_length_idx;
					array_length_idx = _tmp314_ - 1;
				}
				_tmp315_ = self->priv->current;
				_tmp316_ = _tmp315_->array_length_parameters;
				vala_collection_add ((ValaCollection*) _tmp316_, (gpointer) ((gintptr) array_length_idx));
			}
			if (closure_idx != -1) {
				gboolean _tmp317_ = FALSE;
				ValaGirParserNode* _tmp319_;
				ValaArrayList* _tmp320_;
				if (instance_idx > -2) {
					_tmp317_ = instance_idx < closure_idx;
				} else {
					_tmp317_ = FALSE;
				}
				if (_tmp317_) {
					gint _tmp318_;
					_tmp318_ = closure_idx;
					closure_idx = _tmp318_ - 1;
				}
				_tmp319_ = self->priv->current;
				_tmp320_ = _tmp319_->closure_parameters;
				if (vala_list_index_of ((ValaList*) _tmp320_, (gpointer) ((gintptr) current_parameter_idx)) < 0) {
					ValaGirParserNode* _tmp321_;
					ValaArrayList* _tmp322_;
					_tmp321_ = self->priv->current;
					_tmp322_ = _tmp321_->closure_parameters;
					vala_collection_add ((ValaCollection*) _tmp322_, (gpointer) ((gintptr) closure_idx));
				}
			}
			if (destroy_idx != -1) {
				gboolean _tmp323_ = FALSE;
				ValaGirParserNode* _tmp325_;
				ValaArrayList* _tmp326_;
				if (instance_idx > -2) {
					_tmp323_ = instance_idx < destroy_idx;
				} else {
					_tmp323_ = FALSE;
				}
				if (_tmp323_) {
					gint _tmp324_;
					_tmp324_ = destroy_idx;
					destroy_idx = _tmp324_ - 1;
				}
				_tmp325_ = self->priv->current;
				_tmp326_ = _tmp325_->destroy_parameters;
				if (vala_list_index_of ((ValaList*) _tmp326_, (gpointer) ((gintptr) current_parameter_idx)) < 0) {
					ValaGirParserNode* _tmp327_;
					ValaArrayList* _tmp328_;
					_tmp327_ = self->priv->current;
					_tmp328_ = _tmp327_->destroy_parameters;
					vala_collection_add ((ValaCollection*) _tmp328_, (gpointer) ((gintptr) destroy_idx));
				}
			}
			_tmp329_ = param_comment;
			if (_tmp329_ != NULL) {
				ValaGirComment* _tmp330_;
				const gchar* _tmp337_ = NULL;
				ValaParameter* _tmp338_;
				gboolean _tmp339_;
				gboolean _tmp340_;
				ValaGirComment* _tmp344_;
				ValaComment* _tmp345_;
				_tmp330_ = comment;
				if (_tmp330_ == NULL) {
					ValaSymbol* _tmp331_;
					ValaSourceReference* _tmp332_;
					ValaSourceReference* _tmp333_;
					ValaGirComment* _tmp334_;
					ValaSymbol* _tmp335_;
					ValaGirComment* _tmp336_;
					_tmp331_ = s;
					_tmp332_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp331_);
					_tmp333_ = _tmp332_;
					_tmp334_ = vala_gir_comment_new (NULL, _tmp333_);
					_vala_comment_unref0 (comment);
					comment = _tmp334_;
					_tmp335_ = s;
					_tmp336_ = comment;
					vala_symbol_set_comment (_tmp335_, (ValaComment*) _tmp336_);
				}
				_tmp338_ = param;
				_tmp339_ = vala_parameter_get_ellipsis (_tmp338_);
				_tmp340_ = _tmp339_;
				if (_tmp340_) {
					_tmp337_ = "...";
				} else {
					ValaParameter* _tmp341_;
					const gchar* _tmp342_;
					const gchar* _tmp343_;
					_tmp341_ = param;
					_tmp342_ = vala_symbol_get_name ((ValaSymbol*) _tmp341_);
					_tmp343_ = _tmp342_;
					_tmp337_ = _tmp343_;
				}
				_tmp344_ = comment;
				_tmp345_ = param_comment;
				vala_gir_comment_add_content_for_parameter (_tmp344_, _tmp337_, _tmp345_);
			}
			_tmp346_ = param;
			_tmp347_ = scope;
			_tmp348_ = vala_gir_parser_parameter_info_new (_tmp346_, array_length_idx, closure_idx, destroy_idx, g_strcmp0 (_tmp347_, "async") == 0);
			info = _tmp348_;
			_tmp349_ = param;
			_tmp350_ = vala_variable_get_variable_type ((ValaVariable*) _tmp349_);
			_tmp351_ = _tmp350_;
			unresolved_type = VALA_IS_UNRESOLVED_TYPE (_tmp351_) ? ((ValaUnresolvedType*) _tmp351_) : NULL;
			_tmp353_ = s;
			if (VALA_IS_METHOD (_tmp353_)) {
				const gchar* _tmp354_;
				_tmp354_ = scope;
				_tmp352_ = g_strcmp0 (_tmp354_, "async") == 0;
			} else {
				_tmp352_ = FALSE;
			}
			if (_tmp352_) {
				gboolean _tmp355_ = FALSE;
				ValaUnresolvedType* _tmp356_;
				_tmp356_ = unresolved_type;
				if (_tmp356_ != NULL) {
					ValaUnresolvedType* _tmp357_;
					ValaUnresolvedSymbol* _tmp358_;
					ValaUnresolvedSymbol* _tmp359_;
					const gchar* _tmp360_;
					const gchar* _tmp361_;
					_tmp357_ = unresolved_type;
					_tmp358_ = vala_unresolved_type_get_unresolved_symbol (_tmp357_);
					_tmp359_ = _tmp358_;
					_tmp360_ = vala_symbol_get_name ((ValaSymbol*) _tmp359_);
					_tmp361_ = _tmp360_;
					_tmp355_ = g_strcmp0 (_tmp361_, "AsyncReadyCallback") == 0;
				} else {
					_tmp355_ = FALSE;
				}
				if (_tmp355_) {
					ValaSymbol* _tmp362_;
					ValaGirParserParameterInfo* _tmp363_;
					_tmp362_ = s;
					vala_method_set_coroutine (G_TYPE_CHECK_INSTANCE_CAST (_tmp362_, VALA_TYPE_METHOD, ValaMethod), TRUE);
					_tmp363_ = info;
					_tmp363_->keep = FALSE;
				}
			}
			_tmp366_ = s;
			if (VALA_IS_DELEGATE (_tmp366_)) {
				const gchar* _tmp367_;
				_tmp367_ = throws_string;
				_tmp365_ = g_strcmp0 (_tmp367_, "1") != 0;
			} else {
				_tmp365_ = FALSE;
			}
			if (_tmp365_) {
				ValaParameter* _tmp368_;
				ValaParameterDirection _tmp369_;
				ValaParameterDirection _tmp370_;
				_tmp368_ = param;
				_tmp369_ = vala_parameter_get_direction (_tmp368_);
				_tmp370_ = _tmp369_;
				_tmp364_ = _tmp370_ == VALA_PARAMETER_DIRECTION_OUT;
			} else {
				_tmp364_ = FALSE;
			}
			if (_tmp364_) {
				gboolean _tmp371_ = FALSE;
				ValaUnresolvedType* _tmp372_;
				_tmp372_ = unresolved_type;
				if (_tmp372_ != NULL) {
					ValaUnresolvedType* _tmp373_;
					ValaUnresolvedSymbol* _tmp374_;
					ValaUnresolvedSymbol* _tmp375_;
					gchar* _tmp376_;
					gchar* _tmp377_;
					_tmp373_ = unresolved_type;
					_tmp374_ = vala_unresolved_type_get_unresolved_symbol (_tmp373_);
					_tmp375_ = _tmp374_;
					_tmp376_ = vala_code_node_to_string ((ValaCodeNode*) _tmp375_);
					_tmp377_ = _tmp376_;
					_tmp371_ = g_strcmp0 (_tmp377_, "GLib.Error") == 0;
					_g_free0 (_tmp377_);
				} else {
					_tmp371_ = FALSE;
				}
				if (_tmp371_) {
					ValaSymbol* _tmp378_;
					ValaErrorType* _tmp379_;
					ValaErrorType* _tmp380_;
					ValaGirParserParameterInfo* _tmp381_;
					ValaGirParserParameterInfo* _tmp382_;
					_tmp378_ = s;
					_tmp379_ = vala_error_type_new (NULL, NULL, NULL);
					_tmp380_ = _tmp379_;
					vala_delegate_add_error_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp378_, VALA_TYPE_DELEGATE, ValaDelegate), (ValaDataType*) _tmp380_);
					_vala_code_node_unref0 (_tmp380_);
					_tmp381_ = info;
					_tmp381_->is_error = TRUE;
					_tmp382_ = info;
					_tmp382_->keep = FALSE;
				}
			}
			_tmp383_ = parameters;
			_tmp384_ = info;
			vala_collection_add ((ValaCollection*) _tmp383_, _tmp384_);
			vala_gir_parser_pop_metadata (self);
			_vala_gir_parser_parameter_info_unref0 (info);
			_vala_code_node_unref0 (param);
			_vala_comment_unref0 (param_comment);
			_g_free0 (default_param_name);
			_g_free0 (scope);
		}
		vala_gir_parser_end_element (self, "parameters");
	}
	_tmp385_ = self->priv->current;
	_tmp386_ = parameters;
	_tmp387_ = _vala_iterable_ref0 ((ValaList*) _tmp386_);
	_vala_iterable_unref0 (_tmp385_->parameters);
	_tmp385_->parameters = _tmp387_;
	{
		gint param_n = 0;
		ValaArrayList* _tmp388_;
		gint _tmp389_;
		gint _tmp390_;
		_tmp388_ = parameters;
		_tmp389_ = vala_collection_get_size ((ValaCollection*) _tmp388_);
		_tmp390_ = _tmp389_;
		param_n = _tmp390_ - 1;
		{
			gboolean _tmp391_ = FALSE;
			_tmp391_ = TRUE;
			while (TRUE) {
				ValaGirParserParameterInfo* pi = NULL;
				ValaArrayList* _tmp393_;
				gpointer _tmp394_;
				gboolean _tmp395_ = FALSE;
				ValaGirParserParameterInfo* _tmp396_;
				ValaParameter* _tmp397_;
				gboolean _tmp398_;
				gboolean _tmp399_;
				if (!_tmp391_) {
					gint _tmp392_;
					_tmp392_ = param_n;
					param_n = _tmp392_ - 1;
				}
				_tmp391_ = FALSE;
				if (!(param_n >= 0)) {
					break;
				}
				_tmp393_ = parameters;
				_tmp394_ = vala_list_get ((ValaList*) _tmp393_, param_n);
				pi = (ValaGirParserParameterInfo*) _tmp394_;
				_tmp396_ = pi;
				_tmp397_ = _tmp396_->param;
				_tmp398_ = vala_parameter_get_ellipsis (_tmp397_);
				_tmp399_ = _tmp398_;
				if (!_tmp399_) {
					ValaGirParserParameterInfo* _tmp400_;
					ValaParameter* _tmp401_;
					ValaExpression* _tmp402_;
					ValaExpression* _tmp403_;
					_tmp400_ = pi;
					_tmp401_ = _tmp400_->param;
					_tmp402_ = vala_variable_get_initializer ((ValaVariable*) _tmp401_);
					_tmp403_ = _tmp402_;
					_tmp395_ = _tmp403_ == NULL;
				} else {
					_tmp395_ = FALSE;
				}
				if (_tmp395_) {
					gchar* type_string = NULL;
					ValaGirParserParameterInfo* _tmp404_;
					ValaParameter* _tmp405_;
					ValaDataType* _tmp406_;
					ValaDataType* _tmp407_;
					gchar* _tmp408_;
					const gchar* _tmp409_;
					_tmp404_ = pi;
					_tmp405_ = _tmp404_->param;
					_tmp406_ = vala_variable_get_variable_type ((ValaVariable*) _tmp405_);
					_tmp407_ = _tmp406_;
					_tmp408_ = vala_code_node_to_string ((ValaCodeNode*) _tmp407_);
					type_string = _tmp408_;
					_tmp409_ = type_string;
					if (g_strcmp0 (_tmp409_, "Gio.Cancellable?") == 0) {
						ValaGirParserParameterInfo* _tmp410_;
						ValaParameter* _tmp411_;
						ValaNullLiteral* _tmp412_;
						ValaNullLiteral* _tmp413_;
						_tmp410_ = pi;
						_tmp411_ = _tmp410_->param;
						_tmp412_ = vala_null_literal_new (NULL);
						_tmp413_ = _tmp412_;
						vala_variable_set_initializer ((ValaVariable*) _tmp411_, (ValaExpression*) _tmp413_);
						_vala_code_node_unref0 (_tmp413_);
					} else {
						_g_free0 (type_string);
						_vala_gir_parser_parameter_info_unref0 (pi);
						break;
					}
					_g_free0 (type_string);
				}
				_vala_gir_parser_parameter_info_unref0 (pi);
			}
		}
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, element_name);
	_vala_iterable_unref0 (parameters);
	_vala_code_node_unref0 (array_type);
	_vala_code_node_unref0 (s);
	_g_free0 (return_ctype);
	_vala_code_node_unref0 (return_type);
	_vala_comment_unref0 (comment);
	_g_free0 (invoker);
	_g_free0 (throws_string);
	_g_free0 (name);
	_g_free0 (ctype);
	_g_free0 (symbol_type);
}

static void
vala_gir_parser_parse_method (ValaGirParser* self,
                              const gchar* element_name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_parse_function (self, element_name);
}

static void
vala_gir_parser_parse_signal (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_function (self, "glib:signal");
}

static void
vala_gir_parser_parse_boxed (ValaGirParser* self,
                             const gchar* element_name)
{
	gchar* name = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ValaClass* cl = NULL;
	gboolean require_copy_free = FALSE;
	ValaGirParserNode* _tmp8_;
	ValaClass* _tmp21_;
	ValaClass* _tmp22_;
	ValaClass* _tmp23_;
	ValaGirParserMetadata* _tmp24_;
	ValaClass* _tmp34_;
	ValaGirComment* _tmp35_;
	ValaGirComment* _tmp36_;
	ValaGirParserNode* ref_method = NULL;
	ValaGirParserNode* unref_method = NULL;
	gboolean _tmp81_ = FALSE;
	gboolean _tmp82_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaClass* _tmp84_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_start_element (self, element_name);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	name = _tmp1_;
	_tmp2_ = name;
	if (_tmp2_ == NULL) {
		ValaMarkupReader* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->reader;
		_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, "glib:name");
		_g_free0 (name);
		name = _tmp4_;
	}
	_tmp5_ = name;
	_tmp6_ = vala_gir_parser_element_get_name (self, _tmp5_);
	_tmp7_ = _tmp6_;
	vala_gir_parser_push_node (self, _tmp7_, TRUE);
	_g_free0 (_tmp7_);
	require_copy_free = FALSE;
	_tmp8_ = self->priv->current;
	if (_tmp8_->new_symbol) {
		ValaGirParserNode* _tmp9_;
		const gchar* _tmp10_;
		ValaGirParserNode* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaClass* _tmp13_;
		ValaClass* _tmp14_;
		ValaGirParserNode* _tmp15_;
		ValaClass* _tmp16_;
		ValaSymbol* _tmp17_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_->name;
		_tmp11_ = self->priv->current;
		_tmp12_ = _tmp11_->source_reference;
		_tmp13_ = vala_class_new (_tmp10_, _tmp12_, NULL);
		_vala_code_node_unref0 (cl);
		cl = _tmp13_;
		_tmp14_ = cl;
		vala_class_set_is_compact (_tmp14_, TRUE);
		_tmp15_ = self->priv->current;
		_tmp16_ = cl;
		_tmp17_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp16_);
		_vala_code_node_unref0 (_tmp15_->symbol);
		_tmp15_->symbol = _tmp17_;
	} else {
		ValaGirParserNode* _tmp18_;
		ValaSymbol* _tmp19_;
		ValaClass* _tmp20_;
		_tmp18_ = self->priv->current;
		_tmp19_ = _tmp18_->symbol;
		_tmp20_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_CLASS, ValaClass));
		_vala_code_node_unref0 (cl);
		cl = _tmp20_;
	}
	_tmp21_ = cl;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp21_);
	_tmp22_ = cl;
	require_copy_free = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp22_, "CCode", "type_id");
	_tmp23_ = cl;
	vala_symbol_set_access ((ValaSymbol*) _tmp23_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp24_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp24_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE)) {
		ValaClass* _tmp25_;
		ValaGirParserMetadata* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		ValaGirParserMetadata* _tmp29_;
		ValaSourceReference* _tmp30_;
		ValaSourceReference* _tmp31_;
		ValaDataType* _tmp32_;
		ValaDataType* _tmp33_;
		_tmp25_ = cl;
		_tmp26_ = self->priv->metadata;
		_tmp27_ = vala_gir_parser_metadata_get_string (_tmp26_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp28_ = _tmp27_;
		_tmp29_ = self->priv->metadata;
		_tmp30_ = vala_gir_parser_metadata_get_source_reference (_tmp29_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_gir_parser_parse_type_from_string (self, _tmp28_, TRUE, _tmp31_);
		_tmp33_ = _tmp32_;
		vala_class_add_base_type (_tmp25_, _tmp33_);
		_vala_code_node_unref0 (_tmp33_);
		_vala_source_reference_unref0 (_tmp31_);
		_g_free0 (_tmp28_);
	}
	vala_gir_parser_next (self);
	_tmp34_ = cl;
	_tmp35_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp36_ = _tmp35_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp34_, (ValaComment*) _tmp36_);
	_vala_comment_unref0 (_tmp36_);
	ref_method = NULL;
	unref_method = NULL;
	while (TRUE) {
		ValaMarkupTokenType _tmp37_;
		ValaMarkupReader* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		_tmp37_ = self->priv->current_token;
		if (!(_tmp37_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp38_ = self->priv->reader;
		_tmp39_ = vala_markup_reader_get_name (_tmp38_);
		_tmp40_ = _tmp39_;
		if (g_strcmp0 (_tmp40_, "field") == 0) {
			vala_gir_parser_parse_field (self);
		} else {
			ValaMarkupReader* _tmp41_;
			const gchar* _tmp42_;
			const gchar* _tmp43_;
			_tmp41_ = self->priv->reader;
			_tmp42_ = vala_markup_reader_get_name (_tmp41_);
			_tmp43_ = _tmp42_;
			if (g_strcmp0 (_tmp43_, "constructor") == 0) {
				vala_gir_parser_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				_tmp44_ = self->priv->reader;
				_tmp45_ = vala_markup_reader_get_name (_tmp44_);
				_tmp46_ = _tmp45_;
				if (g_strcmp0 (_tmp46_, "method") == 0) {
					gchar* cname = NULL;
					ValaGirParserNode* _tmp47_;
					gchar* _tmp48_;
					gboolean _tmp49_ = FALSE;
					const gchar* _tmp50_;
					vala_gir_parser_parse_method (self, "method");
					_tmp47_ = self->priv->old_current;
					_tmp48_ = vala_gir_parser_node_get_cname (_tmp47_);
					cname = _tmp48_;
					_tmp50_ = cname;
					if (g_str_has_suffix (_tmp50_, "_ref")) {
						gboolean _tmp51_ = FALSE;
						ValaGirParserNode* _tmp52_;
						_tmp52_ = ref_method;
						if (_tmp52_ == NULL) {
							_tmp51_ = TRUE;
						} else {
							ValaGirParserNode* _tmp53_;
							const gchar* _tmp54_;
							_tmp53_ = self->priv->old_current;
							_tmp54_ = _tmp53_->name;
							_tmp51_ = g_strcmp0 (_tmp54_, "ref") == 0;
						}
						_tmp49_ = _tmp51_;
					} else {
						_tmp49_ = FALSE;
					}
					if (_tmp49_) {
						ValaGirParserNode* _tmp55_;
						ValaGirParserNode* _tmp56_;
						_tmp55_ = self->priv->old_current;
						_tmp56_ = _vala_gir_parser_node_ref0 (_tmp55_);
						_vala_gir_parser_node_unref0 (ref_method);
						ref_method = _tmp56_;
					} else {
						gboolean _tmp57_ = FALSE;
						const gchar* _tmp58_;
						_tmp58_ = cname;
						if (g_str_has_suffix (_tmp58_, "_unref")) {
							gboolean _tmp59_ = FALSE;
							ValaGirParserNode* _tmp60_;
							_tmp60_ = unref_method;
							if (_tmp60_ == NULL) {
								_tmp59_ = TRUE;
							} else {
								ValaGirParserNode* _tmp61_;
								const gchar* _tmp62_;
								_tmp61_ = self->priv->old_current;
								_tmp62_ = _tmp61_->name;
								_tmp59_ = g_strcmp0 (_tmp62_, "unref") == 0;
							}
							_tmp57_ = _tmp59_;
						} else {
							_tmp57_ = FALSE;
						}
						if (_tmp57_) {
							ValaGirParserNode* _tmp63_;
							ValaGirParserNode* _tmp64_;
							_tmp63_ = self->priv->old_current;
							_tmp64_ = _vala_gir_parser_node_ref0 (_tmp63_);
							_vala_gir_parser_node_unref0 (unref_method);
							unref_method = _tmp64_;
						}
					}
					_g_free0 (cname);
				} else {
					ValaMarkupReader* _tmp65_;
					const gchar* _tmp66_;
					const gchar* _tmp67_;
					_tmp65_ = self->priv->reader;
					_tmp66_ = vala_markup_reader_get_name (_tmp65_);
					_tmp67_ = _tmp66_;
					if (g_strcmp0 (_tmp67_, "function") == 0) {
						vala_gir_parser_skip_element (self);
					} else {
						ValaMarkupReader* _tmp68_;
						const gchar* _tmp69_;
						const gchar* _tmp70_;
						_tmp68_ = self->priv->reader;
						_tmp69_ = vala_markup_reader_get_name (_tmp68_);
						_tmp70_ = _tmp69_;
						if (g_strcmp0 (_tmp70_, "function-macro") == 0) {
							vala_gir_parser_skip_element (self);
						} else {
							ValaMarkupReader* _tmp71_;
							const gchar* _tmp72_;
							const gchar* _tmp73_;
							_tmp71_ = self->priv->reader;
							_tmp72_ = vala_markup_reader_get_name (_tmp71_);
							_tmp73_ = _tmp72_;
							if (g_strcmp0 (_tmp73_, "union") == 0) {
								vala_gir_parser_parse_union (self);
							} else {
								ValaSourceReference* _tmp74_;
								ValaSourceReference* _tmp75_;
								ValaMarkupReader* _tmp76_;
								const gchar* _tmp77_;
								const gchar* _tmp78_;
								gchar* _tmp79_;
								gchar* _tmp80_;
								_tmp74_ = vala_gir_parser_get_current_src (self);
								_tmp75_ = _tmp74_;
								_tmp76_ = self->priv->reader;
								_tmp77_ = vala_markup_reader_get_name (_tmp76_);
								_tmp78_ = _tmp77_;
								_tmp79_ = g_strdup_printf ("unknown child element `%s' in `class'", _tmp78_);
								_tmp80_ = _tmp79_;
								vala_report_error (_tmp75_, _tmp80_);
								_g_free0 (_tmp80_);
								_vala_source_reference_unref0 (_tmp75_);
								vala_gir_parser_skip_element (self);
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	_tmp84_ = cl;
	if (vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp84_, "CCode", "ref_function")) {
		_tmp83_ = TRUE;
	} else {
		ValaClass* _tmp85_;
		_tmp85_ = cl;
		_tmp83_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp85_, "CCode", "unref_function");
	}
	if (_tmp83_) {
		_tmp82_ = TRUE;
	} else {
		ValaClass* _tmp86_;
		_tmp86_ = cl;
		_tmp82_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp86_, "CCode", "copy_function");
	}
	if (_tmp82_) {
		_tmp81_ = TRUE;
	} else {
		ValaClass* _tmp87_;
		_tmp87_ = cl;
		_tmp81_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp87_, "CCode", "free_function");
	}
	if (_tmp81_) {
	} else {
		gboolean _tmp88_ = FALSE;
		ValaGirParserNode* _tmp89_;
		_tmp89_ = ref_method;
		if (_tmp89_ != NULL) {
			ValaGirParserNode* _tmp90_;
			_tmp90_ = unref_method;
			_tmp88_ = _tmp90_ != NULL;
		} else {
			_tmp88_ = FALSE;
		}
		if (_tmp88_) {
			ValaClass* _tmp91_;
			ValaGirParserNode* _tmp92_;
			gchar* _tmp93_;
			gchar* _tmp94_;
			ValaClass* _tmp95_;
			ValaGirParserNode* _tmp96_;
			gchar* _tmp97_;
			gchar* _tmp98_;
			_tmp91_ = cl;
			_tmp92_ = ref_method;
			_tmp93_ = vala_gir_parser_node_get_cname (_tmp92_);
			_tmp94_ = _tmp93_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp91_, "CCode", "ref_function", _tmp94_, NULL);
			_g_free0 (_tmp94_);
			_tmp95_ = cl;
			_tmp96_ = unref_method;
			_tmp97_ = vala_gir_parser_node_get_cname (_tmp96_);
			_tmp98_ = _tmp97_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp95_, "CCode", "unref_function", _tmp98_, NULL);
			_g_free0 (_tmp98_);
		} else {
			if (require_copy_free) {
				ValaClass* _tmp99_;
				ValaClass* _tmp100_;
				_tmp99_ = cl;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp99_, "CCode", "copy_function", "g_boxed_copy", NULL);
				_tmp100_ = cl;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp100_, "CCode", "free_function", "g_boxed_free", NULL);
			}
		}
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, element_name);
	_vala_gir_parser_node_unref0 (unref_method);
	_vala_gir_parser_node_unref0 (ref_method);
	_vala_code_node_unref0 (cl);
	_g_free0 (name);
}

static void
vala_gir_parser_parse_union (ValaGirParser* self)
{
	gchar* element_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp15_;
	ValaStruct* st = NULL;
	ValaGirParserNode* _tmp16_;
	ValaStruct* _tmp29_;
	ValaStruct* _tmp30_;
	ValaGirComment* _tmp31_;
	ValaGirComment* _tmp32_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "union");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	element_name = _tmp0_;
	_tmp1_ = element_name;
	if (_tmp1_ == NULL) {
		ValaGirComment* _tmp2_;
		ValaGirComment* _tmp3_;
		vala_gir_parser_next (self);
		_tmp2_ = vala_gir_parser_parse_symbol_doc (self);
		_tmp3_ = _tmp2_;
		_vala_comment_unref0 (_tmp3_);
		while (TRUE) {
			ValaMarkupTokenType _tmp4_;
			ValaMarkupReader* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			_tmp4_ = self->priv->current_token;
			if (!(_tmp4_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
				break;
			}
			if (!vala_gir_parser_push_metadata (self)) {
				vala_gir_parser_skip_element (self);
				continue;
			}
			_tmp5_ = self->priv->reader;
			_tmp6_ = vala_markup_reader_get_name (_tmp5_);
			_tmp7_ = _tmp6_;
			if (g_strcmp0 (_tmp7_, "field") == 0) {
				vala_gir_parser_parse_field (self);
			} else {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				ValaMarkupReader* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp8_ = vala_gir_parser_get_current_src (self);
				_tmp9_ = _tmp8_;
				_tmp10_ = self->priv->reader;
				_tmp11_ = vala_markup_reader_get_name (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strdup_printf ("unknown child element `%s' in `transparent union'", _tmp12_);
				_tmp14_ = _tmp13_;
				vala_report_error (_tmp9_, _tmp14_);
				_g_free0 (_tmp14_);
				_vala_source_reference_unref0 (_tmp9_);
				vala_gir_parser_skip_element (self);
			}
			vala_gir_parser_pop_metadata (self);
		}
		vala_gir_parser_end_element (self, "union");
		_g_free0 (element_name);
		return;
	}
	_tmp15_ = element_name;
	vala_gir_parser_push_node (self, _tmp15_, TRUE);
	_tmp16_ = self->priv->current;
	if (_tmp16_->new_symbol) {
		ValaMarkupReader* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		ValaGirParserNode* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaStruct* _tmp22_;
		ValaGirParserNode* _tmp23_;
		ValaStruct* _tmp24_;
		ValaSymbol* _tmp25_;
		_tmp17_ = self->priv->reader;
		_tmp18_ = vala_markup_reader_get_attribute (_tmp17_, "name");
		_tmp19_ = _tmp18_;
		_tmp20_ = self->priv->current;
		_tmp21_ = _tmp20_->source_reference;
		_tmp22_ = vala_struct_new (_tmp19_, _tmp21_, NULL);
		_vala_code_node_unref0 (st);
		st = _tmp22_;
		_g_free0 (_tmp19_);
		_tmp23_ = self->priv->current;
		_tmp24_ = st;
		_tmp25_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp24_);
		_vala_code_node_unref0 (_tmp23_->symbol);
		_tmp23_->symbol = _tmp25_;
	} else {
		ValaGirParserNode* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaStruct* _tmp28_;
		_tmp26_ = self->priv->current;
		_tmp27_ = _tmp26_->symbol;
		_tmp28_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, VALA_TYPE_STRUCT, ValaStruct));
		_vala_code_node_unref0 (st);
		st = _tmp28_;
	}
	_tmp29_ = st;
	vala_symbol_set_access ((ValaSymbol*) _tmp29_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	vala_gir_parser_next (self);
	_tmp30_ = st;
	_tmp31_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp32_ = _tmp31_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp30_, (ValaComment*) _tmp32_);
	_vala_comment_unref0 (_tmp32_);
	while (TRUE) {
		ValaMarkupTokenType _tmp33_;
		ValaMarkupReader* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		_tmp33_ = self->priv->current_token;
		if (!(_tmp33_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp34_ = self->priv->reader;
		_tmp35_ = vala_markup_reader_get_name (_tmp34_);
		_tmp36_ = _tmp35_;
		if (g_strcmp0 (_tmp36_, "field") == 0) {
			vala_gir_parser_parse_field (self);
		} else {
			ValaMarkupReader* _tmp37_;
			const gchar* _tmp38_;
			const gchar* _tmp39_;
			_tmp37_ = self->priv->reader;
			_tmp38_ = vala_markup_reader_get_name (_tmp37_);
			_tmp39_ = _tmp38_;
			if (g_strcmp0 (_tmp39_, "constructor") == 0) {
				vala_gir_parser_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp40_;
				const gchar* _tmp41_;
				const gchar* _tmp42_;
				_tmp40_ = self->priv->reader;
				_tmp41_ = vala_markup_reader_get_name (_tmp40_);
				_tmp42_ = _tmp41_;
				if (g_strcmp0 (_tmp42_, "method") == 0) {
					vala_gir_parser_parse_method (self, "method");
				} else {
					ValaMarkupReader* _tmp43_;
					const gchar* _tmp44_;
					const gchar* _tmp45_;
					_tmp43_ = self->priv->reader;
					_tmp44_ = vala_markup_reader_get_name (_tmp43_);
					_tmp45_ = _tmp44_;
					if (g_strcmp0 (_tmp45_, "function") == 0) {
						vala_gir_parser_skip_element (self);
					} else {
						ValaMarkupReader* _tmp46_;
						const gchar* _tmp47_;
						const gchar* _tmp48_;
						_tmp46_ = self->priv->reader;
						_tmp47_ = vala_markup_reader_get_name (_tmp46_);
						_tmp48_ = _tmp47_;
						if (g_strcmp0 (_tmp48_, "function-macro") == 0) {
							vala_gir_parser_skip_element (self);
						} else {
							ValaMarkupReader* _tmp49_;
							const gchar* _tmp50_;
							const gchar* _tmp51_;
							_tmp49_ = self->priv->reader;
							_tmp50_ = vala_markup_reader_get_name (_tmp49_);
							_tmp51_ = _tmp50_;
							if (g_strcmp0 (_tmp51_, "record") == 0) {
								vala_gir_parser_parse_record (self);
							} else {
								ValaSourceReference* _tmp52_;
								ValaSourceReference* _tmp53_;
								ValaMarkupReader* _tmp54_;
								const gchar* _tmp55_;
								const gchar* _tmp56_;
								gchar* _tmp57_;
								gchar* _tmp58_;
								_tmp52_ = vala_gir_parser_get_current_src (self);
								_tmp53_ = _tmp52_;
								_tmp54_ = self->priv->reader;
								_tmp55_ = vala_markup_reader_get_name (_tmp54_);
								_tmp56_ = _tmp55_;
								_tmp57_ = g_strdup_printf ("unknown child element `%s' in `union'", _tmp56_);
								_tmp58_ = _tmp57_;
								vala_report_error (_tmp53_, _tmp58_);
								_g_free0 (_tmp58_);
								_vala_source_reference_unref0 (_tmp53_);
								vala_gir_parser_skip_element (self);
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "union");
	_vala_code_node_unref0 (st);
	_g_free0 (element_name);
}

static void
vala_gir_parser_parse_constant (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp2_;
	gboolean no_array_length = FALSE;
	gboolean array_null_terminated = FALSE;
	gint array_length_idx = 0;
	ValaDataType* type = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	ValaDataType* _tmp8_;
	ValaConstant* c = NULL;
	ValaGirParserNode* _tmp9_;
	const gchar* _tmp10_;
	ValaDataType* _tmp11_;
	ValaGirParserNode* _tmp12_;
	ValaSourceReference* _tmp13_;
	ValaConstant* _tmp14_;
	ValaGirParserNode* _tmp15_;
	ValaConstant* _tmp16_;
	ValaSymbol* _tmp17_;
	ValaConstant* _tmp18_;
	ValaConstant* _tmp19_;
	ValaGirComment* _tmp20_;
	gboolean _tmp21_ = FALSE;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "constant");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, FALSE);
	_g_free0 (_tmp1_);
	vala_gir_parser_next (self);
	_tmp2_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp2_;
	_tmp6_ = vala_gir_parser_parse_type (self, NULL, &_tmp3_, TRUE, &_tmp4_, &_tmp5_);
	array_length_idx = _tmp3_;
	no_array_length = _tmp4_;
	array_null_terminated = _tmp5_;
	type = _tmp6_;
	_tmp7_ = type;
	_tmp8_ = vala_gir_parser_element_get_type (self, _tmp7_, TRUE, &no_array_length, &array_null_terminated, NULL);
	_vala_code_node_unref0 (type);
	type = _tmp8_;
	_tmp9_ = self->priv->current;
	_tmp10_ = _tmp9_->name;
	_tmp11_ = type;
	_tmp12_ = self->priv->current;
	_tmp13_ = _tmp12_->source_reference;
	_tmp14_ = vala_constant_new (_tmp10_, _tmp11_, NULL, _tmp13_, NULL);
	c = _tmp14_;
	_tmp15_ = self->priv->current;
	_tmp16_ = c;
	_tmp17_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp16_);
	_vala_code_node_unref0 (_tmp15_->symbol);
	_tmp15_->symbol = _tmp17_;
	_tmp18_ = c;
	vala_symbol_set_access ((ValaSymbol*) _tmp18_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp19_ = c;
	_tmp20_ = comment;
	vala_symbol_set_comment ((ValaSymbol*) _tmp19_, (ValaComment*) _tmp20_);
	if (no_array_length) {
		_tmp21_ = TRUE;
	} else {
		_tmp21_ = array_null_terminated;
	}
	if (_tmp21_) {
		ValaConstant* _tmp22_;
		_tmp22_ = c;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp22_, "CCode", "array_length", !no_array_length, NULL);
	}
	if (array_null_terminated) {
		ValaConstant* _tmp23_;
		_tmp23_ = c;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp23_, "CCode", "array_null_terminated", TRUE, NULL);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "constant");
	_vala_code_node_unref0 (c);
	_vala_code_node_unref0 (type);
	_vala_comment_unref0 (comment);
}

static void
vala_gir_parser_report_unused_metadata (ValaGirParser* self,
                                        ValaGirParserMetadata* metadata)
{
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaMap* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata != NULL);
	_tmp0_ = vala_gir_parser_metadata_get_empty ();
	_tmp1_ = _tmp0_;
	if (metadata == _tmp1_) {
		return;
	}
	_tmp3_ = metadata->args;
	_tmp4_ = vala_map_get_size (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		ValaArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = metadata->children;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaSourceReference* _tmp9_;
		_tmp9_ = metadata->source_reference;
		vala_report_warning (_tmp9_, "empty metadata");
		return;
	}
	{
		ValaIterator* _arg_type_it = NULL;
		ValaMap* _tmp10_;
		ValaSet* _tmp11_;
		ValaSet* _tmp12_;
		ValaIterator* _tmp13_;
		ValaIterator* _tmp14_;
		_tmp10_ = metadata->args;
		_tmp11_ = vala_map_get_keys (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_iterable_iterator ((ValaIterable*) _tmp12_);
		_tmp14_ = _tmp13_;
		_vala_iterable_unref0 (_tmp12_);
		_arg_type_it = _tmp14_;
		while (TRUE) {
			ValaIterator* _tmp15_;
			ValaGirParserArgumentType arg_type = 0;
			ValaIterator* _tmp16_;
			gpointer _tmp17_;
			ValaGirParserArgument* arg = NULL;
			ValaMap* _tmp18_;
			ValaGirParserArgumentType _tmp19_;
			gpointer _tmp20_;
			ValaGirParserArgument* _tmp21_;
			_tmp15_ = _arg_type_it;
			if (!vala_iterator_next (_tmp15_)) {
				break;
			}
			_tmp16_ = _arg_type_it;
			_tmp17_ = vala_iterator_get (_tmp16_);
			arg_type = (ValaGirParserArgumentType) ((gintptr) _tmp17_);
			_tmp18_ = metadata->args;
			_tmp19_ = arg_type;
			_tmp20_ = vala_map_get (_tmp18_, (gpointer) ((gintptr) _tmp19_));
			arg = (ValaGirParserArgument*) _tmp20_;
			_tmp21_ = arg;
			if (!_tmp21_->used) {
				ValaGirParserArgument* _tmp22_;
				ValaSourceReference* _tmp23_;
				_tmp22_ = arg;
				_tmp23_ = _tmp22_->source_reference;
				vala_report_warning (_tmp23_, "argument never used");
			}
			_vala_gir_parser_argument_unref0 (arg);
		}
		_vala_iterator_unref0 (_arg_type_it);
	}
	{
		ValaArrayList* _child_list = NULL;
		ValaArrayList* _tmp24_;
		ValaArrayList* _tmp25_;
		gint _child_size = 0;
		ValaArrayList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _child_index = 0;
		_tmp24_ = metadata->children;
		_tmp25_ = _vala_iterable_ref0 (_tmp24_);
		_child_list = _tmp25_;
		_tmp26_ = _child_list;
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_child_size = _tmp28_;
		_child_index = -1;
		while (TRUE) {
			ValaGirParserMetadata* child = NULL;
			ValaArrayList* _tmp29_;
			gpointer _tmp30_;
			ValaGirParserMetadata* _tmp31_;
			_child_index = _child_index + 1;
			if (!(_child_index < _child_size)) {
				break;
			}
			_tmp29_ = _child_list;
			_tmp30_ = vala_list_get ((ValaList*) _tmp29_, _child_index);
			child = (ValaGirParserMetadata*) _tmp30_;
			_tmp31_ = child;
			if (!_tmp31_->used) {
				ValaGirParserMetadata* _tmp32_;
				ValaSourceReference* _tmp33_;
				_tmp32_ = child;
				_tmp33_ = _tmp32_->source_reference;
				vala_report_warning (_tmp33_, "metadata never used");
			} else {
				ValaGirParserMetadata* _tmp34_;
				_tmp34_ = child;
				vala_gir_parser_report_unused_metadata (self, _tmp34_);
			}
			_vala_gir_parser_metadata_unref0 (child);
		}
		_vala_iterable_unref0 (_child_list);
	}
}

static void
vala_gir_parser_resolve_gir_symbols (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	{
		ValaArrayList* _map_from_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _map_from_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _map_from_index = 0;
		_tmp0_ = self->priv->unresolved_gir_symbols;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_map_from_list = _tmp1_;
		_tmp2_ = _map_from_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_map_from_size = _tmp4_;
		_map_from_index = -1;
		while (TRUE) {
			ValaUnresolvedSymbol* map_from = NULL;
			ValaArrayList* _tmp5_;
			gpointer _tmp6_;
			_map_from_index = _map_from_index + 1;
			if (!(_map_from_index < _map_from_size)) {
				break;
			}
			_tmp5_ = _map_from_list;
			_tmp6_ = vala_list_get ((ValaList*) _tmp5_, _map_from_index);
			map_from = (ValaUnresolvedSymbol*) _tmp6_;
			while (TRUE) {
				ValaUnresolvedSymbol* _tmp7_;
				ValaSymbol* map_to = NULL;
				ValaHashMap* _tmp8_;
				ValaUnresolvedSymbol* _tmp9_;
				gpointer _tmp10_;
				ValaSymbol* _tmp11_;
				ValaUnresolvedSymbol* _tmp61_;
				ValaUnresolvedSymbol* _tmp62_;
				ValaUnresolvedSymbol* _tmp63_;
				ValaUnresolvedSymbol* _tmp64_;
				_tmp7_ = map_from;
				if (!(_tmp7_ != NULL)) {
					break;
				}
				_tmp8_ = self->priv->unresolved_symbols_map;
				_tmp9_ = map_from;
				_tmp10_ = vala_map_get ((ValaMap*) _tmp8_, _tmp9_);
				map_to = (ValaSymbol*) _tmp10_;
				_tmp11_ = map_to;
				if (_tmp11_ != NULL) {
					ValaUnresolvedSymbol* _tmp12_;
					ValaUnresolvedSymbol* _tmp13_;
					ValaSymbol* _tmp14_;
					const gchar* _tmp15_;
					const gchar* _tmp16_;
					ValaSymbol* _tmp17_;
					_tmp12_ = map_from;
					vala_unresolved_symbol_set_inner (_tmp12_, NULL);
					_tmp13_ = map_from;
					_tmp14_ = map_to;
					_tmp15_ = vala_symbol_get_name (_tmp14_);
					_tmp16_ = _tmp15_;
					vala_symbol_set_name ((ValaSymbol*) _tmp13_, _tmp16_);
					_tmp17_ = map_to;
					if (VALA_IS_UNRESOLVED_SYMBOL (_tmp17_)) {
						ValaUnresolvedSymbol* umap_to = NULL;
						ValaSymbol* _tmp18_;
						ValaUnresolvedSymbol* _tmp19_;
						_tmp18_ = map_to;
						_tmp19_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbol));
						umap_to = _tmp19_;
						while (TRUE) {
							ValaUnresolvedSymbol* _tmp20_;
							ValaUnresolvedSymbol* _tmp21_;
							ValaUnresolvedSymbol* _tmp22_;
							ValaUnresolvedSymbol* _tmp23_;
							ValaUnresolvedSymbol* _tmp24_;
							ValaUnresolvedSymbol* _tmp25_;
							ValaUnresolvedSymbol* _tmp26_;
							ValaUnresolvedSymbol* _tmp27_;
							ValaUnresolvedSymbol* _tmp28_;
							const gchar* _tmp29_;
							const gchar* _tmp30_;
							ValaUnresolvedSymbol* _tmp31_;
							ValaUnresolvedSymbol* _tmp32_;
							ValaUnresolvedSymbol* _tmp33_;
							ValaUnresolvedSymbol* _tmp34_;
							ValaUnresolvedSymbol* _tmp35_;
							ValaUnresolvedSymbol* _tmp36_;
							_tmp20_ = umap_to;
							_tmp21_ = vala_unresolved_symbol_get_inner (_tmp20_);
							_tmp22_ = _tmp21_;
							if (!(_tmp22_ != NULL)) {
								break;
							}
							_tmp23_ = umap_to;
							_tmp24_ = vala_unresolved_symbol_get_inner (_tmp23_);
							_tmp25_ = _tmp24_;
							_tmp26_ = _vala_code_node_ref0 (_tmp25_);
							_vala_code_node_unref0 (umap_to);
							umap_to = _tmp26_;
							_tmp27_ = map_from;
							_tmp28_ = umap_to;
							_tmp29_ = vala_symbol_get_name ((ValaSymbol*) _tmp28_);
							_tmp30_ = _tmp29_;
							_tmp31_ = vala_unresolved_symbol_new (NULL, _tmp30_, NULL);
							_tmp32_ = _tmp31_;
							vala_unresolved_symbol_set_inner (_tmp27_, _tmp32_);
							_vala_code_node_unref0 (_tmp32_);
							_tmp33_ = map_from;
							_tmp34_ = vala_unresolved_symbol_get_inner (_tmp33_);
							_tmp35_ = _tmp34_;
							_tmp36_ = _vala_code_node_ref0 (_tmp35_);
							_vala_code_node_unref0 (map_from);
							map_from = _tmp36_;
						}
						_vala_code_node_unref0 (umap_to);
					} else {
						while (TRUE) {
							gboolean _tmp37_ = FALSE;
							ValaSymbol* _tmp38_;
							ValaSymbol* _tmp39_;
							ValaSymbol* _tmp40_;
							ValaSymbol* _tmp47_;
							ValaSymbol* _tmp48_;
							ValaSymbol* _tmp49_;
							ValaSymbol* _tmp50_;
							ValaUnresolvedSymbol* _tmp51_;
							ValaSymbol* _tmp52_;
							const gchar* _tmp53_;
							const gchar* _tmp54_;
							ValaUnresolvedSymbol* _tmp55_;
							ValaUnresolvedSymbol* _tmp56_;
							ValaUnresolvedSymbol* _tmp57_;
							ValaUnresolvedSymbol* _tmp58_;
							ValaUnresolvedSymbol* _tmp59_;
							ValaUnresolvedSymbol* _tmp60_;
							_tmp38_ = map_to;
							_tmp39_ = vala_symbol_get_parent_symbol (_tmp38_);
							_tmp40_ = _tmp39_;
							if (_tmp40_ != NULL) {
								ValaSymbol* _tmp41_;
								ValaSymbol* _tmp42_;
								ValaSymbol* _tmp43_;
								ValaCodeContext* _tmp44_;
								ValaNamespace* _tmp45_;
								ValaNamespace* _tmp46_;
								_tmp41_ = map_to;
								_tmp42_ = vala_symbol_get_parent_symbol (_tmp41_);
								_tmp43_ = _tmp42_;
								_tmp44_ = self->priv->context;
								_tmp45_ = vala_code_context_get_root (_tmp44_);
								_tmp46_ = _tmp45_;
								_tmp37_ = _tmp43_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, VALA_TYPE_SYMBOL, ValaSymbol);
							} else {
								_tmp37_ = FALSE;
							}
							if (!_tmp37_) {
								break;
							}
							_tmp47_ = map_to;
							_tmp48_ = vala_symbol_get_parent_symbol (_tmp47_);
							_tmp49_ = _tmp48_;
							_tmp50_ = _vala_code_node_ref0 (_tmp49_);
							_vala_code_node_unref0 (map_to);
							map_to = _tmp50_;
							_tmp51_ = map_from;
							_tmp52_ = map_to;
							_tmp53_ = vala_symbol_get_name (_tmp52_);
							_tmp54_ = _tmp53_;
							_tmp55_ = vala_unresolved_symbol_new (NULL, _tmp54_, NULL);
							_tmp56_ = _tmp55_;
							vala_unresolved_symbol_set_inner (_tmp51_, _tmp56_);
							_vala_code_node_unref0 (_tmp56_);
							_tmp57_ = map_from;
							_tmp58_ = vala_unresolved_symbol_get_inner (_tmp57_);
							_tmp59_ = _tmp58_;
							_tmp60_ = _vala_code_node_ref0 (_tmp59_);
							_vala_code_node_unref0 (map_from);
							map_from = _tmp60_;
						}
					}
					_vala_code_node_unref0 (map_to);
					break;
				}
				_tmp61_ = map_from;
				_tmp62_ = vala_unresolved_symbol_get_inner (_tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = _vala_code_node_ref0 (_tmp63_);
				_vala_code_node_unref0 (map_from);
				map_from = _tmp64_;
				_vala_code_node_unref0 (map_to);
			}
			_vala_code_node_unref0 (map_from);
		}
		_vala_iterable_unref0 (_map_from_list);
	}
}

static void
vala_gir_parser_create_new_namespaces (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	{
		ValaArrayList* _node_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _node_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _node_index = 0;
		_tmp0_ = vala_gir_parser_node_new_namespaces;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_node_list = _tmp1_;
		_tmp2_ = _node_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_node_size = _tmp4_;
		_node_index = -1;
		while (TRUE) {
			ValaGirParserNode* node = NULL;
			ValaArrayList* _tmp5_;
			gpointer _tmp6_;
			ValaGirParserNode* _tmp7_;
			ValaSymbol* _tmp8_;
			_node_index = _node_index + 1;
			if (!(_node_index < _node_size)) {
				break;
			}
			_tmp5_ = _node_list;
			_tmp6_ = vala_list_get ((ValaList*) _tmp5_, _node_index);
			node = (ValaGirParserNode*) _tmp6_;
			_tmp7_ = node;
			_tmp8_ = _tmp7_->symbol;
			if (_tmp8_ == NULL) {
				ValaGirParserNode* _tmp9_;
				ValaGirParserNode* _tmp10_;
				const gchar* _tmp11_;
				ValaGirParserNode* _tmp12_;
				ValaSourceReference* _tmp13_;
				ValaNamespace* _tmp14_;
				_tmp9_ = node;
				_tmp10_ = node;
				_tmp11_ = _tmp10_->name;
				_tmp12_ = node;
				_tmp13_ = _tmp12_->source_reference;
				_tmp14_ = vala_namespace_new (_tmp11_, _tmp13_);
				_vala_code_node_unref0 (_tmp9_->symbol);
				_tmp9_->symbol = (ValaSymbol*) _tmp14_;
			}
			_vala_gir_parser_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
}

static void
vala_gir_parser_resolve_type_arguments (ValaGirParser* self)
{
	ValaMapIterator* it = NULL;
	ValaHashMap* _tmp0_;
	ValaMapIterator* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->unresolved_type_arguments;
	_tmp1_ = vala_map_map_iterator ((ValaMap*) _tmp0_);
	it = _tmp1_;
	while (TRUE) {
		ValaMapIterator* _tmp2_;
		ValaUnresolvedType* element_type = NULL;
		ValaMapIterator* _tmp3_;
		gpointer _tmp4_;
		ValaGirParserNode* parent = NULL;
		ValaMapIterator* _tmp5_;
		gpointer _tmp6_;
		ValaTypeSymbol* sym = NULL;
		ValaGirParserNode* _tmp7_;
		ValaUnresolvedType* _tmp8_;
		ValaUnresolvedSymbol* _tmp9_;
		ValaUnresolvedSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaStruct* st = NULL;
		ValaTypeSymbol* _tmp12_;
		ValaStruct* _tmp13_;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		ValaStruct* _tmp16_;
		_tmp2_ = it;
		if (!vala_map_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = it;
		_tmp4_ = vala_map_iterator_get_key (_tmp3_);
		element_type = (ValaUnresolvedType*) _tmp4_;
		_tmp5_ = it;
		_tmp6_ = vala_map_iterator_get_value (_tmp5_);
		parent = (ValaGirParserNode*) _tmp6_;
		_tmp7_ = parent;
		_tmp8_ = element_type;
		_tmp9_ = vala_unresolved_type_get_unresolved_symbol (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_gir_parser_resolve_symbol (self, _tmp7_, _tmp10_);
		sym = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		_tmp12_ = sym;
		_tmp13_ = _vala_code_node_ref0 (VALA_IS_STRUCT (_tmp12_) ? ((ValaStruct*) _tmp12_) : NULL);
		st = _tmp13_;
		_tmp16_ = st;
		if (_tmp16_ != NULL) {
			ValaStruct* _tmp17_;
			_tmp17_ = st;
			_tmp15_ = !vala_struct_is_integer_type (_tmp17_);
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			ValaStruct* _tmp18_;
			_tmp18_ = st;
			_tmp14_ = !vala_struct_is_floating_type (_tmp18_);
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			ValaUnresolvedType* _tmp19_;
			_tmp19_ = element_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp19_, TRUE);
		}
		_vala_code_node_unref0 (st);
		_vala_code_node_unref0 (sym);
		_vala_gir_parser_node_unref0 (parent);
		_vala_code_node_unref0 (element_type);
	}
	_vala_map_iterator_unref0 (it);
}

static void
vala_gir_parser_process_interface (ValaGirParser* self,
                                   ValaGirParserNode* iface_node)
{
	ValaInterface* iface = NULL;
	ValaSymbol* _tmp0_;
	ValaInterface* _tmp1_;
	gboolean has_instantiable_prereq = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface_node != NULL);
	_tmp0_ = iface_node->symbol;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALA_TYPE_INTERFACE, ValaInterface));
	iface = _tmp1_;
	has_instantiable_prereq = FALSE;
	{
		ValaList* _prereq_list = NULL;
		ValaInterface* _tmp2_;
		ValaList* _tmp3_;
		ValaList* _tmp4_;
		gint _prereq_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _prereq_index = 0;
		_tmp2_ = iface;
		_tmp3_ = vala_interface_get_prerequisites (_tmp2_);
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_prereq_list = _tmp4_;
		_tmp5_ = _prereq_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_prereq_size = _tmp7_;
		_prereq_index = -1;
		while (TRUE) {
			ValaDataType* prereq = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaSymbol* sym = NULL;
			ValaDataType* _tmp10_;
			ValaSymbol* _tmp22_;
			_prereq_index = _prereq_index + 1;
			if (!(_prereq_index < _prereq_size)) {
				break;
			}
			_tmp8_ = _prereq_list;
			_tmp9_ = vala_list_get (_tmp8_, _prereq_index);
			prereq = (ValaDataType*) _tmp9_;
			sym = NULL;
			_tmp10_ = prereq;
			if (VALA_IS_UNRESOLVED_TYPE (_tmp10_)) {
				ValaUnresolvedSymbol* unresolved_symbol = NULL;
				ValaDataType* _tmp11_;
				ValaUnresolvedSymbol* _tmp12_;
				ValaUnresolvedSymbol* _tmp13_;
				ValaUnresolvedSymbol* _tmp14_;
				ValaGirParserNode* _tmp15_;
				ValaUnresolvedSymbol* _tmp16_;
				ValaSymbol* _tmp17_;
				_tmp11_ = prereq;
				_tmp12_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
				_tmp13_ = _tmp12_;
				_tmp14_ = _vala_code_node_ref0 (_tmp13_);
				unresolved_symbol = _tmp14_;
				_tmp15_ = iface_node->parent;
				_tmp16_ = unresolved_symbol;
				_tmp17_ = vala_gir_parser_resolve_symbol (self, _tmp15_, _tmp16_);
				_vala_code_node_unref0 (sym);
				sym = _tmp17_;
				_vala_code_node_unref0 (unresolved_symbol);
			} else {
				ValaDataType* _tmp18_;
				ValaTypeSymbol* _tmp19_;
				ValaTypeSymbol* _tmp20_;
				ValaSymbol* _tmp21_;
				_tmp18_ = prereq;
				_tmp19_ = vala_data_type_get_type_symbol (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp20_);
				_vala_code_node_unref0 (sym);
				sym = _tmp21_;
			}
			_tmp22_ = sym;
			if (VALA_IS_CLASS (_tmp22_)) {
				has_instantiable_prereq = TRUE;
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (prereq);
				break;
			}
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	if (!has_instantiable_prereq) {
		ValaArrayList* _tmp23_;
		ValaInterface* _tmp24_;
		_tmp23_ = self->priv->ifaces_needing_object_prereq;
		_tmp24_ = iface;
		vala_collection_add ((ValaCollection*) _tmp23_, _tmp24_);
	}
	_vala_code_node_unref0 (iface);
}

static void
vala_gir_parser_process_alias (ValaGirParser* self,
                               ValaGirParserNode* alias)
{
	ValaDataType* base_type = NULL;
	ValaSymbol* type_sym = NULL;
	ValaGirParserNode* base_node = NULL;
	gboolean simple_type = FALSE;
	ValaDataType* _tmp0_;
	gboolean _tmp32_ = FALSE;
	ValaSymbol* _tmp33_;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	ValaDataType* _tmp37_;
	gboolean _tmp148_ = FALSE;
	ValaSymbol* _tmp149_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (alias != NULL);
	base_type = NULL;
	type_sym = NULL;
	base_node = NULL;
	simple_type = FALSE;
	_tmp0_ = alias->base_type;
	if (VALA_IS_UNRESOLVED_TYPE (_tmp0_)) {
		ValaDataType* _tmp1_;
		ValaDataType* _tmp2_;
		ValaGirParserNode* _tmp3_;
		ValaDataType* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		ValaUnresolvedSymbol* _tmp6_;
		ValaGirParserNode* _tmp7_;
		ValaGirParserNode* _tmp8_;
		_tmp1_ = alias->base_type;
		_tmp2_ = _vala_code_node_ref0 (_tmp1_);
		_vala_code_node_unref0 (base_type);
		base_type = _tmp2_;
		_tmp3_ = alias->parent;
		_tmp4_ = base_type;
		_tmp5_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_gir_parser_resolve_node (self, _tmp3_, _tmp6_, FALSE);
		_vala_gir_parser_node_unref0 (base_node);
		base_node = _tmp7_;
		_tmp8_ = base_node;
		if (_tmp8_ != NULL) {
			ValaGirParserNode* _tmp9_;
			ValaSymbol* _tmp10_;
			ValaSymbol* _tmp11_;
			_tmp9_ = base_node;
			_tmp10_ = _tmp9_->symbol;
			_tmp11_ = _vala_code_node_ref0 (_tmp10_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp11_;
		}
	} else {
		gboolean _tmp12_ = FALSE;
		ValaDataType* _tmp13_;
		_tmp13_ = alias->base_type;
		if (VALA_IS_POINTER_TYPE (_tmp13_)) {
			ValaDataType* _tmp14_;
			ValaDataType* _tmp15_;
			ValaDataType* _tmp16_;
			_tmp14_ = alias->base_type;
			_tmp15_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
			_tmp16_ = _tmp15_;
			_tmp12_ = VALA_IS_VOID_TYPE (_tmp16_);
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			simple_type = TRUE;
		} else {
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			ValaDataType* _tmp19_;
			ValaTypeSymbol* _tmp20_;
			ValaTypeSymbol* _tmp21_;
			ValaSymbol* _tmp22_;
			ValaSymbol* _tmp23_;
			_tmp17_ = alias->base_type;
			_tmp18_ = _vala_code_node_ref0 (_tmp17_);
			_vala_code_node_unref0 (base_type);
			base_type = _tmp18_;
			_tmp19_ = base_type;
			_tmp20_ = vala_data_type_get_type_symbol (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp21_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp22_;
			_tmp23_ = type_sym;
			if (_tmp23_ != NULL) {
				ValaGirParserNode* _tmp24_;
				ValaSymbol* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				ValaSourceReference* _tmp28_;
				ValaUnresolvedSymbol* _tmp29_;
				ValaUnresolvedSymbol* _tmp30_;
				ValaGirParserNode* _tmp31_;
				_tmp24_ = alias->parent;
				_tmp25_ = type_sym;
				_tmp26_ = vala_symbol_get_full_name (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = alias->source_reference;
				_tmp29_ = vala_gir_parser_parse_symbol_from_string (self, _tmp27_, _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = vala_gir_parser_resolve_node (self, _tmp24_, _tmp30_, FALSE);
				_vala_gir_parser_node_unref0 (base_node);
				base_node = _tmp31_;
				_vala_code_node_unref0 (_tmp30_);
				_g_free0 (_tmp27_);
			}
		}
	}
	_tmp33_ = type_sym;
	if (VALA_IS_STRUCT (_tmp33_)) {
		ValaSymbol* _tmp34_;
		_tmp34_ = type_sym;
		_tmp32_ = vala_struct_is_simple_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, VALA_TYPE_STRUCT, ValaStruct));
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		simple_type = TRUE;
	}
	_tmp37_ = base_type;
	if (_tmp37_ == NULL) {
		_tmp36_ = TRUE;
	} else {
		ValaSymbol* _tmp38_;
		_tmp38_ = type_sym;
		_tmp36_ = _tmp38_ == NULL;
	}
	if (_tmp36_) {
		_tmp35_ = TRUE;
	} else {
		ValaSymbol* _tmp39_;
		_tmp39_ = type_sym;
		_tmp35_ = VALA_IS_STRUCT (_tmp39_);
	}
	if (_tmp35_) {
		ValaStruct* st = NULL;
		const gchar* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaStruct* _tmp42_;
		ValaStruct* _tmp43_;
		ValaDataType* _tmp44_;
		ValaStruct* _tmp47_;
		ValaGirComment* _tmp48_;
		ValaStruct* _tmp49_;
		ValaStruct* _tmp50_;
		ValaSymbol* _tmp51_;
		_tmp40_ = alias->name;
		_tmp41_ = alias->source_reference;
		_tmp42_ = vala_struct_new (_tmp40_, _tmp41_, NULL);
		st = _tmp42_;
		_tmp43_ = st;
		vala_symbol_set_access ((ValaSymbol*) _tmp43_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp44_ = base_type;
		if (_tmp44_ != NULL) {
			ValaStruct* _tmp45_;
			ValaDataType* _tmp46_;
			_tmp45_ = st;
			_tmp46_ = base_type;
			vala_struct_set_base_type (_tmp45_, _tmp46_);
		}
		_tmp47_ = st;
		_tmp48_ = alias->comment;
		vala_symbol_set_comment ((ValaSymbol*) _tmp47_, (ValaComment*) _tmp48_);
		_tmp49_ = st;
		vala_struct_set_simple_type (_tmp49_, simple_type);
		_tmp50_ = st;
		_tmp51_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp50_);
		_vala_code_node_unref0 (alias->symbol);
		alias->symbol = _tmp51_;
		_vala_code_node_unref0 (st);
	} else {
		ValaSymbol* _tmp52_;
		_tmp52_ = type_sym;
		if (VALA_IS_CLASS (_tmp52_)) {
			ValaClass* cl = NULL;
			const gchar* _tmp53_;
			ValaSourceReference* _tmp54_;
			ValaClass* _tmp55_;
			ValaClass* _tmp56_;
			ValaDataType* _tmp57_;
			ValaClass* _tmp60_;
			ValaGirComment* _tmp61_;
			ValaClass* _tmp62_;
			ValaSymbol* _tmp63_;
			gboolean _tmp64_;
			gboolean _tmp65_;
			ValaClass* _tmp66_;
			ValaSymbol* _tmp67_;
			_tmp53_ = alias->name;
			_tmp54_ = alias->source_reference;
			_tmp55_ = vala_class_new (_tmp53_, _tmp54_, NULL);
			cl = _tmp55_;
			_tmp56_ = cl;
			vala_symbol_set_access ((ValaSymbol*) _tmp56_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp57_ = base_type;
			if (_tmp57_ != NULL) {
				ValaClass* _tmp58_;
				ValaDataType* _tmp59_;
				_tmp58_ = cl;
				_tmp59_ = base_type;
				vala_class_add_base_type (_tmp58_, _tmp59_);
			}
			_tmp60_ = cl;
			_tmp61_ = alias->comment;
			vala_symbol_set_comment ((ValaSymbol*) _tmp60_, (ValaComment*) _tmp61_);
			_tmp62_ = cl;
			_tmp63_ = type_sym;
			_tmp64_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_CLASS, ValaClass));
			_tmp65_ = _tmp64_;
			vala_class_set_is_compact (_tmp62_, _tmp65_);
			_tmp66_ = cl;
			_tmp67_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp66_);
			_vala_code_node_unref0 (alias->symbol);
			alias->symbol = _tmp67_;
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp68_;
			_tmp68_ = type_sym;
			if (VALA_IS_INTERFACE (_tmp68_)) {
				ValaInterface* iface = NULL;
				const gchar* _tmp69_;
				ValaSourceReference* _tmp70_;
				ValaInterface* _tmp71_;
				ValaInterface* _tmp72_;
				ValaDataType* _tmp73_;
				ValaInterface* _tmp76_;
				ValaGirComment* _tmp77_;
				ValaInterface* _tmp78_;
				ValaSymbol* _tmp79_;
				_tmp69_ = alias->name;
				_tmp70_ = alias->source_reference;
				_tmp71_ = vala_interface_new (_tmp69_, _tmp70_, NULL);
				iface = _tmp71_;
				_tmp72_ = iface;
				vala_symbol_set_access ((ValaSymbol*) _tmp72_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
				_tmp73_ = base_type;
				if (_tmp73_ != NULL) {
					ValaInterface* _tmp74_;
					ValaDataType* _tmp75_;
					_tmp74_ = iface;
					_tmp75_ = base_type;
					vala_interface_add_prerequisite (_tmp74_, _tmp75_);
				}
				_tmp76_ = iface;
				_tmp77_ = alias->comment;
				vala_symbol_set_comment ((ValaSymbol*) _tmp76_, (ValaComment*) _tmp77_);
				_tmp78_ = iface;
				_tmp79_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp78_);
				_vala_code_node_unref0 (alias->symbol);
				alias->symbol = _tmp79_;
				_vala_code_node_unref0 (iface);
			} else {
				ValaSymbol* _tmp80_;
				_tmp80_ = type_sym;
				if (VALA_IS_DELEGATE (_tmp80_)) {
					ValaDelegate* orig = NULL;
					ValaSymbol* _tmp81_;
					ValaDelegate* _tmp82_;
					ValaGirParserNode* _tmp83_;
					ValaDelegate* deleg = NULL;
					const gchar* _tmp88_;
					ValaDelegate* _tmp89_;
					ValaDataType* _tmp90_;
					ValaDataType* _tmp91_;
					ValaDataType* _tmp92_;
					ValaDataType* _tmp93_;
					ValaSourceReference* _tmp94_;
					ValaDelegate* _tmp95_;
					ValaDelegate* _tmp96_;
					ValaDelegate* _tmp97_;
					ValaDelegate* _tmp98_;
					ValaSymbolAccessibility _tmp99_;
					ValaSymbolAccessibility _tmp100_;
					ValaArrayList* error_types = NULL;
					GEqualFunc _tmp113_;
					ValaArrayList* _tmp114_;
					ValaDelegate* _tmp115_;
					ValaArrayList* _tmp116_;
					ValaSourceReference* _tmp117_;
					ValaDelegate* _tmp129_;
					GList* _tmp130_;
					ValaDelegate* _tmp135_;
					ValaSymbol* _tmp136_;
					_tmp81_ = type_sym;
					_tmp82_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, VALA_TYPE_DELEGATE, ValaDelegate));
					orig = _tmp82_;
					_tmp83_ = base_node;
					if (_tmp83_ != NULL) {
						ValaGirParserNode* _tmp84_;
						ValaGirParserNode* _tmp85_;
						ValaSymbol* _tmp86_;
						ValaDelegate* _tmp87_;
						_tmp84_ = base_node;
						vala_gir_parser_node_process (_tmp84_, self);
						_tmp85_ = base_node;
						_tmp86_ = _tmp85_->symbol;
						_tmp87_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_DELEGATE, ValaDelegate));
						_vala_code_node_unref0 (orig);
						orig = _tmp87_;
					}
					_tmp88_ = alias->name;
					_tmp89_ = orig;
					_tmp90_ = vala_callable_get_return_type ((ValaCallable*) _tmp89_);
					_tmp91_ = _tmp90_;
					_tmp92_ = vala_data_type_copy (_tmp91_);
					_tmp93_ = _tmp92_;
					_tmp94_ = alias->source_reference;
					_tmp95_ = vala_delegate_new (_tmp88_, _tmp93_, _tmp94_, NULL);
					_tmp96_ = _tmp95_;
					_vala_code_node_unref0 (_tmp93_);
					deleg = _tmp96_;
					_tmp97_ = deleg;
					_tmp98_ = orig;
					_tmp99_ = vala_symbol_get_access ((ValaSymbol*) _tmp98_);
					_tmp100_ = _tmp99_;
					vala_symbol_set_access ((ValaSymbol*) _tmp97_, _tmp100_);
					{
						ValaList* _param_list = NULL;
						ValaDelegate* _tmp101_;
						ValaList* _tmp102_;
						ValaList* _tmp103_;
						gint _param_size = 0;
						ValaList* _tmp104_;
						gint _tmp105_;
						gint _tmp106_;
						gint _param_index = 0;
						_tmp101_ = orig;
						_tmp102_ = vala_callable_get_parameters ((ValaCallable*) _tmp101_);
						_tmp103_ = _vala_iterable_ref0 (_tmp102_);
						_param_list = _tmp103_;
						_tmp104_ = _param_list;
						_tmp105_ = vala_collection_get_size ((ValaCollection*) _tmp104_);
						_tmp106_ = _tmp105_;
						_param_size = _tmp106_;
						_param_index = -1;
						while (TRUE) {
							ValaParameter* param = NULL;
							ValaList* _tmp107_;
							gpointer _tmp108_;
							ValaDelegate* _tmp109_;
							ValaParameter* _tmp110_;
							ValaParameter* _tmp111_;
							ValaParameter* _tmp112_;
							_param_index = _param_index + 1;
							if (!(_param_index < _param_size)) {
								break;
							}
							_tmp107_ = _param_list;
							_tmp108_ = vala_list_get (_tmp107_, _param_index);
							param = (ValaParameter*) _tmp108_;
							_tmp109_ = deleg;
							_tmp110_ = param;
							_tmp111_ = vala_parameter_copy (_tmp110_);
							_tmp112_ = _tmp111_;
							vala_callable_add_parameter ((ValaCallable*) _tmp109_, _tmp112_);
							_vala_code_node_unref0 (_tmp112_);
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
					_tmp113_ = g_direct_equal;
					_tmp114_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp113_);
					error_types = _tmp114_;
					_tmp115_ = orig;
					_tmp116_ = error_types;
					_tmp117_ = alias->source_reference;
					vala_code_node_get_error_types ((ValaCodeNode*) _tmp115_, (ValaCollection*) _tmp116_, _tmp117_);
					{
						ValaArrayList* _error_type_list = NULL;
						ValaArrayList* _tmp118_;
						ValaArrayList* _tmp119_;
						gint _error_type_size = 0;
						ValaArrayList* _tmp120_;
						gint _tmp121_;
						gint _tmp122_;
						gint _error_type_index = 0;
						_tmp118_ = error_types;
						_tmp119_ = _vala_iterable_ref0 (_tmp118_);
						_error_type_list = _tmp119_;
						_tmp120_ = _error_type_list;
						_tmp121_ = vala_collection_get_size ((ValaCollection*) _tmp120_);
						_tmp122_ = _tmp121_;
						_error_type_size = _tmp122_;
						_error_type_index = -1;
						while (TRUE) {
							ValaDataType* error_type = NULL;
							ValaArrayList* _tmp123_;
							gpointer _tmp124_;
							ValaDelegate* _tmp125_;
							ValaDataType* _tmp126_;
							ValaDataType* _tmp127_;
							ValaDataType* _tmp128_;
							_error_type_index = _error_type_index + 1;
							if (!(_error_type_index < _error_type_size)) {
								break;
							}
							_tmp123_ = _error_type_list;
							_tmp124_ = vala_list_get ((ValaList*) _tmp123_, _error_type_index);
							error_type = (ValaDataType*) _tmp124_;
							_tmp125_ = deleg;
							_tmp126_ = error_type;
							_tmp127_ = vala_data_type_copy (_tmp126_);
							_tmp128_ = _tmp127_;
							vala_delegate_add_error_type (_tmp125_, _tmp128_);
							_vala_code_node_unref0 (_tmp128_);
							_vala_code_node_unref0 (error_type);
						}
						_vala_iterable_unref0 (_error_type_list);
					}
					_tmp129_ = orig;
					_tmp130_ = ((ValaCodeNode*) _tmp129_)->attributes;
					{
						GList* attribute_collection = NULL;
						GList* attribute_it = NULL;
						attribute_collection = _tmp130_;
						for (attribute_it = attribute_collection; attribute_it != NULL; attribute_it = attribute_it->next) {
							ValaAttribute* _tmp131_;
							ValaAttribute* attribute = NULL;
							_tmp131_ = _vala_code_node_ref0 ((ValaAttribute*) attribute_it->data);
							attribute = _tmp131_;
							{
								ValaDelegate* _tmp132_;
								ValaAttribute* _tmp133_;
								ValaAttribute* _tmp134_;
								_tmp132_ = deleg;
								_tmp133_ = attribute;
								_tmp134_ = _vala_code_node_ref0 (_tmp133_);
								((ValaCodeNode*) _tmp132_)->attributes = g_list_append (((ValaCodeNode*) _tmp132_)->attributes, _tmp134_);
								_vala_code_node_unref0 (attribute);
							}
						}
					}
					_tmp135_ = deleg;
					_tmp136_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp135_);
					_vala_code_node_unref0 (alias->symbol);
					alias->symbol = _tmp136_;
					_vala_iterable_unref0 (error_types);
					_vala_code_node_unref0 (deleg);
					_vala_code_node_unref0 (orig);
				} else {
					ValaSymbol* _tmp137_;
					_tmp137_ = type_sym;
					if (_tmp137_ != NULL) {
						ValaSourceReference* _tmp138_;
						gchar* _tmp139_;
						gchar* _tmp140_;
						ValaSymbol* _tmp141_;
						gchar* _tmp142_;
						gchar* _tmp143_;
						gchar* _tmp144_;
						gchar* _tmp145_;
						ValaSymbol* _tmp146_;
						ValaSymbol* _tmp147_;
						_tmp138_ = alias->source_reference;
						_tmp139_ = vala_gir_parser_node_get_full_name (alias);
						_tmp140_ = _tmp139_;
						_tmp141_ = type_sym;
						_tmp142_ = vala_symbol_get_full_name (_tmp141_);
						_tmp143_ = _tmp142_;
						_tmp144_ = g_strdup_printf ("alias `%s' for `%s' is not supported", _tmp140_, _tmp143_);
						_tmp145_ = _tmp144_;
						vala_report_warning (_tmp138_, _tmp145_);
						_g_free0 (_tmp145_);
						_g_free0 (_tmp143_);
						_g_free0 (_tmp140_);
						_tmp146_ = type_sym;
						_tmp147_ = _vala_code_node_ref0 (_tmp146_);
						_vala_code_node_unref0 (alias->symbol);
						alias->symbol = _tmp147_;
						alias->merged = TRUE;
					}
				}
			}
		}
	}
	_tmp149_ = type_sym;
	if (VALA_IS_CLASS (_tmp149_)) {
		_tmp148_ = TRUE;
	} else {
		gboolean _tmp150_ = FALSE;
		ValaSymbol* _tmp151_;
		_tmp151_ = type_sym;
		if (VALA_IS_STRUCT (_tmp151_)) {
			_tmp150_ = !simple_type;
		} else {
			_tmp150_ = FALSE;
		}
		_tmp148_ = _tmp150_;
	}
	if (_tmp148_) {
		ValaSymbol* _tmp152_;
		_tmp152_ = type_sym;
		if (vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp152_, "CCode", "has_type_id")) {
			ValaSymbol* _tmp153_;
			ValaSymbol* _tmp154_;
			_tmp153_ = alias->symbol;
			_tmp154_ = type_sym;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp153_, "CCode", "has_type_id", vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp154_, "CCode", "has_type_id", FALSE), NULL);
		} else {
			ValaSymbol* _tmp155_;
			_tmp155_ = type_sym;
			if (vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp155_, "CCode", "type_id")) {
				ValaSymbol* _tmp156_;
				ValaSymbol* _tmp157_;
				gchar* _tmp158_;
				gchar* _tmp159_;
				_tmp156_ = alias->symbol;
				_tmp157_ = type_sym;
				_tmp158_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp157_, "CCode", "type_id", NULL);
				_tmp159_ = _tmp158_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp156_, "CCode", "type_id", _tmp159_, NULL);
				_g_free0 (_tmp159_);
			}
		}
	}
	_vala_gir_parser_node_unref0 (base_node);
	_vala_code_node_unref0 (type_sym);
	_vala_code_node_unref0 (base_type);
}

static void
vala_gir_parser_process_callable (ValaGirParser* self,
                                  ValaGirParserNode* node)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	ValaSymbol* s = NULL;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaList* parameters = NULL;
	ValaList* _tmp5_;
	ValaList* _tmp6_;
	ValaDataType* return_type = NULL;
	ValaSymbol* _tmp7_;
	gboolean _tmp12_ = FALSE;
	ValaDataType* _tmp13_;
	ValaList* _tmp148_;
	gint _tmp149_;
	gint _tmp150_;
	gint i = 0;
	gint j = 0;
	gint first_out = 0;
	gint last = 0;
	gboolean _tmp364_ = FALSE;
	ValaDataType* _tmp365_;
	ValaSymbol* _tmp370_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp1_ = node->element_type;
	if (g_strcmp0 (_tmp1_, "alias") == 0) {
		ValaSymbol* _tmp2_;
		_tmp2_ = node->symbol;
		_tmp0_ = VALA_IS_DELEGATE (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = node->symbol;
	_tmp4_ = _vala_code_node_ref0 (_tmp3_);
	s = _tmp4_;
	_tmp5_ = node->parameters;
	_tmp6_ = _vala_iterable_ref0 (_tmp5_);
	parameters = _tmp6_;
	return_type = NULL;
	_tmp7_ = s;
	if (VALA_IS_CALLABLE (_tmp7_)) {
		ValaSymbol* _tmp8_;
		ValaDataType* _tmp9_;
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp8_ = s;
		_tmp9_ = vala_callable_get_return_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_CALLABLE, ValaCallable));
		_tmp10_ = _tmp9_;
		_tmp11_ = _vala_code_node_ref0 (_tmp10_);
		_vala_code_node_unref0 (return_type);
		return_type = _tmp11_;
	}
	_tmp13_ = return_type;
	if (VALA_IS_ARRAY_TYPE (_tmp13_)) {
		_tmp12_ = node->return_array_length_idx >= 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp14_ = parameters;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		if (node->return_array_length_idx >= _tmp16_) {
			ValaDataType* _tmp17_;
			ValaSourceReference* _tmp18_;
			ValaSourceReference* _tmp19_;
			_tmp17_ = return_type;
			_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp17_);
			_tmp19_ = _tmp18_;
			vala_report_error (_tmp19_, "invalid array length index");
		} else {
			ValaList* _tmp20_;
			gpointer _tmp21_;
			ValaGirParserParameterInfo* _tmp22_;
			ValaArrayList* _tmp23_;
			_tmp20_ = parameters;
			_tmp21_ = vala_list_get (_tmp20_, node->return_array_length_idx);
			_tmp22_ = (ValaGirParserParameterInfo*) _tmp21_;
			_tmp22_->keep = FALSE;
			_vala_gir_parser_parameter_info_unref0 (_tmp22_);
			_tmp23_ = node->array_length_parameters;
			vala_collection_add ((ValaCollection*) _tmp23_, (gpointer) ((gintptr) node->return_array_length_idx));
		}
	} else {
		gboolean _tmp24_ = FALSE;
		ValaDataType* _tmp25_;
		_tmp25_ = return_type;
		if (VALA_IS_VOID_TYPE (_tmp25_)) {
			ValaList* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			_tmp26_ = parameters;
			_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
			_tmp28_ = _tmp27_;
			_tmp24_ = _tmp28_ > 0;
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			gint n_out_parameters = 0;
			n_out_parameters = 0;
			{
				ValaList* _info_list = NULL;
				ValaList* _tmp29_;
				ValaList* _tmp30_;
				gint _info_size = 0;
				ValaList* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gint _info_index = 0;
				_tmp29_ = parameters;
				_tmp30_ = _vala_iterable_ref0 (_tmp29_);
				_info_list = _tmp30_;
				_tmp31_ = _info_list;
				_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
				_tmp33_ = _tmp32_;
				_info_size = _tmp33_;
				_info_index = -1;
				while (TRUE) {
					ValaGirParserParameterInfo* info = NULL;
					ValaList* _tmp34_;
					gpointer _tmp35_;
					ValaGirParserParameterInfo* _tmp36_;
					ValaParameter* _tmp37_;
					ValaParameterDirection _tmp38_;
					ValaParameterDirection _tmp39_;
					_info_index = _info_index + 1;
					if (!(_info_index < _info_size)) {
						break;
					}
					_tmp34_ = _info_list;
					_tmp35_ = vala_list_get (_tmp34_, _info_index);
					info = (ValaGirParserParameterInfo*) _tmp35_;
					_tmp36_ = info;
					_tmp37_ = _tmp36_->param;
					_tmp38_ = vala_parameter_get_direction (_tmp37_);
					_tmp39_ = _tmp38_;
					if (_tmp39_ == VALA_PARAMETER_DIRECTION_OUT) {
						gint _tmp40_;
						_tmp40_ = n_out_parameters;
						n_out_parameters = _tmp40_ + 1;
					}
					_vala_gir_parser_parameter_info_unref0 (info);
				}
				_vala_iterable_unref0 (_info_list);
			}
			if (n_out_parameters == 1) {
				ValaGirParserParameterInfo* last_param = NULL;
				ValaList* _tmp41_;
				ValaList* _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				gpointer _tmp45_;
				ValaGirParserParameterInfo* _tmp46_;
				ValaParameter* _tmp47_;
				ValaParameterDirection _tmp48_;
				ValaParameterDirection _tmp49_;
				_tmp41_ = parameters;
				_tmp42_ = parameters;
				_tmp43_ = vala_collection_get_size ((ValaCollection*) _tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = vala_list_get (_tmp41_, _tmp44_ - 1);
				last_param = (ValaGirParserParameterInfo*) _tmp45_;
				_tmp46_ = last_param;
				_tmp47_ = _tmp46_->param;
				_tmp48_ = vala_parameter_get_direction (_tmp47_);
				_tmp49_ = _tmp48_;
				if (_tmp49_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaGirParserParameterInfo* _tmp50_;
					ValaParameter* _tmp51_;
					ValaDataType* _tmp52_;
					ValaDataType* _tmp53_;
					_tmp50_ = last_param;
					_tmp51_ = _tmp50_->param;
					_tmp52_ = vala_variable_get_variable_type ((ValaVariable*) _tmp51_);
					_tmp53_ = _tmp52_;
					if (VALA_IS_UNRESOLVED_TYPE (_tmp53_)) {
						ValaStruct* st = NULL;
						ValaGirParserNode* _tmp54_;
						ValaGirParserParameterInfo* _tmp55_;
						ValaParameter* _tmp56_;
						ValaDataType* _tmp57_;
						ValaDataType* _tmp58_;
						ValaUnresolvedSymbol* _tmp59_;
						ValaUnresolvedSymbol* _tmp60_;
						ValaSymbol* _tmp61_;
						ValaStruct* _tmp62_;
						gboolean _tmp63_ = FALSE;
						gboolean _tmp64_ = FALSE;
						ValaStruct* _tmp65_;
						_tmp54_ = node->parent;
						_tmp55_ = last_param;
						_tmp56_ = _tmp55_->param;
						_tmp57_ = vala_variable_get_variable_type ((ValaVariable*) _tmp56_);
						_tmp58_ = _tmp57_;
						_tmp59_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
						_tmp60_ = _tmp59_;
						_tmp61_ = vala_gir_parser_resolve_symbol (self, _tmp54_, _tmp60_);
						_tmp62_ = VALA_IS_STRUCT (_tmp61_) ? ((ValaStruct*) _tmp61_) : NULL;
						if (_tmp62_ == NULL) {
							_vala_code_node_unref0 (_tmp61_);
						}
						st = _tmp62_;
						_tmp65_ = st;
						if (_tmp65_ != NULL) {
							ValaStruct* _tmp66_;
							_tmp66_ = st;
							_tmp64_ = !vala_struct_is_simple_type (_tmp66_);
						} else {
							_tmp64_ = FALSE;
						}
						if (_tmp64_) {
							ValaGirParserParameterInfo* _tmp67_;
							ValaParameter* _tmp68_;
							ValaDataType* _tmp69_;
							ValaDataType* _tmp70_;
							gboolean _tmp71_;
							gboolean _tmp72_;
							_tmp67_ = last_param;
							_tmp68_ = _tmp67_->param;
							_tmp69_ = vala_variable_get_variable_type ((ValaVariable*) _tmp68_);
							_tmp70_ = _tmp69_;
							_tmp71_ = vala_data_type_get_nullable (_tmp70_);
							_tmp72_ = _tmp71_;
							_tmp63_ = !_tmp72_;
						} else {
							_tmp63_ = FALSE;
						}
						if (_tmp63_) {
							ValaGirParserMetadata* _tmp73_;
							_tmp73_ = node->metadata;
							if (!vala_gir_parser_metadata_get_bool (_tmp73_, VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID, FALSE)) {
								ValaGirParserParameterInfo* _tmp74_;
								ValaGirParserParameterInfo* _tmp75_;
								ValaParameter* _tmp76_;
								ValaDataType* _tmp77_;
								ValaDataType* _tmp78_;
								ValaDataType* _tmp79_;
								_tmp74_ = last_param;
								_tmp74_->keep = FALSE;
								_tmp75_ = last_param;
								_tmp76_ = _tmp75_->param;
								_tmp77_ = vala_variable_get_variable_type ((ValaVariable*) _tmp76_);
								_tmp78_ = _tmp77_;
								_tmp79_ = vala_data_type_copy (_tmp78_);
								_vala_code_node_unref0 (return_type);
								return_type = _tmp79_;
							}
						}
						_vala_code_node_unref0 (st);
					}
				}
				_vala_gir_parser_parameter_info_unref0 (last_param);
			}
		} else {
			gboolean _tmp80_ = FALSE;
			ValaDataType* _tmp81_;
			_tmp81_ = return_type;
			if (VALA_IS_UNRESOLVED_TYPE (_tmp81_)) {
				ValaDataType* _tmp82_;
				gboolean _tmp83_;
				gboolean _tmp84_;
				_tmp82_ = return_type;
				_tmp83_ = vala_data_type_get_nullable (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp80_ = !_tmp84_;
			} else {
				_tmp80_ = FALSE;
			}
			if (_tmp80_) {
				ValaStruct* st = NULL;
				ValaGirParserNode* _tmp85_;
				ValaDataType* _tmp86_;
				ValaUnresolvedSymbol* _tmp87_;
				ValaUnresolvedSymbol* _tmp88_;
				ValaSymbol* _tmp89_;
				ValaStruct* _tmp90_;
				ValaStruct* _tmp91_;
				_tmp85_ = node->parent;
				_tmp86_ = return_type;
				_tmp87_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
				_tmp88_ = _tmp87_;
				_tmp89_ = vala_gir_parser_resolve_symbol (self, _tmp85_, _tmp88_);
				_tmp90_ = VALA_IS_STRUCT (_tmp89_) ? ((ValaStruct*) _tmp89_) : NULL;
				if (_tmp90_ == NULL) {
					_vala_code_node_unref0 (_tmp89_);
				}
				st = _tmp90_;
				_tmp91_ = st;
				if (_tmp91_ != NULL) {
					gboolean is_simple_type = FALSE;
					ValaStruct* base_st = NULL;
					ValaStruct* _tmp92_;
					ValaStruct* _tmp93_;
					is_simple_type = FALSE;
					_tmp92_ = st;
					_tmp93_ = _vala_code_node_ref0 (_tmp92_);
					base_st = _tmp93_;
					while (TRUE) {
						ValaStruct* _tmp94_;
						ValaStruct* _tmp95_;
						ValaStruct* _tmp96_;
						ValaDataType* _tmp97_;
						ValaDataType* _tmp98_;
						_tmp94_ = base_st;
						if (!(_tmp94_ != NULL)) {
							break;
						}
						_tmp95_ = base_st;
						if (vala_struct_is_simple_type (_tmp95_)) {
							is_simple_type = TRUE;
							break;
						}
						_tmp96_ = base_st;
						_tmp97_ = vala_struct_get_base_type (_tmp96_);
						_tmp98_ = _tmp97_;
						if (VALA_IS_UNRESOLVED_TYPE (_tmp98_)) {
							ValaGirParserNode* _tmp99_;
							ValaStruct* _tmp100_;
							ValaDataType* _tmp101_;
							ValaDataType* _tmp102_;
							ValaUnresolvedSymbol* _tmp103_;
							ValaUnresolvedSymbol* _tmp104_;
							ValaSymbol* _tmp105_;
							ValaStruct* _tmp106_;
							_tmp99_ = node->parent;
							_tmp100_ = base_st;
							_tmp101_ = vala_struct_get_base_type (_tmp100_);
							_tmp102_ = _tmp101_;
							_tmp103_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
							_tmp104_ = _tmp103_;
							_tmp105_ = vala_gir_parser_resolve_symbol (self, _tmp99_, _tmp104_);
							_tmp106_ = VALA_IS_STRUCT (_tmp105_) ? ((ValaStruct*) _tmp105_) : NULL;
							if (_tmp106_ == NULL) {
								_vala_code_node_unref0 (_tmp105_);
							}
							_vala_code_node_unref0 (base_st);
							base_st = _tmp106_;
						} else {
							ValaStruct* _tmp107_;
							ValaStruct* _tmp108_;
							ValaStruct* _tmp109_;
							ValaStruct* _tmp110_;
							_tmp107_ = base_st;
							_tmp108_ = vala_struct_get_base_struct (_tmp107_);
							_tmp109_ = _tmp108_;
							_tmp110_ = _vala_code_node_ref0 (_tmp109_);
							_vala_code_node_unref0 (base_st);
							base_st = _tmp110_;
						}
					}
					if (!is_simple_type) {
						ValaDataType* _tmp111_;
						_tmp111_ = return_type;
						vala_data_type_set_nullable (_tmp111_, TRUE);
					}
					_vala_code_node_unref0 (base_st);
				}
				_vala_code_node_unref0 (st);
			}
		}
	}
	{
		ValaList* _info_list = NULL;
		ValaList* _tmp112_;
		ValaList* _tmp113_;
		gint _info_size = 0;
		ValaList* _tmp114_;
		gint _tmp115_;
		gint _tmp116_;
		gint _info_index = 0;
		_tmp112_ = parameters;
		_tmp113_ = _vala_iterable_ref0 (_tmp112_);
		_info_list = _tmp113_;
		_tmp114_ = _info_list;
		_tmp115_ = vala_collection_get_size ((ValaCollection*) _tmp114_);
		_tmp116_ = _tmp115_;
		_info_size = _tmp116_;
		_info_index = -1;
		while (TRUE) {
			ValaGirParserParameterInfo* info = NULL;
			ValaList* _tmp117_;
			gpointer _tmp118_;
			ValaDataType* type = NULL;
			ValaGirParserParameterInfo* _tmp119_;
			ValaParameter* _tmp120_;
			ValaDataType* _tmp121_;
			ValaDataType* _tmp122_;
			ValaDataType* _tmp123_;
			gboolean _tmp124_ = FALSE;
			ValaGirParserParameterInfo* _tmp125_;
			ValaParameter* _tmp126_;
			ValaParameterDirection _tmp127_;
			ValaParameterDirection _tmp128_;
			_info_index = _info_index + 1;
			if (!(_info_index < _info_size)) {
				break;
			}
			_tmp117_ = _info_list;
			_tmp118_ = vala_list_get (_tmp117_, _info_index);
			info = (ValaGirParserParameterInfo*) _tmp118_;
			_tmp119_ = info;
			_tmp120_ = _tmp119_->param;
			_tmp121_ = vala_variable_get_variable_type ((ValaVariable*) _tmp120_);
			_tmp122_ = _tmp121_;
			_tmp123_ = _vala_code_node_ref0 (_tmp122_);
			type = _tmp123_;
			_tmp125_ = info;
			_tmp126_ = _tmp125_->param;
			_tmp127_ = vala_parameter_get_direction (_tmp126_);
			_tmp128_ = _tmp127_;
			if (_tmp128_ == VALA_PARAMETER_DIRECTION_OUT) {
				ValaDataType* _tmp129_;
				gboolean _tmp130_;
				gboolean _tmp131_;
				_tmp129_ = type;
				_tmp130_ = vala_data_type_get_nullable (_tmp129_);
				_tmp131_ = _tmp130_;
				_tmp124_ = _tmp131_;
			} else {
				_tmp124_ = FALSE;
			}
			if (_tmp124_) {
				ValaStruct* st = NULL;
				ValaDataType* _tmp132_;
				gboolean _tmp144_ = FALSE;
				ValaStruct* _tmp145_;
				st = NULL;
				_tmp132_ = type;
				if (VALA_IS_UNRESOLVED_TYPE (_tmp132_)) {
					ValaGirParserNode* _tmp133_;
					ValaDataType* _tmp134_;
					ValaUnresolvedSymbol* _tmp135_;
					ValaUnresolvedSymbol* _tmp136_;
					ValaSymbol* _tmp137_;
					ValaStruct* _tmp138_;
					_tmp133_ = node->parent;
					_tmp134_ = type;
					_tmp135_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp134_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
					_tmp136_ = _tmp135_;
					_tmp137_ = vala_gir_parser_resolve_symbol (self, _tmp133_, _tmp136_);
					_tmp138_ = VALA_IS_STRUCT (_tmp137_) ? ((ValaStruct*) _tmp137_) : NULL;
					if (_tmp138_ == NULL) {
						_vala_code_node_unref0 (_tmp137_);
					}
					_vala_code_node_unref0 (st);
					st = _tmp138_;
				} else {
					ValaDataType* _tmp139_;
					_tmp139_ = type;
					if (VALA_IS_VALUE_TYPE (_tmp139_)) {
						ValaDataType* _tmp140_;
						ValaTypeSymbol* _tmp141_;
						ValaTypeSymbol* _tmp142_;
						ValaStruct* _tmp143_;
						_tmp140_ = type;
						_tmp141_ = vala_data_type_get_type_symbol (_tmp140_);
						_tmp142_ = _tmp141_;
						_tmp143_ = _vala_code_node_ref0 (VALA_IS_STRUCT (_tmp142_) ? ((ValaStruct*) _tmp142_) : NULL);
						_vala_code_node_unref0 (st);
						st = _tmp143_;
					}
				}
				_tmp145_ = st;
				if (_tmp145_ != NULL) {
					ValaStruct* _tmp146_;
					_tmp146_ = st;
					_tmp144_ = vala_struct_is_simple_type (_tmp146_);
				} else {
					_tmp144_ = FALSE;
				}
				if (_tmp144_) {
					ValaDataType* _tmp147_;
					_tmp147_ = type;
					vala_data_type_set_nullable (_tmp147_, FALSE);
				}
				_vala_code_node_unref0 (st);
			}
			_vala_code_node_unref0 (type);
			_vala_gir_parser_parameter_info_unref0 (info);
		}
		_vala_iterable_unref0 (_info_list);
	}
	_tmp148_ = parameters;
	_tmp149_ = vala_collection_get_size ((ValaCollection*) _tmp148_);
	_tmp150_ = _tmp149_;
	if (_tmp150_ > 1) {
		ValaGirParserParameterInfo* last_param = NULL;
		ValaList* _tmp151_;
		ValaList* _tmp152_;
		gint _tmp153_;
		gint _tmp154_;
		gpointer _tmp155_;
		ValaGirParserParameterInfo* _tmp156_;
		ValaParameter* _tmp157_;
		gboolean _tmp158_;
		gboolean _tmp159_;
		_tmp151_ = parameters;
		_tmp152_ = parameters;
		_tmp153_ = vala_collection_get_size ((ValaCollection*) _tmp152_);
		_tmp154_ = _tmp153_;
		_tmp155_ = vala_list_get (_tmp151_, _tmp154_ - 1);
		last_param = (ValaGirParserParameterInfo*) _tmp155_;
		_tmp156_ = last_param;
		_tmp157_ = _tmp156_->param;
		_tmp158_ = vala_parameter_get_ellipsis (_tmp157_);
		_tmp159_ = _tmp158_;
		if (_tmp159_) {
			ValaGirParserParameterInfo* first_vararg_param = NULL;
			ValaList* _tmp160_;
			ValaList* _tmp161_;
			gint _tmp162_;
			gint _tmp163_;
			gpointer _tmp164_;
			ValaGirParserParameterInfo* _tmp165_;
			ValaParameter* _tmp166_;
			const gchar* _tmp167_;
			const gchar* _tmp168_;
			_tmp160_ = parameters;
			_tmp161_ = parameters;
			_tmp162_ = vala_collection_get_size ((ValaCollection*) _tmp161_);
			_tmp163_ = _tmp162_;
			_tmp164_ = vala_list_get (_tmp160_, _tmp163_ - 2);
			first_vararg_param = (ValaGirParserParameterInfo*) _tmp164_;
			_tmp165_ = first_vararg_param;
			_tmp166_ = _tmp165_->param;
			_tmp167_ = vala_symbol_get_name ((ValaSymbol*) _tmp166_);
			_tmp168_ = _tmp167_;
			if (g_str_has_prefix (_tmp168_, "first_")) {
				ValaGirParserParameterInfo* _tmp169_;
				_tmp169_ = first_vararg_param;
				_tmp169_->keep = FALSE;
			}
			_vala_gir_parser_parameter_info_unref0 (first_vararg_param);
		}
		_vala_gir_parser_parameter_info_unref0 (last_param);
	}
	i = 0;
	j = 1;
	first_out = -1;
	last = -1;
	{
		ValaList* _info_list = NULL;
		ValaList* _tmp170_;
		ValaList* _tmp171_;
		gint _info_size = 0;
		ValaList* _tmp172_;
		gint _tmp173_;
		gint _tmp174_;
		gint _info_index = 0;
		_tmp170_ = parameters;
		_tmp171_ = _vala_iterable_ref0 (_tmp170_);
		_info_list = _tmp171_;
		_tmp172_ = _info_list;
		_tmp173_ = vala_collection_get_size ((ValaCollection*) _tmp172_);
		_tmp174_ = _tmp173_;
		_info_size = _tmp174_;
		_info_index = -1;
		while (TRUE) {
			ValaGirParserParameterInfo* info = NULL;
			ValaList* _tmp175_;
			gpointer _tmp176_;
			gboolean _tmp177_ = FALSE;
			ValaSymbol* _tmp178_;
			gboolean _tmp205_ = FALSE;
			gboolean _tmp210_ = FALSE;
			gboolean _tmp211_ = FALSE;
			ValaSymbol* _tmp212_;
			gboolean _tmp230_ = FALSE;
			ValaSymbol* _tmp231_;
			gint _tmp235_;
			_info_index = _info_index + 1;
			if (!(_info_index < _info_size)) {
				break;
			}
			_tmp175_ = _info_list;
			_tmp176_ = vala_list_get (_tmp175_, _info_index);
			info = (ValaGirParserParameterInfo*) _tmp176_;
			_tmp178_ = s;
			if (VALA_IS_DELEGATE (_tmp178_)) {
				ValaGirParserParameterInfo* _tmp179_;
				_tmp179_ = info;
				_tmp177_ = _tmp179_->closure_idx == i;
			} else {
				_tmp177_ = FALSE;
			}
			if (_tmp177_) {
				ValaDelegate* d = NULL;
				ValaSymbol* _tmp180_;
				ValaDelegate* _tmp181_;
				ValaDelegate* _tmp182_;
				ValaDelegate* _tmp183_;
				ValaGirParserParameterInfo* _tmp184_;
				_tmp180_ = s;
				_tmp181_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp180_, VALA_TYPE_DELEGATE, ValaDelegate));
				d = _tmp181_;
				_tmp182_ = d;
				vala_delegate_set_has_target (_tmp182_, TRUE);
				_tmp183_ = d;
				vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp183_, "CCode", "instance_pos", j - 0.1, NULL);
				_tmp184_ = info;
				_tmp184_->keep = FALSE;
				_vala_code_node_unref0 (d);
			} else {
				gboolean _tmp185_ = FALSE;
				gboolean _tmp186_ = FALSE;
				gboolean _tmp187_ = FALSE;
				ValaGirParserParameterInfo* _tmp188_;
				_tmp188_ = info;
				if (_tmp188_->keep) {
					ValaArrayList* _tmp189_;
					_tmp189_ = node->array_length_parameters;
					_tmp187_ = !vala_collection_contains ((ValaCollection*) _tmp189_, (gpointer) ((gintptr) i));
				} else {
					_tmp187_ = FALSE;
				}
				if (_tmp187_) {
					ValaArrayList* _tmp190_;
					_tmp190_ = node->closure_parameters;
					_tmp186_ = !vala_collection_contains ((ValaCollection*) _tmp190_, (gpointer) ((gintptr) i));
				} else {
					_tmp186_ = FALSE;
				}
				if (_tmp186_) {
					ValaArrayList* _tmp191_;
					_tmp191_ = node->destroy_parameters;
					_tmp185_ = !vala_collection_contains ((ValaCollection*) _tmp191_, (gpointer) ((gintptr) i));
				} else {
					_tmp185_ = FALSE;
				}
				if (_tmp185_) {
					ValaGirParserParameterInfo* _tmp192_;
					ValaGirParserParameterInfo* _tmp193_;
					gfloat last_idx = 0.0F;
					gint _tmp202_;
					_tmp192_ = info;
					_tmp192_->vala_idx = (gfloat) j;
					_tmp193_ = info;
					_tmp193_->keep = TRUE;
					last_idx = 0.0F;
					if (last != -1) {
						ValaList* _tmp194_;
						gpointer _tmp195_;
						ValaGirParserParameterInfo* _tmp196_;
						_tmp194_ = parameters;
						_tmp195_ = vala_list_get (_tmp194_, last);
						_tmp196_ = (ValaGirParserParameterInfo*) _tmp195_;
						last_idx = _tmp196_->vala_idx;
						_vala_gir_parser_parameter_info_unref0 (_tmp196_);
					}
					{
						gint k = 0;
						k = last + 1;
						{
							gboolean _tmp197_ = FALSE;
							_tmp197_ = TRUE;
							while (TRUE) {
								ValaList* _tmp199_;
								gpointer _tmp200_;
								ValaGirParserParameterInfo* _tmp201_;
								if (!_tmp197_) {
									gint _tmp198_;
									_tmp198_ = k;
									k = _tmp198_ + 1;
								}
								_tmp197_ = FALSE;
								if (!(k < i)) {
									break;
								}
								_tmp199_ = parameters;
								_tmp200_ = vala_list_get (_tmp199_, k);
								_tmp201_ = (ValaGirParserParameterInfo*) _tmp200_;
								_tmp201_->vala_idx = last_idx + (((j - last_idx) / (i - last)) * (k - last));
								_vala_gir_parser_parameter_info_unref0 (_tmp201_);
							}
						}
					}
					last = i;
					_tmp202_ = j;
					j = _tmp202_ + 1;
				} else {
					ValaGirParserParameterInfo* _tmp203_;
					ValaGirParserParameterInfo* _tmp204_;
					_tmp203_ = info;
					_tmp203_->keep = FALSE;
					_tmp204_ = info;
					_tmp204_->vala_idx = (j - 1) + ((i - last) * 0.1F);
				}
			}
			if (first_out < 0) {
				ValaGirParserParameterInfo* _tmp206_;
				ValaParameter* _tmp207_;
				ValaParameterDirection _tmp208_;
				ValaParameterDirection _tmp209_;
				_tmp206_ = info;
				_tmp207_ = _tmp206_->param;
				_tmp208_ = vala_parameter_get_direction (_tmp207_);
				_tmp209_ = _tmp208_;
				_tmp205_ = _tmp209_ == VALA_PARAMETER_DIRECTION_OUT;
			} else {
				_tmp205_ = FALSE;
			}
			if (_tmp205_) {
				first_out = i;
			}
			_tmp212_ = s;
			if (VALA_IS_METHOD (_tmp212_)) {
				_tmp211_ = first_out >= 0;
			} else {
				_tmp211_ = FALSE;
			}
			if (_tmp211_) {
				ValaGirParserParameterInfo* _tmp213_;
				ValaParameter* _tmp214_;
				ValaDataType* _tmp215_;
				ValaDataType* _tmp216_;
				_tmp213_ = info;
				_tmp214_ = _tmp213_->param;
				_tmp215_ = vala_variable_get_variable_type ((ValaVariable*) _tmp214_);
				_tmp216_ = _tmp215_;
				_tmp210_ = _tmp216_ != NULL;
			} else {
				_tmp210_ = FALSE;
			}
			if (_tmp210_) {
				gchar* type_name = NULL;
				ValaGirParserParameterInfo* _tmp217_;
				ValaParameter* _tmp218_;
				ValaDataType* _tmp219_;
				ValaDataType* _tmp220_;
				gchar* _tmp221_;
				gboolean _tmp222_ = FALSE;
				const gchar* _tmp223_;
				_tmp217_ = info;
				_tmp218_ = _tmp217_->param;
				_tmp219_ = vala_variable_get_variable_type ((ValaVariable*) _tmp218_);
				_tmp220_ = _tmp219_;
				_tmp221_ = vala_code_node_to_string ((ValaCodeNode*) _tmp220_);
				type_name = _tmp221_;
				_tmp223_ = type_name;
				if (g_strcmp0 (_tmp223_, "GLib.AsyncResult") == 0) {
					_tmp222_ = TRUE;
				} else {
					const gchar* _tmp224_;
					_tmp224_ = type_name;
					_tmp222_ = g_strcmp0 (_tmp224_, "Gio.AsyncResult") == 0;
				}
				if (_tmp222_) {
					gdouble _tmp225_ = 0.0;
					ValaSymbol* _tmp226_;
					ValaMemberBinding _tmp227_;
					ValaMemberBinding _tmp228_;
					gdouble shift = 0.0;
					ValaSymbol* _tmp229_;
					_tmp226_ = s;
					_tmp227_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp226_, VALA_TYPE_METHOD, ValaMethod));
					_tmp228_ = _tmp227_;
					if (_tmp228_ == VALA_MEMBER_BINDING_INSTANCE) {
						_tmp225_ = 1.1;
					} else {
						_tmp225_ = 0.1;
					}
					shift = _tmp225_;
					_tmp229_ = s;
					vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp229_, "CCode", "async_result_pos", i + shift, NULL);
				}
				_g_free0 (type_name);
			}
			_tmp231_ = s;
			if (VALA_IS_DELEGATE (_tmp231_)) {
				ValaGirParserParameterInfo* _tmp232_;
				_tmp232_ = info;
				_tmp230_ = _tmp232_->is_error;
			} else {
				_tmp230_ = FALSE;
			}
			if (_tmp230_) {
				ValaSymbol* _tmp233_;
				_tmp233_ = s;
				if (!vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp233_, "CCode", "instance_pos")) {
					ValaSymbol* _tmp234_;
					_tmp234_ = s;
					vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp234_, "CCode", "error_pos", j - 0.2, NULL);
				}
			}
			_tmp235_ = i;
			i = _tmp235_ + 1;
			_vala_gir_parser_parameter_info_unref0 (info);
		}
		_vala_iterable_unref0 (_info_list);
	}
	{
		ValaList* _info_list = NULL;
		ValaList* _tmp236_;
		ValaList* _tmp237_;
		gint _info_size = 0;
		ValaList* _tmp238_;
		gint _tmp239_;
		gint _tmp240_;
		gint _info_index = 0;
		_tmp236_ = parameters;
		_tmp237_ = _vala_iterable_ref0 (_tmp236_);
		_info_list = _tmp237_;
		_tmp238_ = _info_list;
		_tmp239_ = vala_collection_get_size ((ValaCollection*) _tmp238_);
		_tmp240_ = _tmp239_;
		_info_size = _tmp240_;
		_info_index = -1;
		while (TRUE) {
			ValaGirParserParameterInfo* info = NULL;
			ValaList* _tmp241_;
			gpointer _tmp242_;
			ValaGirParserParameterInfo* _tmp243_;
			ValaSymbol* _tmp244_;
			ValaGirParserParameterInfo* _tmp248_;
			ValaGirParserParameterInfo* _tmp263_;
			ValaGirParserParameterInfo* _tmp288_;
			ValaGirParserParameterInfo* _tmp313_;
			_info_index = _info_index + 1;
			if (!(_info_index < _info_size)) {
				break;
			}
			_tmp241_ = _info_list;
			_tmp242_ = vala_list_get (_tmp241_, _info_index);
			info = (ValaGirParserParameterInfo*) _tmp242_;
			_tmp243_ = info;
			if (!_tmp243_->keep) {
				_vala_gir_parser_parameter_info_unref0 (info);
				continue;
			}
			_tmp244_ = s;
			if (VALA_IS_CALLABLE (_tmp244_)) {
				ValaSymbol* _tmp245_;
				ValaGirParserParameterInfo* _tmp246_;
				ValaParameter* _tmp247_;
				_tmp245_ = s;
				_tmp246_ = info;
				_tmp247_ = _tmp246_->param;
				vala_callable_add_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp245_, VALA_TYPE_CALLABLE, ValaCallable), _tmp247_);
			}
			_tmp248_ = info;
			if (_tmp248_->array_length_idx != -1) {
				ValaGirParserParameterInfo* _tmp249_;
				ValaList* _tmp250_;
				gint _tmp251_;
				gint _tmp252_;
				ValaGirParserParameterInfo* _tmp257_;
				ValaParameter* _tmp258_;
				ValaList* _tmp259_;
				ValaGirParserParameterInfo* _tmp260_;
				gpointer _tmp261_;
				ValaGirParserParameterInfo* _tmp262_;
				_tmp249_ = info;
				_tmp250_ = parameters;
				_tmp251_ = vala_collection_get_size ((ValaCollection*) _tmp250_);
				_tmp252_ = _tmp251_;
				if (_tmp249_->array_length_idx >= _tmp252_) {
					ValaGirParserParameterInfo* _tmp253_;
					ValaParameter* _tmp254_;
					ValaSourceReference* _tmp255_;
					ValaSourceReference* _tmp256_;
					_tmp253_ = info;
					_tmp254_ = _tmp253_->param;
					_tmp255_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp254_);
					_tmp256_ = _tmp255_;
					vala_report_error (_tmp256_, "invalid array_length index");
					_vala_gir_parser_parameter_info_unref0 (info);
					continue;
				}
				_tmp257_ = info;
				_tmp258_ = _tmp257_->param;
				_tmp259_ = parameters;
				_tmp260_ = info;
				_tmp261_ = vala_list_get (_tmp259_, _tmp260_->array_length_idx);
				_tmp262_ = (ValaGirParserParameterInfo*) _tmp261_;
				vala_gir_parser_set_array_ccode (self, (ValaSymbol*) _tmp258_, _tmp262_);
				_vala_gir_parser_parameter_info_unref0 (_tmp262_);
			}
			_tmp263_ = info;
			if (_tmp263_->closure_idx != -1) {
				ValaGirParserParameterInfo* _tmp264_;
				ValaList* _tmp265_;
				gint _tmp266_;
				gint _tmp267_;
				ValaList* _tmp272_;
				ValaGirParserParameterInfo* _tmp273_;
				gpointer _tmp274_;
				ValaGirParserParameterInfo* _tmp275_;
				gchar* _tmp276_;
				gchar* _tmp277_;
				ValaGirParserParameterInfo* _tmp278_;
				gchar* _tmp279_;
				gchar* _tmp280_;
				gboolean _tmp281_;
				_tmp264_ = info;
				_tmp265_ = parameters;
				_tmp266_ = vala_collection_get_size ((ValaCollection*) _tmp265_);
				_tmp267_ = _tmp266_;
				if (_tmp264_->closure_idx >= _tmp267_) {
					ValaGirParserParameterInfo* _tmp268_;
					ValaParameter* _tmp269_;
					ValaSourceReference* _tmp270_;
					ValaSourceReference* _tmp271_;
					_tmp268_ = info;
					_tmp269_ = _tmp268_->param;
					_tmp270_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp269_);
					_tmp271_ = _tmp270_;
					vala_report_error (_tmp271_, "invalid closure index");
					_vala_gir_parser_parameter_info_unref0 (info);
					continue;
				}
				_tmp272_ = parameters;
				_tmp273_ = info;
				_tmp274_ = vala_list_get (_tmp272_, _tmp273_->closure_idx);
				_tmp275_ = (ValaGirParserParameterInfo*) _tmp274_;
				_tmp276_ = g_strdup_printf ("%g", (gdouble) _tmp275_->vala_idx);
				_tmp277_ = _tmp276_;
				_tmp278_ = info;
				_tmp279_ = g_strdup_printf ("%g", _tmp278_->vala_idx + 0.1);
				_tmp280_ = _tmp279_;
				_tmp281_ = g_strcmp0 (_tmp277_, _tmp280_) != 0;
				_g_free0 (_tmp280_);
				_g_free0 (_tmp277_);
				_vala_gir_parser_parameter_info_unref0 (_tmp275_);
				if (_tmp281_) {
					ValaGirParserParameterInfo* _tmp282_;
					ValaParameter* _tmp283_;
					ValaList* _tmp284_;
					ValaGirParserParameterInfo* _tmp285_;
					gpointer _tmp286_;
					ValaGirParserParameterInfo* _tmp287_;
					_tmp282_ = info;
					_tmp283_ = _tmp282_->param;
					_tmp284_ = parameters;
					_tmp285_ = info;
					_tmp286_ = vala_list_get (_tmp284_, _tmp285_->closure_idx);
					_tmp287_ = (ValaGirParserParameterInfo*) _tmp286_;
					vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp283_, "CCode", "delegate_target_pos", (gdouble) _tmp287_->vala_idx, NULL);
					_vala_gir_parser_parameter_info_unref0 (_tmp287_);
				}
			}
			_tmp288_ = info;
			if (_tmp288_->destroy_idx != -1) {
				ValaGirParserParameterInfo* _tmp289_;
				ValaList* _tmp290_;
				gint _tmp291_;
				gint _tmp292_;
				ValaList* _tmp297_;
				ValaGirParserParameterInfo* _tmp298_;
				gpointer _tmp299_;
				ValaGirParserParameterInfo* _tmp300_;
				gchar* _tmp301_;
				gchar* _tmp302_;
				ValaGirParserParameterInfo* _tmp303_;
				gchar* _tmp304_;
				gchar* _tmp305_;
				gboolean _tmp306_;
				_tmp289_ = info;
				_tmp290_ = parameters;
				_tmp291_ = vala_collection_get_size ((ValaCollection*) _tmp290_);
				_tmp292_ = _tmp291_;
				if (_tmp289_->destroy_idx >= _tmp292_) {
					ValaGirParserParameterInfo* _tmp293_;
					ValaParameter* _tmp294_;
					ValaSourceReference* _tmp295_;
					ValaSourceReference* _tmp296_;
					_tmp293_ = info;
					_tmp294_ = _tmp293_->param;
					_tmp295_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp294_);
					_tmp296_ = _tmp295_;
					vala_report_error (_tmp296_, "invalid destroy index");
					_vala_gir_parser_parameter_info_unref0 (info);
					continue;
				}
				_tmp297_ = parameters;
				_tmp298_ = info;
				_tmp299_ = vala_list_get (_tmp297_, _tmp298_->destroy_idx);
				_tmp300_ = (ValaGirParserParameterInfo*) _tmp299_;
				_tmp301_ = g_strdup_printf ("%g", (gdouble) _tmp300_->vala_idx);
				_tmp302_ = _tmp301_;
				_tmp303_ = info;
				_tmp304_ = g_strdup_printf ("%g", _tmp303_->vala_idx + 0.2);
				_tmp305_ = _tmp304_;
				_tmp306_ = g_strcmp0 (_tmp302_, _tmp305_) != 0;
				_g_free0 (_tmp305_);
				_g_free0 (_tmp302_);
				_vala_gir_parser_parameter_info_unref0 (_tmp300_);
				if (_tmp306_) {
					ValaGirParserParameterInfo* _tmp307_;
					ValaParameter* _tmp308_;
					ValaList* _tmp309_;
					ValaGirParserParameterInfo* _tmp310_;
					gpointer _tmp311_;
					ValaGirParserParameterInfo* _tmp312_;
					_tmp307_ = info;
					_tmp308_ = _tmp307_->param;
					_tmp309_ = parameters;
					_tmp310_ = info;
					_tmp311_ = vala_list_get (_tmp309_, _tmp310_->destroy_idx);
					_tmp312_ = (ValaGirParserParameterInfo*) _tmp311_;
					vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp308_, "CCode", "destroy_notify_pos", (gdouble) _tmp312_->vala_idx, NULL);
					_vala_gir_parser_parameter_info_unref0 (_tmp312_);
				}
			}
			_tmp313_ = info;
			if (_tmp313_->is_async) {
				ValaDataType* resolved_type = NULL;
				ValaGirParserParameterInfo* _tmp314_;
				ValaParameter* _tmp315_;
				ValaDataType* _tmp316_;
				ValaDataType* _tmp317_;
				ValaDataType* _tmp318_;
				ValaDataType* _tmp319_;
				ValaDataType* _tmp328_;
				_tmp314_ = info;
				_tmp315_ = _tmp314_->param;
				_tmp316_ = vala_variable_get_variable_type ((ValaVariable*) _tmp315_);
				_tmp317_ = _tmp316_;
				_tmp318_ = _vala_code_node_ref0 (_tmp317_);
				resolved_type = _tmp318_;
				_tmp319_ = resolved_type;
				if (VALA_IS_UNRESOLVED_TYPE (_tmp319_)) {
					ValaSymbol* resolved_symbol = NULL;
					ValaGirParserNode* _tmp320_;
					ValaDataType* _tmp321_;
					ValaUnresolvedSymbol* _tmp322_;
					ValaUnresolvedSymbol* _tmp323_;
					ValaSymbol* _tmp324_;
					ValaSymbol* _tmp325_;
					_tmp320_ = node->parent;
					_tmp321_ = resolved_type;
					_tmp322_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp321_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
					_tmp323_ = _tmp322_;
					_tmp324_ = vala_gir_parser_resolve_symbol (self, _tmp320_, _tmp323_);
					resolved_symbol = _tmp324_;
					_tmp325_ = resolved_symbol;
					if (VALA_IS_DELEGATE (_tmp325_)) {
						ValaSymbol* _tmp326_;
						ValaDelegateType* _tmp327_;
						_tmp326_ = resolved_symbol;
						_tmp327_ = vala_delegate_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp326_, VALA_TYPE_DELEGATE, ValaDelegate));
						_vala_code_node_unref0 (resolved_type);
						resolved_type = (ValaDataType*) _tmp327_;
					}
					_vala_code_node_unref0 (resolved_symbol);
				}
				_tmp328_ = resolved_type;
				if (VALA_IS_DELEGATE_TYPE (_tmp328_)) {
					ValaDelegate* d = NULL;
					ValaDataType* _tmp329_;
					ValaDelegate* _tmp330_;
					ValaDelegate* _tmp331_;
					ValaDelegate* _tmp332_;
					gboolean _tmp333_ = FALSE;
					ValaDelegate* _tmp334_;
					const gchar* _tmp335_;
					const gchar* _tmp336_;
					_tmp329_ = resolved_type;
					_tmp330_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp329_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp331_ = _tmp330_;
					_tmp332_ = _vala_code_node_ref0 (_tmp331_);
					d = _tmp332_;
					_tmp334_ = d;
					_tmp335_ = vala_symbol_get_name ((ValaSymbol*) _tmp334_);
					_tmp336_ = _tmp335_;
					if (g_strcmp0 (_tmp336_, "DestroyNotify") == 0) {
						ValaDelegate* _tmp337_;
						ValaSymbol* _tmp338_;
						ValaSymbol* _tmp339_;
						const gchar* _tmp340_;
						const gchar* _tmp341_;
						_tmp337_ = d;
						_tmp338_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp337_);
						_tmp339_ = _tmp338_;
						_tmp340_ = vala_symbol_get_name (_tmp339_);
						_tmp341_ = _tmp340_;
						_tmp333_ = g_strcmp0 (_tmp341_, "GLib") == 0;
					} else {
						_tmp333_ = FALSE;
					}
					if (!_tmp333_) {
						ValaGirParserParameterInfo* _tmp342_;
						ValaParameter* _tmp343_;
						gboolean _tmp344_ = FALSE;
						ValaGirParserParameterInfo* _tmp345_;
						ValaGirParserParameterInfo* _tmp347_;
						ValaParameter* _tmp348_;
						ValaDataType* _tmp349_;
						ValaDataType* _tmp350_;
						_tmp342_ = info;
						_tmp343_ = _tmp342_->param;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp343_, "CCode", "scope", "async", NULL);
						_tmp345_ = info;
						if (_tmp345_->closure_idx != -1) {
							ValaGirParserParameterInfo* _tmp346_;
							_tmp346_ = info;
							_tmp344_ = _tmp346_->destroy_idx != -1;
						} else {
							_tmp344_ = FALSE;
						}
						_tmp347_ = info;
						_tmp348_ = _tmp347_->param;
						_tmp349_ = vala_variable_get_variable_type ((ValaVariable*) _tmp348_);
						_tmp350_ = _tmp349_;
						vala_data_type_set_value_owned (_tmp350_, _tmp344_);
					}
					_vala_code_node_unref0 (d);
				}
				_vala_code_node_unref0 (resolved_type);
			} else {
				ValaDataType* resolved_type = NULL;
				ValaGirParserParameterInfo* _tmp351_;
				ValaParameter* _tmp352_;
				ValaDataType* _tmp353_;
				ValaDataType* _tmp354_;
				ValaDataType* _tmp355_;
				ValaDataType* _tmp356_;
				_tmp351_ = info;
				_tmp352_ = _tmp351_->param;
				_tmp353_ = vala_variable_get_variable_type ((ValaVariable*) _tmp352_);
				_tmp354_ = _tmp353_;
				_tmp355_ = _vala_code_node_ref0 (_tmp354_);
				resolved_type = _tmp355_;
				_tmp356_ = resolved_type;
				if (VALA_IS_DELEGATE_TYPE (_tmp356_)) {
					gboolean _tmp357_ = FALSE;
					ValaGirParserParameterInfo* _tmp358_;
					ValaGirParserParameterInfo* _tmp360_;
					ValaParameter* _tmp361_;
					ValaDataType* _tmp362_;
					ValaDataType* _tmp363_;
					_tmp358_ = info;
					if (_tmp358_->closure_idx != -1) {
						ValaGirParserParameterInfo* _tmp359_;
						_tmp359_ = info;
						_tmp357_ = _tmp359_->destroy_idx != -1;
					} else {
						_tmp357_ = FALSE;
					}
					_tmp360_ = info;
					_tmp361_ = _tmp360_->param;
					_tmp362_ = vala_variable_get_variable_type ((ValaVariable*) _tmp361_);
					_tmp363_ = _tmp362_;
					vala_data_type_set_value_owned (_tmp363_, _tmp357_);
				}
				_vala_code_node_unref0 (resolved_type);
			}
			_vala_gir_parser_parameter_info_unref0 (info);
		}
		_vala_iterable_unref0 (_info_list);
	}
	_tmp365_ = return_type;
	if (VALA_IS_ARRAY_TYPE (_tmp365_)) {
		_tmp364_ = node->return_array_length_idx >= 0;
	} else {
		_tmp364_ = FALSE;
	}
	if (_tmp364_) {
		ValaSymbol* _tmp366_;
		ValaList* _tmp367_;
		gpointer _tmp368_;
		ValaGirParserParameterInfo* _tmp369_;
		_tmp366_ = s;
		_tmp367_ = parameters;
		_tmp368_ = vala_list_get (_tmp367_, node->return_array_length_idx);
		_tmp369_ = (ValaGirParserParameterInfo*) _tmp368_;
		vala_gir_parser_set_array_ccode (self, _tmp366_, _tmp369_);
		_vala_gir_parser_parameter_info_unref0 (_tmp369_);
	}
	_tmp370_ = s;
	if (VALA_IS_CALLABLE (_tmp370_)) {
		ValaSymbol* _tmp371_;
		ValaDataType* _tmp372_;
		_tmp371_ = s;
		_tmp372_ = return_type;
		vala_callable_set_return_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp371_, VALA_TYPE_CALLABLE, ValaCallable), _tmp372_);
	}
	_vala_code_node_unref0 (return_type);
	_vala_iterable_unref0 (parameters);
	_vala_code_node_unref0 (s);
}

static void
vala_gir_parser_find_parent (ValaGirParser* self,
                             const gchar* cname,
                             ValaGirParserNode* current,
                             ValaGirParserNode* * best,
                             gint* match)
{
	ValaGirParserNode* old_best = NULL;
	ValaGirParserNode* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaGirParserNode* _tmp19_;
	gint current_match = 0;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	g_return_if_fail (current != NULL);
	g_return_if_fail (*best != NULL);
	_tmp0_ = _vala_gir_parser_node_ref0 (*best);
	old_best = _tmp0_;
	_tmp1_ = current->symbol;
	if (VALA_IS_NAMESPACE (_tmp1_)) {
		{
			ValaArrayList* _child_list = NULL;
			ValaArrayList* _tmp2_;
			ValaArrayList* _tmp3_;
			gint _child_size = 0;
			ValaArrayList* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _child_index = 0;
			_tmp2_ = current->members;
			_tmp3_ = _vala_iterable_ref0 (_tmp2_);
			_child_list = _tmp3_;
			_tmp4_ = _child_list;
			_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
			_tmp6_ = _tmp5_;
			_child_size = _tmp6_;
			_child_index = -1;
			while (TRUE) {
				ValaGirParserNode* child = NULL;
				ValaArrayList* _tmp7_;
				gpointer _tmp8_;
				gboolean _tmp9_ = FALSE;
				gboolean _tmp10_ = FALSE;
				ValaGirParserNode* _tmp11_;
				ValaSymbol* _tmp12_;
				_child_index = _child_index + 1;
				if (!(_child_index < _child_size)) {
					break;
				}
				_tmp7_ = _child_list;
				_tmp8_ = vala_list_get ((ValaList*) _tmp7_, _child_index);
				child = (ValaGirParserNode*) _tmp8_;
				_tmp11_ = child;
				_tmp12_ = _tmp11_->symbol;
				if (_tmp12_ == NULL) {
					_tmp10_ = TRUE;
				} else {
					ValaGirParserNode* _tmp13_;
					ValaSymbol* _tmp14_;
					_tmp13_ = child;
					_tmp14_ = _tmp13_->symbol;
					_tmp10_ = vala_gir_parser_is_container (_tmp14_);
				}
				if (_tmp10_) {
					ValaGirParserNode* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
					_tmp15_ = child;
					_tmp16_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp15_);
					_tmp17_ = _tmp16_;
					_tmp9_ = g_str_has_prefix (cname, _tmp17_);
					_g_free0 (_tmp17_);
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					ValaGirParserNode* _tmp18_;
					_tmp18_ = child;
					vala_gir_parser_find_parent (self, cname, _tmp18_, best, match);
				}
				_vala_gir_parser_node_unref0 (child);
			}
			_vala_iterable_unref0 (_child_list);
		}
	}
	_tmp19_ = old_best;
	if ((*best) != _tmp19_) {
		_vala_gir_parser_node_unref0 (old_best);
		return;
	}
	_tmp20_ = vala_gir_parser_node_get_lower_case_cprefix (current);
	_tmp21_ = _tmp20_;
	_tmp22_ = strlen (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = _tmp23_;
	_g_free0 (_tmp21_);
	current_match = _tmp24_;
	if (current_match > (*match)) {
		ValaGirParserNode* _tmp25_;
		*match = current_match;
		_tmp25_ = _vala_gir_parser_node_ref0 (current);
		_vala_gir_parser_node_unref0 (*best);
		*best = _tmp25_;
	}
	_vala_gir_parser_node_unref0 (old_best);
}

static gboolean
vala_gir_parser_same_gir (ValaGirParser* self,
                          ValaSymbol* gir_component,
                          ValaSymbol* sym)
{
	gchar* gir_name = NULL;
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceFile* _tmp2_;
	ValaSourceFile* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* gir_version = NULL;
	ValaSourceReference* _tmp7_;
	ValaSourceReference* _tmp8_;
	ValaSourceFile* _tmp9_;
	ValaSourceFile* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSourceFile* _tmp16_;
	ValaSourceFile* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gboolean _tmp22_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (gir_component != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) gir_component);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_source_reference_get_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_source_file_get_gir_namespace (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup (_tmp5_);
	gir_name = _tmp6_;
	_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) gir_component);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_source_reference_get_file (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_source_file_get_gir_version (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup (_tmp12_);
	gir_version = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_source_reference_get_file (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_source_file_get_filename (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup_printf ("%s-%s", gir_name, gir_version);
	_tmp21_ = _tmp20_;
	_tmp22_ = string_contains (_tmp19_, _tmp21_);
	_g_free0 (_tmp21_);
	result = _tmp22_;
	_g_free0 (gir_version);
	_g_free0 (gir_name);
	return result;
}

static void
vala_gir_parser_process_namespace_method (ValaGirParser* self,
                                          ValaGirParserNode* ns,
                                          ValaGirParserNode* node)
{
	gchar* ns_cprefix = NULL;
	gchar* _tmp0_;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp1_;
	ValaMethod* _tmp2_;
	gchar* cname = NULL;
	gchar* _tmp3_;
	ValaParameter* first_param = NULL;
	ValaList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	ValaParameter* _tmp14_;
	gint match = 0;
	ValaGirParserNode* parent = NULL;
	ValaGirParserNode* _tmp73_;
	const gchar* _tmp74_;
	gchar* new_name = NULL;
	ValaMethod* _tmp75_;
	const gchar* _tmp76_;
	const gchar* _tmp77_;
	ValaGirParserNode* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	gint _tmp81_;
	gint _tmp82_;
	const gchar* _tmp83_;
	gint _tmp84_;
	gint _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gboolean _tmp88_ = FALSE;
	ValaMethod* _tmp89_;
	ValaGirParserNode* _tmp90_;
	ValaSymbol* _tmp91_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = vala_gir_parser_node_get_lower_case_cprefix (ns);
	ns_cprefix = _tmp0_;
	_tmp1_ = node->symbol;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_METHOD, ValaMethod));
	method = _tmp2_;
	_tmp3_ = vala_gir_parser_node_get_cname (node);
	cname = _tmp3_;
	first_param = NULL;
	_tmp4_ = node->parameters;
	_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ > 0) {
		ValaList* _tmp7_;
		gpointer _tmp8_;
		ValaGirParserParameterInfo* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		_tmp7_ = node->parameters;
		_tmp8_ = vala_list_get (_tmp7_, 0);
		_tmp9_ = (ValaGirParserParameterInfo*) _tmp8_;
		_tmp10_ = _tmp9_->param;
		_tmp11_ = _vala_code_node_ref0 (_tmp10_);
		_vala_code_node_unref0 (first_param);
		first_param = _tmp11_;
		_vala_gir_parser_parameter_info_unref0 (_tmp9_);
	}
	_tmp14_ = first_param;
	if (_tmp14_ != NULL) {
		ValaParameter* _tmp15_;
		ValaParameterDirection _tmp16_;
		ValaParameterDirection _tmp17_;
		_tmp15_ = first_param;
		_tmp16_ = vala_parameter_get_direction (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp13_ = _tmp17_ == VALA_PARAMETER_DIRECTION_IN;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		ValaParameter* _tmp18_;
		ValaDataType* _tmp19_;
		ValaDataType* _tmp20_;
		_tmp18_ = first_param;
		_tmp19_ = vala_variable_get_variable_type ((ValaVariable*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp12_ = VALA_IS_UNRESOLVED_TYPE (_tmp20_);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		ValaUnresolvedSymbol* sym = NULL;
		ValaParameter* _tmp21_;
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		ValaUnresolvedSymbol* _tmp24_;
		ValaUnresolvedSymbol* _tmp25_;
		ValaUnresolvedSymbol* _tmp26_;
		ValaGirParserNode* parent = NULL;
		ValaUnresolvedSymbol* _tmp27_;
		ValaGirParserNode* _tmp28_;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
		ValaGirParserNode* _tmp33_;
		_tmp21_ = first_param;
		_tmp22_ = vala_variable_get_variable_type ((ValaVariable*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
		_tmp25_ = _tmp24_;
		_tmp26_ = _vala_code_node_ref0 (_tmp25_);
		sym = _tmp26_;
		_tmp27_ = sym;
		_tmp28_ = vala_gir_parser_resolve_node (self, ns, _tmp27_, FALSE);
		parent = _tmp28_;
		_tmp33_ = parent;
		if (_tmp33_ != NULL) {
			ValaMethod* _tmp34_;
			ValaGirParserNode* _tmp35_;
			ValaSymbol* _tmp36_;
			_tmp34_ = method;
			_tmp35_ = parent;
			_tmp36_ = _tmp35_->symbol;
			_tmp32_ = vala_gir_parser_same_gir (self, (ValaSymbol*) _tmp34_, _tmp36_);
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			ValaGirParserNode* _tmp37_;
			ValaGirParserNode* _tmp38_;
			_tmp37_ = parent;
			_tmp38_ = _tmp37_->parent;
			_tmp31_ = _tmp38_ == ns;
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			ValaGirParserNode* _tmp39_;
			ValaSymbol* _tmp40_;
			_tmp39_ = parent;
			_tmp40_ = _tmp39_->symbol;
			_tmp30_ = vala_gir_parser_is_container (_tmp40_);
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			const gchar* _tmp41_;
			ValaGirParserNode* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			_tmp41_ = cname;
			_tmp42_ = parent;
			_tmp43_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp29_ = g_str_has_prefix (_tmp41_, _tmp44_);
			_g_free0 (_tmp44_);
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			gchar* new_name = NULL;
			ValaMethod* _tmp45_;
			const gchar* _tmp46_;
			const gchar* _tmp47_;
			ValaGirParserNode* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			gint _tmp51_;
			gint _tmp52_;
			const gchar* _tmp53_;
			gint _tmp54_;
			gint _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			ValaGirParserNode* _tmp58_;
			const gchar* _tmp59_;
			ValaGirParserNode* _tmp60_;
			ValaGirParserNode* _tmp61_;
			gboolean _tmp62_;
			_tmp45_ = method;
			_tmp46_ = vala_symbol_get_name ((ValaSymbol*) _tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = parent;
			_tmp49_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = strlen (_tmp50_);
			_tmp52_ = _tmp51_;
			_tmp53_ = ns_cprefix;
			_tmp54_ = strlen (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = string_substring (_tmp47_, (glong) (_tmp52_ - _tmp55_), (glong) -1);
			_tmp57_ = _tmp56_;
			_g_free0 (_tmp50_);
			new_name = _tmp57_;
			_tmp58_ = parent;
			_tmp59_ = new_name;
			_tmp60_ = vala_gir_parser_node_lookup (_tmp58_, _tmp59_, FALSE, NULL);
			_tmp61_ = _tmp60_;
			_tmp62_ = _tmp61_ == NULL;
			_vala_gir_parser_node_unref0 (_tmp61_);
			if (_tmp62_) {
				const gchar* _tmp63_;
				gchar* _tmp64_;
				ValaList* _tmp65_;
				gpointer _tmp66_;
				ValaGirParserParameterInfo* _tmp67_;
				gint _tmp68_;
				ValaMethod* _tmp69_;
				const gchar* _tmp70_;
				ValaMethod* _tmp71_;
				ValaGirParserNode* _tmp72_;
				vala_gir_parser_node_remove_member (ns, node);
				_tmp63_ = new_name;
				_tmp64_ = g_strdup (_tmp63_);
				_g_free0 (node->name);
				node->name = _tmp64_;
				_tmp65_ = node->parameters;
				_tmp66_ = vala_list_remove_at (_tmp65_, 0);
				_tmp67_ = (ValaGirParserParameterInfo*) _tmp66_;
				_vala_gir_parser_parameter_info_unref0 (_tmp67_);
				_tmp68_ = node->return_array_length_idx;
				node->return_array_length_idx = _tmp68_ - 1;
				_tmp69_ = method;
				_tmp70_ = new_name;
				vala_symbol_set_name ((ValaSymbol*) _tmp69_, _tmp70_);
				_tmp71_ = method;
				vala_method_set_binding (_tmp71_, VALA_MEMBER_BINDING_INSTANCE);
				_tmp72_ = parent;
				vala_gir_parser_node_add_member (_tmp72_, node);
			}
			_g_free0 (new_name);
			_vala_gir_parser_node_unref0 (parent);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (first_param);
			_g_free0 (cname);
			_vala_code_node_unref0 (method);
			_g_free0 (ns_cprefix);
			return;
		}
		_vala_gir_parser_node_unref0 (parent);
		_vala_code_node_unref0 (sym);
	}
	match = 0;
	_tmp73_ = _vala_gir_parser_node_ref0 (ns);
	parent = _tmp73_;
	_tmp74_ = cname;
	vala_gir_parser_find_parent (self, _tmp74_, ns, &parent, &match);
	_tmp75_ = method;
	_tmp76_ = vala_symbol_get_name ((ValaSymbol*) _tmp75_);
	_tmp77_ = _tmp76_;
	_tmp78_ = parent;
	_tmp79_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp78_);
	_tmp80_ = _tmp79_;
	_tmp81_ = strlen (_tmp80_);
	_tmp82_ = _tmp81_;
	_tmp83_ = ns_cprefix;
	_tmp84_ = strlen (_tmp83_);
	_tmp85_ = _tmp84_;
	_tmp86_ = string_substring (_tmp77_, (glong) (_tmp82_ - _tmp85_), (glong) -1);
	_tmp87_ = _tmp86_;
	_g_free0 (_tmp80_);
	new_name = _tmp87_;
	_tmp89_ = method;
	_tmp90_ = parent;
	_tmp91_ = _tmp90_->symbol;
	if (vala_gir_parser_same_gir (self, (ValaSymbol*) _tmp89_, _tmp91_)) {
		ValaGirParserNode* _tmp92_;
		const gchar* _tmp93_;
		ValaGirParserNode* _tmp94_;
		ValaGirParserNode* _tmp95_;
		_tmp92_ = parent;
		_tmp93_ = new_name;
		_tmp94_ = vala_gir_parser_node_lookup (_tmp92_, _tmp93_, FALSE, NULL);
		_tmp95_ = _tmp94_;
		_tmp88_ = _tmp95_ == NULL;
		_vala_gir_parser_node_unref0 (_tmp95_);
	} else {
		_tmp88_ = FALSE;
	}
	if (_tmp88_) {
		const gchar* _tmp96_;
		gchar* _tmp97_;
		ValaMethod* _tmp98_;
		const gchar* _tmp99_;
		ValaGirParserNode* _tmp100_;
		vala_gir_parser_node_remove_member (ns, node);
		_tmp96_ = new_name;
		_tmp97_ = g_strdup (_tmp96_);
		_g_free0 (node->name);
		node->name = _tmp97_;
		_tmp98_ = method;
		_tmp99_ = new_name;
		vala_symbol_set_name ((ValaSymbol*) _tmp98_, _tmp99_);
		_tmp100_ = parent;
		vala_gir_parser_node_add_member (_tmp100_, node);
	}
	_g_free0 (new_name);
	_vala_gir_parser_node_unref0 (parent);
	_vala_code_node_unref0 (first_param);
	_g_free0 (cname);
	_vala_code_node_unref0 (method);
	_g_free0 (ns_cprefix);
}

static void
vala_gir_parser_process_virtual_method_field (ValaGirParser* self,
                                              ValaGirParserNode* node,
                                              ValaDelegate* d,
                                              ValaUnresolvedSymbol* gtype_struct_for)
{
	ValaGirParserNode* gtype_node = NULL;
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaGirParserNode* _tmp3_;
	ValaArrayList* nodes = NULL;
	ValaGirParserNode* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	ValaArrayList* _tmp17_;
	ValaArrayList* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (d != NULL);
	g_return_if_fail (gtype_struct_for != NULL);
	_tmp0_ = node->parent;
	_tmp1_ = vala_gir_parser_resolve_node (self, _tmp0_, gtype_struct_for, FALSE);
	gtype_node = _tmp1_;
	_tmp3_ = gtype_node;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		ValaGirParserNode* _tmp4_;
		ValaSymbol* _tmp5_;
		_tmp4_ = gtype_node;
		_tmp5_ = _tmp4_->symbol;
		_tmp2_ = !VALA_IS_OBJECT_TYPE_SYMBOL (_tmp5_);
	}
	if (_tmp2_) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) gtype_struct_for);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_code_node_to_string ((ValaCodeNode*) gtype_struct_for);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_gir_parser_node_to_string (node);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup_printf ("Unknown symbol `%s' for virtual method field `%s'", _tmp9_, _tmp11_);
		_tmp13_ = _tmp12_;
		vala_report_error (_tmp7_, _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	}
	_tmp14_ = gtype_node;
	_tmp15_ = vala_symbol_get_name ((ValaSymbol*) d);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_gir_parser_node_lookup_all (_tmp14_, _tmp16_);
	nodes = _tmp17_;
	_tmp18_ = nodes;
	if (_tmp18_ == NULL) {
		_vala_iterable_unref0 (nodes);
		_vala_gir_parser_node_unref0 (gtype_node);
		return;
	}
	{
		ValaArrayList* _n_list = NULL;
		ValaArrayList* _tmp19_;
		ValaArrayList* _tmp20_;
		gint _n_size = 0;
		ValaArrayList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _n_index = 0;
		_tmp19_ = nodes;
		_tmp20_ = _vala_iterable_ref0 (_tmp19_);
		_n_list = _tmp20_;
		_tmp21_ = _n_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_n_size = _tmp23_;
		_n_index = -1;
		while (TRUE) {
			ValaGirParserNode* n = NULL;
			ValaArrayList* _tmp24_;
			gpointer _tmp25_;
			ValaGirParserNode* _tmp26_;
			_n_index = _n_index + 1;
			if (!(_n_index < _n_size)) {
				break;
			}
			_tmp24_ = _n_list;
			_tmp25_ = vala_list_get ((ValaList*) _tmp24_, _n_index);
			n = (ValaGirParserNode*) _tmp25_;
			_tmp26_ = n;
			if (node != _tmp26_) {
				ValaGirParserNode* _tmp27_;
				_tmp27_ = n;
				vala_gir_parser_node_process (_tmp27_, self);
			}
			_vala_gir_parser_node_unref0 (n);
		}
		_vala_iterable_unref0 (_n_list);
	}
	{
		ValaArrayList* _n_list = NULL;
		ValaArrayList* _tmp28_;
		ValaArrayList* _tmp29_;
		gint _n_size = 0;
		ValaArrayList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _n_index = 0;
		_tmp28_ = nodes;
		_tmp29_ = _vala_iterable_ref0 (_tmp28_);
		_n_list = _tmp29_;
		_tmp30_ = _n_list;
		_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_n_size = _tmp32_;
		_n_index = -1;
		while (TRUE) {
			ValaGirParserNode* n = NULL;
			ValaArrayList* _tmp33_;
			gpointer _tmp34_;
			ValaGirParserNode* _tmp35_;
			ValaSymbol* sym = NULL;
			ValaGirParserNode* _tmp36_;
			ValaSymbol* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaSymbol* _tmp39_;
			_n_index = _n_index + 1;
			if (!(_n_index < _n_size)) {
				break;
			}
			_tmp33_ = _n_list;
			_tmp34_ = vala_list_get ((ValaList*) _tmp33_, _n_index);
			n = (ValaGirParserNode*) _tmp34_;
			_tmp35_ = n;
			if (_tmp35_->merged) {
				_vala_gir_parser_node_unref0 (n);
				continue;
			}
			_tmp36_ = n;
			_tmp37_ = _tmp36_->symbol;
			_tmp38_ = _vala_code_node_ref0 (_tmp37_);
			sym = _tmp38_;
			_tmp39_ = sym;
			if (VALA_IS_SIGNAL (_tmp39_)) {
				ValaSignal* sig = NULL;
				ValaSymbol* _tmp40_;
				ValaSignal* _tmp41_;
				ValaSignal* _tmp42_;
				ValaSignal* _tmp43_;
				_tmp40_ = sym;
				_tmp41_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, VALA_TYPE_SIGNAL, ValaSignal));
				sig = _tmp41_;
				_tmp42_ = sig;
				vala_signal_set_is_virtual (_tmp42_, TRUE);
				_tmp43_ = sig;
				vala_gir_parser_assume_parameter_names (self, _tmp43_, (ValaSymbol*) d, TRUE);
				_vala_code_node_unref0 (sig);
			} else {
				ValaSymbol* _tmp44_;
				_tmp44_ = sym;
				if (VALA_IS_PROPERTY (_tmp44_)) {
					ValaProperty* prop = NULL;
					ValaSymbol* _tmp45_;
					ValaProperty* _tmp46_;
					ValaProperty* _tmp47_;
					_tmp45_ = sym;
					_tmp46_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, VALA_TYPE_PROPERTY, ValaProperty));
					prop = _tmp46_;
					_tmp47_ = prop;
					vala_property_set_is_virtual (_tmp47_, TRUE);
					_vala_code_node_unref0 (prop);
				}
			}
			_vala_code_node_unref0 (sym);
			_vala_gir_parser_node_unref0 (n);
		}
		_vala_iterable_unref0 (_n_list);
	}
	_vala_iterable_unref0 (nodes);
	_vala_gir_parser_node_unref0 (gtype_node);
}

static void
vala_gir_parser_process_async_method (ValaGirParser* self,
                                      ValaGirParserNode* node)
{
	ValaMethod* m = NULL;
	ValaSymbol* _tmp0_;
	ValaMethod* _tmp1_;
	gboolean requires_pointer = FALSE;
	gchar* finish_method_base = NULL;
	ValaMethod* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	ValaGirParserNode* finish_method_node = NULL;
	ValaGirParserNode* _tmp49_;
	const gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	ValaGirParserNode* _tmp53_;
	ValaGirParserNode* _tmp54_;
	ValaGirParserNode* _tmp55_;
	ValaMethod* method = NULL;
	ValaMethod* _tmp74_;
	ValaMethod* _tmp75_;
	gboolean _tmp76_ = FALSE;
	ValaGirParserNode* _tmp77_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node->symbol;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALA_TYPE_METHOD, ValaMethod));
	m = _tmp1_;
	requires_pointer = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaMethod* _tmp2_;
		ValaList* _tmp3_;
		ValaList* _tmp4_;
		gint _param_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _param_index = 0;
		_tmp2_ = m;
		_tmp3_ = vala_callable_get_parameters ((ValaCallable*) _tmp2_);
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_param_list = _tmp4_;
		_tmp5_ = _param_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_param_size = _tmp7_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp8_;
			gpointer _tmp9_;
			ValaParameter* _tmp10_;
			ValaParameterDirection _tmp11_;
			ValaParameterDirection _tmp12_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp8_ = _param_list;
			_tmp9_ = vala_list_get (_tmp8_, _param_index);
			param = (ValaParameter*) _tmp9_;
			_tmp10_ = param;
			_tmp11_ = vala_parameter_get_direction (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ == VALA_PARAMETER_DIRECTION_IN) {
				requires_pointer = TRUE;
			} else {
				if (requires_pointer) {
					ValaParameter* _tmp13_;
					ValaParameter* _tmp14_;
					ValaDataType* _tmp15_;
					ValaDataType* _tmp16_;
					ValaParameter* _tmp17_;
					ValaParameter* _tmp18_;
					ValaDataType* _tmp19_;
					ValaDataType* _tmp20_;
					ValaPointerType* _tmp21_;
					ValaPointerType* _tmp22_;
					ValaParameter* _tmp23_;
					ValaSourceReference* _tmp24_;
					ValaSourceReference* _tmp25_;
					_tmp13_ = param;
					vala_parameter_set_direction (_tmp13_, VALA_PARAMETER_DIRECTION_IN);
					_tmp14_ = param;
					_tmp15_ = vala_variable_get_variable_type ((ValaVariable*) _tmp14_);
					_tmp16_ = _tmp15_;
					vala_data_type_set_nullable (_tmp16_, FALSE);
					_tmp17_ = param;
					_tmp18_ = param;
					_tmp19_ = vala_variable_get_variable_type ((ValaVariable*) _tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = vala_pointer_type_new (_tmp20_, NULL);
					_tmp22_ = _tmp21_;
					vala_variable_set_variable_type ((ValaVariable*) _tmp17_, (ValaDataType*) _tmp22_);
					_vala_code_node_unref0 (_tmp22_);
					_tmp23_ = param;
					_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp23_);
					_tmp25_ = _tmp24_;
					vala_report_warning (_tmp25_, "Synchronous out-parameters are not supported in async methods");
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp26_ = m;
	_tmp27_ = vala_symbol_get_name ((ValaSymbol*) _tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_ == NULL) {
		ValaMethod* _tmp29_;
		gchar* _tmp30_;
		_tmp29_ = m;
		_vala_assert (VALA_IS_CREATION_METHOD (_tmp29_), "m is CreationMethod");
		_tmp30_ = g_strdup ("new");
		_g_free0 (finish_method_base);
		finish_method_base = _tmp30_;
	} else {
		ValaMethod* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp31_ = m;
		_tmp32_ = vala_symbol_get_name ((ValaSymbol*) _tmp31_);
		_tmp33_ = _tmp32_;
		if (g_str_has_suffix (_tmp33_, "_async")) {
			ValaMethod* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			ValaMethod* _tmp37_;
			const gchar* _tmp38_;
			const gchar* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			gchar* _tmp44_;
			_tmp34_ = m;
			_tmp35_ = vala_symbol_get_name ((ValaSymbol*) _tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = m;
			_tmp38_ = vala_symbol_get_name ((ValaSymbol*) _tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = strlen (_tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = strlen ("_async");
			_tmp43_ = _tmp42_;
			_tmp44_ = string_substring (_tmp36_, (glong) 0, (glong) (_tmp41_ - _tmp43_));
			_g_free0 (finish_method_base);
			finish_method_base = _tmp44_;
		} else {
			ValaMethod* _tmp45_;
			const gchar* _tmp46_;
			const gchar* _tmp47_;
			gchar* _tmp48_;
			_tmp45_ = m;
			_tmp46_ = vala_symbol_get_name ((ValaSymbol*) _tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = g_strdup (_tmp47_);
			_g_free0 (finish_method_base);
			finish_method_base = _tmp48_;
		}
	}
	_tmp49_ = node->parent;
	_tmp50_ = finish_method_base;
	_tmp51_ = g_strconcat (_tmp50_, "_finish", NULL);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_gir_parser_node_lookup (_tmp49_, _tmp52_, FALSE, NULL);
	_tmp54_ = _tmp53_;
	_g_free0 (_tmp52_);
	finish_method_node = _tmp54_;
	_tmp55_ = finish_method_node;
	if (_tmp55_ == NULL) {
		gchar* method_cname = NULL;
		gchar* _tmp56_;
		_tmp56_ = vala_gir_parser_node_get_finish_cname (node);
		method_cname = _tmp56_;
		{
			ValaArrayList* _n_list = NULL;
			ValaGirParserNode* _tmp57_;
			ValaArrayList* _tmp58_;
			ValaArrayList* _tmp59_;
			gint _n_size = 0;
			ValaArrayList* _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			gint _n_index = 0;
			_tmp57_ = node->parent;
			_tmp58_ = _tmp57_->members;
			_tmp59_ = _vala_iterable_ref0 (_tmp58_);
			_n_list = _tmp59_;
			_tmp60_ = _n_list;
			_tmp61_ = vala_collection_get_size ((ValaCollection*) _tmp60_);
			_tmp62_ = _tmp61_;
			_n_size = _tmp62_;
			_n_index = -1;
			while (TRUE) {
				ValaGirParserNode* n = NULL;
				ValaArrayList* _tmp63_;
				gpointer _tmp64_;
				gboolean _tmp65_ = FALSE;
				ValaGirParserNode* _tmp66_;
				ValaSymbol* _tmp67_;
				_n_index = _n_index + 1;
				if (!(_n_index < _n_size)) {
					break;
				}
				_tmp63_ = _n_list;
				_tmp64_ = vala_list_get ((ValaList*) _tmp63_, _n_index);
				n = (ValaGirParserNode*) _tmp64_;
				_tmp66_ = n;
				_tmp67_ = _tmp66_->symbol;
				if (VALA_IS_METHOD (_tmp67_)) {
					ValaGirParserNode* _tmp68_;
					gchar* _tmp69_;
					gchar* _tmp70_;
					const gchar* _tmp71_;
					_tmp68_ = n;
					_tmp69_ = vala_gir_parser_node_get_cname (_tmp68_);
					_tmp70_ = _tmp69_;
					_tmp71_ = method_cname;
					_tmp65_ = g_strcmp0 (_tmp70_, _tmp71_) == 0;
					_g_free0 (_tmp70_);
				} else {
					_tmp65_ = FALSE;
				}
				if (_tmp65_) {
					ValaGirParserNode* _tmp72_;
					ValaGirParserNode* _tmp73_;
					_tmp72_ = n;
					_tmp73_ = _vala_gir_parser_node_ref0 (_tmp72_);
					_vala_gir_parser_node_unref0 (finish_method_node);
					finish_method_node = _tmp73_;
					_vala_gir_parser_node_unref0 (n);
					break;
				}
				_vala_gir_parser_node_unref0 (n);
			}
			_vala_iterable_unref0 (_n_list);
		}
		_g_free0 (method_cname);
	}
	_tmp74_ = m;
	_tmp75_ = _vala_code_node_ref0 (_tmp74_);
	method = _tmp75_;
	_tmp77_ = finish_method_node;
	if (_tmp77_ != NULL) {
		ValaGirParserNode* _tmp78_;
		ValaSymbol* _tmp79_;
		_tmp78_ = finish_method_node;
		_tmp79_ = _tmp78_->symbol;
		_tmp76_ = VALA_IS_METHOD (_tmp79_);
	} else {
		_tmp76_ = FALSE;
	}
	if (_tmp76_) {
		ValaGirParserNode* _tmp80_;
		ValaMethod* finish_method = NULL;
		ValaGirParserNode* _tmp81_;
		ValaSymbol* _tmp82_;
		ValaMethod* _tmp83_;
		ValaMethod* _tmp84_;
		ValaMethod* _tmp152_;
		ValaMethod* _tmp153_;
		ValaArrayList* error_types = NULL;
		GEqualFunc _tmp184_;
		ValaArrayList* _tmp185_;
		ValaMethod* _tmp186_;
		ValaArrayList* _tmp187_;
		ValaMethod* _tmp188_;
		ValaSourceReference* _tmp189_;
		ValaSourceReference* _tmp190_;
		ValaGirParserNode* _tmp200_;
		ValaGirParserNode* _tmp201_;
		_tmp80_ = finish_method_node;
		vala_gir_parser_node_process (_tmp80_, self);
		_tmp81_ = finish_method_node;
		_tmp82_ = _tmp81_->symbol;
		_tmp83_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, VALA_TYPE_METHOD, ValaMethod));
		finish_method = _tmp83_;
		_tmp84_ = finish_method;
		if (VALA_IS_CREATION_METHOD (_tmp84_)) {
			ValaMethod* _tmp85_;
			const gchar* _tmp86_;
			const gchar* _tmp87_;
			ValaMethod* _tmp88_;
			ValaSourceReference* _tmp89_;
			ValaSourceReference* _tmp90_;
			ValaCreationMethod* _tmp91_;
			ValaMethod* _tmp92_;
			ValaMethod* _tmp93_;
			ValaSymbolAccessibility _tmp94_;
			ValaSymbolAccessibility _tmp95_;
			ValaMethod* _tmp96_;
			ValaMethod* _tmp97_;
			ValaMethod* _tmp98_;
			gboolean _tmp99_;
			gboolean _tmp100_;
			ValaMethod* _tmp101_;
			GList* _tmp102_;
			ValaMethod* _tmp107_;
			gchar* _tmp108_;
			gchar* _tmp109_;
			const gchar* _tmp110_;
			ValaMethod* _tmp131_;
			ValaSymbol* _tmp132_;
			_tmp85_ = finish_method;
			_tmp86_ = vala_creation_method_get_class_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			_tmp87_ = _tmp86_;
			_tmp88_ = m;
			_tmp89_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp88_);
			_tmp90_ = _tmp89_;
			_tmp91_ = vala_creation_method_new (_tmp87_, NULL, _tmp90_, NULL);
			_vala_code_node_unref0 (method);
			method = (ValaMethod*) _tmp91_;
			_tmp92_ = method;
			_tmp93_ = m;
			_tmp94_ = vala_symbol_get_access ((ValaSymbol*) _tmp93_);
			_tmp95_ = _tmp94_;
			vala_symbol_set_access ((ValaSymbol*) _tmp92_, _tmp95_);
			_tmp96_ = method;
			vala_method_set_coroutine (_tmp96_, TRUE);
			_tmp97_ = method;
			_tmp98_ = finish_method;
			_tmp99_ = vala_method_get_has_construct_function (_tmp98_);
			_tmp100_ = _tmp99_;
			vala_method_set_has_construct_function (_tmp97_, _tmp100_);
			_tmp101_ = m;
			_tmp102_ = ((ValaCodeNode*) _tmp101_)->attributes;
			{
				GList* a_collection = NULL;
				GList* a_it = NULL;
				a_collection = _tmp102_;
				for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
					ValaAttribute* _tmp103_;
					ValaAttribute* a = NULL;
					_tmp103_ = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
					a = _tmp103_;
					{
						ValaMethod* _tmp104_;
						ValaAttribute* _tmp105_;
						ValaAttribute* _tmp106_;
						_tmp104_ = method;
						_tmp105_ = a;
						_tmp106_ = _vala_code_node_ref0 (_tmp105_);
						((ValaCodeNode*) _tmp104_)->attributes = g_list_append (((ValaCodeNode*) _tmp104_)->attributes, _tmp106_);
						_vala_code_node_unref0 (a);
					}
				}
			}
			_tmp107_ = method;
			_tmp108_ = vala_gir_parser_node_get_cname (node);
			_tmp109_ = _tmp108_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp107_, "CCode", "cname", _tmp109_, NULL);
			_g_free0 (_tmp109_);
			_tmp110_ = finish_method_base;
			if (g_strcmp0 (_tmp110_, "new") == 0) {
				ValaMethod* _tmp111_;
				_tmp111_ = method;
				vala_symbol_set_name ((ValaSymbol*) _tmp111_, NULL);
			} else {
				const gchar* _tmp112_;
				_tmp112_ = finish_method_base;
				if (g_str_has_prefix (_tmp112_, "new_")) {
					ValaMethod* _tmp113_;
					ValaMethod* _tmp114_;
					const gchar* _tmp115_;
					const gchar* _tmp116_;
					gint _tmp117_;
					gint _tmp118_;
					gchar* _tmp119_;
					gchar* _tmp120_;
					_tmp113_ = method;
					_tmp114_ = m;
					_tmp115_ = vala_symbol_get_name ((ValaSymbol*) _tmp114_);
					_tmp116_ = _tmp115_;
					_tmp117_ = strlen ("new_");
					_tmp118_ = _tmp117_;
					_tmp119_ = string_substring (_tmp116_, (glong) _tmp118_, (glong) -1);
					_tmp120_ = _tmp119_;
					vala_symbol_set_name ((ValaSymbol*) _tmp113_, _tmp120_);
					_g_free0 (_tmp120_);
				}
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp121_;
				ValaList* _tmp122_;
				ValaList* _tmp123_;
				gint _param_size = 0;
				ValaList* _tmp124_;
				gint _tmp125_;
				gint _tmp126_;
				gint _param_index = 0;
				_tmp121_ = m;
				_tmp122_ = vala_callable_get_parameters ((ValaCallable*) _tmp121_);
				_tmp123_ = _vala_iterable_ref0 (_tmp122_);
				_param_list = _tmp123_;
				_tmp124_ = _param_list;
				_tmp125_ = vala_collection_get_size ((ValaCollection*) _tmp124_);
				_tmp126_ = _tmp125_;
				_param_size = _tmp126_;
				_param_index = -1;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp127_;
					gpointer _tmp128_;
					ValaMethod* _tmp129_;
					ValaParameter* _tmp130_;
					_param_index = _param_index + 1;
					if (!(_param_index < _param_size)) {
						break;
					}
					_tmp127_ = _param_list;
					_tmp128_ = vala_list_get (_tmp127_, _param_index);
					param = (ValaParameter*) _tmp128_;
					_tmp129_ = method;
					_tmp130_ = param;
					vala_callable_add_parameter ((ValaCallable*) _tmp129_, _tmp130_);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp131_ = method;
			_tmp132_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp131_);
			_vala_code_node_unref0 (node->symbol);
			node->symbol = _tmp132_;
		} else {
			ValaMethod* _tmp133_;
			ValaMethod* _tmp134_;
			ValaDataType* _tmp135_;
			ValaDataType* _tmp136_;
			ValaDataType* _tmp137_;
			ValaDataType* _tmp138_;
			ValaAttribute* a = NULL;
			ValaMethod* _tmp139_;
			ValaAttribute* _tmp140_;
			ValaAttribute* _tmp141_;
			gboolean _tmp142_ = FALSE;
			ValaAttribute* _tmp143_;
			gboolean _tmp147_ = FALSE;
			ValaAttribute* _tmp148_;
			_tmp133_ = method;
			_tmp134_ = finish_method;
			_tmp135_ = vala_callable_get_return_type ((ValaCallable*) _tmp134_);
			_tmp136_ = _tmp135_;
			_tmp137_ = vala_data_type_copy (_tmp136_);
			_tmp138_ = _tmp137_;
			vala_callable_set_return_type ((ValaCallable*) _tmp133_, _tmp138_);
			_vala_code_node_unref0 (_tmp138_);
			_tmp139_ = finish_method;
			_tmp140_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp139_, "CCode");
			_tmp141_ = _vala_code_node_ref0 (_tmp140_);
			a = _tmp141_;
			_tmp143_ = a;
			if (_tmp143_ != NULL) {
				ValaAttribute* _tmp144_;
				_tmp144_ = a;
				_tmp142_ = vala_attribute_has_argument (_tmp144_, "array_length");
			} else {
				_tmp142_ = FALSE;
			}
			if (_tmp142_) {
				ValaMethod* _tmp145_;
				ValaAttribute* _tmp146_;
				_tmp145_ = method;
				_tmp146_ = a;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp145_, "CCode", "array_length", vala_attribute_get_bool (_tmp146_, "array_length", FALSE), NULL);
			}
			_tmp148_ = a;
			if (_tmp148_ != NULL) {
				ValaAttribute* _tmp149_;
				_tmp149_ = a;
				_tmp147_ = vala_attribute_has_argument (_tmp149_, "array_null_terminated");
			} else {
				_tmp147_ = FALSE;
			}
			if (_tmp147_) {
				ValaMethod* _tmp150_;
				ValaAttribute* _tmp151_;
				_tmp150_ = method;
				_tmp151_ = a;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp150_, "CCode", "array_null_terminated", vala_attribute_get_bool (_tmp151_, "array_null_terminated", FALSE), NULL);
			}
			_vala_code_node_unref0 (a);
		}
		_tmp152_ = method;
		_tmp153_ = finish_method;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) _tmp152_, (ValaCodeNode*) _tmp153_, "CCode", "async_result_pos");
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp154_;
			ValaList* _tmp155_;
			ValaList* _tmp156_;
			gint _param_size = 0;
			ValaList* _tmp157_;
			gint _tmp158_;
			gint _tmp159_;
			gint _param_index = 0;
			_tmp154_ = finish_method;
			_tmp155_ = vala_callable_get_parameters ((ValaCallable*) _tmp154_);
			_tmp156_ = _vala_iterable_ref0 (_tmp155_);
			_param_list = _tmp156_;
			_tmp157_ = _param_list;
			_tmp158_ = vala_collection_get_size ((ValaCollection*) _tmp157_);
			_tmp159_ = _tmp158_;
			_param_size = _tmp159_;
			_param_index = -1;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaList* _tmp160_;
				gpointer _tmp161_;
				ValaParameter* _tmp162_;
				ValaParameterDirection _tmp163_;
				ValaParameterDirection _tmp164_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp160_ = _param_list;
				_tmp161_ = vala_list_get (_tmp160_, _param_index);
				param = (ValaParameter*) _tmp161_;
				_tmp162_ = param;
				_tmp163_ = vala_parameter_get_direction (_tmp162_);
				_tmp164_ = _tmp163_;
				if (_tmp164_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaParameter* async_param = NULL;
					ValaParameter* _tmp165_;
					ValaParameter* _tmp166_;
					ValaMethod* _tmp167_;
					ValaScope* _tmp168_;
					ValaScope* _tmp169_;
					ValaParameter* _tmp170_;
					const gchar* _tmp171_;
					const gchar* _tmp172_;
					ValaSymbol* _tmp173_;
					ValaSymbol* _tmp174_;
					gboolean _tmp175_;
					ValaMethod* _tmp182_;
					ValaParameter* _tmp183_;
					_tmp165_ = param;
					_tmp166_ = vala_parameter_copy (_tmp165_);
					async_param = _tmp166_;
					_tmp167_ = method;
					_tmp168_ = vala_symbol_get_scope ((ValaSymbol*) _tmp167_);
					_tmp169_ = _tmp168_;
					_tmp170_ = param;
					_tmp171_ = vala_symbol_get_name ((ValaSymbol*) _tmp170_);
					_tmp172_ = _tmp171_;
					_tmp173_ = vala_scope_lookup (_tmp169_, _tmp172_);
					_tmp174_ = _tmp173_;
					_tmp175_ = _tmp174_ != NULL;
					_vala_code_node_unref0 (_tmp174_);
					if (_tmp175_) {
						ValaParameter* _tmp176_;
						ValaParameter* _tmp177_;
						const gchar* _tmp178_;
						const gchar* _tmp179_;
						gchar* _tmp180_;
						gchar* _tmp181_;
						_tmp176_ = async_param;
						_tmp177_ = async_param;
						_tmp178_ = vala_symbol_get_name ((ValaSymbol*) _tmp177_);
						_tmp179_ = _tmp178_;
						_tmp180_ = g_strconcat (_tmp179_, "_out", NULL);
						_tmp181_ = _tmp180_;
						vala_symbol_set_name ((ValaSymbol*) _tmp177_, _tmp181_);
						_g_free0 (_tmp181_);
					}
					_tmp182_ = method;
					_tmp183_ = async_param;
					vala_callable_add_parameter ((ValaCallable*) _tmp182_, _tmp183_);
					_vala_code_node_unref0 (async_param);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp184_ = g_direct_equal;
		_tmp185_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp184_);
		error_types = _tmp185_;
		_tmp186_ = finish_method;
		_tmp187_ = error_types;
		_tmp188_ = method;
		_tmp189_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp188_);
		_tmp190_ = _tmp189_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp186_, (ValaCollection*) _tmp187_, _tmp190_);
		{
			ValaArrayList* _error_type_list = NULL;
			ValaArrayList* _tmp191_;
			ValaArrayList* _tmp192_;
			gint _error_type_size = 0;
			ValaArrayList* _tmp193_;
			gint _tmp194_;
			gint _tmp195_;
			gint _error_type_index = 0;
			_tmp191_ = error_types;
			_tmp192_ = _vala_iterable_ref0 (_tmp191_);
			_error_type_list = _tmp192_;
			_tmp193_ = _error_type_list;
			_tmp194_ = vala_collection_get_size ((ValaCollection*) _tmp193_);
			_tmp195_ = _tmp194_;
			_error_type_size = _tmp195_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaArrayList* _tmp196_;
				gpointer _tmp197_;
				ValaMethod* _tmp198_;
				ValaDataType* _tmp199_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp196_ = _error_type_list;
				_tmp197_ = vala_list_get ((ValaList*) _tmp196_, _error_type_index);
				error_type = (ValaDataType*) _tmp197_;
				_tmp198_ = method;
				_tmp199_ = error_type;
				vala_method_add_error_type (_tmp198_, _tmp199_);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
		_tmp200_ = finish_method_node;
		_tmp200_->processed = TRUE;
		_tmp201_ = finish_method_node;
		_tmp201_->merged = TRUE;
		_vala_iterable_unref0 (error_types);
		_vala_code_node_unref0 (finish_method);
	}
	_vala_code_node_unref0 (method);
	_vala_gir_parser_node_unref0 (finish_method_node);
	_g_free0 (finish_method_base);
	_vala_code_node_unref0 (m);
}

static guint
vala_gir_parser_unresolved_symbol_hash (ValaUnresolvedSymbol* sym)
{
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp6_;
	const gchar* _tmp7_;
	guint result = 0U;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	while (TRUE) {
		GString* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		ValaUnresolvedSymbol* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		if (!(sym != NULL)) {
			break;
		}
		_tmp1_ = builder;
		_tmp2_ = vala_symbol_get_name ((ValaSymbol*) sym);
		_tmp3_ = _tmp2_;
		g_string_append (_tmp1_, _tmp3_);
		_tmp4_ = vala_unresolved_symbol_get_inner (sym);
		_tmp5_ = _tmp4_;
		sym = _tmp5_;
	}
	_tmp6_ = builder;
	_tmp7_ = _tmp6_->str;
	result = g_str_hash (_tmp7_);
	_g_string_free0 (builder);
	return result;
}

static gboolean
vala_gir_parser_unresolved_symbol_equal (ValaUnresolvedSymbol* sym1,
                                         ValaUnresolvedSymbol* sym2)
{
	gboolean result = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		ValaUnresolvedSymbol* _tmp6_;
		ValaUnresolvedSymbol* _tmp7_;
		ValaUnresolvedSymbol* _tmp8_;
		if (!(sym1 != sym2)) {
			break;
		}
		if (sym1 == NULL) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = sym2 == NULL;
		}
		if (_tmp0_) {
			result = FALSE;
			return result;
		}
		_tmp1_ = vala_symbol_get_name ((ValaSymbol*) sym1);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_symbol_get_name ((ValaSymbol*) sym2);
		_tmp4_ = _tmp3_;
		if (g_strcmp0 (_tmp2_, _tmp4_) != 0) {
			result = FALSE;
			return result;
		}
		_tmp5_ = vala_unresolved_symbol_get_inner (sym1);
		_tmp6_ = _tmp5_;
		sym1 = _tmp6_;
		_tmp7_ = vala_unresolved_symbol_get_inner (sym2);
		_tmp8_ = _tmp7_;
		sym2 = _tmp8_;
	}
	result = TRUE;
	return result;
}

static ValaGirParserNode*
vala_gir_parser_base_interface_property (ValaGirParser* self,
                                         ValaGirParserNode* prop_node)
{
	ValaClass* cl = NULL;
	ValaGirParserNode* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaClass* _tmp2_;
	ValaClass* _tmp3_;
	ValaGirParserNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop_node != NULL, NULL);
	_tmp0_ = prop_node->parent;
	_tmp1_ = _tmp0_->symbol;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp1_) ? ((ValaClass*) _tmp1_) : NULL);
	cl = _tmp2_;
	_tmp3_ = cl;
	if (_tmp3_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (cl);
		return result;
	}
	{
		ValaList* _type_list = NULL;
		ValaClass* _tmp4_;
		ValaList* _tmp5_;
		ValaList* _tmp6_;
		gint _type_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _type_index = 0;
		_tmp4_ = cl;
		_tmp5_ = vala_class_get_base_types (_tmp4_);
		_tmp6_ = _vala_iterable_ref0 (_tmp5_);
		_type_list = _tmp6_;
		_tmp7_ = _type_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_type_size = _tmp9_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp10_;
			gpointer _tmp11_;
			ValaDataType* _tmp12_;
			ValaGirParserNode* base_node = NULL;
			ValaGirParserNode* _tmp13_;
			ValaDataType* _tmp14_;
			ValaUnresolvedSymbol* _tmp15_;
			ValaUnresolvedSymbol* _tmp16_;
			ValaGirParserNode* _tmp17_;
			gboolean _tmp18_ = FALSE;
			ValaGirParserNode* _tmp19_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp10_ = _type_list;
			_tmp11_ = vala_list_get (_tmp10_, _type_index);
			type = (ValaDataType*) _tmp11_;
			_tmp12_ = type;
			if (!VALA_IS_UNRESOLVED_TYPE (_tmp12_)) {
				_vala_code_node_unref0 (type);
				continue;
			}
			_tmp13_ = prop_node->parent;
			_tmp14_ = type;
			_tmp15_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_gir_parser_resolve_node (self, _tmp13_, _tmp16_, FALSE);
			base_node = _tmp17_;
			_tmp19_ = base_node;
			if (_tmp19_ != NULL) {
				ValaGirParserNode* _tmp20_;
				ValaSymbol* _tmp21_;
				_tmp20_ = base_node;
				_tmp21_ = _tmp20_->symbol;
				_tmp18_ = VALA_IS_INTERFACE (_tmp21_);
			} else {
				_tmp18_ = FALSE;
			}
			if (_tmp18_) {
				ValaGirParserNode* base_prop_node = NULL;
				ValaGirParserNode* _tmp22_;
				const gchar* _tmp23_;
				ValaGirParserNode* _tmp24_;
				gboolean _tmp25_ = FALSE;
				ValaGirParserNode* _tmp26_;
				_tmp22_ = base_node;
				_tmp23_ = prop_node->name;
				_tmp24_ = vala_gir_parser_node_lookup (_tmp22_, _tmp23_, FALSE, NULL);
				base_prop_node = _tmp24_;
				_tmp26_ = base_prop_node;
				if (_tmp26_ != NULL) {
					ValaGirParserNode* _tmp27_;
					ValaSymbol* _tmp28_;
					_tmp27_ = base_prop_node;
					_tmp28_ = _tmp27_->symbol;
					_tmp25_ = VALA_IS_PROPERTY (_tmp28_);
				} else {
					_tmp25_ = FALSE;
				}
				if (_tmp25_) {
					ValaProperty* base_property = NULL;
					ValaGirParserNode* _tmp29_;
					ValaSymbol* _tmp30_;
					ValaProperty* _tmp31_;
					gboolean _tmp32_ = FALSE;
					ValaProperty* _tmp33_;
					gboolean _tmp34_;
					gboolean _tmp35_;
					_tmp29_ = base_prop_node;
					_tmp30_ = _tmp29_->symbol;
					_tmp31_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_PROPERTY, ValaProperty));
					base_property = _tmp31_;
					_tmp33_ = base_property;
					_tmp34_ = vala_property_get_is_abstract (_tmp33_);
					_tmp35_ = _tmp34_;
					if (_tmp35_) {
						_tmp32_ = TRUE;
					} else {
						ValaProperty* _tmp36_;
						gboolean _tmp37_;
						gboolean _tmp38_;
						_tmp36_ = base_property;
						_tmp37_ = vala_property_get_is_virtual (_tmp36_);
						_tmp38_ = _tmp37_;
						_tmp32_ = _tmp38_;
					}
					if (_tmp32_) {
						result = base_prop_node;
						_vala_code_node_unref0 (base_property);
						_vala_gir_parser_node_unref0 (base_node);
						_vala_code_node_unref0 (type);
						_vala_iterable_unref0 (_type_list);
						_vala_code_node_unref0 (cl);
						return result;
					}
					_vala_code_node_unref0 (base_property);
				}
				_vala_gir_parser_node_unref0 (base_prop_node);
			}
			_vala_gir_parser_node_unref0 (base_node);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	result = NULL;
	_vala_code_node_unref0 (cl);
	return result;
}

ValaGirParser*
vala_gir_parser_construct (GType object_type)
{
	ValaGirParser* self = NULL;
	self = (ValaGirParser*) vala_code_visitor_construct (object_type);
	return self;
}

ValaGirParser*
vala_gir_parser_new (void)
{
	return vala_gir_parser_construct (VALA_TYPE_GIR_PARSER);
}

static gpointer
_vala_source_reference_ref0 (gpointer self)
{
	return self ? vala_source_reference_ref (self) : NULL;
}

static ValaGirParserArgument*
vala_gir_parser_argument_construct (GType object_type,
                                    ValaExpression* expression,
                                    ValaSourceReference* source_reference)
{
	ValaGirParserArgument* self = NULL;
	ValaExpression* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_val_if_fail (expression != NULL, NULL);
	self = (ValaGirParserArgument*) g_type_create_instance (object_type);
	_tmp0_ = _vala_code_node_ref0 (expression);
	_vala_code_node_unref0 (self->expression);
	self->expression = _tmp0_;
	_tmp1_ = _vala_source_reference_ref0 (source_reference);
	_vala_source_reference_unref0 (self->source_reference);
	self->source_reference = _tmp1_;
	return self;
}

static ValaGirParserArgument*
vala_gir_parser_argument_new (ValaExpression* expression,
                              ValaSourceReference* source_reference)
{
	return vala_gir_parser_argument_construct (VALA_GIR_PARSER_TYPE_ARGUMENT, expression, source_reference);
}

static void
vala_gir_parser_value_argument_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_gir_parser_value_argument_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_argument_unref (value->data[0].v_pointer);
	}
}

static void
vala_gir_parser_value_argument_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_argument_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_gir_parser_value_argument_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_gir_parser_value_argument_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserArgument * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_argument_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_gir_parser_value_argument_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	ValaGirParserArgument ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_argument_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
vala_gir_parser_param_spec_argument (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	ValaGirParserParamSpecArgument* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_ARGUMENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
vala_gir_parser_value_get_argument (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_ARGUMENT), NULL);
	return value->data[0].v_pointer;
}

static void
vala_gir_parser_value_set_argument (GValue* value,
                                    gpointer v_object)
{
	ValaGirParserArgument * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_ARGUMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_ARGUMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_argument_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_argument_unref (old);
	}
}

static void
vala_gir_parser_value_take_argument (GValue* value,
                                     gpointer v_object)
{
	ValaGirParserArgument * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_ARGUMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_ARGUMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_argument_unref (old);
	}
}

static void
vala_gir_parser_argument_class_init (ValaGirParserArgumentClass * klass,
                                     gpointer klass_data)
{
	vala_gir_parser_argument_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserArgumentClass *) klass)->finalize = vala_gir_parser_argument_finalize;
}

static void
vala_gir_parser_argument_instance_init (ValaGirParserArgument * self,
                                        gpointer klass)
{
	self->used = FALSE;
	self->ref_count = 1;
}

static void
vala_gir_parser_argument_finalize (ValaGirParserArgument * obj)
{
	ValaGirParserArgument * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgument);
	g_signal_handlers_destroy (self);
	_vala_code_node_unref0 (self->expression);
	_vala_source_reference_unref0 (self->source_reference);
}

static GType
vala_gir_parser_argument_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_argument_init, vala_gir_parser_value_argument_free_value, vala_gir_parser_value_argument_copy_value, vala_gir_parser_value_argument_peek_pointer, "p", vala_gir_parser_value_argument_collect_value, "p", vala_gir_parser_value_argument_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserArgumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_argument_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserArgument), 0, (GInstanceInitFunc) vala_gir_parser_argument_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_gir_parser_argument_type_id;
	vala_gir_parser_argument_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserArgument", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return vala_gir_parser_argument_type_id;
}

static GType
vala_gir_parser_argument_get_type (void)
{
	static volatile gsize vala_gir_parser_argument_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_argument_type_id__volatile)) {
		GType vala_gir_parser_argument_type_id;
		vala_gir_parser_argument_type_id = vala_gir_parser_argument_get_type_once ();
		g_once_init_leave (&vala_gir_parser_argument_type_id__volatile, vala_gir_parser_argument_type_id);
	}
	return vala_gir_parser_argument_type_id__volatile;
}

static gpointer
vala_gir_parser_argument_ref (gpointer instance)
{
	ValaGirParserArgument * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
vala_gir_parser_argument_unref (gpointer instance)
{
	ValaGirParserArgument * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_ARGUMENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static ValaGirParserMetadataSet*
vala_gir_parser_metadata_set_construct (GType object_type,
                                        const gchar* selector)
{
	ValaGirParserMetadataSet* self = NULL;
	self = (ValaGirParserMetadataSet*) vala_gir_parser_metadata_construct (object_type, "", selector, NULL);
	return self;
}

static ValaGirParserMetadataSet*
vala_gir_parser_metadata_set_new (const gchar* selector)
{
	return vala_gir_parser_metadata_set_construct (VALA_GIR_PARSER_TYPE_METADATA_SET, selector);
}

static void
vala_gir_parser_metadata_set_add_sibling (ValaGirParserMetadataSet* self,
                                          ValaGirParserMetadata* metadata)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata != NULL);
	{
		ValaArrayList* _child_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _child_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _child_index = 0;
		_tmp0_ = metadata->children;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_child_list = _tmp1_;
		_tmp2_ = _child_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_child_size = _tmp4_;
		_child_index = -1;
		while (TRUE) {
			ValaGirParserMetadata* child = NULL;
			ValaArrayList* _tmp5_;
			gpointer _tmp6_;
			ValaGirParserMetadata* _tmp7_;
			_child_index = _child_index + 1;
			if (!(_child_index < _child_size)) {
				break;
			}
			_tmp5_ = _child_list;
			_tmp6_ = vala_list_get ((ValaList*) _tmp5_, _child_index);
			child = (ValaGirParserMetadata*) _tmp6_;
			_tmp7_ = child;
			vala_gir_parser_metadata_add_child ((ValaGirParserMetadata*) self, _tmp7_);
			_vala_gir_parser_metadata_unref0 (child);
		}
		_vala_iterable_unref0 (_child_list);
	}
	{
		ValaIterator* _key_it = NULL;
		ValaMap* _tmp8_;
		ValaSet* _tmp9_;
		ValaSet* _tmp10_;
		ValaIterator* _tmp11_;
		ValaIterator* _tmp12_;
		_tmp8_ = metadata->args;
		_tmp9_ = vala_map_get_keys (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_iterable_iterator ((ValaIterable*) _tmp10_);
		_tmp12_ = _tmp11_;
		_vala_iterable_unref0 (_tmp10_);
		_key_it = _tmp12_;
		while (TRUE) {
			ValaIterator* _tmp13_;
			ValaGirParserArgumentType key = 0;
			ValaIterator* _tmp14_;
			gpointer _tmp15_;
			ValaMap* _tmp16_;
			ValaGirParserArgumentType _tmp17_;
			ValaMap* _tmp18_;
			ValaGirParserArgumentType _tmp19_;
			gpointer _tmp20_;
			ValaGirParserArgument* _tmp21_;
			_tmp13_ = _key_it;
			if (!vala_iterator_next (_tmp13_)) {
				break;
			}
			_tmp14_ = _key_it;
			_tmp15_ = vala_iterator_get (_tmp14_);
			key = (ValaGirParserArgumentType) ((gintptr) _tmp15_);
			_tmp16_ = ((ValaGirParserMetadata*) self)->args;
			_tmp17_ = key;
			_tmp18_ = metadata->args;
			_tmp19_ = key;
			_tmp20_ = vala_map_get (_tmp18_, (gpointer) ((gintptr) _tmp19_));
			_tmp21_ = (ValaGirParserArgument*) _tmp20_;
			vala_map_set (_tmp16_, (gpointer) ((gintptr) _tmp17_), _tmp21_);
			_vala_gir_parser_argument_unref0 (_tmp21_);
		}
		_vala_iterator_unref0 (_key_it);
	}
}

static void
vala_gir_parser_metadata_set_class_init (ValaGirParserMetadataSetClass * klass,
                                         gpointer klass_data)
{
	vala_gir_parser_metadata_set_parent_class = g_type_class_peek_parent (klass);
}

static void
vala_gir_parser_metadata_set_instance_init (ValaGirParserMetadataSet * self,
                                            gpointer klass)
{
}

static GType
vala_gir_parser_metadata_set_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserMetadataSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_metadata_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserMetadataSet), 0, (GInstanceInitFunc) vala_gir_parser_metadata_set_instance_init, NULL };
	GType vala_gir_parser_metadata_set_type_id;
	vala_gir_parser_metadata_set_type_id = g_type_register_static (VALA_GIR_PARSER_TYPE_METADATA, "ValaGirParserMetadataSet", &g_define_type_info, 0);
	return vala_gir_parser_metadata_set_type_id;
}

static GType
vala_gir_parser_metadata_set_get_type (void)
{
	static volatile gsize vala_gir_parser_metadata_set_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_metadata_set_type_id__volatile)) {
		GType vala_gir_parser_metadata_set_type_id;
		vala_gir_parser_metadata_set_type_id = vala_gir_parser_metadata_set_get_type_once ();
		g_once_init_leave (&vala_gir_parser_metadata_set_type_id__volatile, vala_gir_parser_metadata_set_type_id);
	}
	return vala_gir_parser_metadata_set_type_id__volatile;
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_get_empty (void)
{
	ValaGirParserMetadata* result;
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp2_;
	_tmp0_ = vala_gir_parser_metadata__empty;
	if (_tmp0_ == NULL) {
		ValaGirParserMetadata* _tmp1_;
		_tmp1_ = vala_gir_parser_metadata_new ("", NULL, NULL);
		_vala_gir_parser_metadata_unref0 (vala_gir_parser_metadata__empty);
		vala_gir_parser_metadata__empty = _tmp1_;
	}
	_tmp2_ = vala_gir_parser_metadata__empty;
	result = _tmp2_;
	return result;
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_construct (GType object_type,
                                    const gchar* pattern,
                                    const gchar* selector,
                                    ValaSourceReference* source_reference)
{
	ValaGirParserMetadata* self = NULL;
	GPatternSpec* _tmp0_;
	gchar* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_val_if_fail (pattern != NULL, NULL);
	self = (ValaGirParserMetadata*) g_type_create_instance (object_type);
	_tmp0_ = g_pattern_spec_new (pattern);
	_g_pattern_spec_free0 (self->pattern_spec);
	self->pattern_spec = _tmp0_;
	_tmp1_ = g_strdup (selector);
	_g_free0 (self->selector);
	self->selector = _tmp1_;
	_tmp2_ = _vala_source_reference_ref0 (source_reference);
	_vala_source_reference_unref0 (self->source_reference);
	self->source_reference = _tmp2_;
	return self;
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_new (const gchar* pattern,
                              const gchar* selector,
                              ValaSourceReference* source_reference)
{
	return vala_gir_parser_metadata_construct (VALA_GIR_PARSER_TYPE_METADATA, pattern, selector, source_reference);
}

static void
vala_gir_parser_metadata_add_child (ValaGirParserMetadata* self,
                                    ValaGirParserMetadata* metadata)
{
	ValaArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata != NULL);
	_tmp0_ = self->children;
	vala_collection_add ((ValaCollection*) _tmp0_, metadata);
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_match_child (ValaGirParserMetadata* self,
                                      const gchar* name,
                                      const gchar* selector)
{
	ValaGirParserMetadata* _result_ = NULL;
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	ValaGirParserMetadata* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = vala_gir_parser_metadata_get_empty ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_gir_parser_metadata_ref0 (_tmp1_);
	_result_ = _tmp2_;
	{
		ValaArrayList* _metadata_list = NULL;
		ValaArrayList* _tmp3_;
		ValaArrayList* _tmp4_;
		gint _metadata_size = 0;
		ValaArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _metadata_index = 0;
		_tmp3_ = self->children;
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_metadata_list = _tmp4_;
		_tmp5_ = _metadata_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_metadata_size = _tmp7_;
		_metadata_index = -1;
		while (TRUE) {
			ValaGirParserMetadata* metadata = NULL;
			ValaArrayList* _tmp8_;
			gpointer _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			_metadata_index = _metadata_index + 1;
			if (!(_metadata_index < _metadata_size)) {
				break;
			}
			_tmp8_ = _metadata_list;
			_tmp9_ = vala_list_get ((ValaList*) _tmp8_, _metadata_index);
			metadata = (ValaGirParserMetadata*) _tmp9_;
			if (selector == NULL) {
				_tmp12_ = TRUE;
			} else {
				ValaGirParserMetadata* _tmp13_;
				const gchar* _tmp14_;
				_tmp13_ = metadata;
				_tmp14_ = _tmp13_->selector;
				_tmp12_ = _tmp14_ == NULL;
			}
			if (_tmp12_) {
				_tmp11_ = TRUE;
			} else {
				ValaGirParserMetadata* _tmp15_;
				const gchar* _tmp16_;
				_tmp15_ = metadata;
				_tmp16_ = _tmp15_->selector;
				_tmp11_ = g_strcmp0 (_tmp16_, selector) == 0;
			}
			if (_tmp11_) {
				ValaGirParserMetadata* _tmp17_;
				GPatternSpec* _tmp18_;
				_tmp17_ = metadata;
				_tmp18_ = _tmp17_->pattern_spec;
				_tmp10_ = g_pattern_match_string (_tmp18_, name);
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				ValaGirParserMetadata* _tmp19_;
				ValaGirParserMetadata* _tmp20_;
				ValaGirParserMetadata* _tmp21_;
				ValaGirParserMetadata* _tmp22_;
				_tmp19_ = metadata;
				_tmp19_->used = TRUE;
				_tmp20_ = _result_;
				_tmp21_ = vala_gir_parser_metadata_get_empty ();
				_tmp22_ = _tmp21_;
				if (_tmp20_ == _tmp22_) {
					ValaGirParserMetadata* _tmp23_;
					ValaGirParserMetadata* _tmp24_;
					_tmp23_ = metadata;
					_tmp24_ = _vala_gir_parser_metadata_ref0 (_tmp23_);
					_vala_gir_parser_metadata_unref0 (_result_);
					_result_ = _tmp24_;
				} else {
					ValaGirParserMetadataSet* ms = NULL;
					ValaGirParserMetadata* _tmp25_;
					ValaGirParserMetadataSet* _tmp26_;
					ValaGirParserMetadataSet* _tmp27_;
					ValaGirParserMetadataSet* _tmp31_;
					ValaGirParserMetadata* _tmp32_;
					ValaGirParserMetadataSet* _tmp33_;
					ValaGirParserMetadata* _tmp34_;
					_tmp25_ = _result_;
					_tmp26_ = _vala_gir_parser_metadata_ref0 (VALA_GIR_PARSER_IS_METADATA_SET (_tmp25_) ? ((ValaGirParserMetadataSet*) _tmp25_) : NULL);
					ms = _tmp26_;
					_tmp27_ = ms;
					if (_tmp27_ == NULL) {
						ValaGirParserMetadataSet* _tmp28_;
						ValaGirParserMetadataSet* _tmp29_;
						ValaGirParserMetadata* _tmp30_;
						_tmp28_ = vala_gir_parser_metadata_set_new (selector);
						_vala_gir_parser_metadata_unref0 (ms);
						ms = _tmp28_;
						_tmp29_ = ms;
						_tmp30_ = _result_;
						vala_gir_parser_metadata_set_add_sibling (_tmp29_, _tmp30_);
					}
					_tmp31_ = ms;
					_tmp32_ = metadata;
					vala_gir_parser_metadata_set_add_sibling (_tmp31_, _tmp32_);
					_tmp33_ = ms;
					_tmp34_ = _vala_gir_parser_metadata_ref0 ((ValaGirParserMetadata*) _tmp33_);
					_vala_gir_parser_metadata_unref0 (_result_);
					_result_ = _tmp34_;
					_vala_gir_parser_metadata_unref0 (ms);
				}
			}
			_vala_gir_parser_metadata_unref0 (metadata);
		}
		_vala_iterable_unref0 (_metadata_list);
	}
	result = _result_;
	return result;
}

static void
vala_gir_parser_metadata_add_argument (ValaGirParserMetadata* self,
                                       ValaGirParserArgumentType key,
                                       ValaGirParserArgument* value)
{
	ValaMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->args;
	vala_map_set (_tmp0_, (gpointer) ((gintptr) key), value);
}

static gboolean
vala_gir_parser_metadata_has_argument (ValaGirParserMetadata* self,
                                       ValaGirParserArgumentType key)
{
	ValaMap* _tmp0_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->args;
	result = vala_map_contains (_tmp0_, (gpointer) ((gintptr) key));
	return result;
}

static ValaExpression*
vala_gir_parser_metadata_get_expression (ValaGirParserMetadata* self,
                                         ValaGirParserArgumentType arg)
{
	ValaGirParserArgument* val = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	ValaGirParserArgument* _tmp2_;
	ValaExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->args;
	_tmp1_ = vala_map_get (_tmp0_, (gpointer) ((gintptr) arg));
	val = (ValaGirParserArgument*) _tmp1_;
	_tmp2_ = val;
	if (_tmp2_ != NULL) {
		ValaGirParserArgument* _tmp3_;
		ValaGirParserArgument* _tmp4_;
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp3_ = val;
		_tmp3_->used = TRUE;
		_tmp4_ = val;
		_tmp5_ = _tmp4_->expression;
		_tmp6_ = _vala_code_node_ref0 (_tmp5_);
		result = _tmp6_;
		_vala_gir_parser_argument_unref0 (val);
		return result;
	}
	result = NULL;
	_vala_gir_parser_argument_unref0 (val);
	return result;
}

static gchar*
vala_gir_parser_metadata_get_string (ValaGirParserMetadata* self,
                                     ValaGirParserArgumentType arg)
{
	ValaStringLiteral* lit = NULL;
	ValaExpression* _tmp0_;
	ValaStringLiteral* _tmp1_;
	ValaStringLiteral* _tmp2_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_gir_parser_metadata_get_expression (self, arg);
	_tmp1_ = VALA_IS_STRING_LITERAL (_tmp0_) ? ((ValaStringLiteral*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_vala_code_node_unref0 (_tmp0_);
	}
	lit = _tmp1_;
	_tmp2_ = lit;
	if (_tmp2_ != NULL) {
		ValaStringLiteral* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = lit;
		_tmp4_ = vala_string_literal_eval (_tmp3_);
		result = _tmp4_;
		_vala_code_node_unref0 (lit);
		return result;
	}
	result = NULL;
	_vala_code_node_unref0 (lit);
	return result;
}

static gint
vala_gir_parser_metadata_get_integer (ValaGirParserMetadata* self,
                                      ValaGirParserArgumentType arg)
{
	ValaUnaryExpression* unary = NULL;
	ValaExpression* _tmp0_;
	ValaUnaryExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaUnaryExpression* _tmp3_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_gir_parser_metadata_get_expression (self, arg);
	_tmp1_ = VALA_IS_UNARY_EXPRESSION (_tmp0_) ? ((ValaUnaryExpression*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_vala_code_node_unref0 (_tmp0_);
	}
	unary = _tmp1_;
	_tmp3_ = unary;
	if (_tmp3_ != NULL) {
		ValaUnaryExpression* _tmp4_;
		ValaUnaryOperator _tmp5_;
		ValaUnaryOperator _tmp6_;
		_tmp4_ = unary;
		_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ == VALA_UNARY_OPERATOR_MINUS;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaIntegerLiteral* lit = NULL;
		ValaUnaryExpression* _tmp7_;
		ValaExpression* _tmp8_;
		ValaExpression* _tmp9_;
		ValaIntegerLiteral* _tmp10_;
		ValaIntegerLiteral* _tmp11_;
		_tmp7_ = unary;
		_tmp8_ = vala_unary_expression_get_inner (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _vala_code_node_ref0 (VALA_IS_INTEGER_LITERAL (_tmp9_) ? ((ValaIntegerLiteral*) _tmp9_) : NULL);
		lit = _tmp10_;
		_tmp11_ = lit;
		if (_tmp11_ != NULL) {
			ValaIntegerLiteral* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp12_ = lit;
			_tmp13_ = vala_integer_literal_get_value (_tmp12_);
			_tmp14_ = _tmp13_;
			result = -atoi (_tmp14_);
			_vala_code_node_unref0 (lit);
			_vala_code_node_unref0 (unary);
			return result;
		}
		_vala_code_node_unref0 (lit);
	} else {
		ValaIntegerLiteral* lit = NULL;
		ValaExpression* _tmp15_;
		ValaIntegerLiteral* _tmp16_;
		ValaIntegerLiteral* _tmp17_;
		_tmp15_ = vala_gir_parser_metadata_get_expression (self, arg);
		_tmp16_ = VALA_IS_INTEGER_LITERAL (_tmp15_) ? ((ValaIntegerLiteral*) _tmp15_) : NULL;
		if (_tmp16_ == NULL) {
			_vala_code_node_unref0 (_tmp15_);
		}
		lit = _tmp16_;
		_tmp17_ = lit;
		if (_tmp17_ != NULL) {
			ValaIntegerLiteral* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp18_ = lit;
			_tmp19_ = vala_integer_literal_get_value (_tmp18_);
			_tmp20_ = _tmp19_;
			result = atoi (_tmp20_);
			_vala_code_node_unref0 (lit);
			_vala_code_node_unref0 (unary);
			return result;
		}
		_vala_code_node_unref0 (lit);
	}
	result = 0;
	_vala_code_node_unref0 (unary);
	return result;
}

static gboolean
vala_gir_parser_metadata_get_bool (ValaGirParserMetadata* self,
                                   ValaGirParserArgumentType arg,
                                   gboolean default_value)
{
	ValaBooleanLiteral* lit = NULL;
	ValaExpression* _tmp0_;
	ValaBooleanLiteral* _tmp1_;
	ValaBooleanLiteral* _tmp2_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_gir_parser_metadata_get_expression (self, arg);
	_tmp1_ = VALA_IS_BOOLEAN_LITERAL (_tmp0_) ? ((ValaBooleanLiteral*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_vala_code_node_unref0 (_tmp0_);
	}
	lit = _tmp1_;
	_tmp2_ = lit;
	if (_tmp2_ != NULL) {
		ValaBooleanLiteral* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = lit;
		_tmp4_ = vala_boolean_literal_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		result = _tmp5_;
		_vala_code_node_unref0 (lit);
		return result;
	}
	result = default_value;
	_vala_code_node_unref0 (lit);
	return result;
}

static ValaSourceReference*
vala_gir_parser_metadata_get_source_reference (ValaGirParserMetadata* self,
                                               ValaGirParserArgumentType arg)
{
	ValaGirParserArgument* val = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	ValaGirParserArgument* _tmp2_;
	ValaSourceReference* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->args;
	_tmp1_ = vala_map_get (_tmp0_, (gpointer) ((gintptr) arg));
	val = (ValaGirParserArgument*) _tmp1_;
	_tmp2_ = val;
	if (_tmp2_ != NULL) {
		ValaGirParserArgument* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		_tmp3_ = val;
		_tmp4_ = _tmp3_->source_reference;
		_tmp5_ = _vala_source_reference_ref0 (_tmp4_);
		result = _tmp5_;
		_vala_gir_parser_argument_unref0 (val);
		return result;
	}
	result = NULL;
	_vala_gir_parser_argument_unref0 (val);
	return result;
}

static void
vala_gir_parser_value_metadata_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_gir_parser_value_metadata_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_metadata_unref (value->data[0].v_pointer);
	}
}

static void
vala_gir_parser_value_metadata_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_metadata_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_gir_parser_value_metadata_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_gir_parser_value_metadata_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserMetadata * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_metadata_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_gir_parser_value_metadata_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	ValaGirParserMetadata ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_metadata_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
vala_gir_parser_param_spec_metadata (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	ValaGirParserParamSpecMetadata* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_METADATA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
vala_gir_parser_value_get_metadata (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA), NULL);
	return value->data[0].v_pointer;
}

static void
vala_gir_parser_value_set_metadata (GValue* value,
                                    gpointer v_object)
{
	ValaGirParserMetadata * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_metadata_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_unref (old);
	}
}

static void
vala_gir_parser_value_take_metadata (GValue* value,
                                     gpointer v_object)
{
	ValaGirParserMetadata * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_unref (old);
	}
}

static void
vala_gir_parser_metadata_class_init (ValaGirParserMetadataClass * klass,
                                     gpointer klass_data)
{
	vala_gir_parser_metadata_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserMetadataClass *) klass)->finalize = vala_gir_parser_metadata_finalize;
}

static void
vala_gir_parser_metadata_instance_init (ValaGirParserMetadata * self,
                                        gpointer klass)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	self->used = FALSE;
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_GIR_PARSER_TYPE_ARGUMENT_TYPE, NULL, NULL, VALA_GIR_PARSER_TYPE_ARGUMENT, (GBoxedCopyFunc) vala_gir_parser_argument_ref, (GDestroyNotify) vala_gir_parser_argument_unref, _tmp0_, _tmp1_, _tmp2_);
	self->args = (ValaMap*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_METADATA, (GBoxedCopyFunc) vala_gir_parser_metadata_ref, (GDestroyNotify) vala_gir_parser_metadata_unref, _tmp4_);
	self->children = _tmp5_;
	self->ref_count = 1;
}

static void
vala_gir_parser_metadata_finalize (ValaGirParserMetadata * obj)
{
	ValaGirParserMetadata * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadata);
	g_signal_handlers_destroy (self);
	_g_pattern_spec_free0 (self->pattern_spec);
	_g_free0 (self->selector);
	_vala_source_reference_unref0 (self->source_reference);
	_vala_map_unref0 (self->args);
	_vala_iterable_unref0 (self->children);
}

static GType
vala_gir_parser_metadata_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_metadata_init, vala_gir_parser_value_metadata_free_value, vala_gir_parser_value_metadata_copy_value, vala_gir_parser_value_metadata_peek_pointer, "p", vala_gir_parser_value_metadata_collect_value, "p", vala_gir_parser_value_metadata_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserMetadataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_metadata_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserMetadata), 0, (GInstanceInitFunc) vala_gir_parser_metadata_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_gir_parser_metadata_type_id;
	vala_gir_parser_metadata_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserMetadata", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return vala_gir_parser_metadata_type_id;
}

static GType
vala_gir_parser_metadata_get_type (void)
{
	static volatile gsize vala_gir_parser_metadata_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_metadata_type_id__volatile)) {
		GType vala_gir_parser_metadata_type_id;
		vala_gir_parser_metadata_type_id = vala_gir_parser_metadata_get_type_once ();
		g_once_init_leave (&vala_gir_parser_metadata_type_id__volatile, vala_gir_parser_metadata_type_id);
	}
	return vala_gir_parser_metadata_type_id__volatile;
}

static gpointer
vala_gir_parser_metadata_ref (gpointer instance)
{
	ValaGirParserMetadata * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
vala_gir_parser_metadata_unref (gpointer instance)
{
	ValaGirParserMetadata * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_METADATA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
vala_gir_parser_metadata_parser_get_instance_private (ValaGirParserMetadataParser* self)
{
	return G_STRUCT_MEMBER_P (self, ValaGirParserMetadataParser_private_offset);
}

static ValaGirParserMetadataParser*
vala_gir_parser_metadata_parser_construct (GType object_type)
{
	ValaGirParserMetadataParser* self = NULL;
	ValaGirParserMetadata* _tmp0_;
	self = (ValaGirParserMetadataParser*) g_type_create_instance (object_type);
	_tmp0_ = self->priv->tree;
	_tmp0_->used = TRUE;
	return self;
}

static ValaGirParserMetadataParser*
vala_gir_parser_metadata_parser_new (void)
{
	return vala_gir_parser_metadata_parser_construct (VALA_GIR_PARSER_TYPE_METADATA_PARSER);
}

static ValaSourceReference*
vala_gir_parser_metadata_parser_get_current_src (ValaGirParserMetadataParser* self)
{
	ValaScanner* _tmp0_;
	ValaSourceFile* _tmp1_;
	ValaSourceFile* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceLocation _tmp4_;
	ValaSourceReference* _tmp5_;
	ValaSourceReference* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->scanner;
	_tmp1_ = vala_scanner_get_source_file (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->begin;
	_tmp4_ = self->priv->end;
	_tmp5_ = vala_source_reference_new (_tmp2_, &_tmp3_, &_tmp4_);
	result = _tmp5_;
	return result;
}

static ValaSourceReference*
vala_gir_parser_metadata_parser_get_src (ValaGirParserMetadataParser* self,
                                         ValaSourceLocation* begin,
                                         ValaSourceLocation* end)
{
	ValaSourceLocation e = {0};
	ValaSourceLocation _tmp0_;
	ValaScanner* _tmp1_;
	ValaSourceFile* _tmp2_;
	ValaSourceFile* _tmp3_;
	ValaSourceLocation _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	ValaSourceReference* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	_tmp0_ = self->priv->end;
	e = _tmp0_;
	if (end != NULL) {
		e = *end;
	}
	_tmp1_ = self->priv->scanner;
	_tmp2_ = vala_scanner_get_source_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = *begin;
	_tmp5_ = e;
	_tmp6_ = vala_source_reference_new (_tmp3_, &_tmp4_, &_tmp5_);
	result = _tmp6_;
	return result;
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_parser_parse_metadata (ValaGirParserMetadataParser* self,
                                                ValaSourceFile* metadata_file)
{
	ValaScanner* _tmp0_;
	ValaGirParserMetadata* _tmp5_;
	ValaGirParserMetadata* _tmp6_;
	ValaGirParserMetadata* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (metadata_file != NULL, NULL);
	_tmp0_ = vala_scanner_new (metadata_file);
	_vala_scanner_unref0 (self->priv->scanner);
	self->priv->scanner = _tmp0_;
	vala_gir_parser_metadata_parser_next (self);
	while (TRUE) {
		ValaTokenType _tmp1_;
		_tmp1_ = self->priv->current;
		if (!(_tmp1_ != VALA_TOKEN_TYPE_EOF)) {
			break;
		}
		if (!vala_gir_parser_metadata_parser_parse_rule (self)) {
			ValaGirParserMetadata* _tmp2_;
			ValaGirParserMetadata* _tmp3_;
			ValaGirParserMetadata* _tmp4_;
			_tmp2_ = vala_gir_parser_metadata_get_empty ();
			_tmp3_ = _tmp2_;
			_tmp4_ = _vala_gir_parser_metadata_ref0 (_tmp3_);
			result = _tmp4_;
			return result;
		}
	}
	_tmp5_ = self->priv->tree;
	_tmp6_ = _vala_gir_parser_metadata_ref0 (_tmp5_);
	result = _tmp6_;
	return result;
}

static ValaTokenType
vala_gir_parser_metadata_parser_next (ValaGirParserMetadataParser* self)
{
	ValaSourceLocation _tmp0_;
	ValaScanner* _tmp1_;
	ValaSourceLocation _tmp2_ = {0};
	ValaSourceLocation _tmp3_ = {0};
	ValaTokenType _tmp4_;
	ValaTokenType _tmp5_;
	ValaTokenType result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->end;
	self->priv->old_end = _tmp0_;
	_tmp1_ = self->priv->scanner;
	_tmp4_ = vala_scanner_read_token (_tmp1_, &_tmp2_, &_tmp3_);
	self->priv->begin = _tmp2_;
	self->priv->end = _tmp3_;
	self->priv->current = _tmp4_;
	_tmp5_ = self->priv->current;
	result = _tmp5_;
	return result;
}

static gboolean
vala_gir_parser_metadata_parser_has_space (ValaGirParserMetadataParser* self)
{
	ValaSourceLocation _tmp0_;
	gchar* _tmp1_;
	ValaSourceLocation _tmp2_;
	gchar* _tmp3_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->old_end;
	_tmp1_ = _tmp0_.pos;
	_tmp2_ = self->priv->begin;
	_tmp3_ = _tmp2_.pos;
	result = _tmp1_ != _tmp3_;
	return result;
}

static gboolean
vala_gir_parser_metadata_parser_has_newline (ValaGirParserMetadataParser* self)
{
	ValaSourceLocation _tmp0_;
	ValaSourceLocation _tmp1_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->old_end;
	_tmp1_ = self->priv->begin;
	result = _tmp0_.line != _tmp1_.line;
	return result;
}

static gchar*
vala_gir_parser_metadata_parser_get_string (ValaGirParserMetadataParser* self,
                                            ValaSourceLocation* begin,
                                            ValaSourceLocation* end)
{
	ValaSourceLocation b = {0};
	ValaSourceLocation _tmp0_;
	ValaSourceLocation e = {0};
	ValaSourceLocation _tmp1_;
	ValaSourceLocation _tmp2_;
	gchar* _tmp3_;
	ValaSourceLocation _tmp4_;
	gchar* _tmp5_;
	ValaSourceLocation _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->begin;
	b = _tmp0_;
	_tmp1_ = self->priv->end;
	e = _tmp1_;
	if (begin != NULL) {
		b = *begin;
	}
	if (end != NULL) {
		e = *end;
	}
	_tmp2_ = b;
	_tmp3_ = _tmp2_.pos;
	_tmp4_ = e;
	_tmp5_ = _tmp4_.pos;
	_tmp6_ = b;
	_tmp7_ = _tmp6_.pos;
	_tmp8_ = string_substring ((const gchar*) _tmp3_, (glong) 0, (glong) ((gint) (_tmp5_ - _tmp7_)));
	result = _tmp8_;
	return result;
}

static gchar*
vala_gir_parser_metadata_parser_parse_identifier (ValaGirParserMetadataParser* self,
                                                  gboolean is_glob)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaTokenType _tmp2_;
	ValaSourceLocation _tmp15_;
	ValaSourceLocation _tmp16_;
	gchar* _tmp17_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->begin;
	begin = _tmp0_;
	_tmp2_ = self->priv->current;
	if (_tmp2_ == VALA_TOKEN_TYPE_DOT) {
		_tmp1_ = TRUE;
	} else {
		ValaTokenType _tmp3_;
		_tmp3_ = self->priv->current;
		_tmp1_ = _tmp3_ == VALA_TOKEN_TYPE_HASH;
	}
	if (_tmp1_) {
		if (is_glob) {
			ValaSourceLocation _tmp4_;
			ValaSourceReference* _tmp5_;
			ValaSourceReference* _tmp6_;
			_tmp4_ = begin;
			_tmp5_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp4_, NULL);
			_tmp6_ = _tmp5_;
			vala_report_error (_tmp6_, "expected glob-style pattern");
			_vala_source_reference_unref0 (_tmp6_);
		} else {
			ValaSourceLocation _tmp7_;
			ValaSourceReference* _tmp8_;
			ValaSourceReference* _tmp9_;
			_tmp7_ = begin;
			_tmp8_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp7_, NULL);
			_tmp9_ = _tmp8_;
			vala_report_error (_tmp9_, "expected identifier");
			_vala_source_reference_unref0 (_tmp9_);
		}
		result = NULL;
		return result;
	}
	if (is_glob) {
		while (TRUE) {
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			ValaTokenType _tmp12_;
			_tmp12_ = self->priv->current;
			if (_tmp12_ != VALA_TOKEN_TYPE_EOF) {
				ValaTokenType _tmp13_;
				_tmp13_ = self->priv->current;
				_tmp11_ = _tmp13_ != VALA_TOKEN_TYPE_DOT;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				ValaTokenType _tmp14_;
				_tmp14_ = self->priv->current;
				_tmp10_ = _tmp14_ != VALA_TOKEN_TYPE_HASH;
			} else {
				_tmp10_ = FALSE;
			}
			if (!_tmp10_) {
				break;
			}
			vala_gir_parser_metadata_parser_next (self);
			if (vala_gir_parser_metadata_parser_has_space (self)) {
				break;
			}
		}
	} else {
		vala_gir_parser_metadata_parser_next (self);
	}
	_tmp15_ = begin;
	_tmp16_ = self->priv->old_end;
	_tmp17_ = vala_gir_parser_metadata_parser_get_string (self, &_tmp15_, &_tmp16_);
	result = _tmp17_;
	return result;
}

static gchar*
vala_gir_parser_metadata_parser_parse_selector (ValaGirParserMetadataParser* self)
{
	gboolean _tmp0_ = FALSE;
	ValaTokenType _tmp1_;
	gchar* _tmp2_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->current;
	if (_tmp1_ != VALA_TOKEN_TYPE_HASH) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_gir_parser_metadata_parser_has_space (self);
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	vala_gir_parser_metadata_parser_next (self);
	_tmp2_ = vala_gir_parser_metadata_parser_parse_identifier (self, FALSE);
	result = _tmp2_;
	return result;
}

static ValaGirParserMetadata*
vala_gir_parser_metadata_parser_parse_pattern (ValaGirParserMetadataParser* self)
{
	ValaGirParserMetadata* metadata = NULL;
	gboolean is_relative = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaTokenType _tmp1_;
	ValaGirParserMetadata* _tmp12_;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp15_;
	gchar* pattern = NULL;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	ValaSourceLocation _tmp21_;
	ValaSourceReference* _tmp22_;
	ValaSourceReference* _tmp23_;
	ValaGirParserMetadata* _tmp24_;
	ValaGirParserMetadata* _tmp25_;
	ValaGirParserMetadata* _tmp26_;
	ValaGirParserMetadata* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	is_relative = FALSE;
	_tmp1_ = self->priv->current;
	if (_tmp1_ == VALA_TOKEN_TYPE_IDENTIFIER) {
		_tmp0_ = TRUE;
	} else {
		ValaTokenType _tmp2_;
		_tmp2_ = self->priv->current;
		_tmp0_ = _tmp2_ == VALA_TOKEN_TYPE_STAR;
	}
	if (_tmp0_) {
		ValaGirParserMetadata* _tmp3_;
		ValaGirParserMetadata* _tmp4_;
		_tmp3_ = self->priv->tree;
		_tmp4_ = _vala_gir_parser_metadata_ref0 (_tmp3_);
		_vala_gir_parser_metadata_unref0 (self->priv->parent_metadata);
		self->priv->parent_metadata = _tmp4_;
	} else {
		ValaTokenType _tmp5_;
		_tmp5_ = self->priv->current;
		if (_tmp5_ != VALA_TOKEN_TYPE_DOT) {
			ValaSourceReference* _tmp6_;
			ValaSourceReference* _tmp7_;
			ValaTokenType _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp6_ = vala_gir_parser_metadata_parser_get_current_src (self);
			_tmp7_ = _tmp6_;
			_tmp8_ = self->priv->current;
			_tmp9_ = vala_token_type_to_string (_tmp8_);
			_tmp10_ = g_strdup_printf ("expected pattern or `.', got %s", _tmp9_);
			_tmp11_ = _tmp10_;
			vala_report_error (_tmp7_, _tmp11_);
			_g_free0 (_tmp11_);
			_vala_source_reference_unref0 (_tmp7_);
			result = NULL;
			_vala_gir_parser_metadata_unref0 (metadata);
			return result;
		}
		vala_gir_parser_metadata_parser_next (self);
		is_relative = TRUE;
	}
	_tmp12_ = self->priv->parent_metadata;
	if (_tmp12_ == NULL) {
		ValaSourceReference* _tmp13_;
		ValaSourceReference* _tmp14_;
		_tmp13_ = vala_gir_parser_metadata_parser_get_current_src (self);
		_tmp14_ = _tmp13_;
		vala_report_error (_tmp14_, "cannot determinate parent metadata");
		_vala_source_reference_unref0 (_tmp14_);
		result = NULL;
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	_tmp15_ = self->priv->begin;
	begin = _tmp15_;
	_tmp16_ = vala_gir_parser_metadata_parser_parse_identifier (self, TRUE);
	pattern = _tmp16_;
	_tmp17_ = pattern;
	if (_tmp17_ == NULL) {
		result = NULL;
		_g_free0 (pattern);
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	_tmp18_ = pattern;
	_tmp19_ = vala_gir_parser_metadata_parser_parse_selector (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = begin;
	_tmp22_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp21_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_gir_parser_metadata_new (_tmp18_, _tmp20_, _tmp23_);
	_vala_gir_parser_metadata_unref0 (metadata);
	metadata = _tmp24_;
	_vala_source_reference_unref0 (_tmp23_);
	_g_free0 (_tmp20_);
	_tmp25_ = self->priv->parent_metadata;
	_tmp26_ = metadata;
	vala_gir_parser_metadata_add_child (_tmp25_, _tmp26_);
	while (TRUE) {
		gboolean _tmp27_ = FALSE;
		ValaTokenType _tmp28_;
		ValaTokenType _tmp29_;
		ValaSourceLocation _tmp36_;
		gchar* _tmp37_;
		const gchar* _tmp38_;
		ValaGirParserMetadata* child = NULL;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		ValaSourceLocation _tmp42_;
		ValaSourceLocation _tmp43_;
		ValaSourceReference* _tmp44_;
		ValaSourceReference* _tmp45_;
		ValaGirParserMetadata* _tmp46_;
		ValaGirParserMetadata* _tmp47_;
		ValaGirParserMetadata* _tmp48_;
		ValaGirParserMetadata* _tmp49_;
		ValaGirParserMetadata* _tmp50_;
		ValaGirParserMetadata* _tmp51_;
		_tmp28_ = self->priv->current;
		if (_tmp28_ != VALA_TOKEN_TYPE_EOF) {
			_tmp27_ = !vala_gir_parser_metadata_parser_has_space (self);
		} else {
			_tmp27_ = FALSE;
		}
		if (!_tmp27_) {
			break;
		}
		_tmp29_ = self->priv->current;
		if (_tmp29_ != VALA_TOKEN_TYPE_DOT) {
			ValaSourceReference* _tmp30_;
			ValaSourceReference* _tmp31_;
			ValaTokenType _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			_tmp30_ = vala_gir_parser_metadata_parser_get_current_src (self);
			_tmp31_ = _tmp30_;
			_tmp32_ = self->priv->current;
			_tmp33_ = vala_token_type_to_string (_tmp32_);
			_tmp34_ = g_strdup_printf ("expected `.' got %s", _tmp33_);
			_tmp35_ = _tmp34_;
			vala_report_error (_tmp31_, _tmp35_);
			_g_free0 (_tmp35_);
			_vala_source_reference_unref0 (_tmp31_);
			break;
		}
		vala_gir_parser_metadata_parser_next (self);
		_tmp36_ = self->priv->begin;
		begin = _tmp36_;
		_tmp37_ = vala_gir_parser_metadata_parser_parse_identifier (self, TRUE);
		_g_free0 (pattern);
		pattern = _tmp37_;
		_tmp38_ = pattern;
		if (_tmp38_ == NULL) {
			result = NULL;
			_g_free0 (pattern);
			_vala_gir_parser_metadata_unref0 (metadata);
			return result;
		}
		_tmp39_ = pattern;
		_tmp40_ = vala_gir_parser_metadata_parser_parse_selector (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = begin;
		_tmp43_ = self->priv->old_end;
		_tmp44_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp42_, &_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_gir_parser_metadata_new (_tmp39_, _tmp41_, _tmp45_);
		_tmp47_ = _tmp46_;
		_vala_source_reference_unref0 (_tmp45_);
		_g_free0 (_tmp41_);
		child = _tmp47_;
		_tmp48_ = metadata;
		_tmp49_ = child;
		vala_gir_parser_metadata_add_child (_tmp48_, _tmp49_);
		_tmp50_ = child;
		_tmp51_ = _vala_gir_parser_metadata_ref0 (_tmp50_);
		_vala_gir_parser_metadata_unref0 (metadata);
		metadata = _tmp51_;
		_vala_gir_parser_metadata_unref0 (child);
	}
	if (!is_relative) {
		ValaGirParserMetadata* _tmp52_;
		ValaGirParserMetadata* _tmp53_;
		_tmp52_ = metadata;
		_tmp53_ = _vala_gir_parser_metadata_ref0 (_tmp52_);
		_vala_gir_parser_metadata_unref0 (self->priv->parent_metadata);
		self->priv->parent_metadata = _tmp53_;
	}
	result = metadata;
	_g_free0 (pattern);
	return result;
}

static ValaExpression*
vala_gir_parser_metadata_parser_parse_expression (ValaGirParserMetadataParser* self)
{
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_;
	ValaSourceReference* src = NULL;
	ValaSourceReference* _tmp1_;
	ValaExpression* expr = NULL;
	ValaTokenType _tmp2_;
	ValaExpression* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->begin;
	begin = _tmp0_;
	_tmp1_ = vala_gir_parser_metadata_parser_get_current_src (self);
	src = _tmp1_;
	expr = NULL;
	_tmp2_ = self->priv->current;
	switch (_tmp2_) {
		case VALA_TOKEN_TYPE_NULL:
		{
			ValaSourceReference* _tmp3_;
			ValaNullLiteral* _tmp4_;
			_tmp3_ = src;
			_tmp4_ = vala_null_literal_new (_tmp3_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp4_;
			break;
		}
		case VALA_TOKEN_TYPE_TRUE:
		{
			ValaSourceReference* _tmp5_;
			ValaBooleanLiteral* _tmp6_;
			_tmp5_ = src;
			_tmp6_ = vala_boolean_literal_new (TRUE, _tmp5_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp6_;
			break;
		}
		case VALA_TOKEN_TYPE_FALSE:
		{
			ValaSourceReference* _tmp7_;
			ValaBooleanLiteral* _tmp8_;
			_tmp7_ = src;
			_tmp8_ = vala_boolean_literal_new (FALSE, _tmp7_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp8_;
			break;
		}
		case VALA_TOKEN_TYPE_MINUS:
		{
			ValaExpression* inner = NULL;
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			vala_gir_parser_metadata_parser_next (self);
			_tmp9_ = vala_gir_parser_metadata_parser_parse_expression (self);
			inner = _tmp9_;
			_tmp10_ = inner;
			if (_tmp10_ == NULL) {
				ValaSourceReference* _tmp11_;
				ValaTokenType _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp11_ = src;
				_tmp12_ = self->priv->current;
				_tmp13_ = vala_token_type_to_string (_tmp12_);
				_tmp14_ = g_strdup_printf ("expected expression after `-', got %s", _tmp13_);
				_tmp15_ = _tmp14_;
				vala_report_error (_tmp11_, _tmp15_);
				_g_free0 (_tmp15_);
			} else {
				ValaExpression* _tmp16_;
				ValaSourceLocation _tmp17_;
				ValaSourceReference* _tmp18_;
				ValaSourceReference* _tmp19_;
				ValaUnaryExpression* _tmp20_;
				_tmp16_ = inner;
				_tmp17_ = begin;
				_tmp18_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp17_, NULL);
				_tmp19_ = _tmp18_;
				_tmp20_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_MINUS, _tmp16_, _tmp19_);
				_vala_code_node_unref0 (expr);
				expr = (ValaExpression*) _tmp20_;
				_vala_source_reference_unref0 (_tmp19_);
			}
			result = expr;
			_vala_code_node_unref0 (inner);
			_vala_source_reference_unref0 (src);
			return result;
		}
		case VALA_TOKEN_TYPE_INTEGER_LITERAL:
		{
			gchar* _tmp21_;
			gchar* _tmp22_;
			ValaSourceReference* _tmp23_;
			ValaIntegerLiteral* _tmp24_;
			_tmp21_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp22_ = _tmp21_;
			_tmp23_ = src;
			_tmp24_ = vala_integer_literal_new (_tmp22_, _tmp23_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp24_;
			_g_free0 (_tmp22_);
			break;
		}
		case VALA_TOKEN_TYPE_REAL_LITERAL:
		{
			gchar* _tmp25_;
			gchar* _tmp26_;
			ValaSourceReference* _tmp27_;
			ValaRealLiteral* _tmp28_;
			_tmp25_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = src;
			_tmp28_ = vala_real_literal_new (_tmp26_, _tmp27_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp28_;
			_g_free0 (_tmp26_);
			break;
		}
		case VALA_TOKEN_TYPE_STRING_LITERAL:
		{
			gchar* _tmp29_;
			gchar* _tmp30_;
			ValaSourceReference* _tmp31_;
			ValaStringLiteral* _tmp32_;
			_tmp29_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp30_ = _tmp29_;
			_tmp31_ = src;
			_tmp32_ = vala_string_literal_new (_tmp30_, _tmp31_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp32_;
			_g_free0 (_tmp30_);
			break;
		}
		case VALA_TOKEN_TYPE_IDENTIFIER:
		{
			gchar* _tmp33_;
			gchar* _tmp34_;
			ValaSourceReference* _tmp35_;
			ValaMemberAccess* _tmp36_;
			_tmp33_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp34_ = _tmp33_;
			_tmp35_ = src;
			_tmp36_ = vala_member_access_new (NULL, _tmp34_, _tmp35_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp36_;
			_g_free0 (_tmp34_);
			while (TRUE) {
				ValaExpression* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				ValaSourceReference* _tmp46_;
				ValaSourceReference* _tmp47_;
				ValaMemberAccess* _tmp48_;
				if (!(vala_gir_parser_metadata_parser_next (self) == VALA_TOKEN_TYPE_DOT)) {
					break;
				}
				if (vala_gir_parser_metadata_parser_next (self) != VALA_TOKEN_TYPE_IDENTIFIER) {
					ValaSourceReference* _tmp37_;
					ValaSourceReference* _tmp38_;
					ValaTokenType _tmp39_;
					const gchar* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					_tmp37_ = vala_gir_parser_metadata_parser_get_current_src (self);
					_tmp38_ = _tmp37_;
					_tmp39_ = self->priv->current;
					_tmp40_ = vala_token_type_to_string (_tmp39_);
					_tmp41_ = g_strdup_printf ("expected identifier got %s", _tmp40_);
					_tmp42_ = _tmp41_;
					vala_report_error (_tmp38_, _tmp42_);
					_g_free0 (_tmp42_);
					_vala_source_reference_unref0 (_tmp38_);
					break;
				}
				_tmp43_ = expr;
				_tmp44_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
				_tmp45_ = _tmp44_;
				_tmp46_ = vala_gir_parser_metadata_parser_get_current_src (self);
				_tmp47_ = _tmp46_;
				_tmp48_ = vala_member_access_new (_tmp43_, _tmp45_, _tmp47_);
				_vala_code_node_unref0 (expr);
				expr = (ValaExpression*) _tmp48_;
				_vala_source_reference_unref0 (_tmp47_);
				_g_free0 (_tmp45_);
			}
			result = expr;
			_vala_source_reference_unref0 (src);
			return result;
		}
		case VALA_TOKEN_TYPE_OPEN_PARENS:
		{
			ValaSourceReference* _tmp55_;
			ValaTuple* _tmp56_;
			if (vala_gir_parser_metadata_parser_next (self) != VALA_TOKEN_TYPE_CLOSE_PARENS) {
				ValaSourceReference* _tmp49_;
				ValaSourceReference* _tmp50_;
				ValaTokenType _tmp51_;
				const gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				_tmp49_ = vala_gir_parser_metadata_parser_get_current_src (self);
				_tmp50_ = _tmp49_;
				_tmp51_ = self->priv->current;
				_tmp52_ = vala_token_type_to_string (_tmp51_);
				_tmp53_ = g_strdup_printf ("expected `)', got %s", _tmp52_);
				_tmp54_ = _tmp53_;
				vala_report_error (_tmp50_, _tmp54_);
				_g_free0 (_tmp54_);
				_vala_source_reference_unref0 (_tmp50_);
				break;
			}
			_tmp55_ = src;
			_tmp56_ = vala_tuple_new (_tmp55_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp56_;
			break;
		}
		default:
		{
			ValaSourceReference* _tmp57_;
			ValaTokenType _tmp58_;
			const gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			_tmp57_ = src;
			_tmp58_ = self->priv->current;
			_tmp59_ = vala_token_type_to_string (_tmp58_);
			_tmp60_ = g_strdup_printf ("expected literal or symbol got %s", _tmp59_);
			_tmp61_ = _tmp60_;
			vala_report_error (_tmp57_, _tmp61_);
			_g_free0 (_tmp61_);
			break;
		}
	}
	vala_gir_parser_metadata_parser_next (self);
	result = expr;
	_vala_source_reference_unref0 (src);
	return result;
}

static gboolean
vala_gir_parser_metadata_parser_parse_args (ValaGirParserMetadataParser* self,
                                            ValaGirParserMetadata* metadata)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (metadata != NULL, FALSE);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		ValaTokenType _tmp2_;
		ValaSourceLocation begin = {0};
		ValaSourceLocation _tmp3_;
		gchar* id = NULL;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		ValaGirParserArgumentType* arg_type = NULL;
		const gchar* _tmp6_;
		ValaGirParserArgumentType* _tmp7_;
		ValaGirParserArgumentType* _tmp8_;
		ValaTokenType _tmp16_;
		ValaExpression* expr = NULL;
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaGirParserArgumentType* _tmp30_;
		ValaExpression* _tmp31_;
		ValaSourceLocation _tmp32_;
		ValaSourceReference* _tmp33_;
		ValaSourceReference* _tmp34_;
		ValaGirParserArgument* _tmp35_;
		ValaGirParserArgument* _tmp36_;
		_tmp2_ = self->priv->current;
		if (_tmp2_ != VALA_TOKEN_TYPE_EOF) {
			_tmp1_ = vala_gir_parser_metadata_parser_has_space (self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = !vala_gir_parser_metadata_parser_has_newline (self);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp3_ = self->priv->begin;
		begin = _tmp3_;
		_tmp4_ = vala_gir_parser_metadata_parser_parse_identifier (self, FALSE);
		id = _tmp4_;
		_tmp5_ = id;
		if (_tmp5_ == NULL) {
			result = FALSE;
			_g_free0 (id);
			return result;
		}
		_tmp6_ = id;
		_tmp7_ = vala_gir_parser_argument_type_from_string (_tmp6_);
		arg_type = _tmp7_;
		_tmp8_ = arg_type;
		if (_tmp8_ == NULL) {
			ValaSourceLocation _tmp9_;
			ValaSourceLocation _tmp10_;
			ValaSourceReference* _tmp11_;
			ValaSourceReference* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp9_ = begin;
			_tmp10_ = self->priv->old_end;
			_tmp11_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp9_, &_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = id;
			_tmp14_ = g_strdup_printf ("unknown argument `%s'", _tmp13_);
			_tmp15_ = _tmp14_;
			vala_report_warning (_tmp12_, _tmp15_);
			_g_free0 (_tmp15_);
			_vala_source_reference_unref0 (_tmp12_);
			_g_free0 (arg_type);
			_g_free0 (id);
			continue;
		}
		_tmp16_ = self->priv->current;
		if (_tmp16_ != VALA_TOKEN_TYPE_ASSIGN) {
			ValaGirParserArgumentType* _tmp17_;
			ValaSourceLocation _tmp18_;
			ValaSourceReference* _tmp19_;
			ValaSourceReference* _tmp20_;
			ValaBooleanLiteral* _tmp21_;
			ValaBooleanLiteral* _tmp22_;
			ValaSourceLocation _tmp23_;
			ValaSourceReference* _tmp24_;
			ValaSourceReference* _tmp25_;
			ValaGirParserArgument* _tmp26_;
			ValaGirParserArgument* _tmp27_;
			_tmp17_ = arg_type;
			_tmp18_ = begin;
			_tmp19_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp18_, NULL);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_boolean_literal_new (TRUE, _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = begin;
			_tmp24_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp23_, NULL);
			_tmp25_ = _tmp24_;
			_tmp26_ = vala_gir_parser_argument_new ((ValaExpression*) _tmp22_, _tmp25_);
			_tmp27_ = _tmp26_;
			vala_gir_parser_metadata_add_argument (metadata, *_tmp17_, _tmp27_);
			_vala_gir_parser_argument_unref0 (_tmp27_);
			_vala_source_reference_unref0 (_tmp25_);
			_vala_code_node_unref0 (_tmp22_);
			_vala_source_reference_unref0 (_tmp20_);
			_g_free0 (arg_type);
			_g_free0 (id);
			continue;
		}
		vala_gir_parser_metadata_parser_next (self);
		_tmp28_ = vala_gir_parser_metadata_parser_parse_expression (self);
		expr = _tmp28_;
		_tmp29_ = expr;
		if (_tmp29_ == NULL) {
			result = FALSE;
			_vala_code_node_unref0 (expr);
			_g_free0 (arg_type);
			_g_free0 (id);
			return result;
		}
		_tmp30_ = arg_type;
		_tmp31_ = expr;
		_tmp32_ = begin;
		_tmp33_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp32_, NULL);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_gir_parser_argument_new (_tmp31_, _tmp34_);
		_tmp36_ = _tmp35_;
		vala_gir_parser_metadata_add_argument (metadata, *_tmp30_, _tmp36_);
		_vala_gir_parser_argument_unref0 (_tmp36_);
		_vala_source_reference_unref0 (_tmp34_);
		_vala_code_node_unref0 (expr);
		_g_free0 (arg_type);
		_g_free0 (id);
	}
	result = TRUE;
	return result;
}

static gboolean
vala_gir_parser_metadata_parser_parse_rule (ValaGirParserMetadataParser* self)
{
	ValaSourceLocation old_end = {0};
	ValaSourceLocation _tmp0_;
	ValaGirParserMetadata* metadata = NULL;
	ValaGirParserMetadata* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaTokenType _tmp4_;
	ValaGirParserMetadata* _tmp7_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->end;
	old_end = _tmp0_;
	_tmp1_ = vala_gir_parser_metadata_parser_parse_pattern (self);
	metadata = _tmp1_;
	_tmp2_ = metadata;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	_tmp4_ = self->priv->current;
	if (_tmp4_ == VALA_TOKEN_TYPE_EOF) {
		_tmp3_ = TRUE;
	} else {
		ValaSourceLocation _tmp5_;
		ValaSourceLocation _tmp6_;
		_tmp5_ = old_end;
		_tmp6_ = self->priv->end;
		_tmp3_ = _tmp5_.line != _tmp6_.line;
	}
	if (_tmp3_) {
		result = TRUE;
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	_tmp7_ = metadata;
	result = vala_gir_parser_metadata_parser_parse_args (self, _tmp7_);
	_vala_gir_parser_metadata_unref0 (metadata);
	return result;
}

static void
vala_gir_parser_value_metadata_parser_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_gir_parser_value_metadata_parser_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_metadata_parser_unref (value->data[0].v_pointer);
	}
}

static void
vala_gir_parser_value_metadata_parser_copy_value (const GValue* src_value,
                                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_metadata_parser_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_gir_parser_value_metadata_parser_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_gir_parser_value_metadata_parser_collect_value (GValue* value,
                                                     guint n_collect_values,
                                                     GTypeCValue* collect_values,
                                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserMetadataParser * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_metadata_parser_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_gir_parser_value_metadata_parser_lcopy_value (const GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	ValaGirParserMetadataParser ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_metadata_parser_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
vala_gir_parser_param_spec_metadata_parser (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags)
{
	ValaGirParserParamSpecMetadataParser* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_METADATA_PARSER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
vala_gir_parser_value_get_metadata_parser (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA_PARSER), NULL);
	return value->data[0].v_pointer;
}

static void
vala_gir_parser_value_set_metadata_parser (GValue* value,
                                           gpointer v_object)
{
	ValaGirParserMetadataParser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_metadata_parser_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_parser_unref (old);
	}
}

static void
vala_gir_parser_value_take_metadata_parser (GValue* value,
                                            gpointer v_object)
{
	ValaGirParserMetadataParser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_parser_unref (old);
	}
}

static void
vala_gir_parser_metadata_parser_class_init (ValaGirParserMetadataParserClass * klass,
                                            gpointer klass_data)
{
	vala_gir_parser_metadata_parser_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserMetadataParserClass *) klass)->finalize = vala_gir_parser_metadata_parser_finalize;
	g_type_class_adjust_private_offset (klass, &ValaGirParserMetadataParser_private_offset);
}

static void
vala_gir_parser_metadata_parser_instance_init (ValaGirParserMetadataParser * self,
                                               gpointer klass)
{
	ValaGirParserMetadata* _tmp0_;
	self->priv = vala_gir_parser_metadata_parser_get_instance_private (self);
	_tmp0_ = vala_gir_parser_metadata_new ("", NULL, NULL);
	self->priv->tree = _tmp0_;
	self->ref_count = 1;
}

static void
vala_gir_parser_metadata_parser_finalize (ValaGirParserMetadataParser * obj)
{
	ValaGirParserMetadataParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParser);
	g_signal_handlers_destroy (self);
	_vala_gir_parser_metadata_unref0 (self->priv->tree);
	_vala_scanner_unref0 (self->priv->scanner);
	_vala_gir_parser_metadata_unref0 (self->priv->parent_metadata);
}

static GType
vala_gir_parser_metadata_parser_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_metadata_parser_init, vala_gir_parser_value_metadata_parser_free_value, vala_gir_parser_value_metadata_parser_copy_value, vala_gir_parser_value_metadata_parser_peek_pointer, "p", vala_gir_parser_value_metadata_parser_collect_value, "p", vala_gir_parser_value_metadata_parser_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserMetadataParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_metadata_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserMetadataParser), 0, (GInstanceInitFunc) vala_gir_parser_metadata_parser_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_gir_parser_metadata_parser_type_id;
	vala_gir_parser_metadata_parser_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserMetadataParser", &g_define_type_info, &g_define_type_fundamental_info, 0);
	ValaGirParserMetadataParser_private_offset = g_type_add_instance_private (vala_gir_parser_metadata_parser_type_id, sizeof (ValaGirParserMetadataParserPrivate));
	return vala_gir_parser_metadata_parser_type_id;
}

static GType
vala_gir_parser_metadata_parser_get_type (void)
{
	static volatile gsize vala_gir_parser_metadata_parser_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_metadata_parser_type_id__volatile)) {
		GType vala_gir_parser_metadata_parser_type_id;
		vala_gir_parser_metadata_parser_type_id = vala_gir_parser_metadata_parser_get_type_once ();
		g_once_init_leave (&vala_gir_parser_metadata_parser_type_id__volatile, vala_gir_parser_metadata_parser_type_id);
	}
	return vala_gir_parser_metadata_parser_type_id__volatile;
}

static gpointer
vala_gir_parser_metadata_parser_ref (gpointer instance)
{
	ValaGirParserMetadataParser * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
vala_gir_parser_metadata_parser_unref (gpointer instance)
{
	ValaGirParserMetadataParser * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_METADATA_PARSER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static ValaGirParserNode*
vala_gir_parser_node_construct (GType object_type,
                                const gchar* name)
{
	ValaGirParserNode* self = NULL;
	gchar* _tmp0_;
	self = (ValaGirParserNode*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	return self;
}

static ValaGirParserNode*
vala_gir_parser_node_new (const gchar* name)
{
	return vala_gir_parser_node_construct (VALA_GIR_PARSER_TYPE_NODE, name);
}

static void
vala_gir_parser_node_add_member (ValaGirParserNode* self,
                                 ValaGirParserNode* node)
{
	ValaArrayList* nodes = NULL;
	ValaHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	ValaArrayList* _tmp3_;
	ValaArrayList* _tmp9_;
	ValaArrayList* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->scope;
	_tmp1_ = node->name;
	_tmp2_ = vala_map_get ((ValaMap*) _tmp0_, _tmp1_);
	nodes = (ValaArrayList*) _tmp2_;
	_tmp3_ = nodes;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		ValaHashMap* _tmp6_;
		const gchar* _tmp7_;
		ValaArrayList* _tmp8_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp4_);
		_vala_iterable_unref0 (nodes);
		nodes = _tmp5_;
		_tmp6_ = self->scope;
		_tmp7_ = node->name;
		_tmp8_ = nodes;
		vala_map_set ((ValaMap*) _tmp6_, _tmp7_, _tmp8_);
	}
	_tmp9_ = nodes;
	vala_collection_add ((ValaCollection*) _tmp9_, node);
	_tmp10_ = self->members;
	vala_collection_add ((ValaCollection*) _tmp10_, node);
	node->parent = self;
	_vala_iterable_unref0 (nodes);
}

static void
vala_gir_parser_node_remove_member (ValaGirParserNode* self,
                                    ValaGirParserNode* node)
{
	ValaArrayList* nodes = NULL;
	ValaHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	ValaArrayList* _tmp3_;
	ValaArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	ValaArrayList* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->scope;
	_tmp1_ = node->name;
	_tmp2_ = vala_map_get ((ValaMap*) _tmp0_, _tmp1_);
	nodes = (ValaArrayList*) _tmp2_;
	_tmp3_ = nodes;
	vala_collection_remove ((ValaCollection*) _tmp3_, node);
	_tmp4_ = nodes;
	_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == 0) {
		ValaHashMap* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = self->scope;
		_tmp8_ = node->name;
		vala_map_remove ((ValaMap*) _tmp7_, _tmp8_);
	}
	_tmp9_ = self->members;
	vala_collection_remove ((ValaCollection*) _tmp9_, node);
	node->parent = NULL;
	_vala_iterable_unref0 (nodes);
}

static ValaGirParserNode*
vala_gir_parser_node_lookup (ValaGirParserNode* self,
                             const gchar* name,
                             gboolean create_namespace,
                             ValaSourceReference* source_reference)
{
	ValaArrayList* nodes = NULL;
	ValaHashMap* _tmp0_;
	gpointer _tmp1_;
	ValaGirParserNode* node = NULL;
	ValaArrayList* _tmp2_;
	ValaGirParserNode* _tmp5_;
	ValaGirParserNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->scope;
	_tmp1_ = vala_map_get ((ValaMap*) _tmp0_, name);
	nodes = (ValaArrayList*) _tmp1_;
	node = NULL;
	_tmp2_ = nodes;
	if (_tmp2_ != NULL) {
		ValaArrayList* _tmp3_;
		gpointer _tmp4_;
		_tmp3_ = nodes;
		_tmp4_ = vala_list_get ((ValaList*) _tmp3_, 0);
		_vala_gir_parser_node_unref0 (node);
		node = (ValaGirParserNode*) _tmp4_;
	}
	_tmp5_ = node;
	if (_tmp5_ == NULL) {
		ValaSymbol* sym = NULL;
		ValaSymbol* _tmp6_;
		gboolean _tmp11_ = FALSE;
		ValaSymbol* _tmp12_;
		sym = NULL;
		_tmp6_ = self->symbol;
		if (_tmp6_ != NULL) {
			ValaSymbol* _tmp7_;
			ValaScope* _tmp8_;
			ValaScope* _tmp9_;
			ValaSymbol* _tmp10_;
			_tmp7_ = self->symbol;
			_tmp8_ = vala_symbol_get_scope (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_scope_lookup (_tmp9_, name);
			_vala_code_node_unref0 (sym);
			sym = _tmp10_;
		}
		_tmp12_ = sym;
		if (_tmp12_ != NULL) {
			_tmp11_ = TRUE;
		} else {
			_tmp11_ = create_namespace;
		}
		if (_tmp11_) {
			ValaGirParserNode* _tmp13_;
			ValaGirParserNode* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaGirParserNode* _tmp17_;
			ValaGirParserNode* _tmp18_;
			ValaSymbol* _tmp19_;
			ValaGirParserNode* _tmp20_;
			ValaSourceReference* _tmp21_;
			ValaGirParserNode* _tmp22_;
			ValaSymbol* _tmp23_;
			_tmp13_ = vala_gir_parser_node_new (name);
			_vala_gir_parser_node_unref0 (node);
			node = _tmp13_;
			_tmp14_ = node;
			_tmp15_ = sym;
			_tmp16_ = _vala_code_node_ref0 (_tmp15_);
			_vala_code_node_unref0 (_tmp14_->symbol);
			_tmp14_->symbol = _tmp16_;
			_tmp17_ = node;
			_tmp18_ = node;
			_tmp19_ = _tmp18_->symbol;
			_tmp17_->new_symbol = _tmp19_ == NULL;
			_tmp20_ = node;
			_tmp21_ = _vala_source_reference_ref0 (source_reference);
			_vala_source_reference_unref0 (_tmp20_->source_reference);
			_tmp20_->source_reference = _tmp21_;
			_tmp22_ = node;
			vala_gir_parser_node_add_member (self, _tmp22_);
			_tmp23_ = sym;
			if (_tmp23_ == NULL) {
				ValaArrayList* _tmp24_;
				ValaGirParserNode* _tmp25_;
				_tmp24_ = vala_gir_parser_node_new_namespaces;
				_tmp25_ = node;
				vala_collection_add ((ValaCollection*) _tmp24_, _tmp25_);
			}
		}
		_vala_code_node_unref0 (sym);
	}
	result = node;
	_vala_iterable_unref0 (nodes);
	return result;
}

static ValaArrayList*
vala_gir_parser_node_lookup_all (ValaGirParserNode* self,
                                 const gchar* name)
{
	ValaHashMap* _tmp0_;
	gpointer _tmp1_;
	ValaArrayList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->scope;
	_tmp1_ = vala_map_get ((ValaMap*) _tmp0_, name);
	result = (ValaArrayList*) _tmp1_;
	return result;
}

static ValaUnresolvedSymbol*
vala_gir_parser_node_get_unresolved_symbol (ValaGirParserNode* self)
{
	ValaGirParserNode* _tmp0_;
	const gchar* _tmp1_;
	ValaUnresolvedSymbol* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	_tmp1_ = _tmp0_->name;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		ValaUnresolvedSymbol* _tmp3_;
		_tmp2_ = self->name;
		_tmp3_ = vala_unresolved_symbol_new (NULL, _tmp2_, NULL);
		result = _tmp3_;
		return result;
	} else {
		ValaGirParserNode* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		ValaUnresolvedSymbol* _tmp6_;
		const gchar* _tmp7_;
		ValaUnresolvedSymbol* _tmp8_;
		ValaUnresolvedSymbol* _tmp9_;
		_tmp4_ = self->parent;
		_tmp5_ = vala_gir_parser_node_get_unresolved_symbol (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->name;
		_tmp8_ = vala_unresolved_symbol_new (_tmp6_, _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_vala_code_node_unref0 (_tmp6_);
		result = _tmp9_;
		return result;
	}
}

static gchar*
vala_gir_parser_node_get_full_name (ValaGirParserNode* self)
{
	ValaGirParserNode* _tmp0_;
	const gchar* _tmp3_;
	ValaGirParserNode* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	ValaGirParserNode* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->name;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->name;
	if (_tmp3_ == NULL) {
		ValaGirParserNode* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->parent;
		_tmp5_ = vala_gir_parser_node_get_full_name (_tmp4_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = self->parent;
	_tmp7_ = vala_gir_parser_node_get_full_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ == NULL;
	_g_free0 (_tmp8_);
	if (_tmp9_) {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = self->name;
		_tmp11_ = g_strdup (_tmp10_);
		result = _tmp11_;
		return result;
	}
	_tmp12_ = self->parent;
	_tmp13_ = vala_gir_parser_node_get_full_name (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->name;
	_tmp16_ = g_strdup_printf ("%s.%s", _tmp14_, _tmp15_);
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp14_);
	result = _tmp17_;
	return result;
}

static gchar*
vala_gir_parser_node_get_default_gir_name (ValaGirParserNode* self)
{
	GString* default_name = NULL;
	GString* _tmp0_;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	default_name = _tmp0_;
	{
		ValaGirParserNode* node = NULL;
		node = self;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				ValaGirParserNode* _tmp4_;
				ValaGirParserNode* _tmp5_;
				ValaSymbol* _tmp6_;
				GString* _tmp12_;
				ValaGirParserNode* _tmp13_;
				const gchar* _tmp14_;
				if (!_tmp1_) {
					ValaGirParserNode* _tmp2_;
					ValaGirParserNode* _tmp3_;
					_tmp2_ = node;
					_tmp3_ = _tmp2_->parent;
					node = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = node;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = node;
				_tmp6_ = _tmp5_->symbol;
				if (VALA_IS_NAMESPACE (_tmp6_)) {
					ValaGirParserNode* _tmp7_;
					ValaSymbol* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					gboolean _tmp11_;
					_tmp7_ = node;
					_tmp8_ = _tmp7_->symbol;
					_tmp9_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp8_, "CCode", "gir_namespace", NULL);
					_tmp10_ = _tmp9_;
					_tmp11_ = _tmp10_ != NULL;
					_g_free0 (_tmp10_);
					if (_tmp11_) {
						break;
					}
				}
				_tmp12_ = default_name;
				_tmp13_ = node;
				_tmp14_ = _tmp13_->name;
				g_string_prepend (_tmp12_, _tmp14_);
			}
		}
	}
	_tmp15_ = default_name;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = g_strdup (_tmp16_);
	result = _tmp17_;
	_g_string_free0 (default_name);
	return result;
}

static gchar*
vala_gir_parser_node_get_gir_name (ValaGirParserNode* self)
{
	gchar* gir_name = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	const gchar* _tmp2_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->girdata;
	_tmp1_ = vala_map_get (_tmp0_, "name");
	gir_name = (gchar*) _tmp1_;
	_tmp2_ = gir_name;
	if (_tmp2_ == NULL) {
		ValaMap* _tmp3_;
		gpointer _tmp4_;
		_tmp3_ = self->girdata;
		_tmp4_ = vala_map_get (_tmp3_, "glib:name");
		_g_free0 (gir_name);
		gir_name = (gchar*) _tmp4_;
	}
	result = gir_name;
	return result;
}

static gchar*
vala_gir_parser_node_get_lower_case_cprefix (ValaGirParserNode* self)
{
	const gchar* _tmp0_;
	gchar* prefix = NULL;
	ValaSymbol* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	const gchar* _tmp46_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->symbol;
	_tmp3_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp2_, "CCode", "lower_case_cprefix", NULL);
	prefix = _tmp3_;
	_tmp5_ = prefix;
	if (_tmp5_ == NULL) {
		gboolean _tmp6_ = FALSE;
		ValaSymbol* _tmp7_;
		_tmp7_ = self->symbol;
		if (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp7_)) {
			_tmp6_ = TRUE;
		} else {
			ValaSymbol* _tmp8_;
			_tmp8_ = self->symbol;
			_tmp6_ = VALA_IS_STRUCT (_tmp8_);
		}
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaGirParserMetadata* _tmp9_;
		_tmp9_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp9_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX)) {
			ValaGirParserMetadata* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = self->metadata;
			_tmp11_ = vala_gir_parser_metadata_get_string (_tmp10_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX);
			_g_free0 (prefix);
			prefix = _tmp11_;
		} else {
			ValaGirParserMetadata* _tmp12_;
			_tmp12_ = self->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp12_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX)) {
				ValaGirParserMetadata* _tmp13_;
				gchar* _tmp14_;
				_tmp13_ = self->metadata;
				_tmp14_ = vala_gir_parser_metadata_get_string (_tmp13_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX);
				_g_free0 (prefix);
				prefix = _tmp14_;
			} else {
				ValaSymbol* _tmp15_;
				gchar* _tmp16_;
				_tmp15_ = self->symbol;
				_tmp16_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp15_, "CCode", "cprefix", NULL);
				_g_free0 (prefix);
				prefix = _tmp16_;
			}
		}
	}
	_tmp19_ = prefix;
	if (_tmp19_ == NULL) {
		ValaMap* _tmp20_;
		_tmp20_ = self->girdata;
		_tmp18_ = _tmp20_ != NULL;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		gboolean _tmp21_ = FALSE;
		ValaMap* _tmp22_;
		_tmp22_ = self->girdata;
		if (vala_map_contains (_tmp22_, "c:symbol-prefix")) {
			_tmp21_ = TRUE;
		} else {
			ValaMap* _tmp23_;
			_tmp23_ = self->girdata;
			_tmp21_ = vala_map_contains (_tmp23_, "c:symbol-prefixes");
		}
		_tmp17_ = _tmp21_;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		ValaGirParserNode* cur = NULL;
		cur = self;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				ValaGirParserNode* _tmp26_;
				ValaMap* _tmp27_;
				ValaGirParserNode* _tmp44_;
				ValaGirParserNode* _tmp45_;
				if (!_tmp24_) {
					ValaGirParserNode* _tmp25_;
					_tmp25_ = cur;
					if (!(_tmp25_ != NULL)) {
						break;
					}
				}
				_tmp24_ = FALSE;
				_tmp26_ = cur;
				_tmp27_ = _tmp26_->girdata;
				if (_tmp27_ != NULL) {
					gchar* p = NULL;
					ValaGirParserNode* _tmp28_;
					ValaMap* _tmp29_;
					gpointer _tmp30_;
					const gchar* _tmp31_;
					const gchar* _tmp39_;
					_tmp28_ = cur;
					_tmp29_ = _tmp28_->girdata;
					_tmp30_ = vala_map_get (_tmp29_, "c:symbol-prefix");
					p = (gchar*) _tmp30_;
					_tmp31_ = p;
					if (_tmp31_ == NULL) {
						ValaGirParserNode* _tmp32_;
						ValaMap* _tmp33_;
						gpointer _tmp34_;
						const gchar* _tmp35_;
						_tmp32_ = cur;
						_tmp33_ = _tmp32_->girdata;
						_tmp34_ = vala_map_get (_tmp33_, "c:symbol-prefixes");
						_g_free0 (p);
						p = (gchar*) _tmp34_;
						_tmp35_ = p;
						if (_tmp35_ != NULL) {
							gint idx = 0;
							const gchar* _tmp36_;
							_tmp36_ = p;
							idx = string_index_of (_tmp36_, ",", 0);
							if (idx >= 0) {
								const gchar* _tmp37_;
								gchar* _tmp38_;
								_tmp37_ = p;
								_tmp38_ = string_substring (_tmp37_, (glong) 0, (glong) idx);
								_g_free0 (p);
								p = _tmp38_;
							}
						}
					}
					_tmp39_ = p;
					if (_tmp39_ != NULL) {
						const gchar* _tmp40_ = NULL;
						const gchar* _tmp41_;
						const gchar* _tmp42_;
						gchar* _tmp43_;
						_tmp41_ = prefix;
						_tmp40_ = _tmp41_;
						if (_tmp40_ == NULL) {
							_tmp40_ = "";
						}
						_tmp42_ = p;
						_tmp43_ = g_strdup_printf ("%s_%s", _tmp42_, _tmp40_);
						_g_free0 (prefix);
						prefix = _tmp43_;
					}
					_g_free0 (p);
				}
				_tmp44_ = cur;
				_tmp45_ = _tmp44_->parent;
				cur = _tmp45_;
			}
		}
	}
	_tmp46_ = prefix;
	if (_tmp46_ == NULL) {
		gchar* _tmp47_;
		_tmp47_ = vala_gir_parser_node_get_default_lower_case_cprefix (self);
		_g_free0 (prefix);
		prefix = _tmp47_;
	}
	result = prefix;
	return result;
}

static gchar*
vala_gir_parser_node_get_default_lower_case_cprefix (ValaGirParserNode* self)
{
	ValaGirParserNode* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	_tmp1_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_gir_parser_node_get_lower_case_csuffix (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s%s_", _tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp6_;
	return result;
}

static gchar*
vala_gir_parser_node_get_lower_case_csuffix (ValaGirParserNode* self)
{
	gchar* suffix = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	const gchar* _tmp16_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->symbol;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "CCode", "lower_case_csuffix", NULL);
	suffix = _tmp1_;
	_tmp2_ = self->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX)) {
		ValaGirParserMetadata* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->metadata;
		_tmp4_ = vala_gir_parser_metadata_get_string (_tmp3_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX);
		_g_free0 (suffix);
		suffix = _tmp4_;
	}
	_tmp8_ = suffix;
	if (_tmp8_ == NULL) {
		ValaMap* _tmp9_;
		_tmp9_ = self->girdata;
		_tmp7_ = _tmp9_ != NULL;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaMap* _tmp10_;
		gpointer _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = self->girdata;
		_tmp11_ = vala_map_get (_tmp10_, "c:symbol-prefix");
		_tmp12_ = (gchar*) _tmp11_;
		_tmp6_ = _tmp12_ != NULL;
		_g_free0 (_tmp12_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaGirParserMetadata* _tmp13_;
		_tmp13_ = self->metadata;
		_tmp5_ = !vala_gir_parser_metadata_has_argument (_tmp13_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaMap* _tmp14_;
		gpointer _tmp15_;
		_tmp14_ = self->girdata;
		_tmp15_ = vala_map_get (_tmp14_, "c:symbol-prefix");
		_g_free0 (suffix);
		suffix = (gchar*) _tmp15_;
	}
	_tmp16_ = suffix;
	if (_tmp16_ == NULL) {
		gchar* _tmp17_;
		_tmp17_ = vala_gir_parser_node_get_default_lower_case_csuffix (self);
		_g_free0 (suffix);
		suffix = _tmp17_;
	}
	result = suffix;
	return result;
}

static gchar*
vala_gir_parser_node_get_default_lower_case_csuffix (ValaGirParserNode* self)
{
	gchar* csuffix = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp16_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	_tmp1_ = vala_symbol_camel_case_to_lower_case (_tmp0_);
	csuffix = _tmp1_;
	_tmp2_ = csuffix;
	if (g_str_has_prefix (_tmp2_, "type_")) {
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp3_ = csuffix;
		_tmp4_ = strlen ("type_");
		_tmp5_ = _tmp4_;
		_tmp6_ = string_substring (_tmp3_, (glong) _tmp5_, (glong) -1);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat ("type", _tmp7_, NULL);
		_g_free0 (csuffix);
		csuffix = _tmp8_;
		_g_free0 (_tmp7_);
	} else {
		const gchar* _tmp9_;
		_tmp9_ = csuffix;
		if (g_str_has_prefix (_tmp9_, "is_")) {
			const gchar* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp10_ = csuffix;
			_tmp11_ = strlen ("is_");
			_tmp12_ = _tmp11_;
			_tmp13_ = string_substring (_tmp10_, (glong) _tmp12_, (glong) -1);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strconcat ("is", _tmp14_, NULL);
			_g_free0 (csuffix);
			csuffix = _tmp15_;
			_g_free0 (_tmp14_);
		}
	}
	_tmp16_ = csuffix;
	if (g_str_has_suffix (_tmp16_, "_class")) {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp17_ = csuffix;
		_tmp18_ = csuffix;
		_tmp19_ = strlen (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = strlen ("_class");
		_tmp22_ = _tmp21_;
		_tmp23_ = string_substring (_tmp17_, (glong) 0, (glong) (_tmp20_ - _tmp22_));
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strconcat (_tmp24_, "class", NULL);
		_g_free0 (csuffix);
		csuffix = _tmp25_;
		_g_free0 (_tmp24_);
	}
	result = csuffix;
	return result;
}

static gchar*
vala_gir_parser_node_get_cprefix (ValaGirParserNode* self)
{
	const gchar* _tmp0_;
	gchar* prefix = NULL;
	ValaGirParserMetadata* _tmp2_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	const gchar* _tmp19_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX)) {
		ValaGirParserMetadata* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->metadata;
		_tmp4_ = vala_gir_parser_metadata_get_string (_tmp3_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX);
		_g_free0 (prefix);
		prefix = _tmp4_;
	} else {
		ValaSymbol* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = self->symbol;
		_tmp6_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp5_, "CCode", "cprefix", NULL);
		_g_free0 (prefix);
		prefix = _tmp6_;
	}
	_tmp9_ = prefix;
	if (_tmp9_ == NULL) {
		ValaMap* _tmp10_;
		_tmp10_ = self->girdata;
		_tmp8_ = _tmp10_ != NULL;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		ValaMap* _tmp11_;
		gpointer _tmp12_;
		gchar* _tmp13_;
		_tmp11_ = self->girdata;
		_tmp12_ = vala_map_get (_tmp11_, "c:identifier-prefixes");
		_tmp13_ = (gchar*) _tmp12_;
		_tmp7_ = _tmp13_ != NULL;
		_g_free0 (_tmp13_);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaMap* _tmp14_;
		gpointer _tmp15_;
		gint idx = 0;
		const gchar* _tmp16_;
		_tmp14_ = self->girdata;
		_tmp15_ = vala_map_get (_tmp14_, "c:identifier-prefixes");
		_g_free0 (prefix);
		prefix = (gchar*) _tmp15_;
		_tmp16_ = prefix;
		idx = string_index_of (_tmp16_, ",", 0);
		if (idx != -1) {
			const gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp17_ = prefix;
			_tmp18_ = string_substring (_tmp17_, (glong) 0, (glong) idx);
			_g_free0 (prefix);
			prefix = _tmp18_;
		}
	}
	_tmp19_ = prefix;
	if (_tmp19_ == NULL) {
		gboolean _tmp20_ = FALSE;
		ValaSymbol* _tmp21_;
		_tmp21_ = self->symbol;
		if (VALA_IS_ENUM (_tmp21_)) {
			_tmp20_ = TRUE;
		} else {
			ValaSymbol* _tmp22_;
			_tmp22_ = self->symbol;
			_tmp20_ = VALA_IS_ERROR_DOMAIN (_tmp22_);
		}
		if (_tmp20_) {
			ValaGirParserNode* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			const gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp23_ = self->parent;
			_tmp24_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_ascii_strup (_tmp25_, (gssize) -1);
			_tmp27_ = _tmp26_;
			_tmp28_ = self->name;
			_tmp29_ = g_strdup_printf ("%s%s", _tmp27_, _tmp28_);
			_g_free0 (prefix);
			prefix = _tmp29_;
			_g_free0 (_tmp27_);
			_g_free0 (_tmp25_);
		} else {
			gchar* _tmp30_;
			_tmp30_ = vala_gir_parser_node_get_cname (self);
			_g_free0 (prefix);
			prefix = _tmp30_;
		}
	}
	result = prefix;
	return result;
}

static gchar*
vala_gir_parser_node_get_cname (ValaGirParserNode* self)
{
	const gchar* _tmp0_;
	gchar* cname = NULL;
	ValaGirParserMetadata* _tmp2_;
	ValaMap* _tmp7_;
	const gchar* _tmp14_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME)) {
		ValaGirParserMetadata* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->metadata;
		_tmp4_ = vala_gir_parser_metadata_get_string (_tmp3_, VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME);
		_g_free0 (cname);
		cname = _tmp4_;
	} else {
		ValaSymbol* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = self->symbol;
		_tmp6_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp5_, "CCode", "cname", NULL);
		_g_free0 (cname);
		cname = _tmp6_;
	}
	_tmp7_ = self->girdata;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		const gchar* _tmp11_;
		_tmp8_ = cname;
		if (_tmp8_ == NULL) {
			ValaMap* _tmp9_;
			gpointer _tmp10_;
			_tmp9_ = self->girdata;
			_tmp10_ = vala_map_get (_tmp9_, "c:identifier");
			_g_free0 (cname);
			cname = (gchar*) _tmp10_;
		}
		_tmp11_ = cname;
		if (_tmp11_ == NULL) {
			ValaMap* _tmp12_;
			gpointer _tmp13_;
			_tmp12_ = self->girdata;
			_tmp13_ = vala_map_get (_tmp12_, "c:type");
			_g_free0 (cname);
			cname = (gchar*) _tmp13_;
		}
	}
	_tmp14_ = cname;
	if (_tmp14_ == NULL) {
		gchar* _tmp15_;
		_tmp15_ = vala_gir_parser_node_get_default_cname (self);
		_g_free0 (cname);
		cname = _tmp15_;
	}
	result = cname;
	return result;
}

static gchar*
vala_gir_parser_node_get_default_cname (ValaGirParserNode* self)
{
	const gchar* _tmp0_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->symbol;
	if (VALA_IS_FIELD (_tmp2_)) {
		ValaSymbol* _tmp3_;
		ValaMemberBinding _tmp4_;
		ValaMemberBinding _tmp5_;
		_tmp3_ = self->symbol;
		_tmp4_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_FIELD, ValaField));
		_tmp5_ = _tmp4_;
		if (_tmp5_ == VALA_MEMBER_BINDING_STATIC) {
			ValaGirParserNode* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp6_ = self->parent;
			_tmp7_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = self->name;
			_tmp10_ = g_strconcat (_tmp8_, _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			_g_free0 (_tmp8_);
			result = _tmp11_;
			return result;
		} else {
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp12_ = self->name;
			_tmp13_ = g_strdup (_tmp12_);
			result = _tmp13_;
			return result;
		}
	} else {
		ValaSymbol* _tmp14_;
		_tmp14_ = self->symbol;
		if (VALA_IS_METHOD (_tmp14_)) {
			ValaGirParserNode* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp15_ = self->parent;
			_tmp16_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = self->name;
			_tmp19_ = g_strdup_printf ("%s%s", _tmp17_, _tmp18_);
			_tmp20_ = _tmp19_;
			_g_free0 (_tmp17_);
			result = _tmp20_;
			return result;
		} else {
			ValaGirParserNode* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp21_ = self->parent;
			_tmp22_ = vala_gir_parser_node_get_cprefix (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = self->name;
			_tmp25_ = g_strdup_printf ("%s%s", _tmp23_, _tmp24_);
			_tmp26_ = _tmp25_;
			_g_free0 (_tmp23_);
			result = _tmp26_;
			return result;
		}
	}
}

static gchar*
vala_gir_parser_node_get_finish_cname (ValaGirParserNode* self)
{
	gchar* finish_cname = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->symbol;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "CCode", "finish_name", NULL);
	finish_cname = _tmp1_;
	_tmp2_ = finish_cname;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp3_ = vala_gir_parser_node_get_cname (self);
		_g_free0 (finish_cname);
		finish_cname = _tmp3_;
		_tmp4_ = finish_cname;
		if (g_str_has_suffix (_tmp4_, "_async")) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gchar* _tmp11_;
			_tmp5_ = finish_cname;
			_tmp6_ = finish_cname;
			_tmp7_ = strlen (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = strlen ("_async");
			_tmp10_ = _tmp9_;
			_tmp11_ = string_substring (_tmp5_, (glong) 0, (glong) (_tmp8_ - _tmp10_));
			_g_free0 (finish_cname);
			finish_cname = _tmp11_;
		}
		_tmp12_ = finish_cname;
		_tmp13_ = g_strdup_printf ("%s_finish", _tmp12_);
		_g_free0 (finish_cname);
		finish_cname = _tmp13_;
	}
	result = finish_cname;
	return result;
}

static gchar*
vala_gir_parser_node_get_cheader_filename (ValaGirParserNode* self)
{
	ValaGirParserMetadata* _tmp0_;
	gchar* cheader_filename = NULL;
	ValaSymbol* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	ValaGirParserNode* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp19_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp0_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME)) {
		ValaGirParserMetadata* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->metadata;
		_tmp2_ = vala_gir_parser_metadata_get_string (_tmp1_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->symbol;
	_tmp4_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp3_, "CCode", "cheader_filename", NULL);
	cheader_filename = _tmp4_;
	_tmp5_ = cheader_filename;
	if (_tmp5_ != NULL) {
		result = cheader_filename;
		return result;
	}
	_tmp6_ = self->parent;
	_tmp7_ = _tmp6_->name;
	if (_tmp7_ != NULL) {
		ValaGirParserNode* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = self->parent;
		_tmp9_ = vala_gir_parser_node_get_cheader_filename (_tmp8_);
		result = _tmp9_;
		_g_free0 (cheader_filename);
		return result;
	} else {
		ValaSymbol* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		_tmp10_ = self->symbol;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ != NULL) {
			ValaSymbol* _tmp13_;
			ValaSourceReference* _tmp14_;
			ValaSourceReference* _tmp15_;
			ValaSourceFile* _tmp16_;
			ValaSourceFile* _tmp17_;
			gchar* _tmp18_;
			_tmp13_ = self->symbol;
			_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_source_reference_get_file (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_source_file_get_cinclude_filename (_tmp17_);
			result = _tmp18_;
			_g_free0 (cheader_filename);
			return result;
		}
	}
	_tmp19_ = g_strdup ("");
	result = _tmp19_;
	_g_free0 (cheader_filename);
	return result;
}

static gboolean
int64_try_parse (const gchar* str,
                 gint64* _result_,
                 const gchar* * unparsed,
                 guint _base)
{
	gint64 _vala__result_ = 0LL;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result = FALSE;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtoll (str, &_tmp0_, _base);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		gboolean _tmp5_ = FALSE;
		_vala_unparsed = "";
		if (errno != ERANGE) {
			_tmp5_ = errno != EINVAL;
		} else {
			_tmp5_ = FALSE;
		}
		result = _tmp5_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = endptr;
		_vala_unparsed = (const gchar*) _tmp6_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala__result_;
	}
	if (unparsed) {
		*unparsed = _vala_unparsed;
	}
}

static guint64
vala_gir_parser_node_parse_version_string (const gchar* version)
{
	gint64 res = 0LL;
	gint shift = 0;
	gchar** tokens = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint tokens_length1;
	gint _tokens_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	guint64 result = 0ULL;
	g_return_val_if_fail (version != NULL, 0ULL);
	res = (gint64) 0;
	shift = 16;
	_tmp1_ = _tmp0_ = g_strsplit (version, ".", 3);
	tokens = _tmp1_;
	tokens_length1 = _vala_array_length (_tmp0_);
	_tokens_size_ = tokens_length1;
	_tmp2_ = tokens;
	_tmp2__length1 = tokens_length1;
	{
		gchar** token_collection = NULL;
		gint token_collection_length1 = 0;
		gint _token_collection_size_ = 0;
		gint token_it = 0;
		token_collection = _tmp2_;
		token_collection_length1 = _tmp2__length1;
		for (token_it = 0; token_it < token_collection_length1; token_it = token_it + 1) {
			const gchar* token = NULL;
			token = token_collection[token_it];
			{
				gint64 t = 0LL;
				const gchar* _tmp3_;
				gint64 _tmp4_ = 0LL;
				gboolean _tmp5_;
				_tmp3_ = token;
				_tmp5_ = int64_try_parse (_tmp3_, &_tmp4_, NULL, (guint) 0);
				t = _tmp4_;
				if (!_tmp5_) {
					result = (guint64) 0;
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				if (t > ((gint64) 0xffff)) {
					result = (guint64) 0;
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				res |= t << shift;
				shift -= 8;
			}
		}
	}
	result = (guint64) res;
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
vala_gir_parser_node_process (ValaGirParserNode* self,
                              ValaGirParser* parser)
{
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	gboolean _tmp35_ = FALSE;
	ValaSymbol* _tmp36_;
	ValaMap* _tmp74_;
	gboolean _tmp773_ = FALSE;
	gboolean _tmp774_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parser != NULL);
	if (self->processed) {
		return;
	}
	_tmp1_ = self->symbol;
	if (VALA_IS_NAMESPACE (_tmp1_)) {
		ValaGirParserNode* _tmp2_;
		ValaGirParserNode* _tmp3_;
		_tmp2_ = self->parent;
		_tmp3_ = parser->priv->root;
		_tmp0_ = _tmp2_ == _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		{
			ValaArrayList* _node_list = NULL;
			ValaArrayList* _tmp4_;
			ValaArrayList* _tmp5_;
			gint _node_size = 0;
			ValaArrayList* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _node_index = 0;
			_tmp4_ = self->members;
			_tmp5_ = _vala_iterable_ref0 (_tmp4_);
			_node_list = _tmp5_;
			_tmp6_ = _node_list;
			_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_node_size = _tmp8_;
			_node_index = -1;
			while (TRUE) {
				ValaGirParserNode* node = NULL;
				ValaArrayList* _tmp9_;
				gpointer _tmp10_;
				ValaGirParserNode* _tmp11_;
				const gchar* _tmp12_;
				_node_index = _node_index + 1;
				if (!(_node_index < _node_size)) {
					break;
				}
				_tmp9_ = _node_list;
				_tmp10_ = vala_list_get ((ValaList*) _tmp9_, _node_index);
				node = (ValaGirParserNode*) _tmp10_;
				_tmp11_ = node;
				_tmp12_ = _tmp11_->element_type;
				if (g_strcmp0 (_tmp12_, "alias") == 0) {
					ValaGirParserNode* _tmp13_;
					_tmp13_ = node;
					vala_gir_parser_process_alias (parser, _tmp13_);
				}
				_vala_gir_parser_node_unref0 (node);
			}
			_vala_iterable_unref0 (_node_list);
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp14_ = FALSE;
				_tmp14_ = TRUE;
				while (TRUE) {
					ValaArrayList* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					ValaGirParserNode* node = NULL;
					ValaArrayList* _tmp19_;
					gpointer _tmp20_;
					gboolean _tmp21_ = FALSE;
					ValaGirParserNode* _tmp22_;
					ValaSymbol* _tmp23_;
					if (!_tmp14_) {
						gint _tmp15_;
						_tmp15_ = i;
						i = _tmp15_ + 1;
					}
					_tmp14_ = FALSE;
					_tmp16_ = self->members;
					_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
					_tmp18_ = _tmp17_;
					if (!(i < _tmp18_)) {
						break;
					}
					_tmp19_ = self->members;
					_tmp20_ = vala_list_get ((ValaList*) _tmp19_, i);
					node = (ValaGirParserNode*) _tmp20_;
					_tmp22_ = node;
					_tmp23_ = _tmp22_->symbol;
					if (VALA_IS_METHOD (_tmp23_)) {
						ValaGirParserNode* _tmp24_;
						_tmp24_ = node;
						_tmp21_ = _tmp24_->new_symbol;
					} else {
						_tmp21_ = FALSE;
					}
					if (_tmp21_) {
						ValaGirParserNode* _tmp25_;
						gboolean _tmp26_ = FALSE;
						ValaArrayList* _tmp27_;
						gint _tmp28_;
						gint _tmp29_;
						_tmp25_ = node;
						vala_gir_parser_process_namespace_method (parser, self, _tmp25_);
						_tmp27_ = self->members;
						_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
						_tmp29_ = _tmp28_;
						if (i < _tmp29_) {
							ValaArrayList* _tmp30_;
							gpointer _tmp31_;
							ValaGirParserNode* _tmp32_;
							ValaGirParserNode* _tmp33_;
							_tmp30_ = self->members;
							_tmp31_ = vala_list_get ((ValaList*) _tmp30_, i);
							_tmp32_ = (ValaGirParserNode*) _tmp31_;
							_tmp33_ = node;
							_tmp26_ = _tmp32_ != _tmp33_;
							_vala_gir_parser_node_unref0 (_tmp32_);
						} else {
							_tmp26_ = FALSE;
						}
						if (_tmp26_) {
							gint _tmp34_;
							_tmp34_ = i;
							i = _tmp34_ - 1;
						}
					}
					_vala_gir_parser_node_unref0 (node);
				}
			}
		}
	}
	_tmp36_ = self->symbol;
	if (VALA_IS_CLASS (_tmp36_)) {
		ValaMap* _tmp37_;
		_tmp37_ = self->girdata;
		_tmp35_ = _tmp37_ != NULL;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		gchar* class_struct = NULL;
		ValaMap* _tmp38_;
		gpointer _tmp39_;
		const gchar* _tmp40_;
		_tmp38_ = self->girdata;
		_tmp39_ = vala_map_get (_tmp38_, "glib:type-struct");
		class_struct = (gchar*) _tmp39_;
		_tmp40_ = class_struct;
		if (_tmp40_ != NULL) {
			ValaGirParserNode* klass = NULL;
			ValaGirParserNode* _tmp41_;
			const gchar* _tmp42_;
			ValaSourceReference* _tmp43_;
			ValaUnresolvedSymbol* _tmp44_;
			ValaUnresolvedSymbol* _tmp45_;
			ValaGirParserNode* _tmp46_;
			ValaGirParserNode* _tmp47_;
			ValaGirParserNode* _tmp48_;
			_tmp41_ = self->parent;
			_tmp42_ = class_struct;
			_tmp43_ = self->source_reference;
			_tmp44_ = vala_gir_parser_parse_symbol_from_string (parser, _tmp42_, _tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_gir_parser_resolve_node (parser, _tmp41_, _tmp45_, FALSE);
			_tmp47_ = _tmp46_;
			_vala_code_node_unref0 (_tmp45_);
			klass = _tmp47_;
			_tmp48_ = klass;
			if (_tmp48_ != NULL) {
				gint i = 0;
				i = 0;
				while (TRUE) {
					ValaGirParserNode* _tmp49_;
					ValaArrayList* _tmp50_;
					gint _tmp51_;
					gint _tmp52_;
					ValaGirParserNode* node = NULL;
					ValaGirParserNode* _tmp53_;
					ValaArrayList* _tmp54_;
					gpointer _tmp55_;
					ValaGirParserNode* _tmp56_;
					ValaSymbol* _tmp57_;
					_tmp49_ = klass;
					_tmp50_ = _tmp49_->members;
					_tmp51_ = vala_collection_get_size ((ValaCollection*) _tmp50_);
					_tmp52_ = _tmp51_;
					if (!(i < _tmp52_)) {
						break;
					}
					_tmp53_ = klass;
					_tmp54_ = _tmp53_->members;
					_tmp55_ = vala_list_get ((ValaList*) _tmp54_, i);
					node = (ValaGirParserNode*) _tmp55_;
					_tmp56_ = node;
					_tmp57_ = _tmp56_->symbol;
					if (VALA_IS_METHOD (_tmp57_)) {
						ValaGirParserNode* _tmp58_;
						ValaGirParserNode* _tmp59_;
						ValaGirParserNode* _tmp60_;
						ValaMethod* m = NULL;
						ValaGirParserNode* _tmp61_;
						ValaSymbol* _tmp62_;
						ValaMethod* _tmp63_;
						ValaMethod* _tmp64_;
						_tmp58_ = klass;
						_tmp59_ = node;
						vala_gir_parser_node_remove_member (_tmp58_, _tmp59_);
						_tmp60_ = node;
						vala_gir_parser_node_add_member (self, _tmp60_);
						_tmp61_ = node;
						_tmp62_ = _tmp61_->symbol;
						_tmp63_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp63_;
						_tmp64_ = m;
						vala_method_set_binding (_tmp64_, VALA_MEMBER_BINDING_CLASS);
						_vala_code_node_unref0 (m);
					} else {
						gint _tmp65_;
						_tmp65_ = i;
						i = _tmp65_ + 1;
					}
					_vala_gir_parser_node_unref0 (node);
				}
			}
			_vala_gir_parser_node_unref0 (klass);
		}
		_g_free0 (class_struct);
	}
	{
		ValaArrayList* _node_list = NULL;
		ValaArrayList* _tmp66_;
		ValaArrayList* _tmp67_;
		gint _node_size = 0;
		ValaArrayList* _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		gint _node_index = 0;
		_tmp66_ = self->members;
		_tmp67_ = _vala_iterable_ref0 (_tmp66_);
		_node_list = _tmp67_;
		_tmp68_ = _node_list;
		_tmp69_ = vala_collection_get_size ((ValaCollection*) _tmp68_);
		_tmp70_ = _tmp69_;
		_node_size = _tmp70_;
		_node_index = -1;
		while (TRUE) {
			ValaGirParserNode* node = NULL;
			ValaArrayList* _tmp71_;
			gpointer _tmp72_;
			ValaGirParserNode* _tmp73_;
			_node_index = _node_index + 1;
			if (!(_node_index < _node_size)) {
				break;
			}
			_tmp71_ = _node_list;
			_tmp72_ = vala_list_get ((ValaList*) _tmp71_, _node_index);
			node = (ValaGirParserNode*) _tmp72_;
			_tmp73_ = node;
			vala_gir_parser_node_process (_tmp73_, parser);
			_vala_gir_parser_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
	_tmp74_ = self->girdata;
	if (_tmp74_ != NULL) {
		ValaSymbol* _tmp75_;
		ValaGirParserMetadata* _tmp685_;
		ValaGirParserMetadata* _tmp688_;
		ValaGirParserMetadata* _tmp697_;
		const gchar* _tmp703_;
		ValaGirParserMetadata* _tmp705_;
		ValaGirParserMetadata* _tmp708_;
		ValaGirParserNode* _tmp726_;
		ValaSymbol* _tmp727_;
		gchar* _tmp736_;
		gchar* _tmp737_;
		gchar* _tmp738_;
		gchar* _tmp739_;
		gboolean _tmp740_;
		gchar* _tmp744_;
		gchar* _tmp745_;
		gchar* _tmp746_;
		gchar* _tmp747_;
		gboolean _tmp748_;
		gchar* _tmp752_;
		gchar* _tmp753_;
		gchar* _tmp754_;
		gchar* _tmp755_;
		gboolean _tmp756_;
		gchar* gir_name = NULL;
		gchar* _tmp760_;
		gchar* default_gir_name = NULL;
		gchar* _tmp761_;
		gboolean _tmp762_ = FALSE;
		gboolean _tmp763_ = FALSE;
		ValaSymbol* _tmp764_;
		_tmp75_ = self->symbol;
		if (VALA_IS_METHOD (_tmp75_)) {
			ValaMethod* m = NULL;
			ValaSymbol* _tmp76_;
			ValaMethod* _tmp77_;
			ValaArrayList* colliding = NULL;
			ValaGirParserNode* _tmp78_;
			const gchar* _tmp79_;
			ValaArrayList* _tmp80_;
			ValaMethod* _tmp178_;
			ValaMethod* _tmp197_;
			gboolean _tmp198_;
			gboolean _tmp199_;
			_tmp76_ = self->symbol;
			_tmp77_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, VALA_TYPE_METHOD, ValaMethod));
			m = _tmp77_;
			vala_gir_parser_process_callable (parser, self);
			_tmp78_ = self->parent;
			_tmp79_ = self->name;
			_tmp80_ = vala_gir_parser_node_lookup_all (_tmp78_, _tmp79_);
			colliding = _tmp80_;
			{
				ValaArrayList* _node_list = NULL;
				ValaArrayList* _tmp81_;
				ValaArrayList* _tmp82_;
				gint _node_size = 0;
				ValaArrayList* _tmp83_;
				gint _tmp84_;
				gint _tmp85_;
				gint _node_index = 0;
				_tmp81_ = colliding;
				_tmp82_ = _vala_iterable_ref0 (_tmp81_);
				_node_list = _tmp82_;
				_tmp83_ = _node_list;
				_tmp84_ = vala_collection_get_size ((ValaCollection*) _tmp83_);
				_tmp85_ = _tmp84_;
				_node_size = _tmp85_;
				_node_index = -1;
				while (TRUE) {
					ValaGirParserNode* node = NULL;
					ValaArrayList* _tmp86_;
					gpointer _tmp87_;
					ValaSymbol* sym = NULL;
					ValaGirParserNode* _tmp88_;
					ValaSymbol* _tmp89_;
					ValaSymbol* _tmp90_;
					gboolean _tmp91_ = FALSE;
					gboolean _tmp92_ = FALSE;
					ValaSymbol* _tmp93_;
					_node_index = _node_index + 1;
					if (!(_node_index < _node_size)) {
						break;
					}
					_tmp86_ = _node_list;
					_tmp87_ = vala_list_get ((ValaList*) _tmp86_, _node_index);
					node = (ValaGirParserNode*) _tmp87_;
					_tmp88_ = node;
					_tmp89_ = _tmp88_->symbol;
					_tmp90_ = _vala_code_node_ref0 (_tmp89_);
					sym = _tmp90_;
					_tmp93_ = sym;
					if (VALA_IS_FIELD (_tmp93_)) {
						ValaMethod* _tmp94_;
						ValaDataType* _tmp95_;
						ValaDataType* _tmp96_;
						_tmp94_ = m;
						_tmp95_ = vala_callable_get_return_type ((ValaCallable*) _tmp94_);
						_tmp96_ = _tmp95_;
						_tmp92_ = !VALA_IS_VOID_TYPE (_tmp96_);
					} else {
						_tmp92_ = FALSE;
					}
					if (_tmp92_) {
						ValaMethod* _tmp97_;
						ValaList* _tmp98_;
						gint _tmp99_;
						gint _tmp100_;
						_tmp97_ = m;
						_tmp98_ = vala_callable_get_parameters ((ValaCallable*) _tmp97_);
						_tmp99_ = vala_collection_get_size ((ValaCollection*) _tmp98_);
						_tmp100_ = _tmp99_;
						_tmp91_ = _tmp100_ == 0;
					} else {
						_tmp91_ = FALSE;
					}
					if (_tmp91_) {
						self->merged = TRUE;
					} else {
						ValaSymbol* _tmp101_;
						_tmp101_ = sym;
						if (VALA_IS_SIGNAL (_tmp101_)) {
							ValaGirParserNode* _tmp102_;
							ValaSignal* sig = NULL;
							ValaSymbol* _tmp103_;
							ValaSignal* _tmp104_;
							gboolean _tmp105_ = FALSE;
							ValaMethod* _tmp106_;
							gboolean _tmp107_;
							gboolean _tmp108_;
							ValaSignal* _tmp114_;
							ValaMethod* _tmp115_;
							ValaMethod* _tmp116_;
							ValaList* _tmp117_;
							gint _tmp118_;
							gint _tmp119_;
							ValaSignal* _tmp120_;
							ValaList* _tmp121_;
							gint _tmp122_;
							gint _tmp123_;
							_tmp102_ = node;
							vala_gir_parser_node_process (_tmp102_, parser);
							_tmp103_ = sym;
							_tmp104_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, VALA_TYPE_SIGNAL, ValaSignal));
							sig = _tmp104_;
							_tmp106_ = m;
							_tmp107_ = vala_method_get_is_virtual (_tmp106_);
							_tmp108_ = _tmp107_;
							if (_tmp108_) {
								_tmp105_ = TRUE;
							} else {
								ValaMethod* _tmp109_;
								gboolean _tmp110_;
								gboolean _tmp111_;
								_tmp109_ = m;
								_tmp110_ = vala_method_get_is_abstract (_tmp109_);
								_tmp111_ = _tmp110_;
								_tmp105_ = _tmp111_;
							}
							if (_tmp105_) {
								ValaSignal* _tmp112_;
								_tmp112_ = sig;
								vala_signal_set_is_virtual (_tmp112_, TRUE);
							} else {
								ValaSignal* _tmp113_;
								_tmp113_ = sig;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp113_, "HasEmitter", TRUE, NULL);
							}
							_tmp114_ = sig;
							_tmp115_ = m;
							vala_gir_parser_assume_parameter_names (parser, _tmp114_, (ValaSymbol*) _tmp115_, FALSE);
							_tmp116_ = m;
							_tmp117_ = vala_callable_get_parameters ((ValaCallable*) _tmp116_);
							_tmp118_ = vala_collection_get_size ((ValaCollection*) _tmp117_);
							_tmp119_ = _tmp118_;
							_tmp120_ = sig;
							_tmp121_ = vala_callable_get_parameters ((ValaCallable*) _tmp120_);
							_tmp122_ = vala_collection_get_size ((ValaCollection*) _tmp121_);
							_tmp123_ = _tmp122_;
							if (_tmp119_ != _tmp123_) {
								ValaSymbol* _tmp124_;
								ValaSourceReference* _tmp125_;
								ValaSourceReference* _tmp126_;
								gchar* _tmp127_;
								gchar* _tmp128_;
								gchar* _tmp129_;
								gchar* _tmp130_;
								_tmp124_ = self->symbol;
								_tmp125_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp124_);
								_tmp126_ = _tmp125_;
								_tmp127_ = vala_gir_parser_node_get_full_name (self);
								_tmp128_ = _tmp127_;
								_tmp129_ = g_strdup_printf ("Signal `%s' conflicts with method of the same name", _tmp128_);
								_tmp130_ = _tmp129_;
								vala_report_warning (_tmp126_, _tmp130_);
								_g_free0 (_tmp130_);
								_g_free0 (_tmp128_);
							}
							self->merged = TRUE;
							_vala_code_node_unref0 (sig);
						} else {
							gboolean _tmp131_ = FALSE;
							gboolean _tmp132_ = FALSE;
							ValaSymbol* _tmp133_;
							_tmp133_ = sym;
							if (VALA_IS_METHOD (_tmp133_)) {
								ValaSymbol* _tmp134_;
								_tmp134_ = sym;
								_tmp132_ = !VALA_IS_CREATION_METHOD (_tmp134_);
							} else {
								_tmp132_ = FALSE;
							}
							if (_tmp132_) {
								ValaGirParserNode* _tmp135_;
								_tmp135_ = node;
								_tmp131_ = _tmp135_ != self;
							} else {
								_tmp131_ = FALSE;
							}
							if (_tmp131_) {
								gboolean _tmp136_ = FALSE;
								ValaMethod* _tmp137_;
								gboolean _tmp138_;
								gboolean _tmp139_;
								_tmp137_ = m;
								_tmp138_ = vala_method_get_is_virtual (_tmp137_);
								_tmp139_ = _tmp138_;
								if (_tmp139_) {
									_tmp136_ = TRUE;
								} else {
									ValaMethod* _tmp140_;
									gboolean _tmp141_;
									gboolean _tmp142_;
									_tmp140_ = m;
									_tmp141_ = vala_method_get_is_abstract (_tmp140_);
									_tmp142_ = _tmp141_;
									_tmp136_ = _tmp142_;
								}
								if (_tmp136_) {
									gboolean different_invoker = FALSE;
									ValaAttribute* attr = NULL;
									ValaMethod* _tmp143_;
									ValaAttribute* _tmp144_;
									ValaAttribute* _tmp145_;
									ValaAttribute* _tmp146_;
									different_invoker = FALSE;
									_tmp143_ = m;
									_tmp144_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp143_, "NoWrapper");
									_tmp145_ = _vala_code_node_ref0 (_tmp144_);
									attr = _tmp145_;
									_tmp146_ = attr;
									if (_tmp146_ != NULL) {
										ValaGirParserNode* invoker = NULL;
										ValaGirParserNode* _tmp147_;
										ValaGirParserNode* _tmp148_;
										_tmp147_ = vala_gir_parser_find_invoker (parser, self);
										invoker = _tmp147_;
										_tmp148_ = invoker;
										if (_tmp148_ != NULL) {
											ValaMethod* _tmp149_;
											ValaMethod* _tmp150_;
											const gchar* _tmp151_;
											const gchar* _tmp152_;
											ValaMethod* _tmp153_;
											ValaGirParserNode* _tmp154_;
											ValaSymbol* _tmp155_;
											const gchar* _tmp156_;
											const gchar* _tmp157_;
											ValaMethod* _tmp158_;
											ValaGirParserNode* _tmp159_;
											_tmp149_ = m;
											_tmp150_ = m;
											_tmp151_ = vala_symbol_get_name ((ValaSymbol*) _tmp150_);
											_tmp152_ = _tmp151_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp149_, "CCode", "vfunc_name", _tmp152_, NULL);
											_tmp153_ = m;
											_tmp154_ = invoker;
											_tmp155_ = _tmp154_->symbol;
											_tmp156_ = vala_symbol_get_name (_tmp155_);
											_tmp157_ = _tmp156_;
											vala_symbol_set_name ((ValaSymbol*) _tmp153_, _tmp157_);
											_tmp158_ = m;
											vala_code_node_set_attribute ((ValaCodeNode*) _tmp158_, "NoWrapper", FALSE, NULL);
											_tmp159_ = invoker;
											_tmp159_->merged = TRUE;
											different_invoker = TRUE;
										}
										_vala_gir_parser_node_unref0 (invoker);
									}
									if (!different_invoker) {
										ValaAttribute* _tmp160_;
										ValaGirParserNode* _tmp168_;
										_tmp160_ = attr;
										if (_tmp160_ != NULL) {
											ValaSymbol* _tmp161_;
											ValaSourceReference* _tmp162_;
											ValaSourceReference* _tmp163_;
											gchar* _tmp164_;
											gchar* _tmp165_;
											gchar* _tmp166_;
											gchar* _tmp167_;
											_tmp161_ = self->symbol;
											_tmp162_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp161_);
											_tmp163_ = _tmp162_;
											_tmp164_ = vala_gir_parser_node_get_full_name (self);
											_tmp165_ = _tmp164_;
											_tmp166_ = g_strdup_printf ("Virtual method `%s' conflicts with method of the same name", _tmp165_);
											_tmp167_ = _tmp166_;
											vala_report_warning (_tmp163_, _tmp167_);
											_g_free0 (_tmp167_);
											_g_free0 (_tmp165_);
										}
										_tmp168_ = node;
										_tmp168_->merged = TRUE;
									}
									_vala_code_node_unref0 (attr);
								} else {
									ValaMethod* _tmp169_;
									_tmp169_ = m;
									if (vala_symbol_is_class_member ((ValaSymbol*) _tmp169_)) {
										ValaSymbol* _tmp170_;
										ValaSourceReference* _tmp171_;
										ValaSourceReference* _tmp172_;
										gchar* _tmp173_;
										gchar* _tmp174_;
										gchar* _tmp175_;
										gchar* _tmp176_;
										ValaGirParserNode* _tmp177_;
										_tmp170_ = self->symbol;
										_tmp171_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp170_);
										_tmp172_ = _tmp171_;
										_tmp173_ = vala_gir_parser_node_get_full_name (self);
										_tmp174_ = _tmp173_;
										_tmp175_ = g_strdup_printf ("Class method `%s' conflicts with method of the same name", _tmp174_);
										_tmp176_ = _tmp175_;
										vala_report_warning (_tmp172_, _tmp176_);
										_g_free0 (_tmp176_);
										_g_free0 (_tmp174_);
										_tmp177_ = node;
										_tmp177_->merged = TRUE;
									}
								}
							}
						}
					}
					_vala_code_node_unref0 (sym);
					_vala_gir_parser_node_unref0 (node);
				}
				_vala_iterable_unref0 (_node_list);
			}
			_tmp178_ = m;
			if (!VALA_IS_CREATION_METHOD (_tmp178_)) {
				ValaGirParserMetadata* _tmp179_;
				ValaGirParserMetadata* _tmp182_;
				ValaGirParserMetadata* _tmp185_;
				_tmp179_ = self->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp179_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE)) {
					ValaMethod* _tmp180_;
					ValaGirParserMetadata* _tmp181_;
					_tmp180_ = m;
					_tmp181_ = self->metadata;
					vala_code_node_set_attribute ((ValaCodeNode*) _tmp180_, "DestroysInstance", vala_gir_parser_metadata_get_bool (_tmp181_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE, FALSE), NULL);
				}
				_tmp182_ = self->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp182_, VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER)) {
					ValaMethod* _tmp183_;
					ValaGirParserMetadata* _tmp184_;
					_tmp183_ = m;
					_tmp184_ = self->metadata;
					vala_code_node_set_attribute ((ValaCodeNode*) _tmp183_, "ReturnsModifiedPointer", vala_gir_parser_metadata_get_bool (_tmp184_, VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER, FALSE), NULL);
				}
				_tmp185_ = self->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp185_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME)) {
					ValaGirParserNode* vfunc = NULL;
					ValaGirParserNode* _tmp186_;
					ValaGirParserMetadata* _tmp187_;
					gchar* _tmp188_;
					gchar* _tmp189_;
					ValaGirParserNode* _tmp190_;
					ValaGirParserNode* _tmp191_;
					gboolean _tmp192_ = FALSE;
					ValaGirParserNode* _tmp193_;
					_tmp186_ = self->parent;
					_tmp187_ = self->metadata;
					_tmp188_ = vala_gir_parser_metadata_get_string (_tmp187_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME);
					_tmp189_ = _tmp188_;
					_tmp190_ = vala_gir_parser_node_lookup (_tmp186_, _tmp189_, FALSE, NULL);
					_tmp191_ = _tmp190_;
					_g_free0 (_tmp189_);
					vfunc = _tmp191_;
					_tmp193_ = vfunc;
					if (_tmp193_ != NULL) {
						ValaGirParserNode* _tmp194_;
						_tmp194_ = vfunc;
						_tmp192_ = _tmp194_ != self;
					} else {
						_tmp192_ = FALSE;
					}
					if (_tmp192_) {
						ValaGirParserNode* _tmp195_;
						ValaGirParserNode* _tmp196_;
						_tmp195_ = vfunc;
						_tmp195_->processed = TRUE;
						_tmp196_ = vfunc;
						_tmp196_->merged = TRUE;
					}
					_vala_gir_parser_node_unref0 (vfunc);
				}
			}
			_tmp197_ = m;
			_tmp198_ = vala_method_get_coroutine (_tmp197_);
			_tmp199_ = _tmp198_;
			if (_tmp199_) {
				vala_gir_parser_process_async_method (parser, self);
			}
			_vala_iterable_unref0 (colliding);
			_vala_code_node_unref0 (m);
		} else {
			ValaSymbol* _tmp200_;
			_tmp200_ = self->symbol;
			if (VALA_IS_PROPERTY (_tmp200_)) {
				ValaArrayList* colliding = NULL;
				ValaGirParserNode* _tmp201_;
				const gchar* _tmp202_;
				ValaArrayList* _tmp203_;
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp218_;
				ValaProperty* _tmp219_;
				gchar* readable = NULL;
				ValaMap* _tmp220_;
				gpointer _tmp221_;
				gchar* writable = NULL;
				ValaMap* _tmp222_;
				gpointer _tmp223_;
				gchar* construct_ = NULL;
				ValaMap* _tmp224_;
				gpointer _tmp225_;
				gchar* construct_only = NULL;
				ValaMap* _tmp226_;
				gpointer _tmp227_;
				const gchar* _tmp228_;
				gboolean _tmp237_ = FALSE;
				const gchar* _tmp238_;
				ValaProperty* _tmp254_;
				ValaDataType* _tmp255_;
				ValaDataType* _tmp256_;
				ValaGirParserNode* getter = NULL;
				ValaArrayList* getters = NULL;
				ValaGirParserNode* _tmp257_;
				const gchar* _tmp258_;
				gchar* _tmp259_;
				gchar* _tmp260_;
				ValaArrayList* _tmp261_;
				ValaArrayList* _tmp262_;
				ValaArrayList* _tmp263_;
				ValaGirParserNode* setter = NULL;
				ValaArrayList* setters = NULL;
				ValaGirParserNode* _tmp286_;
				const gchar* _tmp287_;
				gchar* _tmp288_;
				gchar* _tmp289_;
				ValaArrayList* _tmp290_;
				ValaArrayList* _tmp291_;
				ValaArrayList* _tmp292_;
				gboolean _tmp315_ = FALSE;
				const gchar* _tmp316_;
				ValaProperty* _tmp318_;
				ValaProperty* _tmp319_;
				ValaPropertyAccessor* _tmp320_;
				ValaPropertyAccessor* _tmp321_;
				gboolean _tmp378_ = FALSE;
				gboolean _tmp379_ = FALSE;
				ValaProperty* _tmp380_;
				ValaAttribute* _tmp381_;
				ValaProperty* _tmp446_;
				ValaAttribute* _tmp447_;
				ValaGirParserMetadata* _tmp493_;
				ValaProperty* _tmp496_;
				ValaAttribute* _tmp497_;
				_tmp201_ = self->parent;
				_tmp202_ = self->name;
				_tmp203_ = vala_gir_parser_node_lookup_all (_tmp201_, _tmp202_);
				colliding = _tmp203_;
				{
					ValaArrayList* _node_list = NULL;
					ValaArrayList* _tmp204_;
					ValaArrayList* _tmp205_;
					gint _node_size = 0;
					ValaArrayList* _tmp206_;
					gint _tmp207_;
					gint _tmp208_;
					gint _node_index = 0;
					_tmp204_ = colliding;
					_tmp205_ = _vala_iterable_ref0 (_tmp204_);
					_node_list = _tmp205_;
					_tmp206_ = _node_list;
					_tmp207_ = vala_collection_get_size ((ValaCollection*) _tmp206_);
					_tmp208_ = _tmp207_;
					_node_size = _tmp208_;
					_node_index = -1;
					while (TRUE) {
						ValaGirParserNode* node = NULL;
						ValaArrayList* _tmp209_;
						gpointer _tmp210_;
						ValaGirParserNode* _tmp211_;
						ValaSymbol* _tmp212_;
						_node_index = _node_index + 1;
						if (!(_node_index < _node_size)) {
							break;
						}
						_tmp209_ = _node_list;
						_tmp210_ = vala_list_get ((ValaList*) _tmp209_, _node_index);
						node = (ValaGirParserNode*) _tmp210_;
						_tmp211_ = node;
						_tmp212_ = _tmp211_->symbol;
						if (VALA_IS_SIGNAL (_tmp212_)) {
							ValaGirParserNode* _tmp213_;
							ValaGirParserNode* _tmp214_;
							_tmp213_ = node;
							_tmp213_->processed = TRUE;
							_tmp214_ = node;
							_tmp214_->merged = TRUE;
						} else {
							ValaGirParserNode* _tmp215_;
							ValaSymbol* _tmp216_;
							_tmp215_ = node;
							_tmp216_ = _tmp215_->symbol;
							if (VALA_IS_METHOD (_tmp216_)) {
								ValaGirParserNode* _tmp217_;
								_tmp217_ = node;
								_tmp217_->merged = TRUE;
							}
						}
						_vala_gir_parser_node_unref0 (node);
					}
					_vala_iterable_unref0 (_node_list);
				}
				_tmp218_ = self->symbol;
				_tmp219_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp218_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp219_;
				_tmp220_ = self->girdata;
				_tmp221_ = vala_map_get (_tmp220_, "readable");
				readable = (gchar*) _tmp221_;
				_tmp222_ = self->girdata;
				_tmp223_ = vala_map_get (_tmp222_, "writable");
				writable = (gchar*) _tmp223_;
				_tmp224_ = self->girdata;
				_tmp225_ = vala_map_get (_tmp224_, "construct");
				construct_ = (gchar*) _tmp225_;
				_tmp226_ = self->girdata;
				_tmp227_ = vala_map_get (_tmp226_, "construct-only");
				construct_only = (gchar*) _tmp227_;
				_tmp228_ = readable;
				if (g_strcmp0 (_tmp228_, "0") != 0) {
					ValaProperty* _tmp229_;
					ValaProperty* _tmp230_;
					ValaDataType* _tmp231_;
					ValaDataType* _tmp232_;
					ValaDataType* _tmp233_;
					ValaDataType* _tmp234_;
					ValaPropertyAccessor* _tmp235_;
					ValaPropertyAccessor* _tmp236_;
					_tmp229_ = prop;
					_tmp230_ = prop;
					_tmp231_ = vala_property_get_property_type (_tmp230_);
					_tmp232_ = _tmp231_;
					_tmp233_ = vala_data_type_copy (_tmp232_);
					_tmp234_ = _tmp233_;
					_tmp235_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp234_, NULL, NULL, NULL);
					_tmp236_ = _tmp235_;
					vala_property_set_get_accessor (_tmp229_, _tmp236_);
					_vala_code_node_unref0 (_tmp236_);
					_vala_code_node_unref0 (_tmp234_);
				}
				_tmp238_ = writable;
				if (g_strcmp0 (_tmp238_, "1") == 0) {
					_tmp237_ = TRUE;
				} else {
					const gchar* _tmp239_;
					_tmp239_ = construct_only;
					_tmp237_ = g_strcmp0 (_tmp239_, "1") == 0;
				}
				if (_tmp237_) {
					gboolean _tmp240_ = FALSE;
					const gchar* _tmp241_;
					gboolean _tmp243_ = FALSE;
					const gchar* _tmp244_;
					ValaProperty* _tmp246_;
					ValaProperty* _tmp247_;
					ValaDataType* _tmp248_;
					ValaDataType* _tmp249_;
					ValaDataType* _tmp250_;
					ValaDataType* _tmp251_;
					ValaPropertyAccessor* _tmp252_;
					ValaPropertyAccessor* _tmp253_;
					_tmp241_ = construct_only;
					if (g_strcmp0 (_tmp241_, "1") != 0) {
						const gchar* _tmp242_;
						_tmp242_ = writable;
						_tmp240_ = g_strcmp0 (_tmp242_, "1") == 0;
					} else {
						_tmp240_ = FALSE;
					}
					_tmp244_ = construct_only;
					if (g_strcmp0 (_tmp244_, "1") == 0) {
						_tmp243_ = TRUE;
					} else {
						const gchar* _tmp245_;
						_tmp245_ = construct_;
						_tmp243_ = g_strcmp0 (_tmp245_, "1") == 0;
					}
					_tmp246_ = prop;
					_tmp247_ = prop;
					_tmp248_ = vala_property_get_property_type (_tmp247_);
					_tmp249_ = _tmp248_;
					_tmp250_ = vala_data_type_copy (_tmp249_);
					_tmp251_ = _tmp250_;
					_tmp252_ = vala_property_accessor_new (FALSE, _tmp240_, _tmp243_, _tmp251_, NULL, NULL, NULL);
					_tmp253_ = _tmp252_;
					vala_property_set_set_accessor (_tmp246_, _tmp253_);
					_vala_code_node_unref0 (_tmp253_);
					_vala_code_node_unref0 (_tmp251_);
				}
				_tmp254_ = prop;
				_tmp255_ = vala_property_get_property_type (_tmp254_);
				_tmp256_ = _tmp255_;
				vala_data_type_set_value_owned (_tmp256_, TRUE);
				getter = NULL;
				_tmp257_ = self->parent;
				_tmp258_ = self->name;
				_tmp259_ = g_strdup_printf ("get_%s", _tmp258_);
				_tmp260_ = _tmp259_;
				_tmp261_ = vala_gir_parser_node_lookup_all (_tmp257_, _tmp260_);
				_tmp262_ = _tmp261_;
				_g_free0 (_tmp260_);
				getters = _tmp262_;
				_tmp263_ = getters;
				if (_tmp263_ != NULL) {
					{
						ValaArrayList* _g_list = NULL;
						ValaArrayList* _tmp264_;
						ValaArrayList* _tmp265_;
						gint _g_size = 0;
						ValaArrayList* _tmp266_;
						gint _tmp267_;
						gint _tmp268_;
						gint _g_index = 0;
						_tmp264_ = getters;
						_tmp265_ = _vala_iterable_ref0 (_tmp264_);
						_g_list = _tmp265_;
						_tmp266_ = _g_list;
						_tmp267_ = vala_collection_get_size ((ValaCollection*) _tmp266_);
						_tmp268_ = _tmp267_;
						_g_size = _tmp268_;
						_g_index = -1;
						while (TRUE) {
							ValaGirParserNode* g = NULL;
							ValaArrayList* _tmp269_;
							gpointer _tmp270_;
							gboolean _tmp271_ = FALSE;
							gboolean _tmp272_ = FALSE;
							ValaGirParserNode* _tmp273_;
							_g_index = _g_index + 1;
							if (!(_g_index < _g_size)) {
								break;
							}
							_tmp269_ = _g_list;
							_tmp270_ = vala_list_get ((ValaList*) _tmp269_, _g_index);
							g = (ValaGirParserNode*) _tmp270_;
							_tmp273_ = getter;
							if (_tmp273_ == NULL) {
								_tmp272_ = TRUE;
							} else {
								ValaGirParserNode* _tmp274_;
								_tmp274_ = g;
								_tmp272_ = !_tmp274_->merged;
							}
							if (_tmp272_) {
								ValaGirParserNode* _tmp275_;
								gchar* _tmp276_;
								gchar* _tmp277_;
								ValaGirParserNode* _tmp278_;
								gchar* _tmp279_;
								gchar* _tmp280_;
								const gchar* _tmp281_;
								gchar* _tmp282_;
								gchar* _tmp283_;
								_tmp275_ = g;
								_tmp276_ = vala_gir_parser_node_get_cname (_tmp275_);
								_tmp277_ = _tmp276_;
								_tmp278_ = self->parent;
								_tmp279_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp278_);
								_tmp280_ = _tmp279_;
								_tmp281_ = self->name;
								_tmp282_ = g_strdup_printf ("%sget_%s", _tmp280_, _tmp281_);
								_tmp283_ = _tmp282_;
								_tmp271_ = g_strcmp0 (_tmp277_, _tmp283_) == 0;
								_g_free0 (_tmp283_);
								_g_free0 (_tmp280_);
								_g_free0 (_tmp277_);
							} else {
								_tmp271_ = FALSE;
							}
							if (_tmp271_) {
								ValaGirParserNode* _tmp284_;
								ValaGirParserNode* _tmp285_;
								_tmp284_ = g;
								_tmp285_ = _vala_gir_parser_node_ref0 (_tmp284_);
								_vala_gir_parser_node_unref0 (getter);
								getter = _tmp285_;
							}
							_vala_gir_parser_node_unref0 (g);
						}
						_vala_iterable_unref0 (_g_list);
					}
				}
				setter = NULL;
				_tmp286_ = self->parent;
				_tmp287_ = self->name;
				_tmp288_ = g_strdup_printf ("set_%s", _tmp287_);
				_tmp289_ = _tmp288_;
				_tmp290_ = vala_gir_parser_node_lookup_all (_tmp286_, _tmp289_);
				_tmp291_ = _tmp290_;
				_g_free0 (_tmp289_);
				setters = _tmp291_;
				_tmp292_ = setters;
				if (_tmp292_ != NULL) {
					{
						ValaArrayList* _s_list = NULL;
						ValaArrayList* _tmp293_;
						ValaArrayList* _tmp294_;
						gint _s_size = 0;
						ValaArrayList* _tmp295_;
						gint _tmp296_;
						gint _tmp297_;
						gint _s_index = 0;
						_tmp293_ = setters;
						_tmp294_ = _vala_iterable_ref0 (_tmp293_);
						_s_list = _tmp294_;
						_tmp295_ = _s_list;
						_tmp296_ = vala_collection_get_size ((ValaCollection*) _tmp295_);
						_tmp297_ = _tmp296_;
						_s_size = _tmp297_;
						_s_index = -1;
						while (TRUE) {
							ValaGirParserNode* s = NULL;
							ValaArrayList* _tmp298_;
							gpointer _tmp299_;
							gboolean _tmp300_ = FALSE;
							gboolean _tmp301_ = FALSE;
							ValaGirParserNode* _tmp302_;
							_s_index = _s_index + 1;
							if (!(_s_index < _s_size)) {
								break;
							}
							_tmp298_ = _s_list;
							_tmp299_ = vala_list_get ((ValaList*) _tmp298_, _s_index);
							s = (ValaGirParserNode*) _tmp299_;
							_tmp302_ = setter;
							if (_tmp302_ == NULL) {
								_tmp301_ = TRUE;
							} else {
								ValaGirParserNode* _tmp303_;
								_tmp303_ = s;
								_tmp301_ = !_tmp303_->merged;
							}
							if (_tmp301_) {
								ValaGirParserNode* _tmp304_;
								gchar* _tmp305_;
								gchar* _tmp306_;
								ValaGirParserNode* _tmp307_;
								gchar* _tmp308_;
								gchar* _tmp309_;
								const gchar* _tmp310_;
								gchar* _tmp311_;
								gchar* _tmp312_;
								_tmp304_ = s;
								_tmp305_ = vala_gir_parser_node_get_cname (_tmp304_);
								_tmp306_ = _tmp305_;
								_tmp307_ = self->parent;
								_tmp308_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp307_);
								_tmp309_ = _tmp308_;
								_tmp310_ = self->name;
								_tmp311_ = g_strdup_printf ("%sset_%s", _tmp309_, _tmp310_);
								_tmp312_ = _tmp311_;
								_tmp300_ = g_strcmp0 (_tmp306_, _tmp312_) == 0;
								_g_free0 (_tmp312_);
								_g_free0 (_tmp309_);
								_g_free0 (_tmp306_);
							} else {
								_tmp300_ = FALSE;
							}
							if (_tmp300_) {
								ValaGirParserNode* _tmp313_;
								ValaGirParserNode* _tmp314_;
								_tmp313_ = s;
								_tmp314_ = _vala_gir_parser_node_ref0 (_tmp313_);
								_vala_gir_parser_node_unref0 (setter);
								setter = _tmp314_;
							}
							_vala_gir_parser_node_unref0 (s);
						}
						_vala_iterable_unref0 (_s_list);
					}
				}
				_tmp316_ = readable;
				if (g_strcmp0 (_tmp316_, "0") == 0) {
					const gchar* _tmp317_;
					_tmp317_ = construct_only;
					_tmp315_ = g_strcmp0 (_tmp317_, "1") == 0;
				} else {
					_tmp315_ = FALSE;
				}
				_tmp318_ = prop;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp318_, "NoAccessorMethod", _tmp315_, NULL);
				_tmp319_ = prop;
				_tmp320_ = vala_property_get_get_accessor (_tmp319_);
				_tmp321_ = _tmp320_;
				if (_tmp321_ != NULL) {
					ValaMethod* _tmp322_ = NULL;
					ValaGirParserNode* _tmp323_;
					ValaMethod* m = NULL;
					ValaMethod* _tmp326_;
					ValaMethod* _tmp327_;
					_tmp323_ = getter;
					if (_tmp323_ != NULL) {
						ValaGirParserNode* _tmp324_;
						ValaSymbol* _tmp325_;
						_tmp324_ = getter;
						_tmp325_ = _tmp324_->symbol;
						_tmp322_ = VALA_IS_METHOD (_tmp325_) ? ((ValaMethod*) _tmp325_) : NULL;
					} else {
						_tmp322_ = NULL;
					}
					_tmp326_ = _vala_code_node_ref0 (_tmp322_);
					m = _tmp326_;
					_tmp327_ = m;
					if (_tmp327_ != NULL) {
						ValaGirParserNode* _tmp328_;
						gboolean _tmp329_ = FALSE;
						gboolean _tmp330_ = FALSE;
						ValaMethod* _tmp331_;
						ValaDataType* _tmp332_;
						ValaDataType* _tmp333_;
						_tmp328_ = getter;
						vala_gir_parser_node_process (_tmp328_, parser);
						_tmp331_ = m;
						_tmp332_ = vala_callable_get_return_type ((ValaCallable*) _tmp331_);
						_tmp333_ = _tmp332_;
						if (VALA_IS_VOID_TYPE (_tmp333_)) {
							_tmp330_ = TRUE;
						} else {
							ValaMethod* _tmp334_;
							ValaList* _tmp335_;
							gint _tmp336_;
							gint _tmp337_;
							_tmp334_ = m;
							_tmp335_ = vala_callable_get_parameters ((ValaCallable*) _tmp334_);
							_tmp336_ = vala_collection_get_size ((ValaCollection*) _tmp335_);
							_tmp337_ = _tmp336_;
							_tmp330_ = _tmp337_ != 0;
						}
						if (_tmp330_) {
							_tmp329_ = TRUE;
						} else {
							ValaMethod* _tmp338_;
							gboolean _tmp339_;
							gboolean _tmp340_;
							_tmp338_ = m;
							_tmp339_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp338_);
							_tmp340_ = _tmp339_;
							_tmp329_ = _tmp340_;
						}
						if (_tmp329_) {
							ValaProperty* _tmp341_;
							_tmp341_ = prop;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp341_, "NoAccessorMethod", TRUE, NULL);
						} else {
							ValaGirParserNode* _tmp342_;
							const gchar* _tmp343_;
							const gchar* _tmp344_;
							ValaProperty* _tmp355_;
							ValaPropertyAccessor* _tmp356_;
							ValaPropertyAccessor* _tmp357_;
							ValaDataType* _tmp358_;
							ValaDataType* _tmp359_;
							ValaMethod* _tmp360_;
							ValaDataType* _tmp361_;
							ValaDataType* _tmp362_;
							gboolean _tmp363_;
							gboolean _tmp364_;
							gboolean _tmp365_ = FALSE;
							gboolean _tmp366_ = FALSE;
							ValaMethod* _tmp367_;
							gboolean _tmp368_;
							gboolean _tmp369_;
							_tmp342_ = getter;
							_tmp343_ = _tmp342_->name;
							_tmp344_ = self->name;
							if (g_strcmp0 (_tmp343_, _tmp344_) == 0) {
								{
									ValaArrayList* _node_list = NULL;
									ValaArrayList* _tmp345_;
									ValaArrayList* _tmp346_;
									gint _node_size = 0;
									ValaArrayList* _tmp347_;
									gint _tmp348_;
									gint _tmp349_;
									gint _node_index = 0;
									_tmp345_ = colliding;
									_tmp346_ = _vala_iterable_ref0 (_tmp345_);
									_node_list = _tmp346_;
									_tmp347_ = _node_list;
									_tmp348_ = vala_collection_get_size ((ValaCollection*) _tmp347_);
									_tmp349_ = _tmp348_;
									_node_size = _tmp349_;
									_node_index = -1;
									while (TRUE) {
										ValaGirParserNode* node = NULL;
										ValaArrayList* _tmp350_;
										gpointer _tmp351_;
										ValaGirParserNode* _tmp352_;
										ValaSymbol* _tmp353_;
										_node_index = _node_index + 1;
										if (!(_node_index < _node_size)) {
											break;
										}
										_tmp350_ = _node_list;
										_tmp351_ = vala_list_get ((ValaList*) _tmp350_, _node_index);
										node = (ValaGirParserNode*) _tmp351_;
										_tmp352_ = node;
										_tmp353_ = _tmp352_->symbol;
										if (VALA_IS_METHOD (_tmp353_)) {
											ValaGirParserNode* _tmp354_;
											_tmp354_ = node;
											_tmp354_->merged = TRUE;
										}
										_vala_gir_parser_node_unref0 (node);
									}
									_vala_iterable_unref0 (_node_list);
								}
							}
							_tmp355_ = prop;
							_tmp356_ = vala_property_get_get_accessor (_tmp355_);
							_tmp357_ = _tmp356_;
							_tmp358_ = vala_property_accessor_get_value_type (_tmp357_);
							_tmp359_ = _tmp358_;
							_tmp360_ = m;
							_tmp361_ = vala_callable_get_return_type ((ValaCallable*) _tmp360_);
							_tmp362_ = _tmp361_;
							_tmp363_ = vala_data_type_get_value_owned (_tmp362_);
							_tmp364_ = _tmp363_;
							vala_data_type_set_value_owned (_tmp359_, _tmp364_);
							_tmp367_ = m;
							_tmp368_ = vala_method_get_is_abstract (_tmp367_);
							_tmp369_ = _tmp368_;
							if (!_tmp369_) {
								ValaMethod* _tmp370_;
								gboolean _tmp371_;
								gboolean _tmp372_;
								_tmp370_ = m;
								_tmp371_ = vala_method_get_is_virtual (_tmp370_);
								_tmp372_ = _tmp371_;
								_tmp366_ = !_tmp372_;
							} else {
								_tmp366_ = FALSE;
							}
							if (_tmp366_) {
								ValaProperty* _tmp373_;
								gboolean _tmp374_;
								gboolean _tmp375_;
								_tmp373_ = prop;
								_tmp374_ = vala_property_get_is_abstract (_tmp373_);
								_tmp375_ = _tmp374_;
								_tmp365_ = _tmp375_;
							} else {
								_tmp365_ = FALSE;
							}
							if (_tmp365_) {
								ValaProperty* _tmp376_;
								_tmp376_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp376_, "ConcreteAccessor", TRUE, NULL);
							}
						}
					} else {
						ValaProperty* _tmp377_;
						_tmp377_ = prop;
						vala_code_node_set_attribute ((ValaCodeNode*) _tmp377_, "NoAccessorMethod", TRUE, NULL);
					}
					_vala_code_node_unref0 (m);
				}
				_tmp380_ = prop;
				_tmp381_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp380_, "NoAccessorMethod");
				if (_tmp381_ == NULL) {
					ValaProperty* _tmp382_;
					ValaPropertyAccessor* _tmp383_;
					ValaPropertyAccessor* _tmp384_;
					_tmp382_ = prop;
					_tmp383_ = vala_property_get_set_accessor (_tmp382_);
					_tmp384_ = _tmp383_;
					_tmp379_ = _tmp384_ != NULL;
				} else {
					_tmp379_ = FALSE;
				}
				if (_tmp379_) {
					ValaProperty* _tmp385_;
					ValaPropertyAccessor* _tmp386_;
					ValaPropertyAccessor* _tmp387_;
					gboolean _tmp388_;
					gboolean _tmp389_;
					_tmp385_ = prop;
					_tmp386_ = vala_property_get_set_accessor (_tmp385_);
					_tmp387_ = _tmp386_;
					_tmp388_ = vala_property_accessor_get_writable (_tmp387_);
					_tmp389_ = _tmp388_;
					_tmp378_ = _tmp389_;
				} else {
					_tmp378_ = FALSE;
				}
				if (_tmp378_) {
					ValaMethod* _tmp390_ = NULL;
					ValaGirParserNode* _tmp391_;
					ValaMethod* m = NULL;
					ValaMethod* _tmp394_;
					ValaMethod* _tmp395_;
					_tmp391_ = setter;
					if (_tmp391_ != NULL) {
						ValaGirParserNode* _tmp392_;
						ValaSymbol* _tmp393_;
						_tmp392_ = setter;
						_tmp393_ = _tmp392_->symbol;
						_tmp390_ = VALA_IS_METHOD (_tmp393_) ? ((ValaMethod*) _tmp393_) : NULL;
					} else {
						_tmp390_ = NULL;
					}
					_tmp394_ = _vala_code_node_ref0 (_tmp390_);
					m = _tmp394_;
					_tmp395_ = m;
					if (_tmp395_ != NULL) {
						ValaGirParserNode* _tmp396_;
						gboolean _tmp397_ = FALSE;
						gboolean _tmp398_ = FALSE;
						gboolean _tmp399_ = FALSE;
						ValaMethod* _tmp400_;
						ValaDataType* _tmp401_;
						ValaDataType* _tmp402_;
						_tmp396_ = setter;
						vala_gir_parser_node_process (_tmp396_, parser);
						_tmp400_ = m;
						_tmp401_ = vala_callable_get_return_type ((ValaCallable*) _tmp400_);
						_tmp402_ = _tmp401_;
						if (VALA_IS_VOID_TYPE (_tmp402_)) {
							_tmp399_ = TRUE;
						} else {
							ValaMethod* _tmp403_;
							ValaDataType* _tmp404_;
							ValaDataType* _tmp405_;
							_tmp403_ = m;
							_tmp404_ = vala_callable_get_return_type ((ValaCallable*) _tmp403_);
							_tmp405_ = _tmp404_;
							_tmp399_ = VALA_IS_BOOLEAN_TYPE (_tmp405_);
						}
						if (!_tmp399_) {
							_tmp398_ = TRUE;
						} else {
							ValaMethod* _tmp406_;
							ValaList* _tmp407_;
							gint _tmp408_;
							gint _tmp409_;
							_tmp406_ = m;
							_tmp407_ = vala_callable_get_parameters ((ValaCallable*) _tmp406_);
							_tmp408_ = vala_collection_get_size ((ValaCollection*) _tmp407_);
							_tmp409_ = _tmp408_;
							_tmp398_ = _tmp409_ != 1;
						}
						if (_tmp398_) {
							_tmp397_ = TRUE;
						} else {
							ValaMethod* _tmp410_;
							gboolean _tmp411_;
							gboolean _tmp412_;
							_tmp410_ = m;
							_tmp411_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) _tmp410_);
							_tmp412_ = _tmp411_;
							_tmp397_ = _tmp412_;
						}
						if (_tmp397_) {
							ValaProperty* _tmp413_;
							ValaProperty* _tmp414_;
							_tmp413_ = prop;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp413_, "NoAccessorMethod", TRUE, NULL);
							_tmp414_ = prop;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp414_, "ConcreteAccessor", FALSE, NULL);
						} else {
							ValaProperty* _tmp415_;
							ValaPropertyAccessor* _tmp416_;
							ValaPropertyAccessor* _tmp417_;
							ValaDataType* _tmp418_;
							ValaDataType* _tmp419_;
							ValaMethod* _tmp420_;
							ValaList* _tmp421_;
							gpointer _tmp422_;
							ValaParameter* _tmp423_;
							ValaDataType* _tmp424_;
							ValaDataType* _tmp425_;
							gboolean _tmp426_;
							gboolean _tmp427_;
							gboolean _tmp428_ = FALSE;
							gboolean _tmp429_ = FALSE;
							gboolean _tmp430_ = FALSE;
							ValaProperty* _tmp431_;
							ValaAttribute* _tmp432_;
							_tmp415_ = prop;
							_tmp416_ = vala_property_get_set_accessor (_tmp415_);
							_tmp417_ = _tmp416_;
							_tmp418_ = vala_property_accessor_get_value_type (_tmp417_);
							_tmp419_ = _tmp418_;
							_tmp420_ = m;
							_tmp421_ = vala_callable_get_parameters ((ValaCallable*) _tmp420_);
							_tmp422_ = vala_list_get (_tmp421_, 0);
							_tmp423_ = (ValaParameter*) _tmp422_;
							_tmp424_ = vala_variable_get_variable_type ((ValaVariable*) _tmp423_);
							_tmp425_ = _tmp424_;
							_tmp426_ = vala_data_type_get_value_owned (_tmp425_);
							_tmp427_ = _tmp426_;
							vala_data_type_set_value_owned (_tmp419_, _tmp427_);
							_vala_code_node_unref0 (_tmp423_);
							_tmp431_ = prop;
							_tmp432_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp431_, "ConcreteAccessor");
							if (_tmp432_ != NULL) {
								ValaMethod* _tmp433_;
								gboolean _tmp434_;
								gboolean _tmp435_;
								_tmp433_ = m;
								_tmp434_ = vala_method_get_is_abstract (_tmp433_);
								_tmp435_ = _tmp434_;
								_tmp430_ = !_tmp435_;
							} else {
								_tmp430_ = FALSE;
							}
							if (_tmp430_) {
								ValaMethod* _tmp436_;
								gboolean _tmp437_;
								gboolean _tmp438_;
								_tmp436_ = m;
								_tmp437_ = vala_method_get_is_virtual (_tmp436_);
								_tmp438_ = _tmp437_;
								_tmp429_ = !_tmp438_;
							} else {
								_tmp429_ = FALSE;
							}
							if (_tmp429_) {
								ValaProperty* _tmp439_;
								gboolean _tmp440_;
								gboolean _tmp441_;
								_tmp439_ = prop;
								_tmp440_ = vala_property_get_is_abstract (_tmp439_);
								_tmp441_ = _tmp440_;
								_tmp428_ = _tmp441_;
							} else {
								_tmp428_ = FALSE;
							}
							if (_tmp428_) {
								ValaProperty* _tmp442_;
								ValaProperty* _tmp443_;
								_tmp442_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp442_, "ConcreteAccessor", TRUE, NULL);
								_tmp443_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp443_, "NoAccessorMethod", FALSE, NULL);
							}
						}
					} else {
						ValaProperty* _tmp444_;
						ValaProperty* _tmp445_;
						_tmp444_ = prop;
						vala_code_node_set_attribute ((ValaCodeNode*) _tmp444_, "NoAccessorMethod", TRUE, NULL);
						_tmp445_ = prop;
						vala_code_node_set_attribute ((ValaCodeNode*) _tmp445_, "ConcreteAccessor", FALSE, NULL);
					}
					_vala_code_node_unref0 (m);
				}
				_tmp446_ = prop;
				_tmp447_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp446_, "NoAccessorMethod");
				if (_tmp447_ != NULL) {
					gboolean _tmp448_ = FALSE;
					ValaProperty* _tmp449_;
					gboolean _tmp450_;
					gboolean _tmp451_;
					_tmp449_ = prop;
					_tmp450_ = vala_property_get_overrides (_tmp449_);
					_tmp451_ = _tmp450_;
					if (!_tmp451_) {
						ValaGirParserNode* _tmp452_;
						ValaSymbol* _tmp453_;
						_tmp452_ = self->parent;
						_tmp453_ = _tmp452_->symbol;
						_tmp448_ = VALA_IS_CLASS (_tmp453_);
					} else {
						_tmp448_ = FALSE;
					}
					if (_tmp448_) {
						ValaGirParserNode* base_prop_node = NULL;
						ValaGirParserNode* _tmp454_;
						ValaGirParserNode* _tmp455_;
						_tmp454_ = vala_gir_parser_base_interface_property (parser, self);
						base_prop_node = _tmp454_;
						_tmp455_ = base_prop_node;
						if (_tmp455_ != NULL) {
							ValaGirParserNode* _tmp456_;
							ValaProperty* base_property = NULL;
							ValaGirParserNode* _tmp457_;
							ValaSymbol* _tmp458_;
							ValaProperty* _tmp459_;
							ValaProperty* _tmp460_;
							ValaAttribute* _tmp461_;
							_tmp456_ = base_prop_node;
							vala_gir_parser_node_process (_tmp456_, parser);
							_tmp457_ = base_prop_node;
							_tmp458_ = _tmp457_->symbol;
							_tmp459_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp458_, VALA_TYPE_PROPERTY, ValaProperty));
							base_property = _tmp459_;
							_tmp460_ = base_property;
							_tmp461_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp460_, "ConcreteAccessor");
							if (_tmp461_ != NULL) {
								ValaProperty* _tmp462_;
								ValaProperty* _tmp463_;
								ValaPropertyAccessor* _tmp464_;
								ValaPropertyAccessor* _tmp465_;
								ValaProperty* _tmp478_;
								ValaPropertyAccessor* _tmp479_;
								ValaPropertyAccessor* _tmp480_;
								_tmp462_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp462_, "NoAccessorMethod", FALSE, NULL);
								_tmp463_ = prop;
								_tmp464_ = vala_property_get_get_accessor (_tmp463_);
								_tmp465_ = _tmp464_;
								if (_tmp465_ != NULL) {
									ValaProperty* _tmp466_;
									ValaPropertyAccessor* _tmp467_;
									ValaPropertyAccessor* _tmp468_;
									ValaDataType* _tmp469_;
									ValaDataType* _tmp470_;
									ValaProperty* _tmp471_;
									ValaPropertyAccessor* _tmp472_;
									ValaPropertyAccessor* _tmp473_;
									ValaDataType* _tmp474_;
									ValaDataType* _tmp475_;
									gboolean _tmp476_;
									gboolean _tmp477_;
									_tmp466_ = prop;
									_tmp467_ = vala_property_get_get_accessor (_tmp466_);
									_tmp468_ = _tmp467_;
									_tmp469_ = vala_property_accessor_get_value_type (_tmp468_);
									_tmp470_ = _tmp469_;
									_tmp471_ = base_property;
									_tmp472_ = vala_property_get_get_accessor (_tmp471_);
									_tmp473_ = _tmp472_;
									_tmp474_ = vala_property_accessor_get_value_type (_tmp473_);
									_tmp475_ = _tmp474_;
									_tmp476_ = vala_data_type_get_value_owned (_tmp475_);
									_tmp477_ = _tmp476_;
									vala_data_type_set_value_owned (_tmp470_, _tmp477_);
								}
								_tmp478_ = prop;
								_tmp479_ = vala_property_get_set_accessor (_tmp478_);
								_tmp480_ = _tmp479_;
								if (_tmp480_ != NULL) {
									ValaProperty* _tmp481_;
									ValaPropertyAccessor* _tmp482_;
									ValaPropertyAccessor* _tmp483_;
									ValaDataType* _tmp484_;
									ValaDataType* _tmp485_;
									ValaProperty* _tmp486_;
									ValaPropertyAccessor* _tmp487_;
									ValaPropertyAccessor* _tmp488_;
									ValaDataType* _tmp489_;
									ValaDataType* _tmp490_;
									gboolean _tmp491_;
									gboolean _tmp492_;
									_tmp481_ = prop;
									_tmp482_ = vala_property_get_set_accessor (_tmp481_);
									_tmp483_ = _tmp482_;
									_tmp484_ = vala_property_accessor_get_value_type (_tmp483_);
									_tmp485_ = _tmp484_;
									_tmp486_ = base_property;
									_tmp487_ = vala_property_get_set_accessor (_tmp486_);
									_tmp488_ = _tmp487_;
									_tmp489_ = vala_property_accessor_get_value_type (_tmp488_);
									_tmp490_ = _tmp489_;
									_tmp491_ = vala_data_type_get_value_owned (_tmp490_);
									_tmp492_ = _tmp491_;
									vala_data_type_set_value_owned (_tmp485_, _tmp492_);
								}
							}
							_vala_code_node_unref0 (base_property);
						}
						_vala_gir_parser_node_unref0 (base_prop_node);
					}
				}
				_tmp493_ = self->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp493_, VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD)) {
					ValaProperty* _tmp494_;
					ValaGirParserMetadata* _tmp495_;
					_tmp494_ = prop;
					_tmp495_ = self->metadata;
					vala_code_node_set_attribute ((ValaCodeNode*) _tmp494_, "NoAccessorMethod", vala_gir_parser_metadata_get_bool (_tmp495_, VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD, FALSE), NULL);
				}
				_tmp496_ = prop;
				_tmp497_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp496_, "NoAccessorMethod");
				if (_tmp497_ != NULL) {
					ValaProperty* _tmp498_;
					ValaPropertyAccessor* _tmp499_;
					ValaPropertyAccessor* _tmp500_;
					ValaProperty* _tmp506_;
					ValaPropertyAccessor* _tmp507_;
					ValaPropertyAccessor* _tmp508_;
					_tmp498_ = prop;
					_tmp499_ = vala_property_get_get_accessor (_tmp498_);
					_tmp500_ = _tmp499_;
					if (_tmp500_ != NULL) {
						ValaProperty* _tmp501_;
						ValaPropertyAccessor* _tmp502_;
						ValaPropertyAccessor* _tmp503_;
						ValaDataType* _tmp504_;
						ValaDataType* _tmp505_;
						_tmp501_ = prop;
						_tmp502_ = vala_property_get_get_accessor (_tmp501_);
						_tmp503_ = _tmp502_;
						_tmp504_ = vala_property_accessor_get_value_type (_tmp503_);
						_tmp505_ = _tmp504_;
						vala_data_type_set_value_owned (_tmp505_, TRUE);
					}
					_tmp506_ = prop;
					_tmp507_ = vala_property_get_set_accessor (_tmp506_);
					_tmp508_ = _tmp507_;
					if (_tmp508_ != NULL) {
						ValaProperty* _tmp509_;
						ValaPropertyAccessor* _tmp510_;
						ValaPropertyAccessor* _tmp511_;
						ValaDataType* _tmp512_;
						ValaDataType* _tmp513_;
						_tmp509_ = prop;
						_tmp510_ = vala_property_get_set_accessor (_tmp509_);
						_tmp511_ = _tmp510_;
						_tmp512_ = vala_property_accessor_get_value_type (_tmp511_);
						_tmp513_ = _tmp512_;
						vala_data_type_set_value_owned (_tmp513_, FALSE);
					}
				}
				_vala_iterable_unref0 (setters);
				_vala_gir_parser_node_unref0 (setter);
				_vala_iterable_unref0 (getters);
				_vala_gir_parser_node_unref0 (getter);
				_g_free0 (construct_only);
				_g_free0 (construct_);
				_g_free0 (writable);
				_g_free0 (readable);
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (colliding);
			} else {
				ValaSymbol* _tmp514_;
				_tmp514_ = self->symbol;
				if (VALA_IS_FIELD (_tmp514_)) {
					ValaField* field = NULL;
					ValaSymbol* _tmp515_;
					ValaField* _tmp516_;
					ValaArrayList* colliding = NULL;
					ValaGirParserNode* _tmp517_;
					const gchar* _tmp518_;
					ValaArrayList* _tmp519_;
					ValaArrayList* _tmp520_;
					gint _tmp521_;
					gint _tmp522_;
					ValaGirParserMetadata* _tmp523_;
					ValaGirParserMetadata* _tmp526_;
					gboolean _tmp531_ = FALSE;
					ValaField* _tmp532_;
					ValaDataType* _tmp533_;
					ValaDataType* _tmp534_;
					_tmp515_ = self->symbol;
					_tmp516_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp515_, VALA_TYPE_FIELD, ValaField));
					field = _tmp516_;
					_tmp517_ = self->parent;
					_tmp518_ = self->name;
					_tmp519_ = vala_gir_parser_node_lookup_all (_tmp517_, _tmp518_);
					colliding = _tmp519_;
					_tmp520_ = colliding;
					_tmp521_ = vala_collection_get_size ((ValaCollection*) _tmp520_);
					_tmp522_ = _tmp521_;
					if (_tmp522_ > 1) {
						self->merged = TRUE;
					}
					_tmp523_ = self->metadata;
					if (vala_gir_parser_metadata_has_argument (_tmp523_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET)) {
						ValaField* _tmp524_;
						ValaGirParserMetadata* _tmp525_;
						_tmp524_ = field;
						_tmp525_ = self->metadata;
						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp524_, "CCode", "delegate_target", vala_gir_parser_metadata_get_bool (_tmp525_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET, FALSE), NULL);
					}
					_tmp526_ = self->metadata;
					if (vala_gir_parser_metadata_has_argument (_tmp526_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME)) {
						ValaField* _tmp527_;
						ValaGirParserMetadata* _tmp528_;
						gchar* _tmp529_;
						gchar* _tmp530_;
						_tmp527_ = field;
						_tmp528_ = self->metadata;
						_tmp529_ = vala_gir_parser_metadata_get_string (_tmp528_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME);
						_tmp530_ = _tmp529_;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp527_, "CCode", "delegate_target_cname", _tmp530_, NULL);
						_g_free0 (_tmp530_);
					}
					_tmp532_ = field;
					_tmp533_ = vala_variable_get_variable_type ((ValaVariable*) _tmp532_);
					_tmp534_ = _tmp533_;
					if (VALA_IS_DELEGATE_TYPE (_tmp534_)) {
						ValaGirParserNode* _tmp535_;
						ValaUnresolvedSymbol* _tmp536_;
						_tmp535_ = self->parent;
						_tmp536_ = _tmp535_->gtype_struct_for;
						_tmp531_ = _tmp536_ != NULL;
					} else {
						_tmp531_ = FALSE;
					}
					if (_tmp531_) {
						ValaDelegate* d = NULL;
						ValaField* _tmp537_;
						ValaDataType* _tmp538_;
						ValaDataType* _tmp539_;
						ValaDelegate* _tmp540_;
						ValaDelegate* _tmp541_;
						ValaDelegate* _tmp542_;
						ValaDelegate* _tmp543_;
						ValaGirParserNode* _tmp544_;
						ValaUnresolvedSymbol* _tmp545_;
						_tmp537_ = field;
						_tmp538_ = vala_variable_get_variable_type ((ValaVariable*) _tmp537_);
						_tmp539_ = _tmp538_;
						_tmp540_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp539_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp541_ = _tmp540_;
						_tmp542_ = _vala_code_node_ref0 (_tmp541_);
						d = _tmp542_;
						_tmp543_ = d;
						_tmp544_ = self->parent;
						_tmp545_ = _tmp544_->gtype_struct_for;
						vala_gir_parser_process_virtual_method_field (parser, self, _tmp543_, _tmp545_);
						self->merged = TRUE;
						_vala_code_node_unref0 (d);
					} else {
						ValaField* _tmp546_;
						ValaDataType* _tmp547_;
						ValaDataType* _tmp548_;
						_tmp546_ = field;
						_tmp547_ = vala_variable_get_variable_type ((ValaVariable*) _tmp546_);
						_tmp548_ = _tmp547_;
						if (VALA_IS_ARRAY_TYPE (_tmp548_)) {
							ValaGirParserNode* array_length = NULL;
							ValaGirParserMetadata* _tmp549_;
							gboolean _tmp586_ = FALSE;
							ValaGirParserNode* _tmp587_;
							_tmp549_ = self->metadata;
							if (vala_gir_parser_metadata_has_argument (_tmp549_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD)) {
								ValaGirParserNode* _tmp550_;
								ValaGirParserMetadata* _tmp551_;
								gchar* _tmp552_;
								gchar* _tmp553_;
								ValaGirParserNode* _tmp554_;
								_tmp550_ = self->parent;
								_tmp551_ = self->metadata;
								_tmp552_ = vala_gir_parser_metadata_get_string (_tmp551_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD);
								_tmp553_ = _tmp552_;
								_tmp554_ = vala_gir_parser_node_lookup (_tmp550_, _tmp553_, FALSE, NULL);
								_vala_gir_parser_node_unref0 (array_length);
								array_length = _tmp554_;
								_g_free0 (_tmp553_);
							} else {
								gboolean _tmp555_ = FALSE;
								if (self->array_length_idx > -1) {
									ValaGirParserNode* _tmp556_;
									ValaArrayList* _tmp557_;
									gint _tmp558_;
									gint _tmp559_;
									_tmp556_ = self->parent;
									_tmp557_ = _tmp556_->members;
									_tmp558_ = vala_collection_get_size ((ValaCollection*) _tmp557_);
									_tmp559_ = _tmp558_;
									_tmp555_ = _tmp559_ > self->array_length_idx;
								} else {
									_tmp555_ = FALSE;
								}
								if (_tmp555_) {
									ValaGirParserNode* _tmp560_;
									ValaArrayList* _tmp561_;
									gpointer _tmp562_;
									_tmp560_ = self->parent;
									_tmp561_ = _tmp560_->members;
									_tmp562_ = vala_list_get ((ValaList*) _tmp561_, self->array_length_idx);
									_vala_gir_parser_node_unref0 (array_length);
									array_length = (ValaGirParserNode*) _tmp562_;
								} else {
									ValaGirParserNode* _tmp563_;
									ValaField* _tmp564_;
									const gchar* _tmp565_;
									const gchar* _tmp566_;
									gchar* _tmp567_;
									gchar* _tmp568_;
									ValaGirParserNode* _tmp569_;
									ValaGirParserNode* _tmp570_;
									_tmp563_ = self->parent;
									_tmp564_ = field;
									_tmp565_ = vala_symbol_get_name ((ValaSymbol*) _tmp564_);
									_tmp566_ = _tmp565_;
									_tmp567_ = g_strdup_printf ("n_%s", _tmp566_);
									_tmp568_ = _tmp567_;
									_tmp569_ = vala_gir_parser_node_lookup (_tmp563_, _tmp568_, FALSE, NULL);
									_vala_gir_parser_node_unref0 (array_length);
									array_length = _tmp569_;
									_g_free0 (_tmp568_);
									_tmp570_ = array_length;
									if (_tmp570_ == NULL) {
										ValaGirParserNode* _tmp571_;
										ValaField* _tmp572_;
										const gchar* _tmp573_;
										const gchar* _tmp574_;
										gchar* _tmp575_;
										gchar* _tmp576_;
										ValaGirParserNode* _tmp577_;
										ValaGirParserNode* _tmp578_;
										_tmp571_ = self->parent;
										_tmp572_ = field;
										_tmp573_ = vala_symbol_get_name ((ValaSymbol*) _tmp572_);
										_tmp574_ = _tmp573_;
										_tmp575_ = g_strdup_printf ("num_%s", _tmp574_);
										_tmp576_ = _tmp575_;
										_tmp577_ = vala_gir_parser_node_lookup (_tmp571_, _tmp576_, FALSE, NULL);
										_vala_gir_parser_node_unref0 (array_length);
										array_length = _tmp577_;
										_g_free0 (_tmp576_);
										_tmp578_ = array_length;
										if (_tmp578_ == NULL) {
											ValaGirParserNode* _tmp579_;
											ValaField* _tmp580_;
											const gchar* _tmp581_;
											const gchar* _tmp582_;
											gchar* _tmp583_;
											gchar* _tmp584_;
											ValaGirParserNode* _tmp585_;
											_tmp579_ = self->parent;
											_tmp580_ = field;
											_tmp581_ = vala_symbol_get_name ((ValaSymbol*) _tmp580_);
											_tmp582_ = _tmp581_;
											_tmp583_ = g_strdup_printf ("%s_length", _tmp582_);
											_tmp584_ = _tmp583_;
											_tmp585_ = vala_gir_parser_node_lookup (_tmp579_, _tmp584_, FALSE, NULL);
											_vala_gir_parser_node_unref0 (array_length);
											array_length = _tmp585_;
											_g_free0 (_tmp584_);
										}
									}
								}
							}
							_tmp587_ = array_length;
							if (_tmp587_ != NULL) {
								ValaGirParserNode* _tmp588_;
								ValaSymbol* _tmp589_;
								_tmp588_ = array_length;
								_tmp589_ = _tmp588_->symbol;
								_tmp586_ = VALA_IS_FIELD (_tmp589_);
							} else {
								_tmp586_ = FALSE;
							}
							if (_tmp586_) {
								ValaField* length_field = NULL;
								ValaGirParserNode* _tmp590_;
								ValaSymbol* _tmp591_;
								ValaField* _tmp592_;
								ValaField* _tmp593_;
								ValaField* _tmp594_;
								const gchar* _tmp595_;
								const gchar* _tmp596_;
								gchar* length_type = NULL;
								ValaField* _tmp597_;
								ValaDataType* _tmp598_;
								ValaDataType* _tmp599_;
								gchar* _tmp600_;
								const gchar* _tmp601_;
								ValaField* _tmp610_;
								ValaField* _tmp611_;
								_tmp590_ = array_length;
								_tmp591_ = _tmp590_->symbol;
								_tmp592_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp591_, VALA_TYPE_FIELD, ValaField));
								length_field = _tmp592_;
								_tmp593_ = field;
								_tmp594_ = length_field;
								_tmp595_ = vala_symbol_get_name ((ValaSymbol*) _tmp594_);
								_tmp596_ = _tmp595_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp593_, "CCode", "array_length_cname", _tmp596_, NULL);
								_tmp597_ = length_field;
								_tmp598_ = vala_variable_get_variable_type ((ValaVariable*) _tmp597_);
								_tmp599_ = _tmp598_;
								_tmp600_ = vala_data_type_to_qualified_string (_tmp599_, NULL);
								length_type = _tmp600_;
								_tmp601_ = length_type;
								if (g_strcmp0 (_tmp601_, "int") != 0) {
									ValaGirParserNode* st = NULL;
									ValaGirParserNode* _tmp602_;
									const gchar* _tmp603_;
									ValaGirParserNode* _tmp604_;
									ValaGirParserNode* _tmp605_;
									_tmp602_ = parser->priv->root;
									_tmp603_ = length_type;
									_tmp604_ = vala_gir_parser_node_lookup (_tmp602_, _tmp603_, FALSE, NULL);
									st = _tmp604_;
									_tmp605_ = st;
									if (_tmp605_ != NULL) {
										ValaField* _tmp606_;
										ValaGirParserNode* _tmp607_;
										gchar* _tmp608_;
										gchar* _tmp609_;
										_tmp606_ = field;
										_tmp607_ = st;
										_tmp608_ = vala_gir_parser_node_get_cname (_tmp607_);
										_tmp609_ = _tmp608_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp606_, "CCode", "array_length_type", _tmp609_, NULL);
										_g_free0 (_tmp609_);
									}
									_vala_gir_parser_node_unref0 (st);
								}
								_tmp610_ = field;
								vala_code_node_remove_attribute_argument ((ValaCodeNode*) _tmp610_, "CCode", "array_length");
								_tmp611_ = field;
								vala_code_node_remove_attribute_argument ((ValaCodeNode*) _tmp611_, "CCode", "array_null_terminated");
								_g_free0 (length_type);
								_vala_code_node_unref0 (length_field);
							}
							_vala_gir_parser_node_unref0 (array_length);
						}
					}
					_vala_iterable_unref0 (colliding);
					_vala_code_node_unref0 (field);
				} else {
					gboolean _tmp612_ = FALSE;
					ValaSymbol* _tmp613_;
					_tmp613_ = self->symbol;
					if (VALA_IS_SIGNAL (_tmp613_)) {
						_tmp612_ = TRUE;
					} else {
						ValaSymbol* _tmp614_;
						_tmp614_ = self->symbol;
						_tmp612_ = VALA_IS_DELEGATE (_tmp614_);
					}
					if (_tmp612_) {
						vala_gir_parser_process_callable (parser, self);
					} else {
						ValaSymbol* _tmp615_;
						_tmp615_ = self->symbol;
						if (VALA_IS_INTERFACE (_tmp615_)) {
							vala_gir_parser_process_interface (parser, self);
						} else {
							ValaSymbol* _tmp616_;
							_tmp616_ = self->symbol;
							if (VALA_IS_STRUCT (_tmp616_)) {
								gboolean _tmp617_ = FALSE;
								ValaGirParserNode* _tmp618_;
								ValaSymbol* _tmp619_;
								_tmp618_ = self->parent;
								_tmp619_ = _tmp618_->symbol;
								if (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp619_)) {
									_tmp617_ = TRUE;
								} else {
									ValaGirParserNode* _tmp620_;
									ValaSymbol* _tmp621_;
									_tmp620_ = self->parent;
									_tmp621_ = _tmp620_->symbol;
									_tmp617_ = VALA_IS_STRUCT (_tmp621_);
								}
								if (_tmp617_) {
									{
										ValaArrayList* _fn_list = NULL;
										ValaArrayList* _tmp622_;
										ValaArrayList* _tmp623_;
										gint _fn_size = 0;
										ValaArrayList* _tmp624_;
										gint _tmp625_;
										gint _tmp626_;
										gint _fn_index = 0;
										_tmp622_ = self->members;
										_tmp623_ = _vala_iterable_ref0 (_tmp622_);
										_fn_list = _tmp623_;
										_tmp624_ = _fn_list;
										_tmp625_ = vala_collection_get_size ((ValaCollection*) _tmp624_);
										_tmp626_ = _tmp625_;
										_fn_size = _tmp626_;
										_fn_index = -1;
										while (TRUE) {
											ValaGirParserNode* fn = NULL;
											ValaArrayList* _tmp627_;
											gpointer _tmp628_;
											ValaField* f = NULL;
											ValaGirParserNode* _tmp629_;
											ValaSymbol* _tmp630_;
											ValaField* _tmp631_;
											ValaField* _tmp632_;
											_fn_index = _fn_index + 1;
											if (!(_fn_index < _fn_size)) {
												break;
											}
											_tmp627_ = _fn_list;
											_tmp628_ = vala_list_get ((ValaList*) _tmp627_, _fn_index);
											fn = (ValaGirParserNode*) _tmp628_;
											_tmp629_ = fn;
											_tmp630_ = _tmp629_->symbol;
											_tmp631_ = _vala_code_node_ref0 (VALA_IS_FIELD (_tmp630_) ? ((ValaField*) _tmp630_) : NULL);
											f = _tmp631_;
											_tmp632_ = f;
											if (_tmp632_ != NULL) {
												ValaField* _tmp633_;
												ValaMemberBinding _tmp634_;
												ValaMemberBinding _tmp635_;
												ValaField* _tmp643_;
												ValaSymbol* _tmp644_;
												const gchar* _tmp645_;
												const gchar* _tmp646_;
												ValaField* _tmp647_;
												const gchar* _tmp648_;
												const gchar* _tmp649_;
												gchar* _tmp650_;
												gchar* _tmp651_;
												ValaGirParserNode* _tmp652_;
												ValaField* _tmp653_;
												const gchar* _tmp654_;
												const gchar* _tmp655_;
												gchar* _tmp656_;
												ValaGirParserNode* _tmp657_;
												ValaGirParserNode* _tmp658_;
												_tmp633_ = f;
												_tmp634_ = vala_field_get_binding (_tmp633_);
												_tmp635_ = _tmp634_;
												if (_tmp635_ == VALA_MEMBER_BINDING_INSTANCE) {
													ValaField* _tmp636_;
													const gchar* _tmp637_;
													ValaGirParserNode* _tmp638_;
													gchar* _tmp639_;
													gchar* _tmp640_;
													gchar* _tmp641_;
													gchar* _tmp642_;
													_tmp636_ = f;
													_tmp637_ = self->name;
													_tmp638_ = fn;
													_tmp639_ = vala_gir_parser_node_get_cname (_tmp638_);
													_tmp640_ = _tmp639_;
													_tmp641_ = g_strdup_printf ("%s.%s", _tmp637_, _tmp640_);
													_tmp642_ = _tmp641_;
													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp636_, "CCode", "cname", _tmp642_, NULL);
													_g_free0 (_tmp642_);
													_g_free0 (_tmp640_);
												}
												_tmp643_ = f;
												_tmp644_ = self->symbol;
												_tmp645_ = vala_symbol_get_name (_tmp644_);
												_tmp646_ = _tmp645_;
												_tmp647_ = f;
												_tmp648_ = vala_symbol_get_name ((ValaSymbol*) _tmp647_);
												_tmp649_ = _tmp648_;
												_tmp650_ = g_strdup_printf ("%s_%s", _tmp646_, _tmp649_);
												_tmp651_ = _tmp650_;
												vala_symbol_set_name ((ValaSymbol*) _tmp643_, _tmp651_);
												_g_free0 (_tmp651_);
												_tmp652_ = fn;
												_tmp653_ = f;
												_tmp654_ = vala_symbol_get_name ((ValaSymbol*) _tmp653_);
												_tmp655_ = _tmp654_;
												_tmp656_ = g_strdup (_tmp655_);
												_g_free0 (_tmp652_->name);
												_tmp652_->name = _tmp656_;
												_tmp657_ = self->parent;
												_tmp658_ = fn;
												vala_gir_parser_node_add_member (_tmp657_, _tmp658_);
											}
											_vala_code_node_unref0 (f);
											_vala_gir_parser_node_unref0 (fn);
										}
										_vala_iterable_unref0 (_fn_list);
									}
									self->merged = TRUE;
								} else {
									gchar* gtype_struct_for = NULL;
									ValaMap* _tmp659_;
									gpointer _tmp660_;
									const gchar* _tmp661_;
									_tmp659_ = self->girdata;
									_tmp660_ = vala_map_get (_tmp659_, "glib:is-gtype-struct-for");
									gtype_struct_for = (gchar*) _tmp660_;
									_tmp661_ = gtype_struct_for;
									if (_tmp661_ != NULL) {
										ValaGirParserNode* iface = NULL;
										ValaGirParserNode* _tmp662_;
										const gchar* _tmp663_;
										ValaSourceReference* _tmp664_;
										ValaUnresolvedSymbol* _tmp665_;
										ValaUnresolvedSymbol* _tmp666_;
										ValaGirParserNode* _tmp667_;
										ValaGirParserNode* _tmp668_;
										gboolean _tmp669_ = FALSE;
										gboolean _tmp670_ = FALSE;
										ValaGirParserNode* _tmp671_;
										_tmp662_ = self->parent;
										_tmp663_ = gtype_struct_for;
										_tmp664_ = self->source_reference;
										_tmp665_ = vala_gir_parser_parse_symbol_from_string (parser, _tmp663_, _tmp664_);
										_tmp666_ = _tmp665_;
										_tmp667_ = vala_gir_parser_resolve_node (parser, _tmp662_, _tmp666_, FALSE);
										_tmp668_ = _tmp667_;
										_vala_code_node_unref0 (_tmp666_);
										iface = _tmp668_;
										_tmp671_ = iface;
										if (_tmp671_ != NULL) {
											ValaGirParserNode* _tmp672_;
											ValaSymbol* _tmp673_;
											_tmp672_ = iface;
											_tmp673_ = _tmp672_->symbol;
											_tmp670_ = VALA_IS_INTERFACE (_tmp673_);
										} else {
											_tmp670_ = FALSE;
										}
										if (_tmp670_) {
											ValaGirParserNode* _tmp674_;
											gchar* _tmp675_;
											gchar* _tmp676_;
											gchar* _tmp677_;
											gchar* _tmp678_;
											gchar* _tmp679_;
											gchar* _tmp680_;
											_tmp674_ = iface;
											_tmp675_ = vala_gir_parser_node_get_cname (_tmp674_);
											_tmp676_ = _tmp675_;
											_tmp677_ = g_strdup_printf ("%sIface", _tmp676_);
											_tmp678_ = _tmp677_;
											_tmp679_ = vala_gir_parser_node_get_cname (self);
											_tmp680_ = _tmp679_;
											_tmp669_ = g_strcmp0 (_tmp678_, _tmp680_) != 0;
											_g_free0 (_tmp680_);
											_g_free0 (_tmp678_);
											_g_free0 (_tmp676_);
										} else {
											_tmp669_ = FALSE;
										}
										if (_tmp669_) {
											ValaGirParserNode* _tmp681_;
											ValaSymbol* _tmp682_;
											gchar* _tmp683_;
											gchar* _tmp684_;
											_tmp681_ = iface;
											_tmp682_ = _tmp681_->symbol;
											_tmp683_ = vala_gir_parser_node_get_cname (self);
											_tmp684_ = _tmp683_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp682_, "CCode", "type_cname", _tmp684_, NULL);
											_g_free0 (_tmp684_);
										}
										self->merged = TRUE;
										_vala_gir_parser_node_unref0 (iface);
									}
									_g_free0 (gtype_struct_for);
								}
							}
						}
					}
				}
			}
		}
		_tmp685_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp685_, VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT)) {
			ValaGirParserMetadata* _tmp686_;
			gchar* _tmp687_;
			self->deprecated = TRUE;
			_tmp686_ = self->metadata;
			_tmp687_ = vala_gir_parser_metadata_get_string (_tmp686_, VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT);
			_g_free0 (self->deprecated_replacement);
			self->deprecated_replacement = _tmp687_;
		}
		_tmp688_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp688_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE)) {
			ValaGirParserMetadata* _tmp689_;
			gchar* _tmp690_;
			self->deprecated = TRUE;
			_tmp689_ = self->metadata;
			_tmp690_ = vala_gir_parser_metadata_get_string (_tmp689_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE);
			_g_free0 (self->deprecated_since);
			self->deprecated_since = _tmp690_;
		} else {
			ValaMap* _tmp691_;
			gpointer _tmp692_;
			gchar* _tmp693_;
			gboolean _tmp694_;
			_tmp691_ = self->girdata;
			_tmp692_ = vala_map_get (_tmp691_, "deprecated-version");
			_tmp693_ = (gchar*) _tmp692_;
			_tmp694_ = _tmp693_ != NULL;
			_g_free0 (_tmp693_);
			if (_tmp694_) {
				ValaMap* _tmp695_;
				gpointer _tmp696_;
				self->deprecated = TRUE;
				_tmp695_ = self->girdata;
				_tmp696_ = vala_map_get (_tmp695_, "deprecated-version");
				_g_free0 (self->deprecated_since);
				self->deprecated_since = (gchar*) _tmp696_;
			}
		}
		_tmp697_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp697_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED)) {
			ValaGirParserMetadata* _tmp698_;
			_tmp698_ = self->metadata;
			self->deprecated = vala_gir_parser_metadata_get_bool (_tmp698_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED, TRUE);
			if (!self->deprecated) {
				_g_free0 (self->deprecated_since);
				self->deprecated_since = NULL;
				_g_free0 (self->deprecated_replacement);
				self->deprecated_replacement = NULL;
			}
		} else {
			ValaMap* _tmp699_;
			gpointer _tmp700_;
			gchar* _tmp701_;
			gboolean _tmp702_;
			_tmp699_ = self->girdata;
			_tmp700_ = vala_map_get (_tmp699_, "deprecated");
			_tmp701_ = (gchar*) _tmp700_;
			_tmp702_ = _tmp701_ != NULL;
			_g_free0 (_tmp701_);
			if (_tmp702_) {
				self->deprecated = TRUE;
			}
		}
		_tmp703_ = self->deprecated_since;
		if (_tmp703_ != NULL) {
			const gchar* _tmp704_;
			_tmp704_ = self->deprecated_since;
			self->deprecated_version = vala_gir_parser_node_parse_version_string (_tmp704_);
		}
		_tmp705_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp705_, VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL)) {
			ValaSymbol* _tmp706_;
			ValaGirParserMetadata* _tmp707_;
			_tmp706_ = self->symbol;
			_tmp707_ = self->metadata;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp706_, "Version", "experimental", vala_gir_parser_metadata_get_bool (_tmp707_, VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL, FALSE), NULL);
		}
		_tmp708_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp708_, VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE)) {
			ValaSymbol* _tmp709_;
			ValaVersionAttribute* _tmp710_;
			ValaVersionAttribute* _tmp711_;
			ValaGirParserMetadata* _tmp712_;
			gchar* _tmp713_;
			gchar* _tmp714_;
			_tmp709_ = self->symbol;
			_tmp710_ = vala_symbol_get_version (_tmp709_);
			_tmp711_ = _tmp710_;
			_tmp712_ = self->metadata;
			_tmp713_ = vala_gir_parser_metadata_get_string (_tmp712_, VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE);
			_tmp714_ = _tmp713_;
			vala_version_attribute_set_since (_tmp711_, _tmp714_);
			_g_free0 (_tmp714_);
		} else {
			gboolean _tmp715_ = FALSE;
			ValaSymbol* _tmp716_;
			_tmp716_ = self->symbol;
			if (VALA_IS_NAMESPACE (_tmp716_) == FALSE) {
				ValaMap* _tmp717_;
				gpointer _tmp718_;
				gchar* _tmp719_;
				_tmp717_ = self->girdata;
				_tmp718_ = vala_map_get (_tmp717_, "version");
				_tmp719_ = (gchar*) _tmp718_;
				_tmp715_ = _tmp719_ != NULL;
				_g_free0 (_tmp719_);
			} else {
				_tmp715_ = FALSE;
			}
			if (_tmp715_) {
				ValaSymbol* _tmp720_;
				ValaVersionAttribute* _tmp721_;
				ValaVersionAttribute* _tmp722_;
				ValaMap* _tmp723_;
				gpointer _tmp724_;
				gchar* _tmp725_;
				_tmp720_ = self->symbol;
				_tmp721_ = vala_symbol_get_version (_tmp720_);
				_tmp722_ = _tmp721_;
				_tmp723_ = self->girdata;
				_tmp724_ = vala_map_get (_tmp723_, "version");
				_tmp725_ = (gchar*) _tmp724_;
				vala_version_attribute_set_since (_tmp722_, _tmp725_);
				_g_free0 (_tmp725_);
			}
		}
		_tmp726_ = self->parent;
		_tmp727_ = _tmp726_->symbol;
		if (VALA_IS_NAMESPACE (_tmp727_)) {
			ValaSymbol* _tmp728_;
			gchar* _tmp729_;
			gchar* _tmp730_;
			_tmp728_ = self->symbol;
			_tmp729_ = vala_gir_parser_node_get_cheader_filename (self);
			_tmp730_ = _tmp729_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp728_, "CCode", "cheader_filename", _tmp730_, NULL);
			_g_free0 (_tmp730_);
		} else {
			ValaGirParserMetadata* _tmp731_;
			_tmp731_ = self->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp731_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME)) {
				ValaSymbol* _tmp732_;
				ValaGirParserMetadata* _tmp733_;
				gchar* _tmp734_;
				gchar* _tmp735_;
				_tmp732_ = self->symbol;
				_tmp733_ = self->metadata;
				_tmp734_ = vala_gir_parser_metadata_get_string (_tmp733_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME);
				_tmp735_ = _tmp734_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp732_, "CCode", "cheader_filename", _tmp735_, NULL);
				_g_free0 (_tmp735_);
			}
		}
		_tmp736_ = vala_gir_parser_node_get_cname (self);
		_tmp737_ = _tmp736_;
		_tmp738_ = vala_gir_parser_node_get_default_cname (self);
		_tmp739_ = _tmp738_;
		_tmp740_ = g_strcmp0 (_tmp737_, _tmp739_) != 0;
		_g_free0 (_tmp739_);
		_g_free0 (_tmp737_);
		if (_tmp740_) {
			ValaSymbol* _tmp741_;
			gchar* _tmp742_;
			gchar* _tmp743_;
			_tmp741_ = self->symbol;
			_tmp742_ = vala_gir_parser_node_get_cname (self);
			_tmp743_ = _tmp742_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp741_, "CCode", "cname", _tmp743_, NULL);
			_g_free0 (_tmp743_);
		}
		_tmp744_ = vala_gir_parser_node_get_lower_case_cprefix (self);
		_tmp745_ = _tmp744_;
		_tmp746_ = vala_gir_parser_node_get_default_lower_case_cprefix (self);
		_tmp747_ = _tmp746_;
		_tmp748_ = g_strcmp0 (_tmp745_, _tmp747_) != 0;
		_g_free0 (_tmp747_);
		_g_free0 (_tmp745_);
		if (_tmp748_) {
			ValaSymbol* _tmp749_;
			gchar* _tmp750_;
			gchar* _tmp751_;
			_tmp749_ = self->symbol;
			_tmp750_ = vala_gir_parser_node_get_lower_case_cprefix (self);
			_tmp751_ = _tmp750_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp749_, "CCode", "lower_case_cprefix", _tmp751_, NULL);
			_g_free0 (_tmp751_);
		}
		_tmp752_ = vala_gir_parser_node_get_lower_case_csuffix (self);
		_tmp753_ = _tmp752_;
		_tmp754_ = vala_gir_parser_node_get_default_lower_case_csuffix (self);
		_tmp755_ = _tmp754_;
		_tmp756_ = g_strcmp0 (_tmp753_, _tmp755_) != 0;
		_g_free0 (_tmp755_);
		_g_free0 (_tmp753_);
		if (_tmp756_) {
			ValaSymbol* _tmp757_;
			gchar* _tmp758_;
			gchar* _tmp759_;
			_tmp757_ = self->symbol;
			_tmp758_ = vala_gir_parser_node_get_lower_case_csuffix (self);
			_tmp759_ = _tmp758_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp757_, "CCode", "lower_case_csuffix", _tmp759_, NULL);
			_g_free0 (_tmp759_);
		}
		_tmp760_ = vala_gir_parser_node_get_gir_name (self);
		gir_name = _tmp760_;
		_tmp761_ = vala_gir_parser_node_get_default_gir_name (self);
		default_gir_name = _tmp761_;
		_tmp764_ = self->symbol;
		if (vala_gir_parser_is_container (_tmp764_)) {
			ValaSymbol* _tmp765_;
			_tmp765_ = self->symbol;
			_tmp763_ = !VALA_IS_NAMESPACE (_tmp765_);
		} else {
			_tmp763_ = FALSE;
		}
		if (_tmp763_) {
			gboolean _tmp766_ = FALSE;
			const gchar* _tmp767_;
			const gchar* _tmp768_;
			_tmp767_ = self->name;
			_tmp768_ = gir_name;
			if (g_strcmp0 (_tmp767_, _tmp768_) != 0) {
				_tmp766_ = TRUE;
			} else {
				const gchar* _tmp769_;
				const gchar* _tmp770_;
				_tmp769_ = gir_name;
				_tmp770_ = default_gir_name;
				_tmp766_ = g_strcmp0 (_tmp769_, _tmp770_) != 0;
			}
			_tmp762_ = _tmp766_;
		} else {
			_tmp762_ = FALSE;
		}
		if (_tmp762_) {
			ValaSymbol* _tmp771_;
			const gchar* _tmp772_;
			_tmp771_ = self->symbol;
			_tmp772_ = gir_name;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp771_, "GIR", "name", _tmp772_, NULL);
		}
		_g_free0 (default_gir_name);
		_g_free0 (gir_name);
	}
	if (self->new_symbol) {
		_tmp774_ = self->merged;
	} else {
		_tmp774_ = FALSE;
	}
	if (!_tmp774_) {
		ValaSymbol* _tmp775_;
		_tmp775_ = self->symbol;
		_tmp773_ = vala_gir_parser_is_container (_tmp775_);
	} else {
		_tmp773_ = FALSE;
	}
	if (_tmp773_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp818_;
		ValaClass* _tmp819_;
		gboolean _tmp820_ = FALSE;
		gboolean _tmp821_ = FALSE;
		ValaClass* _tmp822_;
		{
			ValaArrayList* _node_list = NULL;
			ValaArrayList* _tmp776_;
			ValaArrayList* _tmp777_;
			gint _node_size = 0;
			ValaArrayList* _tmp778_;
			gint _tmp779_;
			gint _tmp780_;
			gint _node_index = 0;
			_tmp776_ = self->members;
			_tmp777_ = _vala_iterable_ref0 (_tmp776_);
			_node_list = _tmp777_;
			_tmp778_ = _node_list;
			_tmp779_ = vala_collection_get_size ((ValaCollection*) _tmp778_);
			_tmp780_ = _tmp779_;
			_node_size = _tmp780_;
			_node_index = -1;
			while (TRUE) {
				ValaGirParserNode* node = NULL;
				ValaArrayList* _tmp781_;
				gpointer _tmp782_;
				gboolean _tmp783_ = FALSE;
				ValaGirParserNode* _tmp789_;
				ValaGirParserNode* _tmp794_;
				const gchar* _tmp795_;
				ValaGirParserNode* _tmp802_;
				const gchar* _tmp803_;
				gboolean _tmp810_ = FALSE;
				gboolean _tmp811_ = FALSE;
				ValaGirParserNode* _tmp812_;
				_node_index = _node_index + 1;
				if (!(_node_index < _node_size)) {
					break;
				}
				_tmp781_ = _node_list;
				_tmp782_ = vala_list_get ((ValaList*) _tmp781_, _node_index);
				node = (ValaGirParserNode*) _tmp782_;
				if (self->deprecated_version > ((guint64) 0)) {
					ValaGirParserNode* _tmp784_;
					_tmp784_ = node;
					_tmp783_ = _tmp784_->deprecated_version > ((guint64) 0);
				} else {
					_tmp783_ = FALSE;
				}
				if (_tmp783_) {
					ValaGirParserNode* _tmp785_;
					_tmp785_ = node;
					if (self->deprecated_version <= _tmp785_->deprecated_version) {
						ValaGirParserNode* _tmp786_;
						ValaGirParserNode* _tmp787_;
						ValaGirParserNode* _tmp788_;
						_tmp786_ = node;
						_tmp786_->deprecated = FALSE;
						_tmp787_ = node;
						_g_free0 (_tmp787_->deprecated_since);
						_tmp787_->deprecated_since = NULL;
						_tmp788_ = node;
						_g_free0 (_tmp788_->deprecated_replacement);
						_tmp788_->deprecated_replacement = NULL;
					}
				}
				_tmp789_ = node;
				if (_tmp789_->deprecated) {
					ValaGirParserNode* _tmp790_;
					ValaSymbol* _tmp791_;
					ValaVersionAttribute* _tmp792_;
					ValaVersionAttribute* _tmp793_;
					_tmp790_ = node;
					_tmp791_ = _tmp790_->symbol;
					_tmp792_ = vala_symbol_get_version (_tmp791_);
					_tmp793_ = _tmp792_;
					vala_version_attribute_set_deprecated (_tmp793_, TRUE);
				}
				_tmp794_ = node;
				_tmp795_ = _tmp794_->deprecated_since;
				if (_tmp795_ != NULL) {
					ValaGirParserNode* _tmp796_;
					ValaSymbol* _tmp797_;
					ValaVersionAttribute* _tmp798_;
					ValaVersionAttribute* _tmp799_;
					ValaGirParserNode* _tmp800_;
					const gchar* _tmp801_;
					_tmp796_ = node;
					_tmp797_ = _tmp796_->symbol;
					_tmp798_ = vala_symbol_get_version (_tmp797_);
					_tmp799_ = _tmp798_;
					_tmp800_ = node;
					_tmp801_ = _tmp800_->deprecated_since;
					vala_version_attribute_set_deprecated_since (_tmp799_, _tmp801_);
				}
				_tmp802_ = node;
				_tmp803_ = _tmp802_->deprecated_replacement;
				if (_tmp803_ != NULL) {
					ValaGirParserNode* _tmp804_;
					ValaSymbol* _tmp805_;
					ValaVersionAttribute* _tmp806_;
					ValaVersionAttribute* _tmp807_;
					ValaGirParserNode* _tmp808_;
					const gchar* _tmp809_;
					_tmp804_ = node;
					_tmp805_ = _tmp804_->symbol;
					_tmp806_ = vala_symbol_get_version (_tmp805_);
					_tmp807_ = _tmp806_;
					_tmp808_ = node;
					_tmp809_ = _tmp808_->deprecated_replacement;
					vala_version_attribute_set_replacement (_tmp807_, _tmp809_);
				}
				_tmp812_ = node;
				if (_tmp812_->new_symbol) {
					ValaGirParserNode* _tmp813_;
					_tmp813_ = node;
					_tmp811_ = !_tmp813_->merged;
				} else {
					_tmp811_ = FALSE;
				}
				if (_tmp811_) {
					ValaGirParserMetadata* _tmp814_;
					_tmp814_ = self->metadata;
					_tmp810_ = !vala_gir_parser_metadata_get_bool (_tmp814_, VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN, FALSE);
				} else {
					_tmp810_ = FALSE;
				}
				if (_tmp810_) {
					ValaSymbol* _tmp815_;
					ValaGirParserNode* _tmp816_;
					ValaSymbol* _tmp817_;
					_tmp815_ = self->symbol;
					_tmp816_ = node;
					_tmp817_ = _tmp816_->symbol;
					vala_gir_parser_add_symbol_to_container (_tmp815_, _tmp817_);
				}
				_vala_gir_parser_node_unref0 (node);
			}
			_vala_iterable_unref0 (_node_list);
		}
		_tmp818_ = self->symbol;
		_tmp819_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp818_) ? ((ValaClass*) _tmp818_) : NULL);
		cl = _tmp819_;
		_tmp822_ = cl;
		if (_tmp822_ != NULL) {
			ValaClass* _tmp823_;
			gboolean _tmp824_;
			gboolean _tmp825_;
			_tmp823_ = cl;
			_tmp824_ = vala_class_get_is_compact (_tmp823_);
			_tmp825_ = _tmp824_;
			_tmp821_ = !_tmp825_;
		} else {
			_tmp821_ = FALSE;
		}
		if (_tmp821_) {
			ValaClass* _tmp826_;
			ValaCreationMethod* _tmp827_;
			ValaCreationMethod* _tmp828_;
			_tmp826_ = cl;
			_tmp827_ = vala_class_get_default_construction_method (_tmp826_);
			_tmp828_ = _tmp827_;
			_tmp820_ = _tmp828_ == NULL;
		} else {
			_tmp820_ = FALSE;
		}
		if (_tmp820_) {
			ValaCreationMethod* cm = NULL;
			ValaClass* _tmp829_;
			ValaSourceReference* _tmp830_;
			ValaSourceReference* _tmp831_;
			ValaCreationMethod* _tmp832_;
			ValaCreationMethod* _tmp833_;
			ValaCreationMethod* _tmp834_;
			ValaClass* _tmp835_;
			ValaCreationMethod* _tmp836_;
			_tmp829_ = cl;
			_tmp830_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp829_);
			_tmp831_ = _tmp830_;
			_tmp832_ = vala_creation_method_new (NULL, NULL, _tmp831_, NULL);
			cm = _tmp832_;
			_tmp833_ = cm;
			vala_method_set_has_construct_function ((ValaMethod*) _tmp833_, FALSE);
			_tmp834_ = cm;
			vala_symbol_set_access ((ValaSymbol*) _tmp834_, VALA_SYMBOL_ACCESSIBILITY_PROTECTED);
			_tmp835_ = cl;
			_tmp836_ = cm;
			vala_symbol_add_method ((ValaSymbol*) _tmp835_, (ValaMethod*) _tmp836_);
			_vala_code_node_unref0 (cm);
		}
		_vala_code_node_unref0 (cl);
	}
	self->processed = TRUE;
}

static gchar*
vala_gir_parser_node_to_string (ValaGirParserNode* self)
{
	ValaGirParserNode* _tmp0_;
	const gchar* _tmp1_;
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	_tmp1_ = _tmp0_->name;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->name;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	} else {
		ValaGirParserNode* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp4_ = self->parent;
		_tmp5_ = vala_gir_parser_node_to_string (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->name;
		_tmp8_ = g_strdup_printf ("%s.%s", _tmp6_, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp6_);
		result = _tmp9_;
		return result;
	}
}

static void
vala_gir_parser_value_node_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_gir_parser_value_node_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_node_unref (value->data[0].v_pointer);
	}
}

static void
vala_gir_parser_value_node_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_gir_parser_value_node_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_gir_parser_value_node_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserNode * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_gir_parser_value_node_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	ValaGirParserNode ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_node_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
vala_gir_parser_param_spec_node (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	ValaGirParserParamSpecNode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
vala_gir_parser_value_get_node (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_NODE), NULL);
	return value->data[0].v_pointer;
}

static void
vala_gir_parser_value_set_node (GValue* value,
                                gpointer v_object)
{
	ValaGirParserNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_node_unref (old);
	}
}

static void
vala_gir_parser_value_take_node (GValue* value,
                                 gpointer v_object)
{
	ValaGirParserNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_node_unref (old);
	}
}

static void
vala_gir_parser_node_class_init (ValaGirParserNodeClass * klass,
                                 gpointer klass_data)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	vala_gir_parser_node_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserNodeClass *) klass)->finalize = vala_gir_parser_node_finalize;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp0_);
	vala_gir_parser_node_new_namespaces = _tmp1_;
}

static void
vala_gir_parser_node_instance_init (ValaGirParserNode * self,
                                    gpointer klass)
{
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GEqualFunc _tmp7_;
	ValaHashMap* _tmp8_;
	self->girdata = NULL;
	_tmp0_ = vala_gir_parser_metadata_get_empty ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_gir_parser_metadata_ref0 (_tmp1_);
	self->metadata = _tmp2_;
	self->source_reference = NULL;
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp3_);
	self->members = _tmp4_;
	_tmp5_ = g_str_hash;
	_tmp6_ = g_str_equal;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_ARRAY_LIST, (GBoxedCopyFunc) vala_iterable_ref, (GDestroyNotify) vala_iterable_unref, _tmp5_, _tmp6_, _tmp7_);
	self->scope = _tmp8_;
	self->return_array_length_idx = -1;
	self->array_length_idx = -1;
	self->deprecated = FALSE;
	self->deprecated_version = (guint64) 0;
	self->deprecated_since = NULL;
	self->deprecated_replacement = NULL;
	self->ref_count = 1;
}

static void
vala_gir_parser_node_finalize (ValaGirParserNode * obj)
{
	ValaGirParserNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNode);
	g_signal_handlers_destroy (self);
	_g_free0 (self->element_type);
	_g_free0 (self->name);
	_vala_map_unref0 (self->girdata);
	_vala_gir_parser_metadata_unref0 (self->metadata);
	_vala_source_reference_unref0 (self->source_reference);
	_vala_iterable_unref0 (self->members);
	_vala_map_unref0 (self->scope);
	_vala_comment_unref0 (self->comment);
	_vala_code_node_unref0 (self->symbol);
	_vala_iterable_unref0 (self->parameters);
	_vala_iterable_unref0 (self->array_length_parameters);
	_vala_iterable_unref0 (self->closure_parameters);
	_vala_iterable_unref0 (self->destroy_parameters);
	_vala_code_node_unref0 (self->gtype_struct_for);
	_vala_code_node_unref0 (self->base_type);
	_g_free0 (self->deprecated_since);
	_g_free0 (self->deprecated_replacement);
}

static GType
vala_gir_parser_node_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_node_init, vala_gir_parser_value_node_free_value, vala_gir_parser_value_node_copy_value, vala_gir_parser_value_node_peek_pointer, "p", vala_gir_parser_value_node_collect_value, "p", vala_gir_parser_value_node_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserNode), 0, (GInstanceInitFunc) vala_gir_parser_node_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_gir_parser_node_type_id;
	vala_gir_parser_node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserNode", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return vala_gir_parser_node_type_id;
}

static GType
vala_gir_parser_node_get_type (void)
{
	static volatile gsize vala_gir_parser_node_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_node_type_id__volatile)) {
		GType vala_gir_parser_node_type_id;
		vala_gir_parser_node_type_id = vala_gir_parser_node_get_type_once ();
		g_once_init_leave (&vala_gir_parser_node_type_id__volatile, vala_gir_parser_node_type_id);
	}
	return vala_gir_parser_node_type_id__volatile;
}

static gpointer
vala_gir_parser_node_ref (gpointer instance)
{
	ValaGirParserNode * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
vala_gir_parser_node_unref (gpointer instance)
{
	ValaGirParserNode * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static ValaGirParserParameterInfo*
vala_gir_parser_parameter_info_construct (GType object_type,
                                          ValaParameter* param,
                                          gint array_length_idx,
                                          gint closure_idx,
                                          gint destroy_idx,
                                          gboolean is_async)
{
	ValaGirParserParameterInfo* self = NULL;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (param != NULL, NULL);
	self = (ValaGirParserParameterInfo*) g_type_create_instance (object_type);
	_tmp0_ = _vala_code_node_ref0 (param);
	_vala_code_node_unref0 (self->param);
	self->param = _tmp0_;
	self->array_length_idx = array_length_idx;
	self->closure_idx = closure_idx;
	self->destroy_idx = destroy_idx;
	self->vala_idx = 0.0F;
	self->keep = TRUE;
	self->is_async = is_async;
	return self;
}

static ValaGirParserParameterInfo*
vala_gir_parser_parameter_info_new (ValaParameter* param,
                                    gint array_length_idx,
                                    gint closure_idx,
                                    gint destroy_idx,
                                    gboolean is_async)
{
	return vala_gir_parser_parameter_info_construct (VALA_GIR_PARSER_TYPE_PARAMETER_INFO, param, array_length_idx, closure_idx, destroy_idx, is_async);
}

static void
vala_gir_parser_value_parameter_info_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
vala_gir_parser_value_parameter_info_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_parameter_info_unref (value->data[0].v_pointer);
	}
}

static void
vala_gir_parser_value_parameter_info_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_parameter_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
vala_gir_parser_value_parameter_info_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
vala_gir_parser_value_parameter_info_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserParameterInfo * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_parameter_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
vala_gir_parser_value_parameter_info_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	ValaGirParserParameterInfo ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_parameter_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
vala_gir_parser_param_spec_parameter_info (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	ValaGirParserParamSpecParameterInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_PARAMETER_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
vala_gir_parser_value_get_parameter_info (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_PARAMETER_INFO), NULL);
	return value->data[0].v_pointer;
}

static void
vala_gir_parser_value_set_parameter_info (GValue* value,
                                          gpointer v_object)
{
	ValaGirParserParameterInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_parameter_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_parameter_info_unref (old);
	}
}

static void
vala_gir_parser_value_take_parameter_info (GValue* value,
                                           gpointer v_object)
{
	ValaGirParserParameterInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_parameter_info_unref (old);
	}
}

static void
vala_gir_parser_parameter_info_class_init (ValaGirParserParameterInfoClass * klass,
                                           gpointer klass_data)
{
	vala_gir_parser_parameter_info_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserParameterInfoClass *) klass)->finalize = vala_gir_parser_parameter_info_finalize;
}

static void
vala_gir_parser_parameter_info_instance_init (ValaGirParserParameterInfo * self,
                                              gpointer klass)
{
	self->ref_count = 1;
}

static void
vala_gir_parser_parameter_info_finalize (ValaGirParserParameterInfo * obj)
{
	ValaGirParserParameterInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfo);
	g_signal_handlers_destroy (self);
	_vala_code_node_unref0 (self->param);
}

static GType
vala_gir_parser_parameter_info_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_parameter_info_init, vala_gir_parser_value_parameter_info_free_value, vala_gir_parser_value_parameter_info_copy_value, vala_gir_parser_value_parameter_info_peek_pointer, "p", vala_gir_parser_value_parameter_info_collect_value, "p", vala_gir_parser_value_parameter_info_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserParameterInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_parameter_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserParameterInfo), 0, (GInstanceInitFunc) vala_gir_parser_parameter_info_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType vala_gir_parser_parameter_info_type_id;
	vala_gir_parser_parameter_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserParameterInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return vala_gir_parser_parameter_info_type_id;
}

static GType
vala_gir_parser_parameter_info_get_type (void)
{
	static volatile gsize vala_gir_parser_parameter_info_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_parameter_info_type_id__volatile)) {
		GType vala_gir_parser_parameter_info_type_id;
		vala_gir_parser_parameter_info_type_id = vala_gir_parser_parameter_info_get_type_once ();
		g_once_init_leave (&vala_gir_parser_parameter_info_type_id__volatile, vala_gir_parser_parameter_info_type_id);
	}
	return vala_gir_parser_parameter_info_type_id__volatile;
}

static gpointer
vala_gir_parser_parameter_info_ref (gpointer instance)
{
	ValaGirParserParameterInfo * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
vala_gir_parser_parameter_info_unref (gpointer instance)
{
	ValaGirParserParameterInfo * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_PARAMETER_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
vala_gir_parser_class_init (ValaGirParserClass * klass,
                            gpointer klass_data)
{
	vala_gir_parser_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gir_parser_finalize;
	g_type_class_adjust_private_offset (klass, &ValaGirParser_private_offset);
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*) (ValaCodeVisitor*, ValaSourceFile*)) vala_gir_parser_real_visit_source_file;
}

static void
vala_gir_parser_instance_init (ValaGirParser * self,
                               gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	ValaHashSet* _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashMap* _tmp6_;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	GHashFunc _tmp9_;
	GEqualFunc _tmp10_;
	GEqualFunc _tmp11_;
	ValaHashMap* _tmp12_;
	GEqualFunc _tmp13_;
	ValaArrayList* _tmp14_;
	self->priv = vala_gir_parser_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_METADATA, (GBoxedCopyFunc) vala_gir_parser_metadata_ref, (GDestroyNotify) vala_gir_parser_metadata_unref, _tmp0_);
	self->priv->metadata_roots = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp2_, _tmp3_);
	self->priv->provided_namespaces = (ValaSet*) _tmp4_;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_hash_map_new (VALA_TYPE_UNRESOLVED_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _vala_gir_parser_unresolved_symbol_hash_ghash_func, _vala_gir_parser_unresolved_symbol_equal_gequal_func, _tmp5_);
	self->priv->unresolved_symbols_map = _tmp6_;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_UNRESOLVED_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp7_);
	self->priv->unresolved_gir_symbols = _tmp8_;
	_tmp9_ = g_direct_hash;
	_tmp10_ = g_direct_equal;
	_tmp11_ = g_direct_equal;
	_tmp12_ = vala_hash_map_new (VALA_TYPE_UNRESOLVED_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp9_, _tmp10_, _tmp11_);
	self->priv->unresolved_type_arguments = _tmp12_;
	_tmp13_ = g_direct_equal;
	_tmp14_ = vala_array_list_new (VALA_TYPE_INTERFACE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp13_);
	self->priv->ifaces_needing_object_prereq = _tmp14_;
}

static void
vala_gir_parser_finalize (ValaCodeVisitor * obj)
{
	ValaGirParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GIR_PARSER, ValaGirParser);
	_vala_markup_reader_unref0 (self->priv->reader);
	_vala_code_context_unref0 (self->priv->context);
	_vala_source_file_unref0 (self->priv->current_source_file);
	_vala_gir_parser_node_unref0 (self->priv->root);
	_vala_iterable_unref0 (self->priv->metadata_roots);
	self->priv->cheader_filenames = (_vala_array_free (self->priv->cheader_filenames, self->priv->cheader_filenames_length1, (GDestroyNotify) g_free), NULL);
	_vala_iterable_unref0 (self->priv->metadata_stack);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	_vala_iterable_unref0 (self->priv->tree_stack);
	_vala_gir_parser_node_unref0 (self->priv->current);
	_vala_gir_parser_node_unref0 (self->priv->old_current);
	_vala_iterable_unref0 (self->priv->provided_namespaces);
	_vala_map_unref0 (self->priv->unresolved_symbols_map);
	_vala_iterable_unref0 (self->priv->unresolved_gir_symbols);
	_vala_map_unref0 (self->priv->unresolved_type_arguments);
	_vala_iterable_unref0 (self->priv->ifaces_needing_object_prereq);
	VALA_CODE_VISITOR_CLASS (vala_gir_parser_parent_class)->finalize (obj);
}

/**
 * Code visitor parsing all GIR source files.
 *
 * Pipeline:
 * 1) Parse metadata
 * 2) Parse GIR with metadata, track unresolved GIR symbols, create Vala symbols
 * 3) Reconciliate the tree by mapping tracked symbols
 * 4) Process the tree
 */
static GType
vala_gir_parser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParser), 0, (GInstanceInitFunc) vala_gir_parser_instance_init, NULL };
	GType vala_gir_parser_type_id;
	vala_gir_parser_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGirParser", &g_define_type_info, 0);
	ValaGirParser_private_offset = g_type_add_instance_private (vala_gir_parser_type_id, sizeof (ValaGirParserPrivate));
	return vala_gir_parser_type_id;
}

GType
vala_gir_parser_get_type (void)
{
	static volatile gsize vala_gir_parser_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_type_id__volatile)) {
		GType vala_gir_parser_type_id;
		vala_gir_parser_type_id = vala_gir_parser_get_type_once ();
		g_once_init_leave (&vala_gir_parser_type_id__volatile, vala_gir_parser_type_id);
	}
	return vala_gir_parser_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

