#include <algorithm>
#include <vector>

#include "atlas/grid.h"
#include "atlas/option.h"
#include "atlas/util/Config.h"
#include "tests/AtlasTestEnvironment.h"

using namespace atlas::util;
using namespace atlas::grid;

namespace {

const double lonlat_arp_t32c24[] = {
    1.99999999999999600, 44.93291171299576092,
    2.77237262934735273, 45.01674523281888440,
    3.47555862489311007, 45.26073815098433784,
    4.04494770792090641, 45.64287023699112211,
    4.42528132740345281, 46.12813070368466839,
    4.57569351104372046, 46.67109320702403608,
    4.47479391972813190, 47.21956618120344018,
    4.12512266986032206, 47.71926346185548340,
    3.55581027759415491, 48.11926090196744354,
    2.82200931024728874, 48.37772379915030996,
    1.99999999999999556, 48.46708828700425187,
    1.17799068975270305, 48.37772379915030996,
    0.44418972240583693, 48.11926090196744354,
    -0.12512266986032983, 47.71926346185548340,
    -0.47479391972814028, 47.21956618120344018,
    -0.57569351104372879, 46.67109320702403608,
    -0.42528132740346147, 46.12813070368466839,
    -0.04494770792091433, 45.64287023699112211,
    0.52444137510688182, 45.26073815098433784,
    1.22762737065263883, 45.01674523281888440,
    1.99999999999999556, 42.63725270983827897,
    3.27473332072834422, 42.73934376403467184,
    4.49349321557291415, 43.04109625964867547,
    5.60127364516099924, 43.52904513460186564,
    6.54514794659825672, 44.18107605134951399,
    7.27568782798168190, 44.96693492678289061,
    7.74887351496657040, 45.84898874281991965,
    7.92867515230084408, 46.78330526703850012,
    7.79040894364469949, 47.72115423047301164,
    7.32476598915540844, 48.61105462603097038,
    6.54204071489340944, 49.40147266886311428,
    5.47559260124316793, 50.04417716102324221,
    4.18315343237871584, 50.49806364409691639,
    2.74458547194322389, 50.73299668020899134,
    1.25541452805676457, 50.73299668020899134,
    -0.18315343237872406, 50.49806364409691639,
    -1.47559260124317815, 50.04417716102324221,
    -2.54204071489341921, 49.40147266886311428,
    -3.32476598915541599, 48.61105462603097038,
    -3.79040894364470748, 47.72115423047301164,
    -3.92867515230085296, 46.78330526703850012,
    -3.74887351496657928, 45.84898874281991965,
    -3.27568782798168812, 44.96693492678289061,
    -2.54514794659826427, 44.18107605134951399,
    -1.60127364516100812, 43.52904513460186564,
    -0.49349321557292075, 43.04109625964867547,
    0.72526667927164967, 42.73934376403467184,
    1.99999999999999556, 40.31236211945285675,
    3.63376292032076975, 40.42261301497919845,
    5.22173788476928014, 40.75019560382368411,
    6.71826031811739099, 41.28563184510834105,
    8.07794770476515467, 42.01322983391511201,
    9.25594876339864392, 42.91123363953519743,
    10.20837670733705771, 43.95202523375940729,
    10.89307303713296271, 45.10238649522262477,
    11.27090590027328432, 46.32385288536406875,
    11.30784824781773779, 47.57322688923063225,
    10.97806564551987840, 48.80336562297891589,
    10.26810804950859612, 49.96440199105025926,
    9.18197003975669723, 51.00557820511744467,
    7.74622775989939338, 51.87782553848720823,
    6.01378910799337074, 52.53707313311167582,
    4.06435502534209725, 52.94800110445672203,
    1.99999999999999600, 53.08763788054714894,
    -0.06435502534210560, 52.94800110445672203,
    -2.01378910799337962, 52.53707313311167582,
    -3.74622775989940182, 51.87782553848720823,
    -5.18197003975670256, 51.00557820511744467,
    -6.26810804950860057, 49.96440199105025926,
    -6.97806564551988551, 48.80336562297891589,
    -7.30784824781774667, 47.57322688923063225,
    -7.27090590027329498, 46.32385288536406875,
    -6.89307303713297248, 45.10238649522262477,
    -6.20837670733706481, 43.95202523375940729,
    -5.25594876339865458, 42.91123363953519743,
    -4.07794770476516355, 42.01322983391511201,
    -2.71826031811739988, 41.28563184510834105,
    -1.22173788476928813, 40.75019560382368411,
    0.36623707967922192, 40.42261301497919845,
    1.99999999999999600, 37.95945956416753120,
    3.72994195085756930, 38.05275970261258323,
    5.43190111561111433, 38.33106975566338548,
    7.07783882564464850, 38.78962916423042628,
    8.63959771096107509, 39.42053684981195261,
    10.08882962579568954, 40.21279467492543347,
    11.39692139773956114, 41.15235690381517486,
    12.53494002107632888, 42.22217718966415845,
    13.47363915243209043, 43.40224634648851065,
    14.18359521918176469, 44.66961909752426152,
    14.63557388477568644, 45.99843704779454612,
    14.80126342211737089, 47.35996933207513848,
    14.65454278958190670, 48.72271255422421632,
    14.17346129570704250, 50.05261748260089405,
    13.34306219743110233, 51.31353838046217675,
    12.15903975007321236, 52.46802323745790630,
    10.63193584333677499, 53.47856301011842106,
    8.79116029542177024, 54.30937174533021761,
    6.68766853851381526, 54.92865613654313961,
    4.39391037845720334, 55.31115535850048559,
    1.99999999999999600, 55.44054043583248159,
    -0.39391037845721066, 55.31115535850048559,
    -2.68766853851382415, 54.92865613654313961,
    -4.79116029542177646, 54.30937174533021761,
    -6.63193584333678299, 53.47856301011842106,
    -8.15903975007321947, 52.46802323745790630,
    -9.34306219743110766, 51.31353838046217675,
    -10.17346129570704960, 50.05261748260089405,
    -10.65454278958191559, 48.72271255422421632,
    -10.80126342211738155, 47.35996933207513848,
    -10.63557388477569354, 45.99843704779454612,
    -10.18359521918177357, 44.66961909752426152,
    -9.47363915243210286, 43.40224634648851065,
    -8.53494002107633776, 42.22217718966415845,
    -7.39692139773957003, 41.15235690381517486,
    -6.08882962579569842, 40.21279467492543347,
    -4.63959771096108220, 39.42053684981195261,
    -3.07783882564465516, 38.78962916423042628,
    -1.43190111561112299, 38.33106975566338548,
    0.27005804914242265, 38.05275970261258323,
    1.99999999999999600, 35.57084905987729684,
    3.89475329148972449, 35.66164776728690811,
    5.76748883913266752, 35.93289207465146262,
    7.59612881396671380, 36.38113516165864070,
    9.35846198524136241, 37.00065953311393940,
    11.03204592267791284, 37.78351258180431671,
    12.59407748901272228, 38.71954642363609622,
    14.02123063562953753, 39.79645326718445375,
    15.28946940417034384, 40.99978674800681233,
    16.37385639149118433, 42.31296002482778107,
    17.24839405994832120, 43.71721334442865725,
    17.88595991605807711, 45.19154778206701195,
    18.25842850603561374, 46.71262882888417067,
    18.33711398818940452, 48.25467471095996785,
    18.09371358173445188, 49.78936139305309894,
    17.50197280996727400, 51.28580055994029152,
    16.54030106040206149, 52.71067834344860614,
    15.19549149366584473, 54.02867680201524081,
    13.46747450557555048, 55.20332460427978560,
    11.37460140494845717, 56.19841400024800038,
    8.95834334902436602, 56.98004544675784899,
    6.28571777452580616, 57.51919556269155720,
    3.44765611568870733, 57.79446760315521914,
    0.55234388431128512, 57.79446760315521914,
    -2.28571777452581371, 57.51919556269155720,
    -4.95834334902437313, 56.98004544675784899,
    -7.37460140494846428, 56.19841400024800038,
    -9.46747450557555759, 55.20332460427978560,
    -11.19549149366585006, 54.02867680201524081,
    -12.54030106040206860, 52.71067834344860614,
    -13.50197280996728288, 51.28580055994029152,
    -14.09371358173445721, 49.78936139305309894,
    -14.33711398818941340, 48.25467471095996785,
    -14.25842850603561907, 46.71262882888417067,
    -13.88595991605808244, 45.19154778206701195,
    -13.24839405994833008, 43.71721334442865725,
    -12.37385639149119498, 42.31296002482778107,
    -11.28946940417035272, 40.99978674800681233,
    -10.02123063562954464, 39.79645326718445375,
    -8.59407748901273116, 38.71954642363609622,
    -7.03204592267792172, 37.78351258180431671,
    -5.35846198524136952, 37.00065953311393940,
    -3.59612881396672091, 36.38113516165864070,
    -1.76748883913267574, 35.93289207465146262,
    0.10524670851026705, 35.66164776728690811,
    1.99999999999999600, 33.13704588354342917,
    4.09718755711548610, 33.23124463343540214,
    6.17473678976558027, 33.51283479810019372,
    8.21297051898842767, 33.97880825794451454,
    10.19211732580419394, 34.62418375193038855,
    12.09222434325374529, 35.44205010622848562,
    13.89302536639832120, 36.42361680044041350,
    15.57375501535205942, 37.55826279697889447,
    17.11290455740948246, 38.83357308646102268,
    18.48792157318536056, 40.23535159216240942,
    19.67486490585671888, 41.74759899443786537,
    20.64804001511417653, 43.35244484209054860,
    21.37966075266355404, 45.03002540480565585,
    21.83961562141898582, 46.75830290430587155,
    21.99546453290828296, 48.51282952087984768,
    21.81285996059914467, 50.26647329190694080,
    21.25667322722224029, 51.98914605534769606,
    20.29319722451073105, 53.64760968250063655,
    18.89384545876525578, 55.20548791890712437,
    17.04067793585433321, 56.62367212326139310,
    14.73370655373201643, 57.86135900031617751,
    11.99912115224313958, 58.87795079119066344,
    8.89637618755807047, 59.63591573610307250,
    5.52099396835736211, 60.10440004572244277,
    1.99999999999999645, 60.26295411645657651,
    -1.52099396835736900, 60.10440004572244277,
    -4.89637618755807846, 59.63591573610307250,
    -7.99912115224314757, 58.87795079119066344,
    -10.73370655373202531, 57.86135900031617751,
    -13.04067793585434032, 56.62367212326139310,
    -14.89384545876526467, 55.20548791890712437,
    -16.29319722451073460, 53.64760968250063655,
    -17.25667322722224739, 51.98914605534769606,
    -17.81285996059915178, 50.26647329190694080,
    -17.99546453290829362, 48.51282952087984768,
    -17.83961562141899648, 46.75830290430587155,
    -17.37966075266356114, 45.03002540480565585,
    -16.64804001511417653, 43.35244484209054860,
    -15.67486490585672598, 41.74759899443786537,
    -14.48792157318536944, 40.23535159216240942,
    -13.11290455740949135, 38.83357308646102268,
    -11.57375501535207007, 37.55826279697889447,
    -9.89302536639833185, 36.42361680044041350,
    -8.09222434325375239, 35.44205010622848562,
    -6.19211732580420193, 34.62418375193038855,
    -4.21297051898843566, 33.97880825794451454,
    -2.17473678976558960, 33.51283479810019372,
    -0.09718755711549353, 33.23124463343540214,
    1.99999999999999600, 30.64757019281734074,
    3.92669240244598505, 30.71678191817960268,
    5.84270801296843700, 30.92395598105918353,
    7.73736939611796171, 31.26771342119434749,
    9.59999239238874047, 31.74577019145994683,
    11.41986936545086984, 32.35495718584155611,
    13.18623692372253586, 33.09124574576952682,
    14.88822378743806851, 33.94977626735131793,
    16.51477509868480453, 34.92488704934376642,
    18.05455017155122732, 36.01014014726423795,
    19.49579145727240714, 37.19834072287546434,
    20.82616341777591984, 38.48154618161253637,
    22.03256121225549435, 39.85106125278488065,
    23.10089088783405131, 41.29741507659190347,
    24.01582559662802652, 42.81031632956308641,
    24.76054697060166987, 44.37858250245571412,
    25.31648826424518717, 45.99003977573201496,
    25.66310777053267245, 47.63139077670033572,
    25.77773936992416637, 49.28804930270956675,
    25.63559425749198795, 50.94394459368972150,
    25.21002592824931199, 52.58130404832083116,
    24.47321926655621738, 54.18043392376822709,
    23.39751805719552991, 55.71953428872550518,
    21.95764487214750105, 57.17460858105235388,
    20.13405311103923623, 58.51955862209560166,
    17.91751559979281083, 59.72658657388572578,
    15.31471471060360479, 60.76704034614789407,
    12.35401191716921154, 61.61281120273996237,
    9.08984714396560278, 62.23829052070698253,
    5.60371952785031446, 62.62270582496653049,
    1.99999999999999556, 62.75242980718265784,
    -1.60371952785032224, 62.62270582496653049,
    -5.08984714396560900, 62.23829052070698253,
    -8.35401191716922042, 61.61281120273996237,
    -11.31471471060361367, 60.76704034614789407,
    -13.91751559979281616, 59.72658657388572578,
    -16.13405311103924689, 58.51955862209560166,
    -17.95764487214750815, 57.17460858105235388,
    -19.39751805719554056, 55.71953428872550518,
    -20.47321926655623159, 54.18043392376822709,
    -21.21002592824931554, 52.58130404832083116,
    -21.63559425749199860, 50.94394459368972150,
    -21.77773936992418058, 49.28804930270956675,
    -21.66310777053267955, 47.63139077670033572,
    -21.31648826424519783, 45.99003977573201496,
    -20.76054697060167697, 44.37858250245571412,
    -20.01582559662803362, 42.81031632956308641,
    -19.10089088783406197, 41.29741507659190347,
    -18.03256121225550146, 39.85106125278488065,
    -16.82616341777592694, 38.48154618161253637,
    -15.49579145727241603, 37.19834072287546434,
    -14.05455017155123620, 36.01014014726423795,
    -12.51477509868481341, 34.92488704934376642,
    -10.88822378743808095, 33.94977626735131793,
    -9.18623692372254474, 33.09124574576952682,
    -7.41986936545088049, 32.35495718584155611,
    -5.59999239238874935, 31.74577019145994683,
    -3.73736939611796970, 31.26771342119434749,
    -1.84270801296844478, 30.92395598105918353,
    0.07330759755400772, 30.71678191817960268,
    1.99999999999999600, 28.09100109536852230,
    4.16843782661930362, 28.16889262543881145,
    6.32564933647368566, 28.40205318377053345,
    8.46042949045145143, 28.78894734383437992,
    10.56160821625925195, 29.32703776203888069,
    12.61804920168178690, 30.01281590885307438,
    14.61862699669389087, 30.84184157026976436,
    16.55217628249286577, 31.80878785141789322,
    18.40740784814350306, 32.90748779465315010,
    20.17278641740253420, 34.13097826525053335,
    21.83636590786353437, 35.47153642700349963,
    23.38557795842459797, 36.92070387379718710,
    24.80696969977402233, 38.46929323359992026,
    26.08588698105331716, 40.10737174655498194,
    27.20610004359020806, 41.82421587722975431,
    28.14937074714974585, 43.60823042135866956,
    28.89496528133906494, 45.44682484300304282,
    29.41912613625676443, 47.32623888788154431,
    29.69453569648833735, 49.23130925676766623,
    29.68983696232584180, 51.14517010976478417,
    29.36933297612858240, 53.04888396821036167,
    28.69307609487012201, 54.92100894435518654,
    27.61769060836896728, 56.73712764036463341,
    26.09844461997003151, 58.46939890910893922,
    24.09325961331439458, 60.08625295311978931,
    21.56939664790981936, 61.55243525845713748,
    18.51323316925390117, 62.82970044453450953,
    14.94248311853021427, 63.87850997409253040,
    10.91821393310038246, 64.66099291349783584,
    6.55165837938126572, 65.14506774788591770,
    1.99999999999999645, 65.30899890463147983,
    -2.55165837938127327, 65.14506774788591770,
    -6.91821393310038868, 64.66099291349783584,
    -10.94248311853022138, 63.87850997409253040,
    -14.51323316925390650, 62.82970044453450953,
    -17.56939664790982647, 61.55243525845713748,
    -20.09325961331440169, 60.08625295311978931,
    -22.09844461997003862, 58.46939890910893922,
    -23.61769060836897793, 56.73712764036463341,
    -24.69307609487013266, 54.92100894435518654,
    -25.36933297612859306, 53.04888396821036167,
    -25.68983696232585245, 51.14517010976478417,
    -25.69453569648835156, 49.23130925676766623,
    -25.41912613625677508, 47.32623888788154431,
    -24.89496528133907205, 45.44682484300304282,
    -24.14937074714975651, 43.60823042135866956,
    -23.20610004359021872, 41.82421587722975431,
    -22.08588698105333137, 40.10737174655498194,
    -20.80696969977403299, 38.46929323359992026,
    -19.38557795842460862, 36.92070387379718710,
    -17.83636590786354148, 35.47153642700349963,
    -16.17278641740254486, 34.13097826525053335,
    -14.40740784814351372, 32.90748779465315010,
    -12.55217628249287110, 31.80878785141789322,
    -10.61862699669389798, 30.84184157026976436,
    -8.61804920168179400, 30.01281590885307438,
    -6.56160821625925994, 29.32703776203888069,
    -4.46042949045146031, 28.78894734383437992,
    -2.32564933647369187, 28.40205318377053345,
    -0.16843782661931131, 28.16889262543881145,
    1.99999999999999600, 25.45485763546421154,
    4.25579267831604824, 25.53081635683327377,
    6.50189378344491864, 25.75824904385734015,
    8.72865139696445169, 26.13583181560235502,
    10.92648650789847409, 26.66137960320710931,
    13.08591371200912867, 27.33187675649334025,
    15.19754366142444368, 28.14351701208744316,
    17.25206214192900589, 29.09175016726920759,
    19.24018123567453742, 30.17133232687284305,
    21.15255849246134545, 31.37637626233231813,
    22.97968026705780886, 32.70039821822412307,
    24.71170528699354918, 34.13635737784334623,
    26.33826403031282837, 35.67668409468497259,
    27.84820859564654683, 37.31329283883029291,
    29.22930648122764197, 39.03757551632935474,
    30.46787020033522708, 40.84037031204417190,
    31.54831327014242248, 42.71190039889389567,
    32.45262246278107199, 44.64167567492752653,
    33.15973753507462618, 46.61834908938177335,
    33.64483525740958214, 48.62951713112133945,
    33.87852862440772839, 50.66145188613276673,
    33.82602201650912122, 52.69875031809839783,
    33.44632120220701665, 54.72388646563504011,
    32.69170289014788011, 56.71665696607986717,
    31.50782877801381332, 58.65352526302899605,
    29.83517004248913196, 60.50690475312735828,
    27.61278608277912383, 62.24449065808524040,
    24.78586461017365750, 63.82887077001763032,
    21.31841683118042496, 65.21781824976642383,
    17.21138564172178320, 66.36584339331807314,
    12.52326664933801226, 67.22759281764989225,
    7.38533547682125846, 67.76325974975715383,
    1.99999999999999600, 67.94514236453578349,
    -3.38533547682126690, 67.76325974975715383,
    -8.52326664933801936, 67.22759281764989225,
    -13.21138564172179031, 66.36584339331807314,
    -17.31841683118043562, 65.21781824976642383,
    -20.78586461017366460, 63.82887077001763032,
    -23.61278608277912738, 62.24449065808524040,
    -25.83517004248913906, 60.50690475312735828,
    -27.50782877801382398, 58.65352526302899605,
    -28.69170289014789077, 56.71665696607986717,
    -29.44632120220701665, 54.72388646563504011,
    -29.82602201650912477, 52.69875031809839783,
    -29.87852862440772839, 50.66145188613276673,
    -29.64483525740958925, 48.62951713112133945,
    -29.15973753507462618, 46.61834908938177335,
    -28.45262246278107554, 44.64167567492752653,
    -27.54831327014242959, 42.71190039889389567,
    -26.46787020033523774, 40.84037031204417190,
    -25.22930648122764907, 39.03757551632935474,
    -23.84820859564655038, 37.31329283883029291,
    -22.33826403031283903, 35.67668409468497259,
    -20.71170528699355629, 34.13635737784334623,
    -18.97968026705781242, 32.70039821822412307,
    -17.15255849246134900, 31.37637626233231813,
    -15.24018123567454097, 30.17133232687284305,
    -13.25206214192901299, 29.09175016726920759,
    -11.19754366142445434, 28.14351701208744316,
    -9.08591371200913933, 27.33187675649334025,
    -6.92648650789848030, 26.66137960320710931,
    -4.72865139696445969, 26.13583181560235502,
    -2.50189378344492708, 25.75824904385734015,
    -0.25579267831605540, 25.53081635683327377,
    1.99999999999999556, 22.72540973598210456,
    4.47629214130109165, 22.80878975038074330,
    6.94242093509331060, 23.05843251151436846,
    9.38829543151647350, 23.47285525677742868,
    11.80396120930039139, 24.04961640006232315,
    14.17964838758363122, 24.78535803035031293,
    16.50579641562137567, 25.67586152120415477,
    18.77304947679039060, 26.71611272875198395,
    20.97221728412494102, 27.90037270541385439,
    23.09419678103115103, 29.22224954465700009,
    25.12985059268006793, 30.67476685924402702,
    27.06983782140639860, 32.25042441190934994,
    28.90439178940929921, 33.94124647006630369,
    30.62303747247054275, 35.73881343521246379,
    32.21423852322426029, 37.63427208010365632,
    33.66495985223924237, 39.61831917500946787,
    34.96012666362174315, 41.68115224019865650,
    36.08195470333167520, 43.81237943576640248,
    37.00911969333093765, 46.00087796034757304,
    37.71572773969587189, 48.23458650173874673,
    38.17004600591188535, 50.50021197832979425,
    38.33296113360039925, 52.78282385843581892,
    38.15616674923441565, 55.06530104282313687,
    37.58017141013022666, 57.32758829402004608,
    36.53242307522426557, 59.54571651024583190,
    34.92626834358740950, 61.69055635034530383,
    32.66225471925319113, 63.72633555655123416,
    29.63456841105837825, 65.60910965714572285,
    25.74696599568290623, 67.28571148577094618,
    20.94303945184942251, 68.69426490502790728,
    15.25145387811900122, 69.76794994271870110,
    8.83336207267744022, 70.44359392189112157,
    1.99999999999999600, 70.67459026401789401,
    -4.83336207267745088, 70.44359392189112157,
    -11.25145387811901188, 69.76794994271870110,
    -16.94303945184943316, 68.69426490502790728,
    -21.74696599568291333, 67.28571148577094618,
    -25.63456841105838890, 65.60910965714572285,
    -28.66225471925320534, 63.72633555655123416,
    -30.92626834358741306, 61.69055635034530383,
    -32.53242307522427978, 59.54571651024583190,
    -33.58017141013024087, 57.32758829402004608,
    -34.15616674923442986, 55.06530104282313687,
    -34.33296113360040636, 52.78282385843581892,
    -34.17004600591189956, 50.50021197832979425,
    -33.71572773969587900, 48.23458650173874673,
    -33.00911969333094476, 46.00087796034757304,
    -32.08195470333168231, 43.81237943576640248,
    -30.96012666362175025, 41.68115224019865650,
    -29.66495985223924237, 39.61831917500946787,
    -28.21423852322426740, 37.63427208010365632,
    -26.62303747247054631, 35.73881343521246379,
    -24.90439178940930276, 33.94124647006630369,
    -23.06983782140640216, 32.25042441190934994,
    -21.12985059268007149, 30.67476685924402702,
    -19.09419678103115459, 29.22224954465700009,
    -16.97221728412494102, 27.90037270541385439,
    -14.77304947679039948, 26.71611272875198395,
    -12.50579641562138455, 25.67586152120415477,
    -10.17964838758364365, 24.78535803035031293,
    -7.80396120930039938, 24.04961640006232315,
    -5.38829543151647972, 23.47285525677742868,
    -2.94242093509332037, 23.05843251151436846,
    -0.47629214130110020, 22.80878975038074330,
    1.99999999999999600, 19.88744176867359670,
    4.69641128035122435, 19.97822987242788884,
    7.38211423303385939, 20.25003331964319031,
    10.04651538477556549, 20.70118176192879389,
    12.67924035399200378, 21.32893128539882710,
    15.27021753707410312, 22.12952164603582617,
    17.80973254683686946, 23.09825113914619976,
    20.28844626261447459, 24.22956442487017270,
    22.69737092792362532, 25.51714801636046204,
    25.02780000980339636, 26.95402789495272344,
    27.27118821325056430, 28.53266378578365448,
    29.41897786066868292, 30.24503490367624536,
    31.46236656888654792, 32.08271233019573287,
    33.39200856069422940, 34.03691345955112979,
    35.19763777135730720, 36.09853399317180589,
    36.86759479425492714, 38.25815259440047811,
    38.38823113470312620, 40.50600232791481403,
    39.74315247327933776, 42.83190113242096686,
    40.91224672040999621, 45.22513042719018728,
    41.87042151784342536, 47.67424596736638165,
    42.58594887503602422, 50.16679739569313057,
    43.01828312042781022, 52.68892136253921876,
    43.11518954384546731, 55.22475594928482678,
    42.80901819915838757, 57.75559962131574565,
    42.01204327449660525, 60.25870541573158334,
    40.61111913565843423, 62.70556553816149403,
    38.46283411458643542, 65.05952649321666570,
    35.39257932570031784, 67.27265449907143591,
    31.20553396293055215, 69.28213523998356038,
    25.72462936947633239, 71.00751554077180572,
    18.87413258170036201, 72.35214877025040892,
    10.80643587234801295, 73.21444539538327945,
    1.99999999999999600, 73.51255823132640899,
    -6.80643587234802006, 73.21444539538327945,
    -14.87413258170037622, 72.35214877025040892,
    -21.72462936947634304, 71.00751554077180572,
    -27.20553396293055570, 69.28213523998356038,
    -31.39257932570032139, 67.27265449907143591,
    -34.46283411458643542, 65.05952649321666570,
    -36.61111913565844134, 62.70556553816149403,
    -38.01204327449661946, 60.25870541573158334,
    -38.80901819915838047, 57.75559962131574565,
    -39.11518954384547442, 55.22475594928482678,
    -39.01828312042781022, 52.68892136253921876,
    -38.58594887503603843, 50.16679739569313057,
    -37.87042151784342536, 47.67424596736638165,
    -36.91224672041000332, 45.22513042719018728,
    -35.74315247327935197, 42.83190113242096686,
    -34.38823113470313331, 40.50600232791481403,
    -32.86759479425493424, 38.25815259440047811,
    -31.19763777135731431, 36.09853399317180589,
    -29.39200856069424717, 34.03691345955112979,
    -27.46236656888655858, 32.08271233019573287,
    -25.41897786066869003, 30.24503490367624536,
    -23.27118821325056786, 28.53266378578365448,
    -21.02780000980340702, 26.95402789495272344,
    -18.69737092792362887, 25.51714801636046204,
    -16.28844626261448170, 24.22956442487017270,
    -13.80973254683687301, 23.09825113914619976,
    -11.27021753707411023, 22.12952164603582617,
    -8.67924035399200910, 21.32893128539882710,
    -6.04651538477557171, 20.70118176192879389,
    -3.38211423303386916, 20.25003331964319031,
    -0.69641128035123179, 19.97822987242788884,
    1.99999999999999556, 16.92397162343523931,
    4.91799021933642688, 17.02221659443387480,
    7.82460955068693664, 17.31631470128239059,
    10.70865569654628935, 17.80437171431731258,
    13.55924980839402139, 18.48328342761256238,
    16.36596498789072385, 19.34881113120014362,
    19.11891780975726363, 20.39568010883170501,
    21.80881477377849720, 21.61769490666709714,
    24.42694818201795570, 23.00786444863284430,
    26.96513811238917668, 24.55852997196867804,
    29.41561850057672345, 26.26148912292403637,
    31.77086550998261671, 28.10811023218007065,
    34.02336509370287132, 30.08943159705432180,
    36.16531367916817175, 32.19624133969532664,
    38.18824090805679106, 34.41913389699745807,
    40.08253581911941410, 36.74853923728758076,
    41.83684688715484867, 39.17472027603687934,
    43.43731045663169255, 41.68773239540036002,
    44.86653894639825779, 44.27733603455973110,
    46.10226597817306526, 46.93284831506371546,
    47.11549450115907689, 49.64291142290011294,
    47.86791757533286074, 52.39514197266055362,
    48.30826862884845241, 55.17560336970880286,
    48.36709840828364548, 57.96800639328736793,
    47.94927569193657035, 60.75248226909388904,
    46.92334661203305046, 63.50367340927639503,
    45.10709162054252630, 66.18773615332521842,
    42.25028545833759352, 68.75766348420629015,
    38.02194152863378918, 71.14627956201685777,
    32.02735732207737840, 73.25702648451857613,
    23.91726594386999949, 74.95625177955801632,
    13.67376613190776347, 76.07990221077976400,
    1.99999999999999600, 76.47602837656475572,
    -9.67376613190777235, 76.07990221077976400,
    -19.91726594387001015, 74.95625177955801632,
    -28.02735732207739261, 73.25702648451857613,
    -34.02194152863380339, 71.14627956201685777,
    -38.25028545833759352, 68.75766348420629015,
    -41.10709162054251919, 66.18773615332521842,
    -42.92334661203306467, 63.50367340927639503,
    -43.94927569193657746, 60.75248226909388904,
    -44.36709840828364548, 57.96800639328736793,
    -44.30826862884845241, 55.17560336970880286,
    -43.86791757533286784, 52.39514197266055362,
    -43.11549450115907689, 49.64291142290011294,
    -42.10226597817306526, 46.93284831506371546,
    -40.86653894639826490, 44.27733603455973110,
    -39.43731045663169965, 41.68773239540036002,
    -37.83684688715485578, 39.17472027603687934,
    -36.08253581911941410, 36.74853923728758076,
    -34.18824090805679816, 34.41913389699745807,
    -32.16531367916818596, 32.19624133969532664,
    -30.02336509370288908, 30.08943159705432180,
    -27.77086550998262737, 28.10811023218007065,
    -25.41561850057673766, 26.26148912292403637,
    -22.96513811238918734, 24.55852997196867804,
    -20.42694818201796636, 23.00786444863284430,
    -17.80881477377850075, 21.61769490666709714,
    -15.11891780975727251, 20.39568010883170501,
    -12.36596498789073095, 19.34881113120014362,
    -9.55924980839402849, 18.48328342761256238,
    -6.70865569654630001, 17.80437171431731258,
    -3.82460955068694464, 17.31631470128239059,
    -0.91799021933643477, 17.02221659443387480,
    1.99999999999999556, 13.81592192037676625,
    5.14299451095195792, 13.92173872937387102,
    8.27378779825514954, 14.23846093632396581,
    11.38041466390652978, 14.76392503362292530,
    14.45136393475438119, 15.49459412897926924,
    17.47576217013061139, 16.42565612762181004,
    20.44350999615491205, 17.55115134744557182,
    23.34536199373425092, 18.86412113035556004,
    26.17294518233925160, 20.35676830949395466,
    28.91871466466540141, 22.02062053097340311,
    31.57584735879237314, 23.84668824688734645,
    34.13807554901531205, 25.82561045671564415,
    36.59946098845733786, 27.94778271439298933,
    38.95410730493897233, 30.20346328869342756,
    41.19580324741197330, 32.58285444844916867,
    43.31758136998609388, 35.07615645611910082,
    45.31116510791174079, 37.67359181604234664,
    47.16626004327477517, 40.36539642075791789,
    48.86961926381131605, 43.14177213432515856,
    50.40377244059970963, 45.99279145534946167,
    51.74524369263552614, 48.90823812634897649,
    52.86197695521289575, 51.87735585154322138,
    53.70950811496559396, 54.88845672164920586,
    54.22511448054331140, 57.92830381592441569,
    54.31863539857850753, 60.98111330635318694,
    53.85773173662808233, 64.02688869849654907,
    52.64383991815974895, 67.03853932314146391,
    50.37308749001456931, 69.97672254379963874,
    46.57629367046713753, 72.78039612779683409,
    40.54693285975561423, 75.34972495190746145,
    31.34759503822197502, 77.51867325981696411,
    18.24038894313819625, 79.03039199474196153,
    1.99999999999999489, 79.58407807962322522,
    -14.24038894313820691, 79.03039199474196153,
    -27.34759503822198567, 77.51867325981696411,
    -36.54693285975562134, 75.34972495190746145,
    -42.57629367046714464, 72.78039612779683409,
    -46.37308749001456931, 69.97672254379963874,
    -48.64383991815974895, 67.03853932314146391,
    -49.85773173662808233, 64.02688869849654907,
    -50.31863539857852174, 60.98111330635318694,
    -50.22511448054332561, 57.92830381592441569,
    -49.70950811496560817, 54.88845672164920586,
    -48.86197695521290996, 51.87735585154322138,
    -47.74524369263553325, 48.90823812634897649,
    -46.40377244059971673, 45.99279145534946167,
    -44.86961926381133026, 43.14177213432515856,
    -43.16626004327478938, 40.36539642075791789,
    -41.31116510791174079, 37.67359181604234664,
    -39.31758136998610098, 35.07615645611910082,
    -37.19580324741197330, 32.58285444844916867,
    -34.95410730493897233, 30.20346328869342756,
    -32.59946098845735207, 27.94778271439298933,
    -30.13807554901532626, 25.82561045671564415,
    -27.57584735879238025, 23.84668824688734645,
    -24.91871466466541207, 22.02062053097340311,
    -22.17294518233926226, 20.35676830949395466,
    -19.34536199373426157, 18.86412113035556004,
    -16.44350999615492626, 17.55115134744557182,
    -13.47576217013062028, 16.42565612762181004,
    -10.45136393475438830, 15.49459412897926924,
    -7.38041466390653600, 14.76392503362292530,
    -4.27378779825515931, 14.23846093632396581,
    -1.14299451095196680, 13.92173872937387102,
    1.99999999999999600, 10.54173785529561158,
    5.37360609917943943, 10.65531494200142149,
    8.73395228112667965, 10.99520717814031556,
    12.06809948196381832, 11.55892497220584403,
    15.36372621835939078, 12.34240842556757656,
    18.60937983520193129, 13.34015413091371016,
    21.79466590782825364, 14.54537904344351951,
    24.91036566952359266, 15.95020993686824440,
    27.94847769357361855, 17.54588626406437513,
    30.90218550361061745, 19.32296477964253967,
    33.76575655354334060, 21.27151577227775903,
    36.53437968696508875, 23.38130282889363798,
    39.20394762734519389, 25.64194033091114022,
    41.77078829775712165, 28.04302503644353095,
    44.23134383513491485, 30.57423988556289629,
    46.58178882927892772, 33.22542941501406233,
    48.81756887288366187, 35.98664677769215103,
    50.93282539675248444, 38.84817223653458029,
    52.91964996438991164, 41.80050199367043007,
    54.76707508825830928, 44.83430401955754974,
    56.45964870701569538, 47.94033352757975308,
    57.97533567047437231, 51.10929358481432416,
    59.28230228211859298, 54.33161333463023368,
    60.33378767939932885, 57.59709162031844443,
    61.05957379451161415, 60.89430451319173443,
    61.35114187047394552, 64.20957103321013903,
    61.03453256694833584, 67.52503657439316953,
    59.81801935702030448, 70.81486693953938527,
    57.18593275925195485, 74.03707888623914357,
    52.17735288037920327, 77.11452529323830163,
    42.96575654499160635, 79.88802174923021937,
    26.58690897303194944, 82.01033616765489853,
    1.99999999999999756, 82.85826214470436923,
    -22.58690897303195300, 82.01033616765489853,
    -38.96575654499161345, 79.88802174923021937,
    -48.17735288037921748, 77.11452529323830163,
    -53.18593275925197617, 74.03707888623914357,
    -55.81801935702031159, 70.81486693953938527,
    -57.03453256694834295, 67.52503657439316953,
    -57.35114187047395262, 64.20957103321013903,
    -57.05957379451162836, 60.89430451319173443,
    -56.33378767939933596, 57.59709162031844443,
    -55.28230228211860720, 54.33161333463023368,
    -53.97533567047437231, 51.10929358481432416,
    -52.45964870701570248, 47.94033352757975308,
    -50.76707508825830928, 44.83430401955754974,
    -48.91964996438991875, 41.80050199367043007,
    -46.93282539675249154, 38.84817223653458029,
    -44.81756887288366897, 35.98664677769215103,
    -42.58178882927894193, 33.22542941501406233,
    -40.23134383513492196, 30.57423988556289629,
    -37.77078829775713587, 28.04302503644353095,
    -35.20394762734520100, 25.64194033091114022,
    -32.53437968696510296, 23.38130282889363798,
    -29.76575655354335481, 21.27151577227775903,
    -26.90218550361062810, 19.32296477964253967,
    -23.94847769357362921, 17.54588626406437513,
    -20.91036566952360332, 15.95020993686824440,
    -17.79466590782826074, 14.54537904344351951,
    -14.60937983520194017, 13.34015413091371016,
    -11.36372621835939611, 12.34240842556757656,
    -8.06809948196382898, 11.55892497220584403,
    -4.73395228112668676, 10.99520717814031556,
    -1.37360609917944720, 10.65531494200142149,
    1.99999999999999600, 7.07694595379052860,
    5.61234064761578821, 7.19855645524002874,
    9.21005712455210990, 7.56241362477411005,
    12.77895396829166508, 8.16563014493928208,
    16.30566013367806733, 9.00350968307661859,
    19.77796305903054730, 10.06971032975657643,
    23.18506021909562875, 11.35645428598743756,
    26.51771689758311723, 12.85476800444172873,
    29.76832854644279536, 14.55473640862136264,
    32.93089420696504277, 16.44575600838861362,
    36.00091302933286386, 18.51677422677156315,
    38.97521854780546846, 20.75650546647104022,
    41.85176517580521960, 23.15361781597290403,
    44.62937881000767248, 25.69688738457191945,
    47.30747895739604303, 28.37531978094453677,
    49.88577372237665486, 31.17824007995576707,
    52.36392121341754091, 34.09535373993877982,
    54.74114071516557090, 37.11678138456306897,
    57.01574257648425004, 40.23307020728445593,
    59.18452370168172649, 43.43518400478754415,
    61.24193904387428233, 46.71447239476329827,
    63.17889520468774833, 50.06261728049957327,
    64.98089250042356468, 53.47155025248752480,
    66.62500642980749888, 56.93332642202356197,
    68.07470870335012592, 60.43992354246547904,
    69.27043361461275595, 63.98289851135272244,
    70.11115128919476547, 67.55274433031233627,
    70.41516373728855172, 71.13755089586132385,
    69.82714145548160900, 74.71983727667713993,
    67.56415050352947560, 78.26774990878784877,
    61.58131858106001033, 81.70467639663139892,
    45.28583165458982052, 84.76914638163376026,
    1.99999999999999689, 86.32305404620944955,
    -41.28583165458982762, 84.76914638163376026,
    -57.58131858106002454, 81.70467639663139892,
    -63.56415050352948981, 78.26774990878784877,
    -65.82714145548162321, 74.71983727667713993,
    -66.41516373728856593, 71.13755089586132385,
    -66.11115128919477968, 67.55274433031233627,
    -65.27043361461275595, 63.98289851135272244,
    -64.07470870335011170, 60.43992354246547904,
    -62.62500642980752019, 56.93332642202356197,
    -60.98089250042357889, 53.47155025248752480,
    -59.17889520468775544, 50.06261728049957327,
    -57.24193904387428233, 46.71447239476329827,
    -55.18452370168172649, 43.43518400478754415,
    -53.01574257648425004, 40.23307020728445593,
    -50.74114071516557800, 37.11678138456306897,
    -48.36392121341754802, 34.09535373993877982,
    -45.88577372237665486, 31.17824007995576707,
    -43.30747895739605013, 28.37531978094453677,
    -40.62937881000767959, 25.69688738457191945,
    -37.85176517580522670, 23.15361781597290403,
    -34.97521854780547557, 20.75650546647104022,
    -32.00091302933286386, 18.51677422677156315,
    -28.93089420696504632, 16.44575600838861362,
    -25.76832854644280957, 14.55473640862136264,
    -22.51771689758312434, 12.85476800444172873,
    -19.18506021909564296, 11.35645428598743756,
    -15.77796305903055796, 10.06971032975657643,
    -12.30566013367807621, 9.00350968307661859,
    -8.77895396829167574, 8.16563014493928208,
    -5.21005712455211967, 7.56241362477411005,
    -1.61234064761579732, 7.19855645524002874,
    1.99999999999999556, 3.39364961385021102,
    5.86220744039440511, 3.52366797872772963,
    9.70801791517021506, 3.91258202080964379,
    13.52160273595813145, 4.55701513369246314,
    17.28822357553576694, 5.45149036402020482,
    20.99466904928960531, 6.58864168091601599,
    24.62957864939021135, 7.95948261839810378,
    28.18364165385172626, 9.55371034930797514,
    31.64967308093981302, 11.36002298851478365,
    35.02258051120933402, 13.36643021383323671,
    38.29924330014637235, 15.56054131855884215,
    41.47832910130669859, 17.92981963683195801,
    44.56007232189227807, 20.46179708442632261,
    47.54603622089215520, 23.14424674184217068,
    50.43887601207384819, 25.96531465470105005,
    53.24211556220075892, 28.91361425616476666,
    55.95994579953058690, 31.97828811153562256,
    58.59704918478396252, 35.14904222145087687,
    61.15845171105517863, 38.41615810166681655,
    63.64940188352277062, 41.77048747717444854,
    66.07527488350018530, 45.20343384586799118,
    68.44149951448399349, 48.70692450151241104,
    70.75350545455997064, 52.27337593848611164,
    73.01668877482984499, 55.89565494125256606,
    75.23639478559491067, 59.56703711552955127,
    77.41791965045068480, 63.28116415502339720,
    79.56653776770211550, 67.03200075627316323,
    81.68757690134610527, 70.81379178736983704,
    83.78661098119418682, 74.62102007313750107,
    85.87003129087820241, 78.44836496333871878,
    87.94730489861872513, 82.29066165213365025,
    90.04670840724658376, 86.14286053253557895,
    -177.99999999999985789, 89.99364961382421768,
    -86.04670840724655534, 86.14286053253557895,
    -83.94730489861876777, 82.29066165213365025,
    -81.87003129087820241, 78.44836496333871878,
    -79.78661098119418682, 74.62102007313750107,
    -77.68757690134613370, 70.81379178736983704,
    -75.56653776770212971, 67.03200075627316323,
    -73.41791965045068480, 63.28116415502339720,
    -71.23639478559491067, 59.56703711552955127,
    -69.01668877482984499, 55.89565494125256606,
    -66.75350545455997064, 52.27337593848611164,
    -64.44149951448400770, 48.70692450151241104,
    -62.07527488350018530, 45.20343384586799118,
    -59.64940188352277772, 41.77048747717444854,
    -57.15845171105518574, 38.41615810166681655,
    -54.59704918478396252, 35.14904222145087687,
    -51.95994579953059400, 31.97828811153562256,
    -49.24211556220076602, 28.91361425616476666,
    -46.43887601207384819, 25.96531465470105005,
    -43.54603622089217652, 23.14424674184217068,
    -40.56007232189229228, 20.46179708442632261,
    -37.47832910130670570, 17.92981963683195801,
    -34.29924330014637945, 15.56054131855884215,
    -31.02258051120933402, 13.36643021383323671,
    -27.64967308093982012, 11.36002298851478365,
    -24.18364165385173337, 9.55371034930797514,
    -20.62957864939022556, 7.95948261839810378,
    -16.99466904928961597, 6.58864168091601599,
    -13.28822357553577582, 5.45149036402020482,
    -9.52160273595813855, 4.55701513369246314,
    -5.70801791517022572, 3.91258202080964379,
    -1.86220744039441377, 3.52366797872772963,
    1.99999999999999556, -0.54003843869415158,
    6.12693783758673050, -0.40111214042971866,
    10.23515434659413970, 0.01431798130226895,
    14.30668142622436534, 0.70226688878527466,
    18.32499114491300674, 1.65629062554436168,
    22.27556116130715580, 2.86776143955401341,
    26.14628266758476016, 4.32621388981252775,
    29.92769777693464306, 6.01973109672258033,
    33.61307490596014702, 7.93534078498540918,
    37.19834740797973183, 10.05939491571368904,
    40.68195074563112712, 12.37791309905906267,
    44.06459700293881809, 14.87687712846902421,
    47.34902402209520034, 17.54247066454981052,
    50.53975201683548590, 20.36126354510683711,
    53.64287529119709319, 23.32034407821754485,
    56.66591251909911620, 26.40740499964346455,
    59.61773745881250619, 29.61078975921034129,
    62.50861449014276872, 32.91950572923986584,
    65.35037195723165837, 36.32321005821969351,
    68.15676435641833564, 39.81217237539897269,
    70.94410839385281520, 43.37721635788606989,
    73.73234087330637010, 47.00963897352001908,
    76.54676554128549526, 50.70110112272598712,
    79.42099130058548440, 54.44347433172315220,
    82.40205491898922219, 58.22861013398449614,
    85.55981529780903827, 62.04795929474799721,
    89.00534896567364740, 65.89187266757559769,
    92.93011750021230455, 69.74815881341463353,
    97.69886509454546797, 73.59868574092438109,
    104.10346048738931302, 77.40995108179684792,
    114.19717929614462548, 81.10053146183234674,
    134.58473801020662108, 84.39088722277180921,
    -178.00000000000002842, 86.05996156130575514,
    -130.58473801020659266, 84.39088722277180921,
    -110.19717929614465390, 81.10053146183234674,
    -100.10346048738929881, 77.40995108179684792,
    -93.69886509454548218, 73.59868574092438109,
    -88.93011750021230455, 69.74815881341463353,
    -85.00534896567366161, 65.89187266757559769,
    -81.55981529780905248, 62.04795929474799721,
    -78.40205491898922219, 58.22861013398449614,
    -75.42099130058548440, 54.44347433172315220,
    -72.54676554128549526, 50.70110112272598712,
    -69.73234087330638431, 47.00963897352001908,
    -66.94410839385282941, 43.37721635788606989,
    -64.15676435641836406, 39.81217237539897269,
    -61.35037195723166548, 36.32321005821969351,
    -58.50861449014277582, 32.91950572923986584,
    -55.61773745881251330, 29.61078975921034129,
    -52.66591251909913041, 26.40740499964346455,
    -49.64287529119710030, 23.32034407821754485,
    -46.53975201683548590, 20.36126354510683711,
    -43.34902402209520034, 17.54247066454981052,
    -40.06459700293881809, 14.87687712846902421,
    -36.68195074563112712, 12.37791309905906267,
    -33.19834740797973893, 10.05939491571368904,
    -29.61307490596015057, 7.93534078498540918,
    -25.92769777693465727, 6.01973109672258033,
    -22.14628266758476371, 4.32621388981252775,
    -18.27556116130716291, 2.86776143955401341,
    -14.32499114491301384, 1.65629062554436168,
    -10.30668142622437244, 0.70226688878527466,
    -6.23515434659414680, 0.01431798130226895,
    -2.12693783758673804, -0.40111214042971866,
    1.99999999999999556, -4.76061810234754645,
    6.41132592404072454, -4.61212239418478553,
    10.80084816537008230, -4.16824654595516098,
    15.14776873556008674, -3.43374257581263365,
    19.43320327160517635, -2.41626750988024641,
    23.64091162595336115, -1.12602081331554671,
    27.75780275269853448, 0.42470591907018324,
    31.77420154083880988, 2.22202305439570047,
    35.68389780238808129, 4.25093893994811900,
    39.48402100288601702, 6.49582334126627270,
    43.17479644658765636, 8.94081392759362181,
    46.75924066894447861, 11.57015196980179894,
    50.24284889074777283, 14.36844259642658628,
    53.63331929525543273, 17.32084182287968943,
    56.94035098918124049, 20.41317688045037571,
    60.17554747078253286, 23.63200834498020697,
    63.35245736607463840, 26.96464262473803686,
    66.48679120890342631, 30.39910192691253599,
    69.59687011372152199, 33.92405612452549946,
    72.70439458886511375, 37.52871692222674938,
    75.83567948061782715, 41.20268880474466755,
    79.02360369831293951, 44.93576201889581512,
    82.31071017117776023, 48.71761719224470966,
    85.75424365182692554, 52.53738247574246856,
    89.43460651588344490, 56.38292751246400769,
    93.47013935832343634, 60.23965935256792648,
    98.04421718085441739, 64.08831694761893516,
    103.45761459629794388, 67.90061168070626252,
    110.23509874248559015, 71.62987479878029262,
    119.34882263320223217, 75.18923730101467129,
    132.64763601333982024, 78.39753950634394641,
    153.15668933029419918, 80.85560324742944260,
    -178.00000000000002842, 81.83938189765245852,
    -149.15668933029422760, 80.85560324742944260,
    -128.64763601333984866, 78.39753950634394641,
    -115.34882263320223217, 75.18923730101467129,
    -106.23509874248556173, 71.62987479878029262,
    -99.45761459629794388, 67.90061168070626252,
    -94.04421718085441739, 64.08831694761893516,
    -89.47013935832346476, 60.23965935256792648,
    -85.43460651588344490, 56.38292751246400769,
    -81.75424365182695396, 52.53738247574246856,
    -78.31071017117777444, 48.71761719224470966,
    -75.02360369831293951, 44.93576201889581512,
    -71.83567948061784136, 41.20268880474466755,
    -68.70439458886511375, 37.52871692222674938,
    -65.59687011372152199, 33.92405612452549946,
    -62.48679120890344052, 30.39910192691253599,
    -59.35245736607464551, 26.96464262473803686,
    -56.17554747078254707, 23.63200834498020697,
    -52.94035098918124760, 20.41317688045037571,
    -49.63331929525544695, 17.32084182287968943,
    -46.24284889074779414, 14.36844259642658628,
    -42.75924066894448572, 11.57015196980179894,
    -39.17479644658766347, 8.94081392759362181,
    -35.48402100288603123, 6.49582334126627270,
    -31.68389780238809195, 4.25093893994811900,
    -27.77420154083882409, 2.22202305439570047,
    -23.75780275269854513, 0.42470591907018324,
    -19.64091162595336826, -1.12602081331554671,
    -15.43320327160518879, -2.41626750988024641,
    -11.14776873556009562, -3.43374257581263365,
    -6.80084816537009029, -4.16824654595516098,
    -2.41132592404073298, -4.61212239418478553,
    1.99999999999999556, -9.30985393851741705,
    6.72175805422021355, -9.15091230991673932,
    11.41756212661333514, -8.67603648837036268,
    16.06282113870961226, -7.89096231408012549,
    20.63552097548324227, -6.80489321395614688,
    25.11717183125960418, -5.43001433583735604,
    29.49342310484702523, -3.78089833576525836,
    33.75433817509684786, -1.87386656696368870,
    37.89437094593881028, 0.27363605581641121,
    41.91211819209927114, 2.64360721178193936,
    45.80993456941938291, 5.21796518077428217,
    49.59349430020984784, 7.97892504367260536,
    53.27137129744098587, 10.90927185095380025,
    56.85469423510678411, 13.99253787292509266,
    60.35691981311008192, 17.21309536720795919,
    63.79375952890369206, 20.55617726580611659,
    67.18329478816110623, 24.00783659504739731,
    70.54632400302143935, 27.55485191826680236,
    73.90700610430916129, 31.18458087158649406,
    77.29390254081907585, 34.88475663106463287,
    80.74158359961856490, 38.64321178012773572,
    84.29307189810650414, 42.44749809608728697,
    88.00357763838491110, 46.28434439562811065,
    91.94629406419836926, 50.13884820321026581,
    96.22157019495104180, 53.99321139219064491,
    100.97173315822050199, 57.82466562901674934,
    106.40541928769302160, 61.60190913800559542,
    112.83745587761723073, 65.27873175231235336,
    120.75095597801100666, 68.78228497629521598,
    130.87442892417493567, 71.99165187875782124,
    144.18467631053604805, 74.70285264202438213,
    161.47781378002883912, 76.59572545663588983,
    -178.00000000000002842, 77.29014606148258792,
    -157.47781378002883912, 76.59572545663588983,
    -140.18467631053607647, 74.70285264202438213,
    -126.87442892417496410, 71.99165187875782124,
    -116.75095597801099245, 68.78228497629521598,
    -108.83745587761723073, 65.27873175231235336,
    -102.40541928769302160, 61.60190913800559542,
    -96.97173315822051620, 57.82466562901674934,
    -92.22157019495104180, 53.99321139219064491,
    -87.94629406419838347, 50.13884820321026581,
    -84.00357763838492531, 46.28434439562811065,
    -80.29307189810650414, 42.44749809608728697,
    -76.74158359961857911, 38.64321178012773572,
    -73.29390254081907585, 34.88475663106463287,
    -69.90700610430916129, 31.18458087158649406,
    -66.54632400302145356, 27.55485191826680236,
    -63.18329478816111333, 24.00783659504739731,
    -59.79375952890369916, 20.55617726580611659,
    -56.35691981311008192, 17.21309536720795919,
    -52.85469423510679832, 13.99253787292509266,
    -49.27137129744098587, 10.90927185095380025,
    -45.59349430020986915, 7.97892504367260536,
    -41.80993456941939712, 5.21796518077428217,
    -37.91211819209929246, 2.64360721178193936,
    -33.89437094593881739, 0.27363605581641121,
    -29.75433817509685497, -1.87386656696368870,
    -25.49342310484703944, -3.78089833576525836,
    -21.11717183125961128, -5.43001433583735604,
    -16.63552097548325293, -6.80489321395614688,
    -12.06282113870962114, -7.89096231408012549,
    -7.41756212661334136, -8.67603648837036268,
    -2.72175805422022110, -9.15091230991673932,
    1.99999999999999556, -14.23540593490034212,
    7.06707279862612125, -14.06484423228424063,
    12.10248720394761790, -13.55555303790300137,
    17.07647532339787944, -12.71455858250937965,
    21.96281473836326015, -11.55307649365679623,
    26.74006765897273041, -10.08584610023314454,
    31.39231472226267528, -8.33033151194296018,
    35.90939060170597230, -6.30588392466837799,
    40.28670514160292271, -4.03294710811188395,
    44.52477649322944586, -1.53236497867592791,
    48.62861191461712451, 1.17517574056815022,
    52.60705694133754662, 4.06955754229703981,
    56.47220691225791711, 7.13150506907926562,
    60.23894695811429756, 10.34273467530950796,
    63.92466443809040300, 13.68599977255221845,
    67.54916484650964037, 17.14505004500527363,
    71.13481958525987636, 20.70451849248449960,
    74.70698212428176532, 24.34974403770184992,
    78.29472888122153051, 28.06652943785655552,
    81.93201512996088809, 31.84082402428231973,
    85.65938939021744147, 35.65830698143167155,
    89.52649044264860834, 39.50382677214758331,
    93.59567144235911940, 43.36062114047545890,
    97.94726867835277062, 47.20919167069192923,
    102.68725830824645584, 51.02562354013957702,
    107.95825647893494192, 54.77900423463843538,
    113.95470750710921948, 58.42738157410047961,
    120.94158660124729465, 61.91142197433249095,
    129.26976638159490562, 65.14478524125112813,
    139.36255278451201889, 68.00113945880528377,
    151.60742176334809983, 70.30250402254893061,
    166.05644118521092878, 71.82662636485281382,
    -178.00000000000002842, 72.36459406509962378,
    -162.05644118521095720, 71.82662636485281382,
    -147.60742176334812825, 70.30250402254893061,
    -135.36255278451201889, 68.00113945880528377,
    -125.26976638159489141, 65.14478524125112813,
    -116.94158660124729465, 61.91142197433249095,
    -109.95470750710923369, 58.42738157410047961,
    -103.95825647893495614, 54.77900423463843538,
    -98.68725830824647005, 51.02562354013957702,
    -93.94726867835278483, 47.20919167069192923,
    -89.59567144235911940, 43.36062114047545890,
    -85.52649044264862255, 39.50382677214758331,
    -81.65938939021744147, 35.65830698143167155,
    -77.93201512996090230, 31.84082402428231973,
    -74.29472888122153051, 28.06652943785655552,
    -70.70698212428177953, 24.34974403770184992,
    -67.13481958525987636, 20.70451849248449960,
    -63.54916484650964748, 17.14505004500527363,
    -59.92466443809041010, 13.68599977255221845,
    -56.23894695811430466, 10.34273467530950796,
    -52.47220691225792422, 7.13150506907926562,
    -48.60705694133756083, 4.06955754229703981,
    -44.62861191461713162, 1.17517574056815022,
    -40.52477649322946007, -1.53236497867592791,
    -36.28670514160293692, -4.03294710811188395,
    -31.90939060170597941, -6.30588392466837799,
    -27.39231472226267883, -8.33033151194296018,
    -22.74006765897273752, -10.08584610023314454,
    -17.96281473836326725, -11.55307649365679623,
    -13.07647532339788832, -12.71455858250937965,
    -8.10248720394762678, -13.55555303790300137,
    -3.06707279862612925, -14.06484423228424063,
    1.99999999999999600, -19.59134287356426896,
    7.46002704385165138, -19.40755726556070115,
    12.88033504279662367, -18.85919797266866738,
    18.22391622121717347, -17.95503295463869264,
    23.45879403720244127, -16.70896594558295334,
    28.55966518490710015, -15.13909773195327269,
    33.50874372060166451, -13.26662598462660014,
    38.29585521437642370, -11.11472732454917889,
    42.91794868987490474, -8.70753794849322738,
    47.37824652323212149, -6.06930752874207258,
    51.68524592294901510, -3.22375917751487107,
    55.85174332801063457, -0.19365520038940884,
    59.89399913408759346, 2.99945241539763385,
    63.83111160507218784, 6.33531713186757095,
    67.68463403089357655, 9.79496963802120746,
    71.47845003929684538, 13.36059248585088000,
    75.23891693218338617, 17.01531594444593409,
    78.99529352424693229, 20.74294398926493699,
    82.78048521884274180, 24.52760876444716587,
    86.63216392910494790, 28.35333972343855180,
    90.59435351833845118, 32.20351875194761959,
    94.71961138434764393, 36.06017287638244539,
    99.07197748871266185, 39.90302877816822757,
    103.73088255981890882, 43.70821480745370025,
    108.79614728017998004, 47.44644408577498496,
    114.39390839554110357, 51.08045112569507751,
    120.68240638414135901, 54.56141374911145192,
    127.85428534979440940, 57.82417470821775396,
    136.12712761110682891, 60.78156430751474204,
    145.70578215046154469, 63.31961305621511116,
    156.69437932769909594, 65.29863962109097031,
    168.95645291666264143, 66.56908368553207822,
    -178.00000000000002842, 67.00865712643570760,
    -164.95645291666266985, 66.56908368553207822,
    -152.69437932769912436, 65.29863962109097031,
    -141.70578215046154469, 63.31961305621511116,
    -132.12712761110685733, 60.78156430751474204,
    -123.85428534979440940, 57.82417470821775396,
    -116.68240638414138743, 54.56141374911145192,
    -110.39390839554111778, 51.08045112569507751,
    -104.79614728017998004, 47.44644408577498496,
    -99.73088255981890882, 43.70821480745370025,
    -95.07197748871266185, 39.90302877816822757,
    -90.71961138434764393, 36.06017287638244539,
    -86.59435351833845118, 32.20351875194761959,
    -82.63216392910496211, 28.35333972343855180,
    -78.78048521884275601, 24.52760876444716587,
    -74.99529352424694650, 20.74294398926493699,
    -71.23891693218340038, 17.01531594444593409,
    -67.47845003929684538, 13.36059248585088000,
    -63.68463403089357655, 9.79496963802120746,
    -59.83111160507219495, 6.33531713186757095,
    -55.89399913408760057, 2.99945241539763385,
    -51.85174332801064168, -0.19365520038940884,
    -47.68524592294902931, -3.22375917751487107,
    -43.37824652323212860, -6.06930752874207258,
    -38.91794868987490474, -8.70753794849322738,
    -34.29585521437643081, -11.11472732454917889,
    -29.50874372060167872, -13.26662598462660014,
    -24.55966518490711081, -15.13909773195327269,
    -19.45879403720245193, -16.70896594558295334,
    -14.22391622121718058, -17.95503295463869264,
    -8.88033504279663255, -18.85919797266866738,
    -3.46002704385166071, -19.40755726556070115,
    1.99999999999999556, -25.43837119820565817,
    7.91994134356474966, -25.23910692117755517,
    13.78834011215970534, -24.64516330804185529,
    19.55772615655293478, -23.66774871950556403,
    25.18808138888132220, -22.32448212182583092,
    30.64904852681420522, -20.63801909702449677,
    35.92081946357622968, -18.63449057116782726,
    40.99386004100856695, -16.34197985921977292,
    45.86781613095838850, -13.78920372951385431,
    50.54999441522539882, -11.00448645615600007,
    55.05375641269628773, -8.01504773475606846,
    59.39706222812605318, -4.84657887125735343,
    63.60129716846514469, -1.52305829704237761,
    67.69043463465565935, 1.93324784086672352,
    71.69053915995505122, 5.50164833296652045,
    75.62959031828353318, 9.16278970353470612,
    79.53760403336076479, 12.89834287286321945,
    83.44703540885105042, 16.69062430422997068,
    87.39346098727328638, 20.52214967325533124,
    91.41655400532015108, 24.37510563102819106,
    95.56137924921046078, 28.23071203179445021,
    99.88003723653145016, 32.06843215731343832,
    104.43366587620558050, 35.86497163386139420,
    109.29473060869932510, 39.59298941537671368,
    114.54933935400606515, 43.21943287866469774,
    120.29889149413013172, 46.70342202473147353,
    126.65952710171551132, 49.99368843662634987,
    133.75638606304184464, 53.02581189527145256,
    141.70772458687929429, 55.72003625021812923,
    150.59283359977422379, 57.98141283097308474,
    160.40162010671977555, 59.70518607312001080,
    170.97884079028881388, 60.79043532425958318,
    -178.00000000000002842, 61.16162880179432193,
    -166.97884079028878546, 60.79043532425958318,
    -156.40162010671977555, 59.70518607312001080,
    -146.59283359977425221, 57.98141283097308474,
    -137.70772458687926587, 55.72003625021812923,
    -129.75638606304184464, 53.02581189527145256,
    -122.65952710171549711, 49.99368843662634987,
    -116.29889149413011751, 46.70342202473147353,
    -110.54933935400606515, 43.21943287866469774,
    -105.29473060869931089, 39.59298941537671368,
    -100.43366587620559471, 35.86497163386139420,
    -95.88003723653146437, 32.06843215731343832,
    -91.56137924921046078, 28.23071203179445021,
    -87.41655400532016529, 24.37510563102819106,
    -83.39346098727328638, 20.52214967325533124,
    -79.44703540885105042, 16.69062430422997068,
    -75.53760403336077900, 12.89834287286321945,
    -71.62959031828354739, 9.16278970353470612,
    -67.69053915995506543, 5.50164833296652045,
    -63.69043463465567356, 1.93324784086672352,
    -59.60129716846515180, -1.52305829704237761,
    -55.39706222812606740, -4.84657887125735343,
    -51.05375641269629483, -8.01504773475606846,
    -46.54999441522540593, -11.00448645615600007,
    -41.86781613095839560, -13.78920372951385431,
    -36.99386004100857406, -16.34197985921977292,
    -31.92081946357624389, -18.63449057116782726,
    -26.64904852681421943, -20.63801909702449677,
    -21.18808138888132575, -22.32448212182583092,
    -15.55772615655294011, -23.66774871950556403,
    -9.78834011215971245, -24.64516330804185529,
    -3.91994134356475854, -25.23910692117755517,
    1.99999999999999600, -31.84350531560286868,
    8.47781225763252877, -31.62546289221583962,
    14.88583393507996711, -30.97645080660140593,
    21.16079514785619509, -29.91127029421520689,
    27.25113130544622919, -28.45290874783366775,
    33.11998552133064067, -26.63042818683534207,
    38.74589265732009835, -24.47666503668304117,
    44.12160159745183563, -22.02610835172851722,
    49.25177543408178593, -19.31318879069118211,
    54.15029168417838434, -16.37106576006627279,
    58.83767345094592827, -13.23089104518995640,
    63.33895182482493169, -9.92146778444056032,
    67.68207179147748320, -6.46920580966549874,
    71.89683474738467339, -2.89828246890513030,
    76.01431282527251199, 0.76906207426874740,
    80.06665407661380129, 4.51214364124032485,
    84.08720437104130951, 8.31139512800513636,
    88.11088800598805904, 12.14788119395578647,
    92.17480572169650088, 16.00276430383186366,
    96.31902021078285259, 19.85670886149115333,
    100.58749981932022877, 23.68920100972959730,
    105.02917319698201482, 27.47775433026597725,
    109.69899804029304846, 31.19696754875727152,
    114.65884380836618561, 34.81740352705595143,
    119.97779813807069615, 38.30427835916992052,
    125.73118977168117283, 41.61600262291977259,
    131.99715883033749719, 44.70273256173389598,
    138.84908760812987794, 47.50530446205828383,
    146.34201331309026273, 49.95526128262041254,
    154.49218436749947614, 51.97706503648645082,
    163.25249258416440057, 53.49372597518600259,
    172.49285933765111167, 54.43639475342744305,
    -178.00000000000002842, 54.75649468439711143,
    -168.49285933765114009, 54.43639475342744305,
    -159.25249258416440057, 53.49372597518600259,
    -150.49218436749950456, 51.97706503648645082,
    -142.34201331309029115, 49.95526128262041254,
    -134.84908760812987794, 47.50530446205828383,
    -127.99715883033752561, 44.70273256173389598,
    -121.73118977168118704, 41.61600262291977259,
    -115.97779813807071037, 38.30427835916992052,
    -110.65884380836619982, 34.81740352705595143,
    -105.69899804029306267, 31.19696754875727152,
    -101.02917319698202903, 27.47775433026597725,
    -96.58749981932022877, 23.68920100972959730,
    -92.31902021078286680, 19.85670886149115333,
    -88.17480572169651509, 16.00276430383186366,
    -84.11088800598805904, 12.14788119395578647,
    -80.08720437104132372, 8.31139512800513636,
    -76.06665407661381550, 4.51214364124032485,
    -72.01431282527251199, 0.76906207426874740,
    -67.89683474738467339, -2.89828246890513030,
    -63.68207179147749031, -6.46920580966549874,
    -59.33895182482493880, -9.92146778444056032,
    -54.83767345094592827, -13.23089104518995640,
    -50.15029168417838434, -16.37106576006627279,
    -45.25177543408179304, -19.31318879069118211,
    -40.12160159745184274, -22.02610835172851722,
    -34.74589265732009835, -24.47666503668304117,
    -29.11998552133064422, -26.63042818683534207,
    -23.25113130544624340, -28.45290874783366775,
    -17.16079514785620930, -29.91127029421520689,
    -10.88583393507997776, -30.97645080660140593,
    -4.47781225763253765, -31.62546289221583962,
    1.99999999999999556, -38.87875527701606160,
    9.18708125479774296, -38.63683300066042392,
    16.27414365511956262, -37.91820250638208734,
    23.17259140539264095, -36.74332279213027164,
    29.81377244810832394, -35.14341202945125531,
    36.15298964123235947, -33.15698491696964822,
    42.16912769952225659, -30.82630445836842625,
    47.86123932751760179, -28.19436585459229860,
    53.24376548995357439, -25.30271165018388402,
    58.34173321358173325, -22.19009961204914561,
    63.18670666190918439, -18.89188184637555779,
    67.81377209114522486, -15.43989911427395079,
    72.25952713288313589, -11.86270778471484277,
    76.56090370117536281, -8.18599910867232694,
    80.75462189677602964, -4.43311662588922584,
    84.87709425893895343, -0.62561625366165385,
    88.96463936229967828, 3.21615784383777248,
    93.05390189983984328, 7.07248905242842518,
    97.18240447461120368, 10.92369066480776318,
    101.38917071735671982, 14.74948212031801020,
    105.71535755141637480, 18.52832281285148497,
    110.20481280215611264, 22.23668760419472790,
    114.90442707083992957, 25.84827445710250160,
    119.86406835852177721, 29.33315055785289260,
    125.13576891124590418, 32.65687547770472321,
    130.77168357131759535, 35.77969749489390949,
    136.82020109922683559, 38.65601141858346068,
    143.31958252044233859, 41.23439386179803279,
    150.28885177460347222, 43.45866798082070659,
    157.71667350566602295, 45.27051130755705799,
    165.55074086228117380, 46.61395503653132977,
    173.69217969866488716, 47.44157216781382402,
    -178.00000000000002842, 47.72124472298391851,
    -169.69217969866491558, 47.44157216781382402,
    -161.55074086228117380, 46.61395503653132977,
    -153.71667350566602295, 45.27051130755705799,
    -146.28885177460344380, 43.45866798082070659,
    -139.31958252044236701, 41.23439386179803279,
    -132.82020109922686402, 38.65601141858346068,
    -126.77168357131760956, 35.77969749489390949,
    -121.13576891124588997, 32.65687547770472321,
    -115.86406835852179142, 29.33315055785289260,
    -110.90442707083994378, 25.84827445710250160,
    -106.20481280215612685, 22.23668760419472790,
    -101.71535755141638901, 18.52832281285148497,
    -97.38917071735673403, 14.74948212031801020,
    -93.18240447461121789, 10.92369066480776318,
    -89.05390189983984328, 7.07248905242842518,
    -84.96463936229969249, 3.21615784383777248,
    -80.87709425893895343, -0.62561625366165385,
    -76.75462189677602964, -4.43311662588922584,
    -72.56090370117536281, -8.18599910867232694,
    -68.25952713288315010, -11.86270778471484277,
    -63.81377209114523907, -15.43989911427395079,
    -59.18670666190919150, -18.89188184637555779,
    -54.34173321358174746, -22.19009961204914561,
    -49.24376548995358149, -25.30271165018388402,
    -43.86123932751760890, -28.19436585459229860,
    -38.16912769952225659, -30.82630445836842625,
    -32.15298964123236658, -33.15698491696964822,
    -25.81377244810833815, -35.14341202945125531,
    -19.17259140539265516, -36.74332279213027164,
    -12.27414365511956973, -37.91820250638208734,
    -5.18708125479775184, -38.63683300066042392,
    1.99999999999999600, -46.61822072475269607,
    10.68839576675080139, -46.30624543028367412,
    19.18911080317679918, -45.38412606933155757,
    27.34546416576215222, -43.89055765093645078,
    35.05142021090807702, -41.88213387768103502,
    42.25559890256131013, -39.42480136235260346,
    48.95316063861176303, -36.58631299796493153,
    55.17233704527057370, -33.43100825355479344,
    60.96117255247643385, -30.01702215459737744,
    66.37723925505210332, -26.39536140379773599,
    71.48085419487965453, -22.61014977269736548,
    76.33122188826865795, -18.69947873486282575,
    80.98463901984250413, -14.69649678201448850,
    85.49400025392819202, -10.63053585607601548,
    89.90905356028720519, -6.52818370181667884,
    94.27704477012913742, -2.41427530523583922,
    98.64352777118510573, 1.68719008387413583,
    103.05319914949195947, 5.75218534812640314,
    107.55065416712271542, 9.75582109859903390,
    112.18096363521173942, 13.67152082594358298,
    116.98994385952536845, 17.47019805768939449,
    122.02393786261990272, 21.11944988981388605,
    127.32885205682140395, 24.58281725765701253,
    132.94811747553873715, 27.81921722445741807,
    138.91921485966395267, 30.78272820361294038,
    145.26850797118672176, 33.42299645292871446,
    152.00450116657361832, 35.68659928106228563,
    159.11038900941949237, 37.51968052984662449,
    166.53782868216146085, 38.87197455633482690,
    174.20476659278793363, 39.70189618399167131,
    -178.00000000000002842, 39.98177927524729114,
    -170.20476659278793363, 39.70189618399167131,
    -162.53782868216148927, 38.87197455633482690,
    -155.11038900941949237, 37.51968052984662449,
    -148.00450116657361832, 35.68659928106228563,
    -141.26850797118672176, 33.42299645292871446,
    -134.91921485966395267, 30.78272820361294038,
    -128.94811747553873715, 27.81921722445741807,
    -123.32885205682140395, 24.58281725765701253,
    -118.02393786261990272, 21.11944988981388605,
    -112.98994385952538266, 17.47019805768939449,
    -108.18096363521175363, 13.67152082594358298,
    -103.55065416712271542, 9.75582109859903390,
    -99.05319914949195947, 5.75218534812640314,
    -94.64352777118511995, 1.68719008387413583,
    -90.27704477012913742, -2.41427530523583922,
    -85.90905356028720519, -6.52818370181667884,
    -81.49400025392820623, -10.63053585607601548,
    -76.98463901984250413, -14.69649678201448850,
    -72.33122188826867216, -18.69947873486282575,
    -67.48085419487966874, -22.61014977269736548,
    -62.37723925505212463, -26.39536140379773599,
    -56.96117255247644096, -30.01702215459737744,
    -51.17233704527057370, -33.43100825355479344,
    -44.95316063861176303, -36.58631299796493153,
    -38.25559890256131723, -39.42480136235260346,
    -31.05142021090808413, -41.88213387768103502,
    -23.34546416576216643, -43.89055765093645078,
    -15.18911080317680451, -45.38412606933155757,
    -6.68839576675080849, -46.30624543028367412,
    1.99999999999999556, -55.13279625041899834,
    12.21451927262477000, -54.76594013073760436,
    22.09872704828332957, -53.68864395349499574,
    31.39769711559288012, -51.96422430511800883,
    39.96960367385942448, -49.68040408706254141,
    47.77902429867568657, -46.93247902115530223,
    54.86545369174167064, -43.81109166541020983,
    61.30916699148811233, -40.39598469592146301,
    67.20576633421555357, -36.75430974219705860,
    72.65107920217620574, -32.94148403257256064,
    77.73388667252179118, -29.00309226896920123,
    82.53343020155088539, -24.97699141478170048,
    87.11942634360052296, -20.89524495725207132,
    91.55320457280680557, -16.78577161643180204,
    95.88921878897831164, -12.67371220268469578,
    100.17656220612792595, -8.58256192749418645,
    104.46031614728221371, -4.53512373056416251,
    108.78265670493264849, -0.55433148808729282,
    113.18367588372132104, 3.33602075627005812,
    117.70187269530691765, 7.11062322287716331,
    122.37425008640165913, 10.74206713847307348,
    127.23592626204656142, 14.20035582641498806,
    132.31914580979304219, 17.45256126555711873,
    137.65157520973264127, 20.46271167815037728,
    143.25381666270027381, 23.19203115841211726,
    149.13620894054645305, 25.59967735271198208,
    155.29523174265207786, 27.64411687523928052,
    161.71017626763577368, 29.28521267182223298,
    168.34108626834759548, 30.48695101230148552,
    175.12910064316457692, 31.22051723140710777,
    -178.00000000000002842, 31.46720374958099598,
    -171.12910064316457692, 31.22051723140710777,
    -164.34108626834762390, 30.48695101230148552,
    -157.71017626763574526, 29.28521267182223298,
    -151.29523174265207786, 27.64411687523928052,
    -145.13620894054648147, 25.59967735271198208,
    -139.25381666270027381, 23.19203115841211726,
    -133.65157520973266969, 20.46271167815037728,
    -128.31914580979304219, 17.45256126555711873,
    -123.23592626204654721, 14.20035582641498806,
    -118.37425008640165913, 10.74206713847307348,
    -113.70187269530693186, 7.11062322287716331,
    -109.18367588372132104, 3.33602075627005812,
    -104.78265670493266271, -0.55433148808729282,
    -100.46031614728222792, -4.53512373056416251,
    -96.17656220612794016, -8.58256192749418645,
    -91.88921878897831164, -12.67371220268469578,
    -87.55320457280681978, -16.78577161643180204,
    -83.11942634360052296, -20.89524495725207132,
    -78.53343020155088539, -24.97699141478170048,
    -73.73388667252179118, -29.00309226896920123,
    -68.65107920217620574, -32.94148403257256064,
    -63.20576633421556068, -36.75430974219705860,
    -57.30916699148811233, -40.39598469592146301,
    -50.86545369174167774, -43.81109166541020983,
    -43.77902429867569367, -46.93247902115530223,
    -35.96960367385943158, -49.68040408706254141,
    -27.39769711559288723, -51.96422430511800883,
    -18.09872704828334022, -53.68864395349499574,
    -8.21451927262477888, -54.76594013073760436,
    1.99999999999999556, -64.48162218246979194,
    17.98037118830460201, -63.76341508305665684,
    32.62428016143745424, -61.72174914658255318,
    45.26325159838053480, -58.62403790832021144,
    55.90710322947827393, -54.76300160634040992,
    64.89227178252910733, -50.38082342875218700,
    72.61131289029847835, -45.65520975111467550,
    79.40370496549049051, -40.71192873614232610,
    85.53547443418635510, -35.64102404029981841,
    91.20945067766287195, -30.50961194071436822,
    96.58116190590757810, -25.37072818781791383,
    101.77265218881962028, -20.26925377022463337,
    106.88281945262124850, -15.24594064653214254,
    111.99465974304708027, -10.34025377357217934,
    117.18006743498143862, -5.59247248797413388,
    122.50268451884780063, -1.04529436283411115,
    128.01906809075350679, 3.25496397729521814,
    133.77826339847268855, 7.25759760165333567,
    139.81978239976487544, 10.90731557455581502,
    146.17005258660478262, 14.14485028302005709,
    152.83768595785250000, 16.90865838596959492,
    159.80845268931921055, 19.13794220572577487,
    167.04151372648448159, 20.77699151155475477,
    174.46891148411387462, 21.78042227826199806,
    -178.00000000000002842, 22.11837781753019527,
    -170.46891148411387462, 21.78042227826199806,
    -163.04151372648448159, 20.77699151155475477,
    -155.80845268931921055, 19.13794220572577487,
    -148.83768595785252842, 16.90865838596959492,
    -142.17005258660481104, 14.14485028302005709,
    -135.81978239976487544, 10.90731557455581502,
    -129.77826339847271697, 7.25759760165333567,
    -124.01906809075352101, 3.25496397729521814,
    -118.50268451884778642, -1.04529436283411115,
    -113.18006743498142441, -5.59247248797413388,
    -107.99465974304709448, -10.34025377357217934,
    -102.88281945262124850, -15.24594064653214254,
    -97.77265218881962028, -20.26925377022463337,
    -92.58116190590757810, -25.37072818781791383,
    -87.20945067766288616, -30.50961194071436822,
    -81.53547443418635510, -35.64102404029981841,
    -75.40370496549049051, -40.71192873614232610,
    -68.61131289029849256, -45.65520975111467550,
    -60.89227178252910733, -50.38082342875218700,
    -51.90710322947828104, -54.76300160634040992,
    -41.26325159838054901, -58.62403790832021144,
    -28.62428016143746490, -61.72174914658255318,
    -13.98037118830460557, -63.76341508305665684,
    1.99999999999999489, -74.69966643845165777,
    26.73698176730493614, -73.50791820369254026,
    46.45208209886830275, -70.36956689494368788,
    60.80977159628141493, -66.05660901455554779,
    71.45848324441054444, -61.11675773175377913,
    79.80759217874309286, -55.85321872580696834,
    86.74466514239207982, -50.43213273346431436,
    92.80540124701705906, -44.95206516381727369,
    98.32251211109890221, -39.47845092120540045,
    103.51336526710929320, -34.06038011063251503,
    108.52834753231333309, -28.73921107936183361,
    113.47768355265095863, -23.55333544230752452,
    118.44656525084906207, -18.54103902309049090,
    123.50369215326308847, -13.74234202233444968,
    128.70582948829564884, -9.20020460514958671,
    134.09971622507504208, -4.96122571165357140,
    139.72202213508867885, -1.07580930674149267,
    145.59779383610683112, 2.40232548413760538,
    151.73783261271663036, 5.41746050329454931,
    158.13565186637288207, 7.91416414131925894,
    164.76497871932286898, 9.84055665005913660,
    171.57900980622665088, 11.15231427016150256,
    178.51254101195692670, 11.81685015330946520,
    -174.51254101195692670, 11.81685015330946520,
    -167.57900980622667930, 11.15231427016150256,
    -160.76497871932289740, 9.84055665005913660,
    -154.13565186637291049, 7.91416414131925894,
    -147.73783261271665879, 5.41746050329454931,
    -141.59779383610683112, 2.40232548413760538,
    -135.72202213508870727, -1.07580930674149267,
    -130.09971622507501365, -4.96122571165357140,
    -124.70582948829567727, -9.20020460514958671,
    -119.50369215326308847, -13.74234202233444968,
    -114.44656525084907628, -18.54103902309049090,
    -109.47768355265095863, -23.55333544230752452,
    -104.52834753231334730, -28.73921107936183361,
    -99.51336526710929320, -34.06038011063251503,
    -94.32251211109890221, -39.47845092120540045,
    -88.80540124701705906, -44.95206516381727369,
    -82.74466514239209403, -50.43213273346431436,
    -75.80759217874310707, -55.85321872580696834,
    -67.45848324441054444, -61.11675773175377913,
    -56.80977159628143625, -66.05660901455554779,
    -42.45208209886832407, -70.36956689494368788,
    -22.73698176730495391, -73.50791820369254026,
    1.99999999999999600, -85.78166687108885924,
    61.87324357773108119, -82.33459525449173100,
    80.27768438369075454, -76.54083121758115738,
    89.42499621356618889, -70.41813086842684299,
    95.82057104813959825, -64.24948773689966686,
    101.11263541171206271, -58.11928872485961506,
    105.90317607822892398, -52.07335345715245722,
    110.47134737780878311, -46.14758359783259323,
    114.97138028465980142, -40.37601690822956613,
    119.50120511177952665, -34.79395188944583595,
    124.13018318901127657, -29.43951176908901957,
    128.91129483912590104, -24.35455549606792047,
    133.88641650799124250, -19.58517424494497305,
    139.08801440266989857, -15.18177122287804615,
    144.53869867413172301, -11.19861017149900739,
    150.24942513902280439, -7.69266569608215622,
    156.21700460768090579, -4.72161659803606781,
    162.42170502724644621, -2.34091526057735644,
    168.82591385569978115, -0.60006016949341945,
    175.37485237931247184, 0.46152536384328491,
    -178.00000000000002842, 0.81833312891115950,
    -171.37485237931247184, 0.46152536384328491,
    -164.82591385569978115, -0.60006016949341945,
    -158.42170502724641779, -2.34091526057735644,
    -152.21700460768090579, -4.72161659803606781,
    -146.24942513902283281, -7.69266569608215622,
    -140.53869867413175143, -11.19861017149900739,
    -135.08801440266989857, -15.18177122287804615,
    -129.88641650799127092, -19.58517424494497305,
    -124.91129483912591525, -24.35455549606792047,
    -120.13018318901130499, -29.43951176908901957,
    -115.50120511177955507, -34.79395188944583595,
    -110.97138028465980142, -40.37601690822956613,
    -106.47134737780881153, -46.14758359783259323,
    -101.90317607822893820, -52.07335345715245722,
    -97.11263541171207692, -58.11928872485961506,
    -91.82057104813961246, -64.24948773689966686,
    -85.42499621356618889, -70.41813086842684299,
    -76.27768438369074033, -76.54083121758115738,
    -57.87324357773110250, -82.33459525449173100,
    -178.00000000000002842, -82.33591847955618448,
    143.22778135121401988, -79.54230031515010069,
    128.60898756414843547, -73.87349687490876704,
    124.32470998353319658, -67.47696540683871547,
    124.01228809564837263, -60.93070105520797597,
    125.59604777627561134, -54.43751136022503090,
    128.28024682035200499, -48.10755262562803125,
    131.71480673751509016, -42.02394287044850074,
    135.73150447900647464, -36.26259289105208694,
    140.24424010430539056, -30.89942669541638764,
    145.20455296082769792, -26.01294410398721979,
    150.57821873782722832, -21.68429473238734317,
    156.33085313434582986, -17.99542592709287092,
    162.41822389716838870, -15.02545489467462048,
    168.78020742076520833, -12.84550987892848184,
    175.33870321353637678, -11.51266748991093536,
    -178.00000000000002842, -11.06408152044378745,
    -171.33870321353637678, -11.51266748991093536,
    -164.78020742076523675, -12.84550987892848184,
    -158.41822389716841712, -15.02545489467462048,
    -152.33085313434585828, -17.99542592709287092,
    -146.57821873782722832, -21.68429473238734317,
    -141.20455296082769792, -26.01294410398721979,
    -136.24424010430539056, -30.89942669541638764,
    -131.73150447900647464, -36.26259289105208694,
    -127.71480673751507595, -42.02394287044850074,
    -124.28024682035203341, -48.10755262562803125,
    -121.59604777627559713, -54.43751136022503090,
    -120.01228809564838684, -60.93070105520797597,
    -120.32470998353322500, -67.47696540683871547,
    -124.60898756414846389, -73.87349687490876704,
    -139.22778135121404830, -79.54230031515010069,
    -178.00000000000002842, -69.79343463141964321,
    167.63134400963940607, -68.62304968612301082,
    156.89871695437406629, -65.48334135458465255,
    150.54736374030309776, -61.10651485448561715,
    147.65287319536125210, -56.10790502157546911,
    147.17953110490091717, -50.89570090116846757,
    148.39568884343808008, -45.73876083396746139,
    150.83543074335267420, -40.82969132012996027,
    154.20166627754437627, -36.32066069380964279,
    158.29374271187359113, -32.34078423455542861,
    162.96127389198957758, -29.00296899656860816,
    168.07572003197756771, -26.40464312032804983,
    173.51374580520655400, -24.62495078480371546,
    179.14909640850049755, -23.72034636702055366,
    -175.14909640850046912, -23.72034636702055366,
    -169.51374580520655400, -24.62495078480371546,
    -164.07572003197756771, -26.40464312032806049,
    -158.96127389198957758, -29.00296899656861527,
    -154.29374271187361956, -32.34078423455542861,
    -150.20166627754440469, -36.32066069380964279,
    -146.83543074335270262, -40.82969132012996027,
    -144.39568884343808008, -45.73876083396746139,
    -143.17953110490091717, -50.89570090116849599,
    -143.65287319536128052, -56.10790502157547621,
    -146.54736374030309776, -61.10651485448561715,
    -152.89871695437406629, -65.48334135458465255,
    -163.63134400963940607, -68.62304968612301082,
    -178.00000000000002842, -56.85258712078380228,
    176.37525674045562596, -56.23764348052387874,
    171.72066876086481102, -54.50623527875517738,
    168.62326642581021474, -51.94637057143930292,
    167.22080918295719698, -48.91487419033276751,
    167.36621335583259906, -45.75617589753742465,
    168.79950790329058918, -42.76713193279059766,
    171.24101930549505823, -40.18968456371464271,
    174.42266827604018431, -38.21219158951615213,
    178.09065200901943626, -36.97055608025468132,
    -178.00000000000002842, -36.54741287921620341,
    -174.09065200901946469, -36.97055608025468132,
    -170.42266827604018431, -38.21219158951615213,
    -167.24101930549508666, -40.18968456371464271,
    -164.79950790329061761, -42.76713193279059766,
    -163.36621335583262749, -45.75617589753742465,
    -163.22080918295719698, -48.91487419033276751,
    -164.62326642581024316, -51.94637057143930292,
    -167.72066876086483944, -54.50623527875517738,
    -172.37525674045562596, -56.23764348052387874 };
};

namespace atlas {
namespace test {
CASE("t31c2.4") {
    auto nx = std::vector<int>{20, 27, 32, 40, 45, 48, 60, 60, 64, 64, 64, 64, 64, 64, 64, 64,
                               64, 64, 64, 64, 64, 64, 64, 64, 60, 60, 48, 45, 40, 32, 27, 20};

    auto proj = Projection("rotated_schmidt", Config("stretching_factor", 2.4) | Config("rotation_angle", 180.0) |
                                                  Config("north_pole", {2.0, 46.7}));

    auto grid = ReducedGaussianGrid(nx, proj);

    for (int j = 0, jglo = 0; j < grid.ny(); j++) {
        for (int i = 0; i < grid.nx(j); i++, jglo++) {
            auto ll1 = PointLonLat(lonlat_arp_t32c24[2 * jglo + 0], lonlat_arp_t32c24[2 * jglo + 1]);
            auto ll2 = grid.lonlat(i, j);
            EXPECT_APPROX_EQ(ll1.lon(), ll2.lon(), 1.e-9);
            EXPECT_APPROX_EQ(ll1.lat(), ll2.lat(), 1.e-9);
        }
    }
}


}  // namespace test
}  // namespace atlas


int main(int argc, char* argv[]) {
    return atlas::test::run(argc, argv);
}
