/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
*/
/* First off, code is include which follows the "include" declaration
** in the input file. */
#include <stdio.h>
#line 30 "tmp.y"


#include <stdlib.h>
#include "parser-lib.h"
#include "xdl-parser.h"
#include "xdl.h"

#define YYDEBUG(state, ch) \
  printf("lexer:%d:%c\n", state, ch)

DECLARE_LEXER()

main:

  {
    unsigned char yych;

    yych = *c;
    if (yych <= '=') {
      if (yych <= '(') {
        if (yych <= 0x0C) {
          if (yych <= 0x00) goto yy34;
          if (yych <= 0x08) goto yy36;
          if (yych <= 0x0A) goto yy6;
          goto yy36;
        } else {
          if (yych <= 0x1F) {
            if (yych <= 0x0D) goto yy6;
            goto yy36;
          } else {
            if (yych <= ' ') goto yy6;
            if (yych <= '\'') goto yy36;
            goto yy28;
          }
        }
      } else {
        if (yych <= '/') {
          if (yych <= '+') {
            if (yych <= ')') goto yy30;
            goto yy36;
          } else {
            if (yych <= ',') goto yy32;
            if (yych <= '.') goto yy36;
          }
        } else {
          if (yych <= ':') {
            if (yych <= '9') goto yy16;
            goto yy36;
          } else {
            if (yych <= ';') goto yy20;
            if (yych <= '<') goto yy4;
            goto yy18;
          }
        }
      }
    } else {
      if (yych <= 'e') {
        if (yych <= '^') {
          if (yych <= '>') goto yy22;
          if (yych <= '@') goto yy36;
          if (yych <= 'Z') goto yy15;
          goto yy36;
        } else {
          if (yych <= '`') {
            if (yych <= '_') goto yy8;
            goto yy36;
          } else {
            if (yych <= 'a') goto yy13;
            if (yych <= 'd') goto yy15;
            goto yy10;
          }
        }
      } else {
        if (yych <= 't') {
          if (yych <= 'n') {
            if (yych <= 'm') goto yy15;
            goto yy11;
          } else {
            if (yych <= 'r') goto yy15;
            if (yych <= 's') goto yy12;
            goto yy14;
          }
        } else {
          if (yych <= '{') {
            if (yych <= 'z') goto yy15;
            goto yy24;
          } else {
            if (yych == '}') goto yy26;
            goto yy36;
          }
        }
      }
    }
    yych = *++c;
    if (yych == '*') goto yy156;
    if (yych == '/') goto yy158;
yy3:
    { RET(TK_UNKNOWN); }
yy4:
    ++c;
    if ((yych = *c) == '%') goto yy154;
    { RET(TK_LT); }
yy6:
    ++c;
    yych = *c;
    goto yy153;
yy7:
    { EAT(); goto main; }
yy8:
    ++c;
    if ((yych = *c) == '_') goto yy77;
    goto yy40;
yy9:
    { RET(TK_ID); }
yy10:
    yych = *++c;
    if (yych == 'r') goto yy72;
    goto yy40;
yy11:
    yych = *++c;
    if (yych == 'a') goto yy63;
    goto yy40;
yy12:
    yych = *++c;
    if (yych == 'e') goto yy50;
    if (yych == 't') goto yy51;
    goto yy40;
yy13:
    yych = *++c;
    if (yych == 'r') goto yy45;
    goto yy40;
yy14:
    yych = *++c;
    if (yych == 'a') goto yy41;
    goto yy40;
yy15:
    yych = *++c;
    goto yy40;
yy16:
    ++c;
    yych = *c;
    goto yy38;
yy17:
    { RET(TK_INTEGER); }
yy18:
    ++c;
    { RET(TK_EQ); }
yy20:
    ++c;
    { RET(TK_SEMICOL); }
yy22:
    ++c;
    { RET(TK_GT); }
yy24:
    ++c;
    { RET(TK_LB); }
yy26:
    ++c;
    { RET(TK_RB); }
yy28:
    ++c;
    { RET(TK_LP); }
yy30:
    ++c;
    { RET(TK_RP); }
yy32:
    ++c;
    { RET(TK_COMMA); }
yy34:
    ++c;
    { RET(TK_EOF); }
yy36:
    yych = *++c;
    goto yy3;
yy37:
    ++c;
    yych = *c;
yy38:
    if (yych <= '/') goto yy17;
    if (yych <= '9') goto yy37;
    goto yy17;
yy39:
    ++c;
    yych = *c;
yy40:
    if (yych <= 'Z') {
      if (yych <= '/') goto yy9;
      if (yych <= '9') goto yy39;
      if (yych <= '@') goto yy9;
      goto yy39;
    } else {
      if (yych <= '_') {
        if (yych <= '^') goto yy9;
        goto yy39;
      } else {
        if (yych <= '`') goto yy9;
        if (yych <= 'z') goto yy39;
        goto yy9;
      }
    }
yy41:
    yych = *++c;
    if (yych != 'k') goto yy40;
    yych = *++c;
    if (yych != 'e') goto yy40;
    ++c;
    if ((yych = *c) <= 'Z') {
      if (yych <= '/') goto yy44;
      if (yych <= '9') goto yy39;
      if (yych >= 'A') goto yy39;
    } else {
      if (yych <= '_') {
        if (yych >= '_') goto yy39;
      } else {
        if (yych <= '`') goto yy44;
        if (yych <= 'z') goto yy39;
      }
    }
yy44:
    { RET(TK_TAKE); }
yy45:
    yych = *++c;
    if (yych != 'r') goto yy40;
    yych = *++c;
    if (yych != 'a') goto yy40;
    yych = *++c;
    if (yych != 'y') goto yy40;
    ++c;
    if ((yych = *c) <= 'Z') {
      if (yych <= '/') goto yy49;
      if (yych <= '9') goto yy39;
      if (yych >= 'A') goto yy39;
    } else {
      if (yych <= '_') {
        if (yych >= '_') goto yy39;
      } else {
        if (yych <= '`') goto yy49;
        if (yych <= 'z') goto yy39;
      }
    }
yy49:
    { RET(TK_ARRAY); }
yy50:
    yych = *++c;
    if (yych == 'r') goto yy57;
    goto yy40;
yy51:
    yych = *++c;
    if (yych != 'r') goto yy40;
    yych = *++c;
    if (yych != 'u') goto yy40;
    yych = *++c;
    if (yych != 'c') goto yy40;
    yych = *++c;
    if (yych != 't') goto yy40;
    ++c;
    if ((yych = *c) <= 'Z') {
      if (yych <= '/') goto yy56;
      if (yych <= '9') goto yy39;
      if (yych >= 'A') goto yy39;
    } else {
      if (yych <= '_') {
        if (yych >= '_') goto yy39;
      } else {
        if (yych <= '`') goto yy56;
        if (yych <= 'z') goto yy39;
      }
    }
yy56:
    { RET(TK_STRUCT); }
yy57:
    yych = *++c;
    if (yych != 'v') goto yy40;
    yych = *++c;
    if (yych != 'l') goto yy40;
    yych = *++c;
    if (yych != 'e') goto yy40;
    yych = *++c;
    if (yych != 't') goto yy40;
    ++c;
    if ((yych = *c) <= 'Z') {
      if (yych <= '/') goto yy62;
      if (yych <= '9') goto yy39;
      if (yych >= 'A') goto yy39;
    } else {
      if (yych <= '_') {
        if (yych >= '_') goto yy39;
      } else {
        if (yych <= '`') goto yy62;
        if (yych <= 'z') goto yy39;
      }
    }
yy62:
    { RET(TK_SERVLET); }
yy63:
    yych = *++c;
    if (yych != 'm') goto yy40;
    yych = *++c;
    if (yych != 'e') goto yy40;
    yych = *++c;
    if (yych != 's') goto yy40;
    yych = *++c;
    if (yych != 'p') goto yy40;
    yych = *++c;
    if (yych != 'a') goto yy40;
    yych = *++c;
    if (yych != 'c') goto yy40;
    yych = *++c;
    if (yych != 'e') goto yy40;
    ++c;
    if ((yych = *c) <= 'Z') {
      if (yych <= '/') goto yy71;
      if (yych <= '9') goto yy39;
      if (yych >= 'A') goto yy39;
    } else {
      if (yych <= '_') {
        if (yych >= '_') goto yy39;
      } else {
        if (yych <= '`') goto yy71;
        if (yych <= 'z') goto yy39;
      }
    }
yy71:
    { RET(TK_NAMESPACE); }
yy72:
    yych = *++c;
    if (yych != 'r') goto yy40;
    yych = *++c;
    if (yych != 'o') goto yy40;
    yych = *++c;
    if (yych != 'r') goto yy40;
    ++c;
    if ((yych = *c) <= 'Z') {
      if (yych <= '/') goto yy76;
      if (yych <= '9') goto yy39;
      if (yych >= 'A') goto yy39;
    } else {
      if (yych <= '_') {
        if (yych >= '_') goto yy39;
      } else {
        if (yych <= '`') goto yy76;
        if (yych <= 'z') goto yy39;
      }
    }
yy76:
    { RET(TK_ERROR); }
yy77:
    yych = *++c;
    switch (yych) {
    case 'a':  goto yy80;
    case 'd':  goto yy82;
    case 'f':  goto yy79;
    case 'i':  goto yy78;
    case 'p':  goto yy81;
    case 'u':  goto yy83;
    default:  goto yy40;
    }
yy78:
    yych = *++c;
    if (yych == 'n') goto yy146;
    goto yy40;
yy79:
    yych = *++c;
    if (yych == 'a') goto yy130;
    if (yych == 'i') goto yy131;
    goto yy40;
yy80:
    yych = *++c;
    if (yych == 't') goto yy123;
    goto yy40;
yy81:
    yych = *++c;
    if (yych == 'o') goto yy102;
    if (yych == 'r') goto yy103;
    goto yy40;
yy82:
    yych = *++c;
    if (yych == 'o') goto yy92;
    goto yy40;
yy83:
    yych = *++c;
    if (yych != 'p') goto yy40;
    yych = *++c;
    if (yych != 'l') goto yy40;
    yych = *++c;
    if (yych != 'o') goto yy40;
    yych = *++c;
    if (yych != 'a') goto yy40;
    yych = *++c;
    if (yych != 'd') goto yy40;
    yych = *++c;
    if (yych != '_') goto yy40;
    yych = *++c;
    if (yych != '_') goto yy40;
    ++c;
    if ((yych = *c) <= 'Z') {
      if (yych <= '/') goto yy91;
      if (yych <= '9') goto yy39;
      if (yych >= 'A') goto yy39;
    } else {
      if (yych <= '_') {
        if (yych >= '_') goto yy39;
      } else {
        if (yych <= '`') goto yy91;
        if (yych <= 'z') goto yy39;
      }
    }
yy91:
    { RET(TK_UPLOAD); }
yy92:
    yych = *++c;
    if (yych != 'w') goto yy40;
    yych = *++c;
    if (yych != 'n') goto yy40;
    yych = *++c;
    if (yych != 'l') goto yy40;
    yych = *++c;
    if (yych != 'o') goto yy40;
    yych = *++c;
    if (yych != 'a') goto yy40;
    yych = *++c;
    if (yych != 'd') goto yy40;
    yych = *++c;
    if (yych != '_') goto yy40;
    yych = *++c;
    if (yych != '_') goto yy40;
    ++c;
    if ((yych = *c) <= 'Z') {
      if (yych <= '/') goto yy101;
      if (yych <= '9') goto yy39;
      if (yych >= 'A') goto yy39;
    } else {
      if (yych <= '_') {
        if (yych >= '_') goto yy39;
      } else {
        if (yych <= '`') goto yy101;
        if (yych <= 'z') goto yy39;
      }
    }
yy101:
    { RET(TK_DOWNLOAD); }
yy102:
    yych = *++c;
    if (yych == 's') goto yy113;
    goto yy40;
yy103:
    yych = *++c;
    if (yych != 'e') goto yy40;
    yych = *++c;
    if (yych != '_') goto yy40;
    yych = *++c;
    if (yych != 'c') goto yy40;
    yych = *++c;
    if (yych != 'a') goto yy40;
    yych = *++c;
    if (yych != 'l') goto yy40;
    yych = *++c;
    if (yych != 'l') goto yy40;
    yych = *++c;
    if (yych != '_') goto yy40;
    yych = *++c;
    if (yych != '_') goto yy40;
    ++c;
    if ((yych = *c) <= 'Z') {
      if (yych <= '/') goto yy112;
      if (yych <= '9') goto yy39;
      if (yych >= 'A') goto yy39;
    } else {
      if (yych <= '_') {
        if (yych >= '_') goto yy39;
      } else {
        if (yych <= '`') goto yy112;
        if (yych <= 'z') goto yy39;
      }
    }
yy112:
    { RET(TK_PRECALL); }
yy113:
    yych = *++c;
    if (yych != 't') goto yy40;
    yych = *++c;
    if (yych != '_') goto yy40;
    yych = *++c;
    if (yych != 'c') goto yy40;
    yych = *++c;
    if (yych != 'a') goto yy40;
    yych = *++c;
    if (yych != 'l') goto yy40;
    yych = *++c;
    if (yych != 'l') goto yy40;
    yych = *++c;
    if (yych != '_') goto yy40;
    yych = *++c;
    if (yych != '_') goto yy40;
    ++c;
    if ((yych = *c) <= 'Z') {
      if (yych <= '/') goto yy122;
      if (yych <= '9') goto yy39;
      if (yych >= 'A') goto yy39;
    } else {
      if (yych <= '_') {
        if (yych >= '_') goto yy39;
      } else {
        if (yych <= '`') goto yy122;
        if (yych <= 'z') goto yy39;
      }
    }
yy122:
    { RET(TK_POSTCALL); }
yy123:
    yych = *++c;
    if (yych != 't') goto yy40;
    yych = *++c;
    if (yych != 'r') goto yy40;
    yych = *++c;
    if (yych != 's') goto yy40;
    yych = *++c;
    if (yych != '_') goto yy40;
    yych = *++c;
    if (yych != '_') goto yy40;
    ++c;
    if ((yych = *c) <= 'Z') {
      if (yych <= '/') goto yy129;
      if (yych <= '9') goto yy39;
      if (yych >= 'A') goto yy39;
    } else {
      if (yych <= '_') {
        if (yych >= '_') goto yy39;
      } else {
        if (yych <= '`') goto yy129;
        if (yych <= 'z') goto yy39;
      }
    }
yy129:
    { RET(TK_ATTRS); }
yy130:
    yych = *++c;
    if (yych == 'l') goto yy137;
    goto yy40;
yy131:
    yych = *++c;
    if (yych != 'n') goto yy40;
    yych = *++c;
    if (yych != 'i') goto yy40;
    yych = *++c;
    if (yych != '_') goto yy40;
    yych = *++c;
    if (yych != '_') goto yy40;
    ++c;
    if ((yych = *c) <= 'Z') {
      if (yych <= '/') goto yy136;
      if (yych <= '9') goto yy39;
      if (yych >= 'A') goto yy39;
    } else {
      if (yych <= '_') {
        if (yych >= '_') goto yy39;
      } else {
        if (yych <= '`') goto yy136;
        if (yych <= 'z') goto yy39;
      }
    }
yy136:
    { RET(TK_FINI); }
yy137:
    yych = *++c;
    if (yych != 'l') goto yy40;
    yych = *++c;
    if (yych != 'b') goto yy40;
    yych = *++c;
    if (yych != 'a') goto yy40;
    yych = *++c;
    if (yych != 'c') goto yy40;
    yych = *++c;
    if (yych != 'k') goto yy40;
    yych = *++c;
    if (yych != '_') goto yy40;
    yych = *++c;
    if (yych != '_') goto yy40;
    ++c;
    if ((yych = *c) <= 'Z') {
      if (yych <= '/') goto yy145;
      if (yych <= '9') goto yy39;
      if (yych >= 'A') goto yy39;
    } else {
      if (yych <= '_') {
        if (yych >= '_') goto yy39;
      } else {
        if (yych <= '`') goto yy145;
        if (yych <= 'z') goto yy39;
      }
    }
yy145:
    { RET(TK_FALLBACK); }
yy146:
    yych = *++c;
    if (yych != 'i') goto yy40;
    yych = *++c;
    if (yych != 't') goto yy40;
    yych = *++c;
    if (yych != '_') goto yy40;
    yych = *++c;
    if (yych != '_') goto yy40;
    ++c;
    if ((yych = *c) <= 'Z') {
      if (yych <= '/') goto yy151;
      if (yych <= '9') goto yy39;
      if (yych >= 'A') goto yy39;
    } else {
      if (yych <= '_') {
        if (yych >= '_') goto yy39;
      } else {
        if (yych <= '`') goto yy151;
        if (yych <= 'z') goto yy39;
      }
    }
yy151:
    { RET(TK_INIT); }
yy152:
    ++c;
    yych = *c;
yy153:
    if (yych <= 0x0C) {
      if (yych <= 0x08) goto yy7;
      if (yych <= 0x0A) goto yy152;
      goto yy7;
    } else {
      if (yych <= 0x0D) goto yy152;
      if (yych == ' ') goto yy152;
      goto yy7;
    }
yy154:
    ++c;
    { goto code; }
yy156:
    ++c;
    { goto comment; }
yy158:
    ++c;
    yych = *c;
    if (yych <= 0x00) goto yy160;
    if (yych != 0x0A) goto yy158;
yy160:
    ++c;
    { EAT(); goto main; }
  }


code:

  {
    unsigned char yych;
    yych = *c;
    if (yych <= 0x00) goto yy166;
    if (yych != '%') goto yy168;
    ++c;
    if ((yych = *c) == '>') goto yy169;
yy165:
    { goto code; }
yy166:
    ++c;
    { RET(TK_UNKNOWN); }
yy168:
    yych = *++c;
    goto yy165;
yy169:
    ++c;
    { RET(TK_CODE); }
  }


comment:

  {
    unsigned char yych;
    yych = *c;
    if (yych <= 0x00) goto yy175;
    if (yych != '*') goto yy177;
    ++c;
    if ((yych = *c) == '/') goto yy178;
yy174:
    { goto comment; }
yy175:
    ++c;
    { RET(TK_UNKNOWN); }
yy177:
    yych = *++c;
    goto yy174;
yy178:
    ++c;
    { EAT(); goto main; }
  }


DECLARE_LEXER_END()

DECLARE_PARSER(xdlParser, xdl_parse, xdl_model*);

#define MODEL ((xdl_model*)ctx->data)
#define _MODEL ctx->data

#line 710 "tmp.c"
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/* 
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands. 
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash 
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    xdlParserTOKENTYPE     is the data type used for minor tokens given 
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is xdlParserTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    xdlParserARG_SDECL     A static variable declaration for the %extra_argument
**    xdlParserARG_PDECL     A parameter declaration for the %extra_argument
**    xdlParserARG_STORE     Code to store %extra_argument into yypParser
**    xdlParserARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 51
#define YYACTIONTYPE unsigned char
#define xdlParserTOKENTYPE token*
typedef union {
  xdlParserTOKENTYPE yy0;
  xdl_struct_member* yy30;
  xdl_method_param* yy75;
  char* yy85;
  xdl_typedef* yy87;
  int yy92;
  GSList* yy93;
  xdl_method* yy95;
  token* yy96;
  int yy101;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define xdlParserARG_SDECL parser_context *ctx;
#define xdlParserARG_PDECL ,parser_context *ctx
#define xdlParserARG_FETCH parser_context *ctx = yypParser->ctx
#define xdlParserARG_STORE yypParser->ctx = ctx
#define YYNSTATE 79
#define YYNRULE 44
#define YYERRORSYMBOL 28
#define YYERRSYMDT yy101
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

/* Next are that tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.  
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
static const YYACTIONTYPE yy_action[] = {
 /*     0 */    41,  124,    1,   41,   17,   58,   77,   17,   51,   61,
 /*    10 */    39,   31,   32,   33,   34,   35,   36,   37,   38,   41,
 /*    20 */    79,   21,   41,   17,   27,   25,   17,  117,  117,   58,
 /*    30 */    31,   32,   33,   34,   35,   36,   37,   38,   15,   60,
 /*    40 */    11,    3,   54,   14,   51,   76,   43,   44,   45,   21,
 /*    50 */    28,    9,   12,   55,   74,   63,   48,   23,    7,   52,
 /*    60 */    23,   25,    4,   75,   16,   14,   26,   42,   43,   44,
 /*    70 */    45,   57,   11,   51,   12,    9,   30,   13,   74,   63,
 /*    80 */    47,   56,    8,    2,   18,   19,   46,   62,   16,   64,
 /*    90 */    25,   20,    6,   65,   22,   24,   10,   49,   50,   53,
 /*   100 */    29,    5,   59,   66,   67,   68,   69,   70,   71,   72,
 /*   110 */    73,  125,  125,  125,   40,  125,   78,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */     2,   29,   30,    2,    6,   27,   34,    6,    4,   11,
 /*    10 */     3,   13,   14,   15,   16,   17,   18,   19,   20,    2,
 /*    20 */     0,    9,    2,    6,   12,   21,    6,   25,   26,   27,
 /*    30 */    13,   14,   15,   16,   17,   18,   19,   20,   47,   48,
 /*    40 */    49,   31,   43,   33,    4,   35,   36,   37,   38,    9,
 /*    50 */    41,   33,   42,    1,   36,   37,   40,   41,   39,   40,
 /*    60 */    41,   21,   44,   45,   46,   33,   41,   35,   36,   37,
 /*    70 */    38,   48,   49,    4,   42,   33,   41,   10,   36,   37,
 /*    80 */    11,   25,   26,   32,    4,    7,    5,   45,   46,    1,
 /*    90 */    21,    8,   10,    5,    4,    4,   22,    5,   23,    4,
 /*   100 */     4,   24,    4,    1,    1,    1,    1,    1,    1,    1,
 /*   110 */     1,   50,   50,   50,    4,   50,    5,
};
#define YY_SHIFT_USE_DFLT (-23)
#define YY_SHIFT_MAX 40
static const signed char yy_shift_ofst[] = {
 /*     0 */     7,    1,   17,   20,   -2,    2,    4,   69,  -22,   40,
 /*    10 */     4,    4,   67,   52,   12,   56,   88,   80,   78,   83,
 /*    20 */    81,   90,   82,   91,   92,   74,   75,   95,   96,   77,
 /*    30 */    98,  102,  103,  104,  105,  106,  107,  108,  109,  110,
 /*    40 */   111,
};
#define YY_REDUCE_USE_DFLT (-29)
#define YY_REDUCE_MAX 13
static const signed char yy_reduce_ofst[] = {
 /*     0 */   -28,   10,   18,   32,   42,   -9,   19,   16,   23,    9,
 /*    10 */    25,   35,   -1,   51,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */    84,   82,   82,   82,   82,  120,  123,  123,  120,  123,
 /*    10 */   123,  123,  123,   80,  123,  123,  123,  123,  123,  123,
 /*    20 */   123,  123,  123,  123,  123,  123,  123,  123,  123,  123,
 /*    30 */   123,  123,  123,  123,  123,  123,  123,  123,  123,  123,
 /*    40 */   123,   83,   88,   89,   90,   91,   92,   93,   95,   96,
 /*    50 */   114,  115,   94,   98,   97,   81,  116,  119,  121,  122,
 /*    60 */   118,   99,  101,  102,  103,  104,  105,  106,  107,  108,
 /*    70 */   109,  110,  111,  112,  113,  100,   87,   85,   86,
};
#define YY_SZ_ACTTAB (int)(sizeof(yy_action)/sizeof(yy_action[0]))

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammer, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  int stateno;       /* The state-number */
  int major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
  YYMINORTYPE minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
  int yyerrcnt;                 /* Shifts left before out of the error */
  xdlParserARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void xdlParserTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  "$",             "CODE",          "DOC",           "NAMESPACE",   
  "ID",            "SEMICOL",       "ERROR",         "EQ",          
  "INTEGER",       "STRUCT",        "LB",            "RB",          
  "SERVLET",       "INIT",          "FINI",          "ATTRS",       
  "PRECALL",       "POSTCALL",      "FALLBACK",      "DOWNLOAD",    
  "UPLOAD",        "ARRAY",         "LT",            "GT",          
  "LP",            "RP",            "COMMA",         "TAKE",        
  "error",         "compilation_unit",  "opt_namespace_decl",  "toplevel_decls",
  "opt_inline_code",  "opt_doc_comment",  "namespace_decl",  "toplevel_decl",
  "error_decl",    "struct_decl",   "servlet_decl",  "struct_members",
  "struct_member",  "type",          "servlet_decl_head",  "servlet_decl_body",
  "servlet_body_decls",  "servlet_body_decl",  "method_decl",   "params",      
  "param",         "opt_owner",   
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "compilation_unit ::= opt_namespace_decl toplevel_decls",
 /*   1 */ "opt_inline_code ::=",
 /*   2 */ "opt_inline_code ::= CODE",
 /*   3 */ "opt_doc_comment ::=",
 /*   4 */ "opt_doc_comment ::= DOC",
 /*   5 */ "opt_namespace_decl ::=",
 /*   6 */ "opt_namespace_decl ::= namespace_decl",
 /*   7 */ "namespace_decl ::= NAMESPACE ID SEMICOL",
 /*   8 */ "toplevel_decls ::= toplevel_decl",
 /*   9 */ "toplevel_decls ::= toplevel_decls toplevel_decl",
 /*  10 */ "toplevel_decl ::= error_decl",
 /*  11 */ "toplevel_decl ::= struct_decl",
 /*  12 */ "toplevel_decl ::= servlet_decl",
 /*  13 */ "error_decl ::= ERROR ID EQ INTEGER SEMICOL",
 /*  14 */ "struct_decl ::= opt_doc_comment STRUCT ID LB struct_members RB",
 /*  15 */ "struct_members ::= struct_member",
 /*  16 */ "struct_members ::= struct_members struct_member",
 /*  17 */ "struct_member ::= type ID SEMICOL",
 /*  18 */ "servlet_decl ::= servlet_decl_head servlet_decl_body",
 /*  19 */ "servlet_decl_head ::= opt_doc_comment SERVLET ID",
 /*  20 */ "servlet_decl_body ::= LB opt_inline_code servlet_body_decls RB",
 /*  21 */ "servlet_body_decls ::= servlet_body_decl",
 /*  22 */ "servlet_body_decls ::= servlet_body_decls servlet_body_decl",
 /*  23 */ "servlet_body_decl ::= struct_decl",
 /*  24 */ "servlet_body_decl ::= method_decl CODE",
 /*  25 */ "servlet_body_decl ::= method_decl SEMICOL",
 /*  26 */ "servlet_body_decl ::= INIT CODE",
 /*  27 */ "servlet_body_decl ::= FINI CODE",
 /*  28 */ "servlet_body_decl ::= ATTRS CODE",
 /*  29 */ "servlet_body_decl ::= PRECALL CODE",
 /*  30 */ "servlet_body_decl ::= POSTCALL CODE",
 /*  31 */ "servlet_body_decl ::= FALLBACK CODE",
 /*  32 */ "servlet_body_decl ::= DOWNLOAD CODE",
 /*  33 */ "servlet_body_decl ::= UPLOAD CODE",
 /*  34 */ "servlet_body_decl ::= error_decl",
 /*  35 */ "type ::= ARRAY LT type GT",
 /*  36 */ "type ::= ID",
 /*  37 */ "method_decl ::= opt_doc_comment type ID LP params RP",
 /*  38 */ "params ::=",
 /*  39 */ "params ::= param",
 /*  40 */ "params ::= params COMMA param",
 /*  41 */ "opt_owner ::=",
 /*  42 */ "opt_owner ::= TAKE",
 /*  43 */ "param ::= opt_owner type ID",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to xdlParser and xdlParserFree.
*/
void *xdlParserAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#if YYSTACKDEPTH<=0
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(YYCODETYPE yymajor, YYMINORTYPE *yypminor){
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are not used
    ** inside the C code.
    */
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
#line 26 "tmp.y"
{token_free((yypminor->yy0));}
#line 1141 "tmp.c"
      break;
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor( yymajor, &yytos->minor);
  pParser->yyidx--;
  return yymajor;
}

/* 
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from xdlParserAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void xdlParserFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
 
  if( stateno>YY_SHIFT_MAX || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      int iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( j>=0 && j<YY_SZ_ACTTAB && yy_lookahead[j]==YYWILDCARD ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  /* int stateno = pParser->yystack[pParser->yyidx].stateno; */
 
  if( stateno>YY_REDUCE_MAX ||
      (i = yy_reduce_ofst[stateno])==YY_REDUCE_USE_DFLT ){
    return yy_default[stateno];
  }
  if( iLookAhead==YYNOCODE ){
    return YY_NO_ACTION;
  }
  i += iLookAhead;
  if( i<0 || i>=YY_SZ_ACTTAB || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   xdlParserARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
#line 29 "tmp.y"
HANDLE_STACK_OVERFLOW();
#line 1303 "tmp.c"
   xdlParserARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer ot the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#if YYSTACKDEPTH>0 
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor = *yypMinor;
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 29, 2 },
  { 32, 0 },
  { 32, 1 },
  { 33, 0 },
  { 33, 1 },
  { 30, 0 },
  { 30, 1 },
  { 34, 3 },
  { 31, 1 },
  { 31, 2 },
  { 35, 1 },
  { 35, 1 },
  { 35, 1 },
  { 36, 5 },
  { 37, 6 },
  { 39, 1 },
  { 39, 2 },
  { 40, 3 },
  { 38, 2 },
  { 42, 3 },
  { 43, 4 },
  { 44, 1 },
  { 44, 2 },
  { 45, 1 },
  { 45, 2 },
  { 45, 2 },
  { 45, 2 },
  { 45, 2 },
  { 45, 2 },
  { 45, 2 },
  { 45, 2 },
  { 45, 2 },
  { 45, 2 },
  { 45, 2 },
  { 45, 1 },
  { 41, 4 },
  { 41, 1 },
  { 46, 6 },
  { 47, 0 },
  { 47, 1 },
  { 47, 3 },
  { 49, 0 },
  { 49, 1 },
  { 48, 3 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  xdlParserARG_FETCH;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0 
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.  
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  memset(&yygotominor, 0, sizeof(yygotominor));


  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
      case 0:
      case 5:
      case 6:
      case 8:
      case 9:
      case 10:
      case 12:
      case 18:
      case 21:
      case 22:
      case 34:
#line 736 "tmp.y"
{
}
#line 1466 "tmp.c"
        break;
      case 1:
#line 739 "tmp.y"
{
  yygotominor.yy96 = NULL;
}
#line 1473 "tmp.c"
        break;
      case 2:
#line 742 "tmp.y"
{
  yygotominor.yy96 = yymsp[0].minor.yy0;
}
#line 1480 "tmp.c"
        break;
      case 3:
#line 747 "tmp.y"
{
  yygotominor.yy85 = NULL;
}
#line 1487 "tmp.c"
        break;
      case 4:
#line 750 "tmp.y"
{
  yygotominor.yy85 = yymsp[0].minor.yy0->text;
  yymsp[0].minor.yy0->text = NULL;
  token_free(yymsp[0].minor.yy0);
}
#line 1496 "tmp.c"
        break;
      case 7:
#line 759 "tmp.y"
{
  if (!MODEL)
    _MODEL = xdl_new();
  MODEL->name = g_strdup(yymsp[-1].minor.yy0->text);
  token_free(yymsp[-1].minor.yy0);
  yy_destructor(3,&yymsp[-2].minor);
  yy_destructor(5,&yymsp[0].minor);
}
#line 1508 "tmp.c"
        break;
      case 11:
#line 770 "tmp.y"
{
  MODEL->types = g_slist_append(MODEL->types, yymsp[0].minor.yy87);
}
#line 1515 "tmp.c"
        break;
      case 13:
#line 775 "tmp.y"
{
  if (!MODEL)
    _MODEL = xdl_new();
  xdl_error_new(MODEL, MODEL->cur_servlet, yymsp[-3].minor.yy0->text, atoi(yymsp[-1].minor.yy0->text));
  token_free(yymsp[-3].minor.yy0);
  token_free(yymsp[-1].minor.yy0);
  yy_destructor(6,&yymsp[-4].minor);
  yy_destructor(7,&yymsp[-2].minor);
  yy_destructor(5,&yymsp[0].minor);
}
#line 1529 "tmp.c"
        break;
      case 14:
#line 784 "tmp.y"
{
  if (!MODEL)
    _MODEL = xdl_new();
  if (xdl_typedef_find(MODEL, MODEL->cur_servlet, yymsp[-3].minor.yy0->text))
  {
    printf("Redefining already defined type %s\n", yymsp[-3].minor.yy0->text);
    exit(1);
  }
  yygotominor.yy87 = xdl_typedef_new_struct(MODEL, MODEL->cur_servlet, yymsp[-3].minor.yy0->text);
  yygotominor.yy87->struct_members = yymsp[-1].minor.yy93;
  yygotominor.yy87->doc = yymsp[-5].minor.yy85;
  token_free(yymsp[-3].minor.yy0);
  yy_destructor(9,&yymsp[-4].minor);
  yy_destructor(10,&yymsp[-2].minor);
  yy_destructor(11,&yymsp[0].minor);
}
#line 1549 "tmp.c"
        break;
      case 15:
#line 799 "tmp.y"
{
  yygotominor.yy93 = g_slist_append(NULL, yymsp[0].minor.yy30);
}
#line 1556 "tmp.c"
        break;
      case 16:
#line 802 "tmp.y"
{
  yygotominor.yy93 = g_slist_append(yymsp[-1].minor.yy93, yymsp[0].minor.yy30);
}
#line 1563 "tmp.c"
        break;
      case 17:
#line 807 "tmp.y"
{
  yygotominor.yy30 = g_new0(xdl_struct_member, 1);
  yygotominor.yy30->type = yymsp[-2].minor.yy87;
  yygotominor.yy30->name = g_strdup(yymsp[-1].minor.yy0->text);
  token_free(yymsp[-1].minor.yy0);
  yy_destructor(5,&yymsp[0].minor);
}
#line 1574 "tmp.c"
        break;
      case 19:
#line 815 "tmp.y"
{
  if (!MODEL)
    _MODEL = xdl_new();
  MODEL->cur_servlet = g_new0(xdl_servlet, 1);
  MODEL->servlets = g_slist_append(MODEL->servlets, MODEL->cur_servlet);
  MODEL->cur_servlet->name = g_strdup(yymsp[0].minor.yy0->text);
  MODEL->cur_servlet->doc = yymsp[-2].minor.yy85;
  token_free(yymsp[0].minor.yy0);
  yy_destructor(12,&yymsp[-1].minor);
}
#line 1588 "tmp.c"
        break;
      case 20:
#line 824 "tmp.y"
{
  if (yymsp[-2].minor.yy96)
  {
    MODEL->cur_servlet->stub_header = g_strndup(yymsp[-2].minor.yy96->text+2, strlen(yymsp[-2].minor.yy96->text)-4);
    MODEL->cur_servlet->stub_header_line = yymsp[-2].minor.yy96->sline;
    token_free(yymsp[-2].minor.yy96);
  }
  MODEL->cur_servlet = NULL;
  yy_destructor(10,&yymsp[-3].minor);
  yy_destructor(11,&yymsp[0].minor);
}
#line 1603 "tmp.c"
        break;
      case 23:
#line 837 "tmp.y"
{
  MODEL->cur_servlet->types = g_slist_append(MODEL->cur_servlet->types, yymsp[0].minor.yy87);
}
#line 1610 "tmp.c"
        break;
      case 24:
#line 840 "tmp.y"
{
  MODEL->cur_servlet->methods = g_slist_append(MODEL->cur_servlet->methods, yymsp[-1].minor.yy95);
  yymsp[-1].minor.yy95->stub_impl = g_strndup(yymsp[0].minor.yy0->text+2, strlen(yymsp[0].minor.yy0->text)-4);
  yymsp[-1].minor.yy95->stub_impl_line = yymsp[0].minor.yy0->sline;
  token_free(yymsp[0].minor.yy0);
}
#line 1620 "tmp.c"
        break;
      case 25:
#line 846 "tmp.y"
{
  MODEL->cur_servlet->methods = g_slist_append(MODEL->cur_servlet->methods, yymsp[-1].minor.yy95);
  yy_destructor(5,&yymsp[0].minor);
}
#line 1628 "tmp.c"
        break;
      case 26:
#line 849 "tmp.y"
{
  MODEL->cur_servlet->stub_init = g_strndup(yymsp[0].minor.yy0->text+2, strlen(yymsp[0].minor.yy0->text)-4);
  MODEL->cur_servlet->stub_init_line = yymsp[0].minor.yy0->sline;
  token_free(yymsp[0].minor.yy0);
  yy_destructor(13,&yymsp[-1].minor);
}
#line 1638 "tmp.c"
        break;
      case 27:
#line 854 "tmp.y"
{
  MODEL->cur_servlet->stub_fini = g_strndup(yymsp[0].minor.yy0->text+2, strlen(yymsp[0].minor.yy0->text)-4);
  MODEL->cur_servlet->stub_fini_line = yymsp[0].minor.yy0->sline;
  token_free(yymsp[0].minor.yy0);
  yy_destructor(14,&yymsp[-1].minor);
}
#line 1648 "tmp.c"
        break;
      case 28:
#line 859 "tmp.y"
{
  MODEL->cur_servlet->stub_attrs = g_strndup(yymsp[0].minor.yy0->text+2, strlen(yymsp[0].minor.yy0->text)-4);
  MODEL->cur_servlet->stub_attrs_line = yymsp[0].minor.yy0->sline;
  token_free(yymsp[0].minor.yy0);
  yy_destructor(15,&yymsp[-1].minor);
}
#line 1658 "tmp.c"
        break;
      case 29:
#line 864 "tmp.y"
{
  MODEL->cur_servlet->stub_pre_call = g_strndup(yymsp[0].minor.yy0->text+2, strlen(yymsp[0].minor.yy0->text)-4);
  MODEL->cur_servlet->stub_pre_call_line = yymsp[0].minor.yy0->sline;
  token_free(yymsp[0].minor.yy0);
  yy_destructor(16,&yymsp[-1].minor);
}
#line 1668 "tmp.c"
        break;
      case 30:
#line 869 "tmp.y"
{
  MODEL->cur_servlet->stub_post_call = g_strndup(yymsp[0].minor.yy0->text+2, strlen(yymsp[0].minor.yy0->text)-4);
  MODEL->cur_servlet->stub_post_call_line = yymsp[0].minor.yy0->sline;
  token_free(yymsp[0].minor.yy0);
  yy_destructor(17,&yymsp[-1].minor);
}
#line 1678 "tmp.c"
        break;
      case 31:
#line 874 "tmp.y"
{
  MODEL->cur_servlet->stub_fallback = g_strndup(yymsp[0].minor.yy0->text+2, strlen(yymsp[0].minor.yy0->text)-4);
  MODEL->cur_servlet->stub_fallback_line = yymsp[0].minor.yy0->sline;
  token_free(yymsp[0].minor.yy0);
  yy_destructor(18,&yymsp[-1].minor);
}
#line 1688 "tmp.c"
        break;
      case 32:
#line 879 "tmp.y"
{
  MODEL->cur_servlet->stub_download = g_strndup(yymsp[0].minor.yy0->text+2, strlen(yymsp[0].minor.yy0->text)-4);
  MODEL->cur_servlet->stub_download_line = yymsp[0].minor.yy0->sline;
  token_free(yymsp[0].minor.yy0);
  yy_destructor(19,&yymsp[-1].minor);
}
#line 1698 "tmp.c"
        break;
      case 33:
#line 884 "tmp.y"
{
  MODEL->cur_servlet->stub_upload = g_strndup(yymsp[0].minor.yy0->text+2, strlen(yymsp[0].minor.yy0->text)-4);
  MODEL->cur_servlet->stub_upload_line = yymsp[0].minor.yy0->sline;
  token_free(yymsp[0].minor.yy0);
  yy_destructor(20,&yymsp[-1].minor);
}
#line 1708 "tmp.c"
        break;
      case 35:
#line 892 "tmp.y"
{
  if (!MODEL)
    _MODEL = xdl_new();
  yygotominor.yy87 = xdl_typedef_new_array(MODEL, MODEL->cur_servlet, yymsp[-1].minor.yy87);
  yy_destructor(21,&yymsp[-3].minor);
  yy_destructor(22,&yymsp[-2].minor);
  yy_destructor(23,&yymsp[0].minor);
}
#line 1720 "tmp.c"
        break;
      case 36:
#line 897 "tmp.y"
{
  if (!MODEL)
    _MODEL = xdl_new();
  yygotominor.yy87 = xdl_typedef_find(MODEL, MODEL->cur_servlet, yymsp[0].minor.yy0->text);
  if (yygotominor.yy87 == NULL)
  {
    printf("Undefined type %s\n", yymsp[0].minor.yy0->text);
    exit(1);
  }
  token_free(yymsp[0].minor.yy0);
}
#line 1735 "tmp.c"
        break;
      case 37:
#line 910 "tmp.y"
{
  yygotominor.yy95 = g_new0(xdl_method, 1);
  yygotominor.yy95->name = g_strdup(yymsp[-3].minor.yy0->text);
  yygotominor.yy95->return_type = yymsp[-4].minor.yy87;
  yygotominor.yy95->params = yymsp[-1].minor.yy93;
  yygotominor.yy95->doc = yymsp[-5].minor.yy85;
  token_free(yymsp[-3].minor.yy0);
  yy_destructor(24,&yymsp[-2].minor);
  yy_destructor(25,&yymsp[0].minor);
}
#line 1749 "tmp.c"
        break;
      case 38:
#line 920 "tmp.y"
{
  yygotominor.yy93 = NULL;
}
#line 1756 "tmp.c"
        break;
      case 39:
#line 923 "tmp.y"
{
  yygotominor.yy93 = g_slist_append(NULL, yymsp[0].minor.yy75);
}
#line 1763 "tmp.c"
        break;
      case 40:
#line 926 "tmp.y"
{
  yygotominor.yy93 = g_slist_append(yymsp[-2].minor.yy93, yymsp[0].minor.yy75);
  yy_destructor(26,&yymsp[-1].minor);
}
#line 1771 "tmp.c"
        break;
      case 41:
#line 931 "tmp.y"
{
  yygotominor.yy92 = 0;
}
#line 1778 "tmp.c"
        break;
      case 42:
#line 934 "tmp.y"
{
  yygotominor.yy92 = 1;
  yy_destructor(27,&yymsp[0].minor);
}
#line 1786 "tmp.c"
        break;
      case 43:
#line 939 "tmp.y"
{
  yygotominor.yy75 = g_new0(xdl_method_param, 1);
  yygotominor.yy75->type = yymsp[-1].minor.yy87;
  yygotominor.yy75->pass_ownership = yymsp[-2].minor.yy92;
  yygotominor.yy75->name = g_strdup(yymsp[0].minor.yy0->text);
  token_free(yymsp[0].minor.yy0);
}
#line 1797 "tmp.c"
        break;
  };
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = yyact;
      yymsp->major = yygoto;
      yymsp->minor = yygotominor;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
    }
  }else if( yyact == YYNSTATE + YYNRULE + 1 ){
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  xdlParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  xdlParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  xdlParserARG_FETCH;
#define TOKEN (yyminor.yy0)
#line 28 "tmp.y"
HANDLE_SYNTAX_ERROR(TOKEN);
#line 1857 "tmp.c"
  xdlParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  xdlParserARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  xdlParserARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "xdlParserAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void xdlParser(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  xdlParserTOKENTYPE yyminor       /* The value for the token */
  xdlParserARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
  int yyendofinput;     /* True if we are at the end of input */
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      memset(&yyminorunion, 0, sizeof(yyminorunion));
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
  }
  yyminorunion.yy0 = yyminor;
  yyendofinput = (yymajor==0);
  xdlParserARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s\n",yyTracePrompt,yyTokenName[yymajor]);
  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      if( yyendofinput && yypParser->yyidx>=0 ){
        yymajor = 0;
      }else{
        yymajor = YYNOCODE;
      }
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else if( yyact == YY_ERROR_ACTION ){
      int yymx;
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }else{
      yy_accept(yypParser);
      yymajor = YYNOCODE;
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
