/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.core.output2;

import java.awt.event.ActionEvent;
import org.openide.DialogDescriptor;
import org.openide.util.NbBundle;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionListener;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Vector;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbPreferences;

class FindDialogPanel extends javax.swing.JPanel {

    static final long serialVersionUID =5048678953767663114L;
    private static final String KEY_REGEXP = "regExp"; // NOI18N
    private static final String KEY_MATCHCASE = "matchCase"; // NOI18N

    private static Reference<FindDialogPanel> panel = null;
    private JButton acceptButton;
    private static Vector<Object> history = new Vector<Object>();
    
    /** Initializes the Form */
    FindDialogPanel() {
        regExp = NbPreferences.forModule(Controller.class).getBoolean(KEY_REGEXP, false);
        matchCase = NbPreferences.forModule(Controller.class).getBoolean(KEY_MATCHCASE, false);
        initComponents();
        acceptButton = new JButton();
        Mnemonics.setLocalizedText(chbRegExp, NbBundle.getMessage(FindDialogPanel.class, "LBL_Use_RegExp"));
        Mnemonics.setLocalizedText(chbMatchCase, NbBundle.getMessage(FindDialogPanel.class, "LBL_Match_Case"));

        getAccessibleContext().setAccessibleName(NbBundle.getMessage(FindDialogPanel.class, "ACSN_Find"));
        getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FindDialogPanel.class, "ACSD_Find"));
        findWhat.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FindDialogPanel.class, "ACSD_Find_What"));
        acceptButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FindDialogPanel.class, "ACSD_FindBTN"));

        findWhat.setModel(new DefaultComboBoxModel(history));
        findWhat.getEditor().addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                acceptButton.doClick();
            }
        });
        findWhatLabel.setFocusable(false);
    }

    public static FindDialogPanel getPanel() {
        FindDialogPanel result = null;
        if (panel != null) {
            result = panel.get();
        }
        if (result == null) {
            result = new FindDialogPanel();
            panel = new SoftReference<FindDialogPanel> (result);
        }
        return result;
    }
    
    void setFindText(String text) {
        int end = text.indexOf("\n");
        String txt = text;
        if (end  > -1) {
            txt = text.substring(0, end);
        }
        if (!txt.equals(findWhat.getSelectedItem())) {
            findWhat.insertItemAt(txt, 0);
            findWhat.setSelectedIndex(0);
        }
        selectText();
    }
    
    private void selectText() {
        Component comp = findWhat.getEditor().getEditorComponent();
        if (comp instanceof JTextField) {
            JTextField fld = (JTextField)comp;
            fld.setSelectionStart(0);
            fld.setSelectionEnd(fld.getText().length());
        }
    }
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        findWhatLabel = new javax.swing.JLabel();
        findWhat = new javax.swing.JComboBox();
        chbRegExp = new javax.swing.JCheckBox();
        chbMatchCase = new javax.swing.JCheckBox();

        setLayout(new java.awt.GridBagLayout());

        findWhatLabel.setLabelFor(findWhat);
        findWhatLabel.setText(org.openide.util.NbBundle.getMessage(FindDialogPanel.class, "LBL_Find_What")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 12, 5, 5);
        add(findWhatLabel, gridBagConstraints);

        findWhat.setEditable(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.ipadx = 50;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(5, 12, 5, 5);
        add(findWhat, gridBagConstraints);

        chbRegExp.setSelected(regExp());
        chbRegExp.setText(org.openide.util.NbBundle.getMessage(FindDialogPanel.class, "LBL_Use_RegExp")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 12, 5, 5);
        add(chbRegExp, gridBagConstraints);

        chbMatchCase.setSelected(matchCase());
        chbMatchCase.setText(org.openide.util.NbBundle.getMessage(FindDialogPanel.class, "LBL_Match_Case")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 12, 5, 5);
        add(chbMatchCase, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox chbMatchCase;
    private javax.swing.JCheckBox chbRegExp;
    protected javax.swing.JComboBox findWhat;
    protected javax.swing.JLabel findWhatLabel;
    // End of variables declaration//GEN-END:variables


    private String getPattern() {
        return (String) findWhat.getSelectedItem();
    }

    private void updateHistory() {
        Object pattern = findWhat.getEditor().getItem();

        history.add( 0, pattern );
        for ( int i = history.size() - 1; i > 0; i-- ) {
            if ( history.get( i ).equals( pattern ) ) {
                history.remove( i );
                break;
            }
        }
    }

    private static String result;
    private static boolean regExp;
    private static boolean matchCase;

    static String getResult(String selection, String dlgTitle, String comboLabel, String buttonText) {
        final FindDialogPanel findPanel = getPanel();
        Mnemonics.setLocalizedText(findPanel.acceptButton, NbBundle.getMessage(FindDialogPanel.class, buttonText));
        Mnemonics.setLocalizedText(findPanel.findWhatLabel, NbBundle.getMessage(FindDialogPanel.class, comboLabel));
        if (selection != null) {
            findPanel.setFindText(selection);
        }
        findPanel.selectText();

        DialogDescriptor dd = new DialogDescriptor(findPanel, NbBundle.getMessage(FindDialogPanel.class, dlgTitle),
                true, new Object[] {findPanel.acceptButton, DialogDescriptor.CANCEL_OPTION}, findPanel.acceptButton,
                DialogDescriptor.RIGHT_ALIGN, null, null);
        Object res = DialogDisplayer.getDefault().notify(dd);
        if (res.equals(findPanel.acceptButton)) {
            findPanel.updateHistory();
            regExp = findPanel.chbRegExp.getModel().isSelected();
            matchCase  = findPanel.chbMatchCase.getModel().isSelected();
            NbPreferences.forModule(FindDialogPanel.class).putBoolean(KEY_REGEXP, regExp);
            NbPreferences.forModule(FindDialogPanel.class).putBoolean(KEY_MATCHCASE, matchCase);
            result = findPanel.getPattern();
            return result;
        } else {
            result = null;
            return null;
        }
    }

    static String result() {
        return result;
    }

    static boolean regExp() {
        return regExp;
    }

    static boolean matchCase() {
        return matchCase;
    }
}
