#if !defined (__ITERATOREXCEPTION_HPP)
#define __ITERATOREXCEPTION_HPP

/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

namespace corelinux
{


   DECLARE_CLASS( IteratorException );

   /**
   IteratorException is the base exception type for Iterator. All
   Iterator exceptions derive from this.
   */

   class IteratorException : public Exception
   {
   
   public:
   
                        /**
                        Default Constructor
                        @param file The source module throwing the exception
                        @param line The line of source throwing the exception
                        @param severity The Exception::Severity of the Exception
                        @param outOfMemory An out of memory indicator
                        */

                        IteratorException
                        (
                           CharCptr file,
                           LineNum  line,
                           Severity severity = Exception::CONTINUABLE,
                           bool     outOfMemory = false 
                        );
   
                        /**
                        Copy constructor
                        @param IteratorException const reference
                        */
                     
                        IteratorException( IteratorExceptionCref );
   
                        /// Virtual Destructor
   
      virtual           ~IteratorException( void );
   
         //
         // Operator overloads
         //
   
               /**
               Assignment operator overload
               @param  IteratorException const reference
               @return IteratorException reference to self
               */
            
               IteratorExceptionRef   operator=( IteratorExceptionCref );
            
               /**
               Equality operator overload
               @param IteratorException const reference
               @return true if equal, false otherwise
               */

               bool           operator==( IteratorExceptionCref ) const;
            
         //
         // Accessor methods
         //
   
            
         //
         // Mutator methods
         //
   
   
   protected:

                        /**
                        Default Constructor
                        @param why describes why the exception was thrown
                        @param file The source module throwing the exception
                        @param line The line of source throwing the exception
                        @param severity The Exception::Severity of the Exception
                        @param outOfMemory An out of memory indicator
                        */

                        IteratorException
                        (
                           CharCptr why,
                           CharCptr file,
                           LineNum  line,
                           Severity severity = Exception::CONTINUABLE,
                           bool     outOfMemory = false 
                        );
                           /**
                           IteratorException must have at least
                           a location..
                           Default constructor is not allowed.
                           */   
                     
                           IteratorException( void );
   
   
   private:
   
   private:
   
   };

}


#endif  // !defined __ITERATOREXCEPTION_HPP

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.1 $
   $Date: 2000/04/23 20:43:13 $
   $Locker:  $
*/


